/*
 * Decompiled with CFR 0.152.
 */
package io.raven.vertx.ranger;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceFinderBuilders;
import com.flipkart.ranger.finder.sharded.SimpleShardedServiceFinder;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.model.ShardSelector;
import io.raven.vertx.ranger.HierarchicalEnvironmentAwareShardSelector;
import io.raven.vertx.ranger.common.ShardInfo;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryClient.class);
    private final ShardInfo criteria;
    private SimpleShardedServiceFinder<ShardInfo> serviceFinder;

    private ServiceDiscoveryClient(String namespace, String serviceName, String environment, ObjectMapper objectMapper, String connectionString, int refreshTimeMs, boolean disableWatchers) {
        this(namespace, serviceName, environment, objectMapper, CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)new RetryForever(5000)), refreshTimeMs, disableWatchers);
    }

    ServiceDiscoveryClient(String namespace, String serviceName, String environment, ObjectMapper objectMapper, CuratorFramework curator, int refreshTimeMs, boolean disableWatchers) {
        int effectiveRefreshTimeMs = refreshTimeMs;
        if (effectiveRefreshTimeMs < 5000) {
            effectiveRefreshTimeMs = 5000;
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)refreshTimeMs, (Object)5000);
        }
        this.criteria = ShardInfo.builder().environment(environment).build();
        this.serviceFinder = (SimpleShardedServiceFinder)ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(curator).withNamespace(namespace).withServiceName(serviceName).withDeserializer(data -> {
            try {
                return (ServiceNode)objectMapper.readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withNodeRefreshIntervalMs(effectiveRefreshTimeMs).withDisableWatchers(disableWatchers).withShardSelector((ShardSelector)new HierarchicalEnvironmentAwareShardSelector()).build();
    }

    public CompletableFuture<Void> start() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.serviceFinder.start();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public CompletableFuture<Void> stop() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.serviceFinder.stop();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public CompletableFuture<Optional<ServiceNode<ShardInfo>>> getNode() {
        return this.getNode(this.criteria);
    }

    public CompletableFuture<List<ServiceNode<ShardInfo>>> getAllNodes() {
        return this.getAllNodes(this.criteria);
    }

    public CompletableFuture<Optional<ServiceNode<ShardInfo>>> getNode(ShardInfo shardInfo) {
        CompletableFuture<Optional<ServiceNode<ShardInfo>>> result = new CompletableFuture<Optional<ServiceNode<ShardInfo>>>();
        result.complete(Optional.ofNullable(this.serviceFinder.get((Object)shardInfo)));
        return result;
    }

    public CompletableFuture<List<ServiceNode<ShardInfo>>> getAllNodes(ShardInfo shardInfo) {
        CompletableFuture<List<ServiceNode<ShardInfo>>> result = new CompletableFuture<List<ServiceNode<ShardInfo>>>();
        result.complete(this.serviceFinder.getAll((Object)shardInfo));
        return result;
    }

    public static FromConnectionStringBuilder fromConnectionString() {
        return new FromConnectionStringBuilder();
    }

    public static FromCuratorBuilder fromCurator() {
        return new FromCuratorBuilder();
    }

    public static class FromCuratorBuilder {
        private String namespace;
        private String serviceName;
        private String environment;
        private ObjectMapper objectMapper;
        private CuratorFramework curator;
        private int refreshTimeMs;
        private boolean disableWatchers;

        FromCuratorBuilder() {
        }

        public FromCuratorBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FromCuratorBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public FromCuratorBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public FromCuratorBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public FromCuratorBuilder curator(CuratorFramework curator) {
            this.curator = curator;
            return this;
        }

        public FromCuratorBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        public FromCuratorBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.namespace, this.serviceName, this.environment, this.objectMapper, this.curator, this.refreshTimeMs, this.disableWatchers);
        }

        public String toString() {
            return "ServiceDiscoveryClient.FromCuratorBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", objectMapper=" + this.objectMapper + ", curator=" + this.curator + ", refreshTimeMs=" + this.refreshTimeMs + ", disableWatchers=" + this.disableWatchers + ")";
        }
    }

    public static class FromConnectionStringBuilder {
        private String namespace;
        private String serviceName;
        private String environment;
        private ObjectMapper objectMapper;
        private String connectionString;
        private int refreshTimeMs;
        private boolean disableWatchers;

        FromConnectionStringBuilder() {
        }

        public FromConnectionStringBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FromConnectionStringBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public FromConnectionStringBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public FromConnectionStringBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public FromConnectionStringBuilder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public FromConnectionStringBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        public FromConnectionStringBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.namespace, this.serviceName, this.environment, this.objectMapper, this.connectionString, this.refreshTimeMs, this.disableWatchers);
        }

        public String toString() {
            return "ServiceDiscoveryClient.FromConnectionStringBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", objectMapper=" + this.objectMapper + ", connectionString=" + this.connectionString + ", refreshTimeMs=" + this.refreshTimeMs + ", disableWatchers=" + this.disableWatchers + ")";
        }
    }
}

