/*
 * Decompiled with CFR 0.152.
 */
package io.raven.vertx.ranger;

import com.flipkart.ranger.ServiceProviderBuilders;
import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.serviceprovider.ServiceProvider;
import com.flipkart.ranger.serviceprovider.ServiceProviderBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.raven.vertx.ranger.ServiceDiscoveryClient;
import io.raven.vertx.ranger.common.RotationStatus;
import io.raven.vertx.ranger.common.ShardInfo;
import io.raven.vertx.ranger.handlers.BIRHandler;
import io.raven.vertx.ranger.handlers.InfoHandler;
import io.raven.vertx.ranger.handlers.OORHandler;
import io.raven.vertx.ranger.healthchecks.InitialDelayChecker;
import io.raven.vertx.ranger.healthchecks.InternalHealthChecker;
import io.raven.vertx.ranger.healthchecks.RotationCheck;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.Router;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceDiscoveryPublisher {
    private static final Logger log = LogManager.getLogger(ServiceDiscoveryPublisher.class);
    private JsonObject config;
    private Router router;
    private List<Healthcheck> healthchecks = Lists.newArrayList();
    private ServiceProvider<ShardInfo> serviceProvider;
    private ServiceDiscoveryClient serviceDiscoveryClient;
    private CuratorFramework curator;
    private RotationStatus rotationStatus;

    public ServiceDiscoveryPublisher(JsonObject config, Router router) {
        this.config = config;
        this.router = router;
    }

    public void start() throws Exception {
        String namespace = this.config.getString("namespace");
        String serviceName = this.config.getString("serviceName");
        String hostname = this.getHost();
        int port = this.getPort();
        this.rotationStatus = new RotationStatus(this.config.getBoolean("inRotationStatus", Boolean.valueOf(true)));
        this.curator = CuratorFrameworkFactory.builder().connectString(this.config.getString("zkUrl")).namespace(namespace).retryPolicy((RetryPolicy)new RetryForever(this.config.getInteger("connectionRetryMillis", Integer.valueOf(5000)).intValue())).build();
        this.curator.start();
        this.serviceProvider = this.buildServiceProvider(namespace, serviceName, hostname, port);
        this.serviceProvider.start();
        this.serviceDiscoveryClient = this.buildDiscoveryClient(namespace, serviceName);
        this.serviceDiscoveryClient.start();
        this.router.get("/instances").handler((Handler)InfoHandler.builder().serviceDiscoveryClient(this.serviceDiscoveryClient).build());
        this.router.post("/tasks/ranger-oor").handler((Handler)OORHandler.builder().rotationStatus(this.rotationStatus).build());
        this.router.post("/tasks/ranger-bir").handler((Handler)BIRHandler.builder().rotationStatus(this.rotationStatus).build());
    }

    protected int getPort() {
        Preconditions.checkArgument((-1 != this.config.getInteger("publishedPort", Integer.valueOf(-1)) && 0 != this.config.getInteger("publishedPort", Integer.valueOf(-1)) ? 1 : 0) != 0, (Object)"Looks like publishedPost has not been set and getPort() has not been overridden. This is wrong. \nEither set publishedPort in config or override getPort() to return the port on which the service is running");
        return this.config.getInteger("publishedPort", Integer.valueOf(-1));
    }

    protected String getHost() throws UnknownHostException {
        String host = this.config.getString("publishedHost", "__DEFAULT_SERVICE_HOST");
        if (Strings.isNullOrEmpty((String)host) || host.equals("__DEFAULT_SERVICE_HOST")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        return host;
    }

    public void registerHealthcheck(Healthcheck healthcheck) {
        this.healthchecks.add(healthcheck);
    }

    public ServiceDiscoveryClient buildDiscoveryClient(String namespace, String serviceName) {
        return ServiceDiscoveryClient.fromCurator().curator(this.curator).namespace(namespace).serviceName(serviceName).environment(this.config.getString("environment", "stage")).objectMapper(DatabindCodec.mapper()).refreshTimeMs(this.config.getInteger("refreshTimeMs", Integer.valueOf(5000))).disableWatchers(this.config.getBoolean("disableWatchers", Boolean.valueOf(true))).build();
    }

    private ServiceProvider<ShardInfo> buildServiceProvider(String namespace, String serviceName, String hostname, int port) {
        ShardInfo nodeInfo = ShardInfo.builder().environment(this.config.getString("environment", "stage")).build();
        int dwMonitoringInterval = this.config.getInteger("checkInterval", Integer.valueOf(15)) == 0 ? 15 : this.config.getInteger("checkInterval", Integer.valueOf(15));
        ServiceProviderBuilder serviceProviderBuilder = ServiceProviderBuilders.shardedServiceProviderBuilder().withCuratorFramework(this.curator).withNamespace(namespace).withServiceName(serviceName).withHealthUpdateIntervalMs(dwMonitoringInterval * 1000).withSerializer(data -> {
            try {
                return DatabindCodec.mapper().writeValueAsBytes((Object)data);
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withHostname(hostname).withPort(port).withNodeData((Object)nodeInfo).withHealthcheck((Healthcheck)new InternalHealthChecker(this.healthchecks)).withHealthcheck((Healthcheck)new RotationCheck(this.rotationStatus)).withHealthcheck((Healthcheck)new InitialDelayChecker(this.config.getInteger("initialDelayChecker", Integer.valueOf(30)).intValue())).withHealthUpdateIntervalMs(this.config.getInteger("refreshTimeMs", Integer.valueOf(15000)).intValue()).withStaleUpdateThresholdMs(10000);
        return serviceProviderBuilder.buildServiceDiscovery();
    }

    public static ServiceDiscoveryPublisherBuilder builder() {
        return new ServiceDiscoveryPublisherBuilder();
    }

    public static class ServiceDiscoveryPublisherBuilder {
        private JsonObject config;
        private Router router;

        ServiceDiscoveryPublisherBuilder() {
        }

        public ServiceDiscoveryPublisherBuilder config(JsonObject config) {
            this.config = config;
            return this;
        }

        public ServiceDiscoveryPublisherBuilder router(Router router) {
            this.router = router;
            return this;
        }

        public ServiceDiscoveryPublisher build() {
            return new ServiceDiscoveryPublisher(this.config, this.router);
        }

        public String toString() {
            return "ServiceDiscoveryPublisher.ServiceDiscoveryPublisherBuilder(config=" + this.config + ", router=" + this.router + ")";
        }
    }
}

