/*
 * Decompiled with CFR 0.152.
 */
package io.raven.vertx.ranger;

import com.flipkart.ranger.finder.sharded.MapBasedServiceRegistry;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.model.ShardSelector;
import com.google.common.collect.ListMultimap;
import io.raven.vertx.ranger.common.ShardInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalEnvironmentAwareShardSelector
implements ShardSelector<ShardInfo, MapBasedServiceRegistry<ShardInfo>> {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalEnvironmentAwareShardSelector.class);

    public List<ServiceNode<ShardInfo>> nodes(ShardInfo criteria, MapBasedServiceRegistry<ShardInfo> serviceRegistry) {
        ListMultimap serviceNodes = serviceRegistry.nodes();
        String serviceName = serviceRegistry.getService().getServiceName();
        String environment = criteria.getEnvironment();
        if (Objects.equals(environment, "*")) {
            return this.allNodes((ListMultimap<ShardInfo, ServiceNode<ShardInfo>>)serviceNodes);
        }
        for (ShardInfo shardInfo : criteria) {
            List currentEnvNodes = serviceNodes.get((Object)shardInfo);
            if (currentEnvNodes.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Effective environment for discovery of {} is {}", (Object)serviceName, (Object)environment);
            }
            return currentEnvNodes;
        }
        return Collections.emptyList();
    }

    private List<ServiceNode<ShardInfo>> allNodes(ListMultimap<ShardInfo, ServiceNode<ShardInfo>> serviceNodes) {
        return serviceNodes.asMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

