/*
 * Decompiled with CFR 0.152.
 */
package io.raven.vertx.ranger.common;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardInfo
implements Iterable<ShardInfo> {
    private static final Logger log = LoggerFactory.getLogger(ShardInfo.class);
    private static final String SEPARATOR = ".";
    private String environment;

    @Override
    public Iterator<ShardInfo> iterator() {
        return new ShardInfoIterator(this.environment);
    }

    public static ShardInfoBuilder builder() {
        return new ShardInfoBuilder();
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public ShardInfo(String environment) {
        this.environment = environment;
    }

    public ShardInfo() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardInfo)) {
            return false;
        }
        ShardInfo other = (ShardInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    public String toString() {
        return "ShardInfo(environment=" + this.getEnvironment() + ")";
    }

    public static class ShardInfoBuilder {
        private String environment;

        ShardInfoBuilder() {
        }

        public ShardInfoBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public ShardInfo build() {
            return new ShardInfo(this.environment);
        }

        public String toString() {
            return "ShardInfo.ShardInfoBuilder(environment=" + this.environment + ")";
        }
    }

    public static final class ShardInfoIterator
    implements Iterator<ShardInfo> {
        private String remainingEnvironment;

        public ShardInfoIterator(String remainingEnvironment) {
            this.remainingEnvironment = remainingEnvironment;
        }

        @Override
        public boolean hasNext() {
            return !Strings.isNullOrEmpty((String)this.remainingEnvironment);
        }

        @Override
        public ShardInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (log.isDebugEnabled()) {
                log.debug("Effective environment for discovery is {}", (Object)this.remainingEnvironment);
            }
            ShardInfo shardInfo = new ShardInfo(this.remainingEnvironment);
            int sepIndex = this.remainingEnvironment.indexOf(ShardInfo.SEPARATOR);
            this.remainingEnvironment = sepIndex < 0 ? "" : this.remainingEnvironment.substring(0, sepIndex);
            return shardInfo;
        }
    }
}

