/*
 * Decompiled with CFR 0.152.
 */
package io.raven.vertx.ranger.handlers;

import io.raven.vertx.ranger.ServiceDiscoveryClient;
import io.vertx.core.Handler;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InfoHandler
implements Handler<RoutingContext> {
    private static final Logger log = LogManager.getLogger(InfoHandler.class);
    private ServiceDiscoveryClient serviceDiscoveryClient;

    public InfoHandler(ServiceDiscoveryClient serviceDiscoveryClient) {
        this.serviceDiscoveryClient = serviceDiscoveryClient;
    }

    public void handle(RoutingContext event) {
        ((CompletableFuture)this.serviceDiscoveryClient.getAllNodes().thenAccept(nodes -> event.response().end(Json.encodeToBuffer((Object)nodes)))).exceptionally(exception -> {
            log.error("Error getting ranger nodes", exception);
            event.fail(exception);
            return null;
        });
    }

    public static InfoHandlerBuilder builder() {
        return new InfoHandlerBuilder();
    }

    public static class InfoHandlerBuilder {
        private ServiceDiscoveryClient serviceDiscoveryClient;

        InfoHandlerBuilder() {
        }

        public InfoHandlerBuilder serviceDiscoveryClient(ServiceDiscoveryClient serviceDiscoveryClient) {
            this.serviceDiscoveryClient = serviceDiscoveryClient;
            return this;
        }

        public InfoHandler build() {
            return new InfoHandler(this.serviceDiscoveryClient);
        }

        public String toString() {
            return "InfoHandler.InfoHandlerBuilder(serviceDiscoveryClient=" + this.serviceDiscoveryClient + ")";
        }
    }
}

