/*
 * Decompiled with CFR 0.152.
 */
package io.raven.vertx.ranger;

import com.fasterxml.jackson.core.type.TypeReference;
import com.flipkart.ranger.ServiceFinderBuilders;
import com.flipkart.ranger.finder.sharded.SimpleShardedServiceFinder;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.model.ShardSelector;
import io.raven.vertx.ranger.HierarchicalEnvironmentAwareShardSelector;
import io.raven.vertx.ranger.common.ShardInfo;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryClient.class);
    private final ShardInfo criteria;
    private final SimpleShardedServiceFinder<ShardInfo> serviceFinder;
    private final WebClient client;

    private ServiceDiscoveryClient(String connectionString, Vertx vertx, JsonObject clientConfig) {
        this(CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)new RetryForever(5000)), vertx, clientConfig);
    }

    ServiceDiscoveryClient(CuratorFramework curator, Vertx vertx, JsonObject clientConfig) {
        int effectiveRefreshTimeMs = clientConfig.getInteger("refreshTimeMs", Integer.valueOf(10000));
        if (effectiveRefreshTimeMs < 5000) {
            effectiveRefreshTimeMs = 5000;
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)clientConfig.getInteger("refreshTimeMs"), (Object)5000);
        }
        this.criteria = ShardInfo.builder().environment(clientConfig.getString("environment", "local")).build();
        this.serviceFinder = (SimpleShardedServiceFinder)ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(curator).withNamespace(clientConfig.getString("namespace")).withServiceName(clientConfig.getString("serviceName")).withDeserializer(data -> {
            try {
                return (ServiceNode)DatabindCodec.mapper().readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withNodeRefreshIntervalMs(effectiveRefreshTimeMs).withDisableWatchers(clientConfig.getBoolean("disableWatchers", Boolean.valueOf(true)).booleanValue()).withShardSelector((ShardSelector)new HierarchicalEnvironmentAwareShardSelector()).build();
        WebClientOptions clientOptions = new WebClientOptions().setSsl(clientConfig.getBoolean("ssl", Boolean.valueOf(false)).booleanValue()).setMetricsName(clientConfig.getString("clientName", "vertx-web-client")).setKeepAlive(clientConfig.getBoolean("keepAlive", Boolean.valueOf(true)).booleanValue()).setMaxPoolSize(clientConfig.getInteger("maxPoolSize", Integer.valueOf(10)).intValue()).setProtocolVersion(HttpVersion.valueOf((String)clientConfig.getString("protocolVersion", HttpVersion.HTTP_1_1.name()))).setTcpKeepAlive(clientConfig.getBoolean("keepAlive", Boolean.valueOf(true)).booleanValue()).setConnectTimeout(clientConfig.getInteger("connectionTimeout", Integer.valueOf(3000)).intValue()).setIdleTimeout(clientConfig.getInteger("idleTimeout", Integer.valueOf(30)).intValue()).setIdleTimeoutUnit(TimeUnit.SECONDS).setKeepAliveTimeout(clientConfig.getInteger("keepAliveTimeout", Integer.valueOf(60)).intValue()).setTcpFastOpen(true).setVerifyHost(clientConfig.getBoolean("verifyHost", Boolean.valueOf(false)).booleanValue());
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)clientOptions);
    }

    public CompletableFuture<Void> start() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.serviceFinder.start();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public CompletableFuture<Void> stop() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.serviceFinder.stop();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public CompletableFuture<Optional<ServiceNode<ShardInfo>>> getNode() {
        return this.getNode(this.criteria);
    }

    public CompletableFuture<List<ServiceNode<ShardInfo>>> getAllNodes() {
        return this.getAllNodes(this.criteria);
    }

    public CompletableFuture<Optional<ServiceNode<ShardInfo>>> getNode(ShardInfo shardInfo) {
        CompletableFuture<Optional<ServiceNode<ShardInfo>>> result = new CompletableFuture<Optional<ServiceNode<ShardInfo>>>();
        result.complete(Optional.ofNullable(this.serviceFinder.get((Object)shardInfo)));
        return result;
    }

    public CompletableFuture<List<ServiceNode<ShardInfo>>> getAllNodes(ShardInfo shardInfo) {
        CompletableFuture<List<ServiceNode<ShardInfo>>> result = new CompletableFuture<List<ServiceNode<ShardInfo>>>();
        result.complete(this.serviceFinder.getAll((Object)shardInfo));
        return result;
    }

    public CompletableFuture<HttpResponse<Buffer>> get(String requestUri, MultiMap headers, MultiMap queryParameters) {
        ServiceNode node = this.serviceFinder.get((Object)this.criteria);
        if (Objects.isNull(node)) {
            return CompletableFuture.failedFuture(new IllegalStateException("No service node available"));
        }
        CompletableFuture<HttpResponse<Buffer>> result = new CompletableFuture<HttpResponse<Buffer>>();
        HttpRequest request = this.client.get(node.getPort(), node.getHost(), requestUri);
        this.addRequestProperties((HttpRequest<Buffer>)request, headers, queryParameters);
        request.send(res -> {
            if (res.succeeded()) {
                result.complete((HttpResponse)res.result());
            } else {
                result.completeExceptionally(res.cause());
            }
        });
        return result;
    }

    public CompletableFuture<HttpResponse<Buffer>> post(String requestUri, MultiMap headers, MultiMap queryParameters, Buffer data) {
        ServiceNode node = this.serviceFinder.get((Object)this.criteria);
        if (Objects.isNull(node)) {
            return CompletableFuture.failedFuture(new IllegalStateException("No service node available"));
        }
        CompletableFuture<HttpResponse<Buffer>> result = new CompletableFuture<HttpResponse<Buffer>>();
        HttpRequest request = this.client.post(node.getPort(), node.getHost(), requestUri);
        this.addRequestProperties((HttpRequest<Buffer>)request, headers, queryParameters);
        if (Objects.nonNull(data)) {
            request.sendBuffer(data, res -> {
                if (res.succeeded()) {
                    result.complete((HttpResponse)res.result());
                } else {
                    result.completeExceptionally(res.cause());
                }
            });
        }
        return result;
    }

    public CompletableFuture<HttpResponse<Buffer>> put(String requestUri, MultiMap headers, MultiMap queryParameters, Buffer data) {
        ServiceNode node = this.serviceFinder.get((Object)this.criteria);
        if (Objects.isNull(node)) {
            return CompletableFuture.failedFuture(new IllegalStateException("No service node available"));
        }
        CompletableFuture<HttpResponse<Buffer>> result = new CompletableFuture<HttpResponse<Buffer>>();
        HttpRequest request = this.client.put(node.getPort(), node.getHost(), requestUri);
        this.addRequestProperties((HttpRequest<Buffer>)request, headers, queryParameters);
        if (Objects.nonNull(data)) {
            request.sendBuffer(data, res -> {
                if (res.succeeded()) {
                    result.complete((HttpResponse)res.result());
                } else {
                    result.completeExceptionally(res.cause());
                }
            });
        }
        return result;
    }

    private void addRequestProperties(HttpRequest<Buffer> request, MultiMap headers, MultiMap queryParameters) {
        if (Objects.nonNull(headers)) {
            request.putHeaders(headers);
        }
        if (Objects.nonNull(queryParameters)) {
            queryParameters.forEach(e -> request.addQueryParam((String)e.getKey(), (String)e.getValue()));
        }
    }

    public static FromConnectionStringBuilder fromConnectionString() {
        return new FromConnectionStringBuilder();
    }

    public static FromCuratorBuilder fromCurator() {
        return new FromCuratorBuilder();
    }

    public static class FromCuratorBuilder {
        private CuratorFramework curator;
        private Vertx vertx;
        private JsonObject clientConfig;

        FromCuratorBuilder() {
        }

        public FromCuratorBuilder curator(CuratorFramework curator) {
            this.curator = curator;
            return this;
        }

        public FromCuratorBuilder vertx(Vertx vertx) {
            this.vertx = vertx;
            return this;
        }

        public FromCuratorBuilder clientConfig(JsonObject clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.curator, this.vertx, this.clientConfig);
        }

        public String toString() {
            return "ServiceDiscoveryClient.FromCuratorBuilder(curator=" + this.curator + ", vertx=" + this.vertx + ", clientConfig=" + this.clientConfig + ")";
        }
    }

    public static class FromConnectionStringBuilder {
        private String connectionString;
        private Vertx vertx;
        private JsonObject clientConfig;

        FromConnectionStringBuilder() {
        }

        public FromConnectionStringBuilder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public FromConnectionStringBuilder vertx(Vertx vertx) {
            this.vertx = vertx;
            return this;
        }

        public FromConnectionStringBuilder clientConfig(JsonObject clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.connectionString, this.vertx, this.clientConfig);
        }

        public String toString() {
            return "ServiceDiscoveryClient.FromConnectionStringBuilder(connectionString=" + this.connectionString + ", vertx=" + this.vertx + ", clientConfig=" + this.clientConfig + ")";
        }
    }
}

