// Compiled by ClojureScript 1.8.34 {}
goog.provide('full.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
full.async.cljs_env_QMARK_ = (function full$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
full.async.PSupervisor = function(){};

full.async._error = (function full$async$_error(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_error$arity$1 == null)))){
return this$.full$async$PSupervisor$_error$arity$1(this$);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._error[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$);
} else {
var m__19038__auto____$1 = (full.async._error["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

full.async._abort = (function full$async$_abort(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_abort$arity$1 == null)))){
return this$.full$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._abort[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$);
} else {
var m__19038__auto____$1 = (full.async._abort["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

full.async._register_go = (function full$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._register_go[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,body);
} else {
var m__19038__auto____$1 = (full.async._register_go["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

full.async._unregister_go = (function full$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._unregister_go[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,id);
} else {
var m__19038__auto____$1 = (full.async._unregister_go["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

full.async._track_exception = (function full$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._track_exception[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,e);
} else {
var m__19038__auto____$1 = (full.async._track_exception["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

full.async._free_exception = (function full$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._free_exception[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,e);
} else {
var m__19038__auto____$1 = (full.async._free_exception["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

full.async.now = (function full$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {full.async.PSupervisor}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
full.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__18996__auto__,k__18997__auto__){
var self__ = this;
var this__18996__auto____$1 = this;
return cljs.core._lookup.call(null,this__18996__auto____$1,k__18997__auto__,null);
});

full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__18998__auto__,k152641,else__18999__auto__){
var self__ = this;
var this__18998__auto____$1 = this;
var G__152643 = (((k152641 instanceof cljs.core.Keyword))?k152641.fqn:null);
switch (G__152643) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k152641,else__18999__auto__);

}
});

full.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19010__auto__,writer__19011__auto__,opts__19012__auto__){
var self__ = this;
var this__19010__auto____$1 = this;
var pr_pair__19013__auto__ = ((function (this__19010__auto____$1){
return (function (keyval__19014__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19011__auto__,cljs.core.pr_writer,""," ","",opts__19012__auto__,keyval__19014__auto__);
});})(this__19010__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19011__auto__,pr_pair__19013__auto__,"#full.async.TrackingSupervisor{",", ","}",opts__19012__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = true;

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__152640){
var self__ = this;
var G__152640__$1 = this;
return (new cljs.core.RecordIter((0),G__152640__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

full.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__18994__auto__){
var self__ = this;
var this__18994__auto____$1 = this;
return self__.__meta;
});

full.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__18990__auto__){
var self__ = this;
var this__18990__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19000__auto__){
var self__ = this;
var this__19000__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__18991__auto__){
var self__ = this;
var this__18991__auto____$1 = this;
var h__18809__auto__ = self__.__hash;
if(!((h__18809__auto__ == null))){
return h__18809__auto__;
} else {
var h__18809__auto____$1 = cljs.core.hash_imap.call(null,this__18991__auto____$1);
self__.__hash = h__18809__auto____$1;

return h__18809__auto____$1;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__18992__auto__,other__18993__auto__){
var self__ = this;
var this__18992__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18362__auto__ = other__18993__auto__;
if(cljs.core.truth_(and__18362__auto__)){
var and__18362__auto____$1 = (this__18992__auto____$1.constructor === other__18993__auto__.constructor);
if(and__18362__auto____$1){
return cljs.core.equiv_map.call(null,this__18992__auto____$1,other__18993__auto__);
} else {
return and__18362__auto____$1;
}
} else {
return and__18362__auto__;
}
})())){
return true;
} else {
return false;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19005__auto__,k__19006__auto__){
var self__ = this;
var this__19005__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__19006__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19005__auto____$1),self__.__meta),k__19006__auto__);
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19006__auto__)),null));
}
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$ = true;

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,full.async.now.call(null));
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

full.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19003__auto__,k__19004__auto__,G__152640){
var self__ = this;
var this__19003__auto____$1 = this;
var pred__152644 = cljs.core.keyword_identical_QMARK_;
var expr__152645 = k__19004__auto__;
if(cljs.core.truth_(pred__152644.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__152645))){
return (new full.async.TrackingSupervisor(G__152640,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__152644.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__152645))){
return (new full.async.TrackingSupervisor(self__.error,G__152640,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__152644.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__152645))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,G__152640,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__152644.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__152645))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__152640,self__.__meta,self__.__extmap,null));
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19004__auto__,G__152640),null));
}
}
}
}
});

full.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19008__auto__){
var self__ = this;
var this__19008__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__18995__auto__,G__152640){
var self__ = this;
var this__18995__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__152640,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19001__auto__,entry__19002__auto__){
var self__ = this;
var this__19001__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19002__auto__)){
return cljs.core._assoc.call(null,this__19001__auto____$1,cljs.core._nth.call(null,entry__19002__auto__,(0)),cljs.core._nth.call(null,entry__19002__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19001__auto____$1,entry__19002__auto__);
}
});

full.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

full.async.TrackingSupervisor.cljs$lang$type = true;

full.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__19030__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"full.async/TrackingSupervisor");
});

full.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__19030__auto__,writer__19031__auto__){
return cljs.core._write.call(null,writer__19031__auto__,"full.async/TrackingSupervisor");
});

full.async.__GT_TrackingSupervisor = (function full$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new full.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

full.async.map__GT_TrackingSupervisor = (function full$async$map__GT_TrackingSupervisor(G__152642){
return (new full.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__152642),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__152642),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__152642),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__152642),null,cljs.core.dissoc.call(null,G__152642,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
full.async._STAR_super_STAR_ = (function (){var err_ch = cljs.core.async.chan.call(null);
var stale_timeout = ((10) * (1000));
var s = cljs.core.assoc.call(null,full.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),err_ch,new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null)),new cljs.core.Keyword(null,"global?","global?",-2022837689),true);
var c__20412__auto___152719 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20412__auto___152719,err_ch,stale_timeout,s){
return (function (){
var f__20413__auto__ = (function (){var switch__20391__auto__ = ((function (c__20412__auto___152719,err_ch,stale_timeout,s){
return (function (state_152662){
var state_val_152663 = (state_152662[(1)]);
if((state_val_152663 === (1))){
var state_152662__$1 = state_152662;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_152662__$1,(2),err_ch);
} else {
if((state_val_152663 === (2))){
var inst_152649 = (state_152662[(2)]);
var inst_152650 = inst_152649;
var state_152662__$1 = (function (){var statearr_152664 = state_152662;
(statearr_152664[(7)] = inst_152650);

return statearr_152664;
})();
var statearr_152665_152720 = state_152662__$1;
(statearr_152665_152720[(2)] = null);

(statearr_152665_152720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152663 === (3))){
var inst_152652 = cljs.core.async.timeout.call(null,(100));
var state_152662__$1 = state_152662;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_152662__$1,(5),inst_152652);
} else {
if((state_val_152663 === (4))){
var inst_152660 = (state_152662[(2)]);
var state_152662__$1 = state_152662;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_152662__$1,inst_152660);
} else {
if((state_val_152663 === (5))){
var inst_152650 = (state_152662[(7)]);
var inst_152654 = (state_152662[(2)]);
var inst_152655 = cljs.core.println.call(null,"Global supervisor:",inst_152650);
var state_152662__$1 = (function (){var statearr_152666 = state_152662;
(statearr_152666[(8)] = inst_152655);

(statearr_152666[(9)] = inst_152654);

return statearr_152666;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_152662__$1,(6),err_ch);
} else {
if((state_val_152663 === (6))){
var inst_152657 = (state_152662[(2)]);
var inst_152650 = inst_152657;
var state_152662__$1 = (function (){var statearr_152667 = state_152662;
(statearr_152667[(7)] = inst_152650);

return statearr_152667;
})();
var statearr_152668_152721 = state_152662__$1;
(statearr_152668_152721[(2)] = null);

(statearr_152668_152721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});})(c__20412__auto___152719,err_ch,stale_timeout,s))
;
return ((function (switch__20391__auto__,c__20412__auto___152719,err_ch,stale_timeout,s){
return (function() {
var full$async$state_machine__20392__auto__ = null;
var full$async$state_machine__20392__auto____0 = (function (){
var statearr_152672 = [null,null,null,null,null,null,null,null,null,null];
(statearr_152672[(0)] = full$async$state_machine__20392__auto__);

(statearr_152672[(1)] = (1));

return statearr_152672;
});
var full$async$state_machine__20392__auto____1 = (function (state_152662){
while(true){
var ret_value__20393__auto__ = (function (){try{while(true){
var result__20394__auto__ = switch__20391__auto__.call(null,state_152662);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20394__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20394__auto__;
}
break;
}
}catch (e152673){if((e152673 instanceof Object)){
var ex__20395__auto__ = e152673;
var statearr_152674_152722 = state_152662;
(statearr_152674_152722[(5)] = ex__20395__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_152662);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e152673;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20393__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__152723 = state_152662;
state_152662 = G__152723;
continue;
} else {
return ret_value__20393__auto__;
}
break;
}
});
full$async$state_machine__20392__auto__ = function(state_152662){
switch(arguments.length){
case 0:
return full$async$state_machine__20392__auto____0.call(this);
case 1:
return full$async$state_machine__20392__auto____1.call(this,state_152662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20392__auto____0;
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20392__auto____1;
return full$async$state_machine__20392__auto__;
})()
;})(switch__20391__auto__,c__20412__auto___152719,err_ch,stale_timeout,s))
})();
var state__20414__auto__ = (function (){var statearr_152675 = f__20413__auto__.call(null);
(statearr_152675[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20412__auto___152719);

return statearr_152675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20414__auto__);
});})(c__20412__auto___152719,err_ch,stale_timeout,s))
);


var c__20412__auto___152724 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20412__auto___152724,err_ch,stale_timeout,s){
return (function (){
var f__20413__auto__ = (function (){var switch__20391__auto__ = ((function (c__20412__auto___152724,err_ch,stale_timeout,s){
return (function (state_152700){
var state_val_152701 = (state_152700[(1)]);
if((state_val_152701 === (1))){
var state_152700__$1 = state_152700;
var statearr_152702_152725 = state_152700__$1;
(statearr_152702_152725[(2)] = null);

(statearr_152702_152725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152701 === (2))){
var inst_152677 = cljs.core.async.timeout.call(null,stale_timeout);
var state_152700__$1 = state_152700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_152700__$1,(4),inst_152677);
} else {
if((state_val_152701 === (3))){
var inst_152698 = (state_152700[(2)]);
var state_152700__$1 = state_152700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_152700__$1,inst_152698);
} else {
if((state_val_152701 === (4))){
var inst_152688 = (state_152700[(7)]);
var inst_152679 = (state_152700[(2)]);
var inst_152683 = (function (){return ((function (inst_152688,inst_152679,state_val_152701,c__20412__auto___152724,err_ch,stale_timeout,s){
return (function (p__152682){
var vec__152703 = p__152682;
var k = cljs.core.nth.call(null,vec__152703,(0),null);
var v = cljs.core.nth.call(null,vec__152703,(1),null);
return ((full.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});
;})(inst_152688,inst_152679,state_val_152701,c__20412__auto___152724,err_ch,stale_timeout,s))
})();
var inst_152684 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_152685 = cljs.core.deref.call(null,inst_152684);
var inst_152686 = cljs.core.filter.call(null,inst_152683,inst_152685);
var inst_152687 = cljs.core.nth.call(null,inst_152686,(0),null);
var inst_152688__$1 = cljs.core.nth.call(null,inst_152687,(0),null);
var inst_152689 = cljs.core.nth.call(null,inst_152687,(1),null);
var state_152700__$1 = (function (){var statearr_152704 = state_152700;
(statearr_152704[(7)] = inst_152688__$1);

(statearr_152704[(8)] = inst_152679);

(statearr_152704[(9)] = inst_152689);

return statearr_152704;
})();
if(cljs.core.truth_(inst_152688__$1)){
var statearr_152705_152726 = state_152700__$1;
(statearr_152705_152726[(1)] = (5));

} else {
var statearr_152706_152727 = state_152700__$1;
(statearr_152706_152727[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152701 === (5))){
var inst_152688 = (state_152700[(7)]);
var inst_152691 = cljs.core.println.call(null,"Global supervisor detected stale error:",inst_152688);
var inst_152692 = full.async._free_exception.call(null,s,inst_152688);
var state_152700__$1 = (function (){var statearr_152707 = state_152700;
(statearr_152707[(10)] = inst_152691);

return statearr_152707;
})();
var statearr_152708_152728 = state_152700__$1;
(statearr_152708_152728[(2)] = inst_152692);

(statearr_152708_152728[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152701 === (6))){
var state_152700__$1 = state_152700;
var statearr_152709_152729 = state_152700__$1;
(statearr_152709_152729[(2)] = null);

(statearr_152709_152729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152701 === (7))){
var inst_152695 = (state_152700[(2)]);
var state_152700__$1 = (function (){var statearr_152710 = state_152700;
(statearr_152710[(11)] = inst_152695);

return statearr_152710;
})();
var statearr_152711_152730 = state_152700__$1;
(statearr_152711_152730[(2)] = null);

(statearr_152711_152730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20412__auto___152724,err_ch,stale_timeout,s))
;
return ((function (switch__20391__auto__,c__20412__auto___152724,err_ch,stale_timeout,s){
return (function() {
var full$async$state_machine__20392__auto__ = null;
var full$async$state_machine__20392__auto____0 = (function (){
var statearr_152715 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_152715[(0)] = full$async$state_machine__20392__auto__);

(statearr_152715[(1)] = (1));

return statearr_152715;
});
var full$async$state_machine__20392__auto____1 = (function (state_152700){
while(true){
var ret_value__20393__auto__ = (function (){try{while(true){
var result__20394__auto__ = switch__20391__auto__.call(null,state_152700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20394__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20394__auto__;
}
break;
}
}catch (e152716){if((e152716 instanceof Object)){
var ex__20395__auto__ = e152716;
var statearr_152717_152731 = state_152700;
(statearr_152717_152731[(5)] = ex__20395__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_152700);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e152716;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20393__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__152732 = state_152700;
state_152700 = G__152732;
continue;
} else {
return ret_value__20393__auto__;
}
break;
}
});
full$async$state_machine__20392__auto__ = function(state_152700){
switch(arguments.length){
case 0:
return full$async$state_machine__20392__auto____0.call(this);
case 1:
return full$async$state_machine__20392__auto____1.call(this,state_152700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20392__auto____0;
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20392__auto____1;
return full$async$state_machine__20392__auto__;
})()
;})(switch__20391__auto__,c__20412__auto___152724,err_ch,stale_timeout,s))
})();
var state__20414__auto__ = (function (){var statearr_152718 = f__20413__auto__.call(null);
(statearr_152718[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20412__auto___152724);

return statearr_152718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20414__auto__);
});})(c__20412__auto___152724,err_ch,stale_timeout,s))
);


return s;
})();
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
full.async.throw_if_exception = (function full$async$throw_if_exception(x){
if((x instanceof Error)){
full.async._free_exception.call(null,full.async._STAR_super_STAR_,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__18374__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.take_QMARK_ = (function full$async$take_QMARK_(var_args){
var args152751 = [];
var len__19443__auto___152754 = arguments.length;
var i__19444__auto___152755 = (0);
while(true){
if((i__19444__auto___152755 < len__19443__auto___152754)){
args152751.push((arguments[i__19444__auto___152755]));

var G__152756 = (i__19444__auto___152755 + (1));
i__19444__auto___152755 = G__152756;
continue;
} else {
}
break;
}

var G__152753 = args152751.length;
switch (G__152753) {
case 2:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args152751.length)].join('')));

}
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return full.async.take_QMARK_.call(null,port,fn1,true);
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var super$ = full.async._STAR_super_STAR_;
return cljs.core.async.take_BANG_.call(null,port,((function (super$){
return (function (v){
if((v instanceof Error)){
full.async._free_exception.call(null,super$,v);
} else {
}

return fn1.call(null,v);
});})(super$))
,on_caller_QMARK_);
});

full.async.take_QMARK_.cljs$lang$maxFixedArity = 3;
/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.put_QMARK_ = (function full$async$put_QMARK_(var_args){
var args152758 = [];
var len__19443__auto___152761 = arguments.length;
var i__19444__auto___152762 = (0);
while(true){
if((i__19444__auto___152762 < len__19443__auto___152761)){
args152758.push((arguments[i__19444__auto___152762]));

var G__152763 = (i__19444__auto___152762 + (1));
i__19444__auto___152762 = G__152763;
continue;
} else {
}
break;
}

var G__152760 = args152758.length;
switch (G__152760) {
case 2:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args152758.length)].join('')));

}
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
return full.async.put_QMARK_.call(null,port,val,(function full$async$noop(_){
return null;
}));
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return full.async.put_QMARK_.call(null,port,val,fn1,true);
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
full.async._track_exception.call(null,full.async._STAR_super_STAR_,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

full.async.put_QMARK_.cljs$lang$maxFixedArity = 4;
/**
 * Same as core.async alts! but throws an exception if the channel returns a
 *   throwable object or the context has been aborted.
 */
full.async.alts_QMARK_ = (function full$async$alts_QMARK_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___152769 = arguments.length;
var i__19444__auto___152770 = (0);
while(true){
if((i__19444__auto___152770 < len__19443__auto___152769)){
args__19450__auto__.push((arguments[i__19444__auto___152770]));

var G__152771 = (i__19444__auto___152770 + (1));
i__19444__auto___152770 = G__152771;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((1) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((1)),(0),null)):null);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19451__auto__);
});

full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,opts){
var abort__151918__auto__ = full.async._abort.call(null,full.async._STAR_super_STAR_);
var to__151919__auto__ = cljs.core.async.timeout.call(null,(0));
var vec__152767 = cljs.core.async.alts_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [abort__151918__auto__,to__151919__auto__], null),new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var val__151920__auto__ = cljs.core.nth.call(null,vec__152767,(0),null);
var port__151921__auto__ = cljs.core.nth.call(null,vec__152767,(1),null);
if(cljs.core._EQ_.call(null,port__151921__auto__,abort__151918__auto__)){
return cljs.core.ex_info.call(null,"Aborted operations",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"aborted","aborted",1775972619)], null));
} else {
var vec__152768 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var val = cljs.core.nth.call(null,vec__152768,(0),null);
var port = cljs.core.nth.call(null,vec__152768,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [full.async.throw_if_exception.call(null,val),port], null);
}
});

full.async.alts_QMARK_.cljs$lang$maxFixedArity = (1);

full.async.alts_QMARK_.cljs$lang$applyTo = (function (seq152765){
var G__152766 = cljs.core.first.call(null,seq152765);
var seq152765__$1 = cljs.core.next.call(null,seq152765);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__152766,seq152765__$1);
});
/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
full.async.pmap_GT__GT_ = (function full$async$pmap_GT__GT_(var_args){
var args152780 = [];
var len__19443__auto___152902 = arguments.length;
var i__19444__auto___152903 = (0);
while(true){
if((i__19444__auto___152903 < len__19443__auto___152902)){
args152780.push((arguments[i__19444__auto___152903]));

var G__152904 = (i__19444__auto___152903 + (1));
i__19444__auto___152903 = G__152904;
continue;
} else {
}
break;
}

var G__152782 = args152780.length;
switch (G__152782) {
case 3:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args152780.length)].join('')));

}
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3 = (function (f_GT_,parallelism,in_ch){
return full.async.pmap_GT__GT_.call(null,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__19288__auto___152906 = parallelism;
var __152907 = (0);
while(true){
if((__152907 < n__19288__auto___152906)){
var c__20412__auto___152908 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__152907,c__20412__auto___152908,n__19288__auto___152906,threads){
return (function (){
var f__20413__auto__ = (function (){var switch__20391__auto__ = ((function (__152907,c__20412__auto___152908,n__19288__auto___152906,threads){
return (function (state_152858){
var state_val_152859 = (state_152858[(1)]);
if((state_val_152859 === (7))){
var inst_152847 = (state_152858[(2)]);
var state_152858__$1 = state_152858;
var statearr_152860_152909 = state_152858__$1;
(statearr_152860_152909[(2)] = inst_152847);

(statearr_152860_152909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (20))){
var inst_152818 = (state_152858[(7)]);
var inst_152824 = (state_152858[(2)]);
var inst_152825 = cljs.core.nth.call(null,inst_152824,(0),null);
var inst_152826 = cljs.core.nth.call(null,inst_152824,(1),null);
var inst_152827 = cljs.core._EQ_.call(null,inst_152826,inst_152818);
var state_152858__$1 = (function (){var statearr_152861 = state_152858;
(statearr_152861[(8)] = inst_152825);

return statearr_152861;
})();
if(inst_152827){
var statearr_152862_152910 = state_152858__$1;
(statearr_152862_152910[(1)] = (21));

} else {
var statearr_152863_152911 = state_152858__$1;
(statearr_152863_152911[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (27))){
var inst_152856 = (state_152858[(2)]);
var state_152858__$1 = state_152858;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_152858__$1,inst_152856);
} else {
if((state_val_152859 === (1))){
var state_152858__$1 = state_152858;
var statearr_152864_152912 = state_152858__$1;
(statearr_152864_152912[(2)] = null);

(statearr_152864_152912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (24))){
var inst_152835 = (state_152858[(2)]);
var state_152858__$1 = state_152858;
var statearr_152865_152913 = state_152858__$1;
(statearr_152865_152913[(2)] = inst_152835);

(statearr_152865_152913[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (4))){
var inst_152785 = (state_152858[(9)]);
var inst_152785__$1 = (state_152858[(2)]);
var state_152858__$1 = (function (){var statearr_152866 = state_152858;
(statearr_152866[(9)] = inst_152785__$1);

return statearr_152866;
})();
if(cljs.core.truth_(inst_152785__$1)){
var statearr_152867_152914 = state_152858__$1;
(statearr_152867_152914[(1)] = (5));

} else {
var statearr_152868_152915 = state_152858__$1;
(statearr_152868_152915[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (15))){
var inst_152807 = (state_152858[(2)]);
var state_152858__$1 = state_152858;
var statearr_152869_152916 = state_152858__$1;
(statearr_152869_152916[(2)] = inst_152807);

(statearr_152869_152916[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (21))){
var inst_152829 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_152830 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_152831 = cljs.core.PersistentHashMap.fromArrays(inst_152829,inst_152830);
var inst_152832 = cljs.core.ex_info.call(null,"Aborted operations",inst_152831);
var state_152858__$1 = state_152858;
var statearr_152870_152917 = state_152858__$1;
(statearr_152870_152917[(2)] = inst_152832);

(statearr_152870_152917[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (13))){
var inst_152785 = (state_152858[(9)]);
var state_152858__$1 = state_152858;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_152858__$1,(15),out_ch,inst_152785);
} else {
if((state_val_152859 === (22))){
var inst_152815 = (state_152858[(10)]);
var state_152858__$1 = state_152858;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_152858__$1,(24),out_ch,inst_152815);
} else {
if((state_val_152859 === (6))){
var state_152858__$1 = state_152858;
var statearr_152871_152918 = state_152858__$1;
(statearr_152871_152918[(2)] = null);

(statearr_152871_152918[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (25))){
var inst_152853 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_152858__$1 = state_152858;
var statearr_152872_152919 = state_152858__$1;
(statearr_152872_152919[(2)] = inst_152853);

(statearr_152872_152919[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (17))){
var inst_152818 = (state_152858[(7)]);
var inst_152818__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_152819 = cljs.core.async.timeout.call(null,(0));
var inst_152820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_152821 = [inst_152818__$1,inst_152819];
var inst_152822 = (new cljs.core.PersistentVector(null,2,(5),inst_152820,inst_152821,null));
var state_152858__$1 = (function (){var statearr_152873 = state_152858;
(statearr_152873[(7)] = inst_152818__$1);

return statearr_152873;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_152858__$1,(20),inst_152822,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_152859 === (3))){
var inst_152849 = (state_152858[(2)]);
var inst_152850 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_152851 = (inst_152850 === (0));
var state_152858__$1 = (function (){var statearr_152874 = state_152858;
(statearr_152874[(11)] = inst_152849);

return statearr_152874;
})();
if(cljs.core.truth_(inst_152851)){
var statearr_152875_152920 = state_152858__$1;
(statearr_152875_152920[(1)] = (25));

} else {
var statearr_152876_152921 = state_152858__$1;
(statearr_152876_152921[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (12))){
var inst_152801 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_152802 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_152803 = cljs.core.PersistentHashMap.fromArrays(inst_152801,inst_152802);
var inst_152804 = cljs.core.ex_info.call(null,"Aborted operations",inst_152803);
var state_152858__$1 = state_152858;
var statearr_152877_152922 = state_152858__$1;
(statearr_152877_152922[(2)] = inst_152804);

(statearr_152877_152922[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (2))){
var state_152858__$1 = state_152858;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_152858__$1,(4),in_ch);
} else {
if((state_val_152859 === (23))){
var inst_152837 = (state_152858[(2)]);
var inst_152838 = full.async.throw_if_exception.call(null,inst_152837);
var state_152858__$1 = state_152858;
var statearr_152878_152923 = state_152858__$1;
(statearr_152878_152923[(2)] = inst_152838);

(statearr_152878_152923[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (19))){
var inst_152841 = (state_152858[(2)]);
var state_152858__$1 = (function (){var statearr_152879 = state_152858;
(statearr_152879[(12)] = inst_152841);

return statearr_152879;
})();
var statearr_152880_152924 = state_152858__$1;
(statearr_152880_152924[(2)] = null);

(statearr_152880_152924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (11))){
var inst_152790 = (state_152858[(13)]);
var inst_152796 = (state_152858[(2)]);
var inst_152797 = cljs.core.nth.call(null,inst_152796,(0),null);
var inst_152798 = cljs.core.nth.call(null,inst_152796,(1),null);
var inst_152799 = cljs.core._EQ_.call(null,inst_152798,inst_152790);
var state_152858__$1 = (function (){var statearr_152881 = state_152858;
(statearr_152881[(14)] = inst_152797);

return statearr_152881;
})();
if(inst_152799){
var statearr_152882_152925 = state_152858__$1;
(statearr_152882_152925[(1)] = (12));

} else {
var statearr_152883_152926 = state_152858__$1;
(statearr_152883_152926[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (9))){
var inst_152785 = (state_152858[(9)]);
var inst_152813 = f_GT_.call(null,inst_152785);
var state_152858__$1 = state_152858;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_152858__$1,(16),inst_152813);
} else {
if((state_val_152859 === (5))){
var inst_152785 = (state_152858[(9)]);
var inst_152787 = (inst_152785 instanceof Error);
var state_152858__$1 = state_152858;
if(cljs.core.truth_(inst_152787)){
var statearr_152884_152927 = state_152858__$1;
(statearr_152884_152927[(1)] = (8));

} else {
var statearr_152885_152928 = state_152858__$1;
(statearr_152885_152928[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (14))){
var inst_152809 = (state_152858[(2)]);
var inst_152810 = full.async.throw_if_exception.call(null,inst_152809);
var inst_152811 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_152858__$1 = (function (){var statearr_152886 = state_152858;
(statearr_152886[(15)] = inst_152810);

return statearr_152886;
})();
var statearr_152887_152929 = state_152858__$1;
(statearr_152887_152929[(2)] = inst_152811);

(statearr_152887_152929[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (26))){
var state_152858__$1 = state_152858;
var statearr_152888_152930 = state_152858__$1;
(statearr_152888_152930[(2)] = null);

(statearr_152888_152930[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (16))){
var inst_152815 = (state_152858[(10)]);
var inst_152815__$1 = (state_152858[(2)]);
var state_152858__$1 = (function (){var statearr_152889 = state_152858;
(statearr_152889[(10)] = inst_152815__$1);

return statearr_152889;
})();
if(cljs.core.truth_(inst_152815__$1)){
var statearr_152890_152931 = state_152858__$1;
(statearr_152890_152931[(1)] = (17));

} else {
var statearr_152891_152932 = state_152858__$1;
(statearr_152891_152932[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (10))){
var inst_152844 = (state_152858[(2)]);
var state_152858__$1 = state_152858;
var statearr_152892_152933 = state_152858__$1;
(statearr_152892_152933[(2)] = inst_152844);

(statearr_152892_152933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (18))){
var state_152858__$1 = state_152858;
var statearr_152893_152934 = state_152858__$1;
(statearr_152893_152934[(2)] = null);

(statearr_152893_152934[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152859 === (8))){
var inst_152790 = (state_152858[(13)]);
var inst_152790__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_152791 = cljs.core.async.timeout.call(null,(0));
var inst_152792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_152793 = [inst_152790__$1,inst_152791];
var inst_152794 = (new cljs.core.PersistentVector(null,2,(5),inst_152792,inst_152793,null));
var state_152858__$1 = (function (){var statearr_152894 = state_152858;
(statearr_152894[(13)] = inst_152790__$1);

return statearr_152894;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_152858__$1,(11),inst_152794,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__152907,c__20412__auto___152908,n__19288__auto___152906,threads))
;
return ((function (__152907,switch__20391__auto__,c__20412__auto___152908,n__19288__auto___152906,threads){
return (function() {
var full$async$state_machine__20392__auto__ = null;
var full$async$state_machine__20392__auto____0 = (function (){
var statearr_152898 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_152898[(0)] = full$async$state_machine__20392__auto__);

(statearr_152898[(1)] = (1));

return statearr_152898;
});
var full$async$state_machine__20392__auto____1 = (function (state_152858){
while(true){
var ret_value__20393__auto__ = (function (){try{while(true){
var result__20394__auto__ = switch__20391__auto__.call(null,state_152858);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20394__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20394__auto__;
}
break;
}
}catch (e152899){if((e152899 instanceof Object)){
var ex__20395__auto__ = e152899;
var statearr_152900_152935 = state_152858;
(statearr_152900_152935[(5)] = ex__20395__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_152858);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e152899;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20393__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__152936 = state_152858;
state_152858 = G__152936;
continue;
} else {
return ret_value__20393__auto__;
}
break;
}
});
full$async$state_machine__20392__auto__ = function(state_152858){
switch(arguments.length){
case 0:
return full$async$state_machine__20392__auto____0.call(this);
case 1:
return full$async$state_machine__20392__auto____1.call(this,state_152858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20392__auto____0;
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20392__auto____1;
return full$async$state_machine__20392__auto__;
})()
;})(__152907,switch__20391__auto__,c__20412__auto___152908,n__19288__auto___152906,threads))
})();
var state__20414__auto__ = (function (){var statearr_152901 = f__20413__auto__.call(null);
(statearr_152901[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20412__auto___152908);

return statearr_152901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20414__auto__);
});})(__152907,c__20412__auto___152908,n__19288__auto___152906,threads))
);


var G__152937 = (__152907 + (1));
__152907 = G__152937;
continue;
} else {
}
break;
}

return out_ch;
});

full.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 4;
/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
full.async.engulf = (function full$async$engulf(var_args){
var args__19450__auto__ = [];
var len__19443__auto___152965 = arguments.length;
var i__19444__auto___152966 = (0);
while(true){
if((i__19444__auto___152966 < len__19443__auto___152965)){
args__19450__auto__.push((arguments[i__19444__auto___152966]));

var G__152967 = (i__19444__auto___152966 + (1));
i__19444__auto___152966 = G__152967;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((0) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((0)),(0),null)):null);
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(argseq__19451__auto__);
});

full.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__20412__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20412__auto__,ch){
return (function (){
var f__20413__auto__ = (function (){var switch__20391__auto__ = ((function (c__20412__auto__,ch){
return (function (state_152950){
var state_val_152951 = (state_152950[(1)]);
if((state_val_152951 === (1))){
var state_152950__$1 = state_152950;
var statearr_152952_152968 = state_152950__$1;
(statearr_152952_152968[(2)] = null);

(statearr_152952_152968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152951 === (2))){
var state_152950__$1 = state_152950;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_152950__$1,(4),ch);
} else {
if((state_val_152951 === (3))){
var inst_152948 = (state_152950[(2)]);
var state_152950__$1 = state_152950;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_152950__$1,inst_152948);
} else {
if((state_val_152951 === (4))){
var inst_152941 = (state_152950[(2)]);
var state_152950__$1 = state_152950;
if(cljs.core.truth_(inst_152941)){
var statearr_152953_152969 = state_152950__$1;
(statearr_152953_152969[(1)] = (5));

} else {
var statearr_152954_152970 = state_152950__$1;
(statearr_152954_152970[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152951 === (5))){
var state_152950__$1 = state_152950;
var statearr_152955_152971 = state_152950__$1;
(statearr_152955_152971[(2)] = null);

(statearr_152955_152971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152951 === (6))){
var state_152950__$1 = state_152950;
var statearr_152956_152972 = state_152950__$1;
(statearr_152956_152972[(2)] = null);

(statearr_152956_152972[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_152951 === (7))){
var inst_152946 = (state_152950[(2)]);
var state_152950__$1 = state_152950;
var statearr_152957_152973 = state_152950__$1;
(statearr_152957_152973[(2)] = inst_152946);

(statearr_152957_152973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20412__auto__,ch))
;
return ((function (switch__20391__auto__,c__20412__auto__,ch){
return (function() {
var full$async$state_machine__20392__auto__ = null;
var full$async$state_machine__20392__auto____0 = (function (){
var statearr_152961 = [null,null,null,null,null,null,null];
(statearr_152961[(0)] = full$async$state_machine__20392__auto__);

(statearr_152961[(1)] = (1));

return statearr_152961;
});
var full$async$state_machine__20392__auto____1 = (function (state_152950){
while(true){
var ret_value__20393__auto__ = (function (){try{while(true){
var result__20394__auto__ = switch__20391__auto__.call(null,state_152950);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20394__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20394__auto__;
}
break;
}
}catch (e152962){if((e152962 instanceof Object)){
var ex__20395__auto__ = e152962;
var statearr_152963_152974 = state_152950;
(statearr_152963_152974[(5)] = ex__20395__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_152950);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e152962;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20393__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__152975 = state_152950;
state_152950 = G__152975;
continue;
} else {
return ret_value__20393__auto__;
}
break;
}
});
full$async$state_machine__20392__auto__ = function(state_152950){
switch(arguments.length){
case 0:
return full$async$state_machine__20392__auto____0.call(this);
case 1:
return full$async$state_machine__20392__auto____1.call(this,state_152950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20392__auto____0;
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20392__auto____1;
return full$async$state_machine__20392__auto__;
})()
;})(switch__20391__auto__,c__20412__auto__,ch))
})();
var state__20414__auto__ = (function (){var statearr_152964 = f__20413__auto__.call(null);
(statearr_152964[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20412__auto__);

return statearr_152964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20414__auto__);
});})(c__20412__auto__,ch))
);

return c__20412__auto__;
});

full.async.engulf.cljs$lang$maxFixedArity = (0);

full.async.engulf.cljs$lang$applyTo = (function (seq152938){
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq152938));
});
/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
full.async.reduce_GT_ = (function full$async$reduce_GT_(f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__20412__auto___153180 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20412__auto___153180,result){
return (function (){
var f__20413__auto__ = (function (){var switch__20391__auto__ = ((function (c__20412__auto___153180,result){
return (function (state_153144){
var state_val_153145 = (state_153144[(1)]);
if((state_val_153145 === (7))){
var inst_153140 = (state_153144[(2)]);
var state_153144__$1 = state_153144;
var statearr_153146_153181 = state_153144__$1;
(statearr_153146_153181[(2)] = inst_153140);

(statearr_153146_153181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (20))){
var inst_153136 = (state_153144[(2)]);
var inst_153137 = full.async.throw_if_exception.call(null,inst_153136);
var inst_153138 = cljs.core.async.close_BANG_.call(null,result);
var state_153144__$1 = (function (){var statearr_153147 = state_153144;
(statearr_153147[(7)] = inst_153137);

return statearr_153147;
})();
var statearr_153148_153182 = state_153144__$1;
(statearr_153148_153182[(2)] = inst_153138);

(statearr_153148_153182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (1))){
var inst_153078 = acc;
var state_153144__$1 = (function (){var statearr_153149 = state_153144;
(statearr_153149[(8)] = inst_153078);

return statearr_153149;
})();
var statearr_153150_153183 = state_153144__$1;
(statearr_153150_153183[(2)] = null);

(statearr_153150_153183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (4))){
var inst_153081 = (state_153144[(9)]);
var inst_153081__$1 = (state_153144[(2)]);
var state_153144__$1 = (function (){var statearr_153151 = state_153144;
(statearr_153151[(9)] = inst_153081__$1);

return statearr_153151;
})();
if(cljs.core.truth_(inst_153081__$1)){
var statearr_153152_153184 = state_153144__$1;
(statearr_153152_153184[(1)] = (5));

} else {
var statearr_153153_153185 = state_153144__$1;
(statearr_153153_153185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (15))){
var inst_153103 = (state_153144[(2)]);
var state_153144__$1 = state_153144;
var statearr_153154_153186 = state_153144__$1;
(statearr_153154_153186[(2)] = inst_153103);

(statearr_153154_153186[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (21))){
var inst_153134 = (state_153144[(2)]);
var state_153144__$1 = state_153144;
var statearr_153155_153187 = state_153144__$1;
(statearr_153155_153187[(2)] = inst_153134);

(statearr_153155_153187[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (13))){
var inst_153081 = (state_153144[(9)]);
var state_153144__$1 = state_153144;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_153144__$1,(15),result,inst_153081);
} else {
if((state_val_153145 === (6))){
var inst_153117 = (state_153144[(10)]);
var inst_153117__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_153118 = cljs.core.async.timeout.call(null,(0));
var inst_153119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_153120 = [inst_153117__$1,inst_153118];
var inst_153121 = (new cljs.core.PersistentVector(null,2,(5),inst_153119,inst_153120,null));
var state_153144__$1 = (function (){var statearr_153156 = state_153144;
(statearr_153156[(10)] = inst_153117__$1);

return statearr_153156;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_153144__$1,(17),inst_153121,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_153145 === (17))){
var inst_153117 = (state_153144[(10)]);
var inst_153123 = (state_153144[(2)]);
var inst_153124 = cljs.core.nth.call(null,inst_153123,(0),null);
var inst_153125 = cljs.core.nth.call(null,inst_153123,(1),null);
var inst_153126 = cljs.core._EQ_.call(null,inst_153125,inst_153117);
var state_153144__$1 = (function (){var statearr_153157 = state_153144;
(statearr_153157[(11)] = inst_153124);

return statearr_153157;
})();
if(inst_153126){
var statearr_153158_153188 = state_153144__$1;
(statearr_153158_153188[(1)] = (18));

} else {
var statearr_153159_153189 = state_153144__$1;
(statearr_153159_153189[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (3))){
var inst_153142 = (state_153144[(2)]);
var state_153144__$1 = state_153144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_153144__$1,inst_153142);
} else {
if((state_val_153145 === (12))){
var inst_153097 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_153098 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_153099 = cljs.core.PersistentHashMap.fromArrays(inst_153097,inst_153098);
var inst_153100 = cljs.core.ex_info.call(null,"Aborted operations",inst_153099);
var state_153144__$1 = state_153144;
var statearr_153160_153190 = state_153144__$1;
(statearr_153160_153190[(2)] = inst_153100);

(statearr_153160_153190[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (2))){
var state_153144__$1 = state_153144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_153144__$1,(4),ch);
} else {
if((state_val_153145 === (19))){
var inst_153078 = (state_153144[(8)]);
var state_153144__$1 = state_153144;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_153144__$1,(21),result,inst_153078);
} else {
if((state_val_153145 === (11))){
var inst_153086 = (state_153144[(12)]);
var inst_153092 = (state_153144[(2)]);
var inst_153093 = cljs.core.nth.call(null,inst_153092,(0),null);
var inst_153094 = cljs.core.nth.call(null,inst_153092,(1),null);
var inst_153095 = cljs.core._EQ_.call(null,inst_153094,inst_153086);
var state_153144__$1 = (function (){var statearr_153161 = state_153144;
(statearr_153161[(13)] = inst_153093);

return statearr_153161;
})();
if(inst_153095){
var statearr_153162_153191 = state_153144__$1;
(statearr_153162_153191[(1)] = (12));

} else {
var statearr_153163_153192 = state_153144__$1;
(statearr_153163_153192[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (9))){
var inst_153078 = (state_153144[(8)]);
var inst_153081 = (state_153144[(9)]);
var inst_153109 = f_GT_.call(null,inst_153078,inst_153081);
var state_153144__$1 = state_153144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_153144__$1,(16),inst_153109);
} else {
if((state_val_153145 === (5))){
var inst_153081 = (state_153144[(9)]);
var inst_153083 = (inst_153081 instanceof Error);
var state_153144__$1 = state_153144;
if(cljs.core.truth_(inst_153083)){
var statearr_153164_153193 = state_153144__$1;
(statearr_153164_153193[(1)] = (8));

} else {
var statearr_153165_153194 = state_153144__$1;
(statearr_153165_153194[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (14))){
var inst_153105 = (state_153144[(2)]);
var inst_153106 = full.async.throw_if_exception.call(null,inst_153105);
var inst_153107 = cljs.core.async.close_BANG_.call(null,result);
var state_153144__$1 = (function (){var statearr_153166 = state_153144;
(statearr_153166[(14)] = inst_153106);

return statearr_153166;
})();
var statearr_153167_153195 = state_153144__$1;
(statearr_153167_153195[(2)] = inst_153107);

(statearr_153167_153195[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (16))){
var inst_153111 = (state_153144[(2)]);
var inst_153078 = inst_153111;
var state_153144__$1 = (function (){var statearr_153168 = state_153144;
(statearr_153168[(8)] = inst_153078);

return statearr_153168;
})();
var statearr_153169_153196 = state_153144__$1;
(statearr_153169_153196[(2)] = null);

(statearr_153169_153196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (10))){
var inst_153114 = (state_153144[(2)]);
var state_153144__$1 = state_153144;
var statearr_153170_153197 = state_153144__$1;
(statearr_153170_153197[(2)] = inst_153114);

(statearr_153170_153197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (18))){
var inst_153128 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_153129 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_153130 = cljs.core.PersistentHashMap.fromArrays(inst_153128,inst_153129);
var inst_153131 = cljs.core.ex_info.call(null,"Aborted operations",inst_153130);
var state_153144__$1 = state_153144;
var statearr_153171_153198 = state_153144__$1;
(statearr_153171_153198[(2)] = inst_153131);

(statearr_153171_153198[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153145 === (8))){
var inst_153086 = (state_153144[(12)]);
var inst_153086__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_153087 = cljs.core.async.timeout.call(null,(0));
var inst_153088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_153089 = [inst_153086__$1,inst_153087];
var inst_153090 = (new cljs.core.PersistentVector(null,2,(5),inst_153088,inst_153089,null));
var state_153144__$1 = (function (){var statearr_153172 = state_153144;
(statearr_153172[(12)] = inst_153086__$1);

return statearr_153172;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_153144__$1,(11),inst_153090,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20412__auto___153180,result))
;
return ((function (switch__20391__auto__,c__20412__auto___153180,result){
return (function() {
var full$async$reduce_GT__$_state_machine__20392__auto__ = null;
var full$async$reduce_GT__$_state_machine__20392__auto____0 = (function (){
var statearr_153176 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_153176[(0)] = full$async$reduce_GT__$_state_machine__20392__auto__);

(statearr_153176[(1)] = (1));

return statearr_153176;
});
var full$async$reduce_GT__$_state_machine__20392__auto____1 = (function (state_153144){
while(true){
var ret_value__20393__auto__ = (function (){try{while(true){
var result__20394__auto__ = switch__20391__auto__.call(null,state_153144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20394__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20394__auto__;
}
break;
}
}catch (e153177){if((e153177 instanceof Object)){
var ex__20395__auto__ = e153177;
var statearr_153178_153199 = state_153144;
(statearr_153178_153199[(5)] = ex__20395__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_153144);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e153177;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20393__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__153200 = state_153144;
state_153144 = G__153200;
continue;
} else {
return ret_value__20393__auto__;
}
break;
}
});
full$async$reduce_GT__$_state_machine__20392__auto__ = function(state_153144){
switch(arguments.length){
case 0:
return full$async$reduce_GT__$_state_machine__20392__auto____0.call(this);
case 1:
return full$async$reduce_GT__$_state_machine__20392__auto____1.call(this,state_153144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$reduce_GT__$_state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$reduce_GT__$_state_machine__20392__auto____0;
full$async$reduce_GT__$_state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$reduce_GT__$_state_machine__20392__auto____1;
return full$async$reduce_GT__$_state_machine__20392__auto__;
})()
;})(switch__20391__auto__,c__20412__auto___153180,result))
})();
var state__20414__auto__ = (function (){var statearr_153179 = f__20413__auto__.call(null);
(statearr_153179[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20412__auto___153180);

return statearr_153179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20414__auto__);
});})(c__20412__auto___153180,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
full.async.concat_GT__GT_ = (function full$async$concat_GT__GT_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___153249 = arguments.length;
var i__19444__auto___153250 = (0);
while(true){
if((i__19444__auto___153250 < len__19443__auto___153249)){
args__19450__auto__.push((arguments[i__19444__auto___153250]));

var G__153251 = (i__19444__auto___153250 + (1));
i__19444__auto___153250 = G__153251;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((0) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((0)),(0),null)):null);
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__19451__auto__);
});

full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var out = cljs.core.async.chan.call(null);
var c__20412__auto___153252 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20412__auto___153252,out){
return (function (){
var f__20413__auto__ = (function (){var switch__20391__auto__ = ((function (c__20412__auto___153252,out){
return (function (state_153224){
var state_val_153225 = (state_153224[(1)]);
if((state_val_153225 === (7))){
var inst_153207 = (state_153224[(7)]);
var inst_153207__$1 = (state_153224[(2)]);
var state_153224__$1 = (function (){var statearr_153226 = state_153224;
(statearr_153226[(7)] = inst_153207__$1);

return statearr_153226;
})();
if(cljs.core.truth_(inst_153207__$1)){
var statearr_153227_153253 = state_153224__$1;
(statearr_153227_153253[(1)] = (8));

} else {
var statearr_153228_153254 = state_153224__$1;
(statearr_153228_153254[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (1))){
var inst_153202 = cs;
var state_153224__$1 = (function (){var statearr_153229 = state_153224;
(statearr_153229[(8)] = inst_153202);

return statearr_153229;
})();
var statearr_153230_153255 = state_153224__$1;
(statearr_153230_153255[(2)] = null);

(statearr_153230_153255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (4))){
var inst_153204 = (state_153224[(9)]);
var state_153224__$1 = state_153224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_153224__$1,(7),inst_153204);
} else {
if((state_val_153225 === (6))){
var inst_153220 = (state_153224[(2)]);
var state_153224__$1 = state_153224;
var statearr_153231_153256 = state_153224__$1;
(statearr_153231_153256[(2)] = inst_153220);

(statearr_153231_153256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (3))){
var inst_153222 = (state_153224[(2)]);
var state_153224__$1 = state_153224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_153224__$1,inst_153222);
} else {
if((state_val_153225 === (2))){
var inst_153202 = (state_153224[(8)]);
var inst_153204 = (state_153224[(9)]);
var inst_153204__$1 = cljs.core.first.call(null,inst_153202);
var state_153224__$1 = (function (){var statearr_153233 = state_153224;
(statearr_153233[(9)] = inst_153204__$1);

return statearr_153233;
})();
if(cljs.core.truth_(inst_153204__$1)){
var statearr_153234_153257 = state_153224__$1;
(statearr_153234_153257[(1)] = (4));

} else {
var statearr_153235_153258 = state_153224__$1;
(statearr_153235_153258[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (11))){
var inst_153202 = (state_153224[(8)]);
var inst_153210 = (state_153224[(2)]);
var tmp153232 = inst_153202;
var inst_153202__$1 = tmp153232;
var state_153224__$1 = (function (){var statearr_153236 = state_153224;
(statearr_153236[(10)] = inst_153210);

(statearr_153236[(8)] = inst_153202__$1);

return statearr_153236;
})();
var statearr_153237_153259 = state_153224__$1;
(statearr_153237_153259[(2)] = null);

(statearr_153237_153259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (9))){
var inst_153202 = (state_153224[(8)]);
var inst_153213 = cljs.core.rest.call(null,inst_153202);
var inst_153202__$1 = inst_153213;
var state_153224__$1 = (function (){var statearr_153238 = state_153224;
(statearr_153238[(8)] = inst_153202__$1);

return statearr_153238;
})();
var statearr_153239_153260 = state_153224__$1;
(statearr_153239_153260[(2)] = null);

(statearr_153239_153260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (5))){
var inst_153218 = cljs.core.async.close_BANG_.call(null,out);
var state_153224__$1 = state_153224;
var statearr_153240_153261 = state_153224__$1;
(statearr_153240_153261[(2)] = inst_153218);

(statearr_153240_153261[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (10))){
var inst_153216 = (state_153224[(2)]);
var state_153224__$1 = state_153224;
var statearr_153241_153262 = state_153224__$1;
(statearr_153241_153262[(2)] = inst_153216);

(statearr_153241_153262[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153225 === (8))){
var inst_153207 = (state_153224[(7)]);
var state_153224__$1 = state_153224;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_153224__$1,(11),out,inst_153207);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20412__auto___153252,out))
;
return ((function (switch__20391__auto__,c__20412__auto___153252,out){
return (function() {
var full$async$state_machine__20392__auto__ = null;
var full$async$state_machine__20392__auto____0 = (function (){
var statearr_153245 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_153245[(0)] = full$async$state_machine__20392__auto__);

(statearr_153245[(1)] = (1));

return statearr_153245;
});
var full$async$state_machine__20392__auto____1 = (function (state_153224){
while(true){
var ret_value__20393__auto__ = (function (){try{while(true){
var result__20394__auto__ = switch__20391__auto__.call(null,state_153224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20394__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20394__auto__;
}
break;
}
}catch (e153246){if((e153246 instanceof Object)){
var ex__20395__auto__ = e153246;
var statearr_153247_153263 = state_153224;
(statearr_153247_153263[(5)] = ex__20395__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_153224);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e153246;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20393__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__153264 = state_153224;
state_153224 = G__153264;
continue;
} else {
return ret_value__20393__auto__;
}
break;
}
});
full$async$state_machine__20392__auto__ = function(state_153224){
switch(arguments.length){
case 0:
return full$async$state_machine__20392__auto____0.call(this);
case 1:
return full$async$state_machine__20392__auto____1.call(this,state_153224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20392__auto____0;
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20392__auto____1;
return full$async$state_machine__20392__auto__;
})()
;})(switch__20391__auto__,c__20412__auto___153252,out))
})();
var state__20414__auto__ = (function (){var statearr_153248 = f__20413__auto__.call(null);
(statearr_153248[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20412__auto___153252);

return statearr_153248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20414__auto__);
});})(c__20412__auto___153252,out))
);


return out;
});

full.async.concat_GT__GT_.cljs$lang$maxFixedArity = (0);

full.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq153201){
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq153201));
});
full.async.partition_all_GT__GT_ = (function full$async$partition_all_GT__GT_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___153345 = arguments.length;
var i__19444__auto___153346 = (0);
while(true){
if((i__19444__auto___153346 < len__19443__auto___153345)){
args__19450__auto__.push((arguments[i__19444__auto___153346]));

var G__153347 = (i__19444__auto___153346 + (1));
i__19444__auto___153346 = G__153347;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((2) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((2)),(0),null)):null);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19451__auto__);
});

full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (n,in_ch,p__153268){
var map__153269 = p__153268;
var map__153269__$1 = ((((!((map__153269 == null)))?((((map__153269.cljs$lang$protocol_mask$partition0$ & (64))) || (map__153269.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__153269):map__153269);
var out_ch = cljs.core.get.call(null,map__153269__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__18374__auto__ = out_ch;
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__20412__auto___153348 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20412__auto___153348,out_ch__$1,map__153269,map__153269__$1,out_ch){
return (function (){
var f__20413__auto__ = (function (){var switch__20391__auto__ = ((function (c__20412__auto___153348,out_ch__$1,map__153269,map__153269__$1,out_ch){
return (function (state_153311){
var state_val_153312 = (state_153311[(1)]);
if((state_val_153312 === (7))){
var inst_153307 = (state_153311[(2)]);
var state_153311__$1 = state_153311;
var statearr_153313_153349 = state_153311__$1;
(statearr_153313_153349[(2)] = inst_153307);

(statearr_153313_153349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (1))){
var inst_153271 = cljs.core.PersistentVector.EMPTY;
var inst_153272 = inst_153271;
var state_153311__$1 = (function (){var statearr_153314 = state_153311;
(statearr_153314[(7)] = inst_153272);

return statearr_153314;
})();
var statearr_153315_153350 = state_153311__$1;
(statearr_153315_153350[(2)] = null);

(statearr_153315_153350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (4))){
var inst_153275 = (state_153311[(8)]);
var inst_153275__$1 = (state_153311[(2)]);
var state_153311__$1 = (function (){var statearr_153316 = state_153311;
(statearr_153316[(8)] = inst_153275__$1);

return statearr_153316;
})();
if(cljs.core.truth_(inst_153275__$1)){
var statearr_153317_153351 = state_153311__$1;
(statearr_153317_153351[(1)] = (5));

} else {
var statearr_153318_153352 = state_153311__$1;
(statearr_153318_153352[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (15))){
var inst_153288 = (state_153311[(2)]);
var inst_153289 = cljs.core.PersistentVector.EMPTY;
var inst_153272 = inst_153289;
var state_153311__$1 = (function (){var statearr_153319 = state_153311;
(statearr_153319[(7)] = inst_153272);

(statearr_153319[(9)] = inst_153288);

return statearr_153319;
})();
var statearr_153320_153353 = state_153311__$1;
(statearr_153320_153353[(2)] = null);

(statearr_153320_153353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (13))){
var inst_153283 = (state_153311[(10)]);
var inst_153272 = inst_153283;
var state_153311__$1 = (function (){var statearr_153321 = state_153311;
(statearr_153321[(7)] = inst_153272);

return statearr_153321;
})();
var statearr_153322_153354 = state_153311__$1;
(statearr_153322_153354[(2)] = null);

(statearr_153322_153354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (6))){
var inst_153272 = (state_153311[(7)]);
var inst_153298 = cljs.core.not_empty.call(null,inst_153272);
var state_153311__$1 = state_153311;
if(cljs.core.truth_(inst_153298)){
var statearr_153323_153355 = state_153311__$1;
(statearr_153323_153355[(1)] = (16));

} else {
var statearr_153324_153356 = state_153311__$1;
(statearr_153324_153356[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (17))){
var state_153311__$1 = state_153311;
var statearr_153325_153357 = state_153311__$1;
(statearr_153325_153357[(2)] = null);

(statearr_153325_153357[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (3))){
var inst_153309 = (state_153311[(2)]);
var state_153311__$1 = state_153311;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_153311__$1,inst_153309);
} else {
if((state_val_153312 === (12))){
var inst_153283 = (state_153311[(10)]);
var state_153311__$1 = state_153311;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_153311__$1,(15),out_ch__$1,inst_153283);
} else {
if((state_val_153312 === (2))){
var state_153311__$1 = state_153311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_153311__$1,(4),in_ch);
} else {
if((state_val_153312 === (19))){
var inst_153301 = (state_153311[(2)]);
var state_153311__$1 = state_153311;
var statearr_153326_153358 = state_153311__$1;
(statearr_153326_153358[(2)] = inst_153301);

(statearr_153326_153358[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (11))){
var inst_153280 = (state_153311[(2)]);
var inst_153281 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_153311__$1 = (function (){var statearr_153327 = state_153311;
(statearr_153327[(11)] = inst_153280);

return statearr_153327;
})();
var statearr_153328_153359 = state_153311__$1;
(statearr_153328_153359[(2)] = inst_153281);

(statearr_153328_153359[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (9))){
var inst_153275 = (state_153311[(8)]);
var inst_153272 = (state_153311[(7)]);
var inst_153283 = (state_153311[(10)]);
var inst_153283__$1 = cljs.core.conj.call(null,inst_153272,inst_153275);
var inst_153284 = cljs.core.count.call(null,inst_153283__$1);
var inst_153285 = cljs.core._EQ_.call(null,n,inst_153284);
var state_153311__$1 = (function (){var statearr_153329 = state_153311;
(statearr_153329[(10)] = inst_153283__$1);

return statearr_153329;
})();
if(inst_153285){
var statearr_153330_153360 = state_153311__$1;
(statearr_153330_153360[(1)] = (12));

} else {
var statearr_153331_153361 = state_153311__$1;
(statearr_153331_153361[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (5))){
var inst_153275 = (state_153311[(8)]);
var inst_153277 = (inst_153275 instanceof Error);
var state_153311__$1 = state_153311;
if(cljs.core.truth_(inst_153277)){
var statearr_153332_153362 = state_153311__$1;
(statearr_153332_153362[(1)] = (8));

} else {
var statearr_153333_153363 = state_153311__$1;
(statearr_153333_153363[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (14))){
var inst_153294 = (state_153311[(2)]);
var state_153311__$1 = state_153311;
var statearr_153334_153364 = state_153311__$1;
(statearr_153334_153364[(2)] = inst_153294);

(statearr_153334_153364[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (16))){
var inst_153272 = (state_153311[(7)]);
var state_153311__$1 = state_153311;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_153311__$1,(19),out_ch__$1,inst_153272);
} else {
if((state_val_153312 === (10))){
var inst_153296 = (state_153311[(2)]);
var state_153311__$1 = state_153311;
var statearr_153335_153365 = state_153311__$1;
(statearr_153335_153365[(2)] = inst_153296);

(statearr_153335_153365[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (18))){
var inst_153304 = (state_153311[(2)]);
var inst_153305 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_153311__$1 = (function (){var statearr_153336 = state_153311;
(statearr_153336[(12)] = inst_153304);

return statearr_153336;
})();
var statearr_153337_153366 = state_153311__$1;
(statearr_153337_153366[(2)] = inst_153305);

(statearr_153337_153366[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_153312 === (8))){
var inst_153275 = (state_153311[(8)]);
var state_153311__$1 = state_153311;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_153311__$1,(11),out_ch__$1,inst_153275);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20412__auto___153348,out_ch__$1,map__153269,map__153269__$1,out_ch))
;
return ((function (switch__20391__auto__,c__20412__auto___153348,out_ch__$1,map__153269,map__153269__$1,out_ch){
return (function() {
var full$async$state_machine__20392__auto__ = null;
var full$async$state_machine__20392__auto____0 = (function (){
var statearr_153341 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_153341[(0)] = full$async$state_machine__20392__auto__);

(statearr_153341[(1)] = (1));

return statearr_153341;
});
var full$async$state_machine__20392__auto____1 = (function (state_153311){
while(true){
var ret_value__20393__auto__ = (function (){try{while(true){
var result__20394__auto__ = switch__20391__auto__.call(null,state_153311);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20394__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20394__auto__;
}
break;
}
}catch (e153342){if((e153342 instanceof Object)){
var ex__20395__auto__ = e153342;
var statearr_153343_153367 = state_153311;
(statearr_153343_153367[(5)] = ex__20395__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_153311);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e153342;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20393__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__153368 = state_153311;
state_153311 = G__153368;
continue;
} else {
return ret_value__20393__auto__;
}
break;
}
});
full$async$state_machine__20392__auto__ = function(state_153311){
switch(arguments.length){
case 0:
return full$async$state_machine__20392__auto____0.call(this);
case 1:
return full$async$state_machine__20392__auto____1.call(this,state_153311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20392__auto____0;
full$async$state_machine__20392__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20392__auto____1;
return full$async$state_machine__20392__auto__;
})()
;})(switch__20391__auto__,c__20412__auto___153348,out_ch__$1,map__153269,map__153269__$1,out_ch))
})();
var state__20414__auto__ = (function (){var statearr_153344 = f__20413__auto__.call(null);
(statearr_153344[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20412__auto___153348);

return statearr_153344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20414__auto__);
});})(c__20412__auto___153348,out_ch__$1,map__153269,map__153269__$1,out_ch))
);


return out_ch__$1;
});

full.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (2);

full.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq153265){
var G__153266 = cljs.core.first.call(null,seq153265);
var seq153265__$1 = cljs.core.next.call(null,seq153265);
var G__153267 = cljs.core.first.call(null,seq153265__$1);
var seq153265__$2 = cljs.core.next.call(null,seq153265__$1);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__153266,G__153267,seq153265__$2);
});
/**
 * Counts items in a channel. Returns a channel with the item count.
 */
full.async.count_GT_ = (function full$async$count_GT_(ch){
return cljs.core.async.reduce.call(null,(function (acc,_){
return (acc + (1));
}),(0),ch);
});

//# sourceMappingURL=async.js.map