// Compiled by ClojureScript 1.8.34 {}
goog.provide('full.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
full.async.cljs_env_QMARK_ = (function full$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
full.async.PSupervisor = function(){};

full.async._error = (function full$async$_error(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_error$arity$1 == null)))){
return this$.full$async$PSupervisor$_error$arity$1(this$);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._error[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$);
} else {
var m__19038__auto____$1 = (full.async._error["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

full.async._abort = (function full$async$_abort(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_abort$arity$1 == null)))){
return this$.full$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._abort[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$);
} else {
var m__19038__auto____$1 = (full.async._abort["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

full.async._register_go = (function full$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._register_go[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,body);
} else {
var m__19038__auto____$1 = (full.async._register_go["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

full.async._unregister_go = (function full$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._unregister_go[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,id);
} else {
var m__19038__auto____$1 = (full.async._unregister_go["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

full.async._track_exception = (function full$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._track_exception[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,e);
} else {
var m__19038__auto____$1 = (full.async._track_exception["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

full.async._free_exception = (function full$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._free_exception[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,e);
} else {
var m__19038__auto____$1 = (full.async._free_exception["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

full.async.now = (function full$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {full.async.PSupervisor}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
full.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__18996__auto__,k__18997__auto__){
var self__ = this;
var this__18996__auto____$1 = this;
return cljs.core._lookup.call(null,this__18996__auto____$1,k__18997__auto__,null);
});

full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__18998__auto__,k24324,else__18999__auto__){
var self__ = this;
var this__18998__auto____$1 = this;
var G__24326 = (((k24324 instanceof cljs.core.Keyword))?k24324.fqn:null);
switch (G__24326) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k24324,else__18999__auto__);

}
});

full.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19010__auto__,writer__19011__auto__,opts__19012__auto__){
var self__ = this;
var this__19010__auto____$1 = this;
var pr_pair__19013__auto__ = ((function (this__19010__auto____$1){
return (function (keyval__19014__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19011__auto__,cljs.core.pr_writer,""," ","",opts__19012__auto__,keyval__19014__auto__);
});})(this__19010__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19011__auto__,pr_pair__19013__auto__,"#full.async.TrackingSupervisor{",", ","}",opts__19012__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = true;

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__24323){
var self__ = this;
var G__24323__$1 = this;
return (new cljs.core.RecordIter((0),G__24323__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

full.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__18994__auto__){
var self__ = this;
var this__18994__auto____$1 = this;
return self__.__meta;
});

full.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__18990__auto__){
var self__ = this;
var this__18990__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19000__auto__){
var self__ = this;
var this__19000__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__18991__auto__){
var self__ = this;
var this__18991__auto____$1 = this;
var h__18809__auto__ = self__.__hash;
if(!((h__18809__auto__ == null))){
return h__18809__auto__;
} else {
var h__18809__auto____$1 = cljs.core.hash_imap.call(null,this__18991__auto____$1);
self__.__hash = h__18809__auto____$1;

return h__18809__auto____$1;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__18992__auto__,other__18993__auto__){
var self__ = this;
var this__18992__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18362__auto__ = other__18993__auto__;
if(cljs.core.truth_(and__18362__auto__)){
var and__18362__auto____$1 = (this__18992__auto____$1.constructor === other__18993__auto__.constructor);
if(and__18362__auto____$1){
return cljs.core.equiv_map.call(null,this__18992__auto____$1,other__18993__auto__);
} else {
return and__18362__auto____$1;
}
} else {
return and__18362__auto__;
}
})())){
return true;
} else {
return false;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19005__auto__,k__19006__auto__){
var self__ = this;
var this__19005__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__19006__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19005__auto____$1),self__.__meta),k__19006__auto__);
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19006__auto__)),null));
}
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$ = true;

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,full.async.now.call(null));
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

full.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19003__auto__,k__19004__auto__,G__24323){
var self__ = this;
var this__19003__auto____$1 = this;
var pred__24327 = cljs.core.keyword_identical_QMARK_;
var expr__24328 = k__19004__auto__;
if(cljs.core.truth_(pred__24327.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__24328))){
return (new full.async.TrackingSupervisor(G__24323,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__24327.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__24328))){
return (new full.async.TrackingSupervisor(self__.error,G__24323,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__24327.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__24328))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,G__24323,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__24327.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__24328))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__24323,self__.__meta,self__.__extmap,null));
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19004__auto__,G__24323),null));
}
}
}
}
});

full.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19008__auto__){
var self__ = this;
var this__19008__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__18995__auto__,G__24323){
var self__ = this;
var this__18995__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__24323,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19001__auto__,entry__19002__auto__){
var self__ = this;
var this__19001__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19002__auto__)){
return cljs.core._assoc.call(null,this__19001__auto____$1,cljs.core._nth.call(null,entry__19002__auto__,(0)),cljs.core._nth.call(null,entry__19002__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19001__auto____$1,entry__19002__auto__);
}
});

full.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

full.async.TrackingSupervisor.cljs$lang$type = true;

full.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__19030__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"full.async/TrackingSupervisor");
});

full.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__19030__auto__,writer__19031__auto__){
return cljs.core._write.call(null,writer__19031__auto__,"full.async/TrackingSupervisor");
});

full.async.__GT_TrackingSupervisor = (function full$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new full.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

full.async.map__GT_TrackingSupervisor = (function full$async$map__GT_TrackingSupervisor(G__24325){
return (new full.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__24325),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__24325),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__24325),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__24325),null,cljs.core.dissoc.call(null,G__24325,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

full.async._STAR_super_STAR_ = (function (){var err_ch = cljs.core.async.chan.call(null);
var stale_timeout = ((60) * (1000));
var s = full.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),err_ch,new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var c__20554__auto___24402 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___24402,err_ch,stale_timeout,s){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___24402,err_ch,stale_timeout,s){
return (function (state_24345){
var state_val_24346 = (state_24345[(1)]);
if((state_val_24346 === (1))){
var state_24345__$1 = state_24345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24345__$1,(2),err_ch);
} else {
if((state_val_24346 === (2))){
var inst_24332 = (state_24345[(2)]);
var inst_24333 = inst_24332;
var state_24345__$1 = (function (){var statearr_24347 = state_24345;
(statearr_24347[(7)] = inst_24333);

return statearr_24347;
})();
var statearr_24348_24403 = state_24345__$1;
(statearr_24348_24403[(2)] = null);

(statearr_24348_24403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24346 === (3))){
var inst_24335 = cljs.core.async.timeout.call(null,(100));
var state_24345__$1 = state_24345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24345__$1,(5),inst_24335);
} else {
if((state_val_24346 === (4))){
var inst_24343 = (state_24345[(2)]);
var state_24345__$1 = state_24345;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24345__$1,inst_24343);
} else {
if((state_val_24346 === (5))){
var inst_24333 = (state_24345[(7)]);
var inst_24337 = (state_24345[(2)]);
var inst_24338 = cljs.core.println.call(null,"Global supervisor:",inst_24333);
var state_24345__$1 = (function (){var statearr_24349 = state_24345;
(statearr_24349[(8)] = inst_24337);

(statearr_24349[(9)] = inst_24338);

return statearr_24349;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24345__$1,(6),err_ch);
} else {
if((state_val_24346 === (6))){
var inst_24340 = (state_24345[(2)]);
var inst_24333 = inst_24340;
var state_24345__$1 = (function (){var statearr_24350 = state_24345;
(statearr_24350[(7)] = inst_24333);

return statearr_24350;
})();
var statearr_24351_24404 = state_24345__$1;
(statearr_24351_24404[(2)] = null);

(statearr_24351_24404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});})(c__20554__auto___24402,err_ch,stale_timeout,s))
;
return ((function (switch__20400__auto__,c__20554__auto___24402,err_ch,stale_timeout,s){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24355 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24355[(0)] = full$async$state_machine__20401__auto__);

(statearr_24355[(1)] = (1));

return statearr_24355;
});
var full$async$state_machine__20401__auto____1 = (function (state_24345){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24356){if((e24356 instanceof Object)){
var ex__20404__auto__ = e24356;
var statearr_24357_24405 = state_24345;
(statearr_24357_24405[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24345);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24356;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24406 = state_24345;
state_24345 = G__24406;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24345){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___24402,err_ch,stale_timeout,s))
})();
var state__20556__auto__ = (function (){var statearr_24358 = f__20555__auto__.call(null);
(statearr_24358[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24402);

return statearr_24358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___24402,err_ch,stale_timeout,s))
);


var c__20554__auto___24407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___24407,err_ch,stale_timeout,s){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___24407,err_ch,stale_timeout,s){
return (function (state_24383){
var state_val_24384 = (state_24383[(1)]);
if((state_val_24384 === (1))){
var state_24383__$1 = state_24383;
var statearr_24385_24408 = state_24383__$1;
(statearr_24385_24408[(2)] = null);

(statearr_24385_24408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24384 === (2))){
var inst_24360 = cljs.core.async.timeout.call(null,stale_timeout);
var state_24383__$1 = state_24383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24383__$1,(4),inst_24360);
} else {
if((state_val_24384 === (3))){
var inst_24381 = (state_24383[(2)]);
var state_24383__$1 = state_24383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24383__$1,inst_24381);
} else {
if((state_val_24384 === (4))){
var inst_24371 = (state_24383[(7)]);
var inst_24362 = (state_24383[(2)]);
var inst_24366 = (function (){return ((function (inst_24371,inst_24362,state_val_24384,c__20554__auto___24407,err_ch,stale_timeout,s){
return (function (p__24365){
var vec__24386 = p__24365;
var k = cljs.core.nth.call(null,vec__24386,(0),null);
var v = cljs.core.nth.call(null,vec__24386,(1),null);
return ((full.async.now.getTime() - stale_timeout) > v.getTime());
});
;})(inst_24371,inst_24362,state_val_24384,c__20554__auto___24407,err_ch,stale_timeout,s))
})();
var inst_24367 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_24368 = cljs.core.deref.call(null,inst_24367);
var inst_24369 = cljs.core.filter.call(null,inst_24366,inst_24368);
var inst_24370 = cljs.core.nth.call(null,inst_24369,(0),null);
var inst_24371__$1 = cljs.core.nth.call(null,inst_24370,(0),null);
var inst_24372 = cljs.core.nth.call(null,inst_24370,(1),null);
var state_24383__$1 = (function (){var statearr_24387 = state_24383;
(statearr_24387[(8)] = inst_24372);

(statearr_24387[(9)] = inst_24362);

(statearr_24387[(7)] = inst_24371__$1);

return statearr_24387;
})();
if(cljs.core.truth_(inst_24371__$1)){
var statearr_24388_24409 = state_24383__$1;
(statearr_24388_24409[(1)] = (5));

} else {
var statearr_24389_24410 = state_24383__$1;
(statearr_24389_24410[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24384 === (5))){
var inst_24371 = (state_24383[(7)]);
var inst_24374 = cljs.core.println.call(null,"Global supervisor detected stale error:",inst_24371);
var inst_24375 = full.async._free_exception.call(null,s,inst_24371);
var state_24383__$1 = (function (){var statearr_24390 = state_24383;
(statearr_24390[(10)] = inst_24374);

return statearr_24390;
})();
var statearr_24391_24411 = state_24383__$1;
(statearr_24391_24411[(2)] = inst_24375);

(statearr_24391_24411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24384 === (6))){
var state_24383__$1 = state_24383;
var statearr_24392_24412 = state_24383__$1;
(statearr_24392_24412[(2)] = null);

(statearr_24392_24412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24384 === (7))){
var inst_24378 = (state_24383[(2)]);
var state_24383__$1 = (function (){var statearr_24393 = state_24383;
(statearr_24393[(11)] = inst_24378);

return statearr_24393;
})();
var statearr_24394_24413 = state_24383__$1;
(statearr_24394_24413[(2)] = null);

(statearr_24394_24413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20554__auto___24407,err_ch,stale_timeout,s))
;
return ((function (switch__20400__auto__,c__20554__auto___24407,err_ch,stale_timeout,s){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24398 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24398[(0)] = full$async$state_machine__20401__auto__);

(statearr_24398[(1)] = (1));

return statearr_24398;
});
var full$async$state_machine__20401__auto____1 = (function (state_24383){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24399){if((e24399 instanceof Object)){
var ex__20404__auto__ = e24399;
var statearr_24400_24414 = state_24383;
(statearr_24400_24414[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24399;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24415 = state_24383;
state_24383 = G__24415;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24383){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___24407,err_ch,stale_timeout,s))
})();
var state__20556__auto__ = (function (){var statearr_24401 = f__20555__auto__.call(null);
(statearr_24401[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24407);

return statearr_24401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___24407,err_ch,stale_timeout,s))
);


return s;
})();
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
full.async.throw_if_exception = (function full$async$throw_if_exception(x){
if((x instanceof Error)){
full.async._free_exception.call(null,full.async._STAR_super_STAR_,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__18374__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.take_QMARK_ = (function full$async$take_QMARK_(var_args){
var args24433 = [];
var len__19443__auto___24436 = arguments.length;
var i__19444__auto___24437 = (0);
while(true){
if((i__19444__auto___24437 < len__19443__auto___24436)){
args24433.push((arguments[i__19444__auto___24437]));

var G__24438 = (i__19444__auto___24437 + (1));
i__19444__auto___24437 = G__24438;
continue;
} else {
}
break;
}

var G__24435 = args24433.length;
switch (G__24435) {
case 2:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24433.length)].join('')));

}
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return full.async.take_QMARK_.call(null,port,fn1,true);
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var super$ = full.async._STAR_super_STAR_;
return cljs.core.async.take_BANG_.call(null,port,((function (super$){
return (function (v){
if((v instanceof Error)){
full.async._free_exception.call(null,super$,v);
} else {
}

return fn1.call(null,v);
});})(super$))
,on_caller_QMARK_);
});

full.async.take_QMARK_.cljs$lang$maxFixedArity = 3;
/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.put_QMARK_ = (function full$async$put_QMARK_(var_args){
var args24440 = [];
var len__19443__auto___24443 = arguments.length;
var i__19444__auto___24444 = (0);
while(true){
if((i__19444__auto___24444 < len__19443__auto___24443)){
args24440.push((arguments[i__19444__auto___24444]));

var G__24445 = (i__19444__auto___24444 + (1));
i__19444__auto___24444 = G__24445;
continue;
} else {
}
break;
}

var G__24442 = args24440.length;
switch (G__24442) {
case 2:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24440.length)].join('')));

}
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
return full.async.put_QMARK_.call(null,port,val,(function full$async$noop(_){
return null;
}));
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return full.async.put_QMARK_.call(null,port,val,fn1,true);
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
full.async._track_exception.call(null,full.async._STAR_super_STAR_,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

full.async.put_QMARK_.cljs$lang$maxFixedArity = 4;
/**
 * Same as core.async alts! but throws an exception if the channel returns a
 *   throwable object or the context has been aborted.
 */
full.async.alts_QMARK_ = (function full$async$alts_QMARK_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___24451 = arguments.length;
var i__19444__auto___24452 = (0);
while(true){
if((i__19444__auto___24452 < len__19443__auto___24451)){
args__19450__auto__.push((arguments[i__19444__auto___24452]));

var G__24453 = (i__19444__auto___24452 + (1));
i__19444__auto___24452 = G__24453;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((1) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((1)),(0),null)):null);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19451__auto__);
});

full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,opts){
return full.async.throw_if_exception.call(null,(function (){var abort__23601__auto__ = full.async._abort.call(null,full.async._STAR_super_STAR_);
var to__23602__auto__ = cljs.core.apply.call(null,cljs.core.async.timeout,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null));
var vec__24449 = cljs.core.async.alts_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [abort__23601__auto__,to__23602__auto__], null),new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var val__23603__auto__ = cljs.core.nth.call(null,vec__24449,(0),null);
var port__23604__auto__ = cljs.core.nth.call(null,vec__24449,(1),null);
if(cljs.core._EQ_.call(null,port__23604__auto__,abort__23601__auto__)){
return cljs.core.ex_info.call(null,"Aborted operations",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"aborted","aborted",1775972619)], null));
} else {
var vec__24450 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var val = cljs.core.nth.call(null,vec__24450,(0),null);
var port = cljs.core.nth.call(null,vec__24450,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [full.async.throw_if_exception.call(null,val),port], null);
}
})());
});

full.async.alts_QMARK_.cljs$lang$maxFixedArity = (1);

full.async.alts_QMARK_.cljs$lang$applyTo = (function (seq24447){
var G__24448 = cljs.core.first.call(null,seq24447);
var seq24447__$1 = cljs.core.next.call(null,seq24447);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__24448,seq24447__$1);
});
/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
full.async.pmap_GT__GT_ = (function full$async$pmap_GT__GT_(var_args){
var args24462 = [];
var len__19443__auto___24584 = arguments.length;
var i__19444__auto___24585 = (0);
while(true){
if((i__19444__auto___24585 < len__19443__auto___24584)){
args24462.push((arguments[i__19444__auto___24585]));

var G__24586 = (i__19444__auto___24585 + (1));
i__19444__auto___24585 = G__24586;
continue;
} else {
}
break;
}

var G__24464 = args24462.length;
switch (G__24464) {
case 3:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24462.length)].join('')));

}
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3 = (function (f_GT_,parallelism,in_ch){
return full.async.pmap_GT__GT_.call(null,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__19288__auto___24588 = parallelism;
var __24589 = (0);
while(true){
if((__24589 < n__19288__auto___24588)){
var c__20554__auto___24590 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__24589,c__20554__auto___24590,n__19288__auto___24588,threads){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (__24589,c__20554__auto___24590,n__19288__auto___24588,threads){
return (function (state_24542){
var state_val_24543 = (state_24542[(1)]);
if((state_val_24543 === (7))){
var inst_24531 = (state_24542[(2)]);
var state_24542__$1 = state_24542;
var statearr_24544_24591 = state_24542__$1;
(statearr_24544_24591[(2)] = inst_24531);

(statearr_24544_24591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (20))){
var inst_24521 = (state_24542[(2)]);
var inst_24522 = full.async.throw_if_exception.call(null,inst_24521);
var state_24542__$1 = state_24542;
var statearr_24545_24592 = state_24542__$1;
(statearr_24545_24592[(2)] = inst_24522);

(statearr_24545_24592[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (1))){
var state_24542__$1 = state_24542;
var statearr_24546_24593 = state_24542__$1;
(statearr_24546_24593[(2)] = null);

(statearr_24546_24593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (4))){
var inst_24467 = (state_24542[(7)]);
var inst_24467__$1 = (state_24542[(2)]);
var state_24542__$1 = (function (){var statearr_24547 = state_24542;
(statearr_24547[(7)] = inst_24467__$1);

return statearr_24547;
})();
if(cljs.core.truth_(inst_24467__$1)){
var statearr_24548_24594 = state_24542__$1;
(statearr_24548_24594[(1)] = (5));

} else {
var statearr_24549_24595 = state_24542__$1;
(statearr_24549_24595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (15))){
var inst_24501 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24503 = [(0)];
var inst_24504 = (new cljs.core.PersistentVector(null,1,(5),inst_24502,inst_24503,null));
var inst_24505 = cljs.core.apply.call(null,cljs.core.async.timeout,inst_24504);
var inst_24506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24507 = [inst_24501,inst_24505];
var inst_24508 = (new cljs.core.PersistentVector(null,2,(5),inst_24506,inst_24507,null));
var inst_24509 = cljs.core.async.alts_BANG_.call(null,inst_24508,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var inst_24510 = cljs.core.nth.call(null,inst_24509,(0),null);
var inst_24511 = cljs.core.nth.call(null,inst_24509,(1),null);
var inst_24512 = cljs.core._EQ_.call(null,inst_24511,inst_24501);
var state_24542__$1 = (function (){var statearr_24550 = state_24542;
(statearr_24550[(8)] = inst_24510);

return statearr_24550;
})();
if(inst_24512){
var statearr_24551_24596 = state_24542__$1;
(statearr_24551_24596[(1)] = (18));

} else {
var statearr_24552_24597 = state_24542__$1;
(statearr_24552_24597[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (21))){
var inst_24537 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_24542__$1 = state_24542;
var statearr_24553_24598 = state_24542__$1;
(statearr_24553_24598[(2)] = inst_24537);

(statearr_24553_24598[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (13))){
var inst_24492 = (state_24542[(2)]);
var inst_24493 = full.async.throw_if_exception.call(null,inst_24492);
var inst_24494 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_24542__$1 = (function (){var statearr_24554 = state_24542;
(statearr_24554[(9)] = inst_24493);

return statearr_24554;
})();
var statearr_24555_24599 = state_24542__$1;
(statearr_24555_24599[(2)] = inst_24494);

(statearr_24555_24599[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (22))){
var state_24542__$1 = state_24542;
var statearr_24556_24600 = state_24542__$1;
(statearr_24556_24600[(2)] = null);

(statearr_24556_24600[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (6))){
var state_24542__$1 = state_24542;
var statearr_24557_24601 = state_24542__$1;
(statearr_24557_24601[(2)] = null);

(statearr_24557_24601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (17))){
var inst_24525 = (state_24542[(2)]);
var state_24542__$1 = (function (){var statearr_24558 = state_24542;
(statearr_24558[(10)] = inst_24525);

return statearr_24558;
})();
var statearr_24559_24602 = state_24542__$1;
(statearr_24559_24602[(2)] = null);

(statearr_24559_24602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (3))){
var inst_24533 = (state_24542[(2)]);
var inst_24534 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_24535 = (inst_24534 === (0));
var state_24542__$1 = (function (){var statearr_24560 = state_24542;
(statearr_24560[(11)] = inst_24533);

return statearr_24560;
})();
if(cljs.core.truth_(inst_24535)){
var statearr_24561_24603 = state_24542__$1;
(statearr_24561_24603[(1)] = (21));

} else {
var statearr_24562_24604 = state_24542__$1;
(statearr_24562_24604[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (12))){
var inst_24467 = (state_24542[(7)]);
var inst_24490 = cljs.core.async_GT__BANG_.call(null,out_ch,inst_24467);
var state_24542__$1 = state_24542;
var statearr_24563_24605 = state_24542__$1;
(statearr_24563_24605[(2)] = inst_24490);

(statearr_24563_24605[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (2))){
var state_24542__$1 = state_24542;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24542__$1,(4),in_ch);
} else {
if((state_val_24543 === (23))){
var inst_24540 = (state_24542[(2)]);
var state_24542__$1 = state_24542;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24542__$1,inst_24540);
} else {
if((state_val_24543 === (19))){
var inst_24498 = (state_24542[(12)]);
var inst_24519 = cljs.core.async_GT__BANG_.call(null,out_ch,inst_24498);
var state_24542__$1 = state_24542;
var statearr_24564_24606 = state_24542__$1;
(statearr_24564_24606[(2)] = inst_24519);

(statearr_24564_24606[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (11))){
var inst_24485 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24486 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24487 = cljs.core.PersistentHashMap.fromArrays(inst_24485,inst_24486);
var inst_24488 = cljs.core.ex_info.call(null,"Aborted operations",inst_24487);
var state_24542__$1 = state_24542;
var statearr_24565_24607 = state_24542__$1;
(statearr_24565_24607[(2)] = inst_24488);

(statearr_24565_24607[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (9))){
var inst_24467 = (state_24542[(7)]);
var inst_24496 = f_GT_.call(null,inst_24467);
var state_24542__$1 = state_24542;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24542__$1,(14),inst_24496);
} else {
if((state_val_24543 === (5))){
var inst_24467 = (state_24542[(7)]);
var inst_24469 = (inst_24467 instanceof Error);
var state_24542__$1 = state_24542;
if(cljs.core.truth_(inst_24469)){
var statearr_24566_24608 = state_24542__$1;
(statearr_24566_24608[(1)] = (8));

} else {
var statearr_24567_24609 = state_24542__$1;
(statearr_24567_24609[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (14))){
var inst_24498 = (state_24542[(12)]);
var inst_24498__$1 = (state_24542[(2)]);
var state_24542__$1 = (function (){var statearr_24568 = state_24542;
(statearr_24568[(12)] = inst_24498__$1);

return statearr_24568;
})();
if(cljs.core.truth_(inst_24498__$1)){
var statearr_24569_24610 = state_24542__$1;
(statearr_24569_24610[(1)] = (15));

} else {
var statearr_24570_24611 = state_24542__$1;
(statearr_24570_24611[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (16))){
var state_24542__$1 = state_24542;
var statearr_24571_24612 = state_24542__$1;
(statearr_24571_24612[(2)] = null);

(statearr_24571_24612[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (10))){
var inst_24528 = (state_24542[(2)]);
var state_24542__$1 = state_24542;
var statearr_24572_24613 = state_24542__$1;
(statearr_24572_24613[(2)] = inst_24528);

(statearr_24572_24613[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (18))){
var inst_24514 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24515 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24516 = cljs.core.PersistentHashMap.fromArrays(inst_24514,inst_24515);
var inst_24517 = cljs.core.ex_info.call(null,"Aborted operations",inst_24516);
var state_24542__$1 = state_24542;
var statearr_24573_24614 = state_24542__$1;
(statearr_24573_24614[(2)] = inst_24517);

(statearr_24573_24614[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24543 === (8))){
var inst_24472 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24474 = [(0)];
var inst_24475 = (new cljs.core.PersistentVector(null,1,(5),inst_24473,inst_24474,null));
var inst_24476 = cljs.core.apply.call(null,cljs.core.async.timeout,inst_24475);
var inst_24477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24478 = [inst_24472,inst_24476];
var inst_24479 = (new cljs.core.PersistentVector(null,2,(5),inst_24477,inst_24478,null));
var inst_24480 = cljs.core.async.alts_BANG_.call(null,inst_24479,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var inst_24481 = cljs.core.nth.call(null,inst_24480,(0),null);
var inst_24482 = cljs.core.nth.call(null,inst_24480,(1),null);
var inst_24483 = cljs.core._EQ_.call(null,inst_24482,inst_24472);
var state_24542__$1 = (function (){var statearr_24574 = state_24542;
(statearr_24574[(13)] = inst_24481);

return statearr_24574;
})();
if(inst_24483){
var statearr_24575_24615 = state_24542__$1;
(statearr_24575_24615[(1)] = (11));

} else {
var statearr_24576_24616 = state_24542__$1;
(statearr_24576_24616[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__24589,c__20554__auto___24590,n__19288__auto___24588,threads))
;
return ((function (__24589,switch__20400__auto__,c__20554__auto___24590,n__19288__auto___24588,threads){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24580 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24580[(0)] = full$async$state_machine__20401__auto__);

(statearr_24580[(1)] = (1));

return statearr_24580;
});
var full$async$state_machine__20401__auto____1 = (function (state_24542){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24542);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24581){if((e24581 instanceof Object)){
var ex__20404__auto__ = e24581;
var statearr_24582_24617 = state_24542;
(statearr_24582_24617[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24542);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24581;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24618 = state_24542;
state_24542 = G__24618;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24542){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(__24589,switch__20400__auto__,c__20554__auto___24590,n__19288__auto___24588,threads))
})();
var state__20556__auto__ = (function (){var statearr_24583 = f__20555__auto__.call(null);
(statearr_24583[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24590);

return statearr_24583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(__24589,c__20554__auto___24590,n__19288__auto___24588,threads))
);


var G__24619 = (__24589 + (1));
__24589 = G__24619;
continue;
} else {
}
break;
}

return out_ch;
});

full.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 4;
/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
full.async.engulf = (function full$async$engulf(var_args){
var args__19450__auto__ = [];
var len__19443__auto___24647 = arguments.length;
var i__19444__auto___24648 = (0);
while(true){
if((i__19444__auto___24648 < len__19443__auto___24647)){
args__19450__auto__.push((arguments[i__19444__auto___24648]));

var G__24649 = (i__19444__auto___24648 + (1));
i__19444__auto___24648 = G__24649;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((0) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((0)),(0),null)):null);
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(argseq__19451__auto__);
});

full.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__,ch){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__,ch){
return (function (state_24632){
var state_val_24633 = (state_24632[(1)]);
if((state_val_24633 === (1))){
var state_24632__$1 = state_24632;
var statearr_24634_24650 = state_24632__$1;
(statearr_24634_24650[(2)] = null);

(statearr_24634_24650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24633 === (2))){
var state_24632__$1 = state_24632;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24632__$1,(4),ch);
} else {
if((state_val_24633 === (3))){
var inst_24630 = (state_24632[(2)]);
var state_24632__$1 = state_24632;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24632__$1,inst_24630);
} else {
if((state_val_24633 === (4))){
var inst_24623 = (state_24632[(2)]);
var state_24632__$1 = state_24632;
if(cljs.core.truth_(inst_24623)){
var statearr_24635_24651 = state_24632__$1;
(statearr_24635_24651[(1)] = (5));

} else {
var statearr_24636_24652 = state_24632__$1;
(statearr_24636_24652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24633 === (5))){
var state_24632__$1 = state_24632;
var statearr_24637_24653 = state_24632__$1;
(statearr_24637_24653[(2)] = null);

(statearr_24637_24653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24633 === (6))){
var state_24632__$1 = state_24632;
var statearr_24638_24654 = state_24632__$1;
(statearr_24638_24654[(2)] = null);

(statearr_24638_24654[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24633 === (7))){
var inst_24628 = (state_24632[(2)]);
var state_24632__$1 = state_24632;
var statearr_24639_24655 = state_24632__$1;
(statearr_24639_24655[(2)] = inst_24628);

(statearr_24639_24655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20554__auto__,ch))
;
return ((function (switch__20400__auto__,c__20554__auto__,ch){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24643 = [null,null,null,null,null,null,null];
(statearr_24643[(0)] = full$async$state_machine__20401__auto__);

(statearr_24643[(1)] = (1));

return statearr_24643;
});
var full$async$state_machine__20401__auto____1 = (function (state_24632){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24644){if((e24644 instanceof Object)){
var ex__20404__auto__ = e24644;
var statearr_24645_24656 = state_24632;
(statearr_24645_24656[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24632);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24644;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24657 = state_24632;
state_24632 = G__24657;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24632){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__,ch))
})();
var state__20556__auto__ = (function (){var statearr_24646 = f__20555__auto__.call(null);
(statearr_24646[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_24646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__,ch))
);

return c__20554__auto__;
});

full.async.engulf.cljs$lang$maxFixedArity = (0);

full.async.engulf.cljs$lang$applyTo = (function (seq24620){
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq24620));
});
/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
full.async.reduce_GT_ = (function full$async$reduce_GT_(f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__20554__auto___24862 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___24862,result){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___24862,result){
return (function (state_24828){
var state_val_24829 = (state_24828[(1)]);
if((state_val_24829 === (7))){
var inst_24824 = (state_24828[(2)]);
var state_24828__$1 = state_24828;
var statearr_24830_24863 = state_24828__$1;
(statearr_24830_24863[(2)] = inst_24824);

(statearr_24830_24863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (1))){
var inst_24760 = acc;
var state_24828__$1 = (function (){var statearr_24831 = state_24828;
(statearr_24831[(7)] = inst_24760);

return statearr_24831;
})();
var statearr_24832_24864 = state_24828__$1;
(statearr_24832_24864[(2)] = null);

(statearr_24832_24864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (4))){
var inst_24763 = (state_24828[(8)]);
var inst_24763__$1 = (state_24828[(2)]);
var state_24828__$1 = (function (){var statearr_24833 = state_24828;
(statearr_24833[(8)] = inst_24763__$1);

return statearr_24833;
})();
if(cljs.core.truth_(inst_24763__$1)){
var statearr_24834_24865 = state_24828__$1;
(statearr_24834_24865[(1)] = (5));

} else {
var statearr_24835_24866 = state_24828__$1;
(statearr_24835_24866[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (15))){
var inst_24813 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24814 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24815 = cljs.core.PersistentHashMap.fromArrays(inst_24813,inst_24814);
var inst_24816 = cljs.core.ex_info.call(null,"Aborted operations",inst_24815);
var state_24828__$1 = state_24828;
var statearr_24836_24867 = state_24828__$1;
(statearr_24836_24867[(2)] = inst_24816);

(statearr_24836_24867[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (13))){
var inst_24788 = (state_24828[(2)]);
var inst_24789 = full.async.throw_if_exception.call(null,inst_24788);
var inst_24790 = cljs.core.async.close_BANG_.call(null,result);
var state_24828__$1 = (function (){var statearr_24837 = state_24828;
(statearr_24837[(9)] = inst_24789);

return statearr_24837;
})();
var statearr_24838_24868 = state_24828__$1;
(statearr_24838_24868[(2)] = inst_24790);

(statearr_24838_24868[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (6))){
var inst_24800 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24802 = [(0)];
var inst_24803 = (new cljs.core.PersistentVector(null,1,(5),inst_24801,inst_24802,null));
var inst_24804 = cljs.core.apply.call(null,cljs.core.async.timeout,inst_24803);
var inst_24805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24806 = [inst_24800,inst_24804];
var inst_24807 = (new cljs.core.PersistentVector(null,2,(5),inst_24805,inst_24806,null));
var inst_24808 = cljs.core.async.alts_BANG_.call(null,inst_24807,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var inst_24809 = cljs.core.nth.call(null,inst_24808,(0),null);
var inst_24810 = cljs.core.nth.call(null,inst_24808,(1),null);
var inst_24811 = cljs.core._EQ_.call(null,inst_24810,inst_24800);
var state_24828__$1 = (function (){var statearr_24839 = state_24828;
(statearr_24839[(10)] = inst_24809);

return statearr_24839;
})();
if(inst_24811){
var statearr_24840_24869 = state_24828__$1;
(statearr_24840_24869[(1)] = (15));

} else {
var statearr_24841_24870 = state_24828__$1;
(statearr_24841_24870[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (17))){
var inst_24820 = (state_24828[(2)]);
var inst_24821 = full.async.throw_if_exception.call(null,inst_24820);
var inst_24822 = cljs.core.async.close_BANG_.call(null,result);
var state_24828__$1 = (function (){var statearr_24842 = state_24828;
(statearr_24842[(11)] = inst_24821);

return statearr_24842;
})();
var statearr_24843_24871 = state_24828__$1;
(statearr_24843_24871[(2)] = inst_24822);

(statearr_24843_24871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (3))){
var inst_24826 = (state_24828[(2)]);
var state_24828__$1 = state_24828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24828__$1,inst_24826);
} else {
if((state_val_24829 === (12))){
var inst_24763 = (state_24828[(8)]);
var inst_24786 = cljs.core.async_GT__BANG_.call(null,result,inst_24763);
var state_24828__$1 = state_24828;
var statearr_24844_24872 = state_24828__$1;
(statearr_24844_24872[(2)] = inst_24786);

(statearr_24844_24872[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (2))){
var state_24828__$1 = state_24828;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24828__$1,(4),ch);
} else {
if((state_val_24829 === (11))){
var inst_24781 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24782 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24783 = cljs.core.PersistentHashMap.fromArrays(inst_24781,inst_24782);
var inst_24784 = cljs.core.ex_info.call(null,"Aborted operations",inst_24783);
var state_24828__$1 = state_24828;
var statearr_24845_24873 = state_24828__$1;
(statearr_24845_24873[(2)] = inst_24784);

(statearr_24845_24873[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (9))){
var inst_24763 = (state_24828[(8)]);
var inst_24760 = (state_24828[(7)]);
var inst_24792 = f_GT_.call(null,inst_24760,inst_24763);
var state_24828__$1 = state_24828;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24828__$1,(14),inst_24792);
} else {
if((state_val_24829 === (5))){
var inst_24763 = (state_24828[(8)]);
var inst_24765 = (inst_24763 instanceof Error);
var state_24828__$1 = state_24828;
if(cljs.core.truth_(inst_24765)){
var statearr_24846_24874 = state_24828__$1;
(statearr_24846_24874[(1)] = (8));

} else {
var statearr_24847_24875 = state_24828__$1;
(statearr_24847_24875[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (14))){
var inst_24794 = (state_24828[(2)]);
var inst_24760 = inst_24794;
var state_24828__$1 = (function (){var statearr_24848 = state_24828;
(statearr_24848[(7)] = inst_24760);

return statearr_24848;
})();
var statearr_24849_24876 = state_24828__$1;
(statearr_24849_24876[(2)] = null);

(statearr_24849_24876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (16))){
var inst_24760 = (state_24828[(7)]);
var inst_24818 = cljs.core.async_GT__BANG_.call(null,result,inst_24760);
var state_24828__$1 = state_24828;
var statearr_24850_24877 = state_24828__$1;
(statearr_24850_24877[(2)] = inst_24818);

(statearr_24850_24877[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (10))){
var inst_24797 = (state_24828[(2)]);
var state_24828__$1 = state_24828;
var statearr_24851_24878 = state_24828__$1;
(statearr_24851_24878[(2)] = inst_24797);

(statearr_24851_24878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24829 === (8))){
var inst_24768 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24770 = [(0)];
var inst_24771 = (new cljs.core.PersistentVector(null,1,(5),inst_24769,inst_24770,null));
var inst_24772 = cljs.core.apply.call(null,cljs.core.async.timeout,inst_24771);
var inst_24773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24774 = [inst_24768,inst_24772];
var inst_24775 = (new cljs.core.PersistentVector(null,2,(5),inst_24773,inst_24774,null));
var inst_24776 = cljs.core.async.alts_BANG_.call(null,inst_24775,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var inst_24777 = cljs.core.nth.call(null,inst_24776,(0),null);
var inst_24778 = cljs.core.nth.call(null,inst_24776,(1),null);
var inst_24779 = cljs.core._EQ_.call(null,inst_24778,inst_24768);
var state_24828__$1 = (function (){var statearr_24852 = state_24828;
(statearr_24852[(12)] = inst_24777);

return statearr_24852;
})();
if(inst_24779){
var statearr_24853_24879 = state_24828__$1;
(statearr_24853_24879[(1)] = (11));

} else {
var statearr_24854_24880 = state_24828__$1;
(statearr_24854_24880[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___24862,result))
;
return ((function (switch__20400__auto__,c__20554__auto___24862,result){
return (function() {
var full$async$reduce_GT__$_state_machine__20401__auto__ = null;
var full$async$reduce_GT__$_state_machine__20401__auto____0 = (function (){
var statearr_24858 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24858[(0)] = full$async$reduce_GT__$_state_machine__20401__auto__);

(statearr_24858[(1)] = (1));

return statearr_24858;
});
var full$async$reduce_GT__$_state_machine__20401__auto____1 = (function (state_24828){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24859){if((e24859 instanceof Object)){
var ex__20404__auto__ = e24859;
var statearr_24860_24881 = state_24828;
(statearr_24860_24881[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24828);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24882 = state_24828;
state_24828 = G__24882;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$reduce_GT__$_state_machine__20401__auto__ = function(state_24828){
switch(arguments.length){
case 0:
return full$async$reduce_GT__$_state_machine__20401__auto____0.call(this);
case 1:
return full$async$reduce_GT__$_state_machine__20401__auto____1.call(this,state_24828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$reduce_GT__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$reduce_GT__$_state_machine__20401__auto____0;
full$async$reduce_GT__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$reduce_GT__$_state_machine__20401__auto____1;
return full$async$reduce_GT__$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___24862,result))
})();
var state__20556__auto__ = (function (){var statearr_24861 = f__20555__auto__.call(null);
(statearr_24861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24862);

return statearr_24861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___24862,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
full.async.concat_GT__GT_ = (function full$async$concat_GT__GT_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___24931 = arguments.length;
var i__19444__auto___24932 = (0);
while(true){
if((i__19444__auto___24932 < len__19443__auto___24931)){
args__19450__auto__.push((arguments[i__19444__auto___24932]));

var G__24933 = (i__19444__auto___24932 + (1));
i__19444__auto___24932 = G__24933;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((0) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((0)),(0),null)):null);
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__19451__auto__);
});

full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var out = cljs.core.async.chan.call(null);
var c__20554__auto___24934 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___24934,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___24934,out){
return (function (state_24906){
var state_val_24907 = (state_24906[(1)]);
if((state_val_24907 === (7))){
var inst_24889 = (state_24906[(7)]);
var inst_24889__$1 = (state_24906[(2)]);
var state_24906__$1 = (function (){var statearr_24908 = state_24906;
(statearr_24908[(7)] = inst_24889__$1);

return statearr_24908;
})();
if(cljs.core.truth_(inst_24889__$1)){
var statearr_24909_24935 = state_24906__$1;
(statearr_24909_24935[(1)] = (8));

} else {
var statearr_24910_24936 = state_24906__$1;
(statearr_24910_24936[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (1))){
var inst_24884 = cs;
var state_24906__$1 = (function (){var statearr_24911 = state_24906;
(statearr_24911[(8)] = inst_24884);

return statearr_24911;
})();
var statearr_24912_24937 = state_24906__$1;
(statearr_24912_24937[(2)] = null);

(statearr_24912_24937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (4))){
var inst_24886 = (state_24906[(9)]);
var state_24906__$1 = state_24906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24906__$1,(7),inst_24886);
} else {
if((state_val_24907 === (6))){
var inst_24902 = (state_24906[(2)]);
var state_24906__$1 = state_24906;
var statearr_24913_24938 = state_24906__$1;
(statearr_24913_24938[(2)] = inst_24902);

(statearr_24913_24938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (3))){
var inst_24904 = (state_24906[(2)]);
var state_24906__$1 = state_24906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24906__$1,inst_24904);
} else {
if((state_val_24907 === (2))){
var inst_24884 = (state_24906[(8)]);
var inst_24886 = (state_24906[(9)]);
var inst_24886__$1 = cljs.core.first.call(null,inst_24884);
var state_24906__$1 = (function (){var statearr_24915 = state_24906;
(statearr_24915[(9)] = inst_24886__$1);

return statearr_24915;
})();
if(cljs.core.truth_(inst_24886__$1)){
var statearr_24916_24939 = state_24906__$1;
(statearr_24916_24939[(1)] = (4));

} else {
var statearr_24917_24940 = state_24906__$1;
(statearr_24917_24940[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (11))){
var inst_24884 = (state_24906[(8)]);
var inst_24892 = (state_24906[(2)]);
var tmp24914 = inst_24884;
var inst_24884__$1 = tmp24914;
var state_24906__$1 = (function (){var statearr_24918 = state_24906;
(statearr_24918[(10)] = inst_24892);

(statearr_24918[(8)] = inst_24884__$1);

return statearr_24918;
})();
var statearr_24919_24941 = state_24906__$1;
(statearr_24919_24941[(2)] = null);

(statearr_24919_24941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (9))){
var inst_24884 = (state_24906[(8)]);
var inst_24895 = cljs.core.rest.call(null,inst_24884);
var inst_24884__$1 = inst_24895;
var state_24906__$1 = (function (){var statearr_24920 = state_24906;
(statearr_24920[(8)] = inst_24884__$1);

return statearr_24920;
})();
var statearr_24921_24942 = state_24906__$1;
(statearr_24921_24942[(2)] = null);

(statearr_24921_24942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (5))){
var inst_24900 = cljs.core.async.close_BANG_.call(null,out);
var state_24906__$1 = state_24906;
var statearr_24922_24943 = state_24906__$1;
(statearr_24922_24943[(2)] = inst_24900);

(statearr_24922_24943[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (10))){
var inst_24898 = (state_24906[(2)]);
var state_24906__$1 = state_24906;
var statearr_24923_24944 = state_24906__$1;
(statearr_24923_24944[(2)] = inst_24898);

(statearr_24923_24944[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24907 === (8))){
var inst_24889 = (state_24906[(7)]);
var state_24906__$1 = state_24906;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24906__$1,(11),out,inst_24889);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___24934,out))
;
return ((function (switch__20400__auto__,c__20554__auto___24934,out){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24927 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24927[(0)] = full$async$state_machine__20401__auto__);

(statearr_24927[(1)] = (1));

return statearr_24927;
});
var full$async$state_machine__20401__auto____1 = (function (state_24906){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24928){if((e24928 instanceof Object)){
var ex__20404__auto__ = e24928;
var statearr_24929_24945 = state_24906;
(statearr_24929_24945[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24946 = state_24906;
state_24906 = G__24946;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24906){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___24934,out))
})();
var state__20556__auto__ = (function (){var statearr_24930 = f__20555__auto__.call(null);
(statearr_24930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24934);

return statearr_24930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___24934,out))
);


return out;
});

full.async.concat_GT__GT_.cljs$lang$maxFixedArity = (0);

full.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq24883){
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq24883));
});
full.async.partition_all_GT__GT_ = (function full$async$partition_all_GT__GT_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___25027 = arguments.length;
var i__19444__auto___25028 = (0);
while(true){
if((i__19444__auto___25028 < len__19443__auto___25027)){
args__19450__auto__.push((arguments[i__19444__auto___25028]));

var G__25029 = (i__19444__auto___25028 + (1));
i__19444__auto___25028 = G__25029;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((2) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((2)),(0),null)):null);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19451__auto__);
});

full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (n,in_ch,p__24950){
var map__24951 = p__24950;
var map__24951__$1 = ((((!((map__24951 == null)))?((((map__24951.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24951.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24951):map__24951);
var out_ch = cljs.core.get.call(null,map__24951__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__18374__auto__ = out_ch;
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__20554__auto___25030 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___25030,out_ch__$1,map__24951,map__24951__$1,out_ch){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___25030,out_ch__$1,map__24951,map__24951__$1,out_ch){
return (function (state_24993){
var state_val_24994 = (state_24993[(1)]);
if((state_val_24994 === (7))){
var inst_24989 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
var statearr_24995_25031 = state_24993__$1;
(statearr_24995_25031[(2)] = inst_24989);

(statearr_24995_25031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (1))){
var inst_24953 = cljs.core.PersistentVector.EMPTY;
var inst_24954 = inst_24953;
var state_24993__$1 = (function (){var statearr_24996 = state_24993;
(statearr_24996[(7)] = inst_24954);

return statearr_24996;
})();
var statearr_24997_25032 = state_24993__$1;
(statearr_24997_25032[(2)] = null);

(statearr_24997_25032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (4))){
var inst_24957 = (state_24993[(8)]);
var inst_24957__$1 = (state_24993[(2)]);
var state_24993__$1 = (function (){var statearr_24998 = state_24993;
(statearr_24998[(8)] = inst_24957__$1);

return statearr_24998;
})();
if(cljs.core.truth_(inst_24957__$1)){
var statearr_24999_25033 = state_24993__$1;
(statearr_24999_25033[(1)] = (5));

} else {
var statearr_25000_25034 = state_24993__$1;
(statearr_25000_25034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (15))){
var inst_24970 = (state_24993[(2)]);
var inst_24971 = cljs.core.PersistentVector.EMPTY;
var inst_24954 = inst_24971;
var state_24993__$1 = (function (){var statearr_25001 = state_24993;
(statearr_25001[(7)] = inst_24954);

(statearr_25001[(9)] = inst_24970);

return statearr_25001;
})();
var statearr_25002_25035 = state_24993__$1;
(statearr_25002_25035[(2)] = null);

(statearr_25002_25035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (13))){
var inst_24965 = (state_24993[(10)]);
var inst_24954 = inst_24965;
var state_24993__$1 = (function (){var statearr_25003 = state_24993;
(statearr_25003[(7)] = inst_24954);

return statearr_25003;
})();
var statearr_25004_25036 = state_24993__$1;
(statearr_25004_25036[(2)] = null);

(statearr_25004_25036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (6))){
var inst_24954 = (state_24993[(7)]);
var inst_24980 = cljs.core.not_empty.call(null,inst_24954);
var state_24993__$1 = state_24993;
if(cljs.core.truth_(inst_24980)){
var statearr_25005_25037 = state_24993__$1;
(statearr_25005_25037[(1)] = (16));

} else {
var statearr_25006_25038 = state_24993__$1;
(statearr_25006_25038[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (17))){
var state_24993__$1 = state_24993;
var statearr_25007_25039 = state_24993__$1;
(statearr_25007_25039[(2)] = null);

(statearr_25007_25039[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (3))){
var inst_24991 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24993__$1,inst_24991);
} else {
if((state_val_24994 === (12))){
var inst_24965 = (state_24993[(10)]);
var state_24993__$1 = state_24993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24993__$1,(15),out_ch__$1,inst_24965);
} else {
if((state_val_24994 === (2))){
var state_24993__$1 = state_24993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24993__$1,(4),in_ch);
} else {
if((state_val_24994 === (19))){
var inst_24983 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
var statearr_25008_25040 = state_24993__$1;
(statearr_25008_25040[(2)] = inst_24983);

(statearr_25008_25040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (11))){
var inst_24962 = (state_24993[(2)]);
var inst_24963 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_24993__$1 = (function (){var statearr_25009 = state_24993;
(statearr_25009[(11)] = inst_24962);

return statearr_25009;
})();
var statearr_25010_25041 = state_24993__$1;
(statearr_25010_25041[(2)] = inst_24963);

(statearr_25010_25041[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (9))){
var inst_24957 = (state_24993[(8)]);
var inst_24965 = (state_24993[(10)]);
var inst_24954 = (state_24993[(7)]);
var inst_24965__$1 = cljs.core.conj.call(null,inst_24954,inst_24957);
var inst_24966 = cljs.core.count.call(null,inst_24965__$1);
var inst_24967 = cljs.core._EQ_.call(null,n,inst_24966);
var state_24993__$1 = (function (){var statearr_25011 = state_24993;
(statearr_25011[(10)] = inst_24965__$1);

return statearr_25011;
})();
if(inst_24967){
var statearr_25012_25042 = state_24993__$1;
(statearr_25012_25042[(1)] = (12));

} else {
var statearr_25013_25043 = state_24993__$1;
(statearr_25013_25043[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (5))){
var inst_24957 = (state_24993[(8)]);
var inst_24959 = (inst_24957 instanceof Error);
var state_24993__$1 = state_24993;
if(cljs.core.truth_(inst_24959)){
var statearr_25014_25044 = state_24993__$1;
(statearr_25014_25044[(1)] = (8));

} else {
var statearr_25015_25045 = state_24993__$1;
(statearr_25015_25045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (14))){
var inst_24976 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
var statearr_25016_25046 = state_24993__$1;
(statearr_25016_25046[(2)] = inst_24976);

(statearr_25016_25046[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (16))){
var inst_24954 = (state_24993[(7)]);
var state_24993__$1 = state_24993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24993__$1,(19),out_ch__$1,inst_24954);
} else {
if((state_val_24994 === (10))){
var inst_24978 = (state_24993[(2)]);
var state_24993__$1 = state_24993;
var statearr_25017_25047 = state_24993__$1;
(statearr_25017_25047[(2)] = inst_24978);

(statearr_25017_25047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (18))){
var inst_24986 = (state_24993[(2)]);
var inst_24987 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_24993__$1 = (function (){var statearr_25018 = state_24993;
(statearr_25018[(12)] = inst_24986);

return statearr_25018;
})();
var statearr_25019_25048 = state_24993__$1;
(statearr_25019_25048[(2)] = inst_24987);

(statearr_25019_25048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24994 === (8))){
var inst_24957 = (state_24993[(8)]);
var state_24993__$1 = state_24993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24993__$1,(11),out_ch__$1,inst_24957);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___25030,out_ch__$1,map__24951,map__24951__$1,out_ch))
;
return ((function (switch__20400__auto__,c__20554__auto___25030,out_ch__$1,map__24951,map__24951__$1,out_ch){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_25023 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25023[(0)] = full$async$state_machine__20401__auto__);

(statearr_25023[(1)] = (1));

return statearr_25023;
});
var full$async$state_machine__20401__auto____1 = (function (state_24993){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e25024){if((e25024 instanceof Object)){
var ex__20404__auto__ = e25024;
var statearr_25025_25049 = state_24993;
(statearr_25025_25049[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25024;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25050 = state_24993;
state_24993 = G__25050;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24993){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___25030,out_ch__$1,map__24951,map__24951__$1,out_ch))
})();
var state__20556__auto__ = (function (){var statearr_25026 = f__20555__auto__.call(null);
(statearr_25026[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___25030);

return statearr_25026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___25030,out_ch__$1,map__24951,map__24951__$1,out_ch))
);


return out_ch__$1;
});

full.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (2);

full.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq24947){
var G__24948 = cljs.core.first.call(null,seq24947);
var seq24947__$1 = cljs.core.next.call(null,seq24947);
var G__24949 = cljs.core.first.call(null,seq24947__$1);
var seq24947__$2 = cljs.core.next.call(null,seq24947__$1);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__24948,G__24949,seq24947__$2);
});
/**
 * Counts items in a channel. Returns a channel with the item count.
 */
full.async.count_GT_ = (function full$async$count_GT_(ch){
return cljs.core.async.reduce.call(null,(function (acc,_){
return (acc + (1));
}),(0),ch);
});

//# sourceMappingURL=async.js.map