// Compiled by ClojureScript 1.8.34 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args20599 = [];
var len__19443__auto___20605 = arguments.length;
var i__19444__auto___20606 = (0);
while(true){
if((i__19444__auto___20606 < len__19443__auto___20605)){
args20599.push((arguments[i__19444__auto___20606]));

var G__20607 = (i__19444__auto___20606 + (1));
i__19444__auto___20606 = G__20607;
continue;
} else {
}
break;
}

var G__20601 = args20599.length;
switch (G__20601) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20599.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async20602 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20602 = (function (f,blockable,meta20603){
this.f = f;
this.blockable = blockable;
this.meta20603 = meta20603;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20602.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20604,meta20603__$1){
var self__ = this;
var _20604__$1 = this;
return (new cljs.core.async.t_cljs$core$async20602(self__.f,self__.blockable,meta20603__$1));
});

cljs.core.async.t_cljs$core$async20602.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20604){
var self__ = this;
var _20604__$1 = this;
return self__.meta20603;
});

cljs.core.async.t_cljs$core$async20602.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20602.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20602.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async20602.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async20602.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20603","meta20603",-678114289,null)], null);
});

cljs.core.async.t_cljs$core$async20602.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20602.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20602";

cljs.core.async.t_cljs$core$async20602.cljs$lang$ctorPrWriter = (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async20602");
});

cljs.core.async.__GT_t_cljs$core$async20602 = (function cljs$core$async$__GT_t_cljs$core$async20602(f__$1,blockable__$1,meta20603){
return (new cljs.core.async.t_cljs$core$async20602(f__$1,blockable__$1,meta20603));
});

}

return (new cljs.core.async.t_cljs$core$async20602(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args20611 = [];
var len__19443__auto___20614 = arguments.length;
var i__19444__auto___20615 = (0);
while(true){
if((i__19444__auto___20615 < len__19443__auto___20614)){
args20611.push((arguments[i__19444__auto___20615]));

var G__20616 = (i__19444__auto___20615 + (1));
i__19444__auto___20615 = G__20616;
continue;
} else {
}
break;
}

var G__20613 = args20611.length;
switch (G__20613) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20611.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args20618 = [];
var len__19443__auto___20621 = arguments.length;
var i__19444__auto___20622 = (0);
while(true){
if((i__19444__auto___20622 < len__19443__auto___20621)){
args20618.push((arguments[i__19444__auto___20622]));

var G__20623 = (i__19444__auto___20622 + (1));
i__19444__auto___20622 = G__20623;
continue;
} else {
}
break;
}

var G__20620 = args20618.length;
switch (G__20620) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20618.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args20625 = [];
var len__19443__auto___20628 = arguments.length;
var i__19444__auto___20629 = (0);
while(true){
if((i__19444__auto___20629 < len__19443__auto___20628)){
args20625.push((arguments[i__19444__auto___20629]));

var G__20630 = (i__19444__auto___20629 + (1));
i__19444__auto___20629 = G__20630;
continue;
} else {
}
break;
}

var G__20627 = args20625.length;
switch (G__20627) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20625.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_20632 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_20632);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_20632,ret){
return (function (){
return fn1.call(null,val_20632);
});})(val_20632,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args20633 = [];
var len__19443__auto___20636 = arguments.length;
var i__19444__auto___20637 = (0);
while(true){
if((i__19444__auto___20637 < len__19443__auto___20636)){
args20633.push((arguments[i__19444__auto___20637]));

var G__20638 = (i__19444__auto___20637 + (1));
i__19444__auto___20637 = G__20638;
continue;
} else {
}
break;
}

var G__20635 = args20633.length;
switch (G__20635) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20633.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19288__auto___20640 = n;
var x_20641 = (0);
while(true){
if((x_20641 < n__19288__auto___20640)){
(a[x_20641] = (0));

var G__20642 = (x_20641 + (1));
x_20641 = G__20642;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__20643 = (i + (1));
i = G__20643;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async20647 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20647 = (function (alt_flag,flag,meta20648){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta20648 = meta20648;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20647.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20649,meta20648__$1){
var self__ = this;
var _20649__$1 = this;
return (new cljs.core.async.t_cljs$core$async20647(self__.alt_flag,self__.flag,meta20648__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async20647.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20649){
var self__ = this;
var _20649__$1 = this;
return self__.meta20648;
});})(flag))
;

cljs.core.async.t_cljs$core$async20647.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20647.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async20647.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20647.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20647.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20648","meta20648",1246874403,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async20647.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20647.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20647";

cljs.core.async.t_cljs$core$async20647.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async20647");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async20647 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20647(alt_flag__$1,flag__$1,meta20648){
return (new cljs.core.async.t_cljs$core$async20647(alt_flag__$1,flag__$1,meta20648));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async20647(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async20653 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20653 = (function (alt_handler,flag,cb,meta20654){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta20654 = meta20654;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20653.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20655,meta20654__$1){
var self__ = this;
var _20655__$1 = this;
return (new cljs.core.async.t_cljs$core$async20653(self__.alt_handler,self__.flag,self__.cb,meta20654__$1));
});

cljs.core.async.t_cljs$core$async20653.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20655){
var self__ = this;
var _20655__$1 = this;
return self__.meta20654;
});

cljs.core.async.t_cljs$core$async20653.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20653.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async20653.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20653.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async20653.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20654","meta20654",-48392141,null)], null);
});

cljs.core.async.t_cljs$core$async20653.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20653.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20653";

cljs.core.async.t_cljs$core$async20653.cljs$lang$ctorPrWriter = (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async20653");
});

cljs.core.async.__GT_t_cljs$core$async20653 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20653(alt_handler__$1,flag__$1,cb__$1,meta20654){
return (new cljs.core.async.t_cljs$core$async20653(alt_handler__$1,flag__$1,cb__$1,meta20654));
});

}

return (new cljs.core.async.t_cljs$core$async20653(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20656_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20656_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20657_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20657_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18374__auto__ = wport;
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20658 = (i + (1));
i = G__20658;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18374__auto__ = ret;
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__18362__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18362__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18362__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___20664 = arguments.length;
var i__19444__auto___20665 = (0);
while(true){
if((i__19444__auto___20665 < len__19443__auto___20664)){
args__19450__auto__.push((arguments[i__19444__auto___20665]));

var G__20666 = (i__19444__auto___20665 + (1));
i__19444__auto___20665 = G__20666;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((1) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19451__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20661){
var map__20662 = p__20661;
var map__20662__$1 = ((((!((map__20662 == null)))?((((map__20662.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20662.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20662):map__20662);
var opts = map__20662__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20659){
var G__20660 = cljs.core.first.call(null,seq20659);
var seq20659__$1 = cljs.core.next.call(null,seq20659);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20660,seq20659__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args20667 = [];
var len__19443__auto___20717 = arguments.length;
var i__19444__auto___20718 = (0);
while(true){
if((i__19444__auto___20718 < len__19443__auto___20717)){
args20667.push((arguments[i__19444__auto___20718]));

var G__20719 = (i__19444__auto___20718 + (1));
i__19444__auto___20718 = G__20719;
continue;
} else {
}
break;
}

var G__20669 = args20667.length;
switch (G__20669) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20667.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20554__auto___20721 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___20721){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___20721){
return (function (state_20693){
var state_val_20694 = (state_20693[(1)]);
if((state_val_20694 === (7))){
var inst_20689 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
var statearr_20695_20722 = state_20693__$1;
(statearr_20695_20722[(2)] = inst_20689);

(statearr_20695_20722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (1))){
var state_20693__$1 = state_20693;
var statearr_20696_20723 = state_20693__$1;
(statearr_20696_20723[(2)] = null);

(statearr_20696_20723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (4))){
var inst_20672 = (state_20693[(7)]);
var inst_20672__$1 = (state_20693[(2)]);
var inst_20673 = (inst_20672__$1 == null);
var state_20693__$1 = (function (){var statearr_20697 = state_20693;
(statearr_20697[(7)] = inst_20672__$1);

return statearr_20697;
})();
if(cljs.core.truth_(inst_20673)){
var statearr_20698_20724 = state_20693__$1;
(statearr_20698_20724[(1)] = (5));

} else {
var statearr_20699_20725 = state_20693__$1;
(statearr_20699_20725[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (13))){
var state_20693__$1 = state_20693;
var statearr_20700_20726 = state_20693__$1;
(statearr_20700_20726[(2)] = null);

(statearr_20700_20726[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (6))){
var inst_20672 = (state_20693[(7)]);
var state_20693__$1 = state_20693;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20693__$1,(11),to,inst_20672);
} else {
if((state_val_20694 === (3))){
var inst_20691 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20693__$1,inst_20691);
} else {
if((state_val_20694 === (12))){
var state_20693__$1 = state_20693;
var statearr_20701_20727 = state_20693__$1;
(statearr_20701_20727[(2)] = null);

(statearr_20701_20727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (2))){
var state_20693__$1 = state_20693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20693__$1,(4),from);
} else {
if((state_val_20694 === (11))){
var inst_20682 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
if(cljs.core.truth_(inst_20682)){
var statearr_20702_20728 = state_20693__$1;
(statearr_20702_20728[(1)] = (12));

} else {
var statearr_20703_20729 = state_20693__$1;
(statearr_20703_20729[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (9))){
var state_20693__$1 = state_20693;
var statearr_20704_20730 = state_20693__$1;
(statearr_20704_20730[(2)] = null);

(statearr_20704_20730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (5))){
var state_20693__$1 = state_20693;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20705_20731 = state_20693__$1;
(statearr_20705_20731[(1)] = (8));

} else {
var statearr_20706_20732 = state_20693__$1;
(statearr_20706_20732[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (14))){
var inst_20687 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
var statearr_20707_20733 = state_20693__$1;
(statearr_20707_20733[(2)] = inst_20687);

(statearr_20707_20733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (10))){
var inst_20679 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
var statearr_20708_20734 = state_20693__$1;
(statearr_20708_20734[(2)] = inst_20679);

(statearr_20708_20734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (8))){
var inst_20676 = cljs.core.async.close_BANG_.call(null,to);
var state_20693__$1 = state_20693;
var statearr_20709_20735 = state_20693__$1;
(statearr_20709_20735[(2)] = inst_20676);

(statearr_20709_20735[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___20721))
;
return ((function (switch__20400__auto__,c__20554__auto___20721){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_20713 = [null,null,null,null,null,null,null,null];
(statearr_20713[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_20713[(1)] = (1));

return statearr_20713;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_20693){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_20693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e20714){if((e20714 instanceof Object)){
var ex__20404__auto__ = e20714;
var statearr_20715_20736 = state_20693;
(statearr_20715_20736[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20737 = state_20693;
state_20693 = G__20737;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_20693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_20693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___20721))
})();
var state__20556__auto__ = (function (){var statearr_20716 = f__20555__auto__.call(null);
(statearr_20716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___20721);

return statearr_20716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___20721))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__20921){
var vec__20922 = p__20921;
var v = cljs.core.nth.call(null,vec__20922,(0),null);
var p = cljs.core.nth.call(null,vec__20922,(1),null);
var job = vec__20922;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__20554__auto___21104 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___21104,res,vec__20922,v,p,job,jobs,results){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___21104,res,vec__20922,v,p,job,jobs,results){
return (function (state_20927){
var state_val_20928 = (state_20927[(1)]);
if((state_val_20928 === (1))){
var state_20927__$1 = state_20927;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20927__$1,(2),res,v);
} else {
if((state_val_20928 === (2))){
var inst_20924 = (state_20927[(2)]);
var inst_20925 = cljs.core.async.close_BANG_.call(null,res);
var state_20927__$1 = (function (){var statearr_20929 = state_20927;
(statearr_20929[(7)] = inst_20924);

return statearr_20929;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20927__$1,inst_20925);
} else {
return null;
}
}
});})(c__20554__auto___21104,res,vec__20922,v,p,job,jobs,results))
;
return ((function (switch__20400__auto__,c__20554__auto___21104,res,vec__20922,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0 = (function (){
var statearr_20933 = [null,null,null,null,null,null,null,null];
(statearr_20933[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__);

(statearr_20933[(1)] = (1));

return statearr_20933;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1 = (function (state_20927){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_20927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e20934){if((e20934 instanceof Object)){
var ex__20404__auto__ = e20934;
var statearr_20935_21105 = state_20927;
(statearr_20935_21105[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20927);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20934;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21106 = state_20927;
state_20927 = G__21106;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = function(state_20927){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1.call(this,state_20927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___21104,res,vec__20922,v,p,job,jobs,results))
})();
var state__20556__auto__ = (function (){var statearr_20936 = f__20555__auto__.call(null);
(statearr_20936[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___21104);

return statearr_20936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___21104,res,vec__20922,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__20937){
var vec__20938 = p__20937;
var v = cljs.core.nth.call(null,vec__20938,(0),null);
var p = cljs.core.nth.call(null,vec__20938,(1),null);
var job = vec__20938;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19288__auto___21107 = n;
var __21108 = (0);
while(true){
if((__21108 < n__19288__auto___21107)){
var G__20939_21109 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__20939_21109) {
case "compute":
var c__20554__auto___21111 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__21108,c__20554__auto___21111,G__20939_21109,n__19288__auto___21107,jobs,results,process,async){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (__21108,c__20554__auto___21111,G__20939_21109,n__19288__auto___21107,jobs,results,process,async){
return (function (state_20952){
var state_val_20953 = (state_20952[(1)]);
if((state_val_20953 === (1))){
var state_20952__$1 = state_20952;
var statearr_20954_21112 = state_20952__$1;
(statearr_20954_21112[(2)] = null);

(statearr_20954_21112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20953 === (2))){
var state_20952__$1 = state_20952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20952__$1,(4),jobs);
} else {
if((state_val_20953 === (3))){
var inst_20950 = (state_20952[(2)]);
var state_20952__$1 = state_20952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20952__$1,inst_20950);
} else {
if((state_val_20953 === (4))){
var inst_20942 = (state_20952[(2)]);
var inst_20943 = process.call(null,inst_20942);
var state_20952__$1 = state_20952;
if(cljs.core.truth_(inst_20943)){
var statearr_20955_21113 = state_20952__$1;
(statearr_20955_21113[(1)] = (5));

} else {
var statearr_20956_21114 = state_20952__$1;
(statearr_20956_21114[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20953 === (5))){
var state_20952__$1 = state_20952;
var statearr_20957_21115 = state_20952__$1;
(statearr_20957_21115[(2)] = null);

(statearr_20957_21115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20953 === (6))){
var state_20952__$1 = state_20952;
var statearr_20958_21116 = state_20952__$1;
(statearr_20958_21116[(2)] = null);

(statearr_20958_21116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20953 === (7))){
var inst_20948 = (state_20952[(2)]);
var state_20952__$1 = state_20952;
var statearr_20959_21117 = state_20952__$1;
(statearr_20959_21117[(2)] = inst_20948);

(statearr_20959_21117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21108,c__20554__auto___21111,G__20939_21109,n__19288__auto___21107,jobs,results,process,async))
;
return ((function (__21108,switch__20400__auto__,c__20554__auto___21111,G__20939_21109,n__19288__auto___21107,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0 = (function (){
var statearr_20963 = [null,null,null,null,null,null,null];
(statearr_20963[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__);

(statearr_20963[(1)] = (1));

return statearr_20963;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1 = (function (state_20952){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_20952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e20964){if((e20964 instanceof Object)){
var ex__20404__auto__ = e20964;
var statearr_20965_21118 = state_20952;
(statearr_20965_21118[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20952);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20964;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21119 = state_20952;
state_20952 = G__21119;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = function(state_20952){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1.call(this,state_20952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__;
})()
;})(__21108,switch__20400__auto__,c__20554__auto___21111,G__20939_21109,n__19288__auto___21107,jobs,results,process,async))
})();
var state__20556__auto__ = (function (){var statearr_20966 = f__20555__auto__.call(null);
(statearr_20966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___21111);

return statearr_20966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(__21108,c__20554__auto___21111,G__20939_21109,n__19288__auto___21107,jobs,results,process,async))
);


break;
case "async":
var c__20554__auto___21120 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__21108,c__20554__auto___21120,G__20939_21109,n__19288__auto___21107,jobs,results,process,async){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (__21108,c__20554__auto___21120,G__20939_21109,n__19288__auto___21107,jobs,results,process,async){
return (function (state_20979){
var state_val_20980 = (state_20979[(1)]);
if((state_val_20980 === (1))){
var state_20979__$1 = state_20979;
var statearr_20981_21121 = state_20979__$1;
(statearr_20981_21121[(2)] = null);

(statearr_20981_21121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20980 === (2))){
var state_20979__$1 = state_20979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20979__$1,(4),jobs);
} else {
if((state_val_20980 === (3))){
var inst_20977 = (state_20979[(2)]);
var state_20979__$1 = state_20979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20979__$1,inst_20977);
} else {
if((state_val_20980 === (4))){
var inst_20969 = (state_20979[(2)]);
var inst_20970 = async.call(null,inst_20969);
var state_20979__$1 = state_20979;
if(cljs.core.truth_(inst_20970)){
var statearr_20982_21122 = state_20979__$1;
(statearr_20982_21122[(1)] = (5));

} else {
var statearr_20983_21123 = state_20979__$1;
(statearr_20983_21123[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20980 === (5))){
var state_20979__$1 = state_20979;
var statearr_20984_21124 = state_20979__$1;
(statearr_20984_21124[(2)] = null);

(statearr_20984_21124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20980 === (6))){
var state_20979__$1 = state_20979;
var statearr_20985_21125 = state_20979__$1;
(statearr_20985_21125[(2)] = null);

(statearr_20985_21125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20980 === (7))){
var inst_20975 = (state_20979[(2)]);
var state_20979__$1 = state_20979;
var statearr_20986_21126 = state_20979__$1;
(statearr_20986_21126[(2)] = inst_20975);

(statearr_20986_21126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21108,c__20554__auto___21120,G__20939_21109,n__19288__auto___21107,jobs,results,process,async))
;
return ((function (__21108,switch__20400__auto__,c__20554__auto___21120,G__20939_21109,n__19288__auto___21107,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0 = (function (){
var statearr_20990 = [null,null,null,null,null,null,null];
(statearr_20990[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__);

(statearr_20990[(1)] = (1));

return statearr_20990;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1 = (function (state_20979){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_20979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e20991){if((e20991 instanceof Object)){
var ex__20404__auto__ = e20991;
var statearr_20992_21127 = state_20979;
(statearr_20992_21127[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20979);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20991;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21128 = state_20979;
state_20979 = G__21128;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = function(state_20979){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1.call(this,state_20979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__;
})()
;})(__21108,switch__20400__auto__,c__20554__auto___21120,G__20939_21109,n__19288__auto___21107,jobs,results,process,async))
})();
var state__20556__auto__ = (function (){var statearr_20993 = f__20555__auto__.call(null);
(statearr_20993[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___21120);

return statearr_20993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(__21108,c__20554__auto___21120,G__20939_21109,n__19288__auto___21107,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__21129 = (__21108 + (1));
__21108 = G__21129;
continue;
} else {
}
break;
}

var c__20554__auto___21130 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___21130,jobs,results,process,async){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___21130,jobs,results,process,async){
return (function (state_21015){
var state_val_21016 = (state_21015[(1)]);
if((state_val_21016 === (1))){
var state_21015__$1 = state_21015;
var statearr_21017_21131 = state_21015__$1;
(statearr_21017_21131[(2)] = null);

(statearr_21017_21131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (2))){
var state_21015__$1 = state_21015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21015__$1,(4),from);
} else {
if((state_val_21016 === (3))){
var inst_21013 = (state_21015[(2)]);
var state_21015__$1 = state_21015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21015__$1,inst_21013);
} else {
if((state_val_21016 === (4))){
var inst_20996 = (state_21015[(7)]);
var inst_20996__$1 = (state_21015[(2)]);
var inst_20997 = (inst_20996__$1 == null);
var state_21015__$1 = (function (){var statearr_21018 = state_21015;
(statearr_21018[(7)] = inst_20996__$1);

return statearr_21018;
})();
if(cljs.core.truth_(inst_20997)){
var statearr_21019_21132 = state_21015__$1;
(statearr_21019_21132[(1)] = (5));

} else {
var statearr_21020_21133 = state_21015__$1;
(statearr_21020_21133[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (5))){
var inst_20999 = cljs.core.async.close_BANG_.call(null,jobs);
var state_21015__$1 = state_21015;
var statearr_21021_21134 = state_21015__$1;
(statearr_21021_21134[(2)] = inst_20999);

(statearr_21021_21134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (6))){
var inst_21001 = (state_21015[(8)]);
var inst_20996 = (state_21015[(7)]);
var inst_21001__$1 = cljs.core.async.chan.call(null,(1));
var inst_21002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21003 = [inst_20996,inst_21001__$1];
var inst_21004 = (new cljs.core.PersistentVector(null,2,(5),inst_21002,inst_21003,null));
var state_21015__$1 = (function (){var statearr_21022 = state_21015;
(statearr_21022[(8)] = inst_21001__$1);

return statearr_21022;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21015__$1,(8),jobs,inst_21004);
} else {
if((state_val_21016 === (7))){
var inst_21011 = (state_21015[(2)]);
var state_21015__$1 = state_21015;
var statearr_21023_21135 = state_21015__$1;
(statearr_21023_21135[(2)] = inst_21011);

(statearr_21023_21135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (8))){
var inst_21001 = (state_21015[(8)]);
var inst_21006 = (state_21015[(2)]);
var state_21015__$1 = (function (){var statearr_21024 = state_21015;
(statearr_21024[(9)] = inst_21006);

return statearr_21024;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21015__$1,(9),results,inst_21001);
} else {
if((state_val_21016 === (9))){
var inst_21008 = (state_21015[(2)]);
var state_21015__$1 = (function (){var statearr_21025 = state_21015;
(statearr_21025[(10)] = inst_21008);

return statearr_21025;
})();
var statearr_21026_21136 = state_21015__$1;
(statearr_21026_21136[(2)] = null);

(statearr_21026_21136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___21130,jobs,results,process,async))
;
return ((function (switch__20400__auto__,c__20554__auto___21130,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0 = (function (){
var statearr_21030 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21030[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__);

(statearr_21030[(1)] = (1));

return statearr_21030;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1 = (function (state_21015){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_21015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e21031){if((e21031 instanceof Object)){
var ex__20404__auto__ = e21031;
var statearr_21032_21137 = state_21015;
(statearr_21032_21137[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21138 = state_21015;
state_21015 = G__21138;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = function(state_21015){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1.call(this,state_21015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___21130,jobs,results,process,async))
})();
var state__20556__auto__ = (function (){var statearr_21033 = f__20555__auto__.call(null);
(statearr_21033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___21130);

return statearr_21033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___21130,jobs,results,process,async))
);


var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__,jobs,results,process,async){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__,jobs,results,process,async){
return (function (state_21071){
var state_val_21072 = (state_21071[(1)]);
if((state_val_21072 === (7))){
var inst_21067 = (state_21071[(2)]);
var state_21071__$1 = state_21071;
var statearr_21073_21139 = state_21071__$1;
(statearr_21073_21139[(2)] = inst_21067);

(statearr_21073_21139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (20))){
var state_21071__$1 = state_21071;
var statearr_21074_21140 = state_21071__$1;
(statearr_21074_21140[(2)] = null);

(statearr_21074_21140[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (1))){
var state_21071__$1 = state_21071;
var statearr_21075_21141 = state_21071__$1;
(statearr_21075_21141[(2)] = null);

(statearr_21075_21141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (4))){
var inst_21036 = (state_21071[(7)]);
var inst_21036__$1 = (state_21071[(2)]);
var inst_21037 = (inst_21036__$1 == null);
var state_21071__$1 = (function (){var statearr_21076 = state_21071;
(statearr_21076[(7)] = inst_21036__$1);

return statearr_21076;
})();
if(cljs.core.truth_(inst_21037)){
var statearr_21077_21142 = state_21071__$1;
(statearr_21077_21142[(1)] = (5));

} else {
var statearr_21078_21143 = state_21071__$1;
(statearr_21078_21143[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (15))){
var inst_21049 = (state_21071[(8)]);
var state_21071__$1 = state_21071;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21071__$1,(18),to,inst_21049);
} else {
if((state_val_21072 === (21))){
var inst_21062 = (state_21071[(2)]);
var state_21071__$1 = state_21071;
var statearr_21079_21144 = state_21071__$1;
(statearr_21079_21144[(2)] = inst_21062);

(statearr_21079_21144[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (13))){
var inst_21064 = (state_21071[(2)]);
var state_21071__$1 = (function (){var statearr_21080 = state_21071;
(statearr_21080[(9)] = inst_21064);

return statearr_21080;
})();
var statearr_21081_21145 = state_21071__$1;
(statearr_21081_21145[(2)] = null);

(statearr_21081_21145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (6))){
var inst_21036 = (state_21071[(7)]);
var state_21071__$1 = state_21071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21071__$1,(11),inst_21036);
} else {
if((state_val_21072 === (17))){
var inst_21057 = (state_21071[(2)]);
var state_21071__$1 = state_21071;
if(cljs.core.truth_(inst_21057)){
var statearr_21082_21146 = state_21071__$1;
(statearr_21082_21146[(1)] = (19));

} else {
var statearr_21083_21147 = state_21071__$1;
(statearr_21083_21147[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (3))){
var inst_21069 = (state_21071[(2)]);
var state_21071__$1 = state_21071;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21071__$1,inst_21069);
} else {
if((state_val_21072 === (12))){
var inst_21046 = (state_21071[(10)]);
var state_21071__$1 = state_21071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21071__$1,(14),inst_21046);
} else {
if((state_val_21072 === (2))){
var state_21071__$1 = state_21071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21071__$1,(4),results);
} else {
if((state_val_21072 === (19))){
var state_21071__$1 = state_21071;
var statearr_21084_21148 = state_21071__$1;
(statearr_21084_21148[(2)] = null);

(statearr_21084_21148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (11))){
var inst_21046 = (state_21071[(2)]);
var state_21071__$1 = (function (){var statearr_21085 = state_21071;
(statearr_21085[(10)] = inst_21046);

return statearr_21085;
})();
var statearr_21086_21149 = state_21071__$1;
(statearr_21086_21149[(2)] = null);

(statearr_21086_21149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (9))){
var state_21071__$1 = state_21071;
var statearr_21087_21150 = state_21071__$1;
(statearr_21087_21150[(2)] = null);

(statearr_21087_21150[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (5))){
var state_21071__$1 = state_21071;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21088_21151 = state_21071__$1;
(statearr_21088_21151[(1)] = (8));

} else {
var statearr_21089_21152 = state_21071__$1;
(statearr_21089_21152[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (14))){
var inst_21049 = (state_21071[(8)]);
var inst_21051 = (state_21071[(11)]);
var inst_21049__$1 = (state_21071[(2)]);
var inst_21050 = (inst_21049__$1 == null);
var inst_21051__$1 = cljs.core.not.call(null,inst_21050);
var state_21071__$1 = (function (){var statearr_21090 = state_21071;
(statearr_21090[(8)] = inst_21049__$1);

(statearr_21090[(11)] = inst_21051__$1);

return statearr_21090;
})();
if(inst_21051__$1){
var statearr_21091_21153 = state_21071__$1;
(statearr_21091_21153[(1)] = (15));

} else {
var statearr_21092_21154 = state_21071__$1;
(statearr_21092_21154[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (16))){
var inst_21051 = (state_21071[(11)]);
var state_21071__$1 = state_21071;
var statearr_21093_21155 = state_21071__$1;
(statearr_21093_21155[(2)] = inst_21051);

(statearr_21093_21155[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (10))){
var inst_21043 = (state_21071[(2)]);
var state_21071__$1 = state_21071;
var statearr_21094_21156 = state_21071__$1;
(statearr_21094_21156[(2)] = inst_21043);

(statearr_21094_21156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (18))){
var inst_21054 = (state_21071[(2)]);
var state_21071__$1 = state_21071;
var statearr_21095_21157 = state_21071__$1;
(statearr_21095_21157[(2)] = inst_21054);

(statearr_21095_21157[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21072 === (8))){
var inst_21040 = cljs.core.async.close_BANG_.call(null,to);
var state_21071__$1 = state_21071;
var statearr_21096_21158 = state_21071__$1;
(statearr_21096_21158[(2)] = inst_21040);

(statearr_21096_21158[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__,jobs,results,process,async))
;
return ((function (switch__20400__auto__,c__20554__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0 = (function (){
var statearr_21100 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21100[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__);

(statearr_21100[(1)] = (1));

return statearr_21100;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1 = (function (state_21071){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_21071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e21101){if((e21101 instanceof Object)){
var ex__20404__auto__ = e21101;
var statearr_21102_21159 = state_21071;
(statearr_21102_21159[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21071);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21101;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21160 = state_21071;
state_21071 = G__21160;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__ = function(state_21071){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1.call(this,state_21071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20401__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__,jobs,results,process,async))
})();
var state__20556__auto__ = (function (){var statearr_21103 = f__20555__auto__.call(null);
(statearr_21103[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_21103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__,jobs,results,process,async))
);

return c__20554__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args21161 = [];
var len__19443__auto___21164 = arguments.length;
var i__19444__auto___21165 = (0);
while(true){
if((i__19444__auto___21165 < len__19443__auto___21164)){
args21161.push((arguments[i__19444__auto___21165]));

var G__21166 = (i__19444__auto___21165 + (1));
i__19444__auto___21165 = G__21166;
continue;
} else {
}
break;
}

var G__21163 = args21161.length;
switch (G__21163) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21161.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args21168 = [];
var len__19443__auto___21171 = arguments.length;
var i__19444__auto___21172 = (0);
while(true){
if((i__19444__auto___21172 < len__19443__auto___21171)){
args21168.push((arguments[i__19444__auto___21172]));

var G__21173 = (i__19444__auto___21172 + (1));
i__19444__auto___21172 = G__21173;
continue;
} else {
}
break;
}

var G__21170 = args21168.length;
switch (G__21170) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21168.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args21175 = [];
var len__19443__auto___21228 = arguments.length;
var i__19444__auto___21229 = (0);
while(true){
if((i__19444__auto___21229 < len__19443__auto___21228)){
args21175.push((arguments[i__19444__auto___21229]));

var G__21230 = (i__19444__auto___21229 + (1));
i__19444__auto___21229 = G__21230;
continue;
} else {
}
break;
}

var G__21177 = args21175.length;
switch (G__21177) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21175.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__20554__auto___21232 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___21232,tc,fc){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___21232,tc,fc){
return (function (state_21203){
var state_val_21204 = (state_21203[(1)]);
if((state_val_21204 === (7))){
var inst_21199 = (state_21203[(2)]);
var state_21203__$1 = state_21203;
var statearr_21205_21233 = state_21203__$1;
(statearr_21205_21233[(2)] = inst_21199);

(statearr_21205_21233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (1))){
var state_21203__$1 = state_21203;
var statearr_21206_21234 = state_21203__$1;
(statearr_21206_21234[(2)] = null);

(statearr_21206_21234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (4))){
var inst_21180 = (state_21203[(7)]);
var inst_21180__$1 = (state_21203[(2)]);
var inst_21181 = (inst_21180__$1 == null);
var state_21203__$1 = (function (){var statearr_21207 = state_21203;
(statearr_21207[(7)] = inst_21180__$1);

return statearr_21207;
})();
if(cljs.core.truth_(inst_21181)){
var statearr_21208_21235 = state_21203__$1;
(statearr_21208_21235[(1)] = (5));

} else {
var statearr_21209_21236 = state_21203__$1;
(statearr_21209_21236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (13))){
var state_21203__$1 = state_21203;
var statearr_21210_21237 = state_21203__$1;
(statearr_21210_21237[(2)] = null);

(statearr_21210_21237[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (6))){
var inst_21180 = (state_21203[(7)]);
var inst_21186 = p.call(null,inst_21180);
var state_21203__$1 = state_21203;
if(cljs.core.truth_(inst_21186)){
var statearr_21211_21238 = state_21203__$1;
(statearr_21211_21238[(1)] = (9));

} else {
var statearr_21212_21239 = state_21203__$1;
(statearr_21212_21239[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (3))){
var inst_21201 = (state_21203[(2)]);
var state_21203__$1 = state_21203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21203__$1,inst_21201);
} else {
if((state_val_21204 === (12))){
var state_21203__$1 = state_21203;
var statearr_21213_21240 = state_21203__$1;
(statearr_21213_21240[(2)] = null);

(statearr_21213_21240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (2))){
var state_21203__$1 = state_21203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21203__$1,(4),ch);
} else {
if((state_val_21204 === (11))){
var inst_21180 = (state_21203[(7)]);
var inst_21190 = (state_21203[(2)]);
var state_21203__$1 = state_21203;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21203__$1,(8),inst_21190,inst_21180);
} else {
if((state_val_21204 === (9))){
var state_21203__$1 = state_21203;
var statearr_21214_21241 = state_21203__$1;
(statearr_21214_21241[(2)] = tc);

(statearr_21214_21241[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (5))){
var inst_21183 = cljs.core.async.close_BANG_.call(null,tc);
var inst_21184 = cljs.core.async.close_BANG_.call(null,fc);
var state_21203__$1 = (function (){var statearr_21215 = state_21203;
(statearr_21215[(8)] = inst_21183);

return statearr_21215;
})();
var statearr_21216_21242 = state_21203__$1;
(statearr_21216_21242[(2)] = inst_21184);

(statearr_21216_21242[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (14))){
var inst_21197 = (state_21203[(2)]);
var state_21203__$1 = state_21203;
var statearr_21217_21243 = state_21203__$1;
(statearr_21217_21243[(2)] = inst_21197);

(statearr_21217_21243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (10))){
var state_21203__$1 = state_21203;
var statearr_21218_21244 = state_21203__$1;
(statearr_21218_21244[(2)] = fc);

(statearr_21218_21244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21204 === (8))){
var inst_21192 = (state_21203[(2)]);
var state_21203__$1 = state_21203;
if(cljs.core.truth_(inst_21192)){
var statearr_21219_21245 = state_21203__$1;
(statearr_21219_21245[(1)] = (12));

} else {
var statearr_21220_21246 = state_21203__$1;
(statearr_21220_21246[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___21232,tc,fc))
;
return ((function (switch__20400__auto__,c__20554__auto___21232,tc,fc){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_21224 = [null,null,null,null,null,null,null,null,null];
(statearr_21224[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_21224[(1)] = (1));

return statearr_21224;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_21203){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_21203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e21225){if((e21225 instanceof Object)){
var ex__20404__auto__ = e21225;
var statearr_21226_21247 = state_21203;
(statearr_21226_21247[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21203);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21225;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21248 = state_21203;
state_21203 = G__21248;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_21203){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_21203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___21232,tc,fc))
})();
var state__20556__auto__ = (function (){var statearr_21227 = f__20555__auto__.call(null);
(statearr_21227[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___21232);

return statearr_21227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___21232,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__){
return (function (state_21312){
var state_val_21313 = (state_21312[(1)]);
if((state_val_21313 === (7))){
var inst_21308 = (state_21312[(2)]);
var state_21312__$1 = state_21312;
var statearr_21314_21335 = state_21312__$1;
(statearr_21314_21335[(2)] = inst_21308);

(statearr_21314_21335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21313 === (1))){
var inst_21292 = init;
var state_21312__$1 = (function (){var statearr_21315 = state_21312;
(statearr_21315[(7)] = inst_21292);

return statearr_21315;
})();
var statearr_21316_21336 = state_21312__$1;
(statearr_21316_21336[(2)] = null);

(statearr_21316_21336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21313 === (4))){
var inst_21295 = (state_21312[(8)]);
var inst_21295__$1 = (state_21312[(2)]);
var inst_21296 = (inst_21295__$1 == null);
var state_21312__$1 = (function (){var statearr_21317 = state_21312;
(statearr_21317[(8)] = inst_21295__$1);

return statearr_21317;
})();
if(cljs.core.truth_(inst_21296)){
var statearr_21318_21337 = state_21312__$1;
(statearr_21318_21337[(1)] = (5));

} else {
var statearr_21319_21338 = state_21312__$1;
(statearr_21319_21338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21313 === (6))){
var inst_21295 = (state_21312[(8)]);
var inst_21292 = (state_21312[(7)]);
var inst_21299 = (state_21312[(9)]);
var inst_21299__$1 = f.call(null,inst_21292,inst_21295);
var inst_21300 = cljs.core.reduced_QMARK_.call(null,inst_21299__$1);
var state_21312__$1 = (function (){var statearr_21320 = state_21312;
(statearr_21320[(9)] = inst_21299__$1);

return statearr_21320;
})();
if(inst_21300){
var statearr_21321_21339 = state_21312__$1;
(statearr_21321_21339[(1)] = (8));

} else {
var statearr_21322_21340 = state_21312__$1;
(statearr_21322_21340[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21313 === (3))){
var inst_21310 = (state_21312[(2)]);
var state_21312__$1 = state_21312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21312__$1,inst_21310);
} else {
if((state_val_21313 === (2))){
var state_21312__$1 = state_21312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21312__$1,(4),ch);
} else {
if((state_val_21313 === (9))){
var inst_21299 = (state_21312[(9)]);
var inst_21292 = inst_21299;
var state_21312__$1 = (function (){var statearr_21323 = state_21312;
(statearr_21323[(7)] = inst_21292);

return statearr_21323;
})();
var statearr_21324_21341 = state_21312__$1;
(statearr_21324_21341[(2)] = null);

(statearr_21324_21341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21313 === (5))){
var inst_21292 = (state_21312[(7)]);
var state_21312__$1 = state_21312;
var statearr_21325_21342 = state_21312__$1;
(statearr_21325_21342[(2)] = inst_21292);

(statearr_21325_21342[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21313 === (10))){
var inst_21306 = (state_21312[(2)]);
var state_21312__$1 = state_21312;
var statearr_21326_21343 = state_21312__$1;
(statearr_21326_21343[(2)] = inst_21306);

(statearr_21326_21343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21313 === (8))){
var inst_21299 = (state_21312[(9)]);
var inst_21302 = cljs.core.deref.call(null,inst_21299);
var state_21312__$1 = state_21312;
var statearr_21327_21344 = state_21312__$1;
(statearr_21327_21344[(2)] = inst_21302);

(statearr_21327_21344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__))
;
return ((function (switch__20400__auto__,c__20554__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__20401__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20401__auto____0 = (function (){
var statearr_21331 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21331[(0)] = cljs$core$async$reduce_$_state_machine__20401__auto__);

(statearr_21331[(1)] = (1));

return statearr_21331;
});
var cljs$core$async$reduce_$_state_machine__20401__auto____1 = (function (state_21312){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_21312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e21332){if((e21332 instanceof Object)){
var ex__20404__auto__ = e21332;
var statearr_21333_21345 = state_21312;
(statearr_21333_21345[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21332;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21346 = state_21312;
state_21312 = G__21346;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20401__auto__ = function(state_21312){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20401__auto____1.call(this,state_21312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20401__auto____0;
cljs$core$async$reduce_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20401__auto____1;
return cljs$core$async$reduce_$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__))
})();
var state__20556__auto__ = (function (){var statearr_21334 = f__20555__auto__.call(null);
(statearr_21334[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_21334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__))
);

return c__20554__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args21347 = [];
var len__19443__auto___21399 = arguments.length;
var i__19444__auto___21400 = (0);
while(true){
if((i__19444__auto___21400 < len__19443__auto___21399)){
args21347.push((arguments[i__19444__auto___21400]));

var G__21401 = (i__19444__auto___21400 + (1));
i__19444__auto___21400 = G__21401;
continue;
} else {
}
break;
}

var G__21349 = args21347.length;
switch (G__21349) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21347.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__){
return (function (state_21374){
var state_val_21375 = (state_21374[(1)]);
if((state_val_21375 === (7))){
var inst_21356 = (state_21374[(2)]);
var state_21374__$1 = state_21374;
var statearr_21376_21403 = state_21374__$1;
(statearr_21376_21403[(2)] = inst_21356);

(statearr_21376_21403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (1))){
var inst_21350 = cljs.core.seq.call(null,coll);
var inst_21351 = inst_21350;
var state_21374__$1 = (function (){var statearr_21377 = state_21374;
(statearr_21377[(7)] = inst_21351);

return statearr_21377;
})();
var statearr_21378_21404 = state_21374__$1;
(statearr_21378_21404[(2)] = null);

(statearr_21378_21404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (4))){
var inst_21351 = (state_21374[(7)]);
var inst_21354 = cljs.core.first.call(null,inst_21351);
var state_21374__$1 = state_21374;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21374__$1,(7),ch,inst_21354);
} else {
if((state_val_21375 === (13))){
var inst_21368 = (state_21374[(2)]);
var state_21374__$1 = state_21374;
var statearr_21379_21405 = state_21374__$1;
(statearr_21379_21405[(2)] = inst_21368);

(statearr_21379_21405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (6))){
var inst_21359 = (state_21374[(2)]);
var state_21374__$1 = state_21374;
if(cljs.core.truth_(inst_21359)){
var statearr_21380_21406 = state_21374__$1;
(statearr_21380_21406[(1)] = (8));

} else {
var statearr_21381_21407 = state_21374__$1;
(statearr_21381_21407[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (3))){
var inst_21372 = (state_21374[(2)]);
var state_21374__$1 = state_21374;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21374__$1,inst_21372);
} else {
if((state_val_21375 === (12))){
var state_21374__$1 = state_21374;
var statearr_21382_21408 = state_21374__$1;
(statearr_21382_21408[(2)] = null);

(statearr_21382_21408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (2))){
var inst_21351 = (state_21374[(7)]);
var state_21374__$1 = state_21374;
if(cljs.core.truth_(inst_21351)){
var statearr_21383_21409 = state_21374__$1;
(statearr_21383_21409[(1)] = (4));

} else {
var statearr_21384_21410 = state_21374__$1;
(statearr_21384_21410[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (11))){
var inst_21365 = cljs.core.async.close_BANG_.call(null,ch);
var state_21374__$1 = state_21374;
var statearr_21385_21411 = state_21374__$1;
(statearr_21385_21411[(2)] = inst_21365);

(statearr_21385_21411[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (9))){
var state_21374__$1 = state_21374;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21386_21412 = state_21374__$1;
(statearr_21386_21412[(1)] = (11));

} else {
var statearr_21387_21413 = state_21374__$1;
(statearr_21387_21413[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (5))){
var inst_21351 = (state_21374[(7)]);
var state_21374__$1 = state_21374;
var statearr_21388_21414 = state_21374__$1;
(statearr_21388_21414[(2)] = inst_21351);

(statearr_21388_21414[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (10))){
var inst_21370 = (state_21374[(2)]);
var state_21374__$1 = state_21374;
var statearr_21389_21415 = state_21374__$1;
(statearr_21389_21415[(2)] = inst_21370);

(statearr_21389_21415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21375 === (8))){
var inst_21351 = (state_21374[(7)]);
var inst_21361 = cljs.core.next.call(null,inst_21351);
var inst_21351__$1 = inst_21361;
var state_21374__$1 = (function (){var statearr_21390 = state_21374;
(statearr_21390[(7)] = inst_21351__$1);

return statearr_21390;
})();
var statearr_21391_21416 = state_21374__$1;
(statearr_21391_21416[(2)] = null);

(statearr_21391_21416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__))
;
return ((function (switch__20400__auto__,c__20554__auto__){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_21395 = [null,null,null,null,null,null,null,null];
(statearr_21395[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_21395[(1)] = (1));

return statearr_21395;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_21374){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_21374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e21396){if((e21396 instanceof Object)){
var ex__20404__auto__ = e21396;
var statearr_21397_21417 = state_21374;
(statearr_21397_21417[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21374);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21396;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21418 = state_21374;
state_21374 = G__21418;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_21374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_21374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__))
})();
var state__20556__auto__ = (function (){var statearr_21398 = f__20555__auto__.call(null);
(statearr_21398[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_21398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__))
);

return c__20554__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__19037__auto__ = (((_ == null))?null:_);
var m__19038__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,_);
} else {
var m__19038__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__19038__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m,ch);
} else {
var m__19038__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m);
} else {
var m__19038__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21640 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21640 = (function (mult,ch,cs,meta21641){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta21641 = meta21641;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21642,meta21641__$1){
var self__ = this;
var _21642__$1 = this;
return (new cljs.core.async.t_cljs$core$async21640(self__.mult,self__.ch,self__.cs,meta21641__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21642){
var self__ = this;
var _21642__$1 = this;
return self__.meta21641;
});})(cs))
;

cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21640.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21640.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta21641","meta21641",-479383780,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async21640.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21640.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21640";

cljs.core.async.t_cljs$core$async21640.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async21640");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async21640 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async21640(mult__$1,ch__$1,cs__$1,meta21641){
return (new cljs.core.async.t_cljs$core$async21640(mult__$1,ch__$1,cs__$1,meta21641));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async21640(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__20554__auto___21861 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___21861,cs,m,dchan,dctr,done){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___21861,cs,m,dchan,dctr,done){
return (function (state_21773){
var state_val_21774 = (state_21773[(1)]);
if((state_val_21774 === (7))){
var inst_21769 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21775_21862 = state_21773__$1;
(statearr_21775_21862[(2)] = inst_21769);

(statearr_21775_21862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (20))){
var inst_21674 = (state_21773[(7)]);
var inst_21684 = cljs.core.first.call(null,inst_21674);
var inst_21685 = cljs.core.nth.call(null,inst_21684,(0),null);
var inst_21686 = cljs.core.nth.call(null,inst_21684,(1),null);
var state_21773__$1 = (function (){var statearr_21776 = state_21773;
(statearr_21776[(8)] = inst_21685);

return statearr_21776;
})();
if(cljs.core.truth_(inst_21686)){
var statearr_21777_21863 = state_21773__$1;
(statearr_21777_21863[(1)] = (22));

} else {
var statearr_21778_21864 = state_21773__$1;
(statearr_21778_21864[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (27))){
var inst_21645 = (state_21773[(9)]);
var inst_21716 = (state_21773[(10)]);
var inst_21721 = (state_21773[(11)]);
var inst_21714 = (state_21773[(12)]);
var inst_21721__$1 = cljs.core._nth.call(null,inst_21714,inst_21716);
var inst_21722 = cljs.core.async.put_BANG_.call(null,inst_21721__$1,inst_21645,done);
var state_21773__$1 = (function (){var statearr_21779 = state_21773;
(statearr_21779[(11)] = inst_21721__$1);

return statearr_21779;
})();
if(cljs.core.truth_(inst_21722)){
var statearr_21780_21865 = state_21773__$1;
(statearr_21780_21865[(1)] = (30));

} else {
var statearr_21781_21866 = state_21773__$1;
(statearr_21781_21866[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (1))){
var state_21773__$1 = state_21773;
var statearr_21782_21867 = state_21773__$1;
(statearr_21782_21867[(2)] = null);

(statearr_21782_21867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (24))){
var inst_21674 = (state_21773[(7)]);
var inst_21691 = (state_21773[(2)]);
var inst_21692 = cljs.core.next.call(null,inst_21674);
var inst_21654 = inst_21692;
var inst_21655 = null;
var inst_21656 = (0);
var inst_21657 = (0);
var state_21773__$1 = (function (){var statearr_21783 = state_21773;
(statearr_21783[(13)] = inst_21657);

(statearr_21783[(14)] = inst_21654);

(statearr_21783[(15)] = inst_21656);

(statearr_21783[(16)] = inst_21655);

(statearr_21783[(17)] = inst_21691);

return statearr_21783;
})();
var statearr_21784_21868 = state_21773__$1;
(statearr_21784_21868[(2)] = null);

(statearr_21784_21868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (39))){
var state_21773__$1 = state_21773;
var statearr_21788_21869 = state_21773__$1;
(statearr_21788_21869[(2)] = null);

(statearr_21788_21869[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (4))){
var inst_21645 = (state_21773[(9)]);
var inst_21645__$1 = (state_21773[(2)]);
var inst_21646 = (inst_21645__$1 == null);
var state_21773__$1 = (function (){var statearr_21789 = state_21773;
(statearr_21789[(9)] = inst_21645__$1);

return statearr_21789;
})();
if(cljs.core.truth_(inst_21646)){
var statearr_21790_21870 = state_21773__$1;
(statearr_21790_21870[(1)] = (5));

} else {
var statearr_21791_21871 = state_21773__$1;
(statearr_21791_21871[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (15))){
var inst_21657 = (state_21773[(13)]);
var inst_21654 = (state_21773[(14)]);
var inst_21656 = (state_21773[(15)]);
var inst_21655 = (state_21773[(16)]);
var inst_21670 = (state_21773[(2)]);
var inst_21671 = (inst_21657 + (1));
var tmp21785 = inst_21654;
var tmp21786 = inst_21656;
var tmp21787 = inst_21655;
var inst_21654__$1 = tmp21785;
var inst_21655__$1 = tmp21787;
var inst_21656__$1 = tmp21786;
var inst_21657__$1 = inst_21671;
var state_21773__$1 = (function (){var statearr_21792 = state_21773;
(statearr_21792[(18)] = inst_21670);

(statearr_21792[(13)] = inst_21657__$1);

(statearr_21792[(14)] = inst_21654__$1);

(statearr_21792[(15)] = inst_21656__$1);

(statearr_21792[(16)] = inst_21655__$1);

return statearr_21792;
})();
var statearr_21793_21872 = state_21773__$1;
(statearr_21793_21872[(2)] = null);

(statearr_21793_21872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (21))){
var inst_21695 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21797_21873 = state_21773__$1;
(statearr_21797_21873[(2)] = inst_21695);

(statearr_21797_21873[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (31))){
var inst_21721 = (state_21773[(11)]);
var inst_21725 = done.call(null,null);
var inst_21726 = cljs.core.async.untap_STAR_.call(null,m,inst_21721);
var state_21773__$1 = (function (){var statearr_21798 = state_21773;
(statearr_21798[(19)] = inst_21725);

return statearr_21798;
})();
var statearr_21799_21874 = state_21773__$1;
(statearr_21799_21874[(2)] = inst_21726);

(statearr_21799_21874[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (32))){
var inst_21715 = (state_21773[(20)]);
var inst_21716 = (state_21773[(10)]);
var inst_21714 = (state_21773[(12)]);
var inst_21713 = (state_21773[(21)]);
var inst_21728 = (state_21773[(2)]);
var inst_21729 = (inst_21716 + (1));
var tmp21794 = inst_21715;
var tmp21795 = inst_21714;
var tmp21796 = inst_21713;
var inst_21713__$1 = tmp21796;
var inst_21714__$1 = tmp21795;
var inst_21715__$1 = tmp21794;
var inst_21716__$1 = inst_21729;
var state_21773__$1 = (function (){var statearr_21800 = state_21773;
(statearr_21800[(20)] = inst_21715__$1);

(statearr_21800[(10)] = inst_21716__$1);

(statearr_21800[(12)] = inst_21714__$1);

(statearr_21800[(21)] = inst_21713__$1);

(statearr_21800[(22)] = inst_21728);

return statearr_21800;
})();
var statearr_21801_21875 = state_21773__$1;
(statearr_21801_21875[(2)] = null);

(statearr_21801_21875[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (40))){
var inst_21741 = (state_21773[(23)]);
var inst_21745 = done.call(null,null);
var inst_21746 = cljs.core.async.untap_STAR_.call(null,m,inst_21741);
var state_21773__$1 = (function (){var statearr_21802 = state_21773;
(statearr_21802[(24)] = inst_21745);

return statearr_21802;
})();
var statearr_21803_21876 = state_21773__$1;
(statearr_21803_21876[(2)] = inst_21746);

(statearr_21803_21876[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (33))){
var inst_21732 = (state_21773[(25)]);
var inst_21734 = cljs.core.chunked_seq_QMARK_.call(null,inst_21732);
var state_21773__$1 = state_21773;
if(inst_21734){
var statearr_21804_21877 = state_21773__$1;
(statearr_21804_21877[(1)] = (36));

} else {
var statearr_21805_21878 = state_21773__$1;
(statearr_21805_21878[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (13))){
var inst_21664 = (state_21773[(26)]);
var inst_21667 = cljs.core.async.close_BANG_.call(null,inst_21664);
var state_21773__$1 = state_21773;
var statearr_21806_21879 = state_21773__$1;
(statearr_21806_21879[(2)] = inst_21667);

(statearr_21806_21879[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (22))){
var inst_21685 = (state_21773[(8)]);
var inst_21688 = cljs.core.async.close_BANG_.call(null,inst_21685);
var state_21773__$1 = state_21773;
var statearr_21807_21880 = state_21773__$1;
(statearr_21807_21880[(2)] = inst_21688);

(statearr_21807_21880[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (36))){
var inst_21732 = (state_21773[(25)]);
var inst_21736 = cljs.core.chunk_first.call(null,inst_21732);
var inst_21737 = cljs.core.chunk_rest.call(null,inst_21732);
var inst_21738 = cljs.core.count.call(null,inst_21736);
var inst_21713 = inst_21737;
var inst_21714 = inst_21736;
var inst_21715 = inst_21738;
var inst_21716 = (0);
var state_21773__$1 = (function (){var statearr_21808 = state_21773;
(statearr_21808[(20)] = inst_21715);

(statearr_21808[(10)] = inst_21716);

(statearr_21808[(12)] = inst_21714);

(statearr_21808[(21)] = inst_21713);

return statearr_21808;
})();
var statearr_21809_21881 = state_21773__$1;
(statearr_21809_21881[(2)] = null);

(statearr_21809_21881[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (41))){
var inst_21732 = (state_21773[(25)]);
var inst_21748 = (state_21773[(2)]);
var inst_21749 = cljs.core.next.call(null,inst_21732);
var inst_21713 = inst_21749;
var inst_21714 = null;
var inst_21715 = (0);
var inst_21716 = (0);
var state_21773__$1 = (function (){var statearr_21810 = state_21773;
(statearr_21810[(20)] = inst_21715);

(statearr_21810[(10)] = inst_21716);

(statearr_21810[(12)] = inst_21714);

(statearr_21810[(21)] = inst_21713);

(statearr_21810[(27)] = inst_21748);

return statearr_21810;
})();
var statearr_21811_21882 = state_21773__$1;
(statearr_21811_21882[(2)] = null);

(statearr_21811_21882[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (43))){
var state_21773__$1 = state_21773;
var statearr_21812_21883 = state_21773__$1;
(statearr_21812_21883[(2)] = null);

(statearr_21812_21883[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (29))){
var inst_21757 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21813_21884 = state_21773__$1;
(statearr_21813_21884[(2)] = inst_21757);

(statearr_21813_21884[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (44))){
var inst_21766 = (state_21773[(2)]);
var state_21773__$1 = (function (){var statearr_21814 = state_21773;
(statearr_21814[(28)] = inst_21766);

return statearr_21814;
})();
var statearr_21815_21885 = state_21773__$1;
(statearr_21815_21885[(2)] = null);

(statearr_21815_21885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (6))){
var inst_21705 = (state_21773[(29)]);
var inst_21704 = cljs.core.deref.call(null,cs);
var inst_21705__$1 = cljs.core.keys.call(null,inst_21704);
var inst_21706 = cljs.core.count.call(null,inst_21705__$1);
var inst_21707 = cljs.core.reset_BANG_.call(null,dctr,inst_21706);
var inst_21712 = cljs.core.seq.call(null,inst_21705__$1);
var inst_21713 = inst_21712;
var inst_21714 = null;
var inst_21715 = (0);
var inst_21716 = (0);
var state_21773__$1 = (function (){var statearr_21816 = state_21773;
(statearr_21816[(20)] = inst_21715);

(statearr_21816[(29)] = inst_21705__$1);

(statearr_21816[(10)] = inst_21716);

(statearr_21816[(12)] = inst_21714);

(statearr_21816[(21)] = inst_21713);

(statearr_21816[(30)] = inst_21707);

return statearr_21816;
})();
var statearr_21817_21886 = state_21773__$1;
(statearr_21817_21886[(2)] = null);

(statearr_21817_21886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (28))){
var inst_21713 = (state_21773[(21)]);
var inst_21732 = (state_21773[(25)]);
var inst_21732__$1 = cljs.core.seq.call(null,inst_21713);
var state_21773__$1 = (function (){var statearr_21818 = state_21773;
(statearr_21818[(25)] = inst_21732__$1);

return statearr_21818;
})();
if(inst_21732__$1){
var statearr_21819_21887 = state_21773__$1;
(statearr_21819_21887[(1)] = (33));

} else {
var statearr_21820_21888 = state_21773__$1;
(statearr_21820_21888[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (25))){
var inst_21715 = (state_21773[(20)]);
var inst_21716 = (state_21773[(10)]);
var inst_21718 = (inst_21716 < inst_21715);
var inst_21719 = inst_21718;
var state_21773__$1 = state_21773;
if(cljs.core.truth_(inst_21719)){
var statearr_21821_21889 = state_21773__$1;
(statearr_21821_21889[(1)] = (27));

} else {
var statearr_21822_21890 = state_21773__$1;
(statearr_21822_21890[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (34))){
var state_21773__$1 = state_21773;
var statearr_21823_21891 = state_21773__$1;
(statearr_21823_21891[(2)] = null);

(statearr_21823_21891[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (17))){
var state_21773__$1 = state_21773;
var statearr_21824_21892 = state_21773__$1;
(statearr_21824_21892[(2)] = null);

(statearr_21824_21892[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (3))){
var inst_21771 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21773__$1,inst_21771);
} else {
if((state_val_21774 === (12))){
var inst_21700 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21825_21893 = state_21773__$1;
(statearr_21825_21893[(2)] = inst_21700);

(statearr_21825_21893[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (2))){
var state_21773__$1 = state_21773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21773__$1,(4),ch);
} else {
if((state_val_21774 === (23))){
var state_21773__$1 = state_21773;
var statearr_21826_21894 = state_21773__$1;
(statearr_21826_21894[(2)] = null);

(statearr_21826_21894[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (35))){
var inst_21755 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21827_21895 = state_21773__$1;
(statearr_21827_21895[(2)] = inst_21755);

(statearr_21827_21895[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (19))){
var inst_21674 = (state_21773[(7)]);
var inst_21678 = cljs.core.chunk_first.call(null,inst_21674);
var inst_21679 = cljs.core.chunk_rest.call(null,inst_21674);
var inst_21680 = cljs.core.count.call(null,inst_21678);
var inst_21654 = inst_21679;
var inst_21655 = inst_21678;
var inst_21656 = inst_21680;
var inst_21657 = (0);
var state_21773__$1 = (function (){var statearr_21828 = state_21773;
(statearr_21828[(13)] = inst_21657);

(statearr_21828[(14)] = inst_21654);

(statearr_21828[(15)] = inst_21656);

(statearr_21828[(16)] = inst_21655);

return statearr_21828;
})();
var statearr_21829_21896 = state_21773__$1;
(statearr_21829_21896[(2)] = null);

(statearr_21829_21896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (11))){
var inst_21654 = (state_21773[(14)]);
var inst_21674 = (state_21773[(7)]);
var inst_21674__$1 = cljs.core.seq.call(null,inst_21654);
var state_21773__$1 = (function (){var statearr_21830 = state_21773;
(statearr_21830[(7)] = inst_21674__$1);

return statearr_21830;
})();
if(inst_21674__$1){
var statearr_21831_21897 = state_21773__$1;
(statearr_21831_21897[(1)] = (16));

} else {
var statearr_21832_21898 = state_21773__$1;
(statearr_21832_21898[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (9))){
var inst_21702 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21833_21899 = state_21773__$1;
(statearr_21833_21899[(2)] = inst_21702);

(statearr_21833_21899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (5))){
var inst_21652 = cljs.core.deref.call(null,cs);
var inst_21653 = cljs.core.seq.call(null,inst_21652);
var inst_21654 = inst_21653;
var inst_21655 = null;
var inst_21656 = (0);
var inst_21657 = (0);
var state_21773__$1 = (function (){var statearr_21834 = state_21773;
(statearr_21834[(13)] = inst_21657);

(statearr_21834[(14)] = inst_21654);

(statearr_21834[(15)] = inst_21656);

(statearr_21834[(16)] = inst_21655);

return statearr_21834;
})();
var statearr_21835_21900 = state_21773__$1;
(statearr_21835_21900[(2)] = null);

(statearr_21835_21900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (14))){
var state_21773__$1 = state_21773;
var statearr_21836_21901 = state_21773__$1;
(statearr_21836_21901[(2)] = null);

(statearr_21836_21901[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (45))){
var inst_21763 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21837_21902 = state_21773__$1;
(statearr_21837_21902[(2)] = inst_21763);

(statearr_21837_21902[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (26))){
var inst_21705 = (state_21773[(29)]);
var inst_21759 = (state_21773[(2)]);
var inst_21760 = cljs.core.seq.call(null,inst_21705);
var state_21773__$1 = (function (){var statearr_21838 = state_21773;
(statearr_21838[(31)] = inst_21759);

return statearr_21838;
})();
if(inst_21760){
var statearr_21839_21903 = state_21773__$1;
(statearr_21839_21903[(1)] = (42));

} else {
var statearr_21840_21904 = state_21773__$1;
(statearr_21840_21904[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (16))){
var inst_21674 = (state_21773[(7)]);
var inst_21676 = cljs.core.chunked_seq_QMARK_.call(null,inst_21674);
var state_21773__$1 = state_21773;
if(inst_21676){
var statearr_21841_21905 = state_21773__$1;
(statearr_21841_21905[(1)] = (19));

} else {
var statearr_21842_21906 = state_21773__$1;
(statearr_21842_21906[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (38))){
var inst_21752 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21843_21907 = state_21773__$1;
(statearr_21843_21907[(2)] = inst_21752);

(statearr_21843_21907[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (30))){
var state_21773__$1 = state_21773;
var statearr_21844_21908 = state_21773__$1;
(statearr_21844_21908[(2)] = null);

(statearr_21844_21908[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (10))){
var inst_21657 = (state_21773[(13)]);
var inst_21655 = (state_21773[(16)]);
var inst_21663 = cljs.core._nth.call(null,inst_21655,inst_21657);
var inst_21664 = cljs.core.nth.call(null,inst_21663,(0),null);
var inst_21665 = cljs.core.nth.call(null,inst_21663,(1),null);
var state_21773__$1 = (function (){var statearr_21845 = state_21773;
(statearr_21845[(26)] = inst_21664);

return statearr_21845;
})();
if(cljs.core.truth_(inst_21665)){
var statearr_21846_21909 = state_21773__$1;
(statearr_21846_21909[(1)] = (13));

} else {
var statearr_21847_21910 = state_21773__$1;
(statearr_21847_21910[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (18))){
var inst_21698 = (state_21773[(2)]);
var state_21773__$1 = state_21773;
var statearr_21848_21911 = state_21773__$1;
(statearr_21848_21911[(2)] = inst_21698);

(statearr_21848_21911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (42))){
var state_21773__$1 = state_21773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21773__$1,(45),dchan);
} else {
if((state_val_21774 === (37))){
var inst_21645 = (state_21773[(9)]);
var inst_21741 = (state_21773[(23)]);
var inst_21732 = (state_21773[(25)]);
var inst_21741__$1 = cljs.core.first.call(null,inst_21732);
var inst_21742 = cljs.core.async.put_BANG_.call(null,inst_21741__$1,inst_21645,done);
var state_21773__$1 = (function (){var statearr_21849 = state_21773;
(statearr_21849[(23)] = inst_21741__$1);

return statearr_21849;
})();
if(cljs.core.truth_(inst_21742)){
var statearr_21850_21912 = state_21773__$1;
(statearr_21850_21912[(1)] = (39));

} else {
var statearr_21851_21913 = state_21773__$1;
(statearr_21851_21913[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21774 === (8))){
var inst_21657 = (state_21773[(13)]);
var inst_21656 = (state_21773[(15)]);
var inst_21659 = (inst_21657 < inst_21656);
var inst_21660 = inst_21659;
var state_21773__$1 = state_21773;
if(cljs.core.truth_(inst_21660)){
var statearr_21852_21914 = state_21773__$1;
(statearr_21852_21914[(1)] = (10));

} else {
var statearr_21853_21915 = state_21773__$1;
(statearr_21853_21915[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___21861,cs,m,dchan,dctr,done))
;
return ((function (switch__20400__auto__,c__20554__auto___21861,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__20401__auto__ = null;
var cljs$core$async$mult_$_state_machine__20401__auto____0 = (function (){
var statearr_21857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21857[(0)] = cljs$core$async$mult_$_state_machine__20401__auto__);

(statearr_21857[(1)] = (1));

return statearr_21857;
});
var cljs$core$async$mult_$_state_machine__20401__auto____1 = (function (state_21773){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_21773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e21858){if((e21858 instanceof Object)){
var ex__20404__auto__ = e21858;
var statearr_21859_21916 = state_21773;
(statearr_21859_21916[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21858;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21917 = state_21773;
state_21773 = G__21917;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20401__auto__ = function(state_21773){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20401__auto____1.call(this,state_21773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20401__auto____0;
cljs$core$async$mult_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20401__auto____1;
return cljs$core$async$mult_$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___21861,cs,m,dchan,dctr,done))
})();
var state__20556__auto__ = (function (){var statearr_21860 = f__20555__auto__.call(null);
(statearr_21860[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___21861);

return statearr_21860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___21861,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21918 = [];
var len__19443__auto___21921 = arguments.length;
var i__19444__auto___21922 = (0);
while(true){
if((i__19444__auto___21922 < len__19443__auto___21921)){
args21918.push((arguments[i__19444__auto___21922]));

var G__21923 = (i__19444__auto___21922 + (1));
i__19444__auto___21922 = G__21923;
continue;
} else {
}
break;
}

var G__21920 = args21918.length;
switch (G__21920) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21918.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m,ch);
} else {
var m__19038__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m,ch);
} else {
var m__19038__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m);
} else {
var m__19038__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m,state_map);
} else {
var m__19038__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__19037__auto__ = (((m == null))?null:m);
var m__19038__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,m,mode);
} else {
var m__19038__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___21935 = arguments.length;
var i__19444__auto___21936 = (0);
while(true){
if((i__19444__auto___21936 < len__19443__auto___21935)){
args__19450__auto__.push((arguments[i__19444__auto___21936]));

var G__21937 = (i__19444__auto___21936 + (1));
i__19444__auto___21936 = G__21937;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((3) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19451__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21929){
var map__21930 = p__21929;
var map__21930__$1 = ((((!((map__21930 == null)))?((((map__21930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21930):map__21930);
var opts = map__21930__$1;
var statearr_21932_21938 = state;
(statearr_21932_21938[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__21930,map__21930__$1,opts){
return (function (val){
var statearr_21933_21939 = state;
(statearr_21933_21939[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__21930,map__21930__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_21934_21940 = state;
(statearr_21934_21940[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21925){
var G__21926 = cljs.core.first.call(null,seq21925);
var seq21925__$1 = cljs.core.next.call(null,seq21925);
var G__21927 = cljs.core.first.call(null,seq21925__$1);
var seq21925__$2 = cljs.core.next.call(null,seq21925__$1);
var G__21928 = cljs.core.first.call(null,seq21925__$2);
var seq21925__$3 = cljs.core.next.call(null,seq21925__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21926,G__21927,G__21928,seq21925__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async22104 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22104 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta22105){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta22105 = meta22105;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_22106,meta22105__$1){
var self__ = this;
var _22106__$1 = this;
return (new cljs.core.async.t_cljs$core$async22104(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta22105__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_22106){
var self__ = this;
var _22106__$1 = this;
return self__.meta22105;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta22105","meta22105",-1524158648,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22104.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22104.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22104";

cljs.core.async.t_cljs$core$async22104.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async22104");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async22104 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async22104(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta22105){
return (new cljs.core.async.t_cljs$core$async22104(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta22105));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async22104(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20554__auto___22267 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___22267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___22267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_22204){
var state_val_22205 = (state_22204[(1)]);
if((state_val_22205 === (7))){
var inst_22122 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
var statearr_22206_22268 = state_22204__$1;
(statearr_22206_22268[(2)] = inst_22122);

(statearr_22206_22268[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (20))){
var inst_22134 = (state_22204[(7)]);
var state_22204__$1 = state_22204;
var statearr_22207_22269 = state_22204__$1;
(statearr_22207_22269[(2)] = inst_22134);

(statearr_22207_22269[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (27))){
var state_22204__$1 = state_22204;
var statearr_22208_22270 = state_22204__$1;
(statearr_22208_22270[(2)] = null);

(statearr_22208_22270[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (1))){
var inst_22110 = (state_22204[(8)]);
var inst_22110__$1 = calc_state.call(null);
var inst_22112 = (inst_22110__$1 == null);
var inst_22113 = cljs.core.not.call(null,inst_22112);
var state_22204__$1 = (function (){var statearr_22209 = state_22204;
(statearr_22209[(8)] = inst_22110__$1);

return statearr_22209;
})();
if(inst_22113){
var statearr_22210_22271 = state_22204__$1;
(statearr_22210_22271[(1)] = (2));

} else {
var statearr_22211_22272 = state_22204__$1;
(statearr_22211_22272[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (24))){
var inst_22164 = (state_22204[(9)]);
var inst_22178 = (state_22204[(10)]);
var inst_22157 = (state_22204[(11)]);
var inst_22178__$1 = inst_22157.call(null,inst_22164);
var state_22204__$1 = (function (){var statearr_22212 = state_22204;
(statearr_22212[(10)] = inst_22178__$1);

return statearr_22212;
})();
if(cljs.core.truth_(inst_22178__$1)){
var statearr_22213_22273 = state_22204__$1;
(statearr_22213_22273[(1)] = (29));

} else {
var statearr_22214_22274 = state_22204__$1;
(statearr_22214_22274[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (4))){
var inst_22125 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
if(cljs.core.truth_(inst_22125)){
var statearr_22215_22275 = state_22204__$1;
(statearr_22215_22275[(1)] = (8));

} else {
var statearr_22216_22276 = state_22204__$1;
(statearr_22216_22276[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (15))){
var inst_22151 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
if(cljs.core.truth_(inst_22151)){
var statearr_22217_22277 = state_22204__$1;
(statearr_22217_22277[(1)] = (19));

} else {
var statearr_22218_22278 = state_22204__$1;
(statearr_22218_22278[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (21))){
var inst_22156 = (state_22204[(12)]);
var inst_22156__$1 = (state_22204[(2)]);
var inst_22157 = cljs.core.get.call(null,inst_22156__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22158 = cljs.core.get.call(null,inst_22156__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22159 = cljs.core.get.call(null,inst_22156__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_22204__$1 = (function (){var statearr_22219 = state_22204;
(statearr_22219[(12)] = inst_22156__$1);

(statearr_22219[(13)] = inst_22158);

(statearr_22219[(11)] = inst_22157);

return statearr_22219;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_22204__$1,(22),inst_22159);
} else {
if((state_val_22205 === (31))){
var inst_22186 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
if(cljs.core.truth_(inst_22186)){
var statearr_22220_22279 = state_22204__$1;
(statearr_22220_22279[(1)] = (32));

} else {
var statearr_22221_22280 = state_22204__$1;
(statearr_22221_22280[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (32))){
var inst_22163 = (state_22204[(14)]);
var state_22204__$1 = state_22204;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22204__$1,(35),out,inst_22163);
} else {
if((state_val_22205 === (33))){
var inst_22156 = (state_22204[(12)]);
var inst_22134 = inst_22156;
var state_22204__$1 = (function (){var statearr_22222 = state_22204;
(statearr_22222[(7)] = inst_22134);

return statearr_22222;
})();
var statearr_22223_22281 = state_22204__$1;
(statearr_22223_22281[(2)] = null);

(statearr_22223_22281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (13))){
var inst_22134 = (state_22204[(7)]);
var inst_22141 = inst_22134.cljs$lang$protocol_mask$partition0$;
var inst_22142 = (inst_22141 & (64));
var inst_22143 = inst_22134.cljs$core$ISeq$;
var inst_22144 = (inst_22142) || (inst_22143);
var state_22204__$1 = state_22204;
if(cljs.core.truth_(inst_22144)){
var statearr_22224_22282 = state_22204__$1;
(statearr_22224_22282[(1)] = (16));

} else {
var statearr_22225_22283 = state_22204__$1;
(statearr_22225_22283[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (22))){
var inst_22164 = (state_22204[(9)]);
var inst_22163 = (state_22204[(14)]);
var inst_22162 = (state_22204[(2)]);
var inst_22163__$1 = cljs.core.nth.call(null,inst_22162,(0),null);
var inst_22164__$1 = cljs.core.nth.call(null,inst_22162,(1),null);
var inst_22165 = (inst_22163__$1 == null);
var inst_22166 = cljs.core._EQ_.call(null,inst_22164__$1,change);
var inst_22167 = (inst_22165) || (inst_22166);
var state_22204__$1 = (function (){var statearr_22226 = state_22204;
(statearr_22226[(9)] = inst_22164__$1);

(statearr_22226[(14)] = inst_22163__$1);

return statearr_22226;
})();
if(cljs.core.truth_(inst_22167)){
var statearr_22227_22284 = state_22204__$1;
(statearr_22227_22284[(1)] = (23));

} else {
var statearr_22228_22285 = state_22204__$1;
(statearr_22228_22285[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (36))){
var inst_22156 = (state_22204[(12)]);
var inst_22134 = inst_22156;
var state_22204__$1 = (function (){var statearr_22229 = state_22204;
(statearr_22229[(7)] = inst_22134);

return statearr_22229;
})();
var statearr_22230_22286 = state_22204__$1;
(statearr_22230_22286[(2)] = null);

(statearr_22230_22286[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (29))){
var inst_22178 = (state_22204[(10)]);
var state_22204__$1 = state_22204;
var statearr_22231_22287 = state_22204__$1;
(statearr_22231_22287[(2)] = inst_22178);

(statearr_22231_22287[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (6))){
var state_22204__$1 = state_22204;
var statearr_22232_22288 = state_22204__$1;
(statearr_22232_22288[(2)] = false);

(statearr_22232_22288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (28))){
var inst_22174 = (state_22204[(2)]);
var inst_22175 = calc_state.call(null);
var inst_22134 = inst_22175;
var state_22204__$1 = (function (){var statearr_22233 = state_22204;
(statearr_22233[(15)] = inst_22174);

(statearr_22233[(7)] = inst_22134);

return statearr_22233;
})();
var statearr_22234_22289 = state_22204__$1;
(statearr_22234_22289[(2)] = null);

(statearr_22234_22289[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (25))){
var inst_22200 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
var statearr_22235_22290 = state_22204__$1;
(statearr_22235_22290[(2)] = inst_22200);

(statearr_22235_22290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (34))){
var inst_22198 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
var statearr_22236_22291 = state_22204__$1;
(statearr_22236_22291[(2)] = inst_22198);

(statearr_22236_22291[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (17))){
var state_22204__$1 = state_22204;
var statearr_22237_22292 = state_22204__$1;
(statearr_22237_22292[(2)] = false);

(statearr_22237_22292[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (3))){
var state_22204__$1 = state_22204;
var statearr_22238_22293 = state_22204__$1;
(statearr_22238_22293[(2)] = false);

(statearr_22238_22293[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (12))){
var inst_22202 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22204__$1,inst_22202);
} else {
if((state_val_22205 === (2))){
var inst_22110 = (state_22204[(8)]);
var inst_22115 = inst_22110.cljs$lang$protocol_mask$partition0$;
var inst_22116 = (inst_22115 & (64));
var inst_22117 = inst_22110.cljs$core$ISeq$;
var inst_22118 = (inst_22116) || (inst_22117);
var state_22204__$1 = state_22204;
if(cljs.core.truth_(inst_22118)){
var statearr_22239_22294 = state_22204__$1;
(statearr_22239_22294[(1)] = (5));

} else {
var statearr_22240_22295 = state_22204__$1;
(statearr_22240_22295[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (23))){
var inst_22163 = (state_22204[(14)]);
var inst_22169 = (inst_22163 == null);
var state_22204__$1 = state_22204;
if(cljs.core.truth_(inst_22169)){
var statearr_22241_22296 = state_22204__$1;
(statearr_22241_22296[(1)] = (26));

} else {
var statearr_22242_22297 = state_22204__$1;
(statearr_22242_22297[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (35))){
var inst_22189 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
if(cljs.core.truth_(inst_22189)){
var statearr_22243_22298 = state_22204__$1;
(statearr_22243_22298[(1)] = (36));

} else {
var statearr_22244_22299 = state_22204__$1;
(statearr_22244_22299[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (19))){
var inst_22134 = (state_22204[(7)]);
var inst_22153 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22134);
var state_22204__$1 = state_22204;
var statearr_22245_22300 = state_22204__$1;
(statearr_22245_22300[(2)] = inst_22153);

(statearr_22245_22300[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (11))){
var inst_22134 = (state_22204[(7)]);
var inst_22138 = (inst_22134 == null);
var inst_22139 = cljs.core.not.call(null,inst_22138);
var state_22204__$1 = state_22204;
if(inst_22139){
var statearr_22246_22301 = state_22204__$1;
(statearr_22246_22301[(1)] = (13));

} else {
var statearr_22247_22302 = state_22204__$1;
(statearr_22247_22302[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (9))){
var inst_22110 = (state_22204[(8)]);
var state_22204__$1 = state_22204;
var statearr_22248_22303 = state_22204__$1;
(statearr_22248_22303[(2)] = inst_22110);

(statearr_22248_22303[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (5))){
var state_22204__$1 = state_22204;
var statearr_22249_22304 = state_22204__$1;
(statearr_22249_22304[(2)] = true);

(statearr_22249_22304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (14))){
var state_22204__$1 = state_22204;
var statearr_22250_22305 = state_22204__$1;
(statearr_22250_22305[(2)] = false);

(statearr_22250_22305[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (26))){
var inst_22164 = (state_22204[(9)]);
var inst_22171 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_22164);
var state_22204__$1 = state_22204;
var statearr_22251_22306 = state_22204__$1;
(statearr_22251_22306[(2)] = inst_22171);

(statearr_22251_22306[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (16))){
var state_22204__$1 = state_22204;
var statearr_22252_22307 = state_22204__$1;
(statearr_22252_22307[(2)] = true);

(statearr_22252_22307[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (38))){
var inst_22194 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
var statearr_22253_22308 = state_22204__$1;
(statearr_22253_22308[(2)] = inst_22194);

(statearr_22253_22308[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (30))){
var inst_22164 = (state_22204[(9)]);
var inst_22158 = (state_22204[(13)]);
var inst_22157 = (state_22204[(11)]);
var inst_22181 = cljs.core.empty_QMARK_.call(null,inst_22157);
var inst_22182 = inst_22158.call(null,inst_22164);
var inst_22183 = cljs.core.not.call(null,inst_22182);
var inst_22184 = (inst_22181) && (inst_22183);
var state_22204__$1 = state_22204;
var statearr_22254_22309 = state_22204__$1;
(statearr_22254_22309[(2)] = inst_22184);

(statearr_22254_22309[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (10))){
var inst_22110 = (state_22204[(8)]);
var inst_22130 = (state_22204[(2)]);
var inst_22131 = cljs.core.get.call(null,inst_22130,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22132 = cljs.core.get.call(null,inst_22130,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22133 = cljs.core.get.call(null,inst_22130,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_22134 = inst_22110;
var state_22204__$1 = (function (){var statearr_22255 = state_22204;
(statearr_22255[(16)] = inst_22132);

(statearr_22255[(7)] = inst_22134);

(statearr_22255[(17)] = inst_22131);

(statearr_22255[(18)] = inst_22133);

return statearr_22255;
})();
var statearr_22256_22310 = state_22204__$1;
(statearr_22256_22310[(2)] = null);

(statearr_22256_22310[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (18))){
var inst_22148 = (state_22204[(2)]);
var state_22204__$1 = state_22204;
var statearr_22257_22311 = state_22204__$1;
(statearr_22257_22311[(2)] = inst_22148);

(statearr_22257_22311[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (37))){
var state_22204__$1 = state_22204;
var statearr_22258_22312 = state_22204__$1;
(statearr_22258_22312[(2)] = null);

(statearr_22258_22312[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22205 === (8))){
var inst_22110 = (state_22204[(8)]);
var inst_22127 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22110);
var state_22204__$1 = state_22204;
var statearr_22259_22313 = state_22204__$1;
(statearr_22259_22313[(2)] = inst_22127);

(statearr_22259_22313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___22267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__20400__auto__,c__20554__auto___22267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__20401__auto__ = null;
var cljs$core$async$mix_$_state_machine__20401__auto____0 = (function (){
var statearr_22263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22263[(0)] = cljs$core$async$mix_$_state_machine__20401__auto__);

(statearr_22263[(1)] = (1));

return statearr_22263;
});
var cljs$core$async$mix_$_state_machine__20401__auto____1 = (function (state_22204){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_22204);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e22264){if((e22264 instanceof Object)){
var ex__20404__auto__ = e22264;
var statearr_22265_22314 = state_22204;
(statearr_22265_22314[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22204);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22264;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22315 = state_22204;
state_22204 = G__22315;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20401__auto__ = function(state_22204){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20401__auto____1.call(this,state_22204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20401__auto____0;
cljs$core$async$mix_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20401__auto____1;
return cljs$core$async$mix_$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___22267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__20556__auto__ = (function (){var statearr_22266 = f__20555__auto__.call(null);
(statearr_22266[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___22267);

return statearr_22266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___22267,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__19037__auto__ = (((p == null))?null:p);
var m__19038__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__19038__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__19037__auto__ = (((p == null))?null:p);
var m__19038__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,p,v,ch);
} else {
var m__19038__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args22316 = [];
var len__19443__auto___22319 = arguments.length;
var i__19444__auto___22320 = (0);
while(true){
if((i__19444__auto___22320 < len__19443__auto___22319)){
args22316.push((arguments[i__19444__auto___22320]));

var G__22321 = (i__19444__auto___22320 + (1));
i__19444__auto___22320 = G__22321;
continue;
} else {
}
break;
}

var G__22318 = args22316.length;
switch (G__22318) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22316.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__19037__auto__ = (((p == null))?null:p);
var m__19038__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,p);
} else {
var m__19038__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__19037__auto__ = (((p == null))?null:p);
var m__19038__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,p,v);
} else {
var m__19038__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args22324 = [];
var len__19443__auto___22449 = arguments.length;
var i__19444__auto___22450 = (0);
while(true){
if((i__19444__auto___22450 < len__19443__auto___22449)){
args22324.push((arguments[i__19444__auto___22450]));

var G__22451 = (i__19444__auto___22450 + (1));
i__19444__auto___22450 = G__22451;
continue;
} else {
}
break;
}

var G__22326 = args22324.length;
switch (G__22326) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22324.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18374__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18374__auto__,mults){
return (function (p1__22323_SHARP_){
if(cljs.core.truth_(p1__22323_SHARP_.call(null,topic))){
return p1__22323_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__22323_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18374__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async22327 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22327 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta22328){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta22328 = meta22328;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_22329,meta22328__$1){
var self__ = this;
var _22329__$1 = this;
return (new cljs.core.async.t_cljs$core$async22327(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta22328__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_22329){
var self__ = this;
var _22329__$1 = this;
return self__.meta22328;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta22328","meta22328",2106867840,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22327.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22327.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22327";

cljs.core.async.t_cljs$core$async22327.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async22327");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async22327 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async22327(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22328){
return (new cljs.core.async.t_cljs$core$async22327(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22328));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async22327(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20554__auto___22453 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___22453,mults,ensure_mult,p){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___22453,mults,ensure_mult,p){
return (function (state_22401){
var state_val_22402 = (state_22401[(1)]);
if((state_val_22402 === (7))){
var inst_22397 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
var statearr_22403_22454 = state_22401__$1;
(statearr_22403_22454[(2)] = inst_22397);

(statearr_22403_22454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (20))){
var state_22401__$1 = state_22401;
var statearr_22404_22455 = state_22401__$1;
(statearr_22404_22455[(2)] = null);

(statearr_22404_22455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (1))){
var state_22401__$1 = state_22401;
var statearr_22405_22456 = state_22401__$1;
(statearr_22405_22456[(2)] = null);

(statearr_22405_22456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (24))){
var inst_22380 = (state_22401[(7)]);
var inst_22389 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_22380);
var state_22401__$1 = state_22401;
var statearr_22406_22457 = state_22401__$1;
(statearr_22406_22457[(2)] = inst_22389);

(statearr_22406_22457[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (4))){
var inst_22332 = (state_22401[(8)]);
var inst_22332__$1 = (state_22401[(2)]);
var inst_22333 = (inst_22332__$1 == null);
var state_22401__$1 = (function (){var statearr_22407 = state_22401;
(statearr_22407[(8)] = inst_22332__$1);

return statearr_22407;
})();
if(cljs.core.truth_(inst_22333)){
var statearr_22408_22458 = state_22401__$1;
(statearr_22408_22458[(1)] = (5));

} else {
var statearr_22409_22459 = state_22401__$1;
(statearr_22409_22459[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (15))){
var inst_22374 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
var statearr_22410_22460 = state_22401__$1;
(statearr_22410_22460[(2)] = inst_22374);

(statearr_22410_22460[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (21))){
var inst_22394 = (state_22401[(2)]);
var state_22401__$1 = (function (){var statearr_22411 = state_22401;
(statearr_22411[(9)] = inst_22394);

return statearr_22411;
})();
var statearr_22412_22461 = state_22401__$1;
(statearr_22412_22461[(2)] = null);

(statearr_22412_22461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (13))){
var inst_22356 = (state_22401[(10)]);
var inst_22358 = cljs.core.chunked_seq_QMARK_.call(null,inst_22356);
var state_22401__$1 = state_22401;
if(inst_22358){
var statearr_22413_22462 = state_22401__$1;
(statearr_22413_22462[(1)] = (16));

} else {
var statearr_22414_22463 = state_22401__$1;
(statearr_22414_22463[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (22))){
var inst_22386 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
if(cljs.core.truth_(inst_22386)){
var statearr_22415_22464 = state_22401__$1;
(statearr_22415_22464[(1)] = (23));

} else {
var statearr_22416_22465 = state_22401__$1;
(statearr_22416_22465[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (6))){
var inst_22380 = (state_22401[(7)]);
var inst_22382 = (state_22401[(11)]);
var inst_22332 = (state_22401[(8)]);
var inst_22380__$1 = topic_fn.call(null,inst_22332);
var inst_22381 = cljs.core.deref.call(null,mults);
var inst_22382__$1 = cljs.core.get.call(null,inst_22381,inst_22380__$1);
var state_22401__$1 = (function (){var statearr_22417 = state_22401;
(statearr_22417[(7)] = inst_22380__$1);

(statearr_22417[(11)] = inst_22382__$1);

return statearr_22417;
})();
if(cljs.core.truth_(inst_22382__$1)){
var statearr_22418_22466 = state_22401__$1;
(statearr_22418_22466[(1)] = (19));

} else {
var statearr_22419_22467 = state_22401__$1;
(statearr_22419_22467[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (25))){
var inst_22391 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
var statearr_22420_22468 = state_22401__$1;
(statearr_22420_22468[(2)] = inst_22391);

(statearr_22420_22468[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (17))){
var inst_22356 = (state_22401[(10)]);
var inst_22365 = cljs.core.first.call(null,inst_22356);
var inst_22366 = cljs.core.async.muxch_STAR_.call(null,inst_22365);
var inst_22367 = cljs.core.async.close_BANG_.call(null,inst_22366);
var inst_22368 = cljs.core.next.call(null,inst_22356);
var inst_22342 = inst_22368;
var inst_22343 = null;
var inst_22344 = (0);
var inst_22345 = (0);
var state_22401__$1 = (function (){var statearr_22421 = state_22401;
(statearr_22421[(12)] = inst_22367);

(statearr_22421[(13)] = inst_22344);

(statearr_22421[(14)] = inst_22345);

(statearr_22421[(15)] = inst_22343);

(statearr_22421[(16)] = inst_22342);

return statearr_22421;
})();
var statearr_22422_22469 = state_22401__$1;
(statearr_22422_22469[(2)] = null);

(statearr_22422_22469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (3))){
var inst_22399 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22401__$1,inst_22399);
} else {
if((state_val_22402 === (12))){
var inst_22376 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
var statearr_22423_22470 = state_22401__$1;
(statearr_22423_22470[(2)] = inst_22376);

(statearr_22423_22470[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (2))){
var state_22401__$1 = state_22401;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22401__$1,(4),ch);
} else {
if((state_val_22402 === (23))){
var state_22401__$1 = state_22401;
var statearr_22424_22471 = state_22401__$1;
(statearr_22424_22471[(2)] = null);

(statearr_22424_22471[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (19))){
var inst_22382 = (state_22401[(11)]);
var inst_22332 = (state_22401[(8)]);
var inst_22384 = cljs.core.async.muxch_STAR_.call(null,inst_22382);
var state_22401__$1 = state_22401;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22401__$1,(22),inst_22384,inst_22332);
} else {
if((state_val_22402 === (11))){
var inst_22356 = (state_22401[(10)]);
var inst_22342 = (state_22401[(16)]);
var inst_22356__$1 = cljs.core.seq.call(null,inst_22342);
var state_22401__$1 = (function (){var statearr_22425 = state_22401;
(statearr_22425[(10)] = inst_22356__$1);

return statearr_22425;
})();
if(inst_22356__$1){
var statearr_22426_22472 = state_22401__$1;
(statearr_22426_22472[(1)] = (13));

} else {
var statearr_22427_22473 = state_22401__$1;
(statearr_22427_22473[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (9))){
var inst_22378 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
var statearr_22428_22474 = state_22401__$1;
(statearr_22428_22474[(2)] = inst_22378);

(statearr_22428_22474[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (5))){
var inst_22339 = cljs.core.deref.call(null,mults);
var inst_22340 = cljs.core.vals.call(null,inst_22339);
var inst_22341 = cljs.core.seq.call(null,inst_22340);
var inst_22342 = inst_22341;
var inst_22343 = null;
var inst_22344 = (0);
var inst_22345 = (0);
var state_22401__$1 = (function (){var statearr_22429 = state_22401;
(statearr_22429[(13)] = inst_22344);

(statearr_22429[(14)] = inst_22345);

(statearr_22429[(15)] = inst_22343);

(statearr_22429[(16)] = inst_22342);

return statearr_22429;
})();
var statearr_22430_22475 = state_22401__$1;
(statearr_22430_22475[(2)] = null);

(statearr_22430_22475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (14))){
var state_22401__$1 = state_22401;
var statearr_22434_22476 = state_22401__$1;
(statearr_22434_22476[(2)] = null);

(statearr_22434_22476[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (16))){
var inst_22356 = (state_22401[(10)]);
var inst_22360 = cljs.core.chunk_first.call(null,inst_22356);
var inst_22361 = cljs.core.chunk_rest.call(null,inst_22356);
var inst_22362 = cljs.core.count.call(null,inst_22360);
var inst_22342 = inst_22361;
var inst_22343 = inst_22360;
var inst_22344 = inst_22362;
var inst_22345 = (0);
var state_22401__$1 = (function (){var statearr_22435 = state_22401;
(statearr_22435[(13)] = inst_22344);

(statearr_22435[(14)] = inst_22345);

(statearr_22435[(15)] = inst_22343);

(statearr_22435[(16)] = inst_22342);

return statearr_22435;
})();
var statearr_22436_22477 = state_22401__$1;
(statearr_22436_22477[(2)] = null);

(statearr_22436_22477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (10))){
var inst_22344 = (state_22401[(13)]);
var inst_22345 = (state_22401[(14)]);
var inst_22343 = (state_22401[(15)]);
var inst_22342 = (state_22401[(16)]);
var inst_22350 = cljs.core._nth.call(null,inst_22343,inst_22345);
var inst_22351 = cljs.core.async.muxch_STAR_.call(null,inst_22350);
var inst_22352 = cljs.core.async.close_BANG_.call(null,inst_22351);
var inst_22353 = (inst_22345 + (1));
var tmp22431 = inst_22344;
var tmp22432 = inst_22343;
var tmp22433 = inst_22342;
var inst_22342__$1 = tmp22433;
var inst_22343__$1 = tmp22432;
var inst_22344__$1 = tmp22431;
var inst_22345__$1 = inst_22353;
var state_22401__$1 = (function (){var statearr_22437 = state_22401;
(statearr_22437[(13)] = inst_22344__$1);

(statearr_22437[(14)] = inst_22345__$1);

(statearr_22437[(15)] = inst_22343__$1);

(statearr_22437[(16)] = inst_22342__$1);

(statearr_22437[(17)] = inst_22352);

return statearr_22437;
})();
var statearr_22438_22478 = state_22401__$1;
(statearr_22438_22478[(2)] = null);

(statearr_22438_22478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (18))){
var inst_22371 = (state_22401[(2)]);
var state_22401__$1 = state_22401;
var statearr_22439_22479 = state_22401__$1;
(statearr_22439_22479[(2)] = inst_22371);

(statearr_22439_22479[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22402 === (8))){
var inst_22344 = (state_22401[(13)]);
var inst_22345 = (state_22401[(14)]);
var inst_22347 = (inst_22345 < inst_22344);
var inst_22348 = inst_22347;
var state_22401__$1 = state_22401;
if(cljs.core.truth_(inst_22348)){
var statearr_22440_22480 = state_22401__$1;
(statearr_22440_22480[(1)] = (10));

} else {
var statearr_22441_22481 = state_22401__$1;
(statearr_22441_22481[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___22453,mults,ensure_mult,p))
;
return ((function (switch__20400__auto__,c__20554__auto___22453,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_22445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22445[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_22445[(1)] = (1));

return statearr_22445;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_22401){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_22401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e22446){if((e22446 instanceof Object)){
var ex__20404__auto__ = e22446;
var statearr_22447_22482 = state_22401;
(statearr_22447_22482[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22401);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22483 = state_22401;
state_22401 = G__22483;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_22401){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_22401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___22453,mults,ensure_mult,p))
})();
var state__20556__auto__ = (function (){var statearr_22448 = f__20555__auto__.call(null);
(statearr_22448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___22453);

return statearr_22448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___22453,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args22484 = [];
var len__19443__auto___22487 = arguments.length;
var i__19444__auto___22488 = (0);
while(true){
if((i__19444__auto___22488 < len__19443__auto___22487)){
args22484.push((arguments[i__19444__auto___22488]));

var G__22489 = (i__19444__auto___22488 + (1));
i__19444__auto___22488 = G__22489;
continue;
} else {
}
break;
}

var G__22486 = args22484.length;
switch (G__22486) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22484.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args22491 = [];
var len__19443__auto___22494 = arguments.length;
var i__19444__auto___22495 = (0);
while(true){
if((i__19444__auto___22495 < len__19443__auto___22494)){
args22491.push((arguments[i__19444__auto___22495]));

var G__22496 = (i__19444__auto___22495 + (1));
i__19444__auto___22495 = G__22496;
continue;
} else {
}
break;
}

var G__22493 = args22491.length;
switch (G__22493) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22491.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args22498 = [];
var len__19443__auto___22569 = arguments.length;
var i__19444__auto___22570 = (0);
while(true){
if((i__19444__auto___22570 < len__19443__auto___22569)){
args22498.push((arguments[i__19444__auto___22570]));

var G__22571 = (i__19444__auto___22570 + (1));
i__19444__auto___22570 = G__22571;
continue;
} else {
}
break;
}

var G__22500 = args22498.length;
switch (G__22500) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22498.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__20554__auto___22573 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___22573,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___22573,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_22539){
var state_val_22540 = (state_22539[(1)]);
if((state_val_22540 === (7))){
var state_22539__$1 = state_22539;
var statearr_22541_22574 = state_22539__$1;
(statearr_22541_22574[(2)] = null);

(statearr_22541_22574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (1))){
var state_22539__$1 = state_22539;
var statearr_22542_22575 = state_22539__$1;
(statearr_22542_22575[(2)] = null);

(statearr_22542_22575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (4))){
var inst_22503 = (state_22539[(7)]);
var inst_22505 = (inst_22503 < cnt);
var state_22539__$1 = state_22539;
if(cljs.core.truth_(inst_22505)){
var statearr_22543_22576 = state_22539__$1;
(statearr_22543_22576[(1)] = (6));

} else {
var statearr_22544_22577 = state_22539__$1;
(statearr_22544_22577[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (15))){
var inst_22535 = (state_22539[(2)]);
var state_22539__$1 = state_22539;
var statearr_22545_22578 = state_22539__$1;
(statearr_22545_22578[(2)] = inst_22535);

(statearr_22545_22578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (13))){
var inst_22528 = cljs.core.async.close_BANG_.call(null,out);
var state_22539__$1 = state_22539;
var statearr_22546_22579 = state_22539__$1;
(statearr_22546_22579[(2)] = inst_22528);

(statearr_22546_22579[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (6))){
var state_22539__$1 = state_22539;
var statearr_22547_22580 = state_22539__$1;
(statearr_22547_22580[(2)] = null);

(statearr_22547_22580[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (3))){
var inst_22537 = (state_22539[(2)]);
var state_22539__$1 = state_22539;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22539__$1,inst_22537);
} else {
if((state_val_22540 === (12))){
var inst_22525 = (state_22539[(8)]);
var inst_22525__$1 = (state_22539[(2)]);
var inst_22526 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_22525__$1);
var state_22539__$1 = (function (){var statearr_22548 = state_22539;
(statearr_22548[(8)] = inst_22525__$1);

return statearr_22548;
})();
if(cljs.core.truth_(inst_22526)){
var statearr_22549_22581 = state_22539__$1;
(statearr_22549_22581[(1)] = (13));

} else {
var statearr_22550_22582 = state_22539__$1;
(statearr_22550_22582[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (2))){
var inst_22502 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_22503 = (0);
var state_22539__$1 = (function (){var statearr_22551 = state_22539;
(statearr_22551[(9)] = inst_22502);

(statearr_22551[(7)] = inst_22503);

return statearr_22551;
})();
var statearr_22552_22583 = state_22539__$1;
(statearr_22552_22583[(2)] = null);

(statearr_22552_22583[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (11))){
var inst_22503 = (state_22539[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22539,(10),Object,null,(9));
var inst_22512 = chs__$1.call(null,inst_22503);
var inst_22513 = done.call(null,inst_22503);
var inst_22514 = cljs.core.async.take_BANG_.call(null,inst_22512,inst_22513);
var state_22539__$1 = state_22539;
var statearr_22553_22584 = state_22539__$1;
(statearr_22553_22584[(2)] = inst_22514);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22539__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (9))){
var inst_22503 = (state_22539[(7)]);
var inst_22516 = (state_22539[(2)]);
var inst_22517 = (inst_22503 + (1));
var inst_22503__$1 = inst_22517;
var state_22539__$1 = (function (){var statearr_22554 = state_22539;
(statearr_22554[(10)] = inst_22516);

(statearr_22554[(7)] = inst_22503__$1);

return statearr_22554;
})();
var statearr_22555_22585 = state_22539__$1;
(statearr_22555_22585[(2)] = null);

(statearr_22555_22585[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (5))){
var inst_22523 = (state_22539[(2)]);
var state_22539__$1 = (function (){var statearr_22556 = state_22539;
(statearr_22556[(11)] = inst_22523);

return statearr_22556;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22539__$1,(12),dchan);
} else {
if((state_val_22540 === (14))){
var inst_22525 = (state_22539[(8)]);
var inst_22530 = cljs.core.apply.call(null,f,inst_22525);
var state_22539__$1 = state_22539;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22539__$1,(16),out,inst_22530);
} else {
if((state_val_22540 === (16))){
var inst_22532 = (state_22539[(2)]);
var state_22539__$1 = (function (){var statearr_22557 = state_22539;
(statearr_22557[(12)] = inst_22532);

return statearr_22557;
})();
var statearr_22558_22586 = state_22539__$1;
(statearr_22558_22586[(2)] = null);

(statearr_22558_22586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (10))){
var inst_22507 = (state_22539[(2)]);
var inst_22508 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_22539__$1 = (function (){var statearr_22559 = state_22539;
(statearr_22559[(13)] = inst_22507);

return statearr_22559;
})();
var statearr_22560_22587 = state_22539__$1;
(statearr_22560_22587[(2)] = inst_22508);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22539__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22540 === (8))){
var inst_22521 = (state_22539[(2)]);
var state_22539__$1 = state_22539;
var statearr_22561_22588 = state_22539__$1;
(statearr_22561_22588[(2)] = inst_22521);

(statearr_22561_22588[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___22573,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__20400__auto__,c__20554__auto___22573,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_22565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22565[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_22565[(1)] = (1));

return statearr_22565;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_22539){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_22539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e22566){if((e22566 instanceof Object)){
var ex__20404__auto__ = e22566;
var statearr_22567_22589 = state_22539;
(statearr_22567_22589[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22539);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22566;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22590 = state_22539;
state_22539 = G__22590;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_22539){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_22539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___22573,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__20556__auto__ = (function (){var statearr_22568 = f__20555__auto__.call(null);
(statearr_22568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___22573);

return statearr_22568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___22573,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args22592 = [];
var len__19443__auto___22648 = arguments.length;
var i__19444__auto___22649 = (0);
while(true){
if((i__19444__auto___22649 < len__19443__auto___22648)){
args22592.push((arguments[i__19444__auto___22649]));

var G__22650 = (i__19444__auto___22649 + (1));
i__19444__auto___22649 = G__22650;
continue;
} else {
}
break;
}

var G__22594 = args22592.length;
switch (G__22594) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22592.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20554__auto___22652 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___22652,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___22652,out){
return (function (state_22624){
var state_val_22625 = (state_22624[(1)]);
if((state_val_22625 === (7))){
var inst_22604 = (state_22624[(7)]);
var inst_22603 = (state_22624[(8)]);
var inst_22603__$1 = (state_22624[(2)]);
var inst_22604__$1 = cljs.core.nth.call(null,inst_22603__$1,(0),null);
var inst_22605 = cljs.core.nth.call(null,inst_22603__$1,(1),null);
var inst_22606 = (inst_22604__$1 == null);
var state_22624__$1 = (function (){var statearr_22626 = state_22624;
(statearr_22626[(9)] = inst_22605);

(statearr_22626[(7)] = inst_22604__$1);

(statearr_22626[(8)] = inst_22603__$1);

return statearr_22626;
})();
if(cljs.core.truth_(inst_22606)){
var statearr_22627_22653 = state_22624__$1;
(statearr_22627_22653[(1)] = (8));

} else {
var statearr_22628_22654 = state_22624__$1;
(statearr_22628_22654[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22625 === (1))){
var inst_22595 = cljs.core.vec.call(null,chs);
var inst_22596 = inst_22595;
var state_22624__$1 = (function (){var statearr_22629 = state_22624;
(statearr_22629[(10)] = inst_22596);

return statearr_22629;
})();
var statearr_22630_22655 = state_22624__$1;
(statearr_22630_22655[(2)] = null);

(statearr_22630_22655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22625 === (4))){
var inst_22596 = (state_22624[(10)]);
var state_22624__$1 = state_22624;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22624__$1,(7),inst_22596);
} else {
if((state_val_22625 === (6))){
var inst_22620 = (state_22624[(2)]);
var state_22624__$1 = state_22624;
var statearr_22631_22656 = state_22624__$1;
(statearr_22631_22656[(2)] = inst_22620);

(statearr_22631_22656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22625 === (3))){
var inst_22622 = (state_22624[(2)]);
var state_22624__$1 = state_22624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22624__$1,inst_22622);
} else {
if((state_val_22625 === (2))){
var inst_22596 = (state_22624[(10)]);
var inst_22598 = cljs.core.count.call(null,inst_22596);
var inst_22599 = (inst_22598 > (0));
var state_22624__$1 = state_22624;
if(cljs.core.truth_(inst_22599)){
var statearr_22633_22657 = state_22624__$1;
(statearr_22633_22657[(1)] = (4));

} else {
var statearr_22634_22658 = state_22624__$1;
(statearr_22634_22658[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22625 === (11))){
var inst_22596 = (state_22624[(10)]);
var inst_22613 = (state_22624[(2)]);
var tmp22632 = inst_22596;
var inst_22596__$1 = tmp22632;
var state_22624__$1 = (function (){var statearr_22635 = state_22624;
(statearr_22635[(11)] = inst_22613);

(statearr_22635[(10)] = inst_22596__$1);

return statearr_22635;
})();
var statearr_22636_22659 = state_22624__$1;
(statearr_22636_22659[(2)] = null);

(statearr_22636_22659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22625 === (9))){
var inst_22604 = (state_22624[(7)]);
var state_22624__$1 = state_22624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22624__$1,(11),out,inst_22604);
} else {
if((state_val_22625 === (5))){
var inst_22618 = cljs.core.async.close_BANG_.call(null,out);
var state_22624__$1 = state_22624;
var statearr_22637_22660 = state_22624__$1;
(statearr_22637_22660[(2)] = inst_22618);

(statearr_22637_22660[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22625 === (10))){
var inst_22616 = (state_22624[(2)]);
var state_22624__$1 = state_22624;
var statearr_22638_22661 = state_22624__$1;
(statearr_22638_22661[(2)] = inst_22616);

(statearr_22638_22661[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22625 === (8))){
var inst_22605 = (state_22624[(9)]);
var inst_22604 = (state_22624[(7)]);
var inst_22603 = (state_22624[(8)]);
var inst_22596 = (state_22624[(10)]);
var inst_22608 = (function (){var cs = inst_22596;
var vec__22601 = inst_22603;
var v = inst_22604;
var c = inst_22605;
return ((function (cs,vec__22601,v,c,inst_22605,inst_22604,inst_22603,inst_22596,state_val_22625,c__20554__auto___22652,out){
return (function (p1__22591_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__22591_SHARP_);
});
;})(cs,vec__22601,v,c,inst_22605,inst_22604,inst_22603,inst_22596,state_val_22625,c__20554__auto___22652,out))
})();
var inst_22609 = cljs.core.filterv.call(null,inst_22608,inst_22596);
var inst_22596__$1 = inst_22609;
var state_22624__$1 = (function (){var statearr_22639 = state_22624;
(statearr_22639[(10)] = inst_22596__$1);

return statearr_22639;
})();
var statearr_22640_22662 = state_22624__$1;
(statearr_22640_22662[(2)] = null);

(statearr_22640_22662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___22652,out))
;
return ((function (switch__20400__auto__,c__20554__auto___22652,out){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_22644 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22644[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_22644[(1)] = (1));

return statearr_22644;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_22624){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_22624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e22645){if((e22645 instanceof Object)){
var ex__20404__auto__ = e22645;
var statearr_22646_22663 = state_22624;
(statearr_22646_22663[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22645;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22664 = state_22624;
state_22624 = G__22664;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_22624){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_22624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___22652,out))
})();
var state__20556__auto__ = (function (){var statearr_22647 = f__20555__auto__.call(null);
(statearr_22647[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___22652);

return statearr_22647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___22652,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args22665 = [];
var len__19443__auto___22714 = arguments.length;
var i__19444__auto___22715 = (0);
while(true){
if((i__19444__auto___22715 < len__19443__auto___22714)){
args22665.push((arguments[i__19444__auto___22715]));

var G__22716 = (i__19444__auto___22715 + (1));
i__19444__auto___22715 = G__22716;
continue;
} else {
}
break;
}

var G__22667 = args22665.length;
switch (G__22667) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22665.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20554__auto___22718 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___22718,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___22718,out){
return (function (state_22691){
var state_val_22692 = (state_22691[(1)]);
if((state_val_22692 === (7))){
var inst_22673 = (state_22691[(7)]);
var inst_22673__$1 = (state_22691[(2)]);
var inst_22674 = (inst_22673__$1 == null);
var inst_22675 = cljs.core.not.call(null,inst_22674);
var state_22691__$1 = (function (){var statearr_22693 = state_22691;
(statearr_22693[(7)] = inst_22673__$1);

return statearr_22693;
})();
if(inst_22675){
var statearr_22694_22719 = state_22691__$1;
(statearr_22694_22719[(1)] = (8));

} else {
var statearr_22695_22720 = state_22691__$1;
(statearr_22695_22720[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (1))){
var inst_22668 = (0);
var state_22691__$1 = (function (){var statearr_22696 = state_22691;
(statearr_22696[(8)] = inst_22668);

return statearr_22696;
})();
var statearr_22697_22721 = state_22691__$1;
(statearr_22697_22721[(2)] = null);

(statearr_22697_22721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (4))){
var state_22691__$1 = state_22691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22691__$1,(7),ch);
} else {
if((state_val_22692 === (6))){
var inst_22686 = (state_22691[(2)]);
var state_22691__$1 = state_22691;
var statearr_22698_22722 = state_22691__$1;
(statearr_22698_22722[(2)] = inst_22686);

(statearr_22698_22722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (3))){
var inst_22688 = (state_22691[(2)]);
var inst_22689 = cljs.core.async.close_BANG_.call(null,out);
var state_22691__$1 = (function (){var statearr_22699 = state_22691;
(statearr_22699[(9)] = inst_22688);

return statearr_22699;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22691__$1,inst_22689);
} else {
if((state_val_22692 === (2))){
var inst_22668 = (state_22691[(8)]);
var inst_22670 = (inst_22668 < n);
var state_22691__$1 = state_22691;
if(cljs.core.truth_(inst_22670)){
var statearr_22700_22723 = state_22691__$1;
(statearr_22700_22723[(1)] = (4));

} else {
var statearr_22701_22724 = state_22691__$1;
(statearr_22701_22724[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (11))){
var inst_22668 = (state_22691[(8)]);
var inst_22678 = (state_22691[(2)]);
var inst_22679 = (inst_22668 + (1));
var inst_22668__$1 = inst_22679;
var state_22691__$1 = (function (){var statearr_22702 = state_22691;
(statearr_22702[(10)] = inst_22678);

(statearr_22702[(8)] = inst_22668__$1);

return statearr_22702;
})();
var statearr_22703_22725 = state_22691__$1;
(statearr_22703_22725[(2)] = null);

(statearr_22703_22725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (9))){
var state_22691__$1 = state_22691;
var statearr_22704_22726 = state_22691__$1;
(statearr_22704_22726[(2)] = null);

(statearr_22704_22726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (5))){
var state_22691__$1 = state_22691;
var statearr_22705_22727 = state_22691__$1;
(statearr_22705_22727[(2)] = null);

(statearr_22705_22727[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (10))){
var inst_22683 = (state_22691[(2)]);
var state_22691__$1 = state_22691;
var statearr_22706_22728 = state_22691__$1;
(statearr_22706_22728[(2)] = inst_22683);

(statearr_22706_22728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22692 === (8))){
var inst_22673 = (state_22691[(7)]);
var state_22691__$1 = state_22691;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22691__$1,(11),out,inst_22673);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___22718,out))
;
return ((function (switch__20400__auto__,c__20554__auto___22718,out){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_22710 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22710[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_22710[(1)] = (1));

return statearr_22710;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_22691){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_22691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e22711){if((e22711 instanceof Object)){
var ex__20404__auto__ = e22711;
var statearr_22712_22729 = state_22691;
(statearr_22712_22729[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22711;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22730 = state_22691;
state_22691 = G__22730;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_22691){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_22691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___22718,out))
})();
var state__20556__auto__ = (function (){var statearr_22713 = f__20555__auto__.call(null);
(statearr_22713[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___22718);

return statearr_22713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___22718,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22738 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22738 = (function (map_LT_,f,ch,meta22739){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22739 = meta22739;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22740,meta22739__$1){
var self__ = this;
var _22740__$1 = this;
return (new cljs.core.async.t_cljs$core$async22738(self__.map_LT_,self__.f,self__.ch,meta22739__$1));
});

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22740){
var self__ = this;
var _22740__$1 = this;
return self__.meta22739;
});

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async22741 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22741 = (function (map_LT_,f,ch,meta22739,_,fn1,meta22742){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22739 = meta22739;
this._ = _;
this.fn1 = fn1;
this.meta22742 = meta22742;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22741.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_22743,meta22742__$1){
var self__ = this;
var _22743__$1 = this;
return (new cljs.core.async.t_cljs$core$async22741(self__.map_LT_,self__.f,self__.ch,self__.meta22739,self__._,self__.fn1,meta22742__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async22741.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_22743){
var self__ = this;
var _22743__$1 = this;
return self__.meta22742;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22741.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async22741.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22741.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22741.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__22731_SHARP_){
return f1.call(null,(((p1__22731_SHARP_ == null))?null:self__.f.call(null,p1__22731_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async22741.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22739","meta22739",-1110564280,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async22738","cljs.core.async/t_cljs$core$async22738",1780333906,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta22742","meta22742",1662902676,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22741.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22741.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22741";

cljs.core.async.t_cljs$core$async22741.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async22741");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async22741 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22741(map_LT___$1,f__$1,ch__$1,meta22739__$1,___$2,fn1__$1,meta22742){
return (new cljs.core.async.t_cljs$core$async22741(map_LT___$1,f__$1,ch__$1,meta22739__$1,___$2,fn1__$1,meta22742));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async22741(self__.map_LT_,self__.f,self__.ch,self__.meta22739,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18362__auto__ = ret;
if(cljs.core.truth_(and__18362__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18362__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22738.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async22738.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22739","meta22739",-1110564280,null)], null);
});

cljs.core.async.t_cljs$core$async22738.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22738.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22738";

cljs.core.async.t_cljs$core$async22738.cljs$lang$ctorPrWriter = (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async22738");
});

cljs.core.async.__GT_t_cljs$core$async22738 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22738(map_LT___$1,f__$1,ch__$1,meta22739){
return (new cljs.core.async.t_cljs$core$async22738(map_LT___$1,f__$1,ch__$1,meta22739));
});

}

return (new cljs.core.async.t_cljs$core$async22738(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22747 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22747 = (function (map_GT_,f,ch,meta22748){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta22748 = meta22748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22749,meta22748__$1){
var self__ = this;
var _22749__$1 = this;
return (new cljs.core.async.t_cljs$core$async22747(self__.map_GT_,self__.f,self__.ch,meta22748__$1));
});

cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22749){
var self__ = this;
var _22749__$1 = this;
return self__.meta22748;
});

cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22747.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async22747.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22748","meta22748",-2135388619,null)], null);
});

cljs.core.async.t_cljs$core$async22747.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22747.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22747";

cljs.core.async.t_cljs$core$async22747.cljs$lang$ctorPrWriter = (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async22747");
});

cljs.core.async.__GT_t_cljs$core$async22747 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async22747(map_GT___$1,f__$1,ch__$1,meta22748){
return (new cljs.core.async.t_cljs$core$async22747(map_GT___$1,f__$1,ch__$1,meta22748));
});

}

return (new cljs.core.async.t_cljs$core$async22747(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async22753 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22753 = (function (filter_GT_,p,ch,meta22754){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta22754 = meta22754;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22755,meta22754__$1){
var self__ = this;
var _22755__$1 = this;
return (new cljs.core.async.t_cljs$core$async22753(self__.filter_GT_,self__.p,self__.ch,meta22754__$1));
});

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22755){
var self__ = this;
var _22755__$1 = this;
return self__.meta22754;
});

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22753.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async22753.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22754","meta22754",-806045963,null)], null);
});

cljs.core.async.t_cljs$core$async22753.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22753.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22753";

cljs.core.async.t_cljs$core$async22753.cljs$lang$ctorPrWriter = (function (this__18980__auto__,writer__18981__auto__,opt__18982__auto__){
return cljs.core._write.call(null,writer__18981__auto__,"cljs.core.async/t_cljs$core$async22753");
});

cljs.core.async.__GT_t_cljs$core$async22753 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async22753(filter_GT___$1,p__$1,ch__$1,meta22754){
return (new cljs.core.async.t_cljs$core$async22753(filter_GT___$1,p__$1,ch__$1,meta22754));
});

}

return (new cljs.core.async.t_cljs$core$async22753(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args22756 = [];
var len__19443__auto___22800 = arguments.length;
var i__19444__auto___22801 = (0);
while(true){
if((i__19444__auto___22801 < len__19443__auto___22800)){
args22756.push((arguments[i__19444__auto___22801]));

var G__22802 = (i__19444__auto___22801 + (1));
i__19444__auto___22801 = G__22802;
continue;
} else {
}
break;
}

var G__22758 = args22756.length;
switch (G__22758) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22756.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20554__auto___22804 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___22804,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___22804,out){
return (function (state_22779){
var state_val_22780 = (state_22779[(1)]);
if((state_val_22780 === (7))){
var inst_22775 = (state_22779[(2)]);
var state_22779__$1 = state_22779;
var statearr_22781_22805 = state_22779__$1;
(statearr_22781_22805[(2)] = inst_22775);

(statearr_22781_22805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (1))){
var state_22779__$1 = state_22779;
var statearr_22782_22806 = state_22779__$1;
(statearr_22782_22806[(2)] = null);

(statearr_22782_22806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (4))){
var inst_22761 = (state_22779[(7)]);
var inst_22761__$1 = (state_22779[(2)]);
var inst_22762 = (inst_22761__$1 == null);
var state_22779__$1 = (function (){var statearr_22783 = state_22779;
(statearr_22783[(7)] = inst_22761__$1);

return statearr_22783;
})();
if(cljs.core.truth_(inst_22762)){
var statearr_22784_22807 = state_22779__$1;
(statearr_22784_22807[(1)] = (5));

} else {
var statearr_22785_22808 = state_22779__$1;
(statearr_22785_22808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (6))){
var inst_22761 = (state_22779[(7)]);
var inst_22766 = p.call(null,inst_22761);
var state_22779__$1 = state_22779;
if(cljs.core.truth_(inst_22766)){
var statearr_22786_22809 = state_22779__$1;
(statearr_22786_22809[(1)] = (8));

} else {
var statearr_22787_22810 = state_22779__$1;
(statearr_22787_22810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (3))){
var inst_22777 = (state_22779[(2)]);
var state_22779__$1 = state_22779;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22779__$1,inst_22777);
} else {
if((state_val_22780 === (2))){
var state_22779__$1 = state_22779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22779__$1,(4),ch);
} else {
if((state_val_22780 === (11))){
var inst_22769 = (state_22779[(2)]);
var state_22779__$1 = state_22779;
var statearr_22788_22811 = state_22779__$1;
(statearr_22788_22811[(2)] = inst_22769);

(statearr_22788_22811[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (9))){
var state_22779__$1 = state_22779;
var statearr_22789_22812 = state_22779__$1;
(statearr_22789_22812[(2)] = null);

(statearr_22789_22812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (5))){
var inst_22764 = cljs.core.async.close_BANG_.call(null,out);
var state_22779__$1 = state_22779;
var statearr_22790_22813 = state_22779__$1;
(statearr_22790_22813[(2)] = inst_22764);

(statearr_22790_22813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (10))){
var inst_22772 = (state_22779[(2)]);
var state_22779__$1 = (function (){var statearr_22791 = state_22779;
(statearr_22791[(8)] = inst_22772);

return statearr_22791;
})();
var statearr_22792_22814 = state_22779__$1;
(statearr_22792_22814[(2)] = null);

(statearr_22792_22814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22780 === (8))){
var inst_22761 = (state_22779[(7)]);
var state_22779__$1 = state_22779;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22779__$1,(11),out,inst_22761);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___22804,out))
;
return ((function (switch__20400__auto__,c__20554__auto___22804,out){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_22796 = [null,null,null,null,null,null,null,null,null];
(statearr_22796[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_22796[(1)] = (1));

return statearr_22796;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_22779){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_22779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e22797){if((e22797 instanceof Object)){
var ex__20404__auto__ = e22797;
var statearr_22798_22815 = state_22779;
(statearr_22798_22815[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22779);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22797;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22816 = state_22779;
state_22779 = G__22816;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_22779){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_22779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___22804,out))
})();
var state__20556__auto__ = (function (){var statearr_22799 = f__20555__auto__.call(null);
(statearr_22799[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___22804);

return statearr_22799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___22804,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args22817 = [];
var len__19443__auto___22820 = arguments.length;
var i__19444__auto___22821 = (0);
while(true){
if((i__19444__auto___22821 < len__19443__auto___22820)){
args22817.push((arguments[i__19444__auto___22821]));

var G__22822 = (i__19444__auto___22821 + (1));
i__19444__auto___22821 = G__22822;
continue;
} else {
}
break;
}

var G__22819 = args22817.length;
switch (G__22819) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22817.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__){
return (function (state_22989){
var state_val_22990 = (state_22989[(1)]);
if((state_val_22990 === (7))){
var inst_22985 = (state_22989[(2)]);
var state_22989__$1 = state_22989;
var statearr_22991_23032 = state_22989__$1;
(statearr_22991_23032[(2)] = inst_22985);

(statearr_22991_23032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (20))){
var inst_22955 = (state_22989[(7)]);
var inst_22966 = (state_22989[(2)]);
var inst_22967 = cljs.core.next.call(null,inst_22955);
var inst_22941 = inst_22967;
var inst_22942 = null;
var inst_22943 = (0);
var inst_22944 = (0);
var state_22989__$1 = (function (){var statearr_22992 = state_22989;
(statearr_22992[(8)] = inst_22944);

(statearr_22992[(9)] = inst_22942);

(statearr_22992[(10)] = inst_22941);

(statearr_22992[(11)] = inst_22943);

(statearr_22992[(12)] = inst_22966);

return statearr_22992;
})();
var statearr_22993_23033 = state_22989__$1;
(statearr_22993_23033[(2)] = null);

(statearr_22993_23033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (1))){
var state_22989__$1 = state_22989;
var statearr_22994_23034 = state_22989__$1;
(statearr_22994_23034[(2)] = null);

(statearr_22994_23034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (4))){
var inst_22930 = (state_22989[(13)]);
var inst_22930__$1 = (state_22989[(2)]);
var inst_22931 = (inst_22930__$1 == null);
var state_22989__$1 = (function (){var statearr_22995 = state_22989;
(statearr_22995[(13)] = inst_22930__$1);

return statearr_22995;
})();
if(cljs.core.truth_(inst_22931)){
var statearr_22996_23035 = state_22989__$1;
(statearr_22996_23035[(1)] = (5));

} else {
var statearr_22997_23036 = state_22989__$1;
(statearr_22997_23036[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (15))){
var state_22989__$1 = state_22989;
var statearr_23001_23037 = state_22989__$1;
(statearr_23001_23037[(2)] = null);

(statearr_23001_23037[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (21))){
var state_22989__$1 = state_22989;
var statearr_23002_23038 = state_22989__$1;
(statearr_23002_23038[(2)] = null);

(statearr_23002_23038[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (13))){
var inst_22944 = (state_22989[(8)]);
var inst_22942 = (state_22989[(9)]);
var inst_22941 = (state_22989[(10)]);
var inst_22943 = (state_22989[(11)]);
var inst_22951 = (state_22989[(2)]);
var inst_22952 = (inst_22944 + (1));
var tmp22998 = inst_22942;
var tmp22999 = inst_22941;
var tmp23000 = inst_22943;
var inst_22941__$1 = tmp22999;
var inst_22942__$1 = tmp22998;
var inst_22943__$1 = tmp23000;
var inst_22944__$1 = inst_22952;
var state_22989__$1 = (function (){var statearr_23003 = state_22989;
(statearr_23003[(8)] = inst_22944__$1);

(statearr_23003[(14)] = inst_22951);

(statearr_23003[(9)] = inst_22942__$1);

(statearr_23003[(10)] = inst_22941__$1);

(statearr_23003[(11)] = inst_22943__$1);

return statearr_23003;
})();
var statearr_23004_23039 = state_22989__$1;
(statearr_23004_23039[(2)] = null);

(statearr_23004_23039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (22))){
var state_22989__$1 = state_22989;
var statearr_23005_23040 = state_22989__$1;
(statearr_23005_23040[(2)] = null);

(statearr_23005_23040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (6))){
var inst_22930 = (state_22989[(13)]);
var inst_22939 = f.call(null,inst_22930);
var inst_22940 = cljs.core.seq.call(null,inst_22939);
var inst_22941 = inst_22940;
var inst_22942 = null;
var inst_22943 = (0);
var inst_22944 = (0);
var state_22989__$1 = (function (){var statearr_23006 = state_22989;
(statearr_23006[(8)] = inst_22944);

(statearr_23006[(9)] = inst_22942);

(statearr_23006[(10)] = inst_22941);

(statearr_23006[(11)] = inst_22943);

return statearr_23006;
})();
var statearr_23007_23041 = state_22989__$1;
(statearr_23007_23041[(2)] = null);

(statearr_23007_23041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (17))){
var inst_22955 = (state_22989[(7)]);
var inst_22959 = cljs.core.chunk_first.call(null,inst_22955);
var inst_22960 = cljs.core.chunk_rest.call(null,inst_22955);
var inst_22961 = cljs.core.count.call(null,inst_22959);
var inst_22941 = inst_22960;
var inst_22942 = inst_22959;
var inst_22943 = inst_22961;
var inst_22944 = (0);
var state_22989__$1 = (function (){var statearr_23008 = state_22989;
(statearr_23008[(8)] = inst_22944);

(statearr_23008[(9)] = inst_22942);

(statearr_23008[(10)] = inst_22941);

(statearr_23008[(11)] = inst_22943);

return statearr_23008;
})();
var statearr_23009_23042 = state_22989__$1;
(statearr_23009_23042[(2)] = null);

(statearr_23009_23042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (3))){
var inst_22987 = (state_22989[(2)]);
var state_22989__$1 = state_22989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22989__$1,inst_22987);
} else {
if((state_val_22990 === (12))){
var inst_22975 = (state_22989[(2)]);
var state_22989__$1 = state_22989;
var statearr_23010_23043 = state_22989__$1;
(statearr_23010_23043[(2)] = inst_22975);

(statearr_23010_23043[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (2))){
var state_22989__$1 = state_22989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22989__$1,(4),in$);
} else {
if((state_val_22990 === (23))){
var inst_22983 = (state_22989[(2)]);
var state_22989__$1 = state_22989;
var statearr_23011_23044 = state_22989__$1;
(statearr_23011_23044[(2)] = inst_22983);

(statearr_23011_23044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (19))){
var inst_22970 = (state_22989[(2)]);
var state_22989__$1 = state_22989;
var statearr_23012_23045 = state_22989__$1;
(statearr_23012_23045[(2)] = inst_22970);

(statearr_23012_23045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (11))){
var inst_22955 = (state_22989[(7)]);
var inst_22941 = (state_22989[(10)]);
var inst_22955__$1 = cljs.core.seq.call(null,inst_22941);
var state_22989__$1 = (function (){var statearr_23013 = state_22989;
(statearr_23013[(7)] = inst_22955__$1);

return statearr_23013;
})();
if(inst_22955__$1){
var statearr_23014_23046 = state_22989__$1;
(statearr_23014_23046[(1)] = (14));

} else {
var statearr_23015_23047 = state_22989__$1;
(statearr_23015_23047[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (9))){
var inst_22977 = (state_22989[(2)]);
var inst_22978 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_22989__$1 = (function (){var statearr_23016 = state_22989;
(statearr_23016[(15)] = inst_22977);

return statearr_23016;
})();
if(cljs.core.truth_(inst_22978)){
var statearr_23017_23048 = state_22989__$1;
(statearr_23017_23048[(1)] = (21));

} else {
var statearr_23018_23049 = state_22989__$1;
(statearr_23018_23049[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (5))){
var inst_22933 = cljs.core.async.close_BANG_.call(null,out);
var state_22989__$1 = state_22989;
var statearr_23019_23050 = state_22989__$1;
(statearr_23019_23050[(2)] = inst_22933);

(statearr_23019_23050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (14))){
var inst_22955 = (state_22989[(7)]);
var inst_22957 = cljs.core.chunked_seq_QMARK_.call(null,inst_22955);
var state_22989__$1 = state_22989;
if(inst_22957){
var statearr_23020_23051 = state_22989__$1;
(statearr_23020_23051[(1)] = (17));

} else {
var statearr_23021_23052 = state_22989__$1;
(statearr_23021_23052[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (16))){
var inst_22973 = (state_22989[(2)]);
var state_22989__$1 = state_22989;
var statearr_23022_23053 = state_22989__$1;
(statearr_23022_23053[(2)] = inst_22973);

(statearr_23022_23053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22990 === (10))){
var inst_22944 = (state_22989[(8)]);
var inst_22942 = (state_22989[(9)]);
var inst_22949 = cljs.core._nth.call(null,inst_22942,inst_22944);
var state_22989__$1 = state_22989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22989__$1,(13),out,inst_22949);
} else {
if((state_val_22990 === (18))){
var inst_22955 = (state_22989[(7)]);
var inst_22964 = cljs.core.first.call(null,inst_22955);
var state_22989__$1 = state_22989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22989__$1,(20),out,inst_22964);
} else {
if((state_val_22990 === (8))){
var inst_22944 = (state_22989[(8)]);
var inst_22943 = (state_22989[(11)]);
var inst_22946 = (inst_22944 < inst_22943);
var inst_22947 = inst_22946;
var state_22989__$1 = state_22989;
if(cljs.core.truth_(inst_22947)){
var statearr_23023_23054 = state_22989__$1;
(statearr_23023_23054[(1)] = (10));

} else {
var statearr_23024_23055 = state_22989__$1;
(statearr_23024_23055[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__))
;
return ((function (switch__20400__auto__,c__20554__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20401__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20401__auto____0 = (function (){
var statearr_23028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23028[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20401__auto__);

(statearr_23028[(1)] = (1));

return statearr_23028;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20401__auto____1 = (function (state_22989){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_22989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e23029){if((e23029 instanceof Object)){
var ex__20404__auto__ = e23029;
var statearr_23030_23056 = state_22989;
(statearr_23030_23056[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23029;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23057 = state_22989;
state_22989 = G__23057;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20401__auto__ = function(state_22989){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20401__auto____1.call(this,state_22989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20401__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20401__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__))
})();
var state__20556__auto__ = (function (){var statearr_23031 = f__20555__auto__.call(null);
(statearr_23031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_23031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__))
);

return c__20554__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args23058 = [];
var len__19443__auto___23061 = arguments.length;
var i__19444__auto___23062 = (0);
while(true){
if((i__19444__auto___23062 < len__19443__auto___23061)){
args23058.push((arguments[i__19444__auto___23062]));

var G__23063 = (i__19444__auto___23062 + (1));
i__19444__auto___23062 = G__23063;
continue;
} else {
}
break;
}

var G__23060 = args23058.length;
switch (G__23060) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23058.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args23065 = [];
var len__19443__auto___23068 = arguments.length;
var i__19444__auto___23069 = (0);
while(true){
if((i__19444__auto___23069 < len__19443__auto___23068)){
args23065.push((arguments[i__19444__auto___23069]));

var G__23070 = (i__19444__auto___23069 + (1));
i__19444__auto___23069 = G__23070;
continue;
} else {
}
break;
}

var G__23067 = args23065.length;
switch (G__23067) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23065.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args23072 = [];
var len__19443__auto___23123 = arguments.length;
var i__19444__auto___23124 = (0);
while(true){
if((i__19444__auto___23124 < len__19443__auto___23123)){
args23072.push((arguments[i__19444__auto___23124]));

var G__23125 = (i__19444__auto___23124 + (1));
i__19444__auto___23124 = G__23125;
continue;
} else {
}
break;
}

var G__23074 = args23072.length;
switch (G__23074) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23072.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20554__auto___23127 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___23127,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___23127,out){
return (function (state_23098){
var state_val_23099 = (state_23098[(1)]);
if((state_val_23099 === (7))){
var inst_23093 = (state_23098[(2)]);
var state_23098__$1 = state_23098;
var statearr_23100_23128 = state_23098__$1;
(statearr_23100_23128[(2)] = inst_23093);

(statearr_23100_23128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23099 === (1))){
var inst_23075 = null;
var state_23098__$1 = (function (){var statearr_23101 = state_23098;
(statearr_23101[(7)] = inst_23075);

return statearr_23101;
})();
var statearr_23102_23129 = state_23098__$1;
(statearr_23102_23129[(2)] = null);

(statearr_23102_23129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23099 === (4))){
var inst_23078 = (state_23098[(8)]);
var inst_23078__$1 = (state_23098[(2)]);
var inst_23079 = (inst_23078__$1 == null);
var inst_23080 = cljs.core.not.call(null,inst_23079);
var state_23098__$1 = (function (){var statearr_23103 = state_23098;
(statearr_23103[(8)] = inst_23078__$1);

return statearr_23103;
})();
if(inst_23080){
var statearr_23104_23130 = state_23098__$1;
(statearr_23104_23130[(1)] = (5));

} else {
var statearr_23105_23131 = state_23098__$1;
(statearr_23105_23131[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23099 === (6))){
var state_23098__$1 = state_23098;
var statearr_23106_23132 = state_23098__$1;
(statearr_23106_23132[(2)] = null);

(statearr_23106_23132[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23099 === (3))){
var inst_23095 = (state_23098[(2)]);
var inst_23096 = cljs.core.async.close_BANG_.call(null,out);
var state_23098__$1 = (function (){var statearr_23107 = state_23098;
(statearr_23107[(9)] = inst_23095);

return statearr_23107;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23098__$1,inst_23096);
} else {
if((state_val_23099 === (2))){
var state_23098__$1 = state_23098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23098__$1,(4),ch);
} else {
if((state_val_23099 === (11))){
var inst_23078 = (state_23098[(8)]);
var inst_23087 = (state_23098[(2)]);
var inst_23075 = inst_23078;
var state_23098__$1 = (function (){var statearr_23108 = state_23098;
(statearr_23108[(10)] = inst_23087);

(statearr_23108[(7)] = inst_23075);

return statearr_23108;
})();
var statearr_23109_23133 = state_23098__$1;
(statearr_23109_23133[(2)] = null);

(statearr_23109_23133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23099 === (9))){
var inst_23078 = (state_23098[(8)]);
var state_23098__$1 = state_23098;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23098__$1,(11),out,inst_23078);
} else {
if((state_val_23099 === (5))){
var inst_23078 = (state_23098[(8)]);
var inst_23075 = (state_23098[(7)]);
var inst_23082 = cljs.core._EQ_.call(null,inst_23078,inst_23075);
var state_23098__$1 = state_23098;
if(inst_23082){
var statearr_23111_23134 = state_23098__$1;
(statearr_23111_23134[(1)] = (8));

} else {
var statearr_23112_23135 = state_23098__$1;
(statearr_23112_23135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23099 === (10))){
var inst_23090 = (state_23098[(2)]);
var state_23098__$1 = state_23098;
var statearr_23113_23136 = state_23098__$1;
(statearr_23113_23136[(2)] = inst_23090);

(statearr_23113_23136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23099 === (8))){
var inst_23075 = (state_23098[(7)]);
var tmp23110 = inst_23075;
var inst_23075__$1 = tmp23110;
var state_23098__$1 = (function (){var statearr_23114 = state_23098;
(statearr_23114[(7)] = inst_23075__$1);

return statearr_23114;
})();
var statearr_23115_23137 = state_23098__$1;
(statearr_23115_23137[(2)] = null);

(statearr_23115_23137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___23127,out))
;
return ((function (switch__20400__auto__,c__20554__auto___23127,out){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_23119 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23119[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_23119[(1)] = (1));

return statearr_23119;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_23098){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_23098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e23120){if((e23120 instanceof Object)){
var ex__20404__auto__ = e23120;
var statearr_23121_23138 = state_23098;
(statearr_23121_23138[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23139 = state_23098;
state_23098 = G__23139;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_23098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_23098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___23127,out))
})();
var state__20556__auto__ = (function (){var statearr_23122 = f__20555__auto__.call(null);
(statearr_23122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___23127);

return statearr_23122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___23127,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args23140 = [];
var len__19443__auto___23210 = arguments.length;
var i__19444__auto___23211 = (0);
while(true){
if((i__19444__auto___23211 < len__19443__auto___23210)){
args23140.push((arguments[i__19444__auto___23211]));

var G__23212 = (i__19444__auto___23211 + (1));
i__19444__auto___23211 = G__23212;
continue;
} else {
}
break;
}

var G__23142 = args23140.length;
switch (G__23142) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23140.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20554__auto___23214 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___23214,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___23214,out){
return (function (state_23180){
var state_val_23181 = (state_23180[(1)]);
if((state_val_23181 === (7))){
var inst_23176 = (state_23180[(2)]);
var state_23180__$1 = state_23180;
var statearr_23182_23215 = state_23180__$1;
(statearr_23182_23215[(2)] = inst_23176);

(statearr_23182_23215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (1))){
var inst_23143 = (new Array(n));
var inst_23144 = inst_23143;
var inst_23145 = (0);
var state_23180__$1 = (function (){var statearr_23183 = state_23180;
(statearr_23183[(7)] = inst_23144);

(statearr_23183[(8)] = inst_23145);

return statearr_23183;
})();
var statearr_23184_23216 = state_23180__$1;
(statearr_23184_23216[(2)] = null);

(statearr_23184_23216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (4))){
var inst_23148 = (state_23180[(9)]);
var inst_23148__$1 = (state_23180[(2)]);
var inst_23149 = (inst_23148__$1 == null);
var inst_23150 = cljs.core.not.call(null,inst_23149);
var state_23180__$1 = (function (){var statearr_23185 = state_23180;
(statearr_23185[(9)] = inst_23148__$1);

return statearr_23185;
})();
if(inst_23150){
var statearr_23186_23217 = state_23180__$1;
(statearr_23186_23217[(1)] = (5));

} else {
var statearr_23187_23218 = state_23180__$1;
(statearr_23187_23218[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (15))){
var inst_23170 = (state_23180[(2)]);
var state_23180__$1 = state_23180;
var statearr_23188_23219 = state_23180__$1;
(statearr_23188_23219[(2)] = inst_23170);

(statearr_23188_23219[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (13))){
var state_23180__$1 = state_23180;
var statearr_23189_23220 = state_23180__$1;
(statearr_23189_23220[(2)] = null);

(statearr_23189_23220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (6))){
var inst_23145 = (state_23180[(8)]);
var inst_23166 = (inst_23145 > (0));
var state_23180__$1 = state_23180;
if(cljs.core.truth_(inst_23166)){
var statearr_23190_23221 = state_23180__$1;
(statearr_23190_23221[(1)] = (12));

} else {
var statearr_23191_23222 = state_23180__$1;
(statearr_23191_23222[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (3))){
var inst_23178 = (state_23180[(2)]);
var state_23180__$1 = state_23180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23180__$1,inst_23178);
} else {
if((state_val_23181 === (12))){
var inst_23144 = (state_23180[(7)]);
var inst_23168 = cljs.core.vec.call(null,inst_23144);
var state_23180__$1 = state_23180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23180__$1,(15),out,inst_23168);
} else {
if((state_val_23181 === (2))){
var state_23180__$1 = state_23180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23180__$1,(4),ch);
} else {
if((state_val_23181 === (11))){
var inst_23160 = (state_23180[(2)]);
var inst_23161 = (new Array(n));
var inst_23144 = inst_23161;
var inst_23145 = (0);
var state_23180__$1 = (function (){var statearr_23192 = state_23180;
(statearr_23192[(7)] = inst_23144);

(statearr_23192[(8)] = inst_23145);

(statearr_23192[(10)] = inst_23160);

return statearr_23192;
})();
var statearr_23193_23223 = state_23180__$1;
(statearr_23193_23223[(2)] = null);

(statearr_23193_23223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (9))){
var inst_23144 = (state_23180[(7)]);
var inst_23158 = cljs.core.vec.call(null,inst_23144);
var state_23180__$1 = state_23180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23180__$1,(11),out,inst_23158);
} else {
if((state_val_23181 === (5))){
var inst_23153 = (state_23180[(11)]);
var inst_23144 = (state_23180[(7)]);
var inst_23148 = (state_23180[(9)]);
var inst_23145 = (state_23180[(8)]);
var inst_23152 = (inst_23144[inst_23145] = inst_23148);
var inst_23153__$1 = (inst_23145 + (1));
var inst_23154 = (inst_23153__$1 < n);
var state_23180__$1 = (function (){var statearr_23194 = state_23180;
(statearr_23194[(11)] = inst_23153__$1);

(statearr_23194[(12)] = inst_23152);

return statearr_23194;
})();
if(cljs.core.truth_(inst_23154)){
var statearr_23195_23224 = state_23180__$1;
(statearr_23195_23224[(1)] = (8));

} else {
var statearr_23196_23225 = state_23180__$1;
(statearr_23196_23225[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (14))){
var inst_23173 = (state_23180[(2)]);
var inst_23174 = cljs.core.async.close_BANG_.call(null,out);
var state_23180__$1 = (function (){var statearr_23198 = state_23180;
(statearr_23198[(13)] = inst_23173);

return statearr_23198;
})();
var statearr_23199_23226 = state_23180__$1;
(statearr_23199_23226[(2)] = inst_23174);

(statearr_23199_23226[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (10))){
var inst_23164 = (state_23180[(2)]);
var state_23180__$1 = state_23180;
var statearr_23200_23227 = state_23180__$1;
(statearr_23200_23227[(2)] = inst_23164);

(statearr_23200_23227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23181 === (8))){
var inst_23153 = (state_23180[(11)]);
var inst_23144 = (state_23180[(7)]);
var tmp23197 = inst_23144;
var inst_23144__$1 = tmp23197;
var inst_23145 = inst_23153;
var state_23180__$1 = (function (){var statearr_23201 = state_23180;
(statearr_23201[(7)] = inst_23144__$1);

(statearr_23201[(8)] = inst_23145);

return statearr_23201;
})();
var statearr_23202_23228 = state_23180__$1;
(statearr_23202_23228[(2)] = null);

(statearr_23202_23228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___23214,out))
;
return ((function (switch__20400__auto__,c__20554__auto___23214,out){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_23206 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23206[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_23206[(1)] = (1));

return statearr_23206;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_23180){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_23180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e23207){if((e23207 instanceof Object)){
var ex__20404__auto__ = e23207;
var statearr_23208_23229 = state_23180;
(statearr_23208_23229[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23207;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23230 = state_23180;
state_23180 = G__23230;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_23180){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_23180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___23214,out))
})();
var state__20556__auto__ = (function (){var statearr_23209 = f__20555__auto__.call(null);
(statearr_23209[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___23214);

return statearr_23209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___23214,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args23231 = [];
var len__19443__auto___23305 = arguments.length;
var i__19444__auto___23306 = (0);
while(true){
if((i__19444__auto___23306 < len__19443__auto___23305)){
args23231.push((arguments[i__19444__auto___23306]));

var G__23307 = (i__19444__auto___23306 + (1));
i__19444__auto___23306 = G__23307;
continue;
} else {
}
break;
}

var G__23233 = args23231.length;
switch (G__23233) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23231.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20554__auto___23309 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___23309,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___23309,out){
return (function (state_23275){
var state_val_23276 = (state_23275[(1)]);
if((state_val_23276 === (7))){
var inst_23271 = (state_23275[(2)]);
var state_23275__$1 = state_23275;
var statearr_23277_23310 = state_23275__$1;
(statearr_23277_23310[(2)] = inst_23271);

(statearr_23277_23310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (1))){
var inst_23234 = [];
var inst_23235 = inst_23234;
var inst_23236 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_23275__$1 = (function (){var statearr_23278 = state_23275;
(statearr_23278[(7)] = inst_23235);

(statearr_23278[(8)] = inst_23236);

return statearr_23278;
})();
var statearr_23279_23311 = state_23275__$1;
(statearr_23279_23311[(2)] = null);

(statearr_23279_23311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (4))){
var inst_23239 = (state_23275[(9)]);
var inst_23239__$1 = (state_23275[(2)]);
var inst_23240 = (inst_23239__$1 == null);
var inst_23241 = cljs.core.not.call(null,inst_23240);
var state_23275__$1 = (function (){var statearr_23280 = state_23275;
(statearr_23280[(9)] = inst_23239__$1);

return statearr_23280;
})();
if(inst_23241){
var statearr_23281_23312 = state_23275__$1;
(statearr_23281_23312[(1)] = (5));

} else {
var statearr_23282_23313 = state_23275__$1;
(statearr_23282_23313[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (15))){
var inst_23265 = (state_23275[(2)]);
var state_23275__$1 = state_23275;
var statearr_23283_23314 = state_23275__$1;
(statearr_23283_23314[(2)] = inst_23265);

(statearr_23283_23314[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (13))){
var state_23275__$1 = state_23275;
var statearr_23284_23315 = state_23275__$1;
(statearr_23284_23315[(2)] = null);

(statearr_23284_23315[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (6))){
var inst_23235 = (state_23275[(7)]);
var inst_23260 = inst_23235.length;
var inst_23261 = (inst_23260 > (0));
var state_23275__$1 = state_23275;
if(cljs.core.truth_(inst_23261)){
var statearr_23285_23316 = state_23275__$1;
(statearr_23285_23316[(1)] = (12));

} else {
var statearr_23286_23317 = state_23275__$1;
(statearr_23286_23317[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (3))){
var inst_23273 = (state_23275[(2)]);
var state_23275__$1 = state_23275;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23275__$1,inst_23273);
} else {
if((state_val_23276 === (12))){
var inst_23235 = (state_23275[(7)]);
var inst_23263 = cljs.core.vec.call(null,inst_23235);
var state_23275__$1 = state_23275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23275__$1,(15),out,inst_23263);
} else {
if((state_val_23276 === (2))){
var state_23275__$1 = state_23275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23275__$1,(4),ch);
} else {
if((state_val_23276 === (11))){
var inst_23239 = (state_23275[(9)]);
var inst_23243 = (state_23275[(10)]);
var inst_23253 = (state_23275[(2)]);
var inst_23254 = [];
var inst_23255 = inst_23254.push(inst_23239);
var inst_23235 = inst_23254;
var inst_23236 = inst_23243;
var state_23275__$1 = (function (){var statearr_23287 = state_23275;
(statearr_23287[(11)] = inst_23255);

(statearr_23287[(7)] = inst_23235);

(statearr_23287[(8)] = inst_23236);

(statearr_23287[(12)] = inst_23253);

return statearr_23287;
})();
var statearr_23288_23318 = state_23275__$1;
(statearr_23288_23318[(2)] = null);

(statearr_23288_23318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (9))){
var inst_23235 = (state_23275[(7)]);
var inst_23251 = cljs.core.vec.call(null,inst_23235);
var state_23275__$1 = state_23275;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23275__$1,(11),out,inst_23251);
} else {
if((state_val_23276 === (5))){
var inst_23236 = (state_23275[(8)]);
var inst_23239 = (state_23275[(9)]);
var inst_23243 = (state_23275[(10)]);
var inst_23243__$1 = f.call(null,inst_23239);
var inst_23244 = cljs.core._EQ_.call(null,inst_23243__$1,inst_23236);
var inst_23245 = cljs.core.keyword_identical_QMARK_.call(null,inst_23236,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_23246 = (inst_23244) || (inst_23245);
var state_23275__$1 = (function (){var statearr_23289 = state_23275;
(statearr_23289[(10)] = inst_23243__$1);

return statearr_23289;
})();
if(cljs.core.truth_(inst_23246)){
var statearr_23290_23319 = state_23275__$1;
(statearr_23290_23319[(1)] = (8));

} else {
var statearr_23291_23320 = state_23275__$1;
(statearr_23291_23320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (14))){
var inst_23268 = (state_23275[(2)]);
var inst_23269 = cljs.core.async.close_BANG_.call(null,out);
var state_23275__$1 = (function (){var statearr_23293 = state_23275;
(statearr_23293[(13)] = inst_23268);

return statearr_23293;
})();
var statearr_23294_23321 = state_23275__$1;
(statearr_23294_23321[(2)] = inst_23269);

(statearr_23294_23321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (10))){
var inst_23258 = (state_23275[(2)]);
var state_23275__$1 = state_23275;
var statearr_23295_23322 = state_23275__$1;
(statearr_23295_23322[(2)] = inst_23258);

(statearr_23295_23322[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23276 === (8))){
var inst_23235 = (state_23275[(7)]);
var inst_23239 = (state_23275[(9)]);
var inst_23243 = (state_23275[(10)]);
var inst_23248 = inst_23235.push(inst_23239);
var tmp23292 = inst_23235;
var inst_23235__$1 = tmp23292;
var inst_23236 = inst_23243;
var state_23275__$1 = (function (){var statearr_23296 = state_23275;
(statearr_23296[(7)] = inst_23235__$1);

(statearr_23296[(8)] = inst_23236);

(statearr_23296[(14)] = inst_23248);

return statearr_23296;
})();
var statearr_23297_23323 = state_23275__$1;
(statearr_23297_23323[(2)] = null);

(statearr_23297_23323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___23309,out))
;
return ((function (switch__20400__auto__,c__20554__auto___23309,out){
return (function() {
var cljs$core$async$state_machine__20401__auto__ = null;
var cljs$core$async$state_machine__20401__auto____0 = (function (){
var statearr_23301 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23301[(0)] = cljs$core$async$state_machine__20401__auto__);

(statearr_23301[(1)] = (1));

return statearr_23301;
});
var cljs$core$async$state_machine__20401__auto____1 = (function (state_23275){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_23275);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e23302){if((e23302 instanceof Object)){
var ex__20404__auto__ = e23302;
var statearr_23303_23324 = state_23275;
(statearr_23303_23324[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23275);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23302;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23325 = state_23275;
state_23275 = G__23325;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
cljs$core$async$state_machine__20401__auto__ = function(state_23275){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20401__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20401__auto____1.call(this,state_23275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20401__auto____0;
cljs$core$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20401__auto____1;
return cljs$core$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___23309,out))
})();
var state__20556__auto__ = (function (){var statearr_23304 = f__20555__auto__.call(null);
(statearr_23304[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___23309);

return statearr_23304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___23309,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map