// Compiled by ClojureScript 1.8.34 {}
goog.provide('full.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
full.async.cljs_env_QMARK_ = (function full$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
full.async.PSupervisor = function(){};

full.async._error = (function full$async$_error(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_error$arity$1 == null)))){
return this$.full$async$PSupervisor$_error$arity$1(this$);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._error[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$);
} else {
var m__19038__auto____$1 = (full.async._error["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

full.async._abort = (function full$async$_abort(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_abort$arity$1 == null)))){
return this$.full$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._abort[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$);
} else {
var m__19038__auto____$1 = (full.async._abort["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

full.async._register_go = (function full$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._register_go[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,body);
} else {
var m__19038__auto____$1 = (full.async._register_go["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

full.async._unregister_go = (function full$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._unregister_go[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,id);
} else {
var m__19038__auto____$1 = (full.async._unregister_go["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

full.async._track_exception = (function full$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._track_exception[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,e);
} else {
var m__19038__auto____$1 = (full.async._track_exception["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

full.async._free_exception = (function full$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__19037__auto__ = (((this$ == null))?null:this$);
var m__19038__auto__ = (full.async._free_exception[goog.typeOf(x__19037__auto__)]);
if(!((m__19038__auto__ == null))){
return m__19038__auto__.call(null,this$,e);
} else {
var m__19038__auto____$1 = (full.async._free_exception["_"]);
if(!((m__19038__auto____$1 == null))){
return m__19038__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

full.async.now = (function full$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {full.async.PSupervisor}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
full.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__18996__auto__,k__18997__auto__){
var self__ = this;
var this__18996__auto____$1 = this;
return cljs.core._lookup.call(null,this__18996__auto____$1,k__18997__auto__,null);
});

full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__18998__auto__,k24240,else__18999__auto__){
var self__ = this;
var this__18998__auto____$1 = this;
var G__24242 = (((k24240 instanceof cljs.core.Keyword))?k24240.fqn:null);
switch (G__24242) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k24240,else__18999__auto__);

}
});

full.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19010__auto__,writer__19011__auto__,opts__19012__auto__){
var self__ = this;
var this__19010__auto____$1 = this;
var pr_pair__19013__auto__ = ((function (this__19010__auto____$1){
return (function (keyval__19014__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19011__auto__,cljs.core.pr_writer,""," ","",opts__19012__auto__,keyval__19014__auto__);
});})(this__19010__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19011__auto__,pr_pair__19013__auto__,"#full.async.TrackingSupervisor{",", ","}",opts__19012__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = true;

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__24239){
var self__ = this;
var G__24239__$1 = this;
return (new cljs.core.RecordIter((0),G__24239__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

full.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__18994__auto__){
var self__ = this;
var this__18994__auto____$1 = this;
return self__.__meta;
});

full.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__18990__auto__){
var self__ = this;
var this__18990__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19000__auto__){
var self__ = this;
var this__19000__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__18991__auto__){
var self__ = this;
var this__18991__auto____$1 = this;
var h__18809__auto__ = self__.__hash;
if(!((h__18809__auto__ == null))){
return h__18809__auto__;
} else {
var h__18809__auto____$1 = cljs.core.hash_imap.call(null,this__18991__auto____$1);
self__.__hash = h__18809__auto____$1;

return h__18809__auto____$1;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__18992__auto__,other__18993__auto__){
var self__ = this;
var this__18992__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18362__auto__ = other__18993__auto__;
if(cljs.core.truth_(and__18362__auto__)){
var and__18362__auto____$1 = (this__18992__auto____$1.constructor === other__18993__auto__.constructor);
if(and__18362__auto____$1){
return cljs.core.equiv_map.call(null,this__18992__auto____$1,other__18993__auto__);
} else {
return and__18362__auto____$1;
}
} else {
return and__18362__auto__;
}
})())){
return true;
} else {
return false;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19005__auto__,k__19006__auto__){
var self__ = this;
var this__19005__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__19006__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19005__auto____$1),self__.__meta),k__19006__auto__);
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19006__auto__)),null));
}
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$ = true;

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,full.async.now.call(null));
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

full.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19003__auto__,k__19004__auto__,G__24239){
var self__ = this;
var this__19003__auto____$1 = this;
var pred__24243 = cljs.core.keyword_identical_QMARK_;
var expr__24244 = k__19004__auto__;
if(cljs.core.truth_(pred__24243.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__24244))){
return (new full.async.TrackingSupervisor(G__24239,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__24243.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__24244))){
return (new full.async.TrackingSupervisor(self__.error,G__24239,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__24243.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__24244))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,G__24239,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__24243.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__24244))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__24239,self__.__meta,self__.__extmap,null));
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19004__auto__,G__24239),null));
}
}
}
}
});

full.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19008__auto__){
var self__ = this;
var this__19008__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__18995__auto__,G__24239){
var self__ = this;
var this__18995__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__24239,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19001__auto__,entry__19002__auto__){
var self__ = this;
var this__19001__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19002__auto__)){
return cljs.core._assoc.call(null,this__19001__auto____$1,cljs.core._nth.call(null,entry__19002__auto__,(0)),cljs.core._nth.call(null,entry__19002__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19001__auto____$1,entry__19002__auto__);
}
});

full.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

full.async.TrackingSupervisor.cljs$lang$type = true;

full.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__19030__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"full.async/TrackingSupervisor");
});

full.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__19030__auto__,writer__19031__auto__){
return cljs.core._write.call(null,writer__19031__auto__,"full.async/TrackingSupervisor");
});

full.async.__GT_TrackingSupervisor = (function full$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new full.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

full.async.map__GT_TrackingSupervisor = (function full$async$map__GT_TrackingSupervisor(G__24241){
return (new full.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__24241),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__24241),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__24241),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__24241),null,cljs.core.dissoc.call(null,G__24241,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
full.async._STAR_super_STAR_ = (function (){var s = cljs.core.assoc.call(null,full.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null)),new cljs.core.Keyword(null,"global?","global?",-2022837689),true);
var stale_timeout = ((10) * (1000));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,stale_timeout,err_ch){
return (function full$async$loop_fn(e){
cljs.core.println.call(null,"Global Supervisor:",e);

return cljs.core.async.take_BANG_.call(null,err_ch,full$async$loop_fn);
});})(s,stale_timeout,err_ch))
);

((function (s,stale_timeout,err_ch){
return (function full$async$pending(_){
var vec__24251 = cljs.core.filter.call(null,((function (s,stale_timeout,err_ch){
return (function (p__24253){
var vec__24254 = p__24253;
var k = cljs.core.nth.call(null,vec__24254,(0),null);
var v = cljs.core.nth.call(null,vec__24254,(1),null);
return ((full.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,stale_timeout,err_ch))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__24252 = cljs.core.nth.call(null,vec__24251,(0),null);
var e = cljs.core.nth.call(null,vec__24252,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__24252,(1),null);
if(cljs.core.truth_(e)){
cljs.core.println.call(null,"Global Supervisor detected stale error:",e,e.stack);

full.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),full$async$pending);
});})(s,stale_timeout,err_ch))
.call(null,null);

return s;
})();
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
full.async.throw_if_exception = (function full$async$throw_if_exception(x){
if((x instanceof Error)){
full.async._free_exception.call(null,full.async._STAR_super_STAR_,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__18374__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.take_QMARK_ = (function full$async$take_QMARK_(var_args){
var args24273 = [];
var len__19443__auto___24276 = arguments.length;
var i__19444__auto___24277 = (0);
while(true){
if((i__19444__auto___24277 < len__19443__auto___24276)){
args24273.push((arguments[i__19444__auto___24277]));

var G__24278 = (i__19444__auto___24277 + (1));
i__19444__auto___24277 = G__24278;
continue;
} else {
}
break;
}

var G__24275 = args24273.length;
switch (G__24275) {
case 2:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24273.length)].join('')));

}
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return full.async.take_QMARK_.call(null,port,fn1,true);
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var super$ = full.async._STAR_super_STAR_;
return cljs.core.async.take_BANG_.call(null,port,((function (super$){
return (function (v){
if((v instanceof Error)){
full.async._free_exception.call(null,super$,v);
} else {
}

return fn1.call(null,v);
});})(super$))
,on_caller_QMARK_);
});

full.async.take_QMARK_.cljs$lang$maxFixedArity = 3;
/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.put_QMARK_ = (function full$async$put_QMARK_(var_args){
var args24280 = [];
var len__19443__auto___24283 = arguments.length;
var i__19444__auto___24284 = (0);
while(true){
if((i__19444__auto___24284 < len__19443__auto___24283)){
args24280.push((arguments[i__19444__auto___24284]));

var G__24285 = (i__19444__auto___24284 + (1));
i__19444__auto___24284 = G__24285;
continue;
} else {
}
break;
}

var G__24282 = args24280.length;
switch (G__24282) {
case 2:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24280.length)].join('')));

}
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
return full.async.put_QMARK_.call(null,port,val,(function full$async$noop(_){
return null;
}));
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return full.async.put_QMARK_.call(null,port,val,fn1,true);
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
full.async._track_exception.call(null,full.async._STAR_super_STAR_,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

full.async.put_QMARK_.cljs$lang$maxFixedArity = 4;
/**
 * Same as core.async alts! but throws an exception if the channel returns a
 *   throwable object or the context has been aborted.
 */
full.async.alts_QMARK_ = (function full$async$alts_QMARK_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___24291 = arguments.length;
var i__19444__auto___24292 = (0);
while(true){
if((i__19444__auto___24292 < len__19443__auto___24291)){
args__19450__auto__.push((arguments[i__19444__auto___24292]));

var G__24293 = (i__19444__auto___24292 + (1));
i__19444__auto___24292 = G__24293;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((1) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((1)),(0),null)):null);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19451__auto__);
});

full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,opts){
var abort__23517__auto__ = full.async._abort.call(null,full.async._STAR_super_STAR_);
var to__23518__auto__ = cljs.core.async.timeout.call(null,(0));
var vec__24289 = cljs.core.async.alts_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [abort__23517__auto__,to__23518__auto__], null),new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var val__23519__auto__ = cljs.core.nth.call(null,vec__24289,(0),null);
var port__23520__auto__ = cljs.core.nth.call(null,vec__24289,(1),null);
if(cljs.core._EQ_.call(null,port__23520__auto__,abort__23517__auto__)){
return cljs.core.ex_info.call(null,"Aborted operations",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"aborted","aborted",1775972619)], null));
} else {
var vec__24290 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var val = cljs.core.nth.call(null,vec__24290,(0),null);
var port = cljs.core.nth.call(null,vec__24290,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [full.async.throw_if_exception.call(null,val),port], null);
}
});

full.async.alts_QMARK_.cljs$lang$maxFixedArity = (1);

full.async.alts_QMARK_.cljs$lang$applyTo = (function (seq24287){
var G__24288 = cljs.core.first.call(null,seq24287);
var seq24287__$1 = cljs.core.next.call(null,seq24287);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__24288,seq24287__$1);
});
/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
full.async.pmap_GT__GT_ = (function full$async$pmap_GT__GT_(var_args){
var args24302 = [];
var len__19443__auto___24424 = arguments.length;
var i__19444__auto___24425 = (0);
while(true){
if((i__19444__auto___24425 < len__19443__auto___24424)){
args24302.push((arguments[i__19444__auto___24425]));

var G__24426 = (i__19444__auto___24425 + (1));
i__19444__auto___24425 = G__24426;
continue;
} else {
}
break;
}

var G__24304 = args24302.length;
switch (G__24304) {
case 3:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24302.length)].join('')));

}
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3 = (function (f_GT_,parallelism,in_ch){
return full.async.pmap_GT__GT_.call(null,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__19288__auto___24428 = parallelism;
var __24429 = (0);
while(true){
if((__24429 < n__19288__auto___24428)){
var c__20554__auto___24430 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__24429,c__20554__auto___24430,n__19288__auto___24428,threads){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (__24429,c__20554__auto___24430,n__19288__auto___24428,threads){
return (function (state_24380){
var state_val_24381 = (state_24380[(1)]);
if((state_val_24381 === (7))){
var inst_24369 = (state_24380[(2)]);
var state_24380__$1 = state_24380;
var statearr_24382_24431 = state_24380__$1;
(statearr_24382_24431[(2)] = inst_24369);

(statearr_24382_24431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (20))){
var inst_24340 = (state_24380[(7)]);
var inst_24346 = (state_24380[(2)]);
var inst_24347 = cljs.core.nth.call(null,inst_24346,(0),null);
var inst_24348 = cljs.core.nth.call(null,inst_24346,(1),null);
var inst_24349 = cljs.core._EQ_.call(null,inst_24348,inst_24340);
var state_24380__$1 = (function (){var statearr_24383 = state_24380;
(statearr_24383[(8)] = inst_24347);

return statearr_24383;
})();
if(inst_24349){
var statearr_24384_24432 = state_24380__$1;
(statearr_24384_24432[(1)] = (21));

} else {
var statearr_24385_24433 = state_24380__$1;
(statearr_24385_24433[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (27))){
var inst_24378 = (state_24380[(2)]);
var state_24380__$1 = state_24380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24380__$1,inst_24378);
} else {
if((state_val_24381 === (1))){
var state_24380__$1 = state_24380;
var statearr_24386_24434 = state_24380__$1;
(statearr_24386_24434[(2)] = null);

(statearr_24386_24434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (24))){
var inst_24357 = (state_24380[(2)]);
var state_24380__$1 = state_24380;
var statearr_24387_24435 = state_24380__$1;
(statearr_24387_24435[(2)] = inst_24357);

(statearr_24387_24435[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (4))){
var inst_24307 = (state_24380[(9)]);
var inst_24307__$1 = (state_24380[(2)]);
var state_24380__$1 = (function (){var statearr_24388 = state_24380;
(statearr_24388[(9)] = inst_24307__$1);

return statearr_24388;
})();
if(cljs.core.truth_(inst_24307__$1)){
var statearr_24389_24436 = state_24380__$1;
(statearr_24389_24436[(1)] = (5));

} else {
var statearr_24390_24437 = state_24380__$1;
(statearr_24390_24437[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (15))){
var inst_24329 = (state_24380[(2)]);
var state_24380__$1 = state_24380;
var statearr_24391_24438 = state_24380__$1;
(statearr_24391_24438[(2)] = inst_24329);

(statearr_24391_24438[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (21))){
var inst_24351 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24352 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24353 = cljs.core.PersistentHashMap.fromArrays(inst_24351,inst_24352);
var inst_24354 = cljs.core.ex_info.call(null,"Aborted operations",inst_24353);
var state_24380__$1 = state_24380;
var statearr_24392_24439 = state_24380__$1;
(statearr_24392_24439[(2)] = inst_24354);

(statearr_24392_24439[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (13))){
var inst_24307 = (state_24380[(9)]);
var state_24380__$1 = state_24380;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24380__$1,(15),out_ch,inst_24307);
} else {
if((state_val_24381 === (22))){
var inst_24337 = (state_24380[(10)]);
var state_24380__$1 = state_24380;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24380__$1,(24),out_ch,inst_24337);
} else {
if((state_val_24381 === (6))){
var state_24380__$1 = state_24380;
var statearr_24393_24440 = state_24380__$1;
(statearr_24393_24440[(2)] = null);

(statearr_24393_24440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (25))){
var inst_24375 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_24380__$1 = state_24380;
var statearr_24394_24441 = state_24380__$1;
(statearr_24394_24441[(2)] = inst_24375);

(statearr_24394_24441[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (17))){
var inst_24340 = (state_24380[(7)]);
var inst_24340__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24341 = cljs.core.async.timeout.call(null,(0));
var inst_24342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24343 = [inst_24340__$1,inst_24341];
var inst_24344 = (new cljs.core.PersistentVector(null,2,(5),inst_24342,inst_24343,null));
var state_24380__$1 = (function (){var statearr_24395 = state_24380;
(statearr_24395[(7)] = inst_24340__$1);

return statearr_24395;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24380__$1,(20),inst_24344,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_24381 === (3))){
var inst_24371 = (state_24380[(2)]);
var inst_24372 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_24373 = (inst_24372 === (0));
var state_24380__$1 = (function (){var statearr_24396 = state_24380;
(statearr_24396[(11)] = inst_24371);

return statearr_24396;
})();
if(cljs.core.truth_(inst_24373)){
var statearr_24397_24442 = state_24380__$1;
(statearr_24397_24442[(1)] = (25));

} else {
var statearr_24398_24443 = state_24380__$1;
(statearr_24398_24443[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (12))){
var inst_24323 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24324 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24325 = cljs.core.PersistentHashMap.fromArrays(inst_24323,inst_24324);
var inst_24326 = cljs.core.ex_info.call(null,"Aborted operations",inst_24325);
var state_24380__$1 = state_24380;
var statearr_24399_24444 = state_24380__$1;
(statearr_24399_24444[(2)] = inst_24326);

(statearr_24399_24444[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (2))){
var state_24380__$1 = state_24380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24380__$1,(4),in_ch);
} else {
if((state_val_24381 === (23))){
var inst_24359 = (state_24380[(2)]);
var inst_24360 = full.async.throw_if_exception.call(null,inst_24359);
var state_24380__$1 = state_24380;
var statearr_24400_24445 = state_24380__$1;
(statearr_24400_24445[(2)] = inst_24360);

(statearr_24400_24445[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (19))){
var inst_24363 = (state_24380[(2)]);
var state_24380__$1 = (function (){var statearr_24401 = state_24380;
(statearr_24401[(12)] = inst_24363);

return statearr_24401;
})();
var statearr_24402_24446 = state_24380__$1;
(statearr_24402_24446[(2)] = null);

(statearr_24402_24446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (11))){
var inst_24312 = (state_24380[(13)]);
var inst_24318 = (state_24380[(2)]);
var inst_24319 = cljs.core.nth.call(null,inst_24318,(0),null);
var inst_24320 = cljs.core.nth.call(null,inst_24318,(1),null);
var inst_24321 = cljs.core._EQ_.call(null,inst_24320,inst_24312);
var state_24380__$1 = (function (){var statearr_24403 = state_24380;
(statearr_24403[(14)] = inst_24319);

return statearr_24403;
})();
if(inst_24321){
var statearr_24404_24447 = state_24380__$1;
(statearr_24404_24447[(1)] = (12));

} else {
var statearr_24405_24448 = state_24380__$1;
(statearr_24405_24448[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (9))){
var inst_24307 = (state_24380[(9)]);
var inst_24335 = f_GT_.call(null,inst_24307);
var state_24380__$1 = state_24380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24380__$1,(16),inst_24335);
} else {
if((state_val_24381 === (5))){
var inst_24307 = (state_24380[(9)]);
var inst_24309 = (inst_24307 instanceof Error);
var state_24380__$1 = state_24380;
if(cljs.core.truth_(inst_24309)){
var statearr_24406_24449 = state_24380__$1;
(statearr_24406_24449[(1)] = (8));

} else {
var statearr_24407_24450 = state_24380__$1;
(statearr_24407_24450[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (14))){
var inst_24331 = (state_24380[(2)]);
var inst_24332 = full.async.throw_if_exception.call(null,inst_24331);
var inst_24333 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_24380__$1 = (function (){var statearr_24408 = state_24380;
(statearr_24408[(15)] = inst_24332);

return statearr_24408;
})();
var statearr_24409_24451 = state_24380__$1;
(statearr_24409_24451[(2)] = inst_24333);

(statearr_24409_24451[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (26))){
var state_24380__$1 = state_24380;
var statearr_24410_24452 = state_24380__$1;
(statearr_24410_24452[(2)] = null);

(statearr_24410_24452[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (16))){
var inst_24337 = (state_24380[(10)]);
var inst_24337__$1 = (state_24380[(2)]);
var state_24380__$1 = (function (){var statearr_24411 = state_24380;
(statearr_24411[(10)] = inst_24337__$1);

return statearr_24411;
})();
if(cljs.core.truth_(inst_24337__$1)){
var statearr_24412_24453 = state_24380__$1;
(statearr_24412_24453[(1)] = (17));

} else {
var statearr_24413_24454 = state_24380__$1;
(statearr_24413_24454[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (10))){
var inst_24366 = (state_24380[(2)]);
var state_24380__$1 = state_24380;
var statearr_24414_24455 = state_24380__$1;
(statearr_24414_24455[(2)] = inst_24366);

(statearr_24414_24455[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (18))){
var state_24380__$1 = state_24380;
var statearr_24415_24456 = state_24380__$1;
(statearr_24415_24456[(2)] = null);

(statearr_24415_24456[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24381 === (8))){
var inst_24312 = (state_24380[(13)]);
var inst_24312__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24313 = cljs.core.async.timeout.call(null,(0));
var inst_24314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24315 = [inst_24312__$1,inst_24313];
var inst_24316 = (new cljs.core.PersistentVector(null,2,(5),inst_24314,inst_24315,null));
var state_24380__$1 = (function (){var statearr_24416 = state_24380;
(statearr_24416[(13)] = inst_24312__$1);

return statearr_24416;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24380__$1,(11),inst_24316,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__24429,c__20554__auto___24430,n__19288__auto___24428,threads))
;
return ((function (__24429,switch__20400__auto__,c__20554__auto___24430,n__19288__auto___24428,threads){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24420 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24420[(0)] = full$async$state_machine__20401__auto__);

(statearr_24420[(1)] = (1));

return statearr_24420;
});
var full$async$state_machine__20401__auto____1 = (function (state_24380){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24421){if((e24421 instanceof Object)){
var ex__20404__auto__ = e24421;
var statearr_24422_24457 = state_24380;
(statearr_24422_24457[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24380);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24421;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24458 = state_24380;
state_24380 = G__24458;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24380){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(__24429,switch__20400__auto__,c__20554__auto___24430,n__19288__auto___24428,threads))
})();
var state__20556__auto__ = (function (){var statearr_24423 = f__20555__auto__.call(null);
(statearr_24423[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24430);

return statearr_24423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(__24429,c__20554__auto___24430,n__19288__auto___24428,threads))
);


var G__24459 = (__24429 + (1));
__24429 = G__24459;
continue;
} else {
}
break;
}

return out_ch;
});

full.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 4;
/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
full.async.engulf = (function full$async$engulf(var_args){
var args__19450__auto__ = [];
var len__19443__auto___24487 = arguments.length;
var i__19444__auto___24488 = (0);
while(true){
if((i__19444__auto___24488 < len__19443__auto___24487)){
args__19450__auto__.push((arguments[i__19444__auto___24488]));

var G__24489 = (i__19444__auto___24488 + (1));
i__19444__auto___24488 = G__24489;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((0) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((0)),(0),null)):null);
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(argseq__19451__auto__);
});

full.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__,ch){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__,ch){
return (function (state_24472){
var state_val_24473 = (state_24472[(1)]);
if((state_val_24473 === (1))){
var state_24472__$1 = state_24472;
var statearr_24474_24490 = state_24472__$1;
(statearr_24474_24490[(2)] = null);

(statearr_24474_24490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (2))){
var state_24472__$1 = state_24472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24472__$1,(4),ch);
} else {
if((state_val_24473 === (3))){
var inst_24470 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24472__$1,inst_24470);
} else {
if((state_val_24473 === (4))){
var inst_24463 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
if(cljs.core.truth_(inst_24463)){
var statearr_24475_24491 = state_24472__$1;
(statearr_24475_24491[(1)] = (5));

} else {
var statearr_24476_24492 = state_24472__$1;
(statearr_24476_24492[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (5))){
var state_24472__$1 = state_24472;
var statearr_24477_24493 = state_24472__$1;
(statearr_24477_24493[(2)] = null);

(statearr_24477_24493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (6))){
var state_24472__$1 = state_24472;
var statearr_24478_24494 = state_24472__$1;
(statearr_24478_24494[(2)] = null);

(statearr_24478_24494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24473 === (7))){
var inst_24468 = (state_24472[(2)]);
var state_24472__$1 = state_24472;
var statearr_24479_24495 = state_24472__$1;
(statearr_24479_24495[(2)] = inst_24468);

(statearr_24479_24495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20554__auto__,ch))
;
return ((function (switch__20400__auto__,c__20554__auto__,ch){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24483 = [null,null,null,null,null,null,null];
(statearr_24483[(0)] = full$async$state_machine__20401__auto__);

(statearr_24483[(1)] = (1));

return statearr_24483;
});
var full$async$state_machine__20401__auto____1 = (function (state_24472){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24484){if((e24484 instanceof Object)){
var ex__20404__auto__ = e24484;
var statearr_24485_24496 = state_24472;
(statearr_24485_24496[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24484;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24497 = state_24472;
state_24472 = G__24497;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24472){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__,ch))
})();
var state__20556__auto__ = (function (){var statearr_24486 = f__20555__auto__.call(null);
(statearr_24486[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_24486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__,ch))
);

return c__20554__auto__;
});

full.async.engulf.cljs$lang$maxFixedArity = (0);

full.async.engulf.cljs$lang$applyTo = (function (seq24460){
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq24460));
});
/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
full.async.reduce_GT_ = (function full$async$reduce_GT_(f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__20554__auto___24702 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___24702,result){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___24702,result){
return (function (state_24666){
var state_val_24667 = (state_24666[(1)]);
if((state_val_24667 === (7))){
var inst_24662 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24668_24703 = state_24666__$1;
(statearr_24668_24703[(2)] = inst_24662);

(statearr_24668_24703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (20))){
var inst_24658 = (state_24666[(2)]);
var inst_24659 = full.async.throw_if_exception.call(null,inst_24658);
var inst_24660 = cljs.core.async.close_BANG_.call(null,result);
var state_24666__$1 = (function (){var statearr_24669 = state_24666;
(statearr_24669[(7)] = inst_24659);

return statearr_24669;
})();
var statearr_24670_24704 = state_24666__$1;
(statearr_24670_24704[(2)] = inst_24660);

(statearr_24670_24704[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (1))){
var inst_24600 = acc;
var state_24666__$1 = (function (){var statearr_24671 = state_24666;
(statearr_24671[(8)] = inst_24600);

return statearr_24671;
})();
var statearr_24672_24705 = state_24666__$1;
(statearr_24672_24705[(2)] = null);

(statearr_24672_24705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (4))){
var inst_24603 = (state_24666[(9)]);
var inst_24603__$1 = (state_24666[(2)]);
var state_24666__$1 = (function (){var statearr_24673 = state_24666;
(statearr_24673[(9)] = inst_24603__$1);

return statearr_24673;
})();
if(cljs.core.truth_(inst_24603__$1)){
var statearr_24674_24706 = state_24666__$1;
(statearr_24674_24706[(1)] = (5));

} else {
var statearr_24675_24707 = state_24666__$1;
(statearr_24675_24707[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (15))){
var inst_24625 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24676_24708 = state_24666__$1;
(statearr_24676_24708[(2)] = inst_24625);

(statearr_24676_24708[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (21))){
var inst_24656 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24677_24709 = state_24666__$1;
(statearr_24677_24709[(2)] = inst_24656);

(statearr_24677_24709[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (13))){
var inst_24603 = (state_24666[(9)]);
var state_24666__$1 = state_24666;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24666__$1,(15),result,inst_24603);
} else {
if((state_val_24667 === (6))){
var inst_24639 = (state_24666[(10)]);
var inst_24639__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24640 = cljs.core.async.timeout.call(null,(0));
var inst_24641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24642 = [inst_24639__$1,inst_24640];
var inst_24643 = (new cljs.core.PersistentVector(null,2,(5),inst_24641,inst_24642,null));
var state_24666__$1 = (function (){var statearr_24678 = state_24666;
(statearr_24678[(10)] = inst_24639__$1);

return statearr_24678;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24666__$1,(17),inst_24643,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_24667 === (17))){
var inst_24639 = (state_24666[(10)]);
var inst_24645 = (state_24666[(2)]);
var inst_24646 = cljs.core.nth.call(null,inst_24645,(0),null);
var inst_24647 = cljs.core.nth.call(null,inst_24645,(1),null);
var inst_24648 = cljs.core._EQ_.call(null,inst_24647,inst_24639);
var state_24666__$1 = (function (){var statearr_24679 = state_24666;
(statearr_24679[(11)] = inst_24646);

return statearr_24679;
})();
if(inst_24648){
var statearr_24680_24710 = state_24666__$1;
(statearr_24680_24710[(1)] = (18));

} else {
var statearr_24681_24711 = state_24666__$1;
(statearr_24681_24711[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (3))){
var inst_24664 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24666__$1,inst_24664);
} else {
if((state_val_24667 === (12))){
var inst_24619 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24620 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24621 = cljs.core.PersistentHashMap.fromArrays(inst_24619,inst_24620);
var inst_24622 = cljs.core.ex_info.call(null,"Aborted operations",inst_24621);
var state_24666__$1 = state_24666;
var statearr_24682_24712 = state_24666__$1;
(statearr_24682_24712[(2)] = inst_24622);

(statearr_24682_24712[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (2))){
var state_24666__$1 = state_24666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24666__$1,(4),ch);
} else {
if((state_val_24667 === (19))){
var inst_24600 = (state_24666[(8)]);
var state_24666__$1 = state_24666;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24666__$1,(21),result,inst_24600);
} else {
if((state_val_24667 === (11))){
var inst_24608 = (state_24666[(12)]);
var inst_24614 = (state_24666[(2)]);
var inst_24615 = cljs.core.nth.call(null,inst_24614,(0),null);
var inst_24616 = cljs.core.nth.call(null,inst_24614,(1),null);
var inst_24617 = cljs.core._EQ_.call(null,inst_24616,inst_24608);
var state_24666__$1 = (function (){var statearr_24683 = state_24666;
(statearr_24683[(13)] = inst_24615);

return statearr_24683;
})();
if(inst_24617){
var statearr_24684_24713 = state_24666__$1;
(statearr_24684_24713[(1)] = (12));

} else {
var statearr_24685_24714 = state_24666__$1;
(statearr_24685_24714[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (9))){
var inst_24600 = (state_24666[(8)]);
var inst_24603 = (state_24666[(9)]);
var inst_24631 = f_GT_.call(null,inst_24600,inst_24603);
var state_24666__$1 = state_24666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24666__$1,(16),inst_24631);
} else {
if((state_val_24667 === (5))){
var inst_24603 = (state_24666[(9)]);
var inst_24605 = (inst_24603 instanceof Error);
var state_24666__$1 = state_24666;
if(cljs.core.truth_(inst_24605)){
var statearr_24686_24715 = state_24666__$1;
(statearr_24686_24715[(1)] = (8));

} else {
var statearr_24687_24716 = state_24666__$1;
(statearr_24687_24716[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (14))){
var inst_24627 = (state_24666[(2)]);
var inst_24628 = full.async.throw_if_exception.call(null,inst_24627);
var inst_24629 = cljs.core.async.close_BANG_.call(null,result);
var state_24666__$1 = (function (){var statearr_24688 = state_24666;
(statearr_24688[(14)] = inst_24628);

return statearr_24688;
})();
var statearr_24689_24717 = state_24666__$1;
(statearr_24689_24717[(2)] = inst_24629);

(statearr_24689_24717[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (16))){
var inst_24633 = (state_24666[(2)]);
var inst_24600 = inst_24633;
var state_24666__$1 = (function (){var statearr_24690 = state_24666;
(statearr_24690[(8)] = inst_24600);

return statearr_24690;
})();
var statearr_24691_24718 = state_24666__$1;
(statearr_24691_24718[(2)] = null);

(statearr_24691_24718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (10))){
var inst_24636 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24692_24719 = state_24666__$1;
(statearr_24692_24719[(2)] = inst_24636);

(statearr_24692_24719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (18))){
var inst_24650 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_24651 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_24652 = cljs.core.PersistentHashMap.fromArrays(inst_24650,inst_24651);
var inst_24653 = cljs.core.ex_info.call(null,"Aborted operations",inst_24652);
var state_24666__$1 = state_24666;
var statearr_24693_24720 = state_24666__$1;
(statearr_24693_24720[(2)] = inst_24653);

(statearr_24693_24720[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (8))){
var inst_24608 = (state_24666[(12)]);
var inst_24608__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_24609 = cljs.core.async.timeout.call(null,(0));
var inst_24610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24611 = [inst_24608__$1,inst_24609];
var inst_24612 = (new cljs.core.PersistentVector(null,2,(5),inst_24610,inst_24611,null));
var state_24666__$1 = (function (){var statearr_24694 = state_24666;
(statearr_24694[(12)] = inst_24608__$1);

return statearr_24694;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24666__$1,(11),inst_24612,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___24702,result))
;
return ((function (switch__20400__auto__,c__20554__auto___24702,result){
return (function() {
var full$async$reduce_GT__$_state_machine__20401__auto__ = null;
var full$async$reduce_GT__$_state_machine__20401__auto____0 = (function (){
var statearr_24698 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24698[(0)] = full$async$reduce_GT__$_state_machine__20401__auto__);

(statearr_24698[(1)] = (1));

return statearr_24698;
});
var full$async$reduce_GT__$_state_machine__20401__auto____1 = (function (state_24666){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24699){if((e24699 instanceof Object)){
var ex__20404__auto__ = e24699;
var statearr_24700_24721 = state_24666;
(statearr_24700_24721[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24699;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24722 = state_24666;
state_24666 = G__24722;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$reduce_GT__$_state_machine__20401__auto__ = function(state_24666){
switch(arguments.length){
case 0:
return full$async$reduce_GT__$_state_machine__20401__auto____0.call(this);
case 1:
return full$async$reduce_GT__$_state_machine__20401__auto____1.call(this,state_24666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$reduce_GT__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$reduce_GT__$_state_machine__20401__auto____0;
full$async$reduce_GT__$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$reduce_GT__$_state_machine__20401__auto____1;
return full$async$reduce_GT__$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___24702,result))
})();
var state__20556__auto__ = (function (){var statearr_24701 = f__20555__auto__.call(null);
(statearr_24701[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24702);

return statearr_24701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___24702,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
full.async.concat_GT__GT_ = (function full$async$concat_GT__GT_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___24771 = arguments.length;
var i__19444__auto___24772 = (0);
while(true){
if((i__19444__auto___24772 < len__19443__auto___24771)){
args__19450__auto__.push((arguments[i__19444__auto___24772]));

var G__24773 = (i__19444__auto___24772 + (1));
i__19444__auto___24772 = G__24773;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((0) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((0)),(0),null)):null);
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__19451__auto__);
});

full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var out = cljs.core.async.chan.call(null);
var c__20554__auto___24774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___24774,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___24774,out){
return (function (state_24746){
var state_val_24747 = (state_24746[(1)]);
if((state_val_24747 === (7))){
var inst_24729 = (state_24746[(7)]);
var inst_24729__$1 = (state_24746[(2)]);
var state_24746__$1 = (function (){var statearr_24748 = state_24746;
(statearr_24748[(7)] = inst_24729__$1);

return statearr_24748;
})();
if(cljs.core.truth_(inst_24729__$1)){
var statearr_24749_24775 = state_24746__$1;
(statearr_24749_24775[(1)] = (8));

} else {
var statearr_24750_24776 = state_24746__$1;
(statearr_24750_24776[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (1))){
var inst_24724 = cs;
var state_24746__$1 = (function (){var statearr_24751 = state_24746;
(statearr_24751[(8)] = inst_24724);

return statearr_24751;
})();
var statearr_24752_24777 = state_24746__$1;
(statearr_24752_24777[(2)] = null);

(statearr_24752_24777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (4))){
var inst_24726 = (state_24746[(9)]);
var state_24746__$1 = state_24746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24746__$1,(7),inst_24726);
} else {
if((state_val_24747 === (6))){
var inst_24742 = (state_24746[(2)]);
var state_24746__$1 = state_24746;
var statearr_24753_24778 = state_24746__$1;
(statearr_24753_24778[(2)] = inst_24742);

(statearr_24753_24778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (3))){
var inst_24744 = (state_24746[(2)]);
var state_24746__$1 = state_24746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24746__$1,inst_24744);
} else {
if((state_val_24747 === (2))){
var inst_24724 = (state_24746[(8)]);
var inst_24726 = (state_24746[(9)]);
var inst_24726__$1 = cljs.core.first.call(null,inst_24724);
var state_24746__$1 = (function (){var statearr_24755 = state_24746;
(statearr_24755[(9)] = inst_24726__$1);

return statearr_24755;
})();
if(cljs.core.truth_(inst_24726__$1)){
var statearr_24756_24779 = state_24746__$1;
(statearr_24756_24779[(1)] = (4));

} else {
var statearr_24757_24780 = state_24746__$1;
(statearr_24757_24780[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (11))){
var inst_24724 = (state_24746[(8)]);
var inst_24732 = (state_24746[(2)]);
var tmp24754 = inst_24724;
var inst_24724__$1 = tmp24754;
var state_24746__$1 = (function (){var statearr_24758 = state_24746;
(statearr_24758[(8)] = inst_24724__$1);

(statearr_24758[(10)] = inst_24732);

return statearr_24758;
})();
var statearr_24759_24781 = state_24746__$1;
(statearr_24759_24781[(2)] = null);

(statearr_24759_24781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (9))){
var inst_24724 = (state_24746[(8)]);
var inst_24735 = cljs.core.rest.call(null,inst_24724);
var inst_24724__$1 = inst_24735;
var state_24746__$1 = (function (){var statearr_24760 = state_24746;
(statearr_24760[(8)] = inst_24724__$1);

return statearr_24760;
})();
var statearr_24761_24782 = state_24746__$1;
(statearr_24761_24782[(2)] = null);

(statearr_24761_24782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (5))){
var inst_24740 = cljs.core.async.close_BANG_.call(null,out);
var state_24746__$1 = state_24746;
var statearr_24762_24783 = state_24746__$1;
(statearr_24762_24783[(2)] = inst_24740);

(statearr_24762_24783[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (10))){
var inst_24738 = (state_24746[(2)]);
var state_24746__$1 = state_24746;
var statearr_24763_24784 = state_24746__$1;
(statearr_24763_24784[(2)] = inst_24738);

(statearr_24763_24784[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24747 === (8))){
var inst_24729 = (state_24746[(7)]);
var state_24746__$1 = state_24746;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24746__$1,(11),out,inst_24729);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___24774,out))
;
return ((function (switch__20400__auto__,c__20554__auto___24774,out){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24767 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24767[(0)] = full$async$state_machine__20401__auto__);

(statearr_24767[(1)] = (1));

return statearr_24767;
});
var full$async$state_machine__20401__auto____1 = (function (state_24746){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24768){if((e24768 instanceof Object)){
var ex__20404__auto__ = e24768;
var statearr_24769_24785 = state_24746;
(statearr_24769_24785[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24746);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24768;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24786 = state_24746;
state_24746 = G__24786;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24746){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___24774,out))
})();
var state__20556__auto__ = (function (){var statearr_24770 = f__20555__auto__.call(null);
(statearr_24770[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24774);

return statearr_24770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___24774,out))
);


return out;
});

full.async.concat_GT__GT_.cljs$lang$maxFixedArity = (0);

full.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq24723){
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq24723));
});
full.async.partition_all_GT__GT_ = (function full$async$partition_all_GT__GT_(var_args){
var args__19450__auto__ = [];
var len__19443__auto___24867 = arguments.length;
var i__19444__auto___24868 = (0);
while(true){
if((i__19444__auto___24868 < len__19443__auto___24867)){
args__19450__auto__.push((arguments[i__19444__auto___24868]));

var G__24869 = (i__19444__auto___24868 + (1));
i__19444__auto___24868 = G__24869;
continue;
} else {
}
break;
}

var argseq__19451__auto__ = ((((2) < args__19450__auto__.length))?(new cljs.core.IndexedSeq(args__19450__auto__.slice((2)),(0),null)):null);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19451__auto__);
});

full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (n,in_ch,p__24790){
var map__24791 = p__24790;
var map__24791__$1 = ((((!((map__24791 == null)))?((((map__24791.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24791.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24791):map__24791);
var out_ch = cljs.core.get.call(null,map__24791__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__18374__auto__ = out_ch;
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__20554__auto___24870 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___24870,out_ch__$1,map__24791,map__24791__$1,out_ch){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___24870,out_ch__$1,map__24791,map__24791__$1,out_ch){
return (function (state_24833){
var state_val_24834 = (state_24833[(1)]);
if((state_val_24834 === (7))){
var inst_24829 = (state_24833[(2)]);
var state_24833__$1 = state_24833;
var statearr_24835_24871 = state_24833__$1;
(statearr_24835_24871[(2)] = inst_24829);

(statearr_24835_24871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (1))){
var inst_24793 = cljs.core.PersistentVector.EMPTY;
var inst_24794 = inst_24793;
var state_24833__$1 = (function (){var statearr_24836 = state_24833;
(statearr_24836[(7)] = inst_24794);

return statearr_24836;
})();
var statearr_24837_24872 = state_24833__$1;
(statearr_24837_24872[(2)] = null);

(statearr_24837_24872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (4))){
var inst_24797 = (state_24833[(8)]);
var inst_24797__$1 = (state_24833[(2)]);
var state_24833__$1 = (function (){var statearr_24838 = state_24833;
(statearr_24838[(8)] = inst_24797__$1);

return statearr_24838;
})();
if(cljs.core.truth_(inst_24797__$1)){
var statearr_24839_24873 = state_24833__$1;
(statearr_24839_24873[(1)] = (5));

} else {
var statearr_24840_24874 = state_24833__$1;
(statearr_24840_24874[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (15))){
var inst_24810 = (state_24833[(2)]);
var inst_24811 = cljs.core.PersistentVector.EMPTY;
var inst_24794 = inst_24811;
var state_24833__$1 = (function (){var statearr_24841 = state_24833;
(statearr_24841[(9)] = inst_24810);

(statearr_24841[(7)] = inst_24794);

return statearr_24841;
})();
var statearr_24842_24875 = state_24833__$1;
(statearr_24842_24875[(2)] = null);

(statearr_24842_24875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (13))){
var inst_24805 = (state_24833[(10)]);
var inst_24794 = inst_24805;
var state_24833__$1 = (function (){var statearr_24843 = state_24833;
(statearr_24843[(7)] = inst_24794);

return statearr_24843;
})();
var statearr_24844_24876 = state_24833__$1;
(statearr_24844_24876[(2)] = null);

(statearr_24844_24876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (6))){
var inst_24794 = (state_24833[(7)]);
var inst_24820 = cljs.core.not_empty.call(null,inst_24794);
var state_24833__$1 = state_24833;
if(cljs.core.truth_(inst_24820)){
var statearr_24845_24877 = state_24833__$1;
(statearr_24845_24877[(1)] = (16));

} else {
var statearr_24846_24878 = state_24833__$1;
(statearr_24846_24878[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (17))){
var state_24833__$1 = state_24833;
var statearr_24847_24879 = state_24833__$1;
(statearr_24847_24879[(2)] = null);

(statearr_24847_24879[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (3))){
var inst_24831 = (state_24833[(2)]);
var state_24833__$1 = state_24833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24833__$1,inst_24831);
} else {
if((state_val_24834 === (12))){
var inst_24805 = (state_24833[(10)]);
var state_24833__$1 = state_24833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24833__$1,(15),out_ch__$1,inst_24805);
} else {
if((state_val_24834 === (2))){
var state_24833__$1 = state_24833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24833__$1,(4),in_ch);
} else {
if((state_val_24834 === (19))){
var inst_24823 = (state_24833[(2)]);
var state_24833__$1 = state_24833;
var statearr_24848_24880 = state_24833__$1;
(statearr_24848_24880[(2)] = inst_24823);

(statearr_24848_24880[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (11))){
var inst_24802 = (state_24833[(2)]);
var inst_24803 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_24833__$1 = (function (){var statearr_24849 = state_24833;
(statearr_24849[(11)] = inst_24802);

return statearr_24849;
})();
var statearr_24850_24881 = state_24833__$1;
(statearr_24850_24881[(2)] = inst_24803);

(statearr_24850_24881[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (9))){
var inst_24797 = (state_24833[(8)]);
var inst_24805 = (state_24833[(10)]);
var inst_24794 = (state_24833[(7)]);
var inst_24805__$1 = cljs.core.conj.call(null,inst_24794,inst_24797);
var inst_24806 = cljs.core.count.call(null,inst_24805__$1);
var inst_24807 = cljs.core._EQ_.call(null,n,inst_24806);
var state_24833__$1 = (function (){var statearr_24851 = state_24833;
(statearr_24851[(10)] = inst_24805__$1);

return statearr_24851;
})();
if(inst_24807){
var statearr_24852_24882 = state_24833__$1;
(statearr_24852_24882[(1)] = (12));

} else {
var statearr_24853_24883 = state_24833__$1;
(statearr_24853_24883[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (5))){
var inst_24797 = (state_24833[(8)]);
var inst_24799 = (inst_24797 instanceof Error);
var state_24833__$1 = state_24833;
if(cljs.core.truth_(inst_24799)){
var statearr_24854_24884 = state_24833__$1;
(statearr_24854_24884[(1)] = (8));

} else {
var statearr_24855_24885 = state_24833__$1;
(statearr_24855_24885[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (14))){
var inst_24816 = (state_24833[(2)]);
var state_24833__$1 = state_24833;
var statearr_24856_24886 = state_24833__$1;
(statearr_24856_24886[(2)] = inst_24816);

(statearr_24856_24886[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (16))){
var inst_24794 = (state_24833[(7)]);
var state_24833__$1 = state_24833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24833__$1,(19),out_ch__$1,inst_24794);
} else {
if((state_val_24834 === (10))){
var inst_24818 = (state_24833[(2)]);
var state_24833__$1 = state_24833;
var statearr_24857_24887 = state_24833__$1;
(statearr_24857_24887[(2)] = inst_24818);

(statearr_24857_24887[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (18))){
var inst_24826 = (state_24833[(2)]);
var inst_24827 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_24833__$1 = (function (){var statearr_24858 = state_24833;
(statearr_24858[(12)] = inst_24826);

return statearr_24858;
})();
var statearr_24859_24888 = state_24833__$1;
(statearr_24859_24888[(2)] = inst_24827);

(statearr_24859_24888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24834 === (8))){
var inst_24797 = (state_24833[(8)]);
var state_24833__$1 = state_24833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24833__$1,(11),out_ch__$1,inst_24797);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto___24870,out_ch__$1,map__24791,map__24791__$1,out_ch))
;
return ((function (switch__20400__auto__,c__20554__auto___24870,out_ch__$1,map__24791,map__24791__$1,out_ch){
return (function() {
var full$async$state_machine__20401__auto__ = null;
var full$async$state_machine__20401__auto____0 = (function (){
var statearr_24863 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24863[(0)] = full$async$state_machine__20401__auto__);

(statearr_24863[(1)] = (1));

return statearr_24863;
});
var full$async$state_machine__20401__auto____1 = (function (state_24833){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_24833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e24864){if((e24864 instanceof Object)){
var ex__20404__auto__ = e24864;
var statearr_24865_24889 = state_24833;
(statearr_24865_24889[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24833);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24890 = state_24833;
state_24833 = G__24890;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
full$async$state_machine__20401__auto__ = function(state_24833){
switch(arguments.length){
case 0:
return full$async$state_machine__20401__auto____0.call(this);
case 1:
return full$async$state_machine__20401__auto____1.call(this,state_24833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20401__auto____0;
full$async$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20401__auto____1;
return full$async$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___24870,out_ch__$1,map__24791,map__24791__$1,out_ch))
})();
var state__20556__auto__ = (function (){var statearr_24866 = f__20555__auto__.call(null);
(statearr_24866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___24870);

return statearr_24866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___24870,out_ch__$1,map__24791,map__24791__$1,out_ch))
);


return out_ch__$1;
});

full.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (2);

full.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq24787){
var G__24788 = cljs.core.first.call(null,seq24787);
var seq24787__$1 = cljs.core.next.call(null,seq24787);
var G__24789 = cljs.core.first.call(null,seq24787__$1);
var seq24787__$2 = cljs.core.next.call(null,seq24787__$1);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__24788,G__24789,seq24787__$2);
});
/**
 * Counts items in a channel. Returns a channel with the item count.
 */
full.async.count_GT_ = (function full$async$count_GT_(ch){
return cljs.core.async.reduce.call(null,(function (acc,_){
return (acc + (1));
}),(0),ch);
});

//# sourceMappingURL=async.js.map