// Compiled by ClojureScript 1.8.34 {}
goog.provide('full.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
full.async.cljs_env_QMARK_ = (function full$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
full.async.PSupervisor = function(){};

full.async._error = (function full$async$_error(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_error$arity$1 == null)))){
return this$.full$async$PSupervisor$_error$arity$1(this$);
} else {
var x__19118__auto__ = (((this$ == null))?null:this$);
var m__19119__auto__ = (full.async._error[goog.typeOf(x__19118__auto__)]);
if(!((m__19119__auto__ == null))){
return m__19119__auto__.call(null,this$);
} else {
var m__19119__auto____$1 = (full.async._error["_"]);
if(!((m__19119__auto____$1 == null))){
return m__19119__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

full.async._abort = (function full$async$_abort(this$){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_abort$arity$1 == null)))){
return this$.full$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__19118__auto__ = (((this$ == null))?null:this$);
var m__19119__auto__ = (full.async._abort[goog.typeOf(x__19118__auto__)]);
if(!((m__19119__auto__ == null))){
return m__19119__auto__.call(null,this$);
} else {
var m__19119__auto____$1 = (full.async._abort["_"]);
if(!((m__19119__auto____$1 == null))){
return m__19119__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

full.async._register_go = (function full$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__19118__auto__ = (((this$ == null))?null:this$);
var m__19119__auto__ = (full.async._register_go[goog.typeOf(x__19118__auto__)]);
if(!((m__19119__auto__ == null))){
return m__19119__auto__.call(null,this$,body);
} else {
var m__19119__auto____$1 = (full.async._register_go["_"]);
if(!((m__19119__auto____$1 == null))){
return m__19119__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

full.async._unregister_go = (function full$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.full$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__19118__auto__ = (((this$ == null))?null:this$);
var m__19119__auto__ = (full.async._unregister_go[goog.typeOf(x__19118__auto__)]);
if(!((m__19119__auto__ == null))){
return m__19119__auto__.call(null,this$,id);
} else {
var m__19119__auto____$1 = (full.async._unregister_go["_"]);
if(!((m__19119__auto____$1 == null))){
return m__19119__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

full.async._track_exception = (function full$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__19118__auto__ = (((this$ == null))?null:this$);
var m__19119__auto__ = (full.async._track_exception[goog.typeOf(x__19118__auto__)]);
if(!((m__19119__auto__ == null))){
return m__19119__auto__.call(null,this$,e);
} else {
var m__19119__auto____$1 = (full.async._track_exception["_"]);
if(!((m__19119__auto____$1 == null))){
return m__19119__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

full.async._free_exception = (function full$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.full$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.full$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__19118__auto__ = (((this$ == null))?null:this$);
var m__19119__auto__ = (full.async._free_exception[goog.typeOf(x__19118__auto__)]);
if(!((m__19119__auto__ == null))){
return m__19119__auto__.call(null,this$,e);
} else {
var m__19119__auto____$1 = (full.async._free_exception["_"]);
if(!((m__19119__auto____$1 == null))){
return m__19119__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

full.async.now = (function full$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {full.async.PSupervisor}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
full.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__19077__auto__,k__19078__auto__){
var self__ = this;
var this__19077__auto____$1 = this;
return cljs.core._lookup.call(null,this__19077__auto____$1,k__19078__auto__,null);
});

full.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__19079__auto__,k21435,else__19080__auto__){
var self__ = this;
var this__19079__auto____$1 = this;
var G__21437 = (((k21435 instanceof cljs.core.Keyword))?k21435.fqn:null);
switch (G__21437) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k21435,else__19080__auto__);

}
});

full.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__19091__auto__,writer__19092__auto__,opts__19093__auto__){
var self__ = this;
var this__19091__auto____$1 = this;
var pr_pair__19094__auto__ = ((function (this__19091__auto____$1){
return (function (keyval__19095__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__19092__auto__,cljs.core.pr_writer,""," ","",opts__19093__auto__,keyval__19095__auto__);
});})(this__19091__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__19092__auto__,pr_pair__19094__auto__,"#full.async.TrackingSupervisor{",", ","}",opts__19093__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = true;

full.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21434){
var self__ = this;
var G__21434__$1 = this;
return (new cljs.core.RecordIter((0),G__21434__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

full.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__19075__auto__){
var self__ = this;
var this__19075__auto____$1 = this;
return self__.__meta;
});

full.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__19071__auto__){
var self__ = this;
var this__19071__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__19081__auto__){
var self__ = this;
var this__19081__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__19072__auto__){
var self__ = this;
var this__19072__auto____$1 = this;
var h__18890__auto__ = self__.__hash;
if(!((h__18890__auto__ == null))){
return h__18890__auto__;
} else {
var h__18890__auto____$1 = cljs.core.hash_imap.call(null,this__19072__auto____$1);
self__.__hash = h__18890__auto____$1;

return h__18890__auto____$1;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__19073__auto__,other__19074__auto__){
var self__ = this;
var this__19073__auto____$1 = this;
if(cljs.core.truth_((function (){var and__18443__auto__ = other__19074__auto__;
if(cljs.core.truth_(and__18443__auto__)){
var and__18443__auto____$1 = (this__19073__auto____$1.constructor === other__19074__auto__.constructor);
if(and__18443__auto____$1){
return cljs.core.equiv_map.call(null,this__19073__auto____$1,other__19074__auto__);
} else {
return and__18443__auto____$1;
}
} else {
return and__18443__auto__;
}
})())){
return true;
} else {
return false;
}
});

full.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__19086__auto__,k__19087__auto__){
var self__ = this;
var this__19086__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__19087__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__19086__auto____$1),self__.__meta),k__19087__auto__);
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__19087__auto__)),null));
}
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$ = true;

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,full.async.now.call(null));
});

full.async.TrackingSupervisor.prototype.full$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

full.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__19084__auto__,k__19085__auto__,G__21434){
var self__ = this;
var this__19084__auto____$1 = this;
var pred__21438 = cljs.core.keyword_identical_QMARK_;
var expr__21439 = k__19085__auto__;
if(cljs.core.truth_(pred__21438.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__21439))){
return (new full.async.TrackingSupervisor(G__21434,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21438.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__21439))){
return (new full.async.TrackingSupervisor(self__.error,G__21434,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21438.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__21439))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,G__21434,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21438.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__21439))){
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__21434,self__.__meta,self__.__extmap,null));
} else {
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__19085__auto__,G__21434),null));
}
}
}
}
});

full.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__19089__auto__){
var self__ = this;
var this__19089__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

full.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__19076__auto__,G__21434){
var self__ = this;
var this__19076__auto____$1 = this;
return (new full.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__21434,self__.__extmap,self__.__hash));
});

full.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__19082__auto__,entry__19083__auto__){
var self__ = this;
var this__19082__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__19083__auto__)){
return cljs.core._assoc.call(null,this__19082__auto____$1,cljs.core._nth.call(null,entry__19083__auto__,(0)),cljs.core._nth.call(null,entry__19083__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__19082__auto____$1,entry__19083__auto__);
}
});

full.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

full.async.TrackingSupervisor.cljs$lang$type = true;

full.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__19111__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"full.async/TrackingSupervisor");
});

full.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__19111__auto__,writer__19112__auto__){
return cljs.core._write.call(null,writer__19112__auto__,"full.async/TrackingSupervisor");
});

full.async.__GT_TrackingSupervisor = (function full$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new full.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

full.async.map__GT_TrackingSupervisor = (function full$async$map__GT_TrackingSupervisor(G__21436){
return (new full.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__21436),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__21436),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__21436),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__21436),null,cljs.core.dissoc.call(null,G__21436,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
full.async._STAR_super_STAR_ = (function (){var s = cljs.core.assoc.call(null,full.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null)),new cljs.core.Keyword(null,"global?","global?",-2022837689),true);
var stale_timeout = ((10) * (1000));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,stale_timeout,err_ch){
return (function full$async$loop_fn(e){
cljs.core.println.call(null,"Global Supervisor:",e);

return cljs.core.async.take_BANG_.call(null,err_ch,full$async$loop_fn);
});})(s,stale_timeout,err_ch))
);

((function (s,stale_timeout,err_ch){
return (function full$async$pending(_){
var vec__21446 = cljs.core.filter.call(null,((function (s,stale_timeout,err_ch){
return (function (p__21448){
var vec__21449 = p__21448;
var k = cljs.core.nth.call(null,vec__21449,(0),null);
var v = cljs.core.nth.call(null,vec__21449,(1),null);
return ((full.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,stale_timeout,err_ch))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__21447 = cljs.core.nth.call(null,vec__21446,(0),null);
var e = cljs.core.nth.call(null,vec__21447,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__21447,(1),null);
if(cljs.core.truth_(e)){
cljs.core.println.call(null,"Global Supervisor detected stale error:",e,e.stack);

full.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),full$async$pending);
});})(s,stale_timeout,err_ch))
.call(null,null);

return s;
})();
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
full.async.throw_if_exception = (function full$async$throw_if_exception(x){
if((x instanceof Error)){
full.async._free_exception.call(null,full.async._STAR_super_STAR_,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__18455__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__18455__auto__)){
return or__18455__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.take_QMARK_ = (function full$async$take_QMARK_(var_args){
var args21468 = [];
var len__19524__auto___21471 = arguments.length;
var i__19525__auto___21472 = (0);
while(true){
if((i__19525__auto___21472 < len__19524__auto___21471)){
args21468.push((arguments[i__19525__auto___21472]));

var G__21473 = (i__19525__auto___21472 + (1));
i__19525__auto___21472 = G__21473;
continue;
} else {
}
break;
}

var G__21470 = args21468.length;
switch (G__21470) {
case 2:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21468.length)].join('')));

}
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return full.async.take_QMARK_.call(null,port,fn1,true);
});

full.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var super$ = full.async._STAR_super_STAR_;
return cljs.core.async.take_BANG_.call(null,port,((function (super$){
return (function (v){
if((v instanceof Error)){
full.async._free_exception.call(null,super$,v);
} else {
}

return fn1.call(null,v);
});})(super$))
,on_caller_QMARK_);
});

full.async.take_QMARK_.cljs$lang$maxFixedArity = 3;
/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
full.async.put_QMARK_ = (function full$async$put_QMARK_(var_args){
var args21475 = [];
var len__19524__auto___21478 = arguments.length;
var i__19525__auto___21479 = (0);
while(true){
if((i__19525__auto___21479 < len__19524__auto___21478)){
args21475.push((arguments[i__19525__auto___21479]));

var G__21480 = (i__19525__auto___21479 + (1));
i__19525__auto___21479 = G__21480;
continue;
} else {
}
break;
}

var G__21477 = args21475.length;
switch (G__21477) {
case 2:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21475.length)].join('')));

}
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
return full.async.put_QMARK_.call(null,port,val,(function full$async$noop(_){
return null;
}));
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return full.async.put_QMARK_.call(null,port,val,fn1,true);
});

full.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
full.async._track_exception.call(null,full.async._STAR_super_STAR_,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

full.async.put_QMARK_.cljs$lang$maxFixedArity = 4;
/**
 * Same as core.async alts! but throws an exception if the channel returns a
 *   throwable object or the context has been aborted.
 */
full.async.alts_QMARK_ = (function full$async$alts_QMARK_(var_args){
var args__19531__auto__ = [];
var len__19524__auto___21486 = arguments.length;
var i__19525__auto___21487 = (0);
while(true){
if((i__19525__auto___21487 < len__19524__auto___21486)){
args__19531__auto__.push((arguments[i__19525__auto___21487]));

var G__21488 = (i__19525__auto___21487 + (1));
i__19525__auto___21487 = G__21488;
continue;
} else {
}
break;
}

var argseq__19532__auto__ = ((((1) < args__19531__auto__.length))?(new cljs.core.IndexedSeq(args__19531__auto__.slice((1)),(0),null)):null);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19532__auto__);
});

full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,opts){
var abort__20712__auto__ = full.async._abort.call(null,full.async._STAR_super_STAR_);
var to__20713__auto__ = cljs.core.async.timeout.call(null,(0));
var vec__21484 = cljs.core.async.alts_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [abort__20712__auto__,to__20713__auto__], null),new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var val__20714__auto__ = cljs.core.nth.call(null,vec__21484,(0),null);
var port__20715__auto__ = cljs.core.nth.call(null,vec__21484,(1),null);
if(cljs.core._EQ_.call(null,port__20715__auto__,abort__20712__auto__)){
return cljs.core.ex_info.call(null,"Aborted operations",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"aborted","aborted",1775972619)], null));
} else {
var vec__21485 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var val = cljs.core.nth.call(null,vec__21485,(0),null);
var port = cljs.core.nth.call(null,vec__21485,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [full.async.throw_if_exception.call(null,val),port], null);
}
});

full.async.alts_QMARK_.cljs$lang$maxFixedArity = (1);

full.async.alts_QMARK_.cljs$lang$applyTo = (function (seq21482){
var G__21483 = cljs.core.first.call(null,seq21482);
var seq21482__$1 = cljs.core.next.call(null,seq21482);
return full.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__21483,seq21482__$1);
});
/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
full.async.pmap_GT__GT_ = (function full$async$pmap_GT__GT_(var_args){
var args21497 = [];
var len__19524__auto___21619 = arguments.length;
var i__19525__auto___21620 = (0);
while(true){
if((i__19525__auto___21620 < len__19524__auto___21619)){
args21497.push((arguments[i__19525__auto___21620]));

var G__21621 = (i__19525__auto___21620 + (1));
i__19525__auto___21620 = G__21621;
continue;
} else {
}
break;
}

var G__21499 = args21497.length;
switch (G__21499) {
case 3:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21497.length)].join('')));

}
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$3 = (function (f_GT_,parallelism,in_ch){
return full.async.pmap_GT__GT_.call(null,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

full.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__19369__auto___21623 = parallelism;
var __21624 = (0);
while(true){
if((__21624 < n__19369__auto___21623)){
var c__20479__auto___21625 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__21624,c__20479__auto___21625,n__19369__auto___21623,threads){
return (function (){
var f__20480__auto__ = (function (){var switch__20458__auto__ = ((function (__21624,c__20479__auto___21625,n__19369__auto___21623,threads){
return (function (state_21575){
var state_val_21576 = (state_21575[(1)]);
if((state_val_21576 === (7))){
var inst_21564 = (state_21575[(2)]);
var state_21575__$1 = state_21575;
var statearr_21577_21626 = state_21575__$1;
(statearr_21577_21626[(2)] = inst_21564);

(statearr_21577_21626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (20))){
var inst_21535 = (state_21575[(7)]);
var inst_21541 = (state_21575[(2)]);
var inst_21542 = cljs.core.nth.call(null,inst_21541,(0),null);
var inst_21543 = cljs.core.nth.call(null,inst_21541,(1),null);
var inst_21544 = cljs.core._EQ_.call(null,inst_21543,inst_21535);
var state_21575__$1 = (function (){var statearr_21578 = state_21575;
(statearr_21578[(8)] = inst_21542);

return statearr_21578;
})();
if(inst_21544){
var statearr_21579_21627 = state_21575__$1;
(statearr_21579_21627[(1)] = (21));

} else {
var statearr_21580_21628 = state_21575__$1;
(statearr_21580_21628[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (27))){
var inst_21573 = (state_21575[(2)]);
var state_21575__$1 = state_21575;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21575__$1,inst_21573);
} else {
if((state_val_21576 === (1))){
var state_21575__$1 = state_21575;
var statearr_21581_21629 = state_21575__$1;
(statearr_21581_21629[(2)] = null);

(statearr_21581_21629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (24))){
var inst_21552 = (state_21575[(2)]);
var state_21575__$1 = state_21575;
var statearr_21582_21630 = state_21575__$1;
(statearr_21582_21630[(2)] = inst_21552);

(statearr_21582_21630[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (4))){
var inst_21502 = (state_21575[(9)]);
var inst_21502__$1 = (state_21575[(2)]);
var state_21575__$1 = (function (){var statearr_21583 = state_21575;
(statearr_21583[(9)] = inst_21502__$1);

return statearr_21583;
})();
if(cljs.core.truth_(inst_21502__$1)){
var statearr_21584_21631 = state_21575__$1;
(statearr_21584_21631[(1)] = (5));

} else {
var statearr_21585_21632 = state_21575__$1;
(statearr_21585_21632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (15))){
var inst_21524 = (state_21575[(2)]);
var state_21575__$1 = state_21575;
var statearr_21586_21633 = state_21575__$1;
(statearr_21586_21633[(2)] = inst_21524);

(statearr_21586_21633[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (21))){
var inst_21546 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_21547 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_21548 = cljs.core.PersistentHashMap.fromArrays(inst_21546,inst_21547);
var inst_21549 = cljs.core.ex_info.call(null,"Aborted operations",inst_21548);
var state_21575__$1 = state_21575;
var statearr_21587_21634 = state_21575__$1;
(statearr_21587_21634[(2)] = inst_21549);

(statearr_21587_21634[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (13))){
var inst_21502 = (state_21575[(9)]);
var state_21575__$1 = state_21575;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21575__$1,(15),out_ch,inst_21502);
} else {
if((state_val_21576 === (22))){
var inst_21532 = (state_21575[(10)]);
var state_21575__$1 = state_21575;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21575__$1,(24),out_ch,inst_21532);
} else {
if((state_val_21576 === (6))){
var state_21575__$1 = state_21575;
var statearr_21588_21635 = state_21575__$1;
(statearr_21588_21635[(2)] = null);

(statearr_21588_21635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (25))){
var inst_21570 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_21575__$1 = state_21575;
var statearr_21589_21636 = state_21575__$1;
(statearr_21589_21636[(2)] = inst_21570);

(statearr_21589_21636[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (17))){
var inst_21535 = (state_21575[(7)]);
var inst_21535__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_21536 = cljs.core.async.timeout.call(null,(0));
var inst_21537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21538 = [inst_21535__$1,inst_21536];
var inst_21539 = (new cljs.core.PersistentVector(null,2,(5),inst_21537,inst_21538,null));
var state_21575__$1 = (function (){var statearr_21590 = state_21575;
(statearr_21590[(7)] = inst_21535__$1);

return statearr_21590;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_21575__$1,(20),inst_21539,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_21576 === (3))){
var inst_21566 = (state_21575[(2)]);
var inst_21567 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_21568 = (inst_21567 === (0));
var state_21575__$1 = (function (){var statearr_21591 = state_21575;
(statearr_21591[(11)] = inst_21566);

return statearr_21591;
})();
if(cljs.core.truth_(inst_21568)){
var statearr_21592_21637 = state_21575__$1;
(statearr_21592_21637[(1)] = (25));

} else {
var statearr_21593_21638 = state_21575__$1;
(statearr_21593_21638[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (12))){
var inst_21518 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_21519 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_21520 = cljs.core.PersistentHashMap.fromArrays(inst_21518,inst_21519);
var inst_21521 = cljs.core.ex_info.call(null,"Aborted operations",inst_21520);
var state_21575__$1 = state_21575;
var statearr_21594_21639 = state_21575__$1;
(statearr_21594_21639[(2)] = inst_21521);

(statearr_21594_21639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (2))){
var state_21575__$1 = state_21575;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21575__$1,(4),in_ch);
} else {
if((state_val_21576 === (23))){
var inst_21554 = (state_21575[(2)]);
var inst_21555 = full.async.throw_if_exception.call(null,inst_21554);
var state_21575__$1 = state_21575;
var statearr_21595_21640 = state_21575__$1;
(statearr_21595_21640[(2)] = inst_21555);

(statearr_21595_21640[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (19))){
var inst_21558 = (state_21575[(2)]);
var state_21575__$1 = (function (){var statearr_21596 = state_21575;
(statearr_21596[(12)] = inst_21558);

return statearr_21596;
})();
var statearr_21597_21641 = state_21575__$1;
(statearr_21597_21641[(2)] = null);

(statearr_21597_21641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (11))){
var inst_21507 = (state_21575[(13)]);
var inst_21513 = (state_21575[(2)]);
var inst_21514 = cljs.core.nth.call(null,inst_21513,(0),null);
var inst_21515 = cljs.core.nth.call(null,inst_21513,(1),null);
var inst_21516 = cljs.core._EQ_.call(null,inst_21515,inst_21507);
var state_21575__$1 = (function (){var statearr_21598 = state_21575;
(statearr_21598[(14)] = inst_21514);

return statearr_21598;
})();
if(inst_21516){
var statearr_21599_21642 = state_21575__$1;
(statearr_21599_21642[(1)] = (12));

} else {
var statearr_21600_21643 = state_21575__$1;
(statearr_21600_21643[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (9))){
var inst_21502 = (state_21575[(9)]);
var inst_21530 = f_GT_.call(null,inst_21502);
var state_21575__$1 = state_21575;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21575__$1,(16),inst_21530);
} else {
if((state_val_21576 === (5))){
var inst_21502 = (state_21575[(9)]);
var inst_21504 = (inst_21502 instanceof Error);
var state_21575__$1 = state_21575;
if(cljs.core.truth_(inst_21504)){
var statearr_21601_21644 = state_21575__$1;
(statearr_21601_21644[(1)] = (8));

} else {
var statearr_21602_21645 = state_21575__$1;
(statearr_21602_21645[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (14))){
var inst_21526 = (state_21575[(2)]);
var inst_21527 = full.async.throw_if_exception.call(null,inst_21526);
var inst_21528 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_21575__$1 = (function (){var statearr_21603 = state_21575;
(statearr_21603[(15)] = inst_21527);

return statearr_21603;
})();
var statearr_21604_21646 = state_21575__$1;
(statearr_21604_21646[(2)] = inst_21528);

(statearr_21604_21646[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (26))){
var state_21575__$1 = state_21575;
var statearr_21605_21647 = state_21575__$1;
(statearr_21605_21647[(2)] = null);

(statearr_21605_21647[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (16))){
var inst_21532 = (state_21575[(10)]);
var inst_21532__$1 = (state_21575[(2)]);
var state_21575__$1 = (function (){var statearr_21606 = state_21575;
(statearr_21606[(10)] = inst_21532__$1);

return statearr_21606;
})();
if(cljs.core.truth_(inst_21532__$1)){
var statearr_21607_21648 = state_21575__$1;
(statearr_21607_21648[(1)] = (17));

} else {
var statearr_21608_21649 = state_21575__$1;
(statearr_21608_21649[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (10))){
var inst_21561 = (state_21575[(2)]);
var state_21575__$1 = state_21575;
var statearr_21609_21650 = state_21575__$1;
(statearr_21609_21650[(2)] = inst_21561);

(statearr_21609_21650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (18))){
var state_21575__$1 = state_21575;
var statearr_21610_21651 = state_21575__$1;
(statearr_21610_21651[(2)] = null);

(statearr_21610_21651[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21576 === (8))){
var inst_21507 = (state_21575[(13)]);
var inst_21507__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_21508 = cljs.core.async.timeout.call(null,(0));
var inst_21509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21510 = [inst_21507__$1,inst_21508];
var inst_21511 = (new cljs.core.PersistentVector(null,2,(5),inst_21509,inst_21510,null));
var state_21575__$1 = (function (){var statearr_21611 = state_21575;
(statearr_21611[(13)] = inst_21507__$1);

return statearr_21611;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_21575__$1,(11),inst_21511,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__21624,c__20479__auto___21625,n__19369__auto___21623,threads))
;
return ((function (__21624,switch__20458__auto__,c__20479__auto___21625,n__19369__auto___21623,threads){
return (function() {
var full$async$state_machine__20459__auto__ = null;
var full$async$state_machine__20459__auto____0 = (function (){
var statearr_21615 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21615[(0)] = full$async$state_machine__20459__auto__);

(statearr_21615[(1)] = (1));

return statearr_21615;
});
var full$async$state_machine__20459__auto____1 = (function (state_21575){
while(true){
var ret_value__20460__auto__ = (function (){try{while(true){
var result__20461__auto__ = switch__20458__auto__.call(null,state_21575);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20461__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20461__auto__;
}
break;
}
}catch (e21616){if((e21616 instanceof Object)){
var ex__20462__auto__ = e21616;
var statearr_21617_21652 = state_21575;
(statearr_21617_21652[(5)] = ex__20462__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21575);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21616;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21653 = state_21575;
state_21575 = G__21653;
continue;
} else {
return ret_value__20460__auto__;
}
break;
}
});
full$async$state_machine__20459__auto__ = function(state_21575){
switch(arguments.length){
case 0:
return full$async$state_machine__20459__auto____0.call(this);
case 1:
return full$async$state_machine__20459__auto____1.call(this,state_21575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20459__auto____0;
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20459__auto____1;
return full$async$state_machine__20459__auto__;
})()
;})(__21624,switch__20458__auto__,c__20479__auto___21625,n__19369__auto___21623,threads))
})();
var state__20481__auto__ = (function (){var statearr_21618 = f__20480__auto__.call(null);
(statearr_21618[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20479__auto___21625);

return statearr_21618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20481__auto__);
});})(__21624,c__20479__auto___21625,n__19369__auto___21623,threads))
);


var G__21654 = (__21624 + (1));
__21624 = G__21654;
continue;
} else {
}
break;
}

return out_ch;
});

full.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 4;
/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
full.async.engulf = (function full$async$engulf(var_args){
var args__19531__auto__ = [];
var len__19524__auto___21682 = arguments.length;
var i__19525__auto___21683 = (0);
while(true){
if((i__19525__auto___21683 < len__19524__auto___21682)){
args__19531__auto__.push((arguments[i__19525__auto___21683]));

var G__21684 = (i__19525__auto___21683 + (1));
i__19525__auto___21683 = G__21684;
continue;
} else {
}
break;
}

var argseq__19532__auto__ = ((((0) < args__19531__auto__.length))?(new cljs.core.IndexedSeq(args__19531__auto__.slice((0)),(0),null)):null);
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(argseq__19532__auto__);
});

full.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__20479__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20479__auto__,ch){
return (function (){
var f__20480__auto__ = (function (){var switch__20458__auto__ = ((function (c__20479__auto__,ch){
return (function (state_21667){
var state_val_21668 = (state_21667[(1)]);
if((state_val_21668 === (1))){
var state_21667__$1 = state_21667;
var statearr_21669_21685 = state_21667__$1;
(statearr_21669_21685[(2)] = null);

(statearr_21669_21685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21668 === (2))){
var state_21667__$1 = state_21667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21667__$1,(4),ch);
} else {
if((state_val_21668 === (3))){
var inst_21665 = (state_21667[(2)]);
var state_21667__$1 = state_21667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21667__$1,inst_21665);
} else {
if((state_val_21668 === (4))){
var inst_21658 = (state_21667[(2)]);
var state_21667__$1 = state_21667;
if(cljs.core.truth_(inst_21658)){
var statearr_21670_21686 = state_21667__$1;
(statearr_21670_21686[(1)] = (5));

} else {
var statearr_21671_21687 = state_21667__$1;
(statearr_21671_21687[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21668 === (5))){
var state_21667__$1 = state_21667;
var statearr_21672_21688 = state_21667__$1;
(statearr_21672_21688[(2)] = null);

(statearr_21672_21688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21668 === (6))){
var state_21667__$1 = state_21667;
var statearr_21673_21689 = state_21667__$1;
(statearr_21673_21689[(2)] = null);

(statearr_21673_21689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21668 === (7))){
var inst_21663 = (state_21667[(2)]);
var state_21667__$1 = state_21667;
var statearr_21674_21690 = state_21667__$1;
(statearr_21674_21690[(2)] = inst_21663);

(statearr_21674_21690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20479__auto__,ch))
;
return ((function (switch__20458__auto__,c__20479__auto__,ch){
return (function() {
var full$async$state_machine__20459__auto__ = null;
var full$async$state_machine__20459__auto____0 = (function (){
var statearr_21678 = [null,null,null,null,null,null,null];
(statearr_21678[(0)] = full$async$state_machine__20459__auto__);

(statearr_21678[(1)] = (1));

return statearr_21678;
});
var full$async$state_machine__20459__auto____1 = (function (state_21667){
while(true){
var ret_value__20460__auto__ = (function (){try{while(true){
var result__20461__auto__ = switch__20458__auto__.call(null,state_21667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20461__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20461__auto__;
}
break;
}
}catch (e21679){if((e21679 instanceof Object)){
var ex__20462__auto__ = e21679;
var statearr_21680_21691 = state_21667;
(statearr_21680_21691[(5)] = ex__20462__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21667);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21692 = state_21667;
state_21667 = G__21692;
continue;
} else {
return ret_value__20460__auto__;
}
break;
}
});
full$async$state_machine__20459__auto__ = function(state_21667){
switch(arguments.length){
case 0:
return full$async$state_machine__20459__auto____0.call(this);
case 1:
return full$async$state_machine__20459__auto____1.call(this,state_21667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20459__auto____0;
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20459__auto____1;
return full$async$state_machine__20459__auto__;
})()
;})(switch__20458__auto__,c__20479__auto__,ch))
})();
var state__20481__auto__ = (function (){var statearr_21681 = f__20480__auto__.call(null);
(statearr_21681[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20479__auto__);

return statearr_21681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20481__auto__);
});})(c__20479__auto__,ch))
);

return c__20479__auto__;
});

full.async.engulf.cljs$lang$maxFixedArity = (0);

full.async.engulf.cljs$lang$applyTo = (function (seq21655){
return full.async.engulf.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq21655));
});
/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
full.async.reduce_GT_ = (function full$async$reduce_GT_(f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__20479__auto___21897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20479__auto___21897,result){
return (function (){
var f__20480__auto__ = (function (){var switch__20458__auto__ = ((function (c__20479__auto___21897,result){
return (function (state_21861){
var state_val_21862 = (state_21861[(1)]);
if((state_val_21862 === (7))){
var inst_21857 = (state_21861[(2)]);
var state_21861__$1 = state_21861;
var statearr_21863_21898 = state_21861__$1;
(statearr_21863_21898[(2)] = inst_21857);

(statearr_21863_21898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (20))){
var inst_21853 = (state_21861[(2)]);
var inst_21854 = full.async.throw_if_exception.call(null,inst_21853);
var inst_21855 = cljs.core.async.close_BANG_.call(null,result);
var state_21861__$1 = (function (){var statearr_21864 = state_21861;
(statearr_21864[(7)] = inst_21854);

return statearr_21864;
})();
var statearr_21865_21899 = state_21861__$1;
(statearr_21865_21899[(2)] = inst_21855);

(statearr_21865_21899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (1))){
var inst_21795 = acc;
var state_21861__$1 = (function (){var statearr_21866 = state_21861;
(statearr_21866[(8)] = inst_21795);

return statearr_21866;
})();
var statearr_21867_21900 = state_21861__$1;
(statearr_21867_21900[(2)] = null);

(statearr_21867_21900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (4))){
var inst_21798 = (state_21861[(9)]);
var inst_21798__$1 = (state_21861[(2)]);
var state_21861__$1 = (function (){var statearr_21868 = state_21861;
(statearr_21868[(9)] = inst_21798__$1);

return statearr_21868;
})();
if(cljs.core.truth_(inst_21798__$1)){
var statearr_21869_21901 = state_21861__$1;
(statearr_21869_21901[(1)] = (5));

} else {
var statearr_21870_21902 = state_21861__$1;
(statearr_21870_21902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (15))){
var inst_21820 = (state_21861[(2)]);
var state_21861__$1 = state_21861;
var statearr_21871_21903 = state_21861__$1;
(statearr_21871_21903[(2)] = inst_21820);

(statearr_21871_21903[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (21))){
var inst_21851 = (state_21861[(2)]);
var state_21861__$1 = state_21861;
var statearr_21872_21904 = state_21861__$1;
(statearr_21872_21904[(2)] = inst_21851);

(statearr_21872_21904[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (13))){
var inst_21798 = (state_21861[(9)]);
var state_21861__$1 = state_21861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21861__$1,(15),result,inst_21798);
} else {
if((state_val_21862 === (6))){
var inst_21834 = (state_21861[(10)]);
var inst_21834__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_21835 = cljs.core.async.timeout.call(null,(0));
var inst_21836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21837 = [inst_21834__$1,inst_21835];
var inst_21838 = (new cljs.core.PersistentVector(null,2,(5),inst_21836,inst_21837,null));
var state_21861__$1 = (function (){var statearr_21873 = state_21861;
(statearr_21873[(10)] = inst_21834__$1);

return statearr_21873;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_21861__$1,(17),inst_21838,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_21862 === (17))){
var inst_21834 = (state_21861[(10)]);
var inst_21840 = (state_21861[(2)]);
var inst_21841 = cljs.core.nth.call(null,inst_21840,(0),null);
var inst_21842 = cljs.core.nth.call(null,inst_21840,(1),null);
var inst_21843 = cljs.core._EQ_.call(null,inst_21842,inst_21834);
var state_21861__$1 = (function (){var statearr_21874 = state_21861;
(statearr_21874[(11)] = inst_21841);

return statearr_21874;
})();
if(inst_21843){
var statearr_21875_21905 = state_21861__$1;
(statearr_21875_21905[(1)] = (18));

} else {
var statearr_21876_21906 = state_21861__$1;
(statearr_21876_21906[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (3))){
var inst_21859 = (state_21861[(2)]);
var state_21861__$1 = state_21861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21861__$1,inst_21859);
} else {
if((state_val_21862 === (12))){
var inst_21814 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_21815 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_21816 = cljs.core.PersistentHashMap.fromArrays(inst_21814,inst_21815);
var inst_21817 = cljs.core.ex_info.call(null,"Aborted operations",inst_21816);
var state_21861__$1 = state_21861;
var statearr_21877_21907 = state_21861__$1;
(statearr_21877_21907[(2)] = inst_21817);

(statearr_21877_21907[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (2))){
var state_21861__$1 = state_21861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21861__$1,(4),ch);
} else {
if((state_val_21862 === (19))){
var inst_21795 = (state_21861[(8)]);
var state_21861__$1 = state_21861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21861__$1,(21),result,inst_21795);
} else {
if((state_val_21862 === (11))){
var inst_21803 = (state_21861[(12)]);
var inst_21809 = (state_21861[(2)]);
var inst_21810 = cljs.core.nth.call(null,inst_21809,(0),null);
var inst_21811 = cljs.core.nth.call(null,inst_21809,(1),null);
var inst_21812 = cljs.core._EQ_.call(null,inst_21811,inst_21803);
var state_21861__$1 = (function (){var statearr_21878 = state_21861;
(statearr_21878[(13)] = inst_21810);

return statearr_21878;
})();
if(inst_21812){
var statearr_21879_21908 = state_21861__$1;
(statearr_21879_21908[(1)] = (12));

} else {
var statearr_21880_21909 = state_21861__$1;
(statearr_21880_21909[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (9))){
var inst_21795 = (state_21861[(8)]);
var inst_21798 = (state_21861[(9)]);
var inst_21826 = f_GT_.call(null,inst_21795,inst_21798);
var state_21861__$1 = state_21861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21861__$1,(16),inst_21826);
} else {
if((state_val_21862 === (5))){
var inst_21798 = (state_21861[(9)]);
var inst_21800 = (inst_21798 instanceof Error);
var state_21861__$1 = state_21861;
if(cljs.core.truth_(inst_21800)){
var statearr_21881_21910 = state_21861__$1;
(statearr_21881_21910[(1)] = (8));

} else {
var statearr_21882_21911 = state_21861__$1;
(statearr_21882_21911[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (14))){
var inst_21822 = (state_21861[(2)]);
var inst_21823 = full.async.throw_if_exception.call(null,inst_21822);
var inst_21824 = cljs.core.async.close_BANG_.call(null,result);
var state_21861__$1 = (function (){var statearr_21883 = state_21861;
(statearr_21883[(14)] = inst_21823);

return statearr_21883;
})();
var statearr_21884_21912 = state_21861__$1;
(statearr_21884_21912[(2)] = inst_21824);

(statearr_21884_21912[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (16))){
var inst_21828 = (state_21861[(2)]);
var inst_21795 = inst_21828;
var state_21861__$1 = (function (){var statearr_21885 = state_21861;
(statearr_21885[(8)] = inst_21795);

return statearr_21885;
})();
var statearr_21886_21913 = state_21861__$1;
(statearr_21886_21913[(2)] = null);

(statearr_21886_21913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (10))){
var inst_21831 = (state_21861[(2)]);
var state_21861__$1 = state_21861;
var statearr_21887_21914 = state_21861__$1;
(statearr_21887_21914[(2)] = inst_21831);

(statearr_21887_21914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (18))){
var inst_21845 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_21846 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_21847 = cljs.core.PersistentHashMap.fromArrays(inst_21845,inst_21846);
var inst_21848 = cljs.core.ex_info.call(null,"Aborted operations",inst_21847);
var state_21861__$1 = state_21861;
var statearr_21888_21915 = state_21861__$1;
(statearr_21888_21915[(2)] = inst_21848);

(statearr_21888_21915[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21862 === (8))){
var inst_21803 = (state_21861[(12)]);
var inst_21803__$1 = full.async._abort.call(null,full.async._STAR_super_STAR_);
var inst_21804 = cljs.core.async.timeout.call(null,(0));
var inst_21805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21806 = [inst_21803__$1,inst_21804];
var inst_21807 = (new cljs.core.PersistentVector(null,2,(5),inst_21805,inst_21806,null));
var state_21861__$1 = (function (){var statearr_21889 = state_21861;
(statearr_21889[(12)] = inst_21803__$1);

return statearr_21889;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_21861__$1,(11),inst_21807,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20479__auto___21897,result))
;
return ((function (switch__20458__auto__,c__20479__auto___21897,result){
return (function() {
var full$async$reduce_GT__$_state_machine__20459__auto__ = null;
var full$async$reduce_GT__$_state_machine__20459__auto____0 = (function (){
var statearr_21893 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21893[(0)] = full$async$reduce_GT__$_state_machine__20459__auto__);

(statearr_21893[(1)] = (1));

return statearr_21893;
});
var full$async$reduce_GT__$_state_machine__20459__auto____1 = (function (state_21861){
while(true){
var ret_value__20460__auto__ = (function (){try{while(true){
var result__20461__auto__ = switch__20458__auto__.call(null,state_21861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20461__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20461__auto__;
}
break;
}
}catch (e21894){if((e21894 instanceof Object)){
var ex__20462__auto__ = e21894;
var statearr_21895_21916 = state_21861;
(statearr_21895_21916[(5)] = ex__20462__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21894;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21917 = state_21861;
state_21861 = G__21917;
continue;
} else {
return ret_value__20460__auto__;
}
break;
}
});
full$async$reduce_GT__$_state_machine__20459__auto__ = function(state_21861){
switch(arguments.length){
case 0:
return full$async$reduce_GT__$_state_machine__20459__auto____0.call(this);
case 1:
return full$async$reduce_GT__$_state_machine__20459__auto____1.call(this,state_21861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$reduce_GT__$_state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$reduce_GT__$_state_machine__20459__auto____0;
full$async$reduce_GT__$_state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$reduce_GT__$_state_machine__20459__auto____1;
return full$async$reduce_GT__$_state_machine__20459__auto__;
})()
;})(switch__20458__auto__,c__20479__auto___21897,result))
})();
var state__20481__auto__ = (function (){var statearr_21896 = f__20480__auto__.call(null);
(statearr_21896[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20479__auto___21897);

return statearr_21896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20481__auto__);
});})(c__20479__auto___21897,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
full.async.concat_GT__GT_ = (function full$async$concat_GT__GT_(var_args){
var args__19531__auto__ = [];
var len__19524__auto___21966 = arguments.length;
var i__19525__auto___21967 = (0);
while(true){
if((i__19525__auto___21967 < len__19524__auto___21966)){
args__19531__auto__.push((arguments[i__19525__auto___21967]));

var G__21968 = (i__19525__auto___21967 + (1));
i__19525__auto___21967 = G__21968;
continue;
} else {
}
break;
}

var argseq__19532__auto__ = ((((0) < args__19531__auto__.length))?(new cljs.core.IndexedSeq(args__19531__auto__.slice((0)),(0),null)):null);
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__19532__auto__);
});

full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (cs){
var out = cljs.core.async.chan.call(null);
var c__20479__auto___21969 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20479__auto___21969,out){
return (function (){
var f__20480__auto__ = (function (){var switch__20458__auto__ = ((function (c__20479__auto___21969,out){
return (function (state_21941){
var state_val_21942 = (state_21941[(1)]);
if((state_val_21942 === (7))){
var inst_21924 = (state_21941[(7)]);
var inst_21924__$1 = (state_21941[(2)]);
var state_21941__$1 = (function (){var statearr_21943 = state_21941;
(statearr_21943[(7)] = inst_21924__$1);

return statearr_21943;
})();
if(cljs.core.truth_(inst_21924__$1)){
var statearr_21944_21970 = state_21941__$1;
(statearr_21944_21970[(1)] = (8));

} else {
var statearr_21945_21971 = state_21941__$1;
(statearr_21945_21971[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (1))){
var inst_21919 = cs;
var state_21941__$1 = (function (){var statearr_21946 = state_21941;
(statearr_21946[(8)] = inst_21919);

return statearr_21946;
})();
var statearr_21947_21972 = state_21941__$1;
(statearr_21947_21972[(2)] = null);

(statearr_21947_21972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (4))){
var inst_21921 = (state_21941[(9)]);
var state_21941__$1 = state_21941;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21941__$1,(7),inst_21921);
} else {
if((state_val_21942 === (6))){
var inst_21937 = (state_21941[(2)]);
var state_21941__$1 = state_21941;
var statearr_21948_21973 = state_21941__$1;
(statearr_21948_21973[(2)] = inst_21937);

(statearr_21948_21973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (3))){
var inst_21939 = (state_21941[(2)]);
var state_21941__$1 = state_21941;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21941__$1,inst_21939);
} else {
if((state_val_21942 === (2))){
var inst_21921 = (state_21941[(9)]);
var inst_21919 = (state_21941[(8)]);
var inst_21921__$1 = cljs.core.first.call(null,inst_21919);
var state_21941__$1 = (function (){var statearr_21950 = state_21941;
(statearr_21950[(9)] = inst_21921__$1);

return statearr_21950;
})();
if(cljs.core.truth_(inst_21921__$1)){
var statearr_21951_21974 = state_21941__$1;
(statearr_21951_21974[(1)] = (4));

} else {
var statearr_21952_21975 = state_21941__$1;
(statearr_21952_21975[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (11))){
var inst_21919 = (state_21941[(8)]);
var inst_21927 = (state_21941[(2)]);
var tmp21949 = inst_21919;
var inst_21919__$1 = tmp21949;
var state_21941__$1 = (function (){var statearr_21953 = state_21941;
(statearr_21953[(10)] = inst_21927);

(statearr_21953[(8)] = inst_21919__$1);

return statearr_21953;
})();
var statearr_21954_21976 = state_21941__$1;
(statearr_21954_21976[(2)] = null);

(statearr_21954_21976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (9))){
var inst_21919 = (state_21941[(8)]);
var inst_21930 = cljs.core.rest.call(null,inst_21919);
var inst_21919__$1 = inst_21930;
var state_21941__$1 = (function (){var statearr_21955 = state_21941;
(statearr_21955[(8)] = inst_21919__$1);

return statearr_21955;
})();
var statearr_21956_21977 = state_21941__$1;
(statearr_21956_21977[(2)] = null);

(statearr_21956_21977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (5))){
var inst_21935 = cljs.core.async.close_BANG_.call(null,out);
var state_21941__$1 = state_21941;
var statearr_21957_21978 = state_21941__$1;
(statearr_21957_21978[(2)] = inst_21935);

(statearr_21957_21978[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (10))){
var inst_21933 = (state_21941[(2)]);
var state_21941__$1 = state_21941;
var statearr_21958_21979 = state_21941__$1;
(statearr_21958_21979[(2)] = inst_21933);

(statearr_21958_21979[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21942 === (8))){
var inst_21924 = (state_21941[(7)]);
var state_21941__$1 = state_21941;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21941__$1,(11),out,inst_21924);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20479__auto___21969,out))
;
return ((function (switch__20458__auto__,c__20479__auto___21969,out){
return (function() {
var full$async$state_machine__20459__auto__ = null;
var full$async$state_machine__20459__auto____0 = (function (){
var statearr_21962 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21962[(0)] = full$async$state_machine__20459__auto__);

(statearr_21962[(1)] = (1));

return statearr_21962;
});
var full$async$state_machine__20459__auto____1 = (function (state_21941){
while(true){
var ret_value__20460__auto__ = (function (){try{while(true){
var result__20461__auto__ = switch__20458__auto__.call(null,state_21941);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20461__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20461__auto__;
}
break;
}
}catch (e21963){if((e21963 instanceof Object)){
var ex__20462__auto__ = e21963;
var statearr_21964_21980 = state_21941;
(statearr_21964_21980[(5)] = ex__20462__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21941);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21963;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21981 = state_21941;
state_21941 = G__21981;
continue;
} else {
return ret_value__20460__auto__;
}
break;
}
});
full$async$state_machine__20459__auto__ = function(state_21941){
switch(arguments.length){
case 0:
return full$async$state_machine__20459__auto____0.call(this);
case 1:
return full$async$state_machine__20459__auto____1.call(this,state_21941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20459__auto____0;
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20459__auto____1;
return full$async$state_machine__20459__auto__;
})()
;})(switch__20458__auto__,c__20479__auto___21969,out))
})();
var state__20481__auto__ = (function (){var statearr_21965 = f__20480__auto__.call(null);
(statearr_21965[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20479__auto___21969);

return statearr_21965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20481__auto__);
});})(c__20479__auto___21969,out))
);


return out;
});

full.async.concat_GT__GT_.cljs$lang$maxFixedArity = (0);

full.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq21918){
return full.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq21918));
});
full.async.partition_all_GT__GT_ = (function full$async$partition_all_GT__GT_(var_args){
var args__19531__auto__ = [];
var len__19524__auto___22062 = arguments.length;
var i__19525__auto___22063 = (0);
while(true){
if((i__19525__auto___22063 < len__19524__auto___22062)){
args__19531__auto__.push((arguments[i__19525__auto___22063]));

var G__22064 = (i__19525__auto___22063 + (1));
i__19525__auto___22063 = G__22064;
continue;
} else {
}
break;
}

var argseq__19532__auto__ = ((((2) < args__19531__auto__.length))?(new cljs.core.IndexedSeq(args__19531__auto__.slice((2)),(0),null)):null);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19532__auto__);
});

full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (n,in_ch,p__21985){
var map__21986 = p__21985;
var map__21986__$1 = ((((!((map__21986 == null)))?((((map__21986.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21986.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21986):map__21986);
var out_ch = cljs.core.get.call(null,map__21986__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__18455__auto__ = out_ch;
if(cljs.core.truth_(or__18455__auto__)){
return or__18455__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__20479__auto___22065 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20479__auto___22065,out_ch__$1,map__21986,map__21986__$1,out_ch){
return (function (){
var f__20480__auto__ = (function (){var switch__20458__auto__ = ((function (c__20479__auto___22065,out_ch__$1,map__21986,map__21986__$1,out_ch){
return (function (state_22028){
var state_val_22029 = (state_22028[(1)]);
if((state_val_22029 === (7))){
var inst_22024 = (state_22028[(2)]);
var state_22028__$1 = state_22028;
var statearr_22030_22066 = state_22028__$1;
(statearr_22030_22066[(2)] = inst_22024);

(statearr_22030_22066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (1))){
var inst_21988 = cljs.core.PersistentVector.EMPTY;
var inst_21989 = inst_21988;
var state_22028__$1 = (function (){var statearr_22031 = state_22028;
(statearr_22031[(7)] = inst_21989);

return statearr_22031;
})();
var statearr_22032_22067 = state_22028__$1;
(statearr_22032_22067[(2)] = null);

(statearr_22032_22067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (4))){
var inst_21992 = (state_22028[(8)]);
var inst_21992__$1 = (state_22028[(2)]);
var state_22028__$1 = (function (){var statearr_22033 = state_22028;
(statearr_22033[(8)] = inst_21992__$1);

return statearr_22033;
})();
if(cljs.core.truth_(inst_21992__$1)){
var statearr_22034_22068 = state_22028__$1;
(statearr_22034_22068[(1)] = (5));

} else {
var statearr_22035_22069 = state_22028__$1;
(statearr_22035_22069[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (15))){
var inst_22005 = (state_22028[(2)]);
var inst_22006 = cljs.core.PersistentVector.EMPTY;
var inst_21989 = inst_22006;
var state_22028__$1 = (function (){var statearr_22036 = state_22028;
(statearr_22036[(7)] = inst_21989);

(statearr_22036[(9)] = inst_22005);

return statearr_22036;
})();
var statearr_22037_22070 = state_22028__$1;
(statearr_22037_22070[(2)] = null);

(statearr_22037_22070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (13))){
var inst_22000 = (state_22028[(10)]);
var inst_21989 = inst_22000;
var state_22028__$1 = (function (){var statearr_22038 = state_22028;
(statearr_22038[(7)] = inst_21989);

return statearr_22038;
})();
var statearr_22039_22071 = state_22028__$1;
(statearr_22039_22071[(2)] = null);

(statearr_22039_22071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (6))){
var inst_21989 = (state_22028[(7)]);
var inst_22015 = cljs.core.not_empty.call(null,inst_21989);
var state_22028__$1 = state_22028;
if(cljs.core.truth_(inst_22015)){
var statearr_22040_22072 = state_22028__$1;
(statearr_22040_22072[(1)] = (16));

} else {
var statearr_22041_22073 = state_22028__$1;
(statearr_22041_22073[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (17))){
var state_22028__$1 = state_22028;
var statearr_22042_22074 = state_22028__$1;
(statearr_22042_22074[(2)] = null);

(statearr_22042_22074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (3))){
var inst_22026 = (state_22028[(2)]);
var state_22028__$1 = state_22028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22028__$1,inst_22026);
} else {
if((state_val_22029 === (12))){
var inst_22000 = (state_22028[(10)]);
var state_22028__$1 = state_22028;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22028__$1,(15),out_ch__$1,inst_22000);
} else {
if((state_val_22029 === (2))){
var state_22028__$1 = state_22028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22028__$1,(4),in_ch);
} else {
if((state_val_22029 === (19))){
var inst_22018 = (state_22028[(2)]);
var state_22028__$1 = state_22028;
var statearr_22043_22075 = state_22028__$1;
(statearr_22043_22075[(2)] = inst_22018);

(statearr_22043_22075[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (11))){
var inst_21997 = (state_22028[(2)]);
var inst_21998 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_22028__$1 = (function (){var statearr_22044 = state_22028;
(statearr_22044[(11)] = inst_21997);

return statearr_22044;
})();
var statearr_22045_22076 = state_22028__$1;
(statearr_22045_22076[(2)] = inst_21998);

(statearr_22045_22076[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (9))){
var inst_21989 = (state_22028[(7)]);
var inst_21992 = (state_22028[(8)]);
var inst_22000 = (state_22028[(10)]);
var inst_22000__$1 = cljs.core.conj.call(null,inst_21989,inst_21992);
var inst_22001 = cljs.core.count.call(null,inst_22000__$1);
var inst_22002 = cljs.core._EQ_.call(null,n,inst_22001);
var state_22028__$1 = (function (){var statearr_22046 = state_22028;
(statearr_22046[(10)] = inst_22000__$1);

return statearr_22046;
})();
if(inst_22002){
var statearr_22047_22077 = state_22028__$1;
(statearr_22047_22077[(1)] = (12));

} else {
var statearr_22048_22078 = state_22028__$1;
(statearr_22048_22078[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (5))){
var inst_21992 = (state_22028[(8)]);
var inst_21994 = (inst_21992 instanceof Error);
var state_22028__$1 = state_22028;
if(cljs.core.truth_(inst_21994)){
var statearr_22049_22079 = state_22028__$1;
(statearr_22049_22079[(1)] = (8));

} else {
var statearr_22050_22080 = state_22028__$1;
(statearr_22050_22080[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (14))){
var inst_22011 = (state_22028[(2)]);
var state_22028__$1 = state_22028;
var statearr_22051_22081 = state_22028__$1;
(statearr_22051_22081[(2)] = inst_22011);

(statearr_22051_22081[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (16))){
var inst_21989 = (state_22028[(7)]);
var state_22028__$1 = state_22028;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22028__$1,(19),out_ch__$1,inst_21989);
} else {
if((state_val_22029 === (10))){
var inst_22013 = (state_22028[(2)]);
var state_22028__$1 = state_22028;
var statearr_22052_22082 = state_22028__$1;
(statearr_22052_22082[(2)] = inst_22013);

(statearr_22052_22082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (18))){
var inst_22021 = (state_22028[(2)]);
var inst_22022 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_22028__$1 = (function (){var statearr_22053 = state_22028;
(statearr_22053[(12)] = inst_22021);

return statearr_22053;
})();
var statearr_22054_22083 = state_22028__$1;
(statearr_22054_22083[(2)] = inst_22022);

(statearr_22054_22083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22029 === (8))){
var inst_21992 = (state_22028[(8)]);
var state_22028__$1 = state_22028;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22028__$1,(11),out_ch__$1,inst_21992);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20479__auto___22065,out_ch__$1,map__21986,map__21986__$1,out_ch))
;
return ((function (switch__20458__auto__,c__20479__auto___22065,out_ch__$1,map__21986,map__21986__$1,out_ch){
return (function() {
var full$async$state_machine__20459__auto__ = null;
var full$async$state_machine__20459__auto____0 = (function (){
var statearr_22058 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22058[(0)] = full$async$state_machine__20459__auto__);

(statearr_22058[(1)] = (1));

return statearr_22058;
});
var full$async$state_machine__20459__auto____1 = (function (state_22028){
while(true){
var ret_value__20460__auto__ = (function (){try{while(true){
var result__20461__auto__ = switch__20458__auto__.call(null,state_22028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20461__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20461__auto__;
}
break;
}
}catch (e22059){if((e22059 instanceof Object)){
var ex__20462__auto__ = e22059;
var statearr_22060_22084 = state_22028;
(statearr_22060_22084[(5)] = ex__20462__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22028);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22059;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22085 = state_22028;
state_22028 = G__22085;
continue;
} else {
return ret_value__20460__auto__;
}
break;
}
});
full$async$state_machine__20459__auto__ = function(state_22028){
switch(arguments.length){
case 0:
return full$async$state_machine__20459__auto____0.call(this);
case 1:
return full$async$state_machine__20459__auto____1.call(this,state_22028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$0 = full$async$state_machine__20459__auto____0;
full$async$state_machine__20459__auto__.cljs$core$IFn$_invoke$arity$1 = full$async$state_machine__20459__auto____1;
return full$async$state_machine__20459__auto__;
})()
;})(switch__20458__auto__,c__20479__auto___22065,out_ch__$1,map__21986,map__21986__$1,out_ch))
})();
var state__20481__auto__ = (function (){var statearr_22061 = f__20480__auto__.call(null);
(statearr_22061[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20479__auto___22065);

return statearr_22061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20481__auto__);
});})(c__20479__auto___22065,out_ch__$1,map__21986,map__21986__$1,out_ch))
);


return out_ch__$1;
});

full.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (2);

full.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq21982){
var G__21983 = cljs.core.first.call(null,seq21982);
var seq21982__$1 = cljs.core.next.call(null,seq21982);
var G__21984 = cljs.core.first.call(null,seq21982__$1);
var seq21982__$2 = cljs.core.next.call(null,seq21982__$1);
return full.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__21983,G__21984,seq21982__$2);
});
/**
 * Counts items in a channel. Returns a channel with the item count.
 */
full.async.count_GT_ = (function full$async$count_GT_(ch){
return cljs.core.async.reduce.call(null,(function (acc,_){
return (acc + (1));
}),(0),ch);
});

//# sourceMappingURL=async.js.map