// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args52865 = [];
var len__51068__auto___52871 = arguments.length;
var i__51069__auto___52872 = (0);
while(true){
if((i__51069__auto___52872 < len__51068__auto___52871)){
args52865.push((arguments[i__51069__auto___52872]));

var G__52873 = (i__51069__auto___52872 + (1));
i__51069__auto___52872 = G__52873;
continue;
} else {
}
break;
}

var G__52867 = args52865.length;
switch (G__52867) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args52865.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async52868 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52868 = (function (f,blockable,meta52869){
this.f = f;
this.blockable = blockable;
this.meta52869 = meta52869;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52868.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52870,meta52869__$1){
var self__ = this;
var _52870__$1 = this;
return (new cljs.core.async.t_cljs$core$async52868(self__.f,self__.blockable,meta52869__$1));
});

cljs.core.async.t_cljs$core$async52868.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52870){
var self__ = this;
var _52870__$1 = this;
return self__.meta52869;
});

cljs.core.async.t_cljs$core$async52868.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52868.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async52868.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async52868.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async52868.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta52869","meta52869",-1559227145,null)], null);
});

cljs.core.async.t_cljs$core$async52868.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52868.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52868";

cljs.core.async.t_cljs$core$async52868.cljs$lang$ctorPrWriter = (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async52868");
});

cljs.core.async.__GT_t_cljs$core$async52868 = (function cljs$core$async$__GT_t_cljs$core$async52868(f__$1,blockable__$1,meta52869){
return (new cljs.core.async.t_cljs$core$async52868(f__$1,blockable__$1,meta52869));
});

}

return (new cljs.core.async.t_cljs$core$async52868(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args52877 = [];
var len__51068__auto___52880 = arguments.length;
var i__51069__auto___52881 = (0);
while(true){
if((i__51069__auto___52881 < len__51068__auto___52880)){
args52877.push((arguments[i__51069__auto___52881]));

var G__52882 = (i__51069__auto___52881 + (1));
i__51069__auto___52881 = G__52882;
continue;
} else {
}
break;
}

var G__52879 = args52877.length;
switch (G__52879) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args52877.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args52884 = [];
var len__51068__auto___52887 = arguments.length;
var i__51069__auto___52888 = (0);
while(true){
if((i__51069__auto___52888 < len__51068__auto___52887)){
args52884.push((arguments[i__51069__auto___52888]));

var G__52889 = (i__51069__auto___52888 + (1));
i__51069__auto___52888 = G__52889;
continue;
} else {
}
break;
}

var G__52886 = args52884.length;
switch (G__52886) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args52884.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args52891 = [];
var len__51068__auto___52894 = arguments.length;
var i__51069__auto___52895 = (0);
while(true){
if((i__51069__auto___52895 < len__51068__auto___52894)){
args52891.push((arguments[i__51069__auto___52895]));

var G__52896 = (i__51069__auto___52895 + (1));
i__51069__auto___52895 = G__52896;
continue;
} else {
}
break;
}

var G__52893 = args52891.length;
switch (G__52893) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args52891.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_52898 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_52898);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_52898,ret){
return (function (){
return fn1.call(null,val_52898);
});})(val_52898,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args52899 = [];
var len__51068__auto___52902 = arguments.length;
var i__51069__auto___52903 = (0);
while(true){
if((i__51069__auto___52903 < len__51068__auto___52902)){
args52899.push((arguments[i__51069__auto___52903]));

var G__52904 = (i__51069__auto___52903 + (1));
i__51069__auto___52903 = G__52904;
continue;
} else {
}
break;
}

var G__52901 = args52899.length;
switch (G__52901) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args52899.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__50868__auto___52906 = n;
var x_52907 = (0);
while(true){
if((x_52907 < n__50868__auto___52906)){
(a[x_52907] = (0));

var G__52908 = (x_52907 + (1));
x_52907 = G__52908;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__52909 = (i + (1));
i = G__52909;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async52913 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52913 = (function (flag,meta52914){
this.flag = flag;
this.meta52914 = meta52914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_52915,meta52914__$1){
var self__ = this;
var _52915__$1 = this;
return (new cljs.core.async.t_cljs$core$async52913(self__.flag,meta52914__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async52913.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_52915){
var self__ = this;
var _52915__$1 = this;
return self__.meta52914;
});})(flag))
;

cljs.core.async.t_cljs$core$async52913.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52913.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async52913.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async52913.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async52913.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta52914","meta52914",-2146158170,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async52913.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52913.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52913";

cljs.core.async.t_cljs$core$async52913.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async52913");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async52913 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async52913(flag__$1,meta52914){
return (new cljs.core.async.t_cljs$core$async52913(flag__$1,meta52914));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async52913(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async52919 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52919 = (function (flag,cb,meta52920){
this.flag = flag;
this.cb = cb;
this.meta52920 = meta52920;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async52919.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52921,meta52920__$1){
var self__ = this;
var _52921__$1 = this;
return (new cljs.core.async.t_cljs$core$async52919(self__.flag,self__.cb,meta52920__$1));
});

cljs.core.async.t_cljs$core$async52919.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52921){
var self__ = this;
var _52921__$1 = this;
return self__.meta52920;
});

cljs.core.async.t_cljs$core$async52919.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async52919.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async52919.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async52919.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async52919.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta52920","meta52920",1665126487,null)], null);
});

cljs.core.async.t_cljs$core$async52919.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async52919.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52919";

cljs.core.async.t_cljs$core$async52919.cljs$lang$ctorPrWriter = (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async52919");
});

cljs.core.async.__GT_t_cljs$core$async52919 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async52919(flag__$1,cb__$1,meta52920){
return (new cljs.core.async.t_cljs$core$async52919(flag__$1,cb__$1,meta52920));
});

}

return (new cljs.core.async.t_cljs$core$async52919(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__52922_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__52922_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__52923_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__52923_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__49852__auto__ = wport;
if(cljs.core.truth_(or__49852__auto__)){
return or__49852__auto__;
} else {
return port;
}
})()], null));
} else {
var G__52924 = (i + (1));
i = G__52924;
continue;
}
} else {
return null;
}
break;
}
})();
var or__49852__auto__ = ret;
if(cljs.core.truth_(or__49852__auto__)){
return or__49852__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__49840__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__49840__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__49840__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__51075__auto__ = [];
var len__51068__auto___52930 = arguments.length;
var i__51069__auto___52931 = (0);
while(true){
if((i__51069__auto___52931 < len__51068__auto___52930)){
args__51075__auto__.push((arguments[i__51069__auto___52931]));

var G__52932 = (i__51069__auto___52931 + (1));
i__51069__auto___52931 = G__52932;
continue;
} else {
}
break;
}

var argseq__51076__auto__ = ((((1) < args__51075__auto__.length))?(new cljs.core.IndexedSeq(args__51075__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__51076__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__52927){
var map__52928 = p__52927;
var map__52928__$1 = ((((!((map__52928 == null)))?((((map__52928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52928.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52928):map__52928);
var opts = map__52928__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq52925){
var G__52926 = cljs.core.first.call(null,seq52925);
var seq52925__$1 = cljs.core.next.call(null,seq52925);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__52926,seq52925__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args52933 = [];
var len__51068__auto___52983 = arguments.length;
var i__51069__auto___52984 = (0);
while(true){
if((i__51069__auto___52984 < len__51068__auto___52983)){
args52933.push((arguments[i__51069__auto___52984]));

var G__52985 = (i__51069__auto___52984 + (1));
i__51069__auto___52984 = G__52985;
continue;
} else {
}
break;
}

var G__52935 = args52933.length;
switch (G__52935) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args52933.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__52806__auto___52987 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___52987){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___52987){
return (function (state_52959){
var state_val_52960 = (state_52959[(1)]);
if((state_val_52960 === (7))){
var inst_52955 = (state_52959[(2)]);
var state_52959__$1 = state_52959;
var statearr_52961_52988 = state_52959__$1;
(statearr_52961_52988[(2)] = inst_52955);

(statearr_52961_52988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (1))){
var state_52959__$1 = state_52959;
var statearr_52962_52989 = state_52959__$1;
(statearr_52962_52989[(2)] = null);

(statearr_52962_52989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (4))){
var inst_52938 = (state_52959[(7)]);
var inst_52938__$1 = (state_52959[(2)]);
var inst_52939 = (inst_52938__$1 == null);
var state_52959__$1 = (function (){var statearr_52963 = state_52959;
(statearr_52963[(7)] = inst_52938__$1);

return statearr_52963;
})();
if(cljs.core.truth_(inst_52939)){
var statearr_52964_52990 = state_52959__$1;
(statearr_52964_52990[(1)] = (5));

} else {
var statearr_52965_52991 = state_52959__$1;
(statearr_52965_52991[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (13))){
var state_52959__$1 = state_52959;
var statearr_52966_52992 = state_52959__$1;
(statearr_52966_52992[(2)] = null);

(statearr_52966_52992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (6))){
var inst_52938 = (state_52959[(7)]);
var state_52959__$1 = state_52959;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52959__$1,(11),to,inst_52938);
} else {
if((state_val_52960 === (3))){
var inst_52957 = (state_52959[(2)]);
var state_52959__$1 = state_52959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52959__$1,inst_52957);
} else {
if((state_val_52960 === (12))){
var state_52959__$1 = state_52959;
var statearr_52967_52993 = state_52959__$1;
(statearr_52967_52993[(2)] = null);

(statearr_52967_52993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (2))){
var state_52959__$1 = state_52959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52959__$1,(4),from);
} else {
if((state_val_52960 === (11))){
var inst_52948 = (state_52959[(2)]);
var state_52959__$1 = state_52959;
if(cljs.core.truth_(inst_52948)){
var statearr_52968_52994 = state_52959__$1;
(statearr_52968_52994[(1)] = (12));

} else {
var statearr_52969_52995 = state_52959__$1;
(statearr_52969_52995[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (9))){
var state_52959__$1 = state_52959;
var statearr_52970_52996 = state_52959__$1;
(statearr_52970_52996[(2)] = null);

(statearr_52970_52996[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (5))){
var state_52959__$1 = state_52959;
if(cljs.core.truth_(close_QMARK_)){
var statearr_52971_52997 = state_52959__$1;
(statearr_52971_52997[(1)] = (8));

} else {
var statearr_52972_52998 = state_52959__$1;
(statearr_52972_52998[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (14))){
var inst_52953 = (state_52959[(2)]);
var state_52959__$1 = state_52959;
var statearr_52973_52999 = state_52959__$1;
(statearr_52973_52999[(2)] = inst_52953);

(statearr_52973_52999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (10))){
var inst_52945 = (state_52959[(2)]);
var state_52959__$1 = state_52959;
var statearr_52974_53000 = state_52959__$1;
(statearr_52974_53000[(2)] = inst_52945);

(statearr_52974_53000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52960 === (8))){
var inst_52942 = cljs.core.async.close_BANG_.call(null,to);
var state_52959__$1 = state_52959;
var statearr_52975_53001 = state_52959__$1;
(statearr_52975_53001[(2)] = inst_52942);

(statearr_52975_53001[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___52987))
;
return ((function (switch__52692__auto__,c__52806__auto___52987){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_52979 = [null,null,null,null,null,null,null,null];
(statearr_52979[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_52979[(1)] = (1));

return statearr_52979;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_52959){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_52959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e52980){if((e52980 instanceof Object)){
var ex__52696__auto__ = e52980;
var statearr_52981_53002 = state_52959;
(statearr_52981_53002[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52980;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53003 = state_52959;
state_52959 = G__53003;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_52959){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_52959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___52987))
})();
var state__52808__auto__ = (function (){var statearr_52982 = f__52807__auto__.call(null);
(statearr_52982[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___52987);

return statearr_52982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___52987))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__53191){
var vec__53192 = p__53191;
var v = cljs.core.nth.call(null,vec__53192,(0),null);
var p = cljs.core.nth.call(null,vec__53192,(1),null);
var job = vec__53192;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__52806__auto___53378 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___53378,res,vec__53192,v,p,job,jobs,results){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___53378,res,vec__53192,v,p,job,jobs,results){
return (function (state_53199){
var state_val_53200 = (state_53199[(1)]);
if((state_val_53200 === (1))){
var state_53199__$1 = state_53199;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53199__$1,(2),res,v);
} else {
if((state_val_53200 === (2))){
var inst_53196 = (state_53199[(2)]);
var inst_53197 = cljs.core.async.close_BANG_.call(null,res);
var state_53199__$1 = (function (){var statearr_53201 = state_53199;
(statearr_53201[(7)] = inst_53196);

return statearr_53201;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53199__$1,inst_53197);
} else {
return null;
}
}
});})(c__52806__auto___53378,res,vec__53192,v,p,job,jobs,results))
;
return ((function (switch__52692__auto__,c__52806__auto___53378,res,vec__53192,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0 = (function (){
var statearr_53205 = [null,null,null,null,null,null,null,null];
(statearr_53205[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__);

(statearr_53205[(1)] = (1));

return statearr_53205;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1 = (function (state_53199){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53206){if((e53206 instanceof Object)){
var ex__52696__auto__ = e53206;
var statearr_53207_53379 = state_53199;
(statearr_53207_53379[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53199);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53206;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53380 = state_53199;
state_53199 = G__53380;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = function(state_53199){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1.call(this,state_53199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___53378,res,vec__53192,v,p,job,jobs,results))
})();
var state__52808__auto__ = (function (){var statearr_53208 = f__52807__auto__.call(null);
(statearr_53208[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___53378);

return statearr_53208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___53378,res,vec__53192,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__53209){
var vec__53210 = p__53209;
var v = cljs.core.nth.call(null,vec__53210,(0),null);
var p = cljs.core.nth.call(null,vec__53210,(1),null);
var job = vec__53210;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__50868__auto___53381 = n;
var __53382 = (0);
while(true){
if((__53382 < n__50868__auto___53381)){
var G__53213_53383 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__53213_53383) {
case "compute":
var c__52806__auto___53385 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__53382,c__52806__auto___53385,G__53213_53383,n__50868__auto___53381,jobs,results,process,async){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (__53382,c__52806__auto___53385,G__53213_53383,n__50868__auto___53381,jobs,results,process,async){
return (function (state_53226){
var state_val_53227 = (state_53226[(1)]);
if((state_val_53227 === (1))){
var state_53226__$1 = state_53226;
var statearr_53228_53386 = state_53226__$1;
(statearr_53228_53386[(2)] = null);

(statearr_53228_53386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53227 === (2))){
var state_53226__$1 = state_53226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53226__$1,(4),jobs);
} else {
if((state_val_53227 === (3))){
var inst_53224 = (state_53226[(2)]);
var state_53226__$1 = state_53226;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53226__$1,inst_53224);
} else {
if((state_val_53227 === (4))){
var inst_53216 = (state_53226[(2)]);
var inst_53217 = process.call(null,inst_53216);
var state_53226__$1 = state_53226;
if(cljs.core.truth_(inst_53217)){
var statearr_53229_53387 = state_53226__$1;
(statearr_53229_53387[(1)] = (5));

} else {
var statearr_53230_53388 = state_53226__$1;
(statearr_53230_53388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53227 === (5))){
var state_53226__$1 = state_53226;
var statearr_53231_53389 = state_53226__$1;
(statearr_53231_53389[(2)] = null);

(statearr_53231_53389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53227 === (6))){
var state_53226__$1 = state_53226;
var statearr_53232_53390 = state_53226__$1;
(statearr_53232_53390[(2)] = null);

(statearr_53232_53390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53227 === (7))){
var inst_53222 = (state_53226[(2)]);
var state_53226__$1 = state_53226;
var statearr_53233_53391 = state_53226__$1;
(statearr_53233_53391[(2)] = inst_53222);

(statearr_53233_53391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__53382,c__52806__auto___53385,G__53213_53383,n__50868__auto___53381,jobs,results,process,async))
;
return ((function (__53382,switch__52692__auto__,c__52806__auto___53385,G__53213_53383,n__50868__auto___53381,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0 = (function (){
var statearr_53237 = [null,null,null,null,null,null,null];
(statearr_53237[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__);

(statearr_53237[(1)] = (1));

return statearr_53237;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1 = (function (state_53226){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53238){if((e53238 instanceof Object)){
var ex__52696__auto__ = e53238;
var statearr_53239_53392 = state_53226;
(statearr_53239_53392[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53226);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53238;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53393 = state_53226;
state_53226 = G__53393;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = function(state_53226){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1.call(this,state_53226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__;
})()
;})(__53382,switch__52692__auto__,c__52806__auto___53385,G__53213_53383,n__50868__auto___53381,jobs,results,process,async))
})();
var state__52808__auto__ = (function (){var statearr_53240 = f__52807__auto__.call(null);
(statearr_53240[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___53385);

return statearr_53240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(__53382,c__52806__auto___53385,G__53213_53383,n__50868__auto___53381,jobs,results,process,async))
);


break;
case "async":
var c__52806__auto___53394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__53382,c__52806__auto___53394,G__53213_53383,n__50868__auto___53381,jobs,results,process,async){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (__53382,c__52806__auto___53394,G__53213_53383,n__50868__auto___53381,jobs,results,process,async){
return (function (state_53253){
var state_val_53254 = (state_53253[(1)]);
if((state_val_53254 === (1))){
var state_53253__$1 = state_53253;
var statearr_53255_53395 = state_53253__$1;
(statearr_53255_53395[(2)] = null);

(statearr_53255_53395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53254 === (2))){
var state_53253__$1 = state_53253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53253__$1,(4),jobs);
} else {
if((state_val_53254 === (3))){
var inst_53251 = (state_53253[(2)]);
var state_53253__$1 = state_53253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53253__$1,inst_53251);
} else {
if((state_val_53254 === (4))){
var inst_53243 = (state_53253[(2)]);
var inst_53244 = async.call(null,inst_53243);
var state_53253__$1 = state_53253;
if(cljs.core.truth_(inst_53244)){
var statearr_53256_53396 = state_53253__$1;
(statearr_53256_53396[(1)] = (5));

} else {
var statearr_53257_53397 = state_53253__$1;
(statearr_53257_53397[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53254 === (5))){
var state_53253__$1 = state_53253;
var statearr_53258_53398 = state_53253__$1;
(statearr_53258_53398[(2)] = null);

(statearr_53258_53398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53254 === (6))){
var state_53253__$1 = state_53253;
var statearr_53259_53399 = state_53253__$1;
(statearr_53259_53399[(2)] = null);

(statearr_53259_53399[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53254 === (7))){
var inst_53249 = (state_53253[(2)]);
var state_53253__$1 = state_53253;
var statearr_53260_53400 = state_53253__$1;
(statearr_53260_53400[(2)] = inst_53249);

(statearr_53260_53400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__53382,c__52806__auto___53394,G__53213_53383,n__50868__auto___53381,jobs,results,process,async))
;
return ((function (__53382,switch__52692__auto__,c__52806__auto___53394,G__53213_53383,n__50868__auto___53381,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0 = (function (){
var statearr_53264 = [null,null,null,null,null,null,null];
(statearr_53264[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__);

(statearr_53264[(1)] = (1));

return statearr_53264;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1 = (function (state_53253){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53265){if((e53265 instanceof Object)){
var ex__52696__auto__ = e53265;
var statearr_53266_53401 = state_53253;
(statearr_53266_53401[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53265;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53402 = state_53253;
state_53253 = G__53402;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = function(state_53253){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1.call(this,state_53253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__;
})()
;})(__53382,switch__52692__auto__,c__52806__auto___53394,G__53213_53383,n__50868__auto___53381,jobs,results,process,async))
})();
var state__52808__auto__ = (function (){var statearr_53267 = f__52807__auto__.call(null);
(statearr_53267[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___53394);

return statearr_53267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(__53382,c__52806__auto___53394,G__53213_53383,n__50868__auto___53381,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__53403 = (__53382 + (1));
__53382 = G__53403;
continue;
} else {
}
break;
}

var c__52806__auto___53404 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___53404,jobs,results,process,async){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___53404,jobs,results,process,async){
return (function (state_53289){
var state_val_53290 = (state_53289[(1)]);
if((state_val_53290 === (1))){
var state_53289__$1 = state_53289;
var statearr_53291_53405 = state_53289__$1;
(statearr_53291_53405[(2)] = null);

(statearr_53291_53405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53290 === (2))){
var state_53289__$1 = state_53289;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53289__$1,(4),from);
} else {
if((state_val_53290 === (3))){
var inst_53287 = (state_53289[(2)]);
var state_53289__$1 = state_53289;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53289__$1,inst_53287);
} else {
if((state_val_53290 === (4))){
var inst_53270 = (state_53289[(7)]);
var inst_53270__$1 = (state_53289[(2)]);
var inst_53271 = (inst_53270__$1 == null);
var state_53289__$1 = (function (){var statearr_53292 = state_53289;
(statearr_53292[(7)] = inst_53270__$1);

return statearr_53292;
})();
if(cljs.core.truth_(inst_53271)){
var statearr_53293_53406 = state_53289__$1;
(statearr_53293_53406[(1)] = (5));

} else {
var statearr_53294_53407 = state_53289__$1;
(statearr_53294_53407[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53290 === (5))){
var inst_53273 = cljs.core.async.close_BANG_.call(null,jobs);
var state_53289__$1 = state_53289;
var statearr_53295_53408 = state_53289__$1;
(statearr_53295_53408[(2)] = inst_53273);

(statearr_53295_53408[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53290 === (6))){
var inst_53275 = (state_53289[(8)]);
var inst_53270 = (state_53289[(7)]);
var inst_53275__$1 = cljs.core.async.chan.call(null,(1));
var inst_53276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53277 = [inst_53270,inst_53275__$1];
var inst_53278 = (new cljs.core.PersistentVector(null,2,(5),inst_53276,inst_53277,null));
var state_53289__$1 = (function (){var statearr_53296 = state_53289;
(statearr_53296[(8)] = inst_53275__$1);

return statearr_53296;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53289__$1,(8),jobs,inst_53278);
} else {
if((state_val_53290 === (7))){
var inst_53285 = (state_53289[(2)]);
var state_53289__$1 = state_53289;
var statearr_53297_53409 = state_53289__$1;
(statearr_53297_53409[(2)] = inst_53285);

(statearr_53297_53409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53290 === (8))){
var inst_53275 = (state_53289[(8)]);
var inst_53280 = (state_53289[(2)]);
var state_53289__$1 = (function (){var statearr_53298 = state_53289;
(statearr_53298[(9)] = inst_53280);

return statearr_53298;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53289__$1,(9),results,inst_53275);
} else {
if((state_val_53290 === (9))){
var inst_53282 = (state_53289[(2)]);
var state_53289__$1 = (function (){var statearr_53299 = state_53289;
(statearr_53299[(10)] = inst_53282);

return statearr_53299;
})();
var statearr_53300_53410 = state_53289__$1;
(statearr_53300_53410[(2)] = null);

(statearr_53300_53410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___53404,jobs,results,process,async))
;
return ((function (switch__52692__auto__,c__52806__auto___53404,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0 = (function (){
var statearr_53304 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53304[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__);

(statearr_53304[(1)] = (1));

return statearr_53304;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1 = (function (state_53289){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53289);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53305){if((e53305 instanceof Object)){
var ex__52696__auto__ = e53305;
var statearr_53306_53411 = state_53289;
(statearr_53306_53411[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53289);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53305;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53412 = state_53289;
state_53289 = G__53412;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = function(state_53289){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1.call(this,state_53289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___53404,jobs,results,process,async))
})();
var state__52808__auto__ = (function (){var statearr_53307 = f__52807__auto__.call(null);
(statearr_53307[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___53404);

return statearr_53307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___53404,jobs,results,process,async))
);


var c__52806__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto__,jobs,results,process,async){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto__,jobs,results,process,async){
return (function (state_53345){
var state_val_53346 = (state_53345[(1)]);
if((state_val_53346 === (7))){
var inst_53341 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
var statearr_53347_53413 = state_53345__$1;
(statearr_53347_53413[(2)] = inst_53341);

(statearr_53347_53413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (20))){
var state_53345__$1 = state_53345;
var statearr_53348_53414 = state_53345__$1;
(statearr_53348_53414[(2)] = null);

(statearr_53348_53414[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (1))){
var state_53345__$1 = state_53345;
var statearr_53349_53415 = state_53345__$1;
(statearr_53349_53415[(2)] = null);

(statearr_53349_53415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (4))){
var inst_53310 = (state_53345[(7)]);
var inst_53310__$1 = (state_53345[(2)]);
var inst_53311 = (inst_53310__$1 == null);
var state_53345__$1 = (function (){var statearr_53350 = state_53345;
(statearr_53350[(7)] = inst_53310__$1);

return statearr_53350;
})();
if(cljs.core.truth_(inst_53311)){
var statearr_53351_53416 = state_53345__$1;
(statearr_53351_53416[(1)] = (5));

} else {
var statearr_53352_53417 = state_53345__$1;
(statearr_53352_53417[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (15))){
var inst_53323 = (state_53345[(8)]);
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53345__$1,(18),to,inst_53323);
} else {
if((state_val_53346 === (21))){
var inst_53336 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
var statearr_53353_53418 = state_53345__$1;
(statearr_53353_53418[(2)] = inst_53336);

(statearr_53353_53418[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (13))){
var inst_53338 = (state_53345[(2)]);
var state_53345__$1 = (function (){var statearr_53354 = state_53345;
(statearr_53354[(9)] = inst_53338);

return statearr_53354;
})();
var statearr_53355_53419 = state_53345__$1;
(statearr_53355_53419[(2)] = null);

(statearr_53355_53419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (6))){
var inst_53310 = (state_53345[(7)]);
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53345__$1,(11),inst_53310);
} else {
if((state_val_53346 === (17))){
var inst_53331 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
if(cljs.core.truth_(inst_53331)){
var statearr_53356_53420 = state_53345__$1;
(statearr_53356_53420[(1)] = (19));

} else {
var statearr_53357_53421 = state_53345__$1;
(statearr_53357_53421[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (3))){
var inst_53343 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53345__$1,inst_53343);
} else {
if((state_val_53346 === (12))){
var inst_53320 = (state_53345[(10)]);
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53345__$1,(14),inst_53320);
} else {
if((state_val_53346 === (2))){
var state_53345__$1 = state_53345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53345__$1,(4),results);
} else {
if((state_val_53346 === (19))){
var state_53345__$1 = state_53345;
var statearr_53358_53422 = state_53345__$1;
(statearr_53358_53422[(2)] = null);

(statearr_53358_53422[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (11))){
var inst_53320 = (state_53345[(2)]);
var state_53345__$1 = (function (){var statearr_53359 = state_53345;
(statearr_53359[(10)] = inst_53320);

return statearr_53359;
})();
var statearr_53360_53423 = state_53345__$1;
(statearr_53360_53423[(2)] = null);

(statearr_53360_53423[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (9))){
var state_53345__$1 = state_53345;
var statearr_53361_53424 = state_53345__$1;
(statearr_53361_53424[(2)] = null);

(statearr_53361_53424[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (5))){
var state_53345__$1 = state_53345;
if(cljs.core.truth_(close_QMARK_)){
var statearr_53362_53425 = state_53345__$1;
(statearr_53362_53425[(1)] = (8));

} else {
var statearr_53363_53426 = state_53345__$1;
(statearr_53363_53426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (14))){
var inst_53323 = (state_53345[(8)]);
var inst_53325 = (state_53345[(11)]);
var inst_53323__$1 = (state_53345[(2)]);
var inst_53324 = (inst_53323__$1 == null);
var inst_53325__$1 = cljs.core.not.call(null,inst_53324);
var state_53345__$1 = (function (){var statearr_53364 = state_53345;
(statearr_53364[(8)] = inst_53323__$1);

(statearr_53364[(11)] = inst_53325__$1);

return statearr_53364;
})();
if(inst_53325__$1){
var statearr_53365_53427 = state_53345__$1;
(statearr_53365_53427[(1)] = (15));

} else {
var statearr_53366_53428 = state_53345__$1;
(statearr_53366_53428[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (16))){
var inst_53325 = (state_53345[(11)]);
var state_53345__$1 = state_53345;
var statearr_53367_53429 = state_53345__$1;
(statearr_53367_53429[(2)] = inst_53325);

(statearr_53367_53429[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (10))){
var inst_53317 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
var statearr_53368_53430 = state_53345__$1;
(statearr_53368_53430[(2)] = inst_53317);

(statearr_53368_53430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (18))){
var inst_53328 = (state_53345[(2)]);
var state_53345__$1 = state_53345;
var statearr_53369_53431 = state_53345__$1;
(statearr_53369_53431[(2)] = inst_53328);

(statearr_53369_53431[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53346 === (8))){
var inst_53314 = cljs.core.async.close_BANG_.call(null,to);
var state_53345__$1 = state_53345;
var statearr_53370_53432 = state_53345__$1;
(statearr_53370_53432[(2)] = inst_53314);

(statearr_53370_53432[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto__,jobs,results,process,async))
;
return ((function (switch__52692__auto__,c__52806__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0 = (function (){
var statearr_53374 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53374[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__);

(statearr_53374[(1)] = (1));

return statearr_53374;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1 = (function (state_53345){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53375){if((e53375 instanceof Object)){
var ex__52696__auto__ = e53375;
var statearr_53376_53433 = state_53345;
(statearr_53376_53433[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53345);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53375;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53434 = state_53345;
state_53345 = G__53434;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__ = function(state_53345){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1.call(this,state_53345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto__,jobs,results,process,async))
})();
var state__52808__auto__ = (function (){var statearr_53377 = f__52807__auto__.call(null);
(statearr_53377[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto__);

return statearr_53377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto__,jobs,results,process,async))
);

return c__52806__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args53435 = [];
var len__51068__auto___53438 = arguments.length;
var i__51069__auto___53439 = (0);
while(true){
if((i__51069__auto___53439 < len__51068__auto___53438)){
args53435.push((arguments[i__51069__auto___53439]));

var G__53440 = (i__51069__auto___53439 + (1));
i__51069__auto___53439 = G__53440;
continue;
} else {
}
break;
}

var G__53437 = args53435.length;
switch (G__53437) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args53435.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args53442 = [];
var len__51068__auto___53445 = arguments.length;
var i__51069__auto___53446 = (0);
while(true){
if((i__51069__auto___53446 < len__51068__auto___53445)){
args53442.push((arguments[i__51069__auto___53446]));

var G__53447 = (i__51069__auto___53446 + (1));
i__51069__auto___53446 = G__53447;
continue;
} else {
}
break;
}

var G__53444 = args53442.length;
switch (G__53444) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args53442.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args53449 = [];
var len__51068__auto___53502 = arguments.length;
var i__51069__auto___53503 = (0);
while(true){
if((i__51069__auto___53503 < len__51068__auto___53502)){
args53449.push((arguments[i__51069__auto___53503]));

var G__53504 = (i__51069__auto___53503 + (1));
i__51069__auto___53503 = G__53504;
continue;
} else {
}
break;
}

var G__53451 = args53449.length;
switch (G__53451) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args53449.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__52806__auto___53506 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___53506,tc,fc){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___53506,tc,fc){
return (function (state_53477){
var state_val_53478 = (state_53477[(1)]);
if((state_val_53478 === (7))){
var inst_53473 = (state_53477[(2)]);
var state_53477__$1 = state_53477;
var statearr_53479_53507 = state_53477__$1;
(statearr_53479_53507[(2)] = inst_53473);

(statearr_53479_53507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (1))){
var state_53477__$1 = state_53477;
var statearr_53480_53508 = state_53477__$1;
(statearr_53480_53508[(2)] = null);

(statearr_53480_53508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (4))){
var inst_53454 = (state_53477[(7)]);
var inst_53454__$1 = (state_53477[(2)]);
var inst_53455 = (inst_53454__$1 == null);
var state_53477__$1 = (function (){var statearr_53481 = state_53477;
(statearr_53481[(7)] = inst_53454__$1);

return statearr_53481;
})();
if(cljs.core.truth_(inst_53455)){
var statearr_53482_53509 = state_53477__$1;
(statearr_53482_53509[(1)] = (5));

} else {
var statearr_53483_53510 = state_53477__$1;
(statearr_53483_53510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (13))){
var state_53477__$1 = state_53477;
var statearr_53484_53511 = state_53477__$1;
(statearr_53484_53511[(2)] = null);

(statearr_53484_53511[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (6))){
var inst_53454 = (state_53477[(7)]);
var inst_53460 = p.call(null,inst_53454);
var state_53477__$1 = state_53477;
if(cljs.core.truth_(inst_53460)){
var statearr_53485_53512 = state_53477__$1;
(statearr_53485_53512[(1)] = (9));

} else {
var statearr_53486_53513 = state_53477__$1;
(statearr_53486_53513[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (3))){
var inst_53475 = (state_53477[(2)]);
var state_53477__$1 = state_53477;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53477__$1,inst_53475);
} else {
if((state_val_53478 === (12))){
var state_53477__$1 = state_53477;
var statearr_53487_53514 = state_53477__$1;
(statearr_53487_53514[(2)] = null);

(statearr_53487_53514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (2))){
var state_53477__$1 = state_53477;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53477__$1,(4),ch);
} else {
if((state_val_53478 === (11))){
var inst_53454 = (state_53477[(7)]);
var inst_53464 = (state_53477[(2)]);
var state_53477__$1 = state_53477;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53477__$1,(8),inst_53464,inst_53454);
} else {
if((state_val_53478 === (9))){
var state_53477__$1 = state_53477;
var statearr_53488_53515 = state_53477__$1;
(statearr_53488_53515[(2)] = tc);

(statearr_53488_53515[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (5))){
var inst_53457 = cljs.core.async.close_BANG_.call(null,tc);
var inst_53458 = cljs.core.async.close_BANG_.call(null,fc);
var state_53477__$1 = (function (){var statearr_53489 = state_53477;
(statearr_53489[(8)] = inst_53457);

return statearr_53489;
})();
var statearr_53490_53516 = state_53477__$1;
(statearr_53490_53516[(2)] = inst_53458);

(statearr_53490_53516[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (14))){
var inst_53471 = (state_53477[(2)]);
var state_53477__$1 = state_53477;
var statearr_53491_53517 = state_53477__$1;
(statearr_53491_53517[(2)] = inst_53471);

(statearr_53491_53517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (10))){
var state_53477__$1 = state_53477;
var statearr_53492_53518 = state_53477__$1;
(statearr_53492_53518[(2)] = fc);

(statearr_53492_53518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53478 === (8))){
var inst_53466 = (state_53477[(2)]);
var state_53477__$1 = state_53477;
if(cljs.core.truth_(inst_53466)){
var statearr_53493_53519 = state_53477__$1;
(statearr_53493_53519[(1)] = (12));

} else {
var statearr_53494_53520 = state_53477__$1;
(statearr_53494_53520[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___53506,tc,fc))
;
return ((function (switch__52692__auto__,c__52806__auto___53506,tc,fc){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_53498 = [null,null,null,null,null,null,null,null,null];
(statearr_53498[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_53498[(1)] = (1));

return statearr_53498;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_53477){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53477);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53499){if((e53499 instanceof Object)){
var ex__52696__auto__ = e53499;
var statearr_53500_53521 = state_53477;
(statearr_53500_53521[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53477);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53499;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53522 = state_53477;
state_53477 = G__53522;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_53477){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_53477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___53506,tc,fc))
})();
var state__52808__auto__ = (function (){var statearr_53501 = f__52807__auto__.call(null);
(statearr_53501[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___53506);

return statearr_53501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___53506,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__52806__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto__){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto__){
return (function (state_53586){
var state_val_53587 = (state_53586[(1)]);
if((state_val_53587 === (7))){
var inst_53582 = (state_53586[(2)]);
var state_53586__$1 = state_53586;
var statearr_53588_53609 = state_53586__$1;
(statearr_53588_53609[(2)] = inst_53582);

(statearr_53588_53609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53587 === (1))){
var inst_53566 = init;
var state_53586__$1 = (function (){var statearr_53589 = state_53586;
(statearr_53589[(7)] = inst_53566);

return statearr_53589;
})();
var statearr_53590_53610 = state_53586__$1;
(statearr_53590_53610[(2)] = null);

(statearr_53590_53610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53587 === (4))){
var inst_53569 = (state_53586[(8)]);
var inst_53569__$1 = (state_53586[(2)]);
var inst_53570 = (inst_53569__$1 == null);
var state_53586__$1 = (function (){var statearr_53591 = state_53586;
(statearr_53591[(8)] = inst_53569__$1);

return statearr_53591;
})();
if(cljs.core.truth_(inst_53570)){
var statearr_53592_53611 = state_53586__$1;
(statearr_53592_53611[(1)] = (5));

} else {
var statearr_53593_53612 = state_53586__$1;
(statearr_53593_53612[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53587 === (6))){
var inst_53566 = (state_53586[(7)]);
var inst_53573 = (state_53586[(9)]);
var inst_53569 = (state_53586[(8)]);
var inst_53573__$1 = f.call(null,inst_53566,inst_53569);
var inst_53574 = cljs.core.reduced_QMARK_.call(null,inst_53573__$1);
var state_53586__$1 = (function (){var statearr_53594 = state_53586;
(statearr_53594[(9)] = inst_53573__$1);

return statearr_53594;
})();
if(inst_53574){
var statearr_53595_53613 = state_53586__$1;
(statearr_53595_53613[(1)] = (8));

} else {
var statearr_53596_53614 = state_53586__$1;
(statearr_53596_53614[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53587 === (3))){
var inst_53584 = (state_53586[(2)]);
var state_53586__$1 = state_53586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53586__$1,inst_53584);
} else {
if((state_val_53587 === (2))){
var state_53586__$1 = state_53586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53586__$1,(4),ch);
} else {
if((state_val_53587 === (9))){
var inst_53573 = (state_53586[(9)]);
var inst_53566 = inst_53573;
var state_53586__$1 = (function (){var statearr_53597 = state_53586;
(statearr_53597[(7)] = inst_53566);

return statearr_53597;
})();
var statearr_53598_53615 = state_53586__$1;
(statearr_53598_53615[(2)] = null);

(statearr_53598_53615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53587 === (5))){
var inst_53566 = (state_53586[(7)]);
var state_53586__$1 = state_53586;
var statearr_53599_53616 = state_53586__$1;
(statearr_53599_53616[(2)] = inst_53566);

(statearr_53599_53616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53587 === (10))){
var inst_53580 = (state_53586[(2)]);
var state_53586__$1 = state_53586;
var statearr_53600_53617 = state_53586__$1;
(statearr_53600_53617[(2)] = inst_53580);

(statearr_53600_53617[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53587 === (8))){
var inst_53573 = (state_53586[(9)]);
var inst_53576 = cljs.core.deref.call(null,inst_53573);
var state_53586__$1 = state_53586;
var statearr_53601_53618 = state_53586__$1;
(statearr_53601_53618[(2)] = inst_53576);

(statearr_53601_53618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto__))
;
return ((function (switch__52692__auto__,c__52806__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__52693__auto__ = null;
var cljs$core$async$reduce_$_state_machine__52693__auto____0 = (function (){
var statearr_53605 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53605[(0)] = cljs$core$async$reduce_$_state_machine__52693__auto__);

(statearr_53605[(1)] = (1));

return statearr_53605;
});
var cljs$core$async$reduce_$_state_machine__52693__auto____1 = (function (state_53586){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53606){if((e53606 instanceof Object)){
var ex__52696__auto__ = e53606;
var statearr_53607_53619 = state_53586;
(statearr_53607_53619[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53606;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53620 = state_53586;
state_53586 = G__53620;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__52693__auto__ = function(state_53586){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__52693__auto____1.call(this,state_53586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__52693__auto____0;
cljs$core$async$reduce_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__52693__auto____1;
return cljs$core$async$reduce_$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto__))
})();
var state__52808__auto__ = (function (){var statearr_53608 = f__52807__auto__.call(null);
(statearr_53608[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto__);

return statearr_53608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto__))
);

return c__52806__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args53621 = [];
var len__51068__auto___53673 = arguments.length;
var i__51069__auto___53674 = (0);
while(true){
if((i__51069__auto___53674 < len__51068__auto___53673)){
args53621.push((arguments[i__51069__auto___53674]));

var G__53675 = (i__51069__auto___53674 + (1));
i__51069__auto___53674 = G__53675;
continue;
} else {
}
break;
}

var G__53623 = args53621.length;
switch (G__53623) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args53621.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__52806__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto__){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto__){
return (function (state_53648){
var state_val_53649 = (state_53648[(1)]);
if((state_val_53649 === (7))){
var inst_53630 = (state_53648[(2)]);
var state_53648__$1 = state_53648;
var statearr_53650_53677 = state_53648__$1;
(statearr_53650_53677[(2)] = inst_53630);

(statearr_53650_53677[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (1))){
var inst_53624 = cljs.core.seq.call(null,coll);
var inst_53625 = inst_53624;
var state_53648__$1 = (function (){var statearr_53651 = state_53648;
(statearr_53651[(7)] = inst_53625);

return statearr_53651;
})();
var statearr_53652_53678 = state_53648__$1;
(statearr_53652_53678[(2)] = null);

(statearr_53652_53678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (4))){
var inst_53625 = (state_53648[(7)]);
var inst_53628 = cljs.core.first.call(null,inst_53625);
var state_53648__$1 = state_53648;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53648__$1,(7),ch,inst_53628);
} else {
if((state_val_53649 === (13))){
var inst_53642 = (state_53648[(2)]);
var state_53648__$1 = state_53648;
var statearr_53653_53679 = state_53648__$1;
(statearr_53653_53679[(2)] = inst_53642);

(statearr_53653_53679[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (6))){
var inst_53633 = (state_53648[(2)]);
var state_53648__$1 = state_53648;
if(cljs.core.truth_(inst_53633)){
var statearr_53654_53680 = state_53648__$1;
(statearr_53654_53680[(1)] = (8));

} else {
var statearr_53655_53681 = state_53648__$1;
(statearr_53655_53681[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (3))){
var inst_53646 = (state_53648[(2)]);
var state_53648__$1 = state_53648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53648__$1,inst_53646);
} else {
if((state_val_53649 === (12))){
var state_53648__$1 = state_53648;
var statearr_53656_53682 = state_53648__$1;
(statearr_53656_53682[(2)] = null);

(statearr_53656_53682[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (2))){
var inst_53625 = (state_53648[(7)]);
var state_53648__$1 = state_53648;
if(cljs.core.truth_(inst_53625)){
var statearr_53657_53683 = state_53648__$1;
(statearr_53657_53683[(1)] = (4));

} else {
var statearr_53658_53684 = state_53648__$1;
(statearr_53658_53684[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (11))){
var inst_53639 = cljs.core.async.close_BANG_.call(null,ch);
var state_53648__$1 = state_53648;
var statearr_53659_53685 = state_53648__$1;
(statearr_53659_53685[(2)] = inst_53639);

(statearr_53659_53685[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (9))){
var state_53648__$1 = state_53648;
if(cljs.core.truth_(close_QMARK_)){
var statearr_53660_53686 = state_53648__$1;
(statearr_53660_53686[(1)] = (11));

} else {
var statearr_53661_53687 = state_53648__$1;
(statearr_53661_53687[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (5))){
var inst_53625 = (state_53648[(7)]);
var state_53648__$1 = state_53648;
var statearr_53662_53688 = state_53648__$1;
(statearr_53662_53688[(2)] = inst_53625);

(statearr_53662_53688[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (10))){
var inst_53644 = (state_53648[(2)]);
var state_53648__$1 = state_53648;
var statearr_53663_53689 = state_53648__$1;
(statearr_53663_53689[(2)] = inst_53644);

(statearr_53663_53689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53649 === (8))){
var inst_53625 = (state_53648[(7)]);
var inst_53635 = cljs.core.next.call(null,inst_53625);
var inst_53625__$1 = inst_53635;
var state_53648__$1 = (function (){var statearr_53664 = state_53648;
(statearr_53664[(7)] = inst_53625__$1);

return statearr_53664;
})();
var statearr_53665_53690 = state_53648__$1;
(statearr_53665_53690[(2)] = null);

(statearr_53665_53690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto__))
;
return ((function (switch__52692__auto__,c__52806__auto__){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_53669 = [null,null,null,null,null,null,null,null];
(statearr_53669[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_53669[(1)] = (1));

return statearr_53669;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_53648){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_53648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e53670){if((e53670 instanceof Object)){
var ex__52696__auto__ = e53670;
var statearr_53671_53691 = state_53648;
(statearr_53671_53691[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53648);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53670;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53692 = state_53648;
state_53648 = G__53692;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_53648){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_53648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto__))
})();
var state__52808__auto__ = (function (){var statearr_53672 = f__52807__auto__.call(null);
(statearr_53672[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto__);

return statearr_53672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto__))
);

return c__52806__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__50565__auto__ = (((_ == null))?null:_);
var m__50566__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,_);
} else {
var m__50566__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__50566__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m,ch);
} else {
var m__50566__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m);
} else {
var m__50566__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async53918 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async53918 = (function (ch,cs,meta53919){
this.ch = ch;
this.cs = cs;
this.meta53919 = meta53919;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_53920,meta53919__$1){
var self__ = this;
var _53920__$1 = this;
return (new cljs.core.async.t_cljs$core$async53918(self__.ch,self__.cs,meta53919__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_53920){
var self__ = this;
var _53920__$1 = this;
return self__.meta53919;
});})(cs))
;

cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async53918.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async53918.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta53919","meta53919",1041839133,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async53918.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async53918.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async53918";

cljs.core.async.t_cljs$core$async53918.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async53918");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async53918 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async53918(ch__$1,cs__$1,meta53919){
return (new cljs.core.async.t_cljs$core$async53918(ch__$1,cs__$1,meta53919));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async53918(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__52806__auto___54143 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___54143,cs,m,dchan,dctr,done){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___54143,cs,m,dchan,dctr,done){
return (function (state_54055){
var state_val_54056 = (state_54055[(1)]);
if((state_val_54056 === (7))){
var inst_54051 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54057_54144 = state_54055__$1;
(statearr_54057_54144[(2)] = inst_54051);

(statearr_54057_54144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (20))){
var inst_53954 = (state_54055[(7)]);
var inst_53966 = cljs.core.first.call(null,inst_53954);
var inst_53967 = cljs.core.nth.call(null,inst_53966,(0),null);
var inst_53968 = cljs.core.nth.call(null,inst_53966,(1),null);
var state_54055__$1 = (function (){var statearr_54058 = state_54055;
(statearr_54058[(8)] = inst_53967);

return statearr_54058;
})();
if(cljs.core.truth_(inst_53968)){
var statearr_54059_54145 = state_54055__$1;
(statearr_54059_54145[(1)] = (22));

} else {
var statearr_54060_54146 = state_54055__$1;
(statearr_54060_54146[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (27))){
var inst_53998 = (state_54055[(9)]);
var inst_53923 = (state_54055[(10)]);
var inst_54003 = (state_54055[(11)]);
var inst_53996 = (state_54055[(12)]);
var inst_54003__$1 = cljs.core._nth.call(null,inst_53996,inst_53998);
var inst_54004 = cljs.core.async.put_BANG_.call(null,inst_54003__$1,inst_53923,done);
var state_54055__$1 = (function (){var statearr_54061 = state_54055;
(statearr_54061[(11)] = inst_54003__$1);

return statearr_54061;
})();
if(cljs.core.truth_(inst_54004)){
var statearr_54062_54147 = state_54055__$1;
(statearr_54062_54147[(1)] = (30));

} else {
var statearr_54063_54148 = state_54055__$1;
(statearr_54063_54148[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (1))){
var state_54055__$1 = state_54055;
var statearr_54064_54149 = state_54055__$1;
(statearr_54064_54149[(2)] = null);

(statearr_54064_54149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (24))){
var inst_53954 = (state_54055[(7)]);
var inst_53973 = (state_54055[(2)]);
var inst_53974 = cljs.core.next.call(null,inst_53954);
var inst_53932 = inst_53974;
var inst_53933 = null;
var inst_53934 = (0);
var inst_53935 = (0);
var state_54055__$1 = (function (){var statearr_54065 = state_54055;
(statearr_54065[(13)] = inst_53932);

(statearr_54065[(14)] = inst_53935);

(statearr_54065[(15)] = inst_53973);

(statearr_54065[(16)] = inst_53933);

(statearr_54065[(17)] = inst_53934);

return statearr_54065;
})();
var statearr_54066_54150 = state_54055__$1;
(statearr_54066_54150[(2)] = null);

(statearr_54066_54150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (39))){
var state_54055__$1 = state_54055;
var statearr_54070_54151 = state_54055__$1;
(statearr_54070_54151[(2)] = null);

(statearr_54070_54151[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (4))){
var inst_53923 = (state_54055[(10)]);
var inst_53923__$1 = (state_54055[(2)]);
var inst_53924 = (inst_53923__$1 == null);
var state_54055__$1 = (function (){var statearr_54071 = state_54055;
(statearr_54071[(10)] = inst_53923__$1);

return statearr_54071;
})();
if(cljs.core.truth_(inst_53924)){
var statearr_54072_54152 = state_54055__$1;
(statearr_54072_54152[(1)] = (5));

} else {
var statearr_54073_54153 = state_54055__$1;
(statearr_54073_54153[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (15))){
var inst_53932 = (state_54055[(13)]);
var inst_53935 = (state_54055[(14)]);
var inst_53933 = (state_54055[(16)]);
var inst_53934 = (state_54055[(17)]);
var inst_53950 = (state_54055[(2)]);
var inst_53951 = (inst_53935 + (1));
var tmp54067 = inst_53932;
var tmp54068 = inst_53933;
var tmp54069 = inst_53934;
var inst_53932__$1 = tmp54067;
var inst_53933__$1 = tmp54068;
var inst_53934__$1 = tmp54069;
var inst_53935__$1 = inst_53951;
var state_54055__$1 = (function (){var statearr_54074 = state_54055;
(statearr_54074[(13)] = inst_53932__$1);

(statearr_54074[(14)] = inst_53935__$1);

(statearr_54074[(18)] = inst_53950);

(statearr_54074[(16)] = inst_53933__$1);

(statearr_54074[(17)] = inst_53934__$1);

return statearr_54074;
})();
var statearr_54075_54154 = state_54055__$1;
(statearr_54075_54154[(2)] = null);

(statearr_54075_54154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (21))){
var inst_53977 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54079_54155 = state_54055__$1;
(statearr_54079_54155[(2)] = inst_53977);

(statearr_54079_54155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (31))){
var inst_54003 = (state_54055[(11)]);
var inst_54007 = done.call(null,null);
var inst_54008 = cljs.core.async.untap_STAR_.call(null,m,inst_54003);
var state_54055__$1 = (function (){var statearr_54080 = state_54055;
(statearr_54080[(19)] = inst_54007);

return statearr_54080;
})();
var statearr_54081_54156 = state_54055__$1;
(statearr_54081_54156[(2)] = inst_54008);

(statearr_54081_54156[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (32))){
var inst_53998 = (state_54055[(9)]);
var inst_53995 = (state_54055[(20)]);
var inst_53997 = (state_54055[(21)]);
var inst_53996 = (state_54055[(12)]);
var inst_54010 = (state_54055[(2)]);
var inst_54011 = (inst_53998 + (1));
var tmp54076 = inst_53995;
var tmp54077 = inst_53997;
var tmp54078 = inst_53996;
var inst_53995__$1 = tmp54076;
var inst_53996__$1 = tmp54078;
var inst_53997__$1 = tmp54077;
var inst_53998__$1 = inst_54011;
var state_54055__$1 = (function (){var statearr_54082 = state_54055;
(statearr_54082[(9)] = inst_53998__$1);

(statearr_54082[(22)] = inst_54010);

(statearr_54082[(20)] = inst_53995__$1);

(statearr_54082[(21)] = inst_53997__$1);

(statearr_54082[(12)] = inst_53996__$1);

return statearr_54082;
})();
var statearr_54083_54157 = state_54055__$1;
(statearr_54083_54157[(2)] = null);

(statearr_54083_54157[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (40))){
var inst_54023 = (state_54055[(23)]);
var inst_54027 = done.call(null,null);
var inst_54028 = cljs.core.async.untap_STAR_.call(null,m,inst_54023);
var state_54055__$1 = (function (){var statearr_54084 = state_54055;
(statearr_54084[(24)] = inst_54027);

return statearr_54084;
})();
var statearr_54085_54158 = state_54055__$1;
(statearr_54085_54158[(2)] = inst_54028);

(statearr_54085_54158[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (33))){
var inst_54014 = (state_54055[(25)]);
var inst_54016 = cljs.core.chunked_seq_QMARK_.call(null,inst_54014);
var state_54055__$1 = state_54055;
if(inst_54016){
var statearr_54086_54159 = state_54055__$1;
(statearr_54086_54159[(1)] = (36));

} else {
var statearr_54087_54160 = state_54055__$1;
(statearr_54087_54160[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (13))){
var inst_53944 = (state_54055[(26)]);
var inst_53947 = cljs.core.async.close_BANG_.call(null,inst_53944);
var state_54055__$1 = state_54055;
var statearr_54088_54161 = state_54055__$1;
(statearr_54088_54161[(2)] = inst_53947);

(statearr_54088_54161[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (22))){
var inst_53967 = (state_54055[(8)]);
var inst_53970 = cljs.core.async.close_BANG_.call(null,inst_53967);
var state_54055__$1 = state_54055;
var statearr_54089_54162 = state_54055__$1;
(statearr_54089_54162[(2)] = inst_53970);

(statearr_54089_54162[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (36))){
var inst_54014 = (state_54055[(25)]);
var inst_54018 = cljs.core.chunk_first.call(null,inst_54014);
var inst_54019 = cljs.core.chunk_rest.call(null,inst_54014);
var inst_54020 = cljs.core.count.call(null,inst_54018);
var inst_53995 = inst_54019;
var inst_53996 = inst_54018;
var inst_53997 = inst_54020;
var inst_53998 = (0);
var state_54055__$1 = (function (){var statearr_54090 = state_54055;
(statearr_54090[(9)] = inst_53998);

(statearr_54090[(20)] = inst_53995);

(statearr_54090[(21)] = inst_53997);

(statearr_54090[(12)] = inst_53996);

return statearr_54090;
})();
var statearr_54091_54163 = state_54055__$1;
(statearr_54091_54163[(2)] = null);

(statearr_54091_54163[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (41))){
var inst_54014 = (state_54055[(25)]);
var inst_54030 = (state_54055[(2)]);
var inst_54031 = cljs.core.next.call(null,inst_54014);
var inst_53995 = inst_54031;
var inst_53996 = null;
var inst_53997 = (0);
var inst_53998 = (0);
var state_54055__$1 = (function (){var statearr_54092 = state_54055;
(statearr_54092[(27)] = inst_54030);

(statearr_54092[(9)] = inst_53998);

(statearr_54092[(20)] = inst_53995);

(statearr_54092[(21)] = inst_53997);

(statearr_54092[(12)] = inst_53996);

return statearr_54092;
})();
var statearr_54093_54164 = state_54055__$1;
(statearr_54093_54164[(2)] = null);

(statearr_54093_54164[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (43))){
var state_54055__$1 = state_54055;
var statearr_54094_54165 = state_54055__$1;
(statearr_54094_54165[(2)] = null);

(statearr_54094_54165[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (29))){
var inst_54039 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54095_54166 = state_54055__$1;
(statearr_54095_54166[(2)] = inst_54039);

(statearr_54095_54166[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (44))){
var inst_54048 = (state_54055[(2)]);
var state_54055__$1 = (function (){var statearr_54096 = state_54055;
(statearr_54096[(28)] = inst_54048);

return statearr_54096;
})();
var statearr_54097_54167 = state_54055__$1;
(statearr_54097_54167[(2)] = null);

(statearr_54097_54167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (6))){
var inst_53987 = (state_54055[(29)]);
var inst_53986 = cljs.core.deref.call(null,cs);
var inst_53987__$1 = cljs.core.keys.call(null,inst_53986);
var inst_53988 = cljs.core.count.call(null,inst_53987__$1);
var inst_53989 = cljs.core.reset_BANG_.call(null,dctr,inst_53988);
var inst_53994 = cljs.core.seq.call(null,inst_53987__$1);
var inst_53995 = inst_53994;
var inst_53996 = null;
var inst_53997 = (0);
var inst_53998 = (0);
var state_54055__$1 = (function (){var statearr_54098 = state_54055;
(statearr_54098[(9)] = inst_53998);

(statearr_54098[(30)] = inst_53989);

(statearr_54098[(20)] = inst_53995);

(statearr_54098[(29)] = inst_53987__$1);

(statearr_54098[(21)] = inst_53997);

(statearr_54098[(12)] = inst_53996);

return statearr_54098;
})();
var statearr_54099_54168 = state_54055__$1;
(statearr_54099_54168[(2)] = null);

(statearr_54099_54168[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (28))){
var inst_53995 = (state_54055[(20)]);
var inst_54014 = (state_54055[(25)]);
var inst_54014__$1 = cljs.core.seq.call(null,inst_53995);
var state_54055__$1 = (function (){var statearr_54100 = state_54055;
(statearr_54100[(25)] = inst_54014__$1);

return statearr_54100;
})();
if(inst_54014__$1){
var statearr_54101_54169 = state_54055__$1;
(statearr_54101_54169[(1)] = (33));

} else {
var statearr_54102_54170 = state_54055__$1;
(statearr_54102_54170[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (25))){
var inst_53998 = (state_54055[(9)]);
var inst_53997 = (state_54055[(21)]);
var inst_54000 = (inst_53998 < inst_53997);
var inst_54001 = inst_54000;
var state_54055__$1 = state_54055;
if(cljs.core.truth_(inst_54001)){
var statearr_54103_54171 = state_54055__$1;
(statearr_54103_54171[(1)] = (27));

} else {
var statearr_54104_54172 = state_54055__$1;
(statearr_54104_54172[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (34))){
var state_54055__$1 = state_54055;
var statearr_54105_54173 = state_54055__$1;
(statearr_54105_54173[(2)] = null);

(statearr_54105_54173[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (17))){
var state_54055__$1 = state_54055;
var statearr_54106_54174 = state_54055__$1;
(statearr_54106_54174[(2)] = null);

(statearr_54106_54174[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (3))){
var inst_54053 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54055__$1,inst_54053);
} else {
if((state_val_54056 === (12))){
var inst_53982 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54107_54175 = state_54055__$1;
(statearr_54107_54175[(2)] = inst_53982);

(statearr_54107_54175[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (2))){
var state_54055__$1 = state_54055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54055__$1,(4),ch);
} else {
if((state_val_54056 === (23))){
var state_54055__$1 = state_54055;
var statearr_54108_54176 = state_54055__$1;
(statearr_54108_54176[(2)] = null);

(statearr_54108_54176[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (35))){
var inst_54037 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54109_54177 = state_54055__$1;
(statearr_54109_54177[(2)] = inst_54037);

(statearr_54109_54177[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (19))){
var inst_53954 = (state_54055[(7)]);
var inst_53958 = cljs.core.chunk_first.call(null,inst_53954);
var inst_53959 = cljs.core.chunk_rest.call(null,inst_53954);
var inst_53960 = cljs.core.count.call(null,inst_53958);
var inst_53932 = inst_53959;
var inst_53933 = inst_53958;
var inst_53934 = inst_53960;
var inst_53935 = (0);
var state_54055__$1 = (function (){var statearr_54110 = state_54055;
(statearr_54110[(13)] = inst_53932);

(statearr_54110[(14)] = inst_53935);

(statearr_54110[(16)] = inst_53933);

(statearr_54110[(17)] = inst_53934);

return statearr_54110;
})();
var statearr_54111_54178 = state_54055__$1;
(statearr_54111_54178[(2)] = null);

(statearr_54111_54178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (11))){
var inst_53932 = (state_54055[(13)]);
var inst_53954 = (state_54055[(7)]);
var inst_53954__$1 = cljs.core.seq.call(null,inst_53932);
var state_54055__$1 = (function (){var statearr_54112 = state_54055;
(statearr_54112[(7)] = inst_53954__$1);

return statearr_54112;
})();
if(inst_53954__$1){
var statearr_54113_54179 = state_54055__$1;
(statearr_54113_54179[(1)] = (16));

} else {
var statearr_54114_54180 = state_54055__$1;
(statearr_54114_54180[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (9))){
var inst_53984 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54115_54181 = state_54055__$1;
(statearr_54115_54181[(2)] = inst_53984);

(statearr_54115_54181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (5))){
var inst_53930 = cljs.core.deref.call(null,cs);
var inst_53931 = cljs.core.seq.call(null,inst_53930);
var inst_53932 = inst_53931;
var inst_53933 = null;
var inst_53934 = (0);
var inst_53935 = (0);
var state_54055__$1 = (function (){var statearr_54116 = state_54055;
(statearr_54116[(13)] = inst_53932);

(statearr_54116[(14)] = inst_53935);

(statearr_54116[(16)] = inst_53933);

(statearr_54116[(17)] = inst_53934);

return statearr_54116;
})();
var statearr_54117_54182 = state_54055__$1;
(statearr_54117_54182[(2)] = null);

(statearr_54117_54182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (14))){
var state_54055__$1 = state_54055;
var statearr_54118_54183 = state_54055__$1;
(statearr_54118_54183[(2)] = null);

(statearr_54118_54183[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (45))){
var inst_54045 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54119_54184 = state_54055__$1;
(statearr_54119_54184[(2)] = inst_54045);

(statearr_54119_54184[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (26))){
var inst_53987 = (state_54055[(29)]);
var inst_54041 = (state_54055[(2)]);
var inst_54042 = cljs.core.seq.call(null,inst_53987);
var state_54055__$1 = (function (){var statearr_54120 = state_54055;
(statearr_54120[(31)] = inst_54041);

return statearr_54120;
})();
if(inst_54042){
var statearr_54121_54185 = state_54055__$1;
(statearr_54121_54185[(1)] = (42));

} else {
var statearr_54122_54186 = state_54055__$1;
(statearr_54122_54186[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (16))){
var inst_53954 = (state_54055[(7)]);
var inst_53956 = cljs.core.chunked_seq_QMARK_.call(null,inst_53954);
var state_54055__$1 = state_54055;
if(inst_53956){
var statearr_54123_54187 = state_54055__$1;
(statearr_54123_54187[(1)] = (19));

} else {
var statearr_54124_54188 = state_54055__$1;
(statearr_54124_54188[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (38))){
var inst_54034 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54125_54189 = state_54055__$1;
(statearr_54125_54189[(2)] = inst_54034);

(statearr_54125_54189[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (30))){
var state_54055__$1 = state_54055;
var statearr_54126_54190 = state_54055__$1;
(statearr_54126_54190[(2)] = null);

(statearr_54126_54190[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (10))){
var inst_53935 = (state_54055[(14)]);
var inst_53933 = (state_54055[(16)]);
var inst_53943 = cljs.core._nth.call(null,inst_53933,inst_53935);
var inst_53944 = cljs.core.nth.call(null,inst_53943,(0),null);
var inst_53945 = cljs.core.nth.call(null,inst_53943,(1),null);
var state_54055__$1 = (function (){var statearr_54127 = state_54055;
(statearr_54127[(26)] = inst_53944);

return statearr_54127;
})();
if(cljs.core.truth_(inst_53945)){
var statearr_54128_54191 = state_54055__$1;
(statearr_54128_54191[(1)] = (13));

} else {
var statearr_54129_54192 = state_54055__$1;
(statearr_54129_54192[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (18))){
var inst_53980 = (state_54055[(2)]);
var state_54055__$1 = state_54055;
var statearr_54130_54193 = state_54055__$1;
(statearr_54130_54193[(2)] = inst_53980);

(statearr_54130_54193[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (42))){
var state_54055__$1 = state_54055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54055__$1,(45),dchan);
} else {
if((state_val_54056 === (37))){
var inst_54023 = (state_54055[(23)]);
var inst_53923 = (state_54055[(10)]);
var inst_54014 = (state_54055[(25)]);
var inst_54023__$1 = cljs.core.first.call(null,inst_54014);
var inst_54024 = cljs.core.async.put_BANG_.call(null,inst_54023__$1,inst_53923,done);
var state_54055__$1 = (function (){var statearr_54131 = state_54055;
(statearr_54131[(23)] = inst_54023__$1);

return statearr_54131;
})();
if(cljs.core.truth_(inst_54024)){
var statearr_54132_54194 = state_54055__$1;
(statearr_54132_54194[(1)] = (39));

} else {
var statearr_54133_54195 = state_54055__$1;
(statearr_54133_54195[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54056 === (8))){
var inst_53935 = (state_54055[(14)]);
var inst_53934 = (state_54055[(17)]);
var inst_53937 = (inst_53935 < inst_53934);
var inst_53938 = inst_53937;
var state_54055__$1 = state_54055;
if(cljs.core.truth_(inst_53938)){
var statearr_54134_54196 = state_54055__$1;
(statearr_54134_54196[(1)] = (10));

} else {
var statearr_54135_54197 = state_54055__$1;
(statearr_54135_54197[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___54143,cs,m,dchan,dctr,done))
;
return ((function (switch__52692__auto__,c__52806__auto___54143,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__52693__auto__ = null;
var cljs$core$async$mult_$_state_machine__52693__auto____0 = (function (){
var statearr_54139 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54139[(0)] = cljs$core$async$mult_$_state_machine__52693__auto__);

(statearr_54139[(1)] = (1));

return statearr_54139;
});
var cljs$core$async$mult_$_state_machine__52693__auto____1 = (function (state_54055){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_54055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e54140){if((e54140 instanceof Object)){
var ex__52696__auto__ = e54140;
var statearr_54141_54198 = state_54055;
(statearr_54141_54198[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54055);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54140;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54199 = state_54055;
state_54055 = G__54199;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__52693__auto__ = function(state_54055){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__52693__auto____1.call(this,state_54055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__52693__auto____0;
cljs$core$async$mult_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__52693__auto____1;
return cljs$core$async$mult_$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___54143,cs,m,dchan,dctr,done))
})();
var state__52808__auto__ = (function (){var statearr_54142 = f__52807__auto__.call(null);
(statearr_54142[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___54143);

return statearr_54142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___54143,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args54200 = [];
var len__51068__auto___54203 = arguments.length;
var i__51069__auto___54204 = (0);
while(true){
if((i__51069__auto___54204 < len__51068__auto___54203)){
args54200.push((arguments[i__51069__auto___54204]));

var G__54205 = (i__51069__auto___54204 + (1));
i__51069__auto___54204 = G__54205;
continue;
} else {
}
break;
}

var G__54202 = args54200.length;
switch (G__54202) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54200.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m,ch);
} else {
var m__50566__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m,ch);
} else {
var m__50566__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m);
} else {
var m__50566__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m,state_map);
} else {
var m__50566__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__50565__auto__ = (((m == null))?null:m);
var m__50566__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,m,mode);
} else {
var m__50566__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__51075__auto__ = [];
var len__51068__auto___54217 = arguments.length;
var i__51069__auto___54218 = (0);
while(true){
if((i__51069__auto___54218 < len__51068__auto___54217)){
args__51075__auto__.push((arguments[i__51069__auto___54218]));

var G__54219 = (i__51069__auto___54218 + (1));
i__51069__auto___54218 = G__54219;
continue;
} else {
}
break;
}

var argseq__51076__auto__ = ((((3) < args__51075__auto__.length))?(new cljs.core.IndexedSeq(args__51075__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__51076__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__54211){
var map__54212 = p__54211;
var map__54212__$1 = ((((!((map__54212 == null)))?((((map__54212.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54212.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54212):map__54212);
var opts = map__54212__$1;
var statearr_54214_54220 = state;
(statearr_54214_54220[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__54212,map__54212__$1,opts){
return (function (val){
var statearr_54215_54221 = state;
(statearr_54215_54221[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__54212,map__54212__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_54216_54222 = state;
(statearr_54216_54222[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq54207){
var G__54208 = cljs.core.first.call(null,seq54207);
var seq54207__$1 = cljs.core.next.call(null,seq54207);
var G__54209 = cljs.core.first.call(null,seq54207__$1);
var seq54207__$2 = cljs.core.next.call(null,seq54207__$1);
var G__54210 = cljs.core.first.call(null,seq54207__$2);
var seq54207__$3 = cljs.core.next.call(null,seq54207__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__54208,G__54209,G__54210,seq54207__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async54390 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54390 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta54391){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta54391 = meta54391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_54392,meta54391__$1){
var self__ = this;
var _54392__$1 = this;
return (new cljs.core.async.t_cljs$core$async54390(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta54391__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_54392){
var self__ = this;
var _54392__$1 = this;
return self__.meta54391;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta54391","meta54391",882318813,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async54390.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54390.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54390";

cljs.core.async.t_cljs$core$async54390.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async54390");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async54390 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async54390(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta54391){
return (new cljs.core.async.t_cljs$core$async54390(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta54391));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async54390(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__52806__auto___54557 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___54557,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___54557,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_54494){
var state_val_54495 = (state_54494[(1)]);
if((state_val_54495 === (7))){
var inst_54409 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54496_54558 = state_54494__$1;
(statearr_54496_54558[(2)] = inst_54409);

(statearr_54496_54558[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (20))){
var inst_54421 = (state_54494[(7)]);
var state_54494__$1 = state_54494;
var statearr_54497_54559 = state_54494__$1;
(statearr_54497_54559[(2)] = inst_54421);

(statearr_54497_54559[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (27))){
var state_54494__$1 = state_54494;
var statearr_54498_54560 = state_54494__$1;
(statearr_54498_54560[(2)] = null);

(statearr_54498_54560[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (1))){
var inst_54396 = (state_54494[(8)]);
var inst_54396__$1 = calc_state.call(null);
var inst_54398 = (inst_54396__$1 == null);
var inst_54399 = cljs.core.not.call(null,inst_54398);
var state_54494__$1 = (function (){var statearr_54499 = state_54494;
(statearr_54499[(8)] = inst_54396__$1);

return statearr_54499;
})();
if(inst_54399){
var statearr_54500_54561 = state_54494__$1;
(statearr_54500_54561[(1)] = (2));

} else {
var statearr_54501_54562 = state_54494__$1;
(statearr_54501_54562[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (24))){
var inst_54468 = (state_54494[(9)]);
var inst_54454 = (state_54494[(10)]);
var inst_54445 = (state_54494[(11)]);
var inst_54468__$1 = inst_54445.call(null,inst_54454);
var state_54494__$1 = (function (){var statearr_54502 = state_54494;
(statearr_54502[(9)] = inst_54468__$1);

return statearr_54502;
})();
if(cljs.core.truth_(inst_54468__$1)){
var statearr_54503_54563 = state_54494__$1;
(statearr_54503_54563[(1)] = (29));

} else {
var statearr_54504_54564 = state_54494__$1;
(statearr_54504_54564[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (4))){
var inst_54412 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54412)){
var statearr_54505_54565 = state_54494__$1;
(statearr_54505_54565[(1)] = (8));

} else {
var statearr_54506_54566 = state_54494__$1;
(statearr_54506_54566[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (15))){
var inst_54439 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54439)){
var statearr_54507_54567 = state_54494__$1;
(statearr_54507_54567[(1)] = (19));

} else {
var statearr_54508_54568 = state_54494__$1;
(statearr_54508_54568[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (21))){
var inst_54444 = (state_54494[(12)]);
var inst_54444__$1 = (state_54494[(2)]);
var inst_54445 = cljs.core.get.call(null,inst_54444__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_54446 = cljs.core.get.call(null,inst_54444__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_54447 = cljs.core.get.call(null,inst_54444__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_54494__$1 = (function (){var statearr_54509 = state_54494;
(statearr_54509[(11)] = inst_54445);

(statearr_54509[(12)] = inst_54444__$1);

(statearr_54509[(13)] = inst_54446);

return statearr_54509;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54494__$1,(22),inst_54447);
} else {
if((state_val_54495 === (31))){
var inst_54476 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54476)){
var statearr_54510_54569 = state_54494__$1;
(statearr_54510_54569[(1)] = (32));

} else {
var statearr_54511_54570 = state_54494__$1;
(statearr_54511_54570[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (32))){
var inst_54453 = (state_54494[(14)]);
var state_54494__$1 = state_54494;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54494__$1,(35),out,inst_54453);
} else {
if((state_val_54495 === (33))){
var inst_54444 = (state_54494[(12)]);
var inst_54421 = inst_54444;
var state_54494__$1 = (function (){var statearr_54512 = state_54494;
(statearr_54512[(7)] = inst_54421);

return statearr_54512;
})();
var statearr_54513_54571 = state_54494__$1;
(statearr_54513_54571[(2)] = null);

(statearr_54513_54571[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (13))){
var inst_54421 = (state_54494[(7)]);
var inst_54428 = inst_54421.cljs$lang$protocol_mask$partition0$;
var inst_54429 = (inst_54428 & (64));
var inst_54430 = inst_54421.cljs$core$ISeq$;
var inst_54431 = (cljs.core.PROTOCOL_SENTINEL === inst_54430);
var inst_54432 = (inst_54429) || (inst_54431);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54432)){
var statearr_54514_54572 = state_54494__$1;
(statearr_54514_54572[(1)] = (16));

} else {
var statearr_54515_54573 = state_54494__$1;
(statearr_54515_54573[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (22))){
var inst_54454 = (state_54494[(10)]);
var inst_54453 = (state_54494[(14)]);
var inst_54452 = (state_54494[(2)]);
var inst_54453__$1 = cljs.core.nth.call(null,inst_54452,(0),null);
var inst_54454__$1 = cljs.core.nth.call(null,inst_54452,(1),null);
var inst_54455 = (inst_54453__$1 == null);
var inst_54456 = cljs.core._EQ_.call(null,inst_54454__$1,change);
var inst_54457 = (inst_54455) || (inst_54456);
var state_54494__$1 = (function (){var statearr_54516 = state_54494;
(statearr_54516[(10)] = inst_54454__$1);

(statearr_54516[(14)] = inst_54453__$1);

return statearr_54516;
})();
if(cljs.core.truth_(inst_54457)){
var statearr_54517_54574 = state_54494__$1;
(statearr_54517_54574[(1)] = (23));

} else {
var statearr_54518_54575 = state_54494__$1;
(statearr_54518_54575[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (36))){
var inst_54444 = (state_54494[(12)]);
var inst_54421 = inst_54444;
var state_54494__$1 = (function (){var statearr_54519 = state_54494;
(statearr_54519[(7)] = inst_54421);

return statearr_54519;
})();
var statearr_54520_54576 = state_54494__$1;
(statearr_54520_54576[(2)] = null);

(statearr_54520_54576[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (29))){
var inst_54468 = (state_54494[(9)]);
var state_54494__$1 = state_54494;
var statearr_54521_54577 = state_54494__$1;
(statearr_54521_54577[(2)] = inst_54468);

(statearr_54521_54577[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (6))){
var state_54494__$1 = state_54494;
var statearr_54522_54578 = state_54494__$1;
(statearr_54522_54578[(2)] = false);

(statearr_54522_54578[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (28))){
var inst_54464 = (state_54494[(2)]);
var inst_54465 = calc_state.call(null);
var inst_54421 = inst_54465;
var state_54494__$1 = (function (){var statearr_54523 = state_54494;
(statearr_54523[(15)] = inst_54464);

(statearr_54523[(7)] = inst_54421);

return statearr_54523;
})();
var statearr_54524_54579 = state_54494__$1;
(statearr_54524_54579[(2)] = null);

(statearr_54524_54579[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (25))){
var inst_54490 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54525_54580 = state_54494__$1;
(statearr_54525_54580[(2)] = inst_54490);

(statearr_54525_54580[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (34))){
var inst_54488 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54526_54581 = state_54494__$1;
(statearr_54526_54581[(2)] = inst_54488);

(statearr_54526_54581[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (17))){
var state_54494__$1 = state_54494;
var statearr_54527_54582 = state_54494__$1;
(statearr_54527_54582[(2)] = false);

(statearr_54527_54582[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (3))){
var state_54494__$1 = state_54494;
var statearr_54528_54583 = state_54494__$1;
(statearr_54528_54583[(2)] = false);

(statearr_54528_54583[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (12))){
var inst_54492 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54494__$1,inst_54492);
} else {
if((state_val_54495 === (2))){
var inst_54396 = (state_54494[(8)]);
var inst_54401 = inst_54396.cljs$lang$protocol_mask$partition0$;
var inst_54402 = (inst_54401 & (64));
var inst_54403 = inst_54396.cljs$core$ISeq$;
var inst_54404 = (cljs.core.PROTOCOL_SENTINEL === inst_54403);
var inst_54405 = (inst_54402) || (inst_54404);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54405)){
var statearr_54529_54584 = state_54494__$1;
(statearr_54529_54584[(1)] = (5));

} else {
var statearr_54530_54585 = state_54494__$1;
(statearr_54530_54585[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (23))){
var inst_54453 = (state_54494[(14)]);
var inst_54459 = (inst_54453 == null);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54459)){
var statearr_54531_54586 = state_54494__$1;
(statearr_54531_54586[(1)] = (26));

} else {
var statearr_54532_54587 = state_54494__$1;
(statearr_54532_54587[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (35))){
var inst_54479 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54479)){
var statearr_54533_54588 = state_54494__$1;
(statearr_54533_54588[(1)] = (36));

} else {
var statearr_54534_54589 = state_54494__$1;
(statearr_54534_54589[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (19))){
var inst_54421 = (state_54494[(7)]);
var inst_54441 = cljs.core.apply.call(null,cljs.core.hash_map,inst_54421);
var state_54494__$1 = state_54494;
var statearr_54535_54590 = state_54494__$1;
(statearr_54535_54590[(2)] = inst_54441);

(statearr_54535_54590[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (11))){
var inst_54421 = (state_54494[(7)]);
var inst_54425 = (inst_54421 == null);
var inst_54426 = cljs.core.not.call(null,inst_54425);
var state_54494__$1 = state_54494;
if(inst_54426){
var statearr_54536_54591 = state_54494__$1;
(statearr_54536_54591[(1)] = (13));

} else {
var statearr_54537_54592 = state_54494__$1;
(statearr_54537_54592[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (9))){
var inst_54396 = (state_54494[(8)]);
var state_54494__$1 = state_54494;
var statearr_54538_54593 = state_54494__$1;
(statearr_54538_54593[(2)] = inst_54396);

(statearr_54538_54593[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (5))){
var state_54494__$1 = state_54494;
var statearr_54539_54594 = state_54494__$1;
(statearr_54539_54594[(2)] = true);

(statearr_54539_54594[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (14))){
var state_54494__$1 = state_54494;
var statearr_54540_54595 = state_54494__$1;
(statearr_54540_54595[(2)] = false);

(statearr_54540_54595[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (26))){
var inst_54454 = (state_54494[(10)]);
var inst_54461 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_54454);
var state_54494__$1 = state_54494;
var statearr_54541_54596 = state_54494__$1;
(statearr_54541_54596[(2)] = inst_54461);

(statearr_54541_54596[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (16))){
var state_54494__$1 = state_54494;
var statearr_54542_54597 = state_54494__$1;
(statearr_54542_54597[(2)] = true);

(statearr_54542_54597[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (38))){
var inst_54484 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54543_54598 = state_54494__$1;
(statearr_54543_54598[(2)] = inst_54484);

(statearr_54543_54598[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (30))){
var inst_54454 = (state_54494[(10)]);
var inst_54445 = (state_54494[(11)]);
var inst_54446 = (state_54494[(13)]);
var inst_54471 = cljs.core.empty_QMARK_.call(null,inst_54445);
var inst_54472 = inst_54446.call(null,inst_54454);
var inst_54473 = cljs.core.not.call(null,inst_54472);
var inst_54474 = (inst_54471) && (inst_54473);
var state_54494__$1 = state_54494;
var statearr_54544_54599 = state_54494__$1;
(statearr_54544_54599[(2)] = inst_54474);

(statearr_54544_54599[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (10))){
var inst_54396 = (state_54494[(8)]);
var inst_54417 = (state_54494[(2)]);
var inst_54418 = cljs.core.get.call(null,inst_54417,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_54419 = cljs.core.get.call(null,inst_54417,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_54420 = cljs.core.get.call(null,inst_54417,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_54421 = inst_54396;
var state_54494__$1 = (function (){var statearr_54545 = state_54494;
(statearr_54545[(16)] = inst_54418);

(statearr_54545[(17)] = inst_54419);

(statearr_54545[(7)] = inst_54421);

(statearr_54545[(18)] = inst_54420);

return statearr_54545;
})();
var statearr_54546_54600 = state_54494__$1;
(statearr_54546_54600[(2)] = null);

(statearr_54546_54600[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (18))){
var inst_54436 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54547_54601 = state_54494__$1;
(statearr_54547_54601[(2)] = inst_54436);

(statearr_54547_54601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (37))){
var state_54494__$1 = state_54494;
var statearr_54548_54602 = state_54494__$1;
(statearr_54548_54602[(2)] = null);

(statearr_54548_54602[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (8))){
var inst_54396 = (state_54494[(8)]);
var inst_54414 = cljs.core.apply.call(null,cljs.core.hash_map,inst_54396);
var state_54494__$1 = state_54494;
var statearr_54549_54603 = state_54494__$1;
(statearr_54549_54603[(2)] = inst_54414);

(statearr_54549_54603[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___54557,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__52692__auto__,c__52806__auto___54557,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__52693__auto__ = null;
var cljs$core$async$mix_$_state_machine__52693__auto____0 = (function (){
var statearr_54553 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54553[(0)] = cljs$core$async$mix_$_state_machine__52693__auto__);

(statearr_54553[(1)] = (1));

return statearr_54553;
});
var cljs$core$async$mix_$_state_machine__52693__auto____1 = (function (state_54494){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_54494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e54554){if((e54554 instanceof Object)){
var ex__52696__auto__ = e54554;
var statearr_54555_54604 = state_54494;
(statearr_54555_54604[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54494);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54554;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54605 = state_54494;
state_54494 = G__54605;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__52693__auto__ = function(state_54494){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__52693__auto____1.call(this,state_54494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__52693__auto____0;
cljs$core$async$mix_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__52693__auto____1;
return cljs$core$async$mix_$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___54557,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__52808__auto__ = (function (){var statearr_54556 = f__52807__auto__.call(null);
(statearr_54556[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___54557);

return statearr_54556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___54557,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__50565__auto__ = (((p == null))?null:p);
var m__50566__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__50566__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__50565__auto__ = (((p == null))?null:p);
var m__50566__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,p,v,ch);
} else {
var m__50566__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args54606 = [];
var len__51068__auto___54609 = arguments.length;
var i__51069__auto___54610 = (0);
while(true){
if((i__51069__auto___54610 < len__51068__auto___54609)){
args54606.push((arguments[i__51069__auto___54610]));

var G__54611 = (i__51069__auto___54610 + (1));
i__51069__auto___54610 = G__54611;
continue;
} else {
}
break;
}

var G__54608 = args54606.length;
switch (G__54608) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54606.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__50565__auto__ = (((p == null))?null:p);
var m__50566__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,p);
} else {
var m__50566__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__50565__auto__ = (((p == null))?null:p);
var m__50566__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,p,v);
} else {
var m__50566__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args54614 = [];
var len__51068__auto___54739 = arguments.length;
var i__51069__auto___54740 = (0);
while(true){
if((i__51069__auto___54740 < len__51068__auto___54739)){
args54614.push((arguments[i__51069__auto___54740]));

var G__54741 = (i__51069__auto___54740 + (1));
i__51069__auto___54740 = G__54741;
continue;
} else {
}
break;
}

var G__54616 = args54614.length;
switch (G__54616) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54614.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__49852__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__49852__auto__)){
return or__49852__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__49852__auto__,mults){
return (function (p1__54613_SHARP_){
if(cljs.core.truth_(p1__54613_SHARP_.call(null,topic))){
return p1__54613_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__54613_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__49852__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async54617 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54617 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta54618){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta54618 = meta54618;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_54619,meta54618__$1){
var self__ = this;
var _54619__$1 = this;
return (new cljs.core.async.t_cljs$core$async54617(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta54618__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_54619){
var self__ = this;
var _54619__$1 = this;
return self__.meta54618;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta54618","meta54618",174417680,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async54617.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async54617.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54617";

cljs.core.async.t_cljs$core$async54617.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async54617");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async54617 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async54617(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta54618){
return (new cljs.core.async.t_cljs$core$async54617(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta54618));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async54617(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__52806__auto___54743 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___54743,mults,ensure_mult,p){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___54743,mults,ensure_mult,p){
return (function (state_54691){
var state_val_54692 = (state_54691[(1)]);
if((state_val_54692 === (7))){
var inst_54687 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
var statearr_54693_54744 = state_54691__$1;
(statearr_54693_54744[(2)] = inst_54687);

(statearr_54693_54744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (20))){
var state_54691__$1 = state_54691;
var statearr_54694_54745 = state_54691__$1;
(statearr_54694_54745[(2)] = null);

(statearr_54694_54745[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (1))){
var state_54691__$1 = state_54691;
var statearr_54695_54746 = state_54691__$1;
(statearr_54695_54746[(2)] = null);

(statearr_54695_54746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (24))){
var inst_54670 = (state_54691[(7)]);
var inst_54679 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_54670);
var state_54691__$1 = state_54691;
var statearr_54696_54747 = state_54691__$1;
(statearr_54696_54747[(2)] = inst_54679);

(statearr_54696_54747[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (4))){
var inst_54622 = (state_54691[(8)]);
var inst_54622__$1 = (state_54691[(2)]);
var inst_54623 = (inst_54622__$1 == null);
var state_54691__$1 = (function (){var statearr_54697 = state_54691;
(statearr_54697[(8)] = inst_54622__$1);

return statearr_54697;
})();
if(cljs.core.truth_(inst_54623)){
var statearr_54698_54748 = state_54691__$1;
(statearr_54698_54748[(1)] = (5));

} else {
var statearr_54699_54749 = state_54691__$1;
(statearr_54699_54749[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (15))){
var inst_54664 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
var statearr_54700_54750 = state_54691__$1;
(statearr_54700_54750[(2)] = inst_54664);

(statearr_54700_54750[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (21))){
var inst_54684 = (state_54691[(2)]);
var state_54691__$1 = (function (){var statearr_54701 = state_54691;
(statearr_54701[(9)] = inst_54684);

return statearr_54701;
})();
var statearr_54702_54751 = state_54691__$1;
(statearr_54702_54751[(2)] = null);

(statearr_54702_54751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (13))){
var inst_54646 = (state_54691[(10)]);
var inst_54648 = cljs.core.chunked_seq_QMARK_.call(null,inst_54646);
var state_54691__$1 = state_54691;
if(inst_54648){
var statearr_54703_54752 = state_54691__$1;
(statearr_54703_54752[(1)] = (16));

} else {
var statearr_54704_54753 = state_54691__$1;
(statearr_54704_54753[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (22))){
var inst_54676 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
if(cljs.core.truth_(inst_54676)){
var statearr_54705_54754 = state_54691__$1;
(statearr_54705_54754[(1)] = (23));

} else {
var statearr_54706_54755 = state_54691__$1;
(statearr_54706_54755[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (6))){
var inst_54672 = (state_54691[(11)]);
var inst_54622 = (state_54691[(8)]);
var inst_54670 = (state_54691[(7)]);
var inst_54670__$1 = topic_fn.call(null,inst_54622);
var inst_54671 = cljs.core.deref.call(null,mults);
var inst_54672__$1 = cljs.core.get.call(null,inst_54671,inst_54670__$1);
var state_54691__$1 = (function (){var statearr_54707 = state_54691;
(statearr_54707[(11)] = inst_54672__$1);

(statearr_54707[(7)] = inst_54670__$1);

return statearr_54707;
})();
if(cljs.core.truth_(inst_54672__$1)){
var statearr_54708_54756 = state_54691__$1;
(statearr_54708_54756[(1)] = (19));

} else {
var statearr_54709_54757 = state_54691__$1;
(statearr_54709_54757[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (25))){
var inst_54681 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
var statearr_54710_54758 = state_54691__$1;
(statearr_54710_54758[(2)] = inst_54681);

(statearr_54710_54758[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (17))){
var inst_54646 = (state_54691[(10)]);
var inst_54655 = cljs.core.first.call(null,inst_54646);
var inst_54656 = cljs.core.async.muxch_STAR_.call(null,inst_54655);
var inst_54657 = cljs.core.async.close_BANG_.call(null,inst_54656);
var inst_54658 = cljs.core.next.call(null,inst_54646);
var inst_54632 = inst_54658;
var inst_54633 = null;
var inst_54634 = (0);
var inst_54635 = (0);
var state_54691__$1 = (function (){var statearr_54711 = state_54691;
(statearr_54711[(12)] = inst_54635);

(statearr_54711[(13)] = inst_54633);

(statearr_54711[(14)] = inst_54657);

(statearr_54711[(15)] = inst_54634);

(statearr_54711[(16)] = inst_54632);

return statearr_54711;
})();
var statearr_54712_54759 = state_54691__$1;
(statearr_54712_54759[(2)] = null);

(statearr_54712_54759[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (3))){
var inst_54689 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54691__$1,inst_54689);
} else {
if((state_val_54692 === (12))){
var inst_54666 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
var statearr_54713_54760 = state_54691__$1;
(statearr_54713_54760[(2)] = inst_54666);

(statearr_54713_54760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (2))){
var state_54691__$1 = state_54691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54691__$1,(4),ch);
} else {
if((state_val_54692 === (23))){
var state_54691__$1 = state_54691;
var statearr_54714_54761 = state_54691__$1;
(statearr_54714_54761[(2)] = null);

(statearr_54714_54761[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (19))){
var inst_54672 = (state_54691[(11)]);
var inst_54622 = (state_54691[(8)]);
var inst_54674 = cljs.core.async.muxch_STAR_.call(null,inst_54672);
var state_54691__$1 = state_54691;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54691__$1,(22),inst_54674,inst_54622);
} else {
if((state_val_54692 === (11))){
var inst_54646 = (state_54691[(10)]);
var inst_54632 = (state_54691[(16)]);
var inst_54646__$1 = cljs.core.seq.call(null,inst_54632);
var state_54691__$1 = (function (){var statearr_54715 = state_54691;
(statearr_54715[(10)] = inst_54646__$1);

return statearr_54715;
})();
if(inst_54646__$1){
var statearr_54716_54762 = state_54691__$1;
(statearr_54716_54762[(1)] = (13));

} else {
var statearr_54717_54763 = state_54691__$1;
(statearr_54717_54763[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (9))){
var inst_54668 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
var statearr_54718_54764 = state_54691__$1;
(statearr_54718_54764[(2)] = inst_54668);

(statearr_54718_54764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (5))){
var inst_54629 = cljs.core.deref.call(null,mults);
var inst_54630 = cljs.core.vals.call(null,inst_54629);
var inst_54631 = cljs.core.seq.call(null,inst_54630);
var inst_54632 = inst_54631;
var inst_54633 = null;
var inst_54634 = (0);
var inst_54635 = (0);
var state_54691__$1 = (function (){var statearr_54719 = state_54691;
(statearr_54719[(12)] = inst_54635);

(statearr_54719[(13)] = inst_54633);

(statearr_54719[(15)] = inst_54634);

(statearr_54719[(16)] = inst_54632);

return statearr_54719;
})();
var statearr_54720_54765 = state_54691__$1;
(statearr_54720_54765[(2)] = null);

(statearr_54720_54765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (14))){
var state_54691__$1 = state_54691;
var statearr_54724_54766 = state_54691__$1;
(statearr_54724_54766[(2)] = null);

(statearr_54724_54766[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (16))){
var inst_54646 = (state_54691[(10)]);
var inst_54650 = cljs.core.chunk_first.call(null,inst_54646);
var inst_54651 = cljs.core.chunk_rest.call(null,inst_54646);
var inst_54652 = cljs.core.count.call(null,inst_54650);
var inst_54632 = inst_54651;
var inst_54633 = inst_54650;
var inst_54634 = inst_54652;
var inst_54635 = (0);
var state_54691__$1 = (function (){var statearr_54725 = state_54691;
(statearr_54725[(12)] = inst_54635);

(statearr_54725[(13)] = inst_54633);

(statearr_54725[(15)] = inst_54634);

(statearr_54725[(16)] = inst_54632);

return statearr_54725;
})();
var statearr_54726_54767 = state_54691__$1;
(statearr_54726_54767[(2)] = null);

(statearr_54726_54767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (10))){
var inst_54635 = (state_54691[(12)]);
var inst_54633 = (state_54691[(13)]);
var inst_54634 = (state_54691[(15)]);
var inst_54632 = (state_54691[(16)]);
var inst_54640 = cljs.core._nth.call(null,inst_54633,inst_54635);
var inst_54641 = cljs.core.async.muxch_STAR_.call(null,inst_54640);
var inst_54642 = cljs.core.async.close_BANG_.call(null,inst_54641);
var inst_54643 = (inst_54635 + (1));
var tmp54721 = inst_54633;
var tmp54722 = inst_54634;
var tmp54723 = inst_54632;
var inst_54632__$1 = tmp54723;
var inst_54633__$1 = tmp54721;
var inst_54634__$1 = tmp54722;
var inst_54635__$1 = inst_54643;
var state_54691__$1 = (function (){var statearr_54727 = state_54691;
(statearr_54727[(12)] = inst_54635__$1);

(statearr_54727[(13)] = inst_54633__$1);

(statearr_54727[(17)] = inst_54642);

(statearr_54727[(15)] = inst_54634__$1);

(statearr_54727[(16)] = inst_54632__$1);

return statearr_54727;
})();
var statearr_54728_54768 = state_54691__$1;
(statearr_54728_54768[(2)] = null);

(statearr_54728_54768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (18))){
var inst_54661 = (state_54691[(2)]);
var state_54691__$1 = state_54691;
var statearr_54729_54769 = state_54691__$1;
(statearr_54729_54769[(2)] = inst_54661);

(statearr_54729_54769[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54692 === (8))){
var inst_54635 = (state_54691[(12)]);
var inst_54634 = (state_54691[(15)]);
var inst_54637 = (inst_54635 < inst_54634);
var inst_54638 = inst_54637;
var state_54691__$1 = state_54691;
if(cljs.core.truth_(inst_54638)){
var statearr_54730_54770 = state_54691__$1;
(statearr_54730_54770[(1)] = (10));

} else {
var statearr_54731_54771 = state_54691__$1;
(statearr_54731_54771[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___54743,mults,ensure_mult,p))
;
return ((function (switch__52692__auto__,c__52806__auto___54743,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_54735 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54735[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_54735[(1)] = (1));

return statearr_54735;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_54691){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_54691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e54736){if((e54736 instanceof Object)){
var ex__52696__auto__ = e54736;
var statearr_54737_54772 = state_54691;
(statearr_54737_54772[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54736;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54773 = state_54691;
state_54691 = G__54773;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_54691){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_54691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___54743,mults,ensure_mult,p))
})();
var state__52808__auto__ = (function (){var statearr_54738 = f__52807__auto__.call(null);
(statearr_54738[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___54743);

return statearr_54738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___54743,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args54774 = [];
var len__51068__auto___54777 = arguments.length;
var i__51069__auto___54778 = (0);
while(true){
if((i__51069__auto___54778 < len__51068__auto___54777)){
args54774.push((arguments[i__51069__auto___54778]));

var G__54779 = (i__51069__auto___54778 + (1));
i__51069__auto___54778 = G__54779;
continue;
} else {
}
break;
}

var G__54776 = args54774.length;
switch (G__54776) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54774.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args54781 = [];
var len__51068__auto___54784 = arguments.length;
var i__51069__auto___54785 = (0);
while(true){
if((i__51069__auto___54785 < len__51068__auto___54784)){
args54781.push((arguments[i__51069__auto___54785]));

var G__54786 = (i__51069__auto___54785 + (1));
i__51069__auto___54785 = G__54786;
continue;
} else {
}
break;
}

var G__54783 = args54781.length;
switch (G__54783) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54781.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args54788 = [];
var len__51068__auto___54859 = arguments.length;
var i__51069__auto___54860 = (0);
while(true){
if((i__51069__auto___54860 < len__51068__auto___54859)){
args54788.push((arguments[i__51069__auto___54860]));

var G__54861 = (i__51069__auto___54860 + (1));
i__51069__auto___54860 = G__54861;
continue;
} else {
}
break;
}

var G__54790 = args54788.length;
switch (G__54790) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54788.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__52806__auto___54863 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___54863,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___54863,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_54829){
var state_val_54830 = (state_54829[(1)]);
if((state_val_54830 === (7))){
var state_54829__$1 = state_54829;
var statearr_54831_54864 = state_54829__$1;
(statearr_54831_54864[(2)] = null);

(statearr_54831_54864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (1))){
var state_54829__$1 = state_54829;
var statearr_54832_54865 = state_54829__$1;
(statearr_54832_54865[(2)] = null);

(statearr_54832_54865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (4))){
var inst_54793 = (state_54829[(7)]);
var inst_54795 = (inst_54793 < cnt);
var state_54829__$1 = state_54829;
if(cljs.core.truth_(inst_54795)){
var statearr_54833_54866 = state_54829__$1;
(statearr_54833_54866[(1)] = (6));

} else {
var statearr_54834_54867 = state_54829__$1;
(statearr_54834_54867[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (15))){
var inst_54825 = (state_54829[(2)]);
var state_54829__$1 = state_54829;
var statearr_54835_54868 = state_54829__$1;
(statearr_54835_54868[(2)] = inst_54825);

(statearr_54835_54868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (13))){
var inst_54818 = cljs.core.async.close_BANG_.call(null,out);
var state_54829__$1 = state_54829;
var statearr_54836_54869 = state_54829__$1;
(statearr_54836_54869[(2)] = inst_54818);

(statearr_54836_54869[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (6))){
var state_54829__$1 = state_54829;
var statearr_54837_54870 = state_54829__$1;
(statearr_54837_54870[(2)] = null);

(statearr_54837_54870[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (3))){
var inst_54827 = (state_54829[(2)]);
var state_54829__$1 = state_54829;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54829__$1,inst_54827);
} else {
if((state_val_54830 === (12))){
var inst_54815 = (state_54829[(8)]);
var inst_54815__$1 = (state_54829[(2)]);
var inst_54816 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_54815__$1);
var state_54829__$1 = (function (){var statearr_54838 = state_54829;
(statearr_54838[(8)] = inst_54815__$1);

return statearr_54838;
})();
if(cljs.core.truth_(inst_54816)){
var statearr_54839_54871 = state_54829__$1;
(statearr_54839_54871[(1)] = (13));

} else {
var statearr_54840_54872 = state_54829__$1;
(statearr_54840_54872[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (2))){
var inst_54792 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_54793 = (0);
var state_54829__$1 = (function (){var statearr_54841 = state_54829;
(statearr_54841[(7)] = inst_54793);

(statearr_54841[(9)] = inst_54792);

return statearr_54841;
})();
var statearr_54842_54873 = state_54829__$1;
(statearr_54842_54873[(2)] = null);

(statearr_54842_54873[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (11))){
var inst_54793 = (state_54829[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54829,(10),Object,null,(9));
var inst_54802 = chs__$1.call(null,inst_54793);
var inst_54803 = done.call(null,inst_54793);
var inst_54804 = cljs.core.async.take_BANG_.call(null,inst_54802,inst_54803);
var state_54829__$1 = state_54829;
var statearr_54843_54874 = state_54829__$1;
(statearr_54843_54874[(2)] = inst_54804);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54829__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (9))){
var inst_54793 = (state_54829[(7)]);
var inst_54806 = (state_54829[(2)]);
var inst_54807 = (inst_54793 + (1));
var inst_54793__$1 = inst_54807;
var state_54829__$1 = (function (){var statearr_54844 = state_54829;
(statearr_54844[(7)] = inst_54793__$1);

(statearr_54844[(10)] = inst_54806);

return statearr_54844;
})();
var statearr_54845_54875 = state_54829__$1;
(statearr_54845_54875[(2)] = null);

(statearr_54845_54875[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (5))){
var inst_54813 = (state_54829[(2)]);
var state_54829__$1 = (function (){var statearr_54846 = state_54829;
(statearr_54846[(11)] = inst_54813);

return statearr_54846;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54829__$1,(12),dchan);
} else {
if((state_val_54830 === (14))){
var inst_54815 = (state_54829[(8)]);
var inst_54820 = cljs.core.apply.call(null,f,inst_54815);
var state_54829__$1 = state_54829;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54829__$1,(16),out,inst_54820);
} else {
if((state_val_54830 === (16))){
var inst_54822 = (state_54829[(2)]);
var state_54829__$1 = (function (){var statearr_54847 = state_54829;
(statearr_54847[(12)] = inst_54822);

return statearr_54847;
})();
var statearr_54848_54876 = state_54829__$1;
(statearr_54848_54876[(2)] = null);

(statearr_54848_54876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (10))){
var inst_54797 = (state_54829[(2)]);
var inst_54798 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_54829__$1 = (function (){var statearr_54849 = state_54829;
(statearr_54849[(13)] = inst_54797);

return statearr_54849;
})();
var statearr_54850_54877 = state_54829__$1;
(statearr_54850_54877[(2)] = inst_54798);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54829__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54830 === (8))){
var inst_54811 = (state_54829[(2)]);
var state_54829__$1 = state_54829;
var statearr_54851_54878 = state_54829__$1;
(statearr_54851_54878[(2)] = inst_54811);

(statearr_54851_54878[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___54863,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__52692__auto__,c__52806__auto___54863,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_54855 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54855[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_54855[(1)] = (1));

return statearr_54855;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_54829){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_54829);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e54856){if((e54856 instanceof Object)){
var ex__52696__auto__ = e54856;
var statearr_54857_54879 = state_54829;
(statearr_54857_54879[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54829);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54856;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54880 = state_54829;
state_54829 = G__54880;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_54829){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_54829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___54863,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__52808__auto__ = (function (){var statearr_54858 = f__52807__auto__.call(null);
(statearr_54858[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___54863);

return statearr_54858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___54863,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args54882 = [];
var len__51068__auto___54940 = arguments.length;
var i__51069__auto___54941 = (0);
while(true){
if((i__51069__auto___54941 < len__51068__auto___54940)){
args54882.push((arguments[i__51069__auto___54941]));

var G__54942 = (i__51069__auto___54941 + (1));
i__51069__auto___54941 = G__54942;
continue;
} else {
}
break;
}

var G__54884 = args54882.length;
switch (G__54884) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54882.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__52806__auto___54944 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___54944,out){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___54944,out){
return (function (state_54916){
var state_val_54917 = (state_54916[(1)]);
if((state_val_54917 === (7))){
var inst_54895 = (state_54916[(7)]);
var inst_54896 = (state_54916[(8)]);
var inst_54895__$1 = (state_54916[(2)]);
var inst_54896__$1 = cljs.core.nth.call(null,inst_54895__$1,(0),null);
var inst_54897 = cljs.core.nth.call(null,inst_54895__$1,(1),null);
var inst_54898 = (inst_54896__$1 == null);
var state_54916__$1 = (function (){var statearr_54918 = state_54916;
(statearr_54918[(9)] = inst_54897);

(statearr_54918[(7)] = inst_54895__$1);

(statearr_54918[(8)] = inst_54896__$1);

return statearr_54918;
})();
if(cljs.core.truth_(inst_54898)){
var statearr_54919_54945 = state_54916__$1;
(statearr_54919_54945[(1)] = (8));

} else {
var statearr_54920_54946 = state_54916__$1;
(statearr_54920_54946[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (1))){
var inst_54885 = cljs.core.vec.call(null,chs);
var inst_54886 = inst_54885;
var state_54916__$1 = (function (){var statearr_54921 = state_54916;
(statearr_54921[(10)] = inst_54886);

return statearr_54921;
})();
var statearr_54922_54947 = state_54916__$1;
(statearr_54922_54947[(2)] = null);

(statearr_54922_54947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (4))){
var inst_54886 = (state_54916[(10)]);
var state_54916__$1 = state_54916;
return cljs.core.async.ioc_alts_BANG_.call(null,state_54916__$1,(7),inst_54886);
} else {
if((state_val_54917 === (6))){
var inst_54912 = (state_54916[(2)]);
var state_54916__$1 = state_54916;
var statearr_54923_54948 = state_54916__$1;
(statearr_54923_54948[(2)] = inst_54912);

(statearr_54923_54948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (3))){
var inst_54914 = (state_54916[(2)]);
var state_54916__$1 = state_54916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54916__$1,inst_54914);
} else {
if((state_val_54917 === (2))){
var inst_54886 = (state_54916[(10)]);
var inst_54888 = cljs.core.count.call(null,inst_54886);
var inst_54889 = (inst_54888 > (0));
var state_54916__$1 = state_54916;
if(cljs.core.truth_(inst_54889)){
var statearr_54925_54949 = state_54916__$1;
(statearr_54925_54949[(1)] = (4));

} else {
var statearr_54926_54950 = state_54916__$1;
(statearr_54926_54950[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (11))){
var inst_54886 = (state_54916[(10)]);
var inst_54905 = (state_54916[(2)]);
var tmp54924 = inst_54886;
var inst_54886__$1 = tmp54924;
var state_54916__$1 = (function (){var statearr_54927 = state_54916;
(statearr_54927[(10)] = inst_54886__$1);

(statearr_54927[(11)] = inst_54905);

return statearr_54927;
})();
var statearr_54928_54951 = state_54916__$1;
(statearr_54928_54951[(2)] = null);

(statearr_54928_54951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (9))){
var inst_54896 = (state_54916[(8)]);
var state_54916__$1 = state_54916;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54916__$1,(11),out,inst_54896);
} else {
if((state_val_54917 === (5))){
var inst_54910 = cljs.core.async.close_BANG_.call(null,out);
var state_54916__$1 = state_54916;
var statearr_54929_54952 = state_54916__$1;
(statearr_54929_54952[(2)] = inst_54910);

(statearr_54929_54952[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (10))){
var inst_54908 = (state_54916[(2)]);
var state_54916__$1 = state_54916;
var statearr_54930_54953 = state_54916__$1;
(statearr_54930_54953[(2)] = inst_54908);

(statearr_54930_54953[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (8))){
var inst_54897 = (state_54916[(9)]);
var inst_54886 = (state_54916[(10)]);
var inst_54895 = (state_54916[(7)]);
var inst_54896 = (state_54916[(8)]);
var inst_54900 = (function (){var cs = inst_54886;
var vec__54891 = inst_54895;
var v = inst_54896;
var c = inst_54897;
return ((function (cs,vec__54891,v,c,inst_54897,inst_54886,inst_54895,inst_54896,state_val_54917,c__52806__auto___54944,out){
return (function (p1__54881_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__54881_SHARP_);
});
;})(cs,vec__54891,v,c,inst_54897,inst_54886,inst_54895,inst_54896,state_val_54917,c__52806__auto___54944,out))
})();
var inst_54901 = cljs.core.filterv.call(null,inst_54900,inst_54886);
var inst_54886__$1 = inst_54901;
var state_54916__$1 = (function (){var statearr_54931 = state_54916;
(statearr_54931[(10)] = inst_54886__$1);

return statearr_54931;
})();
var statearr_54932_54954 = state_54916__$1;
(statearr_54932_54954[(2)] = null);

(statearr_54932_54954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___54944,out))
;
return ((function (switch__52692__auto__,c__52806__auto___54944,out){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_54936 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54936[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_54936[(1)] = (1));

return statearr_54936;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_54916){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_54916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e54937){if((e54937 instanceof Object)){
var ex__52696__auto__ = e54937;
var statearr_54938_54955 = state_54916;
(statearr_54938_54955[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54956 = state_54916;
state_54916 = G__54956;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_54916){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_54916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___54944,out))
})();
var state__52808__auto__ = (function (){var statearr_54939 = f__52807__auto__.call(null);
(statearr_54939[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___54944);

return statearr_54939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___54944,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args54957 = [];
var len__51068__auto___55006 = arguments.length;
var i__51069__auto___55007 = (0);
while(true){
if((i__51069__auto___55007 < len__51068__auto___55006)){
args54957.push((arguments[i__51069__auto___55007]));

var G__55008 = (i__51069__auto___55007 + (1));
i__51069__auto___55007 = G__55008;
continue;
} else {
}
break;
}

var G__54959 = args54957.length;
switch (G__54959) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args54957.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__52806__auto___55010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___55010,out){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___55010,out){
return (function (state_54983){
var state_val_54984 = (state_54983[(1)]);
if((state_val_54984 === (7))){
var inst_54965 = (state_54983[(7)]);
var inst_54965__$1 = (state_54983[(2)]);
var inst_54966 = (inst_54965__$1 == null);
var inst_54967 = cljs.core.not.call(null,inst_54966);
var state_54983__$1 = (function (){var statearr_54985 = state_54983;
(statearr_54985[(7)] = inst_54965__$1);

return statearr_54985;
})();
if(inst_54967){
var statearr_54986_55011 = state_54983__$1;
(statearr_54986_55011[(1)] = (8));

} else {
var statearr_54987_55012 = state_54983__$1;
(statearr_54987_55012[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (1))){
var inst_54960 = (0);
var state_54983__$1 = (function (){var statearr_54988 = state_54983;
(statearr_54988[(8)] = inst_54960);

return statearr_54988;
})();
var statearr_54989_55013 = state_54983__$1;
(statearr_54989_55013[(2)] = null);

(statearr_54989_55013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (4))){
var state_54983__$1 = state_54983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54983__$1,(7),ch);
} else {
if((state_val_54984 === (6))){
var inst_54978 = (state_54983[(2)]);
var state_54983__$1 = state_54983;
var statearr_54990_55014 = state_54983__$1;
(statearr_54990_55014[(2)] = inst_54978);

(statearr_54990_55014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (3))){
var inst_54980 = (state_54983[(2)]);
var inst_54981 = cljs.core.async.close_BANG_.call(null,out);
var state_54983__$1 = (function (){var statearr_54991 = state_54983;
(statearr_54991[(9)] = inst_54980);

return statearr_54991;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54983__$1,inst_54981);
} else {
if((state_val_54984 === (2))){
var inst_54960 = (state_54983[(8)]);
var inst_54962 = (inst_54960 < n);
var state_54983__$1 = state_54983;
if(cljs.core.truth_(inst_54962)){
var statearr_54992_55015 = state_54983__$1;
(statearr_54992_55015[(1)] = (4));

} else {
var statearr_54993_55016 = state_54983__$1;
(statearr_54993_55016[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (11))){
var inst_54960 = (state_54983[(8)]);
var inst_54970 = (state_54983[(2)]);
var inst_54971 = (inst_54960 + (1));
var inst_54960__$1 = inst_54971;
var state_54983__$1 = (function (){var statearr_54994 = state_54983;
(statearr_54994[(8)] = inst_54960__$1);

(statearr_54994[(10)] = inst_54970);

return statearr_54994;
})();
var statearr_54995_55017 = state_54983__$1;
(statearr_54995_55017[(2)] = null);

(statearr_54995_55017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (9))){
var state_54983__$1 = state_54983;
var statearr_54996_55018 = state_54983__$1;
(statearr_54996_55018[(2)] = null);

(statearr_54996_55018[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (5))){
var state_54983__$1 = state_54983;
var statearr_54997_55019 = state_54983__$1;
(statearr_54997_55019[(2)] = null);

(statearr_54997_55019[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (10))){
var inst_54975 = (state_54983[(2)]);
var state_54983__$1 = state_54983;
var statearr_54998_55020 = state_54983__$1;
(statearr_54998_55020[(2)] = inst_54975);

(statearr_54998_55020[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54984 === (8))){
var inst_54965 = (state_54983[(7)]);
var state_54983__$1 = state_54983;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54983__$1,(11),out,inst_54965);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___55010,out))
;
return ((function (switch__52692__auto__,c__52806__auto___55010,out){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_55002 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55002[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_55002[(1)] = (1));

return statearr_55002;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_54983){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_54983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e55003){if((e55003 instanceof Object)){
var ex__52696__auto__ = e55003;
var statearr_55004_55021 = state_54983;
(statearr_55004_55021[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54983);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55022 = state_54983;
state_54983 = G__55022;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_54983){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_54983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___55010,out))
})();
var state__52808__auto__ = (function (){var statearr_55005 = f__52807__auto__.call(null);
(statearr_55005[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___55010);

return statearr_55005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___55010,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async55030 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55030 = (function (f,ch,meta55031){
this.f = f;
this.ch = ch;
this.meta55031 = meta55031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55032,meta55031__$1){
var self__ = this;
var _55032__$1 = this;
return (new cljs.core.async.t_cljs$core$async55030(self__.f,self__.ch,meta55031__$1));
});

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55032){
var self__ = this;
var _55032__$1 = this;
return self__.meta55031;
});

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async55033 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55033 = (function (f,ch,meta55031,_,fn1,meta55034){
this.f = f;
this.ch = ch;
this.meta55031 = meta55031;
this._ = _;
this.fn1 = fn1;
this.meta55034 = meta55034;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async55033.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_55035,meta55034__$1){
var self__ = this;
var _55035__$1 = this;
return (new cljs.core.async.t_cljs$core$async55033(self__.f,self__.ch,self__.meta55031,self__._,self__.fn1,meta55034__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async55033.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_55035){
var self__ = this;
var _55035__$1 = this;
return self__.meta55034;
});})(___$1))
;

cljs.core.async.t_cljs$core$async55033.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55033.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async55033.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async55033.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__55023_SHARP_){
return f1.call(null,(((p1__55023_SHARP_ == null))?null:self__.f.call(null,p1__55023_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async55033.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55031","meta55031",233453317,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async55030","cljs.core.async/t_cljs$core$async55030",1912414871,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta55034","meta55034",-2089020484,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async55033.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55033.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55033";

cljs.core.async.t_cljs$core$async55033.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async55033");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async55033 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async55033(f__$1,ch__$1,meta55031__$1,___$2,fn1__$1,meta55034){
return (new cljs.core.async.t_cljs$core$async55033(f__$1,ch__$1,meta55031__$1,___$2,fn1__$1,meta55034));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async55033(self__.f,self__.ch,self__.meta55031,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__49840__auto__ = ret;
if(cljs.core.truth_(and__49840__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__49840__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55030.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async55030.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55031","meta55031",233453317,null)], null);
});

cljs.core.async.t_cljs$core$async55030.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55030.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55030";

cljs.core.async.t_cljs$core$async55030.cljs$lang$ctorPrWriter = (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async55030");
});

cljs.core.async.__GT_t_cljs$core$async55030 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async55030(f__$1,ch__$1,meta55031){
return (new cljs.core.async.t_cljs$core$async55030(f__$1,ch__$1,meta55031));
});

}

return (new cljs.core.async.t_cljs$core$async55030(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async55039 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55039 = (function (f,ch,meta55040){
this.f = f;
this.ch = ch;
this.meta55040 = meta55040;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55041,meta55040__$1){
var self__ = this;
var _55041__$1 = this;
return (new cljs.core.async.t_cljs$core$async55039(self__.f,self__.ch,meta55040__$1));
});

cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55041){
var self__ = this;
var _55041__$1 = this;
return self__.meta55040;
});

cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55039.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async55039.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55040","meta55040",899718352,null)], null);
});

cljs.core.async.t_cljs$core$async55039.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55039.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55039";

cljs.core.async.t_cljs$core$async55039.cljs$lang$ctorPrWriter = (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async55039");
});

cljs.core.async.__GT_t_cljs$core$async55039 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async55039(f__$1,ch__$1,meta55040){
return (new cljs.core.async.t_cljs$core$async55039(f__$1,ch__$1,meta55040));
});

}

return (new cljs.core.async.t_cljs$core$async55039(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async55045 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55045 = (function (p,ch,meta55046){
this.p = p;
this.ch = ch;
this.meta55046 = meta55046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55047,meta55046__$1){
var self__ = this;
var _55047__$1 = this;
return (new cljs.core.async.t_cljs$core$async55045(self__.p,self__.ch,meta55046__$1));
});

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55047){
var self__ = this;
var _55047__$1 = this;
return self__.meta55046;
});

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async55045.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async55045.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55046","meta55046",-1024134614,null)], null);
});

cljs.core.async.t_cljs$core$async55045.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async55045.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55045";

cljs.core.async.t_cljs$core$async55045.cljs$lang$ctorPrWriter = (function (this__50504__auto__,writer__50505__auto__,opt__50506__auto__){
return cljs.core._write.call(null,writer__50505__auto__,"cljs.core.async/t_cljs$core$async55045");
});

cljs.core.async.__GT_t_cljs$core$async55045 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async55045(p__$1,ch__$1,meta55046){
return (new cljs.core.async.t_cljs$core$async55045(p__$1,ch__$1,meta55046));
});

}

return (new cljs.core.async.t_cljs$core$async55045(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args55048 = [];
var len__51068__auto___55092 = arguments.length;
var i__51069__auto___55093 = (0);
while(true){
if((i__51069__auto___55093 < len__51068__auto___55092)){
args55048.push((arguments[i__51069__auto___55093]));

var G__55094 = (i__51069__auto___55093 + (1));
i__51069__auto___55093 = G__55094;
continue;
} else {
}
break;
}

var G__55050 = args55048.length;
switch (G__55050) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55048.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__52806__auto___55096 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___55096,out){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___55096,out){
return (function (state_55071){
var state_val_55072 = (state_55071[(1)]);
if((state_val_55072 === (7))){
var inst_55067 = (state_55071[(2)]);
var state_55071__$1 = state_55071;
var statearr_55073_55097 = state_55071__$1;
(statearr_55073_55097[(2)] = inst_55067);

(statearr_55073_55097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (1))){
var state_55071__$1 = state_55071;
var statearr_55074_55098 = state_55071__$1;
(statearr_55074_55098[(2)] = null);

(statearr_55074_55098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (4))){
var inst_55053 = (state_55071[(7)]);
var inst_55053__$1 = (state_55071[(2)]);
var inst_55054 = (inst_55053__$1 == null);
var state_55071__$1 = (function (){var statearr_55075 = state_55071;
(statearr_55075[(7)] = inst_55053__$1);

return statearr_55075;
})();
if(cljs.core.truth_(inst_55054)){
var statearr_55076_55099 = state_55071__$1;
(statearr_55076_55099[(1)] = (5));

} else {
var statearr_55077_55100 = state_55071__$1;
(statearr_55077_55100[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (6))){
var inst_55053 = (state_55071[(7)]);
var inst_55058 = p.call(null,inst_55053);
var state_55071__$1 = state_55071;
if(cljs.core.truth_(inst_55058)){
var statearr_55078_55101 = state_55071__$1;
(statearr_55078_55101[(1)] = (8));

} else {
var statearr_55079_55102 = state_55071__$1;
(statearr_55079_55102[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (3))){
var inst_55069 = (state_55071[(2)]);
var state_55071__$1 = state_55071;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55071__$1,inst_55069);
} else {
if((state_val_55072 === (2))){
var state_55071__$1 = state_55071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55071__$1,(4),ch);
} else {
if((state_val_55072 === (11))){
var inst_55061 = (state_55071[(2)]);
var state_55071__$1 = state_55071;
var statearr_55080_55103 = state_55071__$1;
(statearr_55080_55103[(2)] = inst_55061);

(statearr_55080_55103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (9))){
var state_55071__$1 = state_55071;
var statearr_55081_55104 = state_55071__$1;
(statearr_55081_55104[(2)] = null);

(statearr_55081_55104[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (5))){
var inst_55056 = cljs.core.async.close_BANG_.call(null,out);
var state_55071__$1 = state_55071;
var statearr_55082_55105 = state_55071__$1;
(statearr_55082_55105[(2)] = inst_55056);

(statearr_55082_55105[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (10))){
var inst_55064 = (state_55071[(2)]);
var state_55071__$1 = (function (){var statearr_55083 = state_55071;
(statearr_55083[(8)] = inst_55064);

return statearr_55083;
})();
var statearr_55084_55106 = state_55071__$1;
(statearr_55084_55106[(2)] = null);

(statearr_55084_55106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55072 === (8))){
var inst_55053 = (state_55071[(7)]);
var state_55071__$1 = state_55071;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55071__$1,(11),out,inst_55053);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___55096,out))
;
return ((function (switch__52692__auto__,c__52806__auto___55096,out){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_55088 = [null,null,null,null,null,null,null,null,null];
(statearr_55088[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_55088[(1)] = (1));

return statearr_55088;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_55071){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_55071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e55089){if((e55089 instanceof Object)){
var ex__52696__auto__ = e55089;
var statearr_55090_55107 = state_55071;
(statearr_55090_55107[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55071);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55089;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55108 = state_55071;
state_55071 = G__55108;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_55071){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_55071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___55096,out))
})();
var state__52808__auto__ = (function (){var statearr_55091 = f__52807__auto__.call(null);
(statearr_55091[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___55096);

return statearr_55091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___55096,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args55109 = [];
var len__51068__auto___55112 = arguments.length;
var i__51069__auto___55113 = (0);
while(true){
if((i__51069__auto___55113 < len__51068__auto___55112)){
args55109.push((arguments[i__51069__auto___55113]));

var G__55114 = (i__51069__auto___55113 + (1));
i__51069__auto___55113 = G__55114;
continue;
} else {
}
break;
}

var G__55111 = args55109.length;
switch (G__55111) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55109.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__52806__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto__){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto__){
return (function (state_55281){
var state_val_55282 = (state_55281[(1)]);
if((state_val_55282 === (7))){
var inst_55277 = (state_55281[(2)]);
var state_55281__$1 = state_55281;
var statearr_55283_55324 = state_55281__$1;
(statearr_55283_55324[(2)] = inst_55277);

(statearr_55283_55324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (20))){
var inst_55247 = (state_55281[(7)]);
var inst_55258 = (state_55281[(2)]);
var inst_55259 = cljs.core.next.call(null,inst_55247);
var inst_55233 = inst_55259;
var inst_55234 = null;
var inst_55235 = (0);
var inst_55236 = (0);
var state_55281__$1 = (function (){var statearr_55284 = state_55281;
(statearr_55284[(8)] = inst_55236);

(statearr_55284[(9)] = inst_55235);

(statearr_55284[(10)] = inst_55258);

(statearr_55284[(11)] = inst_55233);

(statearr_55284[(12)] = inst_55234);

return statearr_55284;
})();
var statearr_55285_55325 = state_55281__$1;
(statearr_55285_55325[(2)] = null);

(statearr_55285_55325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (1))){
var state_55281__$1 = state_55281;
var statearr_55286_55326 = state_55281__$1;
(statearr_55286_55326[(2)] = null);

(statearr_55286_55326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (4))){
var inst_55222 = (state_55281[(13)]);
var inst_55222__$1 = (state_55281[(2)]);
var inst_55223 = (inst_55222__$1 == null);
var state_55281__$1 = (function (){var statearr_55287 = state_55281;
(statearr_55287[(13)] = inst_55222__$1);

return statearr_55287;
})();
if(cljs.core.truth_(inst_55223)){
var statearr_55288_55327 = state_55281__$1;
(statearr_55288_55327[(1)] = (5));

} else {
var statearr_55289_55328 = state_55281__$1;
(statearr_55289_55328[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (15))){
var state_55281__$1 = state_55281;
var statearr_55293_55329 = state_55281__$1;
(statearr_55293_55329[(2)] = null);

(statearr_55293_55329[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (21))){
var state_55281__$1 = state_55281;
var statearr_55294_55330 = state_55281__$1;
(statearr_55294_55330[(2)] = null);

(statearr_55294_55330[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (13))){
var inst_55236 = (state_55281[(8)]);
var inst_55235 = (state_55281[(9)]);
var inst_55233 = (state_55281[(11)]);
var inst_55234 = (state_55281[(12)]);
var inst_55243 = (state_55281[(2)]);
var inst_55244 = (inst_55236 + (1));
var tmp55290 = inst_55235;
var tmp55291 = inst_55233;
var tmp55292 = inst_55234;
var inst_55233__$1 = tmp55291;
var inst_55234__$1 = tmp55292;
var inst_55235__$1 = tmp55290;
var inst_55236__$1 = inst_55244;
var state_55281__$1 = (function (){var statearr_55295 = state_55281;
(statearr_55295[(8)] = inst_55236__$1);

(statearr_55295[(9)] = inst_55235__$1);

(statearr_55295[(14)] = inst_55243);

(statearr_55295[(11)] = inst_55233__$1);

(statearr_55295[(12)] = inst_55234__$1);

return statearr_55295;
})();
var statearr_55296_55331 = state_55281__$1;
(statearr_55296_55331[(2)] = null);

(statearr_55296_55331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (22))){
var state_55281__$1 = state_55281;
var statearr_55297_55332 = state_55281__$1;
(statearr_55297_55332[(2)] = null);

(statearr_55297_55332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (6))){
var inst_55222 = (state_55281[(13)]);
var inst_55231 = f.call(null,inst_55222);
var inst_55232 = cljs.core.seq.call(null,inst_55231);
var inst_55233 = inst_55232;
var inst_55234 = null;
var inst_55235 = (0);
var inst_55236 = (0);
var state_55281__$1 = (function (){var statearr_55298 = state_55281;
(statearr_55298[(8)] = inst_55236);

(statearr_55298[(9)] = inst_55235);

(statearr_55298[(11)] = inst_55233);

(statearr_55298[(12)] = inst_55234);

return statearr_55298;
})();
var statearr_55299_55333 = state_55281__$1;
(statearr_55299_55333[(2)] = null);

(statearr_55299_55333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (17))){
var inst_55247 = (state_55281[(7)]);
var inst_55251 = cljs.core.chunk_first.call(null,inst_55247);
var inst_55252 = cljs.core.chunk_rest.call(null,inst_55247);
var inst_55253 = cljs.core.count.call(null,inst_55251);
var inst_55233 = inst_55252;
var inst_55234 = inst_55251;
var inst_55235 = inst_55253;
var inst_55236 = (0);
var state_55281__$1 = (function (){var statearr_55300 = state_55281;
(statearr_55300[(8)] = inst_55236);

(statearr_55300[(9)] = inst_55235);

(statearr_55300[(11)] = inst_55233);

(statearr_55300[(12)] = inst_55234);

return statearr_55300;
})();
var statearr_55301_55334 = state_55281__$1;
(statearr_55301_55334[(2)] = null);

(statearr_55301_55334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (3))){
var inst_55279 = (state_55281[(2)]);
var state_55281__$1 = state_55281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55281__$1,inst_55279);
} else {
if((state_val_55282 === (12))){
var inst_55267 = (state_55281[(2)]);
var state_55281__$1 = state_55281;
var statearr_55302_55335 = state_55281__$1;
(statearr_55302_55335[(2)] = inst_55267);

(statearr_55302_55335[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (2))){
var state_55281__$1 = state_55281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55281__$1,(4),in$);
} else {
if((state_val_55282 === (23))){
var inst_55275 = (state_55281[(2)]);
var state_55281__$1 = state_55281;
var statearr_55303_55336 = state_55281__$1;
(statearr_55303_55336[(2)] = inst_55275);

(statearr_55303_55336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (19))){
var inst_55262 = (state_55281[(2)]);
var state_55281__$1 = state_55281;
var statearr_55304_55337 = state_55281__$1;
(statearr_55304_55337[(2)] = inst_55262);

(statearr_55304_55337[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (11))){
var inst_55247 = (state_55281[(7)]);
var inst_55233 = (state_55281[(11)]);
var inst_55247__$1 = cljs.core.seq.call(null,inst_55233);
var state_55281__$1 = (function (){var statearr_55305 = state_55281;
(statearr_55305[(7)] = inst_55247__$1);

return statearr_55305;
})();
if(inst_55247__$1){
var statearr_55306_55338 = state_55281__$1;
(statearr_55306_55338[(1)] = (14));

} else {
var statearr_55307_55339 = state_55281__$1;
(statearr_55307_55339[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (9))){
var inst_55269 = (state_55281[(2)]);
var inst_55270 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_55281__$1 = (function (){var statearr_55308 = state_55281;
(statearr_55308[(15)] = inst_55269);

return statearr_55308;
})();
if(cljs.core.truth_(inst_55270)){
var statearr_55309_55340 = state_55281__$1;
(statearr_55309_55340[(1)] = (21));

} else {
var statearr_55310_55341 = state_55281__$1;
(statearr_55310_55341[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (5))){
var inst_55225 = cljs.core.async.close_BANG_.call(null,out);
var state_55281__$1 = state_55281;
var statearr_55311_55342 = state_55281__$1;
(statearr_55311_55342[(2)] = inst_55225);

(statearr_55311_55342[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (14))){
var inst_55247 = (state_55281[(7)]);
var inst_55249 = cljs.core.chunked_seq_QMARK_.call(null,inst_55247);
var state_55281__$1 = state_55281;
if(inst_55249){
var statearr_55312_55343 = state_55281__$1;
(statearr_55312_55343[(1)] = (17));

} else {
var statearr_55313_55344 = state_55281__$1;
(statearr_55313_55344[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (16))){
var inst_55265 = (state_55281[(2)]);
var state_55281__$1 = state_55281;
var statearr_55314_55345 = state_55281__$1;
(statearr_55314_55345[(2)] = inst_55265);

(statearr_55314_55345[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55282 === (10))){
var inst_55236 = (state_55281[(8)]);
var inst_55234 = (state_55281[(12)]);
var inst_55241 = cljs.core._nth.call(null,inst_55234,inst_55236);
var state_55281__$1 = state_55281;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55281__$1,(13),out,inst_55241);
} else {
if((state_val_55282 === (18))){
var inst_55247 = (state_55281[(7)]);
var inst_55256 = cljs.core.first.call(null,inst_55247);
var state_55281__$1 = state_55281;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55281__$1,(20),out,inst_55256);
} else {
if((state_val_55282 === (8))){
var inst_55236 = (state_55281[(8)]);
var inst_55235 = (state_55281[(9)]);
var inst_55238 = (inst_55236 < inst_55235);
var inst_55239 = inst_55238;
var state_55281__$1 = state_55281;
if(cljs.core.truth_(inst_55239)){
var statearr_55315_55346 = state_55281__$1;
(statearr_55315_55346[(1)] = (10));

} else {
var statearr_55316_55347 = state_55281__$1;
(statearr_55316_55347[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto__))
;
return ((function (switch__52692__auto__,c__52806__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__52693__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__52693__auto____0 = (function (){
var statearr_55320 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55320[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__52693__auto__);

(statearr_55320[(1)] = (1));

return statearr_55320;
});
var cljs$core$async$mapcat_STAR__$_state_machine__52693__auto____1 = (function (state_55281){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_55281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e55321){if((e55321 instanceof Object)){
var ex__52696__auto__ = e55321;
var statearr_55322_55348 = state_55281;
(statearr_55322_55348[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55281);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55321;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55349 = state_55281;
state_55281 = G__55349;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__52693__auto__ = function(state_55281){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__52693__auto____1.call(this,state_55281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__52693__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__52693__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto__))
})();
var state__52808__auto__ = (function (){var statearr_55323 = f__52807__auto__.call(null);
(statearr_55323[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto__);

return statearr_55323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto__))
);

return c__52806__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args55350 = [];
var len__51068__auto___55353 = arguments.length;
var i__51069__auto___55354 = (0);
while(true){
if((i__51069__auto___55354 < len__51068__auto___55353)){
args55350.push((arguments[i__51069__auto___55354]));

var G__55355 = (i__51069__auto___55354 + (1));
i__51069__auto___55354 = G__55355;
continue;
} else {
}
break;
}

var G__55352 = args55350.length;
switch (G__55352) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55350.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args55357 = [];
var len__51068__auto___55360 = arguments.length;
var i__51069__auto___55361 = (0);
while(true){
if((i__51069__auto___55361 < len__51068__auto___55360)){
args55357.push((arguments[i__51069__auto___55361]));

var G__55362 = (i__51069__auto___55361 + (1));
i__51069__auto___55361 = G__55362;
continue;
} else {
}
break;
}

var G__55359 = args55357.length;
switch (G__55359) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55357.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args55364 = [];
var len__51068__auto___55415 = arguments.length;
var i__51069__auto___55416 = (0);
while(true){
if((i__51069__auto___55416 < len__51068__auto___55415)){
args55364.push((arguments[i__51069__auto___55416]));

var G__55417 = (i__51069__auto___55416 + (1));
i__51069__auto___55416 = G__55417;
continue;
} else {
}
break;
}

var G__55366 = args55364.length;
switch (G__55366) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55364.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__52806__auto___55419 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___55419,out){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___55419,out){
return (function (state_55390){
var state_val_55391 = (state_55390[(1)]);
if((state_val_55391 === (7))){
var inst_55385 = (state_55390[(2)]);
var state_55390__$1 = state_55390;
var statearr_55392_55420 = state_55390__$1;
(statearr_55392_55420[(2)] = inst_55385);

(statearr_55392_55420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55391 === (1))){
var inst_55367 = null;
var state_55390__$1 = (function (){var statearr_55393 = state_55390;
(statearr_55393[(7)] = inst_55367);

return statearr_55393;
})();
var statearr_55394_55421 = state_55390__$1;
(statearr_55394_55421[(2)] = null);

(statearr_55394_55421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55391 === (4))){
var inst_55370 = (state_55390[(8)]);
var inst_55370__$1 = (state_55390[(2)]);
var inst_55371 = (inst_55370__$1 == null);
var inst_55372 = cljs.core.not.call(null,inst_55371);
var state_55390__$1 = (function (){var statearr_55395 = state_55390;
(statearr_55395[(8)] = inst_55370__$1);

return statearr_55395;
})();
if(inst_55372){
var statearr_55396_55422 = state_55390__$1;
(statearr_55396_55422[(1)] = (5));

} else {
var statearr_55397_55423 = state_55390__$1;
(statearr_55397_55423[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55391 === (6))){
var state_55390__$1 = state_55390;
var statearr_55398_55424 = state_55390__$1;
(statearr_55398_55424[(2)] = null);

(statearr_55398_55424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55391 === (3))){
var inst_55387 = (state_55390[(2)]);
var inst_55388 = cljs.core.async.close_BANG_.call(null,out);
var state_55390__$1 = (function (){var statearr_55399 = state_55390;
(statearr_55399[(9)] = inst_55387);

return statearr_55399;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55390__$1,inst_55388);
} else {
if((state_val_55391 === (2))){
var state_55390__$1 = state_55390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55390__$1,(4),ch);
} else {
if((state_val_55391 === (11))){
var inst_55370 = (state_55390[(8)]);
var inst_55379 = (state_55390[(2)]);
var inst_55367 = inst_55370;
var state_55390__$1 = (function (){var statearr_55400 = state_55390;
(statearr_55400[(10)] = inst_55379);

(statearr_55400[(7)] = inst_55367);

return statearr_55400;
})();
var statearr_55401_55425 = state_55390__$1;
(statearr_55401_55425[(2)] = null);

(statearr_55401_55425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55391 === (9))){
var inst_55370 = (state_55390[(8)]);
var state_55390__$1 = state_55390;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55390__$1,(11),out,inst_55370);
} else {
if((state_val_55391 === (5))){
var inst_55370 = (state_55390[(8)]);
var inst_55367 = (state_55390[(7)]);
var inst_55374 = cljs.core._EQ_.call(null,inst_55370,inst_55367);
var state_55390__$1 = state_55390;
if(inst_55374){
var statearr_55403_55426 = state_55390__$1;
(statearr_55403_55426[(1)] = (8));

} else {
var statearr_55404_55427 = state_55390__$1;
(statearr_55404_55427[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55391 === (10))){
var inst_55382 = (state_55390[(2)]);
var state_55390__$1 = state_55390;
var statearr_55405_55428 = state_55390__$1;
(statearr_55405_55428[(2)] = inst_55382);

(statearr_55405_55428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55391 === (8))){
var inst_55367 = (state_55390[(7)]);
var tmp55402 = inst_55367;
var inst_55367__$1 = tmp55402;
var state_55390__$1 = (function (){var statearr_55406 = state_55390;
(statearr_55406[(7)] = inst_55367__$1);

return statearr_55406;
})();
var statearr_55407_55429 = state_55390__$1;
(statearr_55407_55429[(2)] = null);

(statearr_55407_55429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___55419,out))
;
return ((function (switch__52692__auto__,c__52806__auto___55419,out){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_55411 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55411[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_55411[(1)] = (1));

return statearr_55411;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_55390){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_55390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e55412){if((e55412 instanceof Object)){
var ex__52696__auto__ = e55412;
var statearr_55413_55430 = state_55390;
(statearr_55413_55430[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55390);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55412;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55431 = state_55390;
state_55390 = G__55431;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_55390){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_55390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___55419,out))
})();
var state__52808__auto__ = (function (){var statearr_55414 = f__52807__auto__.call(null);
(statearr_55414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___55419);

return statearr_55414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___55419,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args55432 = [];
var len__51068__auto___55502 = arguments.length;
var i__51069__auto___55503 = (0);
while(true){
if((i__51069__auto___55503 < len__51068__auto___55502)){
args55432.push((arguments[i__51069__auto___55503]));

var G__55504 = (i__51069__auto___55503 + (1));
i__51069__auto___55503 = G__55504;
continue;
} else {
}
break;
}

var G__55434 = args55432.length;
switch (G__55434) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55432.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__52806__auto___55506 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___55506,out){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___55506,out){
return (function (state_55472){
var state_val_55473 = (state_55472[(1)]);
if((state_val_55473 === (7))){
var inst_55468 = (state_55472[(2)]);
var state_55472__$1 = state_55472;
var statearr_55474_55507 = state_55472__$1;
(statearr_55474_55507[(2)] = inst_55468);

(statearr_55474_55507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (1))){
var inst_55435 = (new Array(n));
var inst_55436 = inst_55435;
var inst_55437 = (0);
var state_55472__$1 = (function (){var statearr_55475 = state_55472;
(statearr_55475[(7)] = inst_55436);

(statearr_55475[(8)] = inst_55437);

return statearr_55475;
})();
var statearr_55476_55508 = state_55472__$1;
(statearr_55476_55508[(2)] = null);

(statearr_55476_55508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (4))){
var inst_55440 = (state_55472[(9)]);
var inst_55440__$1 = (state_55472[(2)]);
var inst_55441 = (inst_55440__$1 == null);
var inst_55442 = cljs.core.not.call(null,inst_55441);
var state_55472__$1 = (function (){var statearr_55477 = state_55472;
(statearr_55477[(9)] = inst_55440__$1);

return statearr_55477;
})();
if(inst_55442){
var statearr_55478_55509 = state_55472__$1;
(statearr_55478_55509[(1)] = (5));

} else {
var statearr_55479_55510 = state_55472__$1;
(statearr_55479_55510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (15))){
var inst_55462 = (state_55472[(2)]);
var state_55472__$1 = state_55472;
var statearr_55480_55511 = state_55472__$1;
(statearr_55480_55511[(2)] = inst_55462);

(statearr_55480_55511[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (13))){
var state_55472__$1 = state_55472;
var statearr_55481_55512 = state_55472__$1;
(statearr_55481_55512[(2)] = null);

(statearr_55481_55512[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (6))){
var inst_55437 = (state_55472[(8)]);
var inst_55458 = (inst_55437 > (0));
var state_55472__$1 = state_55472;
if(cljs.core.truth_(inst_55458)){
var statearr_55482_55513 = state_55472__$1;
(statearr_55482_55513[(1)] = (12));

} else {
var statearr_55483_55514 = state_55472__$1;
(statearr_55483_55514[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (3))){
var inst_55470 = (state_55472[(2)]);
var state_55472__$1 = state_55472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55472__$1,inst_55470);
} else {
if((state_val_55473 === (12))){
var inst_55436 = (state_55472[(7)]);
var inst_55460 = cljs.core.vec.call(null,inst_55436);
var state_55472__$1 = state_55472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55472__$1,(15),out,inst_55460);
} else {
if((state_val_55473 === (2))){
var state_55472__$1 = state_55472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55472__$1,(4),ch);
} else {
if((state_val_55473 === (11))){
var inst_55452 = (state_55472[(2)]);
var inst_55453 = (new Array(n));
var inst_55436 = inst_55453;
var inst_55437 = (0);
var state_55472__$1 = (function (){var statearr_55484 = state_55472;
(statearr_55484[(10)] = inst_55452);

(statearr_55484[(7)] = inst_55436);

(statearr_55484[(8)] = inst_55437);

return statearr_55484;
})();
var statearr_55485_55515 = state_55472__$1;
(statearr_55485_55515[(2)] = null);

(statearr_55485_55515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (9))){
var inst_55436 = (state_55472[(7)]);
var inst_55450 = cljs.core.vec.call(null,inst_55436);
var state_55472__$1 = state_55472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55472__$1,(11),out,inst_55450);
} else {
if((state_val_55473 === (5))){
var inst_55436 = (state_55472[(7)]);
var inst_55440 = (state_55472[(9)]);
var inst_55437 = (state_55472[(8)]);
var inst_55445 = (state_55472[(11)]);
var inst_55444 = (inst_55436[inst_55437] = inst_55440);
var inst_55445__$1 = (inst_55437 + (1));
var inst_55446 = (inst_55445__$1 < n);
var state_55472__$1 = (function (){var statearr_55486 = state_55472;
(statearr_55486[(12)] = inst_55444);

(statearr_55486[(11)] = inst_55445__$1);

return statearr_55486;
})();
if(cljs.core.truth_(inst_55446)){
var statearr_55487_55516 = state_55472__$1;
(statearr_55487_55516[(1)] = (8));

} else {
var statearr_55488_55517 = state_55472__$1;
(statearr_55488_55517[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (14))){
var inst_55465 = (state_55472[(2)]);
var inst_55466 = cljs.core.async.close_BANG_.call(null,out);
var state_55472__$1 = (function (){var statearr_55490 = state_55472;
(statearr_55490[(13)] = inst_55465);

return statearr_55490;
})();
var statearr_55491_55518 = state_55472__$1;
(statearr_55491_55518[(2)] = inst_55466);

(statearr_55491_55518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (10))){
var inst_55456 = (state_55472[(2)]);
var state_55472__$1 = state_55472;
var statearr_55492_55519 = state_55472__$1;
(statearr_55492_55519[(2)] = inst_55456);

(statearr_55492_55519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55473 === (8))){
var inst_55436 = (state_55472[(7)]);
var inst_55445 = (state_55472[(11)]);
var tmp55489 = inst_55436;
var inst_55436__$1 = tmp55489;
var inst_55437 = inst_55445;
var state_55472__$1 = (function (){var statearr_55493 = state_55472;
(statearr_55493[(7)] = inst_55436__$1);

(statearr_55493[(8)] = inst_55437);

return statearr_55493;
})();
var statearr_55494_55520 = state_55472__$1;
(statearr_55494_55520[(2)] = null);

(statearr_55494_55520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___55506,out))
;
return ((function (switch__52692__auto__,c__52806__auto___55506,out){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_55498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55498[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_55498[(1)] = (1));

return statearr_55498;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_55472){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_55472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e55499){if((e55499 instanceof Object)){
var ex__52696__auto__ = e55499;
var statearr_55500_55521 = state_55472;
(statearr_55500_55521[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55499;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55522 = state_55472;
state_55472 = G__55522;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_55472){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_55472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___55506,out))
})();
var state__52808__auto__ = (function (){var statearr_55501 = f__52807__auto__.call(null);
(statearr_55501[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___55506);

return statearr_55501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___55506,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args55523 = [];
var len__51068__auto___55597 = arguments.length;
var i__51069__auto___55598 = (0);
while(true){
if((i__51069__auto___55598 < len__51068__auto___55597)){
args55523.push((arguments[i__51069__auto___55598]));

var G__55599 = (i__51069__auto___55598 + (1));
i__51069__auto___55598 = G__55599;
continue;
} else {
}
break;
}

var G__55525 = args55523.length;
switch (G__55525) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55523.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__52806__auto___55601 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___55601,out){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___55601,out){
return (function (state_55567){
var state_val_55568 = (state_55567[(1)]);
if((state_val_55568 === (7))){
var inst_55563 = (state_55567[(2)]);
var state_55567__$1 = state_55567;
var statearr_55569_55602 = state_55567__$1;
(statearr_55569_55602[(2)] = inst_55563);

(statearr_55569_55602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (1))){
var inst_55526 = [];
var inst_55527 = inst_55526;
var inst_55528 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_55567__$1 = (function (){var statearr_55570 = state_55567;
(statearr_55570[(7)] = inst_55527);

(statearr_55570[(8)] = inst_55528);

return statearr_55570;
})();
var statearr_55571_55603 = state_55567__$1;
(statearr_55571_55603[(2)] = null);

(statearr_55571_55603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (4))){
var inst_55531 = (state_55567[(9)]);
var inst_55531__$1 = (state_55567[(2)]);
var inst_55532 = (inst_55531__$1 == null);
var inst_55533 = cljs.core.not.call(null,inst_55532);
var state_55567__$1 = (function (){var statearr_55572 = state_55567;
(statearr_55572[(9)] = inst_55531__$1);

return statearr_55572;
})();
if(inst_55533){
var statearr_55573_55604 = state_55567__$1;
(statearr_55573_55604[(1)] = (5));

} else {
var statearr_55574_55605 = state_55567__$1;
(statearr_55574_55605[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (15))){
var inst_55557 = (state_55567[(2)]);
var state_55567__$1 = state_55567;
var statearr_55575_55606 = state_55567__$1;
(statearr_55575_55606[(2)] = inst_55557);

(statearr_55575_55606[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (13))){
var state_55567__$1 = state_55567;
var statearr_55576_55607 = state_55567__$1;
(statearr_55576_55607[(2)] = null);

(statearr_55576_55607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (6))){
var inst_55527 = (state_55567[(7)]);
var inst_55552 = inst_55527.length;
var inst_55553 = (inst_55552 > (0));
var state_55567__$1 = state_55567;
if(cljs.core.truth_(inst_55553)){
var statearr_55577_55608 = state_55567__$1;
(statearr_55577_55608[(1)] = (12));

} else {
var statearr_55578_55609 = state_55567__$1;
(statearr_55578_55609[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (3))){
var inst_55565 = (state_55567[(2)]);
var state_55567__$1 = state_55567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55567__$1,inst_55565);
} else {
if((state_val_55568 === (12))){
var inst_55527 = (state_55567[(7)]);
var inst_55555 = cljs.core.vec.call(null,inst_55527);
var state_55567__$1 = state_55567;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55567__$1,(15),out,inst_55555);
} else {
if((state_val_55568 === (2))){
var state_55567__$1 = state_55567;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55567__$1,(4),ch);
} else {
if((state_val_55568 === (11))){
var inst_55535 = (state_55567[(10)]);
var inst_55531 = (state_55567[(9)]);
var inst_55545 = (state_55567[(2)]);
var inst_55546 = [];
var inst_55547 = inst_55546.push(inst_55531);
var inst_55527 = inst_55546;
var inst_55528 = inst_55535;
var state_55567__$1 = (function (){var statearr_55579 = state_55567;
(statearr_55579[(11)] = inst_55545);

(statearr_55579[(12)] = inst_55547);

(statearr_55579[(7)] = inst_55527);

(statearr_55579[(8)] = inst_55528);

return statearr_55579;
})();
var statearr_55580_55610 = state_55567__$1;
(statearr_55580_55610[(2)] = null);

(statearr_55580_55610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (9))){
var inst_55527 = (state_55567[(7)]);
var inst_55543 = cljs.core.vec.call(null,inst_55527);
var state_55567__$1 = state_55567;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55567__$1,(11),out,inst_55543);
} else {
if((state_val_55568 === (5))){
var inst_55535 = (state_55567[(10)]);
var inst_55528 = (state_55567[(8)]);
var inst_55531 = (state_55567[(9)]);
var inst_55535__$1 = f.call(null,inst_55531);
var inst_55536 = cljs.core._EQ_.call(null,inst_55535__$1,inst_55528);
var inst_55537 = cljs.core.keyword_identical_QMARK_.call(null,inst_55528,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_55538 = (inst_55536) || (inst_55537);
var state_55567__$1 = (function (){var statearr_55581 = state_55567;
(statearr_55581[(10)] = inst_55535__$1);

return statearr_55581;
})();
if(cljs.core.truth_(inst_55538)){
var statearr_55582_55611 = state_55567__$1;
(statearr_55582_55611[(1)] = (8));

} else {
var statearr_55583_55612 = state_55567__$1;
(statearr_55583_55612[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (14))){
var inst_55560 = (state_55567[(2)]);
var inst_55561 = cljs.core.async.close_BANG_.call(null,out);
var state_55567__$1 = (function (){var statearr_55585 = state_55567;
(statearr_55585[(13)] = inst_55560);

return statearr_55585;
})();
var statearr_55586_55613 = state_55567__$1;
(statearr_55586_55613[(2)] = inst_55561);

(statearr_55586_55613[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (10))){
var inst_55550 = (state_55567[(2)]);
var state_55567__$1 = state_55567;
var statearr_55587_55614 = state_55567__$1;
(statearr_55587_55614[(2)] = inst_55550);

(statearr_55587_55614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (8))){
var inst_55535 = (state_55567[(10)]);
var inst_55527 = (state_55567[(7)]);
var inst_55531 = (state_55567[(9)]);
var inst_55540 = inst_55527.push(inst_55531);
var tmp55584 = inst_55527;
var inst_55527__$1 = tmp55584;
var inst_55528 = inst_55535;
var state_55567__$1 = (function (){var statearr_55588 = state_55567;
(statearr_55588[(14)] = inst_55540);

(statearr_55588[(7)] = inst_55527__$1);

(statearr_55588[(8)] = inst_55528);

return statearr_55588;
})();
var statearr_55589_55615 = state_55567__$1;
(statearr_55589_55615[(2)] = null);

(statearr_55589_55615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto___55601,out))
;
return ((function (switch__52692__auto__,c__52806__auto___55601,out){
return (function() {
var cljs$core$async$state_machine__52693__auto__ = null;
var cljs$core$async$state_machine__52693__auto____0 = (function (){
var statearr_55593 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55593[(0)] = cljs$core$async$state_machine__52693__auto__);

(statearr_55593[(1)] = (1));

return statearr_55593;
});
var cljs$core$async$state_machine__52693__auto____1 = (function (state_55567){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_55567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e55594){if((e55594 instanceof Object)){
var ex__52696__auto__ = e55594;
var statearr_55595_55616 = state_55567;
(statearr_55595_55616[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55594;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55617 = state_55567;
state_55567 = G__55617;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
cljs$core$async$state_machine__52693__auto__ = function(state_55567){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52693__auto____1.call(this,state_55567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52693__auto____0;
cljs$core$async$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52693__auto____1;
return cljs$core$async$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___55601,out))
})();
var state__52808__auto__ = (function (){var statearr_55596 = f__52807__auto__.call(null);
(statearr_55596[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___55601);

return statearr_55596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___55601,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1485613062005