// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__7775__auto__ = (((this$ == null))?null:this$);
var m__7776__auto__ = (hasch.benc._coerce[goog.typeOf(x__7775__auto__)]);
if(!((m__7776__auto__ == null))){
return m__7776__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__7776__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__7776__auto____$1 == null))){
return m__7776__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__12552_12556 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__12553_12557 = null;
var count__12554_12558 = (0);
var i__12555_12559 = (0);
while(true){
if((i__12555_12559 < count__12554_12558)){
var bs_12560 = cljs.core._nth.call(null,chunk__12553_12557,i__12555_12559);
md.update(bs_12560);

var G__12561 = seq__12552_12556;
var G__12562 = chunk__12553_12557;
var G__12563 = count__12554_12558;
var G__12564 = (i__12555_12559 + (1));
seq__12552_12556 = G__12561;
chunk__12553_12557 = G__12562;
count__12554_12558 = G__12563;
i__12555_12559 = G__12564;
continue;
} else {
var temp__6753__auto___12565 = cljs.core.seq.call(null,seq__12552_12556);
if(temp__6753__auto___12565){
var seq__12552_12566__$1 = temp__6753__auto___12565;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12552_12566__$1)){
var c__7968__auto___12567 = cljs.core.chunk_first.call(null,seq__12552_12566__$1);
var G__12568 = cljs.core.chunk_rest.call(null,seq__12552_12566__$1);
var G__12569 = c__7968__auto___12567;
var G__12570 = cljs.core.count.call(null,c__7968__auto___12567);
var G__12571 = (0);
seq__12552_12556 = G__12568;
chunk__12553_12557 = G__12569;
count__12554_12558 = G__12570;
i__12555_12559 = G__12571;
continue;
} else {
var bs_12572 = cljs.core.first.call(null,seq__12552_12566__$1);
md.update(bs_12572);

var G__12573 = cljs.core.next.call(null,seq__12552_12566__$1);
var G__12574 = null;
var G__12575 = (0);
var G__12576 = (0);
seq__12552_12556 = G__12573;
chunk__12553_12557 = G__12574;
count__12554_12558 = G__12575;
i__12555_12559 = G__12576;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_12583 = seq;
while(true){
var vec__12580_12584 = s_12583;
var seq__12581_12585 = cljs.core.seq.call(null,vec__12580_12584);
var first__12582_12586 = cljs.core.first.call(null,seq__12581_12585);
var seq__12581_12587__$1 = cljs.core.next.call(null,seq__12581_12585);
var f_12588 = first__12582_12586;
var r_12589 = seq__12581_12587__$1;
seq_md.update(hasch.benc._coerce.call(null,f_12588,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_12589)){
} else {
var G__12590 = cljs.core.rest.call(null,s_12583);
s_12583 = G__12590;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__7402__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__7403__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__7402__auto__ < y__7403__auto__) ? x__7402__auto__ : y__7403__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_12591 = (0);
while(true){
if((i_12591 < len)){
(acc[i_12591] = ((acc[i_12591]) ^ (elem[i_12591])));

var G__12592 = (i_12591 + (1));
i_12591 = G__12592;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_12593 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_12593,len)){
} else {
var e_12594 = (a[i_12593]);
if(((e_12594 > (0))) && ((e_12594 < (30)))){
(ea[i_12593] = (1));
} else {
}

var G__12595 = (i_12593 + (1));
i_12593 = G__12595;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});
