// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args9551 = [];
var len__8278__auto___9554 = arguments.length;
var i__8279__auto___9555 = (0);
while(true){
if((i__8279__auto___9555 < len__8278__auto___9554)){
args9551.push((arguments[i__8279__auto___9555]));

var G__9556 = (i__8279__auto___9555 + (1));
i__8279__auto___9555 = G__9556;
continue;
} else {
}
break;
}

var G__9553 = args9551.length;
switch (G__9553) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9551.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__9550_SHARP_){
if((p1__9550_SHARP_ < (0))){
return (p1__9550_SHARP_ + (256));
} else {
return p1__9550_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__7062__auto__ = write_handlers;
if(cljs.core.truth_(or__7062__auto__)){
return or__7062__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args9558 = [];
var len__8278__auto___9566 = arguments.length;
var i__8279__auto___9567 = (0);
while(true){
if((i__8279__auto___9567 < len__8278__auto___9566)){
args9558.push((arguments[i__8279__auto___9567]));

var G__9568 = (i__8279__auto___9567 + (1));
i__8279__auto___9567 = G__9568;
continue;
} else {
}
break;
}

var G__9562 = args9558.length;
switch (G__9562) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__8301__auto__ = (new cljs.core.IndexedSeq(args9558.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8301__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__9563){
var map__9564 = p__9563;
var map__9564__$1 = ((((!((map__9564 == null)))?((((map__9564.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9564.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9564):map__9564);
var write_handlers = cljs.core.get.call(null,map__9564__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq9559){
var G__9560 = cljs.core.first.call(null,seq9559);
var seq9559__$1 = cljs.core.next.call(null,seq9559);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__9560,seq9559__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);

