// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__49852__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__49852__auto__){
return or__49852__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__49852__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__49852__auto__)){
return or__49852__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__55752_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__55752_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__55757 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__55758 = null;
var count__55759 = (0);
var i__55760 = (0);
while(true){
if((i__55760 < count__55759)){
var n = cljs.core._nth.call(null,chunk__55758,i__55760);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__55761 = seq__55757;
var G__55762 = chunk__55758;
var G__55763 = count__55759;
var G__55764 = (i__55760 + (1));
seq__55757 = G__55761;
chunk__55758 = G__55762;
count__55759 = G__55763;
i__55760 = G__55764;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__55757);
if(temp__6753__auto__){
var seq__55757__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55757__$1)){
var c__50758__auto__ = cljs.core.chunk_first.call(null,seq__55757__$1);
var G__55765 = cljs.core.chunk_rest.call(null,seq__55757__$1);
var G__55766 = c__50758__auto__;
var G__55767 = cljs.core.count.call(null,c__50758__auto__);
var G__55768 = (0);
seq__55757 = G__55765;
chunk__55758 = G__55766;
count__55759 = G__55767;
i__55760 = G__55768;
continue;
} else {
var n = cljs.core.first.call(null,seq__55757__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__55769 = cljs.core.next.call(null,seq__55757__$1);
var G__55770 = null;
var G__55771 = (0);
var G__55772 = (0);
seq__55757 = G__55769;
chunk__55758 = G__55770;
count__55759 = G__55771;
i__55760 = G__55772;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__55823_55834 = cljs.core.seq.call(null,deps);
var chunk__55824_55835 = null;
var count__55825_55836 = (0);
var i__55826_55837 = (0);
while(true){
if((i__55826_55837 < count__55825_55836)){
var dep_55838 = cljs.core._nth.call(null,chunk__55824_55835,i__55826_55837);
topo_sort_helper_STAR_.call(null,dep_55838,(depth + (1)),state);

var G__55839 = seq__55823_55834;
var G__55840 = chunk__55824_55835;
var G__55841 = count__55825_55836;
var G__55842 = (i__55826_55837 + (1));
seq__55823_55834 = G__55839;
chunk__55824_55835 = G__55840;
count__55825_55836 = G__55841;
i__55826_55837 = G__55842;
continue;
} else {
var temp__6753__auto___55843 = cljs.core.seq.call(null,seq__55823_55834);
if(temp__6753__auto___55843){
var seq__55823_55844__$1 = temp__6753__auto___55843;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55823_55844__$1)){
var c__50758__auto___55845 = cljs.core.chunk_first.call(null,seq__55823_55844__$1);
var G__55846 = cljs.core.chunk_rest.call(null,seq__55823_55844__$1);
var G__55847 = c__50758__auto___55845;
var G__55848 = cljs.core.count.call(null,c__50758__auto___55845);
var G__55849 = (0);
seq__55823_55834 = G__55846;
chunk__55824_55835 = G__55847;
count__55825_55836 = G__55848;
i__55826_55837 = G__55849;
continue;
} else {
var dep_55850 = cljs.core.first.call(null,seq__55823_55844__$1);
topo_sort_helper_STAR_.call(null,dep_55850,(depth + (1)),state);

var G__55851 = cljs.core.next.call(null,seq__55823_55844__$1);
var G__55852 = null;
var G__55853 = (0);
var G__55854 = (0);
seq__55823_55834 = G__55851;
chunk__55824_55835 = G__55852;
count__55825_55836 = G__55853;
i__55826_55837 = G__55854;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__55827){
var vec__55831 = p__55827;
var seq__55832 = cljs.core.seq.call(null,vec__55831);
var first__55833 = cljs.core.first.call(null,seq__55832);
var seq__55832__$1 = cljs.core.next.call(null,seq__55832);
var x = first__55833;
var xs = seq__55832__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__55831,seq__55832,first__55833,seq__55832__$1,x,xs,get_deps__$1){
return (function (p1__55773_SHARP_){
return clojure.set.difference.call(null,p1__55773_SHARP_,x);
});})(vec__55831,seq__55832,first__55833,seq__55832__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__55867 = cljs.core.seq.call(null,provides);
var chunk__55868 = null;
var count__55869 = (0);
var i__55870 = (0);
while(true){
if((i__55870 < count__55869)){
var prov = cljs.core._nth.call(null,chunk__55868,i__55870);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__55871_55879 = cljs.core.seq.call(null,requires);
var chunk__55872_55880 = null;
var count__55873_55881 = (0);
var i__55874_55882 = (0);
while(true){
if((i__55874_55882 < count__55873_55881)){
var req_55883 = cljs.core._nth.call(null,chunk__55872_55880,i__55874_55882);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_55883,prov);

var G__55884 = seq__55871_55879;
var G__55885 = chunk__55872_55880;
var G__55886 = count__55873_55881;
var G__55887 = (i__55874_55882 + (1));
seq__55871_55879 = G__55884;
chunk__55872_55880 = G__55885;
count__55873_55881 = G__55886;
i__55874_55882 = G__55887;
continue;
} else {
var temp__6753__auto___55888 = cljs.core.seq.call(null,seq__55871_55879);
if(temp__6753__auto___55888){
var seq__55871_55889__$1 = temp__6753__auto___55888;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55871_55889__$1)){
var c__50758__auto___55890 = cljs.core.chunk_first.call(null,seq__55871_55889__$1);
var G__55891 = cljs.core.chunk_rest.call(null,seq__55871_55889__$1);
var G__55892 = c__50758__auto___55890;
var G__55893 = cljs.core.count.call(null,c__50758__auto___55890);
var G__55894 = (0);
seq__55871_55879 = G__55891;
chunk__55872_55880 = G__55892;
count__55873_55881 = G__55893;
i__55874_55882 = G__55894;
continue;
} else {
var req_55895 = cljs.core.first.call(null,seq__55871_55889__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_55895,prov);

var G__55896 = cljs.core.next.call(null,seq__55871_55889__$1);
var G__55897 = null;
var G__55898 = (0);
var G__55899 = (0);
seq__55871_55879 = G__55896;
chunk__55872_55880 = G__55897;
count__55873_55881 = G__55898;
i__55874_55882 = G__55899;
continue;
}
} else {
}
}
break;
}

var G__55900 = seq__55867;
var G__55901 = chunk__55868;
var G__55902 = count__55869;
var G__55903 = (i__55870 + (1));
seq__55867 = G__55900;
chunk__55868 = G__55901;
count__55869 = G__55902;
i__55870 = G__55903;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__55867);
if(temp__6753__auto__){
var seq__55867__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55867__$1)){
var c__50758__auto__ = cljs.core.chunk_first.call(null,seq__55867__$1);
var G__55904 = cljs.core.chunk_rest.call(null,seq__55867__$1);
var G__55905 = c__50758__auto__;
var G__55906 = cljs.core.count.call(null,c__50758__auto__);
var G__55907 = (0);
seq__55867 = G__55904;
chunk__55868 = G__55905;
count__55869 = G__55906;
i__55870 = G__55907;
continue;
} else {
var prov = cljs.core.first.call(null,seq__55867__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__55875_55908 = cljs.core.seq.call(null,requires);
var chunk__55876_55909 = null;
var count__55877_55910 = (0);
var i__55878_55911 = (0);
while(true){
if((i__55878_55911 < count__55877_55910)){
var req_55912 = cljs.core._nth.call(null,chunk__55876_55909,i__55878_55911);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_55912,prov);

var G__55913 = seq__55875_55908;
var G__55914 = chunk__55876_55909;
var G__55915 = count__55877_55910;
var G__55916 = (i__55878_55911 + (1));
seq__55875_55908 = G__55913;
chunk__55876_55909 = G__55914;
count__55877_55910 = G__55915;
i__55878_55911 = G__55916;
continue;
} else {
var temp__6753__auto___55917__$1 = cljs.core.seq.call(null,seq__55875_55908);
if(temp__6753__auto___55917__$1){
var seq__55875_55918__$1 = temp__6753__auto___55917__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55875_55918__$1)){
var c__50758__auto___55919 = cljs.core.chunk_first.call(null,seq__55875_55918__$1);
var G__55920 = cljs.core.chunk_rest.call(null,seq__55875_55918__$1);
var G__55921 = c__50758__auto___55919;
var G__55922 = cljs.core.count.call(null,c__50758__auto___55919);
var G__55923 = (0);
seq__55875_55908 = G__55920;
chunk__55876_55909 = G__55921;
count__55877_55910 = G__55922;
i__55878_55911 = G__55923;
continue;
} else {
var req_55924 = cljs.core.first.call(null,seq__55875_55918__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_55924,prov);

var G__55925 = cljs.core.next.call(null,seq__55875_55918__$1);
var G__55926 = null;
var G__55927 = (0);
var G__55928 = (0);
seq__55875_55908 = G__55925;
chunk__55876_55909 = G__55926;
count__55877_55910 = G__55927;
i__55878_55911 = G__55928;
continue;
}
} else {
}
}
break;
}

var G__55929 = cljs.core.next.call(null,seq__55867__$1);
var G__55930 = null;
var G__55931 = (0);
var G__55932 = (0);
seq__55867 = G__55929;
chunk__55868 = G__55930;
count__55869 = G__55931;
i__55870 = G__55932;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__55937_55941 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__55938_55942 = null;
var count__55939_55943 = (0);
var i__55940_55944 = (0);
while(true){
if((i__55940_55944 < count__55939_55943)){
var ns_55945 = cljs.core._nth.call(null,chunk__55938_55942,i__55940_55944);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_55945);

var G__55946 = seq__55937_55941;
var G__55947 = chunk__55938_55942;
var G__55948 = count__55939_55943;
var G__55949 = (i__55940_55944 + (1));
seq__55937_55941 = G__55946;
chunk__55938_55942 = G__55947;
count__55939_55943 = G__55948;
i__55940_55944 = G__55949;
continue;
} else {
var temp__6753__auto___55950 = cljs.core.seq.call(null,seq__55937_55941);
if(temp__6753__auto___55950){
var seq__55937_55951__$1 = temp__6753__auto___55950;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55937_55951__$1)){
var c__50758__auto___55952 = cljs.core.chunk_first.call(null,seq__55937_55951__$1);
var G__55953 = cljs.core.chunk_rest.call(null,seq__55937_55951__$1);
var G__55954 = c__50758__auto___55952;
var G__55955 = cljs.core.count.call(null,c__50758__auto___55952);
var G__55956 = (0);
seq__55937_55941 = G__55953;
chunk__55938_55942 = G__55954;
count__55939_55943 = G__55955;
i__55940_55944 = G__55956;
continue;
} else {
var ns_55957 = cljs.core.first.call(null,seq__55937_55951__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_55957);

var G__55958 = cljs.core.next.call(null,seq__55937_55951__$1);
var G__55959 = null;
var G__55960 = (0);
var G__55961 = (0);
seq__55937_55941 = G__55958;
chunk__55938_55942 = G__55959;
count__55939_55943 = G__55960;
i__55940_55944 = G__55961;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__49852__auto__ = goog.require__;
if(cljs.core.truth_(or__49852__auto__)){
return or__49852__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__55962__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__55962 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__55963__i = 0, G__55963__a = new Array(arguments.length -  0);
while (G__55963__i < G__55963__a.length) {G__55963__a[G__55963__i] = arguments[G__55963__i + 0]; ++G__55963__i;}
  args = new cljs.core.IndexedSeq(G__55963__a,0);
} 
return G__55962__delegate.call(this,args);};
G__55962.cljs$lang$maxFixedArity = 0;
G__55962.cljs$lang$applyTo = (function (arglist__55964){
var args = cljs.core.seq(arglist__55964);
return G__55962__delegate(args);
});
G__55962.cljs$core$IFn$_invoke$arity$variadic = G__55962__delegate;
return G__55962;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__55966 = cljs.core._EQ_;
var expr__55967 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__55966.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__55967))){
var path_parts = ((function (pred__55966,expr__55967){
return (function (p1__55965_SHARP_){
return clojure.string.split.call(null,p1__55965_SHARP_,/[\/\\]/);
});})(pred__55966,expr__55967))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__55966,expr__55967){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e55969){if((e55969 instanceof Error)){
var e = e55969;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e55969;

}
}})());
});
;})(path_parts,sep,root,pred__55966,expr__55967))
} else {
if(cljs.core.truth_(pred__55966.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__55967))){
return ((function (pred__55966,expr__55967){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__55966,expr__55967){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__55966,expr__55967))
);

return deferred.addErrback(((function (deferred,pred__55966,expr__55967){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__55966,expr__55967))
);
});
;})(pred__55966,expr__55967))
} else {
return ((function (pred__55966,expr__55967){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__55966,expr__55967))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__55970,callback){
var map__55973 = p__55970;
var map__55973__$1 = ((((!((map__55973 == null)))?((((map__55973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55973.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55973):map__55973);
var file_msg = map__55973__$1;
var request_url = cljs.core.get.call(null,map__55973__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__55973,map__55973__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__55973,map__55973__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__52806__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto__){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto__){
return (function (state_55997){
var state_val_55998 = (state_55997[(1)]);
if((state_val_55998 === (7))){
var inst_55993 = (state_55997[(2)]);
var state_55997__$1 = state_55997;
var statearr_55999_56019 = state_55997__$1;
(statearr_55999_56019[(2)] = inst_55993);

(statearr_55999_56019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55998 === (1))){
var state_55997__$1 = state_55997;
var statearr_56000_56020 = state_55997__$1;
(statearr_56000_56020[(2)] = null);

(statearr_56000_56020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55998 === (4))){
var inst_55977 = (state_55997[(7)]);
var inst_55977__$1 = (state_55997[(2)]);
var state_55997__$1 = (function (){var statearr_56001 = state_55997;
(statearr_56001[(7)] = inst_55977__$1);

return statearr_56001;
})();
if(cljs.core.truth_(inst_55977__$1)){
var statearr_56002_56021 = state_55997__$1;
(statearr_56002_56021[(1)] = (5));

} else {
var statearr_56003_56022 = state_55997__$1;
(statearr_56003_56022[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55998 === (6))){
var state_55997__$1 = state_55997;
var statearr_56004_56023 = state_55997__$1;
(statearr_56004_56023[(2)] = null);

(statearr_56004_56023[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55998 === (3))){
var inst_55995 = (state_55997[(2)]);
var state_55997__$1 = state_55997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55997__$1,inst_55995);
} else {
if((state_val_55998 === (2))){
var state_55997__$1 = state_55997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55997__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_55998 === (11))){
var inst_55989 = (state_55997[(2)]);
var state_55997__$1 = (function (){var statearr_56005 = state_55997;
(statearr_56005[(8)] = inst_55989);

return statearr_56005;
})();
var statearr_56006_56024 = state_55997__$1;
(statearr_56006_56024[(2)] = null);

(statearr_56006_56024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55998 === (9))){
var inst_55983 = (state_55997[(9)]);
var inst_55981 = (state_55997[(10)]);
var inst_55985 = inst_55983.call(null,inst_55981);
var state_55997__$1 = state_55997;
var statearr_56007_56025 = state_55997__$1;
(statearr_56007_56025[(2)] = inst_55985);

(statearr_56007_56025[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55998 === (5))){
var inst_55977 = (state_55997[(7)]);
var inst_55979 = figwheel.client.file_reloading.blocking_load.call(null,inst_55977);
var state_55997__$1 = state_55997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55997__$1,(8),inst_55979);
} else {
if((state_val_55998 === (10))){
var inst_55981 = (state_55997[(10)]);
var inst_55987 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_55981);
var state_55997__$1 = state_55997;
var statearr_56008_56026 = state_55997__$1;
(statearr_56008_56026[(2)] = inst_55987);

(statearr_56008_56026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55998 === (8))){
var inst_55977 = (state_55997[(7)]);
var inst_55983 = (state_55997[(9)]);
var inst_55981 = (state_55997[(2)]);
var inst_55982 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_55983__$1 = cljs.core.get.call(null,inst_55982,inst_55977);
var state_55997__$1 = (function (){var statearr_56009 = state_55997;
(statearr_56009[(9)] = inst_55983__$1);

(statearr_56009[(10)] = inst_55981);

return statearr_56009;
})();
if(cljs.core.truth_(inst_55983__$1)){
var statearr_56010_56027 = state_55997__$1;
(statearr_56010_56027[(1)] = (9));

} else {
var statearr_56011_56028 = state_55997__$1;
(statearr_56011_56028[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto__))
;
return ((function (switch__52692__auto__,c__52806__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__52693__auto__ = null;
var figwheel$client$file_reloading$state_machine__52693__auto____0 = (function (){
var statearr_56015 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_56015[(0)] = figwheel$client$file_reloading$state_machine__52693__auto__);

(statearr_56015[(1)] = (1));

return statearr_56015;
});
var figwheel$client$file_reloading$state_machine__52693__auto____1 = (function (state_55997){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_55997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e56016){if((e56016 instanceof Object)){
var ex__52696__auto__ = e56016;
var statearr_56017_56029 = state_55997;
(statearr_56017_56029[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55997);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56016;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56030 = state_55997;
state_55997 = G__56030;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__52693__auto__ = function(state_55997){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__52693__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__52693__auto____1.call(this,state_55997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__52693__auto____0;
figwheel$client$file_reloading$state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__52693__auto____1;
return figwheel$client$file_reloading$state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto__))
})();
var state__52808__auto__ = (function (){var statearr_56018 = f__52807__auto__.call(null);
(statearr_56018[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto__);

return statearr_56018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto__))
);

return c__52806__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__56031,callback){
var map__56034 = p__56031;
var map__56034__$1 = ((((!((map__56034 == null)))?((((map__56034.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56034.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56034):map__56034);
var file_msg = map__56034__$1;
var namespace = cljs.core.get.call(null,map__56034__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__56034,map__56034__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__56034,map__56034__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__56036){
var map__56039 = p__56036;
var map__56039__$1 = ((((!((map__56039 == null)))?((((map__56039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56039.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56039):map__56039);
var file_msg = map__56039__$1;
var namespace = cljs.core.get.call(null,map__56039__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__49840__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__49840__auto__){
var or__49852__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__49852__auto__)){
return or__49852__auto__;
} else {
var or__49852__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__49852__auto____$1)){
return or__49852__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__49840__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__56041,callback){
var map__56044 = p__56041;
var map__56044__$1 = ((((!((map__56044 == null)))?((((map__56044.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56044.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56044):map__56044);
var file_msg = map__56044__$1;
var request_url = cljs.core.get.call(null,map__56044__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__56044__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__52806__auto___56148 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto___56148,out){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto___56148,out){
return (function (state_56130){
var state_val_56131 = (state_56130[(1)]);
if((state_val_56131 === (1))){
var inst_56104 = cljs.core.seq.call(null,files);
var inst_56105 = cljs.core.first.call(null,inst_56104);
var inst_56106 = cljs.core.next.call(null,inst_56104);
var inst_56107 = files;
var state_56130__$1 = (function (){var statearr_56132 = state_56130;
(statearr_56132[(7)] = inst_56107);

(statearr_56132[(8)] = inst_56106);

(statearr_56132[(9)] = inst_56105);

return statearr_56132;
})();
var statearr_56133_56149 = state_56130__$1;
(statearr_56133_56149[(2)] = null);

(statearr_56133_56149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56131 === (2))){
var inst_56107 = (state_56130[(7)]);
var inst_56113 = (state_56130[(10)]);
var inst_56112 = cljs.core.seq.call(null,inst_56107);
var inst_56113__$1 = cljs.core.first.call(null,inst_56112);
var inst_56114 = cljs.core.next.call(null,inst_56112);
var inst_56115 = (inst_56113__$1 == null);
var inst_56116 = cljs.core.not.call(null,inst_56115);
var state_56130__$1 = (function (){var statearr_56134 = state_56130;
(statearr_56134[(11)] = inst_56114);

(statearr_56134[(10)] = inst_56113__$1);

return statearr_56134;
})();
if(inst_56116){
var statearr_56135_56150 = state_56130__$1;
(statearr_56135_56150[(1)] = (4));

} else {
var statearr_56136_56151 = state_56130__$1;
(statearr_56136_56151[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56131 === (3))){
var inst_56128 = (state_56130[(2)]);
var state_56130__$1 = state_56130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56130__$1,inst_56128);
} else {
if((state_val_56131 === (4))){
var inst_56113 = (state_56130[(10)]);
var inst_56118 = figwheel.client.file_reloading.reload_js_file.call(null,inst_56113);
var state_56130__$1 = state_56130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56130__$1,(7),inst_56118);
} else {
if((state_val_56131 === (5))){
var inst_56124 = cljs.core.async.close_BANG_.call(null,out);
var state_56130__$1 = state_56130;
var statearr_56137_56152 = state_56130__$1;
(statearr_56137_56152[(2)] = inst_56124);

(statearr_56137_56152[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56131 === (6))){
var inst_56126 = (state_56130[(2)]);
var state_56130__$1 = state_56130;
var statearr_56138_56153 = state_56130__$1;
(statearr_56138_56153[(2)] = inst_56126);

(statearr_56138_56153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56131 === (7))){
var inst_56114 = (state_56130[(11)]);
var inst_56120 = (state_56130[(2)]);
var inst_56121 = cljs.core.async.put_BANG_.call(null,out,inst_56120);
var inst_56107 = inst_56114;
var state_56130__$1 = (function (){var statearr_56139 = state_56130;
(statearr_56139[(7)] = inst_56107);

(statearr_56139[(12)] = inst_56121);

return statearr_56139;
})();
var statearr_56140_56154 = state_56130__$1;
(statearr_56140_56154[(2)] = null);

(statearr_56140_56154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__52806__auto___56148,out))
;
return ((function (switch__52692__auto__,c__52806__auto___56148,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto____0 = (function (){
var statearr_56144 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56144[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto__);

(statearr_56144[(1)] = (1));

return statearr_56144;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto____1 = (function (state_56130){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_56130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e56145){if((e56145 instanceof Object)){
var ex__52696__auto__ = e56145;
var statearr_56146_56155 = state_56130;
(statearr_56146_56155[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56130);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56145;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56156 = state_56130;
state_56130 = G__56156;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto__ = function(state_56130){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto____1.call(this,state_56130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto___56148,out))
})();
var state__52808__auto__ = (function (){var statearr_56147 = f__52807__auto__.call(null);
(statearr_56147[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto___56148);

return statearr_56147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto___56148,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__56157,opts){
var map__56161 = p__56157;
var map__56161__$1 = ((((!((map__56161 == null)))?((((map__56161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56161):map__56161);
var eval_body = cljs.core.get.call(null,map__56161__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__56161__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__49840__auto__ = eval_body;
if(cljs.core.truth_(and__49840__auto__)){
return typeof eval_body === 'string';
} else {
return and__49840__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e56163){var e = e56163;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__56164_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__56164_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__56173){
var vec__56174 = p__56173;
var k = cljs.core.nth.call(null,vec__56174,(0),null);
var v = cljs.core.nth.call(null,vec__56174,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__56177){
var vec__56178 = p__56177;
var k = cljs.core.nth.call(null,vec__56178,(0),null);
var v = cljs.core.nth.call(null,vec__56178,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__56184,p__56185){
var map__56433 = p__56184;
var map__56433__$1 = ((((!((map__56433 == null)))?((((map__56433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56433.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56433):map__56433);
var opts = map__56433__$1;
var before_jsload = cljs.core.get.call(null,map__56433__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__56433__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__56433__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__56434 = p__56185;
var map__56434__$1 = ((((!((map__56434 == null)))?((((map__56434.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56434.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56434):map__56434);
var msg = map__56434__$1;
var files = cljs.core.get.call(null,map__56434__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__56434__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__56434__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__52806__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__52807__auto__ = (function (){var switch__52692__auto__ = ((function (c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_56588){
var state_val_56589 = (state_56588[(1)]);
if((state_val_56589 === (7))){
var inst_56450 = (state_56588[(7)]);
var inst_56449 = (state_56588[(8)]);
var inst_56451 = (state_56588[(9)]);
var inst_56448 = (state_56588[(10)]);
var inst_56456 = cljs.core._nth.call(null,inst_56449,inst_56451);
var inst_56457 = figwheel.client.file_reloading.eval_body.call(null,inst_56456,opts);
var inst_56458 = (inst_56451 + (1));
var tmp56590 = inst_56450;
var tmp56591 = inst_56449;
var tmp56592 = inst_56448;
var inst_56448__$1 = tmp56592;
var inst_56449__$1 = tmp56591;
var inst_56450__$1 = tmp56590;
var inst_56451__$1 = inst_56458;
var state_56588__$1 = (function (){var statearr_56593 = state_56588;
(statearr_56593[(7)] = inst_56450__$1);

(statearr_56593[(8)] = inst_56449__$1);

(statearr_56593[(9)] = inst_56451__$1);

(statearr_56593[(10)] = inst_56448__$1);

(statearr_56593[(11)] = inst_56457);

return statearr_56593;
})();
var statearr_56594_56680 = state_56588__$1;
(statearr_56594_56680[(2)] = null);

(statearr_56594_56680[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (20))){
var inst_56491 = (state_56588[(12)]);
var inst_56499 = figwheel.client.file_reloading.sort_files.call(null,inst_56491);
var state_56588__$1 = state_56588;
var statearr_56595_56681 = state_56588__$1;
(statearr_56595_56681[(2)] = inst_56499);

(statearr_56595_56681[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (27))){
var state_56588__$1 = state_56588;
var statearr_56596_56682 = state_56588__$1;
(statearr_56596_56682[(2)] = null);

(statearr_56596_56682[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (1))){
var inst_56440 = (state_56588[(13)]);
var inst_56437 = before_jsload.call(null,files);
var inst_56438 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_56439 = (function (){return ((function (inst_56440,inst_56437,inst_56438,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__56181_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__56181_SHARP_);
});
;})(inst_56440,inst_56437,inst_56438,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56440__$1 = cljs.core.filter.call(null,inst_56439,files);
var inst_56441 = cljs.core.not_empty.call(null,inst_56440__$1);
var state_56588__$1 = (function (){var statearr_56597 = state_56588;
(statearr_56597[(13)] = inst_56440__$1);

(statearr_56597[(14)] = inst_56437);

(statearr_56597[(15)] = inst_56438);

return statearr_56597;
})();
if(cljs.core.truth_(inst_56441)){
var statearr_56598_56683 = state_56588__$1;
(statearr_56598_56683[(1)] = (2));

} else {
var statearr_56599_56684 = state_56588__$1;
(statearr_56599_56684[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (24))){
var state_56588__$1 = state_56588;
var statearr_56600_56685 = state_56588__$1;
(statearr_56600_56685[(2)] = null);

(statearr_56600_56685[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (39))){
var inst_56541 = (state_56588[(16)]);
var state_56588__$1 = state_56588;
var statearr_56601_56686 = state_56588__$1;
(statearr_56601_56686[(2)] = inst_56541);

(statearr_56601_56686[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (46))){
var inst_56583 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
var statearr_56602_56687 = state_56588__$1;
(statearr_56602_56687[(2)] = inst_56583);

(statearr_56602_56687[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (4))){
var inst_56485 = (state_56588[(2)]);
var inst_56486 = cljs.core.List.EMPTY;
var inst_56487 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_56486);
var inst_56488 = (function (){return ((function (inst_56485,inst_56486,inst_56487,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__56182_SHARP_){
var and__49840__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__56182_SHARP_);
if(cljs.core.truth_(and__49840__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__56182_SHARP_));
} else {
return and__49840__auto__;
}
});
;})(inst_56485,inst_56486,inst_56487,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56489 = cljs.core.filter.call(null,inst_56488,files);
var inst_56490 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_56491 = cljs.core.concat.call(null,inst_56489,inst_56490);
var state_56588__$1 = (function (){var statearr_56603 = state_56588;
(statearr_56603[(17)] = inst_56487);

(statearr_56603[(12)] = inst_56491);

(statearr_56603[(18)] = inst_56485);

return statearr_56603;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_56604_56688 = state_56588__$1;
(statearr_56604_56688[(1)] = (16));

} else {
var statearr_56605_56689 = state_56588__$1;
(statearr_56605_56689[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (15))){
var inst_56475 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
var statearr_56606_56690 = state_56588__$1;
(statearr_56606_56690[(2)] = inst_56475);

(statearr_56606_56690[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (21))){
var inst_56501 = (state_56588[(19)]);
var inst_56501__$1 = (state_56588[(2)]);
var inst_56502 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_56501__$1);
var state_56588__$1 = (function (){var statearr_56607 = state_56588;
(statearr_56607[(19)] = inst_56501__$1);

return statearr_56607;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56588__$1,(22),inst_56502);
} else {
if((state_val_56589 === (31))){
var inst_56586 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56588__$1,inst_56586);
} else {
if((state_val_56589 === (32))){
var inst_56541 = (state_56588[(16)]);
var inst_56546 = inst_56541.cljs$lang$protocol_mask$partition0$;
var inst_56547 = (inst_56546 & (64));
var inst_56548 = inst_56541.cljs$core$ISeq$;
var inst_56549 = (cljs.core.PROTOCOL_SENTINEL === inst_56548);
var inst_56550 = (inst_56547) || (inst_56549);
var state_56588__$1 = state_56588;
if(cljs.core.truth_(inst_56550)){
var statearr_56608_56691 = state_56588__$1;
(statearr_56608_56691[(1)] = (35));

} else {
var statearr_56609_56692 = state_56588__$1;
(statearr_56609_56692[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (40))){
var inst_56563 = (state_56588[(20)]);
var inst_56562 = (state_56588[(2)]);
var inst_56563__$1 = cljs.core.get.call(null,inst_56562,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_56564 = cljs.core.get.call(null,inst_56562,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_56565 = cljs.core.not_empty.call(null,inst_56563__$1);
var state_56588__$1 = (function (){var statearr_56610 = state_56588;
(statearr_56610[(21)] = inst_56564);

(statearr_56610[(20)] = inst_56563__$1);

return statearr_56610;
})();
if(cljs.core.truth_(inst_56565)){
var statearr_56611_56693 = state_56588__$1;
(statearr_56611_56693[(1)] = (41));

} else {
var statearr_56612_56694 = state_56588__$1;
(statearr_56612_56694[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (33))){
var state_56588__$1 = state_56588;
var statearr_56613_56695 = state_56588__$1;
(statearr_56613_56695[(2)] = false);

(statearr_56613_56695[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (13))){
var inst_56461 = (state_56588[(22)]);
var inst_56465 = cljs.core.chunk_first.call(null,inst_56461);
var inst_56466 = cljs.core.chunk_rest.call(null,inst_56461);
var inst_56467 = cljs.core.count.call(null,inst_56465);
var inst_56448 = inst_56466;
var inst_56449 = inst_56465;
var inst_56450 = inst_56467;
var inst_56451 = (0);
var state_56588__$1 = (function (){var statearr_56614 = state_56588;
(statearr_56614[(7)] = inst_56450);

(statearr_56614[(8)] = inst_56449);

(statearr_56614[(9)] = inst_56451);

(statearr_56614[(10)] = inst_56448);

return statearr_56614;
})();
var statearr_56615_56696 = state_56588__$1;
(statearr_56615_56696[(2)] = null);

(statearr_56615_56696[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (22))){
var inst_56501 = (state_56588[(19)]);
var inst_56505 = (state_56588[(23)]);
var inst_56504 = (state_56588[(24)]);
var inst_56509 = (state_56588[(25)]);
var inst_56504__$1 = (state_56588[(2)]);
var inst_56505__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_56504__$1);
var inst_56506 = (function (){var all_files = inst_56501;
var res_SINGLEQUOTE_ = inst_56504__$1;
var res = inst_56505__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_56501,inst_56505,inst_56504,inst_56509,inst_56504__$1,inst_56505__$1,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__56183_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__56183_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_56501,inst_56505,inst_56504,inst_56509,inst_56504__$1,inst_56505__$1,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56507 = cljs.core.filter.call(null,inst_56506,inst_56504__$1);
var inst_56508 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_56509__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_56508);
var inst_56510 = cljs.core.not_empty.call(null,inst_56509__$1);
var state_56588__$1 = (function (){var statearr_56616 = state_56588;
(statearr_56616[(26)] = inst_56507);

(statearr_56616[(23)] = inst_56505__$1);

(statearr_56616[(24)] = inst_56504__$1);

(statearr_56616[(25)] = inst_56509__$1);

return statearr_56616;
})();
if(cljs.core.truth_(inst_56510)){
var statearr_56617_56697 = state_56588__$1;
(statearr_56617_56697[(1)] = (23));

} else {
var statearr_56618_56698 = state_56588__$1;
(statearr_56618_56698[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (36))){
var state_56588__$1 = state_56588;
var statearr_56619_56699 = state_56588__$1;
(statearr_56619_56699[(2)] = false);

(statearr_56619_56699[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (41))){
var inst_56563 = (state_56588[(20)]);
var inst_56567 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_56568 = cljs.core.map.call(null,inst_56567,inst_56563);
var inst_56569 = cljs.core.pr_str.call(null,inst_56568);
var inst_56570 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_56569)].join('');
var inst_56571 = figwheel.client.utils.log.call(null,inst_56570);
var state_56588__$1 = state_56588;
var statearr_56620_56700 = state_56588__$1;
(statearr_56620_56700[(2)] = inst_56571);

(statearr_56620_56700[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (43))){
var inst_56564 = (state_56588[(21)]);
var inst_56574 = (state_56588[(2)]);
var inst_56575 = cljs.core.not_empty.call(null,inst_56564);
var state_56588__$1 = (function (){var statearr_56621 = state_56588;
(statearr_56621[(27)] = inst_56574);

return statearr_56621;
})();
if(cljs.core.truth_(inst_56575)){
var statearr_56622_56701 = state_56588__$1;
(statearr_56622_56701[(1)] = (44));

} else {
var statearr_56623_56702 = state_56588__$1;
(statearr_56623_56702[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (29))){
var inst_56507 = (state_56588[(26)]);
var inst_56501 = (state_56588[(19)]);
var inst_56541 = (state_56588[(16)]);
var inst_56505 = (state_56588[(23)]);
var inst_56504 = (state_56588[(24)]);
var inst_56509 = (state_56588[(25)]);
var inst_56537 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_56540 = (function (){var all_files = inst_56501;
var res_SINGLEQUOTE_ = inst_56504;
var res = inst_56505;
var files_not_loaded = inst_56507;
var dependencies_that_loaded = inst_56509;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56541,inst_56505,inst_56504,inst_56509,inst_56537,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__56539){
var map__56624 = p__56539;
var map__56624__$1 = ((((!((map__56624 == null)))?((((map__56624.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56624.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56624):map__56624);
var namespace = cljs.core.get.call(null,map__56624__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56541,inst_56505,inst_56504,inst_56509,inst_56537,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56541__$1 = cljs.core.group_by.call(null,inst_56540,inst_56507);
var inst_56543 = (inst_56541__$1 == null);
var inst_56544 = cljs.core.not.call(null,inst_56543);
var state_56588__$1 = (function (){var statearr_56626 = state_56588;
(statearr_56626[(16)] = inst_56541__$1);

(statearr_56626[(28)] = inst_56537);

return statearr_56626;
})();
if(inst_56544){
var statearr_56627_56703 = state_56588__$1;
(statearr_56627_56703[(1)] = (32));

} else {
var statearr_56628_56704 = state_56588__$1;
(statearr_56628_56704[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (44))){
var inst_56564 = (state_56588[(21)]);
var inst_56577 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_56564);
var inst_56578 = cljs.core.pr_str.call(null,inst_56577);
var inst_56579 = [cljs.core.str("not required: "),cljs.core.str(inst_56578)].join('');
var inst_56580 = figwheel.client.utils.log.call(null,inst_56579);
var state_56588__$1 = state_56588;
var statearr_56629_56705 = state_56588__$1;
(statearr_56629_56705[(2)] = inst_56580);

(statearr_56629_56705[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (6))){
var inst_56482 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
var statearr_56630_56706 = state_56588__$1;
(statearr_56630_56706[(2)] = inst_56482);

(statearr_56630_56706[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (28))){
var inst_56507 = (state_56588[(26)]);
var inst_56534 = (state_56588[(2)]);
var inst_56535 = cljs.core.not_empty.call(null,inst_56507);
var state_56588__$1 = (function (){var statearr_56631 = state_56588;
(statearr_56631[(29)] = inst_56534);

return statearr_56631;
})();
if(cljs.core.truth_(inst_56535)){
var statearr_56632_56707 = state_56588__$1;
(statearr_56632_56707[(1)] = (29));

} else {
var statearr_56633_56708 = state_56588__$1;
(statearr_56633_56708[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (25))){
var inst_56505 = (state_56588[(23)]);
var inst_56521 = (state_56588[(2)]);
var inst_56522 = cljs.core.not_empty.call(null,inst_56505);
var state_56588__$1 = (function (){var statearr_56634 = state_56588;
(statearr_56634[(30)] = inst_56521);

return statearr_56634;
})();
if(cljs.core.truth_(inst_56522)){
var statearr_56635_56709 = state_56588__$1;
(statearr_56635_56709[(1)] = (26));

} else {
var statearr_56636_56710 = state_56588__$1;
(statearr_56636_56710[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (34))){
var inst_56557 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
if(cljs.core.truth_(inst_56557)){
var statearr_56637_56711 = state_56588__$1;
(statearr_56637_56711[(1)] = (38));

} else {
var statearr_56638_56712 = state_56588__$1;
(statearr_56638_56712[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (17))){
var state_56588__$1 = state_56588;
var statearr_56639_56713 = state_56588__$1;
(statearr_56639_56713[(2)] = recompile_dependents);

(statearr_56639_56713[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (3))){
var state_56588__$1 = state_56588;
var statearr_56640_56714 = state_56588__$1;
(statearr_56640_56714[(2)] = null);

(statearr_56640_56714[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (12))){
var inst_56478 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
var statearr_56641_56715 = state_56588__$1;
(statearr_56641_56715[(2)] = inst_56478);

(statearr_56641_56715[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (2))){
var inst_56440 = (state_56588[(13)]);
var inst_56447 = cljs.core.seq.call(null,inst_56440);
var inst_56448 = inst_56447;
var inst_56449 = null;
var inst_56450 = (0);
var inst_56451 = (0);
var state_56588__$1 = (function (){var statearr_56642 = state_56588;
(statearr_56642[(7)] = inst_56450);

(statearr_56642[(8)] = inst_56449);

(statearr_56642[(9)] = inst_56451);

(statearr_56642[(10)] = inst_56448);

return statearr_56642;
})();
var statearr_56643_56716 = state_56588__$1;
(statearr_56643_56716[(2)] = null);

(statearr_56643_56716[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (23))){
var inst_56507 = (state_56588[(26)]);
var inst_56501 = (state_56588[(19)]);
var inst_56505 = (state_56588[(23)]);
var inst_56504 = (state_56588[(24)]);
var inst_56509 = (state_56588[(25)]);
var inst_56512 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_56514 = (function (){var all_files = inst_56501;
var res_SINGLEQUOTE_ = inst_56504;
var res = inst_56505;
var files_not_loaded = inst_56507;
var dependencies_that_loaded = inst_56509;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56505,inst_56504,inst_56509,inst_56512,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__56513){
var map__56644 = p__56513;
var map__56644__$1 = ((((!((map__56644 == null)))?((((map__56644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56644.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56644):map__56644);
var request_url = cljs.core.get.call(null,map__56644__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56505,inst_56504,inst_56509,inst_56512,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56515 = cljs.core.reverse.call(null,inst_56509);
var inst_56516 = cljs.core.map.call(null,inst_56514,inst_56515);
var inst_56517 = cljs.core.pr_str.call(null,inst_56516);
var inst_56518 = figwheel.client.utils.log.call(null,inst_56517);
var state_56588__$1 = (function (){var statearr_56646 = state_56588;
(statearr_56646[(31)] = inst_56512);

return statearr_56646;
})();
var statearr_56647_56717 = state_56588__$1;
(statearr_56647_56717[(2)] = inst_56518);

(statearr_56647_56717[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (35))){
var state_56588__$1 = state_56588;
var statearr_56648_56718 = state_56588__$1;
(statearr_56648_56718[(2)] = true);

(statearr_56648_56718[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (19))){
var inst_56491 = (state_56588[(12)]);
var inst_56497 = figwheel.client.file_reloading.expand_files.call(null,inst_56491);
var state_56588__$1 = state_56588;
var statearr_56649_56719 = state_56588__$1;
(statearr_56649_56719[(2)] = inst_56497);

(statearr_56649_56719[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (11))){
var state_56588__$1 = state_56588;
var statearr_56650_56720 = state_56588__$1;
(statearr_56650_56720[(2)] = null);

(statearr_56650_56720[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (9))){
var inst_56480 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
var statearr_56651_56721 = state_56588__$1;
(statearr_56651_56721[(2)] = inst_56480);

(statearr_56651_56721[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (5))){
var inst_56450 = (state_56588[(7)]);
var inst_56451 = (state_56588[(9)]);
var inst_56453 = (inst_56451 < inst_56450);
var inst_56454 = inst_56453;
var state_56588__$1 = state_56588;
if(cljs.core.truth_(inst_56454)){
var statearr_56652_56722 = state_56588__$1;
(statearr_56652_56722[(1)] = (7));

} else {
var statearr_56653_56723 = state_56588__$1;
(statearr_56653_56723[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (14))){
var inst_56461 = (state_56588[(22)]);
var inst_56470 = cljs.core.first.call(null,inst_56461);
var inst_56471 = figwheel.client.file_reloading.eval_body.call(null,inst_56470,opts);
var inst_56472 = cljs.core.next.call(null,inst_56461);
var inst_56448 = inst_56472;
var inst_56449 = null;
var inst_56450 = (0);
var inst_56451 = (0);
var state_56588__$1 = (function (){var statearr_56654 = state_56588;
(statearr_56654[(7)] = inst_56450);

(statearr_56654[(8)] = inst_56449);

(statearr_56654[(9)] = inst_56451);

(statearr_56654[(32)] = inst_56471);

(statearr_56654[(10)] = inst_56448);

return statearr_56654;
})();
var statearr_56655_56724 = state_56588__$1;
(statearr_56655_56724[(2)] = null);

(statearr_56655_56724[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (45))){
var state_56588__$1 = state_56588;
var statearr_56656_56725 = state_56588__$1;
(statearr_56656_56725[(2)] = null);

(statearr_56656_56725[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (26))){
var inst_56507 = (state_56588[(26)]);
var inst_56501 = (state_56588[(19)]);
var inst_56505 = (state_56588[(23)]);
var inst_56504 = (state_56588[(24)]);
var inst_56509 = (state_56588[(25)]);
var inst_56524 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_56526 = (function (){var all_files = inst_56501;
var res_SINGLEQUOTE_ = inst_56504;
var res = inst_56505;
var files_not_loaded = inst_56507;
var dependencies_that_loaded = inst_56509;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56505,inst_56504,inst_56509,inst_56524,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__56525){
var map__56657 = p__56525;
var map__56657__$1 = ((((!((map__56657 == null)))?((((map__56657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56657.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56657):map__56657);
var namespace = cljs.core.get.call(null,map__56657__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__56657__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56505,inst_56504,inst_56509,inst_56524,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56527 = cljs.core.map.call(null,inst_56526,inst_56505);
var inst_56528 = cljs.core.pr_str.call(null,inst_56527);
var inst_56529 = figwheel.client.utils.log.call(null,inst_56528);
var inst_56530 = (function (){var all_files = inst_56501;
var res_SINGLEQUOTE_ = inst_56504;
var res = inst_56505;
var files_not_loaded = inst_56507;
var dependencies_that_loaded = inst_56509;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56505,inst_56504,inst_56509,inst_56524,inst_56526,inst_56527,inst_56528,inst_56529,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_56507,inst_56501,inst_56505,inst_56504,inst_56509,inst_56524,inst_56526,inst_56527,inst_56528,inst_56529,state_val_56589,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56531 = setTimeout(inst_56530,(10));
var state_56588__$1 = (function (){var statearr_56659 = state_56588;
(statearr_56659[(33)] = inst_56529);

(statearr_56659[(34)] = inst_56524);

return statearr_56659;
})();
var statearr_56660_56726 = state_56588__$1;
(statearr_56660_56726[(2)] = inst_56531);

(statearr_56660_56726[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (16))){
var state_56588__$1 = state_56588;
var statearr_56661_56727 = state_56588__$1;
(statearr_56661_56727[(2)] = reload_dependents);

(statearr_56661_56727[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (38))){
var inst_56541 = (state_56588[(16)]);
var inst_56559 = cljs.core.apply.call(null,cljs.core.hash_map,inst_56541);
var state_56588__$1 = state_56588;
var statearr_56662_56728 = state_56588__$1;
(statearr_56662_56728[(2)] = inst_56559);

(statearr_56662_56728[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (30))){
var state_56588__$1 = state_56588;
var statearr_56663_56729 = state_56588__$1;
(statearr_56663_56729[(2)] = null);

(statearr_56663_56729[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (10))){
var inst_56461 = (state_56588[(22)]);
var inst_56463 = cljs.core.chunked_seq_QMARK_.call(null,inst_56461);
var state_56588__$1 = state_56588;
if(inst_56463){
var statearr_56664_56730 = state_56588__$1;
(statearr_56664_56730[(1)] = (13));

} else {
var statearr_56665_56731 = state_56588__$1;
(statearr_56665_56731[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (18))){
var inst_56495 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
if(cljs.core.truth_(inst_56495)){
var statearr_56666_56732 = state_56588__$1;
(statearr_56666_56732[(1)] = (19));

} else {
var statearr_56667_56733 = state_56588__$1;
(statearr_56667_56733[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (42))){
var state_56588__$1 = state_56588;
var statearr_56668_56734 = state_56588__$1;
(statearr_56668_56734[(2)] = null);

(statearr_56668_56734[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (37))){
var inst_56554 = (state_56588[(2)]);
var state_56588__$1 = state_56588;
var statearr_56669_56735 = state_56588__$1;
(statearr_56669_56735[(2)] = inst_56554);

(statearr_56669_56735[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56589 === (8))){
var inst_56448 = (state_56588[(10)]);
var inst_56461 = (state_56588[(22)]);
var inst_56461__$1 = cljs.core.seq.call(null,inst_56448);
var state_56588__$1 = (function (){var statearr_56670 = state_56588;
(statearr_56670[(22)] = inst_56461__$1);

return statearr_56670;
})();
if(inst_56461__$1){
var statearr_56671_56736 = state_56588__$1;
(statearr_56671_56736[(1)] = (10));

} else {
var statearr_56672_56737 = state_56588__$1;
(statearr_56672_56737[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__52692__auto__,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto____0 = (function (){
var statearr_56676 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56676[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto__);

(statearr_56676[(1)] = (1));

return statearr_56676;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto____1 = (function (state_56588){
while(true){
var ret_value__52694__auto__ = (function (){try{while(true){
var result__52695__auto__ = switch__52692__auto__.call(null,state_56588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__52695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52695__auto__;
}
break;
}
}catch (e56677){if((e56677 instanceof Object)){
var ex__52696__auto__ = e56677;
var statearr_56678_56738 = state_56588;
(statearr_56678_56738[(5)] = ex__52696__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56588);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56677;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__52694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56739 = state_56588;
state_56588 = G__56739;
continue;
} else {
return ret_value__52694__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto__ = function(state_56588){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto____1.call(this,state_56588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__52693__auto__;
})()
;})(switch__52692__auto__,c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__52808__auto__ = (function (){var statearr_56679 = f__52807__auto__.call(null);
(statearr_56679[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__52806__auto__);

return statearr_56679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__52808__auto__);
});})(c__52806__auto__,map__56433,map__56433__$1,opts,before_jsload,on_jsload,reload_dependents,map__56434,map__56434__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__52806__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__56742,link){
var map__56745 = p__56742;
var map__56745__$1 = ((((!((map__56745 == null)))?((((map__56745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56745.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56745):map__56745);
var file = cljs.core.get.call(null,map__56745__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__56745,map__56745__$1,file){
return (function (p1__56740_SHARP_,p2__56741_SHARP_){
if(cljs.core._EQ_.call(null,p1__56740_SHARP_,p2__56741_SHARP_)){
return p1__56740_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__56745,map__56745__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__56751){
var map__56752 = p__56751;
var map__56752__$1 = ((((!((map__56752 == null)))?((((map__56752.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56752.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56752):map__56752);
var match_length = cljs.core.get.call(null,map__56752__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__56752__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__56747_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__56747_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args56754 = [];
var len__51068__auto___56757 = arguments.length;
var i__51069__auto___56758 = (0);
while(true){
if((i__51069__auto___56758 < len__51068__auto___56757)){
args56754.push((arguments[i__51069__auto___56758]));

var G__56759 = (i__51069__auto___56758 + (1));
i__51069__auto___56758 = G__56759;
continue;
} else {
}
break;
}

var G__56756 = args56754.length;
switch (G__56756) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args56754.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__56761_SHARP_,p2__56762_SHARP_){
return cljs.core.assoc.call(null,p1__56761_SHARP_,cljs.core.get.call(null,p2__56762_SHARP_,key),p2__56762_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__56763){
var map__56766 = p__56763;
var map__56766__$1 = ((((!((map__56766 == null)))?((((map__56766.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56766.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56766):map__56766);
var f_data = map__56766__$1;
var file = cljs.core.get.call(null,map__56766__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__56768,p__56769){
var map__56778 = p__56768;
var map__56778__$1 = ((((!((map__56778 == null)))?((((map__56778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56778.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56778):map__56778);
var opts = map__56778__$1;
var on_cssload = cljs.core.get.call(null,map__56778__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__56779 = p__56769;
var map__56779__$1 = ((((!((map__56779 == null)))?((((map__56779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56779.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56779):map__56779);
var files_msg = map__56779__$1;
var files = cljs.core.get.call(null,map__56779__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__56782_56786 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__56783_56787 = null;
var count__56784_56788 = (0);
var i__56785_56789 = (0);
while(true){
if((i__56785_56789 < count__56784_56788)){
var f_56790 = cljs.core._nth.call(null,chunk__56783_56787,i__56785_56789);
figwheel.client.file_reloading.reload_css_file.call(null,f_56790);

var G__56791 = seq__56782_56786;
var G__56792 = chunk__56783_56787;
var G__56793 = count__56784_56788;
var G__56794 = (i__56785_56789 + (1));
seq__56782_56786 = G__56791;
chunk__56783_56787 = G__56792;
count__56784_56788 = G__56793;
i__56785_56789 = G__56794;
continue;
} else {
var temp__6753__auto___56795 = cljs.core.seq.call(null,seq__56782_56786);
if(temp__6753__auto___56795){
var seq__56782_56796__$1 = temp__6753__auto___56795;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56782_56796__$1)){
var c__50758__auto___56797 = cljs.core.chunk_first.call(null,seq__56782_56796__$1);
var G__56798 = cljs.core.chunk_rest.call(null,seq__56782_56796__$1);
var G__56799 = c__50758__auto___56797;
var G__56800 = cljs.core.count.call(null,c__50758__auto___56797);
var G__56801 = (0);
seq__56782_56786 = G__56798;
chunk__56783_56787 = G__56799;
count__56784_56788 = G__56800;
i__56785_56789 = G__56801;
continue;
} else {
var f_56802 = cljs.core.first.call(null,seq__56782_56796__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_56802);

var G__56803 = cljs.core.next.call(null,seq__56782_56796__$1);
var G__56804 = null;
var G__56805 = (0);
var G__56806 = (0);
seq__56782_56786 = G__56803;
chunk__56783_56787 = G__56804;
count__56784_56788 = G__56805;
i__56785_56789 = G__56806;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__56778,map__56778__$1,opts,on_cssload,map__56779,map__56779__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__56778,map__56778__$1,opts,on_cssload,map__56779,map__56779__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1485613062739