// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__50565__auto__ = (((this$ == null))?null:this$);
var m__50566__auto__ = (hasch.benc._coerce[goog.typeOf(x__50565__auto__)]);
if(!((m__50566__auto__ == null))){
return m__50566__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__50566__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__50566__auto____$1 == null))){
return m__50566__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__51336_51340 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__51337_51341 = null;
var count__51338_51342 = (0);
var i__51339_51343 = (0);
while(true){
if((i__51339_51343 < count__51338_51342)){
var bs_51344 = cljs.core._nth.call(null,chunk__51337_51341,i__51339_51343);
md.update(bs_51344);

var G__51345 = seq__51336_51340;
var G__51346 = chunk__51337_51341;
var G__51347 = count__51338_51342;
var G__51348 = (i__51339_51343 + (1));
seq__51336_51340 = G__51345;
chunk__51337_51341 = G__51346;
count__51338_51342 = G__51347;
i__51339_51343 = G__51348;
continue;
} else {
var temp__6753__auto___51349 = cljs.core.seq.call(null,seq__51336_51340);
if(temp__6753__auto___51349){
var seq__51336_51350__$1 = temp__6753__auto___51349;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51336_51350__$1)){
var c__50758__auto___51351 = cljs.core.chunk_first.call(null,seq__51336_51350__$1);
var G__51352 = cljs.core.chunk_rest.call(null,seq__51336_51350__$1);
var G__51353 = c__50758__auto___51351;
var G__51354 = cljs.core.count.call(null,c__50758__auto___51351);
var G__51355 = (0);
seq__51336_51340 = G__51352;
chunk__51337_51341 = G__51353;
count__51338_51342 = G__51354;
i__51339_51343 = G__51355;
continue;
} else {
var bs_51356 = cljs.core.first.call(null,seq__51336_51350__$1);
md.update(bs_51356);

var G__51357 = cljs.core.next.call(null,seq__51336_51350__$1);
var G__51358 = null;
var G__51359 = (0);
var G__51360 = (0);
seq__51336_51340 = G__51357;
chunk__51337_51341 = G__51358;
count__51338_51342 = G__51359;
i__51339_51343 = G__51360;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_51367 = seq;
while(true){
var vec__51364_51368 = s_51367;
var seq__51365_51369 = cljs.core.seq.call(null,vec__51364_51368);
var first__51366_51370 = cljs.core.first.call(null,seq__51365_51369);
var seq__51365_51371__$1 = cljs.core.next.call(null,seq__51365_51369);
var f_51372 = first__51366_51370;
var r_51373 = seq__51365_51371__$1;
seq_md.update(hasch.benc._coerce.call(null,f_51372,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_51373)){
} else {
var G__51374 = cljs.core.rest.call(null,s_51367);
s_51367 = G__51374;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__50192__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__50193__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__50192__auto__ < y__50193__auto__) ? x__50192__auto__ : y__50193__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_51375 = (0);
while(true){
if((i_51375 < len)){
(acc[i_51375] = ((acc[i_51375]) ^ (elem[i_51375])));

var G__51376 = (i_51375 + (1));
i_51375 = G__51376;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_51377 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_51377,len)){
} else {
var e_51378 = (a[i_51377]);
if(((e_51378 > (0))) && ((e_51378 < (30)))){
(ea[i_51377] = (1));
} else {
}

var G__51379 = (i_51377 + (1));
i_51377 = G__51379;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map?rel=1485613059514