// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 * 
 *   Please use the write-handlers only in legacy cases and rather extend the PHashCoercion
 *   protocol to your own types.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args59514 = [];
var len__51173__auto___59517 = arguments.length;
var i__51174__auto___59518 = (0);
while(true){
if((i__51174__auto___59518 < len__51173__auto___59517)){
args59514.push((arguments[i__51174__auto___59518]));

var G__59519 = (i__51174__auto___59518 + (1));
i__51174__auto___59518 = G__59519;
continue;
} else {
}
break;
}

var G__59516 = args59514.length;
switch (G__59516) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59514.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__59513_SHARP_){
if((p1__59513_SHARP_ < (0))){
return (p1__59513_SHARP_ + (256));
} else {
return p1__59513_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__49957__auto__ = write_handlers;
if(cljs.core.truth_(or__49957__auto__)){
return or__49957__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args59521 = [];
var len__51173__auto___59529 = arguments.length;
var i__51174__auto___59530 = (0);
while(true){
if((i__51174__auto___59530 < len__51173__auto___59529)){
args59521.push((arguments[i__51174__auto___59530]));

var G__59531 = (i__51174__auto___59530 + (1));
i__51174__auto___59530 = G__59531;
continue;
} else {
}
break;
}

var G__59525 = args59521.length;
switch (G__59525) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__51196__auto__ = (new cljs.core.IndexedSeq(args59521.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__51196__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__59526){
var map__59527 = p__59526;
var map__59527__$1 = ((((!((map__59527 == null)))?((((map__59527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59527.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59527):map__59527);
var write_handlers = cljs.core.get.call(null,map__59527__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq59522){
var G__59523 = cljs.core.first.call(null,seq59522);
var seq59522__$1 = cljs.core.next.call(null,seq59522);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__59523,seq59522__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);

/**
 * Calculates a sequential UUID as described in
 *   https://github.com/clojure-cookbook/clojure-cookbook/blob/master/01_primitive-data/1-24_uuids.asciidoc
 */
hasch.core.squuid = (function hasch$core$squuid(var_args){
var args59533 = [];
var len__51173__auto___59536 = arguments.length;
var i__51174__auto___59537 = (0);
while(true){
if((i__51174__auto___59537 < len__51173__auto___59536)){
args59533.push((arguments[i__51174__auto___59537]));

var G__59538 = (i__51174__auto___59537 + (1));
i__51174__auto___59537 = G__59538;
continue;
} else {
}
break;
}

var G__59535 = args59533.length;
switch (G__59535) {
case 0:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59533.length)].join('')));

}
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.squuid.call(null,hasch.core.uuid4.call(null));
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$1 = (function (uuid){
var time = (new Date()).getTime();
var secs = cljs.core.quot.call(null,time,(1000));
var prefix = secs.toString((16));
return cljs.core.uuid.call(null,[cljs.core.str(prefix),cljs.core.str(cljs.core.subs.call(null,[cljs.core.str(uuid)].join(''),(8)))].join(''));
});

hasch.core.squuid.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=core.js.map?rel=1494571732000