// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__7798__auto__ = (((this$ == null))?null:this$);
var m__7799__auto__ = (hasch.benc._coerce[goog.typeOf(x__7798__auto__)]);
if(!((m__7799__auto__ == null))){
return m__7799__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__7799__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__7799__auto____$1 == null))){
return m__7799__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__10112_10116 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__10113_10117 = null;
var count__10114_10118 = (0);
var i__10115_10119 = (0);
while(true){
if((i__10115_10119 < count__10114_10118)){
var bs_10120 = cljs.core._nth.call(null,chunk__10113_10117,i__10115_10119);
md.update(bs_10120);

var G__10121 = seq__10112_10116;
var G__10122 = chunk__10113_10117;
var G__10123 = count__10114_10118;
var G__10124 = (i__10115_10119 + (1));
seq__10112_10116 = G__10121;
chunk__10113_10117 = G__10122;
count__10114_10118 = G__10123;
i__10115_10119 = G__10124;
continue;
} else {
var temp__6753__auto___10125 = cljs.core.seq.call(null,seq__10112_10116);
if(temp__6753__auto___10125){
var seq__10112_10126__$1 = temp__6753__auto___10125;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10112_10126__$1)){
var c__7991__auto___10127 = cljs.core.chunk_first.call(null,seq__10112_10126__$1);
var G__10128 = cljs.core.chunk_rest.call(null,seq__10112_10126__$1);
var G__10129 = c__7991__auto___10127;
var G__10130 = cljs.core.count.call(null,c__7991__auto___10127);
var G__10131 = (0);
seq__10112_10116 = G__10128;
chunk__10113_10117 = G__10129;
count__10114_10118 = G__10130;
i__10115_10119 = G__10131;
continue;
} else {
var bs_10132 = cljs.core.first.call(null,seq__10112_10126__$1);
md.update(bs_10132);

var G__10133 = cljs.core.next.call(null,seq__10112_10126__$1);
var G__10134 = null;
var G__10135 = (0);
var G__10136 = (0);
seq__10112_10116 = G__10133;
chunk__10113_10117 = G__10134;
count__10114_10118 = G__10135;
i__10115_10119 = G__10136;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_10143 = seq;
while(true){
var vec__10140_10144 = s_10143;
var seq__10141_10145 = cljs.core.seq.call(null,vec__10140_10144);
var first__10142_10146 = cljs.core.first.call(null,seq__10141_10145);
var seq__10141_10147__$1 = cljs.core.next.call(null,seq__10141_10145);
var f_10148 = first__10142_10146;
var r_10149 = seq__10141_10147__$1;
seq_md.update(hasch.benc._coerce.call(null,f_10148,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_10149)){
} else {
var G__10150 = cljs.core.rest.call(null,s_10143);
s_10143 = G__10150;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__7425__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__7426__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__7425__auto__ < y__7426__auto__) ? x__7425__auto__ : y__7426__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_10151 = (0);
while(true){
if((i_10151 < len)){
(acc[i_10151] = ((acc[i_10151]) ^ (elem[i_10151])));

var G__10152 = (i_10151 + (1));
i_10151 = G__10152;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_10153 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_10153,len)){
} else {
var e_10154 = (a[i_10153]);
if(((e_10154 > (0))) && ((e_10154 < (30)))){
(ea[i_10153] = (1));
} else {
}

var G__10155 = (i_10153 + (1));
i_10153 = G__10155;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});
