// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.base64');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 * 
 *   Please use the write-handlers only in legacy cases and rather extend the PHashCoercion
 *   protocol to your own types.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args55029 = [];
var len__20433__auto___55032 = arguments.length;
var i__20434__auto___55033 = (0);
while(true){
if((i__20434__auto___55033 < len__20433__auto___55032)){
args55029.push((arguments[i__20434__auto___55033]));

var G__55034 = (i__20434__auto___55033 + (1));
i__20434__auto___55033 = G__55034;
continue;
} else {
}
break;
}

var G__55031 = args55029.length;
switch (G__55031) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55029.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__55028_SHARP_){
if((p1__55028_SHARP_ < (0))){
return (p1__55028_SHARP_ + (256));
} else {
return p1__55028_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__19157__auto__ = write_handlers;
if(cljs.core.truth_(or__19157__auto__)){
return or__19157__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args55036 = [];
var len__20433__auto___55044 = arguments.length;
var i__20434__auto___55045 = (0);
while(true){
if((i__20434__auto___55045 < len__20433__auto___55044)){
args55036.push((arguments[i__20434__auto___55045]));

var G__55046 = (i__20434__auto___55045 + (1));
i__20434__auto___55045 = G__55046;
continue;
} else {
}
break;
}

var G__55040 = args55036.length;
switch (G__55040) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__20468__auto__ = (new cljs.core.IndexedSeq(args55036.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__20468__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__55041){
var map__55042 = p__55041;
var map__55042__$1 = ((((!((map__55042 == null)))?((((map__55042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55042.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55042):map__55042);
var write_handlers = cljs.core.get.call(null,map__55042__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq55037){
var G__55038 = cljs.core.first.call(null,seq55037);
var seq55037__$1 = cljs.core.next.call(null,seq55037);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__55038,seq55037__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);

/**
 * Calculates a sequential UUID as described in
 *   https://github.com/clojure-cookbook/clojure-cookbook/blob/master/01_primitive-data/1-24_uuids.asciidoc
 */
hasch.core.squuid = (function hasch$core$squuid(var_args){
var args55048 = [];
var len__20433__auto___55051 = arguments.length;
var i__20434__auto___55052 = (0);
while(true){
if((i__20434__auto___55052 < len__20433__auto___55051)){
args55048.push((arguments[i__20434__auto___55052]));

var G__55053 = (i__20434__auto___55052 + (1));
i__20434__auto___55052 = G__55053;
continue;
} else {
}
break;
}

var G__55050 = args55048.length;
switch (G__55050) {
case 0:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args55048.length)].join('')));

}
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.squuid.call(null,hasch.core.uuid4.call(null));
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$1 = (function (uuid){
var time = (new Date()).getTime();
var secs = cljs.core.quot.call(null,time,(1000));
var prefix = secs.toString((16));
return cljs.core.uuid.call(null,[cljs.core.str(prefix),cljs.core.str(cljs.core.subs.call(null,[cljs.core.str(uuid)].join(''),(8)))].join(''));
});

hasch.core.squuid.cljs$lang$maxFixedArity = 1;

/**
 * Provides a base64 encoded string of the edn-hash of a value val. This contains
 *   all bits of the hash compared to 128 bits for the UUID-5. Both should be safe,
 *   but b64-hash is safer towards collisions.
 */
hasch.core.b64_hash = (function hasch$core$b64_hash(val){
return hasch.base64.encode.call(null,cljs.core.clj__GT_js.call(null,hasch.core.edn_hash.call(null,val)));
});

//# sourceMappingURL=core.js.map?rel=1528140386733