// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__7954__auto__ = (((this$ == null))?null:this$);
var m__7955__auto__ = (hasch.benc._coerce[goog.typeOf(x__7954__auto__)]);
if(!((m__7955__auto__ == null))){
return m__7955__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__7955__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__7955__auto____$1 == null))){
return m__7955__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__10658_10662 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__10659_10663 = null;
var count__10660_10664 = (0);
var i__10661_10665 = (0);
while(true){
if((i__10661_10665 < count__10660_10664)){
var bs_10666 = cljs.core._nth.call(null,chunk__10659_10663,i__10661_10665);
md.update(bs_10666);

var G__10667 = seq__10658_10662;
var G__10668 = chunk__10659_10663;
var G__10669 = count__10660_10664;
var G__10670 = (i__10661_10665 + (1));
seq__10658_10662 = G__10667;
chunk__10659_10663 = G__10668;
count__10660_10664 = G__10669;
i__10661_10665 = G__10670;
continue;
} else {
var temp__6753__auto___10671 = cljs.core.seq.call(null,seq__10658_10662);
if(temp__6753__auto___10671){
var seq__10658_10672__$1 = temp__6753__auto___10671;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10658_10672__$1)){
var c__8147__auto___10673 = cljs.core.chunk_first.call(null,seq__10658_10672__$1);
var G__10674 = cljs.core.chunk_rest.call(null,seq__10658_10672__$1);
var G__10675 = c__8147__auto___10673;
var G__10676 = cljs.core.count.call(null,c__8147__auto___10673);
var G__10677 = (0);
seq__10658_10662 = G__10674;
chunk__10659_10663 = G__10675;
count__10660_10664 = G__10676;
i__10661_10665 = G__10677;
continue;
} else {
var bs_10678 = cljs.core.first.call(null,seq__10658_10672__$1);
md.update(bs_10678);

var G__10679 = cljs.core.next.call(null,seq__10658_10672__$1);
var G__10680 = null;
var G__10681 = (0);
var G__10682 = (0);
seq__10658_10662 = G__10679;
chunk__10659_10663 = G__10680;
count__10660_10664 = G__10681;
i__10661_10665 = G__10682;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_10689 = seq;
while(true){
var vec__10686_10690 = s_10689;
var seq__10687_10691 = cljs.core.seq.call(null,vec__10686_10690);
var first__10688_10692 = cljs.core.first.call(null,seq__10687_10691);
var seq__10687_10693__$1 = cljs.core.next.call(null,seq__10687_10691);
var f_10694 = first__10688_10692;
var r_10695 = seq__10687_10693__$1;
seq_md.update(hasch.benc._coerce.call(null,f_10694,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_10695)){
} else {
var G__10696 = cljs.core.rest.call(null,s_10689);
s_10689 = G__10696;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__7581__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__7582__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__7581__auto__ < y__7582__auto__) ? x__7581__auto__ : y__7582__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_10697 = (0);
while(true){
if((i_10697 < len)){
(acc[i_10697] = ((acc[i_10697]) ^ (elem[i_10697])));

var G__10698 = (i_10697 + (1));
i_10697 = G__10698;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_10699 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_10699,len)){
} else {
var e_10700 = (a[i_10699]);
if(((e_10700 > (0))) && ((e_10700 < (30)))){
(ea[i_10699] = (1));
} else {
}

var G__10701 = (i_10699 + (1));
i_10699 = G__10701;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});
