if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part;parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.provide can not be used within a goog.module.");
  }
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
    } else {
      return null;
    }
  }
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
goog.forwardDeclare("Document");
goog.forwardDeclare("HTMLScriptElement");
goog.forwardDeclare("XMLHttpRequest");
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part;part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_loadFlags) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    if (!opt_loadFlags || typeof opt_loadFlags === "boolean") {
      opt_loadFlags = opt_loadFlags ? {"module":"goog"} : {};
    }
    for (var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      deps.loadFlags[path] = opt_loadFlags;
    }
    for (var j = 0;require = requires[j];j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      } else {
        return null;
      }
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.writeScripts_(path);
        return null;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    goog.logToConsole_(errorMessage);
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
goog.define("goog.TRANSPILE", "detect");
goog.define("goog.TRANSPILER", "transpile.js");
if (goog.DEPENDENCIES_ENABLED) {
  goog.dependencies_ = {loadFlags:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return doc != null && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.isDef(goog.global.CLOSURE_BASE_PATH)) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("SCRIPT");
    for (var i = scripts.length - 1;i >= 0;--i) {
      var script = (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !!(!goog.global.atob && goog.global.document && goog.global.document.all);
  goog.importProcessedScript_ = function(src, isModule, needsTranspile) {
    var bootstrap = 'goog.retrieveAndExec_("' + src + '", ' + isModule + ", " + needsTranspile + ");";
    goog.importScript_("", bootstrap);
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0;i < count;i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    var loadFlags = path && goog.dependencies_.loadFlags[path] || {};
    if (path && (loadFlags["module"] == "goog" || goog.needsTranspile_(loadFlags["lang"]))) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModuleFromUrl = function(url) {
    goog.retrieveAndExec_(url, true, false);
  };
  goog.loadModule = function(moduleDef) {
    var previousState = goog.moduleLoaderState_;
    try {
      goog.moduleLoaderState_ = {moduleName:undefined, declareLegacyNamespace:false};
      var exports;
      if (goog.isFunction(moduleDef)) {
        exports = moduleDef.call(goog.global, {});
      } else {
        if (goog.isString(moduleDef)) {
          exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
        } else {
          throw Error("Invalid module definition");
        }
      }
      var moduleName = goog.moduleLoaderState_.moduleName;
      if (!goog.isString(moduleName) || !moduleName) {
        throw Error('Invalid module name "' + moduleName + '"');
      }
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
          Object.seal(exports);
        }
      }
      goog.loadedModules_[moduleName] = exports;
    } finally {
      goog.moduleLoaderState_ = previousState;
    }
  };
  goog.loadModuleFromSource_ = function() {
    var exports = {};
    eval(arguments[0]);
    return exports;
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = (doc.createElement("script"));
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      if (opt_sourceText === undefined) {
        if (!goog.IS_OLD_IE_) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + opt_sourceText + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.needsTranspile_ = function(lang) {
    if (goog.TRANSPILE == "always") {
      return true;
    } else {
      if (goog.TRANSPILE == "never") {
        return false;
      } else {
        if (!goog.transpiledLanguages_) {
          goog.transpiledLanguages_ = {"es5":true, "es6":true, "es6-impl":true};
          try {
            goog.transpiledLanguages_["es5"] = eval("[1,].length!\x3d1");
            var es6implTest = "let a\x3d{};const X\x3dclass{constructor(){}x(z){return new Map([" + "...arguments]).get(z[0])\x3d\x3d3}};return new X().x([a,3])";
            var es6fullTest = "class X{constructor(){if(new.target!\x3dString)throw 1;this.x\x3d42}}" + "let q\x3dReflect.construct(X,[],String);if(q.x!\x3d42||!(q instanceof " + "String))throw 1;for(const a of[2,3]){if(a\x3d\x3d2)continue;function " + "f(z\x3d{a}){let a\x3d0;return z.a}{function f(){return 0;}}return f()" + "\x3d\x3d3}";
            if (eval('(()\x3d\x3e{"use strict";' + es6implTest + "})()")) {
              goog.transpiledLanguages_["es6-impl"] = false;
            }
            if (eval('(()\x3d\x3e{"use strict";' + es6fullTest + "})()")) {
              goog.transpiledLanguages_["es6"] = false;
            }
          } catch (err) {
          }
        }
      }
    }
    return !!goog.transpiledLanguages_[lang];
  };
  goog.transpiledLanguages_ = null;
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function(pathToLoad) {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    visitNode(pathToLoad);
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      if (path) {
        var loadFlags = deps.loadFlags[path] || {};
        var needsTranspile = goog.needsTranspile_(loadFlags["lang"]);
        if (loadFlags["module"] == "goog" || needsTranspile) {
          goog.importProcessedScript_(goog.basePath + path, loadFlags["module"] == "goog", needsTranspile);
        } else {
          goog.importScript_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    try {
      var xhr = new goog.global["XMLHttpRequest"];
      xhr.open("get", src, false);
      xhr.send();
      return xhr.status == 0 || xhr.status == 200 ? xhr.responseText : null;
    } catch (err) {
      return null;
    }
  }
};
goog.retrieveAndExec_ = function(src, isModule, needsTranspile) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText == null) {
      throw new Error('Load of "' + src + '" failed');
    }
    if (needsTranspile) {
      scriptText = goog.transpile_.call(goog.global, scriptText, src);
    }
    if (isModule) {
      scriptText = goog.wrapModule_(src, scriptText);
    } else {
      scriptText += "\n//# sourceURL\x3d" + src;
    }
    var isOldIE = goog.IS_OLD_IE_;
    if (isOldIE) {
      goog.dependencies_.deferred[originalPath] = scriptText;
      goog.queuedModules_.push(originalPath);
    } else {
      importScript(src, scriptText);
    }
  }
};
goog.transpile_ = function(code, path) {
  var jscomp = goog.global["$jscomp"];
  if (!jscomp) {
    goog.global["$jscomp"] = jscomp = {};
  }
  var transpile = jscomp.transpile;
  if (!transpile) {
    var transpilerPath = goog.basePath + goog.TRANSPILER;
    var transpilerCode = goog.loadFileSync_(transpilerPath);
    if (transpilerCode) {
      eval(transpilerCode + "\n//# sourceURL\x3d" + transpilerPath);
      jscomp = goog.global["$jscomp"];
      transpile = jscomp.transpile;
    }
  }
  if (!transpile) {
    var suffix = " requires transpilation but no transpiler was found.";
    transpile = jscomp.transpile = function(code, path) {
      goog.logToConsole_(path + suffix);
      return code;
    };
  }
  return transpile(code, path);
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if (obj !== null && "removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1E9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _evalTest_ \x3d 1;");
        if (typeof goog.global["_evalTest_"] != "undefined") {
          try {
            delete goog.global["_evalTest_"];
          } catch (ignore) {
          }
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = (doc.createElement("SCRIPT"));
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return opt_values != null && key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2;i < arguments.length;i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1;i < arguments.length;i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2;i < arguments.length;i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.scope is not supported within a goog.module.");
  }
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (!goog.defineClass.SEAL_CLASS_INSTANCES) {
    return ctr;
  }
  var superclassSealable = !goog.defineClass.isUnsealable_(superClass);
  var wrappedCtr = function() {
    var instance = ctr.apply(this, arguments) || this;
    instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
    if (this.constructor === wrappedCtr && superclassSealable && Object.seal instanceof Function) {
      Object.seal(instance);
    }
    return instance;
  };
  return wrappedCtr;
};
goog.defineClass.isUnsealable_ = function(ctr) {
  return ctr && ctr.prototype && ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_];
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0;i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:" "};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "" && ch <= "�";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numberAwareCompare_ = function(str1, str2, tokenizerRegExp) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(tokenizerRegExp);
  var tokens2 = str2.toLowerCase().match(tokenizerRegExp);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.intAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\D+/g);
};
goog.string.floatAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\.\d+|\D+/g);
};
goog.string.numerateCompare = goog.string.floatAwareCompare;
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\", "\x3c":"\x3c"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  var sb = ['"'];
  for (var i = 0;i < s.length;i++) {
    var ch = s.charAt(i);
    var cc = ch.charCodeAt(0);
    sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
  }
  sb.push('"');
  return sb.join("");
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = String.prototype.repeat ? function(string, length) {
  return string.repeat(length);
} : function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i) >>> 0;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.lastComponent = function(str, separators) {
  if (!separators) {
    return str;
  } else {
    if (typeof separators == "string") {
      separators = [separators];
    }
  }
  var lastSeparatorIndex = -1;
  for (var i = 0;i < separators.length;i++) {
    if (separators[i] == "") {
      continue;
    }
    var currentSeparatorIndex = str.lastIndexOf(separators[i]);
    if (currentSeparatorIndex > lastSeparatorIndex) {
      lastSeparatorIndex = currentSeparatorIndex;
    }
  }
  if (lastSeparatorIndex == -1) {
    return str;
  }
  return str.slice(lastSeparatorIndex + 1);
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0;i < b.length + 1;i++) {
    v0[i] = i;
  }
  for (var i = 0;i < a.length;i++) {
    v1[0] = i + 1;
    for (var j = 0;j < b.length;j++) {
      var cost = Number(a[i] != b[j]);
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0;j < v0.length;j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.object");
goog.object.is = function(v, v2) {
  if (v === v2) {
    return v !== 0 || 1 / v === 1 / (v2);
  }
  return v !== v && v2 !== v2;
};
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call((opt_obj), obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call((opt_obj), obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call((opt_obj), obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call((opt_obj), obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call((opt_obj), obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return obj !== null && key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call((opt_this), obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in (obj)) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (obj !== null && key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (obj !== null && key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in (obj) ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (goog.isFunction(obj.clone)) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.math.Integer");
goog.math.Integer = function(bits, sign) {
  this.bits_ = [];
  this.sign_ = sign;
  var top = true;
  for (var i = bits.length - 1;i >= 0;i--) {
    var val = bits[i] | 0;
    if (!top || val != sign) {
      this.bits_[i] = val;
      top = false;
    }
  }
};
goog.math.Integer.IntCache_ = {};
goog.math.Integer.fromInt = function(value) {
  if (-128 <= value && value < 128) {
    var cachedObj = goog.math.Integer.IntCache_[value];
    if (cachedObj) {
      return cachedObj;
    }
  }
  var obj = new goog.math.Integer([value | 0], value < 0 ? -1 : 0);
  if (-128 <= value && value < 128) {
    goog.math.Integer.IntCache_[value] = obj;
  }
  return obj;
};
goog.math.Integer.fromNumber = function(value) {
  if (isNaN(value) || !isFinite(value)) {
    return goog.math.Integer.ZERO;
  } else {
    if (value < 0) {
      return goog.math.Integer.fromNumber(-value).negate();
    } else {
      var bits = [];
      var pow = 1;
      for (var i = 0;value >= pow;i++) {
        bits[i] = value / pow | 0;
        pow *= goog.math.Integer.TWO_PWR_32_DBL_;
      }
      return new goog.math.Integer(bits, 0);
    }
  }
};
goog.math.Integer.fromBits = function(bits) {
  var high = bits[bits.length - 1];
  return new goog.math.Integer(bits, high & 1 << 31 ? -1 : 0);
};
goog.math.Integer.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Integer.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character');
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Integer.ZERO;
  for (var i = 0;i < str.length;i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Integer.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Integer.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Integer.fromNumber(value));
    }
  }
  return result;
};
goog.math.Integer.TWO_PWR_32_DBL_ = (1 << 16) * (1 << 16);
goog.math.Integer.ZERO = goog.math.Integer.fromInt(0);
goog.math.Integer.ONE = goog.math.Integer.fromInt(1);
goog.math.Integer.TWO_PWR_24_ = goog.math.Integer.fromInt(1 << 24);
goog.math.Integer.prototype.toInt = function() {
  return this.bits_.length > 0 ? this.bits_[0] : this.sign_;
};
goog.math.Integer.prototype.toNumber = function() {
  if (this.isNegative()) {
    return -this.negate().toNumber();
  } else {
    var val = 0;
    var pow = 1;
    for (var i = 0;i < this.bits_.length;i++) {
      val += this.getBitsUnsigned(i) * pow;
      pow *= goog.math.Integer.TWO_PWR_32_DBL_;
    }
    return val;
  }
};
goog.math.Integer.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  } else {
    if (this.isNegative()) {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.divide(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Integer.prototype.getBits = function(index) {
  if (index < 0) {
    return 0;
  } else {
    if (index < this.bits_.length) {
      return this.bits_[index];
    } else {
      return this.sign_;
    }
  }
};
goog.math.Integer.prototype.getBitsUnsigned = function(index) {
  var val = this.getBits(index);
  return val >= 0 ? val : goog.math.Integer.TWO_PWR_32_DBL_ + val;
};
goog.math.Integer.prototype.getSign = function() {
  return this.sign_;
};
goog.math.Integer.prototype.isZero = function() {
  if (this.sign_ != 0) {
    return false;
  }
  for (var i = 0;i < this.bits_.length;i++) {
    if (this.bits_[i] != 0) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.isNegative = function() {
  return this.sign_ == -1;
};
goog.math.Integer.prototype.isOdd = function() {
  return this.bits_.length == 0 && this.sign_ == -1 || this.bits_.length > 0 && (this.bits_[0] & 1) != 0;
};
goog.math.Integer.prototype.equals = function(other) {
  if (this.sign_ != other.sign_) {
    return false;
  }
  var len = Math.max(this.bits_.length, other.bits_.length);
  for (var i = 0;i < len;i++) {
    if (this.getBits(i) != other.getBits(i)) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.notEquals = function(other) {
  return !this.equals(other);
};
goog.math.Integer.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Integer.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Integer.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Integer.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Integer.prototype.compare = function(other) {
  var diff = this.subtract(other);
  if (diff.isNegative()) {
    return -1;
  } else {
    if (diff.isZero()) {
      return 0;
    } else {
      return +1;
    }
  }
};
goog.math.Integer.prototype.shorten = function(numBits) {
  var arr_index = numBits - 1 >> 5;
  var bit_index = (numBits - 1) % 32;
  var bits = [];
  for (var i = 0;i < arr_index;i++) {
    bits[i] = this.getBits(i);
  }
  var sigBits = bit_index == 31 ? 4294967295 : (1 << bit_index + 1) - 1;
  var val = this.getBits(arr_index) & sigBits;
  if (val & 1 << bit_index) {
    val |= 4294967295 - sigBits;
    bits[arr_index] = val;
    return new goog.math.Integer(bits, -1);
  } else {
    bits[arr_index] = val;
    return new goog.math.Integer(bits, 0);
  }
};
goog.math.Integer.prototype.negate = function() {
  return this.not().add(goog.math.Integer.ONE);
};
goog.math.Integer.prototype.add = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  var carry = 0;
  for (var i = 0;i <= len;i++) {
    var a1 = this.getBits(i) >>> 16;
    var a0 = this.getBits(i) & 65535;
    var b1 = other.getBits(i) >>> 16;
    var b0 = other.getBits(i) & 65535;
    var c0 = carry + a0 + b0;
    var c1 = (c0 >>> 16) + a1 + b1;
    carry = c1 >>> 16;
    c0 &= 65535;
    c1 &= 65535;
    arr[i] = c1 << 16 | c0;
  }
  return goog.math.Integer.fromBits(arr);
};
goog.math.Integer.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Integer.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Integer.ZERO;
  } else {
    if (other.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Integer.TWO_PWR_24_) && other.lessThan(goog.math.Integer.TWO_PWR_24_)) {
    return goog.math.Integer.fromNumber(this.toNumber() * other.toNumber());
  }
  var len = this.bits_.length + other.bits_.length;
  var arr = [];
  for (var i = 0;i < 2 * len;i++) {
    arr[i] = 0;
  }
  for (var i = 0;i < this.bits_.length;i++) {
    for (var j = 0;j < other.bits_.length;j++) {
      var a1 = this.getBits(i) >>> 16;
      var a0 = this.getBits(i) & 65535;
      var b1 = other.getBits(j) >>> 16;
      var b0 = other.getBits(j) & 65535;
      arr[2 * i + 2 * j] += a0 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j);
      arr[2 * i + 2 * j + 1] += a1 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 1] += a0 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 2] += a1 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 2);
    }
  }
  for (var i = 0;i < len;i++) {
    arr[i] = arr[2 * i + 1] << 16 | arr[2 * i];
  }
  for (var i = len;i < 2 * len;i++) {
    arr[i] = 0;
  }
  return new goog.math.Integer(arr, 0);
};
goog.math.Integer.carry16_ = function(bits, index) {
  while ((bits[index] & 65535) != bits[index]) {
    bits[index + 1] += bits[index] >>> 16;
    bits[index] &= 65535;
  }
};
goog.math.Integer.prototype.slowDivide_ = function(other) {
  if (this.isNegative() || other.isNegative()) {
    throw Error("slowDivide_ only works with positive integers.");
  }
  var twoPower = goog.math.Integer.ONE;
  var multiple = other;
  while (multiple.lessThanOrEqual(this)) {
    twoPower = twoPower.shiftLeft(1);
    multiple = multiple.shiftLeft(1);
  }
  var res = twoPower.shiftRight(1);
  var total = multiple.shiftRight(1);
  var total2;
  multiple = multiple.shiftRight(2);
  twoPower = twoPower.shiftRight(2);
  while (!multiple.isZero()) {
    total2 = total.add(multiple);
    if (total2.lessThanOrEqual(this)) {
      res = res.add(twoPower);
      total = total2;
    }
    multiple = multiple.shiftRight(1);
    twoPower = twoPower.shiftRight(1);
  }
  return res;
};
goog.math.Integer.prototype.divide = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().divide(other.negate());
    } else {
      return this.negate().divide(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.divide(other.negate()).negate();
    }
  }
  if (this.bits_.length > 30) {
    return this.slowDivide_(other);
  }
  var res = goog.math.Integer.ZERO;
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Integer.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Integer.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Integer.ONE;
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Integer.prototype.modulo = function(other) {
  return this.subtract(this.divide(other).multiply(other));
};
goog.math.Integer.prototype.not = function() {
  var len = this.bits_.length;
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = ~this.bits_[i];
  }
  return new goog.math.Integer(arr, ~this.sign_);
};
goog.math.Integer.prototype.and = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = this.getBits(i) & other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ & other.sign_);
};
goog.math.Integer.prototype.or = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = this.getBits(i) | other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ | other.sign_);
};
goog.math.Integer.prototype.xor = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0;i < len;i++) {
    arr[i] = this.getBits(i) ^ other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ ^ other.sign_);
};
goog.math.Integer.prototype.shiftLeft = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length + arr_delta + (bit_delta > 0 ? 1 : 0);
  var arr = [];
  for (var i = 0;i < len;i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i - arr_delta) << bit_delta | this.getBits(i - arr_delta - 1) >>> 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i - arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.math.Integer.prototype.shiftRight = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length - arr_delta;
  var arr = [];
  for (var i = 0;i < len;i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i + arr_delta) >>> bit_delta | this.getBits(i + arr_delta + 1) << 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i + arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += String(a1);
  if (opt_a2 != null) {
    for (var i = 1;i < arguments.length;i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i < arr.length;i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return Array.prototype.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i >= 0;i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  Array.prototype.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      f.call((opt_obj), arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;--i) {
    if (i in arr2) {
      f.call((opt_obj), arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call((opt_obj), val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      res[i] = f.call((opt_obj), arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call((opt_obj), rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.asserts.assert(f != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call((opt_obj), rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && !f.call((opt_obj), arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call((opt_obj), element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;i--) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1;i >= 0;i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeLast = function(arr, obj) {
  var i = goog.array.lastIndexOf(arr, obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call((opt_obj), val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return Array.prototype.concat.apply(Array.prototype, arguments);
};
goog.array.join = function(var_args) {
  return Array.prototype.concat.apply(Array.prototype, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0;i < length;i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0;j < len2;j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return Array.prototype.slice.call(arr, start);
  } else {
    return Array.prototype.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(item) ? "o" + goog.getUid(item) : (typeof item).charAt(0) + item;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = (compareFn)(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  var compArr = new Array(arr.length);
  for (var i = 0;i < arr.length;i++) {
    compArr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(compArr, stableCompareFn);
  for (var i = 0;i < arr.length;i++) {
    arr[i] = compArr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0;i < l;i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter.call((opt_obj), value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call((opt_obj), element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start;i < end;i += step) {
      array.push(i);
    }
  } else {
    for (var i = start;i > end;i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0;i < n;i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0;c < element.length;c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0;r < recurseResult.length;r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      Array.prototype.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        Array.prototype.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = Array.prototype.splice.call(arr, fromIndex, 1);
  Array.prototype.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  var minLen = arguments[0].length;
  for (var i = 1;i < arguments.length;i++) {
    if (arguments[i].length < minLen) {
      minLen = arguments[i].length;
    }
  }
  for (var i = 0;i < minLen;i++) {
    var value = [];
    for (var j = 0;j < arguments.length;j++) {
      value.push(arguments[j][i]);
    }
    result.push(value);
  }
  return result;
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.array.concatMap = function(arr, f, opt_obj) {
  return goog.array.concat.apply([], goog.array.map(arr, f, opt_obj));
};
goog.provide("goog.reflect");
goog.reflect.object = function(type, object) {
  return object;
};
goog.reflect.objectProperty = function(prop, object) {
  return prop;
};
goog.reflect.sinkValue = function(x) {
  goog.reflect.sinkValue[" "](x);
  return x;
};
goog.reflect.sinkValue[" "] = goog.nullFunction;
goog.reflect.canAccessProperty = function(obj, prop) {
  try {
    goog.reflect.sinkValue(obj[prop]);
    return true;
  } catch (e) {
  }
  return false;
};
goog.reflect.cache = function(cacheObj, key, valueFn, opt_keyFn) {
  var storedKey = opt_keyFn ? opt_keyFn(key) : key;
  if (Object.prototype.hasOwnProperty.call(cacheObj, storedKey)) {
    return cacheObj[storedKey];
  }
  return cacheObj[storedKey] = valueFn(key);
};
goog.provide("goog.math.Long");
goog.require("goog.reflect");
goog.math.Long = function(low, high) {
  this.low_ = low | 0;
  this.high_ = high | 0;
};
goog.math.Long.IntCache_ = {};
goog.math.Long.valueCache_ = {};
goog.math.Long.fromInt = function(value) {
  if (-128 <= value && value < 128) {
    return goog.reflect.cache(goog.math.Long.IntCache_, value, function(val) {
      return new goog.math.Long(val | 0, val < 0 ? -1 : 0);
    });
  } else {
    return new goog.math.Long(value | 0, value < 0 ? -1 : 0);
  }
};
goog.math.Long.fromNumber = function(value) {
  if (isNaN(value)) {
    return goog.math.Long.getZero();
  } else {
    if (value <= -goog.math.Long.TWO_PWR_63_DBL_) {
      return goog.math.Long.getMinValue();
    } else {
      if (value + 1 >= goog.math.Long.TWO_PWR_63_DBL_) {
        return goog.math.Long.getMaxValue();
      } else {
        if (value < 0) {
          return goog.math.Long.fromNumber(-value).negate();
        } else {
          return new goog.math.Long(value % goog.math.Long.TWO_PWR_32_DBL_ | 0, value / goog.math.Long.TWO_PWR_32_DBL_ | 0);
        }
      }
    }
  }
};
goog.math.Long.fromBits = function(lowBits, highBits) {
  return new goog.math.Long(lowBits, highBits);
};
goog.math.Long.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Long.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character: ' + str);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Long.getZero();
  for (var i = 0;i < str.length;i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Long.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Long.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Long.fromNumber(value));
    }
  }
  return result;
};
goog.math.Long.TWO_PWR_16_DBL_ = 1 << 16;
goog.math.Long.TWO_PWR_32_DBL_ = goog.math.Long.TWO_PWR_16_DBL_ * goog.math.Long.TWO_PWR_16_DBL_;
goog.math.Long.TWO_PWR_64_DBL_ = goog.math.Long.TWO_PWR_32_DBL_ * goog.math.Long.TWO_PWR_32_DBL_;
goog.math.Long.TWO_PWR_63_DBL_ = goog.math.Long.TWO_PWR_64_DBL_ / 2;
goog.math.Long.getZero = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.ZERO, function() {
    return goog.math.Long.fromInt(0);
  });
};
goog.math.Long.getOne = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.ONE, function() {
    return goog.math.Long.fromInt(1);
  });
};
goog.math.Long.getNegOne = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.NEG_ONE, function() {
    return goog.math.Long.fromInt(-1);
  });
};
goog.math.Long.getMaxValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MAX_VALUE, function() {
    return goog.math.Long.fromBits(4294967295 | 0, 2147483647 | 0);
  });
};
goog.math.Long.getMinValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MIN_VALUE, function() {
    return goog.math.Long.fromBits(0, 2147483648 | 0);
  });
};
goog.math.Long.getTwoPwr24 = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.TWO_PWR_24, function() {
    return goog.math.Long.fromInt(1 << 24);
  });
};
goog.math.Long.prototype.toInt = function() {
  return this.low_;
};
goog.math.Long.prototype.toNumber = function() {
  return this.high_ * goog.math.Long.TWO_PWR_32_DBL_ + this.getLowBitsUnsigned();
};
goog.math.Long.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  }
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      var radixLong = goog.math.Long.fromNumber(radix);
      var div = this.div(radixLong);
      var rem = div.multiply(radixLong).subtract(this);
      return div.toString(radix) + rem.toInt().toString(radix);
    } else {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.div(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Long.prototype.getHighBits = function() {
  return this.high_;
};
goog.math.Long.prototype.getLowBits = function() {
  return this.low_;
};
goog.math.Long.prototype.getLowBitsUnsigned = function() {
  return this.low_ >= 0 ? this.low_ : goog.math.Long.TWO_PWR_32_DBL_ + this.low_;
};
goog.math.Long.prototype.getNumBitsAbs = function() {
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      return 64;
    } else {
      return this.negate().getNumBitsAbs();
    }
  } else {
    var val = this.high_ != 0 ? this.high_ : this.low_;
    for (var bit = 31;bit > 0;bit--) {
      if ((val & 1 << bit) != 0) {
        break;
      }
    }
    return this.high_ != 0 ? bit + 33 : bit + 1;
  }
};
goog.math.Long.prototype.isZero = function() {
  return this.high_ == 0 && this.low_ == 0;
};
goog.math.Long.prototype.isNegative = function() {
  return this.high_ < 0;
};
goog.math.Long.prototype.isOdd = function() {
  return (this.low_ & 1) == 1;
};
goog.math.Long.prototype.equals = function(other) {
  return this.high_ == other.high_ && this.low_ == other.low_;
};
goog.math.Long.prototype.notEquals = function(other) {
  return this.high_ != other.high_ || this.low_ != other.low_;
};
goog.math.Long.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Long.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Long.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Long.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Long.prototype.compare = function(other) {
  if (this.equals(other)) {
    return 0;
  }
  var thisNeg = this.isNegative();
  var otherNeg = other.isNegative();
  if (thisNeg && !otherNeg) {
    return -1;
  }
  if (!thisNeg && otherNeg) {
    return 1;
  }
  if (this.subtract(other).isNegative()) {
    return -1;
  } else {
    return 1;
  }
};
goog.math.Long.prototype.negate = function() {
  if (this.equals(goog.math.Long.getMinValue())) {
    return goog.math.Long.getMinValue();
  } else {
    return this.not().add(goog.math.Long.getOne());
  }
};
goog.math.Long.prototype.add = function(other) {
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 + b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 + b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 + b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 + b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Long.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Long.getZero();
  } else {
    if (other.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    return other.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return this.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Long.getTwoPwr24()) && other.lessThan(goog.math.Long.getTwoPwr24())) {
    return goog.math.Long.fromNumber(this.toNumber() * other.toNumber());
  }
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 * b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 * b00;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c16 += a00 * b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 * b00;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a16 * b16;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a00 * b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.div = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    if (other.equals(goog.math.Long.getOne()) || other.equals(goog.math.Long.getNegOne())) {
      return goog.math.Long.getMinValue();
    } else {
      if (other.equals(goog.math.Long.getMinValue())) {
        return goog.math.Long.getOne();
      } else {
        var halfThis = this.shiftRight(1);
        var approx = halfThis.div(other).shiftLeft(1);
        if (approx.equals(goog.math.Long.getZero())) {
          return other.isNegative() ? goog.math.Long.getOne() : goog.math.Long.getNegOne();
        } else {
          var rem = this.subtract(other.multiply(approx));
          var result = approx.add(rem.div(other));
          return result;
        }
      }
    }
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().div(other.negate());
    } else {
      return this.negate().div(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.div(other.negate()).negate();
    }
  }
  var res = goog.math.Long.getZero();
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Long.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Long.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Long.getOne();
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Long.prototype.modulo = function(other) {
  return this.subtract(this.div(other).multiply(other));
};
goog.math.Long.prototype.not = function() {
  return goog.math.Long.fromBits(~this.low_, ~this.high_);
};
goog.math.Long.prototype.and = function(other) {
  return goog.math.Long.fromBits(this.low_ & other.low_, this.high_ & other.high_);
};
goog.math.Long.prototype.or = function(other) {
  return goog.math.Long.fromBits(this.low_ | other.low_, this.high_ | other.high_);
};
goog.math.Long.prototype.xor = function(other) {
  return goog.math.Long.fromBits(this.low_ ^ other.low_, this.high_ ^ other.high_);
};
goog.math.Long.prototype.shiftLeft = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var low = this.low_;
    if (numBits < 32) {
      var high = this.high_;
      return goog.math.Long.fromBits(low << numBits, high << numBits | low >>> 32 - numBits);
    } else {
      return goog.math.Long.fromBits(0, low << numBits - 32);
    }
  }
};
goog.math.Long.prototype.shiftRight = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >> numBits);
    } else {
      return goog.math.Long.fromBits(high >> numBits - 32, high >= 0 ? 0 : -1);
    }
  }
};
goog.math.Long.prototype.shiftRightUnsigned = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits);
    } else {
      if (numBits == 32) {
        return goog.math.Long.fromBits(high, 0);
      } else {
        return goog.math.Long.fromBits(high >>> numBits - 32, 0);
      }
    }
  }
};
goog.math.Long.ValueCacheId_ = {MAX_VALUE:1, MIN_VALUE:2, ZERO:3, ONE:4, NEG_ONE:5, TWO_PWR_24:6};
goog.provide("cljs.core");
goog.require("goog.math.Long");
goog.require("goog.math.Integer");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "1.9.293";
cljs.core._STAR_unchecked_if_STAR_ = false;
if (typeof cljs.core.PROTOCOL_SENTINEL !== "undefined") {
} else {
  cljs.core.PROTOCOL_SENTINEL = {};
}
goog.define("cljs.core._STAR_target_STAR_", "default");
cljs.core._STAR_ns_STAR_ = null;
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
if (typeof cljs.core._STAR_print_err_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_err_fn_STAR_ = function cljs$core$_STAR_print_err_fn_STAR_(_) {
    throw new Error("No *print-err-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core.set_print_err_fn_BANG_ = function cljs$core$set_print_err_fn_BANG_(f) {
  return cljs.core._STAR_print_err_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  cljs.core._STAR_print_fn_STAR_ = function() {
    var G__9429__delegate = function(args) {
      return console.log.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__9429 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__9430__i = 0, G__9430__a = new Array(arguments.length - 0);
        while (G__9430__i < G__9430__a.length) {
          G__9430__a[G__9430__i] = arguments[G__9430__i + 0];
          ++G__9430__i;
        }
        args = new cljs.core.IndexedSeq(G__9430__a, 0);
      }
      return G__9429__delegate.call(this, args);
    };
    G__9429.cljs$lang$maxFixedArity = 0;
    G__9429.cljs$lang$applyTo = function(arglist__9431) {
      var args = cljs.core.seq(arglist__9431);
      return G__9429__delegate(args);
    };
    G__9429.cljs$core$IFn$_invoke$arity$variadic = G__9429__delegate;
    return G__9429;
  }();
  cljs.core._STAR_print_err_fn_STAR_ = function() {
    var G__9432__delegate = function(args) {
      return console.error.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__9432 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__9433__i = 0, G__9433__a = new Array(arguments.length - 0);
        while (G__9433__i < G__9433__a.length) {
          G__9433__a[G__9433__i] = arguments[G__9433__i + 0];
          ++G__9433__i;
        }
        args = new cljs.core.IndexedSeq(G__9433__a, 0);
      }
      return G__9432__delegate.call(this, args);
    };
    G__9432.cljs$lang$maxFixedArity = 0;
    G__9432.cljs$lang$applyTo = function(arglist__9434) {
      var args = cljs.core.seq(arglist__9434);
      return G__9432__delegate(args);
    };
    G__9432.cljs$core$IFn$_invoke$arity$variadic = G__9432__delegate;
    return G__9432;
  }();
  return null;
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (x == null) {
    return true;
  } else {
    if (x === false) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  return goog.isString(x);
};
cljs.core.char_QMARK_ = function cljs$core$char_QMARK_(x) {
  return typeof x === "string" && 1 === x.length;
};
cljs.core.any_QMARK_ = function cljs$core$any_QMARK_(x) {
  return true;
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[goog.typeOf(x__$1)]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__7050__auto__ = ty;
    if (cljs.core.truth_(and__7050__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__7050__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : goog.typeOf(obj);
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__6751__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__6751__auto__)) {
    var s = temp__6751__auto__;
    return s;
  } else {
    return [cljs.core.str(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && goog.typeOf(Symbol) === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.CHAR_MAP = {"]":"_RBRACK_", "'":"_SINGLEQUOTE_", "\x3d":"_EQ_", '"':"_DOUBLEQUOTE_", "!":"_BANG_", "*":"_STAR_", "%":"_PERCENT_", "|":"_BAR_", "~":"_TILDE_", "/":"_SLASH_", "\\":"_BSLASH_", "-":"_", "?":"_QMARK_", "\x26":"_AMPERSAND_", ":":"_COLON_", "\x3c":"_LT_", "{":"_LBRACE_", "}":"_RBRACE_", "[":"_LBRACK_", "#":"_SHARP_", "^":"_CARET_", "+":"_PLUS_", "@":"_CIRCA_", "\x3e":"_GT_"};
cljs.core.DEMUNGE_MAP = {"_RBRACE_":"}", "_COLON_":":", "_BANG_":"!", "_QMARK_":"?", "_BSLASH_":"\\\\", "_SLASH_":"/", "_PERCENT_":"%", "_PLUS_":"+", "_SHARP_":"#", "_LBRACE_":"{", "_BAR_":"|", "_LBRACK_":"[", "_EQ_":"\x3d", "_":"-", "_TILDE_":"~", "_RBRACK_":"]", "_GT_":"\x3e", "_SINGLEQUOTE_":"'", "_CIRCA_":"@", "_AMPERSAND_":"\x26", "_DOUBLEQUOTE_":'\\"', "_CARET_":"^", "_LT_":"\x3c", "_STAR_":"*"};
cljs.core.DEMUNGE_PATTERN = null;
cljs.core.system_time = function cljs$core$system_time() {
  if (typeof performance !== "undefined" && !(performance.now == null)) {
    return performance.now();
  } else {
    if (typeof process !== "undefined" && !(process.hrtime == null)) {
      var t = process.hrtime();
      return (t[0] * 1E9 + t[1]) / 1E6;
    } else {
      return (new Date).getTime();
    }
  }
};
cljs.core.make_array = function cljs$core$make_array(var_args) {
  var args9435 = [];
  var len__8278__auto___9441 = arguments.length;
  var i__8279__auto___9442 = 0;
  while (true) {
    if (i__8279__auto___9442 < len__8278__auto___9441) {
      args9435.push(arguments[i__8279__auto___9442]);
      var G__9443 = i__8279__auto___9442 + 1;
      i__8279__auto___9442 = G__9443;
      continue;
    } else {
    }
    break;
  }
  var G__9440 = args9435.length;
  switch(G__9440) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9435.slice(2), 0, null);
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = function(type, size, more_sizes) {
  var dims = more_sizes;
  var dimarray = new Array(size);
  var n__8078__auto___9445 = dimarray.length;
  var i_9446 = 0;
  while (true) {
    if (i_9446 < n__8078__auto___9445) {
      dimarray[i_9446] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array, null, dims) : cljs.core.apply.call(null, cljs.core.make_array, null, dims);
      var G__9447 = i_9446 + 1;
      i_9446 = G__9447;
      continue;
    } else {
    }
    break;
  }
  return dimarray;
};
cljs.core.make_array.cljs$lang$applyTo = function(seq9436) {
  var G__9437 = cljs.core.first(seq9436);
  var seq9436__$1 = cljs.core.next(seq9436);
  var G__9438 = cljs.core.first(seq9436__$1);
  var seq9436__$2 = cljs.core.next(seq9436__$1);
  return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(G__9437, G__9438, seq9436__$2);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__8078__auto___9448 = len;
  var i_9449 = 0;
  while (true) {
    if (i_9449 < n__8078__auto___9448) {
      new_arr[i_9449] = arr[i_9449];
      var G__9450 = i_9449 + 1;
      i_9449 = G__9450;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__9451 = i + 1;
      i = G__9451;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget(var_args) {
  var args9452 = [];
  var len__8278__auto___9461 = arguments.length;
  var i__8279__auto___9462 = 0;
  while (true) {
    if (i__8279__auto___9462 < len__8278__auto___9461) {
      args9452.push(arguments[i__8279__auto___9462]);
      var G__9463 = i__8279__auto___9462 + 1;
      i__8279__auto___9462 = G__9463;
      continue;
    } else {
    }
    break;
  }
  var G__9457 = args9452.length;
  switch(G__9457) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9452.slice(2), 0, null);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__9458 = cljs.core.aget;
  var G__9459 = array[i];
  var G__9460 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__9458, G__9459, G__9460) : cljs.core.apply.call(null, G__9458, G__9459, G__9460);
};
cljs.core.aget.cljs$lang$applyTo = function(seq9453) {
  var G__9454 = cljs.core.first(seq9453);
  var seq9453__$1 = cljs.core.next(seq9453);
  var G__9455 = cljs.core.first(seq9453__$1);
  var seq9453__$2 = cljs.core.next(seq9453__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__9454, G__9455, seq9453__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset(var_args) {
  var args9465 = [];
  var len__8278__auto___9476 = arguments.length;
  var i__8279__auto___9477 = 0;
  while (true) {
    if (i__8279__auto___9477 < len__8278__auto___9476) {
      args9465.push(arguments[i__8279__auto___9477]);
      var G__9478 = i__8279__auto___9477 + 1;
      i__8279__auto___9477 = G__9478;
      continue;
    } else {
    }
    break;
  }
  var G__9471 = args9465.length;
  switch(G__9471) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9465.slice(3), 0, null);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__8301__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__9472 = cljs.core.aset;
  var G__9473 = array[idx];
  var G__9474 = idx2;
  var G__9475 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__9472, G__9473, G__9474, G__9475) : cljs.core.apply.call(null, G__9472, G__9473, G__9474, G__9475);
};
cljs.core.aset.cljs$lang$applyTo = function(seq9466) {
  var G__9467 = cljs.core.first(seq9466);
  var seq9466__$1 = cljs.core.next(seq9466);
  var G__9468 = cljs.core.first(seq9466__$1);
  var seq9466__$2 = cljs.core.next(seq9466__$1);
  var G__9469 = cljs.core.first(seq9466__$2);
  var seq9466__$3 = cljs.core.next(seq9466__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__9467, G__9468, G__9469, seq9466__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array(var_args) {
  var args9480 = [];
  var len__8278__auto___9486 = arguments.length;
  var i__8279__auto___9487 = 0;
  while (true) {
    if (i__8279__auto___9487 < len__8278__auto___9486) {
      args9480.push(arguments[i__8279__auto___9487]);
      var G__9488 = i__8279__auto___9487 + 1;
      i__8279__auto___9487 = G__9488;
      continue;
    } else {
    }
    break;
  }
  var G__9482 = args9480.length;
  switch(G__9482) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9480.length)].join(""));;
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__9483 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__9484 = [];
  var G__9485 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__9483, G__9484, G__9485) : cljs.core.reduce.call(null, G__9483, G__9484, G__9485);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke(var_args) {
  var args__8285__auto__ = [];
  var len__8278__auto___9493 = arguments.length;
  var i__8279__auto___9494 = 0;
  while (true) {
    if (i__8279__auto___9494 < len__8278__auto___9493) {
      args__8285__auto__.push(arguments[i__8279__auto___9494]);
      var G__9495 = i__8279__auto___9494 + 1;
      i__8279__auto___9494 = G__9495;
      continue;
    } else {
    }
    break;
  }
  var argseq__8286__auto__ = 2 < args__8285__auto__.length ? new cljs.core.IndexedSeq(args__8285__auto__.slice(2), 0, null) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8286__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq9490) {
  var G__9491 = cljs.core.first(seq9490);
  var seq9490__$1 = cljs.core.next(seq9490);
  var G__9492 = cljs.core.first(seq9490__$1);
  var seq9490__$2 = cljs.core.next(seq9490__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__9491, G__9492, seq9490__$2);
};
cljs.core.Fn = function() {
};
cljs.core.IFn = function() {
};
cljs.core._invoke = function cljs$core$_invoke(var_args) {
  var args9496 = [];
  var len__8278__auto___9499 = arguments.length;
  var i__8279__auto___9500 = 0;
  while (true) {
    if (i__8279__auto___9500 < len__8278__auto___9499) {
      args9496.push(arguments[i__8279__auto___9500]);
      var G__9501 = i__8279__auto___9500 + 1;
      i__8279__auto___9500 = G__9501;
      continue;
    } else {
    }
    break;
  }
  var G__9498 = args9496.length;
  switch(G__9498) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9496.length)].join(""));;
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$1 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7776__auto__.call(null, this$);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7776__auto____$1.call(null, this$);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$2 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(this$, a) : m__7776__auto__.call(null, this$, a);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, a) : m__7776__auto____$1.call(null, this$, a);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$3 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__7776__auto__.call(null, this$, a, b);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__7776__auto____$1.call(null, this$, a, b);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$4 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__7776__auto__.call(null, this$, a, b, c);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__7776__auto____$1.call(null, this$, a, b, c);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$5 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__7776__auto__.call(null, this$, a, b, c, d);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__7776__auto____$1.call(null, this$, a, b, c, d);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$6 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$6 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__7776__auto__.call(null, this$, a, b, c, d, e);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__7776__auto____$1.call(null, this$, a, b, c, d, e);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$7 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$7 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__7776__auto__.call(null, this$, a, b, c, d, e, f);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$8 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$8 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$9 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$9 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$10 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$10 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$11 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$11 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$12 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$12 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$13 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$13 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$14 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$14 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$15 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$15 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$16 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$16 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$17 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$17 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$18 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$18 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$19 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$19 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$20 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$20 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$21 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$21 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$22 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._invoke[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$22 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__7776__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    } else {
      var m__7776__auto____$1 = cljs.core._invoke["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__7776__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
};
cljs.core._clone = function cljs$core$_clone(value) {
  if (!(value == null) && !(value.cljs$core$ICloneable$_clone$arity$1 == null)) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__7775__auto__ = value == null ? null : value;
    var m__7776__auto__ = cljs.core._clone[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__7776__auto__.call(null, value);
    } else {
      var m__7776__auto____$1 = cljs.core._clone["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__7776__auto____$1.call(null, value);
      } else {
        throw cljs.core.missing_protocol("ICloneable.-clone", value);
      }
    }
  }
};
cljs.core.ICounted = function() {
};
cljs.core._count = function cljs$core$_count(coll) {
  if (!(coll == null) && !(coll.cljs$core$ICounted$_count$arity$1 == null)) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._count[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._count["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ICounted.-count", coll);
      }
    }
  }
};
cljs.core.IEmptyableCollection = function() {
};
cljs.core._empty = function cljs$core$_empty(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._empty[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._empty["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
      }
    }
  }
};
cljs.core.ICollection = function() {
};
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (!(coll == null) && !(coll.cljs$core$ICollection$_conj$arity$2 == null)) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._conj[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, o) : m__7776__auto__.call(null, coll, o);
    } else {
      var m__7776__auto____$1 = cljs.core._conj["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, o) : m__7776__auto____$1.call(null, coll, o);
      } else {
        throw cljs.core.missing_protocol("ICollection.-conj", coll);
      }
    }
  }
};
cljs.core.IIndexed = function() {
};
cljs.core._nth = function cljs$core$_nth(var_args) {
  var args9503 = [];
  var len__8278__auto___9506 = arguments.length;
  var i__8279__auto___9507 = 0;
  while (true) {
    if (i__8279__auto___9507 < len__8278__auto___9506) {
      args9503.push(arguments[i__8279__auto___9507]);
      var G__9508 = i__8279__auto___9507 + 1;
      i__8279__auto___9507 = G__9508;
      continue;
    } else {
    }
    break;
  }
  var G__9505 = args9503.length;
  switch(G__9505) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9503.length)].join(""));;
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$2 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._nth[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, n) : m__7776__auto__.call(null, coll, n);
    } else {
      var m__7776__auto____$1 = cljs.core._nth["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, n) : m__7776__auto____$1.call(null, coll, n);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$3 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._nth[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__7776__auto__.call(null, coll, n, not_found);
    } else {
      var m__7776__auto____$1 = cljs.core._nth["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__7776__auto____$1.call(null, coll, n, not_found);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
};
cljs.core.ISeq = function() {
};
cljs.core._first = function cljs$core$_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_first$arity$1 == null)) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._first[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._first["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-first", coll);
      }
    }
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_rest$arity$1 == null)) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._rest[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._rest["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-rest", coll);
      }
    }
  }
};
cljs.core.INext = function() {
};
cljs.core._next = function cljs$core$_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$INext$_next$arity$1 == null)) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._next[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._next["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("INext.-next", coll);
      }
    }
  }
};
cljs.core.ILookup = function() {
};
cljs.core._lookup = function cljs$core$_lookup(var_args) {
  var args9510 = [];
  var len__8278__auto___9513 = arguments.length;
  var i__8279__auto___9514 = 0;
  while (true) {
    if (i__8279__auto___9514 < len__8278__auto___9513) {
      args9510.push(arguments[i__8279__auto___9514]);
      var G__9515 = i__8279__auto___9514 + 1;
      i__8279__auto___9514 = G__9515;
      continue;
    } else {
    }
    break;
  }
  var G__9512 = args9510.length;
  switch(G__9512) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9510.length)].join(""));;
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$2 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._lookup[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(o, k) : m__7776__auto__.call(null, o, k);
    } else {
      var m__7776__auto____$1 = cljs.core._lookup["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(o, k) : m__7776__auto____$1.call(null, o, k);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$3 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._lookup[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__7776__auto__.call(null, o, k, not_found);
    } else {
      var m__7776__auto____$1 = cljs.core._lookup["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__7776__auto____$1.call(null, o, k, not_found);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
};
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._contains_key_QMARK_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7776__auto__.call(null, coll, k);
    } else {
      var m__7776__auto____$1 = cljs.core._contains_key_QMARK_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7776__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
      }
    }
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_assoc$arity$3 == null)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._assoc[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__7776__auto__.call(null, coll, k, v);
    } else {
      var m__7776__auto____$1 = cljs.core._assoc["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__7776__auto____$1.call(null, coll, k, v);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
      }
    }
  }
};
cljs.core.IMap = function() {
};
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IMap$_dissoc$arity$2 == null)) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._dissoc[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7776__auto__.call(null, coll, k);
    } else {
      var m__7776__auto____$1 = cljs.core._dissoc["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__7776__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IMap.-dissoc", coll);
      }
    }
  }
};
cljs.core.IMapEntry = function() {
};
cljs.core._key = function cljs$core$_key(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_key$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._key[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._key["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-key", coll);
      }
    }
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_val$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._val[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._val["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-val", coll);
      }
    }
  }
};
cljs.core.ISet = function() {
};
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (!(coll == null) && !(coll.cljs$core$ISet$_disjoin$arity$2 == null)) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._disjoin[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, v) : m__7776__auto__.call(null, coll, v);
    } else {
      var m__7776__auto____$1 = cljs.core._disjoin["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, v) : m__7776__auto____$1.call(null, coll, v);
      } else {
        throw cljs.core.missing_protocol("ISet.-disjoin", coll);
      }
    }
  }
};
cljs.core.IStack = function() {
};
cljs.core._peek = function cljs$core$_peek(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_peek$arity$1 == null)) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._peek[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._peek["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-peek", coll);
      }
    }
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_pop$arity$1 == null)) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._pop[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._pop["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-pop", coll);
      }
    }
  }
};
cljs.core.IVector = function() {
};
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (!(coll == null) && !(coll.cljs$core$IVector$_assoc_n$arity$3 == null)) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._assoc_n[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__7776__auto__.call(null, coll, n, val);
    } else {
      var m__7776__auto____$1 = cljs.core._assoc_n["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__7776__auto____$1.call(null, coll, n, val);
      } else {
        throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
      }
    }
  }
};
cljs.core.IDeref = function() {
};
cljs.core._deref = function cljs$core$_deref(o) {
  if (!(o == null) && !(o.cljs$core$IDeref$_deref$arity$1 == null)) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._deref[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto__.call(null, o);
    } else {
      var m__7776__auto____$1 = cljs.core._deref["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IDeref.-deref", o);
      }
    }
  }
};
cljs.core.IDerefWithTimeout = function() {
};
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (!(o == null) && !(o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._deref_with_timeout[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__7776__auto__.call(null, o, msec, timeout_val);
    } else {
      var m__7776__auto____$1 = cljs.core._deref_with_timeout["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__7776__auto____$1.call(null, o, msec, timeout_val);
      } else {
        throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
      }
    }
  }
};
cljs.core.IMeta = function() {
};
cljs.core._meta = function cljs$core$_meta(o) {
  if (!(o == null) && !(o.cljs$core$IMeta$_meta$arity$1 == null)) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._meta[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto__.call(null, o);
    } else {
      var m__7776__auto____$1 = cljs.core._meta["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IMeta.-meta", o);
      }
    }
  }
};
cljs.core.IWithMeta = function() {
};
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (!(o == null) && !(o.cljs$core$IWithMeta$_with_meta$arity$2 == null)) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._with_meta[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(o, meta) : m__7776__auto__.call(null, o, meta);
    } else {
      var m__7776__auto____$1 = cljs.core._with_meta["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(o, meta) : m__7776__auto____$1.call(null, o, meta);
      } else {
        throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
      }
    }
  }
};
cljs.core.IReduce = function() {
};
cljs.core._reduce = function cljs$core$_reduce(var_args) {
  var args9517 = [];
  var len__8278__auto___9520 = arguments.length;
  var i__8279__auto___9521 = 0;
  while (true) {
    if (i__8279__auto___9521 < len__8278__auto___9520) {
      args9517.push(arguments[i__8279__auto___9521]);
      var G__9522 = i__8279__auto___9521 + 1;
      i__8279__auto___9521 = G__9522;
      continue;
    } else {
    }
    break;
  }
  var G__9519 = args9517.length;
  switch(G__9519) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9517.length)].join(""));;
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$2 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._reduce[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, f) : m__7776__auto__.call(null, coll, f);
    } else {
      var m__7776__auto____$1 = cljs.core._reduce["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, f) : m__7776__auto____$1.call(null, coll, f);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$3 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._reduce[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__7776__auto__.call(null, coll, f, start);
    } else {
      var m__7776__auto____$1 = cljs.core._reduce["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__7776__auto____$1.call(null, coll, f, start);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
};
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (!(coll == null) && !(coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._kv_reduce[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__7776__auto__.call(null, coll, f, init);
    } else {
      var m__7776__auto____$1 = cljs.core._kv_reduce["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__7776__auto____$1.call(null, coll, f, init);
      } else {
        throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
      }
    }
  }
};
cljs.core.IEquiv = function() {
};
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (!(o == null) && !(o.cljs$core$IEquiv$_equiv$arity$2 == null)) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._equiv[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(o, other) : m__7776__auto__.call(null, o, other);
    } else {
      var m__7776__auto____$1 = cljs.core._equiv["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(o, other) : m__7776__auto____$1.call(null, o, other);
      } else {
        throw cljs.core.missing_protocol("IEquiv.-equiv", o);
      }
    }
  }
};
cljs.core.IHash = function() {
};
cljs.core._hash = function cljs$core$_hash(o) {
  if (!(o == null) && !(o.cljs$core$IHash$_hash$arity$1 == null)) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._hash[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto__.call(null, o);
    } else {
      var m__7776__auto____$1 = cljs.core._hash["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IHash.-hash", o);
      }
    }
  }
};
cljs.core.ISeqable = function() {
};
cljs.core._seq = function cljs$core$_seq(o) {
  if (!(o == null) && !(o.cljs$core$ISeqable$_seq$arity$1 == null)) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._seq[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto__.call(null, o);
    } else {
      var m__7776__auto____$1 = cljs.core._seq["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7776__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("ISeqable.-seq", o);
      }
    }
  }
};
cljs.core.ISequential = function() {
};
cljs.core.IList = function() {
};
cljs.core.IRecord = function() {
};
cljs.core.IReversible = function() {
};
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (!(coll == null) && !(coll.cljs$core$IReversible$_rseq$arity$1 == null)) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._rseq[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._rseq["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IReversible.-rseq", coll);
      }
    }
  }
};
cljs.core.ISorted = function() {
};
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._sorted_seq[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__7776__auto__.call(null, coll, ascending_QMARK_);
    } else {
      var m__7776__auto____$1 = cljs.core._sorted_seq["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__7776__auto____$1.call(null, coll, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
      }
    }
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._sorted_seq_from[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__7776__auto__.call(null, coll, k, ascending_QMARK_);
    } else {
      var m__7776__auto____$1 = cljs.core._sorted_seq_from["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__7776__auto____$1.call(null, coll, k, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
      }
    }
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_entry_key$arity$2 == null)) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._entry_key[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__7776__auto__.call(null, coll, entry);
    } else {
      var m__7776__auto____$1 = cljs.core._entry_key["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__7776__auto____$1.call(null, coll, entry);
      } else {
        throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
      }
    }
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_comparator$arity$1 == null)) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._comparator[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._comparator["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISorted.-comparator", coll);
      }
    }
  }
};
cljs.core.IWriter = function() {
};
cljs.core._write = function cljs$core$_write(writer, s) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_write$arity$2 == null)) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__7775__auto__ = writer == null ? null : writer;
    var m__7776__auto__ = cljs.core._write[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(writer, s) : m__7776__auto__.call(null, writer, s);
    } else {
      var m__7776__auto____$1 = cljs.core._write["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(writer, s) : m__7776__auto____$1.call(null, writer, s);
      } else {
        throw cljs.core.missing_protocol("IWriter.-write", writer);
      }
    }
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_flush$arity$1 == null)) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__7775__auto__ = writer == null ? null : writer;
    var m__7776__auto__ = cljs.core._flush[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__7776__auto__.call(null, writer);
    } else {
      var m__7776__auto____$1 = cljs.core._flush["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__7776__auto____$1.call(null, writer);
      } else {
        throw cljs.core.missing_protocol("IWriter.-flush", writer);
      }
    }
  }
};
cljs.core.IPrintWithWriter = function() {
};
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (!(o == null) && !(o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._pr_writer[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__7776__auto__.call(null, o, writer, opts);
    } else {
      var m__7776__auto____$1 = cljs.core._pr_writer["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__7776__auto____$1.call(null, o, writer, opts);
      } else {
        throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
      }
    }
  }
};
cljs.core.IPending = function() {
};
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(x) {
  if (!(x == null) && !(x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)) {
    return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
  } else {
    var x__7775__auto__ = x == null ? null : x;
    var m__7776__auto__ = cljs.core._realized_QMARK_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7776__auto__.call(null, x);
    } else {
      var m__7776__auto____$1 = cljs.core._realized_QMARK_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7776__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("IPending.-realized?", x);
      }
    }
  }
};
cljs.core.IWatchable = function() {
};
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._notify_watches[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__7776__auto__.call(null, this$, oldval, newval);
    } else {
      var m__7776__auto____$1 = cljs.core._notify_watches["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__7776__auto____$1.call(null, this$, oldval, newval);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
      }
    }
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_add_watch$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._add_watch[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__7776__auto__.call(null, this$, key, f);
    } else {
      var m__7776__auto____$1 = cljs.core._add_watch["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__7776__auto____$1.call(null, this$, key, f);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
      }
    }
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__7775__auto__ = this$ == null ? null : this$;
    var m__7776__auto__ = cljs.core._remove_watch[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(this$, key) : m__7776__auto__.call(null, this$, key);
    } else {
      var m__7776__auto____$1 = cljs.core._remove_watch["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, key) : m__7776__auto____$1.call(null, this$, key);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
      }
    }
  }
};
cljs.core.IEditableCollection = function() {
};
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._as_transient[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._as_transient["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
      }
    }
  }
};
cljs.core.ITransientCollection = function() {
};
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__7775__auto__ = tcoll == null ? null : tcoll;
    var m__7776__auto__ = cljs.core._conj_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__7776__auto__.call(null, tcoll, val);
    } else {
      var m__7776__auto____$1 = cljs.core._conj_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__7776__auto____$1.call(null, tcoll, val);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
      }
    }
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__7775__auto__ = tcoll == null ? null : tcoll;
    var m__7776__auto__ = cljs.core._persistent_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7776__auto__.call(null, tcoll);
    } else {
      var m__7776__auto____$1 = cljs.core._persistent_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7776__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
      }
    }
  }
};
cljs.core.ITransientAssociative = function() {
};
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__7775__auto__ = tcoll == null ? null : tcoll;
    var m__7776__auto__ = cljs.core._assoc_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__7776__auto__.call(null, tcoll, key, val);
    } else {
      var m__7776__auto____$1 = cljs.core._assoc_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__7776__auto____$1.call(null, tcoll, key, val);
      } else {
        throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientMap = function() {
};
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__7775__auto__ = tcoll == null ? null : tcoll;
    var m__7776__auto__ = cljs.core._dissoc_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__7776__auto__.call(null, tcoll, key);
    } else {
      var m__7776__auto____$1 = cljs.core._dissoc_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__7776__auto____$1.call(null, tcoll, key);
      } else {
        throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientVector = function() {
};
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__7775__auto__ = tcoll == null ? null : tcoll;
    var m__7776__auto__ = cljs.core._assoc_n_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__7776__auto__.call(null, tcoll, n, val);
    } else {
      var m__7776__auto____$1 = cljs.core._assoc_n_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__7776__auto____$1.call(null, tcoll, n, val);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
      }
    }
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__7775__auto__ = tcoll == null ? null : tcoll;
    var m__7776__auto__ = cljs.core._pop_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7776__auto__.call(null, tcoll);
    } else {
      var m__7776__auto____$1 = cljs.core._pop_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7776__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
      }
    }
  }
};
cljs.core.ITransientSet = function() {
};
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__7775__auto__ = tcoll == null ? null : tcoll;
    var m__7776__auto__ = cljs.core._disjoin_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__7776__auto__.call(null, tcoll, v);
    } else {
      var m__7776__auto____$1 = cljs.core._disjoin_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__7776__auto____$1.call(null, tcoll, v);
      } else {
        throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
      }
    }
  }
};
cljs.core.IComparable = function() {
};
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (!(x == null) && !(x.cljs$core$IComparable$_compare$arity$2 == null)) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__7775__auto__ = x == null ? null : x;
    var m__7776__auto__ = cljs.core._compare[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(x, y) : m__7776__auto__.call(null, x, y);
    } else {
      var m__7776__auto____$1 = cljs.core._compare["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(x, y) : m__7776__auto____$1.call(null, x, y);
      } else {
        throw cljs.core.missing_protocol("IComparable.-compare", x);
      }
    }
  }
};
cljs.core.IChunk = function() {
};
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunk$_drop_first$arity$1 == null)) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._drop_first[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._drop_first["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
      }
    }
  }
};
cljs.core.IChunkedSeq = function() {
};
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._chunked_first[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._chunked_first["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
      }
    }
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._chunked_rest[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._chunked_rest["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
      }
    }
  }
};
cljs.core.IChunkedNext = function() {
};
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._chunked_next[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._chunked_next["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
      }
    }
  }
};
cljs.core.INamed = function() {
};
cljs.core._name = function cljs$core$_name(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_name$arity$1 == null)) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__7775__auto__ = x == null ? null : x;
    var m__7776__auto__ = cljs.core._name[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7776__auto__.call(null, x);
    } else {
      var m__7776__auto____$1 = cljs.core._name["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7776__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-name", x);
      }
    }
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_namespace$arity$1 == null)) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__7775__auto__ = x == null ? null : x;
    var m__7776__auto__ = cljs.core._namespace[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7776__auto__.call(null, x);
    } else {
      var m__7776__auto____$1 = cljs.core._namespace["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7776__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-namespace", x);
      }
    }
  }
};
cljs.core.IAtom = function() {
};
cljs.core.IReset = function() {
};
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IReset$_reset_BANG_$arity$2 == null)) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._reset_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7776__auto__.call(null, o, new_value);
    } else {
      var m__7776__auto____$1 = cljs.core._reset_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7776__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IReset.-reset!", o);
      }
    }
  }
};
cljs.core.ISwap = function() {
};
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_(var_args) {
  var args9524 = [];
  var len__8278__auto___9527 = arguments.length;
  var i__8279__auto___9528 = 0;
  while (true) {
    if (i__8279__auto___9528 < len__8278__auto___9527) {
      args9524.push(arguments[i__8279__auto___9528]);
      var G__9529 = i__8279__auto___9528 + 1;
      i__8279__auto___9528 = G__9529;
      continue;
    } else {
    }
    break;
  }
  var G__9526 = args9524.length;
  switch(G__9526) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9524.length)].join(""));;
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(o, f) : m__7776__auto__.call(null, o, f);
    } else {
      var m__7776__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(o, f) : m__7776__auto____$1.call(null, o, f);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__7776__auto__.call(null, o, f, a);
    } else {
      var m__7776__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__7776__auto____$1.call(null, o, f, a);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__7776__auto__.call(null, o, f, a, b);
    } else {
      var m__7776__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__7776__auto____$1.call(null, o, f, a, b);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__7776__auto__.call(null, o, f, a, b, xs);
    } else {
      var m__7776__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__7776__auto____$1.call(null, o, f, a, b, xs);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
};
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__7775__auto__ = o == null ? null : o;
    var m__7776__auto__ = cljs.core._vreset_BANG_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7776__auto__.call(null, o, new_value);
    } else {
      var m__7776__auto____$1 = cljs.core._vreset_BANG_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__7776__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
      }
    }
  }
};
cljs.core.IIterable = function() {
};
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (!(coll == null) && !(coll.cljs$core$IIterable$_iterator$arity$1 == null)) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__7775__auto__ = coll == null ? null : coll;
    var m__7776__auto__ = cljs.core._iterator[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto__.call(null, coll);
    } else {
      var m__7776__auto____$1 = cljs.core._iterator["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7776__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IIterable.-iterator", coll);
      }
    }
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(Math.imul(4294967295, 5) === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    return Math.imul(a, b);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  return h1__$6 ^ h1__$6 >>> 16;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__9531 = i + 2;
        var G__9532 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__9531;
        h1 = G__9532;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__9535 = i + 1;
          var G__9536 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__9535;
          hash = G__9536;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  if (k == null) {
    return 0;
  } else {
    var h = cljs.core.string_hash_cache[k];
    if (typeof h === "number") {
      return h;
    } else {
      return cljs.core.add_to_string_hash_cache(k);
    }
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 4194304 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$ ? true : false : false) {
    return o.cljs$core$IHash$_hash$arity$1(null);
  } else {
    if (typeof o === "number") {
      if (cljs.core.truth_(isFinite(o))) {
        return Math.floor(o) % 2147483647;
      } else {
        var G__9544 = o;
        switch(G__9544) {
          case Infinity:
            return 2146435072;
            break;
          case -Infinity:
            return -1048576;
            break;
          default:
            return 2146959360;
        }
      }
    } else {
      if (o === true) {
        return 1231;
      } else {
        if (o === false) {
          return 1237;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf();
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o);
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(c, x) {
  return x instanceof c;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__7050__auto__ = cljs.core.not(a.ns);
      if (and__7050__auto__) {
        return b.ns;
      } else {
        return and__7050__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__9552 = a.ns;
            var G__9553 = b.ns;
            return goog.array.defaultCompare(G__9552, G__9553);
          }();
          if (0 === nsc) {
            var G__9554 = a.name;
            var G__9555 = b.name;
            return goog.array.defaultCompare(G__9554, G__9555);
          } else {
            return nsc;
          }
        }
      } else {
        var G__9556 = a.name;
        var G__9557 = b.name;
        return goog.array.defaultCompare(G__9556, G__9557);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__9559 = null;
  var G__9559__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
  };
  var G__9559__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
  };
  G__9559 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9559__2.call(this, self__, coll);
      case 3:
        return G__9559__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9559.cljs$core$IFn$_invoke$arity$2 = G__9559__2;
  G__9559.cljs$core$IFn$_invoke$arity$3 = G__9559__3;
  return G__9559;
}();
cljs.core.Symbol.prototype.apply = function(self__, args9558) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9558)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__7499__auto__ = self__._hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, 
  "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol(var_args) {
  var args9560 = [];
  var len__8278__auto___9563 = arguments.length;
  var i__8279__auto___9564 = 0;
  while (true) {
    if (i__8279__auto___9564 < len__8278__auto___9563) {
      args9560.push(arguments[i__8279__auto___9564]);
      var G__9565 = i__8279__auto___9564 + 1;
      i__8279__auto___9564 = G__9565;
      continue;
    } else {
    }
    break;
  }
  var G__9562 = args9560.length;
  switch(G__9562) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9560.length)].join(""));;
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    var idx = name.indexOf("/");
    if (idx < 1) {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
    } else {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring(0, idx), name.substring(idx + 1, name.length));
    }
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str(ns), cljs.core.str("/"), cljs.core.str(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 6717441;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.isMacro = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
};
cljs.core.Var.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str("#'"), cljs.core.str(self__.sym)].join("");
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Var(self__.val, self__.sym, new_meta);
};
cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  if (other instanceof cljs.core.Var) {
    var G__9568 = this$__$1.sym;
    var G__9569 = other.sym;
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__9568, G__9569) : cljs.core._EQ_.call(null, G__9568, G__9569);
  } else {
    return false;
  }
};
cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return cljs.core.hash_symbol(self__.sym);
};
cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Var.prototype.call = function() {
  var G__9614 = null;
  var G__9614__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
  };
  var G__9614__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
  };
  var G__9614__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
  };
  var G__9614__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
  };
  var G__9614__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
  };
  var G__9614__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
  };
  var G__9614__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
  };
  var G__9614__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
  };
  var G__9614__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
  };
  var G__9614__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__9614__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__9614__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__9614__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__9614__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__9614__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__9614__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__9614__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__9614__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__9614__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__9614__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__9614__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__9614__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__9570 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    var G__9571 = a;
    var G__9572 = b;
    var G__9573 = c;
    var G__9574 = d;
    var G__9575 = e;
    var G__9576 = f;
    var G__9577 = g;
    var G__9578 = h;
    var G__9579 = i;
    var G__9580 = j;
    var G__9581 = k;
    var G__9582 = l;
    var G__9583 = m;
    var G__9584 = n;
    var G__9585 = o;
    var G__9586 = p;
    var G__9587 = q;
    var G__9588 = r;
    var G__9589 = s;
    var G__9590 = t;
    var G__9591 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__9570, G__9571, G__9572, G__9573, G__9574, G__9575, G__9576, G__9577, G__9578, G__9579, G__9580, G__9581, G__9582, G__9583, G__9584, G__9585, G__9586, G__9587, G__9588, G__9589, G__9590, G__9591) : cljs.core.apply.call(null, G__9570, G__9571, G__9572, G__9573, G__9574, G__9575, G__9576, G__9577, G__9578, G__9579, G__9580, G__9581, G__9582, G__9583, G__9584, G__9585, G__9586, G__9587, G__9588, 
    G__9589, G__9590, G__9591);
  };
  G__9614 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__9614__1.call(this, self__);
      case 2:
        return G__9614__2.call(this, self__, a);
      case 3:
        return G__9614__3.call(this, self__, a, b);
      case 4:
        return G__9614__4.call(this, self__, a, b, c);
      case 5:
        return G__9614__5.call(this, self__, a, b, c, d);
      case 6:
        return G__9614__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__9614__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__9614__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__9614__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__9614__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__9614__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__9614__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__9614__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__9614__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__9614__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__9614__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__9614__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__9614__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__9614__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__9614__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__9614__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__9614__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9614.cljs$core$IFn$_invoke$arity$1 = G__9614__1;
  G__9614.cljs$core$IFn$_invoke$arity$2 = G__9614__2;
  G__9614.cljs$core$IFn$_invoke$arity$3 = G__9614__3;
  G__9614.cljs$core$IFn$_invoke$arity$4 = G__9614__4;
  G__9614.cljs$core$IFn$_invoke$arity$5 = G__9614__5;
  G__9614.cljs$core$IFn$_invoke$arity$6 = G__9614__6;
  G__9614.cljs$core$IFn$_invoke$arity$7 = G__9614__7;
  G__9614.cljs$core$IFn$_invoke$arity$8 = G__9614__8;
  G__9614.cljs$core$IFn$_invoke$arity$9 = G__9614__9;
  G__9614.cljs$core$IFn$_invoke$arity$10 = G__9614__10;
  G__9614.cljs$core$IFn$_invoke$arity$11 = G__9614__11;
  G__9614.cljs$core$IFn$_invoke$arity$12 = G__9614__12;
  G__9614.cljs$core$IFn$_invoke$arity$13 = G__9614__13;
  G__9614.cljs$core$IFn$_invoke$arity$14 = G__9614__14;
  G__9614.cljs$core$IFn$_invoke$arity$15 = G__9614__15;
  G__9614.cljs$core$IFn$_invoke$arity$16 = G__9614__16;
  G__9614.cljs$core$IFn$_invoke$arity$17 = G__9614__17;
  G__9614.cljs$core$IFn$_invoke$arity$18 = G__9614__18;
  G__9614.cljs$core$IFn$_invoke$arity$19 = G__9614__19;
  G__9614.cljs$core$IFn$_invoke$arity$20 = G__9614__20;
  G__9614.cljs$core$IFn$_invoke$arity$21 = G__9614__21;
  G__9614.cljs$core$IFn$_invoke$arity$22 = G__9614__22;
  return G__9614;
}();
cljs.core.Var.prototype.apply = function(self__, args9567) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9567)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__9592 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  var G__9593 = a;
  var G__9594 = b;
  var G__9595 = c;
  var G__9596 = d;
  var G__9597 = e;
  var G__9598 = f;
  var G__9599 = g;
  var G__9600 = h;
  var G__9601 = i;
  var G__9602 = j;
  var G__9603 = k;
  var G__9604 = l;
  var G__9605 = m;
  var G__9606 = n;
  var G__9607 = o;
  var G__9608 = p;
  var G__9609 = q;
  var G__9610 = r;
  var G__9611 = s;
  var G__9612 = t;
  var G__9613 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__9592, G__9593, G__9594, G__9595, G__9596, G__9597, G__9598, G__9599, G__9600, G__9601, G__9602, G__9603, G__9604, G__9605, G__9606, G__9607, G__9608, G__9609, G__9610, G__9611, G__9612, G__9613) : cljs.core.apply.call(null, G__9592, G__9593, G__9594, G__9595, G__9596, G__9597, G__9598, G__9599, G__9600, G__9601, G__9602, G__9603, G__9604, G__9605, G__9606, G__9607, G__9608, G__9609, G__9610, 
  G__9611, G__9612, G__9613);
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  if (!(x == null)) {
    if (false || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  if (!(value == null)) {
    if (value.cljs$lang$protocol_mask$partition1$ & 8192 || cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!value.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$ ? true : false : false) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0, null);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0, null);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str(coll), cljs.core.str(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 128 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$ ? true : false : false) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_(var_args) {
  var args9627 = [];
  var len__8278__auto___9633 = arguments.length;
  var i__8279__auto___9634 = 0;
  while (true) {
    if (i__8279__auto___9634 < len__8278__auto___9633) {
      args9627.push(arguments[i__8279__auto___9634]);
      var G__9635 = i__8279__auto___9634 + 1;
      i__8279__auto___9634 = G__9635;
      continue;
    } else {
    }
    break;
  }
  var G__9632 = args9627.length;
  switch(G__9632) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9627.slice(2), 0, null);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__9637 = y;
        var G__9638 = cljs.core.first(more);
        var G__9639 = cljs.core.next(more);
        x = G__9637;
        y = G__9638;
        more = G__9639;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq9628) {
  var G__9629 = cljs.core.first(seq9628);
  var seq9628__$1 = cljs.core.next(seq9628);
  var G__9630 = cljs.core.first(seq9628__$1);
  var seq9628__$2 = cljs.core.next(seq9628__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9629, G__9630, seq9628__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null, self__.iter);
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__9640 = n + 1;
      var G__9641 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__9642 = cljs.core.next(coll__$1);
      n = G__9640;
      hash_code = G__9641;
      coll__$1 = G__9642;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__9643 = n + 1;
      var G__9644 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__9645 = cljs.core.next(coll__$1);
      n = G__9643;
      hash_code = G__9644;
      coll__$1 = G__9645;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__9646 = this$__$1.valueOf();
    var G__9647 = other.valueOf();
    return goog.array.defaultCompare(G__9646, G__9647);
  } else {
    throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(this$__$1), cljs.core.str(" to "), cljs.core.str(other)].join(""));
  }
};
cljs.core.Inst = function() {
};
cljs.core.inst_ms_STAR_ = function cljs$core$inst_ms_STAR_(inst) {
  if (!(inst == null) && !(inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)) {
    return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
  } else {
    var x__7775__auto__ = inst == null ? null : inst;
    var m__7776__auto__ = cljs.core.inst_ms_STAR_[goog.typeOf(x__7775__auto__)];
    if (!(m__7776__auto__ == null)) {
      return m__7776__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__7776__auto__.call(null, inst);
    } else {
      var m__7776__auto____$1 = cljs.core.inst_ms_STAR_["_"];
      if (!(m__7776__auto____$1 == null)) {
        return m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7776__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__7776__auto____$1.call(null, inst);
      } else {
        throw cljs.core.missing_protocol("Inst.inst-ms*", inst);
      }
    }
  }
};
Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = function(inst) {
  var inst__$1 = this;
  return inst__$1.getTime();
};
cljs.core.inst_ms = function cljs$core$inst_ms(inst) {
  return cljs.core.inst_ms_STAR_(inst);
};
cljs.core.inst_QMARK_ = function cljs$core$inst_QMARK_(x) {
  if (!(x == null)) {
    if (false || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
  }
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.Fn["function"] = true;
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  return goog.getUid(o);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null, x);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce(var_args) {
  var args9650 = [];
  var len__8278__auto___9659 = arguments.length;
  var i__8279__auto___9660 = 0;
  while (true) {
    if (i__8279__auto___9660 < len__8278__auto___9659) {
      args9650.push(arguments[i__8279__auto___9660]);
      var G__9661 = i__8279__auto___9660 + 1;
      i__8279__auto___9660 = G__9661;
      continue;
    } else {
    }
    break;
  }
  var G__9652 = args9650.length;
  switch(G__9652) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9650.length)].join(""));;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__9653 = val;
          var G__9654 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9653, G__9654) : f.call(null, G__9653, G__9654);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__9663 = nval;
          var G__9664 = n + 1;
          val = G__9663;
          n = G__9664;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9655 = val__$1;
        var G__9656 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9655, G__9656) : f.call(null, G__9655, G__9656);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9665 = nval;
        var G__9666 = n + 1;
        val__$1 = G__9665;
        n = G__9666;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9657 = val__$1;
        var G__9658 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9657, G__9658) : f.call(null, G__9657, G__9658);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9667 = nval;
        var G__9668 = n + 1;
        val__$1 = G__9667;
        n = G__9668;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce(var_args) {
  var args9669 = [];
  var len__8278__auto___9678 = arguments.length;
  var i__8279__auto___9679 = 0;
  while (true) {
    if (i__8279__auto___9679 < len__8278__auto___9678) {
      args9669.push(arguments[i__8279__auto___9679]);
      var G__9680 = i__8279__auto___9679 + 1;
      i__8279__auto___9679 = G__9680;
      continue;
    } else {
    }
    break;
  }
  var G__9671 = args9669.length;
  switch(G__9671) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9669.length)].join(""));;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__9672 = val;
          var G__9673 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9672, G__9673) : f.call(null, G__9672, G__9673);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__9682 = nval;
          var G__9683 = n + 1;
          val = G__9682;
          n = G__9683;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9674 = val__$1;
        var G__9675 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9674, G__9675) : f.call(null, G__9674, G__9675);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9684 = nval;
        var G__9685 = n + 1;
        val__$1 = G__9684;
        n = G__9685;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__9676 = val__$1;
        var G__9677 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9676, G__9677) : f.call(null, G__9676, G__9677);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9686 = nval;
        var G__9687 = n + 1;
        val__$1 = G__9686;
        n = G__9687;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 2 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
  }
};
cljs.core._indexOf = function cljs$core$_indexOf(var_args) {
  var args9692 = [];
  var len__8278__auto___9695 = arguments.length;
  var i__8279__auto___9696 = 0;
  while (true) {
    if (i__8279__auto___9696 < len__8278__auto___9695) {
      args9692.push(arguments[i__8279__auto___9696]);
      var G__9697 = i__8279__auto___9696 + 1;
      i__8279__auto___9696 = G__9697;
      continue;
    } else {
    }
    break;
  }
  var G__9694 = args9692.length;
  switch(G__9694) {
    case 2:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9692.length)].join(""));;
  }
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll);
  if (start >= len) {
    return -1;
  } else {
    var idx = start > 0 ? start : start < 0 ? function() {
      var x__7395__auto__ = 0;
      var y__7396__auto__ = start + len;
      return x__7395__auto__ > y__7396__auto__ ? x__7395__auto__ : y__7396__auto__;
    }() : start;
    while (true) {
      if (idx < len) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx) : cljs.core.nth.call(null, coll, idx), x)) {
          return idx;
        } else {
          var G__9699 = idx + 1;
          idx = G__9699;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._indexOf.cljs$lang$maxFixedArity = 3;
cljs.core._lastIndexOf = function cljs$core$_lastIndexOf(var_args) {
  var args9700 = [];
  var len__8278__auto___9703 = arguments.length;
  var i__8279__auto___9704 = 0;
  while (true) {
    if (i__8279__auto___9704 < len__8278__auto___9703) {
      args9700.push(arguments[i__8279__auto___9704]);
      var G__9705 = i__8279__auto___9704 + 1;
      i__8279__auto___9704 = G__9705;
      continue;
    } else {
    }
    break;
  }
  var G__9702 = args9700.length;
  switch(G__9702) {
    case 2:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9700.length)].join(""));;
  }
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll);
  if (len === 0) {
    return -1;
  } else {
    var idx = start > 0 ? function() {
      var x__7402__auto__ = len - 1;
      var y__7403__auto__ = start;
      return x__7402__auto__ < y__7403__auto__ ? x__7402__auto__ : y__7403__auto__;
    }() : start < 0 ? len + start : start;
    while (true) {
      if (idx >= 0) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx) : cljs.core.nth.call(null, coll, idx), x)) {
          return idx;
        } else {
          var G__9707 = idx - 1;
          idx = G__9707;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i, meta) {
  this.arr = arr;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 166592766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.indexOf = function() {
  var G__9708 = null;
  var G__9708__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9708__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9708 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9708__1.call(this, x);
      case 2:
        return G__9708__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9708.cljs$core$IFn$_invoke$arity$1 = G__9708__1;
  G__9708.cljs$core$IFn$_invoke$arity$2 = G__9708__2;
  return G__9708;
}();
cljs.core.IndexedSeq.prototype.lastIndexOf = function() {
  var G__9709 = null;
  var G__9709__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
  };
  var G__9709__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9709 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9709__1.call(this, x);
      case 2:
        return G__9709__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9709.cljs$core$IFn$_invoke$arity$1 = G__9709__1;
  G__9709.cljs$core$IFn$_invoke$arity$2 = G__9709__2;
  return G__9709;
}();
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, self__.meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__7395__auto__ = 0;
  var y__7396__auto__ = self__.arr.length - self__.i;
  return x__7395__auto__ > y__7396__auto__ ? x__7395__auto__ : y__7396__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = cljs.core._count(coll__$1);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, new_meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i, meta) {
  return new cljs.core.IndexedSeq(arr, i, meta);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq(var_args) {
  var args9710 = [];
  var len__8278__auto___9713 = arguments.length;
  var i__8279__auto___9714 = 0;
  while (true) {
    if (i__8279__auto___9714 < len__8278__auto___9713) {
      args9710.push(arguments[i__8279__auto___9714]);
      var G__9715 = i__8279__auto___9714 + 1;
      i__8279__auto___9714 = G__9715;
      continue;
    } else {
    }
    break;
  }
  var G__9712 = args9710.length;
  switch(G__9712) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9710.length)].join(""));;
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i, null);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq(var_args) {
  var args9717 = [];
  var len__8278__auto___9720 = arguments.length;
  var i__8279__auto___9721 = 0;
  while (true) {
    if (i__8279__auto___9721 < len__8278__auto___9720) {
      args9717.push(arguments[i__8279__auto___9721]);
      var G__9722 = i__8279__auto___9721 + 1;
      i__8279__auto___9721 = G__9722;
      continue;
    } else {
    }
    break;
  }
  var G__9719 = args9717.length;
  switch(G__9719) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9717.length)].join(""));;
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.indexOf = function() {
  var G__9726 = null;
  var G__9726__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__9726__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9726 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9726__1.call(this, x);
      case 2:
        return G__9726__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9726.cljs$core$IFn$_invoke$arity$1 = G__9726__1;
  G__9726.cljs$core$IFn$_invoke$arity$2 = G__9726__2;
  return G__9726;
}();
cljs.core.RSeq.prototype.lastIndexOf = function() {
  var G__9727 = null;
  var G__9727__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
  };
  var G__9727__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__9727 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__9727__1.call(this, x);
      case 2:
        return G__9727__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9727.cljs$core$IFn$_invoke$arity$1 = G__9727__1;
  G__9727.cljs$core$IFn$_invoke$arity$2 = G__9727__2;
  return G__9727;
}();
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__9724 = cljs.core.List.EMPTY;
  var G__9725 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__9724, G__9725) : cljs.core.with_meta.call(null, G__9724, G__9725);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, col__$1) : cljs.core.seq_reduce.call(null, f, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, col__$1) : cljs.core.seq_reduce.call(null, f, start, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__9728 = sn;
      s = G__9728;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj(var_args) {
  var args9729 = [];
  var len__8278__auto___9735 = arguments.length;
  var i__8279__auto___9736 = 0;
  while (true) {
    if (i__8279__auto___9736 < len__8278__auto___9735) {
      args9729.push(arguments[i__8279__auto___9736]);
      var G__9737 = i__8279__auto___9736 + 1;
      i__8279__auto___9736 = G__9737;
      continue;
    } else {
    }
    break;
  }
  var G__9734 = args9729.length;
  switch(G__9734) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9729.slice(2), 0, null);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    var x__7991__auto__ = x;
    return cljs.core._conj(cljs.core.List.EMPTY, x__7991__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__9739 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__9740 = cljs.core.first(xs);
      var G__9741 = cljs.core.next(xs);
      coll = G__9739;
      x = G__9740;
      xs = G__9741;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq9730) {
  var G__9731 = cljs.core.first(seq9730);
  var seq9730__$1 = cljs.core.next(seq9730);
  var G__9732 = cljs.core.first(seq9730__$1);
  var seq9730__$2 = cljs.core.next(seq9730__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__9731, G__9732, seq9730__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__9742 = cljs.core.next(s);
      var G__9743 = acc + 1;
      s = G__9742;
      acc = G__9743;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 2 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$ ? true : false : false) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$ ? true : false : false) {
            return cljs.core.accumulating_seq_count(coll);
          } else {
            return cljs.core._count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth(var_args) {
  var args9748 = [];
  var len__8278__auto___9751 = arguments.length;
  var i__8279__auto___9752 = 0;
  while (true) {
    if (i__8279__auto___9752 < len__8278__auto___9751) {
      args9748.push(arguments[i__8279__auto___9752]);
      var G__9753 = i__8279__auto___9752 + 1;
      i__8279__auto___9752 = G__9753;
      continue;
    } else {
    }
    break;
  }
  var G__9750 = args9748.length;
  switch(G__9750) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9748.length)].join(""));;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__9755 = cljs.core.next(coll);
            var G__9756 = n - 1;
            coll = G__9755;
            n = G__9756;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__9757 = cljs.core.next(coll);
            var G__9758 = n - 1;
            var G__9759 = not_found;
            coll = G__9757;
            n = G__9758;
            not_found = G__9759;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth(var_args) {
  var args9760 = [];
  var len__8278__auto___9767 = arguments.length;
  var i__8279__auto___9768 = 0;
  while (true) {
    if (i__8279__auto___9768 < len__8278__auto___9767) {
      args9760.push(arguments[i__8279__auto___9768]);
      var G__9769 = i__8279__auto___9768 + 1;
      i__8279__auto___9768 = G__9769;
      continue;
    } else {
    }
    break;
  }
  var G__9762 = args9760.length;
  switch(G__9762) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9760.length)].join(""));;
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("Index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n >= 0 && n < coll.length) {
            return coll[n];
          } else {
            throw new Error("Index out of bounds");
          }
        } else {
          if (typeof coll === "string") {
            if (n >= 0 && n < coll.length) {
              return coll.charAt(n);
            } else {
              throw new Error("Index out of bounds");
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("Index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n >= 0 && n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n >= 0 && n < coll.length) {
              return coll.charAt(n);
            } else {
              return not_found;
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__9771 = n__$1 - 1;
      var G__9772 = cljs.core.rest(xs);
      n__$1 = G__9771;
      xs = G__9772;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get(var_args) {
  var args9773 = [];
  var len__8278__auto___9778 = arguments.length;
  var i__8279__auto___9779 = 0;
  while (true) {
    if (i__8279__auto___9779 < len__8278__auto___9778) {
      args9773.push(arguments[i__8279__auto___9779]);
      var G__9780 = i__8279__auto___9779 + 1;
      i__8279__auto___9779 = G__9780;
      continue;
    } else {
    }
    break;
  }
  var G__9775 = args9773.length;
  switch(G__9775) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9773.length)].join(""));;
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (cljs.core.some_QMARK_(k) && k < o.length) {
            return o[k | 0];
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k | 0];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k | 0];
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc(var_args) {
  var args9782 = [];
  var len__8278__auto___9789 = arguments.length;
  var i__8279__auto___9790 = 0;
  while (true) {
    if (i__8279__auto___9790 < len__8278__auto___9789) {
      args9782.push(arguments[i__8279__auto___9790]);
      var G__9791 = i__8279__auto___9790 + 1;
      i__8279__auto___9790 = G__9791;
      continue;
    } else {
    }
    break;
  }
  var G__9788 = args9782.length;
  switch(G__9788) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9782.slice(3), 0, null);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__8301__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentHashMap.fromArrays([k], [v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__9793 = ret;
      var G__9794 = cljs.core.first(kvs);
      var G__9795 = cljs.core.second(kvs);
      var G__9796 = cljs.core.nnext(kvs);
      coll = G__9793;
      k = G__9794;
      v = G__9795;
      kvs = G__9796;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq9783) {
  var G__9784 = cljs.core.first(seq9783);
  var seq9783__$1 = cljs.core.next(seq9783);
  var G__9785 = cljs.core.first(seq9783__$1);
  var seq9783__$2 = cljs.core.next(seq9783__$1);
  var G__9786 = cljs.core.first(seq9783__$2);
  var seq9783__$3 = cljs.core.next(seq9783__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__9784, G__9785, G__9786, seq9783__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc(var_args) {
  var args9797 = [];
  var len__8278__auto___9803 = arguments.length;
  var i__8279__auto___9804 = 0;
  while (true) {
    if (i__8279__auto___9804 < len__8278__auto___9803) {
      args9797.push(arguments[i__8279__auto___9804]);
      var G__9805 = i__8279__auto___9804 + 1;
      i__8279__auto___9804 = G__9805;
      continue;
    } else {
    }
    break;
  }
  var G__9802 = args9797.length;
  switch(G__9802) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9797.slice(2), 0, null);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__9807 = ret;
        var G__9808 = cljs.core.first(ks);
        var G__9809 = cljs.core.next(ks);
        coll = G__9807;
        k = G__9808;
        ks = G__9809;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq9798) {
  var G__9799 = cljs.core.first(seq9798);
  var seq9798__$1 = cljs.core.next(seq9798);
  var G__9800 = cljs.core.first(seq9798__$1);
  var seq9798__$2 = cljs.core.next(seq9798__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__9799, G__9800, seq9798__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__7062__auto__ = goog.isFunction(f);
  if (or__7062__auto__) {
    return or__7062__auto__;
  } else {
    if (!(f == null)) {
      if (false || cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.MetaFn.prototype.call = function() {
  var G__9815 = null;
  var G__9815__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__9815__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
  };
  var G__9815__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
  };
  var G__9815__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
  };
  var G__9815__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
  };
  var G__9815__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
  };
  var G__9815__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
  };
  var G__9815__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
  };
  var G__9815__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
  };
  var G__9815__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__9815__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__9815__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__9815__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__9815__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__9815__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__9815__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__9815__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__9815__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__9815__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__9815__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__9815__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__9815__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  };
  G__9815 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__9815__1.call(this, self__);
      case 2:
        return G__9815__2.call(this, self__, a);
      case 3:
        return G__9815__3.call(this, self__, a, b);
      case 4:
        return G__9815__4.call(this, self__, a, b, c);
      case 5:
        return G__9815__5.call(this, self__, a, b, c, d);
      case 6:
        return G__9815__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__9815__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__9815__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__9815__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__9815__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__9815__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__9815__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__9815__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__9815__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__9815__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__9815__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__9815__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__9815__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__9815__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__9815__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__9815__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__9815__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__9815.cljs$core$IFn$_invoke$arity$1 = G__9815__1;
  G__9815.cljs$core$IFn$_invoke$arity$2 = G__9815__2;
  G__9815.cljs$core$IFn$_invoke$arity$3 = G__9815__3;
  G__9815.cljs$core$IFn$_invoke$arity$4 = G__9815__4;
  G__9815.cljs$core$IFn$_invoke$arity$5 = G__9815__5;
  G__9815.cljs$core$IFn$_invoke$arity$6 = G__9815__6;
  G__9815.cljs$core$IFn$_invoke$arity$7 = G__9815__7;
  G__9815.cljs$core$IFn$_invoke$arity$8 = G__9815__8;
  G__9815.cljs$core$IFn$_invoke$arity$9 = G__9815__9;
  G__9815.cljs$core$IFn$_invoke$arity$10 = G__9815__10;
  G__9815.cljs$core$IFn$_invoke$arity$11 = G__9815__11;
  G__9815.cljs$core$IFn$_invoke$arity$12 = G__9815__12;
  G__9815.cljs$core$IFn$_invoke$arity$13 = G__9815__13;
  G__9815.cljs$core$IFn$_invoke$arity$14 = G__9815__14;
  G__9815.cljs$core$IFn$_invoke$arity$15 = G__9815__15;
  G__9815.cljs$core$IFn$_invoke$arity$16 = G__9815__16;
  G__9815.cljs$core$IFn$_invoke$arity$17 = G__9815__17;
  G__9815.cljs$core$IFn$_invoke$arity$18 = G__9815__18;
  G__9815.cljs$core$IFn$_invoke$arity$19 = G__9815__19;
  G__9815.cljs$core$IFn$_invoke$arity$20 = G__9815__20;
  G__9815.cljs$core$IFn$_invoke$arity$21 = G__9815__21;
  G__9815.cljs$core$IFn$_invoke$arity$22 = G__9815__22;
  return G__9815;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args9814) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args9814)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (goog.isFunction(o)) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__7050__auto__ = !(o == null);
    if (and__7050__auto__) {
      if (!(o == null)) {
        if (o.cljs$lang$protocol_mask$partition0$ & 131072 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$) {
          return true;
        } else {
          if (!o.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
      }
    } else {
      return and__7050__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj(var_args) {
  var args9820 = [];
  var len__8278__auto___9826 = arguments.length;
  var i__8279__auto___9827 = 0;
  while (true) {
    if (i__8279__auto___9827 < len__8278__auto___9826) {
      args9820.push(arguments[i__8279__auto___9827]);
      var G__9828 = i__8279__auto___9827 + 1;
      i__8279__auto___9827 = G__9828;
      continue;
    } else {
    }
    break;
  }
  var G__9825 = args9820.length;
  switch(G__9825) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9820.slice(2), 0, null);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__9830 = ret;
        var G__9831 = cljs.core.first(ks);
        var G__9832 = cljs.core.next(ks);
        coll = G__9830;
        k = G__9831;
        ks = G__9832;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq9821) {
  var G__9822 = cljs.core.first(seq9821);
  var seq9821__$1 = cljs.core.next(seq9821);
  var G__9823 = cljs.core.first(seq9821__$1);
  var seq9821__$2 = cljs.core.next(seq9821__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__9822, G__9823, seq9821__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 8 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 4096 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 512 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16777216 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 268435456 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 1024 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 67108864 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16384 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition1$ & 512 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj(var_args) {
  var args9853 = [];
  var len__8278__auto___9859 = arguments.length;
  var i__8279__auto___9860 = 0;
  while (true) {
    if (i__8279__auto___9860 < len__8278__auto___9859) {
      args9853.push(arguments[i__8279__auto___9860]);
      var G__9861 = i__8279__auto___9860 + 1;
      i__8279__auto___9860 = G__9861;
      continue;
    } else {
    }
    break;
  }
  var G__9856 = args9853.length;
  switch(G__9856) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9853.slice(0), 0, null);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__8301__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  return {};
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create, keyvals) : cljs.core.apply.call(null, goog.object.create, keyvals);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq9854) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9854));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__9865_9867 = obj;
  var G__9866_9868 = function(G__9865_9867, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__9865_9867, keys);
  goog.object.forEach(G__9865_9867, G__9866_9868);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__9869 = i__$1 + 1;
      var G__9870 = j__$1 + 1;
      var G__9871 = len__$1 - 1;
      i__$1 = G__9869;
      j__$1 = G__9870;
      len__$1 = G__9871;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__9872 = i__$1 - 1;
      var G__9873 = j__$1 - 1;
      var G__9874 = len__$1 - 1;
      i__$1 = G__9872;
      j__$1 = G__9873;
      len__$1 = G__9874;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.boolean_QMARK_ = function cljs$core$boolean_QMARK_(x) {
  return x === true || x === false;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    if (!(s == null)) {
      if (s.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$) {
        return true;
      } else {
        if (!s.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  if (!(s == null)) {
    if (s.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$) {
      return true;
    } else {
      if (!s.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (x == null) {
    return false;
  } else {
    if (x === false) {
      return false;
    } else {
      return true;
    }
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__7062__auto__ = cljs.core.fn_QMARK_(f);
  if (or__7062__auto__) {
    return or__7062__auto__;
  } else {
    if (!(f == null)) {
      if (f.cljs$lang$protocol_mask$partition0$ & 1 || cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && !isNaN(n) && !(n === Infinity) && parseFloat(n) === parseInt(n, 10);
};
cljs.core.int_QMARK_ = function cljs$core$int_QMARK_(x) {
  return cljs.core.integer_QMARK_(x) || x instanceof goog.math.Integer || x instanceof goog.math.Long;
};
cljs.core.pos_int_QMARK_ = function cljs$core$pos_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x > 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
    } else {
      if (x instanceof goog.math.Long) {
        return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
      } else {
        return false;
      }
    }
  }
};
cljs.core.neg_int_QMARK_ = function cljs$core$neg_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x < 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return x.isNegative();
    } else {
      if (x instanceof goog.math.Long) {
        return x.isNegative();
      } else {
        return false;
      }
    }
  }
};
cljs.core.nat_int_QMARK_ = function cljs$core$nat_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return !(x < 0) || x === 0;
  } else {
    if (x instanceof goog.math.Integer) {
      var or__7062__auto__ = cljs.core.not(x.isNegative());
      if (or__7062__auto__) {
        return or__7062__auto__;
      } else {
        return x.isZero();
      }
    } else {
      if (x instanceof goog.math.Long) {
        var or__7062__auto__ = cljs.core.not(x.isNegative());
        if (or__7062__auto__) {
          return or__7062__auto__;
        } else {
          return x.isZero();
        }
      } else {
        return false;
      }
    }
  }
};
cljs.core.float_QMARK_ = function cljs$core$float_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.double_QMARK_ = function cljs$core$double_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.infinite_QMARK_ = function cljs$core$infinite_QMARK_(x) {
  return x === Number.POSITIVE_INFINITY || x === Number.NEGATIVE_INFINITY;
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_(var_args) {
  var args9885 = [];
  var len__8278__auto___9891 = arguments.length;
  var i__8279__auto___9892 = 0;
  while (true) {
    if (i__8279__auto___9892 < len__8278__auto___9891) {
      args9885.push(arguments[i__8279__auto___9892]);
      var G__9893 = i__8279__auto___9892 + 1;
      i__8279__auto___9892 = G__9893;
      continue;
    } else {
    }
    break;
  }
  var G__9890 = args9885.length;
  switch(G__9890) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9885.slice(2), 0, null);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.fromArray([x, y], true);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__9895 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__9896 = etc;
          s = G__9895;
          xs = G__9896;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq9886) {
  var G__9887 = cljs.core.first(seq9886);
  var seq9886__$1 = cljs.core.next(seq9886);
  var G__9888 = cljs.core.first(seq9886__$1);
  var seq9886__$2 = cljs.core.next(seq9886__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__9887, G__9888, seq9886__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            return goog.array.defaultCompare(x, y);
          } else {
            throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
          }
        } else {
          if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 2048 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$ ? true : !x.cljs$lang$protocol_mask$partition1$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x)) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              return goog.array.defaultCompare(x, y);
            } else {
              throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed(var_args) {
  var args9899 = [];
  var len__8278__auto___9902 = arguments.length;
  var i__8279__auto___9903 = 0;
  while (true) {
    if (i__8279__auto___9903 < len__8278__auto___9902) {
      args9899.push(arguments[i__8279__auto___9903]);
      var G__9904 = i__8279__auto___9903 + 1;
      i__8279__auto___9903 = G__9904;
      continue;
    } else {
    }
    break;
  }
  var G__9901 = args9899.length;
  switch(G__9901) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9899.length)].join(""));;
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__9906 = xs;
      var G__9907 = ys;
      var G__9908 = len;
      var G__9909 = n + 1;
      xs = G__9906;
      ys = G__9907;
      len = G__9908;
      n = G__9909;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y, x) : f.call(null, y, x))) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort(var_args) {
  var args9910 = [];
  var len__8278__auto___9915 = arguments.length;
  var i__8279__auto___9916 = 0;
  while (true) {
    if (i__8279__auto___9916 < len__8278__auto___9915) {
      args9910.push(arguments[i__8279__auto___9916]);
      var G__9917 = i__8279__auto___9916 + 1;
      i__8279__auto___9916 = G__9917;
      continue;
    } else {
    }
    break;
  }
  var G__9912 = args9910.length;
  switch(G__9912) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9910.length)].join(""));;
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
    var G__9913_9919 = a;
    var G__9914_9920 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__9913_9919, G__9914_9920);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by(var_args) {
  var args9921 = [];
  var len__8278__auto___9924 = arguments.length;
  var i__8279__auto___9925 = 0;
  while (true) {
    if (i__8279__auto___9925 < len__8278__auto___9924) {
      args9921.push(arguments[i__8279__auto___9925]);
      var G__9926 = i__8279__auto___9925 + 1;
      i__8279__auto___9925 = G__9926;
      continue;
    } else {
    }
    break;
  }
  var G__9923 = args9921.length;
  switch(G__9923) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9921.length)].join(""));;
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null, x), keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null, y));
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce(var_args) {
  var args9928 = [];
  var len__8278__auto___9936 = arguments.length;
  var i__8279__auto___9937 = 0;
  while (true) {
    if (i__8279__auto___9937 < len__8278__auto___9936) {
      args9928.push(arguments[i__8279__auto___9937]);
      var G__9938 = i__8279__auto___9937 + 1;
      i__8279__auto___9937 = G__9938;
      continue;
    } else {
    }
    break;
  }
  var G__9930 = args9928.length;
  switch(G__9930) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9928.length)].join(""));;
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__6751__auto__ = cljs.core.seq(coll);
  if (temp__6751__auto__) {
    var s = temp__6751__auto__;
    var G__9931 = f;
    var G__9932 = cljs.core.first(s);
    var G__9933 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__9931, G__9932, G__9933) : cljs.core.reduce.call(null, G__9931, G__9932, G__9933);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__9934 = val__$1;
        var G__9935 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9934, G__9935) : f.call(null, G__9934, G__9935);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__9940 = nval;
        var G__9941 = cljs.core.next(coll__$1);
        val__$1 = G__9940;
        coll__$1 = G__9941;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
  goog.array.shuffle(a);
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null, a);
};
cljs.core.reduce = function cljs$core$reduce(var_args) {
  var args9942 = [];
  var len__8278__auto___9947 = arguments.length;
  var i__8279__auto___9948 = 0;
  while (true) {
    if (i__8279__auto___9948 < len__8278__auto___9947) {
      args9942.push(arguments[i__8279__auto___9948]);
      var G__9949 = i__8279__auto___9948 + 1;
      i__8279__auto___9948 = G__9949;
      continue;
    } else {
    }
    break;
  }
  var G__9944 = args9942.length;
  switch(G__9944) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9942.length)].join(""));;
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing(var_args) {
  var args9951 = [];
  var len__8278__auto___9954 = arguments.length;
  var i__8279__auto___9955 = 0;
  while (true) {
    if (i__8279__auto___9955 < len__8278__auto___9954) {
      args9951.push(arguments[i__8279__auto___9955]);
      var G__9956 = i__8279__auto___9955 + 1;
      i__8279__auto___9955 = G__9956;
      continue;
    } else {
    }
    break;
  }
  var G__9953 = args9951.length;
  switch(G__9953) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9951.length)].join(""));;
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__9958 = null;
    var G__9958__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__9958__1 = function(x) {
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null, x);
    };
    var G__9958__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
    };
    G__9958 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__9958__0.call(this);
        case 1:
          return G__9958__1.call(this, x);
        case 2:
          return G__9958__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__9958.cljs$core$IFn$_invoke$arity$0 = G__9958__0;
    G__9958.cljs$core$IFn$_invoke$arity$1 = G__9958__1;
    G__9958.cljs$core$IFn$_invoke$arity$2 = G__9958__2;
    return G__9958;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce(var_args) {
  var args9959 = [];
  var len__8278__auto___9962 = arguments.length;
  var i__8279__auto___9963 = 0;
  while (true) {
    if (i__8279__auto___9963 < len__8278__auto___9962) {
      args9959.push(arguments[i__8279__auto___9963]);
      var G__9964 = i__8279__auto___9963 + 1;
      i__8279__auto___9963 = G__9964;
      continue;
    } else {
    }
    break;
  }
  var G__9961 = args9959.length;
  switch(G__9961) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args9959.length)].join(""));;
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f);
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null, ret);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_(var_args) {
  var args9966 = [];
  var len__8278__auto___9972 = arguments.length;
  var i__8279__auto___9973 = 0;
  while (true) {
    if (i__8279__auto___9973 < len__8278__auto___9972) {
      args9966.push(arguments[i__8279__auto___9973]);
      var G__9974 = i__8279__auto___9973 + 1;
      i__8279__auto___9973 = G__9974;
      continue;
    } else {
    }
    break;
  }
  var G__9971 = args9966.length;
  switch(G__9971) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9966.slice(2), 0, null);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq9967) {
  var G__9968 = cljs.core.first(seq9967);
  var seq9967__$1 = cljs.core.next(seq9967);
  var G__9969 = cljs.core.first(seq9967__$1);
  var seq9967__$2 = cljs.core.next(seq9967__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__9968, G__9969, seq9967__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_(var_args) {
  var args9976 = [];
  var len__8278__auto___9982 = arguments.length;
  var i__8279__auto___9983 = 0;
  while (true) {
    if (i__8279__auto___9983 < len__8278__auto___9982) {
      args9976.push(arguments[i__8279__auto___9983]);
      var G__9984 = i__8279__auto___9983 + 1;
      i__8279__auto___9983 = G__9984;
      continue;
    } else {
    }
    break;
  }
  var G__9981 = args9976.length;
  switch(G__9981) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9976.slice(2), 0, null);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq9977) {
  var G__9978 = cljs.core.first(seq9977);
  var seq9977__$1 = cljs.core.next(seq9977);
  var G__9979 = cljs.core.first(seq9977__$1);
  var seq9977__$2 = cljs.core.next(seq9977__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__9978, G__9979, seq9977__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_(var_args) {
  var args9986 = [];
  var len__8278__auto___9992 = arguments.length;
  var i__8279__auto___9993 = 0;
  while (true) {
    if (i__8279__auto___9993 < len__8278__auto___9992) {
      args9986.push(arguments[i__8279__auto___9993]);
      var G__9994 = i__8279__auto___9993 + 1;
      i__8279__auto___9993 = G__9994;
      continue;
    } else {
    }
    break;
  }
  var G__9991 = args9986.length;
  switch(G__9991) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9986.slice(2), 0, null);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq9987) {
  var G__9988 = cljs.core.first(seq9987);
  var seq9987__$1 = cljs.core.next(seq9987);
  var G__9989 = cljs.core.first(seq9987__$1);
  var seq9987__$2 = cljs.core.next(seq9987__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__9988, G__9989, seq9987__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_(var_args) {
  var args9996 = [];
  var len__8278__auto___10002 = arguments.length;
  var i__8279__auto___10003 = 0;
  while (true) {
    if (i__8279__auto___10003 < len__8278__auto___10002) {
      args9996.push(arguments[i__8279__auto___10003]);
      var G__10004 = i__8279__auto___10003 + 1;
      i__8279__auto___10003 = G__10004;
      continue;
    } else {
    }
    break;
  }
  var G__10001 = args9996.length;
  switch(G__10001) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args9996.slice(2), 0, null);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq9997) {
  var G__9998 = cljs.core.first(seq9997);
  var seq9997__$1 = cljs.core.next(seq9997);
  var G__9999 = cljs.core.first(seq9997__$1);
  var seq9997__$2 = cljs.core.next(seq9997__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__9998, G__9999, seq9997__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_(var_args) {
  var args10006 = [];
  var len__8278__auto___10012 = arguments.length;
  var i__8279__auto___10013 = 0;
  while (true) {
    if (i__8279__auto___10013 < len__8278__auto___10012) {
      args10006.push(arguments[i__8279__auto___10013]);
      var G__10014 = i__8279__auto___10013 + 1;
      i__8279__auto___10013 = G__10014;
      continue;
    } else {
    }
    break;
  }
  var G__10011 = args10006.length;
  switch(G__10011) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10006.slice(2), 0, null);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__10016 = y;
        var G__10017 = cljs.core.first(more);
        var G__10018 = cljs.core.next(more);
        x = G__10016;
        y = G__10017;
        more = G__10018;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq10007) {
  var G__10008 = cljs.core.first(seq10007);
  var seq10007__$1 = cljs.core.next(seq10007);
  var G__10009 = cljs.core.first(seq10007__$1);
  var seq10007__$2 = cljs.core.next(seq10007__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__10008, G__10009, seq10007__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_(var_args) {
  var args10019 = [];
  var len__8278__auto___10025 = arguments.length;
  var i__8279__auto___10026 = 0;
  while (true) {
    if (i__8279__auto___10026 < len__8278__auto___10025) {
      args10019.push(arguments[i__8279__auto___10026]);
      var G__10027 = i__8279__auto___10026 + 1;
      i__8279__auto___10026 = G__10027;
      continue;
    } else {
    }
    break;
  }
  var G__10024 = args10019.length;
  switch(G__10024) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10019.slice(2), 0, null);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__10029 = y;
        var G__10030 = cljs.core.first(more);
        var G__10031 = cljs.core.next(more);
        x = G__10029;
        y = G__10030;
        more = G__10031;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq10020) {
  var G__10021 = cljs.core.first(seq10020);
  var seq10020__$1 = cljs.core.next(seq10020);
  var G__10022 = cljs.core.first(seq10020__$1);
  var seq10020__$2 = cljs.core.next(seq10020__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10021, G__10022, seq10020__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_(var_args) {
  var args10032 = [];
  var len__8278__auto___10038 = arguments.length;
  var i__8279__auto___10039 = 0;
  while (true) {
    if (i__8279__auto___10039 < len__8278__auto___10038) {
      args10032.push(arguments[i__8279__auto___10039]);
      var G__10040 = i__8279__auto___10039 + 1;
      i__8279__auto___10039 = G__10040;
      continue;
    } else {
    }
    break;
  }
  var G__10037 = args10032.length;
  switch(G__10037) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10032.slice(2), 0, null);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__10042 = y;
        var G__10043 = cljs.core.first(more);
        var G__10044 = cljs.core.next(more);
        x = G__10042;
        y = G__10043;
        more = G__10044;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq10033) {
  var G__10034 = cljs.core.first(seq10033);
  var seq10033__$1 = cljs.core.next(seq10033);
  var G__10035 = cljs.core.first(seq10033__$1);
  var seq10033__$2 = cljs.core.next(seq10033__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__10034, G__10035, seq10033__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_(var_args) {
  var args10045 = [];
  var len__8278__auto___10051 = arguments.length;
  var i__8279__auto___10052 = 0;
  while (true) {
    if (i__8279__auto___10052 < len__8278__auto___10051) {
      args10045.push(arguments[i__8279__auto___10052]);
      var G__10053 = i__8279__auto___10052 + 1;
      i__8279__auto___10052 = G__10053;
      continue;
    } else {
    }
    break;
  }
  var G__10050 = args10045.length;
  switch(G__10050) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10045.slice(2), 0, null);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__10055 = y;
        var G__10056 = cljs.core.first(more);
        var G__10057 = cljs.core.next(more);
        x = G__10055;
        y = G__10056;
        more = G__10057;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq10046) {
  var G__10047 = cljs.core.first(seq10046);
  var seq10046__$1 = cljs.core.next(seq10046);
  var G__10048 = cljs.core.first(seq10046__$1);
  var seq10046__$2 = cljs.core.next(seq10046__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10047, G__10048, seq10046__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max(var_args) {
  var args10058 = [];
  var len__8278__auto___10064 = arguments.length;
  var i__8279__auto___10065 = 0;
  while (true) {
    if (i__8279__auto___10065 < len__8278__auto___10064) {
      args10058.push(arguments[i__8279__auto___10065]);
      var G__10066 = i__8279__auto___10065 + 1;
      i__8279__auto___10065 = G__10066;
      continue;
    } else {
    }
    break;
  }
  var G__10063 = args10058.length;
  switch(G__10063) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10058.slice(2), 0, null);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__7395__auto__ = x;
  var y__7396__auto__ = y;
  return x__7395__auto__ > y__7396__auto__ ? x__7395__auto__ : y__7396__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__7395__auto__ = x;
    var y__7396__auto__ = y;
    return x__7395__auto__ > y__7396__auto__ ? x__7395__auto__ : y__7396__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq10059) {
  var G__10060 = cljs.core.first(seq10059);
  var seq10059__$1 = cljs.core.next(seq10059);
  var G__10061 = cljs.core.first(seq10059__$1);
  var seq10059__$2 = cljs.core.next(seq10059__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__10060, G__10061, seq10059__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min(var_args) {
  var args10068 = [];
  var len__8278__auto___10074 = arguments.length;
  var i__8279__auto___10075 = 0;
  while (true) {
    if (i__8279__auto___10075 < len__8278__auto___10074) {
      args10068.push(arguments[i__8279__auto___10075]);
      var G__10076 = i__8279__auto___10075 + 1;
      i__8279__auto___10075 = G__10076;
      continue;
    } else {
    }
    break;
  }
  var G__10073 = args10068.length;
  switch(G__10073) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10068.slice(2), 0, null);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__7402__auto__ = x;
  var y__7403__auto__ = y;
  return x__7402__auto__ < y__7403__auto__ ? x__7402__auto__ : y__7403__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__7402__auto__ = x;
    var y__7403__auto__ = y;
    return x__7402__auto__ < y__7403__auto__ ? x__7402__auto__ : y__7403__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq10069) {
  var G__10070 = cljs.core.first(seq10069);
  var seq10069__$1 = cljs.core.next(seq10069);
  var G__10071 = cljs.core.first(seq10069__$1);
  var seq10069__$2 = cljs.core.next(seq10069__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__10070, G__10071, seq10069__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add(var_args) {
  var args10078 = [];
  var len__8278__auto___10084 = arguments.length;
  var i__8279__auto___10085 = 0;
  while (true) {
    if (i__8279__auto___10085 < len__8278__auto___10084) {
      args10078.push(arguments[i__8279__auto___10085]);
      var G__10086 = i__8279__auto___10085 + 1;
      i__8279__auto___10085 = G__10086;
      continue;
    } else {
    }
    break;
  }
  var G__10083 = args10078.length;
  switch(G__10083) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10078.slice(2), 0, null);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq10079) {
  var G__10080 = cljs.core.first(seq10079);
  var seq10079__$1 = cljs.core.next(seq10079);
  var G__10081 = cljs.core.first(seq10079__$1);
  var seq10079__$2 = cljs.core.next(seq10079__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__10080, G__10081, seq10079__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int(var_args) {
  var args10088 = [];
  var len__8278__auto___10094 = arguments.length;
  var i__8279__auto___10095 = 0;
  while (true) {
    if (i__8279__auto___10095 < len__8278__auto___10094) {
      args10088.push(arguments[i__8279__auto___10095]);
      var G__10096 = i__8279__auto___10095 + 1;
      i__8279__auto___10095 = G__10096;
      continue;
    } else {
    }
    break;
  }
  var G__10093 = args10088.length;
  switch(G__10093) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10088.slice(2), 0, null);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq10089) {
  var G__10090 = cljs.core.first(seq10089);
  var seq10089__$1 = cljs.core.next(seq10089);
  var G__10091 = cljs.core.first(seq10089__$1);
  var seq10089__$2 = cljs.core.next(seq10089__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__10090, G__10091, seq10089__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int(var_args) {
  var args10098 = [];
  var len__8278__auto___10104 = arguments.length;
  var i__8279__auto___10105 = 0;
  while (true) {
    if (i__8279__auto___10105 < len__8278__auto___10104) {
      args10098.push(arguments[i__8279__auto___10105]);
      var G__10106 = i__8279__auto___10105 + 1;
      i__8279__auto___10105 = G__10106;
      continue;
    } else {
    }
    break;
  }
  var G__10103 = args10098.length;
  switch(G__10103) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10098.slice(2), 0, null);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq10099) {
  var G__10100 = cljs.core.first(seq10099);
  var seq10099__$1 = cljs.core.next(seq10099);
  var G__10101 = cljs.core.first(seq10099__$1);
  var seq10099__$2 = cljs.core.next(seq10099__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__10100, G__10101, seq10099__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply(var_args) {
  var args10108 = [];
  var len__8278__auto___10114 = arguments.length;
  var i__8279__auto___10115 = 0;
  while (true) {
    if (i__8279__auto___10115 < len__8278__auto___10114) {
      args10108.push(arguments[i__8279__auto___10115]);
      var G__10116 = i__8279__auto___10115 + 1;
      i__8279__auto___10115 = G__10116;
      continue;
    } else {
    }
    break;
  }
  var G__10113 = args10108.length;
  switch(G__10113) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10108.slice(2), 0, null);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq10109) {
  var G__10110 = cljs.core.first(seq10109);
  var seq10109__$1 = cljs.core.next(seq10109);
  var G__10111 = cljs.core.first(seq10109__$1);
  var seq10109__$2 = cljs.core.next(seq10109__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__10110, G__10111, seq10109__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int(var_args) {
  var args10118 = [];
  var len__8278__auto___10124 = arguments.length;
  var i__8279__auto___10125 = 0;
  while (true) {
    if (i__8279__auto___10125 < len__8278__auto___10124) {
      args10118.push(arguments[i__8279__auto___10125]);
      var G__10126 = i__8279__auto___10125 + 1;
      i__8279__auto___10125 = G__10126;
      continue;
    } else {
    }
    break;
  }
  var G__10123 = args10118.length;
  switch(G__10123) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10118.slice(2), 0, null);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq10119) {
  var G__10120 = cljs.core.first(seq10119);
  var seq10119__$1 = cljs.core.next(seq10119);
  var G__10121 = cljs.core.first(seq10119__$1);
  var seq10119__$2 = cljs.core.next(seq10119__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__10120, G__10121, seq10119__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x, n) : cljs.core.mod.call(null, x, n);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract(var_args) {
  var args10128 = [];
  var len__8278__auto___10134 = arguments.length;
  var i__8279__auto___10135 = 0;
  while (true) {
    if (i__8279__auto___10135 < len__8278__auto___10134) {
      args10128.push(arguments[i__8279__auto___10135]);
      var G__10136 = i__8279__auto___10135 + 1;
      i__8279__auto___10135 = G__10136;
      continue;
    } else {
    }
    break;
  }
  var G__10133 = args10128.length;
  switch(G__10133) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10128.slice(2), 0, null);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq10129) {
  var G__10130 = cljs.core.first(seq10129);
  var seq10129__$1 = cljs.core.next(seq10129);
  var G__10131 = cljs.core.first(seq10129__$1);
  var seq10129__$2 = cljs.core.next(seq10129__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__10130, G__10131, seq10129__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int(var_args) {
  var args10138 = [];
  var len__8278__auto___10144 = arguments.length;
  var i__8279__auto___10145 = 0;
  while (true) {
    if (i__8279__auto___10145 < len__8278__auto___10144) {
      args10138.push(arguments[i__8279__auto___10145]);
      var G__10146 = i__8279__auto___10145 + 1;
      i__8279__auto___10145 = G__10146;
      continue;
    } else {
    }
    break;
  }
  var G__10143 = args10138.length;
  switch(G__10143) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10138.slice(2), 0, null);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq10139) {
  var G__10140 = cljs.core.first(seq10139);
  var seq10139__$1 = cljs.core.next(seq10139);
  var G__10141 = cljs.core.first(seq10139__$1);
  var seq10139__$2 = cljs.core.next(seq10139__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__10140, G__10141, seq10139__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    return Math.floor(q);
  } else {
    return Math.ceil(q);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor(var_args) {
  var args10148 = [];
  var len__8278__auto___10154 = arguments.length;
  var i__8279__auto___10155 = 0;
  while (true) {
    if (i__8279__auto___10155 < len__8278__auto___10154) {
      args10148.push(arguments[i__8279__auto___10155]);
      var G__10156 = i__8279__auto___10155 + 1;
      i__8279__auto___10155 = G__10156;
      continue;
    } else {
    }
    break;
  }
  var G__10153 = args10148.length;
  switch(G__10153) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10148.slice(2), 0, null);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq10149) {
  var G__10150 = cljs.core.first(seq10149);
  var seq10149__$1 = cljs.core.next(seq10149);
  var G__10151 = cljs.core.first(seq10149__$1);
  var seq10149__$2 = cljs.core.next(seq10149__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__10150, G__10151, seq10149__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and(var_args) {
  var args10158 = [];
  var len__8278__auto___10164 = arguments.length;
  var i__8279__auto___10165 = 0;
  while (true) {
    if (i__8279__auto___10165 < len__8278__auto___10164) {
      args10158.push(arguments[i__8279__auto___10165]);
      var G__10166 = i__8279__auto___10165 + 1;
      i__8279__auto___10165 = G__10166;
      continue;
    } else {
    }
    break;
  }
  var G__10163 = args10158.length;
  switch(G__10163) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10158.slice(2), 0, null);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq10159) {
  var G__10160 = cljs.core.first(seq10159);
  var seq10159__$1 = cljs.core.next(seq10159);
  var G__10161 = cljs.core.first(seq10159__$1);
  var seq10159__$2 = cljs.core.next(seq10159__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__10160, G__10161, seq10159__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or(var_args) {
  var args10168 = [];
  var len__8278__auto___10174 = arguments.length;
  var i__8279__auto___10175 = 0;
  while (true) {
    if (i__8279__auto___10175 < len__8278__auto___10174) {
      args10168.push(arguments[i__8279__auto___10175]);
      var G__10176 = i__8279__auto___10175 + 1;
      i__8279__auto___10175 = G__10176;
      continue;
    } else {
    }
    break;
  }
  var G__10173 = args10168.length;
  switch(G__10173) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10168.slice(2), 0, null);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq10169) {
  var G__10170 = cljs.core.first(seq10169);
  var seq10169__$1 = cljs.core.next(seq10169);
  var G__10171 = cljs.core.first(seq10169__$1);
  var seq10169__$2 = cljs.core.next(seq10169__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__10170, G__10171, seq10169__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not(var_args) {
  var args10178 = [];
  var len__8278__auto___10184 = arguments.length;
  var i__8279__auto___10185 = 0;
  while (true) {
    if (i__8279__auto___10185 < len__8278__auto___10184) {
      args10178.push(arguments[i__8279__auto___10185]);
      var G__10186 = i__8279__auto___10185 + 1;
      i__8279__auto___10185 = G__10186;
      continue;
    } else {
    }
    break;
  }
  var G__10183 = args10178.length;
  switch(G__10183) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10178.slice(2), 0, null);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq10179) {
  var G__10180 = cljs.core.first(seq10179);
  var seq10179__$1 = cljs.core.next(seq10179);
  var G__10181 = cljs.core.first(seq10179__$1);
  var seq10179__$2 = cljs.core.next(seq10179__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__10180, G__10181, seq10179__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_(var_args) {
  var args10188 = [];
  var len__8278__auto___10194 = arguments.length;
  var i__8279__auto___10195 = 0;
  while (true) {
    if (i__8279__auto___10195 < len__8278__auto___10194) {
      args10188.push(arguments[i__8279__auto___10195]);
      var G__10196 = i__8279__auto___10195 + 1;
      i__8279__auto___10195 = G__10196;
      continue;
    } else {
    }
    break;
  }
  var G__10193 = args10188.length;
  switch(G__10193) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10188.slice(2), 0, null);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__10198 = y;
        var G__10199 = cljs.core.first(more);
        var G__10200 = cljs.core.next(more);
        x = G__10198;
        y = G__10199;
        more = G__10200;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq10189) {
  var G__10190 = cljs.core.first(seq10189);
  var seq10189__$1 = cljs.core.next(seq10189);
  var G__10191 = cljs.core.first(seq10189__$1);
  var seq10189__$2 = cljs.core.next(seq10189__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10190, G__10191, seq10189__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(x) {
  return x > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(x) {
  return x === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__10201 = n__$1 - 1;
      var G__10202 = cljs.core.next(xs);
      n__$1 = G__10201;
      xs = G__10202;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str(var_args) {
  var args10203 = [];
  var len__8278__auto___10208 = arguments.length;
  var i__8279__auto___10209 = 0;
  while (true) {
    if (i__8279__auto___10209 < len__8278__auto___10208) {
      args10203.push(arguments[i__8279__auto___10209]);
      var G__10210 = i__8279__auto___10209 + 1;
      i__8279__auto___10209 = G__10210;
      continue;
    } else {
    }
    break;
  }
  var G__10207 = args10203.length;
  switch(G__10207) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10203.slice(1), 0, null);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__8301__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    return [x].join("");
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__10212 = sb.append([cljs.core.str(cljs.core.first(more))].join(""));
      var G__10213 = cljs.core.next(more);
      sb = G__10212;
      more = G__10213;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq10204) {
  var G__10205 = cljs.core.first(seq10204);
  var seq10204__$1 = cljs.core.next(seq10204);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__10205, seq10204__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs(var_args) {
  var args10214 = [];
  var len__8278__auto___10217 = arguments.length;
  var i__8279__auto___10218 = 0;
  while (true) {
    if (i__8279__auto___10218 < len__8278__auto___10217) {
      args10214.push(arguments[i__8279__auto___10218]);
      var G__10219 = i__8279__auto___10218 + 1;
      i__8279__auto___10218 = G__10219;
      continue;
    } else {
    }
    break;
  }
  var G__10216 = args10214.length;
  switch(G__10216) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10214.length)].join(""));;
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__10221 = cljs.core.next(xs);
            var G__10222 = cljs.core.next(ys);
            xs = G__10221;
            ys = G__10222;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__10223 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__10224 = cljs.core.next(s);
        res = G__10223;
        s = G__10224;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__10225 = (h + (cljs.core.hash(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e)) ^ cljs.core.hash(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e)))) % 4503599627370496;
      var G__10226 = cljs.core.next(s);
      h = G__10225;
      s = G__10226;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__10227 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__10228 = cljs.core.next(s__$1);
      h = G__10227;
      s__$1 = G__10228;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__10239_10249 = cljs.core.seq(fn_map);
  var chunk__10240_10250 = null;
  var count__10241_10251 = 0;
  var i__10242_10252 = 0;
  while (true) {
    if (i__10242_10252 < count__10241_10251) {
      var vec__10243_10253 = chunk__10240_10250.cljs$core$IIndexed$_nth$arity$2(null, i__10242_10252);
      var key_name_10254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10243_10253, 0, null);
      var f_10255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10243_10253, 1, null);
      var str_name_10256 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_10254) : cljs.core.name.call(null, key_name_10254);
      obj[str_name_10256] = f_10255;
      var G__10257 = seq__10239_10249;
      var G__10258 = chunk__10240_10250;
      var G__10259 = count__10241_10251;
      var G__10260 = i__10242_10252 + 1;
      seq__10239_10249 = G__10257;
      chunk__10240_10250 = G__10258;
      count__10241_10251 = G__10259;
      i__10242_10252 = G__10260;
      continue;
    } else {
      var temp__6753__auto___10261 = cljs.core.seq(seq__10239_10249);
      if (temp__6753__auto___10261) {
        var seq__10239_10262__$1 = temp__6753__auto___10261;
        if (cljs.core.chunked_seq_QMARK_(seq__10239_10262__$1)) {
          var c__7968__auto___10263 = cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__10239_10262__$1) : cljs.core.chunk_first.call(null, seq__10239_10262__$1);
          var G__10264 = cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__10239_10262__$1) : cljs.core.chunk_rest.call(null, seq__10239_10262__$1);
          var G__10265 = c__7968__auto___10263;
          var G__10266 = cljs.core.count(c__7968__auto___10263);
          var G__10267 = 0;
          seq__10239_10249 = G__10264;
          chunk__10240_10250 = G__10265;
          count__10241_10251 = G__10266;
          i__10242_10252 = G__10267;
          continue;
        } else {
          var vec__10246_10268 = cljs.core.first(seq__10239_10262__$1);
          var key_name_10269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10246_10268, 0, null);
          var f_10270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10246_10268, 1, null);
          var str_name_10271 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_10269) : cljs.core.name.call(null, key_name_10269);
          obj[str_name_10271] = f_10270;
          var G__10272 = cljs.core.next(seq__10239_10262__$1);
          var G__10273 = null;
          var G__10274 = 0;
          var G__10275 = 0;
          seq__10239_10249 = G__10272;
          chunk__10240_10250 = G__10273;
          count__10241_10251 = G__10274;
          i__10242_10252 = G__10275;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.indexOf = function() {
  var G__10276 = null;
  var G__10276__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10276__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10276 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10276__1.call(this, x);
      case 2:
        return G__10276__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10276.cljs$core$IFn$_invoke$arity$1 = G__10276__1;
  G__10276.cljs$core$IFn$_invoke$arity$2 = G__10276__2;
  return G__10276;
}();
cljs.core.List.prototype.lastIndexOf = function() {
  var G__10277 = null;
  var G__10277__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count);
  };
  var G__10277__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10277 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10277__1.call(this, x);
      case 2:
        return G__10277__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10277.cljs$core$IFn$_invoke$arity$1 = G__10277__1;
  G__10277.cljs$core$IFn$_invoke$arity$2 = G__10277__2;
  return G__10277;
}();
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._rest(coll__$1);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 33554432 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
  }
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.indexOf = function() {
  var G__10280 = null;
  var G__10280__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10280__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10280 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10280__1.call(this, x);
      case 2:
        return G__10280__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10280.cljs$core$IFn$_invoke$arity$1 = G__10280__1;
  G__10280.cljs$core$IFn$_invoke$arity$2 = G__10280__2;
  return G__10280;
}();
cljs.core.EmptyList.prototype.lastIndexOf = function() {
  var G__10281 = null;
  var G__10281__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10281__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10281 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10281__1.call(this, x);
      case 2:
        return G__10281__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10281.cljs$core$IFn$_invoke$arity$1 = G__10281__1;
  G__10281.cljs$core$IFn$_invoke$arity$2 = G__10281__2;
  return G__10281;
}();
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.list_QMARK_(other) || cljs.core.sequential_QMARK_(other)) {
    return cljs.core.seq(other) == null;
  } else {
    return false;
  }
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  if (!(coll == null)) {
    if (coll.cljs$lang$protocol_mask$partition0$ & 134217728 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$) {
      return true;
    } else {
      if (!coll.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
  }
};
cljs.core.rseq = function cljs$core$rseq(rev) {
  return cljs.core._rseq(rev);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list(var_args) {
  var args__8285__auto__ = [];
  var len__8278__auto___10285 = arguments.length;
  var i__8279__auto___10286 = 0;
  while (true) {
    if (i__8279__auto___10286 < len__8278__auto___10285) {
      args__8285__auto__.push(arguments[i__8279__auto___10286]);
      var G__10287 = i__8279__auto___10286 + 1;
      i__8279__auto___10286 = G__10287;
      continue;
    } else {
    }
    break;
  }
  var argseq__8286__auto__ = 0 < args__8285__auto__.length ? new cljs.core.IndexedSeq(args__8285__auto__.slice(0), 0, null) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__8286__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__10288 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__10288;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__10289 = i - 1;
      var G__10290 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__10289;
      r = G__10290;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq10284) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10284));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.indexOf = function() {
  var G__10291 = null;
  var G__10291__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10291__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10291 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10291__1.call(this, x);
      case 2:
        return G__10291__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10291.cljs$core$IFn$_invoke$arity$1 = G__10291__1;
  G__10291.cljs$core$IFn$_invoke$arity$2 = G__10291__2;
  return G__10291;
}();
cljs.core.Cons.prototype.lastIndexOf = function() {
  var G__10292 = null;
  var G__10292__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10292__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10292 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10292__1.call(this, x);
      case 2:
        return G__10292__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10292.cljs$core$IFn$_invoke$arity$1 = G__10292__1;
  G__10292.cljs$core$IFn$_invoke$arity$2 = G__10292__2;
  return G__10292;
}();
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, null);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__7062__auto__ = coll == null;
    if (or__7062__auto__) {
      return or__7062__auto__;
    } else {
      if (!(coll == null)) {
        if (coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__7050__auto__ = cljs.core.not(a.ns);
      if (and__7050__auto__) {
        return b.ns;
      } else {
        return and__7050__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__10303 = a.ns;
            var G__10304 = b.ns;
            return goog.array.defaultCompare(G__10303, G__10304);
          }();
          if (0 === nsc) {
            var G__10305 = a.name;
            var G__10306 = b.name;
            return goog.array.defaultCompare(G__10305, G__10306);
          } else {
            return nsc;
          }
        }
      } else {
        var G__10307 = a.name;
        var G__10308 = b.name;
        return goog.array.defaultCompare(G__10307, G__10308);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str(":"), cljs.core.str(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__10310 = null;
  var G__10310__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__10310__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__10310 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10310__2.call(this, self__, coll);
      case 3:
        return G__10310__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10310.cljs$core$IFn$_invoke$arity$2 = G__10310__2;
  G__10310.cljs$core$IFn$_invoke$arity$3 = G__10310__3;
  return G__10310;
}();
cljs.core.Keyword.prototype.apply = function(self__, args10309) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args10309)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__7499__auto__ = self__._hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str(":"), cljs.core.str(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.symbol_identical_QMARK_ = function cljs$core$symbol_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Symbol && y instanceof cljs.core.Symbol) {
      return x.str === y.str;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 4096 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$ ? true : false : false) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.ident_QMARK_ = function cljs$core$ident_QMARK_(x) {
  return x instanceof cljs.core.Keyword || x instanceof cljs.core.Symbol;
};
cljs.core.simple_ident_QMARK_ = function cljs$core$simple_ident_QMARK_(x) {
  return cljs.core.ident_QMARK_(x) && cljs.core.namespace(x) == null;
};
cljs.core.qualified_ident_QMARK_ = function cljs$core$qualified_ident_QMARK_(x) {
  var and__7050__auto__ = cljs.core.ident_QMARK_(x);
  if (and__7050__auto__) {
    var and__7050__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__7050__auto____$1)) {
      return true;
    } else {
      return and__7050__auto____$1;
    }
  } else {
    return and__7050__auto__;
  }
};
cljs.core.simple_symbol_QMARK_ = function cljs$core$simple_symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol && cljs.core.namespace(x) == null;
};
cljs.core.qualified_symbol_QMARK_ = function cljs$core$qualified_symbol_QMARK_(x) {
  var and__7050__auto__ = x instanceof cljs.core.Symbol;
  if (and__7050__auto__) {
    var and__7050__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__7050__auto____$1)) {
      return true;
    } else {
      return and__7050__auto____$1;
    }
  } else {
    return and__7050__auto__;
  }
};
cljs.core.simple_keyword_QMARK_ = function cljs$core$simple_keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword && cljs.core.namespace(x) == null;
};
cljs.core.qualified_keyword_QMARK_ = function cljs$core$qualified_keyword_QMARK_(x) {
  var and__7050__auto__ = x instanceof cljs.core.Keyword;
  if (and__7050__auto__) {
    var and__7050__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__7050__auto____$1)) {
      return true;
    } else {
      return and__7050__auto____$1;
    }
  } else {
    return and__7050__auto__;
  }
};
cljs.core.keyword = function cljs$core$keyword(var_args) {
  var args10313 = [];
  var len__8278__auto___10316 = arguments.length;
  var i__8279__auto___10317 = 0;
  while (true) {
    if (i__8279__auto___10317 < len__8278__auto___10316) {
      args10313.push(arguments[i__8279__auto___10317]);
      var G__10318 = i__8279__auto___10317 + 1;
      i__8279__auto___10317 = G__10318;
      continue;
    } else {
    }
    break;
  }
  var G__10315 = args10313.length;
  switch(G__10315) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10313.length)].join(""));;
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var ns__$1 = ns instanceof cljs.core.Keyword ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null, ns) : ns instanceof cljs.core.Symbol ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null, ns) : ns;
  var name__$1 = name instanceof cljs.core.Keyword ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name) : name instanceof cljs.core.Symbol ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name) : name;
  return new cljs.core.Keyword(ns__$1, name__$1, [cljs.core.str(cljs.core.truth_(ns__$1) ? [cljs.core.str(ns__$1), cljs.core.str("/")].join("") : null), cljs.core.str(name__$1)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.indexOf = function() {
  var G__10320 = null;
  var G__10320__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10320__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10320 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10320__1.call(this, x);
      case 2:
        return G__10320__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10320.cljs$core$IFn$_invoke$arity$1 = G__10320__1;
  G__10320.cljs$core$IFn$_invoke$arity$2 = G__10320__2;
  return G__10320;
}();
cljs.core.LazySeq.prototype.lastIndexOf = function() {
  var G__10321 = null;
  var G__10321__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10321__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10321 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10321__1.call(this, x);
      case 2:
        return G__10321__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10321.cljs$core$IFn$_invoke$arity$1 = G__10321__1;
  G__10321.cljs$core$IFn$_invoke$arity$2 = G__10321__2;
  return G__10321;
}();
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.not(self__.fn);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__10322 = ls.sval();
        ls = G__10322;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk(var_args) {
  var args10323 = [];
  var len__8278__auto___10326 = arguments.length;
  var i__8279__auto___10327 = 0;
  while (true) {
    if (i__8279__auto___10327 < len__8278__auto___10326) {
      args10323.push(arguments[i__8279__auto___10327]);
      var G__10328 = i__8279__auto___10327 + 1;
      i__8279__auto___10327 = G__10328;
      continue;
    } else {
    }
    break;
  }
  var G__10325 = args10323.length;
  switch(G__10325) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10323.length)].join(""));;
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.indexOf = function() {
  var G__10330 = null;
  var G__10330__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10330__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10330 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10330__1.call(this, x);
      case 2:
        return G__10330__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10330.cljs$core$IFn$_invoke$arity$1 = G__10330__1;
  G__10330.cljs$core$IFn$_invoke$arity$2 = G__10330__2;
  return G__10330;
}();
cljs.core.ChunkedCons.prototype.lastIndexOf = function() {
  var G__10331 = null;
  var G__10331__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10331__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10331 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10331__1.call(this, x);
      case 2:
        return G__10331__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10331.cljs$core$IFn$_invoke$arity$1 = G__10331__1;
  G__10331.cljs$core$IFn$_invoke$arity$2 = G__10331__2;
  return G__10331;
}();
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (!(s == null) ? s.cljs$lang$protocol_mask$partition1$ & 1024 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$ ? true : false : false) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__10334 = cljs.core.next(s__$1);
      s__$1 = G__10334;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_10335 = 0;
  var xs_10336 = cljs.core.seq(coll);
  while (true) {
    if (xs_10336) {
      ret[i_10335] = cljs.core.to_array(cljs.core.first(xs_10336));
      var G__10337 = i_10335 + 1;
      var G__10338 = cljs.core.next(xs_10336);
      i_10335 = G__10337;
      xs_10336 = G__10338;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array(var_args) {
  var args10339 = [];
  var len__8278__auto___10342 = arguments.length;
  var i__8279__auto___10343 = 0;
  while (true) {
    if (i__8279__auto___10343 < len__8278__auto___10342) {
      args10339.push(arguments[i__8279__auto___10343]);
      var G__10344 = i__8279__auto___10343 + 1;
      i__8279__auto___10343 = G__10344;
      continue;
    } else {
    }
    break;
  }
  var G__10341 = args10339.length;
  switch(G__10341) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10339.length)].join(""));;
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10346 = i + 1;
        var G__10347 = cljs.core.next(s__$1);
        i = G__10346;
        s__$1 = G__10347;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__8078__auto___10348 = size;
    var i_10349 = 0;
    while (true) {
      if (i_10349 < n__8078__auto___10348) {
        a[i_10349] = init_val_or_seq;
        var G__10350 = i_10349 + 1;
        i_10349 = G__10350;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array(var_args) {
  var args10351 = [];
  var len__8278__auto___10354 = arguments.length;
  var i__8279__auto___10355 = 0;
  while (true) {
    if (i__8279__auto___10355 < len__8278__auto___10354) {
      args10351.push(arguments[i__8279__auto___10355]);
      var G__10356 = i__8279__auto___10355 + 1;
      i__8279__auto___10355 = G__10356;
      continue;
    } else {
    }
    break;
  }
  var G__10353 = args10351.length;
  switch(G__10353) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10351.length)].join(""));;
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10358 = i + 1;
        var G__10359 = cljs.core.next(s__$1);
        i = G__10358;
        s__$1 = G__10359;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__8078__auto___10360 = size;
    var i_10361 = 0;
    while (true) {
      if (i_10361 < n__8078__auto___10360) {
        a[i_10361] = init_val_or_seq;
        var G__10362 = i_10361 + 1;
        i_10361 = G__10362;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array(var_args) {
  var args10363 = [];
  var len__8278__auto___10366 = arguments.length;
  var i__8279__auto___10367 = 0;
  while (true) {
    if (i__8279__auto___10367 < len__8278__auto___10366) {
      args10363.push(arguments[i__8279__auto___10367]);
      var G__10368 = i__8279__auto___10367 + 1;
      i__8279__auto___10367 = G__10368;
      continue;
    } else {
    }
    break;
  }
  var G__10365 = args10363.length;
  switch(G__10365) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10363.length)].join(""));;
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10370 = i + 1;
        var G__10371 = cljs.core.next(s__$1);
        i = G__10370;
        s__$1 = G__10371;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__8078__auto___10372 = size;
    var i_10373 = 0;
    while (true) {
      if (i_10373 < n__8078__auto___10372) {
        a[i_10373] = init_val_or_seq;
        var G__10374 = i_10373 + 1;
        i_10373 = G__10374;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array(var_args) {
  var args10375 = [];
  var len__8278__auto___10378 = arguments.length;
  var i__8279__auto___10379 = 0;
  while (true) {
    if (i__8279__auto___10379 < len__8278__auto___10378) {
      args10375.push(arguments[i__8279__auto___10379]);
      var G__10380 = i__8279__auto___10379 + 1;
      i__8279__auto___10379 = G__10380;
      continue;
    } else {
    }
    break;
  }
  var G__10377 = args10375.length;
  switch(G__10377) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10375.length)].join(""));;
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__10382 = i + 1;
        var G__10383 = cljs.core.next(s__$1);
        i = G__10382;
        s__$1 = G__10383;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__8078__auto___10384 = size;
    var i_10385 = 0;
    while (true) {
      if (i_10385 < n__8078__auto___10384) {
        a[i_10385] = init_val_or_seq;
        var G__10386 = i_10385 + 1;
        i_10385 = G__10386;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(n, coll) {
  if (cljs.core.counted_QMARK_(coll)) {
    return cljs.core.count(coll);
  } else {
    var i = 0;
    var s = cljs.core.seq(coll);
    while (true) {
      if (!(s == null) && i < n) {
        var G__10387 = i + 1;
        var G__10388 = cljs.core.next(s);
        i = G__10387;
        s = G__10388;
        continue;
      } else {
        return i;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), function() {
        var G__10390 = cljs.core.next(arglist);
        return cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(G__10390) : cljs.core.spread.call(null, G__10390);
      }());
    }
  }
};
cljs.core.concat = function cljs$core$concat(var_args) {
  var args10391 = [];
  var len__8278__auto___10403 = arguments.length;
  var i__8279__auto___10404 = 0;
  while (true) {
    if (i__8279__auto___10404 < len__8278__auto___10403) {
      args10391.push(arguments[i__8279__auto___10404]);
      var G__10405 = i__8279__auto___10404 + 1;
      i__8279__auto___10404 = G__10405;
      continue;
    } else {
    }
    break;
  }
  var G__10396 = args10391.length;
  switch(G__10396) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10391.slice(2), 0, null);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq10392) {
  var G__10393 = cljs.core.first(seq10392);
  var seq10392__$1 = cljs.core.next(seq10392);
  var G__10394 = cljs.core.first(seq10392__$1);
  var seq10392__$2 = cljs.core.next(seq10392__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__10393, G__10394, seq10392__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_(var_args) {
  var args10407 = [];
  var len__8278__auto___10415 = arguments.length;
  var i__8279__auto___10416 = 0;
  while (true) {
    if (i__8279__auto___10416 < len__8278__auto___10415) {
      args10407.push(arguments[i__8279__auto___10416]);
      var G__10417 = i__8279__auto___10416 + 1;
      i__8279__auto___10416 = G__10417;
      continue;
    } else {
    }
    break;
  }
  var G__10414 = args10407.length;
  switch(G__10414) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10407.slice(4), 0, null);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__8301__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq10408) {
  var G__10409 = cljs.core.first(seq10408);
  var seq10408__$1 = cljs.core.next(seq10408);
  var G__10410 = cljs.core.first(seq10408__$1);
  var seq10408__$2 = cljs.core.next(seq10408__$1);
  var G__10411 = cljs.core.first(seq10408__$2);
  var seq10408__$3 = cljs.core.next(seq10408__$2);
  var G__10412 = cljs.core.first(seq10408__$3);
  var seq10408__$4 = cljs.core.next(seq10408__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__10409, G__10410, G__10411, G__10412, seq10408__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_(var_args) {
  var args10419 = [];
  var len__8278__auto___10425 = arguments.length;
  var i__8279__auto___10426 = 0;
  while (true) {
    if (i__8279__auto___10426 < len__8278__auto___10425) {
      args10419.push(arguments[i__8279__auto___10426]);
      var G__10427 = i__8279__auto___10426 + 1;
      i__8279__auto___10426 = G__10427;
      continue;
    } else {
    }
    break;
  }
  var G__10424 = args10419.length;
  switch(G__10424) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10419.slice(2), 0, null);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(tcoll) {
  return tcoll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__10429 = ntcoll;
      var G__10430 = cljs.core.first(vals);
      var G__10431 = cljs.core.next(vals);
      tcoll = G__10429;
      val = G__10430;
      vals = G__10431;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq10420) {
  var G__10421 = cljs.core.first(seq10420);
  var seq10420__$1 = cljs.core.next(seq10420);
  var G__10422 = cljs.core.first(seq10420__$1);
  var seq10420__$2 = cljs.core.next(seq10420__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10421, G__10422, seq10420__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_(var_args) {
  var args10432 = [];
  var len__8278__auto___10439 = arguments.length;
  var i__8279__auto___10440 = 0;
  while (true) {
    if (i__8279__auto___10440 < len__8278__auto___10439) {
      args10432.push(arguments[i__8279__auto___10440]);
      var G__10441 = i__8279__auto___10440 + 1;
      i__8279__auto___10440 = G__10441;
      continue;
    } else {
    }
    break;
  }
  var G__10438 = args10432.length;
  switch(G__10438) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10432.slice(3), 0, null);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__8301__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__10443 = ntcoll;
      var G__10444 = cljs.core.first(kvs);
      var G__10445 = cljs.core.second(kvs);
      var G__10446 = cljs.core.nnext(kvs);
      tcoll = G__10443;
      key = G__10444;
      val = G__10445;
      kvs = G__10446;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq10433) {
  var G__10434 = cljs.core.first(seq10433);
  var seq10433__$1 = cljs.core.next(seq10433);
  var G__10435 = cljs.core.first(seq10433__$1);
  var seq10433__$2 = cljs.core.next(seq10433__$1);
  var G__10436 = cljs.core.first(seq10433__$2);
  var seq10433__$3 = cljs.core.next(seq10433__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10434, G__10435, G__10436, seq10433__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_(var_args) {
  var args10447 = [];
  var len__8278__auto___10453 = arguments.length;
  var i__8279__auto___10454 = 0;
  while (true) {
    if (i__8279__auto___10454 < len__8278__auto___10453) {
      args10447.push(arguments[i__8279__auto___10454]);
      var G__10455 = i__8279__auto___10454 + 1;
      i__8279__auto___10454 = G__10455;
      continue;
    } else {
    }
    break;
  }
  var G__10452 = args10447.length;
  switch(G__10452) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10447.slice(2), 0, null);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__10457 = ntcoll;
      var G__10458 = cljs.core.first(ks);
      var G__10459 = cljs.core.next(ks);
      tcoll = G__10457;
      key = G__10458;
      ks = G__10459;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq10448) {
  var G__10449 = cljs.core.first(seq10448);
  var seq10448__$1 = cljs.core.next(seq10448);
  var G__10450 = cljs.core.first(seq10448__$1);
  var seq10448__$2 = cljs.core.next(seq10448__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10449, G__10450, seq10448__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_(var_args) {
  var args10460 = [];
  var len__8278__auto___10466 = arguments.length;
  var i__8279__auto___10467 = 0;
  while (true) {
    if (i__8279__auto___10467 < len__8278__auto___10466) {
      args10460.push(arguments[i__8279__auto___10467]);
      var G__10468 = i__8279__auto___10467 + 1;
      i__8279__auto___10467 = G__10468;
      continue;
    } else {
    }
    break;
  }
  var G__10465 = args10460.length;
  switch(G__10465) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10460.slice(2), 0, null);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__10470 = ntcoll;
      var G__10471 = cljs.core.first(vals);
      var G__10472 = cljs.core.next(vals);
      tcoll = G__10470;
      val = G__10471;
      vals = G__10472;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq10461) {
  var G__10462 = cljs.core.first(seq10461);
  var seq10461__$1 = cljs.core.next(seq10461);
  var G__10463 = cljs.core.first(seq10461__$1);
  var seq10461__$2 = cljs.core.next(seq10461__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10462, G__10463, seq10461__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a8122 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a8122);
      } else {
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a8122) : f.call(null, a8122);
      }
    } else {
      var b8123 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a8122, b8123);
        } else {
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a8122, b8123) : f.call(null, a8122, b8123);
        }
      } else {
        var c8124 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a8122, b8123, c8124);
          } else {
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a8122, b8123, c8124) : f.call(null, a8122, b8123, c8124);
          }
        } else {
          var d8125 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a8122, b8123, c8124, d8125);
            } else {
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a8122, b8123, c8124, d8125) : f.call(null, a8122, b8123, c8124, d8125);
            }
          } else {
            var e8126 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a8122, b8123, c8124, d8125, e8126);
              } else {
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a8122, b8123, c8124, d8125, e8126) : f.call(null, a8122, b8123, c8124, d8125, e8126);
              }
            } else {
              var f8127 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a8122, b8123, c8124, d8125, e8126, f8127);
                } else {
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a8122, b8123, c8124, d8125, e8126, f8127) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127);
                }
              } else {
                var g8128 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a8122, b8123, c8124, d8125, e8126, f8127, g8128);
                  } else {
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a8122, b8123, c8124, d8125, e8126, f8127, g8128) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128);
                  }
                } else {
                  var h8129 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129);
                    } else {
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129);
                    }
                  } else {
                    var i8130 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130);
                      } else {
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130);
                      }
                    } else {
                      var j8131 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131);
                        } else {
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131);
                        }
                      } else {
                        var k8132 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132);
                          } else {
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132);
                          }
                        } else {
                          var l8133 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133);
                            } else {
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133);
                            }
                          } else {
                            var m8134 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134);
                              } else {
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134);
                              }
                            } else {
                              var n8135 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135);
                                } else {
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135);
                                }
                              } else {
                                var o8136 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136);
                                  } else {
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136);
                                  }
                                } else {
                                  var p8137 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137);
                                    } else {
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137);
                                    }
                                  } else {
                                    var q8138 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138);
                                      } else {
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138);
                                      }
                                    } else {
                                      var r8139 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139);
                                        } else {
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139);
                                        }
                                      } else {
                                        var s8140 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139, s8140);
                                          } else {
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139, s8140) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139, s8140);
                                          }
                                        } else {
                                          var t8141 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139, s8140, t8141);
                                            } else {
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139, s8140, t8141) : f.call(null, a8122, b8123, c8124, d8125, e8126, f8127, g8128, h8129, i8130, j8131, k8132, l8133, m8134, n8135, o8136, p8137, q8138, r8139, s8140, t8141);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply(var_args) {
  var args10473 = [];
  var len__8278__auto___10482 = arguments.length;
  var i__8279__auto___10483 = 0;
  while (true) {
    if (i__8279__auto___10483 < len__8278__auto___10482) {
      args10473.push(arguments[i__8279__auto___10483]);
      var G__10484 = i__8279__auto___10483 + 1;
      i__8279__auto___10483 = G__10484;
      continue;
    } else {
    }
    break;
  }
  var G__10481 = args10473.length;
  switch(G__10481) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10473.slice(5), 0, null);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__8301__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, args);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq10474) {
  var G__10475 = cljs.core.first(seq10474);
  var seq10474__$1 = cljs.core.next(seq10474);
  var G__10476 = cljs.core.first(seq10474__$1);
  var seq10474__$2 = cljs.core.next(seq10474__$1);
  var G__10477 = cljs.core.first(seq10474__$2);
  var seq10474__$3 = cljs.core.next(seq10474__$2);
  var G__10478 = cljs.core.first(seq10474__$3);
  var seq10474__$4 = cljs.core.next(seq10474__$3);
  var G__10479 = cljs.core.first(seq10474__$4);
  var seq10474__$5 = cljs.core.next(seq10474__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__10475, G__10476, G__10477, G__10478, G__10479, seq10474__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta(var_args) {
  var args10486 = [];
  var len__8278__auto___10511 = arguments.length;
  var i__8279__auto___10512 = 0;
  while (true) {
    if (i__8279__auto___10512 < len__8278__auto___10511) {
      args10486.push(arguments[i__8279__auto___10512]);
      var G__10513 = i__8279__auto___10512 + 1;
      i__8279__auto___10512 = G__10513;
      continue;
    } else {
    }
    break;
  }
  var G__10495 = args10486.length;
  switch(G__10495) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10486.slice(6), 0, null);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__8301__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__10496 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10496) : f.call(null, G__10496);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__10497 = cljs.core.meta(obj);
    var G__10498 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10497, G__10498) : f.call(null, G__10497, G__10498);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__10499 = cljs.core.meta(obj);
    var G__10500 = a;
    var G__10501 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10499, G__10500, G__10501) : f.call(null, G__10499, G__10500, G__10501);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__10502 = cljs.core.meta(obj);
    var G__10503 = a;
    var G__10504 = b;
    var G__10505 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10502, G__10503, G__10504, G__10505) : f.call(null, G__10502, G__10503, G__10504, G__10505);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__10506 = cljs.core.meta(obj);
    var G__10507 = a;
    var G__10508 = b;
    var G__10509 = c;
    var G__10510 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__10506, G__10507, G__10508, G__10509, G__10510) : f.call(null, G__10506, G__10507, G__10508, G__10509, G__10510);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq10487) {
  var G__10488 = cljs.core.first(seq10487);
  var seq10487__$1 = cljs.core.next(seq10487);
  var G__10489 = cljs.core.first(seq10487__$1);
  var seq10487__$2 = cljs.core.next(seq10487__$1);
  var G__10490 = cljs.core.first(seq10487__$2);
  var seq10487__$3 = cljs.core.next(seq10487__$2);
  var G__10491 = cljs.core.first(seq10487__$3);
  var seq10487__$4 = cljs.core.next(seq10487__$3);
  var G__10492 = cljs.core.first(seq10487__$4);
  var seq10487__$5 = cljs.core.next(seq10487__$4);
  var G__10493 = cljs.core.first(seq10487__$5);
  var seq10487__$6 = cljs.core.next(seq10487__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__10488, G__10489, G__10490, G__10491, G__10492, G__10493, seq10487__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_(var_args) {
  var args10515 = [];
  var len__8278__auto___10521 = arguments.length;
  var i__8279__auto___10522 = 0;
  while (true) {
    if (i__8279__auto___10522 < len__8278__auto___10521) {
      args10515.push(arguments[i__8279__auto___10522]);
      var G__10523 = i__8279__auto___10522 + 1;
      i__8279__auto___10522 = G__10523;
      continue;
    } else {
    }
    break;
  }
  var G__10520 = args10515.length;
  switch(G__10520) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10515.slice(2), 0, null);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq10516) {
  var G__10517 = cljs.core.first(seq10516);
  var seq10516__$1 = cljs.core.next(seq10516);
  var G__10518 = cljs.core.first(seq10516__$1);
  var seq10516__$2 = cljs.core.next(seq10516__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10517, G__10518, seq10516__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t_cljs$core10528 !== "undefined") {
  } else {
    cljs.core.t_cljs$core10528 = function(meta10529) {
      this.meta10529 = meta10529;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t_cljs$core10528.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_10530, meta10529__$1) {
      var self__ = this;
      var _10530__$1 = this;
      return new cljs.core.t_cljs$core10528(meta10529__$1);
    };
    cljs.core.t_cljs$core10528.prototype.cljs$core$IMeta$_meta$arity$1 = function(_10530) {
      var self__ = this;
      var _10530__$1 = this;
      return self__.meta10529;
    };
    cljs.core.t_cljs$core10528.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t_cljs$core10528.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t_cljs$core10528.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t_cljs$core10528.getBasis = function() {
      return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta10529", "meta10529", 176460949, null)], null);
    };
    cljs.core.t_cljs$core10528.cljs$lang$type = true;
    cljs.core.t_cljs$core10528.cljs$lang$ctorStr = "cljs.core/t_cljs$core10528";
    cljs.core.t_cljs$core10528.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
      return cljs.core._write(writer__7715__auto__, "cljs.core/t_cljs$core10528");
    };
    cljs.core.__GT_t_cljs$core10528 = function cljs$core$nil_iter_$___GT_t_cljs$core10528(meta10529) {
      return new cljs.core.t_cljs$core10528(meta10529);
    };
  }
  return new cljs.core.t_cljs$core10528(cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.not(this$.hasNext())) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "_next", "_next", 101877036, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.iterable_QMARK_(coll)) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str("Cannot create iterator from "), cljs.core.str(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__7050__auto__ = !(lt.stepper == null);
      if (and__7050__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__7050__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__10531 = lt;
        var G__10532 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__10531, G__10532) : self__.xform.call(null, G__10531, G__10532);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.Stepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null)], null);
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (cljs.core.not(iter.hasNext())) {
        return false;
      } else {
        var G__10533 = cljs.core.next(iters__$1);
        iters__$1 = G__10533;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__8078__auto___10534 = self__.iters.length;
  var i_10535 = 0;
  while (true) {
    if (i_10535 < n__8078__auto___10534) {
      self__.nexts[i_10535] = self__.iters[i_10535].next();
      var G__10536 = i_10535 + 1;
      i_10535 = G__10536;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__7050__auto__ = !(lt.stepper == null);
      if (and__7050__auto__) {
        return this$.hasNext();
      } else {
        return and__7050__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.MultiStepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iters", "iters", 719353031, null), new cljs.core.Symbol(null, "nexts", "nexts", -1683579407, null)], null);
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper(var_args) {
  var args10537 = [];
  var len__8278__auto___10540 = arguments.length;
  var i__8279__auto___10541 = 0;
  while (true) {
    if (i__8279__auto___10541 < len__8278__auto___10540) {
      args10537.push(arguments[i__8279__auto___10541]);
      var G__10542 = i__8279__auto___10541 + 1;
      i__8279__auto___10541 = G__10542;
      continue;
    } else {
    }
    break;
  }
  var G__10539 = args10537.length;
  switch(G__10539) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10537.length)].join(""));;
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 31850700;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazyTransformer.prototype.indexOf = function() {
  var G__10544 = null;
  var G__10544__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__10544__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10544 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10544__1.call(this, x);
      case 2:
        return G__10544__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10544.cljs$core$IFn$_invoke$arity$1 = G__10544__1;
  G__10544.cljs$core$IFn$_invoke$arity$2 = G__10544__2;
  return G__10544;
}();
cljs.core.LazyTransformer.prototype.lastIndexOf = function() {
  var G__10545 = null;
  var G__10545__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__10545__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__10545 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__10545__1.call(this, x);
      case 2:
        return G__10545__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__10545.cljs$core$IFn$_invoke$arity$1 = G__10545__1;
  G__10545.cljs$core$IFn$_invoke$arity$2 = G__10545__2;
  return G__10545;
}();
cljs.core.LazyTransformer.prototype.cljs$core$IMeta$_meta$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return self__.meta;
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = cljs.core._seq(this$__$1);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, cljs.core._seq(this$__$1));
};
cljs.core.LazyTransformer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "stepper", "stepper", 1159163296, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  cljs.core.with_meta(new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__10546_10550 = cljs.core.seq(colls);
  var chunk__10547_10551 = null;
  var count__10548_10552 = 0;
  var i__10549_10553 = 0;
  while (true) {
    if (i__10549_10553 < count__10548_10552) {
      var coll_10554 = chunk__10547_10551.cljs$core$IIndexed$_nth$arity$2(null, i__10549_10553);
      iters.push(cljs.core.iter(coll_10554));
      var G__10555 = seq__10546_10550;
      var G__10556 = chunk__10547_10551;
      var G__10557 = count__10548_10552;
      var G__10558 = i__10549_10553 + 1;
      seq__10546_10550 = G__10555;
      chunk__10547_10551 = G__10556;
      count__10548_10552 = G__10557;
      i__10549_10553 = G__10558;
      continue;
    } else {
      var temp__6753__auto___10559 = cljs.core.seq(seq__10546_10550);
      if (temp__6753__auto___10559) {
        var seq__10546_10560__$1 = temp__6753__auto___10559;
        if (cljs.core.chunked_seq_QMARK_(seq__10546_10560__$1)) {
          var c__7968__auto___10561 = cljs.core.chunk_first(seq__10546_10560__$1);
          var G__10562 = cljs.core.chunk_rest(seq__10546_10560__$1);
          var G__10563 = c__7968__auto___10561;
          var G__10564 = cljs.core.count(c__7968__auto___10561);
          var G__10565 = 0;
          seq__10546_10550 = G__10562;
          chunk__10547_10551 = G__10563;
          count__10548_10552 = G__10564;
          i__10549_10553 = G__10565;
          continue;
        } else {
          var coll_10566 = cljs.core.first(seq__10546_10560__$1);
          iters.push(cljs.core.iter(coll_10566));
          var G__10567 = cljs.core.next(seq__10546_10560__$1);
          var G__10568 = null;
          var G__10569 = 0;
          var G__10570 = 0;
          seq__10546_10550 = G__10567;
          chunk__10547_10551 = G__10568;
          count__10548_10552 = G__10569;
          i__10549_10553 = G__10570;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence(var_args) {
  var args10571 = [];
  var len__8278__auto___10577 = arguments.length;
  var i__8279__auto___10578 = 0;
  while (true) {
    if (i__8279__auto___10578 < len__8278__auto___10577) {
      args10571.push(arguments[i__8279__auto___10578]);
      var G__10579 = i__8279__auto___10578 + 1;
      i__8279__auto___10578 = G__10579;
      continue;
    } else {
    }
    break;
  }
  var G__10576 = args10571.length;
  switch(G__10576) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10571.slice(2), 0, null);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__7062__auto__ = cljs.core.seq(coll);
    if (or__7062__auto__) {
      return or__7062__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq10572) {
  var G__10573 = cljs.core.first(seq10572);
  var seq10572__$1 = cljs.core.next(seq10572);
  var G__10574 = cljs.core.first(seq10572__$1);
  var seq10572__$2 = cljs.core.next(seq10572__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__10573, G__10574, seq10572__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__10582 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10582) : pred.call(null, G__10582);
      }())) {
        var G__10583 = pred;
        var G__10584 = cljs.core.next(coll);
        pred = G__10583;
        coll = G__10584;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__7062__auto__ = function() {
        var G__10588 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10588) : pred.call(null, G__10588);
      }();
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        var G__10589 = pred;
        var G__10590 = cljs.core.next(coll);
        pred = G__10589;
        coll = G__10590;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__10591 = null;
    var G__10591__0 = function() {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
    };
    var G__10591__1 = function(x) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x));
    };
    var G__10591__2 = function(x, y) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y));
    };
    var G__10591__3 = function() {
      var G__10592__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__10592 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__10593__i = 0, G__10593__a = new Array(arguments.length - 2);
          while (G__10593__i < G__10593__a.length) {
            G__10593__a[G__10593__i] = arguments[G__10593__i + 2];
            ++G__10593__i;
          }
          zs = new cljs.core.IndexedSeq(G__10593__a, 0);
        }
        return G__10592__delegate.call(this, x, y, zs);
      };
      G__10592.cljs$lang$maxFixedArity = 2;
      G__10592.cljs$lang$applyTo = function(arglist__10594) {
        var x = cljs.core.first(arglist__10594);
        arglist__10594 = cljs.core.next(arglist__10594);
        var y = cljs.core.first(arglist__10594);
        var zs = cljs.core.rest(arglist__10594);
        return G__10592__delegate(x, y, zs);
      };
      G__10592.cljs$core$IFn$_invoke$arity$variadic = G__10592__delegate;
      return G__10592;
    }();
    G__10591 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__10591__0.call(this);
        case 1:
          return G__10591__1.call(this, x);
        case 2:
          return G__10591__2.call(this, x, y);
        default:
          var G__10595 = null;
          if (arguments.length > 2) {
            var G__10596__i = 0, G__10596__a = new Array(arguments.length - 2);
            while (G__10596__i < G__10596__a.length) {
              G__10596__a[G__10596__i] = arguments[G__10596__i + 2];
              ++G__10596__i;
            }
            G__10595 = new cljs.core.IndexedSeq(G__10596__a, 0);
          }
          return G__10591__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__10595);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10591.cljs$lang$maxFixedArity = 2;
    G__10591.cljs$lang$applyTo = G__10591__3.cljs$lang$applyTo;
    G__10591.cljs$core$IFn$_invoke$arity$0 = G__10591__0;
    G__10591.cljs$core$IFn$_invoke$arity$1 = G__10591__1;
    G__10591.cljs$core$IFn$_invoke$arity$2 = G__10591__2;
    G__10591.cljs$core$IFn$_invoke$arity$variadic = G__10591__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__10591;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__10597__delegate = function(args) {
      return x;
    };
    var G__10597 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__10598__i = 0, G__10598__a = new Array(arguments.length - 0);
        while (G__10598__i < G__10598__a.length) {
          G__10598__a[G__10598__i] = arguments[G__10598__i + 0];
          ++G__10598__i;
        }
        args = new cljs.core.IndexedSeq(G__10598__a, 0);
      }
      return G__10597__delegate.call(this, args);
    };
    G__10597.cljs$lang$maxFixedArity = 0;
    G__10597.cljs$lang$applyTo = function(arglist__10599) {
      var args = cljs.core.seq(arglist__10599);
      return G__10597__delegate(args);
    };
    G__10597.cljs$core$IFn$_invoke$arity$variadic = G__10597__delegate;
    return G__10597;
  }();
};
cljs.core.comp = function cljs$core$comp(var_args) {
  var args10600 = [];
  var len__8278__auto___10622 = arguments.length;
  var i__8279__auto___10623 = 0;
  while (true) {
    if (i__8279__auto___10623 < len__8278__auto___10622) {
      args10600.push(arguments[i__8279__auto___10623]);
      var G__10624 = i__8279__auto___10623 + 1;
      i__8279__auto___10623 = G__10624;
      continue;
    } else {
    }
    break;
  }
  var G__10606 = args10600.length;
  switch(G__10606) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10600.slice(3), 0, null);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__8301__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__10626 = null;
    var G__10626__0 = function() {
      var G__10607 = g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10607) : f.call(null, G__10607);
    };
    var G__10626__1 = function(x) {
      var G__10608 = g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null, x);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10608) : f.call(null, G__10608);
    };
    var G__10626__2 = function(x, y) {
      var G__10609 = g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x, y) : g.call(null, x, y);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10609) : f.call(null, G__10609);
    };
    var G__10626__3 = function(x, y, z) {
      var G__10610 = g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x, y, z) : g.call(null, x, y, z);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10610) : f.call(null, G__10610);
    };
    var G__10626__4 = function() {
      var G__10627__delegate = function(x, y, z, args) {
        var G__10611 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10611) : f.call(null, G__10611);
      };
      var G__10627 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10628__i = 0, G__10628__a = new Array(arguments.length - 3);
          while (G__10628__i < G__10628__a.length) {
            G__10628__a[G__10628__i] = arguments[G__10628__i + 3];
            ++G__10628__i;
          }
          args = new cljs.core.IndexedSeq(G__10628__a, 0);
        }
        return G__10627__delegate.call(this, x, y, z, args);
      };
      G__10627.cljs$lang$maxFixedArity = 3;
      G__10627.cljs$lang$applyTo = function(arglist__10629) {
        var x = cljs.core.first(arglist__10629);
        arglist__10629 = cljs.core.next(arglist__10629);
        var y = cljs.core.first(arglist__10629);
        arglist__10629 = cljs.core.next(arglist__10629);
        var z = cljs.core.first(arglist__10629);
        var args = cljs.core.rest(arglist__10629);
        return G__10627__delegate(x, y, z, args);
      };
      G__10627.cljs$core$IFn$_invoke$arity$variadic = G__10627__delegate;
      return G__10627;
    }();
    G__10626 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__10626__0.call(this);
        case 1:
          return G__10626__1.call(this, x);
        case 2:
          return G__10626__2.call(this, x, y);
        case 3:
          return G__10626__3.call(this, x, y, z);
        default:
          var G__10630 = null;
          if (arguments.length > 3) {
            var G__10631__i = 0, G__10631__a = new Array(arguments.length - 3);
            while (G__10631__i < G__10631__a.length) {
              G__10631__a[G__10631__i] = arguments[G__10631__i + 3];
              ++G__10631__i;
            }
            G__10630 = new cljs.core.IndexedSeq(G__10631__a, 0);
          }
          return G__10626__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10630);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10626.cljs$lang$maxFixedArity = 3;
    G__10626.cljs$lang$applyTo = G__10626__4.cljs$lang$applyTo;
    G__10626.cljs$core$IFn$_invoke$arity$0 = G__10626__0;
    G__10626.cljs$core$IFn$_invoke$arity$1 = G__10626__1;
    G__10626.cljs$core$IFn$_invoke$arity$2 = G__10626__2;
    G__10626.cljs$core$IFn$_invoke$arity$3 = G__10626__3;
    G__10626.cljs$core$IFn$_invoke$arity$variadic = G__10626__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10626;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__10632 = null;
    var G__10632__0 = function() {
      var G__10612 = function() {
        var G__10613 = h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10613) : g.call(null, G__10613);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10612) : f.call(null, G__10612);
    };
    var G__10632__1 = function(x) {
      var G__10614 = function() {
        var G__10615 = h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null, x);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10615) : g.call(null, G__10615);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10614) : f.call(null, G__10614);
    };
    var G__10632__2 = function(x, y) {
      var G__10616 = function() {
        var G__10617 = h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x, y) : h.call(null, x, y);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10617) : g.call(null, G__10617);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10616) : f.call(null, G__10616);
    };
    var G__10632__3 = function(x, y, z) {
      var G__10618 = function() {
        var G__10619 = h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x, y, z) : h.call(null, x, y, z);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10619) : g.call(null, G__10619);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10618) : f.call(null, G__10618);
    };
    var G__10632__4 = function() {
      var G__10633__delegate = function(x, y, z, args) {
        var G__10620 = function() {
          var G__10621 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__10621) : g.call(null, G__10621);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10620) : f.call(null, G__10620);
      };
      var G__10633 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10634__i = 0, G__10634__a = new Array(arguments.length - 3);
          while (G__10634__i < G__10634__a.length) {
            G__10634__a[G__10634__i] = arguments[G__10634__i + 3];
            ++G__10634__i;
          }
          args = new cljs.core.IndexedSeq(G__10634__a, 0);
        }
        return G__10633__delegate.call(this, x, y, z, args);
      };
      G__10633.cljs$lang$maxFixedArity = 3;
      G__10633.cljs$lang$applyTo = function(arglist__10635) {
        var x = cljs.core.first(arglist__10635);
        arglist__10635 = cljs.core.next(arglist__10635);
        var y = cljs.core.first(arglist__10635);
        arglist__10635 = cljs.core.next(arglist__10635);
        var z = cljs.core.first(arglist__10635);
        var args = cljs.core.rest(arglist__10635);
        return G__10633__delegate(x, y, z, args);
      };
      G__10633.cljs$core$IFn$_invoke$arity$variadic = G__10633__delegate;
      return G__10633;
    }();
    G__10632 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__10632__0.call(this);
        case 1:
          return G__10632__1.call(this, x);
        case 2:
          return G__10632__2.call(this, x, y);
        case 3:
          return G__10632__3.call(this, x, y, z);
        default:
          var G__10636 = null;
          if (arguments.length > 3) {
            var G__10637__i = 0, G__10637__a = new Array(arguments.length - 3);
            while (G__10637__i < G__10637__a.length) {
              G__10637__a[G__10637__i] = arguments[G__10637__i + 3];
              ++G__10637__i;
            }
            G__10636 = new cljs.core.IndexedSeq(G__10637__a, 0);
          }
          return G__10632__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10636);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10632.cljs$lang$maxFixedArity = 3;
    G__10632.cljs$lang$applyTo = G__10632__4.cljs$lang$applyTo;
    G__10632.cljs$core$IFn$_invoke$arity$0 = G__10632__0;
    G__10632.cljs$core$IFn$_invoke$arity$1 = G__10632__1;
    G__10632.cljs$core$IFn$_invoke$arity$2 = G__10632__2;
    G__10632.cljs$core$IFn$_invoke$arity$3 = G__10632__3;
    G__10632.cljs$core$IFn$_invoke$arity$variadic = G__10632__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10632;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__10638__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__10639 = cljs.core.first(fs__$2).call(null, ret);
            var G__10640 = cljs.core.next(fs__$2);
            ret = G__10639;
            fs__$2 = G__10640;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__10638 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__10641__i = 0, G__10641__a = new Array(arguments.length - 0);
          while (G__10641__i < G__10641__a.length) {
            G__10641__a[G__10641__i] = arguments[G__10641__i + 0];
            ++G__10641__i;
          }
          args = new cljs.core.IndexedSeq(G__10641__a, 0);
        }
        return G__10638__delegate.call(this, args);
      };
      G__10638.cljs$lang$maxFixedArity = 0;
      G__10638.cljs$lang$applyTo = function(arglist__10642) {
        var args = cljs.core.seq(arglist__10642);
        return G__10638__delegate(args);
      };
      G__10638.cljs$core$IFn$_invoke$arity$variadic = G__10638__delegate;
      return G__10638;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq10601) {
  var G__10602 = cljs.core.first(seq10601);
  var seq10601__$1 = cljs.core.next(seq10601);
  var G__10603 = cljs.core.first(seq10601__$1);
  var seq10601__$2 = cljs.core.next(seq10601__$1);
  var G__10604 = cljs.core.first(seq10601__$2);
  var seq10601__$3 = cljs.core.next(seq10601__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__10602, G__10603, G__10604, seq10601__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial(var_args) {
  var args10643 = [];
  var len__8278__auto___10651 = arguments.length;
  var i__8279__auto___10652 = 0;
  while (true) {
    if (i__8279__auto___10652 < len__8278__auto___10651) {
      args10643.push(arguments[i__8279__auto___10652]);
      var G__10653 = i__8279__auto___10652 + 1;
      i__8279__auto___10652 = G__10653;
      continue;
    } else {
    }
    break;
  }
  var G__10650 = args10643.length;
  switch(G__10650) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10643.slice(4), 0, null);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__8301__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__10655 = null;
    var G__10655__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null, arg1);
    };
    var G__10655__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, x) : f.call(null, arg1, x);
    };
    var G__10655__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, x, y) : f.call(null, arg1, x, y);
    };
    var G__10655__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, x, y, z) : f.call(null, arg1, x, y, z);
    };
    var G__10655__4 = function() {
      var G__10656__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__10656 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10657__i = 0, G__10657__a = new Array(arguments.length - 3);
          while (G__10657__i < G__10657__a.length) {
            G__10657__a[G__10657__i] = arguments[G__10657__i + 3];
            ++G__10657__i;
          }
          args = new cljs.core.IndexedSeq(G__10657__a, 0);
        }
        return G__10656__delegate.call(this, x, y, z, args);
      };
      G__10656.cljs$lang$maxFixedArity = 3;
      G__10656.cljs$lang$applyTo = function(arglist__10658) {
        var x = cljs.core.first(arglist__10658);
        arglist__10658 = cljs.core.next(arglist__10658);
        var y = cljs.core.first(arglist__10658);
        arglist__10658 = cljs.core.next(arglist__10658);
        var z = cljs.core.first(arglist__10658);
        var args = cljs.core.rest(arglist__10658);
        return G__10656__delegate(x, y, z, args);
      };
      G__10656.cljs$core$IFn$_invoke$arity$variadic = G__10656__delegate;
      return G__10656;
    }();
    G__10655 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__10655__0.call(this);
        case 1:
          return G__10655__1.call(this, x);
        case 2:
          return G__10655__2.call(this, x, y);
        case 3:
          return G__10655__3.call(this, x, y, z);
        default:
          var G__10659 = null;
          if (arguments.length > 3) {
            var G__10660__i = 0, G__10660__a = new Array(arguments.length - 3);
            while (G__10660__i < G__10660__a.length) {
              G__10660__a[G__10660__i] = arguments[G__10660__i + 3];
              ++G__10660__i;
            }
            G__10659 = new cljs.core.IndexedSeq(G__10660__a, 0);
          }
          return G__10655__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10659);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10655.cljs$lang$maxFixedArity = 3;
    G__10655.cljs$lang$applyTo = G__10655__4.cljs$lang$applyTo;
    G__10655.cljs$core$IFn$_invoke$arity$0 = G__10655__0;
    G__10655.cljs$core$IFn$_invoke$arity$1 = G__10655__1;
    G__10655.cljs$core$IFn$_invoke$arity$2 = G__10655__2;
    G__10655.cljs$core$IFn$_invoke$arity$3 = G__10655__3;
    G__10655.cljs$core$IFn$_invoke$arity$variadic = G__10655__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10655;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__10661 = null;
    var G__10661__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, arg2) : f.call(null, arg1, arg2);
    };
    var G__10661__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, x) : f.call(null, arg1, arg2, x);
    };
    var G__10661__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, x, y) : f.call(null, arg1, arg2, x, y);
    };
    var G__10661__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, x, y, z) : f.call(null, arg1, arg2, x, y, z);
    };
    var G__10661__4 = function() {
      var G__10662__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__10662 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10663__i = 0, G__10663__a = new Array(arguments.length - 3);
          while (G__10663__i < G__10663__a.length) {
            G__10663__a[G__10663__i] = arguments[G__10663__i + 3];
            ++G__10663__i;
          }
          args = new cljs.core.IndexedSeq(G__10663__a, 0);
        }
        return G__10662__delegate.call(this, x, y, z, args);
      };
      G__10662.cljs$lang$maxFixedArity = 3;
      G__10662.cljs$lang$applyTo = function(arglist__10664) {
        var x = cljs.core.first(arglist__10664);
        arglist__10664 = cljs.core.next(arglist__10664);
        var y = cljs.core.first(arglist__10664);
        arglist__10664 = cljs.core.next(arglist__10664);
        var z = cljs.core.first(arglist__10664);
        var args = cljs.core.rest(arglist__10664);
        return G__10662__delegate(x, y, z, args);
      };
      G__10662.cljs$core$IFn$_invoke$arity$variadic = G__10662__delegate;
      return G__10662;
    }();
    G__10661 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__10661__0.call(this);
        case 1:
          return G__10661__1.call(this, x);
        case 2:
          return G__10661__2.call(this, x, y);
        case 3:
          return G__10661__3.call(this, x, y, z);
        default:
          var G__10665 = null;
          if (arguments.length > 3) {
            var G__10666__i = 0, G__10666__a = new Array(arguments.length - 3);
            while (G__10666__i < G__10666__a.length) {
              G__10666__a[G__10666__i] = arguments[G__10666__i + 3];
              ++G__10666__i;
            }
            G__10665 = new cljs.core.IndexedSeq(G__10666__a, 0);
          }
          return G__10661__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10665);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10661.cljs$lang$maxFixedArity = 3;
    G__10661.cljs$lang$applyTo = G__10661__4.cljs$lang$applyTo;
    G__10661.cljs$core$IFn$_invoke$arity$0 = G__10661__0;
    G__10661.cljs$core$IFn$_invoke$arity$1 = G__10661__1;
    G__10661.cljs$core$IFn$_invoke$arity$2 = G__10661__2;
    G__10661.cljs$core$IFn$_invoke$arity$3 = G__10661__3;
    G__10661.cljs$core$IFn$_invoke$arity$variadic = G__10661__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10661;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__10667 = null;
    var G__10667__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, arg3) : f.call(null, arg1, arg2, arg3);
    };
    var G__10667__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, arg3, x) : f.call(null, arg1, arg2, arg3, x);
    };
    var G__10667__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, arg3, x, y) : f.call(null, arg1, arg2, arg3, x, y);
    };
    var G__10667__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1, arg2, arg3, x, y, z) : f.call(null, arg1, arg2, arg3, x, y, z);
    };
    var G__10667__4 = function() {
      var G__10668__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__10668 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10669__i = 0, G__10669__a = new Array(arguments.length - 3);
          while (G__10669__i < G__10669__a.length) {
            G__10669__a[G__10669__i] = arguments[G__10669__i + 3];
            ++G__10669__i;
          }
          args = new cljs.core.IndexedSeq(G__10669__a, 0);
        }
        return G__10668__delegate.call(this, x, y, z, args);
      };
      G__10668.cljs$lang$maxFixedArity = 3;
      G__10668.cljs$lang$applyTo = function(arglist__10670) {
        var x = cljs.core.first(arglist__10670);
        arglist__10670 = cljs.core.next(arglist__10670);
        var y = cljs.core.first(arglist__10670);
        arglist__10670 = cljs.core.next(arglist__10670);
        var z = cljs.core.first(arglist__10670);
        var args = cljs.core.rest(arglist__10670);
        return G__10668__delegate(x, y, z, args);
      };
      G__10668.cljs$core$IFn$_invoke$arity$variadic = G__10668__delegate;
      return G__10668;
    }();
    G__10667 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__10667__0.call(this);
        case 1:
          return G__10667__1.call(this, x);
        case 2:
          return G__10667__2.call(this, x, y);
        case 3:
          return G__10667__3.call(this, x, y, z);
        default:
          var G__10671 = null;
          if (arguments.length > 3) {
            var G__10672__i = 0, G__10672__a = new Array(arguments.length - 3);
            while (G__10672__i < G__10672__a.length) {
              G__10672__a[G__10672__i] = arguments[G__10672__i + 3];
              ++G__10672__i;
            }
            G__10671 = new cljs.core.IndexedSeq(G__10672__a, 0);
          }
          return G__10667__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10671);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10667.cljs$lang$maxFixedArity = 3;
    G__10667.cljs$lang$applyTo = G__10667__4.cljs$lang$applyTo;
    G__10667.cljs$core$IFn$_invoke$arity$0 = G__10667__0;
    G__10667.cljs$core$IFn$_invoke$arity$1 = G__10667__1;
    G__10667.cljs$core$IFn$_invoke$arity$2 = G__10667__2;
    G__10667.cljs$core$IFn$_invoke$arity$3 = G__10667__3;
    G__10667.cljs$core$IFn$_invoke$arity$variadic = G__10667__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10667;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__10673__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__10673 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__10674__i = 0, G__10674__a = new Array(arguments.length - 0);
        while (G__10674__i < G__10674__a.length) {
          G__10674__a[G__10674__i] = arguments[G__10674__i + 0];
          ++G__10674__i;
        }
        args = new cljs.core.IndexedSeq(G__10674__a, 0);
      }
      return G__10673__delegate.call(this, args);
    };
    G__10673.cljs$lang$maxFixedArity = 0;
    G__10673.cljs$lang$applyTo = function(arglist__10675) {
      var args = cljs.core.seq(arglist__10675);
      return G__10673__delegate(args);
    };
    G__10673.cljs$core$IFn$_invoke$arity$variadic = G__10673__delegate;
    return G__10673;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq10644) {
  var G__10645 = cljs.core.first(seq10644);
  var seq10644__$1 = cljs.core.next(seq10644);
  var G__10646 = cljs.core.first(seq10644__$1);
  var seq10644__$2 = cljs.core.next(seq10644__$1);
  var G__10647 = cljs.core.first(seq10644__$2);
  var seq10644__$3 = cljs.core.next(seq10644__$2);
  var G__10648 = cljs.core.first(seq10644__$3);
  var seq10644__$4 = cljs.core.next(seq10644__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__10645, G__10646, G__10647, G__10648, seq10644__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil(var_args) {
  var args10676 = [];
  var len__8278__auto___10695 = arguments.length;
  var i__8279__auto___10696 = 0;
  while (true) {
    if (i__8279__auto___10696 < len__8278__auto___10695) {
      args10676.push(arguments[i__8279__auto___10696]);
      var G__10697 = i__8279__auto___10696 + 1;
      i__8279__auto___10696 = G__10697;
      continue;
    } else {
    }
    break;
  }
  var G__10678 = args10676.length;
  switch(G__10678) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10676.length)].join(""));;
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__10699 = null;
    var G__10699__1 = function(a) {
      var G__10679 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10679) : f.call(null, G__10679);
    };
    var G__10699__2 = function(a, b) {
      var G__10680 = a == null ? x : a;
      var G__10681 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10680, G__10681) : f.call(null, G__10680, G__10681);
    };
    var G__10699__3 = function(a, b, c) {
      var G__10682 = a == null ? x : a;
      var G__10683 = b;
      var G__10684 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10682, G__10683, G__10684) : f.call(null, G__10682, G__10683, G__10684);
    };
    var G__10699__4 = function() {
      var G__10700__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__10700 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__10701__i = 0, G__10701__a = new Array(arguments.length - 3);
          while (G__10701__i < G__10701__a.length) {
            G__10701__a[G__10701__i] = arguments[G__10701__i + 3];
            ++G__10701__i;
          }
          ds = new cljs.core.IndexedSeq(G__10701__a, 0);
        }
        return G__10700__delegate.call(this, a, b, c, ds);
      };
      G__10700.cljs$lang$maxFixedArity = 3;
      G__10700.cljs$lang$applyTo = function(arglist__10702) {
        var a = cljs.core.first(arglist__10702);
        arglist__10702 = cljs.core.next(arglist__10702);
        var b = cljs.core.first(arglist__10702);
        arglist__10702 = cljs.core.next(arglist__10702);
        var c = cljs.core.first(arglist__10702);
        var ds = cljs.core.rest(arglist__10702);
        return G__10700__delegate(a, b, c, ds);
      };
      G__10700.cljs$core$IFn$_invoke$arity$variadic = G__10700__delegate;
      return G__10700;
    }();
    G__10699 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__10699__1.call(this, a);
        case 2:
          return G__10699__2.call(this, a, b);
        case 3:
          return G__10699__3.call(this, a, b, c);
        default:
          var G__10703 = null;
          if (arguments.length > 3) {
            var G__10704__i = 0, G__10704__a = new Array(arguments.length - 3);
            while (G__10704__i < G__10704__a.length) {
              G__10704__a[G__10704__i] = arguments[G__10704__i + 3];
              ++G__10704__i;
            }
            G__10703 = new cljs.core.IndexedSeq(G__10704__a, 0);
          }
          return G__10699__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__10703);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10699.cljs$lang$maxFixedArity = 3;
    G__10699.cljs$lang$applyTo = G__10699__4.cljs$lang$applyTo;
    G__10699.cljs$core$IFn$_invoke$arity$1 = G__10699__1;
    G__10699.cljs$core$IFn$_invoke$arity$2 = G__10699__2;
    G__10699.cljs$core$IFn$_invoke$arity$3 = G__10699__3;
    G__10699.cljs$core$IFn$_invoke$arity$variadic = G__10699__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10699;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__10705 = null;
    var G__10705__2 = function(a, b) {
      var G__10685 = a == null ? x : a;
      var G__10686 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10685, G__10686) : f.call(null, G__10685, G__10686);
    };
    var G__10705__3 = function(a, b, c) {
      var G__10687 = a == null ? x : a;
      var G__10688 = b == null ? y : b;
      var G__10689 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10687, G__10688, G__10689) : f.call(null, G__10687, G__10688, G__10689);
    };
    var G__10705__4 = function() {
      var G__10706__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__10706 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__10707__i = 0, G__10707__a = new Array(arguments.length - 3);
          while (G__10707__i < G__10707__a.length) {
            G__10707__a[G__10707__i] = arguments[G__10707__i + 3];
            ++G__10707__i;
          }
          ds = new cljs.core.IndexedSeq(G__10707__a, 0);
        }
        return G__10706__delegate.call(this, a, b, c, ds);
      };
      G__10706.cljs$lang$maxFixedArity = 3;
      G__10706.cljs$lang$applyTo = function(arglist__10708) {
        var a = cljs.core.first(arglist__10708);
        arglist__10708 = cljs.core.next(arglist__10708);
        var b = cljs.core.first(arglist__10708);
        arglist__10708 = cljs.core.next(arglist__10708);
        var c = cljs.core.first(arglist__10708);
        var ds = cljs.core.rest(arglist__10708);
        return G__10706__delegate(a, b, c, ds);
      };
      G__10706.cljs$core$IFn$_invoke$arity$variadic = G__10706__delegate;
      return G__10706;
    }();
    G__10705 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__10705__2.call(this, a, b);
        case 3:
          return G__10705__3.call(this, a, b, c);
        default:
          var G__10709 = null;
          if (arguments.length > 3) {
            var G__10710__i = 0, G__10710__a = new Array(arguments.length - 3);
            while (G__10710__i < G__10710__a.length) {
              G__10710__a[G__10710__i] = arguments[G__10710__i + 3];
              ++G__10710__i;
            }
            G__10709 = new cljs.core.IndexedSeq(G__10710__a, 0);
          }
          return G__10705__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__10709);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10705.cljs$lang$maxFixedArity = 3;
    G__10705.cljs$lang$applyTo = G__10705__4.cljs$lang$applyTo;
    G__10705.cljs$core$IFn$_invoke$arity$2 = G__10705__2;
    G__10705.cljs$core$IFn$_invoke$arity$3 = G__10705__3;
    G__10705.cljs$core$IFn$_invoke$arity$variadic = G__10705__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10705;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__10711 = null;
    var G__10711__2 = function(a, b) {
      var G__10690 = a == null ? x : a;
      var G__10691 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10690, G__10691) : f.call(null, G__10690, G__10691);
    };
    var G__10711__3 = function(a, b, c) {
      var G__10692 = a == null ? x : a;
      var G__10693 = b == null ? y : b;
      var G__10694 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10692, G__10693, G__10694) : f.call(null, G__10692, G__10693, G__10694);
    };
    var G__10711__4 = function() {
      var G__10712__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__10712 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__10713__i = 0, G__10713__a = new Array(arguments.length - 3);
          while (G__10713__i < G__10713__a.length) {
            G__10713__a[G__10713__i] = arguments[G__10713__i + 3];
            ++G__10713__i;
          }
          ds = new cljs.core.IndexedSeq(G__10713__a, 0);
        }
        return G__10712__delegate.call(this, a, b, c, ds);
      };
      G__10712.cljs$lang$maxFixedArity = 3;
      G__10712.cljs$lang$applyTo = function(arglist__10714) {
        var a = cljs.core.first(arglist__10714);
        arglist__10714 = cljs.core.next(arglist__10714);
        var b = cljs.core.first(arglist__10714);
        arglist__10714 = cljs.core.next(arglist__10714);
        var c = cljs.core.first(arglist__10714);
        var ds = cljs.core.rest(arglist__10714);
        return G__10712__delegate(a, b, c, ds);
      };
      G__10712.cljs$core$IFn$_invoke$arity$variadic = G__10712__delegate;
      return G__10712;
    }();
    G__10711 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__10711__2.call(this, a, b);
        case 3:
          return G__10711__3.call(this, a, b, c);
        default:
          var G__10715 = null;
          if (arguments.length > 3) {
            var G__10716__i = 0, G__10716__a = new Array(arguments.length - 3);
            while (G__10716__i < G__10716__a.length) {
              G__10716__a[G__10716__i] = arguments[G__10716__i + 3];
              ++G__10716__i;
            }
            G__10715 = new cljs.core.IndexedSeq(G__10716__a, 0);
          }
          return G__10711__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__10715);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__10711.cljs$lang$maxFixedArity = 3;
    G__10711.cljs$lang$applyTo = G__10711__4.cljs$lang$applyTo;
    G__10711.cljs$core$IFn$_invoke$arity$2 = G__10711__2;
    G__10711.cljs$core$IFn$_invoke$arity$3 = G__10711__3;
    G__10711.cljs$core$IFn$_invoke$arity$variadic = G__10711__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__10711;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed(var_args) {
  var args10717 = [];
  var len__8278__auto___10748 = arguments.length;
  var i__8279__auto___10749 = 0;
  while (true) {
    if (i__8279__auto___10749 < len__8278__auto___10748) {
      args10717.push(arguments[i__8279__auto___10749]);
      var G__10750 = i__8279__auto___10749 + 1;
      i__8279__auto___10749 = G__10750;
      continue;
    } else {
    }
    break;
  }
  var G__10719 = args10717.length;
  switch(G__10719) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10717.length)].join(""));;
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(-1) : cljs.core.volatile_BANG_.call(null, -1);
    return function(i) {
      return function() {
        var G__10752 = null;
        var G__10752__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10752__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10752__2 = function(result, input) {
          var G__10720 = result;
          var G__10721 = function() {
            var G__10722 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__10723 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10722, G__10723) : f.call(null, G__10722, G__10723);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10720, G__10721) : rf.call(null, G__10720, G__10721);
        };
        G__10752 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10752__0.call(this);
            case 1:
              return G__10752__1.call(this, result);
            case 2:
              return G__10752__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10752.cljs$core$IFn$_invoke$arity$0 = G__10752__0;
        G__10752.cljs$core$IFn$_invoke$arity$1 = G__10752__1;
        G__10752.cljs$core$IFn$_invoke$arity$2 = G__10752__2;
        return G__10752;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__6753__auto__ = cljs.core.seq(coll__$1);
      if (temp__6753__auto__) {
        var s = temp__6753__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__8078__auto___10753 = size;
          var i_10754 = 0;
          while (true) {
            if (i_10754 < n__8078__auto___10753) {
              cljs.core.chunk_append(b, function() {
                var G__10744 = idx + i_10754;
                var G__10745 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10754);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10744, G__10745) : f.call(null, G__10744, G__10745);
              }());
              var G__10755 = i_10754 + 1;
              i_10754 = G__10755;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__10746 = idx;
            var G__10747 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10746, G__10747) : f.call(null, G__10746, G__10747);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep(var_args) {
  var args10756 = [];
  var len__8278__auto___10761 = arguments.length;
  var i__8279__auto___10762 = 0;
  while (true) {
    if (i__8279__auto___10762 < len__8278__auto___10761) {
      args10756.push(arguments[i__8279__auto___10762]);
      var G__10763 = i__8279__auto___10762 + 1;
      i__8279__auto___10762 = G__10763;
      continue;
    } else {
    }
    break;
  }
  var G__10758 = args10756.length;
  switch(G__10758) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10756.length)].join(""));;
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__10765 = null;
      var G__10765__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__10765__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__10765__2 = function(result, input) {
        var v = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        if (v == null) {
          return result;
        } else {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
        }
      };
      G__10765 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__10765__0.call(this);
          case 1:
            return G__10765__1.call(this, result);
          case 2:
            return G__10765__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__10765.cljs$core$IFn$_invoke$arity$0 = G__10765__0;
      G__10765.cljs$core$IFn$_invoke$arity$1 = G__10765__1;
      G__10765.cljs$core$IFn$_invoke$arity$2 = G__10765__2;
      return G__10765;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6753__auto__ = cljs.core.seq(coll);
    if (temp__6753__auto__) {
      var s = temp__6753__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__8078__auto___10766 = size;
        var i_10767 = 0;
        while (true) {
          if (i_10767 < n__8078__auto___10766) {
            var x_10768 = function() {
              var G__10759 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10767);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10759) : f.call(null, G__10759);
            }();
            if (x_10768 == null) {
            } else {
              cljs.core.chunk_append(b, x_10768);
            }
            var G__10769 = i_10767 + 1;
            i_10767 = G__10769;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__10760 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10760) : f.call(null, G__10760);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__10770 = cljs.core.seq(self__.watches);
  var chunk__10771 = null;
  var count__10772 = 0;
  var i__10773 = 0;
  while (true) {
    if (i__10773 < count__10772) {
      var vec__10774 = chunk__10771.cljs$core$IIndexed$_nth$arity$2(null, i__10773);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10774, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10774, 1, null);
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
      var G__10780 = seq__10770;
      var G__10781 = chunk__10771;
      var G__10782 = count__10772;
      var G__10783 = i__10773 + 1;
      seq__10770 = G__10780;
      chunk__10771 = G__10781;
      count__10772 = G__10782;
      i__10773 = G__10783;
      continue;
    } else {
      var temp__6753__auto__ = cljs.core.seq(seq__10770);
      if (temp__6753__auto__) {
        var seq__10770__$1 = temp__6753__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__10770__$1)) {
          var c__7968__auto__ = cljs.core.chunk_first(seq__10770__$1);
          var G__10784 = cljs.core.chunk_rest(seq__10770__$1);
          var G__10785 = c__7968__auto__;
          var G__10786 = cljs.core.count(c__7968__auto__);
          var G__10787 = 0;
          seq__10770 = G__10784;
          chunk__10771 = G__10785;
          count__10772 = G__10786;
          i__10773 = G__10787;
          continue;
        } else {
          var vec__10777 = cljs.core.first(seq__10770__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10777, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10777, 1, null);
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
          var G__10788 = cljs.core.next(seq__10770__$1);
          var G__10789 = null;
          var G__10790 = 0;
          var G__10791 = 0;
          seq__10770 = G__10788;
          chunk__10771 = G__10789;
          count__10772 = G__10790;
          i__10773 = G__10791;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return goog.getUid(this$__$1);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom(var_args) {
  var args10792 = [];
  var len__8278__auto___10800 = arguments.length;
  var i__8279__auto___10801 = 0;
  while (true) {
    if (i__8279__auto___10801 < len__8278__auto___10800) {
      args10792.push(arguments[i__8279__auto___10801]);
      var G__10802 = i__8279__auto___10801 + 1;
      i__8279__auto___10801 = G__10802;
      continue;
    } else {
    }
    break;
  }
  var G__10796 = args10792.length;
  switch(G__10796) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10792.slice(1), 0, null);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__8301__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__10797) {
  var map__10798 = p__10797;
  var map__10798__$1 = (!(map__10798 == null) ? map__10798.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === map__10798.cljs$core$ISeq$ ? true : false : false) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__10798) : map__10798;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10798__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10798__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq10793) {
  var G__10794 = cljs.core.first(seq10793);
  var seq10793__$1 = cljs.core.next(seq10793);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__10794, seq10793__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value))) {
      } else {
        throw new Error("Validator rejected reference state");
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_(var_args) {
  var args10804 = [];
  var len__8278__auto___10818 = arguments.length;
  var i__8279__auto___10819 = 0;
  while (true) {
    if (i__8279__auto___10819 < len__8278__auto___10818) {
      args10804.push(arguments[i__8279__auto___10819]);
      var G__10820 = i__8279__auto___10819 + 1;
      i__8279__auto___10819 = G__10820;
      continue;
    } else {
    }
    break;
  }
  var G__10811 = args10804.length;
  switch(G__10811) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10804.slice(4), 0, null);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__8301__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__10812 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10812) : f.call(null, G__10812);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__10813 = a.state;
      var G__10814 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10813, G__10814) : f.call(null, G__10813, G__10814);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__10815 = a.state;
      var G__10816 = x;
      var G__10817 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10815, G__10816, G__10817) : f.call(null, G__10815, G__10816, G__10817);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq10805) {
  var G__10806 = cljs.core.first(seq10805);
  var seq10805__$1 = cljs.core.next(seq10805);
  var G__10807 = cljs.core.first(seq10805__$1);
  var seq10805__$2 = cljs.core.next(seq10805__$1);
  var G__10808 = cljs.core.first(seq10805__$2);
  var seq10805__$3 = cljs.core.next(seq10805__$2);
  var G__10809 = cljs.core.first(seq10805__$3);
  var seq10805__$4 = cljs.core.next(seq10805__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10806, G__10807, G__10808, G__10809, seq10805__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed(var_args) {
  var args10822 = [];
  var len__8278__auto___10853 = arguments.length;
  var i__8279__auto___10854 = 0;
  while (true) {
    if (i__8279__auto___10854 < len__8278__auto___10853) {
      args10822.push(arguments[i__8279__auto___10854]);
      var G__10855 = i__8279__auto___10854 + 1;
      i__8279__auto___10854 = G__10855;
      continue;
    } else {
    }
    break;
  }
  var G__10824 = args10822.length;
  switch(G__10824) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10822.length)].join(""));;
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__10857 = null;
        var G__10857__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10857__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10857__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i, input) : f.call(null, i, input);
          if (v == null) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
          }
        };
        G__10857 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10857__0.call(this);
            case 1:
              return G__10857__1.call(this, result);
            case 2:
              return G__10857__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10857.cljs$core$IFn$_invoke$arity$0 = G__10857__0;
        G__10857.cljs$core$IFn$_invoke$arity$1 = G__10857__1;
        G__10857.cljs$core$IFn$_invoke$arity$2 = G__10857__2;
        return G__10857;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__6753__auto__ = cljs.core.seq(coll__$1);
      if (temp__6753__auto__) {
        var s = temp__6753__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__8078__auto___10858 = size;
          var i_10859 = 0;
          while (true) {
            if (i_10859 < n__8078__auto___10858) {
              var x_10860 = function() {
                var G__10849 = idx + i_10859;
                var G__10850 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10859);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10849, G__10850) : f.call(null, G__10849, G__10850);
              }();
              if (x_10860 == null) {
              } else {
                cljs.core.chunk_append(b, x_10860);
              }
              var G__10861 = i_10859 + 1;
              i_10859 = G__10861;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__10851 = idx;
            var G__10852 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10851, G__10852) : f.call(null, G__10851, G__10852);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred(var_args) {
  var args10868 = [];
  var len__8278__auto___10875 = arguments.length;
  var i__8279__auto___10876 = 0;
  while (true) {
    if (i__8279__auto___10876 < len__8278__auto___10875) {
      args10868.push(arguments[i__8279__auto___10876]);
      var G__10877 = i__8279__auto___10876 + 1;
      i__8279__auto___10876 = G__10877;
      continue;
    } else {
    }
    break;
  }
  var G__10874 = args10868.length;
  switch(G__10874) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10868.slice(3), 0, null);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__8301__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          var and__7050__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
          if (cljs.core.truth_(and__7050__auto____$1)) {
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
          } else {
            return and__7050__auto____$1;
          }
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__10879__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__7050__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__7050__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__7050__auto__;
          }
        }());
      };
      var G__10879 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10880__i = 0, G__10880__a = new Array(arguments.length - 3);
          while (G__10880__i < G__10880__a.length) {
            G__10880__a[G__10880__i] = arguments[G__10880__i + 3];
            ++G__10880__i;
          }
          args = new cljs.core.IndexedSeq(G__10880__a, 0);
        }
        return G__10879__delegate.call(this, x, y, z, args);
      };
      G__10879.cljs$lang$maxFixedArity = 3;
      G__10879.cljs$lang$applyTo = function(arglist__10881) {
        var x = cljs.core.first(arglist__10881);
        arglist__10881 = cljs.core.next(arglist__10881);
        var y = cljs.core.first(arglist__10881);
        arglist__10881 = cljs.core.next(arglist__10881);
        var z = cljs.core.first(arglist__10881);
        var args = cljs.core.rest(arglist__10881);
        return G__10879__delegate(x, y, z, args);
      };
      G__10879.cljs$core$IFn$_invoke$arity$variadic = G__10879__delegate;
      return G__10879;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__10882 = null;
          if (arguments.length > 3) {
            var G__10883__i = 0, G__10883__a = new Array(arguments.length - 3);
            while (G__10883__i < G__10883__a.length) {
              G__10883__a[G__10883__i] = arguments[G__10883__i + 3];
              ++G__10883__i;
            }
            G__10882 = new cljs.core.IndexedSeq(G__10883__a, 0);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10882);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          var and__7050__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__7050__auto____$1)) {
            var and__7050__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(and__7050__auto____$2)) {
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
            } else {
              return and__7050__auto____$2;
            }
          } else {
            return and__7050__auto____$1;
          }
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          var and__7050__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__7050__auto____$1)) {
            var and__7050__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
            if (cljs.core.truth_(and__7050__auto____$2)) {
              var and__7050__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
              if (cljs.core.truth_(and__7050__auto____$3)) {
                var and__7050__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__7050__auto____$4)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                } else {
                  return and__7050__auto____$4;
                }
              } else {
                return and__7050__auto____$3;
              }
            } else {
              return and__7050__auto____$2;
            }
          } else {
            return and__7050__auto____$1;
          }
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__10884__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__7050__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__7050__auto__)) {
            return cljs.core.every_QMARK_(function(and__7050__auto__) {
              return function(p1__10862_SHARP_) {
                var and__7050__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10862_SHARP_) : p1.call(null, p1__10862_SHARP_);
                if (cljs.core.truth_(and__7050__auto____$1)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10862_SHARP_) : p2.call(null, p1__10862_SHARP_);
                } else {
                  return and__7050__auto____$1;
                }
              };
            }(and__7050__auto__), args);
          } else {
            return and__7050__auto__;
          }
        }());
      };
      var G__10884 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10885__i = 0, G__10885__a = new Array(arguments.length - 3);
          while (G__10885__i < G__10885__a.length) {
            G__10885__a[G__10885__i] = arguments[G__10885__i + 3];
            ++G__10885__i;
          }
          args = new cljs.core.IndexedSeq(G__10885__a, 0);
        }
        return G__10884__delegate.call(this, x, y, z, args);
      };
      G__10884.cljs$lang$maxFixedArity = 3;
      G__10884.cljs$lang$applyTo = function(arglist__10886) {
        var x = cljs.core.first(arglist__10886);
        arglist__10886 = cljs.core.next(arglist__10886);
        var y = cljs.core.first(arglist__10886);
        arglist__10886 = cljs.core.next(arglist__10886);
        var z = cljs.core.first(arglist__10886);
        var args = cljs.core.rest(arglist__10886);
        return G__10884__delegate(x, y, z, args);
      };
      G__10884.cljs$core$IFn$_invoke$arity$variadic = G__10884__delegate;
      return G__10884;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__10887 = null;
          if (arguments.length > 3) {
            var G__10888__i = 0, G__10888__a = new Array(arguments.length - 3);
            while (G__10888__i < G__10888__a.length) {
              G__10888__a[G__10888__i] = arguments[G__10888__i + 3];
              ++G__10888__i;
            }
            G__10887 = new cljs.core.IndexedSeq(G__10888__a, 0);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10887);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          var and__7050__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__7050__auto____$1)) {
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          } else {
            return and__7050__auto____$1;
          }
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          var and__7050__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__7050__auto____$1)) {
            var and__7050__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__7050__auto____$2)) {
              var and__7050__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__7050__auto____$3)) {
                var and__7050__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__7050__auto____$4)) {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                } else {
                  return and__7050__auto____$4;
                }
              } else {
                return and__7050__auto____$3;
              }
            } else {
              return and__7050__auto____$2;
            }
          } else {
            return and__7050__auto____$1;
          }
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__7050__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__7050__auto__)) {
          var and__7050__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__7050__auto____$1)) {
            var and__7050__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__7050__auto____$2)) {
              var and__7050__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__7050__auto____$3)) {
                var and__7050__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__7050__auto____$4)) {
                  var and__7050__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                  if (cljs.core.truth_(and__7050__auto____$5)) {
                    var and__7050__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                    if (cljs.core.truth_(and__7050__auto____$6)) {
                      var and__7050__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                      if (cljs.core.truth_(and__7050__auto____$7)) {
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                      } else {
                        return and__7050__auto____$7;
                      }
                    } else {
                      return and__7050__auto____$6;
                    }
                  } else {
                    return and__7050__auto____$5;
                  }
                } else {
                  return and__7050__auto____$4;
                }
              } else {
                return and__7050__auto____$3;
              }
            } else {
              return and__7050__auto____$2;
            }
          } else {
            return and__7050__auto____$1;
          }
        } else {
          return and__7050__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__10889__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__7050__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__7050__auto__)) {
            return cljs.core.every_QMARK_(function(and__7050__auto__) {
              return function(p1__10863_SHARP_) {
                var and__7050__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10863_SHARP_) : p1.call(null, p1__10863_SHARP_);
                if (cljs.core.truth_(and__7050__auto____$1)) {
                  var and__7050__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10863_SHARP_) : p2.call(null, p1__10863_SHARP_);
                  if (cljs.core.truth_(and__7050__auto____$2)) {
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__10863_SHARP_) : p3.call(null, p1__10863_SHARP_);
                  } else {
                    return and__7050__auto____$2;
                  }
                } else {
                  return and__7050__auto____$1;
                }
              };
            }(and__7050__auto__), args);
          } else {
            return and__7050__auto__;
          }
        }());
      };
      var G__10889 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10890__i = 0, G__10890__a = new Array(arguments.length - 3);
          while (G__10890__i < G__10890__a.length) {
            G__10890__a[G__10890__i] = arguments[G__10890__i + 3];
            ++G__10890__i;
          }
          args = new cljs.core.IndexedSeq(G__10890__a, 0);
        }
        return G__10889__delegate.call(this, x, y, z, args);
      };
      G__10889.cljs$lang$maxFixedArity = 3;
      G__10889.cljs$lang$applyTo = function(arglist__10891) {
        var x = cljs.core.first(arglist__10891);
        arglist__10891 = cljs.core.next(arglist__10891);
        var y = cljs.core.first(arglist__10891);
        arglist__10891 = cljs.core.next(arglist__10891);
        var z = cljs.core.first(arglist__10891);
        var args = cljs.core.rest(arglist__10891);
        return G__10889__delegate(x, y, z, args);
      };
      G__10889.cljs$core$IFn$_invoke$arity$variadic = G__10889__delegate;
      return G__10889;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__10892 = null;
          if (arguments.length > 3) {
            var G__10893__i = 0, G__10893__a = new Array(arguments.length - 3);
            while (G__10893__i < G__10893__a.length) {
              G__10893__a[G__10893__i] = arguments[G__10893__i + 3];
              ++G__10893__i;
            }
            G__10892 = new cljs.core.IndexedSeq(G__10893__a, 0);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10892);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__10864_SHARP_) {
            return p1__10864_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10864_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10864_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__10865_SHARP_) {
            var and__7050__auto__ = p1__10865_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10865_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10865_SHARP_.call(null, x);
            if (cljs.core.truth_(and__7050__auto__)) {
              return p1__10865_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10865_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10865_SHARP_.call(null, y);
            } else {
              return and__7050__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__10866_SHARP_) {
            var and__7050__auto__ = p1__10866_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10866_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10866_SHARP_.call(null, x);
            if (cljs.core.truth_(and__7050__auto__)) {
              var and__7050__auto____$1 = p1__10866_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10866_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10866_SHARP_.call(null, y);
              if (cljs.core.truth_(and__7050__auto____$1)) {
                return p1__10866_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10866_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__10866_SHARP_.call(null, z);
              } else {
                return and__7050__auto____$1;
              }
            } else {
              return and__7050__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__10894__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__7050__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__7050__auto__)) {
              return cljs.core.every_QMARK_(function(and__7050__auto__, ps__$1) {
                return function(p1__10867_SHARP_) {
                  return cljs.core.every_QMARK_(p1__10867_SHARP_, args);
                };
              }(and__7050__auto__, ps__$1), ps__$1);
            } else {
              return and__7050__auto__;
            }
          }());
        };
        var G__10894 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__10895__i = 0, G__10895__a = new Array(arguments.length - 3);
            while (G__10895__i < G__10895__a.length) {
              G__10895__a[G__10895__i] = arguments[G__10895__i + 3];
              ++G__10895__i;
            }
            args = new cljs.core.IndexedSeq(G__10895__a, 0);
          }
          return G__10894__delegate.call(this, x, y, z, args);
        };
        G__10894.cljs$lang$maxFixedArity = 3;
        G__10894.cljs$lang$applyTo = function(arglist__10896) {
          var x = cljs.core.first(arglist__10896);
          arglist__10896 = cljs.core.next(arglist__10896);
          var y = cljs.core.first(arglist__10896);
          arglist__10896 = cljs.core.next(arglist__10896);
          var z = cljs.core.first(arglist__10896);
          var args = cljs.core.rest(arglist__10896);
          return G__10894__delegate(x, y, z, args);
        };
        G__10894.cljs$core$IFn$_invoke$arity$variadic = G__10894__delegate;
        return G__10894;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__10897 = null;
            if (arguments.length > 3) {
              var G__10898__i = 0, G__10898__a = new Array(arguments.length - 3);
              while (G__10898__i < G__10898__a.length) {
                G__10898__a[G__10898__i] = arguments[G__10898__i + 3];
                ++G__10898__i;
              }
              G__10897 = new cljs.core.IndexedSeq(G__10898__a, 0);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10897);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq10869) {
  var G__10870 = cljs.core.first(seq10869);
  var seq10869__$1 = cljs.core.next(seq10869);
  var G__10871 = cljs.core.first(seq10869__$1);
  var seq10869__$2 = cljs.core.next(seq10869__$1);
  var G__10872 = cljs.core.first(seq10869__$2);
  var seq10869__$3 = cljs.core.next(seq10869__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__10870, G__10871, G__10872, seq10869__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn(var_args) {
  var args10905 = [];
  var len__8278__auto___10912 = arguments.length;
  var i__8279__auto___10913 = 0;
  while (true) {
    if (i__8279__auto___10913 < len__8278__auto___10912) {
      args10905.push(arguments[i__8279__auto___10913]);
      var G__10914 = i__8279__auto___10913 + 1;
      i__8279__auto___10913 = G__10914;
      continue;
    } else {
    }
    break;
  }
  var G__10911 = args10905.length;
  switch(G__10911) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10905.slice(3), 0, null);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__8301__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__7062__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__7062__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        var or__7062__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        if (cljs.core.truth_(or__7062__auto____$1)) {
          return or__7062__auto____$1;
        } else {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__10916__delegate = function(x, y, z, args) {
        var or__7062__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__7062__auto__)) {
          return or__7062__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__10916 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10917__i = 0, G__10917__a = new Array(arguments.length - 3);
          while (G__10917__i < G__10917__a.length) {
            G__10917__a[G__10917__i] = arguments[G__10917__i + 3];
            ++G__10917__i;
          }
          args = new cljs.core.IndexedSeq(G__10917__a, 0);
        }
        return G__10916__delegate.call(this, x, y, z, args);
      };
      G__10916.cljs$lang$maxFixedArity = 3;
      G__10916.cljs$lang$applyTo = function(arglist__10918) {
        var x = cljs.core.first(arglist__10918);
        arglist__10918 = cljs.core.next(arglist__10918);
        var y = cljs.core.first(arglist__10918);
        arglist__10918 = cljs.core.next(arglist__10918);
        var z = cljs.core.first(arglist__10918);
        var args = cljs.core.rest(arglist__10918);
        return G__10916__delegate(x, y, z, args);
      };
      G__10916.cljs$core$IFn$_invoke$arity$variadic = G__10916__delegate;
      return G__10916;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__10919 = null;
          if (arguments.length > 3) {
            var G__10920__i = 0, G__10920__a = new Array(arguments.length - 3);
            while (G__10920__i < G__10920__a.length) {
              G__10920__a[G__10920__i] = arguments[G__10920__i + 3];
              ++G__10920__i;
            }
            G__10919 = new cljs.core.IndexedSeq(G__10920__a, 0);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10919);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__7062__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__7062__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        var or__7062__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__7062__auto____$1)) {
          return or__7062__auto____$1;
        } else {
          var or__7062__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(or__7062__auto____$2)) {
            return or__7062__auto____$2;
          } else {
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__7062__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        var or__7062__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__7062__auto____$1)) {
          return or__7062__auto____$1;
        } else {
          var or__7062__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
          if (cljs.core.truth_(or__7062__auto____$2)) {
            return or__7062__auto____$2;
          } else {
            var or__7062__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(or__7062__auto____$3)) {
              return or__7062__auto____$3;
            } else {
              var or__7062__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__7062__auto____$4)) {
                return or__7062__auto____$4;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__10921__delegate = function(x, y, z, args) {
        var or__7062__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__7062__auto__)) {
          return or__7062__auto__;
        } else {
          return cljs.core.some(function(or__7062__auto__) {
            return function(p1__10899_SHARP_) {
              var or__7062__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10899_SHARP_) : p1.call(null, p1__10899_SHARP_);
              if (cljs.core.truth_(or__7062__auto____$1)) {
                return or__7062__auto____$1;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10899_SHARP_) : p2.call(null, p1__10899_SHARP_);
              }
            };
          }(or__7062__auto__), args);
        }
      };
      var G__10921 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10922__i = 0, G__10922__a = new Array(arguments.length - 3);
          while (G__10922__i < G__10922__a.length) {
            G__10922__a[G__10922__i] = arguments[G__10922__i + 3];
            ++G__10922__i;
          }
          args = new cljs.core.IndexedSeq(G__10922__a, 0);
        }
        return G__10921__delegate.call(this, x, y, z, args);
      };
      G__10921.cljs$lang$maxFixedArity = 3;
      G__10921.cljs$lang$applyTo = function(arglist__10923) {
        var x = cljs.core.first(arglist__10923);
        arglist__10923 = cljs.core.next(arglist__10923);
        var y = cljs.core.first(arglist__10923);
        arglist__10923 = cljs.core.next(arglist__10923);
        var z = cljs.core.first(arglist__10923);
        var args = cljs.core.rest(arglist__10923);
        return G__10921__delegate(x, y, z, args);
      };
      G__10921.cljs$core$IFn$_invoke$arity$variadic = G__10921__delegate;
      return G__10921;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__10924 = null;
          if (arguments.length > 3) {
            var G__10925__i = 0, G__10925__a = new Array(arguments.length - 3);
            while (G__10925__i < G__10925__a.length) {
              G__10925__a[G__10925__i] = arguments[G__10925__i + 3];
              ++G__10925__i;
            }
            G__10924 = new cljs.core.IndexedSeq(G__10925__a, 0);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10924);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__7062__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        var or__7062__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__7062__auto____$1)) {
          return or__7062__auto____$1;
        } else {
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__7062__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        var or__7062__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__7062__auto____$1)) {
          return or__7062__auto____$1;
        } else {
          var or__7062__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__7062__auto____$2)) {
            return or__7062__auto____$2;
          } else {
            var or__7062__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__7062__auto____$3)) {
              return or__7062__auto____$3;
            } else {
              var or__7062__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__7062__auto____$4)) {
                return or__7062__auto____$4;
              } else {
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__7062__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        var or__7062__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__7062__auto____$1)) {
          return or__7062__auto____$1;
        } else {
          var or__7062__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__7062__auto____$2)) {
            return or__7062__auto____$2;
          } else {
            var or__7062__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__7062__auto____$3)) {
              return or__7062__auto____$3;
            } else {
              var or__7062__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__7062__auto____$4)) {
                return or__7062__auto____$4;
              } else {
                var or__7062__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                if (cljs.core.truth_(or__7062__auto____$5)) {
                  return or__7062__auto____$5;
                } else {
                  var or__7062__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                  if (cljs.core.truth_(or__7062__auto____$6)) {
                    return or__7062__auto____$6;
                  } else {
                    var or__7062__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                    if (cljs.core.truth_(or__7062__auto____$7)) {
                      return or__7062__auto____$7;
                    } else {
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__10926__delegate = function(x, y, z, args) {
        var or__7062__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__7062__auto__)) {
          return or__7062__auto__;
        } else {
          return cljs.core.some(function(or__7062__auto__) {
            return function(p1__10900_SHARP_) {
              var or__7062__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__10900_SHARP_) : p1.call(null, p1__10900_SHARP_);
              if (cljs.core.truth_(or__7062__auto____$1)) {
                return or__7062__auto____$1;
              } else {
                var or__7062__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__10900_SHARP_) : p2.call(null, p1__10900_SHARP_);
                if (cljs.core.truth_(or__7062__auto____$2)) {
                  return or__7062__auto____$2;
                } else {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__10900_SHARP_) : p3.call(null, p1__10900_SHARP_);
                }
              }
            };
          }(or__7062__auto__), args);
        }
      };
      var G__10926 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__10927__i = 0, G__10927__a = new Array(arguments.length - 3);
          while (G__10927__i < G__10927__a.length) {
            G__10927__a[G__10927__i] = arguments[G__10927__i + 3];
            ++G__10927__i;
          }
          args = new cljs.core.IndexedSeq(G__10927__a, 0);
        }
        return G__10926__delegate.call(this, x, y, z, args);
      };
      G__10926.cljs$lang$maxFixedArity = 3;
      G__10926.cljs$lang$applyTo = function(arglist__10928) {
        var x = cljs.core.first(arglist__10928);
        arglist__10928 = cljs.core.next(arglist__10928);
        var y = cljs.core.first(arglist__10928);
        arglist__10928 = cljs.core.next(arglist__10928);
        var z = cljs.core.first(arglist__10928);
        var args = cljs.core.rest(arglist__10928);
        return G__10926__delegate(x, y, z, args);
      };
      G__10926.cljs$core$IFn$_invoke$arity$variadic = G__10926__delegate;
      return G__10926;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__10929 = null;
          if (arguments.length > 3) {
            var G__10930__i = 0, G__10930__a = new Array(arguments.length - 3);
            while (G__10930__i < G__10930__a.length) {
              G__10930__a[G__10930__i] = arguments[G__10930__i + 3];
              ++G__10930__i;
            }
            G__10929 = new cljs.core.IndexedSeq(G__10930__a, 0);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10929);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__10901_SHARP_) {
            return p1__10901_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10901_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10901_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__10902_SHARP_) {
            var or__7062__auto__ = p1__10902_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10902_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10902_SHARP_.call(null, x);
            if (cljs.core.truth_(or__7062__auto__)) {
              return or__7062__auto__;
            } else {
              return p1__10902_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10902_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10902_SHARP_.call(null, y);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__10903_SHARP_) {
            var or__7062__auto__ = p1__10903_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10903_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__10903_SHARP_.call(null, x);
            if (cljs.core.truth_(or__7062__auto__)) {
              return or__7062__auto__;
            } else {
              var or__7062__auto____$1 = p1__10903_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10903_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__10903_SHARP_.call(null, y);
              if (cljs.core.truth_(or__7062__auto____$1)) {
                return or__7062__auto____$1;
              } else {
                return p1__10903_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10903_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__10903_SHARP_.call(null, z);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__10931__delegate = function(x, y, z, args) {
          var or__7062__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__7062__auto__)) {
            return or__7062__auto__;
          } else {
            return cljs.core.some(function(or__7062__auto__, ps__$1) {
              return function(p1__10904_SHARP_) {
                return cljs.core.some(p1__10904_SHARP_, args);
              };
            }(or__7062__auto__, ps__$1), ps__$1);
          }
        };
        var G__10931 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__10932__i = 0, G__10932__a = new Array(arguments.length - 3);
            while (G__10932__i < G__10932__a.length) {
              G__10932__a[G__10932__i] = arguments[G__10932__i + 3];
              ++G__10932__i;
            }
            args = new cljs.core.IndexedSeq(G__10932__a, 0);
          }
          return G__10931__delegate.call(this, x, y, z, args);
        };
        G__10931.cljs$lang$maxFixedArity = 3;
        G__10931.cljs$lang$applyTo = function(arglist__10933) {
          var x = cljs.core.first(arglist__10933);
          arglist__10933 = cljs.core.next(arglist__10933);
          var y = cljs.core.first(arglist__10933);
          arglist__10933 = cljs.core.next(arglist__10933);
          var z = cljs.core.first(arglist__10933);
          var args = cljs.core.rest(arglist__10933);
          return G__10931__delegate(x, y, z, args);
        };
        G__10931.cljs$core$IFn$_invoke$arity$variadic = G__10931__delegate;
        return G__10931;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__10934 = null;
            if (arguments.length > 3) {
              var G__10935__i = 0, G__10935__a = new Array(arguments.length - 3);
              while (G__10935__i < G__10935__a.length) {
                G__10935__a[G__10935__i] = arguments[G__10935__i + 3];
                ++G__10935__i;
              }
              G__10934 = new cljs.core.IndexedSeq(G__10935__a, 0);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__10934);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq10906) {
  var G__10907 = cljs.core.first(seq10906);
  var seq10906__$1 = cljs.core.next(seq10906);
  var G__10908 = cljs.core.first(seq10906__$1);
  var seq10906__$2 = cljs.core.next(seq10906__$1);
  var G__10909 = cljs.core.first(seq10906__$2);
  var seq10906__$3 = cljs.core.next(seq10906__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__10907, G__10908, G__10909, seq10906__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map(var_args) {
  var args10937 = [];
  var len__8278__auto___10957 = arguments.length;
  var i__8279__auto___10958 = 0;
  while (true) {
    if (i__8279__auto___10958 < len__8278__auto___10957) {
      args10937.push(arguments[i__8279__auto___10958]);
      var G__10959 = i__8279__auto___10958 + 1;
      i__8279__auto___10958 = G__10959;
      continue;
    } else {
    }
    break;
  }
  var G__10944 = args10937.length;
  switch(G__10944) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args10937.slice(4), 0, null);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__8301__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__10961 = null;
      var G__10961__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__10961__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__10961__2 = function(result, input) {
        var G__10945 = result;
        var G__10946 = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10945, G__10946) : rf.call(null, G__10945, G__10946);
      };
      var G__10961__3 = function() {
        var G__10962__delegate = function(result, input, inputs) {
          var G__10947 = result;
          var G__10948 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10947, G__10948) : rf.call(null, G__10947, G__10948);
        };
        var G__10962 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__10963__i = 0, G__10963__a = new Array(arguments.length - 2);
            while (G__10963__i < G__10963__a.length) {
              G__10963__a[G__10963__i] = arguments[G__10963__i + 2];
              ++G__10963__i;
            }
            inputs = new cljs.core.IndexedSeq(G__10963__a, 0);
          }
          return G__10962__delegate.call(this, result, input, inputs);
        };
        G__10962.cljs$lang$maxFixedArity = 2;
        G__10962.cljs$lang$applyTo = function(arglist__10964) {
          var result = cljs.core.first(arglist__10964);
          arglist__10964 = cljs.core.next(arglist__10964);
          var input = cljs.core.first(arglist__10964);
          var inputs = cljs.core.rest(arglist__10964);
          return G__10962__delegate(result, input, inputs);
        };
        G__10962.cljs$core$IFn$_invoke$arity$variadic = G__10962__delegate;
        return G__10962;
      }();
      G__10961 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__10961__0.call(this);
          case 1:
            return G__10961__1.call(this, result);
          case 2:
            return G__10961__2.call(this, result, input);
          default:
            var G__10965 = null;
            if (arguments.length > 2) {
              var G__10966__i = 0, G__10966__a = new Array(arguments.length - 2);
              while (G__10966__i < G__10966__a.length) {
                G__10966__a[G__10966__i] = arguments[G__10966__i + 2];
                ++G__10966__i;
              }
              G__10965 = new cljs.core.IndexedSeq(G__10966__a, 0);
            }
            return G__10961__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__10965);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__10961.cljs$lang$maxFixedArity = 2;
      G__10961.cljs$lang$applyTo = G__10961__3.cljs$lang$applyTo;
      G__10961.cljs$core$IFn$_invoke$arity$0 = G__10961__0;
      G__10961.cljs$core$IFn$_invoke$arity$1 = G__10961__1;
      G__10961.cljs$core$IFn$_invoke$arity$2 = G__10961__2;
      G__10961.cljs$core$IFn$_invoke$arity$variadic = G__10961__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__10961;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6753__auto__ = cljs.core.seq(coll);
    if (temp__6753__auto__) {
      var s = temp__6753__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__8078__auto___10967 = size;
        var i_10968 = 0;
        while (true) {
          if (i_10968 < n__8078__auto___10967) {
            cljs.core.chunk_append(b, function() {
              var G__10949 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_10968);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10949) : f.call(null, G__10949);
            }());
            var G__10969 = i_10968 + 1;
            i_10968 = G__10969;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__10950 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10950) : f.call(null, G__10950);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__10951 = cljs.core.first(s1);
        var G__10952 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10951, G__10952) : f.call(null, G__10951, G__10952);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__10953 = cljs.core.first(s1);
        var G__10954 = cljs.core.first(s2);
        var G__10955 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10953, G__10954, G__10955) : f.call(null, G__10953, G__10954, G__10955);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__10936_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__10936_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq10938) {
  var G__10939 = cljs.core.first(seq10938);
  var seq10938__$1 = cljs.core.next(seq10938);
  var G__10940 = cljs.core.first(seq10938__$1);
  var seq10938__$2 = cljs.core.next(seq10938__$1);
  var G__10941 = cljs.core.first(seq10938__$2);
  var seq10938__$3 = cljs.core.next(seq10938__$2);
  var G__10942 = cljs.core.first(seq10938__$3);
  var seq10938__$4 = cljs.core.next(seq10938__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__10939, G__10940, G__10941, G__10942, seq10938__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take(var_args) {
  var args10970 = [];
  var len__8278__auto___10973 = arguments.length;
  var i__8279__auto___10974 = 0;
  while (true) {
    if (i__8279__auto___10974 < len__8278__auto___10973) {
      args10970.push(arguments[i__8279__auto___10974]);
      var G__10975 = i__8279__auto___10974 + 1;
      i__8279__auto___10974 = G__10975;
      continue;
    } else {
    }
    break;
  }
  var G__10972 = args10970.length;
  switch(G__10972) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10970.length)].join(""));;
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__10977 = null;
        var G__10977__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10977__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10977__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input) : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__10977 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10977__0.call(this);
            case 1:
              return G__10977__1.call(this, result);
            case 2:
              return G__10977__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10977.cljs$core$IFn$_invoke$arity$0 = G__10977__0;
        G__10977.cljs$core$IFn$_invoke$arity$1 = G__10977__1;
        G__10977.cljs$core$IFn$_invoke$arity$2 = G__10977__2;
        return G__10977;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__6753__auto__ = cljs.core.seq(coll);
      if (temp__6753__auto__) {
        var s = temp__6753__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop(var_args) {
  var args10978 = [];
  var len__8278__auto___10981 = arguments.length;
  var i__8279__auto___10982 = 0;
  while (true) {
    if (i__8279__auto___10982 < len__8278__auto___10981) {
      args10978.push(arguments[i__8279__auto___10982]);
      var G__10983 = i__8279__auto___10982 + 1;
      i__8279__auto___10982 = G__10983;
      continue;
    } else {
    }
    break;
  }
  var G__10980 = args10978.length;
  switch(G__10980) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10978.length)].join(""));;
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__10985 = null;
        var G__10985__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__10985__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__10985__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__10985 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__10985__0.call(this);
            case 1:
              return G__10985__1.call(this, result);
            case 2:
              return G__10985__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__10985.cljs$core$IFn$_invoke$arity$0 = G__10985__0;
        G__10985.cljs$core$IFn$_invoke$arity$1 = G__10985__1;
        G__10985.cljs$core$IFn$_invoke$arity$2 = G__10985__2;
        return G__10985;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__10986 = n__$1 - 1;
        var G__10987 = cljs.core.rest(s);
        n__$1 = G__10986;
        coll__$1 = G__10987;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last(var_args) {
  var args10988 = [];
  var len__8278__auto___10991 = arguments.length;
  var i__8279__auto___10992 = 0;
  while (true) {
    if (i__8279__auto___10992 < len__8278__auto___10991) {
      args10988.push(arguments[i__8279__auto___10992]);
      var G__10993 = i__8279__auto___10992 + 1;
      i__8279__auto___10992 = G__10993;
      continue;
    } else {
    }
    break;
  }
  var G__10990 = args10988.length;
  switch(G__10990) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10988.length)].join(""));;
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__10995 = cljs.core.next(s);
      var G__10996 = cljs.core.next(lead);
      s = G__10995;
      lead = G__10996;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while(var_args) {
  var args10997 = [];
  var len__8278__auto___11002 = arguments.length;
  var i__8279__auto___11003 = 0;
  while (true) {
    if (i__8279__auto___11003 < len__8278__auto___11002) {
      args10997.push(arguments[i__8279__auto___11003]);
      var G__11004 = i__8279__auto___11003 + 1;
      i__8279__auto___11003 = G__11004;
      continue;
    } else {
    }
    break;
  }
  var G__10999 = args10997.length;
  switch(G__10999) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args10997.length)].join(""));;
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__11006 = null;
        var G__11006__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11006__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__11006__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__7050__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__7050__auto__)) {
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input);
            } else {
              return and__7050__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__11006 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11006__0.call(this);
            case 1:
              return G__11006__1.call(this, result);
            case 2:
              return G__11006__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11006.cljs$core$IFn$_invoke$arity$0 = G__11006__0;
        G__11006.cljs$core$IFn$_invoke$arity$1 = G__11006__1;
        G__11006.cljs$core$IFn$_invoke$arity$2 = G__11006__2;
        return G__11006;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__7050__auto__ = s;
        if (and__7050__auto__) {
          var G__11001 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__11001) : pred__$1.call(null, G__11001);
        } else {
          return and__7050__auto__;
        }
      }())) {
        var G__11007 = pred__$1;
        var G__11008 = cljs.core.rest(s);
        pred__$1 = G__11007;
        coll__$1 = G__11008;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6753__auto__ = cljs.core.seq(coll);
    if (temp__6753__auto__) {
      var s = temp__6753__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs.core.cycle.cljs$core$IFn$_invoke$arity$1 ? cljs.core.cycle.cljs$core$IFn$_invoke$arity$1(s) : cljs.core.cycle.call(null, s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat(var_args) {
  var args11009 = [];
  var len__8278__auto___11012 = arguments.length;
  var i__8279__auto___11013 = 0;
  while (true) {
    if (i__8279__auto___11013 < len__8278__auto___11012) {
      args11009.push(arguments[i__8279__auto___11013]);
      var G__11014 = i__8279__auto___11013 + 1;
      i__8279__auto___11013 = G__11014;
      continue;
    } else {
    }
    break;
  }
  var G__11011 = args11009.length;
  switch(G__11011) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11009.length)].join(""));;
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly(var_args) {
  var args11016 = [];
  var len__8278__auto___11019 = arguments.length;
  var i__8279__auto___11020 = 0;
  while (true) {
    if (i__8279__auto___11020 < len__8278__auto___11019) {
      args11016.push(arguments[i__8279__auto___11020]);
      var G__11021 = i__8279__auto___11020 + 1;
      i__8279__auto___11020 = G__11021;
      continue;
    } else {
    }
    break;
  }
  var G__11018 = args11016.length;
  switch(G__11018) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11016.length)].join(""));;
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    var G__11025 = f;
    var G__11026 = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x);
    return cljs.core.iterate.cljs$core$IFn$_invoke$arity$2 ? cljs.core.iterate.cljs$core$IFn$_invoke$arity$2(G__11025, G__11026) : cljs.core.iterate.call(null, G__11025, G__11026);
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave(var_args) {
  var args11027 = [];
  var len__8278__auto___11033 = arguments.length;
  var i__8279__auto___11034 = 0;
  while (true) {
    if (i__8279__auto___11034 < len__8278__auto___11033) {
      args11027.push(arguments[i__8279__auto___11034]);
      var G__11035 = i__8279__auto___11034 + 1;
      i__8279__auto___11034 = G__11035;
      continue;
    } else {
    }
    break;
  }
  var G__11032 = args11027.length;
  switch(G__11032) {
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args11027.slice(2), 0, null);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__8301__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq11028) {
  var G__11029 = cljs.core.first(seq11028);
  var seq11028__$1 = cljs.core.next(seq11028);
  var G__11030 = cljs.core.first(seq11028__$1);
  var seq11028__$2 = cljs.core.next(seq11028__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__11029, G__11030, seq11028__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose(var_args) {
  var args11037 = [];
  var len__8278__auto___11040 = arguments.length;
  var i__8279__auto___11041 = 0;
  while (true) {
    if (i__8279__auto___11041 < len__8278__auto___11040) {
      args11037.push(arguments[i__8279__auto___11041]);
      var G__11042 = i__8279__auto___11041 + 1;
      i__8279__auto___11041 = G__11042;
      continue;
    } else {
    }
    break;
  }
  var G__11039 = args11037.length;
  switch(G__11039) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11037.length)].join(""));;
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__11044 = null;
        var G__11044__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__11044__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__11044__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, sep) : rf.call(null, result, sep);
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr, input) : rf.call(null, sepr, input);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__11044 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__11044__0.call(this);
            case 1:
              return G__11044__1.call(this, result);
            case 2:
              return G__11044__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__11044.cljs$core$IFn$_invoke$arity$0 = G__11044__0;
        G__11044.cljs$core$IFn$_invoke$arity$1 = G__11044__1;
        G__11044.cljs$core$IFn$_invoke$arity$2 = G__11044__2;
        return G__11044;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__6751__auto__ = cljs.core.seq(coll);
      if (temp__6751__auto__) {
        var coll__$1 = temp__6751__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat(var_args) {
  var args11053 = [];
  var len__8278__auto___11058 = arguments.length;
  var i__8279__auto___11059 = 0;
  while (true) {
    if (i__8279__auto___11059 < len__8278__auto___11058) {
      args11053.push(arguments[i__8279__auto___11059]);
      var G__11060 = i__8279__auto___11059 + 1;
      i__8279__auto___11059 = G__11060;
      continue;
    } else {
    }
    break;
  }
  var G__11057 = args11053.length;
  switch(G__11057) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args11053.slice(1), 0, null);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__8301__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq11054) {
  var G__11055 = cljs.core.first(seq11054);
  var seq11054__$1 = cljs.core.next(seq11054);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__11055, seq11054__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter(var_args) {
  var args11062 = [];
  var len__8278__auto___11066 = arguments.length;
  var i__8279__auto___11067 = 0;
  while (true) {
    if (i__8279__auto___11067 < len__8278__auto___11066) {
      args11062.push(arguments[i__8279__auto___11067]);
      var G__11068 = i__8279__auto___11067 + 1;
      i__8279__auto___11067 = G__11068;
      continue;
    } else {
    }
    break;
  }
  var G__11064 = args11062.length;
  switch(G__11064) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11062.length)].join(""));;
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__11070 = null;
      var G__11070__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__11070__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__11070__2 = function(result, input) {
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input))) {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
        } else {
          return result;
        }
      };
      G__11070 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__11070__0.call(this);
          case 1:
            return G__11070__1.call(this, result);
          case 2:
            return G__11070__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__11070.cljs$core$IFn$_invoke$arity$0 = G__11070__0;
      G__11070.cljs$core$IFn$_invoke$arity$1 = G__11070__1;
      G__11070.cljs$core$IFn$_invoke$arity$2 = G__11070__2;
      return G__11070;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6753__auto__ = cljs.core.seq(coll);
    if (temp__6753__auto__) {
      var s = temp__6753__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__8078__auto___11071 = size;
        var i_11072 = 0;
        while (true) {
          if (i_11072 < n__8078__auto___11071) {
            if (cljs.core.truth_(function() {
              var G__11065 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11072);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11065) : pred.call(null, G__11065);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_11072));
            } else {
            }
            var G__11073 = i_11072 + 1;
            i_11072 = G__11073;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null, f))) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove(var_args) {
  var args11074 = [];
  var len__8278__auto___11077 = arguments.length;
  var i__8279__auto___11078 = 0;
  while (true) {
    if (i__8279__auto___11078 < len__8278__auto___11077) {
      args11074.push(arguments[i__8279__auto___11078]);
      var G__11079 = i__8279__auto___11078 + 1;
      i__8279__auto___11078 = G__11079;
      continue;
    } else {
    }
    break;
  }
  var G__11076 = args11074.length;
  switch(G__11076) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11074.length)].join(""));;
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null, node)) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null, node)], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__11081_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__11081_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into(var_args) {
  var args11082 = [];
  var len__8278__auto___11087 = arguments.length;
  var i__8279__auto___11088 = 0;
  while (true) {
    if (i__8279__auto___11088 < len__8278__auto___11087) {
      args11082.push(arguments[i__8279__auto___11088]);
      var G__11089 = i__8279__auto___11088 + 1;
      i__8279__auto___11088 = G__11089;
      continue;
    } else {
    }
    break;
  }
  var G__11084 = args11082.length;
  switch(G__11084) {
    case 0:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11082.length)].join(""));;
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.into.cljs$core$IFn$_invoke$arity$1 = function(to) {
  return to;
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$ ? true : false : false) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$ ? true : false : false) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv(var_args) {
  var args11091 = [];
  var len__8278__auto___11099 = arguments.length;
  var i__8279__auto___11100 = 0;
  while (true) {
    if (i__8279__auto___11100 < len__8278__auto___11099) {
      args11091.push(arguments[i__8279__auto___11100]);
      var G__11101 = i__8279__auto___11100 + 1;
      i__8279__auto___11100 = G__11101;
      continue;
    } else {
    }
    break;
  }
  var G__11098 = args11091.length;
  switch(G__11098) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args11091.slice(4), 0, null);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__8301__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null, o));
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq11092) {
  var G__11093 = cljs.core.first(seq11092);
  var seq11092__$1 = cljs.core.next(seq11092);
  var G__11094 = cljs.core.first(seq11092__$1);
  var seq11092__$2 = cljs.core.next(seq11092__$1);
  var G__11095 = cljs.core.first(seq11092__$2);
  var seq11092__$3 = cljs.core.next(seq11092__$2);
  var G__11096 = cljs.core.first(seq11092__$3);
  var seq11092__$4 = cljs.core.next(seq11092__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__11093, G__11094, G__11095, G__11096, seq11092__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null, o))) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition(var_args) {
  var args11103 = [];
  var len__8278__auto___11106 = arguments.length;
  var i__8279__auto___11107 = 0;
  while (true) {
    if (i__8279__auto___11107 < len__8278__auto___11106) {
      args11103.push(arguments[i__8279__auto___11107]);
      var G__11108 = i__8279__auto___11107 + 1;
      i__8279__auto___11107 = G__11108;
      continue;
    } else {
    }
    break;
  }
  var G__11105 = args11103.length;
  switch(G__11105) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11103.length)].join(""));;
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6753__auto__ = cljs.core.seq(coll);
    if (temp__6753__auto__) {
      var s = temp__6753__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6753__auto__ = cljs.core.seq(coll);
    if (temp__6753__auto__) {
      var s = temp__6753__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        var x__7991__auto__ = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad));
        return cljs.core._conj(cljs.core.List.EMPTY, x__7991__auto__);
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in(var_args) {
  var args11110 = [];
  var len__8278__auto___11113 = arguments.length;
  var i__8279__auto___11114 = 0;
  while (true) {
    if (i__8279__auto___11114 < len__8278__auto___11113) {
      args11110.push(arguments[i__8279__auto___11114]);
      var G__11115 = i__8279__auto___11114 + 1;
      i__8279__auto___11114 = G__11115;
      continue;
    } else {
    }
    break;
  }
  var G__11112 = args11110.length;
  switch(G__11112) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11110.length)].join(""));;
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get, m, ks);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (!(ks__$1 == null)) {
      var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
      if (sentinel === m__$2) {
        return not_found;
      } else {
        var G__11117 = sentinel;
        var G__11118 = m__$2;
        var G__11119 = cljs.core.next(ks__$1);
        sentinel = G__11117;
        m__$1 = G__11118;
        ks__$1 = G__11119;
        continue;
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__11120, v) {
  var vec__11127 = p__11120;
  var seq__11128 = cljs.core.seq(vec__11127);
  var first__11129 = cljs.core.first(seq__11128);
  var seq__11128__$1 = cljs.core.next(seq__11128);
  var k = first__11129;
  var ks = seq__11128__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11130 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__11131 = ks;
      var G__11132 = v;
      return cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__11130, G__11131, G__11132) : cljs.core.assoc_in.call(null, G__11130, G__11131, G__11132);
    }());
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in(var_args) {
  var args11133 = [];
  var len__8278__auto___11173 = arguments.length;
  var i__8279__auto___11174 = 0;
  while (true) {
    if (i__8279__auto___11174 < len__8278__auto___11173) {
      args11133.push(arguments[i__8279__auto___11174]);
      var G__11175 = i__8279__auto___11174 + 1;
      i__8279__auto___11174 = G__11175;
      continue;
    } else {
    }
    break;
  }
  var G__11142 = args11133.length;
  switch(G__11142) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args11133.slice(6), 0, null);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__8301__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__11143, f) {
  var vec__11144 = p__11143;
  var seq__11145 = cljs.core.seq(vec__11144);
  var first__11146 = cljs.core.first(seq__11145);
  var seq__11145__$1 = cljs.core.next(seq__11145);
  var k = first__11146;
  var ks = seq__11145__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11147 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11147) : f.call(null, G__11147);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__11148, f, a) {
  var vec__11149 = p__11148;
  var seq__11150 = cljs.core.seq(vec__11149);
  var first__11151 = cljs.core.first(seq__11150);
  var seq__11150__$1 = cljs.core.next(seq__11150);
  var k = first__11151;
  var ks = seq__11150__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__11153 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11152, G__11153) : f.call(null, G__11152, G__11153);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__11154, f, a, b) {
  var vec__11155 = p__11154;
  var seq__11156 = cljs.core.seq(vec__11155);
  var first__11157 = cljs.core.first(seq__11156);
  var seq__11156__$1 = cljs.core.next(seq__11156);
  var k = first__11157;
  var ks = seq__11156__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__11159 = a;
      var G__11160 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11158, G__11159, G__11160) : f.call(null, G__11158, G__11159, G__11160);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__11161, f, a, b, c) {
  var vec__11162 = p__11161;
  var seq__11163 = cljs.core.seq(vec__11162);
  var first__11164 = cljs.core.first(seq__11163);
  var seq__11163__$1 = cljs.core.next(seq__11163);
  var k = first__11164;
  var ks = seq__11163__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__11165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__11166 = a;
      var G__11167 = b;
      var G__11168 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11165, G__11166, G__11167, G__11168) : f.call(null, G__11165, G__11166, G__11167, G__11168);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__11169, f, a, b, c, args) {
  var vec__11170 = p__11169;
  var seq__11171 = cljs.core.seq(vec__11170);
  var first__11172 = cljs.core.first(seq__11171);
  var seq__11171__$1 = cljs.core.next(seq__11171);
  var k = first__11172;
  var ks = seq__11171__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq11134) {
  var G__11135 = cljs.core.first(seq11134);
  var seq11134__$1 = cljs.core.next(seq11134);
  var G__11136 = cljs.core.first(seq11134__$1);
  var seq11134__$2 = cljs.core.next(seq11134__$1);
  var G__11137 = cljs.core.first(seq11134__$2);
  var seq11134__$3 = cljs.core.next(seq11134__$2);
  var G__11138 = cljs.core.first(seq11134__$3);
  var seq11134__$4 = cljs.core.next(seq11134__$3);
  var G__11139 = cljs.core.first(seq11134__$4);
  var seq11134__$5 = cljs.core.next(seq11134__$4);
  var G__11140 = cljs.core.first(seq11134__$5);
  var seq11134__$6 = cljs.core.next(seq11134__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__11135, G__11136, G__11137, G__11138, G__11139, G__11140, seq11134__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update(var_args) {
  var args11177 = [];
  var len__8278__auto___11197 = arguments.length;
  var i__8279__auto___11198 = 0;
  while (true) {
    if (i__8279__auto___11198 < len__8278__auto___11197) {
      args11177.push(arguments[i__8279__auto___11198]);
      var G__11199 = i__8279__auto___11198 + 1;
      i__8279__auto___11198 = G__11199;
      continue;
    } else {
    }
    break;
  }
  var G__11186 = args11177.length;
  switch(G__11186) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__8301__auto__ = new cljs.core.IndexedSeq(args11177.slice(6), 0, null);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__8301__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11187 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11187) : f.call(null, G__11187);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11188 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__11189 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11188, G__11189) : f.call(null, G__11188, G__11189);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__11191 = x;
    var G__11192 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11190, G__11191, G__11192) : f.call(null, G__11190, G__11191, G__11192);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__11193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__11194 = x;
    var G__11195 = y;
    var G__11196 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11193, G__11194, G__11195, G__11196) : f.call(null, G__11193, G__11194, G__11195, G__11196);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq11178) {
  var G__11179 = cljs.core.first(seq11178);
  var seq11178__$1 = cljs.core.next(seq11178);
  var G__11180 = cljs.core.first(seq11178__$1);
  var seq11178__$2 = cljs.core.next(seq11178__$1);
  var G__11181 = cljs.core.first(seq11178__$2);
  var seq11178__$3 = cljs.core.next(seq11178__$2);
  var G__11182 = cljs.core.first(seq11178__$3);
  var seq11178__$4 = cljs.core.next(seq11178__$3);
  var G__11183 = cljs.core.first(seq11178__$4);
  var seq11178__$5 = cljs.core.next(seq11178__$4);
  var G__11184 = cljs.core.first(seq11178__$5);
  var seq11178__$6 = cljs.core.next(seq11178__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__11179, G__11180, G__11181, G__11182, G__11183, G__11184, seq11178__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__11201 = ll - 5;
      var G__11202 = r;
      ll = G__11201;
      ret = G__11202;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = function() {
        var G__11207 = pv;
        var G__11208 = level - 5;
        var G__11209 = child;
        var G__11210 = tailnode;
        return cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__11207, G__11208, G__11209, G__11210) : cljs.core.push_tail.call(null, G__11207, G__11208, G__11209, G__11210);
      }();
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__11211 = cljs.core.pv_aget(node, 0);
      var G__11212 = level - 5;
      node = G__11211;
      level = G__11212;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__11213 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__11214 = level - 5;
        node = G__11213;
        level = G__11214;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, function() {
      var G__11220 = pv;
      var G__11221 = level - 5;
      var G__11222 = cljs.core.pv_aget(node, subidx);
      var G__11223 = i;
      var G__11224 = val;
      return cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__11220, G__11221, G__11222, G__11223, G__11224) : cljs.core.do_assoc.call(null, G__11220, G__11221, G__11222, G__11223, G__11224);
    }());
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = function() {
      var G__11228 = pv;
      var G__11229 = level - 5;
      var G__11230 = cljs.core.pv_aget(node, subidx);
      return cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__11228, G__11229, G__11230) : cljs.core.pop_tail.call(null, G__11228, G__11229, G__11230);
    }();
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.indexOf = function() {
  var G__11241 = null;
  var G__11241__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11241__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11241 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11241__1.call(this, x);
      case 2:
        return G__11241__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11241.cljs$core$IFn$_invoke$arity$1 = G__11241__1;
  G__11241.cljs$core$IFn$_invoke$arity$2 = G__11241__2;
  return G__11241;
}();
cljs.core.PersistentVector.prototype.lastIndexOf = function() {
  var G__11242 = null;
  var G__11242__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11242__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11242 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11242__1.call(this, x);
      case 2:
        return G__11242__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11242.cljs$core$IFn$_invoke$arity$1 = G__11242__1;
  G__11242.cljs$core$IFn$_invoke$arity$2 = G__11242__2;
  return G__11242;
}();
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__11232 = init__$2;
              var G__11233 = j + i;
              var G__11234 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11232, G__11233, G__11234) : f.call(null, G__11232, G__11233, G__11234);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__11243 = j + 1;
              var G__11244 = init__$3;
              j = G__11243;
              init__$2 = G__11244;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__11245 = i + len;
        var G__11246 = init__$2;
        i = G__11245;
        init__$1 = G__11246;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return cljs.core._conj(coll__$1, val);
    } else {
      throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds  [0,"), cljs.core.str(self__.cnt), cljs.core.str("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = cljs.core._iterator(coll__$1);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (cljs.core.truth_(me_iter.hasNext())) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null, self__.root), cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null, self__.tail));
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__11235 = init__$2;
              var G__11236 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11235, G__11236) : f.call(null, G__11235, G__11236);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__11247 = j + 1;
              var G__11248 = init__$3;
              j = G__11247;
              init__$2 = G__11248;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__11249 = i + len;
        var G__11250 = init__$2;
        i = G__11249;
        init__$1 = G__11250;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._assoc_n(coll__$1, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0, null);
    } else {
      var G__11237 = coll__$1;
      var G__11238 = cljs.core.first_array_for_longvec(coll__$1);
      var G__11239 = 0;
      var G__11240 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11237, G__11238, G__11239, G__11240) : cljs.core.chunked_seq.call(null, G__11237, G__11238, G__11239, G__11240);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__8078__auto___11251 = len;
    var i_11252 = 0;
    while (true) {
      if (i_11252 < n__8078__auto___11251) {
        new_tail[i_11252] = self__.tail[i_11252];
        var G__11253 = i_11252 + 1;
        i_11252 = G__11253;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__11254 = null;
  var G__11254__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__11254__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__11254 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11254__2.call(this, self__, k);
      case 3:
        return G__11254__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11254.cljs$core$IFn$_invoke$arity$2 = G__11254__2;
  G__11254.cljs$core$IFn$_invoke$arity$3 = G__11254__3;
  return G__11254;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args11231) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11231)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__11255 = i + 1;
        var G__11256 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__11255;
        out = G__11256;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector(var_args) {
  var args__8285__auto__ = [];
  var len__8278__auto___11258 = arguments.length;
  var i__8279__auto___11259 = 0;
  while (true) {
    if (i__8279__auto___11259 < len__8278__auto___11258) {
      args__8285__auto__.push(arguments[i__8279__auto___11259]);
      var G__11260 = i__8279__auto___11259 + 1;
      i__8279__auto___11259 = G__11260;
      continue;
    } else {
    }
    break;
  }
  var argseq__8286__auto__ = 0 < args__8285__auto__.length ? new cljs.core.IndexedSeq(args__8285__auto__.slice(0), 0, null) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__8286__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq11257) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq11257));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.indexOf = function() {
  var G__11283 = null;
  var G__11283__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11283__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11283 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11283__1.call(this, x);
      case 2:
        return G__11283__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11283.cljs$core$IFn$_invoke$arity$1 = G__11283__1;
  G__11283.cljs$core$IFn$_invoke$arity$2 = G__11283__2;
  return G__11283;
}();
cljs.core.ChunkedSeq.prototype.lastIndexOf = function() {
  var G__11284 = null;
  var G__11284__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11284__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11284 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11284__1.call(this, x);
      case 2:
        return G__11284__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11284.cljs$core$IFn$_invoke$arity$1 = G__11284__1;
  G__11284.cljs$core$IFn$_invoke$arity$2 = G__11284__2;
  return G__11284;
}();
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__11261 = self__.vec;
      var G__11262 = self__.node;
      var G__11263 = self__.i;
      var G__11264 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11261, G__11262, G__11263, G__11264) : cljs.core.chunked_seq.call(null, G__11261, G__11262, G__11263, G__11264);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_next(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__11265 = self__.vec;
    var G__11266 = self__.i + self__.off;
    var G__11267 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11265, G__11266, G__11267) : cljs.core.subvec.call(null, G__11265, G__11266, G__11267);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__11268 = self__.vec;
    var G__11269 = self__.i + self__.off;
    var G__11270 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11268, G__11269, G__11270) : cljs.core.subvec.call(null, G__11268, G__11269, G__11270);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__11271 = self__.vec;
      var G__11272 = self__.node;
      var G__11273 = self__.i;
      var G__11274 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11271, G__11272, G__11273, G__11274) : cljs.core.chunked_seq.call(null, G__11271, G__11272, G__11273, G__11274);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_rest(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__11275 = self__.vec;
    var G__11276 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__11277 = end;
    var G__11278 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11275, G__11276, G__11277, G__11278) : cljs.core.chunked_seq.call(null, G__11275, G__11276, G__11277, G__11278);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec, self__.node, self__.i, self__.off, m) : cljs.core.chunked_seq.call(null, self__.vec, self__.node, self__.i, self__.off, m);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__11279 = self__.vec;
    var G__11280 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__11281 = end;
    var G__11282 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11279, G__11280, G__11281, G__11282) : cljs.core.chunked_seq.call(null, G__11279, G__11280, G__11281, G__11282);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq(var_args) {
  var args11285 = [];
  var len__8278__auto___11288 = arguments.length;
  var i__8279__auto___11289 = 0;
  while (true) {
    if (i__8279__auto___11289 < len__8278__auto___11288) {
      args11285.push(arguments[i__8279__auto___11289]);
      var G__11290 = i__8279__auto___11289 + 1;
      i__8279__auto___11289 = G__11290;
      continue;
    } else {
    }
    break;
  }
  var G__11287 = args11285.length;
  switch(G__11287) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11285.length)].join(""));;
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.indexOf = function() {
  var G__11312 = null;
  var G__11312__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11312__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__11312 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__11312__1.call(this, x);
      case 2:
        return G__11312__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11312.cljs$core$IFn$_invoke$arity$1 = G__11312__1;
  G__11312.cljs$core$IFn$_invoke$arity$2 = G__11312__2;
  return G__11312;
}();
cljs.core.Subvec.prototype.lastIndexOf = function() {
  var G__11313 = null;
  var G__11313__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11313__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__11313 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__11313__1.call(this, x);
      case 2:
        return G__11313__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11313.cljs$core$IFn$_invoke$arity$1 = G__11313__1;
  G__11313.cljs$core$IFn$_invoke$arity$2 = G__11313__2;
  return G__11313;
}();
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__11293 = init__$1;
        var G__11294 = j;
        var G__11295 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11293, G__11294, G__11295) : f.call(null, G__11293, G__11294, G__11295);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__11314 = i + 1;
        var G__11315 = j + 1;
        var G__11316 = init__$2;
        i = G__11314;
        j = G__11315;
        init__$1 = G__11316;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  var G__11296 = self__.meta;
  var G__11297 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
  var G__11298 = self__.start;
  var G__11299 = function() {
    var x__7395__auto__ = self__.end;
    var y__7396__auto__ = v_pos + 1;
    return x__7395__auto__ > y__7396__auto__ ? x__7395__auto__ : y__7396__auto__;
  }();
  var G__11300 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11296, G__11297, G__11298, G__11299, G__11300) : cljs.core.build_subvec.call(null, G__11296, G__11297, G__11298, G__11299, G__11300);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__11301 = self__.meta;
    var G__11302 = self__.v;
    var G__11303 = self__.start;
    var G__11304 = self__.end - 1;
    var G__11305 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11301, G__11302, G__11303, G__11304, G__11305) : cljs.core.build_subvec.call(null, G__11301, G__11302, G__11303, G__11304, G__11305);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n(coll__$1, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1, self__.v, self__.start, self__.end, self__.__hash) : cljs.core.build_subvec.call(null, meta__$1, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__11307 = self__.meta;
  var G__11308 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__11309 = self__.start;
  var G__11310 = self__.end + 1;
  var G__11311 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11307, G__11308, G__11309, G__11310, G__11311) : cljs.core.build_subvec.call(null, G__11307, G__11308, G__11309, G__11310, G__11311);
};
cljs.core.Subvec.prototype.call = function() {
  var G__11317 = null;
  var G__11317__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__11317__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__11317 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11317__2.call(this, self__, k);
      case 3:
        return G__11317__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11317.cljs$core$IFn$_invoke$arity$2 = G__11317__2;
  G__11317.cljs$core$IFn$_invoke$arity$3 = G__11317__3;
  return G__11317;
}();
cljs.core.Subvec.prototype.apply = function(self__, args11292) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11292)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__11318 = meta;
      var G__11319 = v.v;
      var G__11320 = v.start + start;
      var G__11321 = v.start + end;
      var G__11322 = __hash;
      meta = G__11318;
      v = G__11319;
      start = G__11320;
      end = G__11321;
      __hash = G__11322;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec(var_args) {
  var args11323 = [];
  var len__8278__auto___11326 = arguments.length;
  var i__8279__auto___11327 = 0;
  while (true) {
    if (i__8279__auto___11327 < len__8278__auto___11326) {
      args11323.push(arguments[i__8279__auto___11327]);
      var G__11328 = i__8279__auto___11327 + 1;
      i__8279__auto___11327 = G__11328;
      continue;
    } else {
    }
    break;
  }
  var G__11325 = args11323.length;
  switch(G__11325) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11323.length)].join(""));;
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      var G__11338 = tv;
      var G__11339 = level - 5;
      var G__11340 = child;
      var G__11341 = tail_node;
      return cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__11338, G__11339, G__11340, G__11341) : cljs.core.tv_push_tail.call(null, G__11338, G__11339, G__11340, G__11341);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = function() {
      var G__11345 = tv;
      var G__11346 = level - 5;
      var G__11347 = cljs.core.pv_aget(node__$1, subidx);
      return cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__11345, G__11346, G__11347) : cljs.core.tv_pop_tail.call(null, G__11345, G__11346, G__11347);
    }();
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__11348 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__11349 = level - 5;
        node = G__11348;
        level = G__11349;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n_BANG_(tcoll__$1, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return cljs.core._conj_BANG_(tcoll__$1, val);
      } else {
        throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__11353 = null;
  var G__11353__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__11353__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__11353 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11353__2.call(this, self__, k);
      case 3:
        return G__11353__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11353.cljs$core$IFn$_invoke$arity$2 = G__11353__2;
  G__11353.cljs$core$IFn$_invoke$arity$3 = G__11353__3;
  return G__11353;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args11350) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11350)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueIter = function(fseq, riter) {
  this.fseq = fseq;
  this.riter = riter;
};
cljs.core.PersistentQueueIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__7062__auto__ = cljs.core.some_QMARK_(self__.fseq) && cljs.core.seq(self__.fseq);
  if (or__7062__auto__) {
    return or__7062__auto__;
  } else {
    var and__7050__auto__ = cljs.core.some_QMARK_(self__.riter);
    if (and__7050__auto__) {
      return self__.riter.hasNext();
    } else {
      return and__7050__auto__;
    }
  }
};
cljs.core.PersistentQueueIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (cljs.core.some_QMARK_(self__.fseq)) {
    var ret = cljs.core.first(self__.fseq);
    self__.fseq = cljs.core.next(self__.fseq);
    return ret;
  } else {
    if (cljs.core.some_QMARK_(self__.riter) && self__.riter.hasNext()) {
      return self__.riter.next();
    } else {
      throw new Error("No such element");
    }
  }
};
cljs.core.PersistentQueueIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.PersistentQueueIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "fseq", "fseq", -1466412450, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "riter", "riter", -237834262, null)], null);
};
cljs.core.PersistentQueueIter.cljs$lang$type = true;
cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";
cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentQueueIter");
};
cljs.core.__GT_PersistentQueueIter = function cljs$core$__GT_PersistentQueueIter(fseq, riter) {
  return new cljs.core.PersistentQueueIter(fseq, riter);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.indexOf = function() {
  var G__11354 = null;
  var G__11354__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11354__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11354 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11354__1.call(this, x);
      case 2:
        return G__11354__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11354.cljs$core$IFn$_invoke$arity$1 = G__11354__1;
  G__11354.cljs$core$IFn$_invoke$arity$2 = G__11354__2;
  return G__11354;
}();
cljs.core.PersistentQueueSeq.prototype.lastIndexOf = function() {
  var G__11355 = null;
  var G__11355__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11355__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11355 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11355__1.call(this, x);
      case 2:
        return G__11355__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11355.cljs$core$IFn$_invoke$arity$1 = G__11355__1;
  G__11355.cljs$core$IFn$_invoke$arity$2 = G__11355__2;
  return G__11355;
}();
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__6751__auto__ = cljs.core.next(self__.front);
  if (temp__6751__auto__) {
    var f1 = temp__6751__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return cljs.core._empty(coll__$1);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.indexOf = function() {
  var G__11356 = null;
  var G__11356__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11356__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11356 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11356__1.call(this, x);
      case 2:
        return G__11356__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11356.cljs$core$IFn$_invoke$arity$1 = G__11356__1;
  G__11356.cljs$core$IFn$_invoke$arity$2 = G__11356__2;
  return G__11356;
}();
cljs.core.PersistentQueue.prototype.lastIndexOf = function() {
  var G__11357 = null;
  var G__11357__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null, coll));
  };
  var G__11357__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11357 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11357__1.call(this, x);
      case 2:
        return G__11357__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11357.cljs$core$IFn$_invoke$arity$1 = G__11357__1;
  G__11357.cljs$core$IFn$_invoke$arity$2 = G__11357__2;
  return G__11357;
}();
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueIter(self__.front, cljs.core._iterator(self__.rear));
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__6751__auto__ = cljs.core.next(self__.front);
    if (temp__6751__auto__) {
      var f1 = temp__6751__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__7062__auto__ = self__.front;
    if (cljs.core.truth_(or__7062__auto__)) {
      return or__7062__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__7062__auto__ = self__.rear;
      if (cljs.core.truth_(or__7062__auto__)) {
        return or__7062__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__11358 = i + incr;
        i = G__11358;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__11359 = i + 1;
      var G__11360 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__11359;
      out = G__11360;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = {};
  var l = ks.length;
  var i_11365 = 0;
  while (true) {
    if (i_11365 < l) {
      var k_11366 = ks[i_11365];
      new_obj[k_11366] = obj[k_11366];
      var G__11367 = i_11365 + 1;
      i_11365 = G__11367;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__11370 = init__$1;
        var G__11371 = k;
        var G__11372 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11370, G__11371, G__11372) : f.call(null, G__11370, G__11371, G__11372);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__11373 = cljs.core.rest(keys__$1);
        var G__11374 = init__$2;
        keys__$1 = G__11373;
        init__$1 = G__11374;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k)) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__11368_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11368_SHARP_, self__.strobj[p1__11368_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__11375 = null;
  var G__11375__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__11375__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__11375 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11375__2.call(this, self__, k);
      case 3:
        return G__11375__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11375.cljs$core$IFn$_invoke$arity$2 = G__11375__2;
  G__11375.cljs$core$IFn$_invoke$arity$3 = G__11375__3;
  return G__11375;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args11369) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11369)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.RecordIter = function(i, record, base_count, fields, ext_map_iter) {
  this.i = i;
  this.record = record;
  this.base_count = base_count;
  this.fields = fields;
  this.ext_map_iter = ext_map_iter;
};
cljs.core.RecordIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__7062__auto__ = self__.i < self__.base_count;
  if (or__7062__auto__) {
    return or__7062__auto__;
  } else {
    return self__.ext_map_iter.hasNext();
  }
};
cljs.core.RecordIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (self__.i < self__.base_count) {
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields, self__.i);
    self__.i = self__.i + 1;
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record, k)], null);
  } else {
    return self__.ext_map_iter.next();
  }
};
cljs.core.RecordIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.RecordIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "record", "record", 861424668, null), new cljs.core.Symbol(null, "base-count", "base-count", -1180647182, null), new cljs.core.Symbol(null, "fields", "fields", -291534703, null), new cljs.core.Symbol(null, 
  "ext-map-iter", "ext-map-iter", -1215982757, null)], null);
};
cljs.core.RecordIter.cljs$lang$type = true;
cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";
cljs.core.RecordIter.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/RecordIter");
};
cljs.core.__GT_RecordIter = function cljs$core$__GT_RecordIter(i, record, base_count, fields, ext_map_iter) {
  return new cljs.core.RecordIter(i, record, base_count, fields, ext_map_iter);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__11378 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11378, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11378, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__11381 = i + 2;
        i = G__11381;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Keyword && kstr === arr[i].fqn) {
        return i;
      } else {
        var G__11382 = i + 2;
        i = G__11382;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Symbol && kstr === arr[i].str) {
        return i;
      } else {
        var G__11383 = i + 2;
        i = G__11383;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__11384 = i + 2;
        i = G__11384;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__11385 = i + 2;
        i = G__11385;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (goog.isString(k) || typeof k === "number") {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_11386 = 0;
  while (true) {
    if (i_11386 < l) {
      narr[i_11386] = arr[i_11386];
      var G__11387 = i_11386 + 1;
      i_11386 = G__11387;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.indexOf = function() {
  var G__11388 = null;
  var G__11388__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11388__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11388 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11388__1.call(this, x);
      case 2:
        return G__11388__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11388.cljs$core$IFn$_invoke$arity$1 = G__11388__1;
  G__11388.cljs$core$IFn$_invoke$arity$2 = G__11388__2;
  return G__11388;
}();
cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = function() {
  var G__11389 = null;
  var G__11389__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11389__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11389 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11389__1.call(this, x);
      case 2:
        return G__11389__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11389.cljs$core$IFn$_invoke$arity$1 = G__11389__1;
  G__11389.cljs$core$IFn$_invoke$arity$2 = G__11389__2;
  return G__11389;
}();
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__11391 = cljs.core.seq(coll);
  var chunk__11392 = null;
  var count__11393 = 0;
  var i__11394 = 0;
  while (true) {
    if (i__11394 < count__11393) {
      var vec__11395 = chunk__11392.cljs$core$IIndexed$_nth$arity$2(null, i__11394);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11395, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11395, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__11408 = seq__11391;
      var G__11409 = chunk__11392;
      var G__11410 = count__11393;
      var G__11411 = i__11394 + 1;
      seq__11391 = G__11408;
      chunk__11392 = G__11409;
      count__11393 = G__11410;
      i__11394 = G__11411;
      continue;
    } else {
      var temp__6753__auto__ = cljs.core.seq(seq__11391);
      if (temp__6753__auto__) {
        var seq__11391__$1 = temp__6753__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__11391__$1)) {
          var c__7968__auto__ = cljs.core.chunk_first(seq__11391__$1);
          var G__11412 = cljs.core.chunk_rest(seq__11391__$1);
          var G__11413 = c__7968__auto__;
          var G__11414 = cljs.core.count(c__7968__auto__);
          var G__11415 = 0;
          seq__11391 = G__11412;
          chunk__11392 = G__11413;
          count__11393 = G__11414;
          i__11394 = G__11415;
          continue;
        } else {
          var vec__11398 = cljs.core.first(seq__11391__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11398, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11398, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__11416 = cljs.core.next(seq__11391__$1);
          var G__11417 = null;
          var G__11418 = 0;
          var G__11419 = 0;
          seq__11391 = G__11416;
          chunk__11392 = G__11417;
          count__11393 = G__11418;
          i__11394 = G__11419;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__11401 = init__$1;
        var G__11402 = self__.arr[i];
        var G__11403 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11401, G__11402, G__11403) : f.call(null, G__11401, G__11402, G__11403);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__11420 = i + 2;
        var G__11421 = init__$2;
        i = G__11420;
        init__$1 = G__11421;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (!(other == null) ? other.cljs$lang$protocol_mask$partition0$ & 1024 || cljs.core.PROTOCOL_SENTINEL === other.cljs$core$IMap$ ? true : false : false) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__11422 = i + 2;
              i = G__11422;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap({}, self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return cljs.core._empty(coll__$1);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__11423 = s + 2;
            var G__11424 = d;
            s = G__11423;
            d = G__11424;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__11425 = s + 2;
            var G__11426 = d + 2;
            s = G__11425;
            d = G__11426;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__11407 = cljs.core.aclone(self__.arr);
        G__11407[idx + 1] = v;
        return G__11407;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__11427 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__11428 = cljs.core.next(es);
          ret = G__11427;
          es = G__11428;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__11429 = null;
  var G__11429__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__11429__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__11429 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11429__2.call(this, self__, k);
      case 3:
        return G__11429__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11429.cljs$core$IFn$_invoke$arity$2 = G__11429__2;
  G__11429.cljs$core$IFn$_invoke$arity$3 = G__11429__3;
  return G__11429;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args11390) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11390)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_11430 = 0;
    while (true) {
      if (i_11430 < arr__$1.length) {
        var k_11431 = arr__$1[i_11430];
        var v_11432 = arr__$1[i_11430 + 1];
        var idx_11433 = cljs.core.array_index_of(ret, k_11431);
        if (idx_11433 === -1) {
          ret.push(k_11431);
          ret.push(v_11432);
        } else {
        }
        var G__11434 = i_11430 + 2;
        i_11430 = G__11434;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var cnt = arr__$2.length / 2;
  return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return cljs.core._assoc_BANG_(tcoll__$1, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__6751__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__6751__auto__)) {
          var e = temp__6751__auto__;
          var G__11437 = cljs.core.next(es);
          var G__11438 = cljs.core._assoc_BANG_(tcoll__$2, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__11437;
          tcoll__$2 = G__11438;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len, self__.arr) : cljs.core.array__GT_transient_hash_map.call(null, self__.len, self__.arr), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__11436_11439 = self__.arr;
      G__11436_11439.pop();
      G__11436_11439.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__11440 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__11441 = i + 2;
      out = G__11440;
      i = G__11441;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set(var_args) {
  var args11442 = [];
  var len__8278__auto___11447 = arguments.length;
  var i__8279__auto___11448 = 0;
  while (true) {
    if (i__8279__auto___11448 < len__8278__auto___11447) {
      args11442.push(arguments[i__8279__auto___11448]);
      var G__11449 = i__8279__auto___11448 + 1;
      i__8279__auto___11448 = G__11449;
      continue;
    } else {
    }
    break;
  }
  var G__11444 = args11442.length;
  switch(G__11444) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11442.length)].join(""));;
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__11445 = cljs.core.aclone(arr);
  G__11445[i] = a;
  return G__11445;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__11446 = cljs.core.aclone(arr);
  G__11446[i] = a;
  G__11446[j] = b;
  return G__11446;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set(var_args) {
  var args11451 = [];
  var len__8278__auto___11454 = arguments.length;
  var i__8279__auto___11455 = 0;
  while (true) {
    if (i__8279__auto___11455 < len__8278__auto___11454) {
      args11451.push(arguments[i__8279__auto___11455]);
      var G__11456 = i__8279__auto___11455 + 1;
      i__8279__auto___11455 = G__11456;
      continue;
    } else {
    }
    break;
  }
  var G__11453 = args11451.length;
  switch(G__11453) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11451.length)].join(""));;
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__11461 = init__$1;
          var G__11462 = k;
          var G__11463 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11461, G__11462, G__11463) : f.call(null, G__11461, G__11462, G__11463);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__11464 = i + 2;
        var G__11465 = init__$2;
        i = G__11464;
        init__$1 = G__11465;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.NodeIterator = function(arr, i, next_entry, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_entry = next_entry;
  this.next_iter = next_iter;
};
cljs.core.NodeIterator.prototype.advance = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (self__.i < len) {
      var key = self__.arr[self__.i];
      var node_or_val = self__.arr[self__.i + 1];
      var found = cljs.core.some_QMARK_(key) ? self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key, node_or_val], null) : cljs.core.some_QMARK_(node_or_val) ? function() {
        var new_iter = cljs.core._iterator(node_or_val);
        if (new_iter.hasNext()) {
          return self__.next_iter = new_iter;
        } else {
          return false;
        }
      }() : false;
      self__.i = self__.i + 2;
      if (found) {
        return true;
      } else {
        continue;
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core.NodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var or__7062__auto__ = cljs.core.some_QMARK_(self__.next_entry);
  if (or__7062__auto__) {
    return or__7062__auto__;
  } else {
    var or__7062__auto____$1 = cljs.core.some_QMARK_(self__.next_iter);
    if (or__7062__auto____$1) {
      return or__7062__auto____$1;
    } else {
      return this$.advance();
    }
  }
};
cljs.core.NodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.some_QMARK_(self__.next_entry)) {
    var ret = self__.next_entry;
    self__.next_entry = null;
    return ret;
  } else {
    if (cljs.core.some_QMARK_(self__.next_iter)) {
      var ret = self__.next_iter.next();
      if (self__.next_iter.hasNext()) {
      } else {
        self__.next_iter = null;
      }
      return ret;
    } else {
      if (this$.advance()) {
        return this$.next();
      } else {
        throw new Error("No such element");
      }
    }
  }
};
cljs.core.NodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.NodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-entry", "next-entry", 1091342476, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.NodeIterator.cljs$lang$type = true;
cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";
cljs.core.NodeIterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/NodeIterator");
};
cljs.core.__GT_NodeIterator = function cljs$core$__GT_NodeIterator(arr, i, next_entry, next_iter) {
  return new cljs.core.NodeIterator(arr, i, next_entry, next_iter);
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_[0] = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_11479 = 0;
        var j_11480 = 0;
        while (true) {
          if (i_11479 < 32) {
            if ((self__.bitmap >>> i_11479 & 1) === 0) {
              var G__11481 = i_11479 + 1;
              var G__11482 = j_11480;
              i_11479 = G__11481;
              j_11480 = G__11482;
              continue;
            } else {
              nodes[i_11479] = !(self__.arr[j_11480] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_11480]), self__.arr[j_11480], self__.arr[j_11480 + 1], added_leaf_QMARK_) : self__.arr[j_11480 + 1];
              var G__11483 = i_11479 + 1;
              var G__11484 = j_11480 + 2;
              i_11479 = G__11483;
              j_11480 = G__11484;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__11466 = edit__$1;
          var G__11467 = shift + 5;
          var G__11468 = key_or_nil;
          var G__11469 = val_or_node;
          var G__11470 = hash;
          var G__11471 = key;
          var G__11472 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__11466, G__11467, G__11468, G__11469, G__11470, G__11471, G__11472) : cljs.core.create_node.call(null, G__11466, G__11467, G__11468, G__11469, G__11470, G__11471, G__11472);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_11485 = 0;
      var j_11486 = 0;
      while (true) {
        if (i_11485 < 32) {
          if ((self__.bitmap >>> i_11485 & 1) === 0) {
            var G__11487 = i_11485 + 1;
            var G__11488 = j_11486;
            i_11485 = G__11487;
            j_11486 = G__11488;
            continue;
          } else {
            nodes[i_11485] = !(self__.arr[j_11486] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_11486]), self__.arr[j_11486], self__.arr[j_11486 + 1], added_leaf_QMARK_) : self__.arr[j_11486 + 1];
            var G__11489 = i_11485 + 1;
            var G__11490 = j_11486 + 2;
            i_11485 = G__11489;
            j_11486 = G__11490;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__11473 = shift + 5;
          var G__11474 = key_or_nil;
          var G__11475 = val_or_node;
          var G__11476 = hash;
          var G__11477 = key;
          var G__11478 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__11473, G__11474, G__11475, G__11476, G__11477, G__11478) : cljs.core.create_node.call(null, G__11473, G__11474, G__11475, G__11476, G__11477, G__11478);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.BitmapIndexedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "bitmap", "bitmap", 501334601, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__11491 = i + 1;
        var G__11492 = j + 2;
        var G__11493 = bitmap | 1 << i;
        i = G__11491;
        j = G__11492;
        bitmap = G__11493;
        continue;
      } else {
        var G__11494 = i + 1;
        var G__11495 = j;
        var G__11496 = bitmap;
        i = G__11494;
        j = G__11495;
        bitmap = G__11496;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNodeIterator = function(arr, i, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_iter = next_iter;
};
cljs.core.ArrayNodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (!(cljs.core.some_QMARK_(self__.next_iter) && self__.next_iter.hasNext())) {
      if (self__.i < len) {
        var node = self__.arr[self__.i];
        self__.i = self__.i + 1;
        if (cljs.core.some_QMARK_(node)) {
          self__.next_iter = cljs.core._iterator(node);
        } else {
        }
        continue;
      } else {
        return false;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.ArrayNodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (this$.hasNext()) {
    return self__.next_iter.next();
  } else {
    throw new Error("No such element");
  }
};
cljs.core.ArrayNodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayNodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNodeIterator.cljs$lang$type = true;
cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";
cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ArrayNodeIterator");
};
cljs.core.__GT_ArrayNodeIterator = function cljs$core$__GT_ArrayNodeIterator(arr, i, next_iter) {
  return new cljs.core.ArrayNodeIterator(arr, i, next_iter);
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null, self__.arr);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
        } else {
          var G__11497 = i + 1;
          var G__11498 = init__$2;
          i = G__11497;
          init__$1 = G__11498;
          continue;
        }
      } else {
        var G__11499 = i + 1;
        var G__11500 = init__$1;
        i = G__11499;
        init__$1 = G__11500;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeIterator(self__.arr, 0, null);
};
cljs.core.ArrayNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__11501 = i + 2;
        i = G__11501;
        continue;
      }
    } else {
      return -1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_[0] = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx + 1], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.HashCollisionNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "collision-hash", "collision-hash", -35831342, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node(var_args) {
  var args11502 = [];
  var len__8278__auto___11505 = arguments.length;
  var i__8279__auto___11506 = 0;
  while (true) {
    if (i__8279__auto___11506 < len__8278__auto___11505) {
      args11502.push(arguments[i__8279__auto___11506]);
      var G__11507 = i__8279__auto___11506 + 1;
      i__8279__auto___11506 = G__11507;
      continue;
    } else {
    }
    break;
  }
  var G__11504 = args11502.length;
  switch(G__11504) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11502.length)].join(""));;
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.indexOf = function() {
  var G__11515 = null;
  var G__11515__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11515__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11515 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11515__1.call(this, x);
      case 2:
        return G__11515__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11515.cljs$core$IFn$_invoke$arity$1 = G__11515__1;
  G__11515.cljs$core$IFn$_invoke$arity$2 = G__11515__2;
  return G__11515;
}();
cljs.core.NodeSeq.prototype.lastIndexOf = function() {
  var G__11516 = null;
  var G__11516__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11516__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11516 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11516__1.call(this, x);
      case 2:
        return G__11516__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11516.cljs$core$IFn$_invoke$arity$1 = G__11516__1;
  G__11516.cljs$core$IFn$_invoke$arity$2 = G__11516__2;
  return G__11516;
}();
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var ret = self__.s == null ? function() {
    var G__11509 = self__.nodes;
    var G__11510 = self__.i + 2;
    var G__11511 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__11509, G__11510, G__11511) : cljs.core.create_inode_seq.call(null, G__11509, G__11510, G__11511);
  }() : function() {
    var G__11512 = self__.nodes;
    var G__11513 = self__.i;
    var G__11514 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__11512, G__11513, G__11514) : cljs.core.create_inode_seq.call(null, G__11512, G__11513, G__11514);
  }();
  if (!(ret == null)) {
    return ret;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq(var_args) {
  var args11517 = [];
  var len__8278__auto___11520 = arguments.length;
  var i__8279__auto___11521 = 0;
  while (true) {
    if (i__8279__auto___11521 < len__8278__auto___11520) {
      args11517.push(arguments[i__8279__auto___11521]);
      var G__11522 = i__8279__auto___11521 + 1;
      i__8279__auto___11521 = G__11522;
      continue;
    } else {
    }
    break;
  }
  var G__11519 = args11517.length;
  switch(G__11519) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11517.length)].join(""));;
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__6751__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__6751__auto__)) {
            var node = temp__6751__auto__;
            var temp__6751__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__6751__auto____$1)) {
              var node_seq = temp__6751__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__11524 = j + 2;
              j = G__11524;
              continue;
            }
          } else {
            var G__11525 = j + 2;
            j = G__11525;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.indexOf = function() {
  var G__11530 = null;
  var G__11530__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11530__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11530 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11530__1.call(this, x);
      case 2:
        return G__11530__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11530.cljs$core$IFn$_invoke$arity$1 = G__11530__1;
  G__11530.cljs$core$IFn$_invoke$arity$2 = G__11530__2;
  return G__11530;
}();
cljs.core.ArrayNodeSeq.prototype.lastIndexOf = function() {
  var G__11531 = null;
  var G__11531__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11531__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11531 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11531__1.call(this, x);
      case 2:
        return G__11531__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11531.cljs$core$IFn$_invoke$arity$1 = G__11531__1;
  G__11531.cljs$core$IFn$_invoke$arity$2 = G__11531__2;
  return G__11531;
}();
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var ret = function() {
    var G__11526 = null;
    var G__11527 = self__.nodes;
    var G__11528 = self__.i;
    var G__11529 = cljs.core.next(self__.s);
    return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__11526, G__11527, G__11528, G__11529) : cljs.core.create_array_node_seq.call(null, G__11526, G__11527, G__11528, G__11529);
  }();
  if (!(ret == null)) {
    return ret;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq(var_args) {
  var args11532 = [];
  var len__8278__auto___11535 = arguments.length;
  var i__8279__auto___11536 = 0;
  while (true) {
    if (i__8279__auto___11536 < len__8278__auto___11535) {
      args11532.push(arguments[i__8279__auto___11536]);
      var G__11537 = i__8279__auto___11536 + 1;
      i__8279__auto___11536 = G__11537;
      continue;
    } else {
    }
    break;
  }
  var G__11534 = args11532.length;
  switch(G__11534) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args11532.length)].join(""));;
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__6751__auto__ = nodes[j];
        if (cljs.core.truth_(temp__6751__auto__)) {
          var nj = temp__6751__auto__;
          var temp__6751__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__6751__auto____$1)) {
            var ns = temp__6751__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__11539 = j + 1;
            j = G__11539;
            continue;
          }
        } else {
          var G__11540 = j + 1;
          j = G__11540;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.HashMapIter = function(nil_val, root_iter, seen) {
  this.nil_val = nil_val;
  this.root_iter = root_iter;
  this.seen = seen;
};
cljs.core.HashMapIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return cljs.core.not(self__.seen) || self__.root_iter.hasNext();
};
cljs.core.HashMapIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!self__.seen) {
    self__.seen = true;
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null);
  } else {
    return self__.root_iter.next();
  }
};
cljs.core.HashMapIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.HashMapIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.Symbol(null, "root-iter", "root-iter", 1974672108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "seen", "seen", 1121531738, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashMapIter.cljs$lang$type = true;
cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";
cljs.core.HashMapIter.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/HashMapIter");
};
cljs.core.__GT_HashMapIter = function cljs$core$__GT_HashMapIter(nil_val, root_iter, seen) {
  return new cljs.core.HashMapIter(nil_val, root_iter, seen);
};
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__11542 = cljs.core.seq(coll);
  var chunk__11543 = null;
  var count__11544 = 0;
  var i__11545 = 0;
  while (true) {
    if (i__11545 < count__11544) {
      var vec__11546 = chunk__11543.cljs$core$IIndexed$_nth$arity$2(null, i__11545);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11546, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11546, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__11554 = seq__11542;
      var G__11555 = chunk__11543;
      var G__11556 = count__11544;
      var G__11557 = i__11545 + 1;
      seq__11542 = G__11554;
      chunk__11543 = G__11555;
      count__11544 = G__11556;
      i__11545 = G__11557;
      continue;
    } else {
      var temp__6753__auto__ = cljs.core.seq(seq__11542);
      if (temp__6753__auto__) {
        var seq__11542__$1 = temp__6753__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__11542__$1)) {
          var c__7968__auto__ = cljs.core.chunk_first(seq__11542__$1);
          var G__11558 = cljs.core.chunk_rest(seq__11542__$1);
          var G__11559 = c__7968__auto__;
          var G__11560 = cljs.core.count(c__7968__auto__);
          var G__11561 = 0;
          seq__11542 = G__11558;
          chunk__11543 = G__11559;
          count__11544 = G__11560;
          i__11545 = G__11561;
          continue;
        } else {
          var vec__11549 = cljs.core.first(seq__11542__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11549, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11549, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__11562 = cljs.core.next(seq__11542__$1);
          var G__11563 = null;
          var G__11564 = 0;
          var G__11565 = 0;
          seq__11542 = G__11562;
          chunk__11543 = G__11563;
          count__11544 = G__11564;
          i__11545 = G__11565;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init, null, self__.nil_val) : f.call(null, init, null, self__.nil_val) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var root_iter = self__.root ? cljs.core._iterator(self__.root) : cljs.core.nil_iter();
  if (self__.has_nil_QMARK_) {
    return new cljs.core.HashMapIter(self__.nil_val, root_iter, false);
  } else {
    return root_iter;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap({}, self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return !(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__11566 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__11567 = cljs.core.next(es);
          ret = G__11566;
          es = G__11567;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__11568 = null;
  var G__11568__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__11568__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__11568 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11568__2.call(this, self__, k);
      case 3:
        return G__11568__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11568.cljs$core$IFn$_invoke$arity$2 = G__11568__2;
  G__11568.cljs$core$IFn$_invoke$arity$3 = G__11568__3;
  return G__11568;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args11541) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11541)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", 
  "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__11569 = i + 2;
      var G__11570 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__11569;
      ret = G__11570;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__11571 = i + 1;
      var G__11572 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__11571;
      out = G__11572;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return tcoll.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__6751__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__6751__auto__)) {
          var e = temp__6751__auto__;
          var G__11574 = cljs.core.next(es);
          var G__11575 = tcoll__$1.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__11574;
          tcoll__$1 = G__11575;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (cljs.core.truth_(removed_leaf_QMARK_[0])) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, 
  "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__11576 = ascending_QMARK_ ? t.left : t.right;
      var G__11577 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__11576;
      stack__$1 = G__11577;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.indexOf = function() {
  var G__11578 = null;
  var G__11578__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11578__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11578 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11578__1.call(this, x);
      case 2:
        return G__11578__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11578.cljs$core$IFn$_invoke$arity$1 = G__11578__1;
  G__11578.cljs$core$IFn$_invoke$arity$2 = G__11578__2;
  return G__11578;
}();
cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = function() {
  var G__11579 = null;
  var G__11579__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11579__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11579 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11579__1.call(this, x);
      case 2:
        return G__11579__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11579.cljs$core$IFn$_invoke$arity$1 = G__11579__1;
  G__11579.cljs$core$IFn$_invoke$arity$2 = G__11579__2;
  return G__11579;
}();
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "stack", "stack", 847125597, null), cljs.core.with_meta(new cljs.core.Symbol(null, "ascending?", "ascending?", -1938452653, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, 
  "cnt", "cnt", 1924510325, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? function() {
    var G__11589 = node.left;
    var G__11590 = f;
    var G__11591 = init;
    return cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__11589, G__11590, G__11591) : cljs.core.tree_map_kv_reduce.call(null, G__11589, G__11590, G__11591);
  }() : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    var init__$2 = function() {
      var G__11592 = init__$1;
      var G__11593 = node.key;
      var G__11594 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11592, G__11593, G__11594) : f.call(null, G__11592, G__11593, G__11594);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
    } else {
      var init__$3 = !(node.right == null) ? function() {
        var G__11595 = node.right;
        var G__11596 = f;
        var G__11597 = init__$2;
        return cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__11595, G__11596, G__11597) : cljs.core.tree_map_kv_reduce.call(null, G__11595, G__11596, G__11597);
      }() : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null, init__$3);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.BlackNode.prototype.lastIndexOf = function() {
  var G__11599 = null;
  var G__11599__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11599__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11599 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11599__1.call(this, x);
      case 2:
        return G__11599__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11599.cljs$core$IFn$_invoke$arity$1 = G__11599__1;
  G__11599.cljs$core$IFn$_invoke$arity$2 = G__11599__2;
  return G__11599;
}();
cljs.core.BlackNode.prototype.indexOf = function() {
  var G__11600 = null;
  var G__11600__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11600__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11600 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11600__1.call(this, x);
      case 2:
        return G__11600__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11600.cljs$core$IFn$_invoke$arity$1 = G__11600__1;
  G__11600.cljs$core$IFn$_invoke$arity$2 = G__11600__2;
  return G__11600;
}();
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
};
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_left_del(self__.key, self__.val, del, self__.right);
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_right_del(self__.key, self__.val, self__.left, del);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  var x__7991__auto__ = self__.key;
  return cljs.core._conj(function() {
    var x__7991__auto____$1 = self__.val;
    return cljs.core._conj(cljs.core.List.EMPTY, x__7991__auto____$1);
  }(), x__7991__auto__);
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.BlackNode.prototype.call = function() {
  var G__11601 = null;
  var G__11601__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__11601__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__11601 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11601__2.call(this, self__, k);
      case 3:
        return G__11601__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11601.cljs$core$IFn$_invoke$arity$2 = G__11601__2;
  G__11601.cljs$core$IFn$_invoke$arity$3 = G__11601__3;
  return G__11601;
}();
cljs.core.BlackNode.prototype.apply = function(self__, args11598) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11598)));
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.BlackNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";
cljs.core.BlackNode.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/BlackNode");
};
cljs.core.__GT_BlackNode = function cljs$core$__GT_BlackNode(key, val, left, right, __hash) {
  return new cljs.core.BlackNode(key, val, left, right, __hash);
};
cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.RedNode.prototype.lastIndexOf = function() {
  var G__11603 = null;
  var G__11603__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__11603__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11603 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11603__1.call(this, x);
      case 2:
        return G__11603__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11603.cljs$core$IFn$_invoke$arity$1 = G__11603__1;
  G__11603.cljs$core$IFn$_invoke$arity$2 = G__11603__2;
  return G__11603;
}();
cljs.core.RedNode.prototype.indexOf = function() {
  var G__11604 = null;
  var G__11604__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__11604__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__11604 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__11604__1.call(this, x);
      case 2:
        return G__11604__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11604.cljs$core$IFn$_invoke$arity$1 = G__11604__1;
  G__11604.cljs$core$IFn$_invoke$arity$2 = G__11604__2;
  return G__11604;
}();
cljs.core.RedNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, ins, null);
};
cljs.core.RedNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, ins, self__.right, null);
};
cljs.core.RedNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.left instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, self__.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, self__.right, parent.right, null), null);
  } else {
    if (self__.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.right.key, self__.right.val, new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, self__.right.right, parent.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
    }
  }
};
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.right instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left, null), self__.right.blacken(), null);
  } else {
    if (self__.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.left.key, self__.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left.left, null), new cljs.core.BlackNode(self__.key, self__.val, self__.left.right, self__.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
    }
  }
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, del, self__.right, null);
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, del, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__7499__auto__ = self__.__hash;
  if (!(h__7499__auto__ == null)) {
    return h__7499__auto__;
  } else {
    var h__7499__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__7499__auto____$1;
    return h__7499__auto____$1;
  }
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  var x__7991__auto__ = self__.key;
  return cljs.core._conj(function() {
    var x__7991__auto____$1 = self__.val;
    return cljs.core._conj(cljs.core.List.EMPTY, x__7991__auto____$1);
  }(), x__7991__auto__);
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.RedNode.prototype.call = function() {
  var G__11605 = null;
  var G__11605__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__11605__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__11605 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__11605__2.call(this, self__, k);
      case 3:
        return G__11605__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__11605.cljs$core$IFn$_invoke$arity$2 = G__11605__2;
  G__11605.cljs$core$IFn$_invoke$arity$3 = G__11605__3;
  return G__11605;
}();
cljs.core.RedNode.prototype.apply = function(self__, args11602) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args11602)));
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.RedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "left", "left", 1241415590, null), new cljs.core.Symbol(null, "right", "right", 1187949694, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";
cljs.core.RedNode.cljs$lang$ctorPrWriter = function(this__7714__auto__, writer__7715__auto__, opt__7716__auto__) {
  return cljs.core._write(writer__7715__auto__, "cljs.core/RedNode");
};
cljs.core.__GT_RedNode = function cljs$core$__GT_RedNode(key, val, left, right, __hash) {
  return new cljs.core.RedNode(key, val, left, right, __hash);
};
cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__8169__auto__ = this;
  return cljs.core.es6_iterator(this__8169__auto__);
};
cljs.core.tree_map_add = function cljs$core$tree_map_add(comp, tree, k, v, found) {
  if (tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null);
  } else {
    var c = function() {
      var G__11618 = k;
      var G__11619 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11618, G__11619) : comp.call(null, G__11618, G__11619);
    }();
    if (c === 0) {
      found[0] = tree;
      return null;
    } else {
      if (c < 0) {
        var ins = function() {
          var G__11620 = comp;
          var G__11621 = tree.left;
          var G__11622 = k;
          var G__11623 = v;
          var G__11624 = found;
          return cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__11620, G__11621, G__11622, G__11623, G__11624) : cljs.core.tree_map_add.call(null, G__11620, G__11621, G__11622, G__11623, G__11624);
        }();
        if (!(ins == null)) {
          return tree.add_left(ins);
        } else {
          return null;
        }
      } else {
        var ins = function() {
          var G__11625 = comp;
          var G__11626 = tree.right;
          var G__11627 = k;
          var G__11628 = v;
          var G__11629 = found;
          return cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__11625, G__11626, G__11627, G__11628, G__11629) : cljs.core.tree_map_add.call(null, G__11625, G__11626, G__11627, G__11628, G__11629);
        }();
        if (!(ins == null)) {
          return tree.add_right(ins);
        } else {
          return null;
        }
      }
    }
  }
};
cljs.core.tree_map_append = function cljs$core$tree_map_append(left, right) {
  if (left == null) {
    return right;
  } else {
    if (right == null) {
      return left;
    } else {
      if (left instanceof cljs.core.RedNode) {
        if (right instanceof cljs.core.RedNode) {
          var app = function() {
            var G__11638 = left.right;
            var G__11639 = right.left;
            return cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__11638, G__11639) : cljs.core.tree_map_append.call(null, G__11638, G__11639);
          }();
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.RedNode(left.key, left.val, left.left, app.left, null), new cljs.core.RedNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app, right.right, null), null);
          }
        } else {
          return new cljs.core.RedNode(left.key, left.val, left.left, function() {
            var G__11640 = left.right;
            var G__11641 = right;
            return cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__11640, G__11641) : cljs.core.tree_map_append.call(null, G__11640, G__11641);
          }(), null);
        }
      } else {
        if (right instanceof cljs.core.RedNode) {
          return new cljs.core.RedNode(right.key, right.val, function() {
            var G__11642 = left;
            var G__11643 = right.left;
            return cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__11642, G__11643) : cljs.core.tree_map_append.call(null, G__11642, G__11643);
          }(), right.right, null);
        } else {
          var app = function() {
            var G__11644 = left.right;
            var G__11645 = right.left;
            return cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__11644, G__11645) : cljs.core.tree_map_append.call(null, G__11644, G__11645);
          }();
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.BlackNode(left.key, left.val, left.left, app.left, null), new cljs.core.BlackNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return cljs.core.balance_left_del(left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app, right.right, null));
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function cljs$core$tree_map_remove(comp, tree, k, found) {
  if (!(tree == null)) {
    var c = function() {
      var G__11656 = k;
      var G__11657 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11656, G__11657) : comp.call(null, G__11656, G__11657);
    }();
    if (c === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append(tree.left, tree.right);
    } else {
      if (c < 0) {
        var del = function() {
          var G__11658 = comp;
          var G__11659 = tree.left;
          var G__11660 = k;
          var G__11661 = found;
          return cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__11658, G__11659, G__11660, G__11661) : cljs.core.tree_map_remove.call(null, G__11658, G__11659, G__11660, G__11661);
        }();
        if (!(del == null) || !(found[0] == null)) {
          if (tree.left instanceof cljs.core.BlackNode) {
            return cljs.core.balance_left_del(tree.key, tree.val, del, tree.right);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, del, tree.right, null);
          }
        } else {
          return null;
        }
      } else {
        var del = function() {
          var G__11662 = comp;
          var G__11663 = tree.right;
          var G__11664 = k;
          var G__11665 = found;
          return cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__11662, G__11663, G__11664, G__11665) : cljs.core.tree_map_remove.call(null, G__11662, G__11663, G__11664, G__11665);
        }();
        if (!(del == null) || !(found[0] == null)) {
          if (tree.right instanceof cljs.core.BlackNode) {
            return cljs.core.balance_right_del(tree.key, tree.val, tree.left, del);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, tree.left, del, null);
          }
        } else {
          return null;
        }
      }
    }
  } else {
    return null;
  }
};
cljs.core.tree_map_replace = function cljs$core$tree_map_replace(comp, tree, k, v) {
  var tk = tree.key;
  var c = comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k, tk) : comp.call(null, k, tk);
  if (c === 0) {
    return tree.replace(tk, v, tree.left, tree.right);
  } else {
    if (c < 0) {
      return tree.replace(tk, tree.val, function() {
        var G__11674 = comp;
        var G__11675 = tree.left;
        var G__11676 = k;
        var G__11677 = v;
        return cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__11674, G__11675, G__11676, G__11677) : cljs.core.tree_map_replace.call(null, G__11674, G__11675, G__11676, G__11677);
      }(), tree.right);
    } else {
      return tree.replace(tk, tree.val, tree.left, function() {
        var G__11678 = comp;
        var G__11679 = tree.right;
        var G__11680 = k;
        var G__11681 = v;
        return cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__11678, G__11679, G__11680, G__11681) : cljs.core.tree_map_replace.call(null, G__11678, G__11679, G__11680, G__11681);
      }());
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 418776847;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__11683 = cljs.core.seq(coll);
  var chunk__11684 = null;
  var count__11685 = 0;
  var i__11686 = 0;
  while (true) {
    if (i__11686 < count__11685) {
      var vec__11687 = chunk__11684.cljs$core$IIndexed$_nth$arity$2(null, i__11686);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11687, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11687, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__11697 = seq__11683;
      var G__11698 = chunk__11684;
      var G__11699 = count__11685;
      var G__11700 = i__11686 + 1;
      seq__11683 = G__11697;
      chunk__11684 = G__11698;
      count__11685 = G__11699;
      i__11686 = G__11700;
      continue;
    } else {
      var temp__6753__auto__ = cljs.core.seq(seq__11683);
      if (temp__6753__auto__) {
        var seq__11683__$1 = temp__6753__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__11683__$1)) {
          var c__7968__auto__ = cljs.c