// Compiled by ClojureScript 1.8.51 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__6873__auto__ = (((this$ == null))?null:this$);
var m__6874__auto__ = (hasch.benc._coerce[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__6874__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__31838_31842 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__31839_31843 = null;
var count__31840_31844 = (0);
var i__31841_31845 = (0);
while(true){
if((i__31841_31845 < count__31840_31844)){
var bs_31846 = cljs.core._nth.call(null,chunk__31839_31843,i__31841_31845);
md.update(bs_31846);

var G__31847 = seq__31838_31842;
var G__31848 = chunk__31839_31843;
var G__31849 = count__31840_31844;
var G__31850 = (i__31841_31845 + (1));
seq__31838_31842 = G__31847;
chunk__31839_31843 = G__31848;
count__31840_31844 = G__31849;
i__31841_31845 = G__31850;
continue;
} else {
var temp__4657__auto___31851 = cljs.core.seq.call(null,seq__31838_31842);
if(temp__4657__auto___31851){
var seq__31838_31852__$1 = temp__4657__auto___31851;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31838_31852__$1)){
var c__7021__auto___31853 = cljs.core.chunk_first.call(null,seq__31838_31852__$1);
var G__31854 = cljs.core.chunk_rest.call(null,seq__31838_31852__$1);
var G__31855 = c__7021__auto___31853;
var G__31856 = cljs.core.count.call(null,c__7021__auto___31853);
var G__31857 = (0);
seq__31838_31842 = G__31854;
chunk__31839_31843 = G__31855;
count__31840_31844 = G__31856;
i__31841_31845 = G__31857;
continue;
} else {
var bs_31858 = cljs.core.first.call(null,seq__31838_31852__$1);
md.update(bs_31858);

var G__31859 = cljs.core.next.call(null,seq__31838_31852__$1);
var G__31860 = null;
var G__31861 = (0);
var G__31862 = (0);
seq__31838_31842 = G__31859;
chunk__31839_31843 = G__31860;
count__31840_31844 = G__31861;
i__31841_31845 = G__31862;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_31865 = seq;
while(true){
var vec__31864_31866 = s_31865;
var f_31867 = cljs.core.nth.call(null,vec__31864_31866,(0),null);
var r_31868 = cljs.core.nthnext.call(null,vec__31864_31866,(1));
seq_md.update(hasch.benc._coerce.call(null,f_31867,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_31868)){
} else {
var G__31869 = cljs.core.rest.call(null,s_31865);
s_31865 = G__31869;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__6548__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__6549__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__6548__auto__ < y__6549__auto__) ? x__6548__auto__ : y__6549__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_31870 = (0);
while(true){
if((i_31870 < len)){
(acc[i_31870] = ((acc[i_31870]) ^ (elem[i_31870])));

var G__31871 = (i_31870 + (1));
i_31870 = G__31871;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_31872 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_31872,len)){
} else {
var e_31873 = (a[i_31872]);
if(((e_31873 > (0))) && ((e_31873 < (30)))){
(ea[i_31872] = (1));
} else {
}

var G__31874 = (i_31872 + (1));
i_31872 = G__31874;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map