// Compiled by ClojureScript 1.8.51 {}
goog.provide('konserve.memory');
goog.require('cljs.core');
goog.require('konserve.protocols');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {konserve.protocols.PEDNAsyncKeyValueStore}
 * @implements {konserve.protocols.PBinaryAsyncKeyValueStore}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
konserve.memory.MemAsyncKeyValueStore = (function (state,read_handlers,write_handlers,locks,__meta,__extmap,__hash){
this.state = state;
this.read_handlers = read_handlers;
this.write_handlers = write_handlers;
this.locks = locks;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6832__auto__,k__6833__auto__){
var self__ = this;
var this__6832__auto____$1 = this;
return cljs.core._lookup.call(null,this__6832__auto____$1,k__6833__auto__,null);
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6834__auto__,k28355,else__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
var G__28357 = (((k28355 instanceof cljs.core.Keyword))?k28355.fqn:null);
switch (G__28357) {
case "state":
return self__.state;

break;
case "read-handlers":
return self__.read_handlers;

break;
case "write-handlers":
return self__.write_handlers;

break;
case "locks":
return self__.locks;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28355,else__6835__auto__);

}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6846__auto__,writer__6847__auto__,opts__6848__auto__){
var self__ = this;
var this__6846__auto____$1 = this;
var pr_pair__6849__auto__ = ((function (this__6846__auto____$1){
return (function (keyval__6850__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6847__auto__,cljs.core.pr_writer,""," ","",opts__6848__auto__,keyval__6850__auto__);
});})(this__6846__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6847__auto__,pr_pair__6849__auto__,"#konserve.memory.MemAsyncKeyValueStore{",", ","}",opts__6848__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$ = true;

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28354){
var self__ = this;
var G__28354__$1 = this;
return (new cljs.core.RecordIter((0),G__28354__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6830__auto__){
var self__ = this;
var this__6830__auto____$1 = this;
return self__.__meta;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6826__auto__){
var self__ = this;
var this__6826__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$ = true;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_exists_QMARK_$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,this$__$1){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,this$__$1){
return (function (state_28365){
var state_val_28366 = (state_28365[(1)]);
if((state_val_28366 === (1))){
var inst_28358 = cljs.core.deref.call(null,self__.state);
var inst_28359 = inst_28358.call(null,key);
var state_28365__$1 = state_28365;
if(cljs.core.truth_(inst_28359)){
var statearr_28367_28451 = state_28365__$1;
(statearr_28367_28451[(1)] = (2));

} else {
var statearr_28368_28452 = state_28365__$1;
(statearr_28368_28452[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28366 === (2))){
var state_28365__$1 = state_28365;
var statearr_28369_28453 = state_28365__$1;
(statearr_28369_28453[(2)] = true);

(statearr_28369_28453[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28366 === (3))){
var state_28365__$1 = state_28365;
var statearr_28370_28454 = state_28365__$1;
(statearr_28370_28454[(2)] = false);

(statearr_28370_28454[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28366 === (4))){
var inst_28363 = (state_28365[(2)]);
var state_28365__$1 = state_28365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28365__$1,inst_28363);
} else {
return null;
}
}
}
}
});})(c__28309__auto__,this$__$1))
;
return ((function (switch__28294__auto__,c__28309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__28295__auto__ = null;
var konserve$memory$state_machine__28295__auto____0 = (function (){
var statearr_28374 = [null,null,null,null,null,null,null];
(statearr_28374[(0)] = konserve$memory$state_machine__28295__auto__);

(statearr_28374[(1)] = (1));

return statearr_28374;
});
var konserve$memory$state_machine__28295__auto____1 = (function (state_28365){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_28365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e28375){if((e28375 instanceof Object)){
var ex__28298__auto__ = e28375;
var statearr_28376_28455 = state_28365;
(statearr_28376_28455[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28375;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28456 = state_28365;
state_28365 = G__28456;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
konserve$memory$state_machine__28295__auto__ = function(state_28365){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__28295__auto____0.call(this);
case 1:
return konserve$memory$state_machine__28295__auto____1.call(this,state_28365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__28295__auto____0;
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__28295__auto____1;
return konserve$memory$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,this$__$1))
})();
var state__28311__auto__ = (function (){var statearr_28377 = f__28310__auto__.call(null);
(statearr_28377[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_28377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,this$__$1))
);

return c__28309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_get_in$arity$2 = (function (this$,key_vec){
var self__ = this;
var this$__$1 = this;
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,this$__$1){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,this$__$1){
return (function (state_28381){
var state_val_28382 = (state_28381[(1)]);
if((state_val_28382 === (1))){
var inst_28378 = cljs.core.deref.call(null,self__.state);
var inst_28379 = cljs.core.get_in.call(null,inst_28378,key_vec);
var state_28381__$1 = state_28381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28381__$1,inst_28379);
} else {
return null;
}
});})(c__28309__auto__,this$__$1))
;
return ((function (switch__28294__auto__,c__28309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__28295__auto__ = null;
var konserve$memory$state_machine__28295__auto____0 = (function (){
var statearr_28386 = [null,null,null,null,null,null,null];
(statearr_28386[(0)] = konserve$memory$state_machine__28295__auto__);

(statearr_28386[(1)] = (1));

return statearr_28386;
});
var konserve$memory$state_machine__28295__auto____1 = (function (state_28381){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_28381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e28387){if((e28387 instanceof Object)){
var ex__28298__auto__ = e28387;
var statearr_28388_28457 = state_28381;
(statearr_28388_28457[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28381);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28458 = state_28381;
state_28381 = G__28458;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
konserve$memory$state_machine__28295__auto__ = function(state_28381){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__28295__auto____0.call(this);
case 1:
return konserve$memory$state_machine__28295__auto____1.call(this,state_28381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__28295__auto____0;
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__28295__auto____1;
return konserve$memory$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,this$__$1))
})();
var state__28311__auto__ = (function (){var statearr_28389 = f__28310__auto__.call(null);
(statearr_28389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_28389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,this$__$1))
);

return c__28309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3 = (function (this$,key_vec,up_fn){
var self__ = this;
var this$__$1 = this;
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,this$__$1){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,this$__$1){
return (function (state_28398){
var state_val_28399 = (state_28398[(1)]);
if((state_val_28399 === (1))){
var inst_28390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28391 = cljs.core.deref.call(null,self__.state);
var inst_28392 = cljs.core.get_in.call(null,inst_28391,key_vec);
var inst_28393 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.update_in,key_vec,up_fn);
var inst_28394 = cljs.core.get_in.call(null,inst_28393,key_vec);
var inst_28395 = [inst_28392,inst_28394];
var inst_28396 = (new cljs.core.PersistentVector(null,2,(5),inst_28390,inst_28395,null));
var state_28398__$1 = state_28398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28398__$1,inst_28396);
} else {
return null;
}
});})(c__28309__auto__,this$__$1))
;
return ((function (switch__28294__auto__,c__28309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__28295__auto__ = null;
var konserve$memory$state_machine__28295__auto____0 = (function (){
var statearr_28403 = [null,null,null,null,null,null,null];
(statearr_28403[(0)] = konserve$memory$state_machine__28295__auto__);

(statearr_28403[(1)] = (1));

return statearr_28403;
});
var konserve$memory$state_machine__28295__auto____1 = (function (state_28398){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_28398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e28404){if((e28404 instanceof Object)){
var ex__28298__auto__ = e28404;
var statearr_28405_28459 = state_28398;
(statearr_28405_28459[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28404;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28460 = state_28398;
state_28398 = G__28460;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
konserve$memory$state_machine__28295__auto__ = function(state_28398){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__28295__auto____0.call(this);
case 1:
return konserve$memory$state_machine__28295__auto____1.call(this,state_28398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__28295__auto____0;
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__28295__auto____1;
return konserve$memory$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,this$__$1))
})();
var state__28311__auto__ = (function (){var statearr_28406 = f__28310__auto__.call(null);
(statearr_28406[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_28406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,this$__$1))
);

return c__28309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_assoc_in$arity$3 = (function (this$,key_vec,val){
var self__ = this;
var this$__$1 = this;
return konserve.protocols._update_in.call(null,this$__$1,key_vec,((function (this$__$1){
return (function (_){
return val;
});})(this$__$1))
);
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_dissoc$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,this$__$1){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,this$__$1){
return (function (state_28409){
var state_val_28410 = (state_28409[(1)]);
if((state_val_28410 === (1))){
var inst_28407 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.dissoc,key);
var state_28409__$1 = (function (){var statearr_28411 = state_28409;
(statearr_28411[(7)] = inst_28407);

return statearr_28411;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28409__$1,null);
} else {
return null;
}
});})(c__28309__auto__,this$__$1))
;
return ((function (switch__28294__auto__,c__28309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__28295__auto__ = null;
var konserve$memory$state_machine__28295__auto____0 = (function (){
var statearr_28415 = [null,null,null,null,null,null,null,null];
(statearr_28415[(0)] = konserve$memory$state_machine__28295__auto__);

(statearr_28415[(1)] = (1));

return statearr_28415;
});
var konserve$memory$state_machine__28295__auto____1 = (function (state_28409){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_28409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e28416){if((e28416 instanceof Object)){
var ex__28298__auto__ = e28416;
var statearr_28417_28461 = state_28409;
(statearr_28417_28461[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28409);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28416;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28462 = state_28409;
state_28409 = G__28462;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
konserve$memory$state_machine__28295__auto__ = function(state_28409){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__28295__auto____0.call(this);
case 1:
return konserve$memory$state_machine__28295__auto____1.call(this,state_28409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__28295__auto____0;
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__28295__auto____1;
return konserve$memory$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,this$__$1))
})();
var state__28311__auto__ = (function (){var statearr_28418 = f__28310__auto__.call(null);
(statearr_28418[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_28418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,this$__$1))
);

return c__28309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6836__auto__){
var self__ = this;
var this__6836__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$ = true;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bget$arity$3 = (function (this$,key,locked_cb){
var self__ = this;
var this$__$1 = this;
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,this$__$1){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,this$__$1){
return (function (state_28423){
var state_val_28424 = (state_28423[(1)]);
if((state_val_28424 === (1))){
var inst_28419 = cljs.core.deref.call(null,self__.state);
var inst_28420 = cljs.core.get.call(null,inst_28419,key);
var inst_28421 = locked_cb.call(null,inst_28420);
var state_28423__$1 = state_28423;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28423__$1,inst_28421);
} else {
return null;
}
});})(c__28309__auto__,this$__$1))
;
return ((function (switch__28294__auto__,c__28309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__28295__auto__ = null;
var konserve$memory$state_machine__28295__auto____0 = (function (){
var statearr_28428 = [null,null,null,null,null,null,null];
(statearr_28428[(0)] = konserve$memory$state_machine__28295__auto__);

(statearr_28428[(1)] = (1));

return statearr_28428;
});
var konserve$memory$state_machine__28295__auto____1 = (function (state_28423){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_28423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e28429){if((e28429 instanceof Object)){
var ex__28298__auto__ = e28429;
var statearr_28430_28463 = state_28423;
(statearr_28430_28463[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28423);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28429;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28464 = state_28423;
state_28423 = G__28464;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
konserve$memory$state_machine__28295__auto__ = function(state_28423){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__28295__auto____0.call(this);
case 1:
return konserve$memory$state_machine__28295__auto____1.call(this,state_28423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__28295__auto____0;
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__28295__auto____1;
return konserve$memory$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,this$__$1))
})();
var state__28311__auto__ = (function (){var statearr_28431 = f__28310__auto__.call(null);
(statearr_28431[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_28431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,this$__$1))
);

return c__28309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bassoc$arity$3 = (function (this$,key,input){
var self__ = this;
var this$__$1 = this;
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,this$__$1){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,this$__$1){
return (function (state_28437){
var state_val_28438 = (state_28437[(1)]);
if((state_val_28438 === (1))){
var inst_28432 = [new cljs.core.Keyword(null,"input-stream","input-stream",-179909472),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_28433 = [input,new cljs.core.Keyword(null,"unknown","unknown",-935977881)];
var inst_28434 = cljs.core.PersistentHashMap.fromArrays(inst_28432,inst_28433);
var inst_28435 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.assoc,key,inst_28434);
var state_28437__$1 = (function (){var statearr_28439 = state_28437;
(statearr_28439[(7)] = inst_28435);

return statearr_28439;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28437__$1,null);
} else {
return null;
}
});})(c__28309__auto__,this$__$1))
;
return ((function (switch__28294__auto__,c__28309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__28295__auto__ = null;
var konserve$memory$state_machine__28295__auto____0 = (function (){
var statearr_28443 = [null,null,null,null,null,null,null,null];
(statearr_28443[(0)] = konserve$memory$state_machine__28295__auto__);

(statearr_28443[(1)] = (1));

return statearr_28443;
});
var konserve$memory$state_machine__28295__auto____1 = (function (state_28437){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_28437);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e28444){if((e28444 instanceof Object)){
var ex__28298__auto__ = e28444;
var statearr_28445_28465 = state_28437;
(statearr_28445_28465[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28437);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28444;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28466 = state_28437;
state_28437 = G__28466;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
konserve$memory$state_machine__28295__auto__ = function(state_28437){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__28295__auto____0.call(this);
case 1:
return konserve$memory$state_machine__28295__auto____1.call(this,state_28437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__28295__auto____0;
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__28295__auto____1;
return konserve$memory$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,this$__$1))
})();
var state__28311__auto__ = (function (){var statearr_28446 = f__28310__auto__.call(null);
(statearr_28446[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_28446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,this$__$1))
);

return c__28309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
var h__6645__auto__ = self__.__hash;
if(!((h__6645__auto__ == null))){
return h__6645__auto__;
} else {
var h__6645__auto____$1 = cljs.core.hash_imap.call(null,this__6827__auto____$1);
self__.__hash = h__6645__auto____$1;

return h__6645__auto____$1;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6828__auto__,other__6829__auto__){
var self__ = this;
var this__6828__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6198__auto__ = other__6829__auto__;
if(cljs.core.truth_(and__6198__auto__)){
var and__6198__auto____$1 = (this__6828__auto____$1.constructor === other__6829__auto__.constructor);
if(and__6198__auto____$1){
return cljs.core.equiv_map.call(null,this__6828__auto____$1,other__6829__auto__);
} else {
return and__6198__auto____$1;
}
} else {
return and__6198__auto__;
}
})())){
return true;
} else {
return false;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6841__auto__,k__6842__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"locks","locks",1560476518),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),null], null), null),k__6842__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6841__auto____$1),self__.__meta),k__6842__auto__);
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6842__auto__)),null));
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6839__auto__,k__6840__auto__,G__28354){
var self__ = this;
var this__6839__auto____$1 = this;
var pred__28447 = cljs.core.keyword_identical_QMARK_;
var expr__28448 = k__6840__auto__;
if(cljs.core.truth_(pred__28447.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__28448))){
return (new konserve.memory.MemAsyncKeyValueStore(G__28354,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28447.call(null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),expr__28448))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,G__28354,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28447.call(null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),expr__28448))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,G__28354,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28447.call(null,new cljs.core.Keyword(null,"locks","locks",1560476518),expr__28448))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,G__28354,self__.__meta,self__.__extmap,null));
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6840__auto__,G__28354),null));
}
}
}
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6844__auto__){
var self__ = this;
var this__6844__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6831__auto__,G__28354){
var self__ = this;
var this__6831__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,G__28354,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6837__auto__,entry__6838__auto__){
var self__ = this;
var this__6837__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6838__auto__)){
return cljs.core._assoc.call(null,this__6837__auto____$1,cljs.core._nth.call(null,entry__6838__auto__,(0)),cljs.core._nth.call(null,entry__6838__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6837__auto____$1,entry__6838__auto__);
}
});

konserve.memory.MemAsyncKeyValueStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"read-handlers","read-handlers",-544976454,null),new cljs.core.Symbol(null,"write-handlers","write-handlers",-456757384,null),new cljs.core.Symbol(null,"locks","locks",-1093959251,null)], null);
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$type = true;

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrSeq = (function (this__6866__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrWriter = (function (this__6866__auto__,writer__6867__auto__){
return cljs.core._write.call(null,writer__6867__auto__,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.__GT_MemAsyncKeyValueStore = (function konserve$memory$__GT_MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks){
return (new konserve.memory.MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks,null,null,null));
});

konserve.memory.map__GT_MemAsyncKeyValueStore = (function konserve$memory$map__GT_MemAsyncKeyValueStore(G__28356){
return (new konserve.memory.MemAsyncKeyValueStore(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28356),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315).cljs$core$IFn$_invoke$arity$1(G__28356),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911).cljs$core$IFn$_invoke$arity$1(G__28356),new cljs.core.Keyword(null,"locks","locks",1560476518).cljs$core$IFn$_invoke$arity$1(G__28356),null,cljs.core.dissoc.call(null,G__28356,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)),null));
});

/**
 * Create in memory store. Binaries are not properly locked yet and
 *   the read and write-handlers are dummy ones for compatibility.
 */
konserve.memory.new_mem_store = (function konserve$memory$new_mem_store(var_args){
var args28467 = [];
var len__7280__auto___28490 = arguments.length;
var i__7281__auto___28491 = (0);
while(true){
if((i__7281__auto___28491 < len__7280__auto___28490)){
args28467.push((arguments[i__7281__auto___28491]));

var G__28492 = (i__7281__auto___28491 + (1));
i__7281__auto___28491 = G__28492;
continue;
} else {
}
break;
}

var G__28469 = args28467.length;
switch (G__28469) {
case 0:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28467.length)].join('')));

}
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0 = (function (){
return konserve.memory.new_mem_store.call(null,cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1 = (function (init_atom){
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__){
return (function (state_28481){
var state_val_28482 = (state_28481[(1)]);
if((state_val_28482 === (1))){
var inst_28470 = [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)];
var inst_28471 = cljs.core.PersistentHashMap.EMPTY;
var inst_28472 = cljs.core.atom.call(null,inst_28471);
var inst_28473 = cljs.core.PersistentHashMap.EMPTY;
var inst_28474 = cljs.core.atom.call(null,inst_28473);
var inst_28475 = cljs.core.PersistentHashMap.EMPTY;
var inst_28476 = cljs.core.atom.call(null,inst_28475);
var inst_28477 = [init_atom,inst_28472,inst_28474,inst_28476];
var inst_28478 = cljs.core.PersistentHashMap.fromArrays(inst_28470,inst_28477);
var inst_28479 = konserve.memory.map__GT_MemAsyncKeyValueStore.call(null,inst_28478);
var state_28481__$1 = state_28481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28481__$1,inst_28479);
} else {
return null;
}
});})(c__28309__auto__))
;
return ((function (switch__28294__auto__,c__28309__auto__){
return (function() {
var konserve$memory$state_machine__28295__auto__ = null;
var konserve$memory$state_machine__28295__auto____0 = (function (){
var statearr_28486 = [null,null,null,null,null,null,null];
(statearr_28486[(0)] = konserve$memory$state_machine__28295__auto__);

(statearr_28486[(1)] = (1));

return statearr_28486;
});
var konserve$memory$state_machine__28295__auto____1 = (function (state_28481){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_28481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e28487){if((e28487 instanceof Object)){
var ex__28298__auto__ = e28487;
var statearr_28488_28494 = state_28481;
(statearr_28488_28494[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28481);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28487;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28495 = state_28481;
state_28481 = G__28495;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
konserve$memory$state_machine__28295__auto__ = function(state_28481){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__28295__auto____0.call(this);
case 1:
return konserve$memory$state_machine__28295__auto____1.call(this,state_28481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__28295__auto____0;
konserve$memory$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__28295__auto____1;
return konserve$memory$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__))
})();
var state__28311__auto__ = (function (){var statearr_28489 = f__28310__auto__.call(null);
(statearr_28489[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_28489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__))
);

return c__28309__auto__;
});

konserve.memory.new_mem_store.cljs$lang$maxFixedArity = 1;

//# sourceMappingURL=memory.js.map