// Compiled by ClojureScript 1.10.773 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__3415 = arguments.length;
switch (G__3415) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3416 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3416 = (function (f,blockable,meta3417){
this.f = f;
this.blockable = blockable;
this.meta3417 = meta3417;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3416.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3418,meta3417__$1){
var self__ = this;
var _3418__$1 = this;
return (new cljs.core.async.t_cljs$core$async3416(self__.f,self__.blockable,meta3417__$1));
}));

(cljs.core.async.t_cljs$core$async3416.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3418){
var self__ = this;
var _3418__$1 = this;
return self__.meta3417;
}));

(cljs.core.async.t_cljs$core$async3416.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3416.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async3416.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async3416.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async3416.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta3417","meta3417",503083701,null)], null);
}));

(cljs.core.async.t_cljs$core$async3416.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3416.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3416");

(cljs.core.async.t_cljs$core$async3416.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3416");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3416.
 */
cljs.core.async.__GT_t_cljs$core$async3416 = (function cljs$core$async$__GT_t_cljs$core$async3416(f__$1,blockable__$1,meta3417){
return (new cljs.core.async.t_cljs$core$async3416(f__$1,blockable__$1,meta3417));
});

}

return (new cljs.core.async.t_cljs$core$async3416(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__3422 = arguments.length;
switch (G__3422) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__3425 = arguments.length;
switch (G__3425) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__3428 = arguments.length;
switch (G__3428) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_3430 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_3430);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_3430);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__3432 = arguments.length;
switch (G__3432) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___3434 = n;
var x_3435 = (0);
while(true){
if((x_3435 < n__4613__auto___3434)){
(a[x_3435] = x_3435);

var G__3436 = (x_3435 + (1));
x_3435 = G__3436;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3437 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3437 = (function (flag,meta3438){
this.flag = flag;
this.meta3438 = meta3438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3439,meta3438__$1){
var self__ = this;
var _3439__$1 = this;
return (new cljs.core.async.t_cljs$core$async3437(self__.flag,meta3438__$1));
}));

(cljs.core.async.t_cljs$core$async3437.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3439){
var self__ = this;
var _3439__$1 = this;
return self__.meta3438;
}));

(cljs.core.async.t_cljs$core$async3437.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3437.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async3437.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async3437.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async3437.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta3438","meta3438",-460635160,null)], null);
}));

(cljs.core.async.t_cljs$core$async3437.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3437.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3437");

(cljs.core.async.t_cljs$core$async3437.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3437");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3437.
 */
cljs.core.async.__GT_t_cljs$core$async3437 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async3437(flag__$1,meta3438){
return (new cljs.core.async.t_cljs$core$async3437(flag__$1,meta3438));
});

}

return (new cljs.core.async.t_cljs$core$async3437(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3440 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3440 = (function (flag,cb,meta3441){
this.flag = flag;
this.cb = cb;
this.meta3441 = meta3441;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3440.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3442,meta3441__$1){
var self__ = this;
var _3442__$1 = this;
return (new cljs.core.async.t_cljs$core$async3440(self__.flag,self__.cb,meta3441__$1));
}));

(cljs.core.async.t_cljs$core$async3440.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3442){
var self__ = this;
var _3442__$1 = this;
return self__.meta3441;
}));

(cljs.core.async.t_cljs$core$async3440.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3440.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async3440.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async3440.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async3440.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta3441","meta3441",1429077932,null)], null);
}));

(cljs.core.async.t_cljs$core$async3440.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3440.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3440");

(cljs.core.async.t_cljs$core$async3440.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3440");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3440.
 */
cljs.core.async.__GT_t_cljs$core$async3440 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async3440(flag__$1,cb__$1,meta3441){
return (new cljs.core.async.t_cljs$core$async3440(flag__$1,cb__$1,meta3441));
});

}

return (new cljs.core.async.t_cljs$core$async3440(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3443_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3443_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__3444_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__3444_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__3445 = (i + (1));
i = G__3445;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___3451 = arguments.length;
var i__4737__auto___3452 = (0);
while(true){
if((i__4737__auto___3452 < len__4736__auto___3451)){
args__4742__auto__.push((arguments[i__4737__auto___3452]));

var G__3453 = (i__4737__auto___3452 + (1));
i__4737__auto___3452 = G__3453;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__3448){
var map__3449 = p__3448;
var map__3449__$1 = (((((!((map__3449 == null))))?(((((map__3449.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3449.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3449):map__3449);
var opts = map__3449__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq3446){
var G__3447 = cljs.core.first.call(null,seq3446);
var seq3446__$1 = cljs.core.next.call(null,seq3446);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3447,seq3446__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__3455 = arguments.length;
switch (G__3455) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__3355__auto___3502 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3479){
var state_val_3480 = (state_3479[(1)]);
if((state_val_3480 === (7))){
var inst_3475 = (state_3479[(2)]);
var state_3479__$1 = state_3479;
var statearr_3481_3503 = state_3479__$1;
(statearr_3481_3503[(2)] = inst_3475);

(statearr_3481_3503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (1))){
var state_3479__$1 = state_3479;
var statearr_3482_3504 = state_3479__$1;
(statearr_3482_3504[(2)] = null);

(statearr_3482_3504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (4))){
var inst_3458 = (state_3479[(7)]);
var inst_3458__$1 = (state_3479[(2)]);
var inst_3459 = (inst_3458__$1 == null);
var state_3479__$1 = (function (){var statearr_3483 = state_3479;
(statearr_3483[(7)] = inst_3458__$1);

return statearr_3483;
})();
if(cljs.core.truth_(inst_3459)){
var statearr_3484_3505 = state_3479__$1;
(statearr_3484_3505[(1)] = (5));

} else {
var statearr_3485_3506 = state_3479__$1;
(statearr_3485_3506[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (13))){
var state_3479__$1 = state_3479;
var statearr_3486_3507 = state_3479__$1;
(statearr_3486_3507[(2)] = null);

(statearr_3486_3507[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (6))){
var inst_3458 = (state_3479[(7)]);
var state_3479__$1 = state_3479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3479__$1,(11),to,inst_3458);
} else {
if((state_val_3480 === (3))){
var inst_3477 = (state_3479[(2)]);
var state_3479__$1 = state_3479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3479__$1,inst_3477);
} else {
if((state_val_3480 === (12))){
var state_3479__$1 = state_3479;
var statearr_3487_3508 = state_3479__$1;
(statearr_3487_3508[(2)] = null);

(statearr_3487_3508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (2))){
var state_3479__$1 = state_3479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3479__$1,(4),from);
} else {
if((state_val_3480 === (11))){
var inst_3468 = (state_3479[(2)]);
var state_3479__$1 = state_3479;
if(cljs.core.truth_(inst_3468)){
var statearr_3488_3509 = state_3479__$1;
(statearr_3488_3509[(1)] = (12));

} else {
var statearr_3489_3510 = state_3479__$1;
(statearr_3489_3510[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (9))){
var state_3479__$1 = state_3479;
var statearr_3490_3511 = state_3479__$1;
(statearr_3490_3511[(2)] = null);

(statearr_3490_3511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (5))){
var state_3479__$1 = state_3479;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3491_3512 = state_3479__$1;
(statearr_3491_3512[(1)] = (8));

} else {
var statearr_3492_3513 = state_3479__$1;
(statearr_3492_3513[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (14))){
var inst_3473 = (state_3479[(2)]);
var state_3479__$1 = state_3479;
var statearr_3493_3514 = state_3479__$1;
(statearr_3493_3514[(2)] = inst_3473);

(statearr_3493_3514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (10))){
var inst_3465 = (state_3479[(2)]);
var state_3479__$1 = state_3479;
var statearr_3494_3515 = state_3479__$1;
(statearr_3494_3515[(2)] = inst_3465);

(statearr_3494_3515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3480 === (8))){
var inst_3462 = cljs.core.async.close_BANG_.call(null,to);
var state_3479__$1 = state_3479;
var statearr_3495_3516 = state_3479__$1;
(statearr_3495_3516[(2)] = inst_3462);

(statearr_3495_3516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_3496 = [null,null,null,null,null,null,null,null];
(statearr_3496[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_3496[(1)] = (1));

return statearr_3496;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_3479){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3497){var ex__3285__auto__ = e3497;
var statearr_3498_3517 = state_3479;
(statearr_3498_3517[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3479[(4)]))){
var statearr_3499_3518 = state_3479;
(statearr_3499_3518[(1)] = cljs.core.first.call(null,(state_3479[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3519 = state_3479;
state_3479 = G__3519;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_3479){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_3479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3500 = f__3356__auto__.call(null);
(statearr_3500[(6)] = c__3355__auto___3502);

return statearr_3500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__3520){
var vec__3521 = p__3520;
var v = cljs.core.nth.call(null,vec__3521,(0),null);
var p = cljs.core.nth.call(null,vec__3521,(1),null);
var job = vec__3521;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__3355__auto___3697 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3528){
var state_val_3529 = (state_3528[(1)]);
if((state_val_3529 === (1))){
var state_3528__$1 = state_3528;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3528__$1,(2),res,v);
} else {
if((state_val_3529 === (2))){
var inst_3525 = (state_3528[(2)]);
var inst_3526 = cljs.core.async.close_BANG_.call(null,res);
var state_3528__$1 = (function (){var statearr_3530 = state_3528;
(statearr_3530[(7)] = inst_3525);

return statearr_3530;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3528__$1,inst_3526);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0 = (function (){
var statearr_3531 = [null,null,null,null,null,null,null,null];
(statearr_3531[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__);

(statearr_3531[(1)] = (1));

return statearr_3531;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1 = (function (state_3528){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3532){var ex__3285__auto__ = e3532;
var statearr_3533_3698 = state_3528;
(statearr_3533_3698[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3528[(4)]))){
var statearr_3534_3699 = state_3528;
(statearr_3534_3699[(1)] = cljs.core.first.call(null,(state_3528[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3700 = state_3528;
state_3528 = G__3700;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = function(state_3528){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1.call(this,state_3528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3535 = f__3356__auto__.call(null);
(statearr_3535[(6)] = c__3355__auto___3697);

return statearr_3535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__3536){
var vec__3537 = p__3536;
var v = cljs.core.nth.call(null,vec__3537,(0),null);
var p = cljs.core.nth.call(null,vec__3537,(1),null);
var job = vec__3537;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___3701 = n;
var __3702 = (0);
while(true){
if((__3702 < n__4613__auto___3701)){
var G__3540_3703 = type;
var G__3540_3704__$1 = (((G__3540_3703 instanceof cljs.core.Keyword))?G__3540_3703.fqn:null);
switch (G__3540_3704__$1) {
case "compute":
var c__3355__auto___3706 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3702,c__3355__auto___3706,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async){
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = ((function (__3702,c__3355__auto___3706,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async){
return (function (state_3553){
var state_val_3554 = (state_3553[(1)]);
if((state_val_3554 === (1))){
var state_3553__$1 = state_3553;
var statearr_3555_3707 = state_3553__$1;
(statearr_3555_3707[(2)] = null);

(statearr_3555_3707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3554 === (2))){
var state_3553__$1 = state_3553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3553__$1,(4),jobs);
} else {
if((state_val_3554 === (3))){
var inst_3551 = (state_3553[(2)]);
var state_3553__$1 = state_3553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3553__$1,inst_3551);
} else {
if((state_val_3554 === (4))){
var inst_3543 = (state_3553[(2)]);
var inst_3544 = process.call(null,inst_3543);
var state_3553__$1 = state_3553;
if(cljs.core.truth_(inst_3544)){
var statearr_3556_3708 = state_3553__$1;
(statearr_3556_3708[(1)] = (5));

} else {
var statearr_3557_3709 = state_3553__$1;
(statearr_3557_3709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3554 === (5))){
var state_3553__$1 = state_3553;
var statearr_3558_3710 = state_3553__$1;
(statearr_3558_3710[(2)] = null);

(statearr_3558_3710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3554 === (6))){
var state_3553__$1 = state_3553;
var statearr_3559_3711 = state_3553__$1;
(statearr_3559_3711[(2)] = null);

(statearr_3559_3711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3554 === (7))){
var inst_3549 = (state_3553[(2)]);
var state_3553__$1 = state_3553;
var statearr_3560_3712 = state_3553__$1;
(statearr_3560_3712[(2)] = inst_3549);

(statearr_3560_3712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3702,c__3355__auto___3706,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async))
;
return ((function (__3702,switch__3281__auto__,c__3355__auto___3706,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0 = (function (){
var statearr_3561 = [null,null,null,null,null,null,null];
(statearr_3561[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__);

(statearr_3561[(1)] = (1));

return statearr_3561;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1 = (function (state_3553){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3562){var ex__3285__auto__ = e3562;
var statearr_3563_3713 = state_3553;
(statearr_3563_3713[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3553[(4)]))){
var statearr_3564_3714 = state_3553;
(statearr_3564_3714[(1)] = cljs.core.first.call(null,(state_3553[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3715 = state_3553;
state_3553 = G__3715;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = function(state_3553){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1.call(this,state_3553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__;
})()
;})(__3702,switch__3281__auto__,c__3355__auto___3706,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async))
})();
var state__3357__auto__ = (function (){var statearr_3565 = f__3356__auto__.call(null);
(statearr_3565[(6)] = c__3355__auto___3706);

return statearr_3565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});})(__3702,c__3355__auto___3706,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async))
);


break;
case "async":
var c__3355__auto___3716 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__3702,c__3355__auto___3716,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async){
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = ((function (__3702,c__3355__auto___3716,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async){
return (function (state_3578){
var state_val_3579 = (state_3578[(1)]);
if((state_val_3579 === (1))){
var state_3578__$1 = state_3578;
var statearr_3580_3717 = state_3578__$1;
(statearr_3580_3717[(2)] = null);

(statearr_3580_3717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3579 === (2))){
var state_3578__$1 = state_3578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3578__$1,(4),jobs);
} else {
if((state_val_3579 === (3))){
var inst_3576 = (state_3578[(2)]);
var state_3578__$1 = state_3578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3578__$1,inst_3576);
} else {
if((state_val_3579 === (4))){
var inst_3568 = (state_3578[(2)]);
var inst_3569 = async.call(null,inst_3568);
var state_3578__$1 = state_3578;
if(cljs.core.truth_(inst_3569)){
var statearr_3581_3718 = state_3578__$1;
(statearr_3581_3718[(1)] = (5));

} else {
var statearr_3582_3719 = state_3578__$1;
(statearr_3582_3719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3579 === (5))){
var state_3578__$1 = state_3578;
var statearr_3583_3720 = state_3578__$1;
(statearr_3583_3720[(2)] = null);

(statearr_3583_3720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3579 === (6))){
var state_3578__$1 = state_3578;
var statearr_3584_3721 = state_3578__$1;
(statearr_3584_3721[(2)] = null);

(statearr_3584_3721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3579 === (7))){
var inst_3574 = (state_3578[(2)]);
var state_3578__$1 = state_3578;
var statearr_3585_3722 = state_3578__$1;
(statearr_3585_3722[(2)] = inst_3574);

(statearr_3585_3722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__3702,c__3355__auto___3716,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async))
;
return ((function (__3702,switch__3281__auto__,c__3355__auto___3716,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0 = (function (){
var statearr_3586 = [null,null,null,null,null,null,null];
(statearr_3586[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__);

(statearr_3586[(1)] = (1));

return statearr_3586;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1 = (function (state_3578){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3587){var ex__3285__auto__ = e3587;
var statearr_3588_3723 = state_3578;
(statearr_3588_3723[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3578[(4)]))){
var statearr_3589_3724 = state_3578;
(statearr_3589_3724[(1)] = cljs.core.first.call(null,(state_3578[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3725 = state_3578;
state_3578 = G__3725;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = function(state_3578){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1.call(this,state_3578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__;
})()
;})(__3702,switch__3281__auto__,c__3355__auto___3716,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async))
})();
var state__3357__auto__ = (function (){var statearr_3590 = f__3356__auto__.call(null);
(statearr_3590[(6)] = c__3355__auto___3716);

return statearr_3590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});})(__3702,c__3355__auto___3716,G__3540_3703,G__3540_3704__$1,n__4613__auto___3701,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__3540_3704__$1)].join('')));

}

var G__3726 = (__3702 + (1));
__3702 = G__3726;
continue;
} else {
}
break;
}

var c__3355__auto___3727 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3612){
var state_val_3613 = (state_3612[(1)]);
if((state_val_3613 === (7))){
var inst_3608 = (state_3612[(2)]);
var state_3612__$1 = state_3612;
var statearr_3614_3728 = state_3612__$1;
(statearr_3614_3728[(2)] = inst_3608);

(statearr_3614_3728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3613 === (1))){
var state_3612__$1 = state_3612;
var statearr_3615_3729 = state_3612__$1;
(statearr_3615_3729[(2)] = null);

(statearr_3615_3729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3613 === (4))){
var inst_3593 = (state_3612[(7)]);
var inst_3593__$1 = (state_3612[(2)]);
var inst_3594 = (inst_3593__$1 == null);
var state_3612__$1 = (function (){var statearr_3616 = state_3612;
(statearr_3616[(7)] = inst_3593__$1);

return statearr_3616;
})();
if(cljs.core.truth_(inst_3594)){
var statearr_3617_3730 = state_3612__$1;
(statearr_3617_3730[(1)] = (5));

} else {
var statearr_3618_3731 = state_3612__$1;
(statearr_3618_3731[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3613 === (6))){
var inst_3598 = (state_3612[(8)]);
var inst_3593 = (state_3612[(7)]);
var inst_3598__$1 = cljs.core.async.chan.call(null,(1));
var inst_3599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_3600 = [inst_3593,inst_3598__$1];
var inst_3601 = (new cljs.core.PersistentVector(null,2,(5),inst_3599,inst_3600,null));
var state_3612__$1 = (function (){var statearr_3619 = state_3612;
(statearr_3619[(8)] = inst_3598__$1);

return statearr_3619;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3612__$1,(8),jobs,inst_3601);
} else {
if((state_val_3613 === (3))){
var inst_3610 = (state_3612[(2)]);
var state_3612__$1 = state_3612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3612__$1,inst_3610);
} else {
if((state_val_3613 === (2))){
var state_3612__$1 = state_3612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3612__$1,(4),from);
} else {
if((state_val_3613 === (9))){
var inst_3605 = (state_3612[(2)]);
var state_3612__$1 = (function (){var statearr_3620 = state_3612;
(statearr_3620[(9)] = inst_3605);

return statearr_3620;
})();
var statearr_3621_3732 = state_3612__$1;
(statearr_3621_3732[(2)] = null);

(statearr_3621_3732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3613 === (5))){
var inst_3596 = cljs.core.async.close_BANG_.call(null,jobs);
var state_3612__$1 = state_3612;
var statearr_3622_3733 = state_3612__$1;
(statearr_3622_3733[(2)] = inst_3596);

(statearr_3622_3733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3613 === (8))){
var inst_3598 = (state_3612[(8)]);
var inst_3603 = (state_3612[(2)]);
var state_3612__$1 = (function (){var statearr_3623 = state_3612;
(statearr_3623[(10)] = inst_3603);

return statearr_3623;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3612__$1,(9),results,inst_3598);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0 = (function (){
var statearr_3624 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3624[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__);

(statearr_3624[(1)] = (1));

return statearr_3624;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1 = (function (state_3612){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3625){var ex__3285__auto__ = e3625;
var statearr_3626_3734 = state_3612;
(statearr_3626_3734[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3612[(4)]))){
var statearr_3627_3735 = state_3612;
(statearr_3627_3735[(1)] = cljs.core.first.call(null,(state_3612[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3736 = state_3612;
state_3612 = G__3736;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = function(state_3612){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1.call(this,state_3612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3628 = f__3356__auto__.call(null);
(statearr_3628[(6)] = c__3355__auto___3727);

return statearr_3628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3666){
var state_val_3667 = (state_3666[(1)]);
if((state_val_3667 === (7))){
var inst_3662 = (state_3666[(2)]);
var state_3666__$1 = state_3666;
var statearr_3668_3737 = state_3666__$1;
(statearr_3668_3737[(2)] = inst_3662);

(statearr_3668_3737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (20))){
var state_3666__$1 = state_3666;
var statearr_3669_3738 = state_3666__$1;
(statearr_3669_3738[(2)] = null);

(statearr_3669_3738[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (1))){
var state_3666__$1 = state_3666;
var statearr_3670_3739 = state_3666__$1;
(statearr_3670_3739[(2)] = null);

(statearr_3670_3739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (4))){
var inst_3631 = (state_3666[(7)]);
var inst_3631__$1 = (state_3666[(2)]);
var inst_3632 = (inst_3631__$1 == null);
var state_3666__$1 = (function (){var statearr_3671 = state_3666;
(statearr_3671[(7)] = inst_3631__$1);

return statearr_3671;
})();
if(cljs.core.truth_(inst_3632)){
var statearr_3672_3740 = state_3666__$1;
(statearr_3672_3740[(1)] = (5));

} else {
var statearr_3673_3741 = state_3666__$1;
(statearr_3673_3741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (15))){
var inst_3644 = (state_3666[(8)]);
var state_3666__$1 = state_3666;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3666__$1,(18),to,inst_3644);
} else {
if((state_val_3667 === (21))){
var inst_3657 = (state_3666[(2)]);
var state_3666__$1 = state_3666;
var statearr_3674_3742 = state_3666__$1;
(statearr_3674_3742[(2)] = inst_3657);

(statearr_3674_3742[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (13))){
var inst_3659 = (state_3666[(2)]);
var state_3666__$1 = (function (){var statearr_3675 = state_3666;
(statearr_3675[(9)] = inst_3659);

return statearr_3675;
})();
var statearr_3676_3743 = state_3666__$1;
(statearr_3676_3743[(2)] = null);

(statearr_3676_3743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (6))){
var inst_3631 = (state_3666[(7)]);
var state_3666__$1 = state_3666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3666__$1,(11),inst_3631);
} else {
if((state_val_3667 === (17))){
var inst_3652 = (state_3666[(2)]);
var state_3666__$1 = state_3666;
if(cljs.core.truth_(inst_3652)){
var statearr_3677_3744 = state_3666__$1;
(statearr_3677_3744[(1)] = (19));

} else {
var statearr_3678_3745 = state_3666__$1;
(statearr_3678_3745[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (3))){
var inst_3664 = (state_3666[(2)]);
var state_3666__$1 = state_3666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3666__$1,inst_3664);
} else {
if((state_val_3667 === (12))){
var inst_3641 = (state_3666[(10)]);
var state_3666__$1 = state_3666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3666__$1,(14),inst_3641);
} else {
if((state_val_3667 === (2))){
var state_3666__$1 = state_3666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3666__$1,(4),results);
} else {
if((state_val_3667 === (19))){
var state_3666__$1 = state_3666;
var statearr_3679_3746 = state_3666__$1;
(statearr_3679_3746[(2)] = null);

(statearr_3679_3746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (11))){
var inst_3641 = (state_3666[(2)]);
var state_3666__$1 = (function (){var statearr_3680 = state_3666;
(statearr_3680[(10)] = inst_3641);

return statearr_3680;
})();
var statearr_3681_3747 = state_3666__$1;
(statearr_3681_3747[(2)] = null);

(statearr_3681_3747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (9))){
var state_3666__$1 = state_3666;
var statearr_3682_3748 = state_3666__$1;
(statearr_3682_3748[(2)] = null);

(statearr_3682_3748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (5))){
var state_3666__$1 = state_3666;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3683_3749 = state_3666__$1;
(statearr_3683_3749[(1)] = (8));

} else {
var statearr_3684_3750 = state_3666__$1;
(statearr_3684_3750[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (14))){
var inst_3644 = (state_3666[(8)]);
var inst_3644__$1 = (state_3666[(2)]);
var inst_3645 = (inst_3644__$1 == null);
var inst_3646 = cljs.core.not.call(null,inst_3645);
var state_3666__$1 = (function (){var statearr_3685 = state_3666;
(statearr_3685[(8)] = inst_3644__$1);

return statearr_3685;
})();
if(inst_3646){
var statearr_3686_3751 = state_3666__$1;
(statearr_3686_3751[(1)] = (15));

} else {
var statearr_3687_3752 = state_3666__$1;
(statearr_3687_3752[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (16))){
var state_3666__$1 = state_3666;
var statearr_3688_3753 = state_3666__$1;
(statearr_3688_3753[(2)] = false);

(statearr_3688_3753[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (10))){
var inst_3638 = (state_3666[(2)]);
var state_3666__$1 = state_3666;
var statearr_3689_3754 = state_3666__$1;
(statearr_3689_3754[(2)] = inst_3638);

(statearr_3689_3754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (18))){
var inst_3649 = (state_3666[(2)]);
var state_3666__$1 = state_3666;
var statearr_3690_3755 = state_3666__$1;
(statearr_3690_3755[(2)] = inst_3649);

(statearr_3690_3755[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3667 === (8))){
var inst_3635 = cljs.core.async.close_BANG_.call(null,to);
var state_3666__$1 = state_3666;
var statearr_3691_3756 = state_3666__$1;
(statearr_3691_3756[(2)] = inst_3635);

(statearr_3691_3756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0 = (function (){
var statearr_3692 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3692[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__);

(statearr_3692[(1)] = (1));

return statearr_3692;
});
var cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1 = (function (state_3666){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3693){var ex__3285__auto__ = e3693;
var statearr_3694_3757 = state_3666;
(statearr_3694_3757[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3666[(4)]))){
var statearr_3695_3758 = state_3666;
(statearr_3695_3758[(1)] = cljs.core.first.call(null,(state_3666[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3759 = state_3666;
state_3666 = G__3759;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__ = function(state_3666){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1.call(this,state_3666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__3282__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3696 = f__3356__auto__.call(null);
(statearr_3696[(6)] = c__3355__auto__);

return statearr_3696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__3761 = arguments.length;
switch (G__3761) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__3764 = arguments.length;
switch (G__3764) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__3767 = arguments.length;
switch (G__3767) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__3355__auto___3817 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3793){
var state_val_3794 = (state_3793[(1)]);
if((state_val_3794 === (7))){
var inst_3789 = (state_3793[(2)]);
var state_3793__$1 = state_3793;
var statearr_3795_3818 = state_3793__$1;
(statearr_3795_3818[(2)] = inst_3789);

(statearr_3795_3818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (1))){
var state_3793__$1 = state_3793;
var statearr_3796_3819 = state_3793__$1;
(statearr_3796_3819[(2)] = null);

(statearr_3796_3819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (4))){
var inst_3770 = (state_3793[(7)]);
var inst_3770__$1 = (state_3793[(2)]);
var inst_3771 = (inst_3770__$1 == null);
var state_3793__$1 = (function (){var statearr_3797 = state_3793;
(statearr_3797[(7)] = inst_3770__$1);

return statearr_3797;
})();
if(cljs.core.truth_(inst_3771)){
var statearr_3798_3820 = state_3793__$1;
(statearr_3798_3820[(1)] = (5));

} else {
var statearr_3799_3821 = state_3793__$1;
(statearr_3799_3821[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (13))){
var state_3793__$1 = state_3793;
var statearr_3800_3822 = state_3793__$1;
(statearr_3800_3822[(2)] = null);

(statearr_3800_3822[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (6))){
var inst_3770 = (state_3793[(7)]);
var inst_3776 = p.call(null,inst_3770);
var state_3793__$1 = state_3793;
if(cljs.core.truth_(inst_3776)){
var statearr_3801_3823 = state_3793__$1;
(statearr_3801_3823[(1)] = (9));

} else {
var statearr_3802_3824 = state_3793__$1;
(statearr_3802_3824[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (3))){
var inst_3791 = (state_3793[(2)]);
var state_3793__$1 = state_3793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3793__$1,inst_3791);
} else {
if((state_val_3794 === (12))){
var state_3793__$1 = state_3793;
var statearr_3803_3825 = state_3793__$1;
(statearr_3803_3825[(2)] = null);

(statearr_3803_3825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (2))){
var state_3793__$1 = state_3793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3793__$1,(4),ch);
} else {
if((state_val_3794 === (11))){
var inst_3770 = (state_3793[(7)]);
var inst_3780 = (state_3793[(2)]);
var state_3793__$1 = state_3793;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3793__$1,(8),inst_3780,inst_3770);
} else {
if((state_val_3794 === (9))){
var state_3793__$1 = state_3793;
var statearr_3804_3826 = state_3793__$1;
(statearr_3804_3826[(2)] = tc);

(statearr_3804_3826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (5))){
var inst_3773 = cljs.core.async.close_BANG_.call(null,tc);
var inst_3774 = cljs.core.async.close_BANG_.call(null,fc);
var state_3793__$1 = (function (){var statearr_3805 = state_3793;
(statearr_3805[(8)] = inst_3773);

return statearr_3805;
})();
var statearr_3806_3827 = state_3793__$1;
(statearr_3806_3827[(2)] = inst_3774);

(statearr_3806_3827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (14))){
var inst_3787 = (state_3793[(2)]);
var state_3793__$1 = state_3793;
var statearr_3807_3828 = state_3793__$1;
(statearr_3807_3828[(2)] = inst_3787);

(statearr_3807_3828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (10))){
var state_3793__$1 = state_3793;
var statearr_3808_3829 = state_3793__$1;
(statearr_3808_3829[(2)] = fc);

(statearr_3808_3829[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3794 === (8))){
var inst_3782 = (state_3793[(2)]);
var state_3793__$1 = state_3793;
if(cljs.core.truth_(inst_3782)){
var statearr_3809_3830 = state_3793__$1;
(statearr_3809_3830[(1)] = (12));

} else {
var statearr_3810_3831 = state_3793__$1;
(statearr_3810_3831[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_3811 = [null,null,null,null,null,null,null,null,null];
(statearr_3811[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_3811[(1)] = (1));

return statearr_3811;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_3793){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3812){var ex__3285__auto__ = e3812;
var statearr_3813_3832 = state_3793;
(statearr_3813_3832[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3793[(4)]))){
var statearr_3814_3833 = state_3793;
(statearr_3814_3833[(1)] = cljs.core.first.call(null,(state_3793[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3834 = state_3793;
state_3793 = G__3834;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_3793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_3793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3815 = f__3356__auto__.call(null);
(statearr_3815[(6)] = c__3355__auto___3817);

return statearr_3815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3856){
var state_val_3857 = (state_3856[(1)]);
if((state_val_3857 === (7))){
var inst_3852 = (state_3856[(2)]);
var state_3856__$1 = state_3856;
var statearr_3858_3877 = state_3856__$1;
(statearr_3858_3877[(2)] = inst_3852);

(statearr_3858_3877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3857 === (1))){
var inst_3835 = init;
var inst_3836 = inst_3835;
var state_3856__$1 = (function (){var statearr_3859 = state_3856;
(statearr_3859[(7)] = inst_3836);

return statearr_3859;
})();
var statearr_3860_3878 = state_3856__$1;
(statearr_3860_3878[(2)] = null);

(statearr_3860_3878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3857 === (4))){
var inst_3839 = (state_3856[(8)]);
var inst_3839__$1 = (state_3856[(2)]);
var inst_3840 = (inst_3839__$1 == null);
var state_3856__$1 = (function (){var statearr_3861 = state_3856;
(statearr_3861[(8)] = inst_3839__$1);

return statearr_3861;
})();
if(cljs.core.truth_(inst_3840)){
var statearr_3862_3879 = state_3856__$1;
(statearr_3862_3879[(1)] = (5));

} else {
var statearr_3863_3880 = state_3856__$1;
(statearr_3863_3880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3857 === (6))){
var inst_3843 = (state_3856[(9)]);
var inst_3839 = (state_3856[(8)]);
var inst_3836 = (state_3856[(7)]);
var inst_3843__$1 = f.call(null,inst_3836,inst_3839);
var inst_3844 = cljs.core.reduced_QMARK_.call(null,inst_3843__$1);
var state_3856__$1 = (function (){var statearr_3864 = state_3856;
(statearr_3864[(9)] = inst_3843__$1);

return statearr_3864;
})();
if(inst_3844){
var statearr_3865_3881 = state_3856__$1;
(statearr_3865_3881[(1)] = (8));

} else {
var statearr_3866_3882 = state_3856__$1;
(statearr_3866_3882[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3857 === (3))){
var inst_3854 = (state_3856[(2)]);
var state_3856__$1 = state_3856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3856__$1,inst_3854);
} else {
if((state_val_3857 === (2))){
var state_3856__$1 = state_3856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3856__$1,(4),ch);
} else {
if((state_val_3857 === (9))){
var inst_3843 = (state_3856[(9)]);
var inst_3836 = inst_3843;
var state_3856__$1 = (function (){var statearr_3867 = state_3856;
(statearr_3867[(7)] = inst_3836);

return statearr_3867;
})();
var statearr_3868_3883 = state_3856__$1;
(statearr_3868_3883[(2)] = null);

(statearr_3868_3883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3857 === (5))){
var inst_3836 = (state_3856[(7)]);
var state_3856__$1 = state_3856;
var statearr_3869_3884 = state_3856__$1;
(statearr_3869_3884[(2)] = inst_3836);

(statearr_3869_3884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3857 === (10))){
var inst_3850 = (state_3856[(2)]);
var state_3856__$1 = state_3856;
var statearr_3870_3885 = state_3856__$1;
(statearr_3870_3885[(2)] = inst_3850);

(statearr_3870_3885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3857 === (8))){
var inst_3843 = (state_3856[(9)]);
var inst_3846 = cljs.core.deref.call(null,inst_3843);
var state_3856__$1 = state_3856;
var statearr_3871_3886 = state_3856__$1;
(statearr_3871_3886[(2)] = inst_3846);

(statearr_3871_3886[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__3282__auto__ = null;
var cljs$core$async$reduce_$_state_machine__3282__auto____0 = (function (){
var statearr_3872 = [null,null,null,null,null,null,null,null,null,null];
(statearr_3872[(0)] = cljs$core$async$reduce_$_state_machine__3282__auto__);

(statearr_3872[(1)] = (1));

return statearr_3872;
});
var cljs$core$async$reduce_$_state_machine__3282__auto____1 = (function (state_3856){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3873){var ex__3285__auto__ = e3873;
var statearr_3874_3887 = state_3856;
(statearr_3874_3887[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3856[(4)]))){
var statearr_3875_3888 = state_3856;
(statearr_3875_3888[(1)] = cljs.core.first.call(null,(state_3856[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3889 = state_3856;
state_3856 = G__3889;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__3282__auto__ = function(state_3856){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__3282__auto____1.call(this,state_3856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__3282__auto____0;
cljs$core$async$reduce_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__3282__auto____1;
return cljs$core$async$reduce_$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3876 = f__3356__auto__.call(null);
(statearr_3876[(6)] = c__3355__auto__);

return statearr_3876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3895){
var state_val_3896 = (state_3895[(1)]);
if((state_val_3896 === (1))){
var inst_3890 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_3895__$1 = state_3895;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3895__$1,(2),inst_3890);
} else {
if((state_val_3896 === (2))){
var inst_3892 = (state_3895[(2)]);
var inst_3893 = f__$1.call(null,inst_3892);
var state_3895__$1 = state_3895;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3895__$1,inst_3893);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__3282__auto__ = null;
var cljs$core$async$transduce_$_state_machine__3282__auto____0 = (function (){
var statearr_3897 = [null,null,null,null,null,null,null];
(statearr_3897[(0)] = cljs$core$async$transduce_$_state_machine__3282__auto__);

(statearr_3897[(1)] = (1));

return statearr_3897;
});
var cljs$core$async$transduce_$_state_machine__3282__auto____1 = (function (state_3895){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3895);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3898){var ex__3285__auto__ = e3898;
var statearr_3899_3902 = state_3895;
(statearr_3899_3902[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3895[(4)]))){
var statearr_3900_3903 = state_3895;
(statearr_3900_3903[(1)] = cljs.core.first.call(null,(state_3895[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3904 = state_3895;
state_3895 = G__3904;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__3282__auto__ = function(state_3895){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__3282__auto____1.call(this,state_3895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__3282__auto____0;
cljs$core$async$transduce_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__3282__auto____1;
return cljs$core$async$transduce_$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3901 = f__3356__auto__.call(null);
(statearr_3901[(6)] = c__3355__auto__);

return statearr_3901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__3906 = arguments.length;
switch (G__3906) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_3931){
var state_val_3932 = (state_3931[(1)]);
if((state_val_3932 === (7))){
var inst_3913 = (state_3931[(2)]);
var state_3931__$1 = state_3931;
var statearr_3933_3955 = state_3931__$1;
(statearr_3933_3955[(2)] = inst_3913);

(statearr_3933_3955[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (1))){
var inst_3907 = cljs.core.seq.call(null,coll);
var inst_3908 = inst_3907;
var state_3931__$1 = (function (){var statearr_3934 = state_3931;
(statearr_3934[(7)] = inst_3908);

return statearr_3934;
})();
var statearr_3935_3956 = state_3931__$1;
(statearr_3935_3956[(2)] = null);

(statearr_3935_3956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (4))){
var inst_3908 = (state_3931[(7)]);
var inst_3911 = cljs.core.first.call(null,inst_3908);
var state_3931__$1 = state_3931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3931__$1,(7),ch,inst_3911);
} else {
if((state_val_3932 === (13))){
var inst_3925 = (state_3931[(2)]);
var state_3931__$1 = state_3931;
var statearr_3936_3957 = state_3931__$1;
(statearr_3936_3957[(2)] = inst_3925);

(statearr_3936_3957[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (6))){
var inst_3916 = (state_3931[(2)]);
var state_3931__$1 = state_3931;
if(cljs.core.truth_(inst_3916)){
var statearr_3937_3958 = state_3931__$1;
(statearr_3937_3958[(1)] = (8));

} else {
var statearr_3938_3959 = state_3931__$1;
(statearr_3938_3959[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (3))){
var inst_3929 = (state_3931[(2)]);
var state_3931__$1 = state_3931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3931__$1,inst_3929);
} else {
if((state_val_3932 === (12))){
var state_3931__$1 = state_3931;
var statearr_3939_3960 = state_3931__$1;
(statearr_3939_3960[(2)] = null);

(statearr_3939_3960[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (2))){
var inst_3908 = (state_3931[(7)]);
var state_3931__$1 = state_3931;
if(cljs.core.truth_(inst_3908)){
var statearr_3940_3961 = state_3931__$1;
(statearr_3940_3961[(1)] = (4));

} else {
var statearr_3941_3962 = state_3931__$1;
(statearr_3941_3962[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (11))){
var inst_3922 = cljs.core.async.close_BANG_.call(null,ch);
var state_3931__$1 = state_3931;
var statearr_3942_3963 = state_3931__$1;
(statearr_3942_3963[(2)] = inst_3922);

(statearr_3942_3963[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (9))){
var state_3931__$1 = state_3931;
if(cljs.core.truth_(close_QMARK_)){
var statearr_3943_3964 = state_3931__$1;
(statearr_3943_3964[(1)] = (11));

} else {
var statearr_3944_3965 = state_3931__$1;
(statearr_3944_3965[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (5))){
var inst_3908 = (state_3931[(7)]);
var state_3931__$1 = state_3931;
var statearr_3945_3966 = state_3931__$1;
(statearr_3945_3966[(2)] = inst_3908);

(statearr_3945_3966[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (10))){
var inst_3927 = (state_3931[(2)]);
var state_3931__$1 = state_3931;
var statearr_3946_3967 = state_3931__$1;
(statearr_3946_3967[(2)] = inst_3927);

(statearr_3946_3967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3932 === (8))){
var inst_3908 = (state_3931[(7)]);
var inst_3918 = cljs.core.next.call(null,inst_3908);
var inst_3908__$1 = inst_3918;
var state_3931__$1 = (function (){var statearr_3947 = state_3931;
(statearr_3947[(7)] = inst_3908__$1);

return statearr_3947;
})();
var statearr_3948_3968 = state_3931__$1;
(statearr_3948_3968[(2)] = null);

(statearr_3948_3968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_3949 = [null,null,null,null,null,null,null,null];
(statearr_3949[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_3949[(1)] = (1));

return statearr_3949;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_3931){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_3931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e3950){var ex__3285__auto__ = e3950;
var statearr_3951_3969 = state_3931;
(statearr_3951_3969[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_3931[(4)]))){
var statearr_3952_3970 = state_3931;
(statearr_3952_3970[(1)] = cljs.core.first.call(null,(state_3931[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3971 = state_3931;
state_3931 = G__3971;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_3931){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_3931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_3953 = f__3356__auto__.call(null);
(statearr_3953[(6)] = c__3355__auto__);

return statearr_3953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__3973 = arguments.length;
switch (G__3973) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_3975 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_3975.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_3976 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_3976.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_3977 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_3977.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_3978 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_3978.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3979 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3979 = (function (ch,cs,meta3980){
this.ch = ch;
this.cs = cs;
this.meta3980 = meta3980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3981,meta3980__$1){
var self__ = this;
var _3981__$1 = this;
return (new cljs.core.async.t_cljs$core$async3979(self__.ch,self__.cs,meta3980__$1));
}));

(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3981){
var self__ = this;
var _3981__$1 = this;
return self__.meta3980;
}));

(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async3979.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async3979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta3980","meta3980",1180092915,null)], null);
}));

(cljs.core.async.t_cljs$core$async3979.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async3979.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3979");

(cljs.core.async.t_cljs$core$async3979.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async3979");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3979.
 */
cljs.core.async.__GT_t_cljs$core$async3979 = (function cljs$core$async$mult_$___GT_t_cljs$core$async3979(ch__$1,cs__$1,meta3980){
return (new cljs.core.async.t_cljs$core$async3979(ch__$1,cs__$1,meta3980));
});

}

return (new cljs.core.async.t_cljs$core$async3979(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__3355__auto___4198 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_4114){
var state_val_4115 = (state_4114[(1)]);
if((state_val_4115 === (7))){
var inst_4110 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4116_4199 = state_4114__$1;
(statearr_4116_4199[(2)] = inst_4110);

(statearr_4116_4199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (20))){
var inst_4015 = (state_4114[(7)]);
var inst_4027 = cljs.core.first.call(null,inst_4015);
var inst_4028 = cljs.core.nth.call(null,inst_4027,(0),null);
var inst_4029 = cljs.core.nth.call(null,inst_4027,(1),null);
var state_4114__$1 = (function (){var statearr_4117 = state_4114;
(statearr_4117[(8)] = inst_4028);

return statearr_4117;
})();
if(cljs.core.truth_(inst_4029)){
var statearr_4118_4200 = state_4114__$1;
(statearr_4118_4200[(1)] = (22));

} else {
var statearr_4119_4201 = state_4114__$1;
(statearr_4119_4201[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (27))){
var inst_4057 = (state_4114[(9)]);
var inst_3984 = (state_4114[(10)]);
var inst_4059 = (state_4114[(11)]);
var inst_4064 = (state_4114[(12)]);
var inst_4064__$1 = cljs.core._nth.call(null,inst_4057,inst_4059);
var inst_4065 = cljs.core.async.put_BANG_.call(null,inst_4064__$1,inst_3984,done);
var state_4114__$1 = (function (){var statearr_4120 = state_4114;
(statearr_4120[(12)] = inst_4064__$1);

return statearr_4120;
})();
if(cljs.core.truth_(inst_4065)){
var statearr_4121_4202 = state_4114__$1;
(statearr_4121_4202[(1)] = (30));

} else {
var statearr_4122_4203 = state_4114__$1;
(statearr_4122_4203[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (1))){
var state_4114__$1 = state_4114;
var statearr_4123_4204 = state_4114__$1;
(statearr_4123_4204[(2)] = null);

(statearr_4123_4204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (24))){
var inst_4015 = (state_4114[(7)]);
var inst_4034 = (state_4114[(2)]);
var inst_4035 = cljs.core.next.call(null,inst_4015);
var inst_3993 = inst_4035;
var inst_3994 = null;
var inst_3995 = (0);
var inst_3996 = (0);
var state_4114__$1 = (function (){var statearr_4124 = state_4114;
(statearr_4124[(13)] = inst_3993);

(statearr_4124[(14)] = inst_3994);

(statearr_4124[(15)] = inst_3996);

(statearr_4124[(16)] = inst_3995);

(statearr_4124[(17)] = inst_4034);

return statearr_4124;
})();
var statearr_4125_4205 = state_4114__$1;
(statearr_4125_4205[(2)] = null);

(statearr_4125_4205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (39))){
var state_4114__$1 = state_4114;
var statearr_4129_4206 = state_4114__$1;
(statearr_4129_4206[(2)] = null);

(statearr_4129_4206[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (4))){
var inst_3984 = (state_4114[(10)]);
var inst_3984__$1 = (state_4114[(2)]);
var inst_3985 = (inst_3984__$1 == null);
var state_4114__$1 = (function (){var statearr_4130 = state_4114;
(statearr_4130[(10)] = inst_3984__$1);

return statearr_4130;
})();
if(cljs.core.truth_(inst_3985)){
var statearr_4131_4207 = state_4114__$1;
(statearr_4131_4207[(1)] = (5));

} else {
var statearr_4132_4208 = state_4114__$1;
(statearr_4132_4208[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (15))){
var inst_3993 = (state_4114[(13)]);
var inst_3994 = (state_4114[(14)]);
var inst_3996 = (state_4114[(15)]);
var inst_3995 = (state_4114[(16)]);
var inst_4011 = (state_4114[(2)]);
var inst_4012 = (inst_3996 + (1));
var tmp4126 = inst_3993;
var tmp4127 = inst_3994;
var tmp4128 = inst_3995;
var inst_3993__$1 = tmp4126;
var inst_3994__$1 = tmp4127;
var inst_3995__$1 = tmp4128;
var inst_3996__$1 = inst_4012;
var state_4114__$1 = (function (){var statearr_4133 = state_4114;
(statearr_4133[(13)] = inst_3993__$1);

(statearr_4133[(18)] = inst_4011);

(statearr_4133[(14)] = inst_3994__$1);

(statearr_4133[(15)] = inst_3996__$1);

(statearr_4133[(16)] = inst_3995__$1);

return statearr_4133;
})();
var statearr_4134_4209 = state_4114__$1;
(statearr_4134_4209[(2)] = null);

(statearr_4134_4209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (21))){
var inst_4038 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4138_4210 = state_4114__$1;
(statearr_4138_4210[(2)] = inst_4038);

(statearr_4138_4210[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (31))){
var inst_4064 = (state_4114[(12)]);
var inst_4068 = cljs.core.async.untap_STAR_.call(null,m,inst_4064);
var state_4114__$1 = state_4114;
var statearr_4139_4211 = state_4114__$1;
(statearr_4139_4211[(2)] = inst_4068);

(statearr_4139_4211[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (32))){
var inst_4056 = (state_4114[(19)]);
var inst_4057 = (state_4114[(9)]);
var inst_4059 = (state_4114[(11)]);
var inst_4058 = (state_4114[(20)]);
var inst_4070 = (state_4114[(2)]);
var inst_4071 = (inst_4059 + (1));
var tmp4135 = inst_4056;
var tmp4136 = inst_4057;
var tmp4137 = inst_4058;
var inst_4056__$1 = tmp4135;
var inst_4057__$1 = tmp4136;
var inst_4058__$1 = tmp4137;
var inst_4059__$1 = inst_4071;
var state_4114__$1 = (function (){var statearr_4140 = state_4114;
(statearr_4140[(19)] = inst_4056__$1);

(statearr_4140[(9)] = inst_4057__$1);

(statearr_4140[(11)] = inst_4059__$1);

(statearr_4140[(20)] = inst_4058__$1);

(statearr_4140[(21)] = inst_4070);

return statearr_4140;
})();
var statearr_4141_4212 = state_4114__$1;
(statearr_4141_4212[(2)] = null);

(statearr_4141_4212[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (40))){
var inst_4083 = (state_4114[(22)]);
var inst_4087 = cljs.core.async.untap_STAR_.call(null,m,inst_4083);
var state_4114__$1 = state_4114;
var statearr_4142_4213 = state_4114__$1;
(statearr_4142_4213[(2)] = inst_4087);

(statearr_4142_4213[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (33))){
var inst_4074 = (state_4114[(23)]);
var inst_4076 = cljs.core.chunked_seq_QMARK_.call(null,inst_4074);
var state_4114__$1 = state_4114;
if(inst_4076){
var statearr_4143_4214 = state_4114__$1;
(statearr_4143_4214[(1)] = (36));

} else {
var statearr_4144_4215 = state_4114__$1;
(statearr_4144_4215[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (13))){
var inst_4005 = (state_4114[(24)]);
var inst_4008 = cljs.core.async.close_BANG_.call(null,inst_4005);
var state_4114__$1 = state_4114;
var statearr_4145_4216 = state_4114__$1;
(statearr_4145_4216[(2)] = inst_4008);

(statearr_4145_4216[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (22))){
var inst_4028 = (state_4114[(8)]);
var inst_4031 = cljs.core.async.close_BANG_.call(null,inst_4028);
var state_4114__$1 = state_4114;
var statearr_4146_4217 = state_4114__$1;
(statearr_4146_4217[(2)] = inst_4031);

(statearr_4146_4217[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (36))){
var inst_4074 = (state_4114[(23)]);
var inst_4078 = cljs.core.chunk_first.call(null,inst_4074);
var inst_4079 = cljs.core.chunk_rest.call(null,inst_4074);
var inst_4080 = cljs.core.count.call(null,inst_4078);
var inst_4056 = inst_4079;
var inst_4057 = inst_4078;
var inst_4058 = inst_4080;
var inst_4059 = (0);
var state_4114__$1 = (function (){var statearr_4147 = state_4114;
(statearr_4147[(19)] = inst_4056);

(statearr_4147[(9)] = inst_4057);

(statearr_4147[(11)] = inst_4059);

(statearr_4147[(20)] = inst_4058);

return statearr_4147;
})();
var statearr_4148_4218 = state_4114__$1;
(statearr_4148_4218[(2)] = null);

(statearr_4148_4218[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (41))){
var inst_4074 = (state_4114[(23)]);
var inst_4089 = (state_4114[(2)]);
var inst_4090 = cljs.core.next.call(null,inst_4074);
var inst_4056 = inst_4090;
var inst_4057 = null;
var inst_4058 = (0);
var inst_4059 = (0);
var state_4114__$1 = (function (){var statearr_4149 = state_4114;
(statearr_4149[(19)] = inst_4056);

(statearr_4149[(9)] = inst_4057);

(statearr_4149[(25)] = inst_4089);

(statearr_4149[(11)] = inst_4059);

(statearr_4149[(20)] = inst_4058);

return statearr_4149;
})();
var statearr_4150_4219 = state_4114__$1;
(statearr_4150_4219[(2)] = null);

(statearr_4150_4219[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (43))){
var state_4114__$1 = state_4114;
var statearr_4151_4220 = state_4114__$1;
(statearr_4151_4220[(2)] = null);

(statearr_4151_4220[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (29))){
var inst_4098 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4152_4221 = state_4114__$1;
(statearr_4152_4221[(2)] = inst_4098);

(statearr_4152_4221[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (44))){
var inst_4107 = (state_4114[(2)]);
var state_4114__$1 = (function (){var statearr_4153 = state_4114;
(statearr_4153[(26)] = inst_4107);

return statearr_4153;
})();
var statearr_4154_4222 = state_4114__$1;
(statearr_4154_4222[(2)] = null);

(statearr_4154_4222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (6))){
var inst_4048 = (state_4114[(27)]);
var inst_4047 = cljs.core.deref.call(null,cs);
var inst_4048__$1 = cljs.core.keys.call(null,inst_4047);
var inst_4049 = cljs.core.count.call(null,inst_4048__$1);
var inst_4050 = cljs.core.reset_BANG_.call(null,dctr,inst_4049);
var inst_4055 = cljs.core.seq.call(null,inst_4048__$1);
var inst_4056 = inst_4055;
var inst_4057 = null;
var inst_4058 = (0);
var inst_4059 = (0);
var state_4114__$1 = (function (){var statearr_4155 = state_4114;
(statearr_4155[(19)] = inst_4056);

(statearr_4155[(27)] = inst_4048__$1);

(statearr_4155[(9)] = inst_4057);

(statearr_4155[(28)] = inst_4050);

(statearr_4155[(11)] = inst_4059);

(statearr_4155[(20)] = inst_4058);

return statearr_4155;
})();
var statearr_4156_4223 = state_4114__$1;
(statearr_4156_4223[(2)] = null);

(statearr_4156_4223[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (28))){
var inst_4056 = (state_4114[(19)]);
var inst_4074 = (state_4114[(23)]);
var inst_4074__$1 = cljs.core.seq.call(null,inst_4056);
var state_4114__$1 = (function (){var statearr_4157 = state_4114;
(statearr_4157[(23)] = inst_4074__$1);

return statearr_4157;
})();
if(inst_4074__$1){
var statearr_4158_4224 = state_4114__$1;
(statearr_4158_4224[(1)] = (33));

} else {
var statearr_4159_4225 = state_4114__$1;
(statearr_4159_4225[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (25))){
var inst_4059 = (state_4114[(11)]);
var inst_4058 = (state_4114[(20)]);
var inst_4061 = (inst_4059 < inst_4058);
var inst_4062 = inst_4061;
var state_4114__$1 = state_4114;
if(cljs.core.truth_(inst_4062)){
var statearr_4160_4226 = state_4114__$1;
(statearr_4160_4226[(1)] = (27));

} else {
var statearr_4161_4227 = state_4114__$1;
(statearr_4161_4227[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (34))){
var state_4114__$1 = state_4114;
var statearr_4162_4228 = state_4114__$1;
(statearr_4162_4228[(2)] = null);

(statearr_4162_4228[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (17))){
var state_4114__$1 = state_4114;
var statearr_4163_4229 = state_4114__$1;
(statearr_4163_4229[(2)] = null);

(statearr_4163_4229[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (3))){
var inst_4112 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4114__$1,inst_4112);
} else {
if((state_val_4115 === (12))){
var inst_4043 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4164_4230 = state_4114__$1;
(statearr_4164_4230[(2)] = inst_4043);

(statearr_4164_4230[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (2))){
var state_4114__$1 = state_4114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4114__$1,(4),ch);
} else {
if((state_val_4115 === (23))){
var state_4114__$1 = state_4114;
var statearr_4165_4231 = state_4114__$1;
(statearr_4165_4231[(2)] = null);

(statearr_4165_4231[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (35))){
var inst_4096 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4166_4232 = state_4114__$1;
(statearr_4166_4232[(2)] = inst_4096);

(statearr_4166_4232[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (19))){
var inst_4015 = (state_4114[(7)]);
var inst_4019 = cljs.core.chunk_first.call(null,inst_4015);
var inst_4020 = cljs.core.chunk_rest.call(null,inst_4015);
var inst_4021 = cljs.core.count.call(null,inst_4019);
var inst_3993 = inst_4020;
var inst_3994 = inst_4019;
var inst_3995 = inst_4021;
var inst_3996 = (0);
var state_4114__$1 = (function (){var statearr_4167 = state_4114;
(statearr_4167[(13)] = inst_3993);

(statearr_4167[(14)] = inst_3994);

(statearr_4167[(15)] = inst_3996);

(statearr_4167[(16)] = inst_3995);

return statearr_4167;
})();
var statearr_4168_4233 = state_4114__$1;
(statearr_4168_4233[(2)] = null);

(statearr_4168_4233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (11))){
var inst_3993 = (state_4114[(13)]);
var inst_4015 = (state_4114[(7)]);
var inst_4015__$1 = cljs.core.seq.call(null,inst_3993);
var state_4114__$1 = (function (){var statearr_4169 = state_4114;
(statearr_4169[(7)] = inst_4015__$1);

return statearr_4169;
})();
if(inst_4015__$1){
var statearr_4170_4234 = state_4114__$1;
(statearr_4170_4234[(1)] = (16));

} else {
var statearr_4171_4235 = state_4114__$1;
(statearr_4171_4235[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (9))){
var inst_4045 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4172_4236 = state_4114__$1;
(statearr_4172_4236[(2)] = inst_4045);

(statearr_4172_4236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (5))){
var inst_3991 = cljs.core.deref.call(null,cs);
var inst_3992 = cljs.core.seq.call(null,inst_3991);
var inst_3993 = inst_3992;
var inst_3994 = null;
var inst_3995 = (0);
var inst_3996 = (0);
var state_4114__$1 = (function (){var statearr_4173 = state_4114;
(statearr_4173[(13)] = inst_3993);

(statearr_4173[(14)] = inst_3994);

(statearr_4173[(15)] = inst_3996);

(statearr_4173[(16)] = inst_3995);

return statearr_4173;
})();
var statearr_4174_4237 = state_4114__$1;
(statearr_4174_4237[(2)] = null);

(statearr_4174_4237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (14))){
var state_4114__$1 = state_4114;
var statearr_4175_4238 = state_4114__$1;
(statearr_4175_4238[(2)] = null);

(statearr_4175_4238[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (45))){
var inst_4104 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4176_4239 = state_4114__$1;
(statearr_4176_4239[(2)] = inst_4104);

(statearr_4176_4239[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (26))){
var inst_4048 = (state_4114[(27)]);
var inst_4100 = (state_4114[(2)]);
var inst_4101 = cljs.core.seq.call(null,inst_4048);
var state_4114__$1 = (function (){var statearr_4177 = state_4114;
(statearr_4177[(29)] = inst_4100);

return statearr_4177;
})();
if(inst_4101){
var statearr_4178_4240 = state_4114__$1;
(statearr_4178_4240[(1)] = (42));

} else {
var statearr_4179_4241 = state_4114__$1;
(statearr_4179_4241[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (16))){
var inst_4015 = (state_4114[(7)]);
var inst_4017 = cljs.core.chunked_seq_QMARK_.call(null,inst_4015);
var state_4114__$1 = state_4114;
if(inst_4017){
var statearr_4180_4242 = state_4114__$1;
(statearr_4180_4242[(1)] = (19));

} else {
var statearr_4181_4243 = state_4114__$1;
(statearr_4181_4243[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (38))){
var inst_4093 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4182_4244 = state_4114__$1;
(statearr_4182_4244[(2)] = inst_4093);

(statearr_4182_4244[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (30))){
var state_4114__$1 = state_4114;
var statearr_4183_4245 = state_4114__$1;
(statearr_4183_4245[(2)] = null);

(statearr_4183_4245[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (10))){
var inst_3994 = (state_4114[(14)]);
var inst_3996 = (state_4114[(15)]);
var inst_4004 = cljs.core._nth.call(null,inst_3994,inst_3996);
var inst_4005 = cljs.core.nth.call(null,inst_4004,(0),null);
var inst_4006 = cljs.core.nth.call(null,inst_4004,(1),null);
var state_4114__$1 = (function (){var statearr_4184 = state_4114;
(statearr_4184[(24)] = inst_4005);

return statearr_4184;
})();
if(cljs.core.truth_(inst_4006)){
var statearr_4185_4246 = state_4114__$1;
(statearr_4185_4246[(1)] = (13));

} else {
var statearr_4186_4247 = state_4114__$1;
(statearr_4186_4247[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (18))){
var inst_4041 = (state_4114[(2)]);
var state_4114__$1 = state_4114;
var statearr_4187_4248 = state_4114__$1;
(statearr_4187_4248[(2)] = inst_4041);

(statearr_4187_4248[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (42))){
var state_4114__$1 = state_4114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4114__$1,(45),dchan);
} else {
if((state_val_4115 === (37))){
var inst_3984 = (state_4114[(10)]);
var inst_4083 = (state_4114[(22)]);
var inst_4074 = (state_4114[(23)]);
var inst_4083__$1 = cljs.core.first.call(null,inst_4074);
var inst_4084 = cljs.core.async.put_BANG_.call(null,inst_4083__$1,inst_3984,done);
var state_4114__$1 = (function (){var statearr_4188 = state_4114;
(statearr_4188[(22)] = inst_4083__$1);

return statearr_4188;
})();
if(cljs.core.truth_(inst_4084)){
var statearr_4189_4249 = state_4114__$1;
(statearr_4189_4249[(1)] = (39));

} else {
var statearr_4190_4250 = state_4114__$1;
(statearr_4190_4250[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4115 === (8))){
var inst_3996 = (state_4114[(15)]);
var inst_3995 = (state_4114[(16)]);
var inst_3998 = (inst_3996 < inst_3995);
var inst_3999 = inst_3998;
var state_4114__$1 = state_4114;
if(cljs.core.truth_(inst_3999)){
var statearr_4191_4251 = state_4114__$1;
(statearr_4191_4251[(1)] = (10));

} else {
var statearr_4192_4252 = state_4114__$1;
(statearr_4192_4252[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__3282__auto__ = null;
var cljs$core$async$mult_$_state_machine__3282__auto____0 = (function (){
var statearr_4193 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4193[(0)] = cljs$core$async$mult_$_state_machine__3282__auto__);

(statearr_4193[(1)] = (1));

return statearr_4193;
});
var cljs$core$async$mult_$_state_machine__3282__auto____1 = (function (state_4114){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_4114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e4194){var ex__3285__auto__ = e4194;
var statearr_4195_4253 = state_4114;
(statearr_4195_4253[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_4114[(4)]))){
var statearr_4196_4254 = state_4114;
(statearr_4196_4254[(1)] = cljs.core.first.call(null,(state_4114[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4255 = state_4114;
state_4114 = G__4255;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__3282__auto__ = function(state_4114){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__3282__auto____1.call(this,state_4114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__3282__auto____0;
cljs$core$async$mult_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__3282__auto____1;
return cljs$core$async$mult_$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_4197 = f__3356__auto__.call(null);
(statearr_4197[(6)] = c__3355__auto___4198);

return statearr_4197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__4257 = arguments.length;
switch (G__4257) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_4259 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_4259.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_4260 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_4260.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_4261 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_4261.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_4262 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_4262.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_4263 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_4263.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___4274 = arguments.length;
var i__4737__auto___4275 = (0);
while(true){
if((i__4737__auto___4275 < len__4736__auto___4274)){
args__4742__auto__.push((arguments[i__4737__auto___4275]));

var G__4276 = (i__4737__auto___4275 + (1));
i__4737__auto___4275 = G__4276;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__4268){
var map__4269 = p__4268;
var map__4269__$1 = (((((!((map__4269 == null))))?(((((map__4269.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4269.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4269):map__4269);
var opts = map__4269__$1;
var statearr_4271_4277 = state;
(statearr_4271_4277[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_4272_4278 = state;
(statearr_4272_4278[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_4273_4279 = state;
(statearr_4273_4279[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq4264){
var G__4265 = cljs.core.first.call(null,seq4264);
var seq4264__$1 = cljs.core.next.call(null,seq4264);
var G__4266 = cljs.core.first.call(null,seq4264__$1);
var seq4264__$2 = cljs.core.next.call(null,seq4264__$1);
var G__4267 = cljs.core.first.call(null,seq4264__$2);
var seq4264__$3 = cljs.core.next.call(null,seq4264__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4265,G__4266,G__4267,seq4264__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4280 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4280 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta4281){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta4281 = meta4281;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4282,meta4281__$1){
var self__ = this;
var _4282__$1 = this;
return (new cljs.core.async.t_cljs$core$async4280(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta4281__$1));
}));

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4282){
var self__ = this;
var _4282__$1 = this;
return self__.meta4281;
}));

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async4280.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async4280.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta4281","meta4281",-1744850330,null)], null);
}));

(cljs.core.async.t_cljs$core$async4280.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4280.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4280");

(cljs.core.async.t_cljs$core$async4280.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4280");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4280.
 */
cljs.core.async.__GT_t_cljs$core$async4280 = (function cljs$core$async$mix_$___GT_t_cljs$core$async4280(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta4281){
return (new cljs.core.async.t_cljs$core$async4280(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta4281));
});

}

return (new cljs.core.async.t_cljs$core$async4280(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__3355__auto___4445 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_4384){
var state_val_4385 = (state_4384[(1)]);
if((state_val_4385 === (7))){
var inst_4299 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
var statearr_4386_4446 = state_4384__$1;
(statearr_4386_4446[(2)] = inst_4299);

(statearr_4386_4446[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (20))){
var inst_4311 = (state_4384[(7)]);
var state_4384__$1 = state_4384;
var statearr_4387_4447 = state_4384__$1;
(statearr_4387_4447[(2)] = inst_4311);

(statearr_4387_4447[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (27))){
var state_4384__$1 = state_4384;
var statearr_4388_4448 = state_4384__$1;
(statearr_4388_4448[(2)] = null);

(statearr_4388_4448[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (1))){
var inst_4286 = (state_4384[(8)]);
var inst_4286__$1 = calc_state.call(null);
var inst_4288 = (inst_4286__$1 == null);
var inst_4289 = cljs.core.not.call(null,inst_4288);
var state_4384__$1 = (function (){var statearr_4389 = state_4384;
(statearr_4389[(8)] = inst_4286__$1);

return statearr_4389;
})();
if(inst_4289){
var statearr_4390_4449 = state_4384__$1;
(statearr_4390_4449[(1)] = (2));

} else {
var statearr_4391_4450 = state_4384__$1;
(statearr_4391_4450[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (24))){
var inst_4344 = (state_4384[(9)]);
var inst_4358 = (state_4384[(10)]);
var inst_4335 = (state_4384[(11)]);
var inst_4358__$1 = inst_4335.call(null,inst_4344);
var state_4384__$1 = (function (){var statearr_4392 = state_4384;
(statearr_4392[(10)] = inst_4358__$1);

return statearr_4392;
})();
if(cljs.core.truth_(inst_4358__$1)){
var statearr_4393_4451 = state_4384__$1;
(statearr_4393_4451[(1)] = (29));

} else {
var statearr_4394_4452 = state_4384__$1;
(statearr_4394_4452[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (4))){
var inst_4302 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
if(cljs.core.truth_(inst_4302)){
var statearr_4395_4453 = state_4384__$1;
(statearr_4395_4453[(1)] = (8));

} else {
var statearr_4396_4454 = state_4384__$1;
(statearr_4396_4454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (15))){
var inst_4329 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
if(cljs.core.truth_(inst_4329)){
var statearr_4397_4455 = state_4384__$1;
(statearr_4397_4455[(1)] = (19));

} else {
var statearr_4398_4456 = state_4384__$1;
(statearr_4398_4456[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (21))){
var inst_4334 = (state_4384[(12)]);
var inst_4334__$1 = (state_4384[(2)]);
var inst_4335 = cljs.core.get.call(null,inst_4334__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_4336 = cljs.core.get.call(null,inst_4334__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_4337 = cljs.core.get.call(null,inst_4334__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_4384__$1 = (function (){var statearr_4399 = state_4384;
(statearr_4399[(13)] = inst_4336);

(statearr_4399[(11)] = inst_4335);

(statearr_4399[(12)] = inst_4334__$1);

return statearr_4399;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_4384__$1,(22),inst_4337);
} else {
if((state_val_4385 === (31))){
var inst_4366 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
if(cljs.core.truth_(inst_4366)){
var statearr_4400_4457 = state_4384__$1;
(statearr_4400_4457[(1)] = (32));

} else {
var statearr_4401_4458 = state_4384__$1;
(statearr_4401_4458[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (32))){
var inst_4343 = (state_4384[(14)]);
var state_4384__$1 = state_4384;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4384__$1,(35),out,inst_4343);
} else {
if((state_val_4385 === (33))){
var inst_4334 = (state_4384[(12)]);
var inst_4311 = inst_4334;
var state_4384__$1 = (function (){var statearr_4402 = state_4384;
(statearr_4402[(7)] = inst_4311);

return statearr_4402;
})();
var statearr_4403_4459 = state_4384__$1;
(statearr_4403_4459[(2)] = null);

(statearr_4403_4459[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (13))){
var inst_4311 = (state_4384[(7)]);
var inst_4318 = inst_4311.cljs$lang$protocol_mask$partition0$;
var inst_4319 = (inst_4318 & (64));
var inst_4320 = inst_4311.cljs$core$ISeq$;
var inst_4321 = (cljs.core.PROTOCOL_SENTINEL === inst_4320);
var inst_4322 = ((inst_4319) || (inst_4321));
var state_4384__$1 = state_4384;
if(cljs.core.truth_(inst_4322)){
var statearr_4404_4460 = state_4384__$1;
(statearr_4404_4460[(1)] = (16));

} else {
var statearr_4405_4461 = state_4384__$1;
(statearr_4405_4461[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (22))){
var inst_4344 = (state_4384[(9)]);
var inst_4343 = (state_4384[(14)]);
var inst_4342 = (state_4384[(2)]);
var inst_4343__$1 = cljs.core.nth.call(null,inst_4342,(0),null);
var inst_4344__$1 = cljs.core.nth.call(null,inst_4342,(1),null);
var inst_4345 = (inst_4343__$1 == null);
var inst_4346 = cljs.core._EQ_.call(null,inst_4344__$1,change);
var inst_4347 = ((inst_4345) || (inst_4346));
var state_4384__$1 = (function (){var statearr_4406 = state_4384;
(statearr_4406[(9)] = inst_4344__$1);

(statearr_4406[(14)] = inst_4343__$1);

return statearr_4406;
})();
if(cljs.core.truth_(inst_4347)){
var statearr_4407_4462 = state_4384__$1;
(statearr_4407_4462[(1)] = (23));

} else {
var statearr_4408_4463 = state_4384__$1;
(statearr_4408_4463[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (36))){
var inst_4334 = (state_4384[(12)]);
var inst_4311 = inst_4334;
var state_4384__$1 = (function (){var statearr_4409 = state_4384;
(statearr_4409[(7)] = inst_4311);

return statearr_4409;
})();
var statearr_4410_4464 = state_4384__$1;
(statearr_4410_4464[(2)] = null);

(statearr_4410_4464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (29))){
var inst_4358 = (state_4384[(10)]);
var state_4384__$1 = state_4384;
var statearr_4411_4465 = state_4384__$1;
(statearr_4411_4465[(2)] = inst_4358);

(statearr_4411_4465[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (6))){
var state_4384__$1 = state_4384;
var statearr_4412_4466 = state_4384__$1;
(statearr_4412_4466[(2)] = false);

(statearr_4412_4466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (28))){
var inst_4354 = (state_4384[(2)]);
var inst_4355 = calc_state.call(null);
var inst_4311 = inst_4355;
var state_4384__$1 = (function (){var statearr_4413 = state_4384;
(statearr_4413[(7)] = inst_4311);

(statearr_4413[(15)] = inst_4354);

return statearr_4413;
})();
var statearr_4414_4467 = state_4384__$1;
(statearr_4414_4467[(2)] = null);

(statearr_4414_4467[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (25))){
var inst_4380 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
var statearr_4415_4468 = state_4384__$1;
(statearr_4415_4468[(2)] = inst_4380);

(statearr_4415_4468[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (34))){
var inst_4378 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
var statearr_4416_4469 = state_4384__$1;
(statearr_4416_4469[(2)] = inst_4378);

(statearr_4416_4469[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (17))){
var state_4384__$1 = state_4384;
var statearr_4417_4470 = state_4384__$1;
(statearr_4417_4470[(2)] = false);

(statearr_4417_4470[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (3))){
var state_4384__$1 = state_4384;
var statearr_4418_4471 = state_4384__$1;
(statearr_4418_4471[(2)] = false);

(statearr_4418_4471[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (12))){
var inst_4382 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4384__$1,inst_4382);
} else {
if((state_val_4385 === (2))){
var inst_4286 = (state_4384[(8)]);
var inst_4291 = inst_4286.cljs$lang$protocol_mask$partition0$;
var inst_4292 = (inst_4291 & (64));
var inst_4293 = inst_4286.cljs$core$ISeq$;
var inst_4294 = (cljs.core.PROTOCOL_SENTINEL === inst_4293);
var inst_4295 = ((inst_4292) || (inst_4294));
var state_4384__$1 = state_4384;
if(cljs.core.truth_(inst_4295)){
var statearr_4419_4472 = state_4384__$1;
(statearr_4419_4472[(1)] = (5));

} else {
var statearr_4420_4473 = state_4384__$1;
(statearr_4420_4473[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (23))){
var inst_4343 = (state_4384[(14)]);
var inst_4349 = (inst_4343 == null);
var state_4384__$1 = state_4384;
if(cljs.core.truth_(inst_4349)){
var statearr_4421_4474 = state_4384__$1;
(statearr_4421_4474[(1)] = (26));

} else {
var statearr_4422_4475 = state_4384__$1;
(statearr_4422_4475[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (35))){
var inst_4369 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
if(cljs.core.truth_(inst_4369)){
var statearr_4423_4476 = state_4384__$1;
(statearr_4423_4476[(1)] = (36));

} else {
var statearr_4424_4477 = state_4384__$1;
(statearr_4424_4477[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (19))){
var inst_4311 = (state_4384[(7)]);
var inst_4331 = cljs.core.apply.call(null,cljs.core.hash_map,inst_4311);
var state_4384__$1 = state_4384;
var statearr_4425_4478 = state_4384__$1;
(statearr_4425_4478[(2)] = inst_4331);

(statearr_4425_4478[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (11))){
var inst_4311 = (state_4384[(7)]);
var inst_4315 = (inst_4311 == null);
var inst_4316 = cljs.core.not.call(null,inst_4315);
var state_4384__$1 = state_4384;
if(inst_4316){
var statearr_4426_4479 = state_4384__$1;
(statearr_4426_4479[(1)] = (13));

} else {
var statearr_4427_4480 = state_4384__$1;
(statearr_4427_4480[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (9))){
var inst_4286 = (state_4384[(8)]);
var state_4384__$1 = state_4384;
var statearr_4428_4481 = state_4384__$1;
(statearr_4428_4481[(2)] = inst_4286);

(statearr_4428_4481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (5))){
var state_4384__$1 = state_4384;
var statearr_4429_4482 = state_4384__$1;
(statearr_4429_4482[(2)] = true);

(statearr_4429_4482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (14))){
var state_4384__$1 = state_4384;
var statearr_4430_4483 = state_4384__$1;
(statearr_4430_4483[(2)] = false);

(statearr_4430_4483[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (26))){
var inst_4344 = (state_4384[(9)]);
var inst_4351 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_4344);
var state_4384__$1 = state_4384;
var statearr_4431_4484 = state_4384__$1;
(statearr_4431_4484[(2)] = inst_4351);

(statearr_4431_4484[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (16))){
var state_4384__$1 = state_4384;
var statearr_4432_4485 = state_4384__$1;
(statearr_4432_4485[(2)] = true);

(statearr_4432_4485[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (38))){
var inst_4374 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
var statearr_4433_4486 = state_4384__$1;
(statearr_4433_4486[(2)] = inst_4374);

(statearr_4433_4486[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (30))){
var inst_4336 = (state_4384[(13)]);
var inst_4344 = (state_4384[(9)]);
var inst_4335 = (state_4384[(11)]);
var inst_4361 = cljs.core.empty_QMARK_.call(null,inst_4335);
var inst_4362 = inst_4336.call(null,inst_4344);
var inst_4363 = cljs.core.not.call(null,inst_4362);
var inst_4364 = ((inst_4361) && (inst_4363));
var state_4384__$1 = state_4384;
var statearr_4434_4487 = state_4384__$1;
(statearr_4434_4487[(2)] = inst_4364);

(statearr_4434_4487[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (10))){
var inst_4286 = (state_4384[(8)]);
var inst_4307 = (state_4384[(2)]);
var inst_4308 = cljs.core.get.call(null,inst_4307,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_4309 = cljs.core.get.call(null,inst_4307,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_4310 = cljs.core.get.call(null,inst_4307,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_4311 = inst_4286;
var state_4384__$1 = (function (){var statearr_4435 = state_4384;
(statearr_4435[(16)] = inst_4308);

(statearr_4435[(17)] = inst_4310);

(statearr_4435[(7)] = inst_4311);

(statearr_4435[(18)] = inst_4309);

return statearr_4435;
})();
var statearr_4436_4488 = state_4384__$1;
(statearr_4436_4488[(2)] = null);

(statearr_4436_4488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (18))){
var inst_4326 = (state_4384[(2)]);
var state_4384__$1 = state_4384;
var statearr_4437_4489 = state_4384__$1;
(statearr_4437_4489[(2)] = inst_4326);

(statearr_4437_4489[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (37))){
var state_4384__$1 = state_4384;
var statearr_4438_4490 = state_4384__$1;
(statearr_4438_4490[(2)] = null);

(statearr_4438_4490[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4385 === (8))){
var inst_4286 = (state_4384[(8)]);
var inst_4304 = cljs.core.apply.call(null,cljs.core.hash_map,inst_4286);
var state_4384__$1 = state_4384;
var statearr_4439_4491 = state_4384__$1;
(statearr_4439_4491[(2)] = inst_4304);

(statearr_4439_4491[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__3282__auto__ = null;
var cljs$core$async$mix_$_state_machine__3282__auto____0 = (function (){
var statearr_4440 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4440[(0)] = cljs$core$async$mix_$_state_machine__3282__auto__);

(statearr_4440[(1)] = (1));

return statearr_4440;
});
var cljs$core$async$mix_$_state_machine__3282__auto____1 = (function (state_4384){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_4384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e4441){var ex__3285__auto__ = e4441;
var statearr_4442_4492 = state_4384;
(statearr_4442_4492[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_4384[(4)]))){
var statearr_4443_4493 = state_4384;
(statearr_4443_4493[(1)] = cljs.core.first.call(null,(state_4384[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4494 = state_4384;
state_4384 = G__4494;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__3282__auto__ = function(state_4384){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__3282__auto____1.call(this,state_4384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__3282__auto____0;
cljs$core$async$mix_$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__3282__auto____1;
return cljs$core$async$mix_$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_4444 = f__3356__auto__.call(null);
(statearr_4444[(6)] = c__3355__auto___4445);

return statearr_4444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_4497 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_4497.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_4498 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_4498.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_4499 = (function() {
var G__4500 = null;
var G__4500__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__4500__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__4500 = function(p,v){
switch(arguments.length){
case 1:
return G__4500__1.call(this,p);
case 2:
return G__4500__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4500.cljs$core$IFn$_invoke$arity$1 = G__4500__1;
G__4500.cljs$core$IFn$_invoke$arity$2 = G__4500__2;
return G__4500;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__4496 = arguments.length;
switch (G__4496) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_4499.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_4499.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__4504 = arguments.length;
switch (G__4504) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__4502_SHARP_){
if(cljs.core.truth_(p1__4502_SHARP_.call(null,topic))){
return p1__4502_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__4502_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4505 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4505 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta4506){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta4506 = meta4506;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4507,meta4506__$1){
var self__ = this;
var _4507__$1 = this;
return (new cljs.core.async.t_cljs$core$async4505(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta4506__$1));
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4507){
var self__ = this;
var _4507__$1 = this;
return self__.meta4506;
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async4505.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async4505.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta4506","meta4506",465705946,null)], null);
}));

(cljs.core.async.t_cljs$core$async4505.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4505.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4505");

(cljs.core.async.t_cljs$core$async4505.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4505");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4505.
 */
cljs.core.async.__GT_t_cljs$core$async4505 = (function cljs$core$async$__GT_t_cljs$core$async4505(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4506){
return (new cljs.core.async.t_cljs$core$async4505(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta4506));
});

}

return (new cljs.core.async.t_cljs$core$async4505(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__3355__auto___4626 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_4579){
var state_val_4580 = (state_4579[(1)]);
if((state_val_4580 === (7))){
var inst_4575 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
var statearr_4581_4627 = state_4579__$1;
(statearr_4581_4627[(2)] = inst_4575);

(statearr_4581_4627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (20))){
var state_4579__$1 = state_4579;
var statearr_4582_4628 = state_4579__$1;
(statearr_4582_4628[(2)] = null);

(statearr_4582_4628[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (1))){
var state_4579__$1 = state_4579;
var statearr_4583_4629 = state_4579__$1;
(statearr_4583_4629[(2)] = null);

(statearr_4583_4629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (24))){
var inst_4558 = (state_4579[(7)]);
var inst_4567 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_4558);
var state_4579__$1 = state_4579;
var statearr_4584_4630 = state_4579__$1;
(statearr_4584_4630[(2)] = inst_4567);

(statearr_4584_4630[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (4))){
var inst_4510 = (state_4579[(8)]);
var inst_4510__$1 = (state_4579[(2)]);
var inst_4511 = (inst_4510__$1 == null);
var state_4579__$1 = (function (){var statearr_4585 = state_4579;
(statearr_4585[(8)] = inst_4510__$1);

return statearr_4585;
})();
if(cljs.core.truth_(inst_4511)){
var statearr_4586_4631 = state_4579__$1;
(statearr_4586_4631[(1)] = (5));

} else {
var statearr_4587_4632 = state_4579__$1;
(statearr_4587_4632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (15))){
var inst_4552 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
var statearr_4588_4633 = state_4579__$1;
(statearr_4588_4633[(2)] = inst_4552);

(statearr_4588_4633[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (21))){
var inst_4572 = (state_4579[(2)]);
var state_4579__$1 = (function (){var statearr_4589 = state_4579;
(statearr_4589[(9)] = inst_4572);

return statearr_4589;
})();
var statearr_4590_4634 = state_4579__$1;
(statearr_4590_4634[(2)] = null);

(statearr_4590_4634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (13))){
var inst_4534 = (state_4579[(10)]);
var inst_4536 = cljs.core.chunked_seq_QMARK_.call(null,inst_4534);
var state_4579__$1 = state_4579;
if(inst_4536){
var statearr_4591_4635 = state_4579__$1;
(statearr_4591_4635[(1)] = (16));

} else {
var statearr_4592_4636 = state_4579__$1;
(statearr_4592_4636[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (22))){
var inst_4564 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
if(cljs.core.truth_(inst_4564)){
var statearr_4593_4637 = state_4579__$1;
(statearr_4593_4637[(1)] = (23));

} else {
var statearr_4594_4638 = state_4579__$1;
(statearr_4594_4638[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (6))){
var inst_4560 = (state_4579[(11)]);
var inst_4510 = (state_4579[(8)]);
var inst_4558 = (state_4579[(7)]);
var inst_4558__$1 = topic_fn.call(null,inst_4510);
var inst_4559 = cljs.core.deref.call(null,mults);
var inst_4560__$1 = cljs.core.get.call(null,inst_4559,inst_4558__$1);
var state_4579__$1 = (function (){var statearr_4595 = state_4579;
(statearr_4595[(11)] = inst_4560__$1);

(statearr_4595[(7)] = inst_4558__$1);

return statearr_4595;
})();
if(cljs.core.truth_(inst_4560__$1)){
var statearr_4596_4639 = state_4579__$1;
(statearr_4596_4639[(1)] = (19));

} else {
var statearr_4597_4640 = state_4579__$1;
(statearr_4597_4640[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (25))){
var inst_4569 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
var statearr_4598_4641 = state_4579__$1;
(statearr_4598_4641[(2)] = inst_4569);

(statearr_4598_4641[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (17))){
var inst_4534 = (state_4579[(10)]);
var inst_4543 = cljs.core.first.call(null,inst_4534);
var inst_4544 = cljs.core.async.muxch_STAR_.call(null,inst_4543);
var inst_4545 = cljs.core.async.close_BANG_.call(null,inst_4544);
var inst_4546 = cljs.core.next.call(null,inst_4534);
var inst_4520 = inst_4546;
var inst_4521 = null;
var inst_4522 = (0);
var inst_4523 = (0);
var state_4579__$1 = (function (){var statearr_4599 = state_4579;
(statearr_4599[(12)] = inst_4545);

(statearr_4599[(13)] = inst_4520);

(statearr_4599[(14)] = inst_4522);

(statearr_4599[(15)] = inst_4521);

(statearr_4599[(16)] = inst_4523);

return statearr_4599;
})();
var statearr_4600_4642 = state_4579__$1;
(statearr_4600_4642[(2)] = null);

(statearr_4600_4642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (3))){
var inst_4577 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4579__$1,inst_4577);
} else {
if((state_val_4580 === (12))){
var inst_4554 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
var statearr_4601_4643 = state_4579__$1;
(statearr_4601_4643[(2)] = inst_4554);

(statearr_4601_4643[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (2))){
var state_4579__$1 = state_4579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4579__$1,(4),ch);
} else {
if((state_val_4580 === (23))){
var state_4579__$1 = state_4579;
var statearr_4602_4644 = state_4579__$1;
(statearr_4602_4644[(2)] = null);

(statearr_4602_4644[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (19))){
var inst_4560 = (state_4579[(11)]);
var inst_4510 = (state_4579[(8)]);
var inst_4562 = cljs.core.async.muxch_STAR_.call(null,inst_4560);
var state_4579__$1 = state_4579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4579__$1,(22),inst_4562,inst_4510);
} else {
if((state_val_4580 === (11))){
var inst_4534 = (state_4579[(10)]);
var inst_4520 = (state_4579[(13)]);
var inst_4534__$1 = cljs.core.seq.call(null,inst_4520);
var state_4579__$1 = (function (){var statearr_4603 = state_4579;
(statearr_4603[(10)] = inst_4534__$1);

return statearr_4603;
})();
if(inst_4534__$1){
var statearr_4604_4645 = state_4579__$1;
(statearr_4604_4645[(1)] = (13));

} else {
var statearr_4605_4646 = state_4579__$1;
(statearr_4605_4646[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (9))){
var inst_4556 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
var statearr_4606_4647 = state_4579__$1;
(statearr_4606_4647[(2)] = inst_4556);

(statearr_4606_4647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (5))){
var inst_4517 = cljs.core.deref.call(null,mults);
var inst_4518 = cljs.core.vals.call(null,inst_4517);
var inst_4519 = cljs.core.seq.call(null,inst_4518);
var inst_4520 = inst_4519;
var inst_4521 = null;
var inst_4522 = (0);
var inst_4523 = (0);
var state_4579__$1 = (function (){var statearr_4607 = state_4579;
(statearr_4607[(13)] = inst_4520);

(statearr_4607[(14)] = inst_4522);

(statearr_4607[(15)] = inst_4521);

(statearr_4607[(16)] = inst_4523);

return statearr_4607;
})();
var statearr_4608_4648 = state_4579__$1;
(statearr_4608_4648[(2)] = null);

(statearr_4608_4648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (14))){
var state_4579__$1 = state_4579;
var statearr_4612_4649 = state_4579__$1;
(statearr_4612_4649[(2)] = null);

(statearr_4612_4649[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (16))){
var inst_4534 = (state_4579[(10)]);
var inst_4538 = cljs.core.chunk_first.call(null,inst_4534);
var inst_4539 = cljs.core.chunk_rest.call(null,inst_4534);
var inst_4540 = cljs.core.count.call(null,inst_4538);
var inst_4520 = inst_4539;
var inst_4521 = inst_4538;
var inst_4522 = inst_4540;
var inst_4523 = (0);
var state_4579__$1 = (function (){var statearr_4613 = state_4579;
(statearr_4613[(13)] = inst_4520);

(statearr_4613[(14)] = inst_4522);

(statearr_4613[(15)] = inst_4521);

(statearr_4613[(16)] = inst_4523);

return statearr_4613;
})();
var statearr_4614_4650 = state_4579__$1;
(statearr_4614_4650[(2)] = null);

(statearr_4614_4650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (10))){
var inst_4520 = (state_4579[(13)]);
var inst_4522 = (state_4579[(14)]);
var inst_4521 = (state_4579[(15)]);
var inst_4523 = (state_4579[(16)]);
var inst_4528 = cljs.core._nth.call(null,inst_4521,inst_4523);
var inst_4529 = cljs.core.async.muxch_STAR_.call(null,inst_4528);
var inst_4530 = cljs.core.async.close_BANG_.call(null,inst_4529);
var inst_4531 = (inst_4523 + (1));
var tmp4609 = inst_4520;
var tmp4610 = inst_4522;
var tmp4611 = inst_4521;
var inst_4520__$1 = tmp4609;
var inst_4521__$1 = tmp4611;
var inst_4522__$1 = tmp4610;
var inst_4523__$1 = inst_4531;
var state_4579__$1 = (function (){var statearr_4615 = state_4579;
(statearr_4615[(17)] = inst_4530);

(statearr_4615[(13)] = inst_4520__$1);

(statearr_4615[(14)] = inst_4522__$1);

(statearr_4615[(15)] = inst_4521__$1);

(statearr_4615[(16)] = inst_4523__$1);

return statearr_4615;
})();
var statearr_4616_4651 = state_4579__$1;
(statearr_4616_4651[(2)] = null);

(statearr_4616_4651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (18))){
var inst_4549 = (state_4579[(2)]);
var state_4579__$1 = state_4579;
var statearr_4617_4652 = state_4579__$1;
(statearr_4617_4652[(2)] = inst_4549);

(statearr_4617_4652[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4580 === (8))){
var inst_4522 = (state_4579[(14)]);
var inst_4523 = (state_4579[(16)]);
var inst_4525 = (inst_4523 < inst_4522);
var inst_4526 = inst_4525;
var state_4579__$1 = state_4579;
if(cljs.core.truth_(inst_4526)){
var statearr_4618_4653 = state_4579__$1;
(statearr_4618_4653[(1)] = (10));

} else {
var statearr_4619_4654 = state_4579__$1;
(statearr_4619_4654[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_4620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4620[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_4620[(1)] = (1));

return statearr_4620;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_4579){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_4579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e4621){var ex__3285__auto__ = e4621;
var statearr_4622_4655 = state_4579;
(statearr_4622_4655[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_4579[(4)]))){
var statearr_4623_4656 = state_4579;
(statearr_4623_4656[(1)] = cljs.core.first.call(null,(state_4579[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4657 = state_4579;
state_4579 = G__4657;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_4579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_4579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_4624 = f__3356__auto__.call(null);
(statearr_4624[(6)] = c__3355__auto___4626);

return statearr_4624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__4659 = arguments.length;
switch (G__4659) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__4662 = arguments.length;
switch (G__4662) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__4665 = arguments.length;
switch (G__4665) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__3355__auto___4743 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_4708){
var state_val_4709 = (state_4708[(1)]);
if((state_val_4709 === (7))){
var state_4708__$1 = state_4708;
var statearr_4710_4744 = state_4708__$1;
(statearr_4710_4744[(2)] = null);

(statearr_4710_4744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (1))){
var state_4708__$1 = state_4708;
var statearr_4711_4745 = state_4708__$1;
(statearr_4711_4745[(2)] = null);

(statearr_4711_4745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (4))){
var inst_4668 = (state_4708[(7)]);
var inst_4669 = (state_4708[(8)]);
var inst_4671 = (inst_4669 < inst_4668);
var state_4708__$1 = state_4708;
if(cljs.core.truth_(inst_4671)){
var statearr_4712_4746 = state_4708__$1;
(statearr_4712_4746[(1)] = (6));

} else {
var statearr_4713_4747 = state_4708__$1;
(statearr_4713_4747[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (15))){
var inst_4694 = (state_4708[(9)]);
var inst_4699 = cljs.core.apply.call(null,f,inst_4694);
var state_4708__$1 = state_4708;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4708__$1,(17),out,inst_4699);
} else {
if((state_val_4709 === (13))){
var inst_4694 = (state_4708[(9)]);
var inst_4694__$1 = (state_4708[(2)]);
var inst_4695 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_4694__$1);
var state_4708__$1 = (function (){var statearr_4714 = state_4708;
(statearr_4714[(9)] = inst_4694__$1);

return statearr_4714;
})();
if(cljs.core.truth_(inst_4695)){
var statearr_4715_4748 = state_4708__$1;
(statearr_4715_4748[(1)] = (14));

} else {
var statearr_4716_4749 = state_4708__$1;
(statearr_4716_4749[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (6))){
var state_4708__$1 = state_4708;
var statearr_4717_4750 = state_4708__$1;
(statearr_4717_4750[(2)] = null);

(statearr_4717_4750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (17))){
var inst_4701 = (state_4708[(2)]);
var state_4708__$1 = (function (){var statearr_4719 = state_4708;
(statearr_4719[(10)] = inst_4701);

return statearr_4719;
})();
var statearr_4720_4751 = state_4708__$1;
(statearr_4720_4751[(2)] = null);

(statearr_4720_4751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (3))){
var inst_4706 = (state_4708[(2)]);
var state_4708__$1 = state_4708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4708__$1,inst_4706);
} else {
if((state_val_4709 === (12))){
var _ = (function (){var statearr_4721 = state_4708;
(statearr_4721[(4)] = cljs.core.rest.call(null,(state_4708[(4)])));

return statearr_4721;
})();
var state_4708__$1 = state_4708;
var ex4718 = (state_4708__$1[(2)]);
var statearr_4722_4752 = state_4708__$1;
(statearr_4722_4752[(5)] = ex4718);


if((ex4718 instanceof Object)){
var statearr_4723_4753 = state_4708__$1;
(statearr_4723_4753[(1)] = (11));

(statearr_4723_4753[(5)] = null);

} else {
throw ex4718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (2))){
var inst_4667 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_4668 = cnt;
var inst_4669 = (0);
var state_4708__$1 = (function (){var statearr_4724 = state_4708;
(statearr_4724[(7)] = inst_4668);

(statearr_4724[(8)] = inst_4669);

(statearr_4724[(11)] = inst_4667);

return statearr_4724;
})();
var statearr_4725_4754 = state_4708__$1;
(statearr_4725_4754[(2)] = null);

(statearr_4725_4754[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (11))){
var inst_4673 = (state_4708[(2)]);
var inst_4674 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_4708__$1 = (function (){var statearr_4726 = state_4708;
(statearr_4726[(12)] = inst_4673);

return statearr_4726;
})();
var statearr_4727_4755 = state_4708__$1;
(statearr_4727_4755[(2)] = inst_4674);

(statearr_4727_4755[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (9))){
var inst_4669 = (state_4708[(8)]);
var _ = (function (){var statearr_4728 = state_4708;
(statearr_4728[(4)] = cljs.core.cons.call(null,(12),(state_4708[(4)])));

return statearr_4728;
})();
var inst_4680 = chs__$1.call(null,inst_4669);
var inst_4681 = done.call(null,inst_4669);
var inst_4682 = cljs.core.async.take_BANG_.call(null,inst_4680,inst_4681);
var ___$1 = (function (){var statearr_4729 = state_4708;
(statearr_4729[(4)] = cljs.core.rest.call(null,(state_4708[(4)])));

return statearr_4729;
})();
var state_4708__$1 = state_4708;
var statearr_4730_4756 = state_4708__$1;
(statearr_4730_4756[(2)] = inst_4682);

(statearr_4730_4756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (5))){
var inst_4692 = (state_4708[(2)]);
var state_4708__$1 = (function (){var statearr_4731 = state_4708;
(statearr_4731[(13)] = inst_4692);

return statearr_4731;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4708__$1,(13),dchan);
} else {
if((state_val_4709 === (14))){
var inst_4697 = cljs.core.async.close_BANG_.call(null,out);
var state_4708__$1 = state_4708;
var statearr_4732_4757 = state_4708__$1;
(statearr_4732_4757[(2)] = inst_4697);

(statearr_4732_4757[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (16))){
var inst_4704 = (state_4708[(2)]);
var state_4708__$1 = state_4708;
var statearr_4733_4758 = state_4708__$1;
(statearr_4733_4758[(2)] = inst_4704);

(statearr_4733_4758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (10))){
var inst_4669 = (state_4708[(8)]);
var inst_4685 = (state_4708[(2)]);
var inst_4686 = (inst_4669 + (1));
var inst_4669__$1 = inst_4686;
var state_4708__$1 = (function (){var statearr_4734 = state_4708;
(statearr_4734[(8)] = inst_4669__$1);

(statearr_4734[(14)] = inst_4685);

return statearr_4734;
})();
var statearr_4735_4759 = state_4708__$1;
(statearr_4735_4759[(2)] = null);

(statearr_4735_4759[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4709 === (8))){
var inst_4690 = (state_4708[(2)]);
var state_4708__$1 = state_4708;
var statearr_4736_4760 = state_4708__$1;
(statearr_4736_4760[(2)] = inst_4690);

(statearr_4736_4760[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_4737 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4737[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_4737[(1)] = (1));

return statearr_4737;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_4708){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_4708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e4738){var ex__3285__auto__ = e4738;
var statearr_4739_4761 = state_4708;
(statearr_4739_4761[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_4708[(4)]))){
var statearr_4740_4762 = state_4708;
(statearr_4740_4762[(1)] = cljs.core.first.call(null,(state_4708[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4763 = state_4708;
state_4708 = G__4763;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_4708){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_4708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_4741 = f__3356__auto__.call(null);
(statearr_4741[(6)] = c__3355__auto___4743);

return statearr_4741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__4766 = arguments.length;
switch (G__4766) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3355__auto___4821 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_4798){
var state_val_4799 = (state_4798[(1)]);
if((state_val_4799 === (7))){
var inst_4777 = (state_4798[(7)]);
var inst_4778 = (state_4798[(8)]);
var inst_4777__$1 = (state_4798[(2)]);
var inst_4778__$1 = cljs.core.nth.call(null,inst_4777__$1,(0),null);
var inst_4779 = cljs.core.nth.call(null,inst_4777__$1,(1),null);
var inst_4780 = (inst_4778__$1 == null);
var state_4798__$1 = (function (){var statearr_4800 = state_4798;
(statearr_4800[(9)] = inst_4779);

(statearr_4800[(7)] = inst_4777__$1);

(statearr_4800[(8)] = inst_4778__$1);

return statearr_4800;
})();
if(cljs.core.truth_(inst_4780)){
var statearr_4801_4822 = state_4798__$1;
(statearr_4801_4822[(1)] = (8));

} else {
var statearr_4802_4823 = state_4798__$1;
(statearr_4802_4823[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4799 === (1))){
var inst_4767 = cljs.core.vec.call(null,chs);
var inst_4768 = inst_4767;
var state_4798__$1 = (function (){var statearr_4803 = state_4798;
(statearr_4803[(10)] = inst_4768);

return statearr_4803;
})();
var statearr_4804_4824 = state_4798__$1;
(statearr_4804_4824[(2)] = null);

(statearr_4804_4824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4799 === (4))){
var inst_4768 = (state_4798[(10)]);
var state_4798__$1 = state_4798;
return cljs.core.async.ioc_alts_BANG_.call(null,state_4798__$1,(7),inst_4768);
} else {
if((state_val_4799 === (6))){
var inst_4794 = (state_4798[(2)]);
var state_4798__$1 = state_4798;
var statearr_4805_4825 = state_4798__$1;
(statearr_4805_4825[(2)] = inst_4794);

(statearr_4805_4825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4799 === (3))){
var inst_4796 = (state_4798[(2)]);
var state_4798__$1 = state_4798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4798__$1,inst_4796);
} else {
if((state_val_4799 === (2))){
var inst_4768 = (state_4798[(10)]);
var inst_4770 = cljs.core.count.call(null,inst_4768);
var inst_4771 = (inst_4770 > (0));
var state_4798__$1 = state_4798;
if(cljs.core.truth_(inst_4771)){
var statearr_4807_4826 = state_4798__$1;
(statearr_4807_4826[(1)] = (4));

} else {
var statearr_4808_4827 = state_4798__$1;
(statearr_4808_4827[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4799 === (11))){
var inst_4768 = (state_4798[(10)]);
var inst_4787 = (state_4798[(2)]);
var tmp4806 = inst_4768;
var inst_4768__$1 = tmp4806;
var state_4798__$1 = (function (){var statearr_4809 = state_4798;
(statearr_4809[(11)] = inst_4787);

(statearr_4809[(10)] = inst_4768__$1);

return statearr_4809;
})();
var statearr_4810_4828 = state_4798__$1;
(statearr_4810_4828[(2)] = null);

(statearr_4810_4828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4799 === (9))){
var inst_4778 = (state_4798[(8)]);
var state_4798__$1 = state_4798;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4798__$1,(11),out,inst_4778);
} else {
if((state_val_4799 === (5))){
var inst_4792 = cljs.core.async.close_BANG_.call(null,out);
var state_4798__$1 = state_4798;
var statearr_4811_4829 = state_4798__$1;
(statearr_4811_4829[(2)] = inst_4792);

(statearr_4811_4829[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4799 === (10))){
var inst_4790 = (state_4798[(2)]);
var state_4798__$1 = state_4798;
var statearr_4812_4830 = state_4798__$1;
(statearr_4812_4830[(2)] = inst_4790);

(statearr_4812_4830[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4799 === (8))){
var inst_4779 = (state_4798[(9)]);
var inst_4777 = (state_4798[(7)]);
var inst_4778 = (state_4798[(8)]);
var inst_4768 = (state_4798[(10)]);
var inst_4782 = (function (){var cs = inst_4768;
var vec__4773 = inst_4777;
var v = inst_4778;
var c = inst_4779;
return (function (p1__4764_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__4764_SHARP_);
});
})();
var inst_4783 = cljs.core.filterv.call(null,inst_4782,inst_4768);
var inst_4768__$1 = inst_4783;
var state_4798__$1 = (function (){var statearr_4813 = state_4798;
(statearr_4813[(10)] = inst_4768__$1);

return statearr_4813;
})();
var statearr_4814_4831 = state_4798__$1;
(statearr_4814_4831[(2)] = null);

(statearr_4814_4831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_4815 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4815[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_4815[(1)] = (1));

return statearr_4815;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_4798){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_4798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e4816){var ex__3285__auto__ = e4816;
var statearr_4817_4832 = state_4798;
(statearr_4817_4832[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_4798[(4)]))){
var statearr_4818_4833 = state_4798;
(statearr_4818_4833[(1)] = cljs.core.first.call(null,(state_4798[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4834 = state_4798;
state_4798 = G__4834;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_4798){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_4798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_4819 = f__3356__auto__.call(null);
(statearr_4819[(6)] = c__3355__auto___4821);

return statearr_4819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__4836 = arguments.length;
switch (G__4836) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3355__auto___4882 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_4860){
var state_val_4861 = (state_4860[(1)]);
if((state_val_4861 === (7))){
var inst_4842 = (state_4860[(7)]);
var inst_4842__$1 = (state_4860[(2)]);
var inst_4843 = (inst_4842__$1 == null);
var inst_4844 = cljs.core.not.call(null,inst_4843);
var state_4860__$1 = (function (){var statearr_4862 = state_4860;
(statearr_4862[(7)] = inst_4842__$1);

return statearr_4862;
})();
if(inst_4844){
var statearr_4863_4883 = state_4860__$1;
(statearr_4863_4883[(1)] = (8));

} else {
var statearr_4864_4884 = state_4860__$1;
(statearr_4864_4884[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (1))){
var inst_4837 = (0);
var state_4860__$1 = (function (){var statearr_4865 = state_4860;
(statearr_4865[(8)] = inst_4837);

return statearr_4865;
})();
var statearr_4866_4885 = state_4860__$1;
(statearr_4866_4885[(2)] = null);

(statearr_4866_4885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (4))){
var state_4860__$1 = state_4860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4860__$1,(7),ch);
} else {
if((state_val_4861 === (6))){
var inst_4855 = (state_4860[(2)]);
var state_4860__$1 = state_4860;
var statearr_4867_4886 = state_4860__$1;
(statearr_4867_4886[(2)] = inst_4855);

(statearr_4867_4886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (3))){
var inst_4857 = (state_4860[(2)]);
var inst_4858 = cljs.core.async.close_BANG_.call(null,out);
var state_4860__$1 = (function (){var statearr_4868 = state_4860;
(statearr_4868[(9)] = inst_4857);

return statearr_4868;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4860__$1,inst_4858);
} else {
if((state_val_4861 === (2))){
var inst_4837 = (state_4860[(8)]);
var inst_4839 = (inst_4837 < n);
var state_4860__$1 = state_4860;
if(cljs.core.truth_(inst_4839)){
var statearr_4869_4887 = state_4860__$1;
(statearr_4869_4887[(1)] = (4));

} else {
var statearr_4870_4888 = state_4860__$1;
(statearr_4870_4888[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (11))){
var inst_4837 = (state_4860[(8)]);
var inst_4847 = (state_4860[(2)]);
var inst_4848 = (inst_4837 + (1));
var inst_4837__$1 = inst_4848;
var state_4860__$1 = (function (){var statearr_4871 = state_4860;
(statearr_4871[(8)] = inst_4837__$1);

(statearr_4871[(10)] = inst_4847);

return statearr_4871;
})();
var statearr_4872_4889 = state_4860__$1;
(statearr_4872_4889[(2)] = null);

(statearr_4872_4889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (9))){
var state_4860__$1 = state_4860;
var statearr_4873_4890 = state_4860__$1;
(statearr_4873_4890[(2)] = null);

(statearr_4873_4890[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (5))){
var state_4860__$1 = state_4860;
var statearr_4874_4891 = state_4860__$1;
(statearr_4874_4891[(2)] = null);

(statearr_4874_4891[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (10))){
var inst_4852 = (state_4860[(2)]);
var state_4860__$1 = state_4860;
var statearr_4875_4892 = state_4860__$1;
(statearr_4875_4892[(2)] = inst_4852);

(statearr_4875_4892[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4861 === (8))){
var inst_4842 = (state_4860[(7)]);
var state_4860__$1 = state_4860;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4860__$1,(11),out,inst_4842);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_4876 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_4876[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_4876[(1)] = (1));

return statearr_4876;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_4860){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_4860);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e4877){var ex__3285__auto__ = e4877;
var statearr_4878_4893 = state_4860;
(statearr_4878_4893[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_4860[(4)]))){
var statearr_4879_4894 = state_4860;
(statearr_4879_4894[(1)] = cljs.core.first.call(null,(state_4860[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4895 = state_4860;
state_4860 = G__4895;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_4860){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_4860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_4880 = f__3356__auto__.call(null);
(statearr_4880[(6)] = c__3355__auto___4882);

return statearr_4880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4897 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4897 = (function (f,ch,meta4898){
this.f = f;
this.ch = ch;
this.meta4898 = meta4898;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4899,meta4898__$1){
var self__ = this;
var _4899__$1 = this;
return (new cljs.core.async.t_cljs$core$async4897(self__.f,self__.ch,meta4898__$1));
}));

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4899){
var self__ = this;
var _4899__$1 = this;
return self__.meta4898;
}));

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4900 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4900 = (function (f,ch,meta4898,_,fn1,meta4901){
this.f = f;
this.ch = ch;
this.meta4898 = meta4898;
this._ = _;
this.fn1 = fn1;
this.meta4901 = meta4901;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4900.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4902,meta4901__$1){
var self__ = this;
var _4902__$1 = this;
return (new cljs.core.async.t_cljs$core$async4900(self__.f,self__.ch,self__.meta4898,self__._,self__.fn1,meta4901__$1));
}));

(cljs.core.async.t_cljs$core$async4900.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4902){
var self__ = this;
var _4902__$1 = this;
return self__.meta4901;
}));

(cljs.core.async.t_cljs$core$async4900.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4900.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async4900.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async4900.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__4896_SHARP_){
return f1.call(null,(((p1__4896_SHARP_ == null))?null:self__.f.call(null,p1__4896_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async4900.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4898","meta4898",830045622,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async4897","cljs.core.async/t_cljs$core$async4897",215666190,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta4901","meta4901",314739436,null)], null);
}));

(cljs.core.async.t_cljs$core$async4900.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4900.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4900");

(cljs.core.async.t_cljs$core$async4900.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4900");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4900.
 */
cljs.core.async.__GT_t_cljs$core$async4900 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async4900(f__$1,ch__$1,meta4898__$1,___$2,fn1__$1,meta4901){
return (new cljs.core.async.t_cljs$core$async4900(f__$1,ch__$1,meta4898__$1,___$2,fn1__$1,meta4901));
});

}

return (new cljs.core.async.t_cljs$core$async4900(self__.f,self__.ch,self__.meta4898,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4897.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async4897.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4898","meta4898",830045622,null)], null);
}));

(cljs.core.async.t_cljs$core$async4897.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4897.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4897");

(cljs.core.async.t_cljs$core$async4897.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4897");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4897.
 */
cljs.core.async.__GT_t_cljs$core$async4897 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async4897(f__$1,ch__$1,meta4898){
return (new cljs.core.async.t_cljs$core$async4897(f__$1,ch__$1,meta4898));
});

}

return (new cljs.core.async.t_cljs$core$async4897(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4903 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4903 = (function (f,ch,meta4904){
this.f = f;
this.ch = ch;
this.meta4904 = meta4904;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4905,meta4904__$1){
var self__ = this;
var _4905__$1 = this;
return (new cljs.core.async.t_cljs$core$async4903(self__.f,self__.ch,meta4904__$1));
}));

(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4905){
var self__ = this;
var _4905__$1 = this;
return self__.meta4904;
}));

(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4903.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async4903.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4904","meta4904",-386753200,null)], null);
}));

(cljs.core.async.t_cljs$core$async4903.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4903.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4903");

(cljs.core.async.t_cljs$core$async4903.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4903");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4903.
 */
cljs.core.async.__GT_t_cljs$core$async4903 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async4903(f__$1,ch__$1,meta4904){
return (new cljs.core.async.t_cljs$core$async4903(f__$1,ch__$1,meta4904));
});

}

return (new cljs.core.async.t_cljs$core$async4903(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4906 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4906 = (function (p,ch,meta4907){
this.p = p;
this.ch = ch;
this.meta4907 = meta4907;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4908,meta4907__$1){
var self__ = this;
var _4908__$1 = this;
return (new cljs.core.async.t_cljs$core$async4906(self__.p,self__.ch,meta4907__$1));
}));

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4908){
var self__ = this;
var _4908__$1 = this;
return self__.meta4907;
}));

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async4906.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async4906.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta4907","meta4907",624896176,null)], null);
}));

(cljs.core.async.t_cljs$core$async4906.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async4906.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4906");

(cljs.core.async.t_cljs$core$async4906.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async4906");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4906.
 */
cljs.core.async.__GT_t_cljs$core$async4906 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async4906(p__$1,ch__$1,meta4907){
return (new cljs.core.async.t_cljs$core$async4906(p__$1,ch__$1,meta4907));
});

}

return (new cljs.core.async.t_cljs$core$async4906(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__4910 = arguments.length;
switch (G__4910) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3355__auto___4951 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_4931){
var state_val_4932 = (state_4931[(1)]);
if((state_val_4932 === (7))){
var inst_4927 = (state_4931[(2)]);
var state_4931__$1 = state_4931;
var statearr_4933_4952 = state_4931__$1;
(statearr_4933_4952[(2)] = inst_4927);

(statearr_4933_4952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (1))){
var state_4931__$1 = state_4931;
var statearr_4934_4953 = state_4931__$1;
(statearr_4934_4953[(2)] = null);

(statearr_4934_4953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (4))){
var inst_4913 = (state_4931[(7)]);
var inst_4913__$1 = (state_4931[(2)]);
var inst_4914 = (inst_4913__$1 == null);
var state_4931__$1 = (function (){var statearr_4935 = state_4931;
(statearr_4935[(7)] = inst_4913__$1);

return statearr_4935;
})();
if(cljs.core.truth_(inst_4914)){
var statearr_4936_4954 = state_4931__$1;
(statearr_4936_4954[(1)] = (5));

} else {
var statearr_4937_4955 = state_4931__$1;
(statearr_4937_4955[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (6))){
var inst_4913 = (state_4931[(7)]);
var inst_4918 = p.call(null,inst_4913);
var state_4931__$1 = state_4931;
if(cljs.core.truth_(inst_4918)){
var statearr_4938_4956 = state_4931__$1;
(statearr_4938_4956[(1)] = (8));

} else {
var statearr_4939_4957 = state_4931__$1;
(statearr_4939_4957[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (3))){
var inst_4929 = (state_4931[(2)]);
var state_4931__$1 = state_4931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4931__$1,inst_4929);
} else {
if((state_val_4932 === (2))){
var state_4931__$1 = state_4931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4931__$1,(4),ch);
} else {
if((state_val_4932 === (11))){
var inst_4921 = (state_4931[(2)]);
var state_4931__$1 = state_4931;
var statearr_4940_4958 = state_4931__$1;
(statearr_4940_4958[(2)] = inst_4921);

(statearr_4940_4958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (9))){
var state_4931__$1 = state_4931;
var statearr_4941_4959 = state_4931__$1;
(statearr_4941_4959[(2)] = null);

(statearr_4941_4959[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (5))){
var inst_4916 = cljs.core.async.close_BANG_.call(null,out);
var state_4931__$1 = state_4931;
var statearr_4942_4960 = state_4931__$1;
(statearr_4942_4960[(2)] = inst_4916);

(statearr_4942_4960[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (10))){
var inst_4924 = (state_4931[(2)]);
var state_4931__$1 = (function (){var statearr_4943 = state_4931;
(statearr_4943[(8)] = inst_4924);

return statearr_4943;
})();
var statearr_4944_4961 = state_4931__$1;
(statearr_4944_4961[(2)] = null);

(statearr_4944_4961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4932 === (8))){
var inst_4913 = (state_4931[(7)]);
var state_4931__$1 = state_4931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4931__$1,(11),out,inst_4913);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_4945 = [null,null,null,null,null,null,null,null,null];
(statearr_4945[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_4945[(1)] = (1));

return statearr_4945;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_4931){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_4931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e4946){var ex__3285__auto__ = e4946;
var statearr_4947_4962 = state_4931;
(statearr_4947_4962[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_4931[(4)]))){
var statearr_4948_4963 = state_4931;
(statearr_4948_4963[(1)] = cljs.core.first.call(null,(state_4931[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4964 = state_4931;
state_4931 = G__4964;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_4931){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_4931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_4949 = f__3356__auto__.call(null);
(statearr_4949[(6)] = c__3355__auto___4951);

return statearr_4949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__4966 = arguments.length;
switch (G__4966) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_5029){
var state_val_5030 = (state_5029[(1)]);
if((state_val_5030 === (7))){
var inst_5025 = (state_5029[(2)]);
var state_5029__$1 = state_5029;
var statearr_5031_5070 = state_5029__$1;
(statearr_5031_5070[(2)] = inst_5025);

(statearr_5031_5070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (20))){
var inst_4995 = (state_5029[(7)]);
var inst_5006 = (state_5029[(2)]);
var inst_5007 = cljs.core.next.call(null,inst_4995);
var inst_4981 = inst_5007;
var inst_4982 = null;
var inst_4983 = (0);
var inst_4984 = (0);
var state_5029__$1 = (function (){var statearr_5032 = state_5029;
(statearr_5032[(8)] = inst_4981);

(statearr_5032[(9)] = inst_4982);

(statearr_5032[(10)] = inst_5006);

(statearr_5032[(11)] = inst_4984);

(statearr_5032[(12)] = inst_4983);

return statearr_5032;
})();
var statearr_5033_5071 = state_5029__$1;
(statearr_5033_5071[(2)] = null);

(statearr_5033_5071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (1))){
var state_5029__$1 = state_5029;
var statearr_5034_5072 = state_5029__$1;
(statearr_5034_5072[(2)] = null);

(statearr_5034_5072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (4))){
var inst_4970 = (state_5029[(13)]);
var inst_4970__$1 = (state_5029[(2)]);
var inst_4971 = (inst_4970__$1 == null);
var state_5029__$1 = (function (){var statearr_5035 = state_5029;
(statearr_5035[(13)] = inst_4970__$1);

return statearr_5035;
})();
if(cljs.core.truth_(inst_4971)){
var statearr_5036_5073 = state_5029__$1;
(statearr_5036_5073[(1)] = (5));

} else {
var statearr_5037_5074 = state_5029__$1;
(statearr_5037_5074[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (15))){
var state_5029__$1 = state_5029;
var statearr_5041_5075 = state_5029__$1;
(statearr_5041_5075[(2)] = null);

(statearr_5041_5075[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (21))){
var state_5029__$1 = state_5029;
var statearr_5042_5076 = state_5029__$1;
(statearr_5042_5076[(2)] = null);

(statearr_5042_5076[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (13))){
var inst_4981 = (state_5029[(8)]);
var inst_4982 = (state_5029[(9)]);
var inst_4984 = (state_5029[(11)]);
var inst_4983 = (state_5029[(12)]);
var inst_4991 = (state_5029[(2)]);
var inst_4992 = (inst_4984 + (1));
var tmp5038 = inst_4981;
var tmp5039 = inst_4982;
var tmp5040 = inst_4983;
var inst_4981__$1 = tmp5038;
var inst_4982__$1 = tmp5039;
var inst_4983__$1 = tmp5040;
var inst_4984__$1 = inst_4992;
var state_5029__$1 = (function (){var statearr_5043 = state_5029;
(statearr_5043[(8)] = inst_4981__$1);

(statearr_5043[(9)] = inst_4982__$1);

(statearr_5043[(14)] = inst_4991);

(statearr_5043[(11)] = inst_4984__$1);

(statearr_5043[(12)] = inst_4983__$1);

return statearr_5043;
})();
var statearr_5044_5077 = state_5029__$1;
(statearr_5044_5077[(2)] = null);

(statearr_5044_5077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (22))){
var state_5029__$1 = state_5029;
var statearr_5045_5078 = state_5029__$1;
(statearr_5045_5078[(2)] = null);

(statearr_5045_5078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (6))){
var inst_4970 = (state_5029[(13)]);
var inst_4979 = f.call(null,inst_4970);
var inst_4980 = cljs.core.seq.call(null,inst_4979);
var inst_4981 = inst_4980;
var inst_4982 = null;
var inst_4983 = (0);
var inst_4984 = (0);
var state_5029__$1 = (function (){var statearr_5046 = state_5029;
(statearr_5046[(8)] = inst_4981);

(statearr_5046[(9)] = inst_4982);

(statearr_5046[(11)] = inst_4984);

(statearr_5046[(12)] = inst_4983);

return statearr_5046;
})();
var statearr_5047_5079 = state_5029__$1;
(statearr_5047_5079[(2)] = null);

(statearr_5047_5079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (17))){
var inst_4995 = (state_5029[(7)]);
var inst_4999 = cljs.core.chunk_first.call(null,inst_4995);
var inst_5000 = cljs.core.chunk_rest.call(null,inst_4995);
var inst_5001 = cljs.core.count.call(null,inst_4999);
var inst_4981 = inst_5000;
var inst_4982 = inst_4999;
var inst_4983 = inst_5001;
var inst_4984 = (0);
var state_5029__$1 = (function (){var statearr_5048 = state_5029;
(statearr_5048[(8)] = inst_4981);

(statearr_5048[(9)] = inst_4982);

(statearr_5048[(11)] = inst_4984);

(statearr_5048[(12)] = inst_4983);

return statearr_5048;
})();
var statearr_5049_5080 = state_5029__$1;
(statearr_5049_5080[(2)] = null);

(statearr_5049_5080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (3))){
var inst_5027 = (state_5029[(2)]);
var state_5029__$1 = state_5029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5029__$1,inst_5027);
} else {
if((state_val_5030 === (12))){
var inst_5015 = (state_5029[(2)]);
var state_5029__$1 = state_5029;
var statearr_5050_5081 = state_5029__$1;
(statearr_5050_5081[(2)] = inst_5015);

(statearr_5050_5081[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (2))){
var state_5029__$1 = state_5029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5029__$1,(4),in$);
} else {
if((state_val_5030 === (23))){
var inst_5023 = (state_5029[(2)]);
var state_5029__$1 = state_5029;
var statearr_5051_5082 = state_5029__$1;
(statearr_5051_5082[(2)] = inst_5023);

(statearr_5051_5082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (19))){
var inst_5010 = (state_5029[(2)]);
var state_5029__$1 = state_5029;
var statearr_5052_5083 = state_5029__$1;
(statearr_5052_5083[(2)] = inst_5010);

(statearr_5052_5083[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (11))){
var inst_4981 = (state_5029[(8)]);
var inst_4995 = (state_5029[(7)]);
var inst_4995__$1 = cljs.core.seq.call(null,inst_4981);
var state_5029__$1 = (function (){var statearr_5053 = state_5029;
(statearr_5053[(7)] = inst_4995__$1);

return statearr_5053;
})();
if(inst_4995__$1){
var statearr_5054_5084 = state_5029__$1;
(statearr_5054_5084[(1)] = (14));

} else {
var statearr_5055_5085 = state_5029__$1;
(statearr_5055_5085[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (9))){
var inst_5017 = (state_5029[(2)]);
var inst_5018 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_5029__$1 = (function (){var statearr_5056 = state_5029;
(statearr_5056[(15)] = inst_5017);

return statearr_5056;
})();
if(cljs.core.truth_(inst_5018)){
var statearr_5057_5086 = state_5029__$1;
(statearr_5057_5086[(1)] = (21));

} else {
var statearr_5058_5087 = state_5029__$1;
(statearr_5058_5087[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (5))){
var inst_4973 = cljs.core.async.close_BANG_.call(null,out);
var state_5029__$1 = state_5029;
var statearr_5059_5088 = state_5029__$1;
(statearr_5059_5088[(2)] = inst_4973);

(statearr_5059_5088[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (14))){
var inst_4995 = (state_5029[(7)]);
var inst_4997 = cljs.core.chunked_seq_QMARK_.call(null,inst_4995);
var state_5029__$1 = state_5029;
if(inst_4997){
var statearr_5060_5089 = state_5029__$1;
(statearr_5060_5089[(1)] = (17));

} else {
var statearr_5061_5090 = state_5029__$1;
(statearr_5061_5090[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (16))){
var inst_5013 = (state_5029[(2)]);
var state_5029__$1 = state_5029;
var statearr_5062_5091 = state_5029__$1;
(statearr_5062_5091[(2)] = inst_5013);

(statearr_5062_5091[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5030 === (10))){
var inst_4982 = (state_5029[(9)]);
var inst_4984 = (state_5029[(11)]);
var inst_4989 = cljs.core._nth.call(null,inst_4982,inst_4984);
var state_5029__$1 = state_5029;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5029__$1,(13),out,inst_4989);
} else {
if((state_val_5030 === (18))){
var inst_4995 = (state_5029[(7)]);
var inst_5004 = cljs.core.first.call(null,inst_4995);
var state_5029__$1 = state_5029;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5029__$1,(20),out,inst_5004);
} else {
if((state_val_5030 === (8))){
var inst_4984 = (state_5029[(11)]);
var inst_4983 = (state_5029[(12)]);
var inst_4986 = (inst_4984 < inst_4983);
var inst_4987 = inst_4986;
var state_5029__$1 = state_5029;
if(cljs.core.truth_(inst_4987)){
var statearr_5063_5092 = state_5029__$1;
(statearr_5063_5092[(1)] = (10));

} else {
var statearr_5064_5093 = state_5029__$1;
(statearr_5064_5093[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__3282__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__3282__auto____0 = (function (){
var statearr_5065 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5065[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__3282__auto__);

(statearr_5065[(1)] = (1));

return statearr_5065;
});
var cljs$core$async$mapcat_STAR__$_state_machine__3282__auto____1 = (function (state_5029){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_5029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e5066){var ex__3285__auto__ = e5066;
var statearr_5067_5094 = state_5029;
(statearr_5067_5094[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_5029[(4)]))){
var statearr_5068_5095 = state_5029;
(statearr_5068_5095[(1)] = cljs.core.first.call(null,(state_5029[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5096 = state_5029;
state_5029 = G__5096;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__3282__auto__ = function(state_5029){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__3282__auto____1.call(this,state_5029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__3282__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__3282__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_5069 = f__3356__auto__.call(null);
(statearr_5069[(6)] = c__3355__auto__);

return statearr_5069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__5098 = arguments.length;
switch (G__5098) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__5101 = arguments.length;
switch (G__5101) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__5104 = arguments.length;
switch (G__5104) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3355__auto___5152 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_5128){
var state_val_5129 = (state_5128[(1)]);
if((state_val_5129 === (7))){
var inst_5123 = (state_5128[(2)]);
var state_5128__$1 = state_5128;
var statearr_5130_5153 = state_5128__$1;
(statearr_5130_5153[(2)] = inst_5123);

(statearr_5130_5153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5129 === (1))){
var inst_5105 = null;
var state_5128__$1 = (function (){var statearr_5131 = state_5128;
(statearr_5131[(7)] = inst_5105);

return statearr_5131;
})();
var statearr_5132_5154 = state_5128__$1;
(statearr_5132_5154[(2)] = null);

(statearr_5132_5154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5129 === (4))){
var inst_5108 = (state_5128[(8)]);
var inst_5108__$1 = (state_5128[(2)]);
var inst_5109 = (inst_5108__$1 == null);
var inst_5110 = cljs.core.not.call(null,inst_5109);
var state_5128__$1 = (function (){var statearr_5133 = state_5128;
(statearr_5133[(8)] = inst_5108__$1);

return statearr_5133;
})();
if(inst_5110){
var statearr_5134_5155 = state_5128__$1;
(statearr_5134_5155[(1)] = (5));

} else {
var statearr_5135_5156 = state_5128__$1;
(statearr_5135_5156[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5129 === (6))){
var state_5128__$1 = state_5128;
var statearr_5136_5157 = state_5128__$1;
(statearr_5136_5157[(2)] = null);

(statearr_5136_5157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5129 === (3))){
var inst_5125 = (state_5128[(2)]);
var inst_5126 = cljs.core.async.close_BANG_.call(null,out);
var state_5128__$1 = (function (){var statearr_5137 = state_5128;
(statearr_5137[(9)] = inst_5125);

return statearr_5137;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5128__$1,inst_5126);
} else {
if((state_val_5129 === (2))){
var state_5128__$1 = state_5128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5128__$1,(4),ch);
} else {
if((state_val_5129 === (11))){
var inst_5108 = (state_5128[(8)]);
var inst_5117 = (state_5128[(2)]);
var inst_5105 = inst_5108;
var state_5128__$1 = (function (){var statearr_5138 = state_5128;
(statearr_5138[(7)] = inst_5105);

(statearr_5138[(10)] = inst_5117);

return statearr_5138;
})();
var statearr_5139_5158 = state_5128__$1;
(statearr_5139_5158[(2)] = null);

(statearr_5139_5158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5129 === (9))){
var inst_5108 = (state_5128[(8)]);
var state_5128__$1 = state_5128;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5128__$1,(11),out,inst_5108);
} else {
if((state_val_5129 === (5))){
var inst_5108 = (state_5128[(8)]);
var inst_5105 = (state_5128[(7)]);
var inst_5112 = cljs.core._EQ_.call(null,inst_5108,inst_5105);
var state_5128__$1 = state_5128;
if(inst_5112){
var statearr_5141_5159 = state_5128__$1;
(statearr_5141_5159[(1)] = (8));

} else {
var statearr_5142_5160 = state_5128__$1;
(statearr_5142_5160[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5129 === (10))){
var inst_5120 = (state_5128[(2)]);
var state_5128__$1 = state_5128;
var statearr_5143_5161 = state_5128__$1;
(statearr_5143_5161[(2)] = inst_5120);

(statearr_5143_5161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5129 === (8))){
var inst_5105 = (state_5128[(7)]);
var tmp5140 = inst_5105;
var inst_5105__$1 = tmp5140;
var state_5128__$1 = (function (){var statearr_5144 = state_5128;
(statearr_5144[(7)] = inst_5105__$1);

return statearr_5144;
})();
var statearr_5145_5162 = state_5128__$1;
(statearr_5145_5162[(2)] = null);

(statearr_5145_5162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_5146 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_5146[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_5146[(1)] = (1));

return statearr_5146;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_5128){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_5128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e5147){var ex__3285__auto__ = e5147;
var statearr_5148_5163 = state_5128;
(statearr_5148_5163[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_5128[(4)]))){
var statearr_5149_5164 = state_5128;
(statearr_5149_5164[(1)] = cljs.core.first.call(null,(state_5128[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5165 = state_5128;
state_5128 = G__5165;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_5128){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_5128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_5150 = f__3356__auto__.call(null);
(statearr_5150[(6)] = c__3355__auto___5152);

return statearr_5150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__5167 = arguments.length;
switch (G__5167) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3355__auto___5234 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_5205){
var state_val_5206 = (state_5205[(1)]);
if((state_val_5206 === (7))){
var inst_5201 = (state_5205[(2)]);
var state_5205__$1 = state_5205;
var statearr_5207_5235 = state_5205__$1;
(statearr_5207_5235[(2)] = inst_5201);

(statearr_5207_5235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (1))){
var inst_5168 = (new Array(n));
var inst_5169 = inst_5168;
var inst_5170 = (0);
var state_5205__$1 = (function (){var statearr_5208 = state_5205;
(statearr_5208[(7)] = inst_5170);

(statearr_5208[(8)] = inst_5169);

return statearr_5208;
})();
var statearr_5209_5236 = state_5205__$1;
(statearr_5209_5236[(2)] = null);

(statearr_5209_5236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (4))){
var inst_5173 = (state_5205[(9)]);
var inst_5173__$1 = (state_5205[(2)]);
var inst_5174 = (inst_5173__$1 == null);
var inst_5175 = cljs.core.not.call(null,inst_5174);
var state_5205__$1 = (function (){var statearr_5210 = state_5205;
(statearr_5210[(9)] = inst_5173__$1);

return statearr_5210;
})();
if(inst_5175){
var statearr_5211_5237 = state_5205__$1;
(statearr_5211_5237[(1)] = (5));

} else {
var statearr_5212_5238 = state_5205__$1;
(statearr_5212_5238[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (15))){
var inst_5195 = (state_5205[(2)]);
var state_5205__$1 = state_5205;
var statearr_5213_5239 = state_5205__$1;
(statearr_5213_5239[(2)] = inst_5195);

(statearr_5213_5239[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (13))){
var state_5205__$1 = state_5205;
var statearr_5214_5240 = state_5205__$1;
(statearr_5214_5240[(2)] = null);

(statearr_5214_5240[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (6))){
var inst_5170 = (state_5205[(7)]);
var inst_5191 = (inst_5170 > (0));
var state_5205__$1 = state_5205;
if(cljs.core.truth_(inst_5191)){
var statearr_5215_5241 = state_5205__$1;
(statearr_5215_5241[(1)] = (12));

} else {
var statearr_5216_5242 = state_5205__$1;
(statearr_5216_5242[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (3))){
var inst_5203 = (state_5205[(2)]);
var state_5205__$1 = state_5205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5205__$1,inst_5203);
} else {
if((state_val_5206 === (12))){
var inst_5169 = (state_5205[(8)]);
var inst_5193 = cljs.core.vec.call(null,inst_5169);
var state_5205__$1 = state_5205;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5205__$1,(15),out,inst_5193);
} else {
if((state_val_5206 === (2))){
var state_5205__$1 = state_5205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5205__$1,(4),ch);
} else {
if((state_val_5206 === (11))){
var inst_5185 = (state_5205[(2)]);
var inst_5186 = (new Array(n));
var inst_5169 = inst_5186;
var inst_5170 = (0);
var state_5205__$1 = (function (){var statearr_5217 = state_5205;
(statearr_5217[(10)] = inst_5185);

(statearr_5217[(7)] = inst_5170);

(statearr_5217[(8)] = inst_5169);

return statearr_5217;
})();
var statearr_5218_5243 = state_5205__$1;
(statearr_5218_5243[(2)] = null);

(statearr_5218_5243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (9))){
var inst_5169 = (state_5205[(8)]);
var inst_5183 = cljs.core.vec.call(null,inst_5169);
var state_5205__$1 = state_5205;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5205__$1,(11),out,inst_5183);
} else {
if((state_val_5206 === (5))){
var inst_5170 = (state_5205[(7)]);
var inst_5173 = (state_5205[(9)]);
var inst_5178 = (state_5205[(11)]);
var inst_5169 = (state_5205[(8)]);
var inst_5177 = (inst_5169[inst_5170] = inst_5173);
var inst_5178__$1 = (inst_5170 + (1));
var inst_5179 = (inst_5178__$1 < n);
var state_5205__$1 = (function (){var statearr_5219 = state_5205;
(statearr_5219[(12)] = inst_5177);

(statearr_5219[(11)] = inst_5178__$1);

return statearr_5219;
})();
if(cljs.core.truth_(inst_5179)){
var statearr_5220_5244 = state_5205__$1;
(statearr_5220_5244[(1)] = (8));

} else {
var statearr_5221_5245 = state_5205__$1;
(statearr_5221_5245[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (14))){
var inst_5198 = (state_5205[(2)]);
var inst_5199 = cljs.core.async.close_BANG_.call(null,out);
var state_5205__$1 = (function (){var statearr_5223 = state_5205;
(statearr_5223[(13)] = inst_5198);

return statearr_5223;
})();
var statearr_5224_5246 = state_5205__$1;
(statearr_5224_5246[(2)] = inst_5199);

(statearr_5224_5246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (10))){
var inst_5189 = (state_5205[(2)]);
var state_5205__$1 = state_5205;
var statearr_5225_5247 = state_5205__$1;
(statearr_5225_5247[(2)] = inst_5189);

(statearr_5225_5247[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5206 === (8))){
var inst_5178 = (state_5205[(11)]);
var inst_5169 = (state_5205[(8)]);
var tmp5222 = inst_5169;
var inst_5169__$1 = tmp5222;
var inst_5170 = inst_5178;
var state_5205__$1 = (function (){var statearr_5226 = state_5205;
(statearr_5226[(7)] = inst_5170);

(statearr_5226[(8)] = inst_5169__$1);

return statearr_5226;
})();
var statearr_5227_5248 = state_5205__$1;
(statearr_5227_5248[(2)] = null);

(statearr_5227_5248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_5228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5228[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_5228[(1)] = (1));

return statearr_5228;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_5205){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_5205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e5229){var ex__3285__auto__ = e5229;
var statearr_5230_5249 = state_5205;
(statearr_5230_5249[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_5205[(4)]))){
var statearr_5231_5250 = state_5205;
(statearr_5231_5250[(1)] = cljs.core.first.call(null,(state_5205[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5251 = state_5205;
state_5205 = G__5251;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_5205){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_5205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_5232 = f__3356__auto__.call(null);
(statearr_5232[(6)] = c__3355__auto___5234);

return statearr_5232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__5253 = arguments.length;
switch (G__5253) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__3355__auto___5324 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_5295){
var state_val_5296 = (state_5295[(1)]);
if((state_val_5296 === (7))){
var inst_5291 = (state_5295[(2)]);
var state_5295__$1 = state_5295;
var statearr_5297_5325 = state_5295__$1;
(statearr_5297_5325[(2)] = inst_5291);

(statearr_5297_5325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (1))){
var inst_5254 = [];
var inst_5255 = inst_5254;
var inst_5256 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_5295__$1 = (function (){var statearr_5298 = state_5295;
(statearr_5298[(7)] = inst_5256);

(statearr_5298[(8)] = inst_5255);

return statearr_5298;
})();
var statearr_5299_5326 = state_5295__$1;
(statearr_5299_5326[(2)] = null);

(statearr_5299_5326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (4))){
var inst_5259 = (state_5295[(9)]);
var inst_5259__$1 = (state_5295[(2)]);
var inst_5260 = (inst_5259__$1 == null);
var inst_5261 = cljs.core.not.call(null,inst_5260);
var state_5295__$1 = (function (){var statearr_5300 = state_5295;
(statearr_5300[(9)] = inst_5259__$1);

return statearr_5300;
})();
if(inst_5261){
var statearr_5301_5327 = state_5295__$1;
(statearr_5301_5327[(1)] = (5));

} else {
var statearr_5302_5328 = state_5295__$1;
(statearr_5302_5328[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (15))){
var inst_5285 = (state_5295[(2)]);
var state_5295__$1 = state_5295;
var statearr_5303_5329 = state_5295__$1;
(statearr_5303_5329[(2)] = inst_5285);

(statearr_5303_5329[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (13))){
var state_5295__$1 = state_5295;
var statearr_5304_5330 = state_5295__$1;
(statearr_5304_5330[(2)] = null);

(statearr_5304_5330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (6))){
var inst_5255 = (state_5295[(8)]);
var inst_5280 = inst_5255.length;
var inst_5281 = (inst_5280 > (0));
var state_5295__$1 = state_5295;
if(cljs.core.truth_(inst_5281)){
var statearr_5305_5331 = state_5295__$1;
(statearr_5305_5331[(1)] = (12));

} else {
var statearr_5306_5332 = state_5295__$1;
(statearr_5306_5332[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (3))){
var inst_5293 = (state_5295[(2)]);
var state_5295__$1 = state_5295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5295__$1,inst_5293);
} else {
if((state_val_5296 === (12))){
var inst_5255 = (state_5295[(8)]);
var inst_5283 = cljs.core.vec.call(null,inst_5255);
var state_5295__$1 = state_5295;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5295__$1,(15),out,inst_5283);
} else {
if((state_val_5296 === (2))){
var state_5295__$1 = state_5295;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5295__$1,(4),ch);
} else {
if((state_val_5296 === (11))){
var inst_5263 = (state_5295[(10)]);
var inst_5259 = (state_5295[(9)]);
var inst_5273 = (state_5295[(2)]);
var inst_5274 = [];
var inst_5275 = inst_5274.push(inst_5259);
var inst_5255 = inst_5274;
var inst_5256 = inst_5263;
var state_5295__$1 = (function (){var statearr_5307 = state_5295;
(statearr_5307[(11)] = inst_5275);

(statearr_5307[(7)] = inst_5256);

(statearr_5307[(8)] = inst_5255);

(statearr_5307[(12)] = inst_5273);

return statearr_5307;
})();
var statearr_5308_5333 = state_5295__$1;
(statearr_5308_5333[(2)] = null);

(statearr_5308_5333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (9))){
var inst_5255 = (state_5295[(8)]);
var inst_5271 = cljs.core.vec.call(null,inst_5255);
var state_5295__$1 = state_5295;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5295__$1,(11),out,inst_5271);
} else {
if((state_val_5296 === (5))){
var inst_5256 = (state_5295[(7)]);
var inst_5263 = (state_5295[(10)]);
var inst_5259 = (state_5295[(9)]);
var inst_5263__$1 = f.call(null,inst_5259);
var inst_5264 = cljs.core._EQ_.call(null,inst_5263__$1,inst_5256);
var inst_5265 = cljs.core.keyword_identical_QMARK_.call(null,inst_5256,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_5266 = ((inst_5264) || (inst_5265));
var state_5295__$1 = (function (){var statearr_5309 = state_5295;
(statearr_5309[(10)] = inst_5263__$1);

return statearr_5309;
})();
if(cljs.core.truth_(inst_5266)){
var statearr_5310_5334 = state_5295__$1;
(statearr_5310_5334[(1)] = (8));

} else {
var statearr_5311_5335 = state_5295__$1;
(statearr_5311_5335[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (14))){
var inst_5288 = (state_5295[(2)]);
var inst_5289 = cljs.core.async.close_BANG_.call(null,out);
var state_5295__$1 = (function (){var statearr_5313 = state_5295;
(statearr_5313[(13)] = inst_5288);

return statearr_5313;
})();
var statearr_5314_5336 = state_5295__$1;
(statearr_5314_5336[(2)] = inst_5289);

(statearr_5314_5336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (10))){
var inst_5278 = (state_5295[(2)]);
var state_5295__$1 = state_5295;
var statearr_5315_5337 = state_5295__$1;
(statearr_5315_5337[(2)] = inst_5278);

(statearr_5315_5337[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (8))){
var inst_5263 = (state_5295[(10)]);
var inst_5255 = (state_5295[(8)]);
var inst_5259 = (state_5295[(9)]);
var inst_5268 = inst_5255.push(inst_5259);
var tmp5312 = inst_5255;
var inst_5255__$1 = tmp5312;
var inst_5256 = inst_5263;
var state_5295__$1 = (function (){var statearr_5316 = state_5295;
(statearr_5316[(14)] = inst_5268);

(statearr_5316[(7)] = inst_5256);

(statearr_5316[(8)] = inst_5255__$1);

return statearr_5316;
})();
var statearr_5317_5338 = state_5295__$1;
(statearr_5317_5338[(2)] = null);

(statearr_5317_5338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__3282__auto__ = null;
var cljs$core$async$state_machine__3282__auto____0 = (function (){
var statearr_5318 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5318[(0)] = cljs$core$async$state_machine__3282__auto__);

(statearr_5318[(1)] = (1));

return statearr_5318;
});
var cljs$core$async$state_machine__3282__auto____1 = (function (state_5295){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_5295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e5319){var ex__3285__auto__ = e5319;
var statearr_5320_5339 = state_5295;
(statearr_5320_5339[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_5295[(4)]))){
var statearr_5321_5340 = state_5295;
(statearr_5321_5340[(1)] = cljs.core.first.call(null,(state_5295[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5341 = state_5295;
state_5295 = G__5341;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
cljs$core$async$state_machine__3282__auto__ = function(state_5295){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__3282__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__3282__auto____1.call(this,state_5295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__3282__auto____0;
cljs$core$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__3282__auto____1;
return cljs$core$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_5322 = f__3356__auto__.call(null);
(statearr_5322[(6)] = c__3355__auto___5324);

return statearr_5322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=async.js.map
