// Compiled by ClojureScript 1.10.773 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

var superv$async$PSupervisor$_error$dyn_17947 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (superv.async._error[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (superv.async._error["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
});
superv.async._error = (function superv$async$_error(this$){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_error$arity$1 == null)))))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
return superv$async$PSupervisor$_error$dyn_17947.call(null,this$);
}
});

var superv$async$PSupervisor$_abort$dyn_17948 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (superv.async._abort[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$);
} else {
var m__4426__auto__ = (superv.async._abort["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
});
superv.async._abort = (function superv$async$_abort(this$){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
return superv$async$PSupervisor$_abort$dyn_17948.call(null,this$);
}
});

var superv$async$PSupervisor$_register_go$dyn_17949 = (function (this$,body){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (superv.async._register_go[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$,body);
} else {
var m__4426__auto__ = (superv.async._register_go["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
});
superv.async._register_go = (function superv$async$_register_go(this$,body){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
return superv$async$PSupervisor$_register_go$dyn_17949.call(null,this$,body);
}
});

var superv$async$PSupervisor$_unregister_go$dyn_17950 = (function (this$,id){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (superv.async._unregister_go[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$,id);
} else {
var m__4426__auto__ = (superv.async._unregister_go["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
});
superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
return superv$async$PSupervisor$_unregister_go$dyn_17950.call(null,this$,id);
}
});

var superv$async$PSupervisor$_track_exception$dyn_17951 = (function (this$,e){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (superv.async._track_exception[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$,e);
} else {
var m__4426__auto__ = (superv.async._track_exception["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
});
superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
return superv$async$PSupervisor$_track_exception$dyn_17951.call(null,this$,e);
}
});

var superv$async$PSupervisor$_free_exception$dyn_17952 = (function (this$,e){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (superv.async._free_exception[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,this$,e);
} else {
var m__4426__auto__ = (superv.async._free_exception["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
});
superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
return superv$async$PSupervisor$_free_exception$dyn_17952.call(null,this$,e);
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,aborts,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.aborts = aborts;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k17954,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__17958 = k17954;
var G__17958__$1 = (((G__17958 instanceof cljs.core.Keyword))?G__17958.fqn:null);
switch (G__17958__$1) {
case "error":
return self__.error;

break;
case "aborts":
return self__.aborts;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k17954,else__4383__auto__);

}
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__17959){
var vec__17960 = p__17959;
var k__4403__auto__ = cljs.core.nth.call(null,vec__17960,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__17960,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"aborts","aborts",-277478143),self__.aborts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__17953){
var self__ = this;
var G__17953__$1 = this;
return (new cljs.core.RecordIter((0),G__17953__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"aborts","aborts",-277478143),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1100907306 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this17955,other17956){
var self__ = this;
var this17955__$1 = this;
return (((!((other17956 == null)))) && ((this17955__$1.constructor === other17956.constructor)) && (cljs.core._EQ_.call(null,this17955__$1.error,other17956.error)) && (cljs.core._EQ_.call(null,this17955__$1.aborts,other17956.aborts)) && (cljs.core._EQ_.call(null,this17955__$1.registered,other17956.registered)) && (cljs.core._EQ_.call(null,this17955__$1.pending_exceptions,other17956.pending_exceptions)) && (cljs.core._EQ_.call(null,this17955__$1.__extmap,other17956.__extmap)));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"aborts","aborts",-277478143),null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL);

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.rand_nth.call(null,self__.aborts);
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__17953){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__17963 = cljs.core.keyword_identical_QMARK_;
var expr__17964 = k__4388__auto__;
if(cljs.core.truth_(pred__17963.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__17964))){
return (new superv.async.TrackingSupervisor(G__17953,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17963.call(null,new cljs.core.Keyword(null,"aborts","aborts",-277478143),expr__17964))){
return (new superv.async.TrackingSupervisor(self__.error,G__17953,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17963.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__17964))){
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,G__17953,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17963.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__17964))){
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,G__17953,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__17953),null));
}
}
}
}
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"error","error",-978969032),self__.error,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"aborts","aborts",-277478143),self__.aborts,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions,null))], null),self__.__extmap));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__17953){
var self__ = this;
var this__4379__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,G__17953,self__.__extmap,self__.__hash));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"aborts","aborts",1363053384,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
}));

(superv.async.TrackingSupervisor.cljs$lang$type = true);

(superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"superv.async/TrackingSupervisor",null,(1),null));
}));

(superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"superv.async/TrackingSupervisor");
}));

/**
 * Positional factory function for superv.async/TrackingSupervisor.
 */
superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,aborts,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,aborts,registered,pending_exceptions,null,null,null));
});

/**
 * Factory function for superv.async/TrackingSupervisor, taking a map of keywords to field values.
 */
superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__17957){
var extmap__4419__auto__ = (function (){var G__17966 = cljs.core.dissoc.call(null,G__17957,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"aborts","aborts",-277478143),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094));
if(cljs.core.record_QMARK_.call(null,G__17957)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__17966);
} else {
return G__17966;
}
})();
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__17957),new cljs.core.Keyword(null,"aborts","aborts",-277478143).cljs$core$IFn$_invoke$arity$1(G__17957),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__17957),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__17957),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

cljs.core.enable_console_print_BANG_.call(null);
superv.async.NUM_ABORT_CHANS = (1000);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__4742__auto__ = [];
var len__4736__auto___17982 = arguments.length;
var i__4737__auto___17983 = (0);
while(true){
if((i__4737__auto___17983 < len__4736__auto___17982)){
args__4742__auto__.push((arguments[i__4737__auto___17983]));

var G__17984 = (i__4737__auto___17983 + (1));
i__4737__auto___17983 = G__17984;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__17969){
var map__17970 = p__17969;
var map__17970__$1 = (((((!((map__17970 == null))))?(((((map__17970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17970):map__17970);
var stale_timeout = cljs.core.get.call(null,map__17970__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__17970__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),(function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
}));
var pending_fn = cljs.core.get.call(null,map__17970__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"aborts","aborts",-277478143),cljs.core.vec.call(null,cljs.core.repeatedly.call(null,(1000),(function (){
return cljs.core.async.promise_chan.call(null);
}))),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = s.error;
cljs.core.async.take_BANG_.call(null,err_ch,(function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
}));

(function superv$async$pending(_){
var vec__17972 = cljs.core.filter.call(null,(function (p__17978){
var vec__17979 = p__17978;
var k = cljs.core.nth.call(null,vec__17979,(0),null);
var v = cljs.core.nth.call(null,vec__17979,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
}),cljs.core.deref.call(null,s.pending_exceptions));
var vec__17975 = cljs.core.nth.call(null,vec__17972,(0),null);
var e = cljs.core.nth.call(null,vec__17975,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__17975,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
}).call(null,null);

return s;
}));

(superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq17968){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17968));
}));

/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception_ = (function superv$async$throw_if_exception_(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(superv.async.supervisor_QMARK_.call(null,x)){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
superv.async.finally_exp_QMARK_ = (function superv$async$finally_exp_QMARK_(exp){
return (!(((cljs.core.seq_QMARK_.call(null,exp)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,exp),new cljs.core.Symbol(null,"finally","finally",-1065347064,null))))));
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var G__18005 = arguments.length;
switch (G__18005) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
}));

(superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
}));

(superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4);

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var G__18008 = arguments.length;
switch (G__18008) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
}));

(superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
}));

(superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if((((val instanceof Error)) && ((!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
}));

(superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5);

/**
 * Reduces over a sequence s with a go function go-f given the initial value init without supervision.
 */
superv.async.reduce_LT__QMARK__ = (function superv$async$reduce_LT__QMARK__(maybe_go_f,init,s){
var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_18072){
var state_val_18073 = (state_18072[(1)]);
if((state_val_18073 === (7))){
var inst_18051 = (state_18072[(7)]);
var inst_18045 = (state_18072[(8)]);
var inst_18050 = cljs.core.seq.call(null,inst_18045);
var inst_18051__$1 = cljs.core.first.call(null,inst_18050);
var inst_18052 = cljs.core.next.call(null,inst_18050);
var state_18072__$1 = (function (){var statearr_18074 = state_18072;
(statearr_18074[(7)] = inst_18051__$1);

(statearr_18074[(9)] = inst_18052);

return statearr_18074;
})();
if(cljs.core.truth_(inst_18051__$1)){
var statearr_18075_18105 = state_18072__$1;
(statearr_18075_18105[(1)] = (9));

} else {
var statearr_18076_18106 = state_18072__$1;
(statearr_18076_18106[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (1))){
var state_18072__$1 = state_18072;
var statearr_18077_18107 = state_18072__$1;
(statearr_18077_18107[(2)] = null);

(statearr_18077_18107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (4))){
var _ = (function (){var statearr_18079 = state_18072;
(statearr_18079[(4)] = cljs.core.rest.call(null,(state_18072[(4)])));

return statearr_18079;
})();
var inst_18022 = (state_18072[(2)]);
var ___$1 = (function (){var temp__5735__auto__ = (state_18072[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_18072__$1 = state_18072;
var statearr_18080_18108 = state_18072__$1;
(statearr_18080_18108[(2)] = inst_18022);

(statearr_18080_18108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (13))){
var inst_18054 = (state_18072[(10)]);
var state_18072__$1 = state_18072;
var statearr_18081_18109 = state_18072__$1;
(statearr_18081_18109[(2)] = inst_18054);

(statearr_18081_18109[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (6))){
var _ = (function (){var statearr_18082 = state_18072;
(statearr_18082[(4)] = cljs.core.rest.call(null,(state_18072[(4)])));

return statearr_18082;
})();
var state_18072__$1 = state_18072;
var ex18078 = (state_18072__$1[(2)]);
var statearr_18083_18110 = state_18072__$1;
(statearr_18083_18110[(5)] = ex18078);


if((ex18078 instanceof Error)){
var statearr_18084_18111 = state_18072__$1;
(statearr_18084_18111[(1)] = (5));

(statearr_18084_18111[(5)] = null);

} else {
throw ex18078;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (3))){
var inst_18070 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18072__$1,inst_18070);
} else {
if((state_val_18073 === (12))){
var inst_18054 = (state_18072[(10)]);
var inst_18057 = clojure.core.async._LT__BANG_(inst_18054);
var inst_18058 = superv.async.throw_if_exception_.call(null,inst_18057);
var state_18072__$1 = state_18072;
var statearr_18085_18112 = state_18072__$1;
(statearr_18085_18112[(2)] = inst_18058);

(statearr_18085_18112[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (2))){
var _ = (function (){var statearr_18086 = state_18072;
(statearr_18086[(4)] = cljs.core.cons.call(null,(4),(state_18072[(4)])));

return statearr_18086;
})();
var ___$1 = (function (){var statearr_18087 = state_18072;
(statearr_18087[(4)] = cljs.core.cons.call(null,(6),(state_18072[(4)])));

return statearr_18087;
})();
var inst_18039 = init;
var inst_18040 = s;
var inst_18041 = cljs.core.seq.call(null,inst_18040);
var inst_18042 = cljs.core.first.call(null,inst_18041);
var inst_18043 = cljs.core.next.call(null,inst_18041);
var inst_18044 = inst_18039;
var inst_18045 = inst_18040;
var state_18072__$1 = (function (){var statearr_18088 = state_18072;
(statearr_18088[(11)] = inst_18043);

(statearr_18088[(8)] = inst_18045);

(statearr_18088[(12)] = inst_18044);

(statearr_18088[(13)] = inst_18042);

return statearr_18088;
})();
var statearr_18089_18113 = state_18072__$1;
(statearr_18089_18113[(2)] = null);

(statearr_18089_18113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (11))){
var inst_18065 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18090_18114 = state_18072__$1;
(statearr_18090_18114[(2)] = inst_18065);

(statearr_18090_18114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (9))){
var inst_18054 = (state_18072[(10)]);
var inst_18051 = (state_18072[(7)]);
var inst_18044 = (state_18072[(12)]);
var inst_18054__$1 = maybe_go_f.call(null,inst_18044,inst_18051);
var inst_18055 = superv.async.chan_QMARK_.call(null,inst_18054__$1);
var state_18072__$1 = (function (){var statearr_18091 = state_18072;
(statearr_18091[(10)] = inst_18054__$1);

return statearr_18091;
})();
if(inst_18055){
var statearr_18092_18115 = state_18072__$1;
(statearr_18092_18115[(1)] = (12));

} else {
var statearr_18093_18116 = state_18072__$1;
(statearr_18093_18116[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (5))){
var inst_18025 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18094_18117 = state_18072__$1;
(statearr_18094_18117[(2)] = inst_18025);

(statearr_18094_18117[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (14))){
var inst_18052 = (state_18072[(9)]);
var inst_18061 = (state_18072[(2)]);
var inst_18044 = inst_18061;
var inst_18045 = inst_18052;
var state_18072__$1 = (function (){var statearr_18095 = state_18072;
(statearr_18095[(8)] = inst_18045);

(statearr_18095[(12)] = inst_18044);

return statearr_18095;
})();
var statearr_18096_18118 = state_18072__$1;
(statearr_18096_18118[(2)] = null);

(statearr_18096_18118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (10))){
var inst_18044 = (state_18072[(12)]);
var state_18072__$1 = state_18072;
var statearr_18097_18119 = state_18072__$1;
(statearr_18097_18119[(2)] = inst_18044);

(statearr_18097_18119[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (8))){
var inst_18067 = (state_18072[(2)]);
var _ = (function (){var statearr_18098 = state_18072;
(statearr_18098[(4)] = cljs.core.rest.call(null,(state_18072[(4)])));

return statearr_18098;
})();
var state_18072__$1 = state_18072;
var statearr_18099_18120 = state_18072__$1;
(statearr_18099_18120[(2)] = inst_18067);

(statearr_18099_18120[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$reduce_LT__QMARK___$_state_machine__3282__auto__ = null;
var superv$async$reduce_LT__QMARK___$_state_machine__3282__auto____0 = (function (){
var statearr_18100 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18100[(0)] = superv$async$reduce_LT__QMARK___$_state_machine__3282__auto__);

(statearr_18100[(1)] = (1));

return statearr_18100;
});
var superv$async$reduce_LT__QMARK___$_state_machine__3282__auto____1 = (function (state_18072){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_18072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e18101){var ex__3285__auto__ = e18101;
var statearr_18102_18121 = state_18072;
(statearr_18102_18121[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_18072[(4)]))){
var statearr_18103_18122 = state_18072;
(statearr_18103_18122[(1)] = cljs.core.first.call(null,(state_18072[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18123 = state_18072;
state_18072 = G__18123;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$reduce_LT__QMARK___$_state_machine__3282__auto__ = function(state_18072){
switch(arguments.length){
case 0:
return superv$async$reduce_LT__QMARK___$_state_machine__3282__auto____0.call(this);
case 1:
return superv$async$reduce_LT__QMARK___$_state_machine__3282__auto____1.call(this,state_18072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_LT__QMARK___$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_LT__QMARK___$_state_machine__3282__auto____0;
superv$async$reduce_LT__QMARK___$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_LT__QMARK___$_state_machine__3282__auto____1;
return superv$async$reduce_LT__QMARK___$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_18104 = f__3356__auto__.call(null);
(statearr_18104[(6)] = c__3355__auto__);

return statearr_18104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
});
/**
 * Reduces over a sequence s with a go function go-f or a normal function f given
 *   the initial value init. The function takes supervisor, accumulator and element
 *   as inputs.
 */
superv.async.reduce_LT__QMARK_ = (function superv$async$reduce_LT__QMARK_(S,maybe_go_f,init,s){
var c__13485__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"init","init",-234949907,null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"r","r",1169147337,null)], null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol(null,"f","f",43394975,null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null),cljs.core.list(new cljs.core.Symbol(null,"maybe-go-f","maybe-go-f",-1545142082,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"f","f",43394975,null))], null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"chan?","chan?",1219428,null),new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null)),new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null)),new cljs.core.Symbol(null,"r","r",1169147337,null))),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)))));
var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_18203){
var state_val_18204 = (state_18203[(1)]);
if((state_val_18204 === (7))){
var inst_18129 = (state_18203[(7)]);
var inst_18135 = superv.async._track_exception.call(null,S,inst_18129);
var state_18203__$1 = state_18203;
var statearr_18205_18249 = state_18203__$1;
(statearr_18205_18249[(2)] = inst_18135);

(statearr_18205_18249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (20))){
var inst_18178 = (state_18203[(8)]);
var state_18203__$1 = state_18203;
var statearr_18206_18250 = state_18203__$1;
(statearr_18206_18250[(2)] = inst_18178);

(statearr_18206_18250[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (1))){
var state_18203__$1 = state_18203;
var statearr_18207_18251 = state_18203__$1;
(statearr_18207_18251[(2)] = null);

(statearr_18207_18251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (4))){
var _ = (function (){var statearr_18208 = state_18203;
(statearr_18208[(4)] = cljs.core.rest.call(null,(state_18203[(4)])));

return statearr_18208;
})();
var inst_18125 = (state_18203[(2)]);
var inst_18126 = superv.async._unregister_go.call(null,S,id__13486__auto__);
var ___$1 = (function (){var temp__5735__auto__ = (state_18203[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_18203__$1 = (function (){var statearr_18209 = state_18203;
(statearr_18209[(9)] = inst_18126);

return statearr_18209;
})();
var statearr_18210_18252 = state_18203__$1;
(statearr_18210_18252[(2)] = inst_18125);

(statearr_18210_18252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (15))){
var inst_18166 = (state_18203[(10)]);
var inst_18172 = (state_18203[(11)]);
var inst_18172__$1 = superv.async._abort.call(null,S);
var inst_18173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18174 = [inst_18172__$1,inst_18166];
var inst_18175 = (new cljs.core.PersistentVector(null,2,(5),inst_18173,inst_18174,null));
var state_18203__$1 = (function (){var statearr_18211 = state_18203;
(statearr_18211[(11)] = inst_18172__$1);

return statearr_18211;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18203__$1,(18),inst_18175,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_18204 === (21))){
var inst_18188 = (state_18203[(2)]);
var inst_18189 = superv.async.throw_if_exception.call(null,S,inst_18188);
var state_18203__$1 = state_18203;
var statearr_18212_18253 = state_18203__$1;
(statearr_18212_18253[(2)] = inst_18189);

(statearr_18212_18253[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (13))){
var inst_18156 = (state_18203[(12)]);
var state_18203__$1 = state_18203;
var statearr_18213_18254 = state_18203__$1;
(statearr_18213_18254[(2)] = inst_18156);

(statearr_18213_18254[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (6))){
var state_18203__$1 = state_18203;
var statearr_18214_18255 = state_18203__$1;
(statearr_18214_18255[(2)] = null);

(statearr_18214_18255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (17))){
var inst_18164 = (state_18203[(13)]);
var inst_18192 = (state_18203[(2)]);
var inst_18156 = inst_18192;
var inst_18157 = inst_18164;
var state_18203__$1 = (function (){var statearr_18215 = state_18203;
(statearr_18215[(12)] = inst_18156);

(statearr_18215[(14)] = inst_18157);

return statearr_18215;
})();
var statearr_18216_18256 = state_18203__$1;
(statearr_18216_18256[(2)] = null);

(statearr_18216_18256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (3))){
var inst_18201 = (state_18203[(2)]);
var state_18203__$1 = state_18203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18203__$1,inst_18201);
} else {
if((state_val_18204 === (12))){
var inst_18156 = (state_18203[(12)]);
var inst_18163 = (state_18203[(15)]);
var inst_18166 = (state_18203[(10)]);
var inst_18166__$1 = maybe_go_f.call(null,S,inst_18156,inst_18163);
var inst_18167 = superv.async.chan_QMARK_.call(null,inst_18166__$1);
var state_18203__$1 = (function (){var statearr_18217 = state_18203;
(statearr_18217[(10)] = inst_18166__$1);

return statearr_18217;
})();
if(inst_18167){
var statearr_18218_18257 = state_18203__$1;
(statearr_18218_18257[(1)] = (15));

} else {
var statearr_18219_18258 = state_18203__$1;
(statearr_18219_18258[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (2))){
var _ = (function (){var statearr_18220 = state_18203;
(statearr_18220[(4)] = cljs.core.cons.call(null,(4),(state_18203[(4)])));

return statearr_18220;
})();
var ___$1 = (function (){var statearr_18221 = state_18203;
(statearr_18221[(4)] = cljs.core.cons.call(null,(9),(state_18203[(4)])));

return statearr_18221;
})();
var inst_18151 = init;
var inst_18152 = s;
var inst_18153 = cljs.core.seq.call(null,inst_18152);
var inst_18154 = cljs.core.first.call(null,inst_18153);
var inst_18155 = cljs.core.next.call(null,inst_18153);
var inst_18156 = inst_18151;
var inst_18157 = inst_18152;
var state_18203__$1 = (function (){var statearr_18222 = state_18203;
(statearr_18222[(12)] = inst_18156);

(statearr_18222[(14)] = inst_18157);

(statearr_18222[(16)] = inst_18155);

(statearr_18222[(17)] = inst_18154);

return statearr_18222;
})();
var statearr_18223_18259 = state_18203__$1;
(statearr_18223_18259[(2)] = null);

(statearr_18223_18259[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (19))){
var inst_18182 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18183 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18184 = cljs.core.PersistentHashMap.fromArrays(inst_18182,inst_18183);
var inst_18185 = cljs.core.ex_info.call(null,"Aborted operations",inst_18184);
var state_18203__$1 = state_18203;
var statearr_18225_18260 = state_18203__$1;
(statearr_18225_18260[(2)] = inst_18185);

(statearr_18225_18260[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (11))){
var inst_18198 = (state_18203[(2)]);
var _ = (function (){var statearr_18226 = state_18203;
(statearr_18226[(4)] = cljs.core.rest.call(null,(state_18203[(4)])));

return statearr_18226;
})();
var state_18203__$1 = state_18203;
var statearr_18227_18261 = state_18203__$1;
(statearr_18227_18261[(2)] = inst_18198);

(statearr_18227_18261[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (9))){
var _ = (function (){var statearr_18228 = state_18203;
(statearr_18228[(4)] = cljs.core.rest.call(null,(state_18203[(4)])));

return statearr_18228;
})();
var state_18203__$1 = state_18203;
var ex18224 = (state_18203__$1[(2)]);
var statearr_18229_18262 = state_18203__$1;
(statearr_18229_18262[(5)] = ex18224);


if((ex18224 instanceof Error)){
var statearr_18230_18263 = state_18203__$1;
(statearr_18230_18263[(1)] = (5));

(statearr_18230_18263[(5)] = null);

} else {
throw ex18224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (5))){
var inst_18129 = (state_18203[(7)]);
var inst_18129__$1 = (state_18203[(2)]);
var inst_18130 = cljs.core.ex_data.call(null,inst_18129__$1);
var inst_18131 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18130);
var inst_18132 = cljs.core._EQ_.call(null,inst_18131,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_18203__$1 = (function (){var statearr_18231 = state_18203;
(statearr_18231[(7)] = inst_18129__$1);

return statearr_18231;
})();
if(inst_18132){
var statearr_18232_18264 = state_18203__$1;
(statearr_18232_18264[(1)] = (6));

} else {
var statearr_18233_18265 = state_18203__$1;
(statearr_18233_18265[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (14))){
var inst_18196 = (state_18203[(2)]);
var state_18203__$1 = state_18203;
var statearr_18234_18266 = state_18203__$1;
(statearr_18234_18266[(2)] = inst_18196);

(statearr_18234_18266[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (16))){
var inst_18166 = (state_18203[(10)]);
var state_18203__$1 = state_18203;
var statearr_18235_18267 = state_18203__$1;
(statearr_18235_18267[(2)] = inst_18166);

(statearr_18235_18267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (10))){
var inst_18157 = (state_18203[(14)]);
var inst_18163 = (state_18203[(15)]);
var inst_18162 = cljs.core.seq.call(null,inst_18157);
var inst_18163__$1 = cljs.core.first.call(null,inst_18162);
var inst_18164 = cljs.core.next.call(null,inst_18162);
var state_18203__$1 = (function (){var statearr_18236 = state_18203;
(statearr_18236[(13)] = inst_18164);

(statearr_18236[(15)] = inst_18163__$1);

return statearr_18236;
})();
if(cljs.core.truth_(inst_18163__$1)){
var statearr_18237_18268 = state_18203__$1;
(statearr_18237_18268[(1)] = (12));

} else {
var statearr_18238_18269 = state_18203__$1;
(statearr_18238_18269[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (18))){
var inst_18172 = (state_18203[(11)]);
var inst_18177 = (state_18203[(2)]);
var inst_18178 = cljs.core.nth.call(null,inst_18177,(0),null);
var inst_18179 = cljs.core.nth.call(null,inst_18177,(1),null);
var inst_18180 = cljs.core._EQ_.call(null,inst_18179,inst_18172);
var state_18203__$1 = (function (){var statearr_18239 = state_18203;
(statearr_18239[(8)] = inst_18178);

return statearr_18239;
})();
if(inst_18180){
var statearr_18240_18270 = state_18203__$1;
(statearr_18240_18270[(1)] = (19));

} else {
var statearr_18241_18271 = state_18203__$1;
(statearr_18241_18271[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18204 === (8))){
var inst_18129 = (state_18203[(7)]);
var inst_18137 = (state_18203[(2)]);
var state_18203__$1 = (function (){var statearr_18242 = state_18203;
(statearr_18242[(18)] = inst_18137);

return statearr_18242;
})();
var statearr_18243_18272 = state_18203__$1;
(statearr_18243_18272[(2)] = inst_18129);

(statearr_18243_18272[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$reduce_LT__QMARK__$_state_machine__3282__auto__ = null;
var superv$async$reduce_LT__QMARK__$_state_machine__3282__auto____0 = (function (){
var statearr_18244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18244[(0)] = superv$async$reduce_LT__QMARK__$_state_machine__3282__auto__);

(statearr_18244[(1)] = (1));

return statearr_18244;
});
var superv$async$reduce_LT__QMARK__$_state_machine__3282__auto____1 = (function (state_18203){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_18203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e18245){var ex__3285__auto__ = e18245;
var statearr_18246_18273 = state_18203;
(statearr_18246_18273[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_18203[(4)]))){
var statearr_18247_18274 = state_18203;
(statearr_18247_18274[(1)] = cljs.core.first.call(null,(state_18203[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18275 = state_18203;
state_18203 = G__18275;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$reduce_LT__QMARK__$_state_machine__3282__auto__ = function(state_18203){
switch(arguments.length){
case 0:
return superv$async$reduce_LT__QMARK__$_state_machine__3282__auto____0.call(this);
case 1:
return superv$async$reduce_LT__QMARK__$_state_machine__3282__auto____1.call(this,state_18203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_LT__QMARK__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_LT__QMARK__$_state_machine__3282__auto____0;
superv$async$reduce_LT__QMARK__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_LT__QMARK__$_state_machine__3282__auto____1;
return superv$async$reduce_LT__QMARK__$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_18248 = f__3356__auto__.call(null);
(statearr_18248[(6)] = c__3355__auto__);

return statearr_18248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
});
/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var G__18277 = arguments.length;
switch (G__18277) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
}));

(superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if(((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0))))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__4613__auto___18492 = parallelism;
var __18493 = (0);
while(true){
if((__18493 < n__4613__auto___18492)){
var c__13485__auto___18494 = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto___18495 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__3355__auto___18496 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18493,c__3355__auto___18496,c__13485__auto___18494,id__13486__auto___18495,n__4613__auto___18492,threads){
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = ((function (__18493,c__3355__auto___18496,c__13485__auto___18494,id__13486__auto___18495,n__4613__auto___18492,threads){
return (function (state_18418){
var state_val_18419 = (state_18418[(1)]);
if((state_val_18419 === (7))){
var inst_18283 = (state_18418[(7)]);
var inst_18289 = superv.async._track_exception.call(null,S,inst_18283);
var state_18418__$1 = state_18418;
var statearr_18420_18497 = state_18418__$1;
(statearr_18420_18497[(2)] = inst_18289);

(statearr_18420_18497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (20))){
var inst_18352 = (state_18418[(8)]);
var inst_18319 = (state_18418[(9)]);
var inst_18352__$1 = superv.async._abort.call(null,S);
var inst_18353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18354 = f_GT_.call(null,inst_18319);
var inst_18355 = [inst_18352__$1,inst_18354];
var inst_18356 = (new cljs.core.PersistentVector(null,2,(5),inst_18353,inst_18355,null));
var state_18418__$1 = (function (){var statearr_18421 = state_18418;
(statearr_18421[(8)] = inst_18352__$1);

return statearr_18421;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18418__$1,(27),inst_18356,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_18419 === (27))){
var inst_18352 = (state_18418[(8)]);
var inst_18358 = (state_18418[(2)]);
var inst_18359 = cljs.core.nth.call(null,inst_18358,(0),null);
var inst_18360 = cljs.core.nth.call(null,inst_18358,(1),null);
var inst_18361 = cljs.core._EQ_.call(null,inst_18360,inst_18352);
var state_18418__$1 = (function (){var statearr_18422 = state_18418;
(statearr_18422[(10)] = inst_18359);

return statearr_18422;
})();
if(inst_18361){
var statearr_18423_18498 = state_18418__$1;
(statearr_18423_18498[(1)] = (28));

} else {
var statearr_18424_18499 = state_18418__$1;
(statearr_18424_18499[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (1))){
var state_18418__$1 = state_18418;
var statearr_18425_18500 = state_18418__$1;
(statearr_18425_18500[(2)] = null);

(statearr_18425_18500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (24))){
var inst_18319 = (state_18418[(9)]);
var state_18418__$1 = state_18418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18418__$1,(26),out_ch,inst_18319);
} else {
if((state_val_18419 === (39))){
var inst_18410 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_18418__$1 = state_18418;
var statearr_18426_18501 = state_18418__$1;
(statearr_18426_18501[(2)] = inst_18410);

(statearr_18426_18501[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (4))){
var ___$1 = (function (){var statearr_18427 = state_18418;
(statearr_18427[(4)] = cljs.core.rest.call(null,(state_18418[(4)])));

return statearr_18427;
})();
var inst_18279 = (state_18418[(2)]);
var inst_18280 = superv.async._unregister_go.call(null,S,id__13486__auto___18495);
var ___$2 = (function (){var temp__5735__auto__ = (state_18418[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_18418__$1 = (function (){var statearr_18428 = state_18418;
(statearr_18428[(11)] = inst_18280);

return statearr_18428;
})();
var statearr_18429_18502 = state_18418__$1;
(statearr_18429_18502[(2)] = inst_18279);

(statearr_18429_18502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (15))){
var inst_18319 = (state_18418[(9)]);
var inst_18318 = (state_18418[(2)]);
var inst_18319__$1 = superv.async.throw_if_exception.call(null,S,inst_18318);
var state_18418__$1 = (function (){var statearr_18430 = state_18418;
(statearr_18430[(9)] = inst_18319__$1);

return statearr_18430;
})();
if(cljs.core.truth_(inst_18319__$1)){
var statearr_18431_18503 = state_18418__$1;
(statearr_18431_18503[(1)] = (16));

} else {
var statearr_18432_18504 = state_18418__$1;
(statearr_18432_18504[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (21))){
var inst_18401 = (state_18418[(2)]);
var state_18418__$1 = state_18418;
var statearr_18433_18505 = state_18418__$1;
(statearr_18433_18505[(2)] = inst_18401);

(statearr_18433_18505[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (31))){
var inst_18375 = (state_18418[(12)]);
var inst_18375__$1 = superv.async._abort.call(null,S);
var inst_18376 = cljs.core.async.timeout.call(null,(0));
var inst_18377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18378 = [inst_18375__$1,inst_18376];
var inst_18379 = (new cljs.core.PersistentVector(null,2,(5),inst_18377,inst_18378,null));
var state_18418__$1 = (function (){var statearr_18434 = state_18418;
(statearr_18434[(12)] = inst_18375__$1);

return statearr_18434;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18418__$1,(34),inst_18379,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_18419 === (32))){
var state_18418__$1 = state_18418;
var statearr_18435_18506 = state_18418__$1;
(statearr_18435_18506[(2)] = null);

(statearr_18435_18506[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (40))){
var state_18418__$1 = state_18418;
var statearr_18436_18507 = state_18418__$1;
(statearr_18436_18507[(2)] = null);

(statearr_18436_18507[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (33))){
var inst_18398 = (state_18418[(2)]);
var state_18418__$1 = (function (){var statearr_18437 = state_18418;
(statearr_18437[(13)] = inst_18398);

return statearr_18437;
})();
var statearr_18438_18508 = state_18418__$1;
(statearr_18438_18508[(2)] = null);

(statearr_18438_18508[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (13))){
var inst_18312 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18313 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18314 = cljs.core.PersistentHashMap.fromArrays(inst_18312,inst_18313);
var inst_18315 = cljs.core.ex_info.call(null,"Aborted operations",inst_18314);
var state_18418__$1 = state_18418;
var statearr_18439_18509 = state_18418__$1;
(statearr_18439_18509[(2)] = inst_18315);

(statearr_18439_18509[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (22))){
var inst_18326 = (state_18418[(14)]);
var inst_18332 = (state_18418[(2)]);
var inst_18333 = cljs.core.nth.call(null,inst_18332,(0),null);
var inst_18334 = cljs.core.nth.call(null,inst_18332,(1),null);
var inst_18335 = cljs.core._EQ_.call(null,inst_18334,inst_18326);
var state_18418__$1 = (function (){var statearr_18440 = state_18418;
(statearr_18440[(15)] = inst_18333);

return statearr_18440;
})();
if(inst_18335){
var statearr_18441_18510 = state_18418__$1;
(statearr_18441_18510[(1)] = (23));

} else {
var statearr_18442_18511 = state_18418__$1;
(statearr_18442_18511[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (36))){
var inst_18370 = (state_18418[(16)]);
var state_18418__$1 = state_18418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18418__$1,(38),out_ch,inst_18370);
} else {
if((state_val_18419 === (41))){
var inst_18413 = (state_18418[(2)]);
var ___$1 = (function (){var statearr_18443 = state_18418;
(statearr_18443[(4)] = cljs.core.rest.call(null,(state_18418[(4)])));

return statearr_18443;
})();
var state_18418__$1 = state_18418;
var statearr_18444_18512 = state_18418__$1;
(statearr_18444_18512[(2)] = inst_18413);

(statearr_18444_18512[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (29))){
var inst_18359 = (state_18418[(10)]);
var state_18418__$1 = state_18418;
var statearr_18445_18513 = state_18418__$1;
(statearr_18445_18513[(2)] = inst_18359);

(statearr_18445_18513[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (6))){
var state_18418__$1 = state_18418;
var statearr_18446_18514 = state_18418__$1;
(statearr_18446_18514[(2)] = null);

(statearr_18446_18514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (28))){
var inst_18363 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18364 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18365 = cljs.core.PersistentHashMap.fromArrays(inst_18363,inst_18364);
var inst_18366 = cljs.core.ex_info.call(null,"Aborted operations",inst_18365);
var state_18418__$1 = state_18418;
var statearr_18447_18515 = state_18418__$1;
(statearr_18447_18515[(2)] = inst_18366);

(statearr_18447_18515[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (25))){
var inst_18345 = (state_18418[(2)]);
var inst_18346 = superv.async.throw_if_exception.call(null,S,inst_18345);
var inst_18347 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_18418__$1 = (function (){var statearr_18448 = state_18418;
(statearr_18448[(17)] = inst_18346);

return statearr_18448;
})();
var statearr_18449_18516 = state_18418__$1;
(statearr_18449_18516[(2)] = inst_18347);

(statearr_18449_18516[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (34))){
var inst_18375 = (state_18418[(12)]);
var inst_18381 = (state_18418[(2)]);
var inst_18382 = cljs.core.nth.call(null,inst_18381,(0),null);
var inst_18383 = cljs.core.nth.call(null,inst_18381,(1),null);
var inst_18384 = cljs.core._EQ_.call(null,inst_18383,inst_18375);
var state_18418__$1 = (function (){var statearr_18450 = state_18418;
(statearr_18450[(18)] = inst_18382);

return statearr_18450;
})();
if(inst_18384){
var statearr_18451_18517 = state_18418__$1;
(statearr_18451_18517[(1)] = (35));

} else {
var statearr_18452_18518 = state_18418__$1;
(statearr_18452_18518[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (17))){
var state_18418__$1 = state_18418;
var statearr_18453_18519 = state_18418__$1;
(statearr_18453_18519[(2)] = null);

(statearr_18453_18519[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (3))){
var inst_18416 = (state_18418[(2)]);
var state_18418__$1 = state_18418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18418__$1,inst_18416);
} else {
if((state_val_18419 === (12))){
var inst_18302 = (state_18418[(19)]);
var inst_18307 = (state_18418[(2)]);
var inst_18308 = cljs.core.nth.call(null,inst_18307,(0),null);
var inst_18309 = cljs.core.nth.call(null,inst_18307,(1),null);
var inst_18310 = cljs.core._EQ_.call(null,inst_18309,inst_18302);
var state_18418__$1 = (function (){var statearr_18454 = state_18418;
(statearr_18454[(20)] = inst_18308);

return statearr_18454;
})();
if(inst_18310){
var statearr_18455_18520 = state_18418__$1;
(statearr_18455_18520[(1)] = (13));

} else {
var statearr_18456_18521 = state_18418__$1;
(statearr_18456_18521[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (2))){
var ___$1 = (function (){var statearr_18457 = state_18418;
(statearr_18457[(4)] = cljs.core.cons.call(null,(4),(state_18418[(4)])));

return statearr_18457;
})();
var ___$2 = (function (){var statearr_18458 = state_18418;
(statearr_18458[(4)] = cljs.core.cons.call(null,(9),(state_18418[(4)])));

return statearr_18458;
})();
var state_18418__$1 = state_18418;
var statearr_18459_18522 = state_18418__$1;
(statearr_18459_18522[(2)] = null);

(statearr_18459_18522[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (23))){
var inst_18337 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18338 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18339 = cljs.core.PersistentHashMap.fromArrays(inst_18337,inst_18338);
var inst_18340 = cljs.core.ex_info.call(null,"Aborted operations",inst_18339);
var state_18418__$1 = state_18418;
var statearr_18460_18523 = state_18418__$1;
(statearr_18460_18523[(2)] = inst_18340);

(statearr_18460_18523[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (35))){
var inst_18386 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18387 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18388 = cljs.core.PersistentHashMap.fromArrays(inst_18386,inst_18387);
var inst_18389 = cljs.core.ex_info.call(null,"Aborted operations",inst_18388);
var state_18418__$1 = state_18418;
var statearr_18461_18524 = state_18418__$1;
(statearr_18461_18524[(2)] = inst_18389);

(statearr_18461_18524[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (19))){
var inst_18326 = (state_18418[(14)]);
var inst_18326__$1 = superv.async._abort.call(null,S);
var inst_18327 = cljs.core.async.timeout.call(null,(0));
var inst_18328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18329 = [inst_18326__$1,inst_18327];
var inst_18330 = (new cljs.core.PersistentVector(null,2,(5),inst_18328,inst_18329,null));
var state_18418__$1 = (function (){var statearr_18463 = state_18418;
(statearr_18463[(14)] = inst_18326__$1);

return statearr_18463;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18418__$1,(22),inst_18330,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_18419 === (11))){
var inst_18406 = (state_18418[(2)]);
var inst_18407 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_18408 = (inst_18407 === (0));
var state_18418__$1 = (function (){var statearr_18464 = state_18418;
(statearr_18464[(21)] = inst_18406);

return statearr_18464;
})();
if(cljs.core.truth_(inst_18408)){
var statearr_18465_18525 = state_18418__$1;
(statearr_18465_18525[(1)] = (39));

} else {
var statearr_18466_18526 = state_18418__$1;
(statearr_18466_18526[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (9))){
var ___$1 = (function (){var statearr_18467 = state_18418;
(statearr_18467[(4)] = cljs.core.rest.call(null,(state_18418[(4)])));

return statearr_18467;
})();
var state_18418__$1 = state_18418;
var ex18462 = (state_18418__$1[(2)]);
var statearr_18468_18527 = state_18418__$1;
(statearr_18468_18527[(5)] = ex18462);


if((ex18462 instanceof Error)){
var statearr_18469_18528 = state_18418__$1;
(statearr_18469_18528[(1)] = (5));

(statearr_18469_18528[(5)] = null);

} else {
throw ex18462;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (5))){
var inst_18283 = (state_18418[(7)]);
var inst_18283__$1 = (state_18418[(2)]);
var inst_18284 = cljs.core.ex_data.call(null,inst_18283__$1);
var inst_18285 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18284);
var inst_18286 = cljs.core._EQ_.call(null,inst_18285,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_18418__$1 = (function (){var statearr_18470 = state_18418;
(statearr_18470[(7)] = inst_18283__$1);

return statearr_18470;
})();
if(inst_18286){
var statearr_18471_18529 = state_18418__$1;
(statearr_18471_18529[(1)] = (6));

} else {
var statearr_18472_18530 = state_18418__$1;
(statearr_18472_18530[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (14))){
var inst_18308 = (state_18418[(20)]);
var state_18418__$1 = state_18418;
var statearr_18473_18531 = state_18418__$1;
(statearr_18473_18531[(2)] = inst_18308);

(statearr_18473_18531[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (26))){
var inst_18343 = (state_18418[(2)]);
var state_18418__$1 = state_18418;
var statearr_18474_18532 = state_18418__$1;
(statearr_18474_18532[(2)] = inst_18343);

(statearr_18474_18532[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (16))){
var inst_18319 = (state_18418[(9)]);
var inst_18321 = (inst_18319 instanceof Error);
var state_18418__$1 = state_18418;
if(cljs.core.truth_(inst_18321)){
var statearr_18475_18533 = state_18418__$1;
(statearr_18475_18533[(1)] = (19));

} else {
var statearr_18476_18534 = state_18418__$1;
(statearr_18476_18534[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (38))){
var inst_18392 = (state_18418[(2)]);
var state_18418__$1 = state_18418;
var statearr_18477_18535 = state_18418__$1;
(statearr_18477_18535[(2)] = inst_18392);

(statearr_18477_18535[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (30))){
var inst_18370 = (state_18418[(16)]);
var inst_18369 = (state_18418[(2)]);
var inst_18370__$1 = superv.async.throw_if_exception.call(null,S,inst_18369);
var state_18418__$1 = (function (){var statearr_18478 = state_18418;
(statearr_18478[(16)] = inst_18370__$1);

return statearr_18478;
})();
if(cljs.core.truth_(inst_18370__$1)){
var statearr_18479_18536 = state_18418__$1;
(statearr_18479_18536[(1)] = (31));

} else {
var statearr_18480_18537 = state_18418__$1;
(statearr_18480_18537[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (10))){
var inst_18302 = (state_18418[(19)]);
var inst_18302__$1 = superv.async._abort.call(null,S);
var inst_18303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18304 = [inst_18302__$1,in_ch];
var inst_18305 = (new cljs.core.PersistentVector(null,2,(5),inst_18303,inst_18304,null));
var state_18418__$1 = (function (){var statearr_18481 = state_18418;
(statearr_18481[(19)] = inst_18302__$1);

return statearr_18481;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18418__$1,(12),inst_18305,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_18419 === (18))){
var inst_18404 = (state_18418[(2)]);
var state_18418__$1 = state_18418;
var statearr_18482_18538 = state_18418__$1;
(statearr_18482_18538[(2)] = inst_18404);

(statearr_18482_18538[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (37))){
var inst_18394 = (state_18418[(2)]);
var inst_18395 = superv.async.throw_if_exception.call(null,S,inst_18394);
var state_18418__$1 = state_18418;
var statearr_18483_18539 = state_18418__$1;
(statearr_18483_18539[(2)] = inst_18395);

(statearr_18483_18539[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18419 === (8))){
var inst_18283 = (state_18418[(7)]);
var inst_18291 = (state_18418[(2)]);
var state_18418__$1 = (function (){var statearr_18484 = state_18418;
(statearr_18484[(22)] = inst_18291);

return statearr_18484;
})();
var statearr_18485_18540 = state_18418__$1;
(statearr_18485_18540[(2)] = inst_18283);

(statearr_18485_18540[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__18493,c__3355__auto___18496,c__13485__auto___18494,id__13486__auto___18495,n__4613__auto___18492,threads))
;
return ((function (__18493,switch__3281__auto__,c__3355__auto___18496,c__13485__auto___18494,id__13486__auto___18495,n__4613__auto___18492,threads){
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_18486 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18486[(0)] = superv$async$state_machine__3282__auto__);

(statearr_18486[(1)] = (1));

return statearr_18486;
});
var superv$async$state_machine__3282__auto____1 = (function (state_18418){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_18418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e18487){var ex__3285__auto__ = e18487;
var statearr_18488_18541 = state_18418;
(statearr_18488_18541[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_18418[(4)]))){
var statearr_18489_18542 = state_18418;
(statearr_18489_18542[(1)] = cljs.core.first.call(null,(state_18418[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18543 = state_18418;
state_18418 = G__18543;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_18418){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_18418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
;})(__18493,switch__3281__auto__,c__3355__auto___18496,c__13485__auto___18494,id__13486__auto___18495,n__4613__auto___18492,threads))
})();
var state__3357__auto__ = (function (){var statearr_18490 = f__3356__auto__.call(null);
(statearr_18490[(6)] = c__3355__auto___18496);

return statearr_18490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});})(__18493,c__3355__auto___18496,c__13485__auto___18494,id__13486__auto___18495,n__4613__auto___18492,threads))
);


var G__18544 = (__18493 + (1));
__18493 = G__18544;
continue;
} else {
}
break;
}

return out_ch;
}));

(superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5);

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__4742__auto__ = [];
var len__4736__auto___18638 = arguments.length;
var i__4737__auto___18639 = (0);
while(true){
if((i__4737__auto___18639 < len__4736__auto___18638)){
args__4742__auto__.push((arguments[i__4737__auto___18639]));

var G__18640 = (i__4737__auto___18639 + (1));
i__4737__auto___18639 = G__18640;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__13485__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__3355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_18600){
var state_val_18601 = (state_18600[(1)]);
if((state_val_18601 === (7))){
var inst_18552 = (state_18600[(7)]);
var inst_18558 = superv.async._track_exception.call(null,S,inst_18552);
var state_18600__$1 = state_18600;
var statearr_18602_18641 = state_18600__$1;
(statearr_18602_18641[(2)] = inst_18558);

(statearr_18602_18641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (1))){
var state_18600__$1 = state_18600;
var statearr_18603_18642 = state_18600__$1;
(statearr_18603_18642[(2)] = null);

(statearr_18603_18642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (4))){
var _ = (function (){var statearr_18604 = state_18600;
(statearr_18604[(4)] = cljs.core.rest.call(null,(state_18600[(4)])));

return statearr_18604;
})();
var inst_18548 = (state_18600[(2)]);
var inst_18549 = superv.async._unregister_go.call(null,S,id__13486__auto__);
var ___$1 = (function (){var temp__5735__auto__ = (state_18600[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_18600__$1 = (function (){var statearr_18605 = state_18600;
(statearr_18605[(8)] = inst_18549);

return statearr_18605;
})();
var statearr_18606_18643 = state_18600__$1;
(statearr_18606_18643[(2)] = inst_18548);

(statearr_18606_18643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (15))){
var inst_18587 = (state_18600[(2)]);
var inst_18588 = superv.async.throw_if_exception.call(null,S,inst_18587);
var state_18600__$1 = state_18600;
if(cljs.core.truth_(inst_18588)){
var statearr_18607_18644 = state_18600__$1;
(statearr_18607_18644[(1)] = (16));

} else {
var statearr_18608_18645 = state_18600__$1;
(statearr_18608_18645[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (13))){
var inst_18581 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18582 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18583 = cljs.core.PersistentHashMap.fromArrays(inst_18581,inst_18582);
var inst_18584 = cljs.core.ex_info.call(null,"Aborted operations",inst_18583);
var state_18600__$1 = state_18600;
var statearr_18609_18646 = state_18600__$1;
(statearr_18609_18646[(2)] = inst_18584);

(statearr_18609_18646[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (6))){
var state_18600__$1 = state_18600;
var statearr_18610_18647 = state_18600__$1;
(statearr_18610_18647[(2)] = null);

(statearr_18610_18647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (17))){
var state_18600__$1 = state_18600;
var statearr_18611_18648 = state_18600__$1;
(statearr_18611_18648[(2)] = null);

(statearr_18611_18648[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (3))){
var inst_18598 = (state_18600[(2)]);
var state_18600__$1 = state_18600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18600__$1,inst_18598);
} else {
if((state_val_18601 === (12))){
var inst_18571 = (state_18600[(9)]);
var inst_18576 = (state_18600[(2)]);
var inst_18577 = cljs.core.nth.call(null,inst_18576,(0),null);
var inst_18578 = cljs.core.nth.call(null,inst_18576,(1),null);
var inst_18579 = cljs.core._EQ_.call(null,inst_18578,inst_18571);
var state_18600__$1 = (function (){var statearr_18612 = state_18600;
(statearr_18612[(10)] = inst_18577);

return statearr_18612;
})();
if(inst_18579){
var statearr_18613_18649 = state_18600__$1;
(statearr_18613_18649[(1)] = (13));

} else {
var statearr_18614_18650 = state_18600__$1;
(statearr_18614_18650[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (2))){
var _ = (function (){var statearr_18616 = state_18600;
(statearr_18616[(4)] = cljs.core.cons.call(null,(4),(state_18600[(4)])));

return statearr_18616;
})();
var ___$1 = (function (){var statearr_18617 = state_18600;
(statearr_18617[(4)] = cljs.core.cons.call(null,(9),(state_18600[(4)])));

return statearr_18617;
})();
var state_18600__$1 = state_18600;
var statearr_18618_18651 = state_18600__$1;
(statearr_18618_18651[(2)] = null);

(statearr_18618_18651[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (11))){
var inst_18595 = (state_18600[(2)]);
var _ = (function (){var statearr_18619 = state_18600;
(statearr_18619[(4)] = cljs.core.rest.call(null,(state_18600[(4)])));

return statearr_18619;
})();
var state_18600__$1 = state_18600;
var statearr_18620_18652 = state_18600__$1;
(statearr_18620_18652[(2)] = inst_18595);

(statearr_18620_18652[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (9))){
var _ = (function (){var statearr_18621 = state_18600;
(statearr_18621[(4)] = cljs.core.rest.call(null,(state_18600[(4)])));

return statearr_18621;
})();
var state_18600__$1 = state_18600;
var ex18615 = (state_18600__$1[(2)]);
var statearr_18622_18653 = state_18600__$1;
(statearr_18622_18653[(5)] = ex18615);


if((ex18615 instanceof Error)){
var statearr_18623_18654 = state_18600__$1;
(statearr_18623_18654[(1)] = (5));

(statearr_18623_18654[(5)] = null);

} else {
throw ex18615;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (5))){
var inst_18552 = (state_18600[(7)]);
var inst_18552__$1 = (state_18600[(2)]);
var inst_18553 = cljs.core.ex_data.call(null,inst_18552__$1);
var inst_18554 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18553);
var inst_18555 = cljs.core._EQ_.call(null,inst_18554,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_18600__$1 = (function (){var statearr_18624 = state_18600;
(statearr_18624[(7)] = inst_18552__$1);

return statearr_18624;
})();
if(inst_18555){
var statearr_18625_18655 = state_18600__$1;
(statearr_18625_18655[(1)] = (6));

} else {
var statearr_18626_18656 = state_18600__$1;
(statearr_18626_18656[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (14))){
var inst_18577 = (state_18600[(10)]);
var state_18600__$1 = state_18600;
var statearr_18627_18657 = state_18600__$1;
(statearr_18627_18657[(2)] = inst_18577);

(statearr_18627_18657[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (16))){
var state_18600__$1 = state_18600;
var statearr_18628_18658 = state_18600__$1;
(statearr_18628_18658[(2)] = null);

(statearr_18628_18658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (10))){
var inst_18571 = (state_18600[(9)]);
var inst_18571__$1 = superv.async._abort.call(null,S);
var inst_18572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18573 = [inst_18571__$1,ch];
var inst_18574 = (new cljs.core.PersistentVector(null,2,(5),inst_18572,inst_18573,null));
var state_18600__$1 = (function (){var statearr_18629 = state_18600;
(statearr_18629[(9)] = inst_18571__$1);

return statearr_18629;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18600__$1,(12),inst_18574,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_18601 === (18))){
var inst_18593 = (state_18600[(2)]);
var state_18600__$1 = state_18600;
var statearr_18630_18659 = state_18600__$1;
(statearr_18630_18659[(2)] = inst_18593);

(statearr_18630_18659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18601 === (8))){
var inst_18552 = (state_18600[(7)]);
var inst_18560 = (state_18600[(2)]);
var state_18600__$1 = (function (){var statearr_18631 = state_18600;
(statearr_18631[(11)] = inst_18560);

return statearr_18631;
})();
var statearr_18632_18660 = state_18600__$1;
(statearr_18632_18660[(2)] = inst_18552);

(statearr_18632_18660[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_18633 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18633[(0)] = superv$async$state_machine__3282__auto__);

(statearr_18633[(1)] = (1));

return statearr_18633;
});
var superv$async$state_machine__3282__auto____1 = (function (state_18600){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_18600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e18634){var ex__3285__auto__ = e18634;
var statearr_18635_18661 = state_18600;
(statearr_18635_18661[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_18600[(4)]))){
var statearr_18636_18662 = state_18600;
(statearr_18636_18662[(1)] = cljs.core.first.call(null,(state_18600[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18663 = state_18600;
state_18600 = G__18663;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_18600){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_18600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_18637 = f__3356__auto__.call(null);
(statearr_18637[(6)] = c__3355__auto__);

return statearr_18637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));

return c__3355__auto__;
}));

(superv.async.engulf.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(superv.async.engulf.cljs$lang$applyTo = (function (seq18545){
var G__18546 = cljs.core.first.call(null,seq18545);
var seq18545__$1 = cljs.core.next.call(null,seq18545);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18546,seq18545__$1);
}));

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__13485__auto___18861 = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto___18862 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__3355__auto___18863 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_18796){
var state_val_18797 = (state_18796[(1)]);
if((state_val_18797 === (7))){
var inst_18669 = (state_18796[(7)]);
var inst_18675 = superv.async._track_exception.call(null,S,inst_18669);
var state_18796__$1 = state_18796;
var statearr_18798_18864 = state_18796__$1;
(statearr_18798_18864[(2)] = inst_18675);

(statearr_18798_18864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (20))){
var inst_18685 = (state_18796[(8)]);
var inst_18707 = (state_18796[(9)]);
var inst_18740 = (state_18796[(10)]);
var inst_18740__$1 = superv.async._abort.call(null,S);
var inst_18741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18742 = f_GT_.call(null,inst_18685,inst_18707);
var inst_18743 = [inst_18740__$1,inst_18742];
var inst_18744 = (new cljs.core.PersistentVector(null,2,(5),inst_18741,inst_18743,null));
var state_18796__$1 = (function (){var statearr_18799 = state_18796;
(statearr_18799[(10)] = inst_18740__$1);

return statearr_18799;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18796__$1,(27),inst_18744,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_18797 === (27))){
var inst_18740 = (state_18796[(10)]);
var inst_18746 = (state_18796[(2)]);
var inst_18747 = cljs.core.nth.call(null,inst_18746,(0),null);
var inst_18748 = cljs.core.nth.call(null,inst_18746,(1),null);
var inst_18749 = cljs.core._EQ_.call(null,inst_18748,inst_18740);
var state_18796__$1 = (function (){var statearr_18800 = state_18796;
(statearr_18800[(11)] = inst_18747);

return statearr_18800;
})();
if(inst_18749){
var statearr_18801_18865 = state_18796__$1;
(statearr_18801_18865[(1)] = (28));

} else {
var statearr_18802_18866 = state_18796__$1;
(statearr_18802_18866[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (1))){
var state_18796__$1 = state_18796;
var statearr_18803_18867 = state_18796__$1;
(statearr_18803_18867[(2)] = null);

(statearr_18803_18867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (24))){
var inst_18707 = (state_18796[(9)]);
var state_18796__$1 = state_18796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18796__$1,(26),result,inst_18707);
} else {
if((state_val_18797 === (4))){
var _ = (function (){var statearr_18804 = state_18796;
(statearr_18804[(4)] = cljs.core.rest.call(null,(state_18796[(4)])));

return statearr_18804;
})();
var inst_18665 = (state_18796[(2)]);
var inst_18666 = superv.async._unregister_go.call(null,S,id__13486__auto___18862);
var ___$1 = (function (){var temp__5735__auto__ = (state_18796[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_18796__$1 = (function (){var statearr_18805 = state_18796;
(statearr_18805[(12)] = inst_18666);

return statearr_18805;
})();
var statearr_18806_18868 = state_18796__$1;
(statearr_18806_18868[(2)] = inst_18665);

(statearr_18806_18868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (15))){
var inst_18707 = (state_18796[(9)]);
var inst_18706 = (state_18796[(2)]);
var inst_18707__$1 = superv.async.throw_if_exception.call(null,S,inst_18706);
var state_18796__$1 = (function (){var statearr_18807 = state_18796;
(statearr_18807[(9)] = inst_18707__$1);

return statearr_18807;
})();
if(cljs.core.truth_(inst_18707__$1)){
var statearr_18808_18869 = state_18796__$1;
(statearr_18808_18869[(1)] = (16));

} else {
var statearr_18809_18870 = state_18796__$1;
(statearr_18809_18870[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (21))){
var inst_18761 = (state_18796[(2)]);
var state_18796__$1 = state_18796;
var statearr_18810_18871 = state_18796__$1;
(statearr_18810_18871[(2)] = inst_18761);

(statearr_18810_18871[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (31))){
var inst_18766 = (state_18796[(13)]);
var inst_18772 = (state_18796[(2)]);
var inst_18773 = cljs.core.nth.call(null,inst_18772,(0),null);
var inst_18774 = cljs.core.nth.call(null,inst_18772,(1),null);
var inst_18775 = cljs.core._EQ_.call(null,inst_18774,inst_18766);
var state_18796__$1 = (function (){var statearr_18811 = state_18796;
(statearr_18811[(14)] = inst_18773);

return statearr_18811;
})();
if(inst_18775){
var statearr_18812_18872 = state_18796__$1;
(statearr_18812_18872[(1)] = (32));

} else {
var statearr_18813_18873 = state_18796__$1;
(statearr_18813_18873[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (32))){
var inst_18777 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18778 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18779 = cljs.core.PersistentHashMap.fromArrays(inst_18777,inst_18778);
var inst_18780 = cljs.core.ex_info.call(null,"Aborted operations",inst_18779);
var state_18796__$1 = state_18796;
var statearr_18814_18874 = state_18796__$1;
(statearr_18814_18874[(2)] = inst_18780);

(statearr_18814_18874[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (33))){
var inst_18685 = (state_18796[(8)]);
var state_18796__$1 = state_18796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18796__$1,(35),result,inst_18685);
} else {
if((state_val_18797 === (13))){
var inst_18700 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18701 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18702 = cljs.core.PersistentHashMap.fromArrays(inst_18700,inst_18701);
var inst_18703 = cljs.core.ex_info.call(null,"Aborted operations",inst_18702);
var state_18796__$1 = state_18796;
var statearr_18815_18875 = state_18796__$1;
(statearr_18815_18875[(2)] = inst_18703);

(statearr_18815_18875[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (22))){
var inst_18714 = (state_18796[(15)]);
var inst_18720 = (state_18796[(2)]);
var inst_18721 = cljs.core.nth.call(null,inst_18720,(0),null);
var inst_18722 = cljs.core.nth.call(null,inst_18720,(1),null);
var inst_18723 = cljs.core._EQ_.call(null,inst_18722,inst_18714);
var state_18796__$1 = (function (){var statearr_18816 = state_18796;
(statearr_18816[(16)] = inst_18721);

return statearr_18816;
})();
if(inst_18723){
var statearr_18817_18876 = state_18796__$1;
(statearr_18817_18876[(1)] = (23));

} else {
var statearr_18818_18877 = state_18796__$1;
(statearr_18818_18877[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (29))){
var inst_18747 = (state_18796[(11)]);
var state_18796__$1 = state_18796;
var statearr_18819_18878 = state_18796__$1;
(statearr_18819_18878[(2)] = inst_18747);

(statearr_18819_18878[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (6))){
var state_18796__$1 = state_18796;
var statearr_18820_18879 = state_18796__$1;
(statearr_18820_18879[(2)] = null);

(statearr_18820_18879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (28))){
var inst_18751 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18752 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18753 = cljs.core.PersistentHashMap.fromArrays(inst_18751,inst_18752);
var inst_18754 = cljs.core.ex_info.call(null,"Aborted operations",inst_18753);
var state_18796__$1 = state_18796;
var statearr_18821_18880 = state_18796__$1;
(statearr_18821_18880[(2)] = inst_18754);

(statearr_18821_18880[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (25))){
var inst_18733 = (state_18796[(2)]);
var inst_18734 = superv.async.throw_if_exception.call(null,S,inst_18733);
var inst_18735 = cljs.core.async.close_BANG_.call(null,result);
var state_18796__$1 = (function (){var statearr_18822 = state_18796;
(statearr_18822[(17)] = inst_18734);

return statearr_18822;
})();
var statearr_18823_18881 = state_18796__$1;
(statearr_18823_18881[(2)] = inst_18735);

(statearr_18823_18881[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (34))){
var inst_18785 = (state_18796[(2)]);
var inst_18786 = superv.async.throw_if_exception.call(null,S,inst_18785);
var inst_18787 = cljs.core.async.close_BANG_.call(null,result);
var state_18796__$1 = (function (){var statearr_18824 = state_18796;
(statearr_18824[(18)] = inst_18786);

return statearr_18824;
})();
var statearr_18825_18882 = state_18796__$1;
(statearr_18825_18882[(2)] = inst_18787);

(statearr_18825_18882[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (17))){
var inst_18766 = (state_18796[(13)]);
var inst_18766__$1 = superv.async._abort.call(null,S);
var inst_18767 = cljs.core.async.timeout.call(null,(0));
var inst_18768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18769 = [inst_18766__$1,inst_18767];
var inst_18770 = (new cljs.core.PersistentVector(null,2,(5),inst_18768,inst_18769,null));
var state_18796__$1 = (function (){var statearr_18826 = state_18796;
(statearr_18826[(13)] = inst_18766__$1);

return statearr_18826;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18796__$1,(31),inst_18770,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_18797 === (3))){
var inst_18794 = (state_18796[(2)]);
var state_18796__$1 = state_18796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18796__$1,inst_18794);
} else {
if((state_val_18797 === (12))){
var inst_18690 = (state_18796[(19)]);
var inst_18695 = (state_18796[(2)]);
var inst_18696 = cljs.core.nth.call(null,inst_18695,(0),null);
var inst_18697 = cljs.core.nth.call(null,inst_18695,(1),null);
var inst_18698 = cljs.core._EQ_.call(null,inst_18697,inst_18690);
var state_18796__$1 = (function (){var statearr_18827 = state_18796;
(statearr_18827[(20)] = inst_18696);

return statearr_18827;
})();
if(inst_18698){
var statearr_18828_18883 = state_18796__$1;
(statearr_18828_18883[(1)] = (13));

} else {
var statearr_18829_18884 = state_18796__$1;
(statearr_18829_18884[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (2))){
var _ = (function (){var statearr_18830 = state_18796;
(statearr_18830[(4)] = cljs.core.cons.call(null,(4),(state_18796[(4)])));

return statearr_18830;
})();
var ___$1 = (function (){var statearr_18831 = state_18796;
(statearr_18831[(4)] = cljs.core.cons.call(null,(9),(state_18796[(4)])));

return statearr_18831;
})();
var inst_18684 = acc;
var inst_18685 = inst_18684;
var state_18796__$1 = (function (){var statearr_18832 = state_18796;
(statearr_18832[(8)] = inst_18685);

return statearr_18832;
})();
var statearr_18833_18885 = state_18796__$1;
(statearr_18833_18885[(2)] = null);

(statearr_18833_18885[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (23))){
var inst_18725 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18726 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18727 = cljs.core.PersistentHashMap.fromArrays(inst_18725,inst_18726);
var inst_18728 = cljs.core.ex_info.call(null,"Aborted operations",inst_18727);
var state_18796__$1 = state_18796;
var statearr_18834_18886 = state_18796__$1;
(statearr_18834_18886[(2)] = inst_18728);

(statearr_18834_18886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (35))){
var inst_18783 = (state_18796[(2)]);
var state_18796__$1 = state_18796;
var statearr_18835_18887 = state_18796__$1;
(statearr_18835_18887[(2)] = inst_18783);

(statearr_18835_18887[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (19))){
var inst_18714 = (state_18796[(15)]);
var inst_18714__$1 = superv.async._abort.call(null,S);
var inst_18715 = cljs.core.async.timeout.call(null,(0));
var inst_18716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18717 = [inst_18714__$1,inst_18715];
var inst_18718 = (new cljs.core.PersistentVector(null,2,(5),inst_18716,inst_18717,null));
var state_18796__$1 = (function (){var statearr_18837 = state_18796;
(statearr_18837[(15)] = inst_18714__$1);

return statearr_18837;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18796__$1,(22),inst_18718,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_18797 === (11))){
var inst_18791 = (state_18796[(2)]);
var _ = (function (){var statearr_18838 = state_18796;
(statearr_18838[(4)] = cljs.core.rest.call(null,(state_18796[(4)])));

return statearr_18838;
})();
var state_18796__$1 = state_18796;
var statearr_18839_18888 = state_18796__$1;
(statearr_18839_18888[(2)] = inst_18791);

(statearr_18839_18888[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (9))){
var _ = (function (){var statearr_18840 = state_18796;
(statearr_18840[(4)] = cljs.core.rest.call(null,(state_18796[(4)])));

return statearr_18840;
})();
var state_18796__$1 = state_18796;
var ex18836 = (state_18796__$1[(2)]);
var statearr_18841_18889 = state_18796__$1;
(statearr_18841_18889[(5)] = ex18836);


if((ex18836 instanceof Error)){
var statearr_18842_18890 = state_18796__$1;
(statearr_18842_18890[(1)] = (5));

(statearr_18842_18890[(5)] = null);

} else {
throw ex18836;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (5))){
var inst_18669 = (state_18796[(7)]);
var inst_18669__$1 = (state_18796[(2)]);
var inst_18670 = cljs.core.ex_data.call(null,inst_18669__$1);
var inst_18671 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18670);
var inst_18672 = cljs.core._EQ_.call(null,inst_18671,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_18796__$1 = (function (){var statearr_18843 = state_18796;
(statearr_18843[(7)] = inst_18669__$1);

return statearr_18843;
})();
if(inst_18672){
var statearr_18844_18891 = state_18796__$1;
(statearr_18844_18891[(1)] = (6));

} else {
var statearr_18845_18892 = state_18796__$1;
(statearr_18845_18892[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (14))){
var inst_18696 = (state_18796[(20)]);
var state_18796__$1 = state_18796;
var statearr_18846_18893 = state_18796__$1;
(statearr_18846_18893[(2)] = inst_18696);

(statearr_18846_18893[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (26))){
var inst_18731 = (state_18796[(2)]);
var state_18796__$1 = state_18796;
var statearr_18847_18894 = state_18796__$1;
(statearr_18847_18894[(2)] = inst_18731);

(statearr_18847_18894[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (16))){
var inst_18707 = (state_18796[(9)]);
var inst_18709 = (inst_18707 instanceof Error);
var state_18796__$1 = state_18796;
if(cljs.core.truth_(inst_18709)){
var statearr_18848_18895 = state_18796__$1;
(statearr_18848_18895[(1)] = (19));

} else {
var statearr_18849_18896 = state_18796__$1;
(statearr_18849_18896[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (30))){
var inst_18757 = (state_18796[(2)]);
var inst_18758 = superv.async.throw_if_exception.call(null,S,inst_18757);
var inst_18685 = inst_18758;
var state_18796__$1 = (function (){var statearr_18850 = state_18796;
(statearr_18850[(8)] = inst_18685);

return statearr_18850;
})();
var statearr_18851_18897 = state_18796__$1;
(statearr_18851_18897[(2)] = null);

(statearr_18851_18897[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (10))){
var inst_18690 = (state_18796[(19)]);
var inst_18690__$1 = superv.async._abort.call(null,S);
var inst_18691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18692 = [inst_18690__$1,ch];
var inst_18693 = (new cljs.core.PersistentVector(null,2,(5),inst_18691,inst_18692,null));
var state_18796__$1 = (function (){var statearr_18852 = state_18796;
(statearr_18852[(19)] = inst_18690__$1);

return statearr_18852;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18796__$1,(12),inst_18693,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_18797 === (18))){
var inst_18789 = (state_18796[(2)]);
var state_18796__$1 = state_18796;
var statearr_18853_18898 = state_18796__$1;
(statearr_18853_18898[(2)] = inst_18789);

(statearr_18853_18898[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18797 === (8))){
var inst_18669 = (state_18796[(7)]);
var inst_18677 = (state_18796[(2)]);
var state_18796__$1 = (function (){var statearr_18854 = state_18796;
(statearr_18854[(21)] = inst_18677);

return statearr_18854;
})();
var statearr_18855_18899 = state_18796__$1;
(statearr_18855_18899[(2)] = inst_18669);

(statearr_18855_18899[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$reduce_GT__$_state_machine__3282__auto__ = null;
var superv$async$reduce_GT__$_state_machine__3282__auto____0 = (function (){
var statearr_18856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18856[(0)] = superv$async$reduce_GT__$_state_machine__3282__auto__);

(statearr_18856[(1)] = (1));

return statearr_18856;
});
var superv$async$reduce_GT__$_state_machine__3282__auto____1 = (function (state_18796){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_18796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e18857){var ex__3285__auto__ = e18857;
var statearr_18858_18900 = state_18796;
(statearr_18858_18900[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_18796[(4)]))){
var statearr_18859_18901 = state_18796;
(statearr_18859_18901[(1)] = cljs.core.first.call(null,(state_18796[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18902 = state_18796;
state_18796 = G__18902;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__3282__auto__ = function(state_18796){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__3282__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__3282__auto____1.call(this,state_18796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_GT__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__3282__auto____0;
superv$async$reduce_GT__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__3282__auto____1;
return superv$async$reduce_GT__$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_18860 = f__3356__auto__.call(null);
(statearr_18860[(6)] = c__3355__auto___18863);

return statearr_18860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___19046 = arguments.length;
var i__4737__auto___19047 = (0);
while(true){
if((i__4737__auto___19047 < len__4736__auto___19046)){
args__4742__auto__.push((arguments[i__4737__auto___19047]));

var G__19048 = (i__4737__auto___19047 + (1));
i__4737__auto___19047 = G__19048;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__13485__auto___19049 = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto___19050 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__3355__auto___19051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_18992){
var state_val_18993 = (state_18992[(1)]);
if((state_val_18993 === (7))){
var inst_18910 = (state_18992[(7)]);
var inst_18916 = superv.async._track_exception.call(null,S,inst_18910);
var state_18992__$1 = state_18992;
var statearr_18994_19052 = state_18992__$1;
(statearr_18994_19052[(2)] = inst_18916);

(statearr_18994_19052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (20))){
var inst_18926 = (state_18992[(8)]);
var inst_18978 = cljs.core.rest.call(null,inst_18926);
var inst_18926__$1 = inst_18978;
var state_18992__$1 = (function (){var statearr_18995 = state_18992;
(statearr_18995[(8)] = inst_18926__$1);

return statearr_18995;
})();
var statearr_18996_19053 = state_18992__$1;
(statearr_18996_19053[(2)] = null);

(statearr_18996_19053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (1))){
var state_18992__$1 = state_18992;
var statearr_18997_19054 = state_18992__$1;
(statearr_18997_19054[(2)] = null);

(statearr_18997_19054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (24))){
var inst_18950 = (state_18992[(9)]);
var state_18992__$1 = state_18992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18992__$1,(26),out,inst_18950);
} else {
if((state_val_18993 === (4))){
var _ = (function (){var statearr_18998 = state_18992;
(statearr_18998[(4)] = cljs.core.rest.call(null,(state_18992[(4)])));

return statearr_18998;
})();
var inst_18906 = (state_18992[(2)]);
var inst_18907 = superv.async._unregister_go.call(null,S,id__13486__auto___19050);
var ___$1 = (function (){var temp__5735__auto__ = (state_18992[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_18992__$1 = (function (){var statearr_18999 = state_18992;
(statearr_18999[(10)] = inst_18907);

return statearr_18999;
})();
var statearr_19000_19055 = state_18992__$1;
(statearr_19000_19055[(2)] = inst_18906);

(statearr_19000_19055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (15))){
var inst_18933 = (state_18992[(11)]);
var inst_18938 = (state_18992[(2)]);
var inst_18939 = cljs.core.nth.call(null,inst_18938,(0),null);
var inst_18940 = cljs.core.nth.call(null,inst_18938,(1),null);
var inst_18941 = cljs.core._EQ_.call(null,inst_18940,inst_18933);
var state_18992__$1 = (function (){var statearr_19001 = state_18992;
(statearr_19001[(12)] = inst_18939);

return statearr_19001;
})();
if(inst_18941){
var statearr_19002_19056 = state_18992__$1;
(statearr_19002_19056[(1)] = (16));

} else {
var statearr_19003_19057 = state_18992__$1;
(statearr_19003_19057[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (21))){
var inst_18981 = (state_18992[(2)]);
var state_18992__$1 = state_18992;
var statearr_19004_19058 = state_18992__$1;
(statearr_19004_19058[(2)] = inst_18981);

(statearr_19004_19058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (13))){
var inst_18983 = cljs.core.async.close_BANG_.call(null,out);
var state_18992__$1 = state_18992;
var statearr_19005_19059 = state_18992__$1;
(statearr_19005_19059[(2)] = inst_18983);

(statearr_19005_19059[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (22))){
var inst_18955 = (state_18992[(13)]);
var inst_18961 = (state_18992[(2)]);
var inst_18962 = cljs.core.nth.call(null,inst_18961,(0),null);
var inst_18963 = cljs.core.nth.call(null,inst_18961,(1),null);
var inst_18964 = cljs.core._EQ_.call(null,inst_18963,inst_18955);
var state_18992__$1 = (function (){var statearr_19007 = state_18992;
(statearr_19007[(14)] = inst_18962);

return statearr_19007;
})();
if(inst_18964){
var statearr_19008_19060 = state_18992__$1;
(statearr_19008_19060[(1)] = (23));

} else {
var statearr_19009_19061 = state_18992__$1;
(statearr_19009_19061[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (6))){
var state_18992__$1 = state_18992;
var statearr_19010_19062 = state_18992__$1;
(statearr_19010_19062[(2)] = null);

(statearr_19010_19062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (25))){
var inst_18926 = (state_18992[(8)]);
var inst_18974 = (state_18992[(2)]);
var inst_18975 = superv.async.throw_if_exception.call(null,S,inst_18974);
var tmp19006 = inst_18926;
var inst_18926__$1 = tmp19006;
var state_18992__$1 = (function (){var statearr_19011 = state_18992;
(statearr_19011[(8)] = inst_18926__$1);

(statearr_19011[(15)] = inst_18975);

return statearr_19011;
})();
var statearr_19012_19063 = state_18992__$1;
(statearr_19012_19063[(2)] = null);

(statearr_19012_19063[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (17))){
var inst_18939 = (state_18992[(12)]);
var state_18992__$1 = state_18992;
var statearr_19013_19064 = state_18992__$1;
(statearr_19013_19064[(2)] = inst_18939);

(statearr_19013_19064[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (3))){
var inst_18990 = (state_18992[(2)]);
var state_18992__$1 = state_18992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18992__$1,inst_18990);
} else {
if((state_val_18993 === (12))){
var inst_18928 = (state_18992[(16)]);
var inst_18933 = (state_18992[(11)]);
var inst_18933__$1 = superv.async._abort.call(null,S);
var inst_18934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18935 = [inst_18933__$1,inst_18928];
var inst_18936 = (new cljs.core.PersistentVector(null,2,(5),inst_18934,inst_18935,null));
var state_18992__$1 = (function (){var statearr_19014 = state_18992;
(statearr_19014[(11)] = inst_18933__$1);

return statearr_19014;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18992__$1,(15),inst_18936,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_18993 === (2))){
var _ = (function (){var statearr_19015 = state_18992;
(statearr_19015[(4)] = cljs.core.cons.call(null,(4),(state_18992[(4)])));

return statearr_19015;
})();
var ___$1 = (function (){var statearr_19016 = state_18992;
(statearr_19016[(4)] = cljs.core.cons.call(null,(9),(state_18992[(4)])));

return statearr_19016;
})();
var inst_18925 = cs;
var inst_18926 = inst_18925;
var state_18992__$1 = (function (){var statearr_19017 = state_18992;
(statearr_19017[(8)] = inst_18926);

return statearr_19017;
})();
var statearr_19018_19065 = state_18992__$1;
(statearr_19018_19065[(2)] = null);

(statearr_19018_19065[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (23))){
var inst_18966 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18967 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18968 = cljs.core.PersistentHashMap.fromArrays(inst_18966,inst_18967);
var inst_18969 = cljs.core.ex_info.call(null,"Aborted operations",inst_18968);
var state_18992__$1 = state_18992;
var statearr_19019_19066 = state_18992__$1;
(statearr_19019_19066[(2)] = inst_18969);

(statearr_19019_19066[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (19))){
var inst_18955 = (state_18992[(13)]);
var inst_18955__$1 = superv.async._abort.call(null,S);
var inst_18956 = cljs.core.async.timeout.call(null,(0));
var inst_18957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18958 = [inst_18955__$1,inst_18956];
var inst_18959 = (new cljs.core.PersistentVector(null,2,(5),inst_18957,inst_18958,null));
var state_18992__$1 = (function (){var statearr_19021 = state_18992;
(statearr_19021[(13)] = inst_18955__$1);

return statearr_19021;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18992__$1,(22),inst_18959,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_18993 === (11))){
var inst_18987 = (state_18992[(2)]);
var _ = (function (){var statearr_19022 = state_18992;
(statearr_19022[(4)] = cljs.core.rest.call(null,(state_18992[(4)])));

return statearr_19022;
})();
var state_18992__$1 = state_18992;
var statearr_19023_19067 = state_18992__$1;
(statearr_19023_19067[(2)] = inst_18987);

(statearr_19023_19067[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (9))){
var _ = (function (){var statearr_19024 = state_18992;
(statearr_19024[(4)] = cljs.core.rest.call(null,(state_18992[(4)])));

return statearr_19024;
})();
var state_18992__$1 = state_18992;
var ex19020 = (state_18992__$1[(2)]);
var statearr_19025_19068 = state_18992__$1;
(statearr_19025_19068[(5)] = ex19020);


if((ex19020 instanceof Error)){
var statearr_19026_19069 = state_18992__$1;
(statearr_19026_19069[(1)] = (5));

(statearr_19026_19069[(5)] = null);

} else {
throw ex19020;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (5))){
var inst_18910 = (state_18992[(7)]);
var inst_18910__$1 = (state_18992[(2)]);
var inst_18911 = cljs.core.ex_data.call(null,inst_18910__$1);
var inst_18912 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18911);
var inst_18913 = cljs.core._EQ_.call(null,inst_18912,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_18992__$1 = (function (){var statearr_19027 = state_18992;
(statearr_19027[(7)] = inst_18910__$1);

return statearr_19027;
})();
if(inst_18913){
var statearr_19028_19070 = state_18992__$1;
(statearr_19028_19070[(1)] = (6));

} else {
var statearr_19029_19071 = state_18992__$1;
(statearr_19029_19071[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (14))){
var inst_18985 = (state_18992[(2)]);
var state_18992__$1 = state_18992;
var statearr_19030_19072 = state_18992__$1;
(statearr_19030_19072[(2)] = inst_18985);

(statearr_19030_19072[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (26))){
var inst_18972 = (state_18992[(2)]);
var state_18992__$1 = state_18992;
var statearr_19031_19073 = state_18992__$1;
(statearr_19031_19073[(2)] = inst_18972);

(statearr_19031_19073[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (16))){
var inst_18943 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_18944 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_18945 = cljs.core.PersistentHashMap.fromArrays(inst_18943,inst_18944);
var inst_18946 = cljs.core.ex_info.call(null,"Aborted operations",inst_18945);
var state_18992__$1 = state_18992;
var statearr_19032_19074 = state_18992__$1;
(statearr_19032_19074[(2)] = inst_18946);

(statearr_19032_19074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (10))){
var inst_18926 = (state_18992[(8)]);
var inst_18928 = (state_18992[(16)]);
var inst_18928__$1 = cljs.core.first.call(null,inst_18926);
var state_18992__$1 = (function (){var statearr_19033 = state_18992;
(statearr_19033[(16)] = inst_18928__$1);

return statearr_19033;
})();
if(cljs.core.truth_(inst_18928__$1)){
var statearr_19034_19075 = state_18992__$1;
(statearr_19034_19075[(1)] = (12));

} else {
var statearr_19035_19076 = state_18992__$1;
(statearr_19035_19076[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (18))){
var inst_18950 = (state_18992[(9)]);
var inst_18949 = (state_18992[(2)]);
var inst_18950__$1 = superv.async.throw_if_exception.call(null,S,inst_18949);
var state_18992__$1 = (function (){var statearr_19036 = state_18992;
(statearr_19036[(9)] = inst_18950__$1);

return statearr_19036;
})();
if(cljs.core.truth_(inst_18950__$1)){
var statearr_19037_19077 = state_18992__$1;
(statearr_19037_19077[(1)] = (19));

} else {
var statearr_19038_19078 = state_18992__$1;
(statearr_19038_19078[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18993 === (8))){
var inst_18910 = (state_18992[(7)]);
var inst_18918 = (state_18992[(2)]);
var state_18992__$1 = (function (){var statearr_19039 = state_18992;
(statearr_19039[(17)] = inst_18918);

return statearr_19039;
})();
var statearr_19040_19079 = state_18992__$1;
(statearr_19040_19079[(2)] = inst_18910);

(statearr_19040_19079[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_19041 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19041[(0)] = superv$async$state_machine__3282__auto__);

(statearr_19041[(1)] = (1));

return statearr_19041;
});
var superv$async$state_machine__3282__auto____1 = (function (state_18992){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_18992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e19042){var ex__3285__auto__ = e19042;
var statearr_19043_19080 = state_18992;
(statearr_19043_19080[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_18992[(4)]))){
var statearr_19044_19081 = state_18992;
(statearr_19044_19081[(1)] = cljs.core.first.call(null,(state_18992[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19082 = state_18992;
state_18992 = G__19082;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_18992){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_18992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_19045 = f__3356__auto__.call(null);
(statearr_19045[(6)] = c__3355__auto___19051);

return statearr_19045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
}));

(superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq18903){
var G__18904 = cljs.core.first.call(null,seq18903);
var seq18903__$1 = cljs.core.next.call(null,seq18903);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18904,seq18903__$1);
}));

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___19313 = arguments.length;
var i__4737__auto___19314 = (0);
while(true){
if((i__4737__auto___19314 < len__4736__auto___19313)){
args__4742__auto__.push((arguments[i__4737__auto___19314]));

var G__19315 = (i__4737__auto___19314 + (1));
i__4737__auto___19314 = G__19315;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__19087){
var map__19088 = p__19087;
var map__19088__$1 = (((((!((map__19088 == null))))?(((((map__19088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19088.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19088):map__19088);
var out_ch = cljs.core.get.call(null,map__19088__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__4126__auto__ = out_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__13485__auto___19316 = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto___19317 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__3355__auto___19318 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_19238){
var state_val_19239 = (state_19238[(1)]);
if((state_val_19239 === (7))){
var inst_19095 = (state_19238[(7)]);
var inst_19101 = superv.async._track_exception.call(null,S,inst_19095);
var state_19238__$1 = state_19238;
var statearr_19240_19319 = state_19238__$1;
(statearr_19240_19319[(2)] = inst_19101);

(statearr_19240_19319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (20))){
var inst_19133 = (state_19238[(8)]);
var inst_19111 = (state_19238[(9)]);
var inst_19163 = (state_19238[(10)]);
var inst_19163__$1 = cljs.core.conj.call(null,inst_19111,inst_19133);
var inst_19164 = cljs.core.count.call(null,inst_19163__$1);
var inst_19165 = cljs.core._EQ_.call(null,n,inst_19164);
var state_19238__$1 = (function (){var statearr_19241 = state_19238;
(statearr_19241[(10)] = inst_19163__$1);

return statearr_19241;
})();
if(inst_19165){
var statearr_19242_19320 = state_19238__$1;
(statearr_19242_19320[(1)] = (27));

} else {
var statearr_19243_19321 = state_19238__$1;
(statearr_19243_19321[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (27))){
var inst_19170 = (state_19238[(11)]);
var inst_19170__$1 = superv.async._abort.call(null,S);
var inst_19171 = cljs.core.async.timeout.call(null,(0));
var inst_19172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19173 = [inst_19170__$1,inst_19171];
var inst_19174 = (new cljs.core.PersistentVector(null,2,(5),inst_19172,inst_19173,null));
var state_19238__$1 = (function (){var statearr_19244 = state_19238;
(statearr_19244[(11)] = inst_19170__$1);

return statearr_19244;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19238__$1,(30),inst_19174,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19239 === (1))){
var state_19238__$1 = state_19238;
var statearr_19245_19322 = state_19238__$1;
(statearr_19245_19322[(2)] = null);

(statearr_19245_19322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (24))){
var inst_19133 = (state_19238[(8)]);
var state_19238__$1 = state_19238;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19238__$1,(26),out_ch__$1,inst_19133);
} else {
if((state_val_19239 === (39))){
var inst_19216 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_19217 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_19218 = cljs.core.PersistentHashMap.fromArrays(inst_19216,inst_19217);
var inst_19219 = cljs.core.ex_info.call(null,"Aborted operations",inst_19218);
var state_19238__$1 = state_19238;
var statearr_19246_19323 = state_19238__$1;
(statearr_19246_19323[(2)] = inst_19219);

(statearr_19246_19323[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (4))){
var _ = (function (){var statearr_19247 = state_19238;
(statearr_19247[(4)] = cljs.core.rest.call(null,(state_19238[(4)])));

return statearr_19247;
})();
var inst_19091 = (state_19238[(2)]);
var inst_19092 = superv.async._unregister_go.call(null,S,id__13486__auto___19317);
var ___$1 = (function (){var temp__5735__auto__ = (state_19238[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_19238__$1 = (function (){var statearr_19248 = state_19238;
(statearr_19248[(12)] = inst_19092);

return statearr_19248;
})();
var statearr_19249_19324 = state_19238__$1;
(statearr_19249_19324[(2)] = inst_19091);

(statearr_19249_19324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (15))){
var inst_19133 = (state_19238[(8)]);
var inst_19132 = (state_19238[(2)]);
var inst_19133__$1 = superv.async.throw_if_exception.call(null,S,inst_19132);
var state_19238__$1 = (function (){var statearr_19250 = state_19238;
(statearr_19250[(8)] = inst_19133__$1);

return statearr_19250;
})();
if(cljs.core.truth_(inst_19133__$1)){
var statearr_19251_19325 = state_19238__$1;
(statearr_19251_19325[(1)] = (16));

} else {
var statearr_19252_19326 = state_19238__$1;
(statearr_19252_19326[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (21))){
var inst_19198 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
var statearr_19253_19327 = state_19238__$1;
(statearr_19253_19327[(2)] = inst_19198);

(statearr_19253_19327[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (31))){
var inst_19181 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_19182 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_19183 = cljs.core.PersistentHashMap.fromArrays(inst_19181,inst_19182);
var inst_19184 = cljs.core.ex_info.call(null,"Aborted operations",inst_19183);
var state_19238__$1 = state_19238;
var statearr_19254_19328 = state_19238__$1;
(statearr_19254_19328[(2)] = inst_19184);

(statearr_19254_19328[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (32))){
var inst_19163 = (state_19238[(10)]);
var state_19238__$1 = state_19238;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19238__$1,(34),out_ch__$1,inst_19163);
} else {
if((state_val_19239 === (40))){
var inst_19111 = (state_19238[(9)]);
var state_19238__$1 = state_19238;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19238__$1,(42),out_ch__$1,inst_19111);
} else {
if((state_val_19239 === (33))){
var inst_19189 = (state_19238[(2)]);
var inst_19190 = superv.async.throw_if_exception.call(null,S,inst_19189);
var inst_19191 = cljs.core.PersistentVector.EMPTY;
var inst_19111 = inst_19191;
var state_19238__$1 = (function (){var statearr_19255 = state_19238;
(statearr_19255[(13)] = inst_19190);

(statearr_19255[(9)] = inst_19111);

return statearr_19255;
})();
var statearr_19256_19329 = state_19238__$1;
(statearr_19256_19329[(2)] = null);

(statearr_19256_19329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (13))){
var inst_19126 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_19127 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_19128 = cljs.core.PersistentHashMap.fromArrays(inst_19126,inst_19127);
var inst_19129 = cljs.core.ex_info.call(null,"Aborted operations",inst_19128);
var state_19238__$1 = state_19238;
var statearr_19257_19330 = state_19238__$1;
(statearr_19257_19330[(2)] = inst_19129);

(statearr_19257_19330[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (22))){
var inst_19140 = (state_19238[(14)]);
var inst_19146 = (state_19238[(2)]);
var inst_19147 = cljs.core.nth.call(null,inst_19146,(0),null);
var inst_19148 = cljs.core.nth.call(null,inst_19146,(1),null);
var inst_19149 = cljs.core._EQ_.call(null,inst_19148,inst_19140);
var state_19238__$1 = (function (){var statearr_19258 = state_19238;
(statearr_19258[(15)] = inst_19147);

return statearr_19258;
})();
if(inst_19149){
var statearr_19259_19331 = state_19238__$1;
(statearr_19259_19331[(1)] = (23));

} else {
var statearr_19260_19332 = state_19238__$1;
(statearr_19260_19332[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (36))){
var state_19238__$1 = state_19238;
var statearr_19261_19333 = state_19238__$1;
(statearr_19261_19333[(2)] = null);

(statearr_19261_19333[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (41))){
var inst_19224 = (state_19238[(2)]);
var inst_19225 = superv.async.throw_if_exception.call(null,S,inst_19224);
var state_19238__$1 = state_19238;
var statearr_19262_19334 = state_19238__$1;
(statearr_19262_19334[(2)] = inst_19225);

(statearr_19262_19334[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (29))){
var inst_19196 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
var statearr_19263_19335 = state_19238__$1;
(statearr_19263_19335[(2)] = inst_19196);

(statearr_19263_19335[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (6))){
var state_19238__$1 = state_19238;
var statearr_19264_19336 = state_19238__$1;
(statearr_19264_19336[(2)] = null);

(statearr_19264_19336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (28))){
var inst_19163 = (state_19238[(10)]);
var inst_19111 = inst_19163;
var state_19238__$1 = (function (){var statearr_19265 = state_19238;
(statearr_19265[(9)] = inst_19111);

return statearr_19265;
})();
var statearr_19266_19337 = state_19238__$1;
(statearr_19266_19337[(2)] = null);

(statearr_19266_19337[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (25))){
var inst_19159 = (state_19238[(2)]);
var inst_19160 = superv.async.throw_if_exception.call(null,S,inst_19159);
var inst_19161 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_19238__$1 = (function (){var statearr_19267 = state_19238;
(statearr_19267[(16)] = inst_19160);

return statearr_19267;
})();
var statearr_19268_19338 = state_19238__$1;
(statearr_19268_19338[(2)] = inst_19161);

(statearr_19268_19338[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (34))){
var inst_19187 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
var statearr_19269_19339 = state_19238__$1;
(statearr_19269_19339[(2)] = inst_19187);

(statearr_19269_19339[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (17))){
var inst_19111 = (state_19238[(9)]);
var inst_19200 = cljs.core.not_empty.call(null,inst_19111);
var state_19238__$1 = state_19238;
if(cljs.core.truth_(inst_19200)){
var statearr_19270_19340 = state_19238__$1;
(statearr_19270_19340[(1)] = (35));

} else {
var statearr_19271_19341 = state_19238__$1;
(statearr_19271_19341[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (3))){
var inst_19236 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19238__$1,inst_19236);
} else {
if((state_val_19239 === (12))){
var inst_19116 = (state_19238[(17)]);
var inst_19121 = (state_19238[(2)]);
var inst_19122 = cljs.core.nth.call(null,inst_19121,(0),null);
var inst_19123 = cljs.core.nth.call(null,inst_19121,(1),null);
var inst_19124 = cljs.core._EQ_.call(null,inst_19123,inst_19116);
var state_19238__$1 = (function (){var statearr_19272 = state_19238;
(statearr_19272[(18)] = inst_19122);

return statearr_19272;
})();
if(inst_19124){
var statearr_19273_19342 = state_19238__$1;
(statearr_19273_19342[(1)] = (13));

} else {
var statearr_19274_19343 = state_19238__$1;
(statearr_19274_19343[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (2))){
var _ = (function (){var statearr_19275 = state_19238;
(statearr_19275[(4)] = cljs.core.cons.call(null,(4),(state_19238[(4)])));

return statearr_19275;
})();
var ___$1 = (function (){var statearr_19276 = state_19238;
(statearr_19276[(4)] = cljs.core.cons.call(null,(9),(state_19238[(4)])));

return statearr_19276;
})();
var inst_19110 = cljs.core.PersistentVector.EMPTY;
var inst_19111 = inst_19110;
var state_19238__$1 = (function (){var statearr_19277 = state_19238;
(statearr_19277[(9)] = inst_19111);

return statearr_19277;
})();
var statearr_19278_19344 = state_19238__$1;
(statearr_19278_19344[(2)] = null);

(statearr_19278_19344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (23))){
var inst_19151 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_19152 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_19153 = cljs.core.PersistentHashMap.fromArrays(inst_19151,inst_19152);
var inst_19154 = cljs.core.ex_info.call(null,"Aborted operations",inst_19153);
var state_19238__$1 = state_19238;
var statearr_19279_19345 = state_19238__$1;
(statearr_19279_19345[(2)] = inst_19154);

(statearr_19279_19345[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (35))){
var inst_19205 = (state_19238[(19)]);
var inst_19205__$1 = superv.async._abort.call(null,S);
var inst_19206 = cljs.core.async.timeout.call(null,(0));
var inst_19207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19208 = [inst_19205__$1,inst_19206];
var inst_19209 = (new cljs.core.PersistentVector(null,2,(5),inst_19207,inst_19208,null));
var state_19238__$1 = (function (){var statearr_19280 = state_19238;
(statearr_19280[(19)] = inst_19205__$1);

return statearr_19280;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19238__$1,(38),inst_19209,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19239 === (19))){
var inst_19140 = (state_19238[(14)]);
var inst_19140__$1 = superv.async._abort.call(null,S);
var inst_19141 = cljs.core.async.timeout.call(null,(0));
var inst_19142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19143 = [inst_19140__$1,inst_19141];
var inst_19144 = (new cljs.core.PersistentVector(null,2,(5),inst_19142,inst_19143,null));
var state_19238__$1 = (function (){var statearr_19282 = state_19238;
(statearr_19282[(14)] = inst_19140__$1);

return statearr_19282;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19238__$1,(22),inst_19144,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19239 === (11))){
var inst_19233 = (state_19238[(2)]);
var _ = (function (){var statearr_19283 = state_19238;
(statearr_19283[(4)] = cljs.core.rest.call(null,(state_19238[(4)])));

return statearr_19283;
})();
var state_19238__$1 = state_19238;
var statearr_19284_19346 = state_19238__$1;
(statearr_19284_19346[(2)] = inst_19233);

(statearr_19284_19346[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (9))){
var _ = (function (){var statearr_19285 = state_19238;
(statearr_19285[(4)] = cljs.core.rest.call(null,(state_19238[(4)])));

return statearr_19285;
})();
var state_19238__$1 = state_19238;
var ex19281 = (state_19238__$1[(2)]);
var statearr_19286_19347 = state_19238__$1;
(statearr_19286_19347[(5)] = ex19281);


if((ex19281 instanceof Error)){
var statearr_19287_19348 = state_19238__$1;
(statearr_19287_19348[(1)] = (5));

(statearr_19287_19348[(5)] = null);

} else {
throw ex19281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (5))){
var inst_19095 = (state_19238[(7)]);
var inst_19095__$1 = (state_19238[(2)]);
var inst_19096 = cljs.core.ex_data.call(null,inst_19095__$1);
var inst_19097 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19096);
var inst_19098 = cljs.core._EQ_.call(null,inst_19097,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_19238__$1 = (function (){var statearr_19288 = state_19238;
(statearr_19288[(7)] = inst_19095__$1);

return statearr_19288;
})();
if(inst_19098){
var statearr_19289_19349 = state_19238__$1;
(statearr_19289_19349[(1)] = (6));

} else {
var statearr_19290_19350 = state_19238__$1;
(statearr_19290_19350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (14))){
var inst_19122 = (state_19238[(18)]);
var state_19238__$1 = state_19238;
var statearr_19291_19351 = state_19238__$1;
(statearr_19291_19351[(2)] = inst_19122);

(statearr_19291_19351[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (26))){
var inst_19157 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
var statearr_19292_19352 = state_19238__$1;
(statearr_19292_19352[(2)] = inst_19157);

(statearr_19292_19352[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (16))){
var inst_19133 = (state_19238[(8)]);
var inst_19135 = (inst_19133 instanceof Error);
var state_19238__$1 = state_19238;
if(cljs.core.truth_(inst_19135)){
var statearr_19293_19353 = state_19238__$1;
(statearr_19293_19353[(1)] = (19));

} else {
var statearr_19294_19354 = state_19238__$1;
(statearr_19294_19354[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (38))){
var inst_19205 = (state_19238[(19)]);
var inst_19211 = (state_19238[(2)]);
var inst_19212 = cljs.core.nth.call(null,inst_19211,(0),null);
var inst_19213 = cljs.core.nth.call(null,inst_19211,(1),null);
var inst_19214 = cljs.core._EQ_.call(null,inst_19213,inst_19205);
var state_19238__$1 = (function (){var statearr_19295 = state_19238;
(statearr_19295[(20)] = inst_19212);

return statearr_19295;
})();
if(inst_19214){
var statearr_19296_19355 = state_19238__$1;
(statearr_19296_19355[(1)] = (39));

} else {
var statearr_19297_19356 = state_19238__$1;
(statearr_19297_19356[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (30))){
var inst_19170 = (state_19238[(11)]);
var inst_19176 = (state_19238[(2)]);
var inst_19177 = cljs.core.nth.call(null,inst_19176,(0),null);
var inst_19178 = cljs.core.nth.call(null,inst_19176,(1),null);
var inst_19179 = cljs.core._EQ_.call(null,inst_19178,inst_19170);
var state_19238__$1 = (function (){var statearr_19298 = state_19238;
(statearr_19298[(21)] = inst_19177);

return statearr_19298;
})();
if(inst_19179){
var statearr_19299_19357 = state_19238__$1;
(statearr_19299_19357[(1)] = (31));

} else {
var statearr_19300_19358 = state_19238__$1;
(statearr_19300_19358[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (10))){
var inst_19116 = (state_19238[(17)]);
var inst_19116__$1 = superv.async._abort.call(null,S);
var inst_19117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19118 = [inst_19116__$1,in_ch];
var inst_19119 = (new cljs.core.PersistentVector(null,2,(5),inst_19117,inst_19118,null));
var state_19238__$1 = (function (){var statearr_19301 = state_19238;
(statearr_19301[(17)] = inst_19116__$1);

return statearr_19301;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19238__$1,(12),inst_19119,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_19239 === (18))){
var inst_19231 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
var statearr_19302_19359 = state_19238__$1;
(statearr_19302_19359[(2)] = inst_19231);

(statearr_19302_19359[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (42))){
var inst_19222 = (state_19238[(2)]);
var state_19238__$1 = state_19238;
var statearr_19303_19360 = state_19238__$1;
(statearr_19303_19360[(2)] = inst_19222);

(statearr_19303_19360[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (37))){
var inst_19228 = (state_19238[(2)]);
var inst_19229 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_19238__$1 = (function (){var statearr_19304 = state_19238;
(statearr_19304[(22)] = inst_19228);

return statearr_19304;
})();
var statearr_19305_19361 = state_19238__$1;
(statearr_19305_19361[(2)] = inst_19229);

(statearr_19305_19361[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19239 === (8))){
var inst_19095 = (state_19238[(7)]);
var inst_19103 = (state_19238[(2)]);
var state_19238__$1 = (function (){var statearr_19306 = state_19238;
(statearr_19306[(23)] = inst_19103);

return statearr_19306;
})();
var statearr_19307_19362 = state_19238__$1;
(statearr_19307_19362[(2)] = inst_19095);

(statearr_19307_19362[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_19308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19308[(0)] = superv$async$state_machine__3282__auto__);

(statearr_19308[(1)] = (1));

return statearr_19308;
});
var superv$async$state_machine__3282__auto____1 = (function (state_19238){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_19238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e19309){var ex__3285__auto__ = e19309;
var statearr_19310_19363 = state_19238;
(statearr_19310_19363[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_19238[(4)]))){
var statearr_19311_19364 = state_19238;
(statearr_19311_19364[(1)] = cljs.core.first.call(null,(state_19238[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19365 = state_19238;
state_19238 = G__19365;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_19238){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_19238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_19312 = f__3356__auto__.call(null);
(statearr_19312[(6)] = c__3355__auto___19318);

return statearr_19312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out_ch__$1;
}));

(superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq19083){
var G__19084 = cljs.core.first.call(null,seq19083);
var seq19083__$1 = cljs.core.next.call(null,seq19083);
var G__19085 = cljs.core.first.call(null,seq19083__$1);
var seq19083__$2 = cljs.core.next.call(null,seq19083__$1);
var G__19086 = cljs.core.first.call(null,seq19083__$2);
var seq19083__$3 = cljs.core.next.call(null,seq19083__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19084,G__19085,G__19086,seq19083__$3);
}));

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__13485__auto___19554 = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto___19555 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__3355__auto___19556 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_19493){
var state_val_19494 = (state_19493[(1)]);
if((state_val_19494 === (7))){
var inst_19371 = (state_19493[(7)]);
var inst_19377 = superv.async._track_exception.call(null,S,inst_19371);
var state_19493__$1 = state_19493;
var statearr_19495_19557 = state_19493__$1;
(statearr_19495_19557[(2)] = inst_19377);

(statearr_19495_19557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (20))){
var inst_19413 = (state_19493[(8)]);
var inst_19424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19425 = superv.async._abort.call(null,S);
var inst_19426 = [inst_19425];
var inst_19427 = (new cljs.core.PersistentVector(null,1,(5),inst_19424,inst_19426,null));
var inst_19428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19429 = [ch,inst_19413];
var inst_19430 = (new cljs.core.PersistentVector(null,2,(5),inst_19428,inst_19429,null));
var inst_19431 = cljs.core.concat.call(null,inst_19427,inst_19430);
var state_19493__$1 = state_19493;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19493__$1,(22),inst_19431);
} else {
if((state_val_19494 === (27))){
var inst_19462 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_19463 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_19464 = cljs.core.PersistentHashMap.fromArrays(inst_19462,inst_19463);
var inst_19465 = cljs.core.ex_info.call(null,"Aborted operations",inst_19464);
var state_19493__$1 = state_19493;
var statearr_19496_19558 = state_19493__$1;
(statearr_19496_19558[(2)] = inst_19465);

(statearr_19496_19558[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (1))){
var state_19493__$1 = state_19493;
var statearr_19497_19559 = state_19493__$1;
(statearr_19497_19559[(2)] = null);

(statearr_19497_19559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (24))){
var inst_19441 = (state_19493[(9)]);
var inst_19445 = (state_19493[(10)]);
var inst_19474 = inst_19445.call(null,inst_19441,inst_19441);
var state_19493__$1 = state_19493;
if(cljs.core.truth_(inst_19474)){
var statearr_19498_19560 = state_19493__$1;
(statearr_19498_19560[(1)] = (31));

} else {
var statearr_19499_19561 = state_19493__$1;
(statearr_19499_19561[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (4))){
var _ = (function (){var statearr_19500 = state_19493;
(statearr_19500[(4)] = cljs.core.rest.call(null,(state_19493[(4)])));

return statearr_19500;
})();
var inst_19367 = (state_19493[(2)]);
var inst_19368 = superv.async._unregister_go.call(null,S,id__13486__auto___19555);
var ___$1 = (function (){var temp__5735__auto__ = (state_19493[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_19493__$1 = (function (){var statearr_19501 = state_19493;
(statearr_19501[(11)] = inst_19368);

return statearr_19501;
})();
var statearr_19502_19562 = state_19493__$1;
(statearr_19502_19562[(2)] = inst_19367);

(statearr_19502_19562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (15))){
var inst_19393 = (state_19493[(12)]);
var inst_19398 = (state_19493[(2)]);
var inst_19399 = cljs.core.nth.call(null,inst_19398,(0),null);
var inst_19400 = cljs.core.nth.call(null,inst_19398,(1),null);
var inst_19401 = cljs.core._EQ_.call(null,inst_19400,inst_19393);
var state_19493__$1 = (function (){var statearr_19503 = state_19493;
(statearr_19503[(13)] = inst_19399);

return statearr_19503;
})();
if(inst_19401){
var statearr_19504_19563 = state_19493__$1;
(statearr_19504_19563[(1)] = (16));

} else {
var statearr_19505_19564 = state_19493__$1;
(statearr_19505_19564[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (21))){
var inst_19486 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19506_19565 = state_19493__$1;
(statearr_19506_19565[(2)] = inst_19486);

(statearr_19506_19565[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (31))){
var inst_19440 = (state_19493[(14)]);
var inst_19386 = inst_19440;
var state_19493__$1 = (function (){var statearr_19507 = state_19493;
(statearr_19507[(15)] = inst_19386);

return statearr_19507;
})();
var statearr_19508_19566 = state_19493__$1;
(statearr_19508_19566[(2)] = null);

(statearr_19508_19566[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (32))){
var inst_19441 = (state_19493[(9)]);
var inst_19478 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19441)].join('');
var inst_19479 = (new Error(inst_19478));
var inst_19480 = (function(){throw inst_19479})();
var state_19493__$1 = state_19493;
var statearr_19509_19567 = state_19493__$1;
(statearr_19509_19567[(2)] = inst_19480);

(statearr_19509_19567[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (33))){
var inst_19482 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19510_19568 = state_19493__$1;
(statearr_19510_19568[(2)] = inst_19482);

(statearr_19510_19568[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (13))){
var inst_19393 = (state_19493[(12)]);
var inst_19393__$1 = superv.async._abort.call(null,S);
var inst_19394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19395 = [inst_19393__$1,ch];
var inst_19396 = (new cljs.core.PersistentVector(null,2,(5),inst_19394,inst_19395,null));
var state_19493__$1 = (function (){var statearr_19511 = state_19493;
(statearr_19511[(12)] = inst_19393__$1);

return statearr_19511;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19493__$1,(15),inst_19396,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_19494 === (22))){
var inst_19441 = (state_19493[(9)]);
var inst_19413 = (state_19493[(8)]);
var inst_19445 = (state_19493[(10)]);
var inst_19433 = (state_19493[(2)]);
var inst_19434 = cljs.core.nth.call(null,inst_19433,(0),null);
var inst_19435 = cljs.core.nth.call(null,inst_19433,(1),null);
var inst_19436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19437 = superv.async.throw_if_exception.call(null,S,inst_19434);
var inst_19438 = [inst_19437,inst_19435];
var inst_19439 = (new cljs.core.PersistentVector(null,2,(5),inst_19436,inst_19438,null));
var inst_19440 = cljs.core.nth.call(null,inst_19439,(0),null);
var inst_19441__$1 = cljs.core.nth.call(null,inst_19439,(1),null);
var inst_19445__$1 = cljs.core._EQ_;
var inst_19446 = inst_19445__$1.call(null,inst_19413,inst_19441__$1);
var state_19493__$1 = (function (){var statearr_19512 = state_19493;
(statearr_19512[(14)] = inst_19440);

(statearr_19512[(9)] = inst_19441__$1);

(statearr_19512[(10)] = inst_19445__$1);

return statearr_19512;
})();
if(cljs.core.truth_(inst_19446)){
var statearr_19513_19569 = state_19493__$1;
(statearr_19513_19569[(1)] = (23));

} else {
var statearr_19514_19570 = state_19493__$1;
(statearr_19514_19570[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (29))){
var inst_19470 = (state_19493[(2)]);
var inst_19471 = superv.async.throw_if_exception.call(null,S,inst_19470);
var inst_19386 = null;
var state_19493__$1 = (function (){var statearr_19515 = state_19493;
(statearr_19515[(15)] = inst_19386);

(statearr_19515[(16)] = inst_19471);

return statearr_19515;
})();
var statearr_19516_19571 = state_19493__$1;
(statearr_19516_19571[(2)] = null);

(statearr_19516_19571[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (6))){
var state_19493__$1 = state_19493;
var statearr_19517_19572 = state_19493__$1;
(statearr_19517_19572[(2)] = null);

(statearr_19517_19572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (28))){
var inst_19412 = (state_19493[(17)]);
var state_19493__$1 = state_19493;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19493__$1,(30),out,inst_19412);
} else {
if((state_val_19494 === (25))){
var inst_19484 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19518_19573 = state_19493__$1;
(statearr_19518_19573[(2)] = inst_19484);

(statearr_19518_19573[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (17))){
var inst_19399 = (state_19493[(13)]);
var state_19493__$1 = state_19493;
var statearr_19519_19574 = state_19493__$1;
(statearr_19519_19574[(2)] = inst_19399);

(statearr_19519_19574[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (3))){
var inst_19491 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19493__$1,inst_19491);
} else {
if((state_val_19494 === (12))){
var inst_19386 = (state_19493[(15)]);
var state_19493__$1 = state_19493;
var statearr_19520_19575 = state_19493__$1;
(statearr_19520_19575[(2)] = inst_19386);

(statearr_19520_19575[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (2))){
var _ = (function (){var statearr_19521 = state_19493;
(statearr_19521[(4)] = cljs.core.cons.call(null,(4),(state_19493[(4)])));

return statearr_19521;
})();
var ___$1 = (function (){var statearr_19522 = state_19493;
(statearr_19522[(4)] = cljs.core.cons.call(null,(9),(state_19493[(4)])));

return statearr_19522;
})();
var inst_19386 = null;
var state_19493__$1 = (function (){var statearr_19523 = state_19493;
(statearr_19523[(15)] = inst_19386);

return statearr_19523;
})();
var statearr_19524_19576 = state_19493__$1;
(statearr_19524_19576[(2)] = null);

(statearr_19524_19576[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (23))){
var inst_19451 = (state_19493[(18)]);
var inst_19451__$1 = superv.async._abort.call(null,S);
var inst_19452 = cljs.core.async.timeout.call(null,(0));
var inst_19453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19454 = [inst_19451__$1,inst_19452];
var inst_19455 = (new cljs.core.PersistentVector(null,2,(5),inst_19453,inst_19454,null));
var state_19493__$1 = (function (){var statearr_19525 = state_19493;
(statearr_19525[(18)] = inst_19451__$1);

return statearr_19525;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19493__$1,(26),inst_19455,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19494 === (19))){
var inst_19416 = cljs.core.async.close_BANG_.call(null,out);
var state_19493__$1 = state_19493;
var statearr_19527_19577 = state_19493__$1;
(statearr_19527_19577[(2)] = inst_19416);

(statearr_19527_19577[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (11))){
var inst_19488 = (state_19493[(2)]);
var _ = (function (){var statearr_19528 = state_19493;
(statearr_19528[(4)] = cljs.core.rest.call(null,(state_19493[(4)])));

return statearr_19528;
})();
var state_19493__$1 = state_19493;
var statearr_19529_19578 = state_19493__$1;
(statearr_19529_19578[(2)] = inst_19488);

(statearr_19529_19578[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (9))){
var _ = (function (){var statearr_19530 = state_19493;
(statearr_19530[(4)] = cljs.core.rest.call(null,(state_19493[(4)])));

return statearr_19530;
})();
var state_19493__$1 = state_19493;
var ex19526 = (state_19493__$1[(2)]);
var statearr_19531_19579 = state_19493__$1;
(statearr_19531_19579[(5)] = ex19526);


if((ex19526 instanceof Error)){
var statearr_19532_19580 = state_19493__$1;
(statearr_19532_19580[(1)] = (5));

(statearr_19532_19580[(5)] = null);

} else {
throw ex19526;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (5))){
var inst_19371 = (state_19493[(7)]);
var inst_19371__$1 = (state_19493[(2)]);
var inst_19372 = cljs.core.ex_data.call(null,inst_19371__$1);
var inst_19373 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19372);
var inst_19374 = cljs.core._EQ_.call(null,inst_19373,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_19493__$1 = (function (){var statearr_19533 = state_19493;
(statearr_19533[(7)] = inst_19371__$1);

return statearr_19533;
})();
if(inst_19374){
var statearr_19534_19581 = state_19493__$1;
(statearr_19534_19581[(1)] = (6));

} else {
var statearr_19535_19582 = state_19493__$1;
(statearr_19535_19582[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (14))){
var inst_19412 = (state_19493[(17)]);
var inst_19412__$1 = (state_19493[(2)]);
var inst_19413 = cljs.core.async.timeout.call(null,interval);
var inst_19414 = (inst_19412__$1 == null);
var state_19493__$1 = (function (){var statearr_19536 = state_19493;
(statearr_19536[(8)] = inst_19413);

(statearr_19536[(17)] = inst_19412__$1);

return statearr_19536;
})();
if(cljs.core.truth_(inst_19414)){
var statearr_19537_19583 = state_19493__$1;
(statearr_19537_19583[(1)] = (19));

} else {
var statearr_19538_19584 = state_19493__$1;
(statearr_19538_19584[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (26))){
var inst_19451 = (state_19493[(18)]);
var inst_19457 = (state_19493[(2)]);
var inst_19458 = cljs.core.nth.call(null,inst_19457,(0),null);
var inst_19459 = cljs.core.nth.call(null,inst_19457,(1),null);
var inst_19460 = cljs.core._EQ_.call(null,inst_19459,inst_19451);
var state_19493__$1 = (function (){var statearr_19539 = state_19493;
(statearr_19539[(19)] = inst_19458);

return statearr_19539;
})();
if(inst_19460){
var statearr_19540_19585 = state_19493__$1;
(statearr_19540_19585[(1)] = (27));

} else {
var statearr_19541_19586 = state_19493__$1;
(statearr_19541_19586[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (16))){
var inst_19403 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_19404 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_19405 = cljs.core.PersistentHashMap.fromArrays(inst_19403,inst_19404);
var inst_19406 = cljs.core.ex_info.call(null,"Aborted operations",inst_19405);
var state_19493__$1 = state_19493;
var statearr_19542_19587 = state_19493__$1;
(statearr_19542_19587[(2)] = inst_19406);

(statearr_19542_19587[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (30))){
var inst_19468 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19543_19588 = state_19493__$1;
(statearr_19543_19588[(2)] = inst_19468);

(statearr_19543_19588[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (10))){
var inst_19386 = (state_19493[(15)]);
var state_19493__$1 = state_19493;
if(cljs.core.truth_(inst_19386)){
var statearr_19544_19589 = state_19493__$1;
(statearr_19544_19589[(1)] = (12));

} else {
var statearr_19545_19590 = state_19493__$1;
(statearr_19545_19590[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (18))){
var inst_19409 = (state_19493[(2)]);
var inst_19410 = superv.async.throw_if_exception.call(null,S,inst_19409);
var state_19493__$1 = state_19493;
var statearr_19546_19591 = state_19493__$1;
(statearr_19546_19591[(2)] = inst_19410);

(statearr_19546_19591[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (8))){
var inst_19371 = (state_19493[(7)]);
var inst_19379 = (state_19493[(2)]);
var state_19493__$1 = (function (){var statearr_19547 = state_19493;
(statearr_19547[(20)] = inst_19379);

return statearr_19547;
})();
var statearr_19548_19592 = state_19493__$1;
(statearr_19548_19592[(2)] = inst_19371);

(statearr_19548_19592[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__3282__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__3282__auto____0 = (function (){
var statearr_19549 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19549[(0)] = superv$async$debounce_GT__GT__$_state_machine__3282__auto__);

(statearr_19549[(1)] = (1));

return statearr_19549;
});
var superv$async$debounce_GT__GT__$_state_machine__3282__auto____1 = (function (state_19493){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_19493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e19550){var ex__3285__auto__ = e19550;
var statearr_19551_19593 = state_19493;
(statearr_19551_19593[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_19493[(4)]))){
var statearr_19552_19594 = state_19493;
(statearr_19552_19594[(1)] = cljs.core.first.call(null,(state_19493[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19595 = state_19493;
state_19493 = G__19595;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__3282__auto__ = function(state_19493){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__3282__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__3282__auto____1.call(this,state_19493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$debounce_GT__GT__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__3282__auto____0;
superv$async$debounce_GT__GT__$_state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__3282__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_19553 = f__3356__auto__.call(null);
(statearr_19553[(6)] = c__3355__auto___19556);

return statearr_19553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var G__19597 = arguments.length;
switch (G__19597) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
}));

(superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__13485__auto___19760 = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto___19761 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__3355__auto___19762 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_19688){
var state_val_19689 = (state_19688[(1)]);
if((state_val_19689 === (7))){
var inst_19603 = (state_19688[(7)]);
var inst_19609 = superv.async._track_exception.call(null,S,inst_19603);
var state_19688__$1 = state_19688;
var statearr_19690_19763 = state_19688__$1;
(statearr_19690_19763[(2)] = inst_19609);

(statearr_19690_19763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (1))){
var state_19688__$1 = state_19688;
var statearr_19691_19764 = state_19688__$1;
(statearr_19691_19764[(2)] = null);

(statearr_19691_19764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (4))){
var _ = (function (){var statearr_19692 = state_19688;
(statearr_19692[(4)] = cljs.core.rest.call(null,(state_19688[(4)])));

return statearr_19692;
})();
var inst_19599 = (state_19688[(2)]);
var inst_19600 = superv.async._unregister_go.call(null,S,id__13486__auto___19761);
var ___$1 = (function (){var temp__5735__auto__ = (state_19688[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_19688__$1 = (function (){var statearr_19693 = state_19688;
(statearr_19693[(8)] = inst_19600);

return statearr_19693;
})();
var statearr_19694_19765 = state_19688__$1;
(statearr_19694_19765[(2)] = inst_19599);

(statearr_19694_19765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (15))){
var state_19688__$1 = state_19688;
var statearr_19695_19766 = state_19688__$1;
(statearr_19695_19766[(2)] = null);

(statearr_19695_19766[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (13))){
var inst_19625 = (state_19688[(2)]);
var state_19688__$1 = state_19688;
if(cljs.core.truth_(inst_19625)){
var statearr_19696_19767 = state_19688__$1;
(statearr_19696_19767[(1)] = (14));

} else {
var statearr_19697_19768 = state_19688__$1;
(statearr_19697_19768[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (6))){
var state_19688__$1 = state_19688;
var statearr_19698_19769 = state_19688__$1;
(statearr_19698_19769[(2)] = null);

(statearr_19698_19769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (3))){
var inst_19686 = (state_19688[(2)]);
var state_19688__$1 = state_19688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19688__$1,inst_19686);
} else {
if((state_val_19689 === (12))){
var inst_19622 = (state_19688[(9)]);
var inst_19632 = (state_19688[(2)]);
var inst_19633 = null;
var inst_19634 = superv.async._register_go.call(null,inst_19632,inst_19633);
var inst_19681 = cljs.core.async.chan.call(null,(1));
var inst_19682 = (function (){var c__13485__auto____$1 = inst_19622;
var id__13486__auto____$1 = inst_19634;
var c__3355__auto____$1 = inst_19681;
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_19679){
var state_val_19680 = (state_19679[(1)]);
if((state_val_19680 === (7))){
var inst_19639 = (state_19679[(2)]);
var state_19679__$1 = state_19679;
if(cljs.core.truth_(inst_19639)){
var statearr_19699_19770 = state_19679__$1;
(statearr_19699_19770[(1)] = (8));

} else {
var statearr_19700_19771 = state_19679__$1;
(statearr_19700_19771[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (20))){
var inst_19663 = (state_19679[(2)]);
var state_19679__$1 = state_19679;
var statearr_19701_19772 = state_19679__$1;
(statearr_19701_19772[(2)] = inst_19663);

(statearr_19701_19772[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (1))){
var state_19679__$1 = state_19679;
var statearr_19702_19773 = state_19679__$1;
(statearr_19702_19773[(2)] = null);

(statearr_19702_19773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (4))){
var _ = (function (){var statearr_19704 = state_19679;
(statearr_19704[(4)] = cljs.core.rest.call(null,(state_19679[(4)])));

return statearr_19704;
})();
var inst_19636 = (state_19679[(2)]);
var state_19679__$1 = (function (){var statearr_19705 = state_19679;
(statearr_19705[(7)] = inst_19636);

return statearr_19705;
})();
var statearr_19706_19774 = state_19679__$1;
(statearr_19706_19774[(2)] = null);

(statearr_19706_19774[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (15))){
var state_19679__$1 = state_19679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19679__$1,(17),ch);
} else {
if((state_val_19680 === (21))){
var _ = (function (){var statearr_19707 = state_19679;
(statearr_19707[(4)] = cljs.core.rest.call(null,(state_19679[(4)])));

return statearr_19707;
})();
var state_19679__$1 = state_19679;
var ex19703 = (state_19679__$1[(2)]);
var statearr_19708_19775 = state_19679__$1;
(statearr_19708_19775[(5)] = ex19703);


if((ex19703 instanceof Error)){
var statearr_19709_19776 = state_19679__$1;
(statearr_19709_19776[(1)] = (11));

(statearr_19709_19776[(5)] = null);

} else {
throw ex19703;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (13))){
var state_19679__$1 = state_19679;
var statearr_19710_19777 = state_19679__$1;
(statearr_19710_19777[(2)] = null);

(statearr_19710_19777[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (6))){
var inst_19636 = (state_19679[(7)]);
var inst_19646 = (state_19679[(2)]);
var inst_19647 = superv.async._unregister_go.call(null,inst_19646,id__13486__auto____$1);
var _ = (function (){var temp__5735__auto__ = (state_19679[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_19679__$1 = (function (){var statearr_19711 = state_19679;
(statearr_19711[(8)] = inst_19647);

return statearr_19711;
})();
var statearr_19712_19778 = state_19679__$1;
(statearr_19712_19778[(2)] = inst_19636);

(statearr_19712_19778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (17))){
var inst_19658 = (state_19679[(2)]);
var state_19679__$1 = state_19679;
if(cljs.core.truth_(inst_19658)){
var statearr_19713_19779 = state_19679__$1;
(statearr_19713_19779[(1)] = (18));

} else {
var statearr_19714_19780 = state_19679__$1;
(statearr_19714_19780[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (3))){
var inst_19677 = (state_19679[(2)]);
var state_19679__$1 = state_19679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19679__$1,inst_19677);
} else {
if((state_val_19680 === (12))){
var state_19679__$1 = state_19679;
var statearr_19715_19781 = state_19679__$1;
(statearr_19715_19781[(2)] = null);

(statearr_19715_19781[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (2))){
var _ = (function (){var statearr_19716 = state_19679;
(statearr_19716[(4)] = cljs.core.cons.call(null,(4),(state_19679[(4)])));

return statearr_19716;
})();
var ___$1 = (function (){var statearr_19717 = state_19679;
(statearr_19717[(4)] = cljs.core.cons.call(null,(21),(state_19679[(4)])));

return statearr_19717;
})();
var ___$2 = (function (){var statearr_19718 = state_19679;
(statearr_19718[(4)] = cljs.core.rest.call(null,(state_19679[(4)])));

return statearr_19718;
})();
var state_19679__$1 = state_19679;
var statearr_19719_19782 = state_19679__$1;
(statearr_19719_19782[(2)] = null);

(statearr_19719_19782[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (19))){
var state_19679__$1 = state_19679;
var statearr_19720_19783 = state_19679__$1;
(statearr_19720_19783[(2)] = null);

(statearr_19720_19783[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (11))){
var inst_19650 = (state_19679[(9)]);
var inst_19650__$1 = (state_19679[(2)]);
var inst_19651 = cljs.core.ex_data.call(null,inst_19650__$1);
var inst_19652 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19651);
var inst_19653 = cljs.core._EQ_.call(null,inst_19652,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_19679__$1 = (function (){var statearr_19721 = state_19679;
(statearr_19721[(9)] = inst_19650__$1);

return statearr_19721;
})();
if(inst_19653){
var statearr_19722_19784 = state_19679__$1;
(statearr_19722_19784[(1)] = (12));

} else {
var statearr_19723_19785 = state_19679__$1;
(statearr_19723_19785[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (9))){
var state_19679__$1 = state_19679;
var statearr_19724_19786 = state_19679__$1;
(statearr_19724_19786[(2)] = null);

(statearr_19724_19786[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (5))){
var state_19679__$1 = state_19679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19679__$1,(7),ch);
} else {
if((state_val_19680 === (14))){
var inst_19650 = (state_19679[(9)]);
var inst_19668 = (state_19679[(2)]);
var state_19679__$1 = (function (){var statearr_19725 = state_19679;
(statearr_19725[(10)] = inst_19668);

return statearr_19725;
})();
var statearr_19726_19787 = state_19679__$1;
(statearr_19726_19787[(2)] = inst_19650);

(statearr_19726_19787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (16))){
var inst_19650 = (state_19679[(9)]);
var inst_19665 = (state_19679[(2)]);
var inst_19666 = superv.async._track_exception.call(null,inst_19665,inst_19650);
var state_19679__$1 = state_19679;
var statearr_19727_19788 = state_19679__$1;
(statearr_19727_19788[(2)] = inst_19666);

(statearr_19727_19788[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (10))){
var inst_19644 = (state_19679[(2)]);
var state_19679__$1 = state_19679;
var statearr_19728_19789 = state_19679__$1;
(statearr_19728_19789[(2)] = inst_19644);

(statearr_19728_19789[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (18))){
var state_19679__$1 = state_19679;
var statearr_19729_19790 = state_19679__$1;
(statearr_19729_19790[(2)] = null);

(statearr_19729_19790[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19680 === (8))){
var state_19679__$1 = state_19679;
var statearr_19730_19791 = state_19679__$1;
(statearr_19730_19791[(2)] = null);

(statearr_19730_19791[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_19731 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19731[(0)] = superv$async$state_machine__3282__auto__);

(statearr_19731[(1)] = (1));

return statearr_19731;
});
var superv$async$state_machine__3282__auto____1 = (function (state_19679){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_19679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e19732){var ex__3285__auto__ = e19732;
var statearr_19733_19792 = state_19679;
(statearr_19733_19792[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_19679[(4)]))){
var statearr_19734_19793 = state_19679;
(statearr_19734_19793[(1)] = cljs.core.first.call(null,(state_19679[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19794 = state_19679;
state_19679 = G__19794;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_19679){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_19679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_19735 = f__3356__auto__.call(null);
(statearr_19735[(6)] = c__3355__auto____$1);

return statearr_19735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});
})();
var inst_19683 = cljs.core.async.impl.dispatch.run.call(null,inst_19682);
var _ = (function (){var statearr_19736 = state_19688;
(statearr_19736[(4)] = cljs.core.rest.call(null,(state_19688[(4)])));

return statearr_19736;
})();
var state_19688__$1 = (function (){var statearr_19737 = state_19688;
(statearr_19737[(10)] = inst_19683);

return statearr_19737;
})();
var statearr_19738_19795 = state_19688__$1;
(statearr_19738_19795[(2)] = inst_19681);

(statearr_19738_19795[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (2))){
var _ = (function (){var statearr_19740 = state_19688;
(statearr_19740[(4)] = cljs.core.cons.call(null,(4),(state_19688[(4)])));

return statearr_19740;
})();
var ___$1 = (function (){var statearr_19741 = state_19688;
(statearr_19741[(4)] = cljs.core.cons.call(null,(9),(state_19688[(4)])));

return statearr_19741;
})();
var inst_19618 = superv.async._abort.call(null,S);
var state_19688__$1 = state_19688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19688__$1,(10),inst_19618);
} else {
if((state_val_19689 === (11))){
var state_19688__$1 = state_19688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19688__$1,(13),ch);
} else {
if((state_val_19689 === (9))){
var _ = (function (){var statearr_19742 = state_19688;
(statearr_19742[(4)] = cljs.core.rest.call(null,(state_19688[(4)])));

return statearr_19742;
})();
var state_19688__$1 = state_19688;
var ex19739 = (state_19688__$1[(2)]);
var statearr_19743_19796 = state_19688__$1;
(statearr_19743_19796[(5)] = ex19739);


if((ex19739 instanceof Error)){
var statearr_19744_19797 = state_19688__$1;
(statearr_19744_19797[(1)] = (5));

(statearr_19744_19797[(5)] = null);

} else {
throw ex19739;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (5))){
var inst_19603 = (state_19688[(7)]);
var inst_19603__$1 = (state_19688[(2)]);
var inst_19604 = cljs.core.ex_data.call(null,inst_19603__$1);
var inst_19605 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19604);
var inst_19606 = cljs.core._EQ_.call(null,inst_19605,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_19688__$1 = (function (){var statearr_19745 = state_19688;
(statearr_19745[(7)] = inst_19603__$1);

return statearr_19745;
})();
if(inst_19606){
var statearr_19746_19798 = state_19688__$1;
(statearr_19746_19798[(1)] = (6));

} else {
var statearr_19747_19799 = state_19688__$1;
(statearr_19747_19799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (14))){
var state_19688__$1 = state_19688;
var statearr_19748_19800 = state_19688__$1;
(statearr_19748_19800[(2)] = null);

(statearr_19748_19800[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (16))){
var inst_19630 = (state_19688[(2)]);
var state_19688__$1 = state_19688;
var statearr_19749_19801 = state_19688__$1;
(statearr_19749_19801[(2)] = inst_19630);

(statearr_19749_19801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (10))){
var inst_19620 = (state_19688[(2)]);
var inst_19621 = cljs.core.async.close_BANG_.call(null,ch);
var inst_19622 = superv.async.check_supervisor.call(null,superv.async.S);
var state_19688__$1 = (function (){var statearr_19750 = state_19688;
(statearr_19750[(11)] = inst_19621);

(statearr_19750[(12)] = inst_19620);

(statearr_19750[(9)] = inst_19622);

return statearr_19750;
})();
var statearr_19751_19802 = state_19688__$1;
(statearr_19751_19802[(2)] = null);

(statearr_19751_19802[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19689 === (8))){
var inst_19603 = (state_19688[(7)]);
var inst_19611 = (state_19688[(2)]);
var state_19688__$1 = (function (){var statearr_19752 = state_19688;
(statearr_19752[(13)] = inst_19611);

return statearr_19752;
})();
var statearr_19753_19803 = state_19688__$1;
(statearr_19753_19803[(2)] = inst_19603);

(statearr_19753_19803[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_19754 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19754[(0)] = superv$async$state_machine__3282__auto__);

(statearr_19754[(1)] = (1));

return statearr_19754;
});
var superv$async$state_machine__3282__auto____1 = (function (state_19688){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_19688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e19755){var ex__3285__auto__ = e19755;
var statearr_19756_19804 = state_19688;
(statearr_19756_19804[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_19688[(4)]))){
var statearr_19757_19805 = state_19688;
(statearr_19757_19805[(1)] = cljs.core.first.call(null,(state_19688[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19806 = state_19688;
state_19688 = G__19806;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_19688){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_19688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_19758 = f__3356__auto__.call(null);
(statearr_19758[(6)] = c__3355__auto___19762);

return statearr_19758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
}));

(superv.async.tap.cljs$lang$maxFixedArity = 4);

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var G__19808 = arguments.length;
switch (G__19808) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
}));

(superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__13485__auto___19937 = superv.async.check_supervisor.call(null,superv.async.S);
var id__13486__auto___19938 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__3355__auto___19939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_19879){
var state_val_19880 = (state_19879[(1)]);
if((state_val_19880 === (7))){
var inst_19814 = (state_19879[(7)]);
var inst_19820 = superv.async._track_exception.call(null,S,inst_19814);
var state_19879__$1 = state_19879;
var statearr_19881_19940 = state_19879__$1;
(statearr_19881_19940[(2)] = inst_19820);

(statearr_19881_19940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19880 === (1))){
var state_19879__$1 = state_19879;
var statearr_19882_19941 = state_19879__$1;
(statearr_19882_19941[(2)] = null);

(statearr_19882_19941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19880 === (4))){
var _ = (function (){var statearr_19883 = state_19879;
(statearr_19883[(4)] = cljs.core.rest.call(null,(state_19879[(4)])));

return statearr_19883;
})();
var inst_19810 = (state_19879[(2)]);
var inst_19811 = superv.async._unregister_go.call(null,S,id__13486__auto___19938);
var ___$1 = (function (){var temp__5735__auto__ = (state_19879[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_19879__$1 = (function (){var statearr_19884 = state_19879;
(statearr_19884[(8)] = inst_19811);

return statearr_19884;
})();
var statearr_19885_19942 = state_19879__$1;
(statearr_19885_19942[(2)] = inst_19810);

(statearr_19885_19942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19880 === (6))){
var state_19879__$1 = state_19879;
var statearr_19886_19943 = state_19879__$1;
(statearr_19886_19943[(2)] = null);

(statearr_19886_19943[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19880 === (3))){
var inst_19877 = (state_19879[(2)]);
var state_19879__$1 = state_19879;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19879__$1,inst_19877);
} else {
if((state_val_19880 === (2))){
var _ = (function (){var statearr_19888 = state_19879;
(statearr_19888[(4)] = cljs.core.cons.call(null,(4),(state_19879[(4)])));

return statearr_19888;
})();
var ___$1 = (function (){var statearr_19889 = state_19879;
(statearr_19889[(4)] = cljs.core.cons.call(null,(9),(state_19879[(4)])));

return statearr_19889;
})();
var inst_19829 = superv.async._abort.call(null,S);
var state_19879__$1 = state_19879;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19879__$1,(10),inst_19829);
} else {
if((state_val_19880 === (9))){
var _ = (function (){var statearr_19890 = state_19879;
(statearr_19890[(4)] = cljs.core.rest.call(null,(state_19879[(4)])));

return statearr_19890;
})();
var state_19879__$1 = state_19879;
var ex19887 = (state_19879__$1[(2)]);
var statearr_19891_19944 = state_19879__$1;
(statearr_19891_19944[(5)] = ex19887);


if((ex19887 instanceof Error)){
var statearr_19892_19945 = state_19879__$1;
(statearr_19892_19945[(1)] = (5));

(statearr_19892_19945[(5)] = null);

} else {
throw ex19887;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19880 === (5))){
var inst_19814 = (state_19879[(7)]);
var inst_19814__$1 = (state_19879[(2)]);
var inst_19815 = cljs.core.ex_data.call(null,inst_19814__$1);
var inst_19816 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19815);
var inst_19817 = cljs.core._EQ_.call(null,inst_19816,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_19879__$1 = (function (){var statearr_19893 = state_19879;
(statearr_19893[(7)] = inst_19814__$1);

return statearr_19893;
})();
if(inst_19817){
var statearr_19894_19946 = state_19879__$1;
(statearr_19894_19946[(1)] = (6));

} else {
var statearr_19895_19947 = state_19879__$1;
(statearr_19895_19947[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19880 === (10))){
var inst_19831 = (state_19879[(2)]);
var inst_19832 = cljs.core.async.close_BANG_.call(null,ch);
var inst_19833 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_19834 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_19835 = superv.async._register_go.call(null,S,inst_19834);
var inst_19872 = cljs.core.async.chan.call(null,(1));
var inst_19873 = (function (){var c__13485__auto____$1 = inst_19833;
var id__13486__auto____$1 = inst_19835;
var c__3355__auto____$1 = inst_19872;
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_19870){
var state_val_19871 = (state_19870[(1)]);
if((state_val_19871 === (7))){
var inst_19841 = (state_19870[(7)]);
var inst_19847 = superv.async._track_exception.call(null,S,inst_19841);
var state_19870__$1 = state_19870;
var statearr_19896_19948 = state_19870__$1;
(statearr_19896_19948[(2)] = inst_19847);

(statearr_19896_19948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (1))){
var state_19870__$1 = state_19870;
var statearr_19897_19949 = state_19870__$1;
(statearr_19897_19949[(2)] = null);

(statearr_19897_19949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (4))){
var _ = (function (){var statearr_19898 = state_19870;
(statearr_19898[(4)] = cljs.core.rest.call(null,(state_19870[(4)])));

return statearr_19898;
})();
var inst_19837 = (state_19870[(2)]);
var inst_19838 = superv.async._unregister_go.call(null,S,id__13486__auto____$1);
var ___$1 = (function (){var temp__5735__auto__ = (state_19870[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_19870__$1 = (function (){var statearr_19899 = state_19870;
(statearr_19899[(8)] = inst_19838);

return statearr_19899;
})();
var statearr_19900_19950 = state_19870__$1;
(statearr_19900_19950[(2)] = inst_19837);

(statearr_19900_19950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (15))){
var inst_19863 = (state_19870[(2)]);
var state_19870__$1 = state_19870;
var statearr_19901_19951 = state_19870__$1;
(statearr_19901_19951[(2)] = inst_19863);

(statearr_19901_19951[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (13))){
var state_19870__$1 = state_19870;
var statearr_19902_19952 = state_19870__$1;
(statearr_19902_19952[(2)] = null);

(statearr_19902_19952[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (6))){
var state_19870__$1 = state_19870;
var statearr_19903_19953 = state_19870__$1;
(statearr_19903_19953[(2)] = null);

(statearr_19903_19953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (3))){
var inst_19868 = (state_19870[(2)]);
var state_19870__$1 = state_19870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19870__$1,inst_19868);
} else {
if((state_val_19871 === (12))){
var inst_19858 = (state_19870[(2)]);
var state_19870__$1 = state_19870;
if(cljs.core.truth_(inst_19858)){
var statearr_19904_19954 = state_19870__$1;
(statearr_19904_19954[(1)] = (13));

} else {
var statearr_19905_19955 = state_19870__$1;
(statearr_19905_19955[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (2))){
var _ = (function (){var statearr_19907 = state_19870;
(statearr_19907[(4)] = cljs.core.cons.call(null,(4),(state_19870[(4)])));

return statearr_19907;
})();
var ___$1 = (function (){var statearr_19908 = state_19870;
(statearr_19908[(4)] = cljs.core.cons.call(null,(9),(state_19870[(4)])));

return statearr_19908;
})();
var state_19870__$1 = state_19870;
var statearr_19909_19956 = state_19870__$1;
(statearr_19909_19956[(2)] = null);

(statearr_19909_19956[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (11))){
var inst_19865 = (state_19870[(2)]);
var _ = (function (){var statearr_19910 = state_19870;
(statearr_19910[(4)] = cljs.core.rest.call(null,(state_19870[(4)])));

return statearr_19910;
})();
var state_19870__$1 = state_19870;
var statearr_19911_19957 = state_19870__$1;
(statearr_19911_19957[(2)] = inst_19865);

(statearr_19911_19957[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (9))){
var _ = (function (){var statearr_19912 = state_19870;
(statearr_19912[(4)] = cljs.core.rest.call(null,(state_19870[(4)])));

return statearr_19912;
})();
var state_19870__$1 = state_19870;
var ex19906 = (state_19870__$1[(2)]);
var statearr_19913_19958 = state_19870__$1;
(statearr_19913_19958[(5)] = ex19906);


if((ex19906 instanceof Error)){
var statearr_19914_19959 = state_19870__$1;
(statearr_19914_19959[(1)] = (5));

(statearr_19914_19959[(5)] = null);

} else {
throw ex19906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (5))){
var inst_19841 = (state_19870[(7)]);
var inst_19841__$1 = (state_19870[(2)]);
var inst_19842 = cljs.core.ex_data.call(null,inst_19841__$1);
var inst_19843 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19842);
var inst_19844 = cljs.core._EQ_.call(null,inst_19843,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_19870__$1 = (function (){var statearr_19915 = state_19870;
(statearr_19915[(7)] = inst_19841__$1);

return statearr_19915;
})();
if(inst_19844){
var statearr_19916_19960 = state_19870__$1;
(statearr_19916_19960[(1)] = (6));

} else {
var statearr_19917_19961 = state_19870__$1;
(statearr_19917_19961[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (14))){
var state_19870__$1 = state_19870;
var statearr_19918_19962 = state_19870__$1;
(statearr_19918_19962[(2)] = null);

(statearr_19918_19962[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19871 === (10))){
var state_19870__$1 = state_19870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19870__$1,(12),ch);
} else {
if((state_val_19871 === (8))){
var inst_19841 = (state_19870[(7)]);
var inst_19849 = (state_19870[(2)]);
var state_19870__$1 = (function (){var statearr_19919 = state_19870;
(statearr_19919[(9)] = inst_19849);

return statearr_19919;
})();
var statearr_19920_19963 = state_19870__$1;
(statearr_19920_19963[(2)] = inst_19841);

(statearr_19920_19963[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_19921 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19921[(0)] = superv$async$state_machine__3282__auto__);

(statearr_19921[(1)] = (1));

return statearr_19921;
});
var superv$async$state_machine__3282__auto____1 = (function (state_19870){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_19870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e19922){var ex__3285__auto__ = e19922;
var statearr_19923_19964 = state_19870;
(statearr_19923_19964[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_19870[(4)]))){
var statearr_19924_19965 = state_19870;
(statearr_19924_19965[(1)] = cljs.core.first.call(null,(state_19870[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19966 = state_19870;
state_19870 = G__19966;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_19870){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_19870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_19925 = f__3356__auto__.call(null);
(statearr_19925[(6)] = c__3355__auto____$1);

return statearr_19925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});
})();
var inst_19874 = cljs.core.async.impl.dispatch.run.call(null,inst_19873);
var _ = (function (){var statearr_19926 = state_19879;
(statearr_19926[(4)] = cljs.core.rest.call(null,(state_19879[(4)])));

return statearr_19926;
})();
var state_19879__$1 = (function (){var statearr_19927 = state_19879;
(statearr_19927[(9)] = inst_19831);

(statearr_19927[(10)] = inst_19832);

(statearr_19927[(11)] = inst_19874);

return statearr_19927;
})();
var statearr_19928_19967 = state_19879__$1;
(statearr_19928_19967[(2)] = inst_19872);

(statearr_19928_19967[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19880 === (8))){
var inst_19814 = (state_19879[(7)]);
var inst_19822 = (state_19879[(2)]);
var state_19879__$1 = (function (){var statearr_19929 = state_19879;
(statearr_19929[(12)] = inst_19822);

return statearr_19929;
})();
var statearr_19930_19968 = state_19879__$1;
(statearr_19930_19968[(2)] = inst_19814);

(statearr_19930_19968[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_19931 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19931[(0)] = superv$async$state_machine__3282__auto__);

(statearr_19931[(1)] = (1));

return statearr_19931;
});
var superv$async$state_machine__3282__auto____1 = (function (state_19879){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_19879);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e19932){var ex__3285__auto__ = e19932;
var statearr_19933_19969 = state_19879;
(statearr_19933_19969[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_19879[(4)]))){
var statearr_19934_19970 = state_19879;
(statearr_19934_19970[(1)] = cljs.core.first.call(null,(state_19879[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19971 = state_19879;
state_19879 = G__19971;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_19879){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_19879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_19935 = f__3356__auto__.call(null);
(statearr_19935[(6)] = c__3355__auto___19939);

return statearr_19935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
}));

(superv.async.sub.cljs$lang$maxFixedArity = 5);

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__4742__auto__ = [];
var len__4736__auto___20415 = arguments.length;
var i__4737__auto___20416 = (0);
while(true){
if((i__4737__auto___20416 < len__4736__auto___20415)){
args__4742__auto__.push((arguments[i__4737__auto___20416]));

var G__20417 = (i__4737__auto___20416 + (1));
i__4737__auto___20416 = G__20417;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__19986){
var map__19987 = p__19986;
var map__19987__$1 = (((((!((map__19987 == null))))?(((((map__19987.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19987.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19987):map__19987);
var retries = cljs.core.get.call(null,map__19987__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__19987__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__19987__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__19987__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__19987__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__19987__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),(function (level,msg){
return cljs.core.println.call(null,level,msg);
}));
var supervisor = cljs.core.get.call(null,map__19987__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__4126__auto__ = retries;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__3355__auto___20418 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_20270){
var state_val_20271 = (state_20270[(1)]);
if((state_val_20271 === (7))){
var inst_19996 = (state_20270[(7)]);
var inst_20171 = (state_20270[(2)]);
var inst_20172 = cljs.core.nth.call(null,inst_20171,(0),null);
var inst_20173 = cljs.core.nth.call(null,inst_20171,(1),null);
var inst_20174 = cljs.core._EQ_.call(null,inst_20173,inst_19996);
var inst_20175 = (!(inst_20174));
var state_20270__$1 = (function (){var statearr_20272 = state_20270;
(statearr_20272[(8)] = inst_20172);

return statearr_20272;
})();
if(inst_20175){
var statearr_20273_20419 = state_20270__$1;
(statearr_20273_20419[(1)] = (8));

} else {
var statearr_20274_20420 = state_20270__$1;
(statearr_20274_20420[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (20))){
var inst_20197 = (state_20270[(9)]);
var inst_20206 = cljs.core.first.call(null,inst_20197);
var inst_20207 = cljs.core.async.put_BANG_.call(null,inst_20206,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_20208 = cljs.core.async.close_BANG_.call(null,inst_20206);
var inst_20209 = cljs.core.next.call(null,inst_20197);
var inst_20183 = inst_20209;
var inst_20184 = null;
var inst_20185 = (0);
var inst_20186 = (0);
var state_20270__$1 = (function (){var statearr_20275 = state_20270;
(statearr_20275[(10)] = inst_20186);

(statearr_20275[(11)] = inst_20183);

(statearr_20275[(12)] = inst_20208);

(statearr_20275[(13)] = inst_20207);

(statearr_20275[(14)] = inst_20184);

(statearr_20275[(15)] = inst_20185);

return statearr_20275;
})();
var statearr_20276_20421 = state_20270__$1;
(statearr_20276_20421[(2)] = null);

(statearr_20276_20421[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (27))){
var inst_20248 = cljs.core.async.timeout.call(null,delay);
var state_20270__$1 = state_20270;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20270__$1,(32),inst_20248);
} else {
if((state_val_20271 === (1))){
var inst_19989 = retries__$1;
var inst_19990 = inst_19989;
var state_20270__$1 = (function (){var statearr_20277 = state_20270;
(statearr_20277[(16)] = inst_19990);

return statearr_20277;
})();
var statearr_20278_20422 = state_20270__$1;
(statearr_20278_20422[(2)] = null);

(statearr_20278_20422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (24))){
var inst_20172 = (state_20270[(8)]);
var inst_20227 = error_fn.call(null,inst_20172);
var state_20270__$1 = state_20270;
var statearr_20279_20423 = state_20270__$1;
(statearr_20279_20423[(2)] = inst_20227);

(statearr_20279_20423[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (4))){
var inst_19990 = (state_20270[(16)]);
var inst_19996 = (state_20270[(7)]);
var inst_19992 = (state_20270[(17)]);
var inst_19995 = (state_20270[(18)]);
var inst_20004 = (state_20270[(19)]);
var inst_20005 = (state_20270[(20)]);
var inst_20007 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_20008 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"doseq","doseq",221164135,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"ab-chs","ab-chs",-2000988533,null)], null),cljs.core.list(new cljs.core.Symbol(null,"put!","put!",-531220546,null),new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Keyword(null,"abort","abort",521193198)),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"a","a",-482876059,null))));
var inst_20009 = superv.async._register_go.call(null,supervisor,inst_20008);
var inst_20081 = cljs.core.async.chan.call(null,(1));
var inst_20082 = (function (){var stale_timeout__$1 = (1000);
var err_ch = inst_19992;
var id__13486__auto__ = inst_20009;
var ab_chs = inst_19995;
var res_ch = inst_20005;
var close_ch = inst_19996;
var retries__$2 = inst_19990;
var s = inst_20004;
var c__3355__auto____$1 = inst_20081;
var c__13485__auto__ = inst_20007;
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_20079){
var state_val_20080 = (state_20079[(1)]);
if((state_val_20080 === (7))){
var inst_20015 = (state_20079[(7)]);
var inst_20021 = superv.async._track_exception.call(null,supervisor,inst_20015);
var state_20079__$1 = state_20079;
var statearr_20280_20424 = state_20079__$1;
(statearr_20280_20424[(2)] = inst_20021);

(statearr_20280_20424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (20))){
var inst_20052 = (state_20079[(8)]);
var inst_20061 = cljs.core.first.call(null,inst_20052);
var inst_20062 = cljs.core.async.put_BANG_.call(null,inst_20061,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_20063 = cljs.core.async.close_BANG_.call(null,inst_20061);
var inst_20064 = cljs.core.next.call(null,inst_20052);
var inst_20038 = inst_20064;
var inst_20039 = null;
var inst_20040 = (0);
var inst_20041 = (0);
var state_20079__$1 = (function (){var statearr_20281 = state_20079;
(statearr_20281[(9)] = inst_20063);

(statearr_20281[(10)] = inst_20040);

(statearr_20281[(11)] = inst_20039);

(statearr_20281[(12)] = inst_20041);

(statearr_20281[(13)] = inst_20062);

(statearr_20281[(14)] = inst_20038);

return statearr_20281;
})();
var statearr_20282_20425 = state_20079__$1;
(statearr_20282_20425[(2)] = null);

(statearr_20282_20425[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (1))){
var state_20079__$1 = state_20079;
var statearr_20283_20426 = state_20079__$1;
(statearr_20283_20426[(2)] = null);

(statearr_20283_20426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (4))){
var _ = (function (){var statearr_20284 = state_20079;
(statearr_20284[(4)] = cljs.core.rest.call(null,(state_20079[(4)])));

return statearr_20284;
})();
var inst_20011 = (state_20079[(2)]);
var inst_20012 = superv.async._unregister_go.call(null,supervisor,id__13486__auto__);
var ___$1 = (function (){var temp__5735__auto__ = (state_20079[(5)]);
if(cljs.core.truth_(temp__5735__auto__)){
var e__2526__auto__ = temp__5735__auto__;
throw e__2526__auto__;
} else {
return null;
}
})();
var state_20079__$1 = (function (){var statearr_20285 = state_20079;
(statearr_20285[(15)] = inst_20012);

return statearr_20285;
})();
var statearr_20286_20427 = state_20079__$1;
(statearr_20286_20427[(2)] = inst_20011);

(statearr_20286_20427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (15))){
var inst_20072 = (state_20079[(2)]);
var state_20079__$1 = state_20079;
var statearr_20290_20428 = state_20079__$1;
(statearr_20290_20428[(2)] = inst_20072);

(statearr_20290_20428[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (21))){
var inst_20067 = (state_20079[(2)]);
var state_20079__$1 = state_20079;
var statearr_20291_20429 = state_20079__$1;
(statearr_20291_20429[(2)] = inst_20067);

(statearr_20291_20429[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (13))){
var inst_20040 = (state_20079[(10)]);
var inst_20039 = (state_20079[(11)]);
var inst_20041 = (state_20079[(12)]);
var inst_20038 = (state_20079[(14)]);
var inst_20046 = cljs.core._nth.call(null,inst_20039,inst_20041);
var inst_20047 = cljs.core.async.put_BANG_.call(null,inst_20046,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_20048 = cljs.core.async.close_BANG_.call(null,inst_20046);
var inst_20049 = (inst_20041 + (1));
var tmp20287 = inst_20040;
var tmp20288 = inst_20039;
var tmp20289 = inst_20038;
var inst_20038__$1 = tmp20289;
var inst_20039__$1 = tmp20288;
var inst_20040__$1 = tmp20287;
var inst_20041__$1 = inst_20049;
var state_20079__$1 = (function (){var statearr_20292 = state_20079;
(statearr_20292[(16)] = inst_20048);

(statearr_20292[(10)] = inst_20040__$1);

(statearr_20292[(11)] = inst_20039__$1);

(statearr_20292[(12)] = inst_20041__$1);

(statearr_20292[(17)] = inst_20047);

(statearr_20292[(14)] = inst_20038__$1);

return statearr_20292;
})();
var statearr_20293_20430 = state_20079__$1;
(statearr_20293_20430[(2)] = null);

(statearr_20293_20430[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (6))){
var state_20079__$1 = state_20079;
var statearr_20294_20431 = state_20079__$1;
(statearr_20294_20431[(2)] = null);

(statearr_20294_20431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (17))){
var state_20079__$1 = state_20079;
var statearr_20295_20432 = state_20079__$1;
(statearr_20295_20432[(2)] = null);

(statearr_20295_20432[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (3))){
var inst_20077 = (state_20079[(2)]);
var state_20079__$1 = state_20079;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20079__$1,inst_20077);
} else {
if((state_val_20080 === (12))){
var inst_20074 = (state_20079[(2)]);
var _ = (function (){var statearr_20296 = state_20079;
(statearr_20296[(4)] = cljs.core.rest.call(null,(state_20079[(4)])));

return statearr_20296;
})();
var state_20079__$1 = state_20079;
var statearr_20297_20433 = state_20079__$1;
(statearr_20297_20433[(2)] = inst_20074);

(statearr_20297_20433[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (2))){
var _ = (function (){var statearr_20298 = state_20079;
(statearr_20298[(4)] = cljs.core.cons.call(null,(4),(state_20079[(4)])));

return statearr_20298;
})();
var ___$1 = (function (){var statearr_20299 = state_20079;
(statearr_20299[(4)] = cljs.core.cons.call(null,(9),(state_20079[(4)])));

return statearr_20299;
})();
var inst_20030 = superv.async._abort.call(null,supervisor);
var state_20079__$1 = state_20079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20079__$1,(10),inst_20030);
} else {
if((state_val_20080 === (19))){
var inst_20052 = (state_20079[(8)]);
var inst_20056 = cljs.core.chunk_first.call(null,inst_20052);
var inst_20057 = cljs.core.chunk_rest.call(null,inst_20052);
var inst_20058 = cljs.core.count.call(null,inst_20056);
var inst_20038 = inst_20057;
var inst_20039 = inst_20056;
var inst_20040 = inst_20058;
var inst_20041 = (0);
var state_20079__$1 = (function (){var statearr_20301 = state_20079;
(statearr_20301[(10)] = inst_20040);

(statearr_20301[(11)] = inst_20039);

(statearr_20301[(12)] = inst_20041);

(statearr_20301[(14)] = inst_20038);

return statearr_20301;
})();
var statearr_20302_20434 = state_20079__$1;
(statearr_20302_20434[(2)] = null);

(statearr_20302_20434[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (11))){
var inst_20040 = (state_20079[(10)]);
var inst_20041 = (state_20079[(12)]);
var inst_20043 = (inst_20041 < inst_20040);
var inst_20044 = inst_20043;
var state_20079__$1 = state_20079;
if(cljs.core.truth_(inst_20044)){
var statearr_20303_20435 = state_20079__$1;
(statearr_20303_20435[(1)] = (13));

} else {
var statearr_20304_20436 = state_20079__$1;
(statearr_20304_20436[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (9))){
var _ = (function (){var statearr_20305 = state_20079;
(statearr_20305[(4)] = cljs.core.rest.call(null,(state_20079[(4)])));

return statearr_20305;
})();
var state_20079__$1 = state_20079;
var ex20300 = (state_20079__$1[(2)]);
var statearr_20306_20437 = state_20079__$1;
(statearr_20306_20437[(5)] = ex20300);


if((ex20300 instanceof Error)){
var statearr_20307_20438 = state_20079__$1;
(statearr_20307_20438[(1)] = (5));

(statearr_20307_20438[(5)] = null);

} else {
throw ex20300;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (5))){
var inst_20015 = (state_20079[(7)]);
var inst_20015__$1 = (state_20079[(2)]);
var inst_20016 = cljs.core.ex_data.call(null,inst_20015__$1);
var inst_20017 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_20016);
var inst_20018 = cljs.core._EQ_.call(null,inst_20017,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_20079__$1 = (function (){var statearr_20308 = state_20079;
(statearr_20308[(7)] = inst_20015__$1);

return statearr_20308;
})();
if(inst_20018){
var statearr_20309_20439 = state_20079__$1;
(statearr_20309_20439[(1)] = (6));

} else {
var statearr_20310_20440 = state_20079__$1;
(statearr_20310_20440[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (14))){
var inst_20052 = (state_20079[(8)]);
var inst_20038 = (state_20079[(14)]);
var inst_20052__$1 = cljs.core.seq.call(null,inst_20038);
var state_20079__$1 = (function (){var statearr_20311 = state_20079;
(statearr_20311[(8)] = inst_20052__$1);

return statearr_20311;
})();
if(inst_20052__$1){
var statearr_20312_20441 = state_20079__$1;
(statearr_20312_20441[(1)] = (16));

} else {
var statearr_20313_20442 = state_20079__$1;
(statearr_20313_20442[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (16))){
var inst_20052 = (state_20079[(8)]);
var inst_20054 = cljs.core.chunked_seq_QMARK_.call(null,inst_20052);
var state_20079__$1 = state_20079;
if(inst_20054){
var statearr_20314_20443 = state_20079__$1;
(statearr_20314_20443[(1)] = (19));

} else {
var statearr_20315_20444 = state_20079__$1;
(statearr_20315_20444[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (10))){
var inst_20032 = (state_20079[(2)]);
var inst_20037 = cljs.core.seq.call(null,ab_chs);
var inst_20038 = inst_20037;
var inst_20039 = null;
var inst_20040 = (0);
var inst_20041 = (0);
var state_20079__$1 = (function (){var statearr_20316 = state_20079;
(statearr_20316[(18)] = inst_20032);

(statearr_20316[(10)] = inst_20040);

(statearr_20316[(11)] = inst_20039);

(statearr_20316[(12)] = inst_20041);

(statearr_20316[(14)] = inst_20038);

return statearr_20316;
})();
var statearr_20317_20445 = state_20079__$1;
(statearr_20317_20445[(2)] = null);

(statearr_20317_20445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (18))){
var inst_20070 = (state_20079[(2)]);
var state_20079__$1 = state_20079;
var statearr_20318_20446 = state_20079__$1;
(statearr_20318_20446[(2)] = inst_20070);

(statearr_20318_20446[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20080 === (8))){
var inst_20015 = (state_20079[(7)]);
var inst_20023 = (state_20079[(2)]);
var state_20079__$1 = (function (){var statearr_20319 = state_20079;
(statearr_20319[(19)] = inst_20023);

return statearr_20319;
})();
var statearr_20320_20447 = state_20079__$1;
(statearr_20320_20447[(2)] = inst_20015);

(statearr_20320_20447[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_20321 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20321[(0)] = superv$async$state_machine__3282__auto__);

(statearr_20321[(1)] = (1));

return statearr_20321;
});
var superv$async$state_machine__3282__auto____1 = (function (state_20079){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_20079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e20322){var ex__3285__auto__ = e20322;
var statearr_20323_20448 = state_20079;
(statearr_20323_20448[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_20079[(4)]))){
var statearr_20324_20449 = state_20079;
(statearr_20324_20449[(1)] = cljs.core.first.call(null,(state_20079[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20450 = state_20079;
state_20079 = G__20450;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_20079){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_20079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_20325 = f__3356__auto__.call(null);
(statearr_20325[(6)] = c__3355__auto____$1);

return statearr_20325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});
})();
var inst_20083 = cljs.core.async.impl.dispatch.run.call(null,inst_20082);
var state_20270__$1 = (function (){var statearr_20326 = state_20270;
(statearr_20326[(21)] = inst_20083);

return statearr_20326;
})();
var statearr_20327_20451 = state_20270__$1;
(statearr_20327_20451[(2)] = inst_20081);

(statearr_20327_20451[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (15))){
var inst_20217 = (state_20270[(2)]);
var state_20270__$1 = state_20270;
var statearr_20328_20452 = state_20270__$1;
(statearr_20328_20452[(2)] = inst_20217);

(statearr_20328_20452[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (21))){
var inst_20212 = (state_20270[(2)]);
var state_20270__$1 = state_20270;
var statearr_20329_20453 = state_20270__$1;
(statearr_20329_20453[(2)] = inst_20212);

(statearr_20329_20453[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (31))){
var inst_20172 = (state_20270[(8)]);
var inst_20244 = (state_20270[(2)]);
var inst_20245 = cljs.core.async.put_BANG_.call(null,out_ch,inst_20172);
var inst_20246 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_20270__$1 = (function (){var statearr_20330 = state_20270;
(statearr_20330[(22)] = inst_20244);

(statearr_20330[(23)] = inst_20245);

return statearr_20330;
})();
var statearr_20331_20454 = state_20270__$1;
(statearr_20331_20454[(2)] = inst_20246);

(statearr_20331_20454[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (32))){
var inst_19990 = (state_20270[(16)]);
var inst_20172 = (state_20270[(8)]);
var inst_20250 = (state_20270[(2)]);
var inst_20251 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_20252 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20172);
var inst_20253 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_20252,inst_19990];
var inst_20254 = cljs.core.PersistentHashMap.fromArrays(inst_20251,inst_20253);
var inst_20255 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_20254);
var inst_20256 = (inst_19990 - (1));
var inst_19990__$1 = inst_20256;
var state_20270__$1 = (function (){var statearr_20335 = state_20270;
(statearr_20335[(24)] = inst_20250);

(statearr_20335[(16)] = inst_19990__$1);

(statearr_20335[(25)] = inst_20255);

return statearr_20335;
})();
var statearr_20336_20455 = state_20270__$1;
(statearr_20336_20455[(2)] = null);

(statearr_20336_20455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (33))){
var inst_20262 = (state_20270[(2)]);
var inst_20263 = cljs.core.async.put_BANG_.call(null,out_ch,inst_20262);
var inst_20264 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_20270__$1 = (function (){var statearr_20337 = state_20270;
(statearr_20337[(26)] = inst_20263);

return statearr_20337;
})();
var statearr_20338_20456 = state_20270__$1;
(statearr_20338_20456[(2)] = inst_20264);

(statearr_20338_20456[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (13))){
var inst_20186 = (state_20270[(10)]);
var inst_20183 = (state_20270[(11)]);
var inst_20184 = (state_20270[(14)]);
var inst_20185 = (state_20270[(15)]);
var inst_20191 = cljs.core._nth.call(null,inst_20184,inst_20186);
var inst_20192 = cljs.core.async.put_BANG_.call(null,inst_20191,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_20193 = cljs.core.async.close_BANG_.call(null,inst_20191);
var inst_20194 = (inst_20186 + (1));
var tmp20332 = inst_20183;
var tmp20333 = inst_20184;
var tmp20334 = inst_20185;
var inst_20183__$1 = tmp20332;
var inst_20184__$1 = tmp20333;
var inst_20185__$1 = tmp20334;
var inst_20186__$1 = inst_20194;
var state_20270__$1 = (function (){var statearr_20339 = state_20270;
(statearr_20339[(10)] = inst_20186__$1);

(statearr_20339[(27)] = inst_20193);

(statearr_20339[(11)] = inst_20183__$1);

(statearr_20339[(14)] = inst_20184__$1);

(statearr_20339[(28)] = inst_20192);

(statearr_20339[(15)] = inst_20185__$1);

return statearr_20339;
})();
var statearr_20340_20457 = state_20270__$1;
(statearr_20340_20457[(2)] = null);

(statearr_20340_20457[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (22))){
var inst_20224 = (state_20270[(29)]);
var inst_20172 = (state_20270[(8)]);
var inst_20221 = (state_20270[(2)]);
var inst_20222 = (inst_20172 instanceof exception);
var inst_20223 = cljs.core.not.call(null,inst_20222);
var inst_20224__$1 = cljs.core.not.call(null,error_fn);
var state_20270__$1 = (function (){var statearr_20341 = state_20270;
(statearr_20341[(30)] = inst_20221);

(statearr_20341[(29)] = inst_20224__$1);

(statearr_20341[(31)] = inst_20223);

return statearr_20341;
})();
if(inst_20224__$1){
var statearr_20342_20458 = state_20270__$1;
(statearr_20342_20458[(1)] = (23));

} else {
var statearr_20343_20459 = state_20270__$1;
(statearr_20343_20459[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (29))){
var inst_20172 = (state_20270[(8)]);
var inst_20240 = superv.async._error.call(null,supervisor);
var inst_20241 = cljs.core.async.put_BANG_.call(null,inst_20240,inst_20172);
var state_20270__$1 = state_20270;
var statearr_20344_20460 = state_20270__$1;
(statearr_20344_20460[(2)] = inst_20241);

(statearr_20344_20460[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (6))){
var inst_19990 = (state_20270[(16)]);
var inst_19996 = (state_20270[(7)]);
var inst_19992 = (state_20270[(17)]);
var inst_19995 = (state_20270[(18)]);
var inst_20004 = (state_20270[(19)]);
var inst_20005 = (state_20270[(20)]);
var inst_20086 = (state_20270[(2)]);
var inst_20133 = cljs.core.async.chan.call(null,(1));
var inst_20134 = (function (){var retries__$2 = inst_19990;
var err_ch = inst_19992;
var ab_chs = inst_19995;
var close_ch = inst_19996;
var s = inst_20004;
var res_ch = inst_20005;
var stale_timeout__$1 = (1000);
var c__3355__auto____$1 = inst_20133;
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_20131){
var state_val_20132 = (state_20131[(1)]);
if((state_val_20132 === (7))){
var inst_20106 = (state_20131[(7)]);
var inst_20093 = (state_20131[(2)]);
var inst_20101 = (function (){return (function (p__20100){
var vec__20345 = p__20100;
var k = cljs.core.nth.call(null,vec__20345,(0),null);
var v = cljs.core.nth.call(null,vec__20345,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
})();
var inst_20102 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_20103 = cljs.core.deref.call(null,inst_20102);
var inst_20104 = cljs.core.filter.call(null,inst_20101,inst_20103);
var inst_20105 = cljs.core.nth.call(null,inst_20104,(0),null);
var inst_20106__$1 = cljs.core.nth.call(null,inst_20105,(0),null);
var inst_20107 = cljs.core.nth.call(null,inst_20105,(1),null);
var state_20131__$1 = (function (){var statearr_20348 = state_20131;
(statearr_20348[(8)] = inst_20093);

(statearr_20348[(9)] = inst_20107);

(statearr_20348[(7)] = inst_20106__$1);

return statearr_20348;
})();
if(cljs.core.truth_(inst_20106__$1)){
var statearr_20349_20461 = state_20131__$1;
(statearr_20349_20461[(1)] = (8));

} else {
var statearr_20350_20462 = state_20131__$1;
(statearr_20350_20462[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (1))){
var state_20131__$1 = state_20131;
var statearr_20351_20463 = state_20131__$1;
(statearr_20351_20463[(2)] = null);

(statearr_20351_20463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (4))){
var state_20131__$1 = state_20131;
var statearr_20352_20464 = state_20131__$1;
(statearr_20352_20464[(2)] = null);

(statearr_20352_20464[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (13))){
var inst_20106 = (state_20131[(7)]);
var inst_20119 = (state_20131[(2)]);
var inst_20120 = superv.async._free_exception.call(null,s,inst_20106);
var inst_20121 = cljs.core.async.put_BANG_.call(null,err_ch,inst_20106);
var state_20131__$1 = (function (){var statearr_20353 = state_20131;
(statearr_20353[(10)] = inst_20119);

(statearr_20353[(11)] = inst_20120);

return statearr_20353;
})();
var statearr_20354_20465 = state_20131__$1;
(statearr_20354_20465[(2)] = inst_20121);

(statearr_20354_20465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (6))){
var inst_20127 = (state_20131[(2)]);
var state_20131__$1 = state_20131;
var statearr_20355_20466 = state_20131__$1;
(statearr_20355_20466[(2)] = inst_20127);

(statearr_20355_20466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (3))){
var inst_20129 = (state_20131[(2)]);
var state_20131__$1 = state_20131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20131__$1,inst_20129);
} else {
if((state_val_20132 === (12))){
var inst_20106 = (state_20131[(7)]);
var inst_20114 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20115 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_20106];
var inst_20116 = cljs.core.PersistentHashMap.fromArrays(inst_20114,inst_20115);
var inst_20117 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_20116);
var state_20131__$1 = state_20131;
var statearr_20356_20467 = state_20131__$1;
(statearr_20356_20467[(2)] = inst_20117);

(statearr_20356_20467[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (2))){
var inst_20088 = cljs.core.some.call(null,cljs.core.async.poll_BANG_,ab_chs);
var state_20131__$1 = state_20131;
if(cljs.core.truth_(inst_20088)){
var statearr_20357_20468 = state_20131__$1;
(statearr_20357_20468[(1)] = (4));

} else {
var statearr_20358_20469 = state_20131__$1;
(statearr_20358_20469[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (11))){
var state_20131__$1 = state_20131;
var statearr_20359_20470 = state_20131__$1;
(statearr_20359_20470[(2)] = null);

(statearr_20359_20470[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (9))){
var state_20131__$1 = state_20131;
var statearr_20360_20471 = state_20131__$1;
(statearr_20360_20471[(2)] = null);

(statearr_20360_20471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (5))){
var inst_20091 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_20131__$1 = state_20131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20131__$1,(7),inst_20091);
} else {
if((state_val_20132 === (10))){
var inst_20125 = (state_20131[(2)]);
var state_20131__$1 = state_20131;
var statearr_20361_20472 = state_20131__$1;
(statearr_20361_20472[(2)] = inst_20125);

(statearr_20361_20472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20132 === (8))){
var inst_20106 = (state_20131[(7)]);
var inst_20109 = cljs.core.ex_data.call(null,inst_20106);
var inst_20110 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_20109);
var inst_20111 = cljs.core._EQ_.call(null,inst_20110,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_20131__$1 = state_20131;
if(inst_20111){
var statearr_20362_20473 = state_20131__$1;
(statearr_20362_20473[(1)] = (11));

} else {
var statearr_20363_20474 = state_20131__$1;
(statearr_20363_20474[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_20364 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20364[(0)] = superv$async$state_machine__3282__auto__);

(statearr_20364[(1)] = (1));

return statearr_20364;
});
var superv$async$state_machine__3282__auto____1 = (function (state_20131){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_20131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e20365){var ex__3285__auto__ = e20365;
var statearr_20366_20475 = state_20131;
(statearr_20366_20475[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_20131[(4)]))){
var statearr_20367_20476 = state_20131;
(statearr_20367_20476[(1)] = cljs.core.first.call(null,(state_20131[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20477 = state_20131;
state_20131 = G__20477;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_20131){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_20131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_20368 = f__3356__auto__.call(null);
(statearr_20368[(6)] = c__3355__auto____$1);

return statearr_20368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});
})();
var inst_20135 = cljs.core.async.impl.dispatch.run.call(null,inst_20134);
var inst_20161 = cljs.core.async.chan.call(null,(1));
var inst_20162 = (function (){var retries__$2 = inst_19990;
var err_ch = inst_19992;
var ab_chs = inst_19995;
var close_ch = inst_19996;
var s = inst_20004;
var res_ch = inst_20005;
var stale_timeout__$1 = (1000);
var c__3355__auto____$1 = inst_20161;
return (function (){
var f__3356__auto__ = (function (){var switch__3281__auto__ = (function (state_20159){
var state_val_20160 = (state_20159[(1)]);
if((state_val_20160 === (1))){
var inst_20136 = (0);
var state_20159__$1 = (function (){var statearr_20369 = state_20159;
(statearr_20369[(7)] = inst_20136);

return statearr_20369;
})();
var statearr_20370_20478 = state_20159__$1;
(statearr_20370_20478[(2)] = null);

(statearr_20370_20478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20160 === (2))){
var inst_20138 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_20139 = cljs.core.deref.call(null,inst_20138);
var inst_20140 = cljs.core.empty_QMARK_.call(null,inst_20139);
var inst_20141 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_20142 = cljs.core.deref.call(null,inst_20141);
var inst_20143 = cljs.core.empty_QMARK_.call(null,inst_20142);
var inst_20144 = ((inst_20140) && (inst_20143));
var inst_20145 = cljs.core.not.call(null,inst_20144);
var state_20159__$1 = state_20159;
if(inst_20145){
var statearr_20371_20479 = state_20159__$1;
(statearr_20371_20479[(1)] = (4));

} else {
var statearr_20372_20480 = state_20159__$1;
(statearr_20372_20480[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20160 === (3))){
var inst_20157 = (state_20159[(2)]);
var state_20159__$1 = state_20159;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20159__$1,inst_20157);
} else {
if((state_val_20160 === (4))){
var inst_20147 = cljs.core.async.timeout.call(null,(100));
var state_20159__$1 = state_20159;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20159__$1,(7),inst_20147);
} else {
if((state_val_20160 === (5))){
var inst_20153 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_20159__$1 = state_20159;
var statearr_20373_20481 = state_20159__$1;
(statearr_20373_20481[(2)] = inst_20153);

(statearr_20373_20481[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20160 === (6))){
var inst_20155 = (state_20159[(2)]);
var state_20159__$1 = state_20159;
var statearr_20374_20482 = state_20159__$1;
(statearr_20374_20482[(2)] = inst_20155);

(statearr_20374_20482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20160 === (7))){
var inst_20136 = (state_20159[(7)]);
var inst_20149 = (state_20159[(2)]);
var inst_20150 = (inst_20136 + (1));
var inst_20136__$1 = inst_20150;
var state_20159__$1 = (function (){var statearr_20375 = state_20159;
(statearr_20375[(8)] = inst_20149);

(statearr_20375[(7)] = inst_20136__$1);

return statearr_20375;
})();
var statearr_20376_20483 = state_20159__$1;
(statearr_20376_20483[(2)] = null);

(statearr_20376_20483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_20377 = [null,null,null,null,null,null,null,null,null];
(statearr_20377[(0)] = superv$async$state_machine__3282__auto__);

(statearr_20377[(1)] = (1));

return statearr_20377;
});
var superv$async$state_machine__3282__auto____1 = (function (state_20159){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_20159);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e20378){var ex__3285__auto__ = e20378;
var statearr_20379_20484 = state_20159;
(statearr_20379_20484[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_20159[(4)]))){
var statearr_20380_20485 = state_20159;
(statearr_20380_20485[(1)] = cljs.core.first.call(null,(state_20159[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20486 = state_20159;
state_20159 = G__20486;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_20159){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_20159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_20381 = f__3356__auto__.call(null);
(statearr_20381[(6)] = c__3355__auto____$1);

return statearr_20381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
});
})();
var inst_20163 = cljs.core.async.impl.dispatch.run.call(null,inst_20162);
var inst_20167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20168 = [inst_19992,inst_19996];
var inst_20169 = (new cljs.core.PersistentVector(null,2,(5),inst_20167,inst_20168,null));
var state_20270__$1 = (function (){var statearr_20382 = state_20270;
(statearr_20382[(32)] = inst_20086);

(statearr_20382[(33)] = inst_20163);

(statearr_20382[(34)] = inst_20135);

return statearr_20382;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20270__$1,(7),inst_20169,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_20271 === (28))){
var inst_20259 = (state_20270[(2)]);
var state_20270__$1 = state_20270;
var statearr_20383_20487 = state_20270__$1;
(statearr_20383_20487[(2)] = inst_20259);

(statearr_20383_20487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (25))){
var inst_19990 = (state_20270[(16)]);
var inst_20223 = (state_20270[(31)]);
var inst_20229 = (state_20270[(2)]);
var inst_20230 = cljs.core.not.call(null,inst_20229);
var inst_20231 = (inst_19990 > (0));
var inst_20232 = cljs.core.not.call(null,inst_20231);
var inst_20233 = ((inst_20223) || (inst_20230) || (inst_20232));
var state_20270__$1 = state_20270;
if(cljs.core.truth_(inst_20233)){
var statearr_20384_20488 = state_20270__$1;
(statearr_20384_20488[(1)] = (26));

} else {
var statearr_20385_20489 = state_20270__$1;
(statearr_20385_20489[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (17))){
var state_20270__$1 = state_20270;
var statearr_20386_20490 = state_20270__$1;
(statearr_20386_20490[(2)] = null);

(statearr_20386_20490[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (3))){
var inst_20268 = (state_20270[(2)]);
var state_20270__$1 = state_20270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20270__$1,inst_20268);
} else {
if((state_val_20271 === (12))){
var inst_19996 = (state_20270[(7)]);
var inst_20219 = (state_20270[(2)]);
var state_20270__$1 = (function (){var statearr_20387 = state_20270;
(statearr_20387[(35)] = inst_20219);

return statearr_20387;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20270__$1,(22),inst_19996);
} else {
if((state_val_20271 === (2))){
var inst_19990 = (state_20270[(16)]);
var inst_19992 = (state_20270[(17)]);
var inst_19995 = (state_20270[(18)]);
var inst_20004 = (state_20270[(19)]);
var inst_19992__$1 = cljs.core.async.chan.call(null);
var inst_19993 = (function (){var retries__$2 = inst_19990;
var err_ch = inst_19992__$1;
return (function (){
return cljs.core.async.promise_chan.call(null);
});
})();
var inst_19994 = cljs.core.repeatedly.call(null,(1000),inst_19993);
var inst_19995__$1 = cljs.core.vec.call(null,inst_19994);
var inst_19996 = cljs.core.async.chan.call(null);
var inst_19997 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"aborts","aborts",-277478143),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_19998 = cljs.core.PersistentHashMap.EMPTY;
var inst_19999 = cljs.core.atom.call(null,inst_19998);
var inst_20000 = cljs.core.PersistentHashMap.EMPTY;
var inst_20001 = cljs.core.atom.call(null,inst_20000);
var inst_20002 = [inst_19992__$1,inst_19995__$1,inst_19999,inst_20001,true];
var inst_20003 = cljs.core.PersistentHashMap.fromArrays(inst_19997,inst_20002);
var inst_20004__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_20003);
var inst_20005 = start_fn.call(null,inst_20004__$1);
var state_20270__$1 = (function (){var statearr_20388 = state_20270;
(statearr_20388[(7)] = inst_19996);

(statearr_20388[(17)] = inst_19992__$1);

(statearr_20388[(18)] = inst_19995__$1);

(statearr_20388[(19)] = inst_20004__$1);

(statearr_20388[(20)] = inst_20005);

return statearr_20388;
})();
if(cljs.core.truth_(supervisor)){
var statearr_20389_20491 = state_20270__$1;
(statearr_20389_20491[(1)] = (4));

} else {
var statearr_20390_20492 = state_20270__$1;
(statearr_20390_20492[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (23))){
var inst_20224 = (state_20270[(29)]);
var state_20270__$1 = state_20270;
var statearr_20391_20493 = state_20270__$1;
(statearr_20391_20493[(2)] = inst_20224);

(statearr_20391_20493[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (19))){
var inst_20197 = (state_20270[(9)]);
var inst_20201 = cljs.core.chunk_first.call(null,inst_20197);
var inst_20202 = cljs.core.chunk_rest.call(null,inst_20197);
var inst_20203 = cljs.core.count.call(null,inst_20201);
var inst_20183 = inst_20202;
var inst_20184 = inst_20201;
var inst_20185 = inst_20203;
var inst_20186 = (0);
var state_20270__$1 = (function (){var statearr_20392 = state_20270;
(statearr_20392[(10)] = inst_20186);

(statearr_20392[(11)] = inst_20183);

(statearr_20392[(14)] = inst_20184);

(statearr_20392[(15)] = inst_20185);

return statearr_20392;
})();
var statearr_20393_20494 = state_20270__$1;
(statearr_20393_20494[(2)] = null);

(statearr_20393_20494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (11))){
var inst_20186 = (state_20270[(10)]);
var inst_20185 = (state_20270[(15)]);
var inst_20188 = (inst_20186 < inst_20185);
var inst_20189 = inst_20188;
var state_20270__$1 = state_20270;
if(cljs.core.truth_(inst_20189)){
var statearr_20394_20495 = state_20270__$1;
(statearr_20394_20495[(1)] = (13));

} else {
var statearr_20395_20496 = state_20270__$1;
(statearr_20395_20496[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (9))){
var inst_20005 = (state_20270[(20)]);
var state_20270__$1 = state_20270;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20270__$1,(33),inst_20005);
} else {
if((state_val_20271 === (5))){
var state_20270__$1 = state_20270;
var statearr_20396_20497 = state_20270__$1;
(statearr_20396_20497[(2)] = null);

(statearr_20396_20497[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (14))){
var inst_20183 = (state_20270[(11)]);
var inst_20197 = (state_20270[(9)]);
var inst_20197__$1 = cljs.core.seq.call(null,inst_20183);
var state_20270__$1 = (function (){var statearr_20397 = state_20270;
(statearr_20397[(9)] = inst_20197__$1);

return statearr_20397;
})();
if(inst_20197__$1){
var statearr_20398_20498 = state_20270__$1;
(statearr_20398_20498[(1)] = (16));

} else {
var statearr_20399_20499 = state_20270__$1;
(statearr_20399_20499[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (26))){
var inst_20172 = (state_20270[(8)]);
var inst_20235 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20236 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_20172];
var inst_20237 = cljs.core.PersistentHashMap.fromArrays(inst_20235,inst_20236);
var inst_20238 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_20237);
var state_20270__$1 = (function (){var statearr_20400 = state_20270;
(statearr_20400[(36)] = inst_20238);

return statearr_20400;
})();
if(cljs.core.truth_(supervisor)){
var statearr_20401_20500 = state_20270__$1;
(statearr_20401_20500[(1)] = (29));

} else {
var statearr_20402_20501 = state_20270__$1;
(statearr_20402_20501[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (16))){
var inst_20197 = (state_20270[(9)]);
var inst_20199 = cljs.core.chunked_seq_QMARK_.call(null,inst_20197);
var state_20270__$1 = state_20270;
if(inst_20199){
var statearr_20403_20502 = state_20270__$1;
(statearr_20403_20502[(1)] = (19));

} else {
var statearr_20404_20503 = state_20270__$1;
(statearr_20404_20503[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (30))){
var state_20270__$1 = state_20270;
var statearr_20405_20504 = state_20270__$1;
(statearr_20405_20504[(2)] = null);

(statearr_20405_20504[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (10))){
var inst_20266 = (state_20270[(2)]);
var state_20270__$1 = state_20270;
var statearr_20406_20505 = state_20270__$1;
(statearr_20406_20505[(2)] = inst_20266);

(statearr_20406_20505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (18))){
var inst_20215 = (state_20270[(2)]);
var state_20270__$1 = state_20270;
var statearr_20407_20506 = state_20270__$1;
(statearr_20407_20506[(2)] = inst_20215);

(statearr_20407_20506[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20271 === (8))){
var inst_19992 = (state_20270[(17)]);
var inst_19995 = (state_20270[(18)]);
var inst_20177 = cljs.core.async.close_BANG_.call(null,inst_19992);
var inst_20182 = cljs.core.seq.call(null,inst_19995);
var inst_20183 = inst_20182;
var inst_20184 = null;
var inst_20185 = (0);
var inst_20186 = (0);
var state_20270__$1 = (function (){var statearr_20408 = state_20270;
(statearr_20408[(10)] = inst_20186);

(statearr_20408[(11)] = inst_20183);

(statearr_20408[(37)] = inst_20177);

(statearr_20408[(14)] = inst_20184);

(statearr_20408[(15)] = inst_20185);

return statearr_20408;
})();
var statearr_20409_20507 = state_20270__$1;
(statearr_20409_20507[(2)] = null);

(statearr_20409_20507[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__3282__auto__ = null;
var superv$async$state_machine__3282__auto____0 = (function (){
var statearr_20410 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20410[(0)] = superv$async$state_machine__3282__auto__);

(statearr_20410[(1)] = (1));

return statearr_20410;
});
var superv$async$state_machine__3282__auto____1 = (function (state_20270){
while(true){
var ret_value__3283__auto__ = (function (){try{while(true){
var result__3284__auto__ = switch__3281__auto__.call(null,state_20270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__3284__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__3284__auto__;
}
break;
}
}catch (e20411){var ex__3285__auto__ = e20411;
var statearr_20412_20508 = state_20270;
(statearr_20412_20508[(2)] = ex__3285__auto__);


if(cljs.core.seq.call(null,(state_20270[(4)]))){
var statearr_20413_20509 = state_20270;
(statearr_20413_20509[(1)] = cljs.core.first.call(null,(state_20270[(4)])));

} else {
throw ex__3285__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__3283__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20510 = state_20270;
state_20270 = G__20510;
continue;
} else {
return ret_value__3283__auto__;
}
break;
}
});
superv$async$state_machine__3282__auto__ = function(state_20270){
switch(arguments.length){
case 0:
return superv$async$state_machine__3282__auto____0.call(this);
case 1:
return superv$async$state_machine__3282__auto____1.call(this,state_20270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__3282__auto____0;
superv$async$state_machine__3282__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__3282__auto____1;
return superv$async$state_machine__3282__auto__;
})()
})();
var state__3357__auto__ = (function (){var statearr_20414 = f__3356__auto__.call(null);
(statearr_20414[(6)] = c__3355__auto___20418);

return statearr_20414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__3357__auto__);
}));


return out_ch;
}));

(superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq19984){
var G__19985 = cljs.core.first.call(null,seq19984);
var seq19984__$1 = cljs.core.next.call(null,seq19984);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19985,seq19984__$1);
}));


//# sourceMappingURL=async.js.map
