// Compiled by ClojureScript 1.8.34 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__25214__auto__ = (((this$ == null))?null:this$);
var m__25215__auto__ = (superv.async._error[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,this$);
} else {
var m__25215__auto____$1 = (superv.async._error["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__25214__auto__ = (((this$ == null))?null:this$);
var m__25215__auto__ = (superv.async._abort[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,this$);
} else {
var m__25215__auto____$1 = (superv.async._abort["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__25214__auto__ = (((this$ == null))?null:this$);
var m__25215__auto__ = (superv.async._register_go[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,this$,body);
} else {
var m__25215__auto____$1 = (superv.async._register_go["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__25214__auto__ = (((this$ == null))?null:this$);
var m__25215__auto__ = (superv.async._unregister_go[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,this$,id);
} else {
var m__25215__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__25214__auto__ = (((this$ == null))?null:this$);
var m__25215__auto__ = (superv.async._track_exception[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,this$,e);
} else {
var m__25215__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__25214__auto__ = (((this$ == null))?null:this$);
var m__25215__auto__ = (superv.async._free_exception[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,this$,e);
} else {
var m__25215__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__25173__auto__,k__25174__auto__){
var self__ = this;
var this__25173__auto____$1 = this;
return cljs.core._lookup.call(null,this__25173__auto____$1,k__25174__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__25175__auto__,k30724,else__25176__auto__){
var self__ = this;
var this__25175__auto____$1 = this;
var G__30726 = (((k30724 instanceof cljs.core.Keyword))?k30724.fqn:null);
switch (G__30726) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k30724,else__25176__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__25187__auto__,writer__25188__auto__,opts__25189__auto__){
var self__ = this;
var this__25187__auto____$1 = this;
var pr_pair__25190__auto__ = ((function (this__25187__auto____$1){
return (function (keyval__25191__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__25188__auto__,cljs.core.pr_writer,""," ","",opts__25189__auto__,keyval__25191__auto__);
});})(this__25187__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__25188__auto__,pr_pair__25190__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__25189__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = true;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30723){
var self__ = this;
var G__30723__$1 = this;
return (new cljs.core.RecordIter((0),G__30723__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__25171__auto__){
var self__ = this;
var this__25171__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__25167__auto__){
var self__ = this;
var this__25167__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__25177__auto__){
var self__ = this;
var this__25177__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__25168__auto__){
var self__ = this;
var this__25168__auto____$1 = this;
var h__24986__auto__ = self__.__hash;
if(!((h__24986__auto__ == null))){
return h__24986__auto__;
} else {
var h__24986__auto____$1 = cljs.core.hash_imap.call(null,this__25168__auto____$1);
self__.__hash = h__24986__auto____$1;

return h__24986__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__25169__auto__,other__25170__auto__){
var self__ = this;
var this__25169__auto____$1 = this;
if(cljs.core.truth_((function (){var and__24539__auto__ = other__25170__auto__;
if(cljs.core.truth_(and__24539__auto__)){
var and__24539__auto____$1 = (this__25169__auto____$1.constructor === other__25170__auto__.constructor);
if(and__24539__auto____$1){
return cljs.core.equiv_map.call(null,this__25169__auto____$1,other__25170__auto__);
} else {
return and__24539__auto____$1;
}
} else {
return and__24539__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__25182__auto__,k__25183__auto__){
var self__ = this;
var this__25182__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__25183__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__25182__auto____$1),self__.__meta),k__25183__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__25183__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = true;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__25180__auto__,k__25181__auto__,G__30723){
var self__ = this;
var this__25180__auto____$1 = this;
var pred__30727 = cljs.core.keyword_identical_QMARK_;
var expr__30728 = k__25181__auto__;
if(cljs.core.truth_(pred__30727.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__30728))){
return (new superv.async.TrackingSupervisor(G__30723,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__30727.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__30728))){
return (new superv.async.TrackingSupervisor(self__.error,G__30723,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__30727.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__30728))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__30723,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__30727.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__30728))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__30723,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__25181__auto__,G__30723),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__25185__auto__){
var self__ = this;
var this__25185__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__25172__auto__,G__30723){
var self__ = this;
var this__25172__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__30723,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__25178__auto__,entry__25179__auto__){
var self__ = this;
var this__25178__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__25179__auto__)){
return cljs.core._assoc.call(null,this__25178__auto____$1,cljs.core._nth.call(null,entry__25179__auto__,(0)),cljs.core._nth.call(null,entry__25179__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__25178__auto____$1,entry__25179__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__25207__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__25207__auto__,writer__25208__auto__){
return cljs.core._write.call(null,writer__25208__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__30725){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__30725),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__30725),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__30725),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__30725),null,cljs.core.dissoc.call(null,G__30725,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__25627__auto__ = [];
var len__25620__auto___30743 = arguments.length;
var i__25621__auto___30744 = (0);
while(true){
if((i__25621__auto___30744 < len__25620__auto___30743)){
args__25627__auto__.push((arguments[i__25621__auto___30744]));

var G__30745 = (i__25621__auto___30744 + (1));
i__25621__auto___30744 = G__30745;
continue;
} else {
}
break;
}

var argseq__25628__auto__ = ((((0) < args__25627__auto__.length))?(new cljs.core.IndexedSeq(args__25627__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__25628__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__30732){
var map__30733 = p__30732;
var map__30733__$1 = ((((!((map__30733 == null)))?((((map__30733.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30733.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30733):map__30733);
var stale_timeout = cljs.core.get.call(null,map__30733__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__30733__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__30733,map__30733__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__30733,map__30733__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__30733__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755),((function (map__30733,map__30733__$1,stale_timeout,error_fn){
return (function (e){
return cljs.core.println.call(null,"Supervisor detected stale error:",e,e.stack);
});})(map__30733,map__30733__$1,stale_timeout,error_fn))
);
var s = cljs.core.assoc.call(null,superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null)),new cljs.core.Keyword(null,"global?","global?",-2022837689),true);
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__30733,map__30733__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__30733,map__30733__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__30733,map__30733__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__30739 = cljs.core.filter.call(null,((function (s,err_ch,map__30733,map__30733__$1,stale_timeout,error_fn,pending_fn){
return (function (p__30741){
var vec__30742 = p__30741;
var k = cljs.core.nth.call(null,vec__30742,(0),null);
var v = cljs.core.nth.call(null,vec__30742,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__30733,map__30733__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__30740 = cljs.core.nth.call(null,vec__30739,(0),null);
var e = cljs.core.nth.call(null,vec__30740,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__30740,(1),null);
if(cljs.core.truth_(e)){
pending_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__30733,map__30733__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq30731){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq30731));
});
superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__24551__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args30757 = [];
var len__25620__auto___30760 = arguments.length;
var i__25621__auto___30761 = (0);
while(true){
if((i__25621__auto___30761 < len__25620__auto___30760)){
args30757.push((arguments[i__25621__auto___30761]));

var G__30762 = (i__25621__auto___30761 + (1));
i__25621__auto___30761 = G__30762;
continue;
} else {
}
break;
}

var G__30759 = args30757.length;
switch (G__30759) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30757.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;
/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 *   deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args30764 = [];
var len__25620__auto___30767 = arguments.length;
var i__25621__auto___30768 = (0);
while(true){
if((i__25621__auto___30768 < len__25620__auto___30767)){
args30764.push((arguments[i__25621__auto___30768]));

var G__30769 = (i__25621__auto___30768 + (1));
i__25621__auto___30768 = G__30769;
continue;
} else {
}
break;
}

var G__30766 = args30764.length;
switch (G__30766) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30764.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;
/**
 * Same as core.async alts! but throws an exception if the channel returns a
 *   throwable object or the context has been aborted.
 */
superv.async.alts_QMARK_ = (function superv$async$alts_QMARK_(var_args){
var args__25627__auto__ = [];
var len__25620__auto___30776 = arguments.length;
var i__25621__auto___30777 = (0);
while(true){
if((i__25621__auto___30777 < len__25620__auto___30776)){
args__25627__auto__.push((arguments[i__25621__auto___30777]));

var G__30778 = (i__25621__auto___30777 + (1));
i__25621__auto___30777 = G__30778;
continue;
} else {
}
break;
}

var argseq__25628__auto__ = ((((2) < args__25627__auto__.length))?(new cljs.core.IndexedSeq(args__25627__auto__.slice((2)),(0),null)):null);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__25628__auto__);
});

superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (S,ports,opts){
var abort__29673__auto__ = superv.async._abort.call(null,S);
var to__29674__auto__ = cljs.core.async.timeout.call(null,(0));
var vec__30774 = cljs.core.async.alts_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [abort__29673__auto__,to__29674__auto__], null),new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var val__29675__auto__ = cljs.core.nth.call(null,vec__30774,(0),null);
var port__29676__auto__ = cljs.core.nth.call(null,vec__30774,(1),null);
if(cljs.core._EQ_.call(null,port__29676__auto__,abort__29673__auto__)){
return cljs.core.ex_info.call(null,"Aborted operations",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"aborted","aborted",1775972619)], null));
} else {
var vec__30775 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var val = cljs.core.nth.call(null,vec__30775,(0),null);
var port = cljs.core.nth.call(null,vec__30775,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async.throw_if_exception.call(null,S,val),port], null);
}
});

superv.async.alts_QMARK_.cljs$lang$maxFixedArity = (2);

superv.async.alts_QMARK_.cljs$lang$applyTo = (function (seq30771){
var G__30772 = cljs.core.first.call(null,seq30771);
var seq30771__$1 = cljs.core.next.call(null,seq30771);
var G__30773 = cljs.core.first.call(null,seq30771__$1);
var seq30771__$2 = cljs.core.next.call(null,seq30771__$1);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__30772,G__30773,seq30771__$2);
});
/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args30788 = [];
var len__25620__auto___30983 = arguments.length;
var i__25621__auto___30984 = (0);
while(true){
if((i__25621__auto___30984 < len__25620__auto___30983)){
args30788.push((arguments[i__25621__auto___30984]));

var G__30985 = (i__25621__auto___30984 + (1));
i__25621__auto___30984 = G__30985;
continue;
} else {
}
break;
}

var G__30790 = args30788.length;
switch (G__30790) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30788.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__25465__auto___30987 = parallelism;
var __30988 = (0);
while(true){
if((__30988 < n__25465__auto___30987)){
var id__29654__auto___30989 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__26717__auto___30990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30988,c__26717__auto___30990,id__29654__auto___30989,n__25465__auto___30987,threads){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (__30988,c__26717__auto___30990,id__29654__auto___30989,n__25465__auto___30987,threads){
return (function (state_30917){
var state_val_30918 = (state_30917[(1)]);
if((state_val_30918 === (7))){
var inst_30794 = (state_30917[(7)]);
var inst_30802 = (state_30917[(2)]);
var state_30917__$1 = (function (){var statearr_30919 = state_30917;
(statearr_30919[(8)] = inst_30802);

return statearr_30919;
})();
var statearr_30920_30991 = state_30917__$1;
(statearr_30920_30991[(2)] = inst_30794);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30917__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (20))){
var inst_30901 = (state_30917[(2)]);
var state_30917__$1 = state_30917;
var statearr_30921_30992 = state_30917__$1;
(statearr_30921_30992[(2)] = inst_30901);

(statearr_30921_30992[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (27))){
var inst_30865 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_30866 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_30867 = cljs.core.PersistentHashMap.fromArrays(inst_30865,inst_30866);
var inst_30868 = cljs.core.ex_info.call(null,"Aborted operations",inst_30867);
var state_30917__$1 = state_30917;
var statearr_30922_30993 = state_30917__$1;
(statearr_30922_30993[(2)] = inst_30868);

(statearr_30922_30993[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (1))){
var state_30917__$1 = state_30917;
var statearr_30923_30994 = state_30917__$1;
(statearr_30923_30994[(2)] = null);

(statearr_30923_30994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (24))){
var inst_30849 = (state_30917[(2)]);
var inst_30850 = superv.async.throw_if_exception.call(null,S,inst_30849);
var inst_30851 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_30917__$1 = (function (){var statearr_30924 = state_30917;
(statearr_30924[(9)] = inst_30850);

return statearr_30924;
})();
var statearr_30925_30995 = state_30917__$1;
(statearr_30925_30995[(2)] = inst_30851);

(statearr_30925_30995[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (39))){
var state_30917__$1 = state_30917;
var statearr_30926_30996 = state_30917__$1;
(statearr_30926_30996[(2)] = null);

(statearr_30926_30996[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (4))){
var inst_30794 = (state_30917[(7)]);
var inst_30794__$1 = (state_30917[(2)]);
var inst_30795 = cljs.core.ex_data.call(null,inst_30794__$1);
var inst_30796 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_30795);
var inst_30797 = cljs.core._EQ_.call(null,inst_30796,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_30917__$1 = (function (){var statearr_30927 = state_30917;
(statearr_30927[(7)] = inst_30794__$1);

return statearr_30927;
})();
if(inst_30797){
var statearr_30928_30997 = state_30917__$1;
(statearr_30928_30997[(1)] = (5));

} else {
var statearr_30929_30998 = state_30917__$1;
(statearr_30929_30998[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (15))){
var inst_30825 = (state_30917[(10)]);
var inst_30827 = (inst_30825 instanceof Error);
var state_30917__$1 = state_30917;
if(cljs.core.truth_(inst_30827)){
var statearr_30930_30999 = state_30917__$1;
(statearr_30930_30999[(1)] = (18));

} else {
var statearr_30931_31000 = state_30917__$1;
(statearr_30931_31000[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (21))){
var inst_30830 = (state_30917[(11)]);
var inst_30836 = (state_30917[(2)]);
var inst_30837 = cljs.core.nth.call(null,inst_30836,(0),null);
var inst_30838 = cljs.core.nth.call(null,inst_30836,(1),null);
var inst_30839 = cljs.core._EQ_.call(null,inst_30838,inst_30830);
var state_30917__$1 = (function (){var statearr_30932 = state_30917;
(statearr_30932[(12)] = inst_30837);

return statearr_30932;
})();
if(inst_30839){
var statearr_30933_31001 = state_30917__$1;
(statearr_30933_31001[(1)] = (22));

} else {
var statearr_30934_31002 = state_30917__$1;
(statearr_30934_31002[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (31))){
var state_30917__$1 = state_30917;
var statearr_30935_31003 = state_30917__$1;
(statearr_30935_31003[(2)] = null);

(statearr_30935_31003[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (32))){
var inst_30898 = (state_30917[(2)]);
var state_30917__$1 = (function (){var statearr_30936 = state_30917;
(statearr_30936[(13)] = inst_30898);

return statearr_30936;
})();
var statearr_30937_31004 = state_30917__$1;
(statearr_30937_31004[(2)] = null);

(statearr_30937_31004[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (40))){
var inst_30913 = (state_30917[(2)]);
var state_30917__$1 = state_30917;
var statearr_30938_31005 = state_30917__$1;
(statearr_30938_31005[(2)] = inst_30913);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30917__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (33))){
var inst_30875 = (state_30917[(14)]);
var inst_30881 = (state_30917[(2)]);
var inst_30882 = cljs.core.nth.call(null,inst_30881,(0),null);
var inst_30883 = cljs.core.nth.call(null,inst_30881,(1),null);
var inst_30884 = cljs.core._EQ_.call(null,inst_30883,inst_30875);
var state_30917__$1 = (function (){var statearr_30939 = state_30917;
(statearr_30939[(15)] = inst_30882);

return statearr_30939;
})();
if(inst_30884){
var statearr_30940_31006 = state_30917__$1;
(statearr_30940_31006[(1)] = (34));

} else {
var statearr_30941_31007 = state_30917__$1;
(statearr_30941_31007[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (13))){
var inst_30814 = (state_30917[(16)]);
var state_30917__$1 = state_30917;
var statearr_30942_31008 = state_30917__$1;
(statearr_30942_31008[(2)] = inst_30814);

(statearr_30942_31008[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (22))){
var inst_30841 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_30842 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_30843 = cljs.core.PersistentHashMap.fromArrays(inst_30841,inst_30842);
var inst_30844 = cljs.core.ex_info.call(null,"Aborted operations",inst_30843);
var state_30917__$1 = state_30917;
var statearr_30943_31009 = state_30917__$1;
(statearr_30943_31009[(2)] = inst_30844);

(statearr_30943_31009[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (36))){
var inst_30894 = (state_30917[(2)]);
var inst_30895 = superv.async.throw_if_exception.call(null,S,inst_30894);
var state_30917__$1 = state_30917;
var statearr_30944_31010 = state_30917__$1;
(statearr_30944_31010[(2)] = inst_30895);

(statearr_30944_31010[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (29))){
var inst_30872 = (state_30917[(17)]);
var inst_30871 = (state_30917[(2)]);
var inst_30872__$1 = superv.async.throw_if_exception.call(null,S,inst_30871);
var state_30917__$1 = (function (){var statearr_30945 = state_30917;
(statearr_30945[(17)] = inst_30872__$1);

return statearr_30945;
})();
if(cljs.core.truth_(inst_30872__$1)){
var statearr_30946_31011 = state_30917__$1;
(statearr_30946_31011[(1)] = (30));

} else {
var statearr_30947_31012 = state_30917__$1;
(statearr_30947_31012[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (6))){
var inst_30794 = (state_30917[(7)]);
var inst_30800 = superv.async._track_exception.call(null,S,inst_30794);
var state_30917__$1 = state_30917;
var statearr_30948_31013 = state_30917__$1;
(statearr_30948_31013[(2)] = inst_30800);

(statearr_30948_31013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (28))){
var inst_30861 = (state_30917[(18)]);
var state_30917__$1 = state_30917;
var statearr_30949_31014 = state_30917__$1;
(statearr_30949_31014[(2)] = inst_30861);

(statearr_30949_31014[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (25))){
var inst_30847 = (state_30917[(2)]);
var state_30917__$1 = state_30917;
var statearr_30950_31015 = state_30917__$1;
(statearr_30950_31015[(2)] = inst_30847);

(statearr_30950_31015[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (34))){
var inst_30886 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_30887 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_30888 = cljs.core.PersistentHashMap.fromArrays(inst_30886,inst_30887);
var inst_30889 = cljs.core.ex_info.call(null,"Aborted operations",inst_30888);
var state_30917__$1 = state_30917;
var statearr_30951_31016 = state_30917__$1;
(statearr_30951_31016[(2)] = inst_30889);

(statearr_30951_31016[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (17))){
var inst_30904 = (state_30917[(2)]);
var state_30917__$1 = state_30917;
var statearr_30952_31017 = state_30917__$1;
(statearr_30952_31017[(2)] = inst_30904);

(statearr_30952_31017[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (3))){
var inst_30791 = (state_30917[(2)]);
var inst_30792 = superv.async._unregister_go.call(null,S,id__29654__auto___30989);
var state_30917__$1 = (function (){var statearr_30953 = state_30917;
(statearr_30953[(19)] = inst_30791);

(statearr_30953[(20)] = inst_30792);

return statearr_30953;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30917__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (12))){
var inst_30818 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_30819 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_30820 = cljs.core.PersistentHashMap.fromArrays(inst_30818,inst_30819);
var inst_30821 = cljs.core.ex_info.call(null,"Aborted operations",inst_30820);
var state_30917__$1 = state_30917;
var statearr_30954_31018 = state_30917__$1;
(statearr_30954_31018[(2)] = inst_30821);

(statearr_30954_31018[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (2))){
var inst_30915 = (state_30917[(2)]);
var state_30917__$1 = state_30917;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30917__$1,inst_30915);
} else {
if((state_val_30918 === (23))){
var inst_30825 = (state_30917[(10)]);
var state_30917__$1 = state_30917;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30917__$1,(25),out_ch,inst_30825);
} else {
if((state_val_30918 === (35))){
var inst_30872 = (state_30917[(17)]);
var state_30917__$1 = state_30917;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30917__$1,(37),out_ch,inst_30872);
} else {
if((state_val_30918 === (19))){
var inst_30825 = (state_30917[(10)]);
var inst_30854 = (state_30917[(21)]);
var inst_30854__$1 = superv.async._abort.call(null,S);
var inst_30855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30856 = f_GT_.call(null,inst_30825);
var inst_30857 = [inst_30854__$1,inst_30856];
var inst_30858 = (new cljs.core.PersistentVector(null,2,(5),inst_30855,inst_30857,null));
var state_30917__$1 = (function (){var statearr_30955 = state_30917;
(statearr_30955[(21)] = inst_30854__$1);

return statearr_30955;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30917__$1,(26),inst_30858,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_30918 === (11))){
var inst_30808 = (state_30917[(22)]);
var inst_30813 = (state_30917[(2)]);
var inst_30814 = cljs.core.nth.call(null,inst_30813,(0),null);
var inst_30815 = cljs.core.nth.call(null,inst_30813,(1),null);
var inst_30816 = cljs.core._EQ_.call(null,inst_30815,inst_30808);
var state_30917__$1 = (function (){var statearr_30956 = state_30917;
(statearr_30956[(16)] = inst_30814);

return statearr_30956;
})();
if(inst_30816){
var statearr_30957_31019 = state_30917__$1;
(statearr_30957_31019[(1)] = (12));

} else {
var statearr_30958_31020 = state_30917__$1;
(statearr_30958_31020[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (9))){
var inst_30808 = (state_30917[(22)]);
var inst_30808__$1 = superv.async._abort.call(null,S);
var inst_30809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30810 = [inst_30808__$1,in_ch];
var inst_30811 = (new cljs.core.PersistentVector(null,2,(5),inst_30809,inst_30810,null));
var state_30917__$1 = (function (){var statearr_30959 = state_30917;
(statearr_30959[(22)] = inst_30808__$1);

return statearr_30959;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30917__$1,(11),inst_30811,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_30918 === (5))){
var state_30917__$1 = state_30917;
var statearr_30960_31021 = state_30917__$1;
(statearr_30960_31021[(2)] = null);

(statearr_30960_31021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (14))){
var inst_30825 = (state_30917[(10)]);
var inst_30824 = (state_30917[(2)]);
var inst_30825__$1 = superv.async.throw_if_exception.call(null,S,inst_30824);
var state_30917__$1 = (function (){var statearr_30961 = state_30917;
(statearr_30961[(10)] = inst_30825__$1);

return statearr_30961;
})();
if(cljs.core.truth_(inst_30825__$1)){
var statearr_30962_31022 = state_30917__$1;
(statearr_30962_31022[(1)] = (15));

} else {
var statearr_30963_31023 = state_30917__$1;
(statearr_30963_31023[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (26))){
var inst_30854 = (state_30917[(21)]);
var inst_30860 = (state_30917[(2)]);
var inst_30861 = cljs.core.nth.call(null,inst_30860,(0),null);
var inst_30862 = cljs.core.nth.call(null,inst_30860,(1),null);
var inst_30863 = cljs.core._EQ_.call(null,inst_30862,inst_30854);
var state_30917__$1 = (function (){var statearr_30964 = state_30917;
(statearr_30964[(18)] = inst_30861);

return statearr_30964;
})();
if(inst_30863){
var statearr_30965_31024 = state_30917__$1;
(statearr_30965_31024[(1)] = (27));

} else {
var statearr_30966_31025 = state_30917__$1;
(statearr_30966_31025[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (16))){
var state_30917__$1 = state_30917;
var statearr_30967_31026 = state_30917__$1;
(statearr_30967_31026[(2)] = null);

(statearr_30967_31026[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (38))){
var inst_30910 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_30917__$1 = state_30917;
var statearr_30968_31027 = state_30917__$1;
(statearr_30968_31027[(2)] = inst_30910);

(statearr_30968_31027[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (30))){
var inst_30875 = (state_30917[(14)]);
var inst_30875__$1 = superv.async._abort.call(null,S);
var inst_30876 = cljs.core.async.timeout.call(null,(0));
var inst_30877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30878 = [inst_30875__$1,inst_30876];
var inst_30879 = (new cljs.core.PersistentVector(null,2,(5),inst_30877,inst_30878,null));
var state_30917__$1 = (function (){var statearr_30969 = state_30917;
(statearr_30969[(14)] = inst_30875__$1);

return statearr_30969;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30917__$1,(33),inst_30879,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_30918 === (10))){
var inst_30906 = (state_30917[(2)]);
var inst_30907 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_30908 = (inst_30907 === (0));
var state_30917__$1 = (function (){var statearr_30970 = state_30917;
(statearr_30970[(23)] = inst_30906);

return statearr_30970;
})();
if(cljs.core.truth_(inst_30908)){
var statearr_30971_31028 = state_30917__$1;
(statearr_30971_31028[(1)] = (38));

} else {
var statearr_30972_31029 = state_30917__$1;
(statearr_30972_31029[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (18))){
var inst_30830 = (state_30917[(11)]);
var inst_30830__$1 = superv.async._abort.call(null,S);
var inst_30831 = cljs.core.async.timeout.call(null,(0));
var inst_30832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30833 = [inst_30830__$1,inst_30831];
var inst_30834 = (new cljs.core.PersistentVector(null,2,(5),inst_30832,inst_30833,null));
var state_30917__$1 = (function (){var statearr_30973 = state_30917;
(statearr_30973[(11)] = inst_30830__$1);

return statearr_30973;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30917__$1,(21),inst_30834,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_30918 === (37))){
var inst_30892 = (state_30917[(2)]);
var state_30917__$1 = state_30917;
var statearr_30974_31030 = state_30917__$1;
(statearr_30974_31030[(2)] = inst_30892);

(statearr_30974_31030[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30918 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_30917,(4),Error,(3),(2));
var state_30917__$1 = state_30917;
var statearr_30975_31031 = state_30917__$1;
(statearr_30975_31031[(2)] = null);

(statearr_30975_31031[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__30988,c__26717__auto___30990,id__29654__auto___30989,n__25465__auto___30987,threads))
;
return ((function (__30988,switch__26605__auto__,c__26717__auto___30990,id__29654__auto___30989,n__25465__auto___30987,threads){
return (function() {
var superv$async$state_machine__26606__auto__ = null;
var superv$async$state_machine__26606__auto____0 = (function (){
var statearr_30979 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30979[(0)] = superv$async$state_machine__26606__auto__);

(statearr_30979[(1)] = (1));

return statearr_30979;
});
var superv$async$state_machine__26606__auto____1 = (function (state_30917){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_30917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e30980){if((e30980 instanceof Object)){
var ex__26609__auto__ = e30980;
var statearr_30981_31032 = state_30917;
(statearr_30981_31032[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30917);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30980;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31033 = state_30917;
state_30917 = G__31033;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
superv$async$state_machine__26606__auto__ = function(state_30917){
switch(arguments.length){
case 0:
return superv$async$state_machine__26606__auto____0.call(this);
case 1:
return superv$async$state_machine__26606__auto____1.call(this,state_30917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__26606__auto____0;
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__26606__auto____1;
return superv$async$state_machine__26606__auto__;
})()
;})(__30988,switch__26605__auto__,c__26717__auto___30990,id__29654__auto___30989,n__25465__auto___30987,threads))
})();
var state__26719__auto__ = (function (){var statearr_30982 = f__26718__auto__.call(null);
(statearr_30982[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___30990);

return statearr_30982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(__30988,c__26717__auto___30990,id__29654__auto___30989,n__25465__auto___30987,threads))
);


var G__31034 = (__30988 + (1));
__30988 = G__31034;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;
/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__25627__auto__ = [];
var len__25620__auto___31113 = arguments.length;
var i__25621__auto___31114 = (0);
while(true){
if((i__25621__auto___31114 < len__25620__auto___31113)){
args__25627__auto__.push((arguments[i__25621__auto___31114]));

var G__31115 = (i__25621__auto___31114 + (1));
i__25621__auto___31114 = G__31115;
continue;
} else {
}
break;
}

var argseq__25628__auto__ = ((((1) < args__25627__auto__.length))?(new cljs.core.IndexedSeq(args__25627__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__25628__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var id__29654__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__26717__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto__,id__29654__auto__,ch){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto__,id__29654__auto__,ch){
return (function (state_31082){
var state_val_31083 = (state_31082[(1)]);
if((state_val_31083 === (7))){
var inst_31040 = (state_31082[(7)]);
var inst_31048 = (state_31082[(2)]);
var state_31082__$1 = (function (){var statearr_31084 = state_31082;
(statearr_31084[(8)] = inst_31048);

return statearr_31084;
})();
var statearr_31085_31116 = state_31082__$1;
(statearr_31085_31116[(2)] = inst_31040);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31082__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (1))){
var state_31082__$1 = state_31082;
var statearr_31086_31117 = state_31082__$1;
(statearr_31086_31117[(2)] = null);

(statearr_31086_31117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (4))){
var inst_31040 = (state_31082[(7)]);
var inst_31040__$1 = (state_31082[(2)]);
var inst_31041 = cljs.core.ex_data.call(null,inst_31040__$1);
var inst_31042 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_31041);
var inst_31043 = cljs.core._EQ_.call(null,inst_31042,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_31082__$1 = (function (){var statearr_31087 = state_31082;
(statearr_31087[(7)] = inst_31040__$1);

return statearr_31087;
})();
if(inst_31043){
var statearr_31088_31118 = state_31082__$1;
(statearr_31088_31118[(1)] = (5));

} else {
var statearr_31089_31119 = state_31082__$1;
(statearr_31089_31119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (15))){
var state_31082__$1 = state_31082;
var statearr_31090_31120 = state_31082__$1;
(statearr_31090_31120[(2)] = null);

(statearr_31090_31120[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (13))){
var inst_31060 = (state_31082[(9)]);
var state_31082__$1 = state_31082;
var statearr_31091_31121 = state_31082__$1;
(statearr_31091_31121[(2)] = inst_31060);

(statearr_31091_31121[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (6))){
var inst_31040 = (state_31082[(7)]);
var inst_31046 = superv.async._track_exception.call(null,S,inst_31040);
var state_31082__$1 = state_31082;
var statearr_31092_31122 = state_31082__$1;
(statearr_31092_31122[(2)] = inst_31046);

(statearr_31092_31122[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (17))){
var inst_31076 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31093_31123 = state_31082__$1;
(statearr_31093_31123[(2)] = inst_31076);

(statearr_31093_31123[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (3))){
var inst_31037 = (state_31082[(2)]);
var inst_31038 = superv.async._unregister_go.call(null,S,id__29654__auto__);
var state_31082__$1 = (function (){var statearr_31094 = state_31082;
(statearr_31094[(10)] = inst_31038);

(statearr_31094[(11)] = inst_31037);

return statearr_31094;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31082__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (12))){
var inst_31064 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31065 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31066 = cljs.core.PersistentHashMap.fromArrays(inst_31064,inst_31065);
var inst_31067 = cljs.core.ex_info.call(null,"Aborted operations",inst_31066);
var state_31082__$1 = state_31082;
var statearr_31095_31124 = state_31082__$1;
(statearr_31095_31124[(2)] = inst_31067);

(statearr_31095_31124[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (2))){
var inst_31080 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31082__$1,inst_31080);
} else {
if((state_val_31083 === (11))){
var inst_31054 = (state_31082[(12)]);
var inst_31059 = (state_31082[(2)]);
var inst_31060 = cljs.core.nth.call(null,inst_31059,(0),null);
var inst_31061 = cljs.core.nth.call(null,inst_31059,(1),null);
var inst_31062 = cljs.core._EQ_.call(null,inst_31061,inst_31054);
var state_31082__$1 = (function (){var statearr_31096 = state_31082;
(statearr_31096[(9)] = inst_31060);

return statearr_31096;
})();
if(inst_31062){
var statearr_31097_31125 = state_31082__$1;
(statearr_31097_31125[(1)] = (12));

} else {
var statearr_31098_31126 = state_31082__$1;
(statearr_31098_31126[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (9))){
var inst_31054 = (state_31082[(12)]);
var inst_31054__$1 = superv.async._abort.call(null,S);
var inst_31055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31056 = [inst_31054__$1,ch];
var inst_31057 = (new cljs.core.PersistentVector(null,2,(5),inst_31055,inst_31056,null));
var state_31082__$1 = (function (){var statearr_31099 = state_31082;
(statearr_31099[(12)] = inst_31054__$1);

return statearr_31099;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31082__$1,(11),inst_31057,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_31083 === (5))){
var state_31082__$1 = state_31082;
var statearr_31100_31127 = state_31082__$1;
(statearr_31100_31127[(2)] = null);

(statearr_31100_31127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (14))){
var inst_31070 = (state_31082[(2)]);
var inst_31071 = superv.async.throw_if_exception.call(null,S,inst_31070);
var state_31082__$1 = state_31082;
if(cljs.core.truth_(inst_31071)){
var statearr_31101_31128 = state_31082__$1;
(statearr_31101_31128[(1)] = (15));

} else {
var statearr_31102_31129 = state_31082__$1;
(statearr_31102_31129[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (16))){
var state_31082__$1 = state_31082;
var statearr_31103_31130 = state_31082__$1;
(statearr_31103_31130[(2)] = null);

(statearr_31103_31130[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (10))){
var inst_31078 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31104_31131 = state_31082__$1;
(statearr_31104_31131[(2)] = inst_31078);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31082__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31083 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31082,(4),Error,(3),(2));
var state_31082__$1 = state_31082;
var statearr_31105_31132 = state_31082__$1;
(statearr_31105_31132[(2)] = null);

(statearr_31105_31132[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto__,id__29654__auto__,ch))
;
return ((function (switch__26605__auto__,c__26717__auto__,id__29654__auto__,ch){
return (function() {
var superv$async$state_machine__26606__auto__ = null;
var superv$async$state_machine__26606__auto____0 = (function (){
var statearr_31109 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31109[(0)] = superv$async$state_machine__26606__auto__);

(statearr_31109[(1)] = (1));

return statearr_31109;
});
var superv$async$state_machine__26606__auto____1 = (function (state_31082){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_31082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e31110){if((e31110 instanceof Object)){
var ex__26609__auto__ = e31110;
var statearr_31111_31133 = state_31082;
(statearr_31111_31133[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31082);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31134 = state_31082;
state_31082 = G__31134;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
superv$async$state_machine__26606__auto__ = function(state_31082){
switch(arguments.length){
case 0:
return superv$async$state_machine__26606__auto____0.call(this);
case 1:
return superv$async$state_machine__26606__auto____1.call(this,state_31082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__26606__auto____0;
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__26606__auto____1;
return superv$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto__,id__29654__auto__,ch))
})();
var state__26719__auto__ = (function (){var statearr_31112 = f__26718__auto__.call(null);
(statearr_31112[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto__);

return statearr_31112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto__,id__29654__auto__,ch))
);

return c__26717__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq31035){
var G__31036 = cljs.core.first.call(null,seq31035);
var seq31035__$1 = cljs.core.next.call(null,seq31035);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__31036,seq31035__$1);
});
/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var id__29654__auto___31485 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__26717__auto___31486 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___31486,id__29654__auto___31485,result){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___31486,id__29654__auto___31485,result){
return (function (state_31427){
var state_val_31428 = (state_31427[(1)]);
if((state_val_31428 === (7))){
var inst_31313 = (state_31427[(7)]);
var inst_31321 = (state_31427[(2)]);
var state_31427__$1 = (function (){var statearr_31429 = state_31427;
(statearr_31429[(8)] = inst_31321);

return statearr_31429;
})();
var statearr_31430_31487 = state_31427__$1;
(statearr_31430_31487[(2)] = inst_31313);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31427__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (20))){
var inst_31395 = (state_31427[(2)]);
var state_31427__$1 = state_31427;
var statearr_31431_31488 = state_31427__$1;
(statearr_31431_31488[(2)] = inst_31395);

(statearr_31431_31488[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (27))){
var inst_31385 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31386 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31387 = cljs.core.PersistentHashMap.fromArrays(inst_31385,inst_31386);
var inst_31388 = cljs.core.ex_info.call(null,"Aborted operations",inst_31387);
var state_31427__$1 = state_31427;
var statearr_31432_31489 = state_31427__$1;
(statearr_31432_31489[(2)] = inst_31388);

(statearr_31432_31489[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (1))){
var state_31427__$1 = state_31427;
var statearr_31433_31490 = state_31427__$1;
(statearr_31433_31490[(2)] = null);

(statearr_31433_31490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (24))){
var inst_31369 = (state_31427[(2)]);
var inst_31370 = superv.async.throw_if_exception.call(null,S,inst_31369);
var inst_31371 = cljs.core.async.close_BANG_.call(null,result);
var state_31427__$1 = (function (){var statearr_31434 = state_31427;
(statearr_31434[(9)] = inst_31370);

return statearr_31434;
})();
var statearr_31435_31491 = state_31427__$1;
(statearr_31435_31491[(2)] = inst_31371);

(statearr_31435_31491[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (4))){
var inst_31313 = (state_31427[(7)]);
var inst_31313__$1 = (state_31427[(2)]);
var inst_31314 = cljs.core.ex_data.call(null,inst_31313__$1);
var inst_31315 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_31314);
var inst_31316 = cljs.core._EQ_.call(null,inst_31315,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_31427__$1 = (function (){var statearr_31436 = state_31427;
(statearr_31436[(7)] = inst_31313__$1);

return statearr_31436;
})();
if(inst_31316){
var statearr_31437_31492 = state_31427__$1;
(statearr_31437_31492[(1)] = (5));

} else {
var statearr_31438_31493 = state_31427__$1;
(statearr_31438_31493[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (15))){
var inst_31345 = (state_31427[(10)]);
var inst_31347 = (inst_31345 instanceof Error);
var state_31427__$1 = state_31427;
if(cljs.core.truth_(inst_31347)){
var statearr_31439_31494 = state_31427__$1;
(statearr_31439_31494[(1)] = (18));

} else {
var statearr_31440_31495 = state_31427__$1;
(statearr_31440_31495[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (21))){
var inst_31350 = (state_31427[(11)]);
var inst_31356 = (state_31427[(2)]);
var inst_31357 = cljs.core.nth.call(null,inst_31356,(0),null);
var inst_31358 = cljs.core.nth.call(null,inst_31356,(1),null);
var inst_31359 = cljs.core._EQ_.call(null,inst_31358,inst_31350);
var state_31427__$1 = (function (){var statearr_31441 = state_31427;
(statearr_31441[(12)] = inst_31357);

return statearr_31441;
})();
if(inst_31359){
var statearr_31442_31496 = state_31427__$1;
(statearr_31442_31496[(1)] = (22));

} else {
var statearr_31443_31497 = state_31427__$1;
(statearr_31443_31497[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (31))){
var inst_31409 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31410 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31411 = cljs.core.PersistentHashMap.fromArrays(inst_31409,inst_31410);
var inst_31412 = cljs.core.ex_info.call(null,"Aborted operations",inst_31411);
var state_31427__$1 = state_31427;
var statearr_31444_31498 = state_31427__$1;
(statearr_31444_31498[(2)] = inst_31412);

(statearr_31444_31498[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (32))){
var inst_31325 = (state_31427[(13)]);
var state_31427__$1 = state_31427;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31427__$1,(34),result,inst_31325);
} else {
if((state_val_31428 === (33))){
var inst_31417 = (state_31427[(2)]);
var inst_31418 = superv.async.throw_if_exception.call(null,S,inst_31417);
var inst_31419 = cljs.core.async.close_BANG_.call(null,result);
var state_31427__$1 = (function (){var statearr_31445 = state_31427;
(statearr_31445[(14)] = inst_31418);

return statearr_31445;
})();
var statearr_31446_31499 = state_31427__$1;
(statearr_31446_31499[(2)] = inst_31419);

(statearr_31446_31499[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (13))){
var inst_31334 = (state_31427[(15)]);
var state_31427__$1 = state_31427;
var statearr_31447_31500 = state_31427__$1;
(statearr_31447_31500[(2)] = inst_31334);

(statearr_31447_31500[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (22))){
var inst_31361 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31362 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31363 = cljs.core.PersistentHashMap.fromArrays(inst_31361,inst_31362);
var inst_31364 = cljs.core.ex_info.call(null,"Aborted operations",inst_31363);
var state_31427__$1 = state_31427;
var statearr_31448_31501 = state_31427__$1;
(statearr_31448_31501[(2)] = inst_31364);

(statearr_31448_31501[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (29))){
var inst_31391 = (state_31427[(2)]);
var inst_31392 = superv.async.throw_if_exception.call(null,S,inst_31391);
var inst_31325 = inst_31392;
var state_31427__$1 = (function (){var statearr_31449 = state_31427;
(statearr_31449[(13)] = inst_31325);

return statearr_31449;
})();
var statearr_31450_31502 = state_31427__$1;
(statearr_31450_31502[(2)] = null);

(statearr_31450_31502[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (6))){
var inst_31313 = (state_31427[(7)]);
var inst_31319 = superv.async._track_exception.call(null,S,inst_31313);
var state_31427__$1 = state_31427;
var statearr_31451_31503 = state_31427__$1;
(statearr_31451_31503[(2)] = inst_31319);

(statearr_31451_31503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (28))){
var inst_31381 = (state_31427[(16)]);
var state_31427__$1 = state_31427;
var statearr_31452_31504 = state_31427__$1;
(statearr_31452_31504[(2)] = inst_31381);

(statearr_31452_31504[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (25))){
var inst_31367 = (state_31427[(2)]);
var state_31427__$1 = state_31427;
var statearr_31453_31505 = state_31427__$1;
(statearr_31453_31505[(2)] = inst_31367);

(statearr_31453_31505[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (34))){
var inst_31415 = (state_31427[(2)]);
var state_31427__$1 = state_31427;
var statearr_31454_31506 = state_31427__$1;
(statearr_31454_31506[(2)] = inst_31415);

(statearr_31454_31506[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (17))){
var inst_31421 = (state_31427[(2)]);
var state_31427__$1 = state_31427;
var statearr_31455_31507 = state_31427__$1;
(statearr_31455_31507[(2)] = inst_31421);

(statearr_31455_31507[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (3))){
var inst_31310 = (state_31427[(2)]);
var inst_31311 = superv.async._unregister_go.call(null,S,id__29654__auto___31485);
var state_31427__$1 = (function (){var statearr_31456 = state_31427;
(statearr_31456[(17)] = inst_31310);

(statearr_31456[(18)] = inst_31311);

return statearr_31456;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31427__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (12))){
var inst_31338 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31339 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31340 = cljs.core.PersistentHashMap.fromArrays(inst_31338,inst_31339);
var inst_31341 = cljs.core.ex_info.call(null,"Aborted operations",inst_31340);
var state_31427__$1 = state_31427;
var statearr_31457_31508 = state_31427__$1;
(statearr_31457_31508[(2)] = inst_31341);

(statearr_31457_31508[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (2))){
var inst_31425 = (state_31427[(2)]);
var state_31427__$1 = state_31427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31427__$1,inst_31425);
} else {
if((state_val_31428 === (23))){
var inst_31345 = (state_31427[(10)]);
var state_31427__$1 = state_31427;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31427__$1,(25),result,inst_31345);
} else {
if((state_val_31428 === (19))){
var inst_31345 = (state_31427[(10)]);
var inst_31325 = (state_31427[(13)]);
var inst_31374 = (state_31427[(19)]);
var inst_31374__$1 = superv.async._abort.call(null,S);
var inst_31375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31376 = f_GT_.call(null,inst_31325,inst_31345);
var inst_31377 = [inst_31374__$1,inst_31376];
var inst_31378 = (new cljs.core.PersistentVector(null,2,(5),inst_31375,inst_31377,null));
var state_31427__$1 = (function (){var statearr_31458 = state_31427;
(statearr_31458[(19)] = inst_31374__$1);

return statearr_31458;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31427__$1,(26),inst_31378,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_31428 === (11))){
var inst_31328 = (state_31427[(20)]);
var inst_31333 = (state_31427[(2)]);
var inst_31334 = cljs.core.nth.call(null,inst_31333,(0),null);
var inst_31335 = cljs.core.nth.call(null,inst_31333,(1),null);
var inst_31336 = cljs.core._EQ_.call(null,inst_31335,inst_31328);
var state_31427__$1 = (function (){var statearr_31459 = state_31427;
(statearr_31459[(15)] = inst_31334);

return statearr_31459;
})();
if(inst_31336){
var statearr_31460_31509 = state_31427__$1;
(statearr_31460_31509[(1)] = (12));

} else {
var statearr_31461_31510 = state_31427__$1;
(statearr_31461_31510[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (9))){
var inst_31328 = (state_31427[(20)]);
var inst_31328__$1 = superv.async._abort.call(null,S);
var inst_31329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31330 = [inst_31328__$1,ch];
var inst_31331 = (new cljs.core.PersistentVector(null,2,(5),inst_31329,inst_31330,null));
var state_31427__$1 = (function (){var statearr_31462 = state_31427;
(statearr_31462[(20)] = inst_31328__$1);

return statearr_31462;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31427__$1,(11),inst_31331,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_31428 === (5))){
var state_31427__$1 = state_31427;
var statearr_31463_31511 = state_31427__$1;
(statearr_31463_31511[(2)] = null);

(statearr_31463_31511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (14))){
var inst_31345 = (state_31427[(10)]);
var inst_31344 = (state_31427[(2)]);
var inst_31345__$1 = superv.async.throw_if_exception.call(null,S,inst_31344);
var state_31427__$1 = (function (){var statearr_31464 = state_31427;
(statearr_31464[(10)] = inst_31345__$1);

return statearr_31464;
})();
if(cljs.core.truth_(inst_31345__$1)){
var statearr_31465_31512 = state_31427__$1;
(statearr_31465_31512[(1)] = (15));

} else {
var statearr_31466_31513 = state_31427__$1;
(statearr_31466_31513[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (26))){
var inst_31374 = (state_31427[(19)]);
var inst_31380 = (state_31427[(2)]);
var inst_31381 = cljs.core.nth.call(null,inst_31380,(0),null);
var inst_31382 = cljs.core.nth.call(null,inst_31380,(1),null);
var inst_31383 = cljs.core._EQ_.call(null,inst_31382,inst_31374);
var state_31427__$1 = (function (){var statearr_31467 = state_31427;
(statearr_31467[(16)] = inst_31381);

return statearr_31467;
})();
if(inst_31383){
var statearr_31468_31514 = state_31427__$1;
(statearr_31468_31514[(1)] = (27));

} else {
var statearr_31469_31515 = state_31427__$1;
(statearr_31469_31515[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (16))){
var inst_31398 = (state_31427[(21)]);
var inst_31398__$1 = superv.async._abort.call(null,S);
var inst_31399 = cljs.core.async.timeout.call(null,(0));
var inst_31400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31401 = [inst_31398__$1,inst_31399];
var inst_31402 = (new cljs.core.PersistentVector(null,2,(5),inst_31400,inst_31401,null));
var state_31427__$1 = (function (){var statearr_31470 = state_31427;
(statearr_31470[(21)] = inst_31398__$1);

return statearr_31470;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31427__$1,(30),inst_31402,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_31428 === (30))){
var inst_31398 = (state_31427[(21)]);
var inst_31404 = (state_31427[(2)]);
var inst_31405 = cljs.core.nth.call(null,inst_31404,(0),null);
var inst_31406 = cljs.core.nth.call(null,inst_31404,(1),null);
var inst_31407 = cljs.core._EQ_.call(null,inst_31406,inst_31398);
var state_31427__$1 = (function (){var statearr_31471 = state_31427;
(statearr_31471[(22)] = inst_31405);

return statearr_31471;
})();
if(inst_31407){
var statearr_31472_31516 = state_31427__$1;
(statearr_31472_31516[(1)] = (31));

} else {
var statearr_31473_31517 = state_31427__$1;
(statearr_31473_31517[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (10))){
var inst_31423 = (state_31427[(2)]);
var state_31427__$1 = state_31427;
var statearr_31474_31518 = state_31427__$1;
(statearr_31474_31518[(2)] = inst_31423);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31427__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31428 === (18))){
var inst_31350 = (state_31427[(11)]);
var inst_31350__$1 = superv.async._abort.call(null,S);
var inst_31351 = cljs.core.async.timeout.call(null,(0));
var inst_31352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31353 = [inst_31350__$1,inst_31351];
var inst_31354 = (new cljs.core.PersistentVector(null,2,(5),inst_31352,inst_31353,null));
var state_31427__$1 = (function (){var statearr_31475 = state_31427;
(statearr_31475[(11)] = inst_31350__$1);

return statearr_31475;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31427__$1,(21),inst_31354,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_31428 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31427,(4),Error,(3),(2));
var inst_31325 = acc;
var state_31427__$1 = (function (){var statearr_31476 = state_31427;
(statearr_31476[(13)] = inst_31325);

return statearr_31476;
})();
var statearr_31477_31519 = state_31427__$1;
(statearr_31477_31519[(2)] = null);

(statearr_31477_31519[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___31486,id__29654__auto___31485,result))
;
return ((function (switch__26605__auto__,c__26717__auto___31486,id__29654__auto___31485,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__26606__auto__ = null;
var superv$async$reduce_GT__$_state_machine__26606__auto____0 = (function (){
var statearr_31481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31481[(0)] = superv$async$reduce_GT__$_state_machine__26606__auto__);

(statearr_31481[(1)] = (1));

return statearr_31481;
});
var superv$async$reduce_GT__$_state_machine__26606__auto____1 = (function (state_31427){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_31427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e31482){if((e31482 instanceof Object)){
var ex__26609__auto__ = e31482;
var statearr_31483_31520 = state_31427;
(statearr_31483_31520[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31427);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31482;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31521 = state_31427;
state_31427 = G__31521;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__26606__auto__ = function(state_31427){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__26606__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__26606__auto____1.call(this,state_31427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_GT__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__26606__auto____0;
superv$async$reduce_GT__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__26606__auto____1;
return superv$async$reduce_GT__$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___31486,id__29654__auto___31485,result))
})();
var state__26719__auto__ = (function (){var statearr_31484 = f__26718__auto__.call(null);
(statearr_31484[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___31486);

return statearr_31484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___31486,id__29654__auto___31485,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__25627__auto__ = [];
var len__25620__auto___31647 = arguments.length;
var i__25621__auto___31648 = (0);
while(true){
if((i__25621__auto___31648 < len__25620__auto___31647)){
args__25627__auto__.push((arguments[i__25621__auto___31648]));

var G__31649 = (i__25621__auto___31648 + (1));
i__25621__auto___31648 = G__31649;
continue;
} else {
}
break;
}

var argseq__25628__auto__ = ((((1) < args__25627__auto__.length))?(new cljs.core.IndexedSeq(args__25627__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__25628__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var id__29654__auto___31650 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__26717__auto___31651 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___31651,id__29654__auto___31650,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___31651,id__29654__auto___31650,out){
return (function (state_31600){
var state_val_31601 = (state_31600[(1)]);
if((state_val_31601 === (7))){
var inst_31527 = (state_31600[(7)]);
var inst_31535 = (state_31600[(2)]);
var state_31600__$1 = (function (){var statearr_31603 = state_31600;
(statearr_31603[(8)] = inst_31535);

return statearr_31603;
})();
var statearr_31604_31652 = state_31600__$1;
(statearr_31604_31652[(2)] = inst_31527);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31600__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (20))){
var inst_31590 = (state_31600[(2)]);
var state_31600__$1 = state_31600;
var statearr_31605_31653 = state_31600__$1;
(statearr_31605_31653[(2)] = inst_31590);

(statearr_31605_31653[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (1))){
var state_31600__$1 = state_31600;
var statearr_31606_31654 = state_31600__$1;
(statearr_31606_31654[(2)] = null);

(statearr_31606_31654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (24))){
var inst_31539 = (state_31600[(9)]);
var inst_31583 = (state_31600[(2)]);
var inst_31584 = superv.async.throw_if_exception.call(null,S,inst_31583);
var tmp31602 = inst_31539;
var inst_31539__$1 = tmp31602;
var state_31600__$1 = (function (){var statearr_31607 = state_31600;
(statearr_31607[(10)] = inst_31584);

(statearr_31607[(9)] = inst_31539__$1);

return statearr_31607;
})();
var statearr_31608_31655 = state_31600__$1;
(statearr_31608_31655[(2)] = null);

(statearr_31608_31655[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (4))){
var inst_31527 = (state_31600[(7)]);
var inst_31527__$1 = (state_31600[(2)]);
var inst_31528 = cljs.core.ex_data.call(null,inst_31527__$1);
var inst_31529 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_31528);
var inst_31530 = cljs.core._EQ_.call(null,inst_31529,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_31600__$1 = (function (){var statearr_31609 = state_31600;
(statearr_31609[(7)] = inst_31527__$1);

return statearr_31609;
})();
if(inst_31530){
var statearr_31610_31656 = state_31600__$1;
(statearr_31610_31656[(1)] = (5));

} else {
var statearr_31611_31657 = state_31600__$1;
(statearr_31611_31657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (15))){
var inst_31554 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31555 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31556 = cljs.core.PersistentHashMap.fromArrays(inst_31554,inst_31555);
var inst_31557 = cljs.core.ex_info.call(null,"Aborted operations",inst_31556);
var state_31600__$1 = state_31600;
var statearr_31612_31658 = state_31600__$1;
(statearr_31612_31658[(2)] = inst_31557);

(statearr_31612_31658[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (21))){
var inst_31564 = (state_31600[(11)]);
var inst_31570 = (state_31600[(2)]);
var inst_31571 = cljs.core.nth.call(null,inst_31570,(0),null);
var inst_31572 = cljs.core.nth.call(null,inst_31570,(1),null);
var inst_31573 = cljs.core._EQ_.call(null,inst_31572,inst_31564);
var state_31600__$1 = (function (){var statearr_31613 = state_31600;
(statearr_31613[(12)] = inst_31571);

return statearr_31613;
})();
if(inst_31573){
var statearr_31614_31659 = state_31600__$1;
(statearr_31614_31659[(1)] = (22));

} else {
var statearr_31615_31660 = state_31600__$1;
(statearr_31615_31660[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (13))){
var inst_31594 = (state_31600[(2)]);
var state_31600__$1 = state_31600;
var statearr_31616_31661 = state_31600__$1;
(statearr_31616_31661[(2)] = inst_31594);

(statearr_31616_31661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (22))){
var inst_31575 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31576 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31577 = cljs.core.PersistentHashMap.fromArrays(inst_31575,inst_31576);
var inst_31578 = cljs.core.ex_info.call(null,"Aborted operations",inst_31577);
var state_31600__$1 = state_31600;
var statearr_31617_31662 = state_31600__$1;
(statearr_31617_31662[(2)] = inst_31578);

(statearr_31617_31662[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (6))){
var inst_31527 = (state_31600[(7)]);
var inst_31533 = superv.async._track_exception.call(null,S,inst_31527);
var state_31600__$1 = state_31600;
var statearr_31618_31663 = state_31600__$1;
(statearr_31618_31663[(2)] = inst_31533);

(statearr_31618_31663[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (25))){
var inst_31581 = (state_31600[(2)]);
var state_31600__$1 = state_31600;
var statearr_31619_31664 = state_31600__$1;
(statearr_31619_31664[(2)] = inst_31581);

(statearr_31619_31664[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (17))){
var inst_31561 = (state_31600[(13)]);
var inst_31560 = (state_31600[(2)]);
var inst_31561__$1 = superv.async.throw_if_exception.call(null,S,inst_31560);
var state_31600__$1 = (function (){var statearr_31620 = state_31600;
(statearr_31620[(13)] = inst_31561__$1);

return statearr_31620;
})();
if(cljs.core.truth_(inst_31561__$1)){
var statearr_31621_31665 = state_31600__$1;
(statearr_31621_31665[(1)] = (18));

} else {
var statearr_31622_31666 = state_31600__$1;
(statearr_31622_31666[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (3))){
var inst_31524 = (state_31600[(2)]);
var inst_31525 = superv.async._unregister_go.call(null,S,id__29654__auto___31650);
var state_31600__$1 = (function (){var statearr_31623 = state_31600;
(statearr_31623[(14)] = inst_31525);

(statearr_31623[(15)] = inst_31524);

return statearr_31623;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31600__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (12))){
var inst_31592 = cljs.core.async.close_BANG_.call(null,out);
var state_31600__$1 = state_31600;
var statearr_31624_31667 = state_31600__$1;
(statearr_31624_31667[(2)] = inst_31592);

(statearr_31624_31667[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (2))){
var inst_31598 = (state_31600[(2)]);
var state_31600__$1 = state_31600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31600__$1,inst_31598);
} else {
if((state_val_31601 === (23))){
var inst_31561 = (state_31600[(13)]);
var state_31600__$1 = state_31600;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31600__$1,(25),out,inst_31561);
} else {
if((state_val_31601 === (19))){
var inst_31539 = (state_31600[(9)]);
var inst_31587 = cljs.core.rest.call(null,inst_31539);
var inst_31539__$1 = inst_31587;
var state_31600__$1 = (function (){var statearr_31625 = state_31600;
(statearr_31625[(9)] = inst_31539__$1);

return statearr_31625;
})();
var statearr_31626_31668 = state_31600__$1;
(statearr_31626_31668[(2)] = null);

(statearr_31626_31668[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (11))){
var inst_31541 = (state_31600[(16)]);
var inst_31544 = (state_31600[(17)]);
var inst_31544__$1 = superv.async._abort.call(null,S);
var inst_31545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31546 = [inst_31544__$1,inst_31541];
var inst_31547 = (new cljs.core.PersistentVector(null,2,(5),inst_31545,inst_31546,null));
var state_31600__$1 = (function (){var statearr_31627 = state_31600;
(statearr_31627[(17)] = inst_31544__$1);

return statearr_31627;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31600__$1,(14),inst_31547,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_31601 === (9))){
var inst_31541 = (state_31600[(16)]);
var inst_31539 = (state_31600[(9)]);
var inst_31541__$1 = cljs.core.first.call(null,inst_31539);
var state_31600__$1 = (function (){var statearr_31628 = state_31600;
(statearr_31628[(16)] = inst_31541__$1);

return statearr_31628;
})();
if(cljs.core.truth_(inst_31541__$1)){
var statearr_31629_31669 = state_31600__$1;
(statearr_31629_31669[(1)] = (11));

} else {
var statearr_31630_31670 = state_31600__$1;
(statearr_31630_31670[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (5))){
var state_31600__$1 = state_31600;
var statearr_31631_31671 = state_31600__$1;
(statearr_31631_31671[(2)] = null);

(statearr_31631_31671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (14))){
var inst_31544 = (state_31600[(17)]);
var inst_31549 = (state_31600[(2)]);
var inst_31550 = cljs.core.nth.call(null,inst_31549,(0),null);
var inst_31551 = cljs.core.nth.call(null,inst_31549,(1),null);
var inst_31552 = cljs.core._EQ_.call(null,inst_31551,inst_31544);
var state_31600__$1 = (function (){var statearr_31632 = state_31600;
(statearr_31632[(18)] = inst_31550);

return statearr_31632;
})();
if(inst_31552){
var statearr_31633_31672 = state_31600__$1;
(statearr_31633_31672[(1)] = (15));

} else {
var statearr_31634_31673 = state_31600__$1;
(statearr_31634_31673[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (16))){
var inst_31550 = (state_31600[(18)]);
var state_31600__$1 = state_31600;
var statearr_31635_31674 = state_31600__$1;
(statearr_31635_31674[(2)] = inst_31550);

(statearr_31635_31674[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (10))){
var inst_31596 = (state_31600[(2)]);
var state_31600__$1 = state_31600;
var statearr_31636_31675 = state_31600__$1;
(statearr_31636_31675[(2)] = inst_31596);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31600__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31601 === (18))){
var inst_31564 = (state_31600[(11)]);
var inst_31564__$1 = superv.async._abort.call(null,S);
var inst_31565 = cljs.core.async.timeout.call(null,(0));
var inst_31566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31567 = [inst_31564__$1,inst_31565];
var inst_31568 = (new cljs.core.PersistentVector(null,2,(5),inst_31566,inst_31567,null));
var state_31600__$1 = (function (){var statearr_31637 = state_31600;
(statearr_31637[(11)] = inst_31564__$1);

return statearr_31637;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31600__$1,(21),inst_31568,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_31601 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31600,(4),Error,(3),(2));
var inst_31539 = cs;
var state_31600__$1 = (function (){var statearr_31638 = state_31600;
(statearr_31638[(9)] = inst_31539);

return statearr_31638;
})();
var statearr_31639_31676 = state_31600__$1;
(statearr_31639_31676[(2)] = null);

(statearr_31639_31676[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___31651,id__29654__auto___31650,out))
;
return ((function (switch__26605__auto__,c__26717__auto___31651,id__29654__auto___31650,out){
return (function() {
var superv$async$state_machine__26606__auto__ = null;
var superv$async$state_machine__26606__auto____0 = (function (){
var statearr_31643 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31643[(0)] = superv$async$state_machine__26606__auto__);

(statearr_31643[(1)] = (1));

return statearr_31643;
});
var superv$async$state_machine__26606__auto____1 = (function (state_31600){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_31600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e31644){if((e31644 instanceof Object)){
var ex__26609__auto__ = e31644;
var statearr_31645_31677 = state_31600;
(statearr_31645_31677[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31600);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31644;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31678 = state_31600;
state_31600 = G__31678;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
superv$async$state_machine__26606__auto__ = function(state_31600){
switch(arguments.length){
case 0:
return superv$async$state_machine__26606__auto____0.call(this);
case 1:
return superv$async$state_machine__26606__auto____1.call(this,state_31600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__26606__auto____0;
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__26606__auto____1;
return superv$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___31651,id__29654__auto___31650,out))
})();
var state__26719__auto__ = (function (){var statearr_31646 = f__26718__auto__.call(null);
(statearr_31646[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___31651);

return statearr_31646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___31651,id__29654__auto___31650,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq31522){
var G__31523 = cljs.core.first.call(null,seq31522);
var seq31522__$1 = cljs.core.next.call(null,seq31522);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__31523,seq31522__$1);
});
superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__25627__auto__ = [];
var len__25620__auto___31888 = arguments.length;
var i__25621__auto___31889 = (0);
while(true){
if((i__25621__auto___31889 < len__25620__auto___31888)){
args__25627__auto__.push((arguments[i__25621__auto___31889]));

var G__31890 = (i__25621__auto___31889 + (1));
i__25621__auto___31889 = G__31890;
continue;
} else {
}
break;
}

var argseq__25628__auto__ = ((((3) < args__25627__auto__.length))?(new cljs.core.IndexedSeq(args__25627__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__25628__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__31683){
var map__31684 = p__31683;
var map__31684__$1 = ((((!((map__31684 == null)))?((((map__31684.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31684.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31684):map__31684);
var out_ch = cljs.core.get.call(null,map__31684__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__24551__auto__ = out_ch;
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var id__29654__auto___31891 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__26717__auto___31892 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___31892,id__29654__auto___31891,out_ch__$1,map__31684,map__31684__$1,out_ch){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___31892,id__29654__auto___31891,out_ch__$1,map__31684,map__31684__$1,out_ch){
return (function (state_31820){
var state_val_31821 = (state_31820[(1)]);
if((state_val_31821 === (7))){
var inst_31689 = (state_31820[(7)]);
var inst_31697 = (state_31820[(2)]);
var state_31820__$1 = (function (){var statearr_31822 = state_31820;
(statearr_31822[(8)] = inst_31697);

return statearr_31822;
})();
var statearr_31823_31893 = state_31820__$1;
(statearr_31823_31893[(2)] = inst_31689);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31820__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (20))){
var inst_31783 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
var statearr_31824_31894 = state_31820__$1;
(statearr_31824_31894[(2)] = inst_31783);

(statearr_31824_31894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (27))){
var inst_31750 = (state_31820[(9)]);
var inst_31702 = inst_31750;
var state_31820__$1 = (function (){var statearr_31825 = state_31820;
(statearr_31825[(10)] = inst_31702);

return statearr_31825;
})();
var statearr_31826_31895 = state_31820__$1;
(statearr_31826_31895[(2)] = null);

(statearr_31826_31895[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (1))){
var state_31820__$1 = state_31820;
var statearr_31827_31896 = state_31820__$1;
(statearr_31827_31896[(2)] = null);

(statearr_31827_31896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (24))){
var inst_31746 = (state_31820[(2)]);
var inst_31747 = superv.async.throw_if_exception.call(null,S,inst_31746);
var inst_31748 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_31820__$1 = (function (){var statearr_31828 = state_31820;
(statearr_31828[(11)] = inst_31747);

return statearr_31828;
})();
var statearr_31829_31897 = state_31820__$1;
(statearr_31829_31897[(2)] = inst_31748);

(statearr_31829_31897[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (39))){
var inst_31702 = (state_31820[(10)]);
var state_31820__$1 = state_31820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31820__$1,(41),out_ch__$1,inst_31702);
} else {
if((state_val_31821 === (4))){
var inst_31689 = (state_31820[(7)]);
var inst_31689__$1 = (state_31820[(2)]);
var inst_31690 = cljs.core.ex_data.call(null,inst_31689__$1);
var inst_31691 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_31690);
var inst_31692 = cljs.core._EQ_.call(null,inst_31691,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_31820__$1 = (function (){var statearr_31830 = state_31820;
(statearr_31830[(7)] = inst_31689__$1);

return statearr_31830;
})();
if(inst_31692){
var statearr_31831_31898 = state_31820__$1;
(statearr_31831_31898[(1)] = (5));

} else {
var statearr_31832_31899 = state_31820__$1;
(statearr_31832_31899[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (15))){
var inst_31722 = (state_31820[(12)]);
var inst_31724 = (inst_31722 instanceof Error);
var state_31820__$1 = state_31820;
if(cljs.core.truth_(inst_31724)){
var statearr_31833_31900 = state_31820__$1;
(statearr_31833_31900[(1)] = (18));

} else {
var statearr_31834_31901 = state_31820__$1;
(statearr_31834_31901[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (21))){
var inst_31727 = (state_31820[(13)]);
var inst_31733 = (state_31820[(2)]);
var inst_31734 = cljs.core.nth.call(null,inst_31733,(0),null);
var inst_31735 = cljs.core.nth.call(null,inst_31733,(1),null);
var inst_31736 = cljs.core._EQ_.call(null,inst_31735,inst_31727);
var state_31820__$1 = (function (){var statearr_31835 = state_31820;
(statearr_31835[(14)] = inst_31734);

return statearr_31835;
})();
if(inst_31736){
var statearr_31836_31902 = state_31820__$1;
(statearr_31836_31902[(1)] = (22));

} else {
var statearr_31837_31903 = state_31820__$1;
(statearr_31837_31903[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (31))){
var inst_31750 = (state_31820[(9)]);
var state_31820__$1 = state_31820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31820__$1,(33),out_ch__$1,inst_31750);
} else {
if((state_val_31821 === (32))){
var inst_31774 = (state_31820[(2)]);
var inst_31775 = superv.async.throw_if_exception.call(null,S,inst_31774);
var inst_31776 = cljs.core.PersistentVector.EMPTY;
var inst_31702 = inst_31776;
var state_31820__$1 = (function (){var statearr_31838 = state_31820;
(statearr_31838[(10)] = inst_31702);

(statearr_31838[(15)] = inst_31775);

return statearr_31838;
})();
var statearr_31839_31904 = state_31820__$1;
(statearr_31839_31904[(2)] = null);

(statearr_31839_31904[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (40))){
var inst_31807 = (state_31820[(2)]);
var inst_31808 = superv.async.throw_if_exception.call(null,S,inst_31807);
var state_31820__$1 = state_31820;
var statearr_31840_31905 = state_31820__$1;
(statearr_31840_31905[(2)] = inst_31808);

(statearr_31840_31905[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (33))){
var inst_31772 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
var statearr_31841_31906 = state_31820__$1;
(statearr_31841_31906[(2)] = inst_31772);

(statearr_31841_31906[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (13))){
var inst_31711 = (state_31820[(16)]);
var state_31820__$1 = state_31820;
var statearr_31842_31907 = state_31820__$1;
(statearr_31842_31907[(2)] = inst_31711);

(statearr_31842_31907[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (22))){
var inst_31738 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31739 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31740 = cljs.core.PersistentHashMap.fromArrays(inst_31738,inst_31739);
var inst_31741 = cljs.core.ex_info.call(null,"Aborted operations",inst_31740);
var state_31820__$1 = state_31820;
var statearr_31843_31908 = state_31820__$1;
(statearr_31843_31908[(2)] = inst_31741);

(statearr_31843_31908[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (36))){
var inst_31811 = (state_31820[(2)]);
var inst_31812 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_31820__$1 = (function (){var statearr_31844 = state_31820;
(statearr_31844[(17)] = inst_31811);

return statearr_31844;
})();
var statearr_31845_31909 = state_31820__$1;
(statearr_31845_31909[(2)] = inst_31812);

(statearr_31845_31909[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (41))){
var inst_31805 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
var statearr_31846_31910 = state_31820__$1;
(statearr_31846_31910[(2)] = inst_31805);

(statearr_31846_31910[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (29))){
var inst_31755 = (state_31820[(18)]);
var inst_31761 = (state_31820[(2)]);
var inst_31762 = cljs.core.nth.call(null,inst_31761,(0),null);
var inst_31763 = cljs.core.nth.call(null,inst_31761,(1),null);
var inst_31764 = cljs.core._EQ_.call(null,inst_31763,inst_31755);
var state_31820__$1 = (function (){var statearr_31847 = state_31820;
(statearr_31847[(19)] = inst_31762);

return statearr_31847;
})();
if(inst_31764){
var statearr_31848_31911 = state_31820__$1;
(statearr_31848_31911[(1)] = (30));

} else {
var statearr_31849_31912 = state_31820__$1;
(statearr_31849_31912[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (6))){
var inst_31689 = (state_31820[(7)]);
var inst_31695 = superv.async._track_exception.call(null,S,inst_31689);
var state_31820__$1 = state_31820;
var statearr_31850_31913 = state_31820__$1;
(statearr_31850_31913[(2)] = inst_31695);

(statearr_31850_31913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (28))){
var inst_31781 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
var statearr_31851_31914 = state_31820__$1;
(statearr_31851_31914[(2)] = inst_31781);

(statearr_31851_31914[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (25))){
var inst_31744 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
var statearr_31852_31915 = state_31820__$1;
(statearr_31852_31915[(2)] = inst_31744);

(statearr_31852_31915[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (34))){
var inst_31788 = (state_31820[(20)]);
var inst_31788__$1 = superv.async._abort.call(null,S);
var inst_31789 = cljs.core.async.timeout.call(null,(0));
var inst_31790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31791 = [inst_31788__$1,inst_31789];
var inst_31792 = (new cljs.core.PersistentVector(null,2,(5),inst_31790,inst_31791,null));
var state_31820__$1 = (function (){var statearr_31853 = state_31820;
(statearr_31853[(20)] = inst_31788__$1);

return statearr_31853;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31820__$1,(37),inst_31792,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_31821 === (17))){
var inst_31814 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
var statearr_31854_31916 = state_31820__$1;
(statearr_31854_31916[(2)] = inst_31814);

(statearr_31854_31916[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (3))){
var inst_31686 = (state_31820[(2)]);
var inst_31687 = superv.async._unregister_go.call(null,S,id__29654__auto___31891);
var state_31820__$1 = (function (){var statearr_31855 = state_31820;
(statearr_31855[(21)] = inst_31687);

(statearr_31855[(22)] = inst_31686);

return statearr_31855;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31820__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (12))){
var inst_31715 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31716 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31717 = cljs.core.PersistentHashMap.fromArrays(inst_31715,inst_31716);
var inst_31718 = cljs.core.ex_info.call(null,"Aborted operations",inst_31717);
var state_31820__$1 = state_31820;
var statearr_31856_31917 = state_31820__$1;
(statearr_31856_31917[(2)] = inst_31718);

(statearr_31856_31917[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (2))){
var inst_31818 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31820__$1,inst_31818);
} else {
if((state_val_31821 === (23))){
var inst_31722 = (state_31820[(12)]);
var state_31820__$1 = state_31820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31820__$1,(25),out_ch__$1,inst_31722);
} else {
if((state_val_31821 === (35))){
var state_31820__$1 = state_31820;
var statearr_31857_31918 = state_31820__$1;
(statearr_31857_31918[(2)] = null);

(statearr_31857_31918[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (19))){
var inst_31702 = (state_31820[(10)]);
var inst_31722 = (state_31820[(12)]);
var inst_31750 = (state_31820[(9)]);
var inst_31750__$1 = cljs.core.conj.call(null,inst_31702,inst_31722);
var inst_31751 = cljs.core.count.call(null,inst_31750__$1);
var inst_31752 = cljs.core._EQ_.call(null,n,inst_31751);
var state_31820__$1 = (function (){var statearr_31858 = state_31820;
(statearr_31858[(9)] = inst_31750__$1);

return statearr_31858;
})();
if(inst_31752){
var statearr_31859_31919 = state_31820__$1;
(statearr_31859_31919[(1)] = (26));

} else {
var statearr_31860_31920 = state_31820__$1;
(statearr_31860_31920[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (11))){
var inst_31705 = (state_31820[(23)]);
var inst_31710 = (state_31820[(2)]);
var inst_31711 = cljs.core.nth.call(null,inst_31710,(0),null);
var inst_31712 = cljs.core.nth.call(null,inst_31710,(1),null);
var inst_31713 = cljs.core._EQ_.call(null,inst_31712,inst_31705);
var state_31820__$1 = (function (){var statearr_31861 = state_31820;
(statearr_31861[(16)] = inst_31711);

return statearr_31861;
})();
if(inst_31713){
var statearr_31862_31921 = state_31820__$1;
(statearr_31862_31921[(1)] = (12));

} else {
var statearr_31863_31922 = state_31820__$1;
(statearr_31863_31922[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (9))){
var inst_31705 = (state_31820[(23)]);
var inst_31705__$1 = superv.async._abort.call(null,S);
var inst_31706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31707 = [inst_31705__$1,in_ch];
var inst_31708 = (new cljs.core.PersistentVector(null,2,(5),inst_31706,inst_31707,null));
var state_31820__$1 = (function (){var statearr_31864 = state_31820;
(statearr_31864[(23)] = inst_31705__$1);

return statearr_31864;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31820__$1,(11),inst_31708,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_31821 === (5))){
var state_31820__$1 = state_31820;
var statearr_31865_31923 = state_31820__$1;
(statearr_31865_31923[(2)] = null);

(statearr_31865_31923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (14))){
var inst_31722 = (state_31820[(12)]);
var inst_31721 = (state_31820[(2)]);
var inst_31722__$1 = superv.async.throw_if_exception.call(null,S,inst_31721);
var state_31820__$1 = (function (){var statearr_31866 = state_31820;
(statearr_31866[(12)] = inst_31722__$1);

return statearr_31866;
})();
if(cljs.core.truth_(inst_31722__$1)){
var statearr_31867_31924 = state_31820__$1;
(statearr_31867_31924[(1)] = (15));

} else {
var statearr_31868_31925 = state_31820__$1;
(statearr_31868_31925[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (26))){
var inst_31755 = (state_31820[(18)]);
var inst_31755__$1 = superv.async._abort.call(null,S);
var inst_31756 = cljs.core.async.timeout.call(null,(0));
var inst_31757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31758 = [inst_31755__$1,inst_31756];
var inst_31759 = (new cljs.core.PersistentVector(null,2,(5),inst_31757,inst_31758,null));
var state_31820__$1 = (function (){var statearr_31869 = state_31820;
(statearr_31869[(18)] = inst_31755__$1);

return statearr_31869;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31820__$1,(29),inst_31759,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_31821 === (16))){
var inst_31702 = (state_31820[(10)]);
var inst_31785 = cljs.core.not_empty.call(null,inst_31702);
var state_31820__$1 = state_31820;
if(cljs.core.truth_(inst_31785)){
var statearr_31870_31926 = state_31820__$1;
(statearr_31870_31926[(1)] = (34));

} else {
var statearr_31871_31927 = state_31820__$1;
(statearr_31871_31927[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (38))){
var inst_31799 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31800 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31801 = cljs.core.PersistentHashMap.fromArrays(inst_31799,inst_31800);
var inst_31802 = cljs.core.ex_info.call(null,"Aborted operations",inst_31801);
var state_31820__$1 = state_31820;
var statearr_31872_31928 = state_31820__$1;
(statearr_31872_31928[(2)] = inst_31802);

(statearr_31872_31928[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (30))){
var inst_31766 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_31767 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_31768 = cljs.core.PersistentHashMap.fromArrays(inst_31766,inst_31767);
var inst_31769 = cljs.core.ex_info.call(null,"Aborted operations",inst_31768);
var state_31820__$1 = state_31820;
var statearr_31873_31929 = state_31820__$1;
(statearr_31873_31929[(2)] = inst_31769);

(statearr_31873_31929[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (10))){
var inst_31816 = (state_31820[(2)]);
var state_31820__$1 = state_31820;
var statearr_31874_31930 = state_31820__$1;
(statearr_31874_31930[(2)] = inst_31816);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31820__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (18))){
var inst_31727 = (state_31820[(13)]);
var inst_31727__$1 = superv.async._abort.call(null,S);
var inst_31728 = cljs.core.async.timeout.call(null,(0));
var inst_31729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31730 = [inst_31727__$1,inst_31728];
var inst_31731 = (new cljs.core.PersistentVector(null,2,(5),inst_31729,inst_31730,null));
var state_31820__$1 = (function (){var statearr_31875 = state_31820;
(statearr_31875[(13)] = inst_31727__$1);

return statearr_31875;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31820__$1,(21),inst_31731,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_31821 === (37))){
var inst_31788 = (state_31820[(20)]);
var inst_31794 = (state_31820[(2)]);
var inst_31795 = cljs.core.nth.call(null,inst_31794,(0),null);
var inst_31796 = cljs.core.nth.call(null,inst_31794,(1),null);
var inst_31797 = cljs.core._EQ_.call(null,inst_31796,inst_31788);
var state_31820__$1 = (function (){var statearr_31876 = state_31820;
(statearr_31876[(24)] = inst_31795);

return statearr_31876;
})();
if(inst_31797){
var statearr_31877_31931 = state_31820__$1;
(statearr_31877_31931[(1)] = (38));

} else {
var statearr_31878_31932 = state_31820__$1;
(statearr_31878_31932[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31821 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31820,(4),Error,(3),(2));
var inst_31701 = cljs.core.PersistentVector.EMPTY;
var inst_31702 = inst_31701;
var state_31820__$1 = (function (){var statearr_31879 = state_31820;
(statearr_31879[(10)] = inst_31702);

return statearr_31879;
})();
var statearr_31880_31933 = state_31820__$1;
(statearr_31880_31933[(2)] = null);

(statearr_31880_31933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___31892,id__29654__auto___31891,out_ch__$1,map__31684,map__31684__$1,out_ch))
;
return ((function (switch__26605__auto__,c__26717__auto___31892,id__29654__auto___31891,out_ch__$1,map__31684,map__31684__$1,out_ch){
return (function() {
var superv$async$state_machine__26606__auto__ = null;
var superv$async$state_machine__26606__auto____0 = (function (){
var statearr_31884 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31884[(0)] = superv$async$state_machine__26606__auto__);

(statearr_31884[(1)] = (1));

return statearr_31884;
});
var superv$async$state_machine__26606__auto____1 = (function (state_31820){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_31820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e31885){if((e31885 instanceof Object)){
var ex__26609__auto__ = e31885;
var statearr_31886_31934 = state_31820;
(statearr_31886_31934[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31820);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31935 = state_31820;
state_31820 = G__31935;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
superv$async$state_machine__26606__auto__ = function(state_31820){
switch(arguments.length){
case 0:
return superv$async$state_machine__26606__auto____0.call(this);
case 1:
return superv$async$state_machine__26606__auto____1.call(this,state_31820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__26606__auto____0;
superv$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__26606__auto____1;
return superv$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___31892,id__29654__auto___31891,out_ch__$1,map__31684,map__31684__$1,out_ch))
})();
var state__26719__auto__ = (function (){var statearr_31887 = f__26718__auto__.call(null);
(statearr_31887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___31892);

return statearr_31887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___31892,id__29654__auto___31891,out_ch__$1,map__31684,map__31684__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq31679){
var G__31680 = cljs.core.first.call(null,seq31679);
var seq31679__$1 = cljs.core.next.call(null,seq31679);
var G__31681 = cljs.core.first.call(null,seq31679__$1);
var seq31679__$2 = cljs.core.next.call(null,seq31679__$1);
var G__31682 = cljs.core.first.call(null,seq31679__$2);
var seq31679__$3 = cljs.core.next.call(null,seq31679__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__31680,G__31681,G__31682,seq31679__$3);
});
/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});

//# sourceMappingURL=async.js.map?rel=1477097018685