// Compiled by ClojureScript 1.8.34 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args26762 = [];
var len__25620__auto___26768 = arguments.length;
var i__25621__auto___26769 = (0);
while(true){
if((i__25621__auto___26769 < len__25620__auto___26768)){
args26762.push((arguments[i__25621__auto___26769]));

var G__26770 = (i__25621__auto___26769 + (1));
i__25621__auto___26769 = G__26770;
continue;
} else {
}
break;
}

var G__26764 = args26762.length;
switch (G__26764) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26762.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async26765 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26765 = (function (f,blockable,meta26766){
this.f = f;
this.blockable = blockable;
this.meta26766 = meta26766;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26767,meta26766__$1){
var self__ = this;
var _26767__$1 = this;
return (new cljs.core.async.t_cljs$core$async26765(self__.f,self__.blockable,meta26766__$1));
});

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26767){
var self__ = this;
var _26767__$1 = this;
return self__.meta26766;
});

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async26765.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta26766","meta26766",2133586506,null)], null);
});

cljs.core.async.t_cljs$core$async26765.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26765.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26765";

cljs.core.async.t_cljs$core$async26765.cljs$lang$ctorPrWriter = (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async26765");
});

cljs.core.async.__GT_t_cljs$core$async26765 = (function cljs$core$async$__GT_t_cljs$core$async26765(f__$1,blockable__$1,meta26766){
return (new cljs.core.async.t_cljs$core$async26765(f__$1,blockable__$1,meta26766));
});

}

return (new cljs.core.async.t_cljs$core$async26765(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args26774 = [];
var len__25620__auto___26777 = arguments.length;
var i__25621__auto___26778 = (0);
while(true){
if((i__25621__auto___26778 < len__25620__auto___26777)){
args26774.push((arguments[i__25621__auto___26778]));

var G__26779 = (i__25621__auto___26778 + (1));
i__25621__auto___26778 = G__26779;
continue;
} else {
}
break;
}

var G__26776 = args26774.length;
switch (G__26776) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26774.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args26781 = [];
var len__25620__auto___26784 = arguments.length;
var i__25621__auto___26785 = (0);
while(true){
if((i__25621__auto___26785 < len__25620__auto___26784)){
args26781.push((arguments[i__25621__auto___26785]));

var G__26786 = (i__25621__auto___26785 + (1));
i__25621__auto___26785 = G__26786;
continue;
} else {
}
break;
}

var G__26783 = args26781.length;
switch (G__26783) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26781.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args26788 = [];
var len__25620__auto___26791 = arguments.length;
var i__25621__auto___26792 = (0);
while(true){
if((i__25621__auto___26792 < len__25620__auto___26791)){
args26788.push((arguments[i__25621__auto___26792]));

var G__26793 = (i__25621__auto___26792 + (1));
i__25621__auto___26792 = G__26793;
continue;
} else {
}
break;
}

var G__26790 = args26788.length;
switch (G__26790) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26788.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_26795 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_26795);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_26795,ret){
return (function (){
return fn1.call(null,val_26795);
});})(val_26795,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args26796 = [];
var len__25620__auto___26799 = arguments.length;
var i__25621__auto___26800 = (0);
while(true){
if((i__25621__auto___26800 < len__25620__auto___26799)){
args26796.push((arguments[i__25621__auto___26800]));

var G__26801 = (i__25621__auto___26800 + (1));
i__25621__auto___26800 = G__26801;
continue;
} else {
}
break;
}

var G__26798 = args26796.length;
switch (G__26798) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26796.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__25465__auto___26803 = n;
var x_26804 = (0);
while(true){
if((x_26804 < n__25465__auto___26803)){
(a[x_26804] = (0));

var G__26805 = (x_26804 + (1));
x_26804 = G__26805;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__26806 = (i + (1));
i = G__26806;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async26810 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26810 = (function (alt_flag,flag,meta26811){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta26811 = meta26811;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_26812,meta26811__$1){
var self__ = this;
var _26812__$1 = this;
return (new cljs.core.async.t_cljs$core$async26810(self__.alt_flag,self__.flag,meta26811__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async26810.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_26812){
var self__ = this;
var _26812__$1 = this;
return self__.meta26811;
});})(flag))
;

cljs.core.async.t_cljs$core$async26810.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async26810.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async26810.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26810.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26810.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta26811","meta26811",1605423030,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async26810.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26810.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26810";

cljs.core.async.t_cljs$core$async26810.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async26810");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async26810 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async26810(alt_flag__$1,flag__$1,meta26811){
return (new cljs.core.async.t_cljs$core$async26810(alt_flag__$1,flag__$1,meta26811));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async26810(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async26816 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26816 = (function (alt_handler,flag,cb,meta26817){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta26817 = meta26817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26818,meta26817__$1){
var self__ = this;
var _26818__$1 = this;
return (new cljs.core.async.t_cljs$core$async26816(self__.alt_handler,self__.flag,self__.cb,meta26817__$1));
});

cljs.core.async.t_cljs$core$async26816.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26818){
var self__ = this;
var _26818__$1 = this;
return self__.meta26817;
});

cljs.core.async.t_cljs$core$async26816.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async26816.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async26816.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26816.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async26816.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta26817","meta26817",-633949033,null)], null);
});

cljs.core.async.t_cljs$core$async26816.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26816.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26816";

cljs.core.async.t_cljs$core$async26816.cljs$lang$ctorPrWriter = (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async26816");
});

cljs.core.async.__GT_t_cljs$core$async26816 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async26816(alt_handler__$1,flag__$1,cb__$1,meta26817){
return (new cljs.core.async.t_cljs$core$async26816(alt_handler__$1,flag__$1,cb__$1,meta26817));
});

}

return (new cljs.core.async.t_cljs$core$async26816(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26819_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26819_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26820_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26820_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__24551__auto__ = wport;
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
return port;
}
})()], null));
} else {
var G__26821 = (i + (1));
i = G__26821;
continue;
}
} else {
return null;
}
break;
}
})();
var or__24551__auto__ = ret;
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__24539__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__24539__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__24539__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__25627__auto__ = [];
var len__25620__auto___26827 = arguments.length;
var i__25621__auto___26828 = (0);
while(true){
if((i__25621__auto___26828 < len__25620__auto___26827)){
args__25627__auto__.push((arguments[i__25621__auto___26828]));

var G__26829 = (i__25621__auto___26828 + (1));
i__25621__auto___26828 = G__26829;
continue;
} else {
}
break;
}

var argseq__25628__auto__ = ((((1) < args__25627__auto__.length))?(new cljs.core.IndexedSeq(args__25627__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__25628__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__26824){
var map__26825 = p__26824;
var map__26825__$1 = ((((!((map__26825 == null)))?((((map__26825.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26825.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26825):map__26825);
var opts = map__26825__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq26822){
var G__26823 = cljs.core.first.call(null,seq26822);
var seq26822__$1 = cljs.core.next.call(null,seq26822);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26823,seq26822__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args26830 = [];
var len__25620__auto___26880 = arguments.length;
var i__25621__auto___26881 = (0);
while(true){
if((i__25621__auto___26881 < len__25620__auto___26880)){
args26830.push((arguments[i__25621__auto___26881]));

var G__26882 = (i__25621__auto___26881 + (1));
i__25621__auto___26881 = G__26882;
continue;
} else {
}
break;
}

var G__26832 = args26830.length;
switch (G__26832) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26830.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__26717__auto___26884 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___26884){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___26884){
return (function (state_26856){
var state_val_26857 = (state_26856[(1)]);
if((state_val_26857 === (7))){
var inst_26852 = (state_26856[(2)]);
var state_26856__$1 = state_26856;
var statearr_26858_26885 = state_26856__$1;
(statearr_26858_26885[(2)] = inst_26852);

(statearr_26858_26885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (1))){
var state_26856__$1 = state_26856;
var statearr_26859_26886 = state_26856__$1;
(statearr_26859_26886[(2)] = null);

(statearr_26859_26886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (4))){
var inst_26835 = (state_26856[(7)]);
var inst_26835__$1 = (state_26856[(2)]);
var inst_26836 = (inst_26835__$1 == null);
var state_26856__$1 = (function (){var statearr_26860 = state_26856;
(statearr_26860[(7)] = inst_26835__$1);

return statearr_26860;
})();
if(cljs.core.truth_(inst_26836)){
var statearr_26861_26887 = state_26856__$1;
(statearr_26861_26887[(1)] = (5));

} else {
var statearr_26862_26888 = state_26856__$1;
(statearr_26862_26888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (13))){
var state_26856__$1 = state_26856;
var statearr_26863_26889 = state_26856__$1;
(statearr_26863_26889[(2)] = null);

(statearr_26863_26889[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (6))){
var inst_26835 = (state_26856[(7)]);
var state_26856__$1 = state_26856;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26856__$1,(11),to,inst_26835);
} else {
if((state_val_26857 === (3))){
var inst_26854 = (state_26856[(2)]);
var state_26856__$1 = state_26856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26856__$1,inst_26854);
} else {
if((state_val_26857 === (12))){
var state_26856__$1 = state_26856;
var statearr_26864_26890 = state_26856__$1;
(statearr_26864_26890[(2)] = null);

(statearr_26864_26890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (2))){
var state_26856__$1 = state_26856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26856__$1,(4),from);
} else {
if((state_val_26857 === (11))){
var inst_26845 = (state_26856[(2)]);
var state_26856__$1 = state_26856;
if(cljs.core.truth_(inst_26845)){
var statearr_26865_26891 = state_26856__$1;
(statearr_26865_26891[(1)] = (12));

} else {
var statearr_26866_26892 = state_26856__$1;
(statearr_26866_26892[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (9))){
var state_26856__$1 = state_26856;
var statearr_26867_26893 = state_26856__$1;
(statearr_26867_26893[(2)] = null);

(statearr_26867_26893[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (5))){
var state_26856__$1 = state_26856;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26868_26894 = state_26856__$1;
(statearr_26868_26894[(1)] = (8));

} else {
var statearr_26869_26895 = state_26856__$1;
(statearr_26869_26895[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (14))){
var inst_26850 = (state_26856[(2)]);
var state_26856__$1 = state_26856;
var statearr_26870_26896 = state_26856__$1;
(statearr_26870_26896[(2)] = inst_26850);

(statearr_26870_26896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (10))){
var inst_26842 = (state_26856[(2)]);
var state_26856__$1 = state_26856;
var statearr_26871_26897 = state_26856__$1;
(statearr_26871_26897[(2)] = inst_26842);

(statearr_26871_26897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26857 === (8))){
var inst_26839 = cljs.core.async.close_BANG_.call(null,to);
var state_26856__$1 = state_26856;
var statearr_26872_26898 = state_26856__$1;
(statearr_26872_26898[(2)] = inst_26839);

(statearr_26872_26898[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___26884))
;
return ((function (switch__26605__auto__,c__26717__auto___26884){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_26876 = [null,null,null,null,null,null,null,null];
(statearr_26876[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_26876[(1)] = (1));

return statearr_26876;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_26856){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_26856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e26877){if((e26877 instanceof Object)){
var ex__26609__auto__ = e26877;
var statearr_26878_26899 = state_26856;
(statearr_26878_26899[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26877;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26900 = state_26856;
state_26856 = G__26900;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_26856){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_26856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___26884))
})();
var state__26719__auto__ = (function (){var statearr_26879 = f__26718__auto__.call(null);
(statearr_26879[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___26884);

return statearr_26879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___26884))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__27084){
var vec__27085 = p__27084;
var v = cljs.core.nth.call(null,vec__27085,(0),null);
var p = cljs.core.nth.call(null,vec__27085,(1),null);
var job = vec__27085;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__26717__auto___27267 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___27267,res,vec__27085,v,p,job,jobs,results){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___27267,res,vec__27085,v,p,job,jobs,results){
return (function (state_27090){
var state_val_27091 = (state_27090[(1)]);
if((state_val_27091 === (1))){
var state_27090__$1 = state_27090;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27090__$1,(2),res,v);
} else {
if((state_val_27091 === (2))){
var inst_27087 = (state_27090[(2)]);
var inst_27088 = cljs.core.async.close_BANG_.call(null,res);
var state_27090__$1 = (function (){var statearr_27092 = state_27090;
(statearr_27092[(7)] = inst_27087);

return statearr_27092;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27090__$1,inst_27088);
} else {
return null;
}
}
});})(c__26717__auto___27267,res,vec__27085,v,p,job,jobs,results))
;
return ((function (switch__26605__auto__,c__26717__auto___27267,res,vec__27085,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0 = (function (){
var statearr_27096 = [null,null,null,null,null,null,null,null];
(statearr_27096[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__);

(statearr_27096[(1)] = (1));

return statearr_27096;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1 = (function (state_27090){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27097){if((e27097 instanceof Object)){
var ex__26609__auto__ = e27097;
var statearr_27098_27268 = state_27090;
(statearr_27098_27268[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27090);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27097;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27269 = state_27090;
state_27090 = G__27269;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = function(state_27090){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1.call(this,state_27090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___27267,res,vec__27085,v,p,job,jobs,results))
})();
var state__26719__auto__ = (function (){var statearr_27099 = f__26718__auto__.call(null);
(statearr_27099[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___27267);

return statearr_27099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___27267,res,vec__27085,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__27100){
var vec__27101 = p__27100;
var v = cljs.core.nth.call(null,vec__27101,(0),null);
var p = cljs.core.nth.call(null,vec__27101,(1),null);
var job = vec__27101;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__25465__auto___27270 = n;
var __27271 = (0);
while(true){
if((__27271 < n__25465__auto___27270)){
var G__27102_27272 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__27102_27272) {
case "compute":
var c__26717__auto___27274 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__27271,c__26717__auto___27274,G__27102_27272,n__25465__auto___27270,jobs,results,process,async){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (__27271,c__26717__auto___27274,G__27102_27272,n__25465__auto___27270,jobs,results,process,async){
return (function (state_27115){
var state_val_27116 = (state_27115[(1)]);
if((state_val_27116 === (1))){
var state_27115__$1 = state_27115;
var statearr_27117_27275 = state_27115__$1;
(statearr_27117_27275[(2)] = null);

(statearr_27117_27275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (2))){
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27115__$1,(4),jobs);
} else {
if((state_val_27116 === (3))){
var inst_27113 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27115__$1,inst_27113);
} else {
if((state_val_27116 === (4))){
var inst_27105 = (state_27115[(2)]);
var inst_27106 = process.call(null,inst_27105);
var state_27115__$1 = state_27115;
if(cljs.core.truth_(inst_27106)){
var statearr_27118_27276 = state_27115__$1;
(statearr_27118_27276[(1)] = (5));

} else {
var statearr_27119_27277 = state_27115__$1;
(statearr_27119_27277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (5))){
var state_27115__$1 = state_27115;
var statearr_27120_27278 = state_27115__$1;
(statearr_27120_27278[(2)] = null);

(statearr_27120_27278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (6))){
var state_27115__$1 = state_27115;
var statearr_27121_27279 = state_27115__$1;
(statearr_27121_27279[(2)] = null);

(statearr_27121_27279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27116 === (7))){
var inst_27111 = (state_27115[(2)]);
var state_27115__$1 = state_27115;
var statearr_27122_27280 = state_27115__$1;
(statearr_27122_27280[(2)] = inst_27111);

(statearr_27122_27280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__27271,c__26717__auto___27274,G__27102_27272,n__25465__auto___27270,jobs,results,process,async))
;
return ((function (__27271,switch__26605__auto__,c__26717__auto___27274,G__27102_27272,n__25465__auto___27270,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0 = (function (){
var statearr_27126 = [null,null,null,null,null,null,null];
(statearr_27126[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__);

(statearr_27126[(1)] = (1));

return statearr_27126;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1 = (function (state_27115){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27127){if((e27127 instanceof Object)){
var ex__26609__auto__ = e27127;
var statearr_27128_27281 = state_27115;
(statearr_27128_27281[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27115);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27127;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27282 = state_27115;
state_27115 = G__27282;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = function(state_27115){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1.call(this,state_27115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__;
})()
;})(__27271,switch__26605__auto__,c__26717__auto___27274,G__27102_27272,n__25465__auto___27270,jobs,results,process,async))
})();
var state__26719__auto__ = (function (){var statearr_27129 = f__26718__auto__.call(null);
(statearr_27129[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___27274);

return statearr_27129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(__27271,c__26717__auto___27274,G__27102_27272,n__25465__auto___27270,jobs,results,process,async))
);


break;
case "async":
var c__26717__auto___27283 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__27271,c__26717__auto___27283,G__27102_27272,n__25465__auto___27270,jobs,results,process,async){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (__27271,c__26717__auto___27283,G__27102_27272,n__25465__auto___27270,jobs,results,process,async){
return (function (state_27142){
var state_val_27143 = (state_27142[(1)]);
if((state_val_27143 === (1))){
var state_27142__$1 = state_27142;
var statearr_27144_27284 = state_27142__$1;
(statearr_27144_27284[(2)] = null);

(statearr_27144_27284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (2))){
var state_27142__$1 = state_27142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27142__$1,(4),jobs);
} else {
if((state_val_27143 === (3))){
var inst_27140 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27142__$1,inst_27140);
} else {
if((state_val_27143 === (4))){
var inst_27132 = (state_27142[(2)]);
var inst_27133 = async.call(null,inst_27132);
var state_27142__$1 = state_27142;
if(cljs.core.truth_(inst_27133)){
var statearr_27145_27285 = state_27142__$1;
(statearr_27145_27285[(1)] = (5));

} else {
var statearr_27146_27286 = state_27142__$1;
(statearr_27146_27286[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (5))){
var state_27142__$1 = state_27142;
var statearr_27147_27287 = state_27142__$1;
(statearr_27147_27287[(2)] = null);

(statearr_27147_27287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (6))){
var state_27142__$1 = state_27142;
var statearr_27148_27288 = state_27142__$1;
(statearr_27148_27288[(2)] = null);

(statearr_27148_27288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (7))){
var inst_27138 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27149_27289 = state_27142__$1;
(statearr_27149_27289[(2)] = inst_27138);

(statearr_27149_27289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__27271,c__26717__auto___27283,G__27102_27272,n__25465__auto___27270,jobs,results,process,async))
;
return ((function (__27271,switch__26605__auto__,c__26717__auto___27283,G__27102_27272,n__25465__auto___27270,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0 = (function (){
var statearr_27153 = [null,null,null,null,null,null,null];
(statearr_27153[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__);

(statearr_27153[(1)] = (1));

return statearr_27153;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1 = (function (state_27142){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27154){if((e27154 instanceof Object)){
var ex__26609__auto__ = e27154;
var statearr_27155_27290 = state_27142;
(statearr_27155_27290[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27142);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27154;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27291 = state_27142;
state_27142 = G__27291;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = function(state_27142){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1.call(this,state_27142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__;
})()
;})(__27271,switch__26605__auto__,c__26717__auto___27283,G__27102_27272,n__25465__auto___27270,jobs,results,process,async))
})();
var state__26719__auto__ = (function (){var statearr_27156 = f__26718__auto__.call(null);
(statearr_27156[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___27283);

return statearr_27156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(__27271,c__26717__auto___27283,G__27102_27272,n__25465__auto___27270,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__27292 = (__27271 + (1));
__27271 = G__27292;
continue;
} else {
}
break;
}

var c__26717__auto___27293 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___27293,jobs,results,process,async){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___27293,jobs,results,process,async){
return (function (state_27178){
var state_val_27179 = (state_27178[(1)]);
if((state_val_27179 === (1))){
var state_27178__$1 = state_27178;
var statearr_27180_27294 = state_27178__$1;
(statearr_27180_27294[(2)] = null);

(statearr_27180_27294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27179 === (2))){
var state_27178__$1 = state_27178;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27178__$1,(4),from);
} else {
if((state_val_27179 === (3))){
var inst_27176 = (state_27178[(2)]);
var state_27178__$1 = state_27178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27178__$1,inst_27176);
} else {
if((state_val_27179 === (4))){
var inst_27159 = (state_27178[(7)]);
var inst_27159__$1 = (state_27178[(2)]);
var inst_27160 = (inst_27159__$1 == null);
var state_27178__$1 = (function (){var statearr_27181 = state_27178;
(statearr_27181[(7)] = inst_27159__$1);

return statearr_27181;
})();
if(cljs.core.truth_(inst_27160)){
var statearr_27182_27295 = state_27178__$1;
(statearr_27182_27295[(1)] = (5));

} else {
var statearr_27183_27296 = state_27178__$1;
(statearr_27183_27296[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27179 === (5))){
var inst_27162 = cljs.core.async.close_BANG_.call(null,jobs);
var state_27178__$1 = state_27178;
var statearr_27184_27297 = state_27178__$1;
(statearr_27184_27297[(2)] = inst_27162);

(statearr_27184_27297[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27179 === (6))){
var inst_27164 = (state_27178[(8)]);
var inst_27159 = (state_27178[(7)]);
var inst_27164__$1 = cljs.core.async.chan.call(null,(1));
var inst_27165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27166 = [inst_27159,inst_27164__$1];
var inst_27167 = (new cljs.core.PersistentVector(null,2,(5),inst_27165,inst_27166,null));
var state_27178__$1 = (function (){var statearr_27185 = state_27178;
(statearr_27185[(8)] = inst_27164__$1);

return statearr_27185;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27178__$1,(8),jobs,inst_27167);
} else {
if((state_val_27179 === (7))){
var inst_27174 = (state_27178[(2)]);
var state_27178__$1 = state_27178;
var statearr_27186_27298 = state_27178__$1;
(statearr_27186_27298[(2)] = inst_27174);

(statearr_27186_27298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27179 === (8))){
var inst_27164 = (state_27178[(8)]);
var inst_27169 = (state_27178[(2)]);
var state_27178__$1 = (function (){var statearr_27187 = state_27178;
(statearr_27187[(9)] = inst_27169);

return statearr_27187;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27178__$1,(9),results,inst_27164);
} else {
if((state_val_27179 === (9))){
var inst_27171 = (state_27178[(2)]);
var state_27178__$1 = (function (){var statearr_27188 = state_27178;
(statearr_27188[(10)] = inst_27171);

return statearr_27188;
})();
var statearr_27189_27299 = state_27178__$1;
(statearr_27189_27299[(2)] = null);

(statearr_27189_27299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___27293,jobs,results,process,async))
;
return ((function (switch__26605__auto__,c__26717__auto___27293,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0 = (function (){
var statearr_27193 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27193[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__);

(statearr_27193[(1)] = (1));

return statearr_27193;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1 = (function (state_27178){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27194){if((e27194 instanceof Object)){
var ex__26609__auto__ = e27194;
var statearr_27195_27300 = state_27178;
(statearr_27195_27300[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27178);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27194;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27301 = state_27178;
state_27178 = G__27301;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = function(state_27178){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1.call(this,state_27178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___27293,jobs,results,process,async))
})();
var state__26719__auto__ = (function (){var statearr_27196 = f__26718__auto__.call(null);
(statearr_27196[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___27293);

return statearr_27196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___27293,jobs,results,process,async))
);


var c__26717__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto__,jobs,results,process,async){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto__,jobs,results,process,async){
return (function (state_27234){
var state_val_27235 = (state_27234[(1)]);
if((state_val_27235 === (7))){
var inst_27230 = (state_27234[(2)]);
var state_27234__$1 = state_27234;
var statearr_27236_27302 = state_27234__$1;
(statearr_27236_27302[(2)] = inst_27230);

(statearr_27236_27302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (20))){
var state_27234__$1 = state_27234;
var statearr_27237_27303 = state_27234__$1;
(statearr_27237_27303[(2)] = null);

(statearr_27237_27303[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (1))){
var state_27234__$1 = state_27234;
var statearr_27238_27304 = state_27234__$1;
(statearr_27238_27304[(2)] = null);

(statearr_27238_27304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (4))){
var inst_27199 = (state_27234[(7)]);
var inst_27199__$1 = (state_27234[(2)]);
var inst_27200 = (inst_27199__$1 == null);
var state_27234__$1 = (function (){var statearr_27239 = state_27234;
(statearr_27239[(7)] = inst_27199__$1);

return statearr_27239;
})();
if(cljs.core.truth_(inst_27200)){
var statearr_27240_27305 = state_27234__$1;
(statearr_27240_27305[(1)] = (5));

} else {
var statearr_27241_27306 = state_27234__$1;
(statearr_27241_27306[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (15))){
var inst_27212 = (state_27234[(8)]);
var state_27234__$1 = state_27234;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27234__$1,(18),to,inst_27212);
} else {
if((state_val_27235 === (21))){
var inst_27225 = (state_27234[(2)]);
var state_27234__$1 = state_27234;
var statearr_27242_27307 = state_27234__$1;
(statearr_27242_27307[(2)] = inst_27225);

(statearr_27242_27307[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (13))){
var inst_27227 = (state_27234[(2)]);
var state_27234__$1 = (function (){var statearr_27243 = state_27234;
(statearr_27243[(9)] = inst_27227);

return statearr_27243;
})();
var statearr_27244_27308 = state_27234__$1;
(statearr_27244_27308[(2)] = null);

(statearr_27244_27308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (6))){
var inst_27199 = (state_27234[(7)]);
var state_27234__$1 = state_27234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27234__$1,(11),inst_27199);
} else {
if((state_val_27235 === (17))){
var inst_27220 = (state_27234[(2)]);
var state_27234__$1 = state_27234;
if(cljs.core.truth_(inst_27220)){
var statearr_27245_27309 = state_27234__$1;
(statearr_27245_27309[(1)] = (19));

} else {
var statearr_27246_27310 = state_27234__$1;
(statearr_27246_27310[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (3))){
var inst_27232 = (state_27234[(2)]);
var state_27234__$1 = state_27234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27234__$1,inst_27232);
} else {
if((state_val_27235 === (12))){
var inst_27209 = (state_27234[(10)]);
var state_27234__$1 = state_27234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27234__$1,(14),inst_27209);
} else {
if((state_val_27235 === (2))){
var state_27234__$1 = state_27234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27234__$1,(4),results);
} else {
if((state_val_27235 === (19))){
var state_27234__$1 = state_27234;
var statearr_27247_27311 = state_27234__$1;
(statearr_27247_27311[(2)] = null);

(statearr_27247_27311[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (11))){
var inst_27209 = (state_27234[(2)]);
var state_27234__$1 = (function (){var statearr_27248 = state_27234;
(statearr_27248[(10)] = inst_27209);

return statearr_27248;
})();
var statearr_27249_27312 = state_27234__$1;
(statearr_27249_27312[(2)] = null);

(statearr_27249_27312[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (9))){
var state_27234__$1 = state_27234;
var statearr_27250_27313 = state_27234__$1;
(statearr_27250_27313[(2)] = null);

(statearr_27250_27313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (5))){
var state_27234__$1 = state_27234;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27251_27314 = state_27234__$1;
(statearr_27251_27314[(1)] = (8));

} else {
var statearr_27252_27315 = state_27234__$1;
(statearr_27252_27315[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (14))){
var inst_27212 = (state_27234[(8)]);
var inst_27214 = (state_27234[(11)]);
var inst_27212__$1 = (state_27234[(2)]);
var inst_27213 = (inst_27212__$1 == null);
var inst_27214__$1 = cljs.core.not.call(null,inst_27213);
var state_27234__$1 = (function (){var statearr_27253 = state_27234;
(statearr_27253[(8)] = inst_27212__$1);

(statearr_27253[(11)] = inst_27214__$1);

return statearr_27253;
})();
if(inst_27214__$1){
var statearr_27254_27316 = state_27234__$1;
(statearr_27254_27316[(1)] = (15));

} else {
var statearr_27255_27317 = state_27234__$1;
(statearr_27255_27317[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (16))){
var inst_27214 = (state_27234[(11)]);
var state_27234__$1 = state_27234;
var statearr_27256_27318 = state_27234__$1;
(statearr_27256_27318[(2)] = inst_27214);

(statearr_27256_27318[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (10))){
var inst_27206 = (state_27234[(2)]);
var state_27234__$1 = state_27234;
var statearr_27257_27319 = state_27234__$1;
(statearr_27257_27319[(2)] = inst_27206);

(statearr_27257_27319[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (18))){
var inst_27217 = (state_27234[(2)]);
var state_27234__$1 = state_27234;
var statearr_27258_27320 = state_27234__$1;
(statearr_27258_27320[(2)] = inst_27217);

(statearr_27258_27320[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27235 === (8))){
var inst_27203 = cljs.core.async.close_BANG_.call(null,to);
var state_27234__$1 = state_27234;
var statearr_27259_27321 = state_27234__$1;
(statearr_27259_27321[(2)] = inst_27203);

(statearr_27259_27321[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto__,jobs,results,process,async))
;
return ((function (switch__26605__auto__,c__26717__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0 = (function (){
var statearr_27263 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27263[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__);

(statearr_27263[(1)] = (1));

return statearr_27263;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1 = (function (state_27234){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27264){if((e27264 instanceof Object)){
var ex__26609__auto__ = e27264;
var statearr_27265_27322 = state_27234;
(statearr_27265_27322[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27234);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27264;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27323 = state_27234;
state_27234 = G__27323;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__ = function(state_27234){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1.call(this,state_27234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26606__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto__,jobs,results,process,async))
})();
var state__26719__auto__ = (function (){var statearr_27266 = f__26718__auto__.call(null);
(statearr_27266[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto__);

return statearr_27266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto__,jobs,results,process,async))
);

return c__26717__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args27324 = [];
var len__25620__auto___27327 = arguments.length;
var i__25621__auto___27328 = (0);
while(true){
if((i__25621__auto___27328 < len__25620__auto___27327)){
args27324.push((arguments[i__25621__auto___27328]));

var G__27329 = (i__25621__auto___27328 + (1));
i__25621__auto___27328 = G__27329;
continue;
} else {
}
break;
}

var G__27326 = args27324.length;
switch (G__27326) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27324.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args27331 = [];
var len__25620__auto___27334 = arguments.length;
var i__25621__auto___27335 = (0);
while(true){
if((i__25621__auto___27335 < len__25620__auto___27334)){
args27331.push((arguments[i__25621__auto___27335]));

var G__27336 = (i__25621__auto___27335 + (1));
i__25621__auto___27335 = G__27336;
continue;
} else {
}
break;
}

var G__27333 = args27331.length;
switch (G__27333) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27331.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args27338 = [];
var len__25620__auto___27391 = arguments.length;
var i__25621__auto___27392 = (0);
while(true){
if((i__25621__auto___27392 < len__25620__auto___27391)){
args27338.push((arguments[i__25621__auto___27392]));

var G__27393 = (i__25621__auto___27392 + (1));
i__25621__auto___27392 = G__27393;
continue;
} else {
}
break;
}

var G__27340 = args27338.length;
switch (G__27340) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27338.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__26717__auto___27395 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___27395,tc,fc){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___27395,tc,fc){
return (function (state_27366){
var state_val_27367 = (state_27366[(1)]);
if((state_val_27367 === (7))){
var inst_27362 = (state_27366[(2)]);
var state_27366__$1 = state_27366;
var statearr_27368_27396 = state_27366__$1;
(statearr_27368_27396[(2)] = inst_27362);

(statearr_27368_27396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (1))){
var state_27366__$1 = state_27366;
var statearr_27369_27397 = state_27366__$1;
(statearr_27369_27397[(2)] = null);

(statearr_27369_27397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (4))){
var inst_27343 = (state_27366[(7)]);
var inst_27343__$1 = (state_27366[(2)]);
var inst_27344 = (inst_27343__$1 == null);
var state_27366__$1 = (function (){var statearr_27370 = state_27366;
(statearr_27370[(7)] = inst_27343__$1);

return statearr_27370;
})();
if(cljs.core.truth_(inst_27344)){
var statearr_27371_27398 = state_27366__$1;
(statearr_27371_27398[(1)] = (5));

} else {
var statearr_27372_27399 = state_27366__$1;
(statearr_27372_27399[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (13))){
var state_27366__$1 = state_27366;
var statearr_27373_27400 = state_27366__$1;
(statearr_27373_27400[(2)] = null);

(statearr_27373_27400[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (6))){
var inst_27343 = (state_27366[(7)]);
var inst_27349 = p.call(null,inst_27343);
var state_27366__$1 = state_27366;
if(cljs.core.truth_(inst_27349)){
var statearr_27374_27401 = state_27366__$1;
(statearr_27374_27401[(1)] = (9));

} else {
var statearr_27375_27402 = state_27366__$1;
(statearr_27375_27402[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (3))){
var inst_27364 = (state_27366[(2)]);
var state_27366__$1 = state_27366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27366__$1,inst_27364);
} else {
if((state_val_27367 === (12))){
var state_27366__$1 = state_27366;
var statearr_27376_27403 = state_27366__$1;
(statearr_27376_27403[(2)] = null);

(statearr_27376_27403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (2))){
var state_27366__$1 = state_27366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27366__$1,(4),ch);
} else {
if((state_val_27367 === (11))){
var inst_27343 = (state_27366[(7)]);
var inst_27353 = (state_27366[(2)]);
var state_27366__$1 = state_27366;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27366__$1,(8),inst_27353,inst_27343);
} else {
if((state_val_27367 === (9))){
var state_27366__$1 = state_27366;
var statearr_27377_27404 = state_27366__$1;
(statearr_27377_27404[(2)] = tc);

(statearr_27377_27404[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (5))){
var inst_27346 = cljs.core.async.close_BANG_.call(null,tc);
var inst_27347 = cljs.core.async.close_BANG_.call(null,fc);
var state_27366__$1 = (function (){var statearr_27378 = state_27366;
(statearr_27378[(8)] = inst_27346);

return statearr_27378;
})();
var statearr_27379_27405 = state_27366__$1;
(statearr_27379_27405[(2)] = inst_27347);

(statearr_27379_27405[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (14))){
var inst_27360 = (state_27366[(2)]);
var state_27366__$1 = state_27366;
var statearr_27380_27406 = state_27366__$1;
(statearr_27380_27406[(2)] = inst_27360);

(statearr_27380_27406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (10))){
var state_27366__$1 = state_27366;
var statearr_27381_27407 = state_27366__$1;
(statearr_27381_27407[(2)] = fc);

(statearr_27381_27407[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27367 === (8))){
var inst_27355 = (state_27366[(2)]);
var state_27366__$1 = state_27366;
if(cljs.core.truth_(inst_27355)){
var statearr_27382_27408 = state_27366__$1;
(statearr_27382_27408[(1)] = (12));

} else {
var statearr_27383_27409 = state_27366__$1;
(statearr_27383_27409[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___27395,tc,fc))
;
return ((function (switch__26605__auto__,c__26717__auto___27395,tc,fc){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_27387 = [null,null,null,null,null,null,null,null,null];
(statearr_27387[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_27387[(1)] = (1));

return statearr_27387;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_27366){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27388){if((e27388 instanceof Object)){
var ex__26609__auto__ = e27388;
var statearr_27389_27410 = state_27366;
(statearr_27389_27410[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27388;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27411 = state_27366;
state_27366 = G__27411;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_27366){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_27366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___27395,tc,fc))
})();
var state__26719__auto__ = (function (){var statearr_27390 = f__26718__auto__.call(null);
(statearr_27390[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___27395);

return statearr_27390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___27395,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__26717__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto__){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto__){
return (function (state_27475){
var state_val_27476 = (state_27475[(1)]);
if((state_val_27476 === (7))){
var inst_27471 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27477_27498 = state_27475__$1;
(statearr_27477_27498[(2)] = inst_27471);

(statearr_27477_27498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (1))){
var inst_27455 = init;
var state_27475__$1 = (function (){var statearr_27478 = state_27475;
(statearr_27478[(7)] = inst_27455);

return statearr_27478;
})();
var statearr_27479_27499 = state_27475__$1;
(statearr_27479_27499[(2)] = null);

(statearr_27479_27499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (4))){
var inst_27458 = (state_27475[(8)]);
var inst_27458__$1 = (state_27475[(2)]);
var inst_27459 = (inst_27458__$1 == null);
var state_27475__$1 = (function (){var statearr_27480 = state_27475;
(statearr_27480[(8)] = inst_27458__$1);

return statearr_27480;
})();
if(cljs.core.truth_(inst_27459)){
var statearr_27481_27500 = state_27475__$1;
(statearr_27481_27500[(1)] = (5));

} else {
var statearr_27482_27501 = state_27475__$1;
(statearr_27482_27501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (6))){
var inst_27455 = (state_27475[(7)]);
var inst_27458 = (state_27475[(8)]);
var inst_27462 = (state_27475[(9)]);
var inst_27462__$1 = f.call(null,inst_27455,inst_27458);
var inst_27463 = cljs.core.reduced_QMARK_.call(null,inst_27462__$1);
var state_27475__$1 = (function (){var statearr_27483 = state_27475;
(statearr_27483[(9)] = inst_27462__$1);

return statearr_27483;
})();
if(inst_27463){
var statearr_27484_27502 = state_27475__$1;
(statearr_27484_27502[(1)] = (8));

} else {
var statearr_27485_27503 = state_27475__$1;
(statearr_27485_27503[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (3))){
var inst_27473 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27475__$1,inst_27473);
} else {
if((state_val_27476 === (2))){
var state_27475__$1 = state_27475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27475__$1,(4),ch);
} else {
if((state_val_27476 === (9))){
var inst_27462 = (state_27475[(9)]);
var inst_27455 = inst_27462;
var state_27475__$1 = (function (){var statearr_27486 = state_27475;
(statearr_27486[(7)] = inst_27455);

return statearr_27486;
})();
var statearr_27487_27504 = state_27475__$1;
(statearr_27487_27504[(2)] = null);

(statearr_27487_27504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (5))){
var inst_27455 = (state_27475[(7)]);
var state_27475__$1 = state_27475;
var statearr_27488_27505 = state_27475__$1;
(statearr_27488_27505[(2)] = inst_27455);

(statearr_27488_27505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (10))){
var inst_27469 = (state_27475[(2)]);
var state_27475__$1 = state_27475;
var statearr_27489_27506 = state_27475__$1;
(statearr_27489_27506[(2)] = inst_27469);

(statearr_27489_27506[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27476 === (8))){
var inst_27462 = (state_27475[(9)]);
var inst_27465 = cljs.core.deref.call(null,inst_27462);
var state_27475__$1 = state_27475;
var statearr_27490_27507 = state_27475__$1;
(statearr_27490_27507[(2)] = inst_27465);

(statearr_27490_27507[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto__))
;
return ((function (switch__26605__auto__,c__26717__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__26606__auto__ = null;
var cljs$core$async$reduce_$_state_machine__26606__auto____0 = (function (){
var statearr_27494 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27494[(0)] = cljs$core$async$reduce_$_state_machine__26606__auto__);

(statearr_27494[(1)] = (1));

return statearr_27494;
});
var cljs$core$async$reduce_$_state_machine__26606__auto____1 = (function (state_27475){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27475);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27495){if((e27495 instanceof Object)){
var ex__26609__auto__ = e27495;
var statearr_27496_27508 = state_27475;
(statearr_27496_27508[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27475);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27495;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27509 = state_27475;
state_27475 = G__27509;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__26606__auto__ = function(state_27475){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__26606__auto____1.call(this,state_27475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__26606__auto____0;
cljs$core$async$reduce_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__26606__auto____1;
return cljs$core$async$reduce_$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto__))
})();
var state__26719__auto__ = (function (){var statearr_27497 = f__26718__auto__.call(null);
(statearr_27497[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto__);

return statearr_27497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto__))
);

return c__26717__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args27510 = [];
var len__25620__auto___27562 = arguments.length;
var i__25621__auto___27563 = (0);
while(true){
if((i__25621__auto___27563 < len__25620__auto___27562)){
args27510.push((arguments[i__25621__auto___27563]));

var G__27564 = (i__25621__auto___27563 + (1));
i__25621__auto___27563 = G__27564;
continue;
} else {
}
break;
}

var G__27512 = args27510.length;
switch (G__27512) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27510.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__26717__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto__){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto__){
return (function (state_27537){
var state_val_27538 = (state_27537[(1)]);
if((state_val_27538 === (7))){
var inst_27519 = (state_27537[(2)]);
var state_27537__$1 = state_27537;
var statearr_27539_27566 = state_27537__$1;
(statearr_27539_27566[(2)] = inst_27519);

(statearr_27539_27566[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (1))){
var inst_27513 = cljs.core.seq.call(null,coll);
var inst_27514 = inst_27513;
var state_27537__$1 = (function (){var statearr_27540 = state_27537;
(statearr_27540[(7)] = inst_27514);

return statearr_27540;
})();
var statearr_27541_27567 = state_27537__$1;
(statearr_27541_27567[(2)] = null);

(statearr_27541_27567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (4))){
var inst_27514 = (state_27537[(7)]);
var inst_27517 = cljs.core.first.call(null,inst_27514);
var state_27537__$1 = state_27537;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27537__$1,(7),ch,inst_27517);
} else {
if((state_val_27538 === (13))){
var inst_27531 = (state_27537[(2)]);
var state_27537__$1 = state_27537;
var statearr_27542_27568 = state_27537__$1;
(statearr_27542_27568[(2)] = inst_27531);

(statearr_27542_27568[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (6))){
var inst_27522 = (state_27537[(2)]);
var state_27537__$1 = state_27537;
if(cljs.core.truth_(inst_27522)){
var statearr_27543_27569 = state_27537__$1;
(statearr_27543_27569[(1)] = (8));

} else {
var statearr_27544_27570 = state_27537__$1;
(statearr_27544_27570[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (3))){
var inst_27535 = (state_27537[(2)]);
var state_27537__$1 = state_27537;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27537__$1,inst_27535);
} else {
if((state_val_27538 === (12))){
var state_27537__$1 = state_27537;
var statearr_27545_27571 = state_27537__$1;
(statearr_27545_27571[(2)] = null);

(statearr_27545_27571[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (2))){
var inst_27514 = (state_27537[(7)]);
var state_27537__$1 = state_27537;
if(cljs.core.truth_(inst_27514)){
var statearr_27546_27572 = state_27537__$1;
(statearr_27546_27572[(1)] = (4));

} else {
var statearr_27547_27573 = state_27537__$1;
(statearr_27547_27573[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (11))){
var inst_27528 = cljs.core.async.close_BANG_.call(null,ch);
var state_27537__$1 = state_27537;
var statearr_27548_27574 = state_27537__$1;
(statearr_27548_27574[(2)] = inst_27528);

(statearr_27548_27574[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (9))){
var state_27537__$1 = state_27537;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27549_27575 = state_27537__$1;
(statearr_27549_27575[(1)] = (11));

} else {
var statearr_27550_27576 = state_27537__$1;
(statearr_27550_27576[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (5))){
var inst_27514 = (state_27537[(7)]);
var state_27537__$1 = state_27537;
var statearr_27551_27577 = state_27537__$1;
(statearr_27551_27577[(2)] = inst_27514);

(statearr_27551_27577[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (10))){
var inst_27533 = (state_27537[(2)]);
var state_27537__$1 = state_27537;
var statearr_27552_27578 = state_27537__$1;
(statearr_27552_27578[(2)] = inst_27533);

(statearr_27552_27578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27538 === (8))){
var inst_27514 = (state_27537[(7)]);
var inst_27524 = cljs.core.next.call(null,inst_27514);
var inst_27514__$1 = inst_27524;
var state_27537__$1 = (function (){var statearr_27553 = state_27537;
(statearr_27553[(7)] = inst_27514__$1);

return statearr_27553;
})();
var statearr_27554_27579 = state_27537__$1;
(statearr_27554_27579[(2)] = null);

(statearr_27554_27579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto__))
;
return ((function (switch__26605__auto__,c__26717__auto__){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_27558 = [null,null,null,null,null,null,null,null];
(statearr_27558[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_27558[(1)] = (1));

return statearr_27558;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_27537){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27537);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e27559){if((e27559 instanceof Object)){
var ex__26609__auto__ = e27559;
var statearr_27560_27580 = state_27537;
(statearr_27560_27580[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27537);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27559;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27581 = state_27537;
state_27537 = G__27581;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_27537){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_27537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto__))
})();
var state__26719__auto__ = (function (){var statearr_27561 = f__26718__auto__.call(null);
(statearr_27561[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto__);

return statearr_27561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto__))
);

return c__26717__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__25214__auto__ = (((_ == null))?null:_);
var m__25215__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,_);
} else {
var m__25215__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__25215__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m,ch);
} else {
var m__25215__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m);
} else {
var m__25215__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async27803 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27803 = (function (mult,ch,cs,meta27804){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta27804 = meta27804;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_27805,meta27804__$1){
var self__ = this;
var _27805__$1 = this;
return (new cljs.core.async.t_cljs$core$async27803(self__.mult,self__.ch,self__.cs,meta27804__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_27805){
var self__ = this;
var _27805__$1 = this;
return self__.meta27804;
});})(cs))
;

cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27803.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27803.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta27804","meta27804",-44422893,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async27803.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27803.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27803";

cljs.core.async.t_cljs$core$async27803.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async27803");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async27803 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async27803(mult__$1,ch__$1,cs__$1,meta27804){
return (new cljs.core.async.t_cljs$core$async27803(mult__$1,ch__$1,cs__$1,meta27804));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async27803(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__26717__auto___28024 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___28024,cs,m,dchan,dctr,done){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___28024,cs,m,dchan,dctr,done){
return (function (state_27936){
var state_val_27937 = (state_27936[(1)]);
if((state_val_27937 === (7))){
var inst_27932 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_27938_28025 = state_27936__$1;
(statearr_27938_28025[(2)] = inst_27932);

(statearr_27938_28025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (20))){
var inst_27837 = (state_27936[(7)]);
var inst_27847 = cljs.core.first.call(null,inst_27837);
var inst_27848 = cljs.core.nth.call(null,inst_27847,(0),null);
var inst_27849 = cljs.core.nth.call(null,inst_27847,(1),null);
var state_27936__$1 = (function (){var statearr_27939 = state_27936;
(statearr_27939[(8)] = inst_27848);

return statearr_27939;
})();
if(cljs.core.truth_(inst_27849)){
var statearr_27940_28026 = state_27936__$1;
(statearr_27940_28026[(1)] = (22));

} else {
var statearr_27941_28027 = state_27936__$1;
(statearr_27941_28027[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (27))){
var inst_27879 = (state_27936[(9)]);
var inst_27884 = (state_27936[(10)]);
var inst_27877 = (state_27936[(11)]);
var inst_27808 = (state_27936[(12)]);
var inst_27884__$1 = cljs.core._nth.call(null,inst_27877,inst_27879);
var inst_27885 = cljs.core.async.put_BANG_.call(null,inst_27884__$1,inst_27808,done);
var state_27936__$1 = (function (){var statearr_27942 = state_27936;
(statearr_27942[(10)] = inst_27884__$1);

return statearr_27942;
})();
if(cljs.core.truth_(inst_27885)){
var statearr_27943_28028 = state_27936__$1;
(statearr_27943_28028[(1)] = (30));

} else {
var statearr_27944_28029 = state_27936__$1;
(statearr_27944_28029[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (1))){
var state_27936__$1 = state_27936;
var statearr_27945_28030 = state_27936__$1;
(statearr_27945_28030[(2)] = null);

(statearr_27945_28030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (24))){
var inst_27837 = (state_27936[(7)]);
var inst_27854 = (state_27936[(2)]);
var inst_27855 = cljs.core.next.call(null,inst_27837);
var inst_27817 = inst_27855;
var inst_27818 = null;
var inst_27819 = (0);
var inst_27820 = (0);
var state_27936__$1 = (function (){var statearr_27946 = state_27936;
(statearr_27946[(13)] = inst_27820);

(statearr_27946[(14)] = inst_27817);

(statearr_27946[(15)] = inst_27818);

(statearr_27946[(16)] = inst_27819);

(statearr_27946[(17)] = inst_27854);

return statearr_27946;
})();
var statearr_27947_28031 = state_27936__$1;
(statearr_27947_28031[(2)] = null);

(statearr_27947_28031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (39))){
var state_27936__$1 = state_27936;
var statearr_27951_28032 = state_27936__$1;
(statearr_27951_28032[(2)] = null);

(statearr_27951_28032[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (4))){
var inst_27808 = (state_27936[(12)]);
var inst_27808__$1 = (state_27936[(2)]);
var inst_27809 = (inst_27808__$1 == null);
var state_27936__$1 = (function (){var statearr_27952 = state_27936;
(statearr_27952[(12)] = inst_27808__$1);

return statearr_27952;
})();
if(cljs.core.truth_(inst_27809)){
var statearr_27953_28033 = state_27936__$1;
(statearr_27953_28033[(1)] = (5));

} else {
var statearr_27954_28034 = state_27936__$1;
(statearr_27954_28034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (15))){
var inst_27820 = (state_27936[(13)]);
var inst_27817 = (state_27936[(14)]);
var inst_27818 = (state_27936[(15)]);
var inst_27819 = (state_27936[(16)]);
var inst_27833 = (state_27936[(2)]);
var inst_27834 = (inst_27820 + (1));
var tmp27948 = inst_27817;
var tmp27949 = inst_27818;
var tmp27950 = inst_27819;
var inst_27817__$1 = tmp27948;
var inst_27818__$1 = tmp27949;
var inst_27819__$1 = tmp27950;
var inst_27820__$1 = inst_27834;
var state_27936__$1 = (function (){var statearr_27955 = state_27936;
(statearr_27955[(13)] = inst_27820__$1);

(statearr_27955[(14)] = inst_27817__$1);

(statearr_27955[(15)] = inst_27818__$1);

(statearr_27955[(18)] = inst_27833);

(statearr_27955[(16)] = inst_27819__$1);

return statearr_27955;
})();
var statearr_27956_28035 = state_27936__$1;
(statearr_27956_28035[(2)] = null);

(statearr_27956_28035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (21))){
var inst_27858 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_27960_28036 = state_27936__$1;
(statearr_27960_28036[(2)] = inst_27858);

(statearr_27960_28036[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (31))){
var inst_27884 = (state_27936[(10)]);
var inst_27888 = done.call(null,null);
var inst_27889 = cljs.core.async.untap_STAR_.call(null,m,inst_27884);
var state_27936__$1 = (function (){var statearr_27961 = state_27936;
(statearr_27961[(19)] = inst_27888);

return statearr_27961;
})();
var statearr_27962_28037 = state_27936__$1;
(statearr_27962_28037[(2)] = inst_27889);

(statearr_27962_28037[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (32))){
var inst_27879 = (state_27936[(9)]);
var inst_27876 = (state_27936[(20)]);
var inst_27877 = (state_27936[(11)]);
var inst_27878 = (state_27936[(21)]);
var inst_27891 = (state_27936[(2)]);
var inst_27892 = (inst_27879 + (1));
var tmp27957 = inst_27876;
var tmp27958 = inst_27877;
var tmp27959 = inst_27878;
var inst_27876__$1 = tmp27957;
var inst_27877__$1 = tmp27958;
var inst_27878__$1 = tmp27959;
var inst_27879__$1 = inst_27892;
var state_27936__$1 = (function (){var statearr_27963 = state_27936;
(statearr_27963[(9)] = inst_27879__$1);

(statearr_27963[(20)] = inst_27876__$1);

(statearr_27963[(11)] = inst_27877__$1);

(statearr_27963[(21)] = inst_27878__$1);

(statearr_27963[(22)] = inst_27891);

return statearr_27963;
})();
var statearr_27964_28038 = state_27936__$1;
(statearr_27964_28038[(2)] = null);

(statearr_27964_28038[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (40))){
var inst_27904 = (state_27936[(23)]);
var inst_27908 = done.call(null,null);
var inst_27909 = cljs.core.async.untap_STAR_.call(null,m,inst_27904);
var state_27936__$1 = (function (){var statearr_27965 = state_27936;
(statearr_27965[(24)] = inst_27908);

return statearr_27965;
})();
var statearr_27966_28039 = state_27936__$1;
(statearr_27966_28039[(2)] = inst_27909);

(statearr_27966_28039[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (33))){
var inst_27895 = (state_27936[(25)]);
var inst_27897 = cljs.core.chunked_seq_QMARK_.call(null,inst_27895);
var state_27936__$1 = state_27936;
if(inst_27897){
var statearr_27967_28040 = state_27936__$1;
(statearr_27967_28040[(1)] = (36));

} else {
var statearr_27968_28041 = state_27936__$1;
(statearr_27968_28041[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (13))){
var inst_27827 = (state_27936[(26)]);
var inst_27830 = cljs.core.async.close_BANG_.call(null,inst_27827);
var state_27936__$1 = state_27936;
var statearr_27969_28042 = state_27936__$1;
(statearr_27969_28042[(2)] = inst_27830);

(statearr_27969_28042[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (22))){
var inst_27848 = (state_27936[(8)]);
var inst_27851 = cljs.core.async.close_BANG_.call(null,inst_27848);
var state_27936__$1 = state_27936;
var statearr_27970_28043 = state_27936__$1;
(statearr_27970_28043[(2)] = inst_27851);

(statearr_27970_28043[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (36))){
var inst_27895 = (state_27936[(25)]);
var inst_27899 = cljs.core.chunk_first.call(null,inst_27895);
var inst_27900 = cljs.core.chunk_rest.call(null,inst_27895);
var inst_27901 = cljs.core.count.call(null,inst_27899);
var inst_27876 = inst_27900;
var inst_27877 = inst_27899;
var inst_27878 = inst_27901;
var inst_27879 = (0);
var state_27936__$1 = (function (){var statearr_27971 = state_27936;
(statearr_27971[(9)] = inst_27879);

(statearr_27971[(20)] = inst_27876);

(statearr_27971[(11)] = inst_27877);

(statearr_27971[(21)] = inst_27878);

return statearr_27971;
})();
var statearr_27972_28044 = state_27936__$1;
(statearr_27972_28044[(2)] = null);

(statearr_27972_28044[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (41))){
var inst_27895 = (state_27936[(25)]);
var inst_27911 = (state_27936[(2)]);
var inst_27912 = cljs.core.next.call(null,inst_27895);
var inst_27876 = inst_27912;
var inst_27877 = null;
var inst_27878 = (0);
var inst_27879 = (0);
var state_27936__$1 = (function (){var statearr_27973 = state_27936;
(statearr_27973[(9)] = inst_27879);

(statearr_27973[(27)] = inst_27911);

(statearr_27973[(20)] = inst_27876);

(statearr_27973[(11)] = inst_27877);

(statearr_27973[(21)] = inst_27878);

return statearr_27973;
})();
var statearr_27974_28045 = state_27936__$1;
(statearr_27974_28045[(2)] = null);

(statearr_27974_28045[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (43))){
var state_27936__$1 = state_27936;
var statearr_27975_28046 = state_27936__$1;
(statearr_27975_28046[(2)] = null);

(statearr_27975_28046[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (29))){
var inst_27920 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_27976_28047 = state_27936__$1;
(statearr_27976_28047[(2)] = inst_27920);

(statearr_27976_28047[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (44))){
var inst_27929 = (state_27936[(2)]);
var state_27936__$1 = (function (){var statearr_27977 = state_27936;
(statearr_27977[(28)] = inst_27929);

return statearr_27977;
})();
var statearr_27978_28048 = state_27936__$1;
(statearr_27978_28048[(2)] = null);

(statearr_27978_28048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (6))){
var inst_27868 = (state_27936[(29)]);
var inst_27867 = cljs.core.deref.call(null,cs);
var inst_27868__$1 = cljs.core.keys.call(null,inst_27867);
var inst_27869 = cljs.core.count.call(null,inst_27868__$1);
var inst_27870 = cljs.core.reset_BANG_.call(null,dctr,inst_27869);
var inst_27875 = cljs.core.seq.call(null,inst_27868__$1);
var inst_27876 = inst_27875;
var inst_27877 = null;
var inst_27878 = (0);
var inst_27879 = (0);
var state_27936__$1 = (function (){var statearr_27979 = state_27936;
(statearr_27979[(9)] = inst_27879);

(statearr_27979[(29)] = inst_27868__$1);

(statearr_27979[(30)] = inst_27870);

(statearr_27979[(20)] = inst_27876);

(statearr_27979[(11)] = inst_27877);

(statearr_27979[(21)] = inst_27878);

return statearr_27979;
})();
var statearr_27980_28049 = state_27936__$1;
(statearr_27980_28049[(2)] = null);

(statearr_27980_28049[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (28))){
var inst_27895 = (state_27936[(25)]);
var inst_27876 = (state_27936[(20)]);
var inst_27895__$1 = cljs.core.seq.call(null,inst_27876);
var state_27936__$1 = (function (){var statearr_27981 = state_27936;
(statearr_27981[(25)] = inst_27895__$1);

return statearr_27981;
})();
if(inst_27895__$1){
var statearr_27982_28050 = state_27936__$1;
(statearr_27982_28050[(1)] = (33));

} else {
var statearr_27983_28051 = state_27936__$1;
(statearr_27983_28051[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (25))){
var inst_27879 = (state_27936[(9)]);
var inst_27878 = (state_27936[(21)]);
var inst_27881 = (inst_27879 < inst_27878);
var inst_27882 = inst_27881;
var state_27936__$1 = state_27936;
if(cljs.core.truth_(inst_27882)){
var statearr_27984_28052 = state_27936__$1;
(statearr_27984_28052[(1)] = (27));

} else {
var statearr_27985_28053 = state_27936__$1;
(statearr_27985_28053[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (34))){
var state_27936__$1 = state_27936;
var statearr_27986_28054 = state_27936__$1;
(statearr_27986_28054[(2)] = null);

(statearr_27986_28054[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (17))){
var state_27936__$1 = state_27936;
var statearr_27987_28055 = state_27936__$1;
(statearr_27987_28055[(2)] = null);

(statearr_27987_28055[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (3))){
var inst_27934 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27936__$1,inst_27934);
} else {
if((state_val_27937 === (12))){
var inst_27863 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_27988_28056 = state_27936__$1;
(statearr_27988_28056[(2)] = inst_27863);

(statearr_27988_28056[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (2))){
var state_27936__$1 = state_27936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27936__$1,(4),ch);
} else {
if((state_val_27937 === (23))){
var state_27936__$1 = state_27936;
var statearr_27989_28057 = state_27936__$1;
(statearr_27989_28057[(2)] = null);

(statearr_27989_28057[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (35))){
var inst_27918 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_27990_28058 = state_27936__$1;
(statearr_27990_28058[(2)] = inst_27918);

(statearr_27990_28058[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (19))){
var inst_27837 = (state_27936[(7)]);
var inst_27841 = cljs.core.chunk_first.call(null,inst_27837);
var inst_27842 = cljs.core.chunk_rest.call(null,inst_27837);
var inst_27843 = cljs.core.count.call(null,inst_27841);
var inst_27817 = inst_27842;
var inst_27818 = inst_27841;
var inst_27819 = inst_27843;
var inst_27820 = (0);
var state_27936__$1 = (function (){var statearr_27991 = state_27936;
(statearr_27991[(13)] = inst_27820);

(statearr_27991[(14)] = inst_27817);

(statearr_27991[(15)] = inst_27818);

(statearr_27991[(16)] = inst_27819);

return statearr_27991;
})();
var statearr_27992_28059 = state_27936__$1;
(statearr_27992_28059[(2)] = null);

(statearr_27992_28059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (11))){
var inst_27837 = (state_27936[(7)]);
var inst_27817 = (state_27936[(14)]);
var inst_27837__$1 = cljs.core.seq.call(null,inst_27817);
var state_27936__$1 = (function (){var statearr_27993 = state_27936;
(statearr_27993[(7)] = inst_27837__$1);

return statearr_27993;
})();
if(inst_27837__$1){
var statearr_27994_28060 = state_27936__$1;
(statearr_27994_28060[(1)] = (16));

} else {
var statearr_27995_28061 = state_27936__$1;
(statearr_27995_28061[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (9))){
var inst_27865 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_27996_28062 = state_27936__$1;
(statearr_27996_28062[(2)] = inst_27865);

(statearr_27996_28062[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (5))){
var inst_27815 = cljs.core.deref.call(null,cs);
var inst_27816 = cljs.core.seq.call(null,inst_27815);
var inst_27817 = inst_27816;
var inst_27818 = null;
var inst_27819 = (0);
var inst_27820 = (0);
var state_27936__$1 = (function (){var statearr_27997 = state_27936;
(statearr_27997[(13)] = inst_27820);

(statearr_27997[(14)] = inst_27817);

(statearr_27997[(15)] = inst_27818);

(statearr_27997[(16)] = inst_27819);

return statearr_27997;
})();
var statearr_27998_28063 = state_27936__$1;
(statearr_27998_28063[(2)] = null);

(statearr_27998_28063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (14))){
var state_27936__$1 = state_27936;
var statearr_27999_28064 = state_27936__$1;
(statearr_27999_28064[(2)] = null);

(statearr_27999_28064[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (45))){
var inst_27926 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_28000_28065 = state_27936__$1;
(statearr_28000_28065[(2)] = inst_27926);

(statearr_28000_28065[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (26))){
var inst_27868 = (state_27936[(29)]);
var inst_27922 = (state_27936[(2)]);
var inst_27923 = cljs.core.seq.call(null,inst_27868);
var state_27936__$1 = (function (){var statearr_28001 = state_27936;
(statearr_28001[(31)] = inst_27922);

return statearr_28001;
})();
if(inst_27923){
var statearr_28002_28066 = state_27936__$1;
(statearr_28002_28066[(1)] = (42));

} else {
var statearr_28003_28067 = state_27936__$1;
(statearr_28003_28067[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (16))){
var inst_27837 = (state_27936[(7)]);
var inst_27839 = cljs.core.chunked_seq_QMARK_.call(null,inst_27837);
var state_27936__$1 = state_27936;
if(inst_27839){
var statearr_28004_28068 = state_27936__$1;
(statearr_28004_28068[(1)] = (19));

} else {
var statearr_28005_28069 = state_27936__$1;
(statearr_28005_28069[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (38))){
var inst_27915 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_28006_28070 = state_27936__$1;
(statearr_28006_28070[(2)] = inst_27915);

(statearr_28006_28070[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (30))){
var state_27936__$1 = state_27936;
var statearr_28007_28071 = state_27936__$1;
(statearr_28007_28071[(2)] = null);

(statearr_28007_28071[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (10))){
var inst_27820 = (state_27936[(13)]);
var inst_27818 = (state_27936[(15)]);
var inst_27826 = cljs.core._nth.call(null,inst_27818,inst_27820);
var inst_27827 = cljs.core.nth.call(null,inst_27826,(0),null);
var inst_27828 = cljs.core.nth.call(null,inst_27826,(1),null);
var state_27936__$1 = (function (){var statearr_28008 = state_27936;
(statearr_28008[(26)] = inst_27827);

return statearr_28008;
})();
if(cljs.core.truth_(inst_27828)){
var statearr_28009_28072 = state_27936__$1;
(statearr_28009_28072[(1)] = (13));

} else {
var statearr_28010_28073 = state_27936__$1;
(statearr_28010_28073[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (18))){
var inst_27861 = (state_27936[(2)]);
var state_27936__$1 = state_27936;
var statearr_28011_28074 = state_27936__$1;
(statearr_28011_28074[(2)] = inst_27861);

(statearr_28011_28074[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (42))){
var state_27936__$1 = state_27936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27936__$1,(45),dchan);
} else {
if((state_val_27937 === (37))){
var inst_27895 = (state_27936[(25)]);
var inst_27808 = (state_27936[(12)]);
var inst_27904 = (state_27936[(23)]);
var inst_27904__$1 = cljs.core.first.call(null,inst_27895);
var inst_27905 = cljs.core.async.put_BANG_.call(null,inst_27904__$1,inst_27808,done);
var state_27936__$1 = (function (){var statearr_28012 = state_27936;
(statearr_28012[(23)] = inst_27904__$1);

return statearr_28012;
})();
if(cljs.core.truth_(inst_27905)){
var statearr_28013_28075 = state_27936__$1;
(statearr_28013_28075[(1)] = (39));

} else {
var statearr_28014_28076 = state_27936__$1;
(statearr_28014_28076[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27937 === (8))){
var inst_27820 = (state_27936[(13)]);
var inst_27819 = (state_27936[(16)]);
var inst_27822 = (inst_27820 < inst_27819);
var inst_27823 = inst_27822;
var state_27936__$1 = state_27936;
if(cljs.core.truth_(inst_27823)){
var statearr_28015_28077 = state_27936__$1;
(statearr_28015_28077[(1)] = (10));

} else {
var statearr_28016_28078 = state_27936__$1;
(statearr_28016_28078[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___28024,cs,m,dchan,dctr,done))
;
return ((function (switch__26605__auto__,c__26717__auto___28024,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__26606__auto__ = null;
var cljs$core$async$mult_$_state_machine__26606__auto____0 = (function (){
var statearr_28020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28020[(0)] = cljs$core$async$mult_$_state_machine__26606__auto__);

(statearr_28020[(1)] = (1));

return statearr_28020;
});
var cljs$core$async$mult_$_state_machine__26606__auto____1 = (function (state_27936){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_27936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e28021){if((e28021 instanceof Object)){
var ex__26609__auto__ = e28021;
var statearr_28022_28079 = state_27936;
(statearr_28022_28079[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28021;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28080 = state_27936;
state_27936 = G__28080;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__26606__auto__ = function(state_27936){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__26606__auto____1.call(this,state_27936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__26606__auto____0;
cljs$core$async$mult_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__26606__auto____1;
return cljs$core$async$mult_$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___28024,cs,m,dchan,dctr,done))
})();
var state__26719__auto__ = (function (){var statearr_28023 = f__26718__auto__.call(null);
(statearr_28023[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___28024);

return statearr_28023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___28024,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args28081 = [];
var len__25620__auto___28084 = arguments.length;
var i__25621__auto___28085 = (0);
while(true){
if((i__25621__auto___28085 < len__25620__auto___28084)){
args28081.push((arguments[i__25621__auto___28085]));

var G__28086 = (i__25621__auto___28085 + (1));
i__25621__auto___28085 = G__28086;
continue;
} else {
}
break;
}

var G__28083 = args28081.length;
switch (G__28083) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28081.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m,ch);
} else {
var m__25215__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m,ch);
} else {
var m__25215__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m);
} else {
var m__25215__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m,state_map);
} else {
var m__25215__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__25214__auto__ = (((m == null))?null:m);
var m__25215__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,m,mode);
} else {
var m__25215__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__25627__auto__ = [];
var len__25620__auto___28098 = arguments.length;
var i__25621__auto___28099 = (0);
while(true){
if((i__25621__auto___28099 < len__25620__auto___28098)){
args__25627__auto__.push((arguments[i__25621__auto___28099]));

var G__28100 = (i__25621__auto___28099 + (1));
i__25621__auto___28099 = G__28100;
continue;
} else {
}
break;
}

var argseq__25628__auto__ = ((((3) < args__25627__auto__.length))?(new cljs.core.IndexedSeq(args__25627__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__25628__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__28092){
var map__28093 = p__28092;
var map__28093__$1 = ((((!((map__28093 == null)))?((((map__28093.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28093.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28093):map__28093);
var opts = map__28093__$1;
var statearr_28095_28101 = state;
(statearr_28095_28101[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__28093,map__28093__$1,opts){
return (function (val){
var statearr_28096_28102 = state;
(statearr_28096_28102[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__28093,map__28093__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_28097_28103 = state;
(statearr_28097_28103[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq28088){
var G__28089 = cljs.core.first.call(null,seq28088);
var seq28088__$1 = cljs.core.next.call(null,seq28088);
var G__28090 = cljs.core.first.call(null,seq28088__$1);
var seq28088__$2 = cljs.core.next.call(null,seq28088__$1);
var G__28091 = cljs.core.first.call(null,seq28088__$2);
var seq28088__$3 = cljs.core.next.call(null,seq28088__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28089,G__28090,G__28091,seq28088__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async28267 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28267 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta28268){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta28268 = meta28268;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28269,meta28268__$1){
var self__ = this;
var _28269__$1 = this;
return (new cljs.core.async.t_cljs$core$async28267(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta28268__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_28269){
var self__ = this;
var _28269__$1 = this;
return self__.meta28268;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta28268","meta28268",-1820708553,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async28267.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28267.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28267";

cljs.core.async.t_cljs$core$async28267.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async28267");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async28267 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async28267(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta28268){
return (new cljs.core.async.t_cljs$core$async28267(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta28268));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async28267(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26717__auto___28430 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___28430,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___28430,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_28367){
var state_val_28368 = (state_28367[(1)]);
if((state_val_28368 === (7))){
var inst_28285 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
var statearr_28369_28431 = state_28367__$1;
(statearr_28369_28431[(2)] = inst_28285);

(statearr_28369_28431[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (20))){
var inst_28297 = (state_28367[(7)]);
var state_28367__$1 = state_28367;
var statearr_28370_28432 = state_28367__$1;
(statearr_28370_28432[(2)] = inst_28297);

(statearr_28370_28432[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (27))){
var state_28367__$1 = state_28367;
var statearr_28371_28433 = state_28367__$1;
(statearr_28371_28433[(2)] = null);

(statearr_28371_28433[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (1))){
var inst_28273 = (state_28367[(8)]);
var inst_28273__$1 = calc_state.call(null);
var inst_28275 = (inst_28273__$1 == null);
var inst_28276 = cljs.core.not.call(null,inst_28275);
var state_28367__$1 = (function (){var statearr_28372 = state_28367;
(statearr_28372[(8)] = inst_28273__$1);

return statearr_28372;
})();
if(inst_28276){
var statearr_28373_28434 = state_28367__$1;
(statearr_28373_28434[(1)] = (2));

} else {
var statearr_28374_28435 = state_28367__$1;
(statearr_28374_28435[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (24))){
var inst_28327 = (state_28367[(9)]);
var inst_28341 = (state_28367[(10)]);
var inst_28320 = (state_28367[(11)]);
var inst_28341__$1 = inst_28320.call(null,inst_28327);
var state_28367__$1 = (function (){var statearr_28375 = state_28367;
(statearr_28375[(10)] = inst_28341__$1);

return statearr_28375;
})();
if(cljs.core.truth_(inst_28341__$1)){
var statearr_28376_28436 = state_28367__$1;
(statearr_28376_28436[(1)] = (29));

} else {
var statearr_28377_28437 = state_28367__$1;
(statearr_28377_28437[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (4))){
var inst_28288 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
if(cljs.core.truth_(inst_28288)){
var statearr_28378_28438 = state_28367__$1;
(statearr_28378_28438[(1)] = (8));

} else {
var statearr_28379_28439 = state_28367__$1;
(statearr_28379_28439[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (15))){
var inst_28314 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
if(cljs.core.truth_(inst_28314)){
var statearr_28380_28440 = state_28367__$1;
(statearr_28380_28440[(1)] = (19));

} else {
var statearr_28381_28441 = state_28367__$1;
(statearr_28381_28441[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (21))){
var inst_28319 = (state_28367[(12)]);
var inst_28319__$1 = (state_28367[(2)]);
var inst_28320 = cljs.core.get.call(null,inst_28319__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_28321 = cljs.core.get.call(null,inst_28319__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_28322 = cljs.core.get.call(null,inst_28319__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_28367__$1 = (function (){var statearr_28382 = state_28367;
(statearr_28382[(13)] = inst_28321);

(statearr_28382[(11)] = inst_28320);

(statearr_28382[(12)] = inst_28319__$1);

return statearr_28382;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28367__$1,(22),inst_28322);
} else {
if((state_val_28368 === (31))){
var inst_28349 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
if(cljs.core.truth_(inst_28349)){
var statearr_28383_28442 = state_28367__$1;
(statearr_28383_28442[(1)] = (32));

} else {
var statearr_28384_28443 = state_28367__$1;
(statearr_28384_28443[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (32))){
var inst_28326 = (state_28367[(14)]);
var state_28367__$1 = state_28367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28367__$1,(35),out,inst_28326);
} else {
if((state_val_28368 === (33))){
var inst_28319 = (state_28367[(12)]);
var inst_28297 = inst_28319;
var state_28367__$1 = (function (){var statearr_28385 = state_28367;
(statearr_28385[(7)] = inst_28297);

return statearr_28385;
})();
var statearr_28386_28444 = state_28367__$1;
(statearr_28386_28444[(2)] = null);

(statearr_28386_28444[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (13))){
var inst_28297 = (state_28367[(7)]);
var inst_28304 = inst_28297.cljs$lang$protocol_mask$partition0$;
var inst_28305 = (inst_28304 & (64));
var inst_28306 = inst_28297.cljs$core$ISeq$;
var inst_28307 = (inst_28305) || (inst_28306);
var state_28367__$1 = state_28367;
if(cljs.core.truth_(inst_28307)){
var statearr_28387_28445 = state_28367__$1;
(statearr_28387_28445[(1)] = (16));

} else {
var statearr_28388_28446 = state_28367__$1;
(statearr_28388_28446[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (22))){
var inst_28327 = (state_28367[(9)]);
var inst_28326 = (state_28367[(14)]);
var inst_28325 = (state_28367[(2)]);
var inst_28326__$1 = cljs.core.nth.call(null,inst_28325,(0),null);
var inst_28327__$1 = cljs.core.nth.call(null,inst_28325,(1),null);
var inst_28328 = (inst_28326__$1 == null);
var inst_28329 = cljs.core._EQ_.call(null,inst_28327__$1,change);
var inst_28330 = (inst_28328) || (inst_28329);
var state_28367__$1 = (function (){var statearr_28389 = state_28367;
(statearr_28389[(9)] = inst_28327__$1);

(statearr_28389[(14)] = inst_28326__$1);

return statearr_28389;
})();
if(cljs.core.truth_(inst_28330)){
var statearr_28390_28447 = state_28367__$1;
(statearr_28390_28447[(1)] = (23));

} else {
var statearr_28391_28448 = state_28367__$1;
(statearr_28391_28448[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (36))){
var inst_28319 = (state_28367[(12)]);
var inst_28297 = inst_28319;
var state_28367__$1 = (function (){var statearr_28392 = state_28367;
(statearr_28392[(7)] = inst_28297);

return statearr_28392;
})();
var statearr_28393_28449 = state_28367__$1;
(statearr_28393_28449[(2)] = null);

(statearr_28393_28449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (29))){
var inst_28341 = (state_28367[(10)]);
var state_28367__$1 = state_28367;
var statearr_28394_28450 = state_28367__$1;
(statearr_28394_28450[(2)] = inst_28341);

(statearr_28394_28450[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (6))){
var state_28367__$1 = state_28367;
var statearr_28395_28451 = state_28367__$1;
(statearr_28395_28451[(2)] = false);

(statearr_28395_28451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (28))){
var inst_28337 = (state_28367[(2)]);
var inst_28338 = calc_state.call(null);
var inst_28297 = inst_28338;
var state_28367__$1 = (function (){var statearr_28396 = state_28367;
(statearr_28396[(7)] = inst_28297);

(statearr_28396[(15)] = inst_28337);

return statearr_28396;
})();
var statearr_28397_28452 = state_28367__$1;
(statearr_28397_28452[(2)] = null);

(statearr_28397_28452[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (25))){
var inst_28363 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
var statearr_28398_28453 = state_28367__$1;
(statearr_28398_28453[(2)] = inst_28363);

(statearr_28398_28453[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (34))){
var inst_28361 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
var statearr_28399_28454 = state_28367__$1;
(statearr_28399_28454[(2)] = inst_28361);

(statearr_28399_28454[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (17))){
var state_28367__$1 = state_28367;
var statearr_28400_28455 = state_28367__$1;
(statearr_28400_28455[(2)] = false);

(statearr_28400_28455[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (3))){
var state_28367__$1 = state_28367;
var statearr_28401_28456 = state_28367__$1;
(statearr_28401_28456[(2)] = false);

(statearr_28401_28456[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (12))){
var inst_28365 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28367__$1,inst_28365);
} else {
if((state_val_28368 === (2))){
var inst_28273 = (state_28367[(8)]);
var inst_28278 = inst_28273.cljs$lang$protocol_mask$partition0$;
var inst_28279 = (inst_28278 & (64));
var inst_28280 = inst_28273.cljs$core$ISeq$;
var inst_28281 = (inst_28279) || (inst_28280);
var state_28367__$1 = state_28367;
if(cljs.core.truth_(inst_28281)){
var statearr_28402_28457 = state_28367__$1;
(statearr_28402_28457[(1)] = (5));

} else {
var statearr_28403_28458 = state_28367__$1;
(statearr_28403_28458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (23))){
var inst_28326 = (state_28367[(14)]);
var inst_28332 = (inst_28326 == null);
var state_28367__$1 = state_28367;
if(cljs.core.truth_(inst_28332)){
var statearr_28404_28459 = state_28367__$1;
(statearr_28404_28459[(1)] = (26));

} else {
var statearr_28405_28460 = state_28367__$1;
(statearr_28405_28460[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (35))){
var inst_28352 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
if(cljs.core.truth_(inst_28352)){
var statearr_28406_28461 = state_28367__$1;
(statearr_28406_28461[(1)] = (36));

} else {
var statearr_28407_28462 = state_28367__$1;
(statearr_28407_28462[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (19))){
var inst_28297 = (state_28367[(7)]);
var inst_28316 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28297);
var state_28367__$1 = state_28367;
var statearr_28408_28463 = state_28367__$1;
(statearr_28408_28463[(2)] = inst_28316);

(statearr_28408_28463[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (11))){
var inst_28297 = (state_28367[(7)]);
var inst_28301 = (inst_28297 == null);
var inst_28302 = cljs.core.not.call(null,inst_28301);
var state_28367__$1 = state_28367;
if(inst_28302){
var statearr_28409_28464 = state_28367__$1;
(statearr_28409_28464[(1)] = (13));

} else {
var statearr_28410_28465 = state_28367__$1;
(statearr_28410_28465[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (9))){
var inst_28273 = (state_28367[(8)]);
var state_28367__$1 = state_28367;
var statearr_28411_28466 = state_28367__$1;
(statearr_28411_28466[(2)] = inst_28273);

(statearr_28411_28466[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (5))){
var state_28367__$1 = state_28367;
var statearr_28412_28467 = state_28367__$1;
(statearr_28412_28467[(2)] = true);

(statearr_28412_28467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (14))){
var state_28367__$1 = state_28367;
var statearr_28413_28468 = state_28367__$1;
(statearr_28413_28468[(2)] = false);

(statearr_28413_28468[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (26))){
var inst_28327 = (state_28367[(9)]);
var inst_28334 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_28327);
var state_28367__$1 = state_28367;
var statearr_28414_28469 = state_28367__$1;
(statearr_28414_28469[(2)] = inst_28334);

(statearr_28414_28469[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (16))){
var state_28367__$1 = state_28367;
var statearr_28415_28470 = state_28367__$1;
(statearr_28415_28470[(2)] = true);

(statearr_28415_28470[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (38))){
var inst_28357 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
var statearr_28416_28471 = state_28367__$1;
(statearr_28416_28471[(2)] = inst_28357);

(statearr_28416_28471[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (30))){
var inst_28327 = (state_28367[(9)]);
var inst_28321 = (state_28367[(13)]);
var inst_28320 = (state_28367[(11)]);
var inst_28344 = cljs.core.empty_QMARK_.call(null,inst_28320);
var inst_28345 = inst_28321.call(null,inst_28327);
var inst_28346 = cljs.core.not.call(null,inst_28345);
var inst_28347 = (inst_28344) && (inst_28346);
var state_28367__$1 = state_28367;
var statearr_28417_28472 = state_28367__$1;
(statearr_28417_28472[(2)] = inst_28347);

(statearr_28417_28472[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (10))){
var inst_28273 = (state_28367[(8)]);
var inst_28293 = (state_28367[(2)]);
var inst_28294 = cljs.core.get.call(null,inst_28293,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_28295 = cljs.core.get.call(null,inst_28293,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_28296 = cljs.core.get.call(null,inst_28293,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_28297 = inst_28273;
var state_28367__$1 = (function (){var statearr_28418 = state_28367;
(statearr_28418[(16)] = inst_28296);

(statearr_28418[(7)] = inst_28297);

(statearr_28418[(17)] = inst_28294);

(statearr_28418[(18)] = inst_28295);

return statearr_28418;
})();
var statearr_28419_28473 = state_28367__$1;
(statearr_28419_28473[(2)] = null);

(statearr_28419_28473[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (18))){
var inst_28311 = (state_28367[(2)]);
var state_28367__$1 = state_28367;
var statearr_28420_28474 = state_28367__$1;
(statearr_28420_28474[(2)] = inst_28311);

(statearr_28420_28474[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (37))){
var state_28367__$1 = state_28367;
var statearr_28421_28475 = state_28367__$1;
(statearr_28421_28475[(2)] = null);

(statearr_28421_28475[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28368 === (8))){
var inst_28273 = (state_28367[(8)]);
var inst_28290 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28273);
var state_28367__$1 = state_28367;
var statearr_28422_28476 = state_28367__$1;
(statearr_28422_28476[(2)] = inst_28290);

(statearr_28422_28476[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___28430,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__26605__auto__,c__26717__auto___28430,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__26606__auto__ = null;
var cljs$core$async$mix_$_state_machine__26606__auto____0 = (function (){
var statearr_28426 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28426[(0)] = cljs$core$async$mix_$_state_machine__26606__auto__);

(statearr_28426[(1)] = (1));

return statearr_28426;
});
var cljs$core$async$mix_$_state_machine__26606__auto____1 = (function (state_28367){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_28367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e28427){if((e28427 instanceof Object)){
var ex__26609__auto__ = e28427;
var statearr_28428_28477 = state_28367;
(statearr_28428_28477[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28367);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28427;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28478 = state_28367;
state_28367 = G__28478;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__26606__auto__ = function(state_28367){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__26606__auto____1.call(this,state_28367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__26606__auto____0;
cljs$core$async$mix_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__26606__auto____1;
return cljs$core$async$mix_$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___28430,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__26719__auto__ = (function (){var statearr_28429 = f__26718__auto__.call(null);
(statearr_28429[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___28430);

return statearr_28429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___28430,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__25214__auto__ = (((p == null))?null:p);
var m__25215__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__25215__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__25214__auto__ = (((p == null))?null:p);
var m__25215__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,p,v,ch);
} else {
var m__25215__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args28479 = [];
var len__25620__auto___28482 = arguments.length;
var i__25621__auto___28483 = (0);
while(true){
if((i__25621__auto___28483 < len__25620__auto___28482)){
args28479.push((arguments[i__25621__auto___28483]));

var G__28484 = (i__25621__auto___28483 + (1));
i__25621__auto___28483 = G__28484;
continue;
} else {
}
break;
}

var G__28481 = args28479.length;
switch (G__28481) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28479.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__25214__auto__ = (((p == null))?null:p);
var m__25215__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,p);
} else {
var m__25215__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__25214__auto__ = (((p == null))?null:p);
var m__25215__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__25214__auto__)]);
if(!((m__25215__auto__ == null))){
return m__25215__auto__.call(null,p,v);
} else {
var m__25215__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__25215__auto____$1 == null))){
return m__25215__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args28487 = [];
var len__25620__auto___28612 = arguments.length;
var i__25621__auto___28613 = (0);
while(true){
if((i__25621__auto___28613 < len__25620__auto___28612)){
args28487.push((arguments[i__25621__auto___28613]));

var G__28614 = (i__25621__auto___28613 + (1));
i__25621__auto___28613 = G__28614;
continue;
} else {
}
break;
}

var G__28489 = args28487.length;
switch (G__28489) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28487.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__24551__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__24551__auto__,mults){
return (function (p1__28486_SHARP_){
if(cljs.core.truth_(p1__28486_SHARP_.call(null,topic))){
return p1__28486_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__28486_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__24551__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async28490 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28490 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta28491){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta28491 = meta28491;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_28492,meta28491__$1){
var self__ = this;
var _28492__$1 = this;
return (new cljs.core.async.t_cljs$core$async28490(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta28491__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_28492){
var self__ = this;
var _28492__$1 = this;
return self__.meta28491;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta28491","meta28491",1699691855,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async28490.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28490.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28490";

cljs.core.async.t_cljs$core$async28490.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async28490");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async28490 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async28490(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28491){
return (new cljs.core.async.t_cljs$core$async28490(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta28491));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async28490(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26717__auto___28616 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___28616,mults,ensure_mult,p){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___28616,mults,ensure_mult,p){
return (function (state_28564){
var state_val_28565 = (state_28564[(1)]);
if((state_val_28565 === (7))){
var inst_28560 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
var statearr_28566_28617 = state_28564__$1;
(statearr_28566_28617[(2)] = inst_28560);

(statearr_28566_28617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (20))){
var state_28564__$1 = state_28564;
var statearr_28567_28618 = state_28564__$1;
(statearr_28567_28618[(2)] = null);

(statearr_28567_28618[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (1))){
var state_28564__$1 = state_28564;
var statearr_28568_28619 = state_28564__$1;
(statearr_28568_28619[(2)] = null);

(statearr_28568_28619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (24))){
var inst_28543 = (state_28564[(7)]);
var inst_28552 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_28543);
var state_28564__$1 = state_28564;
var statearr_28569_28620 = state_28564__$1;
(statearr_28569_28620[(2)] = inst_28552);

(statearr_28569_28620[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (4))){
var inst_28495 = (state_28564[(8)]);
var inst_28495__$1 = (state_28564[(2)]);
var inst_28496 = (inst_28495__$1 == null);
var state_28564__$1 = (function (){var statearr_28570 = state_28564;
(statearr_28570[(8)] = inst_28495__$1);

return statearr_28570;
})();
if(cljs.core.truth_(inst_28496)){
var statearr_28571_28621 = state_28564__$1;
(statearr_28571_28621[(1)] = (5));

} else {
var statearr_28572_28622 = state_28564__$1;
(statearr_28572_28622[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (15))){
var inst_28537 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
var statearr_28573_28623 = state_28564__$1;
(statearr_28573_28623[(2)] = inst_28537);

(statearr_28573_28623[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (21))){
var inst_28557 = (state_28564[(2)]);
var state_28564__$1 = (function (){var statearr_28574 = state_28564;
(statearr_28574[(9)] = inst_28557);

return statearr_28574;
})();
var statearr_28575_28624 = state_28564__$1;
(statearr_28575_28624[(2)] = null);

(statearr_28575_28624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (13))){
var inst_28519 = (state_28564[(10)]);
var inst_28521 = cljs.core.chunked_seq_QMARK_.call(null,inst_28519);
var state_28564__$1 = state_28564;
if(inst_28521){
var statearr_28576_28625 = state_28564__$1;
(statearr_28576_28625[(1)] = (16));

} else {
var statearr_28577_28626 = state_28564__$1;
(statearr_28577_28626[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (22))){
var inst_28549 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
if(cljs.core.truth_(inst_28549)){
var statearr_28578_28627 = state_28564__$1;
(statearr_28578_28627[(1)] = (23));

} else {
var statearr_28579_28628 = state_28564__$1;
(statearr_28579_28628[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (6))){
var inst_28545 = (state_28564[(11)]);
var inst_28495 = (state_28564[(8)]);
var inst_28543 = (state_28564[(7)]);
var inst_28543__$1 = topic_fn.call(null,inst_28495);
var inst_28544 = cljs.core.deref.call(null,mults);
var inst_28545__$1 = cljs.core.get.call(null,inst_28544,inst_28543__$1);
var state_28564__$1 = (function (){var statearr_28580 = state_28564;
(statearr_28580[(11)] = inst_28545__$1);

(statearr_28580[(7)] = inst_28543__$1);

return statearr_28580;
})();
if(cljs.core.truth_(inst_28545__$1)){
var statearr_28581_28629 = state_28564__$1;
(statearr_28581_28629[(1)] = (19));

} else {
var statearr_28582_28630 = state_28564__$1;
(statearr_28582_28630[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (25))){
var inst_28554 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
var statearr_28583_28631 = state_28564__$1;
(statearr_28583_28631[(2)] = inst_28554);

(statearr_28583_28631[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (17))){
var inst_28519 = (state_28564[(10)]);
var inst_28528 = cljs.core.first.call(null,inst_28519);
var inst_28529 = cljs.core.async.muxch_STAR_.call(null,inst_28528);
var inst_28530 = cljs.core.async.close_BANG_.call(null,inst_28529);
var inst_28531 = cljs.core.next.call(null,inst_28519);
var inst_28505 = inst_28531;
var inst_28506 = null;
var inst_28507 = (0);
var inst_28508 = (0);
var state_28564__$1 = (function (){var statearr_28584 = state_28564;
(statearr_28584[(12)] = inst_28507);

(statearr_28584[(13)] = inst_28505);

(statearr_28584[(14)] = inst_28508);

(statearr_28584[(15)] = inst_28530);

(statearr_28584[(16)] = inst_28506);

return statearr_28584;
})();
var statearr_28585_28632 = state_28564__$1;
(statearr_28585_28632[(2)] = null);

(statearr_28585_28632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (3))){
var inst_28562 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28564__$1,inst_28562);
} else {
if((state_val_28565 === (12))){
var inst_28539 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
var statearr_28586_28633 = state_28564__$1;
(statearr_28586_28633[(2)] = inst_28539);

(statearr_28586_28633[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (2))){
var state_28564__$1 = state_28564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28564__$1,(4),ch);
} else {
if((state_val_28565 === (23))){
var state_28564__$1 = state_28564;
var statearr_28587_28634 = state_28564__$1;
(statearr_28587_28634[(2)] = null);

(statearr_28587_28634[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (19))){
var inst_28545 = (state_28564[(11)]);
var inst_28495 = (state_28564[(8)]);
var inst_28547 = cljs.core.async.muxch_STAR_.call(null,inst_28545);
var state_28564__$1 = state_28564;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28564__$1,(22),inst_28547,inst_28495);
} else {
if((state_val_28565 === (11))){
var inst_28505 = (state_28564[(13)]);
var inst_28519 = (state_28564[(10)]);
var inst_28519__$1 = cljs.core.seq.call(null,inst_28505);
var state_28564__$1 = (function (){var statearr_28588 = state_28564;
(statearr_28588[(10)] = inst_28519__$1);

return statearr_28588;
})();
if(inst_28519__$1){
var statearr_28589_28635 = state_28564__$1;
(statearr_28589_28635[(1)] = (13));

} else {
var statearr_28590_28636 = state_28564__$1;
(statearr_28590_28636[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (9))){
var inst_28541 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
var statearr_28591_28637 = state_28564__$1;
(statearr_28591_28637[(2)] = inst_28541);

(statearr_28591_28637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (5))){
var inst_28502 = cljs.core.deref.call(null,mults);
var inst_28503 = cljs.core.vals.call(null,inst_28502);
var inst_28504 = cljs.core.seq.call(null,inst_28503);
var inst_28505 = inst_28504;
var inst_28506 = null;
var inst_28507 = (0);
var inst_28508 = (0);
var state_28564__$1 = (function (){var statearr_28592 = state_28564;
(statearr_28592[(12)] = inst_28507);

(statearr_28592[(13)] = inst_28505);

(statearr_28592[(14)] = inst_28508);

(statearr_28592[(16)] = inst_28506);

return statearr_28592;
})();
var statearr_28593_28638 = state_28564__$1;
(statearr_28593_28638[(2)] = null);

(statearr_28593_28638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (14))){
var state_28564__$1 = state_28564;
var statearr_28597_28639 = state_28564__$1;
(statearr_28597_28639[(2)] = null);

(statearr_28597_28639[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (16))){
var inst_28519 = (state_28564[(10)]);
var inst_28523 = cljs.core.chunk_first.call(null,inst_28519);
var inst_28524 = cljs.core.chunk_rest.call(null,inst_28519);
var inst_28525 = cljs.core.count.call(null,inst_28523);
var inst_28505 = inst_28524;
var inst_28506 = inst_28523;
var inst_28507 = inst_28525;
var inst_28508 = (0);
var state_28564__$1 = (function (){var statearr_28598 = state_28564;
(statearr_28598[(12)] = inst_28507);

(statearr_28598[(13)] = inst_28505);

(statearr_28598[(14)] = inst_28508);

(statearr_28598[(16)] = inst_28506);

return statearr_28598;
})();
var statearr_28599_28640 = state_28564__$1;
(statearr_28599_28640[(2)] = null);

(statearr_28599_28640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (10))){
var inst_28507 = (state_28564[(12)]);
var inst_28505 = (state_28564[(13)]);
var inst_28508 = (state_28564[(14)]);
var inst_28506 = (state_28564[(16)]);
var inst_28513 = cljs.core._nth.call(null,inst_28506,inst_28508);
var inst_28514 = cljs.core.async.muxch_STAR_.call(null,inst_28513);
var inst_28515 = cljs.core.async.close_BANG_.call(null,inst_28514);
var inst_28516 = (inst_28508 + (1));
var tmp28594 = inst_28507;
var tmp28595 = inst_28505;
var tmp28596 = inst_28506;
var inst_28505__$1 = tmp28595;
var inst_28506__$1 = tmp28596;
var inst_28507__$1 = tmp28594;
var inst_28508__$1 = inst_28516;
var state_28564__$1 = (function (){var statearr_28600 = state_28564;
(statearr_28600[(12)] = inst_28507__$1);

(statearr_28600[(13)] = inst_28505__$1);

(statearr_28600[(14)] = inst_28508__$1);

(statearr_28600[(17)] = inst_28515);

(statearr_28600[(16)] = inst_28506__$1);

return statearr_28600;
})();
var statearr_28601_28641 = state_28564__$1;
(statearr_28601_28641[(2)] = null);

(statearr_28601_28641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (18))){
var inst_28534 = (state_28564[(2)]);
var state_28564__$1 = state_28564;
var statearr_28602_28642 = state_28564__$1;
(statearr_28602_28642[(2)] = inst_28534);

(statearr_28602_28642[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28565 === (8))){
var inst_28507 = (state_28564[(12)]);
var inst_28508 = (state_28564[(14)]);
var inst_28510 = (inst_28508 < inst_28507);
var inst_28511 = inst_28510;
var state_28564__$1 = state_28564;
if(cljs.core.truth_(inst_28511)){
var statearr_28603_28643 = state_28564__$1;
(statearr_28603_28643[(1)] = (10));

} else {
var statearr_28604_28644 = state_28564__$1;
(statearr_28604_28644[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___28616,mults,ensure_mult,p))
;
return ((function (switch__26605__auto__,c__26717__auto___28616,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_28608 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28608[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_28608[(1)] = (1));

return statearr_28608;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_28564){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_28564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e28609){if((e28609 instanceof Object)){
var ex__26609__auto__ = e28609;
var statearr_28610_28645 = state_28564;
(statearr_28610_28645[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28609;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28646 = state_28564;
state_28564 = G__28646;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_28564){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_28564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___28616,mults,ensure_mult,p))
})();
var state__26719__auto__ = (function (){var statearr_28611 = f__26718__auto__.call(null);
(statearr_28611[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___28616);

return statearr_28611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___28616,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args28647 = [];
var len__25620__auto___28650 = arguments.length;
var i__25621__auto___28651 = (0);
while(true){
if((i__25621__auto___28651 < len__25620__auto___28650)){
args28647.push((arguments[i__25621__auto___28651]));

var G__28652 = (i__25621__auto___28651 + (1));
i__25621__auto___28651 = G__28652;
continue;
} else {
}
break;
}

var G__28649 = args28647.length;
switch (G__28649) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28647.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args28654 = [];
var len__25620__auto___28657 = arguments.length;
var i__25621__auto___28658 = (0);
while(true){
if((i__25621__auto___28658 < len__25620__auto___28657)){
args28654.push((arguments[i__25621__auto___28658]));

var G__28659 = (i__25621__auto___28658 + (1));
i__25621__auto___28658 = G__28659;
continue;
} else {
}
break;
}

var G__28656 = args28654.length;
switch (G__28656) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28654.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args28661 = [];
var len__25620__auto___28732 = arguments.length;
var i__25621__auto___28733 = (0);
while(true){
if((i__25621__auto___28733 < len__25620__auto___28732)){
args28661.push((arguments[i__25621__auto___28733]));

var G__28734 = (i__25621__auto___28733 + (1));
i__25621__auto___28733 = G__28734;
continue;
} else {
}
break;
}

var G__28663 = args28661.length;
switch (G__28663) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28661.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__26717__auto___28736 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___28736,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___28736,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_28702){
var state_val_28703 = (state_28702[(1)]);
if((state_val_28703 === (7))){
var state_28702__$1 = state_28702;
var statearr_28704_28737 = state_28702__$1;
(statearr_28704_28737[(2)] = null);

(statearr_28704_28737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (1))){
var state_28702__$1 = state_28702;
var statearr_28705_28738 = state_28702__$1;
(statearr_28705_28738[(2)] = null);

(statearr_28705_28738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (4))){
var inst_28666 = (state_28702[(7)]);
var inst_28668 = (inst_28666 < cnt);
var state_28702__$1 = state_28702;
if(cljs.core.truth_(inst_28668)){
var statearr_28706_28739 = state_28702__$1;
(statearr_28706_28739[(1)] = (6));

} else {
var statearr_28707_28740 = state_28702__$1;
(statearr_28707_28740[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (15))){
var inst_28698 = (state_28702[(2)]);
var state_28702__$1 = state_28702;
var statearr_28708_28741 = state_28702__$1;
(statearr_28708_28741[(2)] = inst_28698);

(statearr_28708_28741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (13))){
var inst_28691 = cljs.core.async.close_BANG_.call(null,out);
var state_28702__$1 = state_28702;
var statearr_28709_28742 = state_28702__$1;
(statearr_28709_28742[(2)] = inst_28691);

(statearr_28709_28742[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (6))){
var state_28702__$1 = state_28702;
var statearr_28710_28743 = state_28702__$1;
(statearr_28710_28743[(2)] = null);

(statearr_28710_28743[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (3))){
var inst_28700 = (state_28702[(2)]);
var state_28702__$1 = state_28702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28702__$1,inst_28700);
} else {
if((state_val_28703 === (12))){
var inst_28688 = (state_28702[(8)]);
var inst_28688__$1 = (state_28702[(2)]);
var inst_28689 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_28688__$1);
var state_28702__$1 = (function (){var statearr_28711 = state_28702;
(statearr_28711[(8)] = inst_28688__$1);

return statearr_28711;
})();
if(cljs.core.truth_(inst_28689)){
var statearr_28712_28744 = state_28702__$1;
(statearr_28712_28744[(1)] = (13));

} else {
var statearr_28713_28745 = state_28702__$1;
(statearr_28713_28745[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (2))){
var inst_28665 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_28666 = (0);
var state_28702__$1 = (function (){var statearr_28714 = state_28702;
(statearr_28714[(9)] = inst_28665);

(statearr_28714[(7)] = inst_28666);

return statearr_28714;
})();
var statearr_28715_28746 = state_28702__$1;
(statearr_28715_28746[(2)] = null);

(statearr_28715_28746[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (11))){
var inst_28666 = (state_28702[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_28702,(10),Object,null,(9));
var inst_28675 = chs__$1.call(null,inst_28666);
var inst_28676 = done.call(null,inst_28666);
var inst_28677 = cljs.core.async.take_BANG_.call(null,inst_28675,inst_28676);
var state_28702__$1 = state_28702;
var statearr_28716_28747 = state_28702__$1;
(statearr_28716_28747[(2)] = inst_28677);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28702__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (9))){
var inst_28666 = (state_28702[(7)]);
var inst_28679 = (state_28702[(2)]);
var inst_28680 = (inst_28666 + (1));
var inst_28666__$1 = inst_28680;
var state_28702__$1 = (function (){var statearr_28717 = state_28702;
(statearr_28717[(10)] = inst_28679);

(statearr_28717[(7)] = inst_28666__$1);

return statearr_28717;
})();
var statearr_28718_28748 = state_28702__$1;
(statearr_28718_28748[(2)] = null);

(statearr_28718_28748[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (5))){
var inst_28686 = (state_28702[(2)]);
var state_28702__$1 = (function (){var statearr_28719 = state_28702;
(statearr_28719[(11)] = inst_28686);

return statearr_28719;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28702__$1,(12),dchan);
} else {
if((state_val_28703 === (14))){
var inst_28688 = (state_28702[(8)]);
var inst_28693 = cljs.core.apply.call(null,f,inst_28688);
var state_28702__$1 = state_28702;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28702__$1,(16),out,inst_28693);
} else {
if((state_val_28703 === (16))){
var inst_28695 = (state_28702[(2)]);
var state_28702__$1 = (function (){var statearr_28720 = state_28702;
(statearr_28720[(12)] = inst_28695);

return statearr_28720;
})();
var statearr_28721_28749 = state_28702__$1;
(statearr_28721_28749[(2)] = null);

(statearr_28721_28749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (10))){
var inst_28670 = (state_28702[(2)]);
var inst_28671 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_28702__$1 = (function (){var statearr_28722 = state_28702;
(statearr_28722[(13)] = inst_28670);

return statearr_28722;
})();
var statearr_28723_28750 = state_28702__$1;
(statearr_28723_28750[(2)] = inst_28671);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28702__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28703 === (8))){
var inst_28684 = (state_28702[(2)]);
var state_28702__$1 = state_28702;
var statearr_28724_28751 = state_28702__$1;
(statearr_28724_28751[(2)] = inst_28684);

(statearr_28724_28751[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___28736,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__26605__auto__,c__26717__auto___28736,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_28728 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28728[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_28728[(1)] = (1));

return statearr_28728;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_28702){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_28702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e28729){if((e28729 instanceof Object)){
var ex__26609__auto__ = e28729;
var statearr_28730_28752 = state_28702;
(statearr_28730_28752[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28702);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28729;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28753 = state_28702;
state_28702 = G__28753;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_28702){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_28702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___28736,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__26719__auto__ = (function (){var statearr_28731 = f__26718__auto__.call(null);
(statearr_28731[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___28736);

return statearr_28731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___28736,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args28755 = [];
var len__25620__auto___28811 = arguments.length;
var i__25621__auto___28812 = (0);
while(true){
if((i__25621__auto___28812 < len__25620__auto___28811)){
args28755.push((arguments[i__25621__auto___28812]));

var G__28813 = (i__25621__auto___28812 + (1));
i__25621__auto___28812 = G__28813;
continue;
} else {
}
break;
}

var G__28757 = args28755.length;
switch (G__28757) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28755.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26717__auto___28815 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___28815,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___28815,out){
return (function (state_28787){
var state_val_28788 = (state_28787[(1)]);
if((state_val_28788 === (7))){
var inst_28766 = (state_28787[(7)]);
var inst_28767 = (state_28787[(8)]);
var inst_28766__$1 = (state_28787[(2)]);
var inst_28767__$1 = cljs.core.nth.call(null,inst_28766__$1,(0),null);
var inst_28768 = cljs.core.nth.call(null,inst_28766__$1,(1),null);
var inst_28769 = (inst_28767__$1 == null);
var state_28787__$1 = (function (){var statearr_28789 = state_28787;
(statearr_28789[(9)] = inst_28768);

(statearr_28789[(7)] = inst_28766__$1);

(statearr_28789[(8)] = inst_28767__$1);

return statearr_28789;
})();
if(cljs.core.truth_(inst_28769)){
var statearr_28790_28816 = state_28787__$1;
(statearr_28790_28816[(1)] = (8));

} else {
var statearr_28791_28817 = state_28787__$1;
(statearr_28791_28817[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28788 === (1))){
var inst_28758 = cljs.core.vec.call(null,chs);
var inst_28759 = inst_28758;
var state_28787__$1 = (function (){var statearr_28792 = state_28787;
(statearr_28792[(10)] = inst_28759);

return statearr_28792;
})();
var statearr_28793_28818 = state_28787__$1;
(statearr_28793_28818[(2)] = null);

(statearr_28793_28818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28788 === (4))){
var inst_28759 = (state_28787[(10)]);
var state_28787__$1 = state_28787;
return cljs.core.async.ioc_alts_BANG_.call(null,state_28787__$1,(7),inst_28759);
} else {
if((state_val_28788 === (6))){
var inst_28783 = (state_28787[(2)]);
var state_28787__$1 = state_28787;
var statearr_28794_28819 = state_28787__$1;
(statearr_28794_28819[(2)] = inst_28783);

(statearr_28794_28819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28788 === (3))){
var inst_28785 = (state_28787[(2)]);
var state_28787__$1 = state_28787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28787__$1,inst_28785);
} else {
if((state_val_28788 === (2))){
var inst_28759 = (state_28787[(10)]);
var inst_28761 = cljs.core.count.call(null,inst_28759);
var inst_28762 = (inst_28761 > (0));
var state_28787__$1 = state_28787;
if(cljs.core.truth_(inst_28762)){
var statearr_28796_28820 = state_28787__$1;
(statearr_28796_28820[(1)] = (4));

} else {
var statearr_28797_28821 = state_28787__$1;
(statearr_28797_28821[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28788 === (11))){
var inst_28759 = (state_28787[(10)]);
var inst_28776 = (state_28787[(2)]);
var tmp28795 = inst_28759;
var inst_28759__$1 = tmp28795;
var state_28787__$1 = (function (){var statearr_28798 = state_28787;
(statearr_28798[(10)] = inst_28759__$1);

(statearr_28798[(11)] = inst_28776);

return statearr_28798;
})();
var statearr_28799_28822 = state_28787__$1;
(statearr_28799_28822[(2)] = null);

(statearr_28799_28822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28788 === (9))){
var inst_28767 = (state_28787[(8)]);
var state_28787__$1 = state_28787;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28787__$1,(11),out,inst_28767);
} else {
if((state_val_28788 === (5))){
var inst_28781 = cljs.core.async.close_BANG_.call(null,out);
var state_28787__$1 = state_28787;
var statearr_28800_28823 = state_28787__$1;
(statearr_28800_28823[(2)] = inst_28781);

(statearr_28800_28823[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28788 === (10))){
var inst_28779 = (state_28787[(2)]);
var state_28787__$1 = state_28787;
var statearr_28801_28824 = state_28787__$1;
(statearr_28801_28824[(2)] = inst_28779);

(statearr_28801_28824[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28788 === (8))){
var inst_28759 = (state_28787[(10)]);
var inst_28768 = (state_28787[(9)]);
var inst_28766 = (state_28787[(7)]);
var inst_28767 = (state_28787[(8)]);
var inst_28771 = (function (){var cs = inst_28759;
var vec__28764 = inst_28766;
var v = inst_28767;
var c = inst_28768;
return ((function (cs,vec__28764,v,c,inst_28759,inst_28768,inst_28766,inst_28767,state_val_28788,c__26717__auto___28815,out){
return (function (p1__28754_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__28754_SHARP_);
});
;})(cs,vec__28764,v,c,inst_28759,inst_28768,inst_28766,inst_28767,state_val_28788,c__26717__auto___28815,out))
})();
var inst_28772 = cljs.core.filterv.call(null,inst_28771,inst_28759);
var inst_28759__$1 = inst_28772;
var state_28787__$1 = (function (){var statearr_28802 = state_28787;
(statearr_28802[(10)] = inst_28759__$1);

return statearr_28802;
})();
var statearr_28803_28825 = state_28787__$1;
(statearr_28803_28825[(2)] = null);

(statearr_28803_28825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___28815,out))
;
return ((function (switch__26605__auto__,c__26717__auto___28815,out){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_28807 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28807[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_28807[(1)] = (1));

return statearr_28807;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_28787){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_28787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e28808){if((e28808 instanceof Object)){
var ex__26609__auto__ = e28808;
var statearr_28809_28826 = state_28787;
(statearr_28809_28826[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28787);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28808;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28827 = state_28787;
state_28787 = G__28827;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_28787){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_28787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___28815,out))
})();
var state__26719__auto__ = (function (){var statearr_28810 = f__26718__auto__.call(null);
(statearr_28810[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___28815);

return statearr_28810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___28815,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args28828 = [];
var len__25620__auto___28877 = arguments.length;
var i__25621__auto___28878 = (0);
while(true){
if((i__25621__auto___28878 < len__25620__auto___28877)){
args28828.push((arguments[i__25621__auto___28878]));

var G__28879 = (i__25621__auto___28878 + (1));
i__25621__auto___28878 = G__28879;
continue;
} else {
}
break;
}

var G__28830 = args28828.length;
switch (G__28830) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28828.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26717__auto___28881 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___28881,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___28881,out){
return (function (state_28854){
var state_val_28855 = (state_28854[(1)]);
if((state_val_28855 === (7))){
var inst_28836 = (state_28854[(7)]);
var inst_28836__$1 = (state_28854[(2)]);
var inst_28837 = (inst_28836__$1 == null);
var inst_28838 = cljs.core.not.call(null,inst_28837);
var state_28854__$1 = (function (){var statearr_28856 = state_28854;
(statearr_28856[(7)] = inst_28836__$1);

return statearr_28856;
})();
if(inst_28838){
var statearr_28857_28882 = state_28854__$1;
(statearr_28857_28882[(1)] = (8));

} else {
var statearr_28858_28883 = state_28854__$1;
(statearr_28858_28883[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (1))){
var inst_28831 = (0);
var state_28854__$1 = (function (){var statearr_28859 = state_28854;
(statearr_28859[(8)] = inst_28831);

return statearr_28859;
})();
var statearr_28860_28884 = state_28854__$1;
(statearr_28860_28884[(2)] = null);

(statearr_28860_28884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (4))){
var state_28854__$1 = state_28854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28854__$1,(7),ch);
} else {
if((state_val_28855 === (6))){
var inst_28849 = (state_28854[(2)]);
var state_28854__$1 = state_28854;
var statearr_28861_28885 = state_28854__$1;
(statearr_28861_28885[(2)] = inst_28849);

(statearr_28861_28885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (3))){
var inst_28851 = (state_28854[(2)]);
var inst_28852 = cljs.core.async.close_BANG_.call(null,out);
var state_28854__$1 = (function (){var statearr_28862 = state_28854;
(statearr_28862[(9)] = inst_28851);

return statearr_28862;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28854__$1,inst_28852);
} else {
if((state_val_28855 === (2))){
var inst_28831 = (state_28854[(8)]);
var inst_28833 = (inst_28831 < n);
var state_28854__$1 = state_28854;
if(cljs.core.truth_(inst_28833)){
var statearr_28863_28886 = state_28854__$1;
(statearr_28863_28886[(1)] = (4));

} else {
var statearr_28864_28887 = state_28854__$1;
(statearr_28864_28887[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (11))){
var inst_28831 = (state_28854[(8)]);
var inst_28841 = (state_28854[(2)]);
var inst_28842 = (inst_28831 + (1));
var inst_28831__$1 = inst_28842;
var state_28854__$1 = (function (){var statearr_28865 = state_28854;
(statearr_28865[(8)] = inst_28831__$1);

(statearr_28865[(10)] = inst_28841);

return statearr_28865;
})();
var statearr_28866_28888 = state_28854__$1;
(statearr_28866_28888[(2)] = null);

(statearr_28866_28888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (9))){
var state_28854__$1 = state_28854;
var statearr_28867_28889 = state_28854__$1;
(statearr_28867_28889[(2)] = null);

(statearr_28867_28889[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (5))){
var state_28854__$1 = state_28854;
var statearr_28868_28890 = state_28854__$1;
(statearr_28868_28890[(2)] = null);

(statearr_28868_28890[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (10))){
var inst_28846 = (state_28854[(2)]);
var state_28854__$1 = state_28854;
var statearr_28869_28891 = state_28854__$1;
(statearr_28869_28891[(2)] = inst_28846);

(statearr_28869_28891[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28855 === (8))){
var inst_28836 = (state_28854[(7)]);
var state_28854__$1 = state_28854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28854__$1,(11),out,inst_28836);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___28881,out))
;
return ((function (switch__26605__auto__,c__26717__auto___28881,out){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_28873 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28873[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_28873[(1)] = (1));

return statearr_28873;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_28854){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_28854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e28874){if((e28874 instanceof Object)){
var ex__26609__auto__ = e28874;
var statearr_28875_28892 = state_28854;
(statearr_28875_28892[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28854);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28874;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28893 = state_28854;
state_28854 = G__28893;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_28854){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_28854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___28881,out))
})();
var state__26719__auto__ = (function (){var statearr_28876 = f__26718__auto__.call(null);
(statearr_28876[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___28881);

return statearr_28876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___28881,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async28901 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28901 = (function (map_LT_,f,ch,meta28902){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta28902 = meta28902;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28903,meta28902__$1){
var self__ = this;
var _28903__$1 = this;
return (new cljs.core.async.t_cljs$core$async28901(self__.map_LT_,self__.f,self__.ch,meta28902__$1));
});

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28903){
var self__ = this;
var _28903__$1 = this;
return self__.meta28902;
});

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async28904 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28904 = (function (map_LT_,f,ch,meta28902,_,fn1,meta28905){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta28902 = meta28902;
this._ = _;
this.fn1 = fn1;
this.meta28905 = meta28905;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28904.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_28906,meta28905__$1){
var self__ = this;
var _28906__$1 = this;
return (new cljs.core.async.t_cljs$core$async28904(self__.map_LT_,self__.f,self__.ch,self__.meta28902,self__._,self__.fn1,meta28905__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async28904.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_28906){
var self__ = this;
var _28906__$1 = this;
return self__.meta28905;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28904.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28904.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28904.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28904.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__28894_SHARP_){
return f1.call(null,(((p1__28894_SHARP_ == null))?null:self__.f.call(null,p1__28894_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async28904.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28902","meta28902",1699365473,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async28901","cljs.core.async/t_cljs$core$async28901",-919351204,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta28905","meta28905",-1894881337,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28904.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28904.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28904";

cljs.core.async.t_cljs$core$async28904.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async28904");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async28904 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28904(map_LT___$1,f__$1,ch__$1,meta28902__$1,___$2,fn1__$1,meta28905){
return (new cljs.core.async.t_cljs$core$async28904(map_LT___$1,f__$1,ch__$1,meta28902__$1,___$2,fn1__$1,meta28905));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async28904(self__.map_LT_,self__.f,self__.ch,self__.meta28902,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__24539__auto__ = ret;
if(cljs.core.truth_(and__24539__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__24539__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async28901.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async28901.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28902","meta28902",1699365473,null)], null);
});

cljs.core.async.t_cljs$core$async28901.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28901.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28901";

cljs.core.async.t_cljs$core$async28901.cljs$lang$ctorPrWriter = (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async28901");
});

cljs.core.async.__GT_t_cljs$core$async28901 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28901(map_LT___$1,f__$1,ch__$1,meta28902){
return (new cljs.core.async.t_cljs$core$async28901(map_LT___$1,f__$1,ch__$1,meta28902));
});

}

return (new cljs.core.async.t_cljs$core$async28901(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async28910 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28910 = (function (map_GT_,f,ch,meta28911){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta28911 = meta28911;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28912,meta28911__$1){
var self__ = this;
var _28912__$1 = this;
return (new cljs.core.async.t_cljs$core$async28910(self__.map_GT_,self__.f,self__.ch,meta28911__$1));
});

cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28912){
var self__ = this;
var _28912__$1 = this;
return self__.meta28911;
});

cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async28910.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async28910.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28911","meta28911",1536085606,null)], null);
});

cljs.core.async.t_cljs$core$async28910.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28910.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28910";

cljs.core.async.t_cljs$core$async28910.cljs$lang$ctorPrWriter = (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async28910");
});

cljs.core.async.__GT_t_cljs$core$async28910 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async28910(map_GT___$1,f__$1,ch__$1,meta28911){
return (new cljs.core.async.t_cljs$core$async28910(map_GT___$1,f__$1,ch__$1,meta28911));
});

}

return (new cljs.core.async.t_cljs$core$async28910(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async28916 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28916 = (function (filter_GT_,p,ch,meta28917){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta28917 = meta28917;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28918,meta28917__$1){
var self__ = this;
var _28918__$1 = this;
return (new cljs.core.async.t_cljs$core$async28916(self__.filter_GT_,self__.p,self__.ch,meta28917__$1));
});

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28918){
var self__ = this;
var _28918__$1 = this;
return self__.meta28917;
});

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async28916.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async28916.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28917","meta28917",-90241060,null)], null);
});

cljs.core.async.t_cljs$core$async28916.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28916.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28916";

cljs.core.async.t_cljs$core$async28916.cljs$lang$ctorPrWriter = (function (this__25157__auto__,writer__25158__auto__,opt__25159__auto__){
return cljs.core._write.call(null,writer__25158__auto__,"cljs.core.async/t_cljs$core$async28916");
});

cljs.core.async.__GT_t_cljs$core$async28916 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async28916(filter_GT___$1,p__$1,ch__$1,meta28917){
return (new cljs.core.async.t_cljs$core$async28916(filter_GT___$1,p__$1,ch__$1,meta28917));
});

}

return (new cljs.core.async.t_cljs$core$async28916(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args28919 = [];
var len__25620__auto___28963 = arguments.length;
var i__25621__auto___28964 = (0);
while(true){
if((i__25621__auto___28964 < len__25620__auto___28963)){
args28919.push((arguments[i__25621__auto___28964]));

var G__28965 = (i__25621__auto___28964 + (1));
i__25621__auto___28964 = G__28965;
continue;
} else {
}
break;
}

var G__28921 = args28919.length;
switch (G__28921) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28919.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26717__auto___28967 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___28967,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___28967,out){
return (function (state_28942){
var state_val_28943 = (state_28942[(1)]);
if((state_val_28943 === (7))){
var inst_28938 = (state_28942[(2)]);
var state_28942__$1 = state_28942;
var statearr_28944_28968 = state_28942__$1;
(statearr_28944_28968[(2)] = inst_28938);

(statearr_28944_28968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (1))){
var state_28942__$1 = state_28942;
var statearr_28945_28969 = state_28942__$1;
(statearr_28945_28969[(2)] = null);

(statearr_28945_28969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (4))){
var inst_28924 = (state_28942[(7)]);
var inst_28924__$1 = (state_28942[(2)]);
var inst_28925 = (inst_28924__$1 == null);
var state_28942__$1 = (function (){var statearr_28946 = state_28942;
(statearr_28946[(7)] = inst_28924__$1);

return statearr_28946;
})();
if(cljs.core.truth_(inst_28925)){
var statearr_28947_28970 = state_28942__$1;
(statearr_28947_28970[(1)] = (5));

} else {
var statearr_28948_28971 = state_28942__$1;
(statearr_28948_28971[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (6))){
var inst_28924 = (state_28942[(7)]);
var inst_28929 = p.call(null,inst_28924);
var state_28942__$1 = state_28942;
if(cljs.core.truth_(inst_28929)){
var statearr_28949_28972 = state_28942__$1;
(statearr_28949_28972[(1)] = (8));

} else {
var statearr_28950_28973 = state_28942__$1;
(statearr_28950_28973[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (3))){
var inst_28940 = (state_28942[(2)]);
var state_28942__$1 = state_28942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28942__$1,inst_28940);
} else {
if((state_val_28943 === (2))){
var state_28942__$1 = state_28942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28942__$1,(4),ch);
} else {
if((state_val_28943 === (11))){
var inst_28932 = (state_28942[(2)]);
var state_28942__$1 = state_28942;
var statearr_28951_28974 = state_28942__$1;
(statearr_28951_28974[(2)] = inst_28932);

(statearr_28951_28974[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (9))){
var state_28942__$1 = state_28942;
var statearr_28952_28975 = state_28942__$1;
(statearr_28952_28975[(2)] = null);

(statearr_28952_28975[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (5))){
var inst_28927 = cljs.core.async.close_BANG_.call(null,out);
var state_28942__$1 = state_28942;
var statearr_28953_28976 = state_28942__$1;
(statearr_28953_28976[(2)] = inst_28927);

(statearr_28953_28976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (10))){
var inst_28935 = (state_28942[(2)]);
var state_28942__$1 = (function (){var statearr_28954 = state_28942;
(statearr_28954[(8)] = inst_28935);

return statearr_28954;
})();
var statearr_28955_28977 = state_28942__$1;
(statearr_28955_28977[(2)] = null);

(statearr_28955_28977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28943 === (8))){
var inst_28924 = (state_28942[(7)]);
var state_28942__$1 = state_28942;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28942__$1,(11),out,inst_28924);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___28967,out))
;
return ((function (switch__26605__auto__,c__26717__auto___28967,out){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_28959 = [null,null,null,null,null,null,null,null,null];
(statearr_28959[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_28959[(1)] = (1));

return statearr_28959;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_28942){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_28942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e28960){if((e28960 instanceof Object)){
var ex__26609__auto__ = e28960;
var statearr_28961_28978 = state_28942;
(statearr_28961_28978[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28942);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28960;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28979 = state_28942;
state_28942 = G__28979;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_28942){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_28942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___28967,out))
})();
var state__26719__auto__ = (function (){var statearr_28962 = f__26718__auto__.call(null);
(statearr_28962[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___28967);

return statearr_28962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___28967,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args28980 = [];
var len__25620__auto___28983 = arguments.length;
var i__25621__auto___28984 = (0);
while(true){
if((i__25621__auto___28984 < len__25620__auto___28983)){
args28980.push((arguments[i__25621__auto___28984]));

var G__28985 = (i__25621__auto___28984 + (1));
i__25621__auto___28984 = G__28985;
continue;
} else {
}
break;
}

var G__28982 = args28980.length;
switch (G__28982) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28980.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__26717__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto__){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto__){
return (function (state_29152){
var state_val_29153 = (state_29152[(1)]);
if((state_val_29153 === (7))){
var inst_29148 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
var statearr_29154_29195 = state_29152__$1;
(statearr_29154_29195[(2)] = inst_29148);

(statearr_29154_29195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (20))){
var inst_29118 = (state_29152[(7)]);
var inst_29129 = (state_29152[(2)]);
var inst_29130 = cljs.core.next.call(null,inst_29118);
var inst_29104 = inst_29130;
var inst_29105 = null;
var inst_29106 = (0);
var inst_29107 = (0);
var state_29152__$1 = (function (){var statearr_29155 = state_29152;
(statearr_29155[(8)] = inst_29105);

(statearr_29155[(9)] = inst_29107);

(statearr_29155[(10)] = inst_29129);

(statearr_29155[(11)] = inst_29104);

(statearr_29155[(12)] = inst_29106);

return statearr_29155;
})();
var statearr_29156_29196 = state_29152__$1;
(statearr_29156_29196[(2)] = null);

(statearr_29156_29196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (1))){
var state_29152__$1 = state_29152;
var statearr_29157_29197 = state_29152__$1;
(statearr_29157_29197[(2)] = null);

(statearr_29157_29197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (4))){
var inst_29093 = (state_29152[(13)]);
var inst_29093__$1 = (state_29152[(2)]);
var inst_29094 = (inst_29093__$1 == null);
var state_29152__$1 = (function (){var statearr_29158 = state_29152;
(statearr_29158[(13)] = inst_29093__$1);

return statearr_29158;
})();
if(cljs.core.truth_(inst_29094)){
var statearr_29159_29198 = state_29152__$1;
(statearr_29159_29198[(1)] = (5));

} else {
var statearr_29160_29199 = state_29152__$1;
(statearr_29160_29199[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (15))){
var state_29152__$1 = state_29152;
var statearr_29164_29200 = state_29152__$1;
(statearr_29164_29200[(2)] = null);

(statearr_29164_29200[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (21))){
var state_29152__$1 = state_29152;
var statearr_29165_29201 = state_29152__$1;
(statearr_29165_29201[(2)] = null);

(statearr_29165_29201[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (13))){
var inst_29105 = (state_29152[(8)]);
var inst_29107 = (state_29152[(9)]);
var inst_29104 = (state_29152[(11)]);
var inst_29106 = (state_29152[(12)]);
var inst_29114 = (state_29152[(2)]);
var inst_29115 = (inst_29107 + (1));
var tmp29161 = inst_29105;
var tmp29162 = inst_29104;
var tmp29163 = inst_29106;
var inst_29104__$1 = tmp29162;
var inst_29105__$1 = tmp29161;
var inst_29106__$1 = tmp29163;
var inst_29107__$1 = inst_29115;
var state_29152__$1 = (function (){var statearr_29166 = state_29152;
(statearr_29166[(8)] = inst_29105__$1);

(statearr_29166[(9)] = inst_29107__$1);

(statearr_29166[(14)] = inst_29114);

(statearr_29166[(11)] = inst_29104__$1);

(statearr_29166[(12)] = inst_29106__$1);

return statearr_29166;
})();
var statearr_29167_29202 = state_29152__$1;
(statearr_29167_29202[(2)] = null);

(statearr_29167_29202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (22))){
var state_29152__$1 = state_29152;
var statearr_29168_29203 = state_29152__$1;
(statearr_29168_29203[(2)] = null);

(statearr_29168_29203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (6))){
var inst_29093 = (state_29152[(13)]);
var inst_29102 = f.call(null,inst_29093);
var inst_29103 = cljs.core.seq.call(null,inst_29102);
var inst_29104 = inst_29103;
var inst_29105 = null;
var inst_29106 = (0);
var inst_29107 = (0);
var state_29152__$1 = (function (){var statearr_29169 = state_29152;
(statearr_29169[(8)] = inst_29105);

(statearr_29169[(9)] = inst_29107);

(statearr_29169[(11)] = inst_29104);

(statearr_29169[(12)] = inst_29106);

return statearr_29169;
})();
var statearr_29170_29204 = state_29152__$1;
(statearr_29170_29204[(2)] = null);

(statearr_29170_29204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (17))){
var inst_29118 = (state_29152[(7)]);
var inst_29122 = cljs.core.chunk_first.call(null,inst_29118);
var inst_29123 = cljs.core.chunk_rest.call(null,inst_29118);
var inst_29124 = cljs.core.count.call(null,inst_29122);
var inst_29104 = inst_29123;
var inst_29105 = inst_29122;
var inst_29106 = inst_29124;
var inst_29107 = (0);
var state_29152__$1 = (function (){var statearr_29171 = state_29152;
(statearr_29171[(8)] = inst_29105);

(statearr_29171[(9)] = inst_29107);

(statearr_29171[(11)] = inst_29104);

(statearr_29171[(12)] = inst_29106);

return statearr_29171;
})();
var statearr_29172_29205 = state_29152__$1;
(statearr_29172_29205[(2)] = null);

(statearr_29172_29205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (3))){
var inst_29150 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29152__$1,inst_29150);
} else {
if((state_val_29153 === (12))){
var inst_29138 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
var statearr_29173_29206 = state_29152__$1;
(statearr_29173_29206[(2)] = inst_29138);

(statearr_29173_29206[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (2))){
var state_29152__$1 = state_29152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29152__$1,(4),in$);
} else {
if((state_val_29153 === (23))){
var inst_29146 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
var statearr_29174_29207 = state_29152__$1;
(statearr_29174_29207[(2)] = inst_29146);

(statearr_29174_29207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (19))){
var inst_29133 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
var statearr_29175_29208 = state_29152__$1;
(statearr_29175_29208[(2)] = inst_29133);

(statearr_29175_29208[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (11))){
var inst_29118 = (state_29152[(7)]);
var inst_29104 = (state_29152[(11)]);
var inst_29118__$1 = cljs.core.seq.call(null,inst_29104);
var state_29152__$1 = (function (){var statearr_29176 = state_29152;
(statearr_29176[(7)] = inst_29118__$1);

return statearr_29176;
})();
if(inst_29118__$1){
var statearr_29177_29209 = state_29152__$1;
(statearr_29177_29209[(1)] = (14));

} else {
var statearr_29178_29210 = state_29152__$1;
(statearr_29178_29210[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (9))){
var inst_29140 = (state_29152[(2)]);
var inst_29141 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_29152__$1 = (function (){var statearr_29179 = state_29152;
(statearr_29179[(15)] = inst_29140);

return statearr_29179;
})();
if(cljs.core.truth_(inst_29141)){
var statearr_29180_29211 = state_29152__$1;
(statearr_29180_29211[(1)] = (21));

} else {
var statearr_29181_29212 = state_29152__$1;
(statearr_29181_29212[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (5))){
var inst_29096 = cljs.core.async.close_BANG_.call(null,out);
var state_29152__$1 = state_29152;
var statearr_29182_29213 = state_29152__$1;
(statearr_29182_29213[(2)] = inst_29096);

(statearr_29182_29213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (14))){
var inst_29118 = (state_29152[(7)]);
var inst_29120 = cljs.core.chunked_seq_QMARK_.call(null,inst_29118);
var state_29152__$1 = state_29152;
if(inst_29120){
var statearr_29183_29214 = state_29152__$1;
(statearr_29183_29214[(1)] = (17));

} else {
var statearr_29184_29215 = state_29152__$1;
(statearr_29184_29215[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (16))){
var inst_29136 = (state_29152[(2)]);
var state_29152__$1 = state_29152;
var statearr_29185_29216 = state_29152__$1;
(statearr_29185_29216[(2)] = inst_29136);

(statearr_29185_29216[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29153 === (10))){
var inst_29105 = (state_29152[(8)]);
var inst_29107 = (state_29152[(9)]);
var inst_29112 = cljs.core._nth.call(null,inst_29105,inst_29107);
var state_29152__$1 = state_29152;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29152__$1,(13),out,inst_29112);
} else {
if((state_val_29153 === (18))){
var inst_29118 = (state_29152[(7)]);
var inst_29127 = cljs.core.first.call(null,inst_29118);
var state_29152__$1 = state_29152;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29152__$1,(20),out,inst_29127);
} else {
if((state_val_29153 === (8))){
var inst_29107 = (state_29152[(9)]);
var inst_29106 = (state_29152[(12)]);
var inst_29109 = (inst_29107 < inst_29106);
var inst_29110 = inst_29109;
var state_29152__$1 = state_29152;
if(cljs.core.truth_(inst_29110)){
var statearr_29186_29217 = state_29152__$1;
(statearr_29186_29217[(1)] = (10));

} else {
var statearr_29187_29218 = state_29152__$1;
(statearr_29187_29218[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto__))
;
return ((function (switch__26605__auto__,c__26717__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__26606__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__26606__auto____0 = (function (){
var statearr_29191 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29191[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__26606__auto__);

(statearr_29191[(1)] = (1));

return statearr_29191;
});
var cljs$core$async$mapcat_STAR__$_state_machine__26606__auto____1 = (function (state_29152){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_29152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e29192){if((e29192 instanceof Object)){
var ex__26609__auto__ = e29192;
var statearr_29193_29219 = state_29152;
(statearr_29193_29219[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29192;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29220 = state_29152;
state_29152 = G__29220;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__26606__auto__ = function(state_29152){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__26606__auto____1.call(this,state_29152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__26606__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__26606__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto__))
})();
var state__26719__auto__ = (function (){var statearr_29194 = f__26718__auto__.call(null);
(statearr_29194[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto__);

return statearr_29194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto__))
);

return c__26717__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args29221 = [];
var len__25620__auto___29224 = arguments.length;
var i__25621__auto___29225 = (0);
while(true){
if((i__25621__auto___29225 < len__25620__auto___29224)){
args29221.push((arguments[i__25621__auto___29225]));

var G__29226 = (i__25621__auto___29225 + (1));
i__25621__auto___29225 = G__29226;
continue;
} else {
}
break;
}

var G__29223 = args29221.length;
switch (G__29223) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29221.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args29228 = [];
var len__25620__auto___29231 = arguments.length;
var i__25621__auto___29232 = (0);
while(true){
if((i__25621__auto___29232 < len__25620__auto___29231)){
args29228.push((arguments[i__25621__auto___29232]));

var G__29233 = (i__25621__auto___29232 + (1));
i__25621__auto___29232 = G__29233;
continue;
} else {
}
break;
}

var G__29230 = args29228.length;
switch (G__29230) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29228.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args29235 = [];
var len__25620__auto___29286 = arguments.length;
var i__25621__auto___29287 = (0);
while(true){
if((i__25621__auto___29287 < len__25620__auto___29286)){
args29235.push((arguments[i__25621__auto___29287]));

var G__29288 = (i__25621__auto___29287 + (1));
i__25621__auto___29287 = G__29288;
continue;
} else {
}
break;
}

var G__29237 = args29235.length;
switch (G__29237) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29235.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26717__auto___29290 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___29290,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___29290,out){
return (function (state_29261){
var state_val_29262 = (state_29261[(1)]);
if((state_val_29262 === (7))){
var inst_29256 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
var statearr_29263_29291 = state_29261__$1;
(statearr_29263_29291[(2)] = inst_29256);

(statearr_29263_29291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (1))){
var inst_29238 = null;
var state_29261__$1 = (function (){var statearr_29264 = state_29261;
(statearr_29264[(7)] = inst_29238);

return statearr_29264;
})();
var statearr_29265_29292 = state_29261__$1;
(statearr_29265_29292[(2)] = null);

(statearr_29265_29292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (4))){
var inst_29241 = (state_29261[(8)]);
var inst_29241__$1 = (state_29261[(2)]);
var inst_29242 = (inst_29241__$1 == null);
var inst_29243 = cljs.core.not.call(null,inst_29242);
var state_29261__$1 = (function (){var statearr_29266 = state_29261;
(statearr_29266[(8)] = inst_29241__$1);

return statearr_29266;
})();
if(inst_29243){
var statearr_29267_29293 = state_29261__$1;
(statearr_29267_29293[(1)] = (5));

} else {
var statearr_29268_29294 = state_29261__$1;
(statearr_29268_29294[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (6))){
var state_29261__$1 = state_29261;
var statearr_29269_29295 = state_29261__$1;
(statearr_29269_29295[(2)] = null);

(statearr_29269_29295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (3))){
var inst_29258 = (state_29261[(2)]);
var inst_29259 = cljs.core.async.close_BANG_.call(null,out);
var state_29261__$1 = (function (){var statearr_29270 = state_29261;
(statearr_29270[(9)] = inst_29258);

return statearr_29270;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29261__$1,inst_29259);
} else {
if((state_val_29262 === (2))){
var state_29261__$1 = state_29261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29261__$1,(4),ch);
} else {
if((state_val_29262 === (11))){
var inst_29241 = (state_29261[(8)]);
var inst_29250 = (state_29261[(2)]);
var inst_29238 = inst_29241;
var state_29261__$1 = (function (){var statearr_29271 = state_29261;
(statearr_29271[(10)] = inst_29250);

(statearr_29271[(7)] = inst_29238);

return statearr_29271;
})();
var statearr_29272_29296 = state_29261__$1;
(statearr_29272_29296[(2)] = null);

(statearr_29272_29296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (9))){
var inst_29241 = (state_29261[(8)]);
var state_29261__$1 = state_29261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29261__$1,(11),out,inst_29241);
} else {
if((state_val_29262 === (5))){
var inst_29241 = (state_29261[(8)]);
var inst_29238 = (state_29261[(7)]);
var inst_29245 = cljs.core._EQ_.call(null,inst_29241,inst_29238);
var state_29261__$1 = state_29261;
if(inst_29245){
var statearr_29274_29297 = state_29261__$1;
(statearr_29274_29297[(1)] = (8));

} else {
var statearr_29275_29298 = state_29261__$1;
(statearr_29275_29298[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (10))){
var inst_29253 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
var statearr_29276_29299 = state_29261__$1;
(statearr_29276_29299[(2)] = inst_29253);

(statearr_29276_29299[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (8))){
var inst_29238 = (state_29261[(7)]);
var tmp29273 = inst_29238;
var inst_29238__$1 = tmp29273;
var state_29261__$1 = (function (){var statearr_29277 = state_29261;
(statearr_29277[(7)] = inst_29238__$1);

return statearr_29277;
})();
var statearr_29278_29300 = state_29261__$1;
(statearr_29278_29300[(2)] = null);

(statearr_29278_29300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___29290,out))
;
return ((function (switch__26605__auto__,c__26717__auto___29290,out){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_29282 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29282[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_29282[(1)] = (1));

return statearr_29282;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_29261){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_29261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e29283){if((e29283 instanceof Object)){
var ex__26609__auto__ = e29283;
var statearr_29284_29301 = state_29261;
(statearr_29284_29301[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29283;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29302 = state_29261;
state_29261 = G__29302;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_29261){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_29261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___29290,out))
})();
var state__26719__auto__ = (function (){var statearr_29285 = f__26718__auto__.call(null);
(statearr_29285[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___29290);

return statearr_29285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___29290,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args29303 = [];
var len__25620__auto___29373 = arguments.length;
var i__25621__auto___29374 = (0);
while(true){
if((i__25621__auto___29374 < len__25620__auto___29373)){
args29303.push((arguments[i__25621__auto___29374]));

var G__29375 = (i__25621__auto___29374 + (1));
i__25621__auto___29374 = G__29375;
continue;
} else {
}
break;
}

var G__29305 = args29303.length;
switch (G__29305) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29303.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26717__auto___29377 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___29377,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___29377,out){
return (function (state_29343){
var state_val_29344 = (state_29343[(1)]);
if((state_val_29344 === (7))){
var inst_29339 = (state_29343[(2)]);
var state_29343__$1 = state_29343;
var statearr_29345_29378 = state_29343__$1;
(statearr_29345_29378[(2)] = inst_29339);

(statearr_29345_29378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (1))){
var inst_29306 = (new Array(n));
var inst_29307 = inst_29306;
var inst_29308 = (0);
var state_29343__$1 = (function (){var statearr_29346 = state_29343;
(statearr_29346[(7)] = inst_29307);

(statearr_29346[(8)] = inst_29308);

return statearr_29346;
})();
var statearr_29347_29379 = state_29343__$1;
(statearr_29347_29379[(2)] = null);

(statearr_29347_29379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (4))){
var inst_29311 = (state_29343[(9)]);
var inst_29311__$1 = (state_29343[(2)]);
var inst_29312 = (inst_29311__$1 == null);
var inst_29313 = cljs.core.not.call(null,inst_29312);
var state_29343__$1 = (function (){var statearr_29348 = state_29343;
(statearr_29348[(9)] = inst_29311__$1);

return statearr_29348;
})();
if(inst_29313){
var statearr_29349_29380 = state_29343__$1;
(statearr_29349_29380[(1)] = (5));

} else {
var statearr_29350_29381 = state_29343__$1;
(statearr_29350_29381[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (15))){
var inst_29333 = (state_29343[(2)]);
var state_29343__$1 = state_29343;
var statearr_29351_29382 = state_29343__$1;
(statearr_29351_29382[(2)] = inst_29333);

(statearr_29351_29382[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (13))){
var state_29343__$1 = state_29343;
var statearr_29352_29383 = state_29343__$1;
(statearr_29352_29383[(2)] = null);

(statearr_29352_29383[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (6))){
var inst_29308 = (state_29343[(8)]);
var inst_29329 = (inst_29308 > (0));
var state_29343__$1 = state_29343;
if(cljs.core.truth_(inst_29329)){
var statearr_29353_29384 = state_29343__$1;
(statearr_29353_29384[(1)] = (12));

} else {
var statearr_29354_29385 = state_29343__$1;
(statearr_29354_29385[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (3))){
var inst_29341 = (state_29343[(2)]);
var state_29343__$1 = state_29343;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29343__$1,inst_29341);
} else {
if((state_val_29344 === (12))){
var inst_29307 = (state_29343[(7)]);
var inst_29331 = cljs.core.vec.call(null,inst_29307);
var state_29343__$1 = state_29343;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29343__$1,(15),out,inst_29331);
} else {
if((state_val_29344 === (2))){
var state_29343__$1 = state_29343;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29343__$1,(4),ch);
} else {
if((state_val_29344 === (11))){
var inst_29323 = (state_29343[(2)]);
var inst_29324 = (new Array(n));
var inst_29307 = inst_29324;
var inst_29308 = (0);
var state_29343__$1 = (function (){var statearr_29355 = state_29343;
(statearr_29355[(7)] = inst_29307);

(statearr_29355[(10)] = inst_29323);

(statearr_29355[(8)] = inst_29308);

return statearr_29355;
})();
var statearr_29356_29386 = state_29343__$1;
(statearr_29356_29386[(2)] = null);

(statearr_29356_29386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (9))){
var inst_29307 = (state_29343[(7)]);
var inst_29321 = cljs.core.vec.call(null,inst_29307);
var state_29343__$1 = state_29343;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29343__$1,(11),out,inst_29321);
} else {
if((state_val_29344 === (5))){
var inst_29311 = (state_29343[(9)]);
var inst_29307 = (state_29343[(7)]);
var inst_29308 = (state_29343[(8)]);
var inst_29316 = (state_29343[(11)]);
var inst_29315 = (inst_29307[inst_29308] = inst_29311);
var inst_29316__$1 = (inst_29308 + (1));
var inst_29317 = (inst_29316__$1 < n);
var state_29343__$1 = (function (){var statearr_29357 = state_29343;
(statearr_29357[(12)] = inst_29315);

(statearr_29357[(11)] = inst_29316__$1);

return statearr_29357;
})();
if(cljs.core.truth_(inst_29317)){
var statearr_29358_29387 = state_29343__$1;
(statearr_29358_29387[(1)] = (8));

} else {
var statearr_29359_29388 = state_29343__$1;
(statearr_29359_29388[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (14))){
var inst_29336 = (state_29343[(2)]);
var inst_29337 = cljs.core.async.close_BANG_.call(null,out);
var state_29343__$1 = (function (){var statearr_29361 = state_29343;
(statearr_29361[(13)] = inst_29336);

return statearr_29361;
})();
var statearr_29362_29389 = state_29343__$1;
(statearr_29362_29389[(2)] = inst_29337);

(statearr_29362_29389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (10))){
var inst_29327 = (state_29343[(2)]);
var state_29343__$1 = state_29343;
var statearr_29363_29390 = state_29343__$1;
(statearr_29363_29390[(2)] = inst_29327);

(statearr_29363_29390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29344 === (8))){
var inst_29307 = (state_29343[(7)]);
var inst_29316 = (state_29343[(11)]);
var tmp29360 = inst_29307;
var inst_29307__$1 = tmp29360;
var inst_29308 = inst_29316;
var state_29343__$1 = (function (){var statearr_29364 = state_29343;
(statearr_29364[(7)] = inst_29307__$1);

(statearr_29364[(8)] = inst_29308);

return statearr_29364;
})();
var statearr_29365_29391 = state_29343__$1;
(statearr_29365_29391[(2)] = null);

(statearr_29365_29391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___29377,out))
;
return ((function (switch__26605__auto__,c__26717__auto___29377,out){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_29369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29369[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_29369[(1)] = (1));

return statearr_29369;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_29343){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_29343);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e29370){if((e29370 instanceof Object)){
var ex__26609__auto__ = e29370;
var statearr_29371_29392 = state_29343;
(statearr_29371_29392[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29343);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29370;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29393 = state_29343;
state_29343 = G__29393;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_29343){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_29343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___29377,out))
})();
var state__26719__auto__ = (function (){var statearr_29372 = f__26718__auto__.call(null);
(statearr_29372[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___29377);

return statearr_29372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___29377,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args29394 = [];
var len__25620__auto___29468 = arguments.length;
var i__25621__auto___29469 = (0);
while(true){
if((i__25621__auto___29469 < len__25620__auto___29468)){
args29394.push((arguments[i__25621__auto___29469]));

var G__29470 = (i__25621__auto___29469 + (1));
i__25621__auto___29469 = G__29470;
continue;
} else {
}
break;
}

var G__29396 = args29394.length;
switch (G__29396) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29394.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26717__auto___29472 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___29472,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___29472,out){
return (function (state_29438){
var state_val_29439 = (state_29438[(1)]);
if((state_val_29439 === (7))){
var inst_29434 = (state_29438[(2)]);
var state_29438__$1 = state_29438;
var statearr_29440_29473 = state_29438__$1;
(statearr_29440_29473[(2)] = inst_29434);

(statearr_29440_29473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (1))){
var inst_29397 = [];
var inst_29398 = inst_29397;
var inst_29399 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_29438__$1 = (function (){var statearr_29441 = state_29438;
(statearr_29441[(7)] = inst_29398);

(statearr_29441[(8)] = inst_29399);

return statearr_29441;
})();
var statearr_29442_29474 = state_29438__$1;
(statearr_29442_29474[(2)] = null);

(statearr_29442_29474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (4))){
var inst_29402 = (state_29438[(9)]);
var inst_29402__$1 = (state_29438[(2)]);
var inst_29403 = (inst_29402__$1 == null);
var inst_29404 = cljs.core.not.call(null,inst_29403);
var state_29438__$1 = (function (){var statearr_29443 = state_29438;
(statearr_29443[(9)] = inst_29402__$1);

return statearr_29443;
})();
if(inst_29404){
var statearr_29444_29475 = state_29438__$1;
(statearr_29444_29475[(1)] = (5));

} else {
var statearr_29445_29476 = state_29438__$1;
(statearr_29445_29476[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (15))){
var inst_29428 = (state_29438[(2)]);
var state_29438__$1 = state_29438;
var statearr_29446_29477 = state_29438__$1;
(statearr_29446_29477[(2)] = inst_29428);

(statearr_29446_29477[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (13))){
var state_29438__$1 = state_29438;
var statearr_29447_29478 = state_29438__$1;
(statearr_29447_29478[(2)] = null);

(statearr_29447_29478[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (6))){
var inst_29398 = (state_29438[(7)]);
var inst_29423 = inst_29398.length;
var inst_29424 = (inst_29423 > (0));
var state_29438__$1 = state_29438;
if(cljs.core.truth_(inst_29424)){
var statearr_29448_29479 = state_29438__$1;
(statearr_29448_29479[(1)] = (12));

} else {
var statearr_29449_29480 = state_29438__$1;
(statearr_29449_29480[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (3))){
var inst_29436 = (state_29438[(2)]);
var state_29438__$1 = state_29438;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29438__$1,inst_29436);
} else {
if((state_val_29439 === (12))){
var inst_29398 = (state_29438[(7)]);
var inst_29426 = cljs.core.vec.call(null,inst_29398);
var state_29438__$1 = state_29438;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29438__$1,(15),out,inst_29426);
} else {
if((state_val_29439 === (2))){
var state_29438__$1 = state_29438;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29438__$1,(4),ch);
} else {
if((state_val_29439 === (11))){
var inst_29406 = (state_29438[(10)]);
var inst_29402 = (state_29438[(9)]);
var inst_29416 = (state_29438[(2)]);
var inst_29417 = [];
var inst_29418 = inst_29417.push(inst_29402);
var inst_29398 = inst_29417;
var inst_29399 = inst_29406;
var state_29438__$1 = (function (){var statearr_29450 = state_29438;
(statearr_29450[(11)] = inst_29418);

(statearr_29450[(7)] = inst_29398);

(statearr_29450[(8)] = inst_29399);

(statearr_29450[(12)] = inst_29416);

return statearr_29450;
})();
var statearr_29451_29481 = state_29438__$1;
(statearr_29451_29481[(2)] = null);

(statearr_29451_29481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (9))){
var inst_29398 = (state_29438[(7)]);
var inst_29414 = cljs.core.vec.call(null,inst_29398);
var state_29438__$1 = state_29438;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29438__$1,(11),out,inst_29414);
} else {
if((state_val_29439 === (5))){
var inst_29399 = (state_29438[(8)]);
var inst_29406 = (state_29438[(10)]);
var inst_29402 = (state_29438[(9)]);
var inst_29406__$1 = f.call(null,inst_29402);
var inst_29407 = cljs.core._EQ_.call(null,inst_29406__$1,inst_29399);
var inst_29408 = cljs.core.keyword_identical_QMARK_.call(null,inst_29399,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_29409 = (inst_29407) || (inst_29408);
var state_29438__$1 = (function (){var statearr_29452 = state_29438;
(statearr_29452[(10)] = inst_29406__$1);

return statearr_29452;
})();
if(cljs.core.truth_(inst_29409)){
var statearr_29453_29482 = state_29438__$1;
(statearr_29453_29482[(1)] = (8));

} else {
var statearr_29454_29483 = state_29438__$1;
(statearr_29454_29483[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (14))){
var inst_29431 = (state_29438[(2)]);
var inst_29432 = cljs.core.async.close_BANG_.call(null,out);
var state_29438__$1 = (function (){var statearr_29456 = state_29438;
(statearr_29456[(13)] = inst_29431);

return statearr_29456;
})();
var statearr_29457_29484 = state_29438__$1;
(statearr_29457_29484[(2)] = inst_29432);

(statearr_29457_29484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (10))){
var inst_29421 = (state_29438[(2)]);
var state_29438__$1 = state_29438;
var statearr_29458_29485 = state_29438__$1;
(statearr_29458_29485[(2)] = inst_29421);

(statearr_29458_29485[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (8))){
var inst_29398 = (state_29438[(7)]);
var inst_29406 = (state_29438[(10)]);
var inst_29402 = (state_29438[(9)]);
var inst_29411 = inst_29398.push(inst_29402);
var tmp29455 = inst_29398;
var inst_29398__$1 = tmp29455;
var inst_29399 = inst_29406;
var state_29438__$1 = (function (){var statearr_29459 = state_29438;
(statearr_29459[(7)] = inst_29398__$1);

(statearr_29459[(14)] = inst_29411);

(statearr_29459[(8)] = inst_29399);

return statearr_29459;
})();
var statearr_29460_29486 = state_29438__$1;
(statearr_29460_29486[(2)] = null);

(statearr_29460_29486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto___29472,out))
;
return ((function (switch__26605__auto__,c__26717__auto___29472,out){
return (function() {
var cljs$core$async$state_machine__26606__auto__ = null;
var cljs$core$async$state_machine__26606__auto____0 = (function (){
var statearr_29464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29464[(0)] = cljs$core$async$state_machine__26606__auto__);

(statearr_29464[(1)] = (1));

return statearr_29464;
});
var cljs$core$async$state_machine__26606__auto____1 = (function (state_29438){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_29438);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e29465){if((e29465 instanceof Object)){
var ex__26609__auto__ = e29465;
var statearr_29466_29487 = state_29438;
(statearr_29466_29487[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29438);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29465;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29488 = state_29438;
state_29438 = G__29488;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
cljs$core$async$state_machine__26606__auto__ = function(state_29438){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26606__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26606__auto____1.call(this,state_29438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26606__auto____0;
cljs$core$async$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26606__auto____1;
return cljs$core$async$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___29472,out))
})();
var state__26719__auto__ = (function (){var statearr_29467 = f__26718__auto__.call(null);
(statearr_29467[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___29472);

return statearr_29467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___29472,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1477097017586