// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__47465__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__47465__auto__){
return or__47465__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__47465__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__47465__auto__)){
return or__47465__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__50195_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__50195_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__50200 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__50201 = null;
var count__50202 = (0);
var i__50203 = (0);
while(true){
if((i__50203 < count__50202)){
var n = cljs.core._nth.call(null,chunk__50201,i__50203);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__50204 = seq__50200;
var G__50205 = chunk__50201;
var G__50206 = count__50202;
var G__50207 = (i__50203 + (1));
seq__50200 = G__50204;
chunk__50201 = G__50205;
count__50202 = G__50206;
i__50203 = G__50207;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__50200);
if(temp__6753__auto__){
var seq__50200__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50200__$1)){
var c__48371__auto__ = cljs.core.chunk_first.call(null,seq__50200__$1);
var G__50208 = cljs.core.chunk_rest.call(null,seq__50200__$1);
var G__50209 = c__48371__auto__;
var G__50210 = cljs.core.count.call(null,c__48371__auto__);
var G__50211 = (0);
seq__50200 = G__50208;
chunk__50201 = G__50209;
count__50202 = G__50210;
i__50203 = G__50211;
continue;
} else {
var n = cljs.core.first.call(null,seq__50200__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__50212 = cljs.core.next.call(null,seq__50200__$1);
var G__50213 = null;
var G__50214 = (0);
var G__50215 = (0);
seq__50200 = G__50212;
chunk__50201 = G__50213;
count__50202 = G__50214;
i__50203 = G__50215;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__50266_50277 = cljs.core.seq.call(null,deps);
var chunk__50267_50278 = null;
var count__50268_50279 = (0);
var i__50269_50280 = (0);
while(true){
if((i__50269_50280 < count__50268_50279)){
var dep_50281 = cljs.core._nth.call(null,chunk__50267_50278,i__50269_50280);
topo_sort_helper_STAR_.call(null,dep_50281,(depth + (1)),state);

var G__50282 = seq__50266_50277;
var G__50283 = chunk__50267_50278;
var G__50284 = count__50268_50279;
var G__50285 = (i__50269_50280 + (1));
seq__50266_50277 = G__50282;
chunk__50267_50278 = G__50283;
count__50268_50279 = G__50284;
i__50269_50280 = G__50285;
continue;
} else {
var temp__6753__auto___50286 = cljs.core.seq.call(null,seq__50266_50277);
if(temp__6753__auto___50286){
var seq__50266_50287__$1 = temp__6753__auto___50286;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50266_50287__$1)){
var c__48371__auto___50288 = cljs.core.chunk_first.call(null,seq__50266_50287__$1);
var G__50289 = cljs.core.chunk_rest.call(null,seq__50266_50287__$1);
var G__50290 = c__48371__auto___50288;
var G__50291 = cljs.core.count.call(null,c__48371__auto___50288);
var G__50292 = (0);
seq__50266_50277 = G__50289;
chunk__50267_50278 = G__50290;
count__50268_50279 = G__50291;
i__50269_50280 = G__50292;
continue;
} else {
var dep_50293 = cljs.core.first.call(null,seq__50266_50287__$1);
topo_sort_helper_STAR_.call(null,dep_50293,(depth + (1)),state);

var G__50294 = cljs.core.next.call(null,seq__50266_50287__$1);
var G__50295 = null;
var G__50296 = (0);
var G__50297 = (0);
seq__50266_50277 = G__50294;
chunk__50267_50278 = G__50295;
count__50268_50279 = G__50296;
i__50269_50280 = G__50297;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__50270){
var vec__50274 = p__50270;
var seq__50275 = cljs.core.seq.call(null,vec__50274);
var first__50276 = cljs.core.first.call(null,seq__50275);
var seq__50275__$1 = cljs.core.next.call(null,seq__50275);
var x = first__50276;
var xs = seq__50275__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__50274,seq__50275,first__50276,seq__50275__$1,x,xs,get_deps__$1){
return (function (p1__50216_SHARP_){
return clojure.set.difference.call(null,p1__50216_SHARP_,x);
});})(vec__50274,seq__50275,first__50276,seq__50275__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__50310 = cljs.core.seq.call(null,provides);
var chunk__50311 = null;
var count__50312 = (0);
var i__50313 = (0);
while(true){
if((i__50313 < count__50312)){
var prov = cljs.core._nth.call(null,chunk__50311,i__50313);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__50314_50322 = cljs.core.seq.call(null,requires);
var chunk__50315_50323 = null;
var count__50316_50324 = (0);
var i__50317_50325 = (0);
while(true){
if((i__50317_50325 < count__50316_50324)){
var req_50326 = cljs.core._nth.call(null,chunk__50315_50323,i__50317_50325);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50326,prov);

var G__50327 = seq__50314_50322;
var G__50328 = chunk__50315_50323;
var G__50329 = count__50316_50324;
var G__50330 = (i__50317_50325 + (1));
seq__50314_50322 = G__50327;
chunk__50315_50323 = G__50328;
count__50316_50324 = G__50329;
i__50317_50325 = G__50330;
continue;
} else {
var temp__6753__auto___50331 = cljs.core.seq.call(null,seq__50314_50322);
if(temp__6753__auto___50331){
var seq__50314_50332__$1 = temp__6753__auto___50331;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50314_50332__$1)){
var c__48371__auto___50333 = cljs.core.chunk_first.call(null,seq__50314_50332__$1);
var G__50334 = cljs.core.chunk_rest.call(null,seq__50314_50332__$1);
var G__50335 = c__48371__auto___50333;
var G__50336 = cljs.core.count.call(null,c__48371__auto___50333);
var G__50337 = (0);
seq__50314_50322 = G__50334;
chunk__50315_50323 = G__50335;
count__50316_50324 = G__50336;
i__50317_50325 = G__50337;
continue;
} else {
var req_50338 = cljs.core.first.call(null,seq__50314_50332__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50338,prov);

var G__50339 = cljs.core.next.call(null,seq__50314_50332__$1);
var G__50340 = null;
var G__50341 = (0);
var G__50342 = (0);
seq__50314_50322 = G__50339;
chunk__50315_50323 = G__50340;
count__50316_50324 = G__50341;
i__50317_50325 = G__50342;
continue;
}
} else {
}
}
break;
}

var G__50343 = seq__50310;
var G__50344 = chunk__50311;
var G__50345 = count__50312;
var G__50346 = (i__50313 + (1));
seq__50310 = G__50343;
chunk__50311 = G__50344;
count__50312 = G__50345;
i__50313 = G__50346;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__50310);
if(temp__6753__auto__){
var seq__50310__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50310__$1)){
var c__48371__auto__ = cljs.core.chunk_first.call(null,seq__50310__$1);
var G__50347 = cljs.core.chunk_rest.call(null,seq__50310__$1);
var G__50348 = c__48371__auto__;
var G__50349 = cljs.core.count.call(null,c__48371__auto__);
var G__50350 = (0);
seq__50310 = G__50347;
chunk__50311 = G__50348;
count__50312 = G__50349;
i__50313 = G__50350;
continue;
} else {
var prov = cljs.core.first.call(null,seq__50310__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__50318_50351 = cljs.core.seq.call(null,requires);
var chunk__50319_50352 = null;
var count__50320_50353 = (0);
var i__50321_50354 = (0);
while(true){
if((i__50321_50354 < count__50320_50353)){
var req_50355 = cljs.core._nth.call(null,chunk__50319_50352,i__50321_50354);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50355,prov);

var G__50356 = seq__50318_50351;
var G__50357 = chunk__50319_50352;
var G__50358 = count__50320_50353;
var G__50359 = (i__50321_50354 + (1));
seq__50318_50351 = G__50356;
chunk__50319_50352 = G__50357;
count__50320_50353 = G__50358;
i__50321_50354 = G__50359;
continue;
} else {
var temp__6753__auto___50360__$1 = cljs.core.seq.call(null,seq__50318_50351);
if(temp__6753__auto___50360__$1){
var seq__50318_50361__$1 = temp__6753__auto___50360__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50318_50361__$1)){
var c__48371__auto___50362 = cljs.core.chunk_first.call(null,seq__50318_50361__$1);
var G__50363 = cljs.core.chunk_rest.call(null,seq__50318_50361__$1);
var G__50364 = c__48371__auto___50362;
var G__50365 = cljs.core.count.call(null,c__48371__auto___50362);
var G__50366 = (0);
seq__50318_50351 = G__50363;
chunk__50319_50352 = G__50364;
count__50320_50353 = G__50365;
i__50321_50354 = G__50366;
continue;
} else {
var req_50367 = cljs.core.first.call(null,seq__50318_50361__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50367,prov);

var G__50368 = cljs.core.next.call(null,seq__50318_50361__$1);
var G__50369 = null;
var G__50370 = (0);
var G__50371 = (0);
seq__50318_50351 = G__50368;
chunk__50319_50352 = G__50369;
count__50320_50353 = G__50370;
i__50321_50354 = G__50371;
continue;
}
} else {
}
}
break;
}

var G__50372 = cljs.core.next.call(null,seq__50310__$1);
var G__50373 = null;
var G__50374 = (0);
var G__50375 = (0);
seq__50310 = G__50372;
chunk__50311 = G__50373;
count__50312 = G__50374;
i__50313 = G__50375;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__50380_50384 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__50381_50385 = null;
var count__50382_50386 = (0);
var i__50383_50387 = (0);
while(true){
if((i__50383_50387 < count__50382_50386)){
var ns_50388 = cljs.core._nth.call(null,chunk__50381_50385,i__50383_50387);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_50388);

var G__50389 = seq__50380_50384;
var G__50390 = chunk__50381_50385;
var G__50391 = count__50382_50386;
var G__50392 = (i__50383_50387 + (1));
seq__50380_50384 = G__50389;
chunk__50381_50385 = G__50390;
count__50382_50386 = G__50391;
i__50383_50387 = G__50392;
continue;
} else {
var temp__6753__auto___50393 = cljs.core.seq.call(null,seq__50380_50384);
if(temp__6753__auto___50393){
var seq__50380_50394__$1 = temp__6753__auto___50393;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50380_50394__$1)){
var c__48371__auto___50395 = cljs.core.chunk_first.call(null,seq__50380_50394__$1);
var G__50396 = cljs.core.chunk_rest.call(null,seq__50380_50394__$1);
var G__50397 = c__48371__auto___50395;
var G__50398 = cljs.core.count.call(null,c__48371__auto___50395);
var G__50399 = (0);
seq__50380_50384 = G__50396;
chunk__50381_50385 = G__50397;
count__50382_50386 = G__50398;
i__50383_50387 = G__50399;
continue;
} else {
var ns_50400 = cljs.core.first.call(null,seq__50380_50394__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_50400);

var G__50401 = cljs.core.next.call(null,seq__50380_50394__$1);
var G__50402 = null;
var G__50403 = (0);
var G__50404 = (0);
seq__50380_50384 = G__50401;
chunk__50381_50385 = G__50402;
count__50382_50386 = G__50403;
i__50383_50387 = G__50404;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__47465__auto__ = goog.require__;
if(cljs.core.truth_(or__47465__auto__)){
return or__47465__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__50405__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__50405 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__50406__i = 0, G__50406__a = new Array(arguments.length -  0);
while (G__50406__i < G__50406__a.length) {G__50406__a[G__50406__i] = arguments[G__50406__i + 0]; ++G__50406__i;}
  args = new cljs.core.IndexedSeq(G__50406__a,0);
} 
return G__50405__delegate.call(this,args);};
G__50405.cljs$lang$maxFixedArity = 0;
G__50405.cljs$lang$applyTo = (function (arglist__50407){
var args = cljs.core.seq(arglist__50407);
return G__50405__delegate(args);
});
G__50405.cljs$core$IFn$_invoke$arity$variadic = G__50405__delegate;
return G__50405;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__50409 = cljs.core._EQ_;
var expr__50410 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__50409.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__50410))){
var path_parts = ((function (pred__50409,expr__50410){
return (function (p1__50408_SHARP_){
return clojure.string.split.call(null,p1__50408_SHARP_,/[\/\\]/);
});})(pred__50409,expr__50410))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__50409,expr__50410){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e50412){if((e50412 instanceof Error)){
var e = e50412;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e50412;

}
}})());
});
;})(path_parts,sep,root,pred__50409,expr__50410))
} else {
if(cljs.core.truth_(pred__50409.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__50410))){
return ((function (pred__50409,expr__50410){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__50409,expr__50410){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__50409,expr__50410))
);

return deferred.addErrback(((function (deferred,pred__50409,expr__50410){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__50409,expr__50410))
);
});
;})(pred__50409,expr__50410))
} else {
return ((function (pred__50409,expr__50410){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__50409,expr__50410))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__50413,callback){
var map__50416 = p__50413;
var map__50416__$1 = ((((!((map__50416 == null)))?((((map__50416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50416.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50416):map__50416);
var file_msg = map__50416__$1;
var request_url = cljs.core.get.call(null,map__50416__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__50416,map__50416__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__50416,map__50416__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__50102__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto__){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto__){
return (function (state_50440){
var state_val_50441 = (state_50440[(1)]);
if((state_val_50441 === (7))){
var inst_50436 = (state_50440[(2)]);
var state_50440__$1 = state_50440;
var statearr_50442_50462 = state_50440__$1;
(statearr_50442_50462[(2)] = inst_50436);

(statearr_50442_50462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50441 === (1))){
var state_50440__$1 = state_50440;
var statearr_50443_50463 = state_50440__$1;
(statearr_50443_50463[(2)] = null);

(statearr_50443_50463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50441 === (4))){
var inst_50420 = (state_50440[(7)]);
var inst_50420__$1 = (state_50440[(2)]);
var state_50440__$1 = (function (){var statearr_50444 = state_50440;
(statearr_50444[(7)] = inst_50420__$1);

return statearr_50444;
})();
if(cljs.core.truth_(inst_50420__$1)){
var statearr_50445_50464 = state_50440__$1;
(statearr_50445_50464[(1)] = (5));

} else {
var statearr_50446_50465 = state_50440__$1;
(statearr_50446_50465[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50441 === (6))){
var state_50440__$1 = state_50440;
var statearr_50447_50466 = state_50440__$1;
(statearr_50447_50466[(2)] = null);

(statearr_50447_50466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50441 === (3))){
var inst_50438 = (state_50440[(2)]);
var state_50440__$1 = state_50440;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50440__$1,inst_50438);
} else {
if((state_val_50441 === (2))){
var state_50440__$1 = state_50440;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50440__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_50441 === (11))){
var inst_50432 = (state_50440[(2)]);
var state_50440__$1 = (function (){var statearr_50448 = state_50440;
(statearr_50448[(8)] = inst_50432);

return statearr_50448;
})();
var statearr_50449_50467 = state_50440__$1;
(statearr_50449_50467[(2)] = null);

(statearr_50449_50467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50441 === (9))){
var inst_50426 = (state_50440[(9)]);
var inst_50424 = (state_50440[(10)]);
var inst_50428 = inst_50426.call(null,inst_50424);
var state_50440__$1 = state_50440;
var statearr_50450_50468 = state_50440__$1;
(statearr_50450_50468[(2)] = inst_50428);

(statearr_50450_50468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50441 === (5))){
var inst_50420 = (state_50440[(7)]);
var inst_50422 = figwheel.client.file_reloading.blocking_load.call(null,inst_50420);
var state_50440__$1 = state_50440;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50440__$1,(8),inst_50422);
} else {
if((state_val_50441 === (10))){
var inst_50424 = (state_50440[(10)]);
var inst_50430 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_50424);
var state_50440__$1 = state_50440;
var statearr_50451_50469 = state_50440__$1;
(statearr_50451_50469[(2)] = inst_50430);

(statearr_50451_50469[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50441 === (8))){
var inst_50420 = (state_50440[(7)]);
var inst_50426 = (state_50440[(9)]);
var inst_50424 = (state_50440[(2)]);
var inst_50425 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_50426__$1 = cljs.core.get.call(null,inst_50425,inst_50420);
var state_50440__$1 = (function (){var statearr_50452 = state_50440;
(statearr_50452[(9)] = inst_50426__$1);

(statearr_50452[(10)] = inst_50424);

return statearr_50452;
})();
if(cljs.core.truth_(inst_50426__$1)){
var statearr_50453_50470 = state_50440__$1;
(statearr_50453_50470[(1)] = (9));

} else {
var statearr_50454_50471 = state_50440__$1;
(statearr_50454_50471[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto__))
;
return ((function (switch__50079__auto__,c__50102__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__50080__auto__ = null;
var figwheel$client$file_reloading$state_machine__50080__auto____0 = (function (){
var statearr_50458 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50458[(0)] = figwheel$client$file_reloading$state_machine__50080__auto__);

(statearr_50458[(1)] = (1));

return statearr_50458;
});
var figwheel$client$file_reloading$state_machine__50080__auto____1 = (function (state_50440){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_50440);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e50459){if((e50459 instanceof Object)){
var ex__50083__auto__ = e50459;
var statearr_50460_50472 = state_50440;
(statearr_50460_50472[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50440);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50459;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50473 = state_50440;
state_50440 = G__50473;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__50080__auto__ = function(state_50440){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__50080__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__50080__auto____1.call(this,state_50440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__50080__auto____0;
figwheel$client$file_reloading$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__50080__auto____1;
return figwheel$client$file_reloading$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto__))
})();
var state__50104__auto__ = (function (){var statearr_50461 = f__50103__auto__.call(null);
(statearr_50461[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto__);

return statearr_50461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto__))
);

return c__50102__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__50474,callback){
var map__50477 = p__50474;
var map__50477__$1 = ((((!((map__50477 == null)))?((((map__50477.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50477.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50477):map__50477);
var file_msg = map__50477__$1;
var namespace = cljs.core.get.call(null,map__50477__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__50477,map__50477__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__50477,map__50477__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__50479){
var map__50482 = p__50479;
var map__50482__$1 = ((((!((map__50482 == null)))?((((map__50482.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50482.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50482):map__50482);
var file_msg = map__50482__$1;
var namespace = cljs.core.get.call(null,map__50482__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__47453__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__47453__auto__){
var or__47465__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__47465__auto__)){
return or__47465__auto__;
} else {
var or__47465__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__47465__auto____$1)){
return or__47465__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__47453__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__50484,callback){
var map__50487 = p__50484;
var map__50487__$1 = ((((!((map__50487 == null)))?((((map__50487.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50487.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50487):map__50487);
var file_msg = map__50487__$1;
var request_url = cljs.core.get.call(null,map__50487__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__50487__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__50102__auto___50591 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___50591,out){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___50591,out){
return (function (state_50573){
var state_val_50574 = (state_50573[(1)]);
if((state_val_50574 === (1))){
var inst_50547 = cljs.core.seq.call(null,files);
var inst_50548 = cljs.core.first.call(null,inst_50547);
var inst_50549 = cljs.core.next.call(null,inst_50547);
var inst_50550 = files;
var state_50573__$1 = (function (){var statearr_50575 = state_50573;
(statearr_50575[(7)] = inst_50549);

(statearr_50575[(8)] = inst_50548);

(statearr_50575[(9)] = inst_50550);

return statearr_50575;
})();
var statearr_50576_50592 = state_50573__$1;
(statearr_50576_50592[(2)] = null);

(statearr_50576_50592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50574 === (2))){
var inst_50556 = (state_50573[(10)]);
var inst_50550 = (state_50573[(9)]);
var inst_50555 = cljs.core.seq.call(null,inst_50550);
var inst_50556__$1 = cljs.core.first.call(null,inst_50555);
var inst_50557 = cljs.core.next.call(null,inst_50555);
var inst_50558 = (inst_50556__$1 == null);
var inst_50559 = cljs.core.not.call(null,inst_50558);
var state_50573__$1 = (function (){var statearr_50577 = state_50573;
(statearr_50577[(11)] = inst_50557);

(statearr_50577[(10)] = inst_50556__$1);

return statearr_50577;
})();
if(inst_50559){
var statearr_50578_50593 = state_50573__$1;
(statearr_50578_50593[(1)] = (4));

} else {
var statearr_50579_50594 = state_50573__$1;
(statearr_50579_50594[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50574 === (3))){
var inst_50571 = (state_50573[(2)]);
var state_50573__$1 = state_50573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50573__$1,inst_50571);
} else {
if((state_val_50574 === (4))){
var inst_50556 = (state_50573[(10)]);
var inst_50561 = figwheel.client.file_reloading.reload_js_file.call(null,inst_50556);
var state_50573__$1 = state_50573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50573__$1,(7),inst_50561);
} else {
if((state_val_50574 === (5))){
var inst_50567 = cljs.core.async.close_BANG_.call(null,out);
var state_50573__$1 = state_50573;
var statearr_50580_50595 = state_50573__$1;
(statearr_50580_50595[(2)] = inst_50567);

(statearr_50580_50595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50574 === (6))){
var inst_50569 = (state_50573[(2)]);
var state_50573__$1 = state_50573;
var statearr_50581_50596 = state_50573__$1;
(statearr_50581_50596[(2)] = inst_50569);

(statearr_50581_50596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50574 === (7))){
var inst_50557 = (state_50573[(11)]);
var inst_50563 = (state_50573[(2)]);
var inst_50564 = cljs.core.async.put_BANG_.call(null,out,inst_50563);
var inst_50550 = inst_50557;
var state_50573__$1 = (function (){var statearr_50582 = state_50573;
(statearr_50582[(9)] = inst_50550);

(statearr_50582[(12)] = inst_50564);

return statearr_50582;
})();
var statearr_50583_50597 = state_50573__$1;
(statearr_50583_50597[(2)] = null);

(statearr_50583_50597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__50102__auto___50591,out))
;
return ((function (switch__50079__auto__,c__50102__auto___50591,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto____0 = (function (){
var statearr_50587 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50587[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto__);

(statearr_50587[(1)] = (1));

return statearr_50587;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto____1 = (function (state_50573){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_50573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e50588){if((e50588 instanceof Object)){
var ex__50083__auto__ = e50588;
var statearr_50589_50598 = state_50573;
(statearr_50589_50598[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50573);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50599 = state_50573;
state_50573 = G__50599;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto__ = function(state_50573){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto____1.call(this,state_50573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___50591,out))
})();
var state__50104__auto__ = (function (){var statearr_50590 = f__50103__auto__.call(null);
(statearr_50590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___50591);

return statearr_50590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___50591,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__50600,opts){
var map__50604 = p__50600;
var map__50604__$1 = ((((!((map__50604 == null)))?((((map__50604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50604.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50604):map__50604);
var eval_body = cljs.core.get.call(null,map__50604__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__50604__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__47453__auto__ = eval_body;
if(cljs.core.truth_(and__47453__auto__)){
return typeof eval_body === 'string';
} else {
return and__47453__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e50606){var e = e50606;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__50607_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__50607_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__50616){
var vec__50617 = p__50616;
var k = cljs.core.nth.call(null,vec__50617,(0),null);
var v = cljs.core.nth.call(null,vec__50617,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__50620){
var vec__50621 = p__50620;
var k = cljs.core.nth.call(null,vec__50621,(0),null);
var v = cljs.core.nth.call(null,vec__50621,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__50627,p__50628){
var map__50876 = p__50627;
var map__50876__$1 = ((((!((map__50876 == null)))?((((map__50876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50876.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50876):map__50876);
var opts = map__50876__$1;
var before_jsload = cljs.core.get.call(null,map__50876__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__50876__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__50876__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__50877 = p__50628;
var map__50877__$1 = ((((!((map__50877 == null)))?((((map__50877.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50877.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50877):map__50877);
var msg = map__50877__$1;
var files = cljs.core.get.call(null,map__50877__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__50877__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__50877__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__50102__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_51031){
var state_val_51032 = (state_51031[(1)]);
if((state_val_51032 === (7))){
var inst_50894 = (state_51031[(7)]);
var inst_50891 = (state_51031[(8)]);
var inst_50893 = (state_51031[(9)]);
var inst_50892 = (state_51031[(10)]);
var inst_50899 = cljs.core._nth.call(null,inst_50892,inst_50894);
var inst_50900 = figwheel.client.file_reloading.eval_body.call(null,inst_50899,opts);
var inst_50901 = (inst_50894 + (1));
var tmp51033 = inst_50891;
var tmp51034 = inst_50893;
var tmp51035 = inst_50892;
var inst_50891__$1 = tmp51033;
var inst_50892__$1 = tmp51035;
var inst_50893__$1 = tmp51034;
var inst_50894__$1 = inst_50901;
var state_51031__$1 = (function (){var statearr_51036 = state_51031;
(statearr_51036[(7)] = inst_50894__$1);

(statearr_51036[(8)] = inst_50891__$1);

(statearr_51036[(9)] = inst_50893__$1);

(statearr_51036[(11)] = inst_50900);

(statearr_51036[(10)] = inst_50892__$1);

return statearr_51036;
})();
var statearr_51037_51123 = state_51031__$1;
(statearr_51037_51123[(2)] = null);

(statearr_51037_51123[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (20))){
var inst_50934 = (state_51031[(12)]);
var inst_50942 = figwheel.client.file_reloading.sort_files.call(null,inst_50934);
var state_51031__$1 = state_51031;
var statearr_51038_51124 = state_51031__$1;
(statearr_51038_51124[(2)] = inst_50942);

(statearr_51038_51124[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (27))){
var state_51031__$1 = state_51031;
var statearr_51039_51125 = state_51031__$1;
(statearr_51039_51125[(2)] = null);

(statearr_51039_51125[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (1))){
var inst_50883 = (state_51031[(13)]);
var inst_50880 = before_jsload.call(null,files);
var inst_50881 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_50882 = (function (){return ((function (inst_50883,inst_50880,inst_50881,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__50624_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__50624_SHARP_);
});
;})(inst_50883,inst_50880,inst_50881,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50883__$1 = cljs.core.filter.call(null,inst_50882,files);
var inst_50884 = cljs.core.not_empty.call(null,inst_50883__$1);
var state_51031__$1 = (function (){var statearr_51040 = state_51031;
(statearr_51040[(14)] = inst_50880);

(statearr_51040[(15)] = inst_50881);

(statearr_51040[(13)] = inst_50883__$1);

return statearr_51040;
})();
if(cljs.core.truth_(inst_50884)){
var statearr_51041_51126 = state_51031__$1;
(statearr_51041_51126[(1)] = (2));

} else {
var statearr_51042_51127 = state_51031__$1;
(statearr_51042_51127[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (24))){
var state_51031__$1 = state_51031;
var statearr_51043_51128 = state_51031__$1;
(statearr_51043_51128[(2)] = null);

(statearr_51043_51128[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (39))){
var inst_50984 = (state_51031[(16)]);
var state_51031__$1 = state_51031;
var statearr_51044_51129 = state_51031__$1;
(statearr_51044_51129[(2)] = inst_50984);

(statearr_51044_51129[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (46))){
var inst_51026 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
var statearr_51045_51130 = state_51031__$1;
(statearr_51045_51130[(2)] = inst_51026);

(statearr_51045_51130[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (4))){
var inst_50928 = (state_51031[(2)]);
var inst_50929 = cljs.core.List.EMPTY;
var inst_50930 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_50929);
var inst_50931 = (function (){return ((function (inst_50928,inst_50929,inst_50930,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__50625_SHARP_){
var and__47453__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__50625_SHARP_);
if(cljs.core.truth_(and__47453__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__50625_SHARP_));
} else {
return and__47453__auto__;
}
});
;})(inst_50928,inst_50929,inst_50930,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50932 = cljs.core.filter.call(null,inst_50931,files);
var inst_50933 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_50934 = cljs.core.concat.call(null,inst_50932,inst_50933);
var state_51031__$1 = (function (){var statearr_51046 = state_51031;
(statearr_51046[(12)] = inst_50934);

(statearr_51046[(17)] = inst_50928);

(statearr_51046[(18)] = inst_50930);

return statearr_51046;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_51047_51131 = state_51031__$1;
(statearr_51047_51131[(1)] = (16));

} else {
var statearr_51048_51132 = state_51031__$1;
(statearr_51048_51132[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (15))){
var inst_50918 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
var statearr_51049_51133 = state_51031__$1;
(statearr_51049_51133[(2)] = inst_50918);

(statearr_51049_51133[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (21))){
var inst_50944 = (state_51031[(19)]);
var inst_50944__$1 = (state_51031[(2)]);
var inst_50945 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_50944__$1);
var state_51031__$1 = (function (){var statearr_51050 = state_51031;
(statearr_51050[(19)] = inst_50944__$1);

return statearr_51050;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51031__$1,(22),inst_50945);
} else {
if((state_val_51032 === (31))){
var inst_51029 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51031__$1,inst_51029);
} else {
if((state_val_51032 === (32))){
var inst_50984 = (state_51031[(16)]);
var inst_50989 = inst_50984.cljs$lang$protocol_mask$partition0$;
var inst_50990 = (inst_50989 & (64));
var inst_50991 = inst_50984.cljs$core$ISeq$;
var inst_50992 = (cljs.core.PROTOCOL_SENTINEL === inst_50991);
var inst_50993 = (inst_50990) || (inst_50992);
var state_51031__$1 = state_51031;
if(cljs.core.truth_(inst_50993)){
var statearr_51051_51134 = state_51031__$1;
(statearr_51051_51134[(1)] = (35));

} else {
var statearr_51052_51135 = state_51031__$1;
(statearr_51052_51135[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (40))){
var inst_51006 = (state_51031[(20)]);
var inst_51005 = (state_51031[(2)]);
var inst_51006__$1 = cljs.core.get.call(null,inst_51005,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_51007 = cljs.core.get.call(null,inst_51005,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_51008 = cljs.core.not_empty.call(null,inst_51006__$1);
var state_51031__$1 = (function (){var statearr_51053 = state_51031;
(statearr_51053[(21)] = inst_51007);

(statearr_51053[(20)] = inst_51006__$1);

return statearr_51053;
})();
if(cljs.core.truth_(inst_51008)){
var statearr_51054_51136 = state_51031__$1;
(statearr_51054_51136[(1)] = (41));

} else {
var statearr_51055_51137 = state_51031__$1;
(statearr_51055_51137[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (33))){
var state_51031__$1 = state_51031;
var statearr_51056_51138 = state_51031__$1;
(statearr_51056_51138[(2)] = false);

(statearr_51056_51138[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (13))){
var inst_50904 = (state_51031[(22)]);
var inst_50908 = cljs.core.chunk_first.call(null,inst_50904);
var inst_50909 = cljs.core.chunk_rest.call(null,inst_50904);
var inst_50910 = cljs.core.count.call(null,inst_50908);
var inst_50891 = inst_50909;
var inst_50892 = inst_50908;
var inst_50893 = inst_50910;
var inst_50894 = (0);
var state_51031__$1 = (function (){var statearr_51057 = state_51031;
(statearr_51057[(7)] = inst_50894);

(statearr_51057[(8)] = inst_50891);

(statearr_51057[(9)] = inst_50893);

(statearr_51057[(10)] = inst_50892);

return statearr_51057;
})();
var statearr_51058_51139 = state_51031__$1;
(statearr_51058_51139[(2)] = null);

(statearr_51058_51139[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (22))){
var inst_50944 = (state_51031[(19)]);
var inst_50947 = (state_51031[(23)]);
var inst_50948 = (state_51031[(24)]);
var inst_50952 = (state_51031[(25)]);
var inst_50947__$1 = (state_51031[(2)]);
var inst_50948__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_50947__$1);
var inst_50949 = (function (){var all_files = inst_50944;
var res_SINGLEQUOTE_ = inst_50947__$1;
var res = inst_50948__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_50944,inst_50947,inst_50948,inst_50952,inst_50947__$1,inst_50948__$1,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__50626_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__50626_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_50944,inst_50947,inst_50948,inst_50952,inst_50947__$1,inst_50948__$1,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50950 = cljs.core.filter.call(null,inst_50949,inst_50947__$1);
var inst_50951 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_50952__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_50951);
var inst_50953 = cljs.core.not_empty.call(null,inst_50952__$1);
var state_51031__$1 = (function (){var statearr_51059 = state_51031;
(statearr_51059[(23)] = inst_50947__$1);

(statearr_51059[(26)] = inst_50950);

(statearr_51059[(24)] = inst_50948__$1);

(statearr_51059[(25)] = inst_50952__$1);

return statearr_51059;
})();
if(cljs.core.truth_(inst_50953)){
var statearr_51060_51140 = state_51031__$1;
(statearr_51060_51140[(1)] = (23));

} else {
var statearr_51061_51141 = state_51031__$1;
(statearr_51061_51141[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (36))){
var state_51031__$1 = state_51031;
var statearr_51062_51142 = state_51031__$1;
(statearr_51062_51142[(2)] = false);

(statearr_51062_51142[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (41))){
var inst_51006 = (state_51031[(20)]);
var inst_51010 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_51011 = cljs.core.map.call(null,inst_51010,inst_51006);
var inst_51012 = cljs.core.pr_str.call(null,inst_51011);
var inst_51013 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_51012)].join('');
var inst_51014 = figwheel.client.utils.log.call(null,inst_51013);
var state_51031__$1 = state_51031;
var statearr_51063_51143 = state_51031__$1;
(statearr_51063_51143[(2)] = inst_51014);

(statearr_51063_51143[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (43))){
var inst_51007 = (state_51031[(21)]);
var inst_51017 = (state_51031[(2)]);
var inst_51018 = cljs.core.not_empty.call(null,inst_51007);
var state_51031__$1 = (function (){var statearr_51064 = state_51031;
(statearr_51064[(27)] = inst_51017);

return statearr_51064;
})();
if(cljs.core.truth_(inst_51018)){
var statearr_51065_51144 = state_51031__$1;
(statearr_51065_51144[(1)] = (44));

} else {
var statearr_51066_51145 = state_51031__$1;
(statearr_51066_51145[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (29))){
var inst_50984 = (state_51031[(16)]);
var inst_50944 = (state_51031[(19)]);
var inst_50947 = (state_51031[(23)]);
var inst_50950 = (state_51031[(26)]);
var inst_50948 = (state_51031[(24)]);
var inst_50952 = (state_51031[(25)]);
var inst_50980 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_50983 = (function (){var all_files = inst_50944;
var res_SINGLEQUOTE_ = inst_50947;
var res = inst_50948;
var files_not_loaded = inst_50950;
var dependencies_that_loaded = inst_50952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50984,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50980,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__50982){
var map__51067 = p__50982;
var map__51067__$1 = ((((!((map__51067 == null)))?((((map__51067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51067.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51067):map__51067);
var namespace = cljs.core.get.call(null,map__51067__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50984,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50980,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50984__$1 = cljs.core.group_by.call(null,inst_50983,inst_50950);
var inst_50986 = (inst_50984__$1 == null);
var inst_50987 = cljs.core.not.call(null,inst_50986);
var state_51031__$1 = (function (){var statearr_51069 = state_51031;
(statearr_51069[(16)] = inst_50984__$1);

(statearr_51069[(28)] = inst_50980);

return statearr_51069;
})();
if(inst_50987){
var statearr_51070_51146 = state_51031__$1;
(statearr_51070_51146[(1)] = (32));

} else {
var statearr_51071_51147 = state_51031__$1;
(statearr_51071_51147[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (44))){
var inst_51007 = (state_51031[(21)]);
var inst_51020 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_51007);
var inst_51021 = cljs.core.pr_str.call(null,inst_51020);
var inst_51022 = [cljs.core.str("not required: "),cljs.core.str(inst_51021)].join('');
var inst_51023 = figwheel.client.utils.log.call(null,inst_51022);
var state_51031__$1 = state_51031;
var statearr_51072_51148 = state_51031__$1;
(statearr_51072_51148[(2)] = inst_51023);

(statearr_51072_51148[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (6))){
var inst_50925 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
var statearr_51073_51149 = state_51031__$1;
(statearr_51073_51149[(2)] = inst_50925);

(statearr_51073_51149[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (28))){
var inst_50950 = (state_51031[(26)]);
var inst_50977 = (state_51031[(2)]);
var inst_50978 = cljs.core.not_empty.call(null,inst_50950);
var state_51031__$1 = (function (){var statearr_51074 = state_51031;
(statearr_51074[(29)] = inst_50977);

return statearr_51074;
})();
if(cljs.core.truth_(inst_50978)){
var statearr_51075_51150 = state_51031__$1;
(statearr_51075_51150[(1)] = (29));

} else {
var statearr_51076_51151 = state_51031__$1;
(statearr_51076_51151[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (25))){
var inst_50948 = (state_51031[(24)]);
var inst_50964 = (state_51031[(2)]);
var inst_50965 = cljs.core.not_empty.call(null,inst_50948);
var state_51031__$1 = (function (){var statearr_51077 = state_51031;
(statearr_51077[(30)] = inst_50964);

return statearr_51077;
})();
if(cljs.core.truth_(inst_50965)){
var statearr_51078_51152 = state_51031__$1;
(statearr_51078_51152[(1)] = (26));

} else {
var statearr_51079_51153 = state_51031__$1;
(statearr_51079_51153[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (34))){
var inst_51000 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
if(cljs.core.truth_(inst_51000)){
var statearr_51080_51154 = state_51031__$1;
(statearr_51080_51154[(1)] = (38));

} else {
var statearr_51081_51155 = state_51031__$1;
(statearr_51081_51155[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (17))){
var state_51031__$1 = state_51031;
var statearr_51082_51156 = state_51031__$1;
(statearr_51082_51156[(2)] = recompile_dependents);

(statearr_51082_51156[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (3))){
var state_51031__$1 = state_51031;
var statearr_51083_51157 = state_51031__$1;
(statearr_51083_51157[(2)] = null);

(statearr_51083_51157[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (12))){
var inst_50921 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
var statearr_51084_51158 = state_51031__$1;
(statearr_51084_51158[(2)] = inst_50921);

(statearr_51084_51158[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (2))){
var inst_50883 = (state_51031[(13)]);
var inst_50890 = cljs.core.seq.call(null,inst_50883);
var inst_50891 = inst_50890;
var inst_50892 = null;
var inst_50893 = (0);
var inst_50894 = (0);
var state_51031__$1 = (function (){var statearr_51085 = state_51031;
(statearr_51085[(7)] = inst_50894);

(statearr_51085[(8)] = inst_50891);

(statearr_51085[(9)] = inst_50893);

(statearr_51085[(10)] = inst_50892);

return statearr_51085;
})();
var statearr_51086_51159 = state_51031__$1;
(statearr_51086_51159[(2)] = null);

(statearr_51086_51159[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (23))){
var inst_50944 = (state_51031[(19)]);
var inst_50947 = (state_51031[(23)]);
var inst_50950 = (state_51031[(26)]);
var inst_50948 = (state_51031[(24)]);
var inst_50952 = (state_51031[(25)]);
var inst_50955 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_50957 = (function (){var all_files = inst_50944;
var res_SINGLEQUOTE_ = inst_50947;
var res = inst_50948;
var files_not_loaded = inst_50950;
var dependencies_that_loaded = inst_50952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50955,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__50956){
var map__51087 = p__50956;
var map__51087__$1 = ((((!((map__51087 == null)))?((((map__51087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51087.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51087):map__51087);
var request_url = cljs.core.get.call(null,map__51087__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50955,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50958 = cljs.core.reverse.call(null,inst_50952);
var inst_50959 = cljs.core.map.call(null,inst_50957,inst_50958);
var inst_50960 = cljs.core.pr_str.call(null,inst_50959);
var inst_50961 = figwheel.client.utils.log.call(null,inst_50960);
var state_51031__$1 = (function (){var statearr_51089 = state_51031;
(statearr_51089[(31)] = inst_50955);

return statearr_51089;
})();
var statearr_51090_51160 = state_51031__$1;
(statearr_51090_51160[(2)] = inst_50961);

(statearr_51090_51160[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (35))){
var state_51031__$1 = state_51031;
var statearr_51091_51161 = state_51031__$1;
(statearr_51091_51161[(2)] = true);

(statearr_51091_51161[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (19))){
var inst_50934 = (state_51031[(12)]);
var inst_50940 = figwheel.client.file_reloading.expand_files.call(null,inst_50934);
var state_51031__$1 = state_51031;
var statearr_51092_51162 = state_51031__$1;
(statearr_51092_51162[(2)] = inst_50940);

(statearr_51092_51162[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (11))){
var state_51031__$1 = state_51031;
var statearr_51093_51163 = state_51031__$1;
(statearr_51093_51163[(2)] = null);

(statearr_51093_51163[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (9))){
var inst_50923 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
var statearr_51094_51164 = state_51031__$1;
(statearr_51094_51164[(2)] = inst_50923);

(statearr_51094_51164[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (5))){
var inst_50894 = (state_51031[(7)]);
var inst_50893 = (state_51031[(9)]);
var inst_50896 = (inst_50894 < inst_50893);
var inst_50897 = inst_50896;
var state_51031__$1 = state_51031;
if(cljs.core.truth_(inst_50897)){
var statearr_51095_51165 = state_51031__$1;
(statearr_51095_51165[(1)] = (7));

} else {
var statearr_51096_51166 = state_51031__$1;
(statearr_51096_51166[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (14))){
var inst_50904 = (state_51031[(22)]);
var inst_50913 = cljs.core.first.call(null,inst_50904);
var inst_50914 = figwheel.client.file_reloading.eval_body.call(null,inst_50913,opts);
var inst_50915 = cljs.core.next.call(null,inst_50904);
var inst_50891 = inst_50915;
var inst_50892 = null;
var inst_50893 = (0);
var inst_50894 = (0);
var state_51031__$1 = (function (){var statearr_51097 = state_51031;
(statearr_51097[(7)] = inst_50894);

(statearr_51097[(32)] = inst_50914);

(statearr_51097[(8)] = inst_50891);

(statearr_51097[(9)] = inst_50893);

(statearr_51097[(10)] = inst_50892);

return statearr_51097;
})();
var statearr_51098_51167 = state_51031__$1;
(statearr_51098_51167[(2)] = null);

(statearr_51098_51167[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (45))){
var state_51031__$1 = state_51031;
var statearr_51099_51168 = state_51031__$1;
(statearr_51099_51168[(2)] = null);

(statearr_51099_51168[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (26))){
var inst_50944 = (state_51031[(19)]);
var inst_50947 = (state_51031[(23)]);
var inst_50950 = (state_51031[(26)]);
var inst_50948 = (state_51031[(24)]);
var inst_50952 = (state_51031[(25)]);
var inst_50967 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_50969 = (function (){var all_files = inst_50944;
var res_SINGLEQUOTE_ = inst_50947;
var res = inst_50948;
var files_not_loaded = inst_50950;
var dependencies_that_loaded = inst_50952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50967,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__50968){
var map__51100 = p__50968;
var map__51100__$1 = ((((!((map__51100 == null)))?((((map__51100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51100.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51100):map__51100);
var namespace = cljs.core.get.call(null,map__51100__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__51100__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50967,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50970 = cljs.core.map.call(null,inst_50969,inst_50948);
var inst_50971 = cljs.core.pr_str.call(null,inst_50970);
var inst_50972 = figwheel.client.utils.log.call(null,inst_50971);
var inst_50973 = (function (){var all_files = inst_50944;
var res_SINGLEQUOTE_ = inst_50947;
var res = inst_50948;
var files_not_loaded = inst_50950;
var dependencies_that_loaded = inst_50952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50967,inst_50969,inst_50970,inst_50971,inst_50972,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50944,inst_50947,inst_50950,inst_50948,inst_50952,inst_50967,inst_50969,inst_50970,inst_50971,inst_50972,state_val_51032,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50974 = setTimeout(inst_50973,(10));
var state_51031__$1 = (function (){var statearr_51102 = state_51031;
(statearr_51102[(33)] = inst_50972);

(statearr_51102[(34)] = inst_50967);

return statearr_51102;
})();
var statearr_51103_51169 = state_51031__$1;
(statearr_51103_51169[(2)] = inst_50974);

(statearr_51103_51169[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (16))){
var state_51031__$1 = state_51031;
var statearr_51104_51170 = state_51031__$1;
(statearr_51104_51170[(2)] = reload_dependents);

(statearr_51104_51170[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (38))){
var inst_50984 = (state_51031[(16)]);
var inst_51002 = cljs.core.apply.call(null,cljs.core.hash_map,inst_50984);
var state_51031__$1 = state_51031;
var statearr_51105_51171 = state_51031__$1;
(statearr_51105_51171[(2)] = inst_51002);

(statearr_51105_51171[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (30))){
var state_51031__$1 = state_51031;
var statearr_51106_51172 = state_51031__$1;
(statearr_51106_51172[(2)] = null);

(statearr_51106_51172[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (10))){
var inst_50904 = (state_51031[(22)]);
var inst_50906 = cljs.core.chunked_seq_QMARK_.call(null,inst_50904);
var state_51031__$1 = state_51031;
if(inst_50906){
var statearr_51107_51173 = state_51031__$1;
(statearr_51107_51173[(1)] = (13));

} else {
var statearr_51108_51174 = state_51031__$1;
(statearr_51108_51174[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (18))){
var inst_50938 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
if(cljs.core.truth_(inst_50938)){
var statearr_51109_51175 = state_51031__$1;
(statearr_51109_51175[(1)] = (19));

} else {
var statearr_51110_51176 = state_51031__$1;
(statearr_51110_51176[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (42))){
var state_51031__$1 = state_51031;
var statearr_51111_51177 = state_51031__$1;
(statearr_51111_51177[(2)] = null);

(statearr_51111_51177[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (37))){
var inst_50997 = (state_51031[(2)]);
var state_51031__$1 = state_51031;
var statearr_51112_51178 = state_51031__$1;
(statearr_51112_51178[(2)] = inst_50997);

(statearr_51112_51178[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51032 === (8))){
var inst_50891 = (state_51031[(8)]);
var inst_50904 = (state_51031[(22)]);
var inst_50904__$1 = cljs.core.seq.call(null,inst_50891);
var state_51031__$1 = (function (){var statearr_51113 = state_51031;
(statearr_51113[(22)] = inst_50904__$1);

return statearr_51113;
})();
if(inst_50904__$1){
var statearr_51114_51179 = state_51031__$1;
(statearr_51114_51179[(1)] = (10));

} else {
var statearr_51115_51180 = state_51031__$1;
(statearr_51115_51180[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__50079__auto__,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto____0 = (function (){
var statearr_51119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51119[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto__);

(statearr_51119[(1)] = (1));

return statearr_51119;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto____1 = (function (state_51031){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_51031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e51120){if((e51120 instanceof Object)){
var ex__50083__auto__ = e51120;
var statearr_51121_51181 = state_51031;
(statearr_51121_51181[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51031);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51182 = state_51031;
state_51031 = G__51182;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto__ = function(state_51031){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto____1.call(this,state_51031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__50104__auto__ = (function (){var statearr_51122 = f__50103__auto__.call(null);
(statearr_51122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto__);

return statearr_51122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto__,map__50876,map__50876__$1,opts,before_jsload,on_jsload,reload_dependents,map__50877,map__50877__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__50102__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__51185,link){
var map__51188 = p__51185;
var map__51188__$1 = ((((!((map__51188 == null)))?((((map__51188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51188.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51188):map__51188);
var file = cljs.core.get.call(null,map__51188__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__51188,map__51188__$1,file){
return (function (p1__51183_SHARP_,p2__51184_SHARP_){
if(cljs.core._EQ_.call(null,p1__51183_SHARP_,p2__51184_SHARP_)){
return p1__51183_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__51188,map__51188__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__51194){
var map__51195 = p__51194;
var map__51195__$1 = ((((!((map__51195 == null)))?((((map__51195.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51195.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51195):map__51195);
var match_length = cljs.core.get.call(null,map__51195__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__51195__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__51190_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__51190_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args51197 = [];
var len__48681__auto___51200 = arguments.length;
var i__48682__auto___51201 = (0);
while(true){
if((i__48682__auto___51201 < len__48681__auto___51200)){
args51197.push((arguments[i__48682__auto___51201]));

var G__51202 = (i__48682__auto___51201 + (1));
i__48682__auto___51201 = G__51202;
continue;
} else {
}
break;
}

var G__51199 = args51197.length;
switch (G__51199) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args51197.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__51204_SHARP_,p2__51205_SHARP_){
return cljs.core.assoc.call(null,p1__51204_SHARP_,cljs.core.get.call(null,p2__51205_SHARP_,key),p2__51205_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__51206){
var map__51209 = p__51206;
var map__51209__$1 = ((((!((map__51209 == null)))?((((map__51209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51209.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51209):map__51209);
var f_data = map__51209__$1;
var file = cljs.core.get.call(null,map__51209__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__51211,p__51212){
var map__51221 = p__51211;
var map__51221__$1 = ((((!((map__51221 == null)))?((((map__51221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51221.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51221):map__51221);
var opts = map__51221__$1;
var on_cssload = cljs.core.get.call(null,map__51221__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__51222 = p__51212;
var map__51222__$1 = ((((!((map__51222 == null)))?((((map__51222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51222.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51222):map__51222);
var files_msg = map__51222__$1;
var files = cljs.core.get.call(null,map__51222__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__51225_51229 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__51226_51230 = null;
var count__51227_51231 = (0);
var i__51228_51232 = (0);
while(true){
if((i__51228_51232 < count__51227_51231)){
var f_51233 = cljs.core._nth.call(null,chunk__51226_51230,i__51228_51232);
figwheel.client.file_reloading.reload_css_file.call(null,f_51233);

var G__51234 = seq__51225_51229;
var G__51235 = chunk__51226_51230;
var G__51236 = count__51227_51231;
var G__51237 = (i__51228_51232 + (1));
seq__51225_51229 = G__51234;
chunk__51226_51230 = G__51235;
count__51227_51231 = G__51236;
i__51228_51232 = G__51237;
continue;
} else {
var temp__6753__auto___51238 = cljs.core.seq.call(null,seq__51225_51229);
if(temp__6753__auto___51238){
var seq__51225_51239__$1 = temp__6753__auto___51238;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__51225_51239__$1)){
var c__48371__auto___51240 = cljs.core.chunk_first.call(null,seq__51225_51239__$1);
var G__51241 = cljs.core.chunk_rest.call(null,seq__51225_51239__$1);
var G__51242 = c__48371__auto___51240;
var G__51243 = cljs.core.count.call(null,c__48371__auto___51240);
var G__51244 = (0);
seq__51225_51229 = G__51241;
chunk__51226_51230 = G__51242;
count__51227_51231 = G__51243;
i__51228_51232 = G__51244;
continue;
} else {
var f_51245 = cljs.core.first.call(null,seq__51225_51239__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_51245);

var G__51246 = cljs.core.next.call(null,seq__51225_51239__$1);
var G__51247 = null;
var G__51248 = (0);
var G__51249 = (0);
seq__51225_51229 = G__51246;
chunk__51226_51230 = G__51247;
count__51227_51231 = G__51248;
i__51228_51232 = G__51249;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__51221,map__51221__$1,opts,on_cssload,map__51222,map__51222__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__51221,map__51221__$1,opts,on_cssload,map__51222,map__51222__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1483104684408