// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args21544 = [];
var len__10601__auto___21550 = arguments.length;
var i__10602__auto___21551 = (0);
while(true){
if((i__10602__auto___21551 < len__10601__auto___21550)){
args21544.push((arguments[i__10602__auto___21551]));

var G__21552 = (i__10602__auto___21551 + (1));
i__10602__auto___21551 = G__21552;
continue;
} else {
}
break;
}

var G__21546 = args21544.length;
switch (G__21546) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21544.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async21547 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21547 = (function (f,blockable,meta21548){
this.f = f;
this.blockable = blockable;
this.meta21548 = meta21548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21549,meta21548__$1){
var self__ = this;
var _21549__$1 = this;
return (new cljs.core.async.t_cljs$core$async21547(self__.f,self__.blockable,meta21548__$1));
});

cljs.core.async.t_cljs$core$async21547.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21549){
var self__ = this;
var _21549__$1 = this;
return self__.meta21548;
});

cljs.core.async.t_cljs$core$async21547.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21547.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async21547.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async21547.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async21547.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta21548","meta21548",-800779808,null)], null);
});

cljs.core.async.t_cljs$core$async21547.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21547.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21547";

cljs.core.async.t_cljs$core$async21547.cljs$lang$ctorPrWriter = (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async21547");
});

cljs.core.async.__GT_t_cljs$core$async21547 = (function cljs$core$async$__GT_t_cljs$core$async21547(f__$1,blockable__$1,meta21548){
return (new cljs.core.async.t_cljs$core$async21547(f__$1,blockable__$1,meta21548));
});

}

return (new cljs.core.async.t_cljs$core$async21547(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args21556 = [];
var len__10601__auto___21559 = arguments.length;
var i__10602__auto___21560 = (0);
while(true){
if((i__10602__auto___21560 < len__10601__auto___21559)){
args21556.push((arguments[i__10602__auto___21560]));

var G__21561 = (i__10602__auto___21560 + (1));
i__10602__auto___21560 = G__21561;
continue;
} else {
}
break;
}

var G__21558 = args21556.length;
switch (G__21558) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21556.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args21563 = [];
var len__10601__auto___21566 = arguments.length;
var i__10602__auto___21567 = (0);
while(true){
if((i__10602__auto___21567 < len__10601__auto___21566)){
args21563.push((arguments[i__10602__auto___21567]));

var G__21568 = (i__10602__auto___21567 + (1));
i__10602__auto___21567 = G__21568;
continue;
} else {
}
break;
}

var G__21565 = args21563.length;
switch (G__21565) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21563.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args21570 = [];
var len__10601__auto___21573 = arguments.length;
var i__10602__auto___21574 = (0);
while(true){
if((i__10602__auto___21574 < len__10601__auto___21573)){
args21570.push((arguments[i__10602__auto___21574]));

var G__21575 = (i__10602__auto___21574 + (1));
i__10602__auto___21574 = G__21575;
continue;
} else {
}
break;
}

var G__21572 = args21570.length;
switch (G__21572) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21570.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_21577 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_21577);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_21577,ret){
return (function (){
return fn1.call(null,val_21577);
});})(val_21577,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args21578 = [];
var len__10601__auto___21581 = arguments.length;
var i__10602__auto___21582 = (0);
while(true){
if((i__10602__auto___21582 < len__10601__auto___21581)){
args21578.push((arguments[i__10602__auto___21582]));

var G__21583 = (i__10602__auto___21582 + (1));
i__10602__auto___21582 = G__21583;
continue;
} else {
}
break;
}

var G__21580 = args21578.length;
switch (G__21580) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21578.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10401__auto___21585 = n;
var x_21586 = (0);
while(true){
if((x_21586 < n__10401__auto___21585)){
(a[x_21586] = (0));

var G__21587 = (x_21586 + (1));
x_21586 = G__21587;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__21588 = (i + (1));
i = G__21588;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async21592 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21592 = (function (flag,meta21593){
this.flag = flag;
this.meta21593 = meta21593;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21592.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_21594,meta21593__$1){
var self__ = this;
var _21594__$1 = this;
return (new cljs.core.async.t_cljs$core$async21592(self__.flag,meta21593__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async21592.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_21594){
var self__ = this;
var _21594__$1 = this;
return self__.meta21593;
});})(flag))
;

cljs.core.async.t_cljs$core$async21592.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21592.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async21592.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async21592.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async21592.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta21593","meta21593",-507229830,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async21592.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21592.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21592";

cljs.core.async.t_cljs$core$async21592.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async21592");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async21592 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async21592(flag__$1,meta21593){
return (new cljs.core.async.t_cljs$core$async21592(flag__$1,meta21593));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async21592(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async21598 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21598 = (function (flag,cb,meta21599){
this.flag = flag;
this.cb = cb;
this.meta21599 = meta21599;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21600,meta21599__$1){
var self__ = this;
var _21600__$1 = this;
return (new cljs.core.async.t_cljs$core$async21598(self__.flag,self__.cb,meta21599__$1));
});

cljs.core.async.t_cljs$core$async21598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21600){
var self__ = this;
var _21600__$1 = this;
return self__.meta21599;
});

cljs.core.async.t_cljs$core$async21598.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async21598.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async21598.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async21598.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async21598.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta21599","meta21599",-1062678562,null)], null);
});

cljs.core.async.t_cljs$core$async21598.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21598.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21598";

cljs.core.async.t_cljs$core$async21598.cljs$lang$ctorPrWriter = (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async21598");
});

cljs.core.async.__GT_t_cljs$core$async21598 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async21598(flag__$1,cb__$1,meta21599){
return (new cljs.core.async.t_cljs$core$async21598(flag__$1,cb__$1,meta21599));
});

}

return (new cljs.core.async.t_cljs$core$async21598(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__21601_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__21601_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__21602_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__21602_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9385__auto__ = wport;
if(cljs.core.truth_(or__9385__auto__)){
return or__9385__auto__;
} else {
return port;
}
})()], null));
} else {
var G__21603 = (i + (1));
i = G__21603;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9385__auto__ = ret;
if(cljs.core.truth_(or__9385__auto__)){
return or__9385__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__9373__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9373__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9373__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10608__auto__ = [];
var len__10601__auto___21609 = arguments.length;
var i__10602__auto___21610 = (0);
while(true){
if((i__10602__auto___21610 < len__10601__auto___21609)){
args__10608__auto__.push((arguments[i__10602__auto___21610]));

var G__21611 = (i__10602__auto___21610 + (1));
i__10602__auto___21610 = G__21611;
continue;
} else {
}
break;
}

var argseq__10609__auto__ = ((((1) < args__10608__auto__.length))?(new cljs.core.IndexedSeq(args__10608__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10609__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__21606){
var map__21607 = p__21606;
var map__21607__$1 = ((((!((map__21607 == null)))?((((map__21607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21607.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21607):map__21607);
var opts = map__21607__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq21604){
var G__21605 = cljs.core.first.call(null,seq21604);
var seq21604__$1 = cljs.core.next.call(null,seq21604);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21605,seq21604__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args21612 = [];
var len__10601__auto___21662 = arguments.length;
var i__10602__auto___21663 = (0);
while(true){
if((i__10602__auto___21663 < len__10601__auto___21662)){
args21612.push((arguments[i__10602__auto___21663]));

var G__21664 = (i__10602__auto___21663 + (1));
i__10602__auto___21663 = G__21664;
continue;
} else {
}
break;
}

var G__21614 = args21612.length;
switch (G__21614) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21612.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__21485__auto___21666 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___21666){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___21666){
return (function (state_21638){
var state_val_21639 = (state_21638[(1)]);
if((state_val_21639 === (7))){
var inst_21634 = (state_21638[(2)]);
var state_21638__$1 = state_21638;
var statearr_21640_21667 = state_21638__$1;
(statearr_21640_21667[(2)] = inst_21634);

(statearr_21640_21667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (1))){
var state_21638__$1 = state_21638;
var statearr_21641_21668 = state_21638__$1;
(statearr_21641_21668[(2)] = null);

(statearr_21641_21668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (4))){
var inst_21617 = (state_21638[(7)]);
var inst_21617__$1 = (state_21638[(2)]);
var inst_21618 = (inst_21617__$1 == null);
var state_21638__$1 = (function (){var statearr_21642 = state_21638;
(statearr_21642[(7)] = inst_21617__$1);

return statearr_21642;
})();
if(cljs.core.truth_(inst_21618)){
var statearr_21643_21669 = state_21638__$1;
(statearr_21643_21669[(1)] = (5));

} else {
var statearr_21644_21670 = state_21638__$1;
(statearr_21644_21670[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (13))){
var state_21638__$1 = state_21638;
var statearr_21645_21671 = state_21638__$1;
(statearr_21645_21671[(2)] = null);

(statearr_21645_21671[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (6))){
var inst_21617 = (state_21638[(7)]);
var state_21638__$1 = state_21638;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21638__$1,(11),to,inst_21617);
} else {
if((state_val_21639 === (3))){
var inst_21636 = (state_21638[(2)]);
var state_21638__$1 = state_21638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21638__$1,inst_21636);
} else {
if((state_val_21639 === (12))){
var state_21638__$1 = state_21638;
var statearr_21646_21672 = state_21638__$1;
(statearr_21646_21672[(2)] = null);

(statearr_21646_21672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (2))){
var state_21638__$1 = state_21638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21638__$1,(4),from);
} else {
if((state_val_21639 === (11))){
var inst_21627 = (state_21638[(2)]);
var state_21638__$1 = state_21638;
if(cljs.core.truth_(inst_21627)){
var statearr_21647_21673 = state_21638__$1;
(statearr_21647_21673[(1)] = (12));

} else {
var statearr_21648_21674 = state_21638__$1;
(statearr_21648_21674[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (9))){
var state_21638__$1 = state_21638;
var statearr_21649_21675 = state_21638__$1;
(statearr_21649_21675[(2)] = null);

(statearr_21649_21675[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (5))){
var state_21638__$1 = state_21638;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21650_21676 = state_21638__$1;
(statearr_21650_21676[(1)] = (8));

} else {
var statearr_21651_21677 = state_21638__$1;
(statearr_21651_21677[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (14))){
var inst_21632 = (state_21638[(2)]);
var state_21638__$1 = state_21638;
var statearr_21652_21678 = state_21638__$1;
(statearr_21652_21678[(2)] = inst_21632);

(statearr_21652_21678[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (10))){
var inst_21624 = (state_21638[(2)]);
var state_21638__$1 = state_21638;
var statearr_21653_21679 = state_21638__$1;
(statearr_21653_21679[(2)] = inst_21624);

(statearr_21653_21679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21639 === (8))){
var inst_21621 = cljs.core.async.close_BANG_.call(null,to);
var state_21638__$1 = state_21638;
var statearr_21654_21680 = state_21638__$1;
(statearr_21654_21680[(2)] = inst_21621);

(statearr_21654_21680[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___21666))
;
return ((function (switch__21371__auto__,c__21485__auto___21666){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_21658 = [null,null,null,null,null,null,null,null];
(statearr_21658[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_21658[(1)] = (1));

return statearr_21658;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_21638){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_21638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e21659){if((e21659 instanceof Object)){
var ex__21375__auto__ = e21659;
var statearr_21660_21681 = state_21638;
(statearr_21660_21681[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21638);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21682 = state_21638;
state_21638 = G__21682;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_21638){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_21638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___21666))
})();
var state__21487__auto__ = (function (){var statearr_21661 = f__21486__auto__.call(null);
(statearr_21661[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___21666);

return statearr_21661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___21666))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__21870){
var vec__21871 = p__21870;
var v = cljs.core.nth.call(null,vec__21871,(0),null);
var p = cljs.core.nth.call(null,vec__21871,(1),null);
var job = vec__21871;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__21485__auto___22057 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___22057,res,vec__21871,v,p,job,jobs,results){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___22057,res,vec__21871,v,p,job,jobs,results){
return (function (state_21878){
var state_val_21879 = (state_21878[(1)]);
if((state_val_21879 === (1))){
var state_21878__$1 = state_21878;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21878__$1,(2),res,v);
} else {
if((state_val_21879 === (2))){
var inst_21875 = (state_21878[(2)]);
var inst_21876 = cljs.core.async.close_BANG_.call(null,res);
var state_21878__$1 = (function (){var statearr_21880 = state_21878;
(statearr_21880[(7)] = inst_21875);

return statearr_21880;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21878__$1,inst_21876);
} else {
return null;
}
}
});})(c__21485__auto___22057,res,vec__21871,v,p,job,jobs,results))
;
return ((function (switch__21371__auto__,c__21485__auto___22057,res,vec__21871,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0 = (function (){
var statearr_21884 = [null,null,null,null,null,null,null,null];
(statearr_21884[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__);

(statearr_21884[(1)] = (1));

return statearr_21884;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1 = (function (state_21878){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_21878);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e21885){if((e21885 instanceof Object)){
var ex__21375__auto__ = e21885;
var statearr_21886_22058 = state_21878;
(statearr_21886_22058[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21878);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22059 = state_21878;
state_21878 = G__22059;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = function(state_21878){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1.call(this,state_21878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___22057,res,vec__21871,v,p,job,jobs,results))
})();
var state__21487__auto__ = (function (){var statearr_21887 = f__21486__auto__.call(null);
(statearr_21887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___22057);

return statearr_21887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___22057,res,vec__21871,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__21888){
var vec__21889 = p__21888;
var v = cljs.core.nth.call(null,vec__21889,(0),null);
var p = cljs.core.nth.call(null,vec__21889,(1),null);
var job = vec__21889;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10401__auto___22060 = n;
var __22061 = (0);
while(true){
if((__22061 < n__10401__auto___22060)){
var G__21892_22062 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__21892_22062) {
case "compute":
var c__21485__auto___22064 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__22061,c__21485__auto___22064,G__21892_22062,n__10401__auto___22060,jobs,results,process,async){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (__22061,c__21485__auto___22064,G__21892_22062,n__10401__auto___22060,jobs,results,process,async){
return (function (state_21905){
var state_val_21906 = (state_21905[(1)]);
if((state_val_21906 === (1))){
var state_21905__$1 = state_21905;
var statearr_21907_22065 = state_21905__$1;
(statearr_21907_22065[(2)] = null);

(statearr_21907_22065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21906 === (2))){
var state_21905__$1 = state_21905;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21905__$1,(4),jobs);
} else {
if((state_val_21906 === (3))){
var inst_21903 = (state_21905[(2)]);
var state_21905__$1 = state_21905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21905__$1,inst_21903);
} else {
if((state_val_21906 === (4))){
var inst_21895 = (state_21905[(2)]);
var inst_21896 = process.call(null,inst_21895);
var state_21905__$1 = state_21905;
if(cljs.core.truth_(inst_21896)){
var statearr_21908_22066 = state_21905__$1;
(statearr_21908_22066[(1)] = (5));

} else {
var statearr_21909_22067 = state_21905__$1;
(statearr_21909_22067[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21906 === (5))){
var state_21905__$1 = state_21905;
var statearr_21910_22068 = state_21905__$1;
(statearr_21910_22068[(2)] = null);

(statearr_21910_22068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21906 === (6))){
var state_21905__$1 = state_21905;
var statearr_21911_22069 = state_21905__$1;
(statearr_21911_22069[(2)] = null);

(statearr_21911_22069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21906 === (7))){
var inst_21901 = (state_21905[(2)]);
var state_21905__$1 = state_21905;
var statearr_21912_22070 = state_21905__$1;
(statearr_21912_22070[(2)] = inst_21901);

(statearr_21912_22070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__22061,c__21485__auto___22064,G__21892_22062,n__10401__auto___22060,jobs,results,process,async))
;
return ((function (__22061,switch__21371__auto__,c__21485__auto___22064,G__21892_22062,n__10401__auto___22060,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0 = (function (){
var statearr_21916 = [null,null,null,null,null,null,null];
(statearr_21916[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__);

(statearr_21916[(1)] = (1));

return statearr_21916;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1 = (function (state_21905){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_21905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e21917){if((e21917 instanceof Object)){
var ex__21375__auto__ = e21917;
var statearr_21918_22071 = state_21905;
(statearr_21918_22071[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21917;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22072 = state_21905;
state_21905 = G__22072;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = function(state_21905){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1.call(this,state_21905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__;
})()
;})(__22061,switch__21371__auto__,c__21485__auto___22064,G__21892_22062,n__10401__auto___22060,jobs,results,process,async))
})();
var state__21487__auto__ = (function (){var statearr_21919 = f__21486__auto__.call(null);
(statearr_21919[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___22064);

return statearr_21919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(__22061,c__21485__auto___22064,G__21892_22062,n__10401__auto___22060,jobs,results,process,async))
);


break;
case "async":
var c__21485__auto___22073 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__22061,c__21485__auto___22073,G__21892_22062,n__10401__auto___22060,jobs,results,process,async){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (__22061,c__21485__auto___22073,G__21892_22062,n__10401__auto___22060,jobs,results,process,async){
return (function (state_21932){
var state_val_21933 = (state_21932[(1)]);
if((state_val_21933 === (1))){
var state_21932__$1 = state_21932;
var statearr_21934_22074 = state_21932__$1;
(statearr_21934_22074[(2)] = null);

(statearr_21934_22074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21933 === (2))){
var state_21932__$1 = state_21932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21932__$1,(4),jobs);
} else {
if((state_val_21933 === (3))){
var inst_21930 = (state_21932[(2)]);
var state_21932__$1 = state_21932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21932__$1,inst_21930);
} else {
if((state_val_21933 === (4))){
var inst_21922 = (state_21932[(2)]);
var inst_21923 = async.call(null,inst_21922);
var state_21932__$1 = state_21932;
if(cljs.core.truth_(inst_21923)){
var statearr_21935_22075 = state_21932__$1;
(statearr_21935_22075[(1)] = (5));

} else {
var statearr_21936_22076 = state_21932__$1;
(statearr_21936_22076[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21933 === (5))){
var state_21932__$1 = state_21932;
var statearr_21937_22077 = state_21932__$1;
(statearr_21937_22077[(2)] = null);

(statearr_21937_22077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21933 === (6))){
var state_21932__$1 = state_21932;
var statearr_21938_22078 = state_21932__$1;
(statearr_21938_22078[(2)] = null);

(statearr_21938_22078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21933 === (7))){
var inst_21928 = (state_21932[(2)]);
var state_21932__$1 = state_21932;
var statearr_21939_22079 = state_21932__$1;
(statearr_21939_22079[(2)] = inst_21928);

(statearr_21939_22079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__22061,c__21485__auto___22073,G__21892_22062,n__10401__auto___22060,jobs,results,process,async))
;
return ((function (__22061,switch__21371__auto__,c__21485__auto___22073,G__21892_22062,n__10401__auto___22060,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0 = (function (){
var statearr_21943 = [null,null,null,null,null,null,null];
(statearr_21943[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__);

(statearr_21943[(1)] = (1));

return statearr_21943;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1 = (function (state_21932){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_21932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e21944){if((e21944 instanceof Object)){
var ex__21375__auto__ = e21944;
var statearr_21945_22080 = state_21932;
(statearr_21945_22080[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21944;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22081 = state_21932;
state_21932 = G__22081;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = function(state_21932){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1.call(this,state_21932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__;
})()
;})(__22061,switch__21371__auto__,c__21485__auto___22073,G__21892_22062,n__10401__auto___22060,jobs,results,process,async))
})();
var state__21487__auto__ = (function (){var statearr_21946 = f__21486__auto__.call(null);
(statearr_21946[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___22073);

return statearr_21946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(__22061,c__21485__auto___22073,G__21892_22062,n__10401__auto___22060,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__22082 = (__22061 + (1));
__22061 = G__22082;
continue;
} else {
}
break;
}

var c__21485__auto___22083 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___22083,jobs,results,process,async){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___22083,jobs,results,process,async){
return (function (state_21968){
var state_val_21969 = (state_21968[(1)]);
if((state_val_21969 === (1))){
var state_21968__$1 = state_21968;
var statearr_21970_22084 = state_21968__$1;
(statearr_21970_22084[(2)] = null);

(statearr_21970_22084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (2))){
var state_21968__$1 = state_21968;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21968__$1,(4),from);
} else {
if((state_val_21969 === (3))){
var inst_21966 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21968__$1,inst_21966);
} else {
if((state_val_21969 === (4))){
var inst_21949 = (state_21968[(7)]);
var inst_21949__$1 = (state_21968[(2)]);
var inst_21950 = (inst_21949__$1 == null);
var state_21968__$1 = (function (){var statearr_21971 = state_21968;
(statearr_21971[(7)] = inst_21949__$1);

return statearr_21971;
})();
if(cljs.core.truth_(inst_21950)){
var statearr_21972_22085 = state_21968__$1;
(statearr_21972_22085[(1)] = (5));

} else {
var statearr_21973_22086 = state_21968__$1;
(statearr_21973_22086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (5))){
var inst_21952 = cljs.core.async.close_BANG_.call(null,jobs);
var state_21968__$1 = state_21968;
var statearr_21974_22087 = state_21968__$1;
(statearr_21974_22087[(2)] = inst_21952);

(statearr_21974_22087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (6))){
var inst_21954 = (state_21968[(8)]);
var inst_21949 = (state_21968[(7)]);
var inst_21954__$1 = cljs.core.async.chan.call(null,(1));
var inst_21955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21956 = [inst_21949,inst_21954__$1];
var inst_21957 = (new cljs.core.PersistentVector(null,2,(5),inst_21955,inst_21956,null));
var state_21968__$1 = (function (){var statearr_21975 = state_21968;
(statearr_21975[(8)] = inst_21954__$1);

return statearr_21975;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21968__$1,(8),jobs,inst_21957);
} else {
if((state_val_21969 === (7))){
var inst_21964 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_21976_22088 = state_21968__$1;
(statearr_21976_22088[(2)] = inst_21964);

(statearr_21976_22088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (8))){
var inst_21954 = (state_21968[(8)]);
var inst_21959 = (state_21968[(2)]);
var state_21968__$1 = (function (){var statearr_21977 = state_21968;
(statearr_21977[(9)] = inst_21959);

return statearr_21977;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21968__$1,(9),results,inst_21954);
} else {
if((state_val_21969 === (9))){
var inst_21961 = (state_21968[(2)]);
var state_21968__$1 = (function (){var statearr_21978 = state_21968;
(statearr_21978[(10)] = inst_21961);

return statearr_21978;
})();
var statearr_21979_22089 = state_21968__$1;
(statearr_21979_22089[(2)] = null);

(statearr_21979_22089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___22083,jobs,results,process,async))
;
return ((function (switch__21371__auto__,c__21485__auto___22083,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0 = (function (){
var statearr_21983 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21983[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__);

(statearr_21983[(1)] = (1));

return statearr_21983;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1 = (function (state_21968){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_21968);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e21984){if((e21984 instanceof Object)){
var ex__21375__auto__ = e21984;
var statearr_21985_22090 = state_21968;
(statearr_21985_22090[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21968);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21984;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22091 = state_21968;
state_21968 = G__22091;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = function(state_21968){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1.call(this,state_21968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___22083,jobs,results,process,async))
})();
var state__21487__auto__ = (function (){var statearr_21986 = f__21486__auto__.call(null);
(statearr_21986[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___22083);

return statearr_21986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___22083,jobs,results,process,async))
);


var c__21485__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto__,jobs,results,process,async){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto__,jobs,results,process,async){
return (function (state_22024){
var state_val_22025 = (state_22024[(1)]);
if((state_val_22025 === (7))){
var inst_22020 = (state_22024[(2)]);
var state_22024__$1 = state_22024;
var statearr_22026_22092 = state_22024__$1;
(statearr_22026_22092[(2)] = inst_22020);

(statearr_22026_22092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (20))){
var state_22024__$1 = state_22024;
var statearr_22027_22093 = state_22024__$1;
(statearr_22027_22093[(2)] = null);

(statearr_22027_22093[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (1))){
var state_22024__$1 = state_22024;
var statearr_22028_22094 = state_22024__$1;
(statearr_22028_22094[(2)] = null);

(statearr_22028_22094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (4))){
var inst_21989 = (state_22024[(7)]);
var inst_21989__$1 = (state_22024[(2)]);
var inst_21990 = (inst_21989__$1 == null);
var state_22024__$1 = (function (){var statearr_22029 = state_22024;
(statearr_22029[(7)] = inst_21989__$1);

return statearr_22029;
})();
if(cljs.core.truth_(inst_21990)){
var statearr_22030_22095 = state_22024__$1;
(statearr_22030_22095[(1)] = (5));

} else {
var statearr_22031_22096 = state_22024__$1;
(statearr_22031_22096[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (15))){
var inst_22002 = (state_22024[(8)]);
var state_22024__$1 = state_22024;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22024__$1,(18),to,inst_22002);
} else {
if((state_val_22025 === (21))){
var inst_22015 = (state_22024[(2)]);
var state_22024__$1 = state_22024;
var statearr_22032_22097 = state_22024__$1;
(statearr_22032_22097[(2)] = inst_22015);

(statearr_22032_22097[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (13))){
var inst_22017 = (state_22024[(2)]);
var state_22024__$1 = (function (){var statearr_22033 = state_22024;
(statearr_22033[(9)] = inst_22017);

return statearr_22033;
})();
var statearr_22034_22098 = state_22024__$1;
(statearr_22034_22098[(2)] = null);

(statearr_22034_22098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (6))){
var inst_21989 = (state_22024[(7)]);
var state_22024__$1 = state_22024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22024__$1,(11),inst_21989);
} else {
if((state_val_22025 === (17))){
var inst_22010 = (state_22024[(2)]);
var state_22024__$1 = state_22024;
if(cljs.core.truth_(inst_22010)){
var statearr_22035_22099 = state_22024__$1;
(statearr_22035_22099[(1)] = (19));

} else {
var statearr_22036_22100 = state_22024__$1;
(statearr_22036_22100[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (3))){
var inst_22022 = (state_22024[(2)]);
var state_22024__$1 = state_22024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22024__$1,inst_22022);
} else {
if((state_val_22025 === (12))){
var inst_21999 = (state_22024[(10)]);
var state_22024__$1 = state_22024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22024__$1,(14),inst_21999);
} else {
if((state_val_22025 === (2))){
var state_22024__$1 = state_22024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22024__$1,(4),results);
} else {
if((state_val_22025 === (19))){
var state_22024__$1 = state_22024;
var statearr_22037_22101 = state_22024__$1;
(statearr_22037_22101[(2)] = null);

(statearr_22037_22101[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (11))){
var inst_21999 = (state_22024[(2)]);
var state_22024__$1 = (function (){var statearr_22038 = state_22024;
(statearr_22038[(10)] = inst_21999);

return statearr_22038;
})();
var statearr_22039_22102 = state_22024__$1;
(statearr_22039_22102[(2)] = null);

(statearr_22039_22102[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (9))){
var state_22024__$1 = state_22024;
var statearr_22040_22103 = state_22024__$1;
(statearr_22040_22103[(2)] = null);

(statearr_22040_22103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (5))){
var state_22024__$1 = state_22024;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22041_22104 = state_22024__$1;
(statearr_22041_22104[(1)] = (8));

} else {
var statearr_22042_22105 = state_22024__$1;
(statearr_22042_22105[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (14))){
var inst_22002 = (state_22024[(8)]);
var inst_22004 = (state_22024[(11)]);
var inst_22002__$1 = (state_22024[(2)]);
var inst_22003 = (inst_22002__$1 == null);
var inst_22004__$1 = cljs.core.not.call(null,inst_22003);
var state_22024__$1 = (function (){var statearr_22043 = state_22024;
(statearr_22043[(8)] = inst_22002__$1);

(statearr_22043[(11)] = inst_22004__$1);

return statearr_22043;
})();
if(inst_22004__$1){
var statearr_22044_22106 = state_22024__$1;
(statearr_22044_22106[(1)] = (15));

} else {
var statearr_22045_22107 = state_22024__$1;
(statearr_22045_22107[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (16))){
var inst_22004 = (state_22024[(11)]);
var state_22024__$1 = state_22024;
var statearr_22046_22108 = state_22024__$1;
(statearr_22046_22108[(2)] = inst_22004);

(statearr_22046_22108[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (10))){
var inst_21996 = (state_22024[(2)]);
var state_22024__$1 = state_22024;
var statearr_22047_22109 = state_22024__$1;
(statearr_22047_22109[(2)] = inst_21996);

(statearr_22047_22109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (18))){
var inst_22007 = (state_22024[(2)]);
var state_22024__$1 = state_22024;
var statearr_22048_22110 = state_22024__$1;
(statearr_22048_22110[(2)] = inst_22007);

(statearr_22048_22110[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22025 === (8))){
var inst_21993 = cljs.core.async.close_BANG_.call(null,to);
var state_22024__$1 = state_22024;
var statearr_22049_22111 = state_22024__$1;
(statearr_22049_22111[(2)] = inst_21993);

(statearr_22049_22111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto__,jobs,results,process,async))
;
return ((function (switch__21371__auto__,c__21485__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0 = (function (){
var statearr_22053 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22053[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__);

(statearr_22053[(1)] = (1));

return statearr_22053;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1 = (function (state_22024){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_22024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e22054){if((e22054 instanceof Object)){
var ex__21375__auto__ = e22054;
var statearr_22055_22112 = state_22024;
(statearr_22055_22112[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22024);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22054;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22113 = state_22024;
state_22024 = G__22113;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__ = function(state_22024){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1.call(this,state_22024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21372__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto__,jobs,results,process,async))
})();
var state__21487__auto__ = (function (){var statearr_22056 = f__21486__auto__.call(null);
(statearr_22056[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto__);

return statearr_22056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto__,jobs,results,process,async))
);

return c__21485__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args22114 = [];
var len__10601__auto___22117 = arguments.length;
var i__10602__auto___22118 = (0);
while(true){
if((i__10602__auto___22118 < len__10601__auto___22117)){
args22114.push((arguments[i__10602__auto___22118]));

var G__22119 = (i__10602__auto___22118 + (1));
i__10602__auto___22118 = G__22119;
continue;
} else {
}
break;
}

var G__22116 = args22114.length;
switch (G__22116) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22114.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args22121 = [];
var len__10601__auto___22124 = arguments.length;
var i__10602__auto___22125 = (0);
while(true){
if((i__10602__auto___22125 < len__10601__auto___22124)){
args22121.push((arguments[i__10602__auto___22125]));

var G__22126 = (i__10602__auto___22125 + (1));
i__10602__auto___22125 = G__22126;
continue;
} else {
}
break;
}

var G__22123 = args22121.length;
switch (G__22123) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22121.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args22128 = [];
var len__10601__auto___22181 = arguments.length;
var i__10602__auto___22182 = (0);
while(true){
if((i__10602__auto___22182 < len__10601__auto___22181)){
args22128.push((arguments[i__10602__auto___22182]));

var G__22183 = (i__10602__auto___22182 + (1));
i__10602__auto___22182 = G__22183;
continue;
} else {
}
break;
}

var G__22130 = args22128.length;
switch (G__22130) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22128.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__21485__auto___22185 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___22185,tc,fc){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___22185,tc,fc){
return (function (state_22156){
var state_val_22157 = (state_22156[(1)]);
if((state_val_22157 === (7))){
var inst_22152 = (state_22156[(2)]);
var state_22156__$1 = state_22156;
var statearr_22158_22186 = state_22156__$1;
(statearr_22158_22186[(2)] = inst_22152);

(statearr_22158_22186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (1))){
var state_22156__$1 = state_22156;
var statearr_22159_22187 = state_22156__$1;
(statearr_22159_22187[(2)] = null);

(statearr_22159_22187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (4))){
var inst_22133 = (state_22156[(7)]);
var inst_22133__$1 = (state_22156[(2)]);
var inst_22134 = (inst_22133__$1 == null);
var state_22156__$1 = (function (){var statearr_22160 = state_22156;
(statearr_22160[(7)] = inst_22133__$1);

return statearr_22160;
})();
if(cljs.core.truth_(inst_22134)){
var statearr_22161_22188 = state_22156__$1;
(statearr_22161_22188[(1)] = (5));

} else {
var statearr_22162_22189 = state_22156__$1;
(statearr_22162_22189[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (13))){
var state_22156__$1 = state_22156;
var statearr_22163_22190 = state_22156__$1;
(statearr_22163_22190[(2)] = null);

(statearr_22163_22190[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (6))){
var inst_22133 = (state_22156[(7)]);
var inst_22139 = p.call(null,inst_22133);
var state_22156__$1 = state_22156;
if(cljs.core.truth_(inst_22139)){
var statearr_22164_22191 = state_22156__$1;
(statearr_22164_22191[(1)] = (9));

} else {
var statearr_22165_22192 = state_22156__$1;
(statearr_22165_22192[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (3))){
var inst_22154 = (state_22156[(2)]);
var state_22156__$1 = state_22156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22156__$1,inst_22154);
} else {
if((state_val_22157 === (12))){
var state_22156__$1 = state_22156;
var statearr_22166_22193 = state_22156__$1;
(statearr_22166_22193[(2)] = null);

(statearr_22166_22193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (2))){
var state_22156__$1 = state_22156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22156__$1,(4),ch);
} else {
if((state_val_22157 === (11))){
var inst_22133 = (state_22156[(7)]);
var inst_22143 = (state_22156[(2)]);
var state_22156__$1 = state_22156;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22156__$1,(8),inst_22143,inst_22133);
} else {
if((state_val_22157 === (9))){
var state_22156__$1 = state_22156;
var statearr_22167_22194 = state_22156__$1;
(statearr_22167_22194[(2)] = tc);

(statearr_22167_22194[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (5))){
var inst_22136 = cljs.core.async.close_BANG_.call(null,tc);
var inst_22137 = cljs.core.async.close_BANG_.call(null,fc);
var state_22156__$1 = (function (){var statearr_22168 = state_22156;
(statearr_22168[(8)] = inst_22136);

return statearr_22168;
})();
var statearr_22169_22195 = state_22156__$1;
(statearr_22169_22195[(2)] = inst_22137);

(statearr_22169_22195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (14))){
var inst_22150 = (state_22156[(2)]);
var state_22156__$1 = state_22156;
var statearr_22170_22196 = state_22156__$1;
(statearr_22170_22196[(2)] = inst_22150);

(statearr_22170_22196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (10))){
var state_22156__$1 = state_22156;
var statearr_22171_22197 = state_22156__$1;
(statearr_22171_22197[(2)] = fc);

(statearr_22171_22197[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22157 === (8))){
var inst_22145 = (state_22156[(2)]);
var state_22156__$1 = state_22156;
if(cljs.core.truth_(inst_22145)){
var statearr_22172_22198 = state_22156__$1;
(statearr_22172_22198[(1)] = (12));

} else {
var statearr_22173_22199 = state_22156__$1;
(statearr_22173_22199[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___22185,tc,fc))
;
return ((function (switch__21371__auto__,c__21485__auto___22185,tc,fc){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_22177 = [null,null,null,null,null,null,null,null,null];
(statearr_22177[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_22177[(1)] = (1));

return statearr_22177;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_22156){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_22156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e22178){if((e22178 instanceof Object)){
var ex__21375__auto__ = e22178;
var statearr_22179_22200 = state_22156;
(statearr_22179_22200[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22178;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22201 = state_22156;
state_22156 = G__22201;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_22156){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_22156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___22185,tc,fc))
})();
var state__21487__auto__ = (function (){var statearr_22180 = f__21486__auto__.call(null);
(statearr_22180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___22185);

return statearr_22180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___22185,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__21485__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto__){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto__){
return (function (state_22265){
var state_val_22266 = (state_22265[(1)]);
if((state_val_22266 === (7))){
var inst_22261 = (state_22265[(2)]);
var state_22265__$1 = state_22265;
var statearr_22267_22288 = state_22265__$1;
(statearr_22267_22288[(2)] = inst_22261);

(statearr_22267_22288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22266 === (1))){
var inst_22245 = init;
var state_22265__$1 = (function (){var statearr_22268 = state_22265;
(statearr_22268[(7)] = inst_22245);

return statearr_22268;
})();
var statearr_22269_22289 = state_22265__$1;
(statearr_22269_22289[(2)] = null);

(statearr_22269_22289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22266 === (4))){
var inst_22248 = (state_22265[(8)]);
var inst_22248__$1 = (state_22265[(2)]);
var inst_22249 = (inst_22248__$1 == null);
var state_22265__$1 = (function (){var statearr_22270 = state_22265;
(statearr_22270[(8)] = inst_22248__$1);

return statearr_22270;
})();
if(cljs.core.truth_(inst_22249)){
var statearr_22271_22290 = state_22265__$1;
(statearr_22271_22290[(1)] = (5));

} else {
var statearr_22272_22291 = state_22265__$1;
(statearr_22272_22291[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22266 === (6))){
var inst_22252 = (state_22265[(9)]);
var inst_22245 = (state_22265[(7)]);
var inst_22248 = (state_22265[(8)]);
var inst_22252__$1 = f.call(null,inst_22245,inst_22248);
var inst_22253 = cljs.core.reduced_QMARK_.call(null,inst_22252__$1);
var state_22265__$1 = (function (){var statearr_22273 = state_22265;
(statearr_22273[(9)] = inst_22252__$1);

return statearr_22273;
})();
if(inst_22253){
var statearr_22274_22292 = state_22265__$1;
(statearr_22274_22292[(1)] = (8));

} else {
var statearr_22275_22293 = state_22265__$1;
(statearr_22275_22293[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22266 === (3))){
var inst_22263 = (state_22265[(2)]);
var state_22265__$1 = state_22265;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22265__$1,inst_22263);
} else {
if((state_val_22266 === (2))){
var state_22265__$1 = state_22265;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22265__$1,(4),ch);
} else {
if((state_val_22266 === (9))){
var inst_22252 = (state_22265[(9)]);
var inst_22245 = inst_22252;
var state_22265__$1 = (function (){var statearr_22276 = state_22265;
(statearr_22276[(7)] = inst_22245);

return statearr_22276;
})();
var statearr_22277_22294 = state_22265__$1;
(statearr_22277_22294[(2)] = null);

(statearr_22277_22294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22266 === (5))){
var inst_22245 = (state_22265[(7)]);
var state_22265__$1 = state_22265;
var statearr_22278_22295 = state_22265__$1;
(statearr_22278_22295[(2)] = inst_22245);

(statearr_22278_22295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22266 === (10))){
var inst_22259 = (state_22265[(2)]);
var state_22265__$1 = state_22265;
var statearr_22279_22296 = state_22265__$1;
(statearr_22279_22296[(2)] = inst_22259);

(statearr_22279_22296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22266 === (8))){
var inst_22252 = (state_22265[(9)]);
var inst_22255 = cljs.core.deref.call(null,inst_22252);
var state_22265__$1 = state_22265;
var statearr_22280_22297 = state_22265__$1;
(statearr_22280_22297[(2)] = inst_22255);

(statearr_22280_22297[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto__))
;
return ((function (switch__21371__auto__,c__21485__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__21372__auto__ = null;
var cljs$core$async$reduce_$_state_machine__21372__auto____0 = (function (){
var statearr_22284 = [null,null,null,null,null,null,null,null,null,null];
(statearr_22284[(0)] = cljs$core$async$reduce_$_state_machine__21372__auto__);

(statearr_22284[(1)] = (1));

return statearr_22284;
});
var cljs$core$async$reduce_$_state_machine__21372__auto____1 = (function (state_22265){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_22265);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e22285){if((e22285 instanceof Object)){
var ex__21375__auto__ = e22285;
var statearr_22286_22298 = state_22265;
(statearr_22286_22298[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22265);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22285;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22299 = state_22265;
state_22265 = G__22299;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__21372__auto__ = function(state_22265){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__21372__auto____1.call(this,state_22265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__21372__auto____0;
cljs$core$async$reduce_$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__21372__auto____1;
return cljs$core$async$reduce_$_state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto__))
})();
var state__21487__auto__ = (function (){var statearr_22287 = f__21486__auto__.call(null);
(statearr_22287[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto__);

return statearr_22287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto__))
);

return c__21485__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args22300 = [];
var len__10601__auto___22352 = arguments.length;
var i__10602__auto___22353 = (0);
while(true){
if((i__10602__auto___22353 < len__10601__auto___22352)){
args22300.push((arguments[i__10602__auto___22353]));

var G__22354 = (i__10602__auto___22353 + (1));
i__10602__auto___22353 = G__22354;
continue;
} else {
}
break;
}

var G__22302 = args22300.length;
switch (G__22302) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22300.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__21485__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto__){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto__){
return (function (state_22327){
var state_val_22328 = (state_22327[(1)]);
if((state_val_22328 === (7))){
var inst_22309 = (state_22327[(2)]);
var state_22327__$1 = state_22327;
var statearr_22329_22356 = state_22327__$1;
(statearr_22329_22356[(2)] = inst_22309);

(statearr_22329_22356[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (1))){
var inst_22303 = cljs.core.seq.call(null,coll);
var inst_22304 = inst_22303;
var state_22327__$1 = (function (){var statearr_22330 = state_22327;
(statearr_22330[(7)] = inst_22304);

return statearr_22330;
})();
var statearr_22331_22357 = state_22327__$1;
(statearr_22331_22357[(2)] = null);

(statearr_22331_22357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (4))){
var inst_22304 = (state_22327[(7)]);
var inst_22307 = cljs.core.first.call(null,inst_22304);
var state_22327__$1 = state_22327;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22327__$1,(7),ch,inst_22307);
} else {
if((state_val_22328 === (13))){
var inst_22321 = (state_22327[(2)]);
var state_22327__$1 = state_22327;
var statearr_22332_22358 = state_22327__$1;
(statearr_22332_22358[(2)] = inst_22321);

(statearr_22332_22358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (6))){
var inst_22312 = (state_22327[(2)]);
var state_22327__$1 = state_22327;
if(cljs.core.truth_(inst_22312)){
var statearr_22333_22359 = state_22327__$1;
(statearr_22333_22359[(1)] = (8));

} else {
var statearr_22334_22360 = state_22327__$1;
(statearr_22334_22360[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (3))){
var inst_22325 = (state_22327[(2)]);
var state_22327__$1 = state_22327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22327__$1,inst_22325);
} else {
if((state_val_22328 === (12))){
var state_22327__$1 = state_22327;
var statearr_22335_22361 = state_22327__$1;
(statearr_22335_22361[(2)] = null);

(statearr_22335_22361[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (2))){
var inst_22304 = (state_22327[(7)]);
var state_22327__$1 = state_22327;
if(cljs.core.truth_(inst_22304)){
var statearr_22336_22362 = state_22327__$1;
(statearr_22336_22362[(1)] = (4));

} else {
var statearr_22337_22363 = state_22327__$1;
(statearr_22337_22363[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (11))){
var inst_22318 = cljs.core.async.close_BANG_.call(null,ch);
var state_22327__$1 = state_22327;
var statearr_22338_22364 = state_22327__$1;
(statearr_22338_22364[(2)] = inst_22318);

(statearr_22338_22364[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (9))){
var state_22327__$1 = state_22327;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22339_22365 = state_22327__$1;
(statearr_22339_22365[(1)] = (11));

} else {
var statearr_22340_22366 = state_22327__$1;
(statearr_22340_22366[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (5))){
var inst_22304 = (state_22327[(7)]);
var state_22327__$1 = state_22327;
var statearr_22341_22367 = state_22327__$1;
(statearr_22341_22367[(2)] = inst_22304);

(statearr_22341_22367[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (10))){
var inst_22323 = (state_22327[(2)]);
var state_22327__$1 = state_22327;
var statearr_22342_22368 = state_22327__$1;
(statearr_22342_22368[(2)] = inst_22323);

(statearr_22342_22368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22328 === (8))){
var inst_22304 = (state_22327[(7)]);
var inst_22314 = cljs.core.next.call(null,inst_22304);
var inst_22304__$1 = inst_22314;
var state_22327__$1 = (function (){var statearr_22343 = state_22327;
(statearr_22343[(7)] = inst_22304__$1);

return statearr_22343;
})();
var statearr_22344_22369 = state_22327__$1;
(statearr_22344_22369[(2)] = null);

(statearr_22344_22369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto__))
;
return ((function (switch__21371__auto__,c__21485__auto__){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_22348 = [null,null,null,null,null,null,null,null];
(statearr_22348[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_22348[(1)] = (1));

return statearr_22348;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_22327){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_22327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e22349){if((e22349 instanceof Object)){
var ex__21375__auto__ = e22349;
var statearr_22350_22370 = state_22327;
(statearr_22350_22370[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22371 = state_22327;
state_22327 = G__22371;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_22327){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_22327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto__))
})();
var state__21487__auto__ = (function (){var statearr_22351 = f__21486__auto__.call(null);
(statearr_22351[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto__);

return statearr_22351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto__))
);

return c__21485__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__10098__auto__ = (((_ == null))?null:_);
var m__10099__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,_);
} else {
var m__10099__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__10099__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m,ch);
} else {
var m__10099__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m);
} else {
var m__10099__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async22597 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22597 = (function (ch,cs,meta22598){
this.ch = ch;
this.cs = cs;
this.meta22598 = meta22598;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_22599,meta22598__$1){
var self__ = this;
var _22599__$1 = this;
return (new cljs.core.async.t_cljs$core$async22597(self__.ch,self__.cs,meta22598__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_22599){
var self__ = this;
var _22599__$1 = this;
return self__.meta22598;
});})(cs))
;

cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async22597.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async22597.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta22598","meta22598",1521213786,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async22597.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22597.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22597";

cljs.core.async.t_cljs$core$async22597.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async22597");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async22597 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async22597(ch__$1,cs__$1,meta22598){
return (new cljs.core.async.t_cljs$core$async22597(ch__$1,cs__$1,meta22598));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async22597(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__21485__auto___22822 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___22822,cs,m,dchan,dctr,done){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___22822,cs,m,dchan,dctr,done){
return (function (state_22734){
var state_val_22735 = (state_22734[(1)]);
if((state_val_22735 === (7))){
var inst_22730 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22736_22823 = state_22734__$1;
(statearr_22736_22823[(2)] = inst_22730);

(statearr_22736_22823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (20))){
var inst_22633 = (state_22734[(7)]);
var inst_22645 = cljs.core.first.call(null,inst_22633);
var inst_22646 = cljs.core.nth.call(null,inst_22645,(0),null);
var inst_22647 = cljs.core.nth.call(null,inst_22645,(1),null);
var state_22734__$1 = (function (){var statearr_22737 = state_22734;
(statearr_22737[(8)] = inst_22646);

return statearr_22737;
})();
if(cljs.core.truth_(inst_22647)){
var statearr_22738_22824 = state_22734__$1;
(statearr_22738_22824[(1)] = (22));

} else {
var statearr_22739_22825 = state_22734__$1;
(statearr_22739_22825[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (27))){
var inst_22602 = (state_22734[(9)]);
var inst_22682 = (state_22734[(10)]);
var inst_22675 = (state_22734[(11)]);
var inst_22677 = (state_22734[(12)]);
var inst_22682__$1 = cljs.core._nth.call(null,inst_22675,inst_22677);
var inst_22683 = cljs.core.async.put_BANG_.call(null,inst_22682__$1,inst_22602,done);
var state_22734__$1 = (function (){var statearr_22740 = state_22734;
(statearr_22740[(10)] = inst_22682__$1);

return statearr_22740;
})();
if(cljs.core.truth_(inst_22683)){
var statearr_22741_22826 = state_22734__$1;
(statearr_22741_22826[(1)] = (30));

} else {
var statearr_22742_22827 = state_22734__$1;
(statearr_22742_22827[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (1))){
var state_22734__$1 = state_22734;
var statearr_22743_22828 = state_22734__$1;
(statearr_22743_22828[(2)] = null);

(statearr_22743_22828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (24))){
var inst_22633 = (state_22734[(7)]);
var inst_22652 = (state_22734[(2)]);
var inst_22653 = cljs.core.next.call(null,inst_22633);
var inst_22611 = inst_22653;
var inst_22612 = null;
var inst_22613 = (0);
var inst_22614 = (0);
var state_22734__$1 = (function (){var statearr_22744 = state_22734;
(statearr_22744[(13)] = inst_22611);

(statearr_22744[(14)] = inst_22612);

(statearr_22744[(15)] = inst_22652);

(statearr_22744[(16)] = inst_22613);

(statearr_22744[(17)] = inst_22614);

return statearr_22744;
})();
var statearr_22745_22829 = state_22734__$1;
(statearr_22745_22829[(2)] = null);

(statearr_22745_22829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (39))){
var state_22734__$1 = state_22734;
var statearr_22749_22830 = state_22734__$1;
(statearr_22749_22830[(2)] = null);

(statearr_22749_22830[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (4))){
var inst_22602 = (state_22734[(9)]);
var inst_22602__$1 = (state_22734[(2)]);
var inst_22603 = (inst_22602__$1 == null);
var state_22734__$1 = (function (){var statearr_22750 = state_22734;
(statearr_22750[(9)] = inst_22602__$1);

return statearr_22750;
})();
if(cljs.core.truth_(inst_22603)){
var statearr_22751_22831 = state_22734__$1;
(statearr_22751_22831[(1)] = (5));

} else {
var statearr_22752_22832 = state_22734__$1;
(statearr_22752_22832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (15))){
var inst_22611 = (state_22734[(13)]);
var inst_22612 = (state_22734[(14)]);
var inst_22613 = (state_22734[(16)]);
var inst_22614 = (state_22734[(17)]);
var inst_22629 = (state_22734[(2)]);
var inst_22630 = (inst_22614 + (1));
var tmp22746 = inst_22611;
var tmp22747 = inst_22612;
var tmp22748 = inst_22613;
var inst_22611__$1 = tmp22746;
var inst_22612__$1 = tmp22747;
var inst_22613__$1 = tmp22748;
var inst_22614__$1 = inst_22630;
var state_22734__$1 = (function (){var statearr_22753 = state_22734;
(statearr_22753[(18)] = inst_22629);

(statearr_22753[(13)] = inst_22611__$1);

(statearr_22753[(14)] = inst_22612__$1);

(statearr_22753[(16)] = inst_22613__$1);

(statearr_22753[(17)] = inst_22614__$1);

return statearr_22753;
})();
var statearr_22754_22833 = state_22734__$1;
(statearr_22754_22833[(2)] = null);

(statearr_22754_22833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (21))){
var inst_22656 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22758_22834 = state_22734__$1;
(statearr_22758_22834[(2)] = inst_22656);

(statearr_22758_22834[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (31))){
var inst_22682 = (state_22734[(10)]);
var inst_22686 = done.call(null,null);
var inst_22687 = cljs.core.async.untap_STAR_.call(null,m,inst_22682);
var state_22734__$1 = (function (){var statearr_22759 = state_22734;
(statearr_22759[(19)] = inst_22686);

return statearr_22759;
})();
var statearr_22760_22835 = state_22734__$1;
(statearr_22760_22835[(2)] = inst_22687);

(statearr_22760_22835[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (32))){
var inst_22674 = (state_22734[(20)]);
var inst_22675 = (state_22734[(11)]);
var inst_22676 = (state_22734[(21)]);
var inst_22677 = (state_22734[(12)]);
var inst_22689 = (state_22734[(2)]);
var inst_22690 = (inst_22677 + (1));
var tmp22755 = inst_22674;
var tmp22756 = inst_22675;
var tmp22757 = inst_22676;
var inst_22674__$1 = tmp22755;
var inst_22675__$1 = tmp22756;
var inst_22676__$1 = tmp22757;
var inst_22677__$1 = inst_22690;
var state_22734__$1 = (function (){var statearr_22761 = state_22734;
(statearr_22761[(22)] = inst_22689);

(statearr_22761[(20)] = inst_22674__$1);

(statearr_22761[(11)] = inst_22675__$1);

(statearr_22761[(21)] = inst_22676__$1);

(statearr_22761[(12)] = inst_22677__$1);

return statearr_22761;
})();
var statearr_22762_22836 = state_22734__$1;
(statearr_22762_22836[(2)] = null);

(statearr_22762_22836[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (40))){
var inst_22702 = (state_22734[(23)]);
var inst_22706 = done.call(null,null);
var inst_22707 = cljs.core.async.untap_STAR_.call(null,m,inst_22702);
var state_22734__$1 = (function (){var statearr_22763 = state_22734;
(statearr_22763[(24)] = inst_22706);

return statearr_22763;
})();
var statearr_22764_22837 = state_22734__$1;
(statearr_22764_22837[(2)] = inst_22707);

(statearr_22764_22837[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (33))){
var inst_22693 = (state_22734[(25)]);
var inst_22695 = cljs.core.chunked_seq_QMARK_.call(null,inst_22693);
var state_22734__$1 = state_22734;
if(inst_22695){
var statearr_22765_22838 = state_22734__$1;
(statearr_22765_22838[(1)] = (36));

} else {
var statearr_22766_22839 = state_22734__$1;
(statearr_22766_22839[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (13))){
var inst_22623 = (state_22734[(26)]);
var inst_22626 = cljs.core.async.close_BANG_.call(null,inst_22623);
var state_22734__$1 = state_22734;
var statearr_22767_22840 = state_22734__$1;
(statearr_22767_22840[(2)] = inst_22626);

(statearr_22767_22840[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (22))){
var inst_22646 = (state_22734[(8)]);
var inst_22649 = cljs.core.async.close_BANG_.call(null,inst_22646);
var state_22734__$1 = state_22734;
var statearr_22768_22841 = state_22734__$1;
(statearr_22768_22841[(2)] = inst_22649);

(statearr_22768_22841[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (36))){
var inst_22693 = (state_22734[(25)]);
var inst_22697 = cljs.core.chunk_first.call(null,inst_22693);
var inst_22698 = cljs.core.chunk_rest.call(null,inst_22693);
var inst_22699 = cljs.core.count.call(null,inst_22697);
var inst_22674 = inst_22698;
var inst_22675 = inst_22697;
var inst_22676 = inst_22699;
var inst_22677 = (0);
var state_22734__$1 = (function (){var statearr_22769 = state_22734;
(statearr_22769[(20)] = inst_22674);

(statearr_22769[(11)] = inst_22675);

(statearr_22769[(21)] = inst_22676);

(statearr_22769[(12)] = inst_22677);

return statearr_22769;
})();
var statearr_22770_22842 = state_22734__$1;
(statearr_22770_22842[(2)] = null);

(statearr_22770_22842[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (41))){
var inst_22693 = (state_22734[(25)]);
var inst_22709 = (state_22734[(2)]);
var inst_22710 = cljs.core.next.call(null,inst_22693);
var inst_22674 = inst_22710;
var inst_22675 = null;
var inst_22676 = (0);
var inst_22677 = (0);
var state_22734__$1 = (function (){var statearr_22771 = state_22734;
(statearr_22771[(27)] = inst_22709);

(statearr_22771[(20)] = inst_22674);

(statearr_22771[(11)] = inst_22675);

(statearr_22771[(21)] = inst_22676);

(statearr_22771[(12)] = inst_22677);

return statearr_22771;
})();
var statearr_22772_22843 = state_22734__$1;
(statearr_22772_22843[(2)] = null);

(statearr_22772_22843[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (43))){
var state_22734__$1 = state_22734;
var statearr_22773_22844 = state_22734__$1;
(statearr_22773_22844[(2)] = null);

(statearr_22773_22844[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (29))){
var inst_22718 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22774_22845 = state_22734__$1;
(statearr_22774_22845[(2)] = inst_22718);

(statearr_22774_22845[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (44))){
var inst_22727 = (state_22734[(2)]);
var state_22734__$1 = (function (){var statearr_22775 = state_22734;
(statearr_22775[(28)] = inst_22727);

return statearr_22775;
})();
var statearr_22776_22846 = state_22734__$1;
(statearr_22776_22846[(2)] = null);

(statearr_22776_22846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (6))){
var inst_22666 = (state_22734[(29)]);
var inst_22665 = cljs.core.deref.call(null,cs);
var inst_22666__$1 = cljs.core.keys.call(null,inst_22665);
var inst_22667 = cljs.core.count.call(null,inst_22666__$1);
var inst_22668 = cljs.core.reset_BANG_.call(null,dctr,inst_22667);
var inst_22673 = cljs.core.seq.call(null,inst_22666__$1);
var inst_22674 = inst_22673;
var inst_22675 = null;
var inst_22676 = (0);
var inst_22677 = (0);
var state_22734__$1 = (function (){var statearr_22777 = state_22734;
(statearr_22777[(30)] = inst_22668);

(statearr_22777[(20)] = inst_22674);

(statearr_22777[(11)] = inst_22675);

(statearr_22777[(21)] = inst_22676);

(statearr_22777[(29)] = inst_22666__$1);

(statearr_22777[(12)] = inst_22677);

return statearr_22777;
})();
var statearr_22778_22847 = state_22734__$1;
(statearr_22778_22847[(2)] = null);

(statearr_22778_22847[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (28))){
var inst_22674 = (state_22734[(20)]);
var inst_22693 = (state_22734[(25)]);
var inst_22693__$1 = cljs.core.seq.call(null,inst_22674);
var state_22734__$1 = (function (){var statearr_22779 = state_22734;
(statearr_22779[(25)] = inst_22693__$1);

return statearr_22779;
})();
if(inst_22693__$1){
var statearr_22780_22848 = state_22734__$1;
(statearr_22780_22848[(1)] = (33));

} else {
var statearr_22781_22849 = state_22734__$1;
(statearr_22781_22849[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (25))){
var inst_22676 = (state_22734[(21)]);
var inst_22677 = (state_22734[(12)]);
var inst_22679 = (inst_22677 < inst_22676);
var inst_22680 = inst_22679;
var state_22734__$1 = state_22734;
if(cljs.core.truth_(inst_22680)){
var statearr_22782_22850 = state_22734__$1;
(statearr_22782_22850[(1)] = (27));

} else {
var statearr_22783_22851 = state_22734__$1;
(statearr_22783_22851[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (34))){
var state_22734__$1 = state_22734;
var statearr_22784_22852 = state_22734__$1;
(statearr_22784_22852[(2)] = null);

(statearr_22784_22852[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (17))){
var state_22734__$1 = state_22734;
var statearr_22785_22853 = state_22734__$1;
(statearr_22785_22853[(2)] = null);

(statearr_22785_22853[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (3))){
var inst_22732 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22734__$1,inst_22732);
} else {
if((state_val_22735 === (12))){
var inst_22661 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22786_22854 = state_22734__$1;
(statearr_22786_22854[(2)] = inst_22661);

(statearr_22786_22854[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (2))){
var state_22734__$1 = state_22734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22734__$1,(4),ch);
} else {
if((state_val_22735 === (23))){
var state_22734__$1 = state_22734;
var statearr_22787_22855 = state_22734__$1;
(statearr_22787_22855[(2)] = null);

(statearr_22787_22855[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (35))){
var inst_22716 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22788_22856 = state_22734__$1;
(statearr_22788_22856[(2)] = inst_22716);

(statearr_22788_22856[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (19))){
var inst_22633 = (state_22734[(7)]);
var inst_22637 = cljs.core.chunk_first.call(null,inst_22633);
var inst_22638 = cljs.core.chunk_rest.call(null,inst_22633);
var inst_22639 = cljs.core.count.call(null,inst_22637);
var inst_22611 = inst_22638;
var inst_22612 = inst_22637;
var inst_22613 = inst_22639;
var inst_22614 = (0);
var state_22734__$1 = (function (){var statearr_22789 = state_22734;
(statearr_22789[(13)] = inst_22611);

(statearr_22789[(14)] = inst_22612);

(statearr_22789[(16)] = inst_22613);

(statearr_22789[(17)] = inst_22614);

return statearr_22789;
})();
var statearr_22790_22857 = state_22734__$1;
(statearr_22790_22857[(2)] = null);

(statearr_22790_22857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (11))){
var inst_22611 = (state_22734[(13)]);
var inst_22633 = (state_22734[(7)]);
var inst_22633__$1 = cljs.core.seq.call(null,inst_22611);
var state_22734__$1 = (function (){var statearr_22791 = state_22734;
(statearr_22791[(7)] = inst_22633__$1);

return statearr_22791;
})();
if(inst_22633__$1){
var statearr_22792_22858 = state_22734__$1;
(statearr_22792_22858[(1)] = (16));

} else {
var statearr_22793_22859 = state_22734__$1;
(statearr_22793_22859[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (9))){
var inst_22663 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22794_22860 = state_22734__$1;
(statearr_22794_22860[(2)] = inst_22663);

(statearr_22794_22860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (5))){
var inst_22609 = cljs.core.deref.call(null,cs);
var inst_22610 = cljs.core.seq.call(null,inst_22609);
var inst_22611 = inst_22610;
var inst_22612 = null;
var inst_22613 = (0);
var inst_22614 = (0);
var state_22734__$1 = (function (){var statearr_22795 = state_22734;
(statearr_22795[(13)] = inst_22611);

(statearr_22795[(14)] = inst_22612);

(statearr_22795[(16)] = inst_22613);

(statearr_22795[(17)] = inst_22614);

return statearr_22795;
})();
var statearr_22796_22861 = state_22734__$1;
(statearr_22796_22861[(2)] = null);

(statearr_22796_22861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (14))){
var state_22734__$1 = state_22734;
var statearr_22797_22862 = state_22734__$1;
(statearr_22797_22862[(2)] = null);

(statearr_22797_22862[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (45))){
var inst_22724 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22798_22863 = state_22734__$1;
(statearr_22798_22863[(2)] = inst_22724);

(statearr_22798_22863[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (26))){
var inst_22666 = (state_22734[(29)]);
var inst_22720 = (state_22734[(2)]);
var inst_22721 = cljs.core.seq.call(null,inst_22666);
var state_22734__$1 = (function (){var statearr_22799 = state_22734;
(statearr_22799[(31)] = inst_22720);

return statearr_22799;
})();
if(inst_22721){
var statearr_22800_22864 = state_22734__$1;
(statearr_22800_22864[(1)] = (42));

} else {
var statearr_22801_22865 = state_22734__$1;
(statearr_22801_22865[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (16))){
var inst_22633 = (state_22734[(7)]);
var inst_22635 = cljs.core.chunked_seq_QMARK_.call(null,inst_22633);
var state_22734__$1 = state_22734;
if(inst_22635){
var statearr_22802_22866 = state_22734__$1;
(statearr_22802_22866[(1)] = (19));

} else {
var statearr_22803_22867 = state_22734__$1;
(statearr_22803_22867[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (38))){
var inst_22713 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22804_22868 = state_22734__$1;
(statearr_22804_22868[(2)] = inst_22713);

(statearr_22804_22868[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (30))){
var state_22734__$1 = state_22734;
var statearr_22805_22869 = state_22734__$1;
(statearr_22805_22869[(2)] = null);

(statearr_22805_22869[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (10))){
var inst_22612 = (state_22734[(14)]);
var inst_22614 = (state_22734[(17)]);
var inst_22622 = cljs.core._nth.call(null,inst_22612,inst_22614);
var inst_22623 = cljs.core.nth.call(null,inst_22622,(0),null);
var inst_22624 = cljs.core.nth.call(null,inst_22622,(1),null);
var state_22734__$1 = (function (){var statearr_22806 = state_22734;
(statearr_22806[(26)] = inst_22623);

return statearr_22806;
})();
if(cljs.core.truth_(inst_22624)){
var statearr_22807_22870 = state_22734__$1;
(statearr_22807_22870[(1)] = (13));

} else {
var statearr_22808_22871 = state_22734__$1;
(statearr_22808_22871[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (18))){
var inst_22659 = (state_22734[(2)]);
var state_22734__$1 = state_22734;
var statearr_22809_22872 = state_22734__$1;
(statearr_22809_22872[(2)] = inst_22659);

(statearr_22809_22872[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (42))){
var state_22734__$1 = state_22734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22734__$1,(45),dchan);
} else {
if((state_val_22735 === (37))){
var inst_22602 = (state_22734[(9)]);
var inst_22702 = (state_22734[(23)]);
var inst_22693 = (state_22734[(25)]);
var inst_22702__$1 = cljs.core.first.call(null,inst_22693);
var inst_22703 = cljs.core.async.put_BANG_.call(null,inst_22702__$1,inst_22602,done);
var state_22734__$1 = (function (){var statearr_22810 = state_22734;
(statearr_22810[(23)] = inst_22702__$1);

return statearr_22810;
})();
if(cljs.core.truth_(inst_22703)){
var statearr_22811_22873 = state_22734__$1;
(statearr_22811_22873[(1)] = (39));

} else {
var statearr_22812_22874 = state_22734__$1;
(statearr_22812_22874[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22735 === (8))){
var inst_22613 = (state_22734[(16)]);
var inst_22614 = (state_22734[(17)]);
var inst_22616 = (inst_22614 < inst_22613);
var inst_22617 = inst_22616;
var state_22734__$1 = state_22734;
if(cljs.core.truth_(inst_22617)){
var statearr_22813_22875 = state_22734__$1;
(statearr_22813_22875[(1)] = (10));

} else {
var statearr_22814_22876 = state_22734__$1;
(statearr_22814_22876[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___22822,cs,m,dchan,dctr,done))
;
return ((function (switch__21371__auto__,c__21485__auto___22822,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__21372__auto__ = null;
var cljs$core$async$mult_$_state_machine__21372__auto____0 = (function (){
var statearr_22818 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22818[(0)] = cljs$core$async$mult_$_state_machine__21372__auto__);

(statearr_22818[(1)] = (1));

return statearr_22818;
});
var cljs$core$async$mult_$_state_machine__21372__auto____1 = (function (state_22734){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_22734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e22819){if((e22819 instanceof Object)){
var ex__21375__auto__ = e22819;
var statearr_22820_22877 = state_22734;
(statearr_22820_22877[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22819;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22878 = state_22734;
state_22734 = G__22878;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__21372__auto__ = function(state_22734){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__21372__auto____1.call(this,state_22734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__21372__auto____0;
cljs$core$async$mult_$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__21372__auto____1;
return cljs$core$async$mult_$_state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___22822,cs,m,dchan,dctr,done))
})();
var state__21487__auto__ = (function (){var statearr_22821 = f__21486__auto__.call(null);
(statearr_22821[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___22822);

return statearr_22821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___22822,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args22879 = [];
var len__10601__auto___22882 = arguments.length;
var i__10602__auto___22883 = (0);
while(true){
if((i__10602__auto___22883 < len__10601__auto___22882)){
args22879.push((arguments[i__10602__auto___22883]));

var G__22884 = (i__10602__auto___22883 + (1));
i__10602__auto___22883 = G__22884;
continue;
} else {
}
break;
}

var G__22881 = args22879.length;
switch (G__22881) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22879.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m,ch);
} else {
var m__10099__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m,ch);
} else {
var m__10099__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m);
} else {
var m__10099__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m,state_map);
} else {
var m__10099__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__10098__auto__ = (((m == null))?null:m);
var m__10099__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,m,mode);
} else {
var m__10099__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10608__auto__ = [];
var len__10601__auto___22896 = arguments.length;
var i__10602__auto___22897 = (0);
while(true){
if((i__10602__auto___22897 < len__10601__auto___22896)){
args__10608__auto__.push((arguments[i__10602__auto___22897]));

var G__22898 = (i__10602__auto___22897 + (1));
i__10602__auto___22897 = G__22898;
continue;
} else {
}
break;
}

var argseq__10609__auto__ = ((((3) < args__10608__auto__.length))?(new cljs.core.IndexedSeq(args__10608__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10609__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__22890){
var map__22891 = p__22890;
var map__22891__$1 = ((((!((map__22891 == null)))?((((map__22891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22891.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22891):map__22891);
var opts = map__22891__$1;
var statearr_22893_22899 = state;
(statearr_22893_22899[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__22891,map__22891__$1,opts){
return (function (val){
var statearr_22894_22900 = state;
(statearr_22894_22900[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__22891,map__22891__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_22895_22901 = state;
(statearr_22895_22901[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq22886){
var G__22887 = cljs.core.first.call(null,seq22886);
var seq22886__$1 = cljs.core.next.call(null,seq22886);
var G__22888 = cljs.core.first.call(null,seq22886__$1);
var seq22886__$2 = cljs.core.next.call(null,seq22886__$1);
var G__22889 = cljs.core.first.call(null,seq22886__$2);
var seq22886__$3 = cljs.core.next.call(null,seq22886__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22887,G__22888,G__22889,seq22886__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async23069 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23069 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta23070){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta23070 = meta23070;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_23071,meta23070__$1){
var self__ = this;
var _23071__$1 = this;
return (new cljs.core.async.t_cljs$core$async23069(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta23070__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_23071){
var self__ = this;
var _23071__$1 = this;
return self__.meta23070;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta23070","meta23070",-1471885793,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23069.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23069.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23069";

cljs.core.async.t_cljs$core$async23069.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async23069");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async23069 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async23069(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta23070){
return (new cljs.core.async.t_cljs$core$async23069(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta23070));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async23069(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__21485__auto___23236 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___23236,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___23236,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_23173){
var state_val_23174 = (state_23173[(1)]);
if((state_val_23174 === (7))){
var inst_23088 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23175_23237 = state_23173__$1;
(statearr_23175_23237[(2)] = inst_23088);

(statearr_23175_23237[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (20))){
var inst_23100 = (state_23173[(7)]);
var state_23173__$1 = state_23173;
var statearr_23176_23238 = state_23173__$1;
(statearr_23176_23238[(2)] = inst_23100);

(statearr_23176_23238[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (27))){
var state_23173__$1 = state_23173;
var statearr_23177_23239 = state_23173__$1;
(statearr_23177_23239[(2)] = null);

(statearr_23177_23239[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (1))){
var inst_23075 = (state_23173[(8)]);
var inst_23075__$1 = calc_state.call(null);
var inst_23077 = (inst_23075__$1 == null);
var inst_23078 = cljs.core.not.call(null,inst_23077);
var state_23173__$1 = (function (){var statearr_23178 = state_23173;
(statearr_23178[(8)] = inst_23075__$1);

return statearr_23178;
})();
if(inst_23078){
var statearr_23179_23240 = state_23173__$1;
(statearr_23179_23240[(1)] = (2));

} else {
var statearr_23180_23241 = state_23173__$1;
(statearr_23180_23241[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (24))){
var inst_23124 = (state_23173[(9)]);
var inst_23133 = (state_23173[(10)]);
var inst_23147 = (state_23173[(11)]);
var inst_23147__$1 = inst_23124.call(null,inst_23133);
var state_23173__$1 = (function (){var statearr_23181 = state_23173;
(statearr_23181[(11)] = inst_23147__$1);

return statearr_23181;
})();
if(cljs.core.truth_(inst_23147__$1)){
var statearr_23182_23242 = state_23173__$1;
(statearr_23182_23242[(1)] = (29));

} else {
var statearr_23183_23243 = state_23173__$1;
(statearr_23183_23243[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (4))){
var inst_23091 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23091)){
var statearr_23184_23244 = state_23173__$1;
(statearr_23184_23244[(1)] = (8));

} else {
var statearr_23185_23245 = state_23173__$1;
(statearr_23185_23245[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (15))){
var inst_23118 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23118)){
var statearr_23186_23246 = state_23173__$1;
(statearr_23186_23246[(1)] = (19));

} else {
var statearr_23187_23247 = state_23173__$1;
(statearr_23187_23247[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (21))){
var inst_23123 = (state_23173[(12)]);
var inst_23123__$1 = (state_23173[(2)]);
var inst_23124 = cljs.core.get.call(null,inst_23123__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_23125 = cljs.core.get.call(null,inst_23123__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_23126 = cljs.core.get.call(null,inst_23123__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_23173__$1 = (function (){var statearr_23188 = state_23173;
(statearr_23188[(9)] = inst_23124);

(statearr_23188[(13)] = inst_23125);

(statearr_23188[(12)] = inst_23123__$1);

return statearr_23188;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_23173__$1,(22),inst_23126);
} else {
if((state_val_23174 === (31))){
var inst_23155 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23155)){
var statearr_23189_23248 = state_23173__$1;
(statearr_23189_23248[(1)] = (32));

} else {
var statearr_23190_23249 = state_23173__$1;
(statearr_23190_23249[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (32))){
var inst_23132 = (state_23173[(14)]);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23173__$1,(35),out,inst_23132);
} else {
if((state_val_23174 === (33))){
var inst_23123 = (state_23173[(12)]);
var inst_23100 = inst_23123;
var state_23173__$1 = (function (){var statearr_23191 = state_23173;
(statearr_23191[(7)] = inst_23100);

return statearr_23191;
})();
var statearr_23192_23250 = state_23173__$1;
(statearr_23192_23250[(2)] = null);

(statearr_23192_23250[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (13))){
var inst_23100 = (state_23173[(7)]);
var inst_23107 = inst_23100.cljs$lang$protocol_mask$partition0$;
var inst_23108 = (inst_23107 & (64));
var inst_23109 = inst_23100.cljs$core$ISeq$;
var inst_23110 = (cljs.core.PROTOCOL_SENTINEL === inst_23109);
var inst_23111 = (inst_23108) || (inst_23110);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23111)){
var statearr_23193_23251 = state_23173__$1;
(statearr_23193_23251[(1)] = (16));

} else {
var statearr_23194_23252 = state_23173__$1;
(statearr_23194_23252[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (22))){
var inst_23133 = (state_23173[(10)]);
var inst_23132 = (state_23173[(14)]);
var inst_23131 = (state_23173[(2)]);
var inst_23132__$1 = cljs.core.nth.call(null,inst_23131,(0),null);
var inst_23133__$1 = cljs.core.nth.call(null,inst_23131,(1),null);
var inst_23134 = (inst_23132__$1 == null);
var inst_23135 = cljs.core._EQ_.call(null,inst_23133__$1,change);
var inst_23136 = (inst_23134) || (inst_23135);
var state_23173__$1 = (function (){var statearr_23195 = state_23173;
(statearr_23195[(10)] = inst_23133__$1);

(statearr_23195[(14)] = inst_23132__$1);

return statearr_23195;
})();
if(cljs.core.truth_(inst_23136)){
var statearr_23196_23253 = state_23173__$1;
(statearr_23196_23253[(1)] = (23));

} else {
var statearr_23197_23254 = state_23173__$1;
(statearr_23197_23254[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (36))){
var inst_23123 = (state_23173[(12)]);
var inst_23100 = inst_23123;
var state_23173__$1 = (function (){var statearr_23198 = state_23173;
(statearr_23198[(7)] = inst_23100);

return statearr_23198;
})();
var statearr_23199_23255 = state_23173__$1;
(statearr_23199_23255[(2)] = null);

(statearr_23199_23255[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (29))){
var inst_23147 = (state_23173[(11)]);
var state_23173__$1 = state_23173;
var statearr_23200_23256 = state_23173__$1;
(statearr_23200_23256[(2)] = inst_23147);

(statearr_23200_23256[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (6))){
var state_23173__$1 = state_23173;
var statearr_23201_23257 = state_23173__$1;
(statearr_23201_23257[(2)] = false);

(statearr_23201_23257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (28))){
var inst_23143 = (state_23173[(2)]);
var inst_23144 = calc_state.call(null);
var inst_23100 = inst_23144;
var state_23173__$1 = (function (){var statearr_23202 = state_23173;
(statearr_23202[(7)] = inst_23100);

(statearr_23202[(15)] = inst_23143);

return statearr_23202;
})();
var statearr_23203_23258 = state_23173__$1;
(statearr_23203_23258[(2)] = null);

(statearr_23203_23258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (25))){
var inst_23169 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23204_23259 = state_23173__$1;
(statearr_23204_23259[(2)] = inst_23169);

(statearr_23204_23259[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (34))){
var inst_23167 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23205_23260 = state_23173__$1;
(statearr_23205_23260[(2)] = inst_23167);

(statearr_23205_23260[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (17))){
var state_23173__$1 = state_23173;
var statearr_23206_23261 = state_23173__$1;
(statearr_23206_23261[(2)] = false);

(statearr_23206_23261[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (3))){
var state_23173__$1 = state_23173;
var statearr_23207_23262 = state_23173__$1;
(statearr_23207_23262[(2)] = false);

(statearr_23207_23262[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (12))){
var inst_23171 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23173__$1,inst_23171);
} else {
if((state_val_23174 === (2))){
var inst_23075 = (state_23173[(8)]);
var inst_23080 = inst_23075.cljs$lang$protocol_mask$partition0$;
var inst_23081 = (inst_23080 & (64));
var inst_23082 = inst_23075.cljs$core$ISeq$;
var inst_23083 = (cljs.core.PROTOCOL_SENTINEL === inst_23082);
var inst_23084 = (inst_23081) || (inst_23083);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23084)){
var statearr_23208_23263 = state_23173__$1;
(statearr_23208_23263[(1)] = (5));

} else {
var statearr_23209_23264 = state_23173__$1;
(statearr_23209_23264[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (23))){
var inst_23132 = (state_23173[(14)]);
var inst_23138 = (inst_23132 == null);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23138)){
var statearr_23210_23265 = state_23173__$1;
(statearr_23210_23265[(1)] = (26));

} else {
var statearr_23211_23266 = state_23173__$1;
(statearr_23211_23266[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (35))){
var inst_23158 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23158)){
var statearr_23212_23267 = state_23173__$1;
(statearr_23212_23267[(1)] = (36));

} else {
var statearr_23213_23268 = state_23173__$1;
(statearr_23213_23268[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (19))){
var inst_23100 = (state_23173[(7)]);
var inst_23120 = cljs.core.apply.call(null,cljs.core.hash_map,inst_23100);
var state_23173__$1 = state_23173;
var statearr_23214_23269 = state_23173__$1;
(statearr_23214_23269[(2)] = inst_23120);

(statearr_23214_23269[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (11))){
var inst_23100 = (state_23173[(7)]);
var inst_23104 = (inst_23100 == null);
var inst_23105 = cljs.core.not.call(null,inst_23104);
var state_23173__$1 = state_23173;
if(inst_23105){
var statearr_23215_23270 = state_23173__$1;
(statearr_23215_23270[(1)] = (13));

} else {
var statearr_23216_23271 = state_23173__$1;
(statearr_23216_23271[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (9))){
var inst_23075 = (state_23173[(8)]);
var state_23173__$1 = state_23173;
var statearr_23217_23272 = state_23173__$1;
(statearr_23217_23272[(2)] = inst_23075);

(statearr_23217_23272[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (5))){
var state_23173__$1 = state_23173;
var statearr_23218_23273 = state_23173__$1;
(statearr_23218_23273[(2)] = true);

(statearr_23218_23273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (14))){
var state_23173__$1 = state_23173;
var statearr_23219_23274 = state_23173__$1;
(statearr_23219_23274[(2)] = false);

(statearr_23219_23274[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (26))){
var inst_23133 = (state_23173[(10)]);
var inst_23140 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_23133);
var state_23173__$1 = state_23173;
var statearr_23220_23275 = state_23173__$1;
(statearr_23220_23275[(2)] = inst_23140);

(statearr_23220_23275[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (16))){
var state_23173__$1 = state_23173;
var statearr_23221_23276 = state_23173__$1;
(statearr_23221_23276[(2)] = true);

(statearr_23221_23276[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (38))){
var inst_23163 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23222_23277 = state_23173__$1;
(statearr_23222_23277[(2)] = inst_23163);

(statearr_23222_23277[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (30))){
var inst_23124 = (state_23173[(9)]);
var inst_23125 = (state_23173[(13)]);
var inst_23133 = (state_23173[(10)]);
var inst_23150 = cljs.core.empty_QMARK_.call(null,inst_23124);
var inst_23151 = inst_23125.call(null,inst_23133);
var inst_23152 = cljs.core.not.call(null,inst_23151);
var inst_23153 = (inst_23150) && (inst_23152);
var state_23173__$1 = state_23173;
var statearr_23223_23278 = state_23173__$1;
(statearr_23223_23278[(2)] = inst_23153);

(statearr_23223_23278[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (10))){
var inst_23075 = (state_23173[(8)]);
var inst_23096 = (state_23173[(2)]);
var inst_23097 = cljs.core.get.call(null,inst_23096,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_23098 = cljs.core.get.call(null,inst_23096,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_23099 = cljs.core.get.call(null,inst_23096,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_23100 = inst_23075;
var state_23173__$1 = (function (){var statearr_23224 = state_23173;
(statearr_23224[(16)] = inst_23099);

(statearr_23224[(17)] = inst_23097);

(statearr_23224[(7)] = inst_23100);

(statearr_23224[(18)] = inst_23098);

return statearr_23224;
})();
var statearr_23225_23279 = state_23173__$1;
(statearr_23225_23279[(2)] = null);

(statearr_23225_23279[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (18))){
var inst_23115 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23226_23280 = state_23173__$1;
(statearr_23226_23280[(2)] = inst_23115);

(statearr_23226_23280[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (37))){
var state_23173__$1 = state_23173;
var statearr_23227_23281 = state_23173__$1;
(statearr_23227_23281[(2)] = null);

(statearr_23227_23281[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (8))){
var inst_23075 = (state_23173[(8)]);
var inst_23093 = cljs.core.apply.call(null,cljs.core.hash_map,inst_23075);
var state_23173__$1 = state_23173;
var statearr_23228_23282 = state_23173__$1;
(statearr_23228_23282[(2)] = inst_23093);

(statearr_23228_23282[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___23236,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__21371__auto__,c__21485__auto___23236,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__21372__auto__ = null;
var cljs$core$async$mix_$_state_machine__21372__auto____0 = (function (){
var statearr_23232 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23232[(0)] = cljs$core$async$mix_$_state_machine__21372__auto__);

(statearr_23232[(1)] = (1));

return statearr_23232;
});
var cljs$core$async$mix_$_state_machine__21372__auto____1 = (function (state_23173){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_23173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e23233){if((e23233 instanceof Object)){
var ex__21375__auto__ = e23233;
var statearr_23234_23283 = state_23173;
(statearr_23234_23283[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23173);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23233;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23284 = state_23173;
state_23173 = G__23284;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__21372__auto__ = function(state_23173){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__21372__auto____1.call(this,state_23173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__21372__auto____0;
cljs$core$async$mix_$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__21372__auto____1;
return cljs$core$async$mix_$_state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___23236,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__21487__auto__ = (function (){var statearr_23235 = f__21486__auto__.call(null);
(statearr_23235[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___23236);

return statearr_23235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___23236,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__10098__auto__ = (((p == null))?null:p);
var m__10099__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__10099__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__10098__auto__ = (((p == null))?null:p);
var m__10099__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,p,v,ch);
} else {
var m__10099__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args23285 = [];
var len__10601__auto___23288 = arguments.length;
var i__10602__auto___23289 = (0);
while(true){
if((i__10602__auto___23289 < len__10601__auto___23288)){
args23285.push((arguments[i__10602__auto___23289]));

var G__23290 = (i__10602__auto___23289 + (1));
i__10602__auto___23289 = G__23290;
continue;
} else {
}
break;
}

var G__23287 = args23285.length;
switch (G__23287) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23285.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__10098__auto__ = (((p == null))?null:p);
var m__10099__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,p);
} else {
var m__10099__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__10098__auto__ = (((p == null))?null:p);
var m__10099__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,p,v);
} else {
var m__10099__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args23293 = [];
var len__10601__auto___23418 = arguments.length;
var i__10602__auto___23419 = (0);
while(true){
if((i__10602__auto___23419 < len__10601__auto___23418)){
args23293.push((arguments[i__10602__auto___23419]));

var G__23420 = (i__10602__auto___23419 + (1));
i__10602__auto___23419 = G__23420;
continue;
} else {
}
break;
}

var G__23295 = args23293.length;
switch (G__23295) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23293.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9385__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9385__auto__)){
return or__9385__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9385__auto__,mults){
return (function (p1__23292_SHARP_){
if(cljs.core.truth_(p1__23292_SHARP_.call(null,topic))){
return p1__23292_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__23292_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9385__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async23296 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23296 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta23297){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta23297 = meta23297;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_23298,meta23297__$1){
var self__ = this;
var _23298__$1 = this;
return (new cljs.core.async.t_cljs$core$async23296(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta23297__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_23298){
var self__ = this;
var _23298__$1 = this;
return self__.meta23297;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta23297","meta23297",-1880284433,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23296.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23296.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23296";

cljs.core.async.t_cljs$core$async23296.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async23296");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async23296 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async23296(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23297){
return (new cljs.core.async.t_cljs$core$async23296(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23297));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async23296(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__21485__auto___23422 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___23422,mults,ensure_mult,p){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___23422,mults,ensure_mult,p){
return (function (state_23370){
var state_val_23371 = (state_23370[(1)]);
if((state_val_23371 === (7))){
var inst_23366 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
var statearr_23372_23423 = state_23370__$1;
(statearr_23372_23423[(2)] = inst_23366);

(statearr_23372_23423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (20))){
var state_23370__$1 = state_23370;
var statearr_23373_23424 = state_23370__$1;
(statearr_23373_23424[(2)] = null);

(statearr_23373_23424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (1))){
var state_23370__$1 = state_23370;
var statearr_23374_23425 = state_23370__$1;
(statearr_23374_23425[(2)] = null);

(statearr_23374_23425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (24))){
var inst_23349 = (state_23370[(7)]);
var inst_23358 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_23349);
var state_23370__$1 = state_23370;
var statearr_23375_23426 = state_23370__$1;
(statearr_23375_23426[(2)] = inst_23358);

(statearr_23375_23426[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (4))){
var inst_23301 = (state_23370[(8)]);
var inst_23301__$1 = (state_23370[(2)]);
var inst_23302 = (inst_23301__$1 == null);
var state_23370__$1 = (function (){var statearr_23376 = state_23370;
(statearr_23376[(8)] = inst_23301__$1);

return statearr_23376;
})();
if(cljs.core.truth_(inst_23302)){
var statearr_23377_23427 = state_23370__$1;
(statearr_23377_23427[(1)] = (5));

} else {
var statearr_23378_23428 = state_23370__$1;
(statearr_23378_23428[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (15))){
var inst_23343 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
var statearr_23379_23429 = state_23370__$1;
(statearr_23379_23429[(2)] = inst_23343);

(statearr_23379_23429[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (21))){
var inst_23363 = (state_23370[(2)]);
var state_23370__$1 = (function (){var statearr_23380 = state_23370;
(statearr_23380[(9)] = inst_23363);

return statearr_23380;
})();
var statearr_23381_23430 = state_23370__$1;
(statearr_23381_23430[(2)] = null);

(statearr_23381_23430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (13))){
var inst_23325 = (state_23370[(10)]);
var inst_23327 = cljs.core.chunked_seq_QMARK_.call(null,inst_23325);
var state_23370__$1 = state_23370;
if(inst_23327){
var statearr_23382_23431 = state_23370__$1;
(statearr_23382_23431[(1)] = (16));

} else {
var statearr_23383_23432 = state_23370__$1;
(statearr_23383_23432[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (22))){
var inst_23355 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
if(cljs.core.truth_(inst_23355)){
var statearr_23384_23433 = state_23370__$1;
(statearr_23384_23433[(1)] = (23));

} else {
var statearr_23385_23434 = state_23370__$1;
(statearr_23385_23434[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (6))){
var inst_23351 = (state_23370[(11)]);
var inst_23349 = (state_23370[(7)]);
var inst_23301 = (state_23370[(8)]);
var inst_23349__$1 = topic_fn.call(null,inst_23301);
var inst_23350 = cljs.core.deref.call(null,mults);
var inst_23351__$1 = cljs.core.get.call(null,inst_23350,inst_23349__$1);
var state_23370__$1 = (function (){var statearr_23386 = state_23370;
(statearr_23386[(11)] = inst_23351__$1);

(statearr_23386[(7)] = inst_23349__$1);

return statearr_23386;
})();
if(cljs.core.truth_(inst_23351__$1)){
var statearr_23387_23435 = state_23370__$1;
(statearr_23387_23435[(1)] = (19));

} else {
var statearr_23388_23436 = state_23370__$1;
(statearr_23388_23436[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (25))){
var inst_23360 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
var statearr_23389_23437 = state_23370__$1;
(statearr_23389_23437[(2)] = inst_23360);

(statearr_23389_23437[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (17))){
var inst_23325 = (state_23370[(10)]);
var inst_23334 = cljs.core.first.call(null,inst_23325);
var inst_23335 = cljs.core.async.muxch_STAR_.call(null,inst_23334);
var inst_23336 = cljs.core.async.close_BANG_.call(null,inst_23335);
var inst_23337 = cljs.core.next.call(null,inst_23325);
var inst_23311 = inst_23337;
var inst_23312 = null;
var inst_23313 = (0);
var inst_23314 = (0);
var state_23370__$1 = (function (){var statearr_23390 = state_23370;
(statearr_23390[(12)] = inst_23336);

(statearr_23390[(13)] = inst_23311);

(statearr_23390[(14)] = inst_23313);

(statearr_23390[(15)] = inst_23312);

(statearr_23390[(16)] = inst_23314);

return statearr_23390;
})();
var statearr_23391_23438 = state_23370__$1;
(statearr_23391_23438[(2)] = null);

(statearr_23391_23438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (3))){
var inst_23368 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23370__$1,inst_23368);
} else {
if((state_val_23371 === (12))){
var inst_23345 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
var statearr_23392_23439 = state_23370__$1;
(statearr_23392_23439[(2)] = inst_23345);

(statearr_23392_23439[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (2))){
var state_23370__$1 = state_23370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23370__$1,(4),ch);
} else {
if((state_val_23371 === (23))){
var state_23370__$1 = state_23370;
var statearr_23393_23440 = state_23370__$1;
(statearr_23393_23440[(2)] = null);

(statearr_23393_23440[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (19))){
var inst_23351 = (state_23370[(11)]);
var inst_23301 = (state_23370[(8)]);
var inst_23353 = cljs.core.async.muxch_STAR_.call(null,inst_23351);
var state_23370__$1 = state_23370;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23370__$1,(22),inst_23353,inst_23301);
} else {
if((state_val_23371 === (11))){
var inst_23311 = (state_23370[(13)]);
var inst_23325 = (state_23370[(10)]);
var inst_23325__$1 = cljs.core.seq.call(null,inst_23311);
var state_23370__$1 = (function (){var statearr_23394 = state_23370;
(statearr_23394[(10)] = inst_23325__$1);

return statearr_23394;
})();
if(inst_23325__$1){
var statearr_23395_23441 = state_23370__$1;
(statearr_23395_23441[(1)] = (13));

} else {
var statearr_23396_23442 = state_23370__$1;
(statearr_23396_23442[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (9))){
var inst_23347 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
var statearr_23397_23443 = state_23370__$1;
(statearr_23397_23443[(2)] = inst_23347);

(statearr_23397_23443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (5))){
var inst_23308 = cljs.core.deref.call(null,mults);
var inst_23309 = cljs.core.vals.call(null,inst_23308);
var inst_23310 = cljs.core.seq.call(null,inst_23309);
var inst_23311 = inst_23310;
var inst_23312 = null;
var inst_23313 = (0);
var inst_23314 = (0);
var state_23370__$1 = (function (){var statearr_23398 = state_23370;
(statearr_23398[(13)] = inst_23311);

(statearr_23398[(14)] = inst_23313);

(statearr_23398[(15)] = inst_23312);

(statearr_23398[(16)] = inst_23314);

return statearr_23398;
})();
var statearr_23399_23444 = state_23370__$1;
(statearr_23399_23444[(2)] = null);

(statearr_23399_23444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (14))){
var state_23370__$1 = state_23370;
var statearr_23403_23445 = state_23370__$1;
(statearr_23403_23445[(2)] = null);

(statearr_23403_23445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (16))){
var inst_23325 = (state_23370[(10)]);
var inst_23329 = cljs.core.chunk_first.call(null,inst_23325);
var inst_23330 = cljs.core.chunk_rest.call(null,inst_23325);
var inst_23331 = cljs.core.count.call(null,inst_23329);
var inst_23311 = inst_23330;
var inst_23312 = inst_23329;
var inst_23313 = inst_23331;
var inst_23314 = (0);
var state_23370__$1 = (function (){var statearr_23404 = state_23370;
(statearr_23404[(13)] = inst_23311);

(statearr_23404[(14)] = inst_23313);

(statearr_23404[(15)] = inst_23312);

(statearr_23404[(16)] = inst_23314);

return statearr_23404;
})();
var statearr_23405_23446 = state_23370__$1;
(statearr_23405_23446[(2)] = null);

(statearr_23405_23446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (10))){
var inst_23311 = (state_23370[(13)]);
var inst_23313 = (state_23370[(14)]);
var inst_23312 = (state_23370[(15)]);
var inst_23314 = (state_23370[(16)]);
var inst_23319 = cljs.core._nth.call(null,inst_23312,inst_23314);
var inst_23320 = cljs.core.async.muxch_STAR_.call(null,inst_23319);
var inst_23321 = cljs.core.async.close_BANG_.call(null,inst_23320);
var inst_23322 = (inst_23314 + (1));
var tmp23400 = inst_23311;
var tmp23401 = inst_23313;
var tmp23402 = inst_23312;
var inst_23311__$1 = tmp23400;
var inst_23312__$1 = tmp23402;
var inst_23313__$1 = tmp23401;
var inst_23314__$1 = inst_23322;
var state_23370__$1 = (function (){var statearr_23406 = state_23370;
(statearr_23406[(13)] = inst_23311__$1);

(statearr_23406[(17)] = inst_23321);

(statearr_23406[(14)] = inst_23313__$1);

(statearr_23406[(15)] = inst_23312__$1);

(statearr_23406[(16)] = inst_23314__$1);

return statearr_23406;
})();
var statearr_23407_23447 = state_23370__$1;
(statearr_23407_23447[(2)] = null);

(statearr_23407_23447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (18))){
var inst_23340 = (state_23370[(2)]);
var state_23370__$1 = state_23370;
var statearr_23408_23448 = state_23370__$1;
(statearr_23408_23448[(2)] = inst_23340);

(statearr_23408_23448[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23371 === (8))){
var inst_23313 = (state_23370[(14)]);
var inst_23314 = (state_23370[(16)]);
var inst_23316 = (inst_23314 < inst_23313);
var inst_23317 = inst_23316;
var state_23370__$1 = state_23370;
if(cljs.core.truth_(inst_23317)){
var statearr_23409_23449 = state_23370__$1;
(statearr_23409_23449[(1)] = (10));

} else {
var statearr_23410_23450 = state_23370__$1;
(statearr_23410_23450[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___23422,mults,ensure_mult,p))
;
return ((function (switch__21371__auto__,c__21485__auto___23422,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_23414 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23414[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_23414[(1)] = (1));

return statearr_23414;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_23370){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_23370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e23415){if((e23415 instanceof Object)){
var ex__21375__auto__ = e23415;
var statearr_23416_23451 = state_23370;
(statearr_23416_23451[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23370);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23415;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23452 = state_23370;
state_23370 = G__23452;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_23370){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_23370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___23422,mults,ensure_mult,p))
})();
var state__21487__auto__ = (function (){var statearr_23417 = f__21486__auto__.call(null);
(statearr_23417[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___23422);

return statearr_23417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___23422,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args23453 = [];
var len__10601__auto___23456 = arguments.length;
var i__10602__auto___23457 = (0);
while(true){
if((i__10602__auto___23457 < len__10601__auto___23456)){
args23453.push((arguments[i__10602__auto___23457]));

var G__23458 = (i__10602__auto___23457 + (1));
i__10602__auto___23457 = G__23458;
continue;
} else {
}
break;
}

var G__23455 = args23453.length;
switch (G__23455) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23453.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args23460 = [];
var len__10601__auto___23463 = arguments.length;
var i__10602__auto___23464 = (0);
while(true){
if((i__10602__auto___23464 < len__10601__auto___23463)){
args23460.push((arguments[i__10602__auto___23464]));

var G__23465 = (i__10602__auto___23464 + (1));
i__10602__auto___23464 = G__23465;
continue;
} else {
}
break;
}

var G__23462 = args23460.length;
switch (G__23462) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23460.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args23467 = [];
var len__10601__auto___23538 = arguments.length;
var i__10602__auto___23539 = (0);
while(true){
if((i__10602__auto___23539 < len__10601__auto___23538)){
args23467.push((arguments[i__10602__auto___23539]));

var G__23540 = (i__10602__auto___23539 + (1));
i__10602__auto___23539 = G__23540;
continue;
} else {
}
break;
}

var G__23469 = args23467.length;
switch (G__23469) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23467.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__21485__auto___23542 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___23542,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___23542,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_23508){
var state_val_23509 = (state_23508[(1)]);
if((state_val_23509 === (7))){
var state_23508__$1 = state_23508;
var statearr_23510_23543 = state_23508__$1;
(statearr_23510_23543[(2)] = null);

(statearr_23510_23543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (1))){
var state_23508__$1 = state_23508;
var statearr_23511_23544 = state_23508__$1;
(statearr_23511_23544[(2)] = null);

(statearr_23511_23544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (4))){
var inst_23472 = (state_23508[(7)]);
var inst_23474 = (inst_23472 < cnt);
var state_23508__$1 = state_23508;
if(cljs.core.truth_(inst_23474)){
var statearr_23512_23545 = state_23508__$1;
(statearr_23512_23545[(1)] = (6));

} else {
var statearr_23513_23546 = state_23508__$1;
(statearr_23513_23546[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (15))){
var inst_23504 = (state_23508[(2)]);
var state_23508__$1 = state_23508;
var statearr_23514_23547 = state_23508__$1;
(statearr_23514_23547[(2)] = inst_23504);

(statearr_23514_23547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (13))){
var inst_23497 = cljs.core.async.close_BANG_.call(null,out);
var state_23508__$1 = state_23508;
var statearr_23515_23548 = state_23508__$1;
(statearr_23515_23548[(2)] = inst_23497);

(statearr_23515_23548[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (6))){
var state_23508__$1 = state_23508;
var statearr_23516_23549 = state_23508__$1;
(statearr_23516_23549[(2)] = null);

(statearr_23516_23549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (3))){
var inst_23506 = (state_23508[(2)]);
var state_23508__$1 = state_23508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23508__$1,inst_23506);
} else {
if((state_val_23509 === (12))){
var inst_23494 = (state_23508[(8)]);
var inst_23494__$1 = (state_23508[(2)]);
var inst_23495 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_23494__$1);
var state_23508__$1 = (function (){var statearr_23517 = state_23508;
(statearr_23517[(8)] = inst_23494__$1);

return statearr_23517;
})();
if(cljs.core.truth_(inst_23495)){
var statearr_23518_23550 = state_23508__$1;
(statearr_23518_23550[(1)] = (13));

} else {
var statearr_23519_23551 = state_23508__$1;
(statearr_23519_23551[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (2))){
var inst_23471 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_23472 = (0);
var state_23508__$1 = (function (){var statearr_23520 = state_23508;
(statearr_23520[(7)] = inst_23472);

(statearr_23520[(9)] = inst_23471);

return statearr_23520;
})();
var statearr_23521_23552 = state_23508__$1;
(statearr_23521_23552[(2)] = null);

(statearr_23521_23552[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (11))){
var inst_23472 = (state_23508[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_23508,(10),Object,null,(9));
var inst_23481 = chs__$1.call(null,inst_23472);
var inst_23482 = done.call(null,inst_23472);
var inst_23483 = cljs.core.async.take_BANG_.call(null,inst_23481,inst_23482);
var state_23508__$1 = state_23508;
var statearr_23522_23553 = state_23508__$1;
(statearr_23522_23553[(2)] = inst_23483);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23508__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (9))){
var inst_23472 = (state_23508[(7)]);
var inst_23485 = (state_23508[(2)]);
var inst_23486 = (inst_23472 + (1));
var inst_23472__$1 = inst_23486;
var state_23508__$1 = (function (){var statearr_23523 = state_23508;
(statearr_23523[(7)] = inst_23472__$1);

(statearr_23523[(10)] = inst_23485);

return statearr_23523;
})();
var statearr_23524_23554 = state_23508__$1;
(statearr_23524_23554[(2)] = null);

(statearr_23524_23554[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (5))){
var inst_23492 = (state_23508[(2)]);
var state_23508__$1 = (function (){var statearr_23525 = state_23508;
(statearr_23525[(11)] = inst_23492);

return statearr_23525;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23508__$1,(12),dchan);
} else {
if((state_val_23509 === (14))){
var inst_23494 = (state_23508[(8)]);
var inst_23499 = cljs.core.apply.call(null,f,inst_23494);
var state_23508__$1 = state_23508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23508__$1,(16),out,inst_23499);
} else {
if((state_val_23509 === (16))){
var inst_23501 = (state_23508[(2)]);
var state_23508__$1 = (function (){var statearr_23526 = state_23508;
(statearr_23526[(12)] = inst_23501);

return statearr_23526;
})();
var statearr_23527_23555 = state_23508__$1;
(statearr_23527_23555[(2)] = null);

(statearr_23527_23555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (10))){
var inst_23476 = (state_23508[(2)]);
var inst_23477 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_23508__$1 = (function (){var statearr_23528 = state_23508;
(statearr_23528[(13)] = inst_23476);

return statearr_23528;
})();
var statearr_23529_23556 = state_23508__$1;
(statearr_23529_23556[(2)] = inst_23477);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23508__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23509 === (8))){
var inst_23490 = (state_23508[(2)]);
var state_23508__$1 = state_23508;
var statearr_23530_23557 = state_23508__$1;
(statearr_23530_23557[(2)] = inst_23490);

(statearr_23530_23557[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___23542,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__21371__auto__,c__21485__auto___23542,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_23534 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23534[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_23534[(1)] = (1));

return statearr_23534;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_23508){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_23508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e23535){if((e23535 instanceof Object)){
var ex__21375__auto__ = e23535;
var statearr_23536_23558 = state_23508;
(statearr_23536_23558[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23535;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23559 = state_23508;
state_23508 = G__23559;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_23508){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_23508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___23542,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__21487__auto__ = (function (){var statearr_23537 = f__21486__auto__.call(null);
(statearr_23537[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___23542);

return statearr_23537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___23542,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args23561 = [];
var len__10601__auto___23619 = arguments.length;
var i__10602__auto___23620 = (0);
while(true){
if((i__10602__auto___23620 < len__10601__auto___23619)){
args23561.push((arguments[i__10602__auto___23620]));

var G__23621 = (i__10602__auto___23620 + (1));
i__10602__auto___23620 = G__23621;
continue;
} else {
}
break;
}

var G__23563 = args23561.length;
switch (G__23563) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23561.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21485__auto___23623 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___23623,out){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___23623,out){
return (function (state_23595){
var state_val_23596 = (state_23595[(1)]);
if((state_val_23596 === (7))){
var inst_23574 = (state_23595[(7)]);
var inst_23575 = (state_23595[(8)]);
var inst_23574__$1 = (state_23595[(2)]);
var inst_23575__$1 = cljs.core.nth.call(null,inst_23574__$1,(0),null);
var inst_23576 = cljs.core.nth.call(null,inst_23574__$1,(1),null);
var inst_23577 = (inst_23575__$1 == null);
var state_23595__$1 = (function (){var statearr_23597 = state_23595;
(statearr_23597[(7)] = inst_23574__$1);

(statearr_23597[(8)] = inst_23575__$1);

(statearr_23597[(9)] = inst_23576);

return statearr_23597;
})();
if(cljs.core.truth_(inst_23577)){
var statearr_23598_23624 = state_23595__$1;
(statearr_23598_23624[(1)] = (8));

} else {
var statearr_23599_23625 = state_23595__$1;
(statearr_23599_23625[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23596 === (1))){
var inst_23564 = cljs.core.vec.call(null,chs);
var inst_23565 = inst_23564;
var state_23595__$1 = (function (){var statearr_23600 = state_23595;
(statearr_23600[(10)] = inst_23565);

return statearr_23600;
})();
var statearr_23601_23626 = state_23595__$1;
(statearr_23601_23626[(2)] = null);

(statearr_23601_23626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23596 === (4))){
var inst_23565 = (state_23595[(10)]);
var state_23595__$1 = state_23595;
return cljs.core.async.ioc_alts_BANG_.call(null,state_23595__$1,(7),inst_23565);
} else {
if((state_val_23596 === (6))){
var inst_23591 = (state_23595[(2)]);
var state_23595__$1 = state_23595;
var statearr_23602_23627 = state_23595__$1;
(statearr_23602_23627[(2)] = inst_23591);

(statearr_23602_23627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23596 === (3))){
var inst_23593 = (state_23595[(2)]);
var state_23595__$1 = state_23595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23595__$1,inst_23593);
} else {
if((state_val_23596 === (2))){
var inst_23565 = (state_23595[(10)]);
var inst_23567 = cljs.core.count.call(null,inst_23565);
var inst_23568 = (inst_23567 > (0));
var state_23595__$1 = state_23595;
if(cljs.core.truth_(inst_23568)){
var statearr_23604_23628 = state_23595__$1;
(statearr_23604_23628[(1)] = (4));

} else {
var statearr_23605_23629 = state_23595__$1;
(statearr_23605_23629[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23596 === (11))){
var inst_23565 = (state_23595[(10)]);
var inst_23584 = (state_23595[(2)]);
var tmp23603 = inst_23565;
var inst_23565__$1 = tmp23603;
var state_23595__$1 = (function (){var statearr_23606 = state_23595;
(statearr_23606[(11)] = inst_23584);

(statearr_23606[(10)] = inst_23565__$1);

return statearr_23606;
})();
var statearr_23607_23630 = state_23595__$1;
(statearr_23607_23630[(2)] = null);

(statearr_23607_23630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23596 === (9))){
var inst_23575 = (state_23595[(8)]);
var state_23595__$1 = state_23595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23595__$1,(11),out,inst_23575);
} else {
if((state_val_23596 === (5))){
var inst_23589 = cljs.core.async.close_BANG_.call(null,out);
var state_23595__$1 = state_23595;
var statearr_23608_23631 = state_23595__$1;
(statearr_23608_23631[(2)] = inst_23589);

(statearr_23608_23631[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23596 === (10))){
var inst_23587 = (state_23595[(2)]);
var state_23595__$1 = state_23595;
var statearr_23609_23632 = state_23595__$1;
(statearr_23609_23632[(2)] = inst_23587);

(statearr_23609_23632[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23596 === (8))){
var inst_23574 = (state_23595[(7)]);
var inst_23575 = (state_23595[(8)]);
var inst_23576 = (state_23595[(9)]);
var inst_23565 = (state_23595[(10)]);
var inst_23579 = (function (){var cs = inst_23565;
var vec__23570 = inst_23574;
var v = inst_23575;
var c = inst_23576;
return ((function (cs,vec__23570,v,c,inst_23574,inst_23575,inst_23576,inst_23565,state_val_23596,c__21485__auto___23623,out){
return (function (p1__23560_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__23560_SHARP_);
});
;})(cs,vec__23570,v,c,inst_23574,inst_23575,inst_23576,inst_23565,state_val_23596,c__21485__auto___23623,out))
})();
var inst_23580 = cljs.core.filterv.call(null,inst_23579,inst_23565);
var inst_23565__$1 = inst_23580;
var state_23595__$1 = (function (){var statearr_23610 = state_23595;
(statearr_23610[(10)] = inst_23565__$1);

return statearr_23610;
})();
var statearr_23611_23633 = state_23595__$1;
(statearr_23611_23633[(2)] = null);

(statearr_23611_23633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___23623,out))
;
return ((function (switch__21371__auto__,c__21485__auto___23623,out){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_23615 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23615[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_23615[(1)] = (1));

return statearr_23615;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_23595){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_23595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e23616){if((e23616 instanceof Object)){
var ex__21375__auto__ = e23616;
var statearr_23617_23634 = state_23595;
(statearr_23617_23634[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23616;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23635 = state_23595;
state_23595 = G__23635;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_23595){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_23595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___23623,out))
})();
var state__21487__auto__ = (function (){var statearr_23618 = f__21486__auto__.call(null);
(statearr_23618[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___23623);

return statearr_23618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___23623,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args23636 = [];
var len__10601__auto___23685 = arguments.length;
var i__10602__auto___23686 = (0);
while(true){
if((i__10602__auto___23686 < len__10601__auto___23685)){
args23636.push((arguments[i__10602__auto___23686]));

var G__23687 = (i__10602__auto___23686 + (1));
i__10602__auto___23686 = G__23687;
continue;
} else {
}
break;
}

var G__23638 = args23636.length;
switch (G__23638) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23636.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21485__auto___23689 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___23689,out){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___23689,out){
return (function (state_23662){
var state_val_23663 = (state_23662[(1)]);
if((state_val_23663 === (7))){
var inst_23644 = (state_23662[(7)]);
var inst_23644__$1 = (state_23662[(2)]);
var inst_23645 = (inst_23644__$1 == null);
var inst_23646 = cljs.core.not.call(null,inst_23645);
var state_23662__$1 = (function (){var statearr_23664 = state_23662;
(statearr_23664[(7)] = inst_23644__$1);

return statearr_23664;
})();
if(inst_23646){
var statearr_23665_23690 = state_23662__$1;
(statearr_23665_23690[(1)] = (8));

} else {
var statearr_23666_23691 = state_23662__$1;
(statearr_23666_23691[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (1))){
var inst_23639 = (0);
var state_23662__$1 = (function (){var statearr_23667 = state_23662;
(statearr_23667[(8)] = inst_23639);

return statearr_23667;
})();
var statearr_23668_23692 = state_23662__$1;
(statearr_23668_23692[(2)] = null);

(statearr_23668_23692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (4))){
var state_23662__$1 = state_23662;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23662__$1,(7),ch);
} else {
if((state_val_23663 === (6))){
var inst_23657 = (state_23662[(2)]);
var state_23662__$1 = state_23662;
var statearr_23669_23693 = state_23662__$1;
(statearr_23669_23693[(2)] = inst_23657);

(statearr_23669_23693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (3))){
var inst_23659 = (state_23662[(2)]);
var inst_23660 = cljs.core.async.close_BANG_.call(null,out);
var state_23662__$1 = (function (){var statearr_23670 = state_23662;
(statearr_23670[(9)] = inst_23659);

return statearr_23670;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23662__$1,inst_23660);
} else {
if((state_val_23663 === (2))){
var inst_23639 = (state_23662[(8)]);
var inst_23641 = (inst_23639 < n);
var state_23662__$1 = state_23662;
if(cljs.core.truth_(inst_23641)){
var statearr_23671_23694 = state_23662__$1;
(statearr_23671_23694[(1)] = (4));

} else {
var statearr_23672_23695 = state_23662__$1;
(statearr_23672_23695[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (11))){
var inst_23639 = (state_23662[(8)]);
var inst_23649 = (state_23662[(2)]);
var inst_23650 = (inst_23639 + (1));
var inst_23639__$1 = inst_23650;
var state_23662__$1 = (function (){var statearr_23673 = state_23662;
(statearr_23673[(8)] = inst_23639__$1);

(statearr_23673[(10)] = inst_23649);

return statearr_23673;
})();
var statearr_23674_23696 = state_23662__$1;
(statearr_23674_23696[(2)] = null);

(statearr_23674_23696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (9))){
var state_23662__$1 = state_23662;
var statearr_23675_23697 = state_23662__$1;
(statearr_23675_23697[(2)] = null);

(statearr_23675_23697[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (5))){
var state_23662__$1 = state_23662;
var statearr_23676_23698 = state_23662__$1;
(statearr_23676_23698[(2)] = null);

(statearr_23676_23698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (10))){
var inst_23654 = (state_23662[(2)]);
var state_23662__$1 = state_23662;
var statearr_23677_23699 = state_23662__$1;
(statearr_23677_23699[(2)] = inst_23654);

(statearr_23677_23699[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (8))){
var inst_23644 = (state_23662[(7)]);
var state_23662__$1 = state_23662;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23662__$1,(11),out,inst_23644);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___23689,out))
;
return ((function (switch__21371__auto__,c__21485__auto___23689,out){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_23681 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23681[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_23681[(1)] = (1));

return statearr_23681;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_23662){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_23662);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e23682){if((e23682 instanceof Object)){
var ex__21375__auto__ = e23682;
var statearr_23683_23700 = state_23662;
(statearr_23683_23700[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23662);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23682;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23701 = state_23662;
state_23662 = G__23701;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_23662){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_23662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___23689,out))
})();
var state__21487__auto__ = (function (){var statearr_23684 = f__21486__auto__.call(null);
(statearr_23684[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___23689);

return statearr_23684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___23689,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async23709 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23709 = (function (f,ch,meta23710){
this.f = f;
this.ch = ch;
this.meta23710 = meta23710;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23711,meta23710__$1){
var self__ = this;
var _23711__$1 = this;
return (new cljs.core.async.t_cljs$core$async23709(self__.f,self__.ch,meta23710__$1));
});

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23711){
var self__ = this;
var _23711__$1 = this;
return self__.meta23710;
});

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async23712 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23712 = (function (f,ch,meta23710,_,fn1,meta23713){
this.f = f;
this.ch = ch;
this.meta23710 = meta23710;
this._ = _;
this.fn1 = fn1;
this.meta23713 = meta23713;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23712.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_23714,meta23713__$1){
var self__ = this;
var _23714__$1 = this;
return (new cljs.core.async.t_cljs$core$async23712(self__.f,self__.ch,self__.meta23710,self__._,self__.fn1,meta23713__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async23712.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_23714){
var self__ = this;
var _23714__$1 = this;
return self__.meta23713;
});})(___$1))
;

cljs.core.async.t_cljs$core$async23712.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23712.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async23712.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async23712.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__23702_SHARP_){
return f1.call(null,(((p1__23702_SHARP_ == null))?null:self__.f.call(null,p1__23702_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async23712.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta23710","meta23710",705296821,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async23709","cljs.core.async/t_cljs$core$async23709",-480427775,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta23713","meta23713",-1604612084,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async23712.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23712.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23712";

cljs.core.async.t_cljs$core$async23712.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async23712");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async23712 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async23712(f__$1,ch__$1,meta23710__$1,___$2,fn1__$1,meta23713){
return (new cljs.core.async.t_cljs$core$async23712(f__$1,ch__$1,meta23710__$1,___$2,fn1__$1,meta23713));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async23712(self__.f,self__.ch,self__.meta23710,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9373__auto__ = ret;
if(cljs.core.truth_(and__9373__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9373__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23709.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async23709.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta23710","meta23710",705296821,null)], null);
});

cljs.core.async.t_cljs$core$async23709.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23709.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23709";

cljs.core.async.t_cljs$core$async23709.cljs$lang$ctorPrWriter = (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async23709");
});

cljs.core.async.__GT_t_cljs$core$async23709 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async23709(f__$1,ch__$1,meta23710){
return (new cljs.core.async.t_cljs$core$async23709(f__$1,ch__$1,meta23710));
});

}

return (new cljs.core.async.t_cljs$core$async23709(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async23718 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23718 = (function (f,ch,meta23719){
this.f = f;
this.ch = ch;
this.meta23719 = meta23719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23720,meta23719__$1){
var self__ = this;
var _23720__$1 = this;
return (new cljs.core.async.t_cljs$core$async23718(self__.f,self__.ch,meta23719__$1));
});

cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23720){
var self__ = this;
var _23720__$1 = this;
return self__.meta23719;
});

cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23718.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async23718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta23719","meta23719",-1102103733,null)], null);
});

cljs.core.async.t_cljs$core$async23718.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23718.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23718";

cljs.core.async.t_cljs$core$async23718.cljs$lang$ctorPrWriter = (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async23718");
});

cljs.core.async.__GT_t_cljs$core$async23718 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async23718(f__$1,ch__$1,meta23719){
return (new cljs.core.async.t_cljs$core$async23718(f__$1,ch__$1,meta23719));
});

}

return (new cljs.core.async.t_cljs$core$async23718(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async23724 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23724 = (function (p,ch,meta23725){
this.p = p;
this.ch = ch;
this.meta23725 = meta23725;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23726,meta23725__$1){
var self__ = this;
var _23726__$1 = this;
return (new cljs.core.async.t_cljs$core$async23724(self__.p,self__.ch,meta23725__$1));
});

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23726){
var self__ = this;
var _23726__$1 = this;
return self__.meta23725;
});

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23724.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async23724.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta23725","meta23725",1829322975,null)], null);
});

cljs.core.async.t_cljs$core$async23724.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23724.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23724";

cljs.core.async.t_cljs$core$async23724.cljs$lang$ctorPrWriter = (function (this__10037__auto__,writer__10038__auto__,opt__10039__auto__){
return cljs.core._write.call(null,writer__10038__auto__,"cljs.core.async/t_cljs$core$async23724");
});

cljs.core.async.__GT_t_cljs$core$async23724 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async23724(p__$1,ch__$1,meta23725){
return (new cljs.core.async.t_cljs$core$async23724(p__$1,ch__$1,meta23725));
});

}

return (new cljs.core.async.t_cljs$core$async23724(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args23727 = [];
var len__10601__auto___23771 = arguments.length;
var i__10602__auto___23772 = (0);
while(true){
if((i__10602__auto___23772 < len__10601__auto___23771)){
args23727.push((arguments[i__10602__auto___23772]));

var G__23773 = (i__10602__auto___23772 + (1));
i__10602__auto___23772 = G__23773;
continue;
} else {
}
break;
}

var G__23729 = args23727.length;
switch (G__23729) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23727.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21485__auto___23775 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___23775,out){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___23775,out){
return (function (state_23750){
var state_val_23751 = (state_23750[(1)]);
if((state_val_23751 === (7))){
var inst_23746 = (state_23750[(2)]);
var state_23750__$1 = state_23750;
var statearr_23752_23776 = state_23750__$1;
(statearr_23752_23776[(2)] = inst_23746);

(statearr_23752_23776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (1))){
var state_23750__$1 = state_23750;
var statearr_23753_23777 = state_23750__$1;
(statearr_23753_23777[(2)] = null);

(statearr_23753_23777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (4))){
var inst_23732 = (state_23750[(7)]);
var inst_23732__$1 = (state_23750[(2)]);
var inst_23733 = (inst_23732__$1 == null);
var state_23750__$1 = (function (){var statearr_23754 = state_23750;
(statearr_23754[(7)] = inst_23732__$1);

return statearr_23754;
})();
if(cljs.core.truth_(inst_23733)){
var statearr_23755_23778 = state_23750__$1;
(statearr_23755_23778[(1)] = (5));

} else {
var statearr_23756_23779 = state_23750__$1;
(statearr_23756_23779[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (6))){
var inst_23732 = (state_23750[(7)]);
var inst_23737 = p.call(null,inst_23732);
var state_23750__$1 = state_23750;
if(cljs.core.truth_(inst_23737)){
var statearr_23757_23780 = state_23750__$1;
(statearr_23757_23780[(1)] = (8));

} else {
var statearr_23758_23781 = state_23750__$1;
(statearr_23758_23781[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (3))){
var inst_23748 = (state_23750[(2)]);
var state_23750__$1 = state_23750;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23750__$1,inst_23748);
} else {
if((state_val_23751 === (2))){
var state_23750__$1 = state_23750;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23750__$1,(4),ch);
} else {
if((state_val_23751 === (11))){
var inst_23740 = (state_23750[(2)]);
var state_23750__$1 = state_23750;
var statearr_23759_23782 = state_23750__$1;
(statearr_23759_23782[(2)] = inst_23740);

(statearr_23759_23782[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (9))){
var state_23750__$1 = state_23750;
var statearr_23760_23783 = state_23750__$1;
(statearr_23760_23783[(2)] = null);

(statearr_23760_23783[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (5))){
var inst_23735 = cljs.core.async.close_BANG_.call(null,out);
var state_23750__$1 = state_23750;
var statearr_23761_23784 = state_23750__$1;
(statearr_23761_23784[(2)] = inst_23735);

(statearr_23761_23784[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (10))){
var inst_23743 = (state_23750[(2)]);
var state_23750__$1 = (function (){var statearr_23762 = state_23750;
(statearr_23762[(8)] = inst_23743);

return statearr_23762;
})();
var statearr_23763_23785 = state_23750__$1;
(statearr_23763_23785[(2)] = null);

(statearr_23763_23785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23751 === (8))){
var inst_23732 = (state_23750[(7)]);
var state_23750__$1 = state_23750;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23750__$1,(11),out,inst_23732);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___23775,out))
;
return ((function (switch__21371__auto__,c__21485__auto___23775,out){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_23767 = [null,null,null,null,null,null,null,null,null];
(statearr_23767[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_23767[(1)] = (1));

return statearr_23767;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_23750){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_23750);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e23768){if((e23768 instanceof Object)){
var ex__21375__auto__ = e23768;
var statearr_23769_23786 = state_23750;
(statearr_23769_23786[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23750);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23768;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23787 = state_23750;
state_23750 = G__23787;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_23750){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_23750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___23775,out))
})();
var state__21487__auto__ = (function (){var statearr_23770 = f__21486__auto__.call(null);
(statearr_23770[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___23775);

return statearr_23770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___23775,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args23788 = [];
var len__10601__auto___23791 = arguments.length;
var i__10602__auto___23792 = (0);
while(true){
if((i__10602__auto___23792 < len__10601__auto___23791)){
args23788.push((arguments[i__10602__auto___23792]));

var G__23793 = (i__10602__auto___23792 + (1));
i__10602__auto___23792 = G__23793;
continue;
} else {
}
break;
}

var G__23790 = args23788.length;
switch (G__23790) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23788.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__21485__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto__){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto__){
return (function (state_23960){
var state_val_23961 = (state_23960[(1)]);
if((state_val_23961 === (7))){
var inst_23956 = (state_23960[(2)]);
var state_23960__$1 = state_23960;
var statearr_23962_24003 = state_23960__$1;
(statearr_23962_24003[(2)] = inst_23956);

(statearr_23962_24003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (20))){
var inst_23926 = (state_23960[(7)]);
var inst_23937 = (state_23960[(2)]);
var inst_23938 = cljs.core.next.call(null,inst_23926);
var inst_23912 = inst_23938;
var inst_23913 = null;
var inst_23914 = (0);
var inst_23915 = (0);
var state_23960__$1 = (function (){var statearr_23963 = state_23960;
(statearr_23963[(8)] = inst_23914);

(statearr_23963[(9)] = inst_23913);

(statearr_23963[(10)] = inst_23912);

(statearr_23963[(11)] = inst_23915);

(statearr_23963[(12)] = inst_23937);

return statearr_23963;
})();
var statearr_23964_24004 = state_23960__$1;
(statearr_23964_24004[(2)] = null);

(statearr_23964_24004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (1))){
var state_23960__$1 = state_23960;
var statearr_23965_24005 = state_23960__$1;
(statearr_23965_24005[(2)] = null);

(statearr_23965_24005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (4))){
var inst_23901 = (state_23960[(13)]);
var inst_23901__$1 = (state_23960[(2)]);
var inst_23902 = (inst_23901__$1 == null);
var state_23960__$1 = (function (){var statearr_23966 = state_23960;
(statearr_23966[(13)] = inst_23901__$1);

return statearr_23966;
})();
if(cljs.core.truth_(inst_23902)){
var statearr_23967_24006 = state_23960__$1;
(statearr_23967_24006[(1)] = (5));

} else {
var statearr_23968_24007 = state_23960__$1;
(statearr_23968_24007[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (15))){
var state_23960__$1 = state_23960;
var statearr_23972_24008 = state_23960__$1;
(statearr_23972_24008[(2)] = null);

(statearr_23972_24008[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (21))){
var state_23960__$1 = state_23960;
var statearr_23973_24009 = state_23960__$1;
(statearr_23973_24009[(2)] = null);

(statearr_23973_24009[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (13))){
var inst_23914 = (state_23960[(8)]);
var inst_23913 = (state_23960[(9)]);
var inst_23912 = (state_23960[(10)]);
var inst_23915 = (state_23960[(11)]);
var inst_23922 = (state_23960[(2)]);
var inst_23923 = (inst_23915 + (1));
var tmp23969 = inst_23914;
var tmp23970 = inst_23913;
var tmp23971 = inst_23912;
var inst_23912__$1 = tmp23971;
var inst_23913__$1 = tmp23970;
var inst_23914__$1 = tmp23969;
var inst_23915__$1 = inst_23923;
var state_23960__$1 = (function (){var statearr_23974 = state_23960;
(statearr_23974[(8)] = inst_23914__$1);

(statearr_23974[(9)] = inst_23913__$1);

(statearr_23974[(10)] = inst_23912__$1);

(statearr_23974[(14)] = inst_23922);

(statearr_23974[(11)] = inst_23915__$1);

return statearr_23974;
})();
var statearr_23975_24010 = state_23960__$1;
(statearr_23975_24010[(2)] = null);

(statearr_23975_24010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (22))){
var state_23960__$1 = state_23960;
var statearr_23976_24011 = state_23960__$1;
(statearr_23976_24011[(2)] = null);

(statearr_23976_24011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (6))){
var inst_23901 = (state_23960[(13)]);
var inst_23910 = f.call(null,inst_23901);
var inst_23911 = cljs.core.seq.call(null,inst_23910);
var inst_23912 = inst_23911;
var inst_23913 = null;
var inst_23914 = (0);
var inst_23915 = (0);
var state_23960__$1 = (function (){var statearr_23977 = state_23960;
(statearr_23977[(8)] = inst_23914);

(statearr_23977[(9)] = inst_23913);

(statearr_23977[(10)] = inst_23912);

(statearr_23977[(11)] = inst_23915);

return statearr_23977;
})();
var statearr_23978_24012 = state_23960__$1;
(statearr_23978_24012[(2)] = null);

(statearr_23978_24012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (17))){
var inst_23926 = (state_23960[(7)]);
var inst_23930 = cljs.core.chunk_first.call(null,inst_23926);
var inst_23931 = cljs.core.chunk_rest.call(null,inst_23926);
var inst_23932 = cljs.core.count.call(null,inst_23930);
var inst_23912 = inst_23931;
var inst_23913 = inst_23930;
var inst_23914 = inst_23932;
var inst_23915 = (0);
var state_23960__$1 = (function (){var statearr_23979 = state_23960;
(statearr_23979[(8)] = inst_23914);

(statearr_23979[(9)] = inst_23913);

(statearr_23979[(10)] = inst_23912);

(statearr_23979[(11)] = inst_23915);

return statearr_23979;
})();
var statearr_23980_24013 = state_23960__$1;
(statearr_23980_24013[(2)] = null);

(statearr_23980_24013[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (3))){
var inst_23958 = (state_23960[(2)]);
var state_23960__$1 = state_23960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23960__$1,inst_23958);
} else {
if((state_val_23961 === (12))){
var inst_23946 = (state_23960[(2)]);
var state_23960__$1 = state_23960;
var statearr_23981_24014 = state_23960__$1;
(statearr_23981_24014[(2)] = inst_23946);

(statearr_23981_24014[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (2))){
var state_23960__$1 = state_23960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23960__$1,(4),in$);
} else {
if((state_val_23961 === (23))){
var inst_23954 = (state_23960[(2)]);
var state_23960__$1 = state_23960;
var statearr_23982_24015 = state_23960__$1;
(statearr_23982_24015[(2)] = inst_23954);

(statearr_23982_24015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (19))){
var inst_23941 = (state_23960[(2)]);
var state_23960__$1 = state_23960;
var statearr_23983_24016 = state_23960__$1;
(statearr_23983_24016[(2)] = inst_23941);

(statearr_23983_24016[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (11))){
var inst_23912 = (state_23960[(10)]);
var inst_23926 = (state_23960[(7)]);
var inst_23926__$1 = cljs.core.seq.call(null,inst_23912);
var state_23960__$1 = (function (){var statearr_23984 = state_23960;
(statearr_23984[(7)] = inst_23926__$1);

return statearr_23984;
})();
if(inst_23926__$1){
var statearr_23985_24017 = state_23960__$1;
(statearr_23985_24017[(1)] = (14));

} else {
var statearr_23986_24018 = state_23960__$1;
(statearr_23986_24018[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (9))){
var inst_23948 = (state_23960[(2)]);
var inst_23949 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_23960__$1 = (function (){var statearr_23987 = state_23960;
(statearr_23987[(15)] = inst_23948);

return statearr_23987;
})();
if(cljs.core.truth_(inst_23949)){
var statearr_23988_24019 = state_23960__$1;
(statearr_23988_24019[(1)] = (21));

} else {
var statearr_23989_24020 = state_23960__$1;
(statearr_23989_24020[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (5))){
var inst_23904 = cljs.core.async.close_BANG_.call(null,out);
var state_23960__$1 = state_23960;
var statearr_23990_24021 = state_23960__$1;
(statearr_23990_24021[(2)] = inst_23904);

(statearr_23990_24021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (14))){
var inst_23926 = (state_23960[(7)]);
var inst_23928 = cljs.core.chunked_seq_QMARK_.call(null,inst_23926);
var state_23960__$1 = state_23960;
if(inst_23928){
var statearr_23991_24022 = state_23960__$1;
(statearr_23991_24022[(1)] = (17));

} else {
var statearr_23992_24023 = state_23960__$1;
(statearr_23992_24023[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (16))){
var inst_23944 = (state_23960[(2)]);
var state_23960__$1 = state_23960;
var statearr_23993_24024 = state_23960__$1;
(statearr_23993_24024[(2)] = inst_23944);

(statearr_23993_24024[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23961 === (10))){
var inst_23913 = (state_23960[(9)]);
var inst_23915 = (state_23960[(11)]);
var inst_23920 = cljs.core._nth.call(null,inst_23913,inst_23915);
var state_23960__$1 = state_23960;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23960__$1,(13),out,inst_23920);
} else {
if((state_val_23961 === (18))){
var inst_23926 = (state_23960[(7)]);
var inst_23935 = cljs.core.first.call(null,inst_23926);
var state_23960__$1 = state_23960;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23960__$1,(20),out,inst_23935);
} else {
if((state_val_23961 === (8))){
var inst_23914 = (state_23960[(8)]);
var inst_23915 = (state_23960[(11)]);
var inst_23917 = (inst_23915 < inst_23914);
var inst_23918 = inst_23917;
var state_23960__$1 = state_23960;
if(cljs.core.truth_(inst_23918)){
var statearr_23994_24025 = state_23960__$1;
(statearr_23994_24025[(1)] = (10));

} else {
var statearr_23995_24026 = state_23960__$1;
(statearr_23995_24026[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto__))
;
return ((function (switch__21371__auto__,c__21485__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__21372__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__21372__auto____0 = (function (){
var statearr_23999 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23999[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__21372__auto__);

(statearr_23999[(1)] = (1));

return statearr_23999;
});
var cljs$core$async$mapcat_STAR__$_state_machine__21372__auto____1 = (function (state_23960){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_23960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e24000){if((e24000 instanceof Object)){
var ex__21375__auto__ = e24000;
var statearr_24001_24027 = state_23960;
(statearr_24001_24027[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23960);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24000;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24028 = state_23960;
state_23960 = G__24028;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__21372__auto__ = function(state_23960){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__21372__auto____1.call(this,state_23960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__21372__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__21372__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto__))
})();
var state__21487__auto__ = (function (){var statearr_24002 = f__21486__auto__.call(null);
(statearr_24002[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto__);

return statearr_24002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto__))
);

return c__21485__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args24029 = [];
var len__10601__auto___24032 = arguments.length;
var i__10602__auto___24033 = (0);
while(true){
if((i__10602__auto___24033 < len__10601__auto___24032)){
args24029.push((arguments[i__10602__auto___24033]));

var G__24034 = (i__10602__auto___24033 + (1));
i__10602__auto___24033 = G__24034;
continue;
} else {
}
break;
}

var G__24031 = args24029.length;
switch (G__24031) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24029.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args24036 = [];
var len__10601__auto___24039 = arguments.length;
var i__10602__auto___24040 = (0);
while(true){
if((i__10602__auto___24040 < len__10601__auto___24039)){
args24036.push((arguments[i__10602__auto___24040]));

var G__24041 = (i__10602__auto___24040 + (1));
i__10602__auto___24040 = G__24041;
continue;
} else {
}
break;
}

var G__24038 = args24036.length;
switch (G__24038) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24036.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args24043 = [];
var len__10601__auto___24094 = arguments.length;
var i__10602__auto___24095 = (0);
while(true){
if((i__10602__auto___24095 < len__10601__auto___24094)){
args24043.push((arguments[i__10602__auto___24095]));

var G__24096 = (i__10602__auto___24095 + (1));
i__10602__auto___24095 = G__24096;
continue;
} else {
}
break;
}

var G__24045 = args24043.length;
switch (G__24045) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24043.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21485__auto___24098 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___24098,out){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___24098,out){
return (function (state_24069){
var state_val_24070 = (state_24069[(1)]);
if((state_val_24070 === (7))){
var inst_24064 = (state_24069[(2)]);
var state_24069__$1 = state_24069;
var statearr_24071_24099 = state_24069__$1;
(statearr_24071_24099[(2)] = inst_24064);

(statearr_24071_24099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24070 === (1))){
var inst_24046 = null;
var state_24069__$1 = (function (){var statearr_24072 = state_24069;
(statearr_24072[(7)] = inst_24046);

return statearr_24072;
})();
var statearr_24073_24100 = state_24069__$1;
(statearr_24073_24100[(2)] = null);

(statearr_24073_24100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24070 === (4))){
var inst_24049 = (state_24069[(8)]);
var inst_24049__$1 = (state_24069[(2)]);
var inst_24050 = (inst_24049__$1 == null);
var inst_24051 = cljs.core.not.call(null,inst_24050);
var state_24069__$1 = (function (){var statearr_24074 = state_24069;
(statearr_24074[(8)] = inst_24049__$1);

return statearr_24074;
})();
if(inst_24051){
var statearr_24075_24101 = state_24069__$1;
(statearr_24075_24101[(1)] = (5));

} else {
var statearr_24076_24102 = state_24069__$1;
(statearr_24076_24102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24070 === (6))){
var state_24069__$1 = state_24069;
var statearr_24077_24103 = state_24069__$1;
(statearr_24077_24103[(2)] = null);

(statearr_24077_24103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24070 === (3))){
var inst_24066 = (state_24069[(2)]);
var inst_24067 = cljs.core.async.close_BANG_.call(null,out);
var state_24069__$1 = (function (){var statearr_24078 = state_24069;
(statearr_24078[(9)] = inst_24066);

return statearr_24078;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24069__$1,inst_24067);
} else {
if((state_val_24070 === (2))){
var state_24069__$1 = state_24069;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24069__$1,(4),ch);
} else {
if((state_val_24070 === (11))){
var inst_24049 = (state_24069[(8)]);
var inst_24058 = (state_24069[(2)]);
var inst_24046 = inst_24049;
var state_24069__$1 = (function (){var statearr_24079 = state_24069;
(statearr_24079[(10)] = inst_24058);

(statearr_24079[(7)] = inst_24046);

return statearr_24079;
})();
var statearr_24080_24104 = state_24069__$1;
(statearr_24080_24104[(2)] = null);

(statearr_24080_24104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24070 === (9))){
var inst_24049 = (state_24069[(8)]);
var state_24069__$1 = state_24069;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24069__$1,(11),out,inst_24049);
} else {
if((state_val_24070 === (5))){
var inst_24046 = (state_24069[(7)]);
var inst_24049 = (state_24069[(8)]);
var inst_24053 = cljs.core._EQ_.call(null,inst_24049,inst_24046);
var state_24069__$1 = state_24069;
if(inst_24053){
var statearr_24082_24105 = state_24069__$1;
(statearr_24082_24105[(1)] = (8));

} else {
var statearr_24083_24106 = state_24069__$1;
(statearr_24083_24106[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24070 === (10))){
var inst_24061 = (state_24069[(2)]);
var state_24069__$1 = state_24069;
var statearr_24084_24107 = state_24069__$1;
(statearr_24084_24107[(2)] = inst_24061);

(statearr_24084_24107[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24070 === (8))){
var inst_24046 = (state_24069[(7)]);
var tmp24081 = inst_24046;
var inst_24046__$1 = tmp24081;
var state_24069__$1 = (function (){var statearr_24085 = state_24069;
(statearr_24085[(7)] = inst_24046__$1);

return statearr_24085;
})();
var statearr_24086_24108 = state_24069__$1;
(statearr_24086_24108[(2)] = null);

(statearr_24086_24108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___24098,out))
;
return ((function (switch__21371__auto__,c__21485__auto___24098,out){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_24090 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24090[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_24090[(1)] = (1));

return statearr_24090;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_24069){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_24069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e24091){if((e24091 instanceof Object)){
var ex__21375__auto__ = e24091;
var statearr_24092_24109 = state_24069;
(statearr_24092_24109[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24069);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24091;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24110 = state_24069;
state_24069 = G__24110;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_24069){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_24069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___24098,out))
})();
var state__21487__auto__ = (function (){var statearr_24093 = f__21486__auto__.call(null);
(statearr_24093[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___24098);

return statearr_24093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___24098,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args24111 = [];
var len__10601__auto___24181 = arguments.length;
var i__10602__auto___24182 = (0);
while(true){
if((i__10602__auto___24182 < len__10601__auto___24181)){
args24111.push((arguments[i__10602__auto___24182]));

var G__24183 = (i__10602__auto___24182 + (1));
i__10602__auto___24182 = G__24183;
continue;
} else {
}
break;
}

var G__24113 = args24111.length;
switch (G__24113) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24111.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21485__auto___24185 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___24185,out){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___24185,out){
return (function (state_24151){
var state_val_24152 = (state_24151[(1)]);
if((state_val_24152 === (7))){
var inst_24147 = (state_24151[(2)]);
var state_24151__$1 = state_24151;
var statearr_24153_24186 = state_24151__$1;
(statearr_24153_24186[(2)] = inst_24147);

(statearr_24153_24186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (1))){
var inst_24114 = (new Array(n));
var inst_24115 = inst_24114;
var inst_24116 = (0);
var state_24151__$1 = (function (){var statearr_24154 = state_24151;
(statearr_24154[(7)] = inst_24115);

(statearr_24154[(8)] = inst_24116);

return statearr_24154;
})();
var statearr_24155_24187 = state_24151__$1;
(statearr_24155_24187[(2)] = null);

(statearr_24155_24187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (4))){
var inst_24119 = (state_24151[(9)]);
var inst_24119__$1 = (state_24151[(2)]);
var inst_24120 = (inst_24119__$1 == null);
var inst_24121 = cljs.core.not.call(null,inst_24120);
var state_24151__$1 = (function (){var statearr_24156 = state_24151;
(statearr_24156[(9)] = inst_24119__$1);

return statearr_24156;
})();
if(inst_24121){
var statearr_24157_24188 = state_24151__$1;
(statearr_24157_24188[(1)] = (5));

} else {
var statearr_24158_24189 = state_24151__$1;
(statearr_24158_24189[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (15))){
var inst_24141 = (state_24151[(2)]);
var state_24151__$1 = state_24151;
var statearr_24159_24190 = state_24151__$1;
(statearr_24159_24190[(2)] = inst_24141);

(statearr_24159_24190[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (13))){
var state_24151__$1 = state_24151;
var statearr_24160_24191 = state_24151__$1;
(statearr_24160_24191[(2)] = null);

(statearr_24160_24191[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (6))){
var inst_24116 = (state_24151[(8)]);
var inst_24137 = (inst_24116 > (0));
var state_24151__$1 = state_24151;
if(cljs.core.truth_(inst_24137)){
var statearr_24161_24192 = state_24151__$1;
(statearr_24161_24192[(1)] = (12));

} else {
var statearr_24162_24193 = state_24151__$1;
(statearr_24162_24193[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (3))){
var inst_24149 = (state_24151[(2)]);
var state_24151__$1 = state_24151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24151__$1,inst_24149);
} else {
if((state_val_24152 === (12))){
var inst_24115 = (state_24151[(7)]);
var inst_24139 = cljs.core.vec.call(null,inst_24115);
var state_24151__$1 = state_24151;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24151__$1,(15),out,inst_24139);
} else {
if((state_val_24152 === (2))){
var state_24151__$1 = state_24151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24151__$1,(4),ch);
} else {
if((state_val_24152 === (11))){
var inst_24131 = (state_24151[(2)]);
var inst_24132 = (new Array(n));
var inst_24115 = inst_24132;
var inst_24116 = (0);
var state_24151__$1 = (function (){var statearr_24163 = state_24151;
(statearr_24163[(10)] = inst_24131);

(statearr_24163[(7)] = inst_24115);

(statearr_24163[(8)] = inst_24116);

return statearr_24163;
})();
var statearr_24164_24194 = state_24151__$1;
(statearr_24164_24194[(2)] = null);

(statearr_24164_24194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (9))){
var inst_24115 = (state_24151[(7)]);
var inst_24129 = cljs.core.vec.call(null,inst_24115);
var state_24151__$1 = state_24151;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24151__$1,(11),out,inst_24129);
} else {
if((state_val_24152 === (5))){
var inst_24124 = (state_24151[(11)]);
var inst_24115 = (state_24151[(7)]);
var inst_24116 = (state_24151[(8)]);
var inst_24119 = (state_24151[(9)]);
var inst_24123 = (inst_24115[inst_24116] = inst_24119);
var inst_24124__$1 = (inst_24116 + (1));
var inst_24125 = (inst_24124__$1 < n);
var state_24151__$1 = (function (){var statearr_24165 = state_24151;
(statearr_24165[(11)] = inst_24124__$1);

(statearr_24165[(12)] = inst_24123);

return statearr_24165;
})();
if(cljs.core.truth_(inst_24125)){
var statearr_24166_24195 = state_24151__$1;
(statearr_24166_24195[(1)] = (8));

} else {
var statearr_24167_24196 = state_24151__$1;
(statearr_24167_24196[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (14))){
var inst_24144 = (state_24151[(2)]);
var inst_24145 = cljs.core.async.close_BANG_.call(null,out);
var state_24151__$1 = (function (){var statearr_24169 = state_24151;
(statearr_24169[(13)] = inst_24144);

return statearr_24169;
})();
var statearr_24170_24197 = state_24151__$1;
(statearr_24170_24197[(2)] = inst_24145);

(statearr_24170_24197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (10))){
var inst_24135 = (state_24151[(2)]);
var state_24151__$1 = state_24151;
var statearr_24171_24198 = state_24151__$1;
(statearr_24171_24198[(2)] = inst_24135);

(statearr_24171_24198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24152 === (8))){
var inst_24124 = (state_24151[(11)]);
var inst_24115 = (state_24151[(7)]);
var tmp24168 = inst_24115;
var inst_24115__$1 = tmp24168;
var inst_24116 = inst_24124;
var state_24151__$1 = (function (){var statearr_24172 = state_24151;
(statearr_24172[(7)] = inst_24115__$1);

(statearr_24172[(8)] = inst_24116);

return statearr_24172;
})();
var statearr_24173_24199 = state_24151__$1;
(statearr_24173_24199[(2)] = null);

(statearr_24173_24199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___24185,out))
;
return ((function (switch__21371__auto__,c__21485__auto___24185,out){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_24177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24177[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_24177[(1)] = (1));

return statearr_24177;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_24151){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_24151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e24178){if((e24178 instanceof Object)){
var ex__21375__auto__ = e24178;
var statearr_24179_24200 = state_24151;
(statearr_24179_24200[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24151);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24178;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24201 = state_24151;
state_24151 = G__24201;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_24151){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_24151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___24185,out))
})();
var state__21487__auto__ = (function (){var statearr_24180 = f__21486__auto__.call(null);
(statearr_24180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___24185);

return statearr_24180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___24185,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args24202 = [];
var len__10601__auto___24276 = arguments.length;
var i__10602__auto___24277 = (0);
while(true){
if((i__10602__auto___24277 < len__10601__auto___24276)){
args24202.push((arguments[i__10602__auto___24277]));

var G__24278 = (i__10602__auto___24277 + (1));
i__10602__auto___24277 = G__24278;
continue;
} else {
}
break;
}

var G__24204 = args24202.length;
switch (G__24204) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24202.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21485__auto___24280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__21485__auto___24280,out){
return (function (){
var f__21486__auto__ = (function (){var switch__21371__auto__ = ((function (c__21485__auto___24280,out){
return (function (state_24246){
var state_val_24247 = (state_24246[(1)]);
if((state_val_24247 === (7))){
var inst_24242 = (state_24246[(2)]);
var state_24246__$1 = state_24246;
var statearr_24248_24281 = state_24246__$1;
(statearr_24248_24281[(2)] = inst_24242);

(statearr_24248_24281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (1))){
var inst_24205 = [];
var inst_24206 = inst_24205;
var inst_24207 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_24246__$1 = (function (){var statearr_24249 = state_24246;
(statearr_24249[(7)] = inst_24206);

(statearr_24249[(8)] = inst_24207);

return statearr_24249;
})();
var statearr_24250_24282 = state_24246__$1;
(statearr_24250_24282[(2)] = null);

(statearr_24250_24282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (4))){
var inst_24210 = (state_24246[(9)]);
var inst_24210__$1 = (state_24246[(2)]);
var inst_24211 = (inst_24210__$1 == null);
var inst_24212 = cljs.core.not.call(null,inst_24211);
var state_24246__$1 = (function (){var statearr_24251 = state_24246;
(statearr_24251[(9)] = inst_24210__$1);

return statearr_24251;
})();
if(inst_24212){
var statearr_24252_24283 = state_24246__$1;
(statearr_24252_24283[(1)] = (5));

} else {
var statearr_24253_24284 = state_24246__$1;
(statearr_24253_24284[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (15))){
var inst_24236 = (state_24246[(2)]);
var state_24246__$1 = state_24246;
var statearr_24254_24285 = state_24246__$1;
(statearr_24254_24285[(2)] = inst_24236);

(statearr_24254_24285[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (13))){
var state_24246__$1 = state_24246;
var statearr_24255_24286 = state_24246__$1;
(statearr_24255_24286[(2)] = null);

(statearr_24255_24286[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (6))){
var inst_24206 = (state_24246[(7)]);
var inst_24231 = inst_24206.length;
var inst_24232 = (inst_24231 > (0));
var state_24246__$1 = state_24246;
if(cljs.core.truth_(inst_24232)){
var statearr_24256_24287 = state_24246__$1;
(statearr_24256_24287[(1)] = (12));

} else {
var statearr_24257_24288 = state_24246__$1;
(statearr_24257_24288[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (3))){
var inst_24244 = (state_24246[(2)]);
var state_24246__$1 = state_24246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24246__$1,inst_24244);
} else {
if((state_val_24247 === (12))){
var inst_24206 = (state_24246[(7)]);
var inst_24234 = cljs.core.vec.call(null,inst_24206);
var state_24246__$1 = state_24246;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24246__$1,(15),out,inst_24234);
} else {
if((state_val_24247 === (2))){
var state_24246__$1 = state_24246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24246__$1,(4),ch);
} else {
if((state_val_24247 === (11))){
var inst_24210 = (state_24246[(9)]);
var inst_24214 = (state_24246[(10)]);
var inst_24224 = (state_24246[(2)]);
var inst_24225 = [];
var inst_24226 = inst_24225.push(inst_24210);
var inst_24206 = inst_24225;
var inst_24207 = inst_24214;
var state_24246__$1 = (function (){var statearr_24258 = state_24246;
(statearr_24258[(11)] = inst_24226);

(statearr_24258[(7)] = inst_24206);

(statearr_24258[(8)] = inst_24207);

(statearr_24258[(12)] = inst_24224);

return statearr_24258;
})();
var statearr_24259_24289 = state_24246__$1;
(statearr_24259_24289[(2)] = null);

(statearr_24259_24289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (9))){
var inst_24206 = (state_24246[(7)]);
var inst_24222 = cljs.core.vec.call(null,inst_24206);
var state_24246__$1 = state_24246;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24246__$1,(11),out,inst_24222);
} else {
if((state_val_24247 === (5))){
var inst_24210 = (state_24246[(9)]);
var inst_24207 = (state_24246[(8)]);
var inst_24214 = (state_24246[(10)]);
var inst_24214__$1 = f.call(null,inst_24210);
var inst_24215 = cljs.core._EQ_.call(null,inst_24214__$1,inst_24207);
var inst_24216 = cljs.core.keyword_identical_QMARK_.call(null,inst_24207,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_24217 = (inst_24215) || (inst_24216);
var state_24246__$1 = (function (){var statearr_24260 = state_24246;
(statearr_24260[(10)] = inst_24214__$1);

return statearr_24260;
})();
if(cljs.core.truth_(inst_24217)){
var statearr_24261_24290 = state_24246__$1;
(statearr_24261_24290[(1)] = (8));

} else {
var statearr_24262_24291 = state_24246__$1;
(statearr_24262_24291[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (14))){
var inst_24239 = (state_24246[(2)]);
var inst_24240 = cljs.core.async.close_BANG_.call(null,out);
var state_24246__$1 = (function (){var statearr_24264 = state_24246;
(statearr_24264[(13)] = inst_24239);

return statearr_24264;
})();
var statearr_24265_24292 = state_24246__$1;
(statearr_24265_24292[(2)] = inst_24240);

(statearr_24265_24292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (10))){
var inst_24229 = (state_24246[(2)]);
var state_24246__$1 = state_24246;
var statearr_24266_24293 = state_24246__$1;
(statearr_24266_24293[(2)] = inst_24229);

(statearr_24266_24293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24247 === (8))){
var inst_24206 = (state_24246[(7)]);
var inst_24210 = (state_24246[(9)]);
var inst_24214 = (state_24246[(10)]);
var inst_24219 = inst_24206.push(inst_24210);
var tmp24263 = inst_24206;
var inst_24206__$1 = tmp24263;
var inst_24207 = inst_24214;
var state_24246__$1 = (function (){var statearr_24267 = state_24246;
(statearr_24267[(7)] = inst_24206__$1);

(statearr_24267[(14)] = inst_24219);

(statearr_24267[(8)] = inst_24207);

return statearr_24267;
})();
var statearr_24268_24294 = state_24246__$1;
(statearr_24268_24294[(2)] = null);

(statearr_24268_24294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21485__auto___24280,out))
;
return ((function (switch__21371__auto__,c__21485__auto___24280,out){
return (function() {
var cljs$core$async$state_machine__21372__auto__ = null;
var cljs$core$async$state_machine__21372__auto____0 = (function (){
var statearr_24272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24272[(0)] = cljs$core$async$state_machine__21372__auto__);

(statearr_24272[(1)] = (1));

return statearr_24272;
});
var cljs$core$async$state_machine__21372__auto____1 = (function (state_24246){
while(true){
var ret_value__21373__auto__ = (function (){try{while(true){
var result__21374__auto__ = switch__21371__auto__.call(null,state_24246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21374__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21374__auto__;
}
break;
}
}catch (e24273){if((e24273 instanceof Object)){
var ex__21375__auto__ = e24273;
var statearr_24274_24295 = state_24246;
(statearr_24274_24295[(5)] = ex__21375__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24246);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24273;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24296 = state_24246;
state_24246 = G__24296;
continue;
} else {
return ret_value__21373__auto__;
}
break;
}
});
cljs$core$async$state_machine__21372__auto__ = function(state_24246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21372__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21372__auto____1.call(this,state_24246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21372__auto____0;
cljs$core$async$state_machine__21372__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21372__auto____1;
return cljs$core$async$state_machine__21372__auto__;
})()
;})(switch__21371__auto__,c__21485__auto___24280,out))
})();
var state__21487__auto__ = (function (){var statearr_24275 = f__21486__auto__.call(null);
(statearr_24275[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__21485__auto___24280);

return statearr_24275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21487__auto__);
});})(c__21485__auto___24280,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map