// Compiled by ClojureScript 1.9.293 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__50652__auto__ = (((this$ == null))?null:this$);
var m__50653__auto__ = (superv.async._error[goog.typeOf(x__50652__auto__)]);
if(!((m__50653__auto__ == null))){
return m__50653__auto__.call(null,this$);
} else {
var m__50653__auto____$1 = (superv.async._error["_"]);
if(!((m__50653__auto____$1 == null))){
return m__50653__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__50652__auto__ = (((this$ == null))?null:this$);
var m__50653__auto__ = (superv.async._abort[goog.typeOf(x__50652__auto__)]);
if(!((m__50653__auto__ == null))){
return m__50653__auto__.call(null,this$);
} else {
var m__50653__auto____$1 = (superv.async._abort["_"]);
if(!((m__50653__auto____$1 == null))){
return m__50653__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__50652__auto__ = (((this$ == null))?null:this$);
var m__50653__auto__ = (superv.async._register_go[goog.typeOf(x__50652__auto__)]);
if(!((m__50653__auto__ == null))){
return m__50653__auto__.call(null,this$,body);
} else {
var m__50653__auto____$1 = (superv.async._register_go["_"]);
if(!((m__50653__auto____$1 == null))){
return m__50653__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__50652__auto__ = (((this$ == null))?null:this$);
var m__50653__auto__ = (superv.async._unregister_go[goog.typeOf(x__50652__auto__)]);
if(!((m__50653__auto__ == null))){
return m__50653__auto__.call(null,this$,id);
} else {
var m__50653__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__50653__auto____$1 == null))){
return m__50653__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__50652__auto__ = (((this$ == null))?null:this$);
var m__50653__auto__ = (superv.async._track_exception[goog.typeOf(x__50652__auto__)]);
if(!((m__50653__auto__ == null))){
return m__50653__auto__.call(null,this$,e);
} else {
var m__50653__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__50653__auto____$1 == null))){
return m__50653__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__50652__auto__ = (((this$ == null))?null:this$);
var m__50653__auto__ = (superv.async._free_exception[goog.typeOf(x__50652__auto__)]);
if(!((m__50653__auto__ == null))){
return m__50653__auto__.call(null,this$,e);
} else {
var m__50653__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__50653__auto____$1 == null))){
return m__50653__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__50609__auto__,k__50610__auto__){
var self__ = this;
var this__50609__auto____$1 = this;
return cljs.core._lookup.call(null,this__50609__auto____$1,k__50610__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__50611__auto__,k138974,else__50612__auto__){
var self__ = this;
var this__50611__auto____$1 = this;
var G__138976 = (((k138974 instanceof cljs.core.Keyword))?k138974.fqn:null);
switch (G__138976) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k138974,else__50612__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__50623__auto__,writer__50624__auto__,opts__50625__auto__){
var self__ = this;
var this__50623__auto____$1 = this;
var pr_pair__50626__auto__ = ((function (this__50623__auto____$1){
return (function (keyval__50627__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__50624__auto__,cljs.core.pr_writer,""," ","",opts__50625__auto__,keyval__50627__auto__);
});})(this__50623__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__50624__auto__,pr_pair__50626__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__50625__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__138973){
var self__ = this;
var G__138973__$1 = this;
return (new cljs.core.RecordIter((0),G__138973__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__50607__auto__){
var self__ = this;
var this__50607__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__50603__auto__){
var self__ = this;
var this__50603__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__50613__auto__){
var self__ = this;
var this__50613__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__50604__auto__){
var self__ = this;
var this__50604__auto____$1 = this;
var h__50376__auto__ = self__.__hash;
if(!((h__50376__auto__ == null))){
return h__50376__auto__;
} else {
var h__50376__auto____$1 = cljs.core.hash_imap.call(null,this__50604__auto____$1);
self__.__hash = h__50376__auto____$1;

return h__50376__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__50605__auto__,other__50606__auto__){
var self__ = this;
var this__50605__auto____$1 = this;
if(cljs.core.truth_((function (){var and__49927__auto__ = other__50606__auto__;
if(cljs.core.truth_(and__49927__auto__)){
var and__49927__auto____$1 = (this__50605__auto____$1.constructor === other__50606__auto__.constructor);
if(and__49927__auto____$1){
return cljs.core.equiv_map.call(null,this__50605__auto____$1,other__50606__auto__);
} else {
return and__49927__auto____$1;
}
} else {
return and__49927__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__50618__auto__,k__50619__auto__){
var self__ = this;
var this__50618__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__50619__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__50618__auto____$1),self__.__meta),k__50619__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__50619__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__50616__auto__,k__50617__auto__,G__138973){
var self__ = this;
var this__50616__auto____$1 = this;
var pred__138977 = cljs.core.keyword_identical_QMARK_;
var expr__138978 = k__50617__auto__;
if(cljs.core.truth_(pred__138977.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__138978))){
return (new superv.async.TrackingSupervisor(G__138973,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__138977.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__138978))){
return (new superv.async.TrackingSupervisor(self__.error,G__138973,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__138977.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__138978))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__138973,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__138977.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__138978))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__138973,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__50617__auto__,G__138973),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__50621__auto__){
var self__ = this;
var this__50621__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__50608__auto__,G__138973){
var self__ = this;
var this__50608__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__138973,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__50614__auto__,entry__50615__auto__){
var self__ = this;
var this__50614__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__50615__auto__)){
return cljs.core._assoc.call(null,this__50614__auto____$1,cljs.core._nth.call(null,entry__50615__auto__,(0)),cljs.core._nth.call(null,entry__50615__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__50614__auto____$1,entry__50615__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__50645__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__50645__auto__,writer__50646__auto__){
return cljs.core._write.call(null,writer__50646__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__138975){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__138975),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__138975),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__138975),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__138975),null,cljs.core.dissoc.call(null,G__138975,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__51162__auto__ = [];
var len__51155__auto___139005 = arguments.length;
var i__51156__auto___139006 = (0);
while(true){
if((i__51156__auto___139006 < len__51155__auto___139005)){
args__51162__auto__.push((arguments[i__51156__auto___139006]));

var G__139007 = (i__51156__auto___139006 + (1));
i__51156__auto___139006 = G__139007;
continue;
} else {
}
break;
}

var argseq__51163__auto__ = ((((0) < args__51162__auto__.length))?(new cljs.core.IndexedSeq(args__51162__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__51163__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__138982){
var map__138983 = p__138982;
var map__138983__$1 = ((((!((map__138983 == null)))?((((map__138983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138983.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__138983):map__138983);
var stale_timeout = cljs.core.get.call(null,map__138983__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__138983__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__138983,map__138983__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__138983,map__138983__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__138983__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__138983,map__138983__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__138983,map__138983__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__138983,map__138983__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__138995 = cljs.core.filter.call(null,((function (s,err_ch,map__138983,map__138983__$1,stale_timeout,error_fn,pending_fn){
return (function (p__139001){
var vec__139002 = p__139001;
var k = cljs.core.nth.call(null,vec__139002,(0),null);
var v = cljs.core.nth.call(null,vec__139002,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__138983,map__138983__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__138998 = cljs.core.nth.call(null,vec__138995,(0),null);
var e = cljs.core.nth.call(null,vec__138998,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__138998,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__138983,map__138983__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq138981){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq138981));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__49939__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__49939__auto__)){
return or__49939__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args139025 = [];
var len__51155__auto___139028 = arguments.length;
var i__51156__auto___139029 = (0);
while(true){
if((i__51156__auto___139029 < len__51155__auto___139028)){
args139025.push((arguments[i__51156__auto___139029]));

var G__139030 = (i__51156__auto___139029 + (1));
i__51156__auto___139029 = G__139030;
continue;
} else {
}
break;
}

var G__139027 = args139025.length;
switch (G__139027) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args139025.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args139032 = [];
var len__51155__auto___139035 = arguments.length;
var i__51156__auto___139036 = (0);
while(true){
if((i__51156__auto___139036 < len__51155__auto___139035)){
args139032.push((arguments[i__51156__auto___139036]));

var G__139037 = (i__51156__auto___139036 + (1));
i__51156__auto___139036 = G__139037;
continue;
} else {
}
break;
}

var G__139034 = args139032.length;
switch (G__139034) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args139032.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Same as core.async alts! but throws an exception if the channel returns a
 *   throwable object or the context has been aborted.
 */
superv.async.alts_QMARK_ = (function superv$async$alts_QMARK_(var_args){
var args__51162__auto__ = [];
var len__51155__auto___139116 = arguments.length;
var i__51156__auto___139117 = (0);
while(true){
if((i__51156__auto___139117 < len__51155__auto___139116)){
args__51162__auto__.push((arguments[i__51156__auto___139117]));

var G__139118 = (i__51156__auto___139117 + (1));
i__51156__auto___139117 = G__139118;
continue;
} else {
}
break;
}

var argseq__51163__auto__ = ((((2) < args__51162__auto__.length))?(new cljs.core.IndexedSeq(args__51162__auto__.slice((2)),(0),null)):null);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__51163__auto__);
});

superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (S,ports,opts){
var c__136791__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"wrap-abort!","wrap-abort!",-643710675,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"port","port",-1119498507,null)], null),cljs.core.list(new cljs.core.Symbol(null,"apply","apply",-1334050276,null),new cljs.core.Symbol(null,"alts!","alts!",104119866,null),new cljs.core.Symbol(null,"ports","ports",625740665,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"throw-if-exception","throw-if-exception",-939544127,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),new cljs.core.Symbol(null,"port","port",-1119498507,null)], null)))));
var c__53627__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function (state_139091){
var state_val_139092 = (state_139091[(1)]);
if((state_val_139092 === (7))){
var inst_139045 = (state_139091[(7)]);
var inst_139053 = (state_139091[(2)]);
var state_139091__$1 = (function (){var statearr_139093 = state_139091;
(statearr_139093[(8)] = inst_139053);

return statearr_139093;
})();
var statearr_139094_139119 = state_139091__$1;
(statearr_139094_139119[(2)] = inst_139045);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139091__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (1))){
var state_139091__$1 = state_139091;
var statearr_139095_139120 = state_139091__$1;
(statearr_139095_139120[(2)] = null);

(statearr_139095_139120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (4))){
var inst_139045 = (state_139091[(7)]);
var inst_139045__$1 = (state_139091[(2)]);
var inst_139046 = cljs.core.ex_data.call(null,inst_139045__$1);
var inst_139047 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_139046);
var inst_139048 = cljs.core._EQ_.call(null,inst_139047,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_139091__$1 = (function (){var statearr_139096 = state_139091;
(statearr_139096[(7)] = inst_139045__$1);

return statearr_139096;
})();
if(inst_139048){
var statearr_139097_139121 = state_139091__$1;
(statearr_139097_139121[(1)] = (5));

} else {
var statearr_139098_139122 = state_139091__$1;
(statearr_139098_139122[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (6))){
var inst_139045 = (state_139091[(7)]);
var inst_139051 = superv.async._track_exception.call(null,S,inst_139045);
var state_139091__$1 = state_139091;
var statearr_139099_139123 = state_139091__$1;
(statearr_139099_139123[(2)] = inst_139051);

(statearr_139099_139123[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (3))){
var inst_139042 = (state_139091[(2)]);
var inst_139043 = superv.async._unregister_go.call(null,S,id__136792__auto__);
var state_139091__$1 = (function (){var statearr_139100 = state_139091;
(statearr_139100[(9)] = inst_139042);

(statearr_139100[(10)] = inst_139043);

return statearr_139100;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139091__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (12))){
var inst_139087 = (state_139091[(2)]);
var state_139091__$1 = state_139091;
var statearr_139101_139124 = state_139091__$1;
(statearr_139101_139124[(2)] = inst_139087);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139091__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (2))){
var inst_139089 = (state_139091[(2)]);
var state_139091__$1 = state_139091;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_139091__$1,inst_139089);
} else {
if((state_val_139092 === (11))){
var inst_139079 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var inst_139080 = cljs.core.nth.call(null,inst_139079,(0),null);
var inst_139081 = cljs.core.nth.call(null,inst_139079,(1),null);
var inst_139082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139083 = superv.async.throw_if_exception.call(null,S,inst_139080);
var inst_139084 = [inst_139083,inst_139081];
var inst_139085 = (new cljs.core.PersistentVector(null,2,(5),inst_139082,inst_139084,null));
var state_139091__$1 = state_139091;
var statearr_139102_139125 = state_139091__$1;
(statearr_139102_139125[(2)] = inst_139085);

(statearr_139102_139125[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (9))){
var inst_139060 = (state_139091[(11)]);
var inst_139066 = (state_139091[(2)]);
var inst_139067 = cljs.core.nth.call(null,inst_139066,(0),null);
var inst_139068 = cljs.core.nth.call(null,inst_139066,(1),null);
var inst_139069 = cljs.core._EQ_.call(null,inst_139068,inst_139060);
var state_139091__$1 = (function (){var statearr_139103 = state_139091;
(statearr_139103[(12)] = inst_139067);

return statearr_139103;
})();
if(inst_139069){
var statearr_139104_139126 = state_139091__$1;
(statearr_139104_139126[(1)] = (10));

} else {
var statearr_139105_139127 = state_139091__$1;
(statearr_139105_139127[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (5))){
var state_139091__$1 = state_139091;
var statearr_139106_139128 = state_139091__$1;
(statearr_139106_139128[(2)] = null);

(statearr_139106_139128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (10))){
var inst_139071 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139072 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139073 = cljs.core.PersistentHashMap.fromArrays(inst_139071,inst_139072);
var inst_139074 = cljs.core.ex_info.call(null,"Aborted operations",inst_139073);
var state_139091__$1 = state_139091;
var statearr_139107_139129 = state_139091__$1;
(statearr_139107_139129[(2)] = inst_139074);

(statearr_139107_139129[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139092 === (8))){
var inst_139060 = (state_139091[(11)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_139091,(4),Error,(3),(2));
var inst_139060__$1 = superv.async._abort.call(null,S);
var inst_139061 = cljs.core.async.timeout.call(null,(0));
var inst_139062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139063 = [inst_139060__$1,inst_139061];
var inst_139064 = (new cljs.core.PersistentVector(null,2,(5),inst_139062,inst_139063,null));
var state_139091__$1 = (function (){var statearr_139108 = state_139091;
(statearr_139108[(11)] = inst_139060__$1);

return statearr_139108;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139091__$1,(9),inst_139064,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__))
;
return ((function (switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_139112 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_139112[(0)] = superv$async$state_machine__53561__auto__);

(statearr_139112[(1)] = (1));

return statearr_139112;
});
var superv$async$state_machine__53561__auto____1 = (function (state_139091){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_139091);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e139113){if((e139113 instanceof Object)){
var ex__53564__auto__ = e139113;
var statearr_139114_139130 = state_139091;
(statearr_139114_139130[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139091);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139113;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139131 = state_139091;
state_139091 = G__139131;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_139091){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_139091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__))
})();
var state__53629__auto__ = (function (){var statearr_139115 = f__53628__auto__.call(null);
(statearr_139115[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto__);

return statearr_139115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__))
);

return c__53627__auto__;
});

superv.async.alts_QMARK_.cljs$lang$maxFixedArity = (2);

superv.async.alts_QMARK_.cljs$lang$applyTo = (function (seq139039){
var G__139040 = cljs.core.first.call(null,seq139039);
var seq139039__$1 = cljs.core.next.call(null,seq139039);
var G__139041 = cljs.core.first.call(null,seq139039__$1);
var seq139039__$2 = cljs.core.next.call(null,seq139039__$1);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__139040,G__139041,seq139039__$2);
});

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args139141 = [];
var len__51155__auto___139344 = arguments.length;
var i__51156__auto___139345 = (0);
while(true){
if((i__51156__auto___139345 < len__51155__auto___139344)){
args139141.push((arguments[i__51156__auto___139345]));

var G__139346 = (i__51156__auto___139345 + (1));
i__51156__auto___139345 = G__139346;
continue;
} else {
}
break;
}

var G__139143 = args139141.length;
switch (G__139143) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args139141.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__50955__auto___139348 = parallelism;
var __139349 = (0);
while(true){
if((__139349 < n__50955__auto___139348)){
var c__136791__auto___139350 = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto___139351 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__53627__auto___139352 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__139349,c__53627__auto___139352,c__136791__auto___139350,id__136792__auto___139351,n__50955__auto___139348,threads){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (__139349,c__53627__auto___139352,c__136791__auto___139350,id__136792__auto___139351,n__50955__auto___139348,threads){
return (function (state_139278){
var state_val_139279 = (state_139278[(1)]);
if((state_val_139279 === (7))){
var inst_139147 = (state_139278[(7)]);
var inst_139155 = (state_139278[(2)]);
var state_139278__$1 = (function (){var statearr_139280 = state_139278;
(statearr_139280[(8)] = inst_139155);

return statearr_139280;
})();
var statearr_139281_139353 = state_139278__$1;
(statearr_139281_139353[(2)] = inst_139147);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139278__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (20))){
var inst_139262 = (state_139278[(2)]);
var state_139278__$1 = state_139278;
var statearr_139282_139354 = state_139278__$1;
(statearr_139282_139354[(2)] = inst_139262);

(statearr_139282_139354[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (27))){
var inst_139224 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139225 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139226 = cljs.core.PersistentHashMap.fromArrays(inst_139224,inst_139225);
var inst_139227 = cljs.core.ex_info.call(null,"Aborted operations",inst_139226);
var state_139278__$1 = state_139278;
var statearr_139283_139355 = state_139278__$1;
(statearr_139283_139355[(2)] = inst_139227);

(statearr_139283_139355[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (1))){
var state_139278__$1 = state_139278;
var statearr_139284_139356 = state_139278__$1;
(statearr_139284_139356[(2)] = null);

(statearr_139284_139356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (24))){
var inst_139206 = (state_139278[(2)]);
var inst_139207 = superv.async.throw_if_exception.call(null,S,inst_139206);
var inst_139208 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_139278__$1 = (function (){var statearr_139285 = state_139278;
(statearr_139285[(9)] = inst_139207);

return statearr_139285;
})();
var statearr_139286_139357 = state_139278__$1;
(statearr_139286_139357[(2)] = inst_139208);

(statearr_139286_139357[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (39))){
var state_139278__$1 = state_139278;
var statearr_139287_139358 = state_139278__$1;
(statearr_139287_139358[(2)] = null);

(statearr_139287_139358[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (4))){
var inst_139147 = (state_139278[(7)]);
var inst_139147__$1 = (state_139278[(2)]);
var inst_139148 = cljs.core.ex_data.call(null,inst_139147__$1);
var inst_139149 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_139148);
var inst_139150 = cljs.core._EQ_.call(null,inst_139149,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_139278__$1 = (function (){var statearr_139288 = state_139278;
(statearr_139288[(7)] = inst_139147__$1);

return statearr_139288;
})();
if(inst_139150){
var statearr_139289_139359 = state_139278__$1;
(statearr_139289_139359[(1)] = (5));

} else {
var statearr_139290_139360 = state_139278__$1;
(statearr_139290_139360[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (15))){
var inst_139180 = (state_139278[(10)]);
var inst_139182 = (inst_139180 instanceof Error);
var state_139278__$1 = state_139278;
if(cljs.core.truth_(inst_139182)){
var statearr_139291_139361 = state_139278__$1;
(statearr_139291_139361[(1)] = (18));

} else {
var statearr_139292_139362 = state_139278__$1;
(statearr_139292_139362[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (21))){
var inst_139187 = (state_139278[(11)]);
var inst_139193 = (state_139278[(2)]);
var inst_139194 = cljs.core.nth.call(null,inst_139193,(0),null);
var inst_139195 = cljs.core.nth.call(null,inst_139193,(1),null);
var inst_139196 = cljs.core._EQ_.call(null,inst_139195,inst_139187);
var state_139278__$1 = (function (){var statearr_139293 = state_139278;
(statearr_139293[(12)] = inst_139194);

return statearr_139293;
})();
if(inst_139196){
var statearr_139294_139363 = state_139278__$1;
(statearr_139294_139363[(1)] = (22));

} else {
var statearr_139295_139364 = state_139278__$1;
(statearr_139295_139364[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (31))){
var state_139278__$1 = state_139278;
var statearr_139296_139365 = state_139278__$1;
(statearr_139296_139365[(2)] = null);

(statearr_139296_139365[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (32))){
var inst_139259 = (state_139278[(2)]);
var state_139278__$1 = (function (){var statearr_139297 = state_139278;
(statearr_139297[(13)] = inst_139259);

return statearr_139297;
})();
var statearr_139298_139366 = state_139278__$1;
(statearr_139298_139366[(2)] = null);

(statearr_139298_139366[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (40))){
var inst_139274 = (state_139278[(2)]);
var state_139278__$1 = state_139278;
var statearr_139299_139367 = state_139278__$1;
(statearr_139299_139367[(2)] = inst_139274);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139278__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (33))){
var inst_139236 = (state_139278[(14)]);
var inst_139242 = (state_139278[(2)]);
var inst_139243 = cljs.core.nth.call(null,inst_139242,(0),null);
var inst_139244 = cljs.core.nth.call(null,inst_139242,(1),null);
var inst_139245 = cljs.core._EQ_.call(null,inst_139244,inst_139236);
var state_139278__$1 = (function (){var statearr_139300 = state_139278;
(statearr_139300[(15)] = inst_139243);

return statearr_139300;
})();
if(inst_139245){
var statearr_139301_139368 = state_139278__$1;
(statearr_139301_139368[(1)] = (34));

} else {
var statearr_139302_139369 = state_139278__$1;
(statearr_139302_139369[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (13))){
var inst_139169 = (state_139278[(16)]);
var state_139278__$1 = state_139278;
var statearr_139303_139370 = state_139278__$1;
(statearr_139303_139370[(2)] = inst_139169);

(statearr_139303_139370[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (22))){
var inst_139198 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139199 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139200 = cljs.core.PersistentHashMap.fromArrays(inst_139198,inst_139199);
var inst_139201 = cljs.core.ex_info.call(null,"Aborted operations",inst_139200);
var state_139278__$1 = state_139278;
var statearr_139304_139371 = state_139278__$1;
(statearr_139304_139371[(2)] = inst_139201);

(statearr_139304_139371[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (36))){
var inst_139255 = (state_139278[(2)]);
var inst_139256 = superv.async.throw_if_exception.call(null,S,inst_139255);
var state_139278__$1 = state_139278;
var statearr_139305_139372 = state_139278__$1;
(statearr_139305_139372[(2)] = inst_139256);

(statearr_139305_139372[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (29))){
var inst_139231 = (state_139278[(17)]);
var inst_139230 = (state_139278[(2)]);
var inst_139231__$1 = superv.async.throw_if_exception.call(null,S,inst_139230);
var state_139278__$1 = (function (){var statearr_139306 = state_139278;
(statearr_139306[(17)] = inst_139231__$1);

return statearr_139306;
})();
if(cljs.core.truth_(inst_139231__$1)){
var statearr_139307_139373 = state_139278__$1;
(statearr_139307_139373[(1)] = (30));

} else {
var statearr_139308_139374 = state_139278__$1;
(statearr_139308_139374[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (6))){
var inst_139147 = (state_139278[(7)]);
var inst_139153 = superv.async._track_exception.call(null,S,inst_139147);
var state_139278__$1 = state_139278;
var statearr_139309_139375 = state_139278__$1;
(statearr_139309_139375[(2)] = inst_139153);

(statearr_139309_139375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (28))){
var inst_139220 = (state_139278[(18)]);
var state_139278__$1 = state_139278;
var statearr_139310_139376 = state_139278__$1;
(statearr_139310_139376[(2)] = inst_139220);

(statearr_139310_139376[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (25))){
var inst_139204 = (state_139278[(2)]);
var state_139278__$1 = state_139278;
var statearr_139311_139377 = state_139278__$1;
(statearr_139311_139377[(2)] = inst_139204);

(statearr_139311_139377[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (34))){
var inst_139247 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139248 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139249 = cljs.core.PersistentHashMap.fromArrays(inst_139247,inst_139248);
var inst_139250 = cljs.core.ex_info.call(null,"Aborted operations",inst_139249);
var state_139278__$1 = state_139278;
var statearr_139312_139378 = state_139278__$1;
(statearr_139312_139378[(2)] = inst_139250);

(statearr_139312_139378[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (17))){
var inst_139265 = (state_139278[(2)]);
var state_139278__$1 = state_139278;
var statearr_139313_139379 = state_139278__$1;
(statearr_139313_139379[(2)] = inst_139265);

(statearr_139313_139379[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (3))){
var inst_139144 = (state_139278[(2)]);
var inst_139145 = superv.async._unregister_go.call(null,S,id__136792__auto___139351);
var state_139278__$1 = (function (){var statearr_139314 = state_139278;
(statearr_139314[(19)] = inst_139145);

(statearr_139314[(20)] = inst_139144);

return statearr_139314;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139278__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (12))){
var inst_139173 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139174 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139175 = cljs.core.PersistentHashMap.fromArrays(inst_139173,inst_139174);
var inst_139176 = cljs.core.ex_info.call(null,"Aborted operations",inst_139175);
var state_139278__$1 = state_139278;
var statearr_139315_139380 = state_139278__$1;
(statearr_139315_139380[(2)] = inst_139176);

(statearr_139315_139380[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (2))){
var inst_139276 = (state_139278[(2)]);
var state_139278__$1 = state_139278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_139278__$1,inst_139276);
} else {
if((state_val_139279 === (23))){
var inst_139180 = (state_139278[(10)]);
var state_139278__$1 = state_139278;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_139278__$1,(25),out_ch,inst_139180);
} else {
if((state_val_139279 === (35))){
var inst_139231 = (state_139278[(17)]);
var state_139278__$1 = state_139278;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_139278__$1,(37),out_ch,inst_139231);
} else {
if((state_val_139279 === (19))){
var inst_139213 = (state_139278[(21)]);
var inst_139180 = (state_139278[(10)]);
var inst_139213__$1 = superv.async._abort.call(null,S);
var inst_139214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139215 = f_GT_.call(null,inst_139180);
var inst_139216 = [inst_139213__$1,inst_139215];
var inst_139217 = (new cljs.core.PersistentVector(null,2,(5),inst_139214,inst_139216,null));
var state_139278__$1 = (function (){var statearr_139316 = state_139278;
(statearr_139316[(21)] = inst_139213__$1);

return statearr_139316;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139278__$1,(26),inst_139217,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_139279 === (11))){
var inst_139163 = (state_139278[(22)]);
var inst_139168 = (state_139278[(2)]);
var inst_139169 = cljs.core.nth.call(null,inst_139168,(0),null);
var inst_139170 = cljs.core.nth.call(null,inst_139168,(1),null);
var inst_139171 = cljs.core._EQ_.call(null,inst_139170,inst_139163);
var state_139278__$1 = (function (){var statearr_139317 = state_139278;
(statearr_139317[(16)] = inst_139169);

return statearr_139317;
})();
if(inst_139171){
var statearr_139318_139381 = state_139278__$1;
(statearr_139318_139381[(1)] = (12));

} else {
var statearr_139319_139382 = state_139278__$1;
(statearr_139319_139382[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (9))){
var inst_139163 = (state_139278[(22)]);
var inst_139163__$1 = superv.async._abort.call(null,S);
var inst_139164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139165 = [inst_139163__$1,in_ch];
var inst_139166 = (new cljs.core.PersistentVector(null,2,(5),inst_139164,inst_139165,null));
var state_139278__$1 = (function (){var statearr_139320 = state_139278;
(statearr_139320[(22)] = inst_139163__$1);

return statearr_139320;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139278__$1,(11),inst_139166,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_139279 === (5))){
var state_139278__$1 = state_139278;
var statearr_139321_139383 = state_139278__$1;
(statearr_139321_139383[(2)] = null);

(statearr_139321_139383[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (14))){
var inst_139180 = (state_139278[(10)]);
var inst_139179 = (state_139278[(2)]);
var inst_139180__$1 = superv.async.throw_if_exception.call(null,S,inst_139179);
var state_139278__$1 = (function (){var statearr_139322 = state_139278;
(statearr_139322[(10)] = inst_139180__$1);

return statearr_139322;
})();
if(cljs.core.truth_(inst_139180__$1)){
var statearr_139323_139384 = state_139278__$1;
(statearr_139323_139384[(1)] = (15));

} else {
var statearr_139324_139385 = state_139278__$1;
(statearr_139324_139385[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (26))){
var inst_139213 = (state_139278[(21)]);
var inst_139219 = (state_139278[(2)]);
var inst_139220 = cljs.core.nth.call(null,inst_139219,(0),null);
var inst_139221 = cljs.core.nth.call(null,inst_139219,(1),null);
var inst_139222 = cljs.core._EQ_.call(null,inst_139221,inst_139213);
var state_139278__$1 = (function (){var statearr_139325 = state_139278;
(statearr_139325[(18)] = inst_139220);

return statearr_139325;
})();
if(inst_139222){
var statearr_139326_139386 = state_139278__$1;
(statearr_139326_139386[(1)] = (27));

} else {
var statearr_139327_139387 = state_139278__$1;
(statearr_139327_139387[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (16))){
var state_139278__$1 = state_139278;
var statearr_139328_139388 = state_139278__$1;
(statearr_139328_139388[(2)] = null);

(statearr_139328_139388[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (38))){
var inst_139271 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_139278__$1 = state_139278;
var statearr_139329_139389 = state_139278__$1;
(statearr_139329_139389[(2)] = inst_139271);

(statearr_139329_139389[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (30))){
var inst_139236 = (state_139278[(14)]);
var inst_139236__$1 = superv.async._abort.call(null,S);
var inst_139237 = cljs.core.async.timeout.call(null,(0));
var inst_139238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139239 = [inst_139236__$1,inst_139237];
var inst_139240 = (new cljs.core.PersistentVector(null,2,(5),inst_139238,inst_139239,null));
var state_139278__$1 = (function (){var statearr_139330 = state_139278;
(statearr_139330[(14)] = inst_139236__$1);

return statearr_139330;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139278__$1,(33),inst_139240,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_139279 === (10))){
var inst_139267 = (state_139278[(2)]);
var inst_139268 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_139269 = (inst_139268 === (0));
var state_139278__$1 = (function (){var statearr_139331 = state_139278;
(statearr_139331[(23)] = inst_139267);

return statearr_139331;
})();
if(cljs.core.truth_(inst_139269)){
var statearr_139332_139390 = state_139278__$1;
(statearr_139332_139390[(1)] = (38));

} else {
var statearr_139333_139391 = state_139278__$1;
(statearr_139333_139391[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (18))){
var inst_139187 = (state_139278[(11)]);
var inst_139187__$1 = superv.async._abort.call(null,S);
var inst_139188 = cljs.core.async.timeout.call(null,(0));
var inst_139189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139190 = [inst_139187__$1,inst_139188];
var inst_139191 = (new cljs.core.PersistentVector(null,2,(5),inst_139189,inst_139190,null));
var state_139278__$1 = (function (){var statearr_139334 = state_139278;
(statearr_139334[(11)] = inst_139187__$1);

return statearr_139334;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139278__$1,(21),inst_139191,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_139279 === (37))){
var inst_139253 = (state_139278[(2)]);
var state_139278__$1 = state_139278;
var statearr_139335_139392 = state_139278__$1;
(statearr_139335_139392[(2)] = inst_139253);

(statearr_139335_139392[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139279 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_139278,(4),Error,(3),(2));
var state_139278__$1 = state_139278;
var statearr_139336_139393 = state_139278__$1;
(statearr_139336_139393[(2)] = null);

(statearr_139336_139393[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__139349,c__53627__auto___139352,c__136791__auto___139350,id__136792__auto___139351,n__50955__auto___139348,threads))
;
return ((function (__139349,switch__53560__auto__,c__53627__auto___139352,c__136791__auto___139350,id__136792__auto___139351,n__50955__auto___139348,threads){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_139340 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_139340[(0)] = superv$async$state_machine__53561__auto__);

(statearr_139340[(1)] = (1));

return statearr_139340;
});
var superv$async$state_machine__53561__auto____1 = (function (state_139278){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_139278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e139341){if((e139341 instanceof Object)){
var ex__53564__auto__ = e139341;
var statearr_139342_139394 = state_139278;
(statearr_139342_139394[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139278);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139341;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139395 = state_139278;
state_139278 = G__139395;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_139278){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_139278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(__139349,switch__53560__auto__,c__53627__auto___139352,c__136791__auto___139350,id__136792__auto___139351,n__50955__auto___139348,threads))
})();
var state__53629__auto__ = (function (){var statearr_139343 = f__53628__auto__.call(null);
(statearr_139343[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___139352);

return statearr_139343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(__139349,c__53627__auto___139352,c__136791__auto___139350,id__136792__auto___139351,n__50955__auto___139348,threads))
);


var G__139396 = (__139349 + (1));
__139349 = G__139396;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__51162__auto__ = [];
var len__51155__auto___139477 = arguments.length;
var i__51156__auto___139478 = (0);
while(true){
if((i__51156__auto___139478 < len__51155__auto___139477)){
args__51162__auto__.push((arguments[i__51156__auto___139478]));

var G__139479 = (i__51156__auto___139478 + (1));
i__51156__auto___139478 = G__139479;
continue;
} else {
}
break;
}

var argseq__51163__auto__ = ((((1) < args__51162__auto__.length))?(new cljs.core.IndexedSeq(args__51162__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__51163__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__136791__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__53627__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto__,c__136791__auto__,id__136792__auto__,ch){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto__,c__136791__auto__,id__136792__auto__,ch){
return (function (state_139446){
var state_val_139447 = (state_139446[(1)]);
if((state_val_139447 === (7))){
var inst_139402 = (state_139446[(7)]);
var inst_139410 = (state_139446[(2)]);
var state_139446__$1 = (function (){var statearr_139448 = state_139446;
(statearr_139448[(8)] = inst_139410);

return statearr_139448;
})();
var statearr_139449_139480 = state_139446__$1;
(statearr_139449_139480[(2)] = inst_139402);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139446__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (1))){
var state_139446__$1 = state_139446;
var statearr_139450_139481 = state_139446__$1;
(statearr_139450_139481[(2)] = null);

(statearr_139450_139481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (4))){
var inst_139402 = (state_139446[(7)]);
var inst_139402__$1 = (state_139446[(2)]);
var inst_139403 = cljs.core.ex_data.call(null,inst_139402__$1);
var inst_139404 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_139403);
var inst_139405 = cljs.core._EQ_.call(null,inst_139404,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_139446__$1 = (function (){var statearr_139451 = state_139446;
(statearr_139451[(7)] = inst_139402__$1);

return statearr_139451;
})();
if(inst_139405){
var statearr_139452_139482 = state_139446__$1;
(statearr_139452_139482[(1)] = (5));

} else {
var statearr_139453_139483 = state_139446__$1;
(statearr_139453_139483[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (15))){
var state_139446__$1 = state_139446;
var statearr_139454_139484 = state_139446__$1;
(statearr_139454_139484[(2)] = null);

(statearr_139454_139484[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (13))){
var inst_139424 = (state_139446[(9)]);
var state_139446__$1 = state_139446;
var statearr_139455_139485 = state_139446__$1;
(statearr_139455_139485[(2)] = inst_139424);

(statearr_139455_139485[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (6))){
var inst_139402 = (state_139446[(7)]);
var inst_139408 = superv.async._track_exception.call(null,S,inst_139402);
var state_139446__$1 = state_139446;
var statearr_139456_139486 = state_139446__$1;
(statearr_139456_139486[(2)] = inst_139408);

(statearr_139456_139486[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (17))){
var inst_139440 = (state_139446[(2)]);
var state_139446__$1 = state_139446;
var statearr_139457_139487 = state_139446__$1;
(statearr_139457_139487[(2)] = inst_139440);

(statearr_139457_139487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (3))){
var inst_139399 = (state_139446[(2)]);
var inst_139400 = superv.async._unregister_go.call(null,S,id__136792__auto__);
var state_139446__$1 = (function (){var statearr_139458 = state_139446;
(statearr_139458[(10)] = inst_139399);

(statearr_139458[(11)] = inst_139400);

return statearr_139458;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139446__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (12))){
var inst_139428 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139429 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139430 = cljs.core.PersistentHashMap.fromArrays(inst_139428,inst_139429);
var inst_139431 = cljs.core.ex_info.call(null,"Aborted operations",inst_139430);
var state_139446__$1 = state_139446;
var statearr_139459_139488 = state_139446__$1;
(statearr_139459_139488[(2)] = inst_139431);

(statearr_139459_139488[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (2))){
var inst_139444 = (state_139446[(2)]);
var state_139446__$1 = state_139446;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_139446__$1,inst_139444);
} else {
if((state_val_139447 === (11))){
var inst_139418 = (state_139446[(12)]);
var inst_139423 = (state_139446[(2)]);
var inst_139424 = cljs.core.nth.call(null,inst_139423,(0),null);
var inst_139425 = cljs.core.nth.call(null,inst_139423,(1),null);
var inst_139426 = cljs.core._EQ_.call(null,inst_139425,inst_139418);
var state_139446__$1 = (function (){var statearr_139460 = state_139446;
(statearr_139460[(9)] = inst_139424);

return statearr_139460;
})();
if(inst_139426){
var statearr_139461_139489 = state_139446__$1;
(statearr_139461_139489[(1)] = (12));

} else {
var statearr_139462_139490 = state_139446__$1;
(statearr_139462_139490[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (9))){
var inst_139418 = (state_139446[(12)]);
var inst_139418__$1 = superv.async._abort.call(null,S);
var inst_139419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139420 = [inst_139418__$1,ch];
var inst_139421 = (new cljs.core.PersistentVector(null,2,(5),inst_139419,inst_139420,null));
var state_139446__$1 = (function (){var statearr_139463 = state_139446;
(statearr_139463[(12)] = inst_139418__$1);

return statearr_139463;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139446__$1,(11),inst_139421,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_139447 === (5))){
var state_139446__$1 = state_139446;
var statearr_139464_139491 = state_139446__$1;
(statearr_139464_139491[(2)] = null);

(statearr_139464_139491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (14))){
var inst_139434 = (state_139446[(2)]);
var inst_139435 = superv.async.throw_if_exception.call(null,S,inst_139434);
var state_139446__$1 = state_139446;
if(cljs.core.truth_(inst_139435)){
var statearr_139465_139492 = state_139446__$1;
(statearr_139465_139492[(1)] = (15));

} else {
var statearr_139466_139493 = state_139446__$1;
(statearr_139466_139493[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (16))){
var state_139446__$1 = state_139446;
var statearr_139467_139494 = state_139446__$1;
(statearr_139467_139494[(2)] = null);

(statearr_139467_139494[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (10))){
var inst_139442 = (state_139446[(2)]);
var state_139446__$1 = state_139446;
var statearr_139468_139495 = state_139446__$1;
(statearr_139468_139495[(2)] = inst_139442);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139446__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139447 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_139446,(4),Error,(3),(2));
var state_139446__$1 = state_139446;
var statearr_139469_139496 = state_139446__$1;
(statearr_139469_139496[(2)] = null);

(statearr_139469_139496[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__,ch))
;
return ((function (switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__,ch){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_139473 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_139473[(0)] = superv$async$state_machine__53561__auto__);

(statearr_139473[(1)] = (1));

return statearr_139473;
});
var superv$async$state_machine__53561__auto____1 = (function (state_139446){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_139446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e139474){if((e139474 instanceof Object)){
var ex__53564__auto__ = e139474;
var statearr_139475_139497 = state_139446;
(statearr_139475_139497[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139446);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139474;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139498 = state_139446;
state_139446 = G__139498;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_139446){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_139446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__,ch))
})();
var state__53629__auto__ = (function (){var statearr_139476 = f__53628__auto__.call(null);
(statearr_139476[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto__);

return statearr_139476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__,ch))
);

return c__53627__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq139397){
var G__139398 = cljs.core.first.call(null,seq139397);
var seq139397__$1 = cljs.core.next.call(null,seq139397);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__139398,seq139397__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__136791__auto___139865 = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto___139866 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__53627__auto___139867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto___139867,c__136791__auto___139865,id__136792__auto___139866,result){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto___139867,c__136791__auto___139865,id__136792__auto___139866,result){
return (function (state_139807){
var state_val_139808 = (state_139807[(1)]);
if((state_val_139808 === (7))){
var inst_139685 = (state_139807[(7)]);
var inst_139693 = (state_139807[(2)]);
var state_139807__$1 = (function (){var statearr_139809 = state_139807;
(statearr_139809[(8)] = inst_139693);

return statearr_139809;
})();
var statearr_139810_139868 = state_139807__$1;
(statearr_139810_139868[(2)] = inst_139685);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139807__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (20))){
var inst_139773 = (state_139807[(2)]);
var state_139807__$1 = state_139807;
var statearr_139811_139869 = state_139807__$1;
(statearr_139811_139869[(2)] = inst_139773);

(statearr_139811_139869[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (27))){
var inst_139763 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139764 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139765 = cljs.core.PersistentHashMap.fromArrays(inst_139763,inst_139764);
var inst_139766 = cljs.core.ex_info.call(null,"Aborted operations",inst_139765);
var state_139807__$1 = state_139807;
var statearr_139812_139870 = state_139807__$1;
(statearr_139812_139870[(2)] = inst_139766);

(statearr_139812_139870[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (1))){
var state_139807__$1 = state_139807;
var statearr_139813_139871 = state_139807__$1;
(statearr_139813_139871[(2)] = null);

(statearr_139813_139871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (24))){
var inst_139745 = (state_139807[(2)]);
var inst_139746 = superv.async.throw_if_exception.call(null,S,inst_139745);
var inst_139747 = cljs.core.async.close_BANG_.call(null,result);
var state_139807__$1 = (function (){var statearr_139814 = state_139807;
(statearr_139814[(9)] = inst_139746);

return statearr_139814;
})();
var statearr_139815_139872 = state_139807__$1;
(statearr_139815_139872[(2)] = inst_139747);

(statearr_139815_139872[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (4))){
var inst_139685 = (state_139807[(7)]);
var inst_139685__$1 = (state_139807[(2)]);
var inst_139686 = cljs.core.ex_data.call(null,inst_139685__$1);
var inst_139687 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_139686);
var inst_139688 = cljs.core._EQ_.call(null,inst_139687,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_139807__$1 = (function (){var statearr_139816 = state_139807;
(statearr_139816[(7)] = inst_139685__$1);

return statearr_139816;
})();
if(inst_139688){
var statearr_139817_139873 = state_139807__$1;
(statearr_139817_139873[(1)] = (5));

} else {
var statearr_139818_139874 = state_139807__$1;
(statearr_139818_139874[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (15))){
var inst_139719 = (state_139807[(10)]);
var inst_139721 = (inst_139719 instanceof Error);
var state_139807__$1 = state_139807;
if(cljs.core.truth_(inst_139721)){
var statearr_139819_139875 = state_139807__$1;
(statearr_139819_139875[(1)] = (18));

} else {
var statearr_139820_139876 = state_139807__$1;
(statearr_139820_139876[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (21))){
var inst_139726 = (state_139807[(11)]);
var inst_139732 = (state_139807[(2)]);
var inst_139733 = cljs.core.nth.call(null,inst_139732,(0),null);
var inst_139734 = cljs.core.nth.call(null,inst_139732,(1),null);
var inst_139735 = cljs.core._EQ_.call(null,inst_139734,inst_139726);
var state_139807__$1 = (function (){var statearr_139821 = state_139807;
(statearr_139821[(12)] = inst_139733);

return statearr_139821;
})();
if(inst_139735){
var statearr_139822_139877 = state_139807__$1;
(statearr_139822_139877[(1)] = (22));

} else {
var statearr_139823_139878 = state_139807__$1;
(statearr_139823_139878[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (31))){
var inst_139789 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139790 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139791 = cljs.core.PersistentHashMap.fromArrays(inst_139789,inst_139790);
var inst_139792 = cljs.core.ex_info.call(null,"Aborted operations",inst_139791);
var state_139807__$1 = state_139807;
var statearr_139824_139879 = state_139807__$1;
(statearr_139824_139879[(2)] = inst_139792);

(statearr_139824_139879[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (32))){
var inst_139697 = (state_139807[(13)]);
var state_139807__$1 = state_139807;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_139807__$1,(34),result,inst_139697);
} else {
if((state_val_139808 === (33))){
var inst_139797 = (state_139807[(2)]);
var inst_139798 = superv.async.throw_if_exception.call(null,S,inst_139797);
var inst_139799 = cljs.core.async.close_BANG_.call(null,result);
var state_139807__$1 = (function (){var statearr_139825 = state_139807;
(statearr_139825[(14)] = inst_139798);

return statearr_139825;
})();
var statearr_139826_139880 = state_139807__$1;
(statearr_139826_139880[(2)] = inst_139799);

(statearr_139826_139880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (13))){
var inst_139708 = (state_139807[(15)]);
var state_139807__$1 = state_139807;
var statearr_139827_139881 = state_139807__$1;
(statearr_139827_139881[(2)] = inst_139708);

(statearr_139827_139881[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (22))){
var inst_139737 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139738 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139739 = cljs.core.PersistentHashMap.fromArrays(inst_139737,inst_139738);
var inst_139740 = cljs.core.ex_info.call(null,"Aborted operations",inst_139739);
var state_139807__$1 = state_139807;
var statearr_139828_139882 = state_139807__$1;
(statearr_139828_139882[(2)] = inst_139740);

(statearr_139828_139882[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (29))){
var inst_139769 = (state_139807[(2)]);
var inst_139770 = superv.async.throw_if_exception.call(null,S,inst_139769);
var inst_139697 = inst_139770;
var state_139807__$1 = (function (){var statearr_139829 = state_139807;
(statearr_139829[(13)] = inst_139697);

return statearr_139829;
})();
var statearr_139830_139883 = state_139807__$1;
(statearr_139830_139883[(2)] = null);

(statearr_139830_139883[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (6))){
var inst_139685 = (state_139807[(7)]);
var inst_139691 = superv.async._track_exception.call(null,S,inst_139685);
var state_139807__$1 = state_139807;
var statearr_139831_139884 = state_139807__$1;
(statearr_139831_139884[(2)] = inst_139691);

(statearr_139831_139884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (28))){
var inst_139759 = (state_139807[(16)]);
var state_139807__$1 = state_139807;
var statearr_139832_139885 = state_139807__$1;
(statearr_139832_139885[(2)] = inst_139759);

(statearr_139832_139885[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (25))){
var inst_139743 = (state_139807[(2)]);
var state_139807__$1 = state_139807;
var statearr_139833_139886 = state_139807__$1;
(statearr_139833_139886[(2)] = inst_139743);

(statearr_139833_139886[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (34))){
var inst_139795 = (state_139807[(2)]);
var state_139807__$1 = state_139807;
var statearr_139834_139887 = state_139807__$1;
(statearr_139834_139887[(2)] = inst_139795);

(statearr_139834_139887[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (17))){
var inst_139801 = (state_139807[(2)]);
var state_139807__$1 = state_139807;
var statearr_139835_139888 = state_139807__$1;
(statearr_139835_139888[(2)] = inst_139801);

(statearr_139835_139888[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (3))){
var inst_139682 = (state_139807[(2)]);
var inst_139683 = superv.async._unregister_go.call(null,S,id__136792__auto___139866);
var state_139807__$1 = (function (){var statearr_139836 = state_139807;
(statearr_139836[(17)] = inst_139682);

(statearr_139836[(18)] = inst_139683);

return statearr_139836;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139807__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (12))){
var inst_139712 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139713 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139714 = cljs.core.PersistentHashMap.fromArrays(inst_139712,inst_139713);
var inst_139715 = cljs.core.ex_info.call(null,"Aborted operations",inst_139714);
var state_139807__$1 = state_139807;
var statearr_139837_139889 = state_139807__$1;
(statearr_139837_139889[(2)] = inst_139715);

(statearr_139837_139889[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (2))){
var inst_139805 = (state_139807[(2)]);
var state_139807__$1 = state_139807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_139807__$1,inst_139805);
} else {
if((state_val_139808 === (23))){
var inst_139719 = (state_139807[(10)]);
var state_139807__$1 = state_139807;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_139807__$1,(25),result,inst_139719);
} else {
if((state_val_139808 === (19))){
var inst_139697 = (state_139807[(13)]);
var inst_139752 = (state_139807[(19)]);
var inst_139719 = (state_139807[(10)]);
var inst_139752__$1 = superv.async._abort.call(null,S);
var inst_139753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139754 = f_GT_.call(null,inst_139697,inst_139719);
var inst_139755 = [inst_139752__$1,inst_139754];
var inst_139756 = (new cljs.core.PersistentVector(null,2,(5),inst_139753,inst_139755,null));
var state_139807__$1 = (function (){var statearr_139838 = state_139807;
(statearr_139838[(19)] = inst_139752__$1);

return statearr_139838;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139807__$1,(26),inst_139756,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_139808 === (11))){
var inst_139702 = (state_139807[(20)]);
var inst_139707 = (state_139807[(2)]);
var inst_139708 = cljs.core.nth.call(null,inst_139707,(0),null);
var inst_139709 = cljs.core.nth.call(null,inst_139707,(1),null);
var inst_139710 = cljs.core._EQ_.call(null,inst_139709,inst_139702);
var state_139807__$1 = (function (){var statearr_139839 = state_139807;
(statearr_139839[(15)] = inst_139708);

return statearr_139839;
})();
if(inst_139710){
var statearr_139840_139890 = state_139807__$1;
(statearr_139840_139890[(1)] = (12));

} else {
var statearr_139841_139891 = state_139807__$1;
(statearr_139841_139891[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (9))){
var inst_139702 = (state_139807[(20)]);
var inst_139702__$1 = superv.async._abort.call(null,S);
var inst_139703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139704 = [inst_139702__$1,ch];
var inst_139705 = (new cljs.core.PersistentVector(null,2,(5),inst_139703,inst_139704,null));
var state_139807__$1 = (function (){var statearr_139842 = state_139807;
(statearr_139842[(20)] = inst_139702__$1);

return statearr_139842;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139807__$1,(11),inst_139705,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_139808 === (5))){
var state_139807__$1 = state_139807;
var statearr_139843_139892 = state_139807__$1;
(statearr_139843_139892[(2)] = null);

(statearr_139843_139892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (14))){
var inst_139719 = (state_139807[(10)]);
var inst_139718 = (state_139807[(2)]);
var inst_139719__$1 = superv.async.throw_if_exception.call(null,S,inst_139718);
var state_139807__$1 = (function (){var statearr_139844 = state_139807;
(statearr_139844[(10)] = inst_139719__$1);

return statearr_139844;
})();
if(cljs.core.truth_(inst_139719__$1)){
var statearr_139845_139893 = state_139807__$1;
(statearr_139845_139893[(1)] = (15));

} else {
var statearr_139846_139894 = state_139807__$1;
(statearr_139846_139894[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (26))){
var inst_139752 = (state_139807[(19)]);
var inst_139758 = (state_139807[(2)]);
var inst_139759 = cljs.core.nth.call(null,inst_139758,(0),null);
var inst_139760 = cljs.core.nth.call(null,inst_139758,(1),null);
var inst_139761 = cljs.core._EQ_.call(null,inst_139760,inst_139752);
var state_139807__$1 = (function (){var statearr_139847 = state_139807;
(statearr_139847[(16)] = inst_139759);

return statearr_139847;
})();
if(inst_139761){
var statearr_139848_139895 = state_139807__$1;
(statearr_139848_139895[(1)] = (27));

} else {
var statearr_139849_139896 = state_139807__$1;
(statearr_139849_139896[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (16))){
var inst_139778 = (state_139807[(21)]);
var inst_139778__$1 = superv.async._abort.call(null,S);
var inst_139779 = cljs.core.async.timeout.call(null,(0));
var inst_139780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139781 = [inst_139778__$1,inst_139779];
var inst_139782 = (new cljs.core.PersistentVector(null,2,(5),inst_139780,inst_139781,null));
var state_139807__$1 = (function (){var statearr_139850 = state_139807;
(statearr_139850[(21)] = inst_139778__$1);

return statearr_139850;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139807__$1,(30),inst_139782,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_139808 === (30))){
var inst_139778 = (state_139807[(21)]);
var inst_139784 = (state_139807[(2)]);
var inst_139785 = cljs.core.nth.call(null,inst_139784,(0),null);
var inst_139786 = cljs.core.nth.call(null,inst_139784,(1),null);
var inst_139787 = cljs.core._EQ_.call(null,inst_139786,inst_139778);
var state_139807__$1 = (function (){var statearr_139851 = state_139807;
(statearr_139851[(22)] = inst_139785);

return statearr_139851;
})();
if(inst_139787){
var statearr_139852_139897 = state_139807__$1;
(statearr_139852_139897[(1)] = (31));

} else {
var statearr_139853_139898 = state_139807__$1;
(statearr_139853_139898[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (10))){
var inst_139803 = (state_139807[(2)]);
var state_139807__$1 = state_139807;
var statearr_139854_139899 = state_139807__$1;
(statearr_139854_139899[(2)] = inst_139803);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139807__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139808 === (18))){
var inst_139726 = (state_139807[(11)]);
var inst_139726__$1 = superv.async._abort.call(null,S);
var inst_139727 = cljs.core.async.timeout.call(null,(0));
var inst_139728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139729 = [inst_139726__$1,inst_139727];
var inst_139730 = (new cljs.core.PersistentVector(null,2,(5),inst_139728,inst_139729,null));
var state_139807__$1 = (function (){var statearr_139855 = state_139807;
(statearr_139855[(11)] = inst_139726__$1);

return statearr_139855;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139807__$1,(21),inst_139730,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_139808 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_139807,(4),Error,(3),(2));
var inst_139697 = acc;
var state_139807__$1 = (function (){var statearr_139856 = state_139807;
(statearr_139856[(13)] = inst_139697);

return statearr_139856;
})();
var statearr_139857_139900 = state_139807__$1;
(statearr_139857_139900[(2)] = null);

(statearr_139857_139900[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto___139867,c__136791__auto___139865,id__136792__auto___139866,result))
;
return ((function (switch__53560__auto__,c__53627__auto___139867,c__136791__auto___139865,id__136792__auto___139866,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__53561__auto__ = null;
var superv$async$reduce_GT__$_state_machine__53561__auto____0 = (function (){
var statearr_139861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_139861[(0)] = superv$async$reduce_GT__$_state_machine__53561__auto__);

(statearr_139861[(1)] = (1));

return statearr_139861;
});
var superv$async$reduce_GT__$_state_machine__53561__auto____1 = (function (state_139807){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_139807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e139862){if((e139862 instanceof Object)){
var ex__53564__auto__ = e139862;
var statearr_139863_139901 = state_139807;
(statearr_139863_139901[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139807);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e139862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__139902 = state_139807;
state_139807 = G__139902;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__53561__auto__ = function(state_139807){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__53561__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__53561__auto____1.call(this,state_139807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_GT__$_state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__53561__auto____0;
superv$async$reduce_GT__$_state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__53561__auto____1;
return superv$async$reduce_GT__$_state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto___139867,c__136791__auto___139865,id__136792__auto___139866,result))
})();
var state__53629__auto__ = (function (){var statearr_139864 = f__53628__auto__.call(null);
(statearr_139864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___139867);

return statearr_139864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto___139867,c__136791__auto___139865,id__136792__auto___139866,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__51162__auto__ = [];
var len__51155__auto___140032 = arguments.length;
var i__51156__auto___140033 = (0);
while(true){
if((i__51156__auto___140033 < len__51155__auto___140032)){
args__51162__auto__.push((arguments[i__51156__auto___140033]));

var G__140034 = (i__51156__auto___140033 + (1));
i__51156__auto___140033 = G__140034;
continue;
} else {
}
break;
}

var argseq__51163__auto__ = ((((1) < args__51162__auto__.length))?(new cljs.core.IndexedSeq(args__51162__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__51163__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__136791__auto___140035 = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto___140036 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__53627__auto___140037 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto___140037,c__136791__auto___140035,id__136792__auto___140036,out){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto___140037,c__136791__auto___140035,id__136792__auto___140036,out){
return (function (state_139985){
var state_val_139986 = (state_139985[(1)]);
if((state_val_139986 === (7))){
var inst_139908 = (state_139985[(7)]);
var inst_139916 = (state_139985[(2)]);
var state_139985__$1 = (function (){var statearr_139988 = state_139985;
(statearr_139988[(8)] = inst_139916);

return statearr_139988;
})();
var statearr_139989_140038 = state_139985__$1;
(statearr_139989_140038[(2)] = inst_139908);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139985__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (20))){
var inst_139975 = (state_139985[(2)]);
var state_139985__$1 = state_139985;
var statearr_139990_140039 = state_139985__$1;
(statearr_139990_140039[(2)] = inst_139975);

(statearr_139990_140039[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (1))){
var state_139985__$1 = state_139985;
var statearr_139991_140040 = state_139985__$1;
(statearr_139991_140040[(2)] = null);

(statearr_139991_140040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (24))){
var inst_139920 = (state_139985[(9)]);
var inst_139968 = (state_139985[(2)]);
var inst_139969 = superv.async.throw_if_exception.call(null,S,inst_139968);
var tmp139987 = inst_139920;
var inst_139920__$1 = tmp139987;
var state_139985__$1 = (function (){var statearr_139992 = state_139985;
(statearr_139992[(10)] = inst_139969);

(statearr_139992[(9)] = inst_139920__$1);

return statearr_139992;
})();
var statearr_139993_140041 = state_139985__$1;
(statearr_139993_140041[(2)] = null);

(statearr_139993_140041[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (4))){
var inst_139908 = (state_139985[(7)]);
var inst_139908__$1 = (state_139985[(2)]);
var inst_139909 = cljs.core.ex_data.call(null,inst_139908__$1);
var inst_139910 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_139909);
var inst_139911 = cljs.core._EQ_.call(null,inst_139910,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_139985__$1 = (function (){var statearr_139994 = state_139985;
(statearr_139994[(7)] = inst_139908__$1);

return statearr_139994;
})();
if(inst_139911){
var statearr_139995_140042 = state_139985__$1;
(statearr_139995_140042[(1)] = (5));

} else {
var statearr_139996_140043 = state_139985__$1;
(statearr_139996_140043[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (15))){
var inst_139937 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139938 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139939 = cljs.core.PersistentHashMap.fromArrays(inst_139937,inst_139938);
var inst_139940 = cljs.core.ex_info.call(null,"Aborted operations",inst_139939);
var state_139985__$1 = state_139985;
var statearr_139997_140044 = state_139985__$1;
(statearr_139997_140044[(2)] = inst_139940);

(statearr_139997_140044[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (21))){
var inst_139949 = (state_139985[(11)]);
var inst_139955 = (state_139985[(2)]);
var inst_139956 = cljs.core.nth.call(null,inst_139955,(0),null);
var inst_139957 = cljs.core.nth.call(null,inst_139955,(1),null);
var inst_139958 = cljs.core._EQ_.call(null,inst_139957,inst_139949);
var state_139985__$1 = (function (){var statearr_139998 = state_139985;
(statearr_139998[(12)] = inst_139956);

return statearr_139998;
})();
if(inst_139958){
var statearr_139999_140045 = state_139985__$1;
(statearr_139999_140045[(1)] = (22));

} else {
var statearr_140000_140046 = state_139985__$1;
(statearr_140000_140046[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (13))){
var inst_139979 = (state_139985[(2)]);
var state_139985__$1 = state_139985;
var statearr_140001_140047 = state_139985__$1;
(statearr_140001_140047[(2)] = inst_139979);

(statearr_140001_140047[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (22))){
var inst_139960 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_139961 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_139962 = cljs.core.PersistentHashMap.fromArrays(inst_139960,inst_139961);
var inst_139963 = cljs.core.ex_info.call(null,"Aborted operations",inst_139962);
var state_139985__$1 = state_139985;
var statearr_140002_140048 = state_139985__$1;
(statearr_140002_140048[(2)] = inst_139963);

(statearr_140002_140048[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (6))){
var inst_139908 = (state_139985[(7)]);
var inst_139914 = superv.async._track_exception.call(null,S,inst_139908);
var state_139985__$1 = state_139985;
var statearr_140003_140049 = state_139985__$1;
(statearr_140003_140049[(2)] = inst_139914);

(statearr_140003_140049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (25))){
var inst_139966 = (state_139985[(2)]);
var state_139985__$1 = state_139985;
var statearr_140004_140050 = state_139985__$1;
(statearr_140004_140050[(2)] = inst_139966);

(statearr_140004_140050[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (17))){
var inst_139944 = (state_139985[(13)]);
var inst_139943 = (state_139985[(2)]);
var inst_139944__$1 = superv.async.throw_if_exception.call(null,S,inst_139943);
var state_139985__$1 = (function (){var statearr_140005 = state_139985;
(statearr_140005[(13)] = inst_139944__$1);

return statearr_140005;
})();
if(cljs.core.truth_(inst_139944__$1)){
var statearr_140006_140051 = state_139985__$1;
(statearr_140006_140051[(1)] = (18));

} else {
var statearr_140007_140052 = state_139985__$1;
(statearr_140007_140052[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (3))){
var inst_139905 = (state_139985[(2)]);
var inst_139906 = superv.async._unregister_go.call(null,S,id__136792__auto___140036);
var state_139985__$1 = (function (){var statearr_140008 = state_139985;
(statearr_140008[(14)] = inst_139905);

(statearr_140008[(15)] = inst_139906);

return statearr_140008;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139985__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (12))){
var inst_139977 = cljs.core.async.close_BANG_.call(null,out);
var state_139985__$1 = state_139985;
var statearr_140009_140053 = state_139985__$1;
(statearr_140009_140053[(2)] = inst_139977);

(statearr_140009_140053[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (2))){
var inst_139983 = (state_139985[(2)]);
var state_139985__$1 = state_139985;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_139985__$1,inst_139983);
} else {
if((state_val_139986 === (23))){
var inst_139944 = (state_139985[(13)]);
var state_139985__$1 = state_139985;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_139985__$1,(25),out,inst_139944);
} else {
if((state_val_139986 === (19))){
var inst_139920 = (state_139985[(9)]);
var inst_139972 = cljs.core.rest.call(null,inst_139920);
var inst_139920__$1 = inst_139972;
var state_139985__$1 = (function (){var statearr_140010 = state_139985;
(statearr_140010[(9)] = inst_139920__$1);

return statearr_140010;
})();
var statearr_140011_140054 = state_139985__$1;
(statearr_140011_140054[(2)] = null);

(statearr_140011_140054[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (11))){
var inst_139927 = (state_139985[(16)]);
var inst_139922 = (state_139985[(17)]);
var inst_139927__$1 = superv.async._abort.call(null,S);
var inst_139928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139929 = [inst_139927__$1,inst_139922];
var inst_139930 = (new cljs.core.PersistentVector(null,2,(5),inst_139928,inst_139929,null));
var state_139985__$1 = (function (){var statearr_140012 = state_139985;
(statearr_140012[(16)] = inst_139927__$1);

return statearr_140012;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139985__$1,(14),inst_139930,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_139986 === (9))){
var inst_139922 = (state_139985[(17)]);
var inst_139920 = (state_139985[(9)]);
var inst_139922__$1 = cljs.core.first.call(null,inst_139920);
var state_139985__$1 = (function (){var statearr_140013 = state_139985;
(statearr_140013[(17)] = inst_139922__$1);

return statearr_140013;
})();
if(cljs.core.truth_(inst_139922__$1)){
var statearr_140014_140055 = state_139985__$1;
(statearr_140014_140055[(1)] = (11));

} else {
var statearr_140015_140056 = state_139985__$1;
(statearr_140015_140056[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (5))){
var state_139985__$1 = state_139985;
var statearr_140016_140057 = state_139985__$1;
(statearr_140016_140057[(2)] = null);

(statearr_140016_140057[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (14))){
var inst_139927 = (state_139985[(16)]);
var inst_139932 = (state_139985[(2)]);
var inst_139933 = cljs.core.nth.call(null,inst_139932,(0),null);
var inst_139934 = cljs.core.nth.call(null,inst_139932,(1),null);
var inst_139935 = cljs.core._EQ_.call(null,inst_139934,inst_139927);
var state_139985__$1 = (function (){var statearr_140017 = state_139985;
(statearr_140017[(18)] = inst_139933);

return statearr_140017;
})();
if(inst_139935){
var statearr_140018_140058 = state_139985__$1;
(statearr_140018_140058[(1)] = (15));

} else {
var statearr_140019_140059 = state_139985__$1;
(statearr_140019_140059[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (16))){
var inst_139933 = (state_139985[(18)]);
var state_139985__$1 = state_139985;
var statearr_140020_140060 = state_139985__$1;
(statearr_140020_140060[(2)] = inst_139933);

(statearr_140020_140060[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (10))){
var inst_139981 = (state_139985[(2)]);
var state_139985__$1 = state_139985;
var statearr_140021_140061 = state_139985__$1;
(statearr_140021_140061[(2)] = inst_139981);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139985__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_139986 === (18))){
var inst_139949 = (state_139985[(11)]);
var inst_139949__$1 = superv.async._abort.call(null,S);
var inst_139950 = cljs.core.async.timeout.call(null,(0));
var inst_139951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_139952 = [inst_139949__$1,inst_139950];
var inst_139953 = (new cljs.core.PersistentVector(null,2,(5),inst_139951,inst_139952,null));
var state_139985__$1 = (function (){var statearr_140022 = state_139985;
(statearr_140022[(11)] = inst_139949__$1);

return statearr_140022;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_139985__$1,(21),inst_139953,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_139986 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_139985,(4),Error,(3),(2));
var inst_139920 = cs;
var state_139985__$1 = (function (){var statearr_140023 = state_139985;
(statearr_140023[(9)] = inst_139920);

return statearr_140023;
})();
var statearr_140024_140062 = state_139985__$1;
(statearr_140024_140062[(2)] = null);

(statearr_140024_140062[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto___140037,c__136791__auto___140035,id__136792__auto___140036,out))
;
return ((function (switch__53560__auto__,c__53627__auto___140037,c__136791__auto___140035,id__136792__auto___140036,out){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_140028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_140028[(0)] = superv$async$state_machine__53561__auto__);

(statearr_140028[(1)] = (1));

return statearr_140028;
});
var superv$async$state_machine__53561__auto____1 = (function (state_139985){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_139985);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e140029){if((e140029 instanceof Object)){
var ex__53564__auto__ = e140029;
var statearr_140030_140063 = state_139985;
(statearr_140030_140063[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_139985);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140029;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__140064 = state_139985;
state_139985 = G__140064;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_139985){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_139985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto___140037,c__136791__auto___140035,id__136792__auto___140036,out))
})();
var state__53629__auto__ = (function (){var statearr_140031 = f__53628__auto__.call(null);
(statearr_140031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___140037);

return statearr_140031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto___140037,c__136791__auto___140035,id__136792__auto___140036,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq139903){
var G__139904 = cljs.core.first.call(null,seq139903);
var seq139903__$1 = cljs.core.next.call(null,seq139903);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__139904,seq139903__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__51162__auto__ = [];
var len__51155__auto___140282 = arguments.length;
var i__51156__auto___140283 = (0);
while(true){
if((i__51156__auto___140283 < len__51155__auto___140282)){
args__51162__auto__.push((arguments[i__51156__auto___140283]));

var G__140284 = (i__51156__auto___140283 + (1));
i__51156__auto___140283 = G__140284;
continue;
} else {
}
break;
}

var argseq__51163__auto__ = ((((3) < args__51162__auto__.length))?(new cljs.core.IndexedSeq(args__51162__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__51163__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__140069){
var map__140070 = p__140069;
var map__140070__$1 = ((((!((map__140070 == null)))?((((map__140070.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__140070.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__140070):map__140070);
var out_ch = cljs.core.get.call(null,map__140070__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__49939__auto__ = out_ch;
if(cljs.core.truth_(or__49939__auto__)){
return or__49939__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__136791__auto___140285 = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto___140286 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__53627__auto___140287 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto___140287,c__136791__auto___140285,id__136792__auto___140286,out_ch__$1,map__140070,map__140070__$1,out_ch){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto___140287,c__136791__auto___140285,id__136792__auto___140286,out_ch__$1,map__140070,map__140070__$1,out_ch){
return (function (state_140214){
var state_val_140215 = (state_140214[(1)]);
if((state_val_140215 === (7))){
var inst_140075 = (state_140214[(7)]);
var inst_140083 = (state_140214[(2)]);
var state_140214__$1 = (function (){var statearr_140216 = state_140214;
(statearr_140216[(8)] = inst_140083);

return statearr_140216;
})();
var statearr_140217_140288 = state_140214__$1;
(statearr_140217_140288[(2)] = inst_140075);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140214__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (20))){
var inst_140175 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
var statearr_140218_140289 = state_140214__$1;
(statearr_140218_140289[(2)] = inst_140175);

(statearr_140218_140289[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (27))){
var inst_140140 = (state_140214[(9)]);
var inst_140088 = inst_140140;
var state_140214__$1 = (function (){var statearr_140219 = state_140214;
(statearr_140219[(10)] = inst_140088);

return statearr_140219;
})();
var statearr_140220_140290 = state_140214__$1;
(statearr_140220_140290[(2)] = null);

(statearr_140220_140290[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (1))){
var state_140214__$1 = state_140214;
var statearr_140221_140291 = state_140214__$1;
(statearr_140221_140291[(2)] = null);

(statearr_140221_140291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (24))){
var inst_140136 = (state_140214[(2)]);
var inst_140137 = superv.async.throw_if_exception.call(null,S,inst_140136);
var inst_140138 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_140214__$1 = (function (){var statearr_140222 = state_140214;
(statearr_140222[(11)] = inst_140137);

return statearr_140222;
})();
var statearr_140223_140292 = state_140214__$1;
(statearr_140223_140292[(2)] = inst_140138);

(statearr_140223_140292[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (39))){
var inst_140088 = (state_140214[(10)]);
var state_140214__$1 = state_140214;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_140214__$1,(41),out_ch__$1,inst_140088);
} else {
if((state_val_140215 === (4))){
var inst_140075 = (state_140214[(7)]);
var inst_140075__$1 = (state_140214[(2)]);
var inst_140076 = cljs.core.ex_data.call(null,inst_140075__$1);
var inst_140077 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_140076);
var inst_140078 = cljs.core._EQ_.call(null,inst_140077,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_140214__$1 = (function (){var statearr_140224 = state_140214;
(statearr_140224[(7)] = inst_140075__$1);

return statearr_140224;
})();
if(inst_140078){
var statearr_140225_140293 = state_140214__$1;
(statearr_140225_140293[(1)] = (5));

} else {
var statearr_140226_140294 = state_140214__$1;
(statearr_140226_140294[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (15))){
var inst_140110 = (state_140214[(12)]);
var inst_140112 = (inst_140110 instanceof Error);
var state_140214__$1 = state_140214;
if(cljs.core.truth_(inst_140112)){
var statearr_140227_140295 = state_140214__$1;
(statearr_140227_140295[(1)] = (18));

} else {
var statearr_140228_140296 = state_140214__$1;
(statearr_140228_140296[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (21))){
var inst_140117 = (state_140214[(13)]);
var inst_140123 = (state_140214[(2)]);
var inst_140124 = cljs.core.nth.call(null,inst_140123,(0),null);
var inst_140125 = cljs.core.nth.call(null,inst_140123,(1),null);
var inst_140126 = cljs.core._EQ_.call(null,inst_140125,inst_140117);
var state_140214__$1 = (function (){var statearr_140229 = state_140214;
(statearr_140229[(14)] = inst_140124);

return statearr_140229;
})();
if(inst_140126){
var statearr_140230_140297 = state_140214__$1;
(statearr_140230_140297[(1)] = (22));

} else {
var statearr_140231_140298 = state_140214__$1;
(statearr_140231_140298[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (31))){
var inst_140140 = (state_140214[(9)]);
var state_140214__$1 = state_140214;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_140214__$1,(33),out_ch__$1,inst_140140);
} else {
if((state_val_140215 === (32))){
var inst_140166 = (state_140214[(2)]);
var inst_140167 = superv.async.throw_if_exception.call(null,S,inst_140166);
var inst_140168 = cljs.core.PersistentVector.EMPTY;
var inst_140088 = inst_140168;
var state_140214__$1 = (function (){var statearr_140232 = state_140214;
(statearr_140232[(15)] = inst_140167);

(statearr_140232[(10)] = inst_140088);

return statearr_140232;
})();
var statearr_140233_140299 = state_140214__$1;
(statearr_140233_140299[(2)] = null);

(statearr_140233_140299[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (40))){
var inst_140201 = (state_140214[(2)]);
var inst_140202 = superv.async.throw_if_exception.call(null,S,inst_140201);
var state_140214__$1 = state_140214;
var statearr_140234_140300 = state_140214__$1;
(statearr_140234_140300[(2)] = inst_140202);

(statearr_140234_140300[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (33))){
var inst_140164 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
var statearr_140235_140301 = state_140214__$1;
(statearr_140235_140301[(2)] = inst_140164);

(statearr_140235_140301[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (13))){
var inst_140099 = (state_140214[(16)]);
var state_140214__$1 = state_140214;
var statearr_140236_140302 = state_140214__$1;
(statearr_140236_140302[(2)] = inst_140099);

(statearr_140236_140302[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (22))){
var inst_140128 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_140129 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_140130 = cljs.core.PersistentHashMap.fromArrays(inst_140128,inst_140129);
var inst_140131 = cljs.core.ex_info.call(null,"Aborted operations",inst_140130);
var state_140214__$1 = state_140214;
var statearr_140237_140303 = state_140214__$1;
(statearr_140237_140303[(2)] = inst_140131);

(statearr_140237_140303[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (36))){
var inst_140205 = (state_140214[(2)]);
var inst_140206 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_140214__$1 = (function (){var statearr_140238 = state_140214;
(statearr_140238[(17)] = inst_140205);

return statearr_140238;
})();
var statearr_140239_140304 = state_140214__$1;
(statearr_140239_140304[(2)] = inst_140206);

(statearr_140239_140304[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (41))){
var inst_140199 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
var statearr_140240_140305 = state_140214__$1;
(statearr_140240_140305[(2)] = inst_140199);

(statearr_140240_140305[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (29))){
var inst_140147 = (state_140214[(18)]);
var inst_140153 = (state_140214[(2)]);
var inst_140154 = cljs.core.nth.call(null,inst_140153,(0),null);
var inst_140155 = cljs.core.nth.call(null,inst_140153,(1),null);
var inst_140156 = cljs.core._EQ_.call(null,inst_140155,inst_140147);
var state_140214__$1 = (function (){var statearr_140241 = state_140214;
(statearr_140241[(19)] = inst_140154);

return statearr_140241;
})();
if(inst_140156){
var statearr_140242_140306 = state_140214__$1;
(statearr_140242_140306[(1)] = (30));

} else {
var statearr_140243_140307 = state_140214__$1;
(statearr_140243_140307[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (6))){
var inst_140075 = (state_140214[(7)]);
var inst_140081 = superv.async._track_exception.call(null,S,inst_140075);
var state_140214__$1 = state_140214;
var statearr_140244_140308 = state_140214__$1;
(statearr_140244_140308[(2)] = inst_140081);

(statearr_140244_140308[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (28))){
var inst_140173 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
var statearr_140245_140309 = state_140214__$1;
(statearr_140245_140309[(2)] = inst_140173);

(statearr_140245_140309[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (25))){
var inst_140134 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
var statearr_140246_140310 = state_140214__$1;
(statearr_140246_140310[(2)] = inst_140134);

(statearr_140246_140310[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (34))){
var inst_140182 = (state_140214[(20)]);
var inst_140182__$1 = superv.async._abort.call(null,S);
var inst_140183 = cljs.core.async.timeout.call(null,(0));
var inst_140184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_140185 = [inst_140182__$1,inst_140183];
var inst_140186 = (new cljs.core.PersistentVector(null,2,(5),inst_140184,inst_140185,null));
var state_140214__$1 = (function (){var statearr_140247 = state_140214;
(statearr_140247[(20)] = inst_140182__$1);

return statearr_140247;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_140214__$1,(37),inst_140186,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_140215 === (17))){
var inst_140208 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
var statearr_140248_140311 = state_140214__$1;
(statearr_140248_140311[(2)] = inst_140208);

(statearr_140248_140311[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (3))){
var inst_140072 = (state_140214[(2)]);
var inst_140073 = superv.async._unregister_go.call(null,S,id__136792__auto___140286);
var state_140214__$1 = (function (){var statearr_140249 = state_140214;
(statearr_140249[(21)] = inst_140073);

(statearr_140249[(22)] = inst_140072);

return statearr_140249;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140214__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (12))){
var inst_140103 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_140104 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_140105 = cljs.core.PersistentHashMap.fromArrays(inst_140103,inst_140104);
var inst_140106 = cljs.core.ex_info.call(null,"Aborted operations",inst_140105);
var state_140214__$1 = state_140214;
var statearr_140250_140312 = state_140214__$1;
(statearr_140250_140312[(2)] = inst_140106);

(statearr_140250_140312[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (2))){
var inst_140212 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_140214__$1,inst_140212);
} else {
if((state_val_140215 === (23))){
var inst_140110 = (state_140214[(12)]);
var state_140214__$1 = state_140214;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_140214__$1,(25),out_ch__$1,inst_140110);
} else {
if((state_val_140215 === (35))){
var state_140214__$1 = state_140214;
var statearr_140251_140313 = state_140214__$1;
(statearr_140251_140313[(2)] = null);

(statearr_140251_140313[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (19))){
var inst_140140 = (state_140214[(9)]);
var inst_140110 = (state_140214[(12)]);
var inst_140088 = (state_140214[(10)]);
var inst_140140__$1 = cljs.core.conj.call(null,inst_140088,inst_140110);
var inst_140141 = cljs.core.count.call(null,inst_140140__$1);
var inst_140142 = cljs.core._EQ_.call(null,n,inst_140141);
var state_140214__$1 = (function (){var statearr_140252 = state_140214;
(statearr_140252[(9)] = inst_140140__$1);

return statearr_140252;
})();
if(inst_140142){
var statearr_140253_140314 = state_140214__$1;
(statearr_140253_140314[(1)] = (26));

} else {
var statearr_140254_140315 = state_140214__$1;
(statearr_140254_140315[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (11))){
var inst_140093 = (state_140214[(23)]);
var inst_140098 = (state_140214[(2)]);
var inst_140099 = cljs.core.nth.call(null,inst_140098,(0),null);
var inst_140100 = cljs.core.nth.call(null,inst_140098,(1),null);
var inst_140101 = cljs.core._EQ_.call(null,inst_140100,inst_140093);
var state_140214__$1 = (function (){var statearr_140255 = state_140214;
(statearr_140255[(16)] = inst_140099);

return statearr_140255;
})();
if(inst_140101){
var statearr_140256_140316 = state_140214__$1;
(statearr_140256_140316[(1)] = (12));

} else {
var statearr_140257_140317 = state_140214__$1;
(statearr_140257_140317[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (9))){
var inst_140093 = (state_140214[(23)]);
var inst_140093__$1 = superv.async._abort.call(null,S);
var inst_140094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_140095 = [inst_140093__$1,in_ch];
var inst_140096 = (new cljs.core.PersistentVector(null,2,(5),inst_140094,inst_140095,null));
var state_140214__$1 = (function (){var statearr_140258 = state_140214;
(statearr_140258[(23)] = inst_140093__$1);

return statearr_140258;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_140214__$1,(11),inst_140096,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_140215 === (5))){
var state_140214__$1 = state_140214;
var statearr_140259_140318 = state_140214__$1;
(statearr_140259_140318[(2)] = null);

(statearr_140259_140318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (14))){
var inst_140110 = (state_140214[(12)]);
var inst_140109 = (state_140214[(2)]);
var inst_140110__$1 = superv.async.throw_if_exception.call(null,S,inst_140109);
var state_140214__$1 = (function (){var statearr_140260 = state_140214;
(statearr_140260[(12)] = inst_140110__$1);

return statearr_140260;
})();
if(cljs.core.truth_(inst_140110__$1)){
var statearr_140261_140319 = state_140214__$1;
(statearr_140261_140319[(1)] = (15));

} else {
var statearr_140262_140320 = state_140214__$1;
(statearr_140262_140320[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (26))){
var inst_140147 = (state_140214[(18)]);
var inst_140147__$1 = superv.async._abort.call(null,S);
var inst_140148 = cljs.core.async.timeout.call(null,(0));
var inst_140149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_140150 = [inst_140147__$1,inst_140148];
var inst_140151 = (new cljs.core.PersistentVector(null,2,(5),inst_140149,inst_140150,null));
var state_140214__$1 = (function (){var statearr_140263 = state_140214;
(statearr_140263[(18)] = inst_140147__$1);

return statearr_140263;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_140214__$1,(29),inst_140151,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_140215 === (16))){
var inst_140088 = (state_140214[(10)]);
var inst_140177 = cljs.core.not_empty.call(null,inst_140088);
var state_140214__$1 = state_140214;
if(cljs.core.truth_(inst_140177)){
var statearr_140264_140321 = state_140214__$1;
(statearr_140264_140321[(1)] = (34));

} else {
var statearr_140265_140322 = state_140214__$1;
(statearr_140265_140322[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (38))){
var inst_140193 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_140194 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_140195 = cljs.core.PersistentHashMap.fromArrays(inst_140193,inst_140194);
var inst_140196 = cljs.core.ex_info.call(null,"Aborted operations",inst_140195);
var state_140214__$1 = state_140214;
var statearr_140266_140323 = state_140214__$1;
(statearr_140266_140323[(2)] = inst_140196);

(statearr_140266_140323[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (30))){
var inst_140158 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_140159 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_140160 = cljs.core.PersistentHashMap.fromArrays(inst_140158,inst_140159);
var inst_140161 = cljs.core.ex_info.call(null,"Aborted operations",inst_140160);
var state_140214__$1 = state_140214;
var statearr_140267_140324 = state_140214__$1;
(statearr_140267_140324[(2)] = inst_140161);

(statearr_140267_140324[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (10))){
var inst_140210 = (state_140214[(2)]);
var state_140214__$1 = state_140214;
var statearr_140268_140325 = state_140214__$1;
(statearr_140268_140325[(2)] = inst_140210);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140214__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (18))){
var inst_140117 = (state_140214[(13)]);
var inst_140117__$1 = superv.async._abort.call(null,S);
var inst_140118 = cljs.core.async.timeout.call(null,(0));
var inst_140119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_140120 = [inst_140117__$1,inst_140118];
var inst_140121 = (new cljs.core.PersistentVector(null,2,(5),inst_140119,inst_140120,null));
var state_140214__$1 = (function (){var statearr_140269 = state_140214;
(statearr_140269[(13)] = inst_140117__$1);

return statearr_140269;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_140214__$1,(21),inst_140121,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_140215 === (37))){
var inst_140182 = (state_140214[(20)]);
var inst_140188 = (state_140214[(2)]);
var inst_140189 = cljs.core.nth.call(null,inst_140188,(0),null);
var inst_140190 = cljs.core.nth.call(null,inst_140188,(1),null);
var inst_140191 = cljs.core._EQ_.call(null,inst_140190,inst_140182);
var state_140214__$1 = (function (){var statearr_140270 = state_140214;
(statearr_140270[(24)] = inst_140189);

return statearr_140270;
})();
if(inst_140191){
var statearr_140271_140326 = state_140214__$1;
(statearr_140271_140326[(1)] = (38));

} else {
var statearr_140272_140327 = state_140214__$1;
(statearr_140272_140327[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140215 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_140214,(4),Error,(3),(2));
var inst_140087 = cljs.core.PersistentVector.EMPTY;
var inst_140088 = inst_140087;
var state_140214__$1 = (function (){var statearr_140273 = state_140214;
(statearr_140273[(10)] = inst_140088);

return statearr_140273;
})();
var statearr_140274_140328 = state_140214__$1;
(statearr_140274_140328[(2)] = null);

(statearr_140274_140328[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto___140287,c__136791__auto___140285,id__136792__auto___140286,out_ch__$1,map__140070,map__140070__$1,out_ch))
;
return ((function (switch__53560__auto__,c__53627__auto___140287,c__136791__auto___140285,id__136792__auto___140286,out_ch__$1,map__140070,map__140070__$1,out_ch){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_140278 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_140278[(0)] = superv$async$state_machine__53561__auto__);

(statearr_140278[(1)] = (1));

return statearr_140278;
});
var superv$async$state_machine__53561__auto____1 = (function (state_140214){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_140214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e140279){if((e140279 instanceof Object)){
var ex__53564__auto__ = e140279;
var statearr_140280_140329 = state_140214;
(statearr_140280_140329[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140214);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140279;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__140330 = state_140214;
state_140214 = G__140330;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_140214){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_140214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto___140287,c__136791__auto___140285,id__136792__auto___140286,out_ch__$1,map__140070,map__140070__$1,out_ch))
})();
var state__53629__auto__ = (function (){var statearr_140281 = f__53628__auto__.call(null);
(statearr_140281[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___140287);

return statearr_140281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto___140287,c__136791__auto___140285,id__136792__auto___140286,out_ch__$1,map__140070,map__140070__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq140065){
var G__140066 = cljs.core.first.call(null,seq140065);
var seq140065__$1 = cljs.core.next.call(null,seq140065);
var G__140067 = cljs.core.first.call(null,seq140065__$1);
var seq140065__$2 = cljs.core.next.call(null,seq140065__$1);
var G__140068 = cljs.core.first.call(null,seq140065__$2);
var seq140065__$3 = cljs.core.next.call(null,seq140065__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__140066,G__140067,G__140068,seq140065__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__136791__auto___140649 = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto___140650 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__53627__auto___140651 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto___140651,c__136791__auto___140649,id__136792__auto___140650,out){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto___140651,c__136791__auto___140649,id__136792__auto___140650,out){
return (function (state_140595){
var state_val_140596 = (state_140595[(1)]);
if((state_val_140596 === (7))){
var inst_140493 = (state_140595[(7)]);
var inst_140501 = (state_140595[(2)]);
var state_140595__$1 = (function (){var statearr_140597 = state_140595;
(statearr_140597[(8)] = inst_140501);

return statearr_140597;
})();
var statearr_140598_140652 = state_140595__$1;
(statearr_140598_140652[(2)] = inst_140493);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140595__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (20))){
var inst_140589 = (state_140595[(2)]);
var state_140595__$1 = state_140595;
var statearr_140599_140653 = state_140595__$1;
(statearr_140599_140653[(2)] = inst_140589);

(statearr_140599_140653[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (27))){
var inst_140573 = (state_140595[(2)]);
var inst_140574 = superv.async.throw_if_exception.call(null,S,inst_140573);
var inst_140505 = null;
var state_140595__$1 = (function (){var statearr_140600 = state_140595;
(statearr_140600[(9)] = inst_140505);

(statearr_140600[(10)] = inst_140574);

return statearr_140600;
})();
var statearr_140601_140654 = state_140595__$1;
(statearr_140601_140654[(2)] = null);

(statearr_140601_140654[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (1))){
var state_140595__$1 = state_140595;
var statearr_140602_140655 = state_140595__$1;
(statearr_140602_140655[(2)] = null);

(statearr_140602_140655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (24))){
var inst_140554 = (state_140595[(11)]);
var inst_140560 = (state_140595[(2)]);
var inst_140561 = cljs.core.nth.call(null,inst_140560,(0),null);
var inst_140562 = cljs.core.nth.call(null,inst_140560,(1),null);
var inst_140563 = cljs.core._EQ_.call(null,inst_140562,inst_140554);
var state_140595__$1 = (function (){var statearr_140603 = state_140595;
(statearr_140603[(12)] = inst_140561);

return statearr_140603;
})();
if(inst_140563){
var statearr_140604_140656 = state_140595__$1;
(statearr_140604_140656[(1)] = (25));

} else {
var statearr_140605_140657 = state_140595__$1;
(statearr_140605_140657[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (4))){
var inst_140493 = (state_140595[(7)]);
var inst_140493__$1 = (state_140595[(2)]);
var inst_140494 = cljs.core.ex_data.call(null,inst_140493__$1);
var inst_140495 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_140494);
var inst_140496 = cljs.core._EQ_.call(null,inst_140495,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_140595__$1 = (function (){var statearr_140606 = state_140595;
(statearr_140606[(7)] = inst_140493__$1);

return statearr_140606;
})();
if(inst_140496){
var statearr_140607_140658 = state_140595__$1;
(statearr_140607_140658[(1)] = (5));

} else {
var statearr_140608_140659 = state_140595__$1;
(statearr_140608_140659[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (15))){
var inst_140522 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_140523 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_140524 = cljs.core.PersistentHashMap.fromArrays(inst_140522,inst_140523);
var inst_140525 = cljs.core.ex_info.call(null,"Aborted operations",inst_140524);
var state_140595__$1 = state_140595;
var statearr_140609_140660 = state_140595__$1;
(statearr_140609_140660[(2)] = inst_140525);

(statearr_140609_140660[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (21))){
var inst_140554 = (state_140595[(11)]);
var inst_140554__$1 = superv.async._abort.call(null,S);
var inst_140555 = cljs.core.async.timeout.call(null,(0));
var inst_140556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_140557 = [inst_140554__$1,inst_140555];
var inst_140558 = (new cljs.core.PersistentVector(null,2,(5),inst_140556,inst_140557,null));
var state_140595__$1 = (function (){var statearr_140610 = state_140595;
(statearr_140610[(11)] = inst_140554__$1);

return statearr_140610;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_140595__$1,(24),inst_140558,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_140596 === (31))){
var inst_140585 = (state_140595[(2)]);
var state_140595__$1 = state_140595;
var statearr_140611_140661 = state_140595__$1;
(statearr_140611_140661[(2)] = inst_140585);

(statearr_140611_140661[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (13))){
var inst_140531 = (state_140595[(13)]);
var inst_140531__$1 = (state_140595[(2)]);
var inst_140532 = cljs.core.async.timeout.call(null,interval);
var inst_140533 = (inst_140531__$1 == null);
var state_140595__$1 = (function (){var statearr_140612 = state_140595;
(statearr_140612[(14)] = inst_140532);

(statearr_140612[(13)] = inst_140531__$1);

return statearr_140612;
})();
if(cljs.core.truth_(inst_140533)){
var statearr_140613_140662 = state_140595__$1;
(statearr_140613_140662[(1)] = (18));

} else {
var statearr_140614_140663 = state_140595__$1;
(statearr_140614_140663[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (22))){
var inst_140545 = (state_140595[(15)]);
var inst_140577 = cljs.core._EQ_.call(null,inst_140545,inst_140545);
var state_140595__$1 = state_140595;
if(inst_140577){
var statearr_140615_140664 = state_140595__$1;
(statearr_140615_140664[(1)] = (29));

} else {
var statearr_140616_140665 = state_140595__$1;
(statearr_140616_140665[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (29))){
var inst_140544 = (state_140595[(16)]);
var inst_140505 = inst_140544;
var state_140595__$1 = (function (){var statearr_140617 = state_140595;
(statearr_140617[(9)] = inst_140505);

return statearr_140617;
})();
var statearr_140618_140666 = state_140595__$1;
(statearr_140618_140666[(2)] = null);

(statearr_140618_140666[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (6))){
var inst_140493 = (state_140595[(7)]);
var inst_140499 = superv.async._track_exception.call(null,S,inst_140493);
var state_140595__$1 = state_140595;
var statearr_140619_140667 = state_140595__$1;
(statearr_140619_140667[(2)] = inst_140499);

(statearr_140619_140667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (28))){
var inst_140571 = (state_140595[(2)]);
var state_140595__$1 = state_140595;
var statearr_140620_140668 = state_140595__$1;
(statearr_140620_140668[(2)] = inst_140571);

(statearr_140620_140668[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (25))){
var inst_140565 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_140566 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_140567 = cljs.core.PersistentHashMap.fromArrays(inst_140565,inst_140566);
var inst_140568 = cljs.core.ex_info.call(null,"Aborted operations",inst_140567);
var state_140595__$1 = state_140595;
var statearr_140621_140669 = state_140595__$1;
(statearr_140621_140669[(2)] = inst_140568);

(statearr_140621_140669[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (17))){
var inst_140528 = (state_140595[(2)]);
var inst_140529 = superv.async.throw_if_exception.call(null,S,inst_140528);
var state_140595__$1 = state_140595;
var statearr_140622_140670 = state_140595__$1;
(statearr_140622_140670[(2)] = inst_140529);

(statearr_140622_140670[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (3))){
var inst_140490 = (state_140595[(2)]);
var inst_140491 = superv.async._unregister_go.call(null,S,id__136792__auto___140650);
var state_140595__$1 = (function (){var statearr_140623 = state_140595;
(statearr_140623[(17)] = inst_140490);

(statearr_140623[(18)] = inst_140491);

return statearr_140623;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140595__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (12))){
var inst_140512 = (state_140595[(19)]);
var inst_140512__$1 = superv.async._abort.call(null,S);
var inst_140513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_140514 = [inst_140512__$1,ch];
var inst_140515 = (new cljs.core.PersistentVector(null,2,(5),inst_140513,inst_140514,null));
var state_140595__$1 = (function (){var statearr_140624 = state_140595;
(statearr_140624[(19)] = inst_140512__$1);

return statearr_140624;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_140595__$1,(14),inst_140515,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_140596 === (2))){
var inst_140593 = (state_140595[(2)]);
var state_140595__$1 = state_140595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_140595__$1,inst_140593);
} else {
if((state_val_140596 === (23))){
var inst_140587 = (state_140595[(2)]);
var state_140595__$1 = state_140595;
var statearr_140625_140671 = state_140595__$1;
(statearr_140625_140671[(2)] = inst_140587);

(statearr_140625_140671[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (19))){
var inst_140532 = (state_140595[(14)]);
var inst_140545 = (state_140595[(15)]);
var inst_140540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_140541 = [ch,inst_140532];
var inst_140542 = (new cljs.core.PersistentVector(null,2,(5),inst_140540,inst_140541,null));
var inst_140543 = superv.async.alts_QMARK_.call(null,S,inst_140542);
var inst_140544 = cljs.core.nth.call(null,inst_140543,(0),null);
var inst_140545__$1 = cljs.core.nth.call(null,inst_140543,(1),null);
var inst_140549 = cljs.core._EQ_.call(null,inst_140532,inst_140545__$1);
var state_140595__$1 = (function (){var statearr_140626 = state_140595;
(statearr_140626[(16)] = inst_140544);

(statearr_140626[(15)] = inst_140545__$1);

return statearr_140626;
})();
if(inst_140549){
var statearr_140627_140672 = state_140595__$1;
(statearr_140627_140672[(1)] = (21));

} else {
var statearr_140628_140673 = state_140595__$1;
(statearr_140628_140673[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (11))){
var inst_140505 = (state_140595[(9)]);
var state_140595__$1 = state_140595;
var statearr_140629_140674 = state_140595__$1;
(statearr_140629_140674[(2)] = inst_140505);

(statearr_140629_140674[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (9))){
var inst_140505 = (state_140595[(9)]);
var state_140595__$1 = state_140595;
if(cljs.core.truth_(inst_140505)){
var statearr_140630_140675 = state_140595__$1;
(statearr_140630_140675[(1)] = (11));

} else {
var statearr_140631_140676 = state_140595__$1;
(statearr_140631_140676[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (5))){
var state_140595__$1 = state_140595;
var statearr_140632_140677 = state_140595__$1;
(statearr_140632_140677[(2)] = null);

(statearr_140632_140677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (14))){
var inst_140512 = (state_140595[(19)]);
var inst_140517 = (state_140595[(2)]);
var inst_140518 = cljs.core.nth.call(null,inst_140517,(0),null);
var inst_140519 = cljs.core.nth.call(null,inst_140517,(1),null);
var inst_140520 = cljs.core._EQ_.call(null,inst_140519,inst_140512);
var state_140595__$1 = (function (){var statearr_140633 = state_140595;
(statearr_140633[(20)] = inst_140518);

return statearr_140633;
})();
if(inst_140520){
var statearr_140634_140678 = state_140595__$1;
(statearr_140634_140678[(1)] = (15));

} else {
var statearr_140635_140679 = state_140595__$1;
(statearr_140635_140679[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (26))){
var inst_140531 = (state_140595[(13)]);
var state_140595__$1 = state_140595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_140595__$1,(28),out,inst_140531);
} else {
if((state_val_140596 === (16))){
var inst_140518 = (state_140595[(20)]);
var state_140595__$1 = state_140595;
var statearr_140636_140680 = state_140595__$1;
(statearr_140636_140680[(2)] = inst_140518);

(statearr_140636_140680[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (30))){
var inst_140545 = (state_140595[(15)]);
var inst_140581 = [cljs.core.str("No matching clause: "),cljs.core.str(inst_140545)].join('');
var inst_140582 = (new Error(inst_140581));
var inst_140583 = (function(){throw inst_140582})();
var state_140595__$1 = state_140595;
var statearr_140637_140681 = state_140595__$1;
(statearr_140637_140681[(2)] = inst_140583);

(statearr_140637_140681[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (10))){
var inst_140591 = (state_140595[(2)]);
var state_140595__$1 = state_140595;
var statearr_140638_140682 = state_140595__$1;
(statearr_140638_140682[(2)] = inst_140591);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140595__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (18))){
var inst_140535 = cljs.core.async.close_BANG_.call(null,out);
var state_140595__$1 = state_140595;
var statearr_140639_140683 = state_140595__$1;
(statearr_140639_140683[(2)] = inst_140535);

(statearr_140639_140683[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140596 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_140595,(4),Error,(3),(2));
var inst_140505 = null;
var state_140595__$1 = (function (){var statearr_140640 = state_140595;
(statearr_140640[(9)] = inst_140505);

return statearr_140640;
})();
var statearr_140641_140684 = state_140595__$1;
(statearr_140641_140684[(2)] = null);

(statearr_140641_140684[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto___140651,c__136791__auto___140649,id__136792__auto___140650,out))
;
return ((function (switch__53560__auto__,c__53627__auto___140651,c__136791__auto___140649,id__136792__auto___140650,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__53561__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__53561__auto____0 = (function (){
var statearr_140645 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_140645[(0)] = superv$async$debounce_GT__GT__$_state_machine__53561__auto__);

(statearr_140645[(1)] = (1));

return statearr_140645;
});
var superv$async$debounce_GT__GT__$_state_machine__53561__auto____1 = (function (state_140595){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_140595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e140646){if((e140646 instanceof Object)){
var ex__53564__auto__ = e140646;
var statearr_140647_140685 = state_140595;
(statearr_140647_140685[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140646;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__140686 = state_140595;
state_140595 = G__140686;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__53561__auto__ = function(state_140595){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__53561__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__53561__auto____1.call(this,state_140595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$debounce_GT__GT__$_state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__53561__auto____0;
superv$async$debounce_GT__GT__$_state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__53561__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto___140651,c__136791__auto___140649,id__136792__auto___140650,out))
})();
var state__53629__auto__ = (function (){var statearr_140648 = f__53628__auto__.call(null);
(statearr_140648[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___140651);

return statearr_140648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto___140651,c__136791__auto___140649,id__136792__auto___140650,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args140687 = [];
var len__51155__auto___140825 = arguments.length;
var i__51156__auto___140826 = (0);
while(true){
if((i__51156__auto___140826 < len__51155__auto___140825)){
args140687.push((arguments[i__51156__auto___140826]));

var G__140827 = (i__51156__auto___140826 + (1));
i__51156__auto___140826 = G__140827;
continue;
} else {
}
break;
}

var G__140689 = args140687.length;
switch (G__140689) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args140687.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__136791__auto___140829 = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto___140830 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__53627__auto___140831 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830){
return (function (state_140768){
var state_val_140769 = (state_140768[(1)]);
if((state_val_140769 === (7))){
var inst_140693 = (state_140768[(7)]);
var inst_140701 = (state_140768[(2)]);
var state_140768__$1 = (function (){var statearr_140770 = state_140768;
(statearr_140770[(8)] = inst_140701);

return statearr_140770;
})();
var statearr_140771_140832 = state_140768__$1;
(statearr_140771_140832[(2)] = inst_140693);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140768__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (1))){
var state_140768__$1 = state_140768;
var statearr_140772_140833 = state_140768__$1;
(statearr_140772_140833[(2)] = null);

(statearr_140772_140833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (4))){
var inst_140693 = (state_140768[(7)]);
var inst_140693__$1 = (state_140768[(2)]);
var inst_140694 = cljs.core.ex_data.call(null,inst_140693__$1);
var inst_140695 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_140694);
var inst_140696 = cljs.core._EQ_.call(null,inst_140695,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_140768__$1 = (function (){var statearr_140773 = state_140768;
(statearr_140773[(7)] = inst_140693__$1);

return statearr_140773;
})();
if(inst_140696){
var statearr_140774_140834 = state_140768__$1;
(statearr_140774_140834[(1)] = (5));

} else {
var statearr_140775_140835 = state_140768__$1;
(statearr_140775_140835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (15))){
var inst_140717 = (state_140768[(2)]);
var state_140768__$1 = state_140768;
var statearr_140776_140836 = state_140768__$1;
(statearr_140776_140836[(2)] = inst_140717);

(statearr_140776_140836[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (13))){
var state_140768__$1 = state_140768;
var statearr_140777_140837 = state_140768__$1;
(statearr_140777_140837[(2)] = null);

(statearr_140777_140837[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (6))){
var inst_140693 = (state_140768[(7)]);
var inst_140699 = superv.async._track_exception.call(null,S,inst_140693);
var state_140768__$1 = state_140768;
var statearr_140778_140838 = state_140768__$1;
(statearr_140778_140838[(2)] = inst_140699);

(statearr_140778_140838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (3))){
var inst_140690 = (state_140768[(2)]);
var inst_140691 = superv.async._unregister_go.call(null,S,id__136792__auto___140830);
var state_140768__$1 = (function (){var statearr_140779 = state_140768;
(statearr_140779[(9)] = inst_140691);

(statearr_140779[(10)] = inst_140690);

return statearr_140779;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140768__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (12))){
var inst_140712 = (state_140768[(2)]);
var state_140768__$1 = state_140768;
if(cljs.core.truth_(inst_140712)){
var statearr_140780_140839 = state_140768__$1;
(statearr_140780_140839[(1)] = (13));

} else {
var statearr_140781_140840 = state_140768__$1;
(statearr_140781_140840[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (2))){
var inst_140766 = (state_140768[(2)]);
var state_140768__$1 = state_140768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_140768__$1,inst_140766);
} else {
if((state_val_140769 === (11))){
var inst_140709 = (state_140768[(11)]);
var inst_140719 = (state_140768[(2)]);
var inst_140720 = null;
var inst_140721 = superv.async._register_go.call(null,inst_140719,inst_140720);
var inst_140762 = cljs.core.async.chan.call(null,(1));
var inst_140763 = (function (){var c__136791__auto____$1 = inst_140709;
var id__136792__auto____$1 = inst_140721;
var c__53627__auto____$1 = inst_140762;
return ((function (c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140709,inst_140719,inst_140720,inst_140721,inst_140762,state_val_140769,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140709,inst_140719,inst_140720,inst_140721,inst_140762,state_val_140769,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830){
return (function (state_140760){
var state_val_140761 = (state_140760[(1)]);
if((state_val_140761 === (7))){
var state_140760__$1 = state_140760;
var statearr_140782_140841 = state_140760__$1;
(statearr_140782_140841[(2)] = null);

(statearr_140782_140841[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_140760,(10),Error,(3),(2));
var state_140760__$1 = state_140760;
var statearr_140783_140842 = state_140760__$1;
(statearr_140783_140842[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140760__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (1))){
var state_140760__$1 = state_140760;
var statearr_140784_140843 = state_140760__$1;
(statearr_140784_140843[(2)] = null);

(statearr_140784_140843[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (4))){
var state_140760__$1 = state_140760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_140760__$1,(6),ch);
} else {
if((state_val_140761 === (15))){
var inst_140735 = (state_140760[(7)]);
var inst_140750 = (state_140760[(2)]);
var inst_140751 = superv.async._track_exception.call(null,inst_140750,inst_140735);
var state_140760__$1 = state_140760;
var statearr_140785_140844 = state_140760__$1;
(statearr_140785_140844[(2)] = inst_140751);

(statearr_140785_140844[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (13))){
var inst_140735 = (state_140760[(7)]);
var inst_140753 = (state_140760[(2)]);
var state_140760__$1 = (function (){var statearr_140786 = state_140760;
(statearr_140786[(8)] = inst_140753);

return statearr_140786;
})();
var statearr_140787_140845 = state_140760__$1;
(statearr_140787_140845[(2)] = inst_140735);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140760__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (6))){
var inst_140725 = (state_140760[(2)]);
var state_140760__$1 = state_140760;
if(cljs.core.truth_(inst_140725)){
var statearr_140788_140846 = state_140760__$1;
(statearr_140788_140846[(1)] = (7));

} else {
var statearr_140789_140847 = state_140760__$1;
(statearr_140789_140847[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (17))){
var state_140760__$1 = state_140760;
var statearr_140790_140848 = state_140760__$1;
(statearr_140790_140848[(2)] = null);

(statearr_140790_140848[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (3))){
var inst_140722 = (state_140760[(2)]);
var state_140760__$1 = (function (){var statearr_140791 = state_140760;
(statearr_140791[(9)] = inst_140722);

return statearr_140791;
})();
var statearr_140792_140849 = state_140760__$1;
(statearr_140792_140849[(2)] = null);

(statearr_140792_140849[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (12))){
var state_140760__$1 = state_140760;
var statearr_140793_140850 = state_140760__$1;
(statearr_140793_140850[(2)] = null);

(statearr_140793_140850[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (2))){
var inst_140758 = (state_140760[(2)]);
var state_140760__$1 = state_140760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_140760__$1,inst_140758);
} else {
if((state_val_140761 === (19))){
var inst_140748 = (state_140760[(2)]);
var state_140760__$1 = state_140760;
var statearr_140794_140851 = state_140760__$1;
(statearr_140794_140851[(2)] = inst_140748);

(statearr_140794_140851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (11))){
var state_140760__$1 = state_140760;
var statearr_140795_140852 = state_140760__$1;
(statearr_140795_140852[(2)] = null);

(statearr_140795_140852[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (9))){
var inst_140730 = (state_140760[(2)]);
var state_140760__$1 = state_140760;
var statearr_140796_140853 = state_140760__$1;
(statearr_140796_140853[(2)] = inst_140730);

(statearr_140796_140853[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (5))){
var inst_140732 = (state_140760[(2)]);
var inst_140733 = superv.async._unregister_go.call(null,inst_140732,id__136792__auto____$1);
var state_140760__$1 = (function (){var statearr_140797 = state_140760;
(statearr_140797[(10)] = inst_140733);

return statearr_140797;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140760__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (14))){
var state_140760__$1 = state_140760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_140760__$1,(16),ch);
} else {
if((state_val_140761 === (16))){
var inst_140743 = (state_140760[(2)]);
var state_140760__$1 = state_140760;
if(cljs.core.truth_(inst_140743)){
var statearr_140798_140854 = state_140760__$1;
(statearr_140798_140854[(1)] = (17));

} else {
var statearr_140799_140855 = state_140760__$1;
(statearr_140799_140855[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (10))){
var inst_140735 = (state_140760[(7)]);
var inst_140735__$1 = (state_140760[(2)]);
var inst_140736 = cljs.core.ex_data.call(null,inst_140735__$1);
var inst_140737 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_140736);
var inst_140738 = cljs.core._EQ_.call(null,inst_140737,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_140760__$1 = (function (){var statearr_140800 = state_140760;
(statearr_140800[(7)] = inst_140735__$1);

return statearr_140800;
})();
if(inst_140738){
var statearr_140801_140856 = state_140760__$1;
(statearr_140801_140856[(1)] = (11));

} else {
var statearr_140802_140857 = state_140760__$1;
(statearr_140802_140857[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (18))){
var state_140760__$1 = state_140760;
var statearr_140803_140858 = state_140760__$1;
(statearr_140803_140858[(2)] = null);

(statearr_140803_140858[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140761 === (8))){
var state_140760__$1 = state_140760;
var statearr_140804_140859 = state_140760__$1;
(statearr_140804_140859[(2)] = null);

(statearr_140804_140859[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140709,inst_140719,inst_140720,inst_140721,inst_140762,state_val_140769,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830))
;
return ((function (switch__53560__auto__,c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140709,inst_140719,inst_140720,inst_140721,inst_140762,state_val_140769,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_140808 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_140808[(0)] = superv$async$state_machine__53561__auto__);

(statearr_140808[(1)] = (1));

return statearr_140808;
});
var superv$async$state_machine__53561__auto____1 = (function (state_140760){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_140760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e140809){if((e140809 instanceof Object)){
var ex__53564__auto__ = e140809;
var statearr_140810_140860 = state_140760;
(statearr_140810_140860[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__140861 = state_140760;
state_140760 = G__140861;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_140760){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_140760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140709,inst_140719,inst_140720,inst_140721,inst_140762,state_val_140769,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830))
})();
var state__53629__auto__ = (function (){var statearr_140811 = f__53628__auto__.call(null);
(statearr_140811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto____$1);

return statearr_140811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});
;})(c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140709,inst_140719,inst_140720,inst_140721,inst_140762,state_val_140769,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830))
})();
var inst_140764 = cljs.core.async.impl.dispatch.run.call(null,inst_140763);
var state_140768__$1 = (function (){var statearr_140812 = state_140768;
(statearr_140812[(12)] = inst_140764);

return statearr_140812;
})();
var statearr_140813_140862 = state_140768__$1;
(statearr_140813_140862[(2)] = inst_140762);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140768__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (9))){
var inst_140707 = (state_140768[(2)]);
var inst_140708 = cljs.core.async.close_BANG_.call(null,ch);
var inst_140709 = superv.async.check_supervisor.call(null,superv.async.S);
var state_140768__$1 = (function (){var statearr_140814 = state_140768;
(statearr_140814[(11)] = inst_140709);

(statearr_140814[(13)] = inst_140707);

(statearr_140814[(14)] = inst_140708);

return statearr_140814;
})();
var statearr_140815_140863 = state_140768__$1;
(statearr_140815_140863[(2)] = null);

(statearr_140815_140863[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (5))){
var state_140768__$1 = state_140768;
var statearr_140816_140864 = state_140768__$1;
(statearr_140816_140864[(2)] = null);

(statearr_140816_140864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (14))){
var state_140768__$1 = state_140768;
var statearr_140817_140865 = state_140768__$1;
(statearr_140817_140865[(2)] = null);

(statearr_140817_140865[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140769 === (10))){
var state_140768__$1 = state_140768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_140768__$1,(12),ch);
} else {
if((state_val_140769 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_140768,(4),Error,(3),(2));
var inst_140705 = superv.async._abort.call(null,S);
var state_140768__$1 = state_140768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_140768__$1,(9),inst_140705);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830))
;
return ((function (switch__53560__auto__,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_140821 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_140821[(0)] = superv$async$state_machine__53561__auto__);

(statearr_140821[(1)] = (1));

return statearr_140821;
});
var superv$async$state_machine__53561__auto____1 = (function (state_140768){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_140768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e140822){if((e140822 instanceof Object)){
var ex__53564__auto__ = e140822;
var statearr_140823_140866 = state_140768;
(statearr_140823_140866[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140768);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__140867 = state_140768;
state_140768 = G__140867;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_140768){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_140768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830))
})();
var state__53629__auto__ = (function (){var statearr_140824 = f__53628__auto__.call(null);
(statearr_140824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___140831);

return statearr_140824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto___140831,c__136791__auto___140829,id__136792__auto___140830))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args140868 = [];
var len__51155__auto___140972 = arguments.length;
var i__51156__auto___140973 = (0);
while(true){
if((i__51156__auto___140973 < len__51155__auto___140972)){
args140868.push((arguments[i__51156__auto___140973]));

var G__140974 = (i__51156__auto___140973 + (1));
i__51156__auto___140973 = G__140974;
continue;
} else {
}
break;
}

var G__140870 = args140868.length;
switch (G__140870) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args140868.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__136791__auto___140976 = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto___140977 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__53627__auto___140978 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977){
return (function (state_140929){
var state_val_140930 = (state_140929[(1)]);
if((state_val_140930 === (1))){
var state_140929__$1 = state_140929;
var statearr_140931_140979 = state_140929__$1;
(statearr_140931_140979[(2)] = null);

(statearr_140931_140979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140930 === (2))){
var inst_140927 = (state_140929[(2)]);
var state_140929__$1 = state_140929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_140929__$1,inst_140927);
} else {
if((state_val_140930 === (3))){
var inst_140871 = (state_140929[(2)]);
var inst_140872 = superv.async._unregister_go.call(null,S,id__136792__auto___140977);
var state_140929__$1 = (function (){var statearr_140932 = state_140929;
(statearr_140932[(7)] = inst_140872);

(statearr_140932[(8)] = inst_140871);

return statearr_140932;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140929__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140930 === (4))){
var inst_140874 = (state_140929[(9)]);
var inst_140874__$1 = (state_140929[(2)]);
var inst_140875 = cljs.core.ex_data.call(null,inst_140874__$1);
var inst_140876 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_140875);
var inst_140877 = cljs.core._EQ_.call(null,inst_140876,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_140929__$1 = (function (){var statearr_140933 = state_140929;
(statearr_140933[(9)] = inst_140874__$1);

return statearr_140933;
})();
if(inst_140877){
var statearr_140934_140980 = state_140929__$1;
(statearr_140934_140980[(1)] = (5));

} else {
var statearr_140935_140981 = state_140929__$1;
(statearr_140935_140981[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140930 === (5))){
var state_140929__$1 = state_140929;
var statearr_140936_140982 = state_140929__$1;
(statearr_140936_140982[(2)] = null);

(statearr_140936_140982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140930 === (6))){
var inst_140874 = (state_140929[(9)]);
var inst_140880 = superv.async._track_exception.call(null,S,inst_140874);
var state_140929__$1 = state_140929;
var statearr_140937_140983 = state_140929__$1;
(statearr_140937_140983[(2)] = inst_140880);

(statearr_140937_140983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140930 === (7))){
var inst_140874 = (state_140929[(9)]);
var inst_140882 = (state_140929[(2)]);
var state_140929__$1 = (function (){var statearr_140938 = state_140929;
(statearr_140938[(10)] = inst_140882);

return statearr_140938;
})();
var statearr_140939_140984 = state_140929__$1;
(statearr_140939_140984[(2)] = inst_140874);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140929__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140930 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_140929,(4),Error,(3),(2));
var inst_140886 = superv.async._abort.call(null,S);
var state_140929__$1 = state_140929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_140929__$1,(9),inst_140886);
} else {
if((state_val_140930 === (9))){
var inst_140888 = (state_140929[(2)]);
var inst_140889 = cljs.core.async.close_BANG_.call(null,ch);
var inst_140890 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_140891 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_140892 = superv.async._register_go.call(null,S,inst_140891);
var inst_140923 = cljs.core.async.chan.call(null,(1));
var inst_140924 = (function (){var c__136791__auto____$1 = inst_140890;
var id__136792__auto____$1 = inst_140892;
var c__53627__auto____$1 = inst_140923;
return ((function (c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140888,inst_140889,inst_140890,inst_140891,inst_140892,inst_140923,state_val_140930,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140888,inst_140889,inst_140890,inst_140891,inst_140892,inst_140923,state_val_140930,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977){
return (function (state_140921){
var state_val_140922 = (state_140921[(1)]);
if((state_val_140922 === (7))){
var inst_140896 = (state_140921[(7)]);
var inst_140904 = (state_140921[(2)]);
var state_140921__$1 = (function (){var statearr_140940 = state_140921;
(statearr_140940[(8)] = inst_140904);

return statearr_140940;
})();
var statearr_140941_140985 = state_140921__$1;
(statearr_140941_140985[(2)] = inst_140896);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140921__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (1))){
var state_140921__$1 = state_140921;
var statearr_140942_140986 = state_140921__$1;
(statearr_140942_140986[(2)] = null);

(statearr_140942_140986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (4))){
var inst_140896 = (state_140921[(7)]);
var inst_140896__$1 = (state_140921[(2)]);
var inst_140897 = cljs.core.ex_data.call(null,inst_140896__$1);
var inst_140898 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_140897);
var inst_140899 = cljs.core._EQ_.call(null,inst_140898,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_140921__$1 = (function (){var statearr_140943 = state_140921;
(statearr_140943[(7)] = inst_140896__$1);

return statearr_140943;
})();
if(inst_140899){
var statearr_140944_140987 = state_140921__$1;
(statearr_140944_140987[(1)] = (5));

} else {
var statearr_140945_140988 = state_140921__$1;
(statearr_140945_140988[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (13))){
var state_140921__$1 = state_140921;
var statearr_140946_140989 = state_140921__$1;
(statearr_140946_140989[(2)] = null);

(statearr_140946_140989[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (6))){
var inst_140896 = (state_140921[(7)]);
var inst_140902 = superv.async._track_exception.call(null,S,inst_140896);
var state_140921__$1 = state_140921;
var statearr_140947_140990 = state_140921__$1;
(statearr_140947_140990[(2)] = inst_140902);

(statearr_140947_140990[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (3))){
var inst_140893 = (state_140921[(2)]);
var inst_140894 = superv.async._unregister_go.call(null,S,id__136792__auto____$1);
var state_140921__$1 = (function (){var statearr_140948 = state_140921;
(statearr_140948[(9)] = inst_140893);

(statearr_140948[(10)] = inst_140894);

return statearr_140948;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140921__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (12))){
var state_140921__$1 = state_140921;
var statearr_140949_140991 = state_140921__$1;
(statearr_140949_140991[(2)] = null);

(statearr_140949_140991[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (2))){
var inst_140919 = (state_140921[(2)]);
var state_140921__$1 = state_140921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_140921__$1,inst_140919);
} else {
if((state_val_140922 === (11))){
var inst_140910 = (state_140921[(2)]);
var state_140921__$1 = state_140921;
if(cljs.core.truth_(inst_140910)){
var statearr_140950_140992 = state_140921__$1;
(statearr_140950_140992[(1)] = (12));

} else {
var statearr_140951_140993 = state_140921__$1;
(statearr_140951_140993[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (9))){
var state_140921__$1 = state_140921;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_140921__$1,(11),ch);
} else {
if((state_val_140922 === (5))){
var state_140921__$1 = state_140921;
var statearr_140952_140994 = state_140921__$1;
(statearr_140952_140994[(2)] = null);

(statearr_140952_140994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (14))){
var inst_140915 = (state_140921[(2)]);
var state_140921__$1 = state_140921;
var statearr_140953_140995 = state_140921__$1;
(statearr_140953_140995[(2)] = inst_140915);

(statearr_140953_140995[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (10))){
var inst_140917 = (state_140921[(2)]);
var state_140921__$1 = state_140921;
var statearr_140954_140996 = state_140921__$1;
(statearr_140954_140996[(2)] = inst_140917);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140921__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_140922 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_140921,(4),Error,(3),(2));
var state_140921__$1 = state_140921;
var statearr_140955_140997 = state_140921__$1;
(statearr_140955_140997[(2)] = null);

(statearr_140955_140997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140888,inst_140889,inst_140890,inst_140891,inst_140892,inst_140923,state_val_140930,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977))
;
return ((function (switch__53560__auto__,c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140888,inst_140889,inst_140890,inst_140891,inst_140892,inst_140923,state_val_140930,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_140959 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_140959[(0)] = superv$async$state_machine__53561__auto__);

(statearr_140959[(1)] = (1));

return statearr_140959;
});
var superv$async$state_machine__53561__auto____1 = (function (state_140921){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_140921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e140960){if((e140960 instanceof Object)){
var ex__53564__auto__ = e140960;
var statearr_140961_140998 = state_140921;
(statearr_140961_140998[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140921);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140960;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__140999 = state_140921;
state_140921 = G__140999;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_140921){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_140921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140888,inst_140889,inst_140890,inst_140891,inst_140892,inst_140923,state_val_140930,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977))
})();
var state__53629__auto__ = (function (){var statearr_140962 = f__53628__auto__.call(null);
(statearr_140962[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto____$1);

return statearr_140962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});
;})(c__136791__auto____$1,id__136792__auto____$1,c__53627__auto____$1,inst_140888,inst_140889,inst_140890,inst_140891,inst_140892,inst_140923,state_val_140930,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977))
})();
var inst_140925 = cljs.core.async.impl.dispatch.run.call(null,inst_140924);
var state_140929__$1 = (function (){var statearr_140963 = state_140929;
(statearr_140963[(11)] = inst_140888);

(statearr_140963[(12)] = inst_140925);

(statearr_140963[(13)] = inst_140889);

return statearr_140963;
})();
var statearr_140964_141000 = state_140929__$1;
(statearr_140964_141000[(2)] = inst_140923);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140929__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977))
;
return ((function (switch__53560__auto__,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_140968 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_140968[(0)] = superv$async$state_machine__53561__auto__);

(statearr_140968[(1)] = (1));

return statearr_140968;
});
var superv$async$state_machine__53561__auto____1 = (function (state_140929){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_140929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e140969){if((e140969 instanceof Object)){
var ex__53564__auto__ = e140969;
var statearr_140970_141001 = state_140929;
(statearr_140970_141001[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_140929);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e140969;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__141002 = state_140929;
state_140929 = G__141002;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_140929){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_140929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977))
})();
var state__53629__auto__ = (function (){var statearr_140971 = f__53628__auto__.call(null);
(statearr_140971[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___140978);

return statearr_140971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto___140978,c__136791__auto___140976,id__136792__auto___140977))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__51162__auto__ = [];
var len__51155__auto___141310 = arguments.length;
var i__51156__auto___141311 = (0);
while(true){
if((i__51156__auto___141311 < len__51155__auto___141310)){
args__51162__auto__.push((arguments[i__51156__auto___141311]));

var G__141312 = (i__51156__auto___141311 + (1));
i__51156__auto___141311 = G__141312;
continue;
} else {
}
break;
}

var argseq__51163__auto__ = ((((1) < args__51162__auto__.length))?(new cljs.core.IndexedSeq(args__51162__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__51163__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__141017){
var map__141018 = p__141017;
var map__141018__$1 = ((((!((map__141018 == null)))?((((map__141018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__141018.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__141018):map__141018);
var retries = cljs.core.get.call(null,map__141018__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__141018__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__141018__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__141018__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__141018__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__141018__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__141018__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__49939__auto__ = retries;
if(cljs.core.truth_(or__49939__auto__)){
return or__49939__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__53627__auto___141313 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_141209){
var state_val_141210 = (state_141209[(1)]);
if((state_val_141210 === (7))){
var inst_141024 = (state_141209[(7)]);
var inst_141152 = (state_141209[(2)]);
var inst_141153 = cljs.core.nth.call(null,inst_141152,(0),null);
var inst_141154 = cljs.core.nth.call(null,inst_141152,(1),null);
var inst_141155 = cljs.core._EQ_.call(null,inst_141154,inst_141024);
var inst_141156 = !(inst_141155);
var state_141209__$1 = (function (){var statearr_141211 = state_141209;
(statearr_141211[(8)] = inst_141153);

return statearr_141211;
})();
if(inst_141156){
var statearr_141212_141314 = state_141209__$1;
(statearr_141212_141314[(1)] = (8));

} else {
var statearr_141213_141315 = state_141209__$1;
(statearr_141213_141315[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (20))){
var inst_141153 = (state_141209[(8)]);
var inst_141184 = (state_141209[(2)]);
var inst_141185 = cljs.core.async.put_BANG_.call(null,out_ch,inst_141153);
var inst_141186 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_141209__$1 = (function (){var statearr_141214 = state_141209;
(statearr_141214[(9)] = inst_141185);

(statearr_141214[(10)] = inst_141184);

return statearr_141214;
})();
var statearr_141215_141316 = state_141209__$1;
(statearr_141215_141316[(2)] = inst_141186);

(statearr_141215_141316[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (1))){
var inst_141020 = retries__$1;
var state_141209__$1 = (function (){var statearr_141216 = state_141209;
(statearr_141216[(11)] = inst_141020);

return statearr_141216;
})();
var statearr_141217_141317 = state_141209__$1;
(statearr_141217_141317[(2)] = null);

(statearr_141217_141317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (4))){
var inst_141023 = (state_141209[(12)]);
var inst_141020 = (state_141209[(11)]);
var inst_141024 = (state_141209[(7)]);
var inst_141033 = (state_141209[(13)]);
var inst_141022 = (state_141209[(14)]);
var inst_141032 = (state_141209[(15)]);
var inst_141035 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_141036 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_141037 = superv.async._register_go.call(null,supervisor,inst_141036);
var inst_141062 = cljs.core.async.chan.call(null,(1));
var inst_141063 = (function (){var stale_timeout__$1 = (1000);
var err_ch = inst_141022;
var ab_ch = inst_141023;
var res_ch = inst_141033;
var close_ch = inst_141024;
var id__136792__auto__ = inst_141037;
var retries__$2 = inst_141020;
var c__136791__auto__ = inst_141035;
var s = inst_141032;
var c__53627__auto____$1 = inst_141062;
return ((function (stale_timeout__$1,err_ch,ab_ch,res_ch,close_ch,id__136792__auto__,retries__$2,c__136791__auto__,s,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141035,inst_141036,inst_141037,inst_141062,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (stale_timeout__$1,err_ch,ab_ch,res_ch,close_ch,id__136792__auto__,retries__$2,c__136791__auto__,s,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141035,inst_141036,inst_141037,inst_141062,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_141060){
var state_val_141061 = (state_141060[(1)]);
if((state_val_141061 === (1))){
var state_141060__$1 = state_141060;
var statearr_141218_141318 = state_141060__$1;
(statearr_141218_141318[(2)] = null);

(statearr_141218_141318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141061 === (2))){
var inst_141058 = (state_141060[(2)]);
var state_141060__$1 = state_141060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_141060__$1,inst_141058);
} else {
if((state_val_141061 === (3))){
var inst_141038 = (state_141060[(2)]);
var inst_141039 = superv.async._unregister_go.call(null,supervisor,id__136792__auto__);
var state_141060__$1 = (function (){var statearr_141219 = state_141060;
(statearr_141219[(7)] = inst_141039);

(statearr_141219[(8)] = inst_141038);

return statearr_141219;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141060__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141061 === (4))){
var inst_141041 = (state_141060[(9)]);
var inst_141041__$1 = (state_141060[(2)]);
var inst_141042 = cljs.core.ex_data.call(null,inst_141041__$1);
var inst_141043 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_141042);
var inst_141044 = cljs.core._EQ_.call(null,inst_141043,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_141060__$1 = (function (){var statearr_141220 = state_141060;
(statearr_141220[(9)] = inst_141041__$1);

return statearr_141220;
})();
if(inst_141044){
var statearr_141221_141319 = state_141060__$1;
(statearr_141221_141319[(1)] = (5));

} else {
var statearr_141222_141320 = state_141060__$1;
(statearr_141222_141320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141061 === (5))){
var state_141060__$1 = state_141060;
var statearr_141223_141321 = state_141060__$1;
(statearr_141223_141321[(2)] = null);

(statearr_141223_141321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141061 === (6))){
var inst_141041 = (state_141060[(9)]);
var inst_141047 = superv.async._track_exception.call(null,supervisor,inst_141041);
var state_141060__$1 = state_141060;
var statearr_141224_141322 = state_141060__$1;
(statearr_141224_141322[(2)] = inst_141047);

(statearr_141224_141322[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141061 === (7))){
var inst_141041 = (state_141060[(9)]);
var inst_141049 = (state_141060[(2)]);
var state_141060__$1 = (function (){var statearr_141225 = state_141060;
(statearr_141225[(10)] = inst_141049);

return statearr_141225;
})();
var statearr_141226_141323 = state_141060__$1;
(statearr_141226_141323[(2)] = inst_141041);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141060__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141061 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_141060,(4),Error,(3),(2));
var inst_141053 = superv.async._abort.call(null,supervisor);
var state_141060__$1 = state_141060;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_141060__$1,(9),inst_141053);
} else {
if((state_val_141061 === (9))){
var inst_141055 = (state_141060[(2)]);
var inst_141056 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_141060__$1 = (function (){var statearr_141227 = state_141060;
(statearr_141227[(11)] = inst_141055);

return statearr_141227;
})();
var statearr_141228_141324 = state_141060__$1;
(statearr_141228_141324[(2)] = inst_141056);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141060__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(stale_timeout__$1,err_ch,ab_ch,res_ch,close_ch,id__136792__auto__,retries__$2,c__136791__auto__,s,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141035,inst_141036,inst_141037,inst_141062,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__53560__auto__,stale_timeout__$1,err_ch,ab_ch,res_ch,close_ch,id__136792__auto__,retries__$2,c__136791__auto__,s,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141035,inst_141036,inst_141037,inst_141062,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_141232 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_141232[(0)] = superv$async$state_machine__53561__auto__);

(statearr_141232[(1)] = (1));

return statearr_141232;
});
var superv$async$state_machine__53561__auto____1 = (function (state_141060){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_141060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e141233){if((e141233 instanceof Object)){
var ex__53564__auto__ = e141233;
var statearr_141234_141325 = state_141060;
(statearr_141234_141325[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141060);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e141233;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__141326 = state_141060;
state_141060 = G__141326;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_141060){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_141060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,stale_timeout__$1,err_ch,ab_ch,res_ch,close_ch,id__136792__auto__,retries__$2,c__136791__auto__,s,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141035,inst_141036,inst_141037,inst_141062,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__53629__auto__ = (function (){var statearr_141235 = f__53628__auto__.call(null);
(statearr_141235[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto____$1);

return statearr_141235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});
;})(stale_timeout__$1,err_ch,ab_ch,res_ch,close_ch,id__136792__auto__,retries__$2,c__136791__auto__,s,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141035,inst_141036,inst_141037,inst_141062,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_141064 = cljs.core.async.impl.dispatch.run.call(null,inst_141063);
var state_141209__$1 = (function (){var statearr_141236 = state_141209;
(statearr_141236[(16)] = inst_141064);

return statearr_141236;
})();
var statearr_141237_141327 = state_141209__$1;
(statearr_141237_141327[(2)] = inst_141062);

(statearr_141237_141327[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (15))){
var inst_141153 = (state_141209[(8)]);
var inst_141175 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_141176 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_141153];
var inst_141177 = cljs.core.PersistentHashMap.fromArrays(inst_141175,inst_141176);
var inst_141178 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_141177);
var state_141209__$1 = (function (){var statearr_141238 = state_141209;
(statearr_141238[(17)] = inst_141178);

return statearr_141238;
})();
if(cljs.core.truth_(supervisor)){
var statearr_141239_141328 = state_141209__$1;
(statearr_141239_141328[(1)] = (18));

} else {
var statearr_141240_141329 = state_141209__$1;
(statearr_141240_141329[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (21))){
var inst_141020 = (state_141209[(11)]);
var inst_141153 = (state_141209[(8)]);
var inst_141190 = (state_141209[(2)]);
var inst_141191 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_141192 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_141153,inst_141020];
var inst_141193 = cljs.core.PersistentHashMap.fromArrays(inst_141191,inst_141192);
var inst_141194 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_141193);
var inst_141195 = (inst_141020 - (1));
var inst_141020__$1 = inst_141195;
var state_141209__$1 = (function (){var statearr_141241 = state_141209;
(statearr_141241[(18)] = inst_141194);

(statearr_141241[(11)] = inst_141020__$1);

(statearr_141241[(19)] = inst_141190);

return statearr_141241;
})();
var statearr_141242_141330 = state_141209__$1;
(statearr_141242_141330[(2)] = null);

(statearr_141242_141330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (13))){
var inst_141153 = (state_141209[(8)]);
var inst_141167 = error_fn.call(null,inst_141153);
var state_141209__$1 = state_141209;
var statearr_141243_141331 = state_141209__$1;
(statearr_141243_141331[(2)] = inst_141167);

(statearr_141243_141331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (22))){
var inst_141201 = (state_141209[(2)]);
var inst_141202 = cljs.core.async.put_BANG_.call(null,out_ch,inst_141201);
var inst_141203 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_141209__$1 = (function (){var statearr_141244 = state_141209;
(statearr_141244[(20)] = inst_141202);

return statearr_141244;
})();
var statearr_141245_141332 = state_141209__$1;
(statearr_141245_141332[(2)] = inst_141203);

(statearr_141245_141332[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (6))){
var inst_141023 = (state_141209[(12)]);
var inst_141020 = (state_141209[(11)]);
var inst_141024 = (state_141209[(7)]);
var inst_141033 = (state_141209[(13)]);
var inst_141022 = (state_141209[(14)]);
var inst_141032 = (state_141209[(15)]);
var inst_141067 = (state_141209[(2)]);
var inst_141114 = cljs.core.async.chan.call(null,(1));
var inst_141115 = (function (){var retries__$2 = inst_141020;
var err_ch = inst_141022;
var ab_ch = inst_141023;
var close_ch = inst_141024;
var s = inst_141032;
var res_ch = inst_141033;
var stale_timeout__$1 = (1000);
var c__53627__auto____$1 = inst_141114;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_141112){
var state_val_141113 = (state_141112[(1)]);
if((state_val_141113 === (7))){
var inst_141087 = (state_141112[(7)]);
var inst_141074 = (state_141112[(2)]);
var inst_141082 = (function (){return ((function (inst_141087,inst_141074,state_val_141113,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__141081){
var vec__141246 = p__141081;
var k = cljs.core.nth.call(null,vec__141246,(0),null);
var v = cljs.core.nth.call(null,vec__141246,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_141087,inst_141074,state_val_141113,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_141083 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_141084 = cljs.core.deref.call(null,inst_141083);
var inst_141085 = cljs.core.filter.call(null,inst_141082,inst_141084);
var inst_141086 = cljs.core.nth.call(null,inst_141085,(0),null);
var inst_141087__$1 = cljs.core.nth.call(null,inst_141086,(0),null);
var inst_141088 = cljs.core.nth.call(null,inst_141086,(1),null);
var state_141112__$1 = (function (){var statearr_141249 = state_141112;
(statearr_141249[(8)] = inst_141074);

(statearr_141249[(7)] = inst_141087__$1);

(statearr_141249[(9)] = inst_141088);

return statearr_141249;
})();
if(cljs.core.truth_(inst_141087__$1)){
var statearr_141250_141333 = state_141112__$1;
(statearr_141250_141333[(1)] = (8));

} else {
var statearr_141251_141334 = state_141112__$1;
(statearr_141251_141334[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (1))){
var state_141112__$1 = state_141112;
var statearr_141252_141335 = state_141112__$1;
(statearr_141252_141335[(2)] = null);

(statearr_141252_141335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (4))){
var state_141112__$1 = state_141112;
var statearr_141253_141336 = state_141112__$1;
(statearr_141253_141336[(2)] = null);

(statearr_141253_141336[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (13))){
var inst_141087 = (state_141112[(7)]);
var inst_141100 = (state_141112[(2)]);
var inst_141101 = superv.async._free_exception.call(null,s,inst_141087);
var inst_141102 = cljs.core.async.put_BANG_.call(null,err_ch,inst_141087);
var state_141112__$1 = (function (){var statearr_141254 = state_141112;
(statearr_141254[(10)] = inst_141100);

(statearr_141254[(11)] = inst_141101);

return statearr_141254;
})();
var statearr_141255_141337 = state_141112__$1;
(statearr_141255_141337[(2)] = inst_141102);

(statearr_141255_141337[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (6))){
var inst_141108 = (state_141112[(2)]);
var state_141112__$1 = state_141112;
var statearr_141256_141338 = state_141112__$1;
(statearr_141256_141338[(2)] = inst_141108);

(statearr_141256_141338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (3))){
var inst_141110 = (state_141112[(2)]);
var state_141112__$1 = state_141112;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_141112__$1,inst_141110);
} else {
if((state_val_141113 === (12))){
var inst_141087 = (state_141112[(7)]);
var inst_141095 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_141096 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_141087];
var inst_141097 = cljs.core.PersistentHashMap.fromArrays(inst_141095,inst_141096);
var inst_141098 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_141097);
var state_141112__$1 = state_141112;
var statearr_141257_141339 = state_141112__$1;
(statearr_141257_141339[(2)] = inst_141098);

(statearr_141257_141339[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (2))){
var inst_141069 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_141112__$1 = state_141112;
if(cljs.core.truth_(inst_141069)){
var statearr_141258_141340 = state_141112__$1;
(statearr_141258_141340[(1)] = (4));

} else {
var statearr_141259_141341 = state_141112__$1;
(statearr_141259_141341[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (11))){
var state_141112__$1 = state_141112;
var statearr_141260_141342 = state_141112__$1;
(statearr_141260_141342[(2)] = null);

(statearr_141260_141342[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (9))){
var state_141112__$1 = state_141112;
var statearr_141261_141343 = state_141112__$1;
(statearr_141261_141343[(2)] = null);

(statearr_141261_141343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (5))){
var inst_141072 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_141112__$1 = state_141112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_141112__$1,(7),inst_141072);
} else {
if((state_val_141113 === (10))){
var inst_141106 = (state_141112[(2)]);
var state_141112__$1 = state_141112;
var statearr_141262_141344 = state_141112__$1;
(statearr_141262_141344[(2)] = inst_141106);

(statearr_141262_141344[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141113 === (8))){
var inst_141087 = (state_141112[(7)]);
var inst_141090 = cljs.core.ex_data.call(null,inst_141087);
var inst_141091 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_141090);
var inst_141092 = cljs.core._EQ_.call(null,inst_141091,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_141112__$1 = state_141112;
if(inst_141092){
var statearr_141263_141345 = state_141112__$1;
(statearr_141263_141345[(1)] = (11));

} else {
var statearr_141264_141346 = state_141112__$1;
(statearr_141264_141346[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__53560__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_141268 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_141268[(0)] = superv$async$state_machine__53561__auto__);

(statearr_141268[(1)] = (1));

return statearr_141268;
});
var superv$async$state_machine__53561__auto____1 = (function (state_141112){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_141112);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e141269){if((e141269 instanceof Object)){
var ex__53564__auto__ = e141269;
var statearr_141270_141347 = state_141112;
(statearr_141270_141347[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141112);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e141269;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__141348 = state_141112;
state_141112 = G__141348;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_141112){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_141112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__53629__auto__ = (function (){var statearr_141271 = f__53628__auto__.call(null);
(statearr_141271[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto____$1);

return statearr_141271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_141116 = cljs.core.async.impl.dispatch.run.call(null,inst_141115);
var inst_141142 = cljs.core.async.chan.call(null,(1));
var inst_141143 = (function (){var retries__$2 = inst_141020;
var err_ch = inst_141022;
var ab_ch = inst_141023;
var close_ch = inst_141024;
var s = inst_141032;
var res_ch = inst_141033;
var stale_timeout__$1 = (1000);
var c__53627__auto____$1 = inst_141142;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,inst_141115,inst_141116,inst_141142,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,inst_141115,inst_141116,inst_141142,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_141140){
var state_val_141141 = (state_141140[(1)]);
if((state_val_141141 === (1))){
var inst_141117 = (0);
var state_141140__$1 = (function (){var statearr_141272 = state_141140;
(statearr_141272[(7)] = inst_141117);

return statearr_141272;
})();
var statearr_141273_141349 = state_141140__$1;
(statearr_141273_141349[(2)] = null);

(statearr_141273_141349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141141 === (2))){
var inst_141119 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_141120 = cljs.core.deref.call(null,inst_141119);
var inst_141121 = cljs.core.empty_QMARK_.call(null,inst_141120);
var inst_141122 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_141123 = cljs.core.deref.call(null,inst_141122);
var inst_141124 = cljs.core.empty_QMARK_.call(null,inst_141123);
var inst_141125 = (inst_141121) && (inst_141124);
var inst_141126 = cljs.core.not.call(null,inst_141125);
var state_141140__$1 = state_141140;
if(inst_141126){
var statearr_141274_141350 = state_141140__$1;
(statearr_141274_141350[(1)] = (4));

} else {
var statearr_141275_141351 = state_141140__$1;
(statearr_141275_141351[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141141 === (3))){
var inst_141138 = (state_141140[(2)]);
var state_141140__$1 = state_141140;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_141140__$1,inst_141138);
} else {
if((state_val_141141 === (4))){
var inst_141128 = cljs.core.async.timeout.call(null,(100));
var state_141140__$1 = state_141140;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_141140__$1,(7),inst_141128);
} else {
if((state_val_141141 === (5))){
var inst_141134 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_141140__$1 = state_141140;
var statearr_141276_141352 = state_141140__$1;
(statearr_141276_141352[(2)] = inst_141134);

(statearr_141276_141352[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141141 === (6))){
var inst_141136 = (state_141140[(2)]);
var state_141140__$1 = state_141140;
var statearr_141277_141353 = state_141140__$1;
(statearr_141277_141353[(2)] = inst_141136);

(statearr_141277_141353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141141 === (7))){
var inst_141117 = (state_141140[(7)]);
var inst_141130 = (state_141140[(2)]);
var inst_141131 = (inst_141117 + (1));
var inst_141117__$1 = inst_141131;
var state_141140__$1 = (function (){var statearr_141278 = state_141140;
(statearr_141278[(8)] = inst_141130);

(statearr_141278[(7)] = inst_141117__$1);

return statearr_141278;
})();
var statearr_141279_141354 = state_141140__$1;
(statearr_141279_141354[(2)] = null);

(statearr_141279_141354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,inst_141115,inst_141116,inst_141142,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__53560__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,inst_141115,inst_141116,inst_141142,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_141283 = [null,null,null,null,null,null,null,null,null];
(statearr_141283[(0)] = superv$async$state_machine__53561__auto__);

(statearr_141283[(1)] = (1));

return statearr_141283;
});
var superv$async$state_machine__53561__auto____1 = (function (state_141140){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_141140);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e141284){if((e141284 instanceof Object)){
var ex__53564__auto__ = e141284;
var statearr_141285_141355 = state_141140;
(statearr_141285_141355[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141140);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e141284;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__141356 = state_141140;
state_141140 = G__141356;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_141140){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_141140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,inst_141115,inst_141116,inst_141142,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__53629__auto__ = (function (){var statearr_141286 = f__53628__auto__.call(null);
(statearr_141286[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto____$1);

return statearr_141286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__53627__auto____$1,inst_141023,inst_141020,inst_141024,inst_141033,inst_141022,inst_141032,inst_141067,inst_141114,inst_141115,inst_141116,inst_141142,state_val_141210,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_141144 = cljs.core.async.impl.dispatch.run.call(null,inst_141143);
var inst_141148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_141149 = [inst_141022,inst_141024];
var inst_141150 = (new cljs.core.PersistentVector(null,2,(5),inst_141148,inst_141149,null));
var state_141209__$1 = (function (){var statearr_141287 = state_141209;
(statearr_141287[(21)] = inst_141144);

(statearr_141287[(22)] = inst_141116);

(statearr_141287[(23)] = inst_141067);

return statearr_141287;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_141209__$1,(7),inst_141150,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_141210 === (17))){
var inst_141198 = (state_141209[(2)]);
var state_141209__$1 = state_141209;
var statearr_141288_141357 = state_141209__$1;
(statearr_141288_141357[(2)] = inst_141198);

(statearr_141288_141357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (3))){
var inst_141207 = (state_141209[(2)]);
var state_141209__$1 = state_141209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_141209__$1,inst_141207);
} else {
if((state_val_141210 === (12))){
var inst_141164 = (state_141209[(24)]);
var state_141209__$1 = state_141209;
var statearr_141289_141358 = state_141209__$1;
(statearr_141289_141358[(2)] = inst_141164);

(statearr_141289_141358[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (2))){
var inst_141023 = (state_141209[(12)]);
var inst_141022 = (state_141209[(14)]);
var inst_141032 = (state_141209[(15)]);
var inst_141022__$1 = cljs.core.async.chan.call(null);
var inst_141023__$1 = cljs.core.async.chan.call(null);
var inst_141024 = cljs.core.async.chan.call(null);
var inst_141025 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_141026 = cljs.core.PersistentHashMap.EMPTY;
var inst_141027 = cljs.core.atom.call(null,inst_141026);
var inst_141028 = cljs.core.PersistentHashMap.EMPTY;
var inst_141029 = cljs.core.atom.call(null,inst_141028);
var inst_141030 = [inst_141022__$1,inst_141023__$1,inst_141027,inst_141029,true];
var inst_141031 = cljs.core.PersistentHashMap.fromArrays(inst_141025,inst_141030);
var inst_141032__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_141031);
var inst_141033 = start_fn.call(null,inst_141032__$1);
var state_141209__$1 = (function (){var statearr_141290 = state_141209;
(statearr_141290[(12)] = inst_141023__$1);

(statearr_141290[(7)] = inst_141024);

(statearr_141290[(13)] = inst_141033);

(statearr_141290[(14)] = inst_141022__$1);

(statearr_141290[(15)] = inst_141032__$1);

return statearr_141290;
})();
if(cljs.core.truth_(supervisor)){
var statearr_141291_141359 = state_141209__$1;
(statearr_141291_141359[(1)] = (4));

} else {
var statearr_141292_141360 = state_141209__$1;
(statearr_141292_141360[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (19))){
var state_141209__$1 = state_141209;
var statearr_141293_141361 = state_141209__$1;
(statearr_141293_141361[(2)] = null);

(statearr_141293_141361[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (11))){
var inst_141153 = (state_141209[(8)]);
var inst_141164 = (state_141209[(24)]);
var inst_141161 = (state_141209[(2)]);
var inst_141162 = (inst_141153 instanceof exception);
var inst_141163 = cljs.core.not.call(null,inst_141162);
var inst_141164__$1 = cljs.core.not.call(null,error_fn);
var state_141209__$1 = (function (){var statearr_141294 = state_141209;
(statearr_141294[(25)] = inst_141161);

(statearr_141294[(26)] = inst_141163);

(statearr_141294[(24)] = inst_141164__$1);

return statearr_141294;
})();
if(inst_141164__$1){
var statearr_141295_141362 = state_141209__$1;
(statearr_141295_141362[(1)] = (12));

} else {
var statearr_141296_141363 = state_141209__$1;
(statearr_141296_141363[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (9))){
var inst_141033 = (state_141209[(13)]);
var state_141209__$1 = state_141209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_141209__$1,(22),inst_141033);
} else {
if((state_val_141210 === (5))){
var state_141209__$1 = state_141209;
var statearr_141297_141364 = state_141209__$1;
(statearr_141297_141364[(2)] = null);

(statearr_141297_141364[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (14))){
var inst_141020 = (state_141209[(11)]);
var inst_141163 = (state_141209[(26)]);
var inst_141169 = (state_141209[(2)]);
var inst_141170 = cljs.core.not.call(null,inst_141169);
var inst_141171 = (inst_141020 > (0));
var inst_141172 = cljs.core.not.call(null,inst_141171);
var inst_141173 = (inst_141163) || (inst_141170) || (inst_141172);
var state_141209__$1 = state_141209;
if(cljs.core.truth_(inst_141173)){
var statearr_141298_141365 = state_141209__$1;
(statearr_141298_141365[(1)] = (15));

} else {
var statearr_141299_141366 = state_141209__$1;
(statearr_141299_141366[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (16))){
var inst_141188 = cljs.core.async.timeout.call(null,delay);
var state_141209__$1 = state_141209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_141209__$1,(21),inst_141188);
} else {
if((state_val_141210 === (10))){
var inst_141205 = (state_141209[(2)]);
var state_141209__$1 = state_141209;
var statearr_141300_141367 = state_141209__$1;
(statearr_141300_141367[(2)] = inst_141205);

(statearr_141300_141367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (18))){
var inst_141153 = (state_141209[(8)]);
var inst_141180 = superv.async._error.call(null,supervisor);
var inst_141181 = cljs.core.async.put_BANG_.call(null,inst_141180,inst_141153);
var state_141209__$1 = state_141209;
var statearr_141301_141368 = state_141209__$1;
(statearr_141301_141368[(2)] = inst_141181);

(statearr_141301_141368[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141210 === (8))){
var inst_141023 = (state_141209[(12)]);
var inst_141024 = (state_141209[(7)]);
var inst_141022 = (state_141209[(14)]);
var inst_141158 = cljs.core.async.close_BANG_.call(null,inst_141022);
var inst_141159 = cljs.core.async.close_BANG_.call(null,inst_141023);
var state_141209__$1 = (function (){var statearr_141302 = state_141209;
(statearr_141302[(27)] = inst_141158);

(statearr_141302[(28)] = inst_141159);

return statearr_141302;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_141209__$1,(11),inst_141024);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__53560__auto__,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_141306 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_141306[(0)] = superv$async$state_machine__53561__auto__);

(statearr_141306[(1)] = (1));

return statearr_141306;
});
var superv$async$state_machine__53561__auto____1 = (function (state_141209){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_141209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e141307){if((e141307 instanceof Object)){
var ex__53564__auto__ = e141307;
var statearr_141308_141369 = state_141209;
(statearr_141308_141369[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141209);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e141307;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__141370 = state_141209;
state_141209 = G__141370;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_141209){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_141209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__53629__auto__ = (function (){var statearr_141309 = f__53628__auto__.call(null);
(statearr_141309[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto___141313);

return statearr_141309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto___141313,retries__$1,out_ch,map__141018,map__141018__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq141015){
var G__141016 = cljs.core.first.call(null,seq141015);
var seq141015__$1 = cljs.core.next.call(null,seq141015);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__141016,seq141015__$1);
});

/**
 * Asserts that ch does not close or produce a value within ms. Returns a
 *   channel from which the value can be taken.
 */
superv.async.test_within = (function superv$async$test_within(ms,ch){
var c__136791__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto__ = superv.async._register_go.call(null,superv.async.S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"t","t",242699008,null),cljs.core.list(new cljs.core.Symbol(null,"timeout","timeout",1321906209,null),new cljs.core.Symbol(null,"ms","ms",487821794,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"t","t",242699008,null)], null)))], null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"t","t",242699008,null)),cljs.core.list(new cljs.core.Symbol(null,"prn","prn",1561684909,null),cljs.core.list(new cljs.core.Symbol(null,"str","str",-1564826950,null),"Test should have finished within ",new cljs.core.Symbol(null,"ms","ms",487821794,null),"ms."))),new cljs.core.Symbol(null,"v","v",1661996586,null))));
var c__53627__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function (state_141514){
var state_val_141515 = (state_141514[(1)]);
if((state_val_141515 === (7))){
var inst_141461 = (state_141514[(7)]);
var inst_141469 = (state_141514[(2)]);
var state_141514__$1 = (function (){var statearr_141516 = state_141514;
(statearr_141516[(8)] = inst_141469);

return statearr_141516;
})();
var statearr_141517_141545 = state_141514__$1;
(statearr_141517_141545[(2)] = inst_141461);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141514__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (1))){
var state_141514__$1 = state_141514;
var statearr_141518_141546 = state_141514__$1;
(statearr_141518_141546[(2)] = null);

(statearr_141518_141546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (4))){
var inst_141461 = (state_141514[(7)]);
var inst_141461__$1 = (state_141514[(2)]);
var inst_141462 = cljs.core.ex_data.call(null,inst_141461__$1);
var inst_141463 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_141462);
var inst_141464 = cljs.core._EQ_.call(null,inst_141463,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_141514__$1 = (function (){var statearr_141519 = state_141514;
(statearr_141519[(7)] = inst_141461__$1);

return statearr_141519;
})();
if(inst_141464){
var statearr_141520_141547 = state_141514__$1;
(statearr_141520_141547[(1)] = (5));

} else {
var statearr_141521_141548 = state_141514__$1;
(statearr_141521_141548[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (15))){
var inst_141502 = (state_141514[(9)]);
var inst_141510 = (state_141514[(2)]);
var state_141514__$1 = (function (){var statearr_141522 = state_141514;
(statearr_141522[(10)] = inst_141510);

return statearr_141522;
})();
var statearr_141523_141549 = state_141514__$1;
(statearr_141523_141549[(2)] = inst_141502);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141514__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (13))){
var inst_141506 = [cljs.core.str("Test should have finished within "),cljs.core.str(ms),cljs.core.str("ms.")].join('');
var inst_141507 = cljs.core.prn.call(null,inst_141506);
var state_141514__$1 = state_141514;
var statearr_141524_141550 = state_141514__$1;
(statearr_141524_141550[(2)] = inst_141507);

(statearr_141524_141550[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (6))){
var inst_141461 = (state_141514[(7)]);
var inst_141467 = superv.async._track_exception.call(null,superv.async.S,inst_141461);
var state_141514__$1 = state_141514;
var statearr_141525_141551 = state_141514__$1;
(statearr_141525_141551[(2)] = inst_141467);

(statearr_141525_141551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (3))){
var inst_141458 = (state_141514[(2)]);
var inst_141459 = superv.async._unregister_go.call(null,superv.async.S,id__136792__auto__);
var state_141514__$1 = (function (){var statearr_141526 = state_141514;
(statearr_141526[(11)] = inst_141459);

(statearr_141526[(12)] = inst_141458);

return statearr_141526;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141514__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (12))){
var inst_141476 = (state_141514[(13)]);
var inst_141500 = (state_141514[(2)]);
var inst_141501 = superv.async.throw_if_exception.call(null,superv.async.S,inst_141500);
var inst_141502 = cljs.core.nth.call(null,inst_141501,(0),null);
var inst_141503 = cljs.core.nth.call(null,inst_141501,(1),null);
var inst_141504 = cljs.core.not_EQ_.call(null,inst_141503,inst_141476);
var state_141514__$1 = (function (){var statearr_141527 = state_141514;
(statearr_141527[(9)] = inst_141502);

return statearr_141527;
})();
if(inst_141504){
var statearr_141528_141552 = state_141514__$1;
(statearr_141528_141552[(1)] = (13));

} else {
var statearr_141529_141553 = state_141514__$1;
(statearr_141529_141553[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (2))){
var inst_141512 = (state_141514[(2)]);
var state_141514__$1 = state_141514;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_141514__$1,inst_141512);
} else {
if((state_val_141515 === (11))){
var inst_141490 = (state_141514[(14)]);
var state_141514__$1 = state_141514;
var statearr_141530_141554 = state_141514__$1;
(statearr_141530_141554[(2)] = inst_141490);

(statearr_141530_141554[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (9))){
var inst_141480 = (state_141514[(15)]);
var inst_141489 = (state_141514[(2)]);
var inst_141490 = cljs.core.nth.call(null,inst_141489,(0),null);
var inst_141491 = cljs.core.nth.call(null,inst_141489,(1),null);
var inst_141492 = cljs.core._EQ_.call(null,inst_141491,inst_141480);
var state_141514__$1 = (function (){var statearr_141531 = state_141514;
(statearr_141531[(14)] = inst_141490);

return statearr_141531;
})();
if(inst_141492){
var statearr_141532_141555 = state_141514__$1;
(statearr_141532_141555[(1)] = (10));

} else {
var statearr_141533_141556 = state_141514__$1;
(statearr_141533_141556[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (5))){
var state_141514__$1 = state_141514;
var statearr_141534_141557 = state_141514__$1;
(statearr_141534_141557[(2)] = null);

(statearr_141534_141557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (14))){
var state_141514__$1 = state_141514;
var statearr_141535_141558 = state_141514__$1;
(statearr_141535_141558[(2)] = null);

(statearr_141535_141558[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (10))){
var inst_141494 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_141495 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_141496 = cljs.core.PersistentHashMap.fromArrays(inst_141494,inst_141495);
var inst_141497 = cljs.core.ex_info.call(null,"Aborted operations",inst_141496);
var state_141514__$1 = state_141514;
var statearr_141536_141559 = state_141514__$1;
(statearr_141536_141559[(2)] = inst_141497);

(statearr_141536_141559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141515 === (8))){
var inst_141476 = (state_141514[(13)]);
var inst_141480 = (state_141514[(15)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_141514,(4),Error,(3),(2));
var inst_141476__$1 = cljs.core.async.timeout.call(null,ms);
var inst_141480__$1 = superv.async._abort.call(null,superv.async.S);
var inst_141481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_141482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_141483 = [ch,inst_141476__$1];
var inst_141484 = (new cljs.core.PersistentVector(null,2,(5),inst_141482,inst_141483,null));
var inst_141485 = superv.async.alts_QMARK_.call(null,superv.async.S,inst_141484);
var inst_141486 = [inst_141480__$1,inst_141485];
var inst_141487 = (new cljs.core.PersistentVector(null,2,(5),inst_141481,inst_141486,null));
var state_141514__$1 = (function (){var statearr_141537 = state_141514;
(statearr_141537[(13)] = inst_141476__$1);

(statearr_141537[(15)] = inst_141480__$1);

return statearr_141537;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_141514__$1,(9),inst_141487,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__))
;
return ((function (switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function() {
var superv$async$test_within_$_state_machine__53561__auto__ = null;
var superv$async$test_within_$_state_machine__53561__auto____0 = (function (){
var statearr_141541 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_141541[(0)] = superv$async$test_within_$_state_machine__53561__auto__);

(statearr_141541[(1)] = (1));

return statearr_141541;
});
var superv$async$test_within_$_state_machine__53561__auto____1 = (function (state_141514){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_141514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e141542){if((e141542 instanceof Object)){
var ex__53564__auto__ = e141542;
var statearr_141543_141560 = state_141514;
(statearr_141543_141560[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141514);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e141542;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__141561 = state_141514;
state_141514 = G__141561;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$test_within_$_state_machine__53561__auto__ = function(state_141514){
switch(arguments.length){
case 0:
return superv$async$test_within_$_state_machine__53561__auto____0.call(this);
case 1:
return superv$async$test_within_$_state_machine__53561__auto____1.call(this,state_141514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$test_within_$_state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$test_within_$_state_machine__53561__auto____0;
superv$async$test_within_$_state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$test_within_$_state_machine__53561__auto____1;
return superv$async$test_within_$_state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__))
})();
var state__53629__auto__ = (function (){var statearr_141544 = f__53628__auto__.call(null);
(statearr_141544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto__);

return statearr_141544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__))
);

return c__53627__auto__;
});
superv.async.test_within.call(null,(100),(function (){var c__136791__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__136792__auto__ = superv.async._register_go.call(null,superv.async.S,cljs.core.list((1)));
var c__53627__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function (){
var f__53628__auto__ = (function (){var switch__53560__auto__ = ((function (c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function (state_141580){
var state_val_141581 = (state_141580[(1)]);
if((state_val_141581 === (1))){
var state_141580__$1 = state_141580;
var statearr_141582_141599 = state_141580__$1;
(statearr_141582_141599[(2)] = null);

(statearr_141582_141599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141581 === (2))){
var inst_141578 = (state_141580[(2)]);
var state_141580__$1 = state_141580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_141580__$1,inst_141578);
} else {
if((state_val_141581 === (3))){
var inst_141562 = (state_141580[(2)]);
var inst_141563 = superv.async._unregister_go.call(null,superv.async.S,id__136792__auto__);
var state_141580__$1 = (function (){var statearr_141583 = state_141580;
(statearr_141583[(7)] = inst_141563);

(statearr_141583[(8)] = inst_141562);

return statearr_141583;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141580__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141581 === (4))){
var inst_141565 = (state_141580[(9)]);
var inst_141565__$1 = (state_141580[(2)]);
var inst_141566 = cljs.core.ex_data.call(null,inst_141565__$1);
var inst_141567 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_141566);
var inst_141568 = cljs.core._EQ_.call(null,inst_141567,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_141580__$1 = (function (){var statearr_141584 = state_141580;
(statearr_141584[(9)] = inst_141565__$1);

return statearr_141584;
})();
if(inst_141568){
var statearr_141585_141600 = state_141580__$1;
(statearr_141585_141600[(1)] = (5));

} else {
var statearr_141586_141601 = state_141580__$1;
(statearr_141586_141601[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141581 === (5))){
var state_141580__$1 = state_141580;
var statearr_141587_141602 = state_141580__$1;
(statearr_141587_141602[(2)] = null);

(statearr_141587_141602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141581 === (6))){
var inst_141565 = (state_141580[(9)]);
var inst_141571 = superv.async._track_exception.call(null,superv.async.S,inst_141565);
var state_141580__$1 = state_141580;
var statearr_141588_141603 = state_141580__$1;
(statearr_141588_141603[(2)] = inst_141571);

(statearr_141588_141603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141581 === (7))){
var inst_141565 = (state_141580[(9)]);
var inst_141573 = (state_141580[(2)]);
var state_141580__$1 = (function (){var statearr_141589 = state_141580;
(statearr_141589[(10)] = inst_141573);

return statearr_141589;
})();
var statearr_141590_141604 = state_141580__$1;
(statearr_141590_141604[(2)] = inst_141565);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141580__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_141581 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_141580,(4),Error,(3),(2));
var state_141580__$1 = state_141580;
var statearr_141591_141605 = state_141580__$1;
(statearr_141591_141605[(2)] = (1));


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141580__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__))
;
return ((function (switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__){
return (function() {
var superv$async$state_machine__53561__auto__ = null;
var superv$async$state_machine__53561__auto____0 = (function (){
var statearr_141595 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_141595[(0)] = superv$async$state_machine__53561__auto__);

(statearr_141595[(1)] = (1));

return statearr_141595;
});
var superv$async$state_machine__53561__auto____1 = (function (state_141580){
while(true){
var ret_value__53562__auto__ = (function (){try{while(true){
var result__53563__auto__ = switch__53560__auto__.call(null,state_141580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__53563__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__53563__auto__;
}
break;
}
}catch (e141596){if((e141596 instanceof Object)){
var ex__53564__auto__ = e141596;
var statearr_141597_141606 = state_141580;
(statearr_141597_141606[(5)] = ex__53564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_141580);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e141596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__53562__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__141607 = state_141580;
state_141580 = G__141607;
continue;
} else {
return ret_value__53562__auto__;
}
break;
}
});
superv$async$state_machine__53561__auto__ = function(state_141580){
switch(arguments.length){
case 0:
return superv$async$state_machine__53561__auto____0.call(this);
case 1:
return superv$async$state_machine__53561__auto____1.call(this,state_141580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__53561__auto____0;
superv$async$state_machine__53561__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__53561__auto____1;
return superv$async$state_machine__53561__auto__;
})()
;})(switch__53560__auto__,c__53627__auto__,c__136791__auto__,id__136792__auto__))
})();
var state__53629__auto__ = (function (){var statearr_141598 = f__53628__auto__.call(null);
(statearr_141598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__53627__auto__);

return statearr_141598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__53629__auto__);
});})(c__53627__auto__,c__136791__auto__,id__136792__auto__))
);

return c__53627__auto__;
})());

//# sourceMappingURL=async.js.map?rel=1491499685238