/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import java.util.Set;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;

@Provider
public class DisabledMethodsProcessor
implements ModelProcessor {
    private final Set<String> disabledMethods;

    public DisabledMethodsProcessor(Set<String> disabledMethods) {
        this.disabledMethods = disabledMethods;
    }

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        ResourceModel.Builder newResourceModelBuilder = new ResourceModel.Builder(false);
        for (Resource resource : resourceModel.getResources()) {
            Resource.Builder resourceBuilder = Resource.builder((String)resource.getPath());
            for (Resource childResource : resource.getChildResources()) {
                String fullPath = childResource.getParent().getPath() + childResource.getPath();
                if (this.disabledMethods != null && this.disabledMethods.contains(fullPath)) continue;
                resourceBuilder.addChildResource(childResource);
            }
            newResourceModelBuilder.addResource(resourceBuilder.build());
        }
        return newResourceModelBuilder.build();
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return subResourceModel;
    }
}

