/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.provider;

import io.dropwizard.revolver.provider.BlacklistMethodData;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class BlacklistProcessor
implements ModelProcessor {
    private static final Logger log = LoggerFactory.getLogger(BlacklistProcessor.class);
    private final Set<BlacklistMethodData> blacklistMethods;

    public BlacklistProcessor(Set<BlacklistMethodData> blacklistMethods) {
        this.blacklistMethods = blacklistMethods;
    }

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        if (this.blacklistMethods != null && this.blacklistMethods.isEmpty()) {
            log.info("No API end-point to blacklist");
            return resourceModel;
        }
        ResourceModel.Builder newResourceModelBuilder = new ResourceModel.Builder(false);
        for (Resource resource : resourceModel.getResources()) {
            Resource.Builder resourceBuilder;
            List childResources = resource.getChildResources();
            if (childResources.size() < 1) {
                resourceBuilder = Resource.builder((Resource)resource);
            } else {
                resourceBuilder = Resource.builder((String)resource.getPath());
                for (Resource childResource : childResources) {
                    Resource.Builder childResourceBuilder = Resource.builder((String)childResource.getPath());
                    ResourceMethod.Builder methodBuilder = null;
                    for (ResourceMethod method : childResource.getResourceMethods()) {
                        if (!this.shouldAddMethod(method)) continue;
                        methodBuilder = childResourceBuilder.addMethod(method);
                    }
                    if (methodBuilder != null) {
                        methodBuilder.build();
                    }
                    resourceBuilder.addChildResource(childResourceBuilder.build());
                }
            }
            newResourceModelBuilder.addResource(resourceBuilder.build());
        }
        return newResourceModelBuilder.build();
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return subResourceModel;
    }

    private boolean shouldAddMethod(ResourceMethod method) {
        boolean shouldAdd = true;
        for (BlacklistMethodData blacklistData : this.blacklistMethods) {
            if (!method.getInvocable().getHandler().getHandlerClass().getName().equals(blacklistData.getResourceClassName()) || !method.getHttpMethod().equalsIgnoreCase(blacklistData.getHttpMethod()) || !method.getParent().getPath().equals(blacklistData.getRelativePath())) continue;
            log.info("Blacklisting method with path: {}, http method: {}, resource: {}", new Object[]{blacklistData.getRelativePath(), blacklistData.getHttpMethod(), blacklistData.getResourceClassName()});
            shouldAdd = false;
        }
        return shouldAdd;
    }
}

