/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.provider;

import io.dropwizard.revolver.provider.BlacklistMethodData;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class BlacklistProcessor
implements ModelProcessor {
    private static final Logger log = LoggerFactory.getLogger(BlacklistProcessor.class);
    private final Set<BlacklistMethodData> blacklistMethods;

    public BlacklistProcessor(Set<BlacklistMethodData> blacklistMethods) {
        this.blacklistMethods = blacklistMethods;
    }

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        if (this.blacklistMethods == null || this.blacklistMethods.isEmpty()) {
            log.info("No API end-point to blacklist");
            return resourceModel;
        }
        ResourceModel.Builder newResourceModelBuilder = new ResourceModel.Builder(false);
        for (Resource resource : resourceModel.getResources()) {
            List childResources = resource.getChildResources();
            Resource.Builder resourceBuilder = childResources.isEmpty() ? Resource.builder((Resource)resource) : Resource.builder((String)resource.getPath());
            childResources.forEach(childResource -> {
                Resource.Builder childResourceBuilder = Resource.builder((String)childResource.getPath());
                childResource.getResourceMethods().stream().filter(this::shouldAddMethod).forEach(arg_0 -> ((Resource.Builder)childResourceBuilder).addMethod(arg_0));
                resourceBuilder.addChildResource(childResourceBuilder.build());
            });
            newResourceModelBuilder.addResource(resourceBuilder.build());
        }
        return newResourceModelBuilder.build();
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return subResourceModel;
    }

    private boolean shouldAddMethod(ResourceMethod method) {
        return this.blacklistMethods.stream().noneMatch(blacklistData -> {
            if (method.getInvocable().getHandler().getHandlerClass().getName().equals(blacklistData.getResourceClassName()) && method.getHttpMethod().equalsIgnoreCase(blacklistData.getHttpMethod()) && method.getParent().getPath().equals(blacklistData.getRelativePath())) {
                log.info("Blacklisting method with path: {}, http method: {}, resource: {}", new Object[]{blacklistData.getRelativePath(), blacklistData.getHttpMethod(), blacklistData.getResourceClassName()});
                return true;
            }
            return false;
        });
    }
}

