/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.config;

import com.google.common.collect.Lists;
import java.util.List;

public class OptimizerTimeConfig {
    private boolean enabled;
    private List<String> latencyMetrics = Lists.newArrayList((Object[])new String[]{"latencyExecute_percentile_99", "latencyExecute_percentile_50", "latencyExecute_percentile_75", "latencyExecute_percentile_995"});
    private String timeoutMetric;
    private double getMethodTimeoutBuffer;
    private double allMethodTimeoutBuffer;
    private String appLatencyMetric;
    private String apiLatencyMetric;
    private int appLatencyThresholdValue;

    public static OptimizerTimeConfigBuilder builder() {
        return new OptimizerTimeConfigBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getLatencyMetrics() {
        return this.latencyMetrics;
    }

    public String getTimeoutMetric() {
        return this.timeoutMetric;
    }

    public double getGetMethodTimeoutBuffer() {
        return this.getMethodTimeoutBuffer;
    }

    public double getAllMethodTimeoutBuffer() {
        return this.allMethodTimeoutBuffer;
    }

    public String getAppLatencyMetric() {
        return this.appLatencyMetric;
    }

    public String getApiLatencyMetric() {
        return this.apiLatencyMetric;
    }

    public int getAppLatencyThresholdValue() {
        return this.appLatencyThresholdValue;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLatencyMetrics(List<String> latencyMetrics) {
        this.latencyMetrics = latencyMetrics;
    }

    public void setTimeoutMetric(String timeoutMetric) {
        this.timeoutMetric = timeoutMetric;
    }

    public void setGetMethodTimeoutBuffer(double getMethodTimeoutBuffer) {
        this.getMethodTimeoutBuffer = getMethodTimeoutBuffer;
    }

    public void setAllMethodTimeoutBuffer(double allMethodTimeoutBuffer) {
        this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
    }

    public void setAppLatencyMetric(String appLatencyMetric) {
        this.appLatencyMetric = appLatencyMetric;
    }

    public void setApiLatencyMetric(String apiLatencyMetric) {
        this.apiLatencyMetric = apiLatencyMetric;
    }

    public void setAppLatencyThresholdValue(int appLatencyThresholdValue) {
        this.appLatencyThresholdValue = appLatencyThresholdValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerTimeConfig)) {
            return false;
        }
        OptimizerTimeConfig other = (OptimizerTimeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        List<String> this$latencyMetrics = this.getLatencyMetrics();
        List<String> other$latencyMetrics = other.getLatencyMetrics();
        if (this$latencyMetrics == null ? other$latencyMetrics != null : !((Object)this$latencyMetrics).equals(other$latencyMetrics)) {
            return false;
        }
        String this$timeoutMetric = this.getTimeoutMetric();
        String other$timeoutMetric = other.getTimeoutMetric();
        if (this$timeoutMetric == null ? other$timeoutMetric != null : !this$timeoutMetric.equals(other$timeoutMetric)) {
            return false;
        }
        if (Double.compare(this.getGetMethodTimeoutBuffer(), other.getGetMethodTimeoutBuffer()) != 0) {
            return false;
        }
        if (Double.compare(this.getAllMethodTimeoutBuffer(), other.getAllMethodTimeoutBuffer()) != 0) {
            return false;
        }
        String this$appLatencyMetric = this.getAppLatencyMetric();
        String other$appLatencyMetric = other.getAppLatencyMetric();
        if (this$appLatencyMetric == null ? other$appLatencyMetric != null : !this$appLatencyMetric.equals(other$appLatencyMetric)) {
            return false;
        }
        String this$apiLatencyMetric = this.getApiLatencyMetric();
        String other$apiLatencyMetric = other.getApiLatencyMetric();
        if (this$apiLatencyMetric == null ? other$apiLatencyMetric != null : !this$apiLatencyMetric.equals(other$apiLatencyMetric)) {
            return false;
        }
        return this.getAppLatencyThresholdValue() == other.getAppLatencyThresholdValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerTimeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        List<String> $latencyMetrics = this.getLatencyMetrics();
        result = result * 59 + ($latencyMetrics == null ? 43 : ((Object)$latencyMetrics).hashCode());
        String $timeoutMetric = this.getTimeoutMetric();
        result = result * 59 + ($timeoutMetric == null ? 43 : $timeoutMetric.hashCode());
        long $getMethodTimeoutBuffer = Double.doubleToLongBits(this.getGetMethodTimeoutBuffer());
        result = result * 59 + (int)($getMethodTimeoutBuffer >>> 32 ^ $getMethodTimeoutBuffer);
        long $allMethodTimeoutBuffer = Double.doubleToLongBits(this.getAllMethodTimeoutBuffer());
        result = result * 59 + (int)($allMethodTimeoutBuffer >>> 32 ^ $allMethodTimeoutBuffer);
        String $appLatencyMetric = this.getAppLatencyMetric();
        result = result * 59 + ($appLatencyMetric == null ? 43 : $appLatencyMetric.hashCode());
        String $apiLatencyMetric = this.getApiLatencyMetric();
        result = result * 59 + ($apiLatencyMetric == null ? 43 : $apiLatencyMetric.hashCode());
        result = result * 59 + this.getAppLatencyThresholdValue();
        return result;
    }

    public String toString() {
        return "OptimizerTimeConfig(enabled=" + this.isEnabled() + ", latencyMetrics=" + this.getLatencyMetrics() + ", timeoutMetric=" + this.getTimeoutMetric() + ", getMethodTimeoutBuffer=" + this.getGetMethodTimeoutBuffer() + ", allMethodTimeoutBuffer=" + this.getAllMethodTimeoutBuffer() + ", appLatencyMetric=" + this.getAppLatencyMetric() + ", apiLatencyMetric=" + this.getApiLatencyMetric() + ", appLatencyThresholdValue=" + this.getAppLatencyThresholdValue() + ")";
    }

    public OptimizerTimeConfig(boolean enabled, List<String> latencyMetrics, String timeoutMetric, double getMethodTimeoutBuffer, double allMethodTimeoutBuffer, String appLatencyMetric, String apiLatencyMetric, int appLatencyThresholdValue) {
        this.enabled = enabled;
        this.latencyMetrics = latencyMetrics;
        this.timeoutMetric = timeoutMetric;
        this.getMethodTimeoutBuffer = getMethodTimeoutBuffer;
        this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
        this.appLatencyMetric = appLatencyMetric;
        this.apiLatencyMetric = apiLatencyMetric;
        this.appLatencyThresholdValue = appLatencyThresholdValue;
    }

    public OptimizerTimeConfig() {
    }

    public static class OptimizerTimeConfigBuilder {
        private boolean enabled;
        private List<String> latencyMetrics;
        private String timeoutMetric;
        private double getMethodTimeoutBuffer;
        private double allMethodTimeoutBuffer;
        private String appLatencyMetric;
        private String apiLatencyMetric;
        private int appLatencyThresholdValue;

        OptimizerTimeConfigBuilder() {
        }

        public OptimizerTimeConfigBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OptimizerTimeConfigBuilder latencyMetrics(List<String> latencyMetrics) {
            this.latencyMetrics = latencyMetrics;
            return this;
        }

        public OptimizerTimeConfigBuilder timeoutMetric(String timeoutMetric) {
            this.timeoutMetric = timeoutMetric;
            return this;
        }

        public OptimizerTimeConfigBuilder getMethodTimeoutBuffer(double getMethodTimeoutBuffer) {
            this.getMethodTimeoutBuffer = getMethodTimeoutBuffer;
            return this;
        }

        public OptimizerTimeConfigBuilder allMethodTimeoutBuffer(double allMethodTimeoutBuffer) {
            this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
            return this;
        }

        public OptimizerTimeConfigBuilder appLatencyMetric(String appLatencyMetric) {
            this.appLatencyMetric = appLatencyMetric;
            return this;
        }

        public OptimizerTimeConfigBuilder apiLatencyMetric(String apiLatencyMetric) {
            this.apiLatencyMetric = apiLatencyMetric;
            return this;
        }

        public OptimizerTimeConfigBuilder appLatencyThresholdValue(int appLatencyThresholdValue) {
            this.appLatencyThresholdValue = appLatencyThresholdValue;
            return this;
        }

        public OptimizerTimeConfig build() {
            return new OptimizerTimeConfig(this.enabled, this.latencyMetrics, this.timeoutMetric, this.getMethodTimeoutBuffer, this.allMethodTimeoutBuffer, this.appLatencyMetric, this.apiLatencyMetric, this.appLatencyThresholdValue);
        }

        public String toString() {
            return "OptimizerTimeConfig.OptimizerTimeConfigBuilder(enabled=" + this.enabled + ", latencyMetrics=" + this.latencyMetrics + ", timeoutMetric=" + this.timeoutMetric + ", getMethodTimeoutBuffer=" + this.getMethodTimeoutBuffer + ", allMethodTimeoutBuffer=" + this.allMethodTimeoutBuffer + ", appLatencyMetric=" + this.appLatencyMetric + ", apiLatencyMetric=" + this.apiLatencyMetric + ", appLatencyThresholdValue=" + this.appLatencyThresholdValue + ")";
        }
    }
}

