/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.resilience;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.ThreadPoolGroupConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.resilience.ResilienceHttpContext;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilienceUtil {
    private static final Logger log = LoggerFactory.getLogger(ResilienceUtil.class);
    private static final Map<String, String> DEFAULT_KEY_VALUE_MAP = Maps.newHashMap();
    private static final String METRIC_PREFIX = "resilience";
    private static final String DEFAULT_CIRCUIT_BREAKER = "revolver";
    private static final Map<String, Bulkhead> POOL_VS_BULK_HEAD = Maps.newHashMap();
    private static BulkheadRegistry bulkheadRegistry;
    private static CircuitBreakerRegistry circuitBreakerRegistry;

    private ResilienceUtil() {
    }

    public static void initializeResilience(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext) {
        log.info("Initializing resilience util");
        ResilienceUtil.initializeBulkHeads(revolverConfig, resilienceHttpContext);
        ResilienceUtil.initializeCircuitBreakers(revolverConfig, resilienceHttpContext);
        ResilienceUtil.initializeTimeout(revolverConfig, resilienceHttpContext);
    }

    public static void bindResilienceMetrics(MetricRegistry metrics) {
        DropwizardMeterRegistry metricRegistry = new DropwizardMeterRegistry(new DropwizardConfig(){

            public String prefix() {
                return ResilienceUtil.METRIC_PREFIX;
            }

            public String get(String s) {
                return (String)DEFAULT_KEY_VALUE_MAP.get(s);
            }
        }, metrics, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return null;
            }
        };
        TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)bulkheadRegistry).bindTo((MeterRegistry)metricRegistry);
        TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry).bindTo((MeterRegistry)metricRegistry);
    }

    private static void initializeCircuitBreakers(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext) {
        HashMap apiVsCircuitBreaker = Maps.newHashMap();
        resilienceHttpContext.setDefaultCircuitBreaker(circuitBreakerRegistry.circuitBreaker(DEFAULT_CIRCUIT_BREAKER));
        for (RevolverServiceConfig revolverServiceConfig : revolverConfig.getServices()) {
            ResilienceUtil.updateCBForApiConfigs(apiVsCircuitBreaker, revolverServiceConfig);
            ResilienceUtil.updateCBForDefaultServiceConfig(apiVsCircuitBreaker, revolverServiceConfig);
        }
        apiVsCircuitBreaker.forEach((s, circuitBreaker) -> log.info("Resilience circuit breaker : {}, circuit break config : {} ", s, (Object)Float.valueOf(circuitBreaker.getCircuitBreakerConfig().getFailureRateThreshold())));
        resilienceHttpContext.setApiVsCircuitBreaker(apiVsCircuitBreaker);
    }

    private static void initializeBulkHeads(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext) {
        log.info("Initializing resilience bulk heads");
        for (RevolverServiceConfig revolverServiceConfig : revolverConfig.getServices()) {
            ResilienceUtil.updateBulkheadsForThreadPools(revolverServiceConfig);
            ResilienceUtil.updateBulkheadsForApiConfigs(revolverServiceConfig);
            ResilienceUtil.updateBulkHeadsForDefaultServiceConfig(revolverServiceConfig);
        }
        POOL_VS_BULK_HEAD.forEach((s, bulkhead) -> log.info("Resilience bulk head Key : {}, bulk head value : {} ", s, (Object)bulkhead.getBulkheadConfig().getMaxConcurrentCalls()));
        resilienceHttpContext.setPoolVsBulkHeadMap(POOL_VS_BULK_HEAD);
    }

    private static void initializeTimeout(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext) {
        log.info("Initializing resilience time out");
        HashMap poolVsTimeout = Maps.newHashMap();
        HashMap apiVsTimeout = Maps.newHashMap();
        for (RevolverServiceConfig revolverServiceConfig : revolverConfig.getServices()) {
            ResilienceUtil.updateTimeoutsForThreadPools(poolVsTimeout, revolverServiceConfig);
            ResilienceUtil.updateTimeoutsForApiConfigs(poolVsTimeout, apiVsTimeout, revolverServiceConfig);
            ResilienceUtil.updateTimeoutsForDefaultServiceConfig(poolVsTimeout, revolverServiceConfig);
        }
        apiVsTimeout.forEach((s, timeout) -> log.info("Resilience timeout  Key : {}, timeout value : {} ", s, timeout));
        resilienceHttpContext.setApiVsTimeout(apiVsTimeout);
    }

    private static void updateCBForApiConfigs(Map<String, CircuitBreaker> apiVsCircuitBreaker, RevolverServiceConfig revolverServiceConfig) {
        if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
            ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(revolverHttpApiConfig -> {
                String cbName = ResilienceUtil.getCbName(revolverServiceConfig, revolverHttpApiConfig);
                apiVsCircuitBreaker.putIfAbsent(cbName, circuitBreakerRegistry.circuitBreaker(cbName));
            });
        }
    }

    public static String getCbName(RevolverServiceConfig revolverServiceConfig, RevolverHttpApiConfig revolverHttpApiConfig) {
        return revolverServiceConfig.getService() + "." + revolverHttpApiConfig.getApi();
    }

    private static void updateCBForThreadPools(Map<String, CircuitBreaker> poolVsCircuitBreaker, RevolverServiceConfig revolverServiceConfig) {
        ThreadPoolGroupConfig threadPoolGroupConfig = revolverServiceConfig.getThreadPoolGroupConfig();
        if (threadPoolGroupConfig != null) {
            threadPoolGroupConfig.getThreadPools().forEach(threadPoolConfig -> {
                String threadPoolName = ResilienceUtil.getThreadPoolName(revolverServiceConfig, threadPoolConfig);
                poolVsCircuitBreaker.put(threadPoolName, circuitBreakerRegistry.circuitBreaker(threadPoolName));
            });
        }
    }

    private static void updateCBForDefaultServiceConfig(Map<String, CircuitBreaker> apiVsCircuitBreaker, RevolverServiceConfig revolverServiceConfig) {
        apiVsCircuitBreaker.put(revolverServiceConfig.getService(), circuitBreakerRegistry.circuitBreaker(revolverServiceConfig.getService()));
    }

    private static void updateBulkheadsForApiConfigs(RevolverServiceConfig revolverServiceConfig) {
        if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
            ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(revolverHttpApiConfig -> {
                if (revolverHttpApiConfig.getRuntime() != null) {
                    HystrixCommandConfig hystrixCommandConfig = revolverHttpApiConfig.getRuntime();
                    if (hystrixCommandConfig == null || hystrixCommandConfig.getThreadPool() == null) {
                        return;
                    }
                    String threadPoolName = ResilienceUtil.getThreadPoolName(revolverServiceConfig, hystrixCommandConfig.getThreadPool());
                    if (StringUtils.isNotEmpty((CharSequence)threadPoolName)) {
                        return;
                    }
                    threadPoolName = revolverServiceConfig.getService() + "." + revolverHttpApiConfig.getApi();
                    log.info("ThreadPool Name : {}, Concurrency : {} ", (Object)threadPoolName, (Object)hystrixCommandConfig.getThreadPool().getConcurrency());
                    ResilienceUtil.updateBulkheadRegistry(POOL_VS_BULK_HEAD, hystrixCommandConfig.getThreadPool(), threadPoolName);
                }
            });
        }
    }

    private static void updateBulkheadRegistry(Map<String, Bulkhead> poolVsBulkHead, ThreadPoolConfig threadPoolConfig, String threadPoolName) {
        if (poolVsBulkHead.get(threadPoolName) == null) {
            bulkheadRegistry.bulkhead(threadPoolName, BulkheadConfig.custom().maxConcurrentCalls(threadPoolConfig.getConcurrency()).build());
        } else {
            poolVsBulkHead.putIfAbsent(threadPoolName, (Bulkhead)bulkheadRegistry.replace(threadPoolName, (Object)Bulkhead.of((String)threadPoolName, (BulkheadConfig)BulkheadConfig.custom().maxConcurrentCalls(threadPoolConfig.getConcurrency()).build())).get());
        }
    }

    private static void updateBulkheadsForThreadPools(RevolverServiceConfig revolverServiceConfig) {
        ThreadPoolGroupConfig threadPoolGroupConfig = revolverServiceConfig.getThreadPoolGroupConfig();
        if (threadPoolGroupConfig != null) {
            threadPoolGroupConfig.getThreadPools().forEach(threadPoolConfig -> {
                String threadPoolName = ResilienceUtil.getThreadPoolName(revolverServiceConfig, threadPoolConfig);
                log.info("ThreadPool Name : {}, Concurrency : {} ", (Object)threadPoolName, (Object)threadPoolConfig.getConcurrency());
                ResilienceUtil.updateBulkheadRegistry(POOL_VS_BULK_HEAD, threadPoolConfig, threadPoolName);
            });
        }
    }

    private static String getThreadPoolName(RevolverServiceConfig revolverServiceConfig, ThreadPoolConfig threadPoolConfig) {
        if (StringUtils.isEmpty((CharSequence)threadPoolConfig.getThreadPoolName())) {
            return "";
        }
        return revolverServiceConfig.getService() + "." + threadPoolConfig.getThreadPoolName();
    }

    private static void updateTimeoutsForDefaultServiceConfig(Map<String, Integer> poolVsTimeout, RevolverServiceConfig revolverServiceConfig) {
        if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
            ThreadPoolConfig threadPoolConfig = revolverServiceConfig.getRuntime().getThreadPool();
            if (threadPoolConfig == null) {
                return;
            }
            poolVsTimeout.put(revolverServiceConfig.getService(), threadPoolConfig.getTimeout());
        }
    }

    private static void updateTimeoutsForThreadPools(Map<String, Integer> poolVsTimeout, RevolverServiceConfig revolverServiceConfig) {
        ThreadPoolGroupConfig threadPoolGroupConfig = revolverServiceConfig.getThreadPoolGroupConfig();
        if (threadPoolGroupConfig != null) {
            threadPoolGroupConfig.getThreadPools().forEach(threadPoolConfig -> {
                if (StringUtils.isNotEmpty((CharSequence)threadPoolConfig.getThreadPoolName())) {
                    poolVsTimeout.put(threadPoolConfig.getThreadPoolName(), threadPoolConfig.getTimeout());
                }
            });
        }
    }

    private static void updateTimeoutsForApiConfigs(Map<String, Integer> poolVsTimeout, Map<String, Integer> apiVsTimeout, RevolverServiceConfig revolverServiceConfig) {
        if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
            ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(revolverHttpApiConfig -> {
                if (revolverHttpApiConfig.getRuntime() != null) {
                    HystrixCommandConfig hystrixCommandConfig = revolverHttpApiConfig.getRuntime();
                    String apiName = ResilienceUtil.getApiName(revolverServiceConfig, revolverHttpApiConfig);
                    if (hystrixCommandConfig == null || hystrixCommandConfig.getThreadPool() == null) {
                        return;
                    }
                    ThreadPoolConfig threadPoolConfig = hystrixCommandConfig.getThreadPool();
                    if (threadPoolConfig.getTimeout() != 0) {
                        apiVsTimeout.put(apiName, threadPoolConfig.getTimeout());
                        return;
                    }
                    String threadPoolName = threadPoolConfig.getThreadPoolName();
                    if (poolVsTimeout.get(threadPoolName) != null) {
                        apiVsTimeout.put(apiName, (Integer)poolVsTimeout.get(threadPoolName));
                    }
                }
            });
        }
    }

    public static String getApiName(RevolverServiceConfig revolverServiceConfig, RevolverHttpApiConfig revolverHttpApiConfig) {
        return revolverServiceConfig.getService() + "." + revolverHttpApiConfig.getApi();
    }

    private static void updateBulkHeadsForDefaultServiceConfig(RevolverServiceConfig revolverServiceConfig) {
        if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
            ThreadPoolConfig threadPoolConfig = revolverServiceConfig.getRuntime().getThreadPool();
            if (threadPoolConfig == null) {
                return;
            }
            if (POOL_VS_BULK_HEAD.get(revolverServiceConfig.getService()) == null) {
                POOL_VS_BULK_HEAD.put(revolverServiceConfig.getService(), bulkheadRegistry.bulkhead(revolverServiceConfig.getService(), BulkheadConfig.custom().maxConcurrentCalls(threadPoolConfig.getConcurrency()).build()));
                return;
            }
            POOL_VS_BULK_HEAD.put(revolverServiceConfig.getService(), (Bulkhead)bulkheadRegistry.replace(revolverServiceConfig.getService(), (Object)Bulkhead.of((String)revolverServiceConfig.getService(), (BulkheadConfig)BulkheadConfig.custom().maxConcurrentCalls(threadPoolConfig.getConcurrency()).build())).get());
        }
    }

    static {
        DEFAULT_KEY_VALUE_MAP.put("resilience.step", "PT1M");
        DEFAULT_KEY_VALUE_MAP.put("resilience.enabled", "true");
        bulkheadRegistry = BulkheadRegistry.ofDefaults();
        circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
    }
}

