/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.persistence;

import com.google.common.base.Strings;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverCallbackResponses;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class InMemoryPersistenceProvider
implements PersistenceProvider {
    private final ConcurrentHashMap<String, RevolverCallbackRequest> callbackRequests = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RevolverCallbackResponse> callbackResponse = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RevolverRequestState> callbackStates = new ConcurrentHashMap();
    private final MultivaluedMap<String, String> mailbox = new MultivaluedHashMap();
    private final ConcurrentHashMap<String, String> requestToMailboxMap = new ConcurrentHashMap();

    @Override
    public boolean exists(String requestId) {
        return this.callbackRequests.containsKey(requestId);
    }

    @Override
    public void saveRequest(String requestId, String mailBoxId, RevolverCallbackRequest request) {
        this.callbackRequests.put(requestId, request);
        if (!StringUtils.isBlank((CharSequence)mailBoxId)) {
            this.mailbox.add((Object)mailBoxId, (Object)requestId);
            this.requestToMailboxMap.put(requestId, mailBoxId);
        }
        this.callbackStates.put(requestId, RevolverRequestState.RECEIVED);
    }

    @Override
    public void saveRequest(String requestId, String mailBoxId, RevolverCallbackRequest request, int ttl) {
        this.callbackRequests.put(requestId, request);
        if (!StringUtils.isBlank((CharSequence)mailBoxId)) {
            this.mailbox.add((Object)mailBoxId, (Object)requestId);
            this.requestToMailboxMap.put(requestId, mailBoxId);
        }
        this.callbackStates.put(requestId, RevolverRequestState.RECEIVED);
    }

    @Override
    public void setRequestState(String requestId, RevolverRequestState state, int ttl) {
        this.callbackStates.put(requestId, state);
    }

    @Override
    public void saveResponse(String requestId, RevolverCallbackResponse response, int ttl) {
        this.callbackResponse.put(requestId, response);
        this.callbackStates.put(requestId, RevolverRequestState.RESPONDED);
    }

    @Override
    public RevolverRequestState requestState(String requestId) {
        return this.callbackStates.get(requestId);
    }

    @Override
    public RevolverCallbackRequest request(String requestId) {
        return this.callbackRequests.get(requestId);
    }

    @Override
    public RevolverRequestState requestState(String requestId, String mailBoxId) {
        if (this.isInvalidMailboxId(requestId, mailBoxId)) {
            return RevolverRequestState.UNKNOWN;
        }
        return this.callbackStates.get(requestId);
    }

    private boolean isInvalidMailboxId(String requestId, String mailBoxId) {
        return !Strings.isNullOrEmpty((String)this.requestToMailboxMap.get(requestId)) && !this.requestToMailboxMap.get(requestId).equals(mailBoxId);
    }

    @Override
    public RevolverCallbackRequest request(String requestId, String mailBoxId) {
        if (this.isInvalidMailboxId(requestId, mailBoxId)) {
            return null;
        }
        return this.callbackRequests.get(requestId);
    }

    @Override
    public RevolverCallbackResponse response(String requestId, String mailBoxId) {
        if (this.isInvalidMailboxId(requestId, mailBoxId)) {
            return null;
        }
        return this.callbackResponse.get(requestId);
    }

    @Override
    public List<RevolverCallbackRequest> requests(String mailboxId) {
        List requestIds = (List)this.mailbox.get((Object)mailboxId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackRequests::containsKey).map(this.callbackRequests::get).collect(Collectors.toList());
    }

    @Override
    public List<RevolverCallbackResponses> responses(String mailboxId) {
        List requestIds = (List)this.mailbox.get((Object)mailboxId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackResponse::containsKey).map(this.callbackResponse::get).map(e -> RevolverCallbackResponses.builder().headers(e.getHeaders()).statusCode(e.getStatusCode()).body(Base64.getEncoder().encodeToString(e.getBody())).build()).collect(Collectors.toList());
    }
}

