/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

public class OptimalTimeoutAttributes {
    private int optimalTimeout;
    private int meanTimeout;
    private double timeoutBuffer;

    public static OptimalTimeoutAttributesBuilder builder() {
        return new OptimalTimeoutAttributesBuilder();
    }

    public int getOptimalTimeout() {
        return this.optimalTimeout;
    }

    public int getMeanTimeout() {
        return this.meanTimeout;
    }

    public double getTimeoutBuffer() {
        return this.timeoutBuffer;
    }

    public void setOptimalTimeout(int optimalTimeout) {
        this.optimalTimeout = optimalTimeout;
    }

    public void setMeanTimeout(int meanTimeout) {
        this.meanTimeout = meanTimeout;
    }

    public void setTimeoutBuffer(double timeoutBuffer) {
        this.timeoutBuffer = timeoutBuffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimalTimeoutAttributes)) {
            return false;
        }
        OptimalTimeoutAttributes other = (OptimalTimeoutAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOptimalTimeout() != other.getOptimalTimeout()) {
            return false;
        }
        if (this.getMeanTimeout() != other.getMeanTimeout()) {
            return false;
        }
        return Double.compare(this.getTimeoutBuffer(), other.getTimeoutBuffer()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimalTimeoutAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOptimalTimeout();
        result = result * 59 + this.getMeanTimeout();
        long $timeoutBuffer = Double.doubleToLongBits(this.getTimeoutBuffer());
        result = result * 59 + (int)($timeoutBuffer >>> 32 ^ $timeoutBuffer);
        return result;
    }

    public String toString() {
        return "OptimalTimeoutAttributes(optimalTimeout=" + this.getOptimalTimeout() + ", meanTimeout=" + this.getMeanTimeout() + ", timeoutBuffer=" + this.getTimeoutBuffer() + ")";
    }

    public OptimalTimeoutAttributes(int optimalTimeout, int meanTimeout, double timeoutBuffer) {
        this.optimalTimeout = optimalTimeout;
        this.meanTimeout = meanTimeout;
        this.timeoutBuffer = timeoutBuffer;
    }

    public OptimalTimeoutAttributes() {
    }

    public static class OptimalTimeoutAttributesBuilder {
        private int optimalTimeout;
        private int meanTimeout;
        private double timeoutBuffer;

        OptimalTimeoutAttributesBuilder() {
        }

        public OptimalTimeoutAttributesBuilder optimalTimeout(int optimalTimeout) {
            this.optimalTimeout = optimalTimeout;
            return this;
        }

        public OptimalTimeoutAttributesBuilder meanTimeout(int meanTimeout) {
            this.meanTimeout = meanTimeout;
            return this;
        }

        public OptimalTimeoutAttributesBuilder timeoutBuffer(double timeoutBuffer) {
            this.timeoutBuffer = timeoutBuffer;
            return this;
        }

        public OptimalTimeoutAttributes build() {
            return new OptimalTimeoutAttributes(this.optimalTimeout, this.meanTimeout, this.timeoutBuffer);
        }

        public String toString() {
            return "OptimalTimeoutAttributes.OptimalTimeoutAttributesBuilder(optimalTimeout=" + this.optimalTimeout + ", meanTimeout=" + this.meanTimeout + ", timeoutBuffer=" + this.timeoutBuffer + ")";
        }
    }
}

