/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.splitting;

public class SplitConfig {
    private String path;
    private String service;
    private double wrr;
    private double from;
    private double to;

    public static SplitConfigBuilder builder() {
        return new SplitConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getService() {
        return this.service;
    }

    public double getWrr() {
        return this.wrr;
    }

    public double getFrom() {
        return this.from;
    }

    public double getTo() {
        return this.to;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setWrr(double wrr) {
        this.wrr = wrr;
    }

    public void setFrom(double from) {
        this.from = from;
    }

    public void setTo(double to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitConfig)) {
            return false;
        }
        SplitConfig other = (SplitConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        if (Double.compare(this.getWrr(), other.getWrr()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrom(), other.getFrom()) != 0) {
            return false;
        }
        return Double.compare(this.getTo(), other.getTo()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SplitConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        long $wrr = Double.doubleToLongBits(this.getWrr());
        result = result * 59 + (int)($wrr >>> 32 ^ $wrr);
        long $from = Double.doubleToLongBits(this.getFrom());
        result = result * 59 + (int)($from >>> 32 ^ $from);
        long $to = Double.doubleToLongBits(this.getTo());
        result = result * 59 + (int)($to >>> 32 ^ $to);
        return result;
    }

    public String toString() {
        return "SplitConfig(path=" + this.getPath() + ", service=" + this.getService() + ", wrr=" + this.getWrr() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public SplitConfig(String path, String service, double wrr, double from, double to) {
        this.path = path;
        this.service = service;
        this.wrr = wrr;
        this.from = from;
        this.to = to;
    }

    public SplitConfig() {
    }

    public static class SplitConfigBuilder {
        private String path;
        private String service;
        private double wrr;
        private double from;
        private double to;

        SplitConfigBuilder() {
        }

        public SplitConfigBuilder path(String path) {
            this.path = path;
            return this;
        }

        public SplitConfigBuilder service(String service) {
            this.service = service;
            return this;
        }

        public SplitConfigBuilder wrr(double wrr) {
            this.wrr = wrr;
            return this;
        }

        public SplitConfigBuilder from(double from) {
            this.from = from;
            return this;
        }

        public SplitConfigBuilder to(double to) {
            this.to = to;
            return this;
        }

        public SplitConfig build() {
            return new SplitConfig(this.path, this.service, this.wrr, this.from, this.to);
        }

        public String toString() {
            return "SplitConfig.SplitConfigBuilder(path=" + this.path + ", service=" + this.service + ", wrr=" + this.wrr + ", from=" + this.from + ", to=" + this.to + ")";
        }
    }
}

