/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.collect.Maps;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.resilience.ResilienceHttpContext;
import io.dropwizard.revolver.core.resilience.ResilienceUtil;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.optimizer.OptimalThreadPoolAttributes;
import io.dropwizard.revolver.optimizer.OptimalTimeoutAttributes;
import io.dropwizard.revolver.optimizer.OptimizerAggregatedMetric;
import io.dropwizard.revolver.optimizer.OptimizerCacheKey;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConcurrencyConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerTimeConfig;
import io.dropwizard.revolver.optimizer.hystrix.metrics.AggregationAlgo;
import io.dropwizard.revolver.optimizer.hystrix.metrics.ThreadPoolMetric;
import io.dropwizard.revolver.optimizer.resilience.metrics.BulkheadMetric;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverConfigUpdater
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RevolverConfigUpdater.class);
    private RevolverConfig revolverConfig;
    private OptimizerConfig optimizerConfig;
    private ResilienceHttpContext resilienceHttpContext;
    private OptimizerMetricsCache optimizerMetricsCache;
    private static final int DEFAULT_CONCURRENCY = 2;

    @Override
    public void run() {
        try {
            log.info("Running revolver config updater job with exception catching enabled");
            long time = System.currentTimeMillis();
            Map<OptimizerCacheKey, OptimizerMetrics> metricsCache = this.optimizerMetricsCache.getCache();
            if (metricsCache.isEmpty()) {
                log.info("Metrics cache is empty");
                return;
            }
            HashMap aggregatedAppLatencyMetrics = Maps.newHashMap();
            HashMap apiLevelThreadPoolMetrics = Maps.newHashMap();
            HashMap apiLevelBulkheadMetrics = Maps.newHashMap();
            HashMap aggregateApiLevelLatencyMetrics = Maps.newHashMap();
            metricsCache.forEach((key, optimizerMetrics) -> optimizerMetrics.getMetrics().forEach((metric, value) -> {
                this.aggregateAppLevelLatencyMetrics(aggregatedAppLatencyMetrics, (String)metric, (Number)value);
                this.aggregateApiLevelMetrics(apiLevelThreadPoolMetrics, apiLevelBulkheadMetrics, aggregateApiLevelLatencyMetrics, (String)metric, (Number)value, (OptimizerCacheKey)key);
            }));
            Map<String, Number> appLevelLatencyMetrics = this.avgAppLevelLatencyMetrics(aggregatedAppLatencyMetrics);
            Map<String, OptimizerMetrics> apiLevelLatencyMetrics = this.avgApiLevelLatencyMetrics(aggregateApiLevelLatencyMetrics);
            log.debug("Aggregated appLevelLatencyMetrics at time: " + time + " : " + appLevelLatencyMetrics);
            log.debug("Aggregated apiLevelLatencyMetrics at time: " + time + " : " + apiLevelLatencyMetrics);
            log.debug("APILevelBulkheadMetrics at time: " + time + " : " + apiLevelBulkheadMetrics);
            log.debug("APILevelThreadpoolMetrics at time: " + time + " : " + apiLevelThreadPoolMetrics);
            this.updateRevolverConfig(apiLevelThreadPoolMetrics, apiLevelBulkheadMetrics, apiLevelLatencyMetrics);
            this.updateLatencyThreshold(appLevelLatencyMetrics);
        }
        catch (Exception e) {
            log.error("Revolver config couldn't be updated : " + e);
        }
    }

    private void updateRevolverConfig(Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, OptimizerMetrics> apiLevelBulkheadMetrics, Map<String, OptimizerMetrics> apiLevelLatencyMetrics) {
        AtomicBoolean configUpdated = new AtomicBoolean();
        this.revolverConfig.getServices().forEach(revolverServiceConfig -> {
            if (revolverServiceConfig.getThreadPoolGroupConfig() != null) {
                revolverServiceConfig.getThreadPoolGroupConfig().getThreadPools().forEach(threadPoolConfig -> {
                    OptimizerMetrics optimizerThreadPoolMetrics = (OptimizerMetrics)apiLevelThreadPoolMetrics.get(threadPoolConfig.getThreadPoolName());
                    OptimizerMetrics optimizerBulkheadMetrics = (OptimizerMetrics)apiLevelBulkheadMetrics.get(revolverServiceConfig.getService() + "." + threadPoolConfig.getThreadPoolName());
                    this.updateConcurrencySettingForPool((ThreadPoolConfig)threadPoolConfig, optimizerThreadPoolMetrics, optimizerBulkheadMetrics, configUpdated, threadPoolConfig.getThreadPoolName());
                });
            }
            if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
                ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(api -> this.updateApiSettings((RevolverServiceConfig)revolverServiceConfig, (RevolverHttpApiConfig)api, apiLevelThreadPoolMetrics, apiLevelBulkheadMetrics, apiLevelLatencyMetrics, configUpdated));
            }
        });
        if (configUpdated.get()) {
            log.debug("Updating revolver config to : " + (Object)((Object)this.revolverConfig));
            ResilienceUtil.initializeResilience(this.revolverConfig, this.resilienceHttpContext);
            RevolverBundle.loadServiceConfiguration(this.revolverConfig);
        }
    }

    private void updateConcurrencySettingForPool(ThreadPoolConfig threadPoolConfig, OptimizerMetrics optimizerThreadPoolMetrics, OptimizerMetrics optimizerBulkheadMetrics, AtomicBoolean configUpdated, String poolName) {
        OptimalThreadPoolAttributes optimalThreadPoolAttributes = this.calculateOptimalThreadPoolSize(threadPoolConfig.getConcurrency(), threadPoolConfig.getInitialConcurrency(), poolName, optimizerThreadPoolMetrics, optimizerBulkheadMetrics);
        if (optimalThreadPoolAttributes.getOptimalConcurrency() != threadPoolConfig.getConcurrency()) {
            log.info("Setting concurrency for pool : " + poolName + " from : " + threadPoolConfig.getConcurrency() + " to : " + optimalThreadPoolAttributes.getOptimalConcurrency() + ", maxRollingActiveThreads : " + optimalThreadPoolAttributes.getMaxRollingActiveThreads());
            threadPoolConfig.setConcurrency(optimalThreadPoolAttributes.getOptimalConcurrency());
            configUpdated.set(true);
        }
    }

    private void updateApiSettings(RevolverServiceConfig serviceConfig, RevolverHttpApiConfig apiConfig, Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, OptimizerMetrics> apiLevelBulkheadMetrics, Map<String, OptimizerMetrics> apiLevelLatencyMetrics, AtomicBoolean configUpdated) {
        String key = serviceConfig.getService() + "." + apiConfig.getApi();
        OptimizerMetrics optimizerLatencyMetrics = apiLevelLatencyMetrics.get(key);
        OptimizerMetrics optimizerThreadPoolMetrics = apiLevelThreadPoolMetrics.get(key);
        OptimizerMetrics optimizerBulkheadMetrics = apiLevelBulkheadMetrics.get(key);
        if (optimizerThreadPoolMetrics != null || optimizerBulkheadMetrics != null) {
            this.updateConcurrencySettingForCommand(apiConfig.getRuntime().getThreadPool(), optimizerThreadPoolMetrics, optimizerBulkheadMetrics, configUpdated, key);
        }
        if (optimizerLatencyMetrics != null) {
            this.updateTimeoutSettingForCommand(apiConfig.getRuntime().getThreadPool(), optimizerLatencyMetrics, configUpdated, key);
        }
    }

    private void updateConcurrencySettingForCommand(ThreadPoolConfig threadPoolConfig, OptimizerMetrics optimizerThreadPoolMetrics, OptimizerMetrics optimizerBulkheadMetrics, AtomicBoolean configUpdated, String poolName) {
        OptimalThreadPoolAttributes optimalThreadPoolAttributes = this.calculateOptimalThreadPoolSize(threadPoolConfig.getConcurrency(), threadPoolConfig.getInitialConcurrency(), poolName, optimizerThreadPoolMetrics, optimizerBulkheadMetrics);
        if (optimalThreadPoolAttributes.getOptimalConcurrency() != threadPoolConfig.getConcurrency()) {
            log.info("Setting concurrency for command : " + poolName + " from : " + threadPoolConfig.getConcurrency() + " to : " + optimalThreadPoolAttributes.getOptimalConcurrency() + ", maxRollingActiveThreads : " + optimalThreadPoolAttributes.getMaxRollingActiveThreads());
            threadPoolConfig.setConcurrency(optimalThreadPoolAttributes.getOptimalConcurrency());
            configUpdated.set(true);
        }
    }

    private void updateTimeoutSettingForCommand(ThreadPoolConfig threadPoolConfig, OptimizerMetrics optimizerLatencyMetrics, AtomicBoolean configUpdated, String commandName) {
        OptimalTimeoutAttributes optimalTimeoutAttributes = this.calculateOptimalTimeout(threadPoolConfig.getTimeout(), optimizerLatencyMetrics);
        if (optimalTimeoutAttributes.getOptimalTimeout() != threadPoolConfig.getTimeout()) {
            threadPoolConfig.setTimeout(optimalTimeoutAttributes.getOptimalTimeout());
            configUpdated.set(true);
            log.info("Setting timeout for : " + commandName + " from : " + threadPoolConfig.getTimeout() + " to : " + optimalTimeoutAttributes.getOptimalTimeout() + ", meanTimeoutValue : " + optimalTimeoutAttributes.getMeanTimeout() + ", with timeout buffer : " + optimalTimeoutAttributes.getTimeoutBuffer());
        }
    }

    private OptimalTimeoutAttributes calculateOptimalTimeout(int currentTimeout, OptimizerMetrics optimizerLatencyMetrics) {
        OptimalTimeoutAttributes.OptimalTimeoutAttributesBuilder initialTimeoutAttributesBuilder = OptimalTimeoutAttributes.builder().optimalTimeout(currentTimeout);
        OptimizerTimeConfig timeoutConfig = this.optimizerConfig.getTimeConfig();
        if (timeoutConfig == null || !timeoutConfig.isEnabled() || !optimizerLatencyMetrics.getMetrics().containsKey(timeoutConfig.getTimeoutMetric())) {
            return initialTimeoutAttributesBuilder.build();
        }
        int meanTimeoutValue = optimizerLatencyMetrics.getMetrics().get(timeoutConfig.getTimeoutMetric()).intValue();
        if (meanTimeoutValue <= 0) {
            return initialTimeoutAttributesBuilder.meanTimeout(meanTimeoutValue).build();
        }
        double timeoutBuffer = timeoutConfig.getAllMethodTimeoutBuffer();
        if (currentTimeout < meanTimeoutValue || (double)currentTimeout > (double)meanTimeoutValue * timeoutBuffer) {
            return OptimalTimeoutAttributes.builder().meanTimeout(meanTimeoutValue).timeoutBuffer(timeoutBuffer).optimalTimeout((int)((double)meanTimeoutValue * timeoutBuffer)).build();
        }
        return initialTimeoutAttributesBuilder.meanTimeout(meanTimeoutValue).timeoutBuffer(timeoutBuffer).build();
    }

    private void aggregateAppLevelLatencyMetrics(Map<String, OptimizerAggregatedMetric> aggregatedAppLatencyMetrics, String metric, Number value) {
        OptimizerTimeConfig optimizerTimeConfig = this.optimizerConfig.getTimeConfig();
        if (optimizerTimeConfig == null || !optimizerTimeConfig.isEnabled() || !optimizerTimeConfig.getLatencyMetrics().contains(metric) || value.intValue() == 0) {
            return;
        }
        if (!aggregatedAppLatencyMetrics.containsKey(metric)) {
            aggregatedAppLatencyMetrics.put(metric, OptimizerAggregatedMetric.builder().sum(0L).count(0L).build());
        }
        OptimizerAggregatedMetric optimizerAggregatedMetrics = aggregatedAppLatencyMetrics.get(metric);
        optimizerAggregatedMetrics.setSum(optimizerAggregatedMetrics.getSum() + value.longValue());
        optimizerAggregatedMetrics.setCount(optimizerAggregatedMetrics.getCount() + 1L);
        aggregatedAppLatencyMetrics.forEach((metricName, aggregatedAppMetrics) -> log.info("Aggregated " + metricName + " for app: " + aggregatedAppMetrics.getSum() / aggregatedAppMetrics.getCount()));
    }

    private void aggregateApiLevelMetrics(Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, OptimizerMetrics> apiLevelBulkheadMetrics, Map<String, Map<String, OptimizerAggregatedMetric>> aggregateApiLevelLatencyMetrics, String metric, Number value, OptimizerCacheKey key) {
        AggregationAlgo aggregationAlgo = key.getMetricType().getAggregationAlgo();
        switch (aggregationAlgo) {
            case MAX: {
                Map<String, Number> threadPoolMetricsMap = this.getNullSafeOptimizerMetricsMap(apiLevelThreadPoolMetrics, key);
                if (threadPoolMetricsMap.containsKey(metric) && threadPoolMetricsMap.get(metric).intValue() >= value.intValue()) break;
                threadPoolMetricsMap.put(metric, value);
                break;
            }
            case MIN: {
                Map<String, Number> bulkheadMetricsMap = this.getNullSafeOptimizerMetricsMap(apiLevelBulkheadMetrics, key);
                if (bulkheadMetricsMap.containsKey(metric) && bulkheadMetricsMap.get(metric).intValue() <= value.intValue()) break;
                bulkheadMetricsMap.put(metric, value);
                break;
            }
            case AVG: {
                OptimizerAggregatedMetric optimizerAggregatedMetric = this.getAggregateMetricsMap(aggregateApiLevelLatencyMetrics, key, metric);
                optimizerAggregatedMetric.setSum(optimizerAggregatedMetric.getSum() + value.longValue());
                optimizerAggregatedMetric.setCount(optimizerAggregatedMetric.getCount() + 1L);
            }
        }
    }

    private Map<String, Number> getNullSafeOptimizerMetricsMap(Map<String, OptimizerMetrics> maxedThreadPoolMetrics, OptimizerCacheKey key) {
        if (!maxedThreadPoolMetrics.containsKey(key.getName())) {
            maxedThreadPoolMetrics.put(key.getName(), OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
        }
        OptimizerMetrics optimizerAggregatedMetrics = maxedThreadPoolMetrics.get(key.getName());
        return optimizerAggregatedMetrics.getMetrics();
    }

    private OptimizerAggregatedMetric getAggregateMetricsMap(Map<String, Map<String, OptimizerAggregatedMetric>> aggregatedMetrics, OptimizerCacheKey key, String metric) {
        if (!aggregatedMetrics.containsKey(key.getName())) {
            aggregatedMetrics.put(key.getName(), Maps.newHashMap());
        }
        if (!aggregatedMetrics.get(key.getName()).containsKey(metric)) {
            aggregatedMetrics.get(key.getName()).put(metric, OptimizerAggregatedMetric.builder().sum(0L).count(0L).build());
        }
        return aggregatedMetrics.get(key.getName()).get(metric);
    }

    private Map<String, Number> avgAppLevelLatencyMetrics(Map<String, OptimizerAggregatedMetric> overallAppLatencyMetrics) {
        HashMap aggregatedAppLevelLatencyMetrics = Maps.newHashMap();
        overallAppLatencyMetrics.forEach((metricName, aggregatedAppMetrics) -> aggregatedAppLevelLatencyMetrics.put(metricName, aggregatedAppMetrics.getSum() / aggregatedAppMetrics.getCount()));
        return aggregatedAppLevelLatencyMetrics;
    }

    private Map<String, OptimizerMetrics> avgApiLevelLatencyMetrics(Map<String, Map<String, OptimizerAggregatedMetric>> aggregatedLatencyMetrics) {
        HashMap aggregateApiLevelLatencyMetrics = Maps.newHashMap();
        aggregatedLatencyMetrics.forEach((keyName, latencyMetricMap) -> {
            if (!aggregateApiLevelLatencyMetrics.containsKey(keyName)) {
                aggregateApiLevelLatencyMetrics.put(keyName, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
            }
            latencyMetricMap.forEach((metric, aggregateMetric) -> ((OptimizerMetrics)aggregateApiLevelLatencyMetrics.get(keyName)).getMetrics().put((String)metric, aggregateMetric.getSum() / aggregateMetric.getCount()));
        });
        return aggregateApiLevelLatencyMetrics;
    }

    private OptimalThreadPoolAttributes calculateOptimalThreadPoolSize(int currentConcurrency, int initialConcurrency, String poolName, OptimizerMetrics optimizerThreadPoolMetrics, OptimizerMetrics optimizerBulkheadMetrics) {
        OptimalThreadPoolAttributes.OptimalThreadPoolAttributesBuilder initialConcurrencyAttrBuilder = OptimalThreadPoolAttributes.builder().optimalConcurrency(currentConcurrency);
        OptimizerConcurrencyConfig concurrencyConfig = this.optimizerConfig.getConcurrencyConfig();
        if (!(concurrencyConfig != null && concurrencyConfig.isEnabled() && (optimizerThreadPoolMetrics != null && optimizerThreadPoolMetrics.getMetrics().containsKey(ThreadPoolMetric.ROLLING_MAX_ACTIVE_THREADS.getMetricName()) || optimizerBulkheadMetrics != null && optimizerBulkheadMetrics.getMetrics().containsKey(BulkheadMetric.BULKHEAD_AVAILABLE_CONCURRENT_CALLS.getMetricName())))) {
            log.error("No concurrency metrics found for pool : {} ", (Object)poolName);
            return initialConcurrencyAttrBuilder.build();
        }
        int maxRollingActiveThreads = this.calculateMaxRollingActiveThreads(currentConcurrency, optimizerThreadPoolMetrics, optimizerBulkheadMetrics, poolName);
        log.info("Optimizer Concurrency Settings Enabled : {}, Max Threads Multiplier : {}, Max Threshold : {}, Initial Concurrency : {}, Current Concurrency: {}, MaxRollingActiveThreads : {}, Pool Name: {}", new Object[]{concurrencyConfig.isEnabled(), concurrencyConfig.getMaxPoolExpansionLimit(), concurrencyConfig.getMaxThreshold(), initialConcurrency, currentConcurrency, maxRollingActiveThreads, poolName});
        if (maxRollingActiveThreads == 0) {
            return OptimalThreadPoolAttributes.builder().optimalConcurrency(2).maxRollingActiveThreads(maxRollingActiveThreads).build();
        }
        if (((double)maxRollingActiveThreads > (double)currentConcurrency * concurrencyConfig.getMaxThreshold() || (double)maxRollingActiveThreads < (double)currentConcurrency * concurrencyConfig.getMinThreshold()) && (double)maxRollingActiveThreads < (double)initialConcurrency * concurrencyConfig.getMaxPoolExpansionLimit()) {
            int optimalConcurrency = (int)Math.ceil((double)maxRollingActiveThreads * concurrencyConfig.getThreadsMultiplier());
            return OptimalThreadPoolAttributes.builder().optimalConcurrency(optimalConcurrency).maxRollingActiveThreads(maxRollingActiveThreads).build();
        }
        return initialConcurrencyAttrBuilder.maxRollingActiveThreads(maxRollingActiveThreads).build();
    }

    private int calculateMaxRollingActiveThreads(int currentConcurrency, OptimizerMetrics optimizerThreadPoolMetrics, OptimizerMetrics optimizerBulkheadMetrics, String poolName) {
        log.info("Calculating maxRollingActiveThreads for command/pool : " + poolName + " from optimizerThreadPoolMetrics: " + optimizerThreadPoolMetrics + " optimizerBulkheadMetrics: " + optimizerBulkheadMetrics);
        int hystrixMaxActiveThreads = optimizerThreadPoolMetrics != null ? optimizerThreadPoolMetrics.getMetrics().getOrDefault(ThreadPoolMetric.ROLLING_MAX_ACTIVE_THREADS.getMetricName(), new AtomicInteger(0)).intValue() : 0;
        int availableCalls = optimizerBulkheadMetrics != null ? optimizerBulkheadMetrics.getMetrics().getOrDefault(BulkheadMetric.BULKHEAD_AVAILABLE_CONCURRENT_CALLS.getMetricName(), new AtomicInteger(currentConcurrency)).intValue() : 0;
        int bulkheadActiveCalls = currentConcurrency - availableCalls;
        log.info("currentConcurrency: {}, resilience4jBulkheadAvailableConcurrent_calls : {}", (Object)currentConcurrency, (Object)availableCalls);
        return Math.max(hystrixMaxActiveThreads, bulkheadActiveCalls);
    }

    private void updateLatencyThreshold(Map<String, Number> aggregatedAppLevelMetricsValues) {
        OptimizerTimeConfig optimizerTimeConfig = this.optimizerConfig.getTimeConfig();
        if (optimizerTimeConfig == null || !optimizerTimeConfig.isEnabled() || aggregatedAppLevelMetricsValues.get(optimizerTimeConfig.getAppLatencyMetric()) == null) {
            return;
        }
        int latencyThresholdValue = aggregatedAppLevelMetricsValues.get(optimizerTimeConfig.getAppLatencyMetric()).intValue();
        optimizerTimeConfig.setAppLatencyThresholdValue(latencyThresholdValue);
    }

    public static RevolverConfigUpdaterBuilder builder() {
        return new RevolverConfigUpdaterBuilder();
    }

    public RevolverConfig getRevolverConfig() {
        return this.revolverConfig;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public ResilienceHttpContext getResilienceHttpContext() {
        return this.resilienceHttpContext;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public void setRevolverConfig(RevolverConfig revolverConfig) {
        this.revolverConfig = revolverConfig;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public void setResilienceHttpContext(ResilienceHttpContext resilienceHttpContext) {
        this.resilienceHttpContext = resilienceHttpContext;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverConfigUpdater)) {
            return false;
        }
        RevolverConfigUpdater other = (RevolverConfigUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RevolverConfig this$revolverConfig = this.getRevolverConfig();
        RevolverConfig other$revolverConfig = other.getRevolverConfig();
        if (this$revolverConfig == null ? other$revolverConfig != null : !((Object)((Object)this$revolverConfig)).equals((Object)other$revolverConfig)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        if (this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig)) {
            return false;
        }
        ResilienceHttpContext this$resilienceHttpContext = this.getResilienceHttpContext();
        ResilienceHttpContext other$resilienceHttpContext = other.getResilienceHttpContext();
        if (this$resilienceHttpContext == null ? other$resilienceHttpContext != null : !((Object)this$resilienceHttpContext).equals(other$resilienceHttpContext)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        return !(this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverConfigUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevolverConfig $revolverConfig = this.getRevolverConfig();
        result = result * 59 + ($revolverConfig == null ? 43 : ((Object)((Object)$revolverConfig)).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        ResilienceHttpContext $resilienceHttpContext = this.getResilienceHttpContext();
        result = result * 59 + ($resilienceHttpContext == null ? 43 : ((Object)$resilienceHttpContext).hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverConfigUpdater(revolverConfig=" + (Object)((Object)this.getRevolverConfig()) + ", optimizerConfig=" + this.getOptimizerConfig() + ", resilienceHttpContext=" + this.getResilienceHttpContext() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ")";
    }

    public RevolverConfigUpdater() {
    }

    public RevolverConfigUpdater(RevolverConfig revolverConfig, OptimizerConfig optimizerConfig, ResilienceHttpContext resilienceHttpContext, OptimizerMetricsCache optimizerMetricsCache) {
        this.revolverConfig = revolverConfig;
        this.optimizerConfig = optimizerConfig;
        this.resilienceHttpContext = resilienceHttpContext;
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public static class RevolverConfigUpdaterBuilder {
        private RevolverConfig revolverConfig;
        private OptimizerConfig optimizerConfig;
        private ResilienceHttpContext resilienceHttpContext;
        private OptimizerMetricsCache optimizerMetricsCache;

        RevolverConfigUpdaterBuilder() {
        }

        public RevolverConfigUpdaterBuilder revolverConfig(RevolverConfig revolverConfig) {
            this.revolverConfig = revolverConfig;
            return this;
        }

        public RevolverConfigUpdaterBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public RevolverConfigUpdaterBuilder resilienceHttpContext(ResilienceHttpContext resilienceHttpContext) {
            this.resilienceHttpContext = resilienceHttpContext;
            return this;
        }

        public RevolverConfigUpdaterBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public RevolverConfigUpdater build() {
            return new RevolverConfigUpdater(this.revolverConfig, this.optimizerConfig, this.resilienceHttpContext, this.optimizerMetricsCache);
        }

        public String toString() {
            return "RevolverConfigUpdater.RevolverConfigUpdaterBuilder(revolverConfig=" + (Object)((Object)this.revolverConfig) + ", optimizerConfig=" + this.optimizerConfig + ", resilienceHttpContext=" + this.resilienceHttpContext + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ")";
        }
    }
}

