/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.sentinel;

import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.google.common.collect.Lists;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.sentinel.SentinelCommandConfig;
import io.dropwizard.revolver.core.config.sentinel.SentinelFlowControlConfig;
import io.dropwizard.revolver.core.sentinel.SentinelRules;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelUtil {
    private static final Logger log = LoggerFactory.getLogger(SentinelUtil.class);

    public static void initializeSentinel(RevolverConfig revolverConfig) {
        ArrayList rulesInitialized = Lists.newArrayList();
        SentinelRules sentinelRules = new SentinelRules();
        block6: for (RevolverServiceConfig config : revolverConfig.getServices()) {
            String type;
            if (config.getSentinelCommandConfig() == null) continue;
            SentinelCommandConfig sentinelCommandConfig = config.getSentinelCommandConfig();
            SentinelUtil.addRules(sentinelCommandConfig, sentinelRules, rulesInitialized);
            switch (type = config.getType()) {
                case "http": {
                    SentinelUtil.addRulesForApis((RevolverHttpServiceConfig)config, sentinelRules, rulesInitialized);
                    continue block6;
                }
            }
            log.warn("Unsupported Service type: " + type);
        }
        SentinelUtil.initializeRules(sentinelRules);
    }

    private static void initializeRules(SentinelRules sentinelRules) {
        FlowRuleManager.loadRules(sentinelRules.getFlowRules());
    }

    private static void addRules(SentinelCommandConfig sentinelCommandConfig, SentinelRules sentinelRules, List<String> poolsInitialized) {
        if (sentinelCommandConfig == null) {
            return;
        }
        SentinelUtil.addFlowRules(sentinelCommandConfig.getFlowControlConfig(), sentinelRules, poolsInitialized);
    }

    private static void addFlowRules(SentinelFlowControlConfig flowControlConfig, SentinelRules sentinelRules, List<String> poolsInitialized) {
        if (flowControlConfig == null || StringUtils.isEmpty((CharSequence)flowControlConfig.getPoolName()) || poolsInitialized.contains(flowControlConfig.getPoolName())) {
            return;
        }
        poolsInitialized.add(flowControlConfig.getPoolName());
        FlowRule flowRule = new FlowRule();
        flowRule.setResource(flowControlConfig.getPoolName());
        flowRule.setCount(flowControlConfig.getConcurrency());
        SentinelUtil.setGrade(flowRule, flowControlConfig);
        SentinelUtil.setControlBehaviour(flowRule, flowControlConfig);
        sentinelRules.getFlowRules().add(flowRule);
    }

    private static void setGrade(FlowRule flowRule, SentinelFlowControlConfig flowControlConfig) {
        if (flowControlConfig.getGrade() == null) {
            flowRule.setGrade(0);
            return;
        }
        switch (flowControlConfig.getGrade()) {
            case FLOW_GRADE_QPS: {
                flowRule.setGrade(1);
                break;
            }
            case FLOW_GRADE_THREAD: {
                flowRule.setGrade(0);
            }
        }
    }

    private static void setControlBehaviour(FlowRule flowRule, SentinelFlowControlConfig flowControlConfig) {
        if (flowControlConfig.getSentinelControlBehavior() == null) {
            flowRule.setControlBehavior(0);
            return;
        }
        switch (flowControlConfig.getSentinelControlBehavior()) {
            case CONTROL_BEHAVIOR_DEFAULT: {
                flowRule.setControlBehavior(0);
                break;
            }
            case CONTROL_BEHAVIOR_WARM_UP: {
                flowRule.setControlBehavior(1);
                break;
            }
            case CONTROL_BEHAVIOR_RATE_LIMITER: {
                flowRule.setControlBehavior(2);
            }
        }
    }

    private static void addRulesForApis(RevolverHttpServiceConfig config, SentinelRules sentinelRules, List<String> rulesInitialized) {
        config.getApis().forEach(revolverHttpApiConfig -> SentinelUtil.addRules(revolverHttpApiConfig.getSentinelRunTime(), sentinelRules, rulesInitialized));
    }
}

