/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.resilience;

import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverContext;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.resilience.ResilienceHttpContext;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilienceCommandHelper<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig> {
    private static final Logger log = LoggerFactory.getLogger(ResilienceCommandHelper.class);
    private final RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler;
    private final RequestType request;
    private final ContextType context;

    public ResilienceCommandHelper(ContextType context, RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler, RequestType request) {
        this.context = context;
        this.handler = handler;
        this.request = request;
    }

    public ResponseType executeSync() throws Exception {
        log.info("Executing resilience in sync");
        return this.execute();
    }

    public CompletableFuture<ResponseType> executeASync() {
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.execute();
                }
                catch (Exception e) {
                    throw this.getException(e);
                }
            });
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private ResilienceHttpContext getResilienceContext() {
        ResilienceHttpContext resilienceHttpContext = this.context instanceof ResilienceHttpContext ? (ResilienceHttpContext)this.context : new ResilienceHttpContext();
        return resilienceHttpContext;
    }

    private Bulkhead getBulkHead(ResilienceHttpContext resilienceHttpContext, RequestType request, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigurationType apiConfiguration) {
        String threadPoolName = this.getThreadPoolName(request, apiConfiguration);
        Bulkhead bulkhead = resilienceHttpContext.getPoolVsBulkHeadMap().get(threadPoolName);
        if (bulkhead != null) {
            return bulkhead;
        }
        log.info("No bulk head defined for threadpool {} service {}, api {}", new Object[]{threadPoolName, ((RevolverRequest)request).getService(), ((RevolverRequest)request).getApi()});
        threadPoolName = ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getThreadPoolName();
        bulkhead = resilienceHttpContext.getPoolVsBulkHeadMap().get(threadPoolName);
        if (bulkhead == null) {
            log.info("No bulk head defined for service {}, api {} threadpoolName", new Object[]{((RevolverRequest)request).getService(), ((RevolverRequest)request).getApi(), threadPoolName});
            bulkhead = Bulkhead.ofDefaults((String)"revolver");
        }
        return bulkhead;
    }

    private String getThreadPoolName(RequestType request, CommandHandlerConfigurationType apiConfiguration) {
        ThreadPoolConfig threadPoolConfig = ((CommandHandlerConfig)apiConfiguration).getRuntime().getThreadPool();
        String threadPoolName = threadPoolConfig.getThreadPoolName();
        if (StringUtils.isEmpty((CharSequence)threadPoolName)) {
            threadPoolName = ((RevolverRequest)request).getService() + "." + ((RevolverRequest)request).getApi();
        }
        return ((RevolverRequest)request).getService() + "." + threadPoolName;
    }

    private TimeLimiter getTimeoutConfig(ResilienceHttpContext resilienceHttpContext, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigurationType apiConfiguration) {
        long ttl = 0L;
        Map<String, Integer> poolVsTimeout = resilienceHttpContext.getPoolVsTimeout();
        if ((ttl = this.getTtlFromApiConfig(apiConfiguration, ttl, poolVsTimeout)) == 0L) {
            ttl = this.getTtlFromServiceConfig(serviceConfiguration, poolVsTimeout);
        }
        TimeLimiterConfig config = TimeLimiterConfig.custom().timeoutDuration(Duration.ofMillis(ttl)).build();
        return TimeLimiter.of((TimeLimiterConfig)config);
    }

    private long getTtlFromServiceConfig(ServiceConfigurationType serviceConfiguration, Map<String, Integer> poolVsTimeout) {
        long ttl;
        String threadPoolName = ((RevolverServiceConfig)serviceConfiguration).getService() + "." + ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getThreadPoolName();
        if (StringUtils.isNotEmpty((CharSequence)threadPoolName) && poolVsTimeout.get(threadPoolName) != 0) {
            ttl = poolVsTimeout.get(threadPoolName).intValue();
            log.info("TTL for threadPoolName : {}, ttl : {}", (Object)threadPoolName, (Object)ttl);
        } else {
            ttl = ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getTimeout();
        }
        log.info("TTL from service config for threadPoolName : {}, ttl : {}", (Object)threadPoolName, (Object)ttl);
        return ttl;
    }

    private long getTtlFromApiConfig(CommandHandlerConfigurationType apiConfiguration, long ttl, Map<String, Integer> poolVsTimeout) {
        ThreadPoolConfig threadPoolConfig = ((CommandHandlerConfig)apiConfiguration).getRuntime().getThreadPool();
        if (threadPoolConfig != null && threadPoolConfig.getTimeout() != 0) {
            ttl = threadPoolConfig.getTimeout();
            log.info("TTL from api config for api : {}, ttl : {}", (Object)((CommandHandlerConfig)apiConfiguration).getApi(), (Object)ttl);
        } else if (threadPoolConfig != null && poolVsTimeout.get(threadPoolConfig.getThreadPoolName()) != 0) {
            ttl = poolVsTimeout.get(threadPoolConfig.getThreadPoolName()).intValue();
            log.info("TTL from api config for api : {}, ttl : {}", (Object)((CommandHandlerConfig)apiConfiguration).getApi(), (Object)ttl);
        }
        return ttl;
    }

    private RevolverExecutionException getException(Throwable throwable) {
        return new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing command %s", RevolverCommandHelper.getName(this.request)), RevolverExceptionHelper.getLeafThrowable(throwable));
    }

    private ResponseType execute() throws Exception {
        ResilienceHttpContext resilienceHttpContext = this.getResilienceContext();
        CircuitBreaker circuitBreaker = this.getCircuitBreaker(resilienceHttpContext, this.request, this.handler.getServiceConfiguration(), this.handler.getApiConfiguration());
        Bulkhead bulkhead = this.getBulkHead(resilienceHttpContext, this.request, this.handler.getServiceConfiguration(), this.handler.getApiConfiguration());
        TimeLimiter timeLimiter = this.getTimeoutConfig(resilienceHttpContext, this.handler.getServiceConfiguration(), this.handler.getApiConfiguration());
        log.info("Time Limiter : " + timeLimiter);
        Supplier<Future> supplier = () -> resilienceHttpContext.getExecutor().submit(() -> {
            log.info("Executing the resilience request for api :" + ((RevolverRequest)this.request).getApi());
            return this.handler.execute(this.context, this.request);
        });
        Callable timeCallable = TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, supplier);
        Callable circuitCallable = CircuitBreaker.decorateCallable((CircuitBreaker)circuitBreaker, (Callable)timeCallable);
        Callable bulkHeadCallable = Bulkhead.decorateCallable((Bulkhead)bulkhead, (Callable)circuitCallable);
        return (ResponseType)((RevolverResponse)bulkHeadCallable.call());
    }

    private CircuitBreaker getCircuitBreaker(ResilienceHttpContext resilienceHttpContext, RequestType request, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigurationType apiConfiguration) {
        String threadPoolName = this.getThreadPoolName(request, apiConfiguration);
        CircuitBreaker circuitBreaker = resilienceHttpContext.getPoolVsCircuitBreaker().get(threadPoolName);
        if (circuitBreaker != null) {
            return circuitBreaker;
        }
        threadPoolName = ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getThreadPoolName();
        circuitBreaker = resilienceHttpContext.getPoolVsCircuitBreaker().get(threadPoolName);
        if (circuitBreaker == null) {
            log.error("No bulk head defined for service {}, api {}", (Object)((RevolverRequest)request).getService(), (Object)((RevolverRequest)request).getApi());
            circuitBreaker = resilienceHttpContext.getDefaultCircuitBreaker();
        }
        return circuitBreaker;
    }
}

