/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import com.collections.CollectionUtils;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.core.RevolverCommandHandler;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverCommandHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(RevolverCommandHandlerFactory.class);
    private static final Map<RevolverExecutorType, RevolverCommandHandler> FACTORY = Maps.newHashMap();

    public RevolverCommandHandlerFactory() {
        Reflections reflections = new Reflections("io.dropwizard.revolver.core", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(RevolverCommandHandler.class);
        for (Class subType : CollectionUtils.nullSafeSet((Set)subTypes)) {
            try {
                Object obj = subType.newInstance();
                if (!(obj instanceof RevolverCommandHandler)) continue;
                RevolverCommandHandler revolverCommandHandler = (RevolverCommandHandler)obj;
                FACTORY.putIfAbsent(revolverCommandHandler.getExecutorType(), revolverCommandHandler);
            }
            catch (InstantiationException e) {
                log.error("Error occurred while initializing the subtype : {} with exception {}", (Object)subType, (Object)e);
            }
            catch (IllegalAccessException e) {
                log.error("Error occurred while initializing the subtype : {} with exception {}", (Object)subType, (Object)e);
            }
        }
    }

    public static RevolverCommandHandler getHandler(RevolverExecutorType revolverExecutorType) {
        return FACTORY.get(revolverExecutorType);
    }
}

