/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import io.dropwizard.revolver.core.RevolverCommandHandler;
import io.dropwizard.revolver.core.RevolverCommandHandlerFactory;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import io.dropwizard.revolver.http.RevolverContext;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public abstract class RevolverCommand<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, RevolverServiceConfig, CommandHandlerConfigType extends CommandHandlerConfig> {
    private static final Logger log = LoggerFactory.getLogger(RevolverCommand.class);
    private final ContextType context;
    private final RuntimeConfig runtimeConfig;
    private final RevolverServiceConfig serviceConfiguration;
    private final CommandHandlerConfigType apiConfiguration;
    private ClientConfig clientConfiguration;

    public RevolverCommand(ContextType context, ClientConfig clientConfiguration, RuntimeConfig runtimeConfig, RevolverServiceConfig serviceConfiguration, CommandHandlerConfigType apiConfiguration) {
        if (context == null) {
            context = new RevolverHttpContext();
        }
        this.context = context;
        this.clientConfiguration = clientConfiguration;
        this.runtimeConfig = runtimeConfig;
        this.serviceConfiguration = serviceConfiguration;
        this.apiConfiguration = apiConfiguration;
    }

    public ResponseType execute(RequestType request) throws RevolverExecutionException, TimeoutException {
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = normalizedRequest.getTrace();
        RevolverCommandHelper.addContextInfo(RevolverCommandHelper.getName(request), traceInfo);
        try {
            RevolverExecutorType revolverExecutorType = this.getExecutionType(this.getServiceConfiguration(), this.getApiConfiguration());
            RevolverCommandHandler revolverCommandHandler = RevolverCommandHandlerFactory.getHandler(revolverExecutorType);
            RevolverResponse response = revolverCommandHandler.executeSync(this, (RevolverRequest)normalizedRequest);
            if (log.isDebugEnabled()) {
                log.debug("Command response: " + response);
            }
            return (ResponseType)response;
        }
        catch (Throwable t) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            log.error("Error occurred while executing revolver command for service : " + request.getService() + ", for api : " + request.getApi() + " with error : " + RevolverExceptionHelper.getLeafThrowable(t));
            if (rootCause == null) {
                rootCause = t;
            }
            if (rootCause instanceof TimeoutException) {
                throw (TimeoutException)rootCause;
            }
            throw new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, rootCause);
        }
    }

    private RevolverExecutorType getExecutionType(RevolverServiceConfig serviceConfiguration, CommandHandlerConfigType apiConfiguration) {
        RevolverExecutorType revolverExecutorType = null;
        if (apiConfiguration instanceof RevolverHttpApiConfig) {
            revolverExecutorType = ((RevolverHttpApiConfig)apiConfiguration).getRevolverExecutorType();
        }
        if (revolverExecutorType == null) {
            revolverExecutorType = ((RevolverHttpServiceConfig)serviceConfiguration).getRevolverExecutorType();
        }
        if (revolverExecutorType == null) {
            revolverExecutorType = RevolverExecutorType.RESILIENCE;
        }
        return revolverExecutorType;
    }

    public CompletableFuture<ResponseType> executeAsync(RequestType request) {
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = normalizedRequest.getTrace();
        RevolverCommandHelper.addContextInfo(RevolverCommandHelper.getName(request), traceInfo);
        RevolverExecutorType revolverExecutorType = this.getExecutionType(this.getServiceConfiguration(), this.getApiConfiguration());
        RevolverCommandHandler revolverCommandHandler = RevolverCommandHandlerFactory.getHandler(revolverExecutorType);
        return revolverCommandHandler.executeASync(this, (RevolverRequest)normalizedRequest);
    }

    public Observable<ResponseType> executeAsyncAsObservable(RequestType request) {
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = normalizedRequest.getTrace();
        RevolverCommandHelper.addContextInfo(RevolverCommandHelper.getName(request), traceInfo);
        RevolverExecutorType revolverExecutorType = this.getExecutionType(this.getServiceConfiguration(), this.getApiConfiguration());
        RevolverCommandHandler revolverCommandHandler = RevolverCommandHandlerFactory.getHandler(revolverExecutorType);
        return revolverCommandHandler.executeAsyncAsObservable(this, (RevolverRequest)normalizedRequest);
    }

    public boolean isFallbackEnabled() {
        return true;
    }

    public abstract ResponseType execute(ContextType var1, RequestType var2) throws Exception;

    public abstract ResponseType fallback(ContextType var1, RequestType var2);

    protected ClientConfig getClientConfiguration() {
        return this.clientConfiguration;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public RevolverServiceConfig getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public ContextType getContext() {
        return this.context;
    }

    public CommandHandlerConfigType getApiConfiguration() {
        return this.apiConfiguration;
    }
}

