/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import com.netflix.hystrix.HystrixCommand;
import io.dropwizard.revolver.core.HystrixCommandHelper;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import io.dropwizard.revolver.http.RevolverContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class HystrixCommandExecutor<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig>
extends HystrixCommand<ResponseType> {
    private final RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler;
    private final RequestType request;

    public HystrixCommandExecutor(RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler, RequestType request) {
        super(HystrixCommandHelper.setter(handler, request.getApi()));
        this.handler = handler;
        this.request = request;
    }

    protected ResponseType run() throws Exception {
        return (ResponseType)this.handler.execute(this.handler.getContext(), this.request);
    }

    public RevolverResponse executeSync() {
        return (RevolverResponse)this.execute();
    }

    public CompletableFuture executeASync() {
        Future responseFuture = this.queue();
        return CompletableFuture.supplyAsync(() -> {
            try {
                RevolverResponse revolverResponse = (RevolverResponse)responseFuture.get();
                return revolverResponse;
            }
            catch (Throwable t) {
                throw new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing command %s", RevolverCommandHelper.getName(this.request)), RevolverExceptionHelper.getLeafThrowable((Throwable)t));
            }
            finally {
                RevolverCommandHelper.removeContextInfo();
            }
        });
    }

    protected ResponseType getFallback() {
        return (ResponseType)this.handler.fallback(this.handler.getContext(), this.request);
    }
}

