/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.google.common.base.Strings;
import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.setup.Environment;

public class HystrixUtil {
    public static void initializeHystrix(Environment environment, HystrixCodaHaleMetricsPublisher metricsPublisher, RevolverConfig revolverConfig) {
        HystrixPlugins.reset();
        HystrixPlugins.getInstance().registerMetricsPublisher((HystrixMetricsPublisher)metricsPublisher);
        if (Strings.isNullOrEmpty((String)revolverConfig.getHystrixStreamPath())) {
            environment.getApplicationContext().addServlet(HystrixMetricsStreamServlet.class, "/hystrix.stream");
        } else {
            environment.getApplicationContext().addServlet(HystrixMetricsStreamServlet.class, revolverConfig.getHystrixStreamPath());
        }
    }
}

