/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import io.dropwizard.revolver.core.HystrixCommandExecutor;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverCommandHandler;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.http.RevolverContext;
import java.util.concurrent.CompletableFuture;
import rx.Observable;

public class HystrixCommandHandler<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig>
implements RevolverCommandHandler {
    public RevolverResponse executeSync(RevolverCommand revolverCommand, RevolverRequest revolverRequest) throws Exception {
        return new HystrixCommandExecutor(revolverCommand, revolverRequest).executeSync();
    }

    public CompletableFuture executeASync(RevolverCommand revolverCommand, RevolverRequest revolverRequest) {
        return new HystrixCommandExecutor(revolverCommand, revolverRequest).executeASync();
    }

    public Observable executeAsyncAsObservable(RevolverCommand revolverCommand, RevolverRequest revolverRequest) {
        return new HystrixCommandExecutor(revolverCommand, revolverRequest).toObservable();
    }

    public RevolverExecutorType getExecutorType() {
        return RevolverExecutorType.HYSTRIX;
    }
}

