/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.config.hystrix;

public class ThreadPoolConfig {
    private boolean semaphoreIsolated;
    private int concurrency = 10;
    private int maxRequestQueueSize = 100;
    private int dynamicRequestQueueSize = 50;
    private int timeout = 3000;
    private String threadPoolName;
    private int keepAliveTimeInMinutes = 5;
    private int initialConcurrency = 0;

    public static ThreadPoolConfigBuilder builder() {
        return new ThreadPoolConfigBuilder();
    }

    public boolean isSemaphoreIsolated() {
        return this.semaphoreIsolated;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public int getDynamicRequestQueueSize() {
        return this.dynamicRequestQueueSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public int getKeepAliveTimeInMinutes() {
        return this.keepAliveTimeInMinutes;
    }

    public int getInitialConcurrency() {
        return this.initialConcurrency;
    }

    public void setSemaphoreIsolated(boolean semaphoreIsolated) {
        this.semaphoreIsolated = semaphoreIsolated;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setMaxRequestQueueSize(int maxRequestQueueSize) {
        this.maxRequestQueueSize = maxRequestQueueSize;
    }

    public void setDynamicRequestQueueSize(int dynamicRequestQueueSize) {
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public void setKeepAliveTimeInMinutes(int keepAliveTimeInMinutes) {
        this.keepAliveTimeInMinutes = keepAliveTimeInMinutes;
    }

    public void setInitialConcurrency(int initialConcurrency) {
        this.initialConcurrency = initialConcurrency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolConfig)) {
            return false;
        }
        ThreadPoolConfig other = (ThreadPoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSemaphoreIsolated() != other.isSemaphoreIsolated()) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getMaxRequestQueueSize() != other.getMaxRequestQueueSize()) {
            return false;
        }
        if (this.getDynamicRequestQueueSize() != other.getDynamicRequestQueueSize()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$threadPoolName = this.getThreadPoolName();
        String other$threadPoolName = other.getThreadPoolName();
        if (this$threadPoolName == null ? other$threadPoolName != null : !this$threadPoolName.equals(other$threadPoolName)) {
            return false;
        }
        if (this.getKeepAliveTimeInMinutes() != other.getKeepAliveTimeInMinutes()) {
            return false;
        }
        return this.getInitialConcurrency() == other.getInitialConcurrency();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSemaphoreIsolated() ? 79 : 97);
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getMaxRequestQueueSize();
        result = result * 59 + this.getDynamicRequestQueueSize();
        result = result * 59 + this.getTimeout();
        String $threadPoolName = this.getThreadPoolName();
        result = result * 59 + ($threadPoolName == null ? 43 : $threadPoolName.hashCode());
        result = result * 59 + this.getKeepAliveTimeInMinutes();
        result = result * 59 + this.getInitialConcurrency();
        return result;
    }

    public String toString() {
        return "ThreadPoolConfig(semaphoreIsolated=" + this.isSemaphoreIsolated() + ", concurrency=" + this.getConcurrency() + ", maxRequestQueueSize=" + this.getMaxRequestQueueSize() + ", dynamicRequestQueueSize=" + this.getDynamicRequestQueueSize() + ", timeout=" + this.getTimeout() + ", threadPoolName=" + this.getThreadPoolName() + ", keepAliveTimeInMinutes=" + this.getKeepAliveTimeInMinutes() + ", initialConcurrency=" + this.getInitialConcurrency() + ")";
    }

    public ThreadPoolConfig(boolean semaphoreIsolated, int concurrency, int maxRequestQueueSize, int dynamicRequestQueueSize, int timeout, String threadPoolName, int keepAliveTimeInMinutes, int initialConcurrency) {
        this.semaphoreIsolated = semaphoreIsolated;
        this.concurrency = concurrency;
        this.maxRequestQueueSize = maxRequestQueueSize;
        this.dynamicRequestQueueSize = dynamicRequestQueueSize;
        this.timeout = timeout;
        this.threadPoolName = threadPoolName;
        this.keepAliveTimeInMinutes = keepAliveTimeInMinutes;
        this.initialConcurrency = initialConcurrency;
    }

    public ThreadPoolConfig() {
    }

    public static class ThreadPoolConfigBuilder {
        private boolean semaphoreIsolated;
        private int concurrency;
        private int maxRequestQueueSize;
        private int dynamicRequestQueueSize;
        private int timeout;
        private String threadPoolName;
        private int keepAliveTimeInMinutes;
        private int initialConcurrency;

        ThreadPoolConfigBuilder() {
        }

        public ThreadPoolConfigBuilder semaphoreIsolated(boolean semaphoreIsolated) {
            this.semaphoreIsolated = semaphoreIsolated;
            return this;
        }

        public ThreadPoolConfigBuilder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public ThreadPoolConfigBuilder maxRequestQueueSize(int maxRequestQueueSize) {
            this.maxRequestQueueSize = maxRequestQueueSize;
            return this;
        }

        public ThreadPoolConfigBuilder dynamicRequestQueueSize(int dynamicRequestQueueSize) {
            this.dynamicRequestQueueSize = dynamicRequestQueueSize;
            return this;
        }

        public ThreadPoolConfigBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ThreadPoolConfigBuilder threadPoolName(String threadPoolName) {
            this.threadPoolName = threadPoolName;
            return this;
        }

        public ThreadPoolConfigBuilder keepAliveTimeInMinutes(int keepAliveTimeInMinutes) {
            this.keepAliveTimeInMinutes = keepAliveTimeInMinutes;
            return this;
        }

        public ThreadPoolConfigBuilder initialConcurrency(int initialConcurrency) {
            this.initialConcurrency = initialConcurrency;
            return this;
        }

        public ThreadPoolConfig build() {
            return new ThreadPoolConfig(this.semaphoreIsolated, this.concurrency, this.maxRequestQueueSize, this.dynamicRequestQueueSize, this.timeout, this.threadPoolName, this.keepAliveTimeInMinutes, this.initialConcurrency);
        }

        public String toString() {
            return "ThreadPoolConfig.ThreadPoolConfigBuilder(semaphoreIsolated=" + this.semaphoreIsolated + ", concurrency=" + this.concurrency + ", maxRequestQueueSize=" + this.maxRequestQueueSize + ", dynamicRequestQueueSize=" + this.dynamicRequestQueueSize + ", timeout=" + this.timeout + ", threadPoolName=" + this.threadPoolName + ", keepAliveTimeInMinutes=" + this.keepAliveTimeInMinutes + ", initialConcurrency=" + this.initialConcurrency + ")";
        }
    }
}

