/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.dropwizard.revolver.config.CommandHandlerConfig;
import io.dropwizard.revolver.config.RevolverServiceConfig;
import io.dropwizard.revolver.config.RuntimeConfig;
import io.dropwizard.revolver.config.hystrix.CircuitBreakerConfig;
import io.dropwizard.revolver.config.hystrix.MetricsConfig;
import io.dropwizard.revolver.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.RevolverCommand;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class HystrixCommandHelper {
    public static HystrixCommand.Setter setter(RevolverCommand commandHandler, String api) {
        ThreadPoolConfig threadPoolConfig;
        RuntimeConfig runtimeConfig = commandHandler.getRuntimeConfig();
        Object serviceConfiguration = commandHandler.getServiceConfiguration();
        Object config = commandHandler.getApiConfiguration();
        CircuitBreakerConfig circuitBreakerConfig = null != runtimeConfig ? runtimeConfig.getCircuitBreaker() : (null != ((CommandHandlerConfig)config).getRuntime() && null != ((CommandHandlerConfig)config).getRuntime().getCircuitBreaker() ? ((CommandHandlerConfig)config).getRuntime().getCircuitBreaker() : (null != ((RevolverServiceConfig)serviceConfiguration).getRuntime() && null != ((RevolverServiceConfig)serviceConfiguration).getRuntime().getCircuitBreaker() ? ((RevolverServiceConfig)serviceConfiguration).getRuntime().getCircuitBreaker() : new CircuitBreakerConfig()));
        ThreadPoolConfig serviceThreadPoolConfig = null;
        if (null != ((RevolverServiceConfig)serviceConfiguration).getRuntime() && null != ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool()) {
            serviceThreadPoolConfig = ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool();
        }
        String keyName = "";
        MetricsConfig metricsConfig = null != runtimeConfig ? runtimeConfig.getMetrics() : new MetricsConfig();
        Map<Object, Object> threadPoolConfigMap = null != ((RevolverServiceConfig)serviceConfiguration).getThreadPoolGroupConfig() && null != ((RevolverServiceConfig)serviceConfiguration).getThreadPoolGroupConfig().getThreadPools() ? ((RevolverServiceConfig)serviceConfiguration).getThreadPoolGroupConfig().getThreadPools().stream().collect(Collectors.toMap(ThreadPoolConfig::getThreadPoolName, t -> t)) : Maps.newHashMap();
        if (null != ((CommandHandlerConfig)config).getRuntime() && null != ((CommandHandlerConfig)config).getRuntime().getThreadPool() && StringUtils.isNotEmpty((CharSequence)((CommandHandlerConfig)config).getRuntime().getThreadPool().getThreadPoolName()) && null != threadPoolConfigMap.get(((CommandHandlerConfig)config).getRuntime().getThreadPool().getThreadPoolName())) {
            threadPoolConfig = (ThreadPoolConfig)threadPoolConfigMap.get(((CommandHandlerConfig)config).getRuntime().getThreadPool().getThreadPoolName());
            keyName = threadPoolConfig.getThreadPoolName();
        } else if (((CommandHandlerConfig)config).isSharedPool() && null != serviceThreadPoolConfig) {
            threadPoolConfig = serviceThreadPoolConfig;
            if (StringUtils.isEmpty((CharSequence)keyName)) {
                keyName = Joiner.on((String)".").join((Object)((RevolverServiceConfig)commandHandler.getServiceConfiguration()).getService(), (Object)"shared", new Object[0]);
            }
        } else if (null != ((CommandHandlerConfig)config).getRuntime() && null != ((CommandHandlerConfig)config).getRuntime().getThreadPool()) {
            threadPoolConfig = ((CommandHandlerConfig)config).getRuntime().getThreadPool();
            keyName = Joiner.on((String)".").join((Object)((RevolverServiceConfig)commandHandler.getServiceConfiguration()).getService(), (Object)api, new Object[0]);
        } else if (null != serviceThreadPoolConfig) {
            threadPoolConfig = ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool();
            if (StringUtils.isEmpty((CharSequence)keyName)) {
                keyName = Joiner.on((String)".").join((Object)((RevolverServiceConfig)commandHandler.getServiceConfiguration()).getService(), (Object)api, new Object[0]);
            }
        } else if (null != runtimeConfig) {
            threadPoolConfig = runtimeConfig.getThreadPool();
            keyName = Joiner.on((String)".").join((Object)((RevolverServiceConfig)commandHandler.getServiceConfiguration()).getService(), (Object)api, new Object[0]);
        } else {
            threadPoolConfig = new ThreadPoolConfig();
            keyName = Joiner.on((String)".").join((Object)((RevolverServiceConfig)commandHandler.getServiceConfiguration()).getService(), (Object)api, new Object[0]);
        }
        if (null != ((CommandHandlerConfig)config).getRuntime() && null != ((CommandHandlerConfig)config).getRuntime().getThreadPool()) {
            threadPoolConfig.setTimeout(((CommandHandlerConfig)config).getRuntime().getThreadPool().getTimeout());
        }
        int concurrency = threadPoolConfig.getConcurrency();
        int coreSize = (int)Math.ceil((double)concurrency * metricsConfig.getCorePoolSizeReductionParam());
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)((RevolverServiceConfig)serviceConfiguration).getService())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(threadPoolConfig.isSemaphoreIsolated() ? HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE : HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionIsolationSemaphoreMaxConcurrentRequests(threadPoolConfig.getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(threadPoolConfig.getConcurrency()).withFallbackEnabled(commandHandler.isFallbackEnabled()).withCircuitBreakerErrorThresholdPercentage(circuitBreakerConfig.getErrorThresholdPercentage()).withCircuitBreakerRequestVolumeThreshold(circuitBreakerConfig.getNumAcceptableFailuresInTimeWindow()).withCircuitBreakerSleepWindowInMilliseconds(circuitBreakerConfig.getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(threadPoolConfig.getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(metricsConfig.getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(metricsConfig.getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(metricsConfig.getPercentileTimeInMillis())).andCommandKey(HystrixCommandKey.Factory.asKey((String)Joiner.on((String)".").join((Object)((RevolverServiceConfig)commandHandler.getServiceConfiguration()).getService(), (Object)api, new Object[0]))).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)keyName)).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(coreSize).withMaxQueueSize(threadPoolConfig.getMaxRequestQueueSize()).withMaximumSize(concurrency).withKeepAliveTimeMinutes(threadPoolConfig.getKeepAliveTimeInMinutes()).withQueueSizeRejectionThreshold(threadPoolConfig.getDynamicRequestQueueSize()).withAllowMaximumSizeToDivergeFromCoreSize(true).withMetricsRollingStatisticalWindowBuckets(metricsConfig.getStatsBucketSize()).withMetricsRollingStatisticalWindowInMilliseconds(metricsConfig.getStatsTimeInMillis()));
    }
}

