/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.config.hystrix;

public class CircuitBreakerConfig {
    private int numAcceptableFailuresInTimeWindow = 20;
    private int waitTimeBeforeRetry = 5000;
    private int errorThresholdPercentage = 50;

    public static CircuitBreakerConfigBuilder builder() {
        return new CircuitBreakerConfigBuilder();
    }

    public int getNumAcceptableFailuresInTimeWindow() {
        return this.numAcceptableFailuresInTimeWindow;
    }

    public int getWaitTimeBeforeRetry() {
        return this.waitTimeBeforeRetry;
    }

    public int getErrorThresholdPercentage() {
        return this.errorThresholdPercentage;
    }

    public void setNumAcceptableFailuresInTimeWindow(int numAcceptableFailuresInTimeWindow) {
        this.numAcceptableFailuresInTimeWindow = numAcceptableFailuresInTimeWindow;
    }

    public void setWaitTimeBeforeRetry(int waitTimeBeforeRetry) {
        this.waitTimeBeforeRetry = waitTimeBeforeRetry;
    }

    public void setErrorThresholdPercentage(int errorThresholdPercentage) {
        this.errorThresholdPercentage = errorThresholdPercentage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CircuitBreakerConfig)) {
            return false;
        }
        CircuitBreakerConfig other = (CircuitBreakerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumAcceptableFailuresInTimeWindow() != other.getNumAcceptableFailuresInTimeWindow()) {
            return false;
        }
        if (this.getWaitTimeBeforeRetry() != other.getWaitTimeBeforeRetry()) {
            return false;
        }
        return this.getErrorThresholdPercentage() == other.getErrorThresholdPercentage();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CircuitBreakerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumAcceptableFailuresInTimeWindow();
        result = result * 59 + this.getWaitTimeBeforeRetry();
        result = result * 59 + this.getErrorThresholdPercentage();
        return result;
    }

    public String toString() {
        return "CircuitBreakerConfig(numAcceptableFailuresInTimeWindow=" + this.getNumAcceptableFailuresInTimeWindow() + ", waitTimeBeforeRetry=" + this.getWaitTimeBeforeRetry() + ", errorThresholdPercentage=" + this.getErrorThresholdPercentage() + ")";
    }

    public CircuitBreakerConfig(int numAcceptableFailuresInTimeWindow, int waitTimeBeforeRetry, int errorThresholdPercentage) {
        this.numAcceptableFailuresInTimeWindow = numAcceptableFailuresInTimeWindow;
        this.waitTimeBeforeRetry = waitTimeBeforeRetry;
        this.errorThresholdPercentage = errorThresholdPercentage;
    }

    public CircuitBreakerConfig() {
    }

    public static class CircuitBreakerConfigBuilder {
        private int numAcceptableFailuresInTimeWindow;
        private int waitTimeBeforeRetry;
        private int errorThresholdPercentage;

        CircuitBreakerConfigBuilder() {
        }

        public CircuitBreakerConfigBuilder numAcceptableFailuresInTimeWindow(int numAcceptableFailuresInTimeWindow) {
            this.numAcceptableFailuresInTimeWindow = numAcceptableFailuresInTimeWindow;
            return this;
        }

        public CircuitBreakerConfigBuilder waitTimeBeforeRetry(int waitTimeBeforeRetry) {
            this.waitTimeBeforeRetry = waitTimeBeforeRetry;
            return this;
        }

        public CircuitBreakerConfigBuilder errorThresholdPercentage(int errorThresholdPercentage) {
            this.errorThresholdPercentage = errorThresholdPercentage;
            return this;
        }

        public CircuitBreakerConfig build() {
            return new CircuitBreakerConfig(this.numAcceptableFailuresInTimeWindow, this.waitTimeBeforeRetry, this.errorThresholdPercentage);
        }

        public String toString() {
            return "CircuitBreakerConfig.CircuitBreakerConfigBuilder(numAcceptableFailuresInTimeWindow=" + this.numAcceptableFailuresInTimeWindow + ", waitTimeBeforeRetry=" + this.waitTimeBeforeRetry + ", errorThresholdPercentage=" + this.errorThresholdPercentage + ")";
        }
    }
}

