/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.config.resilience;

public class ThreadPoolConfig {
    private int corePoolSize = 50;
    private int maxPoolSize = 1024;
    private int queueSize = 100;
    private int keepAliveTimeInSeconds = 300;

    public static ThreadPoolConfigBuilder builder() {
        return new ThreadPoolConfigBuilder();
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getKeepAliveTimeInSeconds() {
        return this.keepAliveTimeInSeconds;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setKeepAliveTimeInSeconds(int keepAliveTimeInSeconds) {
        this.keepAliveTimeInSeconds = keepAliveTimeInSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolConfig)) {
            return false;
        }
        ThreadPoolConfig other = (ThreadPoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        return this.getKeepAliveTimeInSeconds() == other.getKeepAliveTimeInSeconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaxPoolSize();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + this.getKeepAliveTimeInSeconds();
        return result;
    }

    public String toString() {
        return "ThreadPoolConfig(corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", queueSize=" + this.getQueueSize() + ", keepAliveTimeInSeconds=" + this.getKeepAliveTimeInSeconds() + ")";
    }

    public ThreadPoolConfig() {
    }

    public ThreadPoolConfig(int corePoolSize, int maxPoolSize, int queueSize, int keepAliveTimeInSeconds) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.queueSize = queueSize;
        this.keepAliveTimeInSeconds = keepAliveTimeInSeconds;
    }

    public static class ThreadPoolConfigBuilder {
        private int corePoolSize;
        private int maxPoolSize;
        private int queueSize;
        private int keepAliveTimeInSeconds;

        ThreadPoolConfigBuilder() {
        }

        public ThreadPoolConfigBuilder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public ThreadPoolConfigBuilder maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public ThreadPoolConfigBuilder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public ThreadPoolConfigBuilder keepAliveTimeInSeconds(int keepAliveTimeInSeconds) {
            this.keepAliveTimeInSeconds = keepAliveTimeInSeconds;
            return this;
        }

        public ThreadPoolConfig build() {
            return new ThreadPoolConfig(this.corePoolSize, this.maxPoolSize, this.queueSize, this.keepAliveTimeInSeconds);
        }

        public String toString() {
            return "ThreadPoolConfig.ThreadPoolConfigBuilder(corePoolSize=" + this.corePoolSize + ", maxPoolSize=" + this.maxPoolSize + ", queueSize=" + this.queueSize + ", keepAliveTimeInSeconds=" + this.keepAliveTimeInSeconds + ")";
        }
    }
}

